/*
 * Decompiled with CFR 0.152.
 */
package ACN_1_31_Package;

import ACN_1_17_Package.ACNDataAbstract;
import ACN_1_17_Package.ACNData_Interface;
import ACN_1_17_Package.ACNLayerAbstract;
import ACN_1_17_Package.ACNLayer_Interface;
import ACN_1_17_Package.ACN_ByteData;
import ACN_1_17_Package.ACN_PDU;

public class ACN_1_31_DMPLayer
extends ACNLayerAbstract {
    public static int PDUVECTORSIZE = 1;
    public static int PDUHEADERLENGTHSIZE = 0;
    public static int PDUHEADERSIZE = 1;
    public static ACN_1_31_DMPLayer m_SelfReference = new ACN_1_31_DMPLayer();

    public static ACN_1_31_DMPLayer getInstance() {
        return m_SelfReference;
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public int getACN_Vector_Size() {
        return PDUVECTORSIZE;
    }

    @Override
    public int getACN_PDU_HeaderSize() {
        return PDUHEADERSIZE;
    }

    @Override
    public int getACN_PDU_HeaderLengthBytesCount() {
        return PDUHEADERLENGTHSIZE;
    }

    @Override
    public ACNData_Interface createACNData(ACN_PDU p_ACN_PDU) {
        if (p_ACN_PDU == null) {
            return null;
        }
        ACN_1_31_DMP o_ACNData_Interface = null;
        ACN_PDU.PDU_Vector o_PDU_Vector = p_ACN_PDU.getPDU_Vector();
        if (o_PDU_Vector == null) {
            return o_ACNData_Interface;
        }
        switch (o_PDU_Vector.getVectorValue()) {
            case 2: {
                o_ACNData_Interface = new ACN_1_31_DMP(p_ACN_PDU.getParentACNData(), p_ACN_PDU);
                break;
            }
            default: {
                o_ACNData_Interface = null;
            }
        }
        return o_ACNData_Interface;
    }

    public static class ACN_1_31_DMP
    extends ACNDataAbstract {
        protected ACN_ByteData m_ACN_Data_Address;
        protected ACN_ByteData m_ACN_Data_Increment;
        protected ACN_ByteData m_ACN_ByteData_Count;
        protected ACN_ByteData m_ACN_ByteData_Values;

        public ACN_1_31_DMP() {
            super(null, ACN_1_31_DMPLayer.getInstance(), null);
            this.initMembers();
            this.initMembersFurther();
        }

        public ACN_1_31_DMP(ACNData_Interface p_ParentACNData, ACN_PDU p_ACN_PDU) {
            super(p_ParentACNData, ACN_1_31_DMPLayer.getInstance(), p_ACN_PDU);
            this.initMembers();
            this.initMembersFurther();
        }

        private void initMembers() {
            this.m_ACN_Data_Address = ACN_ByteData.poolGet(2);
            this.addDataACN_Member(this.m_ACN_Data_Address);
            this.m_ACN_Data_Increment = ACN_ByteData.poolGet(2);
            this.addDataACN_Member(this.m_ACN_Data_Increment);
            this.m_ACN_ByteData_Count = ACN_ByteData.poolGet(2);
            this.addDataACN_Member(this.m_ACN_ByteData_Count);
            this.m_ACN_ByteData_Values = ACN_ByteData.poolGet(1);
            this.addDataACN_Member(this.m_ACN_ByteData_Values);
        }

        private void initMembersFurther() {
            if (this.m_ACN_PDU != null) {
                this.m_ACN_PDU.getPDU_Vector().setByte(0, (byte)2);
                this.m_ACN_PDU.getPDU_Header().getHeaderContent().setByte(0, (byte)-95);
            }
            this.m_ACN_Data_Address.setInt(0);
            this.m_ACN_Data_Increment.setInt(1);
            this.m_ACN_ByteData_Count.setInt(1);
        }

        @Override
        public void close() {
            super.close();
        }

        public void setAddressDataType(int p_AddressType) {
            this.m_ACN_PDU.getPDU_Header().getHeaderContent().setInt(p_AddressType);
        }

        public int getAddressDataType() {
            return this.m_ACN_PDU.getPDU_Header().getHeaderContent().getInt();
        }

        public void setFirstPropertyAddress(int p_FirstAddress) {
            this.m_ACN_Data_Address.setInt(p_FirstAddress);
        }

        public int getFirstPropertyAddress() {
            return this.m_ACN_Data_Address.getInt();
        }

        public void setAddressIncrement(int p_AddressIncrement) {
            this.m_ACN_Data_Increment.setInt(p_AddressIncrement);
        }

        public int getAddressIncrement() {
            return this.m_ACN_Data_Increment.getInt();
        }

        public void setPropertyValueCount(int p_AddressIncrement) {
            this.m_ACN_ByteData_Count.setInt(p_AddressIncrement);
        }

        public int getPropertyValueCount() {
            return this.m_ACN_ByteData_Count.getInt();
        }

        public int getStartCode() {
            byte byteStartCode = this.m_ACN_ByteData_Values.getByte(0);
            return byteStartCode & 0xFF;
        }

        public void setStartCode(int p_StartCode) {
            byte byteStartCode = (byte)(p_StartCode & 0xFF);
            this.m_ACN_ByteData_Values.setByte(0, byteStartCode);
        }

        public int[] getPropertyValues() {
            return this.m_ACN_ByteData_Values.getIntegerArray(1, this.m_ACN_ByteData_Values.getSize());
        }

        public void setPropertyValues(int[] p_Values) {
            int intByteCount = p_Values == null ? 1 : (p_Values.length > 512 ? 512 : p_Values.length);
            this.setPropertyValueCount(intByteCount + 1);
            this.m_ACN_ByteData_Values.setIntegerArray(p_Values, 0, 1, intByteCount);
        }

        public int[] getDMXData(int[] p_DMXDataInt, int p_Length) {
            int intDataLength;
            int intBytesToCopy;
            int intDataStartByte;
            if (p_DMXDataInt == null) {
                p_DMXDataInt = new int[512];
            }
            if ((intDataStartByte = 1) + (intBytesToCopy = p_DMXDataInt.length < 512 ? p_DMXDataInt.length : 512) > (intDataLength = this.m_ACN_ByteData_Values.getSize())) {
                intBytesToCopy = intDataLength - intDataStartByte;
            }
            for (int intByte = 0; intByte < intBytesToCopy; ++intByte) {
                try {
                    p_DMXDataInt[intByte] = Byte.toUnsignedInt(this.m_ACN_ByteData_Values.getByte(intDataStartByte + intByte));
                    continue;
                }
                catch (Exception e) {
                    return p_DMXDataInt;
                }
            }
            return p_DMXDataInt;
        }

        @Override
        public ACNLayer_Interface createNextACNLayer(ACN_PDU.PDU_Vector p_PDU_Vector, ACN_PDU.PDU_Header p_PDU_Header) {
            ACNLayer_Interface o_ACNLayer_Interface;
            int intVectorValue = p_PDU_Vector.getVectorValue();
            switch (intVectorValue) {
                case 2: {
                    o_ACNLayer_Interface = null;
                    break;
                }
                default: {
                    o_ACNLayer_Interface = null;
                }
            }
            return o_ACNLayer_Interface;
        }

        @Override
        public void eventDataMemberReceived(ACNData_Interface p_ACNData_Interface, ACN_ByteData p_ACN_ByteData) {
            if (p_ACN_ByteData == this.m_ACN_ByteData_Count) {
                int intCount = this.m_ACN_ByteData_Count.getInt();
                this.m_ACN_ByteData_Values.setSize(intCount);
            }
        }

        @Override
        public void eventDataMemberFilled(ACNData_Interface p_ACNData_Interface, ACN_ByteData p_ACN_ByteData) {
            if (p_ACN_ByteData == this.m_ACN_ByteData_Count) {
                boolean bl = false;
            }
        }

        @Override
        public void eventDataMemberChanged(ACNData_Interface p_ACNData_Interface, ACN_ByteData p_ACN_ByteData) {
            if (p_ACN_ByteData == this.m_ACN_ByteData_Count) {
                int intCount = this.m_ACN_ByteData_Count.getInt();
                this.m_ACN_ByteData_Values.setSize(intCount);
            }
        }

        @Override
        public void eventDataReceived(ACNData_Interface p_ACNData_Interface) {
        }

        @Override
        public void eventDataFilled(ACNData_Interface p_ACNData_Interface) {
        }
    }
}

