/*
 * Decompiled with CFR 0.152.
 */
package ACN_1_17_Package;

import ACN_1_17_Package.ACNDataPackage;
import ACN_1_17_Package.ACN_RootLayer;
import ACN_1_31_Package.ACN_1_31_FrameLayer;
import ACN_1_31_Package.ProtocolConfiguration_ACN_1_31;
import NetworkTools.UDP_Transport_Multicast;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;

public class ACNReceiver
implements UDP_Transport_Multicast.UDPTransportListener {
    protected UDP_Transport_Multicast m_UDP_Transport_Multicast;
    protected ArrayList<ACNDataPackage> m_DataPackages;
    protected ProtocolConfiguration_ACN_1_31 m_ProtocolConfiguration_ACN_1_31;
    protected String m_UsedProtocol;
    protected boolean m_IsActive;
    protected final Object m_SyncUDPTransport = new Object();
    protected final Object m_SyncPackages = new Object();

    public ACNReceiver(ProtocolConfiguration_ACN_1_31 p_ProtocolConfiguration_ACN_1_31) {
        this.initMembers();
        this.m_ProtocolConfiguration_ACN_1_31 = p_ProtocolConfiguration_ACN_1_31;
    }

    private void initMembers() {
        this.m_UDP_Transport_Multicast = null;
        this.m_DataPackages = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList<ACNDataPackage> o_DataPackages;
        this.setUDP_Transport(null);
        this.m_IsActive = false;
        Object object = this.m_SyncPackages;
        synchronized (object) {
            if (this.m_DataPackages == null) {
                return;
            }
            if (this.m_DataPackages.size() <= 0) {
                return;
            }
            o_DataPackages = new ArrayList<ACNDataPackage>(this.m_DataPackages.size());
            o_DataPackages.addAll(this.m_DataPackages);
            this.m_DataPackages.clear();
        }
        for (int intPackage = o_DataPackages.size() - 1; intPackage >= 0; --intPackage) {
            ACNDataPackage o_DataPackage = (ACNDataPackage)o_DataPackages.get(intPackage);
            o_DataPackages.remove(o_DataPackage);
            o_DataPackage.close();
        }
        o_DataPackages.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUDP_Transport(UDP_Transport_Multicast p_UDP_Transport_Multicast) {
        UDP_Transport_Multicast o_UDP_Transport;
        Object object = this.m_SyncUDPTransport;
        synchronized (object) {
            o_UDP_Transport = this.m_UDP_Transport_Multicast;
        }
        if (o_UDP_Transport != null) {
            o_UDP_Transport.removeUDPTransportListener((UDP_Transport_Multicast.UDPTransportListener)this);
        }
        object = this.m_SyncUDPTransport;
        synchronized (object) {
            o_UDP_Transport = this.m_UDP_Transport_Multicast = p_UDP_Transport_Multicast;
        }
        if (o_UDP_Transport != null) {
            o_UDP_Transport.addUDPTransportListener((UDP_Transport_Multicast.UDPTransportListener)this);
        }
    }

    public void setActive(boolean p_Active) {
        this.m_IsActive = p_Active;
    }

    public boolean isActive() {
        return this.m_IsActive;
    }

    public void changeProtocol(String p_Protocol) {
        this.m_UsedProtocol = p_Protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int eventDataReceived(DatagramPacket p_DatagramPacket) {
        ACNDataPackage o_DataPackage;
        ArrayList<ACNDataPackage> o_DataPackages;
        if (!this.m_IsActive) {
            return 0;
        }
        int intOffset = 0;
        Object object = this.m_SyncUDPTransport;
        synchronized (object) {
            while (intOffset < p_DatagramPacket.getLength()) {
                intOffset = this.eventDataReceived(p_DatagramPacket.getData(), intOffset, p_DatagramPacket.getLength());
            }
        }
        Object object2 = this.m_SyncPackages;
        synchronized (object2) {
            if (this.m_DataPackages == null) {
                return intOffset;
            }
            if (this.m_DataPackages.size() <= 0) {
                return intOffset;
            }
            o_DataPackages = new ArrayList<ACNDataPackage>(this.m_DataPackages.size());
            o_DataPackages.addAll(this.m_DataPackages);
        }
        for (int intDataPackage = 0; intDataPackage < o_DataPackages.size() && (o_DataPackage = (ACNDataPackage)o_DataPackages.get(intDataPackage)).isReceived(); ++intDataPackage) {
            Object object3 = this.m_SyncPackages;
            synchronized (object3) {
                this.m_DataPackages.remove(o_DataPackage);
            }
            this.computeDataPackage(o_DataPackage, p_DatagramPacket.getAddress());
        }
        return intOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int eventDataReceived(byte[] p_Data, int p_Offset, int p_Length) {
        int intNewOffset = p_Offset;
        ACNDataPackage o_DataPackage = null;
        Object object = this.m_SyncPackages;
        synchronized (object) {
            if (this.m_DataPackages.size() > 0 && (o_DataPackage = this.m_DataPackages.get(this.m_DataPackages.size() - 1)).isReceived()) {
                o_DataPackage = null;
            }
            if (o_DataPackage == null) {
                o_DataPackage = new ACNDataPackage();
                this.m_DataPackages.add(o_DataPackage);
            }
        }
        intNewOffset = o_DataPackage.eventDataReceived(p_Data, intNewOffset, p_Length);
        return intNewOffset;
    }

    public void computeDataPackage(ACNDataPackage p_DataPackage, InetAddress p_RemoteInetAddress) {
        for (int intRoot = 0; intRoot < p_DataPackage.getACNRootCount(); ++intRoot) {
            ACN_RootLayer.ACN_Root o_ACN_Root = p_DataPackage.getACN_Root(intRoot);
            for (int intRootData = 0; intRootData < o_ACN_Root.getACNDataObjectCount(); ++intRootData) {
                if (!(o_ACN_Root.getACNDataObject(intRootData) instanceof ACN_1_31_FrameLayer.ACN_1_31_Frame)) continue;
                ACN_1_31_FrameLayer.ACN_1_31_Frame o_ACN_1_31_Frame = (ACN_1_31_FrameLayer.ACN_1_31_Frame)o_ACN_Root.getACNDataObject(intRootData);
                this.computeACN_1_31(o_ACN_1_31_Frame, p_RemoteInetAddress);
            }
        }
    }

    public void computeACN_1_31(ACN_1_31_FrameLayer.ACN_1_31_Frame p_ACN_1_31_Frame, InetAddress p_RemoteInetAddress) {
        if (this.m_ProtocolConfiguration_ACN_1_31 == null) {
            return;
        }
        if (p_ACN_1_31_Frame == null) {
            return;
        }
        this.m_ProtocolConfiguration_ACN_1_31.eventReceivedACN_1_31_Frame(p_ACN_1_31_Frame, p_RemoteInetAddress);
        p_ACN_1_31_Frame.close();
    }

    public void eventDataReceived(UDP_Transport_Multicast p_UDP_Transport, DatagramPacket p_DatagramPacket, InetSocketAddress p_ReceiverInetSocketAddress) {
        if (!this.m_IsActive) {
            return;
        }
        this.eventDataReceived(p_DatagramPacket);
    }

    public void eventClosed(UDP_Transport_Multicast p_UDP_Transport) {
        if (this.m_UDP_Transport_Multicast == p_UDP_Transport) {
            this.setUDP_Transport(null);
        }
    }

    public void eventBound(UDP_Transport_Multicast p_UDP_Transport) {
    }

    public void eventError(UDP_Transport_Multicast p_UDP_Transport, Exception p_Exception) {
    }

    public static interface ACNReceiverInterface {
        public void eventValuesReceived(int var1, int[] var2);

        public int getDMXUniverseNumber();
    }
}

