/*
 * Decompiled with CFR 0.152.
 */
package LiveShowControls;

import JarLoader.JarClassLoader;
import JarLoader.JarResources;
import LiveShowControlModels.ControlBlockModel;
import LiveShowControlModels.ControlLabelModel;
import LiveShowControlObjects.ControlObject;
import SwingComponents.MouseAdapter_Delayed;
import ToolsGraphics.ImagesTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class JControlKnob
extends ControlObject {
    public static final String PROP_TRACKINSETS = "trackInsets";
    public static final String PROP_TRACKSLOTWIDTH = "trackSlotWidth";
    public static final String PROP_TRACKSLOTVISIBLE = "trackSlotVisible";
    public static final String PROP_ADJUSTERCOLOR = "adjusterColor";
    public static final String PROP_ADJUSTERIMAGE = "adjusterImage";
    public static final String PROP_KNOBMINANGLE = "knobMinAngle";
    public static final String PROP_KNOBMAXANGLE = "knobMaxAngle";
    protected KnobTrack m_Track;
    protected ControlObject.ControlDimension m_ControlDimension;
    private Rectangle m_ThisRectangle;
    private Insets m_TrackInsets;

    public JControlKnob() {
        this.initMembers();
        this.initComponents();
        this.calculateInnerItems();
    }

    private void initMembers() {
        this.setName("JControlKnob");
        this.m_ControlDimension = super.createNewControlDimension();
        this.m_ControlDimension.setDimensionName("Knob");
        this.m_ControlDimension.setOrientation(1);
        this.m_ControlDimension.setTicksAlignment(0);
        this.m_ControlDimension.setLabelsAlignment(0);
        this.m_ControlDimension.setBlocksAlignment(0);
        this.m_ControlDimension.setLabelsSize(new Dimension(15, 15));
        this.m_ControlDimension.setLabelsMirrored(false);
        this.setTicksMajorLength(7);
        this.setTicksMinorLength(3);
        this.setLabelsInsets(new Insets(0, 0, 0, 0));
        this.setTicksInsets(new Insets(12, 12, 12, 12));
        this.m_Track = new KnobTrack(this);
        this.setTrackInsets(20, 20, 20, 20);
        this.m_ControlDimension.setValue(this.m_ControlDimension.getValueMinimum(), 0.0, 0);
        this.setPreferredSize(new Dimension(50, 50));
    }

    private Object readResolve() {
        this.m_ControlDimension = this.getControlDimension(0);
        this.m_ControlDimension.setValue(this.m_ControlDimension.getValueMinimum(), 0.0, 0);
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
        super.writeExternal(p_ObjectOutput);
        this.m_ControlDimension.writeExternal(p_ObjectOutput);
        this.m_Track.writeExternal(p_ObjectOutput);
    }

    @Override
    public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
        super.readExternal(p_ObjectInput);
        this.m_ControlDimension.readExternal(p_ObjectInput);
        this.m_Track.readExternal(p_ObjectInput);
        this.calculateInnerItems();
    }

    private void initComponents() {
        this.add(this.m_Track, this.m_Track.getConstraints(), 0);
        this.setVisible(true);
    }

    @Override
    public void setToolTipText(String p_Name) {
        super.setToolTipText(p_Name);
        if (this.m_Track == null) {
            return;
        }
        this.m_Track.setToolTipText(p_Name);
        this.m_Track.getAdjuster().setToolTipText(p_Name);
    }

    @Override
    public void setForeground(Color p_Color) {
        this.m_Track.setForeground(p_Color);
        super.setForeground(p_Color);
    }

    public ControlObject.ControlDimension getControlDimension() {
        return this.m_ControlDimension;
    }

    @Override
    public double[] getValuesFromInnerComponentPosition(JComponent p_Component, int p_X, int p_Y) {
        return this.getValuesFromTrackPosition(p_X - this.m_Track.getX() + p_Component.getX(), p_Y - this.m_Track.getY() + p_Component.getY());
    }

    @Override
    public double[] getValuesFromComponentPosition(int p_X, int p_Y) {
        return this.getValuesFromTrackPosition(p_X - this.m_Track.getX(), p_Y - this.m_Track.getY());
    }

    public double[] getValuesFromTrackPosition(int p_X, int p_Y) {
        double doubleAngle = this.m_Track.getAdjuster().calculateAngle(p_X, p_Y);
        double doubleValue = !this.getInverted() ? this.m_ControlDimension.getValueMinimum() + (doubleAngle - this.m_Track.getAdjuster().getKnobMinAngle()) / (this.m_Track.getAdjuster().getKnobMaxAngle() - this.m_Track.getAdjuster().getKnobMinAngle()) * (this.m_ControlDimension.getValueMaximum() - this.m_ControlDimension.getValueMinimum()) : this.m_ControlDimension.getValueMinimum() + (this.m_Track.getAdjuster().getKnobMaxAngle() - doubleAngle) / (this.m_Track.getAdjuster().getKnobMaxAngle() - this.m_Track.getAdjuster().getKnobMinAngle()) * (this.m_ControlDimension.getValueMaximum() - this.m_ControlDimension.getValueMinimum());
        double[] doubleResults = new double[1];
        if (this.m_ControlDimension.getOrientation() == 1) {
            // empty if block
        }
        doubleResults[0] = doubleValue;
        return doubleResults;
    }

    @Override
    public void setJarResources(JarResources p_JarResources) {
        JarResources oldValue = this.m_Resources;
        this.m_Resources = p_JarResources;
        if (this.m_Resources != null) {
            byte[] o_Bytes = this.m_Resources.getResource("LiveShowControls/ControlKnobAdjusterImage");
            Image o_Image = null;
            if (o_Bytes != null) {
                try {
                    o_Image = Toolkit.getDefaultToolkit().createImage(o_Bytes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setAdjusterImage(o_Image);
            o_Bytes = this.m_Resources.getResource("LiveShowControls/ControlKnobBackground");
            o_Image = null;
            if (o_Bytes != null) {
                try {
                    o_Image = Toolkit.getDefaultToolkit().createImage(o_Bytes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setBackgroundImage(o_Image);
            JarClassLoader o_JarClassLoader = this.m_Resources.getJarClassLoader();
            if (o_JarClassLoader != null) {
                try {
                    Class o_Class = o_JarClassLoader.loadClass("LiveShowControls.Colors");
                    Field o_Field = o_Class.getDeclaredField("Control_Foreground");
                    Color o_Color = (Color)o_Field.get(o_Class);
                    this.setForeground(o_Color);
                    o_Field = o_Class.getDeclaredField("Control_Background");
                    o_Color = (Color)o_Field.get(o_Class);
                    this.setBackground(o_Color);
                }
                catch (Exception e) {
                    e.getMessage();
                }
            }
        } else {
            this.setAdjusterImage(null);
            this.setBackgroundImage(null);
        }
        this.firePropertyChange("jarResources", oldValue, this.m_Resources);
        this.revalidate();
        this.repaint();
    }

    public KnobTrack getTrack() {
        return this.m_Track;
    }

    public Insets getTrackInsets() {
        return this.m_Track.getTrackInsets();
    }

    public void setTrackInsets(Insets p_Insets) {
        this.m_Track.setTrackInsets(p_Insets);
    }

    public void setTrackInsets(int p_Top, int p_Left, int p_Bottom, int p_Right) {
        this.m_Track.setTrackInsets(p_Top, p_Left, p_Bottom, p_Right);
    }

    @Override
    public void calculateDisplayItem(ControlObject.ControlDisplayItem p_ControlDisplayItem) {
    }

    public double getKnobMinAngle() {
        return this.m_Track.getAdjuster().getKnobMinAngle();
    }

    public void setKnobMinAngle(double p_AngleRadians) {
        this.m_Track.getAdjuster().setKnobMinAngle(p_AngleRadians);
    }

    public void setKnobMinAngleDegree(double p_AngleRadians) {
        this.m_Track.getAdjuster().setKnobMinAngleDegree(p_AngleRadians);
    }

    public double getKnobMaxAngle() {
        return this.m_Track.getAdjuster().getKnobMaxAngle();
    }

    public void setKnobMaxAngle(double p_AngleRadians) {
        this.m_Track.getAdjuster().setKnobMaxAngle(p_AngleRadians);
    }

    public void setKnobMaxAngleDegree(double p_AngleRadians) {
        this.m_Track.getAdjuster().setKnobMaxAngleDegree(p_AngleRadians);
    }

    public Image getAdjusterImage() {
        return this.m_Track.getAdjuster().getAdjusterImage();
    }

    public void setAdjusterImage(Image p_AdjusterImage) {
        this.m_Track.getAdjuster().setAdjusterImage(p_AdjusterImage);
    }

    public Color getAdjusterColor() {
        return this.m_Track.getAdjuster().getAdjusterColor();
    }

    public void setAdjusterColor(Color p_AdjusterColor) {
        this.m_Track.getAdjuster().setAdjusterColor(p_AdjusterColor);
    }

    @Override
    public void calculateInnerItems() {
        if (this.m_Track == null) {
            return;
        }
        this.m_ThisRectangle = this.getBounds(this.m_ThisRectangle);
        this.m_TrackInsets = this.m_Track.getTrackInsets();
        AbsoluteConstraints o_TrackConstraints = this.m_Track.getConstraints();
        int intWidth = this.m_ThisRectangle.width - this.m_TrackInsets.left - this.m_TrackInsets.right;
        int intHeight = this.m_ThisRectangle.height - this.m_TrackInsets.top - this.m_TrackInsets.bottom;
        if (intWidth > intHeight) {
            o_TrackConstraints.x = this.m_TrackInsets.left + (int)((double)intWidth / 2.0 - (double)intHeight / 2.0);
            o_TrackConstraints.width = intHeight;
            o_TrackConstraints.y = this.m_TrackInsets.top;
            o_TrackConstraints.height = intHeight;
        } else if (intHeight > intWidth) {
            o_TrackConstraints.x = this.m_TrackInsets.left;
            o_TrackConstraints.width = intWidth;
            o_TrackConstraints.y = this.m_TrackInsets.top + (int)((double)intHeight / 2.0 - (double)intWidth / 2.0);
            o_TrackConstraints.height = intWidth;
        } else {
            o_TrackConstraints.x = this.m_TrackInsets.left;
            o_TrackConstraints.width = intWidth;
            o_TrackConstraints.y = this.m_TrackInsets.top;
            o_TrackConstraints.height = intHeight;
        }
        this.calculateAdjuster();
        this.m_ControlDimension.calculateDisplayItems();
        this.m_ControlDimension.getControlTicks().calculate();
        this.m_ControlDimension.recalculateControlLabels();
        this.m_ControlDimension.getControlLabels().calculate();
        this.m_ControlDimension.getControlBlocks().calculate();
    }

    @Override
    public double calculatePixelPerValueLabel(ControlObject.ControlDimension p_ControlDimension) {
        int intRadiusOuter;
        if (p_ControlDimension == null) {
            return -1.0;
        }
        if (this.m_Track == null) {
            return -1.0;
        }
        Rectangle o_ThisRectangle = this.getBounds();
        Insets o_LabelsInsets = p_ControlDimension.getControlLabels().getLabelsInsets();
        AbsoluteConstraints o_LabelsConstraints = p_ControlDimension.getControlLabels().getConstraints();
        int intWidth = o_ThisRectangle.width - o_LabelsInsets.left - o_LabelsInsets.right;
        int intHeight = o_ThisRectangle.height - o_LabelsInsets.top - o_LabelsInsets.bottom;
        if (intWidth > intHeight) {
            o_LabelsConstraints.x = o_LabelsInsets.left + (int)((double)intWidth / 2.0 - (double)intHeight / 2.0);
            o_LabelsConstraints.width = intHeight;
            o_LabelsConstraints.y = o_LabelsInsets.top;
            o_LabelsConstraints.height = intHeight;
        } else if (intHeight > intWidth) {
            o_LabelsConstraints.x = o_LabelsInsets.left;
            o_LabelsConstraints.width = intWidth;
            o_LabelsConstraints.y = o_LabelsInsets.top + (int)((double)intHeight / 2.0 - (double)intWidth / 2.0);
            o_LabelsConstraints.height = intWidth;
        } else {
            o_LabelsConstraints.x = o_LabelsInsets.left;
            o_LabelsConstraints.width = intWidth;
            o_LabelsConstraints.y = o_LabelsInsets.top;
            o_LabelsConstraints.height = intHeight;
        }
        AbsoluteConstraints o_TrackConstraints = this.m_Track.getConstraints();
        int intSize = Math.min(o_TrackConstraints.width, o_TrackConstraints.height);
        if (intSize <= 0) {
            return -1.0;
        }
        int intMidX = (int)((double)(o_TrackConstraints.x - o_LabelsConstraints.x) + (double)intSize / 2.0) - 1;
        int intMidY = (int)((double)(o_TrackConstraints.y - o_LabelsConstraints.y) + (double)intSize / 2.0) - 1;
        int intMaxDistance = 0;
        int intDistance = intMidX;
        if (intMaxDistance < intDistance) {
            intMaxDistance = intDistance;
        }
        if (intMaxDistance < (intDistance = intMidY)) {
            intMaxDistance = intDistance;
        }
        if (intMaxDistance < (intDistance = o_LabelsConstraints.width - intMidX)) {
            intMaxDistance = intDistance;
        }
        if (intMaxDistance < (intDistance = o_LabelsConstraints.height - intMidY)) {
            intMaxDistance = intDistance;
        }
        if ((intRadiusOuter = intMaxDistance) <= 0) {
            intRadiusOuter = 1;
        }
        KnobAdjuster o_Adjuster = this.m_Track.getAdjuster();
        double doubleDistance = (o_Adjuster.getKnobMaxAngle() - o_Adjuster.getKnobMinAngle()) / (p_ControlDimension.getValueMaximum() - p_ControlDimension.getValueMinimum());
        Dimension o_LabelDimension = p_ControlDimension.getControlLabels().getLabelsSize();
        intSize = Math.max(o_LabelDimension.width, o_LabelDimension.height);
        int intRadiusInner = intRadiusOuter - intSize / 2;
        return o_Adjuster.calculateX(doubleDistance, intRadiusInner) - o_Adjuster.calculateX(0.0, intRadiusInner);
    }

    @Override
    public void calculateAdjuster() {
        if (this.m_Track != null) {
            this.m_Track.calculateAdjuster();
        }
        this.m_ControlDimension.setValueAdjusted(this.m_ControlDimension.getValue());
    }

    @Override
    public void calculateTicks(ControlObject.ControlTicks p_Ticks) {
        if (p_Ticks == null) {
            return;
        }
        Rectangle o_ThisRectangle = this.getBounds();
        Insets o_TicksInsets = p_Ticks.getTicksInsets();
        AbsoluteConstraints o_TicksConstraints = p_Ticks.getConstraints();
        int intWidth = o_ThisRectangle.width - o_TicksInsets.left - o_TicksInsets.right;
        int intHeight = o_ThisRectangle.height - o_TicksInsets.top - o_TicksInsets.bottom;
        if (intWidth > intHeight) {
            o_TicksConstraints.x = o_TicksInsets.left + (int)((double)intWidth / 2.0 - (double)intHeight / 2.0);
            o_TicksConstraints.width = intHeight;
            o_TicksConstraints.y = o_TicksInsets.top;
            o_TicksConstraints.height = intHeight;
        } else if (intHeight > intWidth) {
            o_TicksConstraints.x = o_TicksInsets.left;
            o_TicksConstraints.width = intWidth;
            o_TicksConstraints.y = o_TicksInsets.top + (int)((double)intHeight / 2.0 - (double)intWidth / 2.0);
            o_TicksConstraints.height = intWidth;
        } else {
            o_TicksConstraints.x = o_TicksInsets.left;
            o_TicksConstraints.width = intWidth;
            o_TicksConstraints.y = o_TicksInsets.top;
            o_TicksConstraints.height = intHeight;
        }
        p_Ticks.revalidate();
    }

    @Override
    public void paintTicks(Graphics p_Graphics, ControlObject.ControlTicks p_Ticks) {
        double doubleAngle;
        double doubleValue;
        double doubleJump;
        int intPassCount;
        int intTickRadiusInner;
        int intTickRadiusOuter;
        if (p_Ticks == null) {
            return;
        }
        if (p_Ticks.getTicksMajor() <= 0.0 && p_Ticks.getTicksMinor() <= 0.0) {
            return;
        }
        ControlObject.ControlDimension o_ControlDimension = p_Ticks.getControlDimension();
        AbsoluteConstraints o_TrackConstraints = this.m_Track.getConstraints();
        AbsoluteConstraints o_TicksConstraints = p_Ticks.getConstraints();
        int intSize = Math.min(o_TrackConstraints.width, o_TrackConstraints.height);
        if (intSize <= 0) {
            return;
        }
        int intMidX = (int)((double)(o_TrackConstraints.x - o_TicksConstraints.x) + (double)intSize / 2.0) - 1;
        int intMidY = (int)((double)(o_TrackConstraints.y - o_TicksConstraints.y) + (double)intSize / 2.0) - 1;
        int intMaxDistance = 0;
        int intDistance = intMidX;
        if (intMaxDistance < intDistance) {
            intMaxDistance = intDistance;
        }
        if (intMaxDistance < (intDistance = intMidY)) {
            intMaxDistance = intDistance;
        }
        if (intMaxDistance < (intDistance = o_TicksConstraints.width - intMidX)) {
            intMaxDistance = intDistance;
        }
        if (intMaxDistance < (intDistance = o_TicksConstraints.height - intMidY)) {
            intMaxDistance = intDistance;
        }
        int intRadiusOuter = intMaxDistance > 0 ? intMaxDistance : 1;
        int intTickLongest = p_Ticks.getTicksMajorLength() > p_Ticks.getTicksMinorLength() ? p_Ticks.getTicksMajorLength() : p_Ticks.getTicksMinorLength();
        int intRadiusInner = intRadiusOuter - intTickLongest;
        KnobAdjuster o_Adjuster = this.m_Track.getAdjuster();
        double doubleDistance = (o_Adjuster.getKnobMaxAngle() - o_Adjuster.getKnobMinAngle()) / (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum());
        Graphics2D g2d = (Graphics2D)p_Graphics.create();
        g2d.setColor(this.getForeground());
        if (p_Ticks.getTicksMajor() > 0.0 && p_Ticks.getTicksMajorLength() > 0) {
            if (!p_Ticks.getTicksMirrored()) {
                intTickRadiusOuter = intRadiusInner + p_Ticks.getTicksMajorLength();
                intTickRadiusInner = intRadiusInner;
            } else {
                intTickRadiusInner = intRadiusOuter - p_Ticks.getTicksMajorLength();
                intTickRadiusOuter = intRadiusOuter;
            }
            if (intTickRadiusInner <= 0) {
                intTickRadiusInner = 1;
            }
            if (intRadiusOuter <= 0) {
                intRadiusOuter = 1;
            }
            intPassCount = 1;
            if (o_Adjuster.calculateX(doubleDistance * (double)p_Ticks.getTicksMajorLength(), intTickRadiusInner) - o_Adjuster.calculateX(0.0, intTickRadiusInner) < 7.0) {
                intPassCount = (int)(7.0 / (o_Adjuster.calculateX(doubleDistance * (double)p_Ticks.getTicksMajorLength(), intTickRadiusInner) - o_Adjuster.calculateX(0.0, intTickRadiusInner)) + 1.0);
            }
            doubleJump = p_Ticks.getTicksMajor() * (double)intPassCount;
            p_Ticks.setTicksMajorPassCount(intPassCount);
            for (doubleValue = o_ControlDimension.getValueMinimum(); doubleValue <= o_ControlDimension.getValueMaximum(); doubleValue += doubleJump) {
                doubleAngle = !this.getInverted() ? o_Adjuster.getKnobMinAngle() + doubleValue * doubleDistance : o_Adjuster.getKnobMaxAngle() - doubleValue * doubleDistance;
                g2d.drawLine(intMidX + (int)(o_Adjuster.calculateX(doubleAngle, intTickRadiusInner) + 0.5), intMidY + (int)(o_Adjuster.calculateY(doubleAngle, intTickRadiusInner) + 0.5), intMidX + (int)(o_Adjuster.calculateX(doubleAngle, intTickRadiusOuter) + 0.5), intMidY + (int)o_Adjuster.calculateY(doubleAngle, (double)intTickRadiusOuter + 0.5));
            }
        }
        if (p_Ticks.getTicksMinor() > 0.0 && p_Ticks.getTicksMinorLength() > 0) {
            if (!p_Ticks.getTicksMirrored()) {
                intTickRadiusOuter = intRadiusInner + p_Ticks.getTicksMinorLength();
                intTickRadiusInner = intRadiusInner;
            } else {
                intTickRadiusInner = intRadiusOuter - p_Ticks.getTicksMinorLength();
                intTickRadiusOuter = intRadiusOuter;
            }
            if (intTickRadiusInner <= 0) {
                intTickRadiusInner = 1;
            }
            if (intRadiusOuter <= 0) {
                intRadiusOuter = 1;
            }
            intPassCount = 1;
            if (o_Adjuster.calculateX(doubleDistance * (double)p_Ticks.getTicksMinorLength(), intTickRadiusInner) - o_Adjuster.calculateX(0.0, intTickRadiusInner) < 3.0) {
                intPassCount = (int)(3.0 / (o_Adjuster.calculateX(doubleDistance * (double)p_Ticks.getTicksMinorLength(), intTickRadiusInner) - o_Adjuster.calculateX(0.0, intTickRadiusInner)) + 1.0);
            }
            doubleJump = p_Ticks.getTicksMinor() * (double)intPassCount;
            for (doubleValue = o_ControlDimension.getValueMinimum(); doubleValue <= o_ControlDimension.getValueMaximum(); doubleValue += doubleJump) {
                doubleAngle = !this.getInverted() ? o_Adjuster.getKnobMinAngle() + doubleValue * doubleDistance : o_Adjuster.getKnobMaxAngle() - doubleValue * doubleDistance;
                g2d.drawLine(intMidX + (int)(o_Adjuster.calculateX(doubleAngle, intTickRadiusInner) + 0.5), intMidY + (int)(o_Adjuster.calculateY(doubleAngle, intTickRadiusInner) + 0.5), intMidX + (int)(o_Adjuster.calculateX(doubleAngle, intTickRadiusOuter) + 0.5), intMidY + (int)o_Adjuster.calculateY(doubleAngle, (double)intTickRadiusOuter + 0.5));
            }
        }
        g2d.dispose();
    }

    @Override
    public void calculateLabels(ControlObject.ControlLabels p_Labels) {
        int intRadiusOuter;
        if (p_Labels == null) {
            return;
        }
        if (this.m_Track == null) {
            return;
        }
        Rectangle o_ThisRectangle = this.getBounds();
        ControlObject.ControlDimension o_ControlDimension = p_Labels.getControlDimension();
        Insets o_LabelsInsets = p_Labels.getLabelsInsets();
        AbsoluteConstraints o_LabelsConstraints = p_Labels.getConstraints();
        int intWidth = o_ThisRectangle.width - o_LabelsInsets.left - o_LabelsInsets.right;
        int intHeight = o_ThisRectangle.height - o_LabelsInsets.top - o_LabelsInsets.bottom;
        if (intWidth > intHeight) {
            o_LabelsConstraints.x = o_LabelsInsets.left + (int)((double)intWidth / 2.0 - (double)intHeight / 2.0);
            o_LabelsConstraints.width = intHeight;
            o_LabelsConstraints.y = o_LabelsInsets.top;
            o_LabelsConstraints.height = intHeight;
        } else if (intHeight > intWidth) {
            o_LabelsConstraints.x = o_LabelsInsets.left;
            o_LabelsConstraints.width = intWidth;
            o_LabelsConstraints.y = o_LabelsInsets.top + (int)((double)intHeight / 2.0 - (double)intWidth / 2.0);
            o_LabelsConstraints.height = intWidth;
        } else {
            o_LabelsConstraints.x = o_LabelsInsets.left;
            o_LabelsConstraints.width = intWidth;
            o_LabelsConstraints.y = o_LabelsInsets.top;
            o_LabelsConstraints.height = intHeight;
        }
        o_ControlDimension = p_Labels.getControlDimension();
        AbsoluteConstraints o_TrackConstraints = this.m_Track.getConstraints();
        int intSize = Math.min(o_TrackConstraints.width, o_TrackConstraints.height);
        if (intSize <= 0) {
            return;
        }
        int intMidX = (int)((double)(o_TrackConstraints.x - o_LabelsConstraints.x) + (double)intSize / 2.0) - 1;
        int intMidY = (int)((double)(o_TrackConstraints.y - o_LabelsConstraints.y) + (double)intSize / 2.0) - 1;
        int intMaxDistance = 0;
        int intDistance = intMidX;
        if (intMaxDistance < intDistance) {
            intMaxDistance = intDistance;
        }
        if (intMaxDistance < (intDistance = intMidY)) {
            intMaxDistance = intDistance;
        }
        if (intMaxDistance < (intDistance = o_LabelsConstraints.width - intMidX)) {
            intMaxDistance = intDistance;
        }
        if (intMaxDistance < (intDistance = o_LabelsConstraints.height - intMidY)) {
            intMaxDistance = intDistance;
        }
        if ((intRadiusOuter = intMaxDistance) <= 0) {
            intRadiusOuter = 1;
        }
        KnobAdjuster o_Adjuster = this.m_Track.getAdjuster();
        double doubleDistance = (o_Adjuster.getKnobMaxAngle() - o_Adjuster.getKnobMinAngle()) / (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum());
        Dimension o_LabelDimension = p_Labels.getLabelsSize();
        intSize = Math.max(o_LabelDimension.width, o_LabelDimension.height);
        int intRadiusInner = intRadiusOuter - intSize / 2;
        if (!p_Labels.getLabelsSizeFixed()) {
            if (o_Adjuster.calculateX(doubleDistance * p_Labels.getMinimalLabelsDistance(), intRadiusInner) - o_Adjuster.calculateX(0.0, intRadiusInner) < (double)intSize) {
                intSize = (int)(o_Adjuster.calculateX(doubleDistance * p_Labels.getMinimalLabelsDistance(), intRadiusInner) - o_Adjuster.calculateX(0.0, intRadiusInner));
            }
            intRadiusInner = intRadiusOuter - intSize / 2;
        }
        if (intRadiusInner <= 0) {
            intRadiusInner = 1;
        }
        for (int intLabel = 0; intLabel < p_Labels.getControlLabelsCount(); ++intLabel) {
            ControlObject.ControlLabels.ControlLabel o_ControlLabel = p_Labels.getControlLabel(intLabel);
            AbsoluteConstraints o_ControlLabelConstraints = o_ControlLabel.getConstraints();
            double doubleAngle = !this.getInverted() ? o_Adjuster.getKnobMinAngle() + o_ControlLabel.getControlLabelDescription().getValueDefault() * doubleDistance : o_Adjuster.getKnobMaxAngle() - o_ControlLabel.getControlLabelDescription().getValueDefault() * doubleDistance;
            int intPosX = (int)o_Adjuster.calculateX(doubleAngle, intRadiusInner);
            int intPosY = (int)o_Adjuster.calculateY(doubleAngle, intRadiusInner);
            o_ControlLabelConstraints.x = intMidX + intPosX - intSize / 2;
            o_ControlLabelConstraints.y = intMidY + intPosY - intSize / 2;
            o_ControlLabelConstraints.width = intSize;
            o_ControlLabelConstraints.height = intSize;
            if (p_Labels.getLabelsAlignment() == 2 || p_Labels.getLabelsAlignment() == 1) {
                if (intPosX < 0) {
                    o_ControlLabel.setHorizontalAlignment(2);
                } else if (intPosX == 0) {
                    o_ControlLabel.setHorizontalAlignment(0);
                } else if (intPosX > 0) {
                    o_ControlLabel.setHorizontalAlignment(4);
                }
                if (intPosY < 0) {
                    o_ControlLabel.setVerticalAlignment(1);
                    continue;
                }
                if (intPosY == 0) {
                    o_ControlLabel.setVerticalAlignment(0);
                    continue;
                }
                if (intPosY <= 0) continue;
                o_ControlLabel.setVerticalAlignment(3);
                continue;
            }
            if (p_Labels.getLabelsAlignment() == 4 || p_Labels.getLabelsAlignment() == 3) {
                if (intPosX < 0) {
                    o_ControlLabel.setHorizontalAlignment(4);
                } else if (intPosX == 0) {
                    o_ControlLabel.setHorizontalAlignment(0);
                } else if (intPosX > 0) {
                    o_ControlLabel.setHorizontalAlignment(2);
                }
                if (intPosY < 0) {
                    o_ControlLabel.setVerticalAlignment(3);
                    continue;
                }
                if (intPosY == 0) {
                    o_ControlLabel.setVerticalAlignment(0);
                    continue;
                }
                if (intPosY <= 0) continue;
                o_ControlLabel.setVerticalAlignment(1);
                continue;
            }
            o_ControlLabel.setVerticalAlignment(0);
            o_ControlLabel.setHorizontalAlignment(0);
        }
        p_Labels.revalidate();
    }

    @Override
    public void paintLabels(Graphics p_Graphics, ControlObject.ControlLabels p_ControlLabels) {
    }

    @Override
    public void calculateBlocks(ControlObject.ControlBlocks p_Blocks) {
        int intRadiusOuter;
        if (p_Blocks == null) {
            return;
        }
        if (this.m_Track == null) {
            return;
        }
        Rectangle o_ThisRectangle = this.getBounds();
        ControlObject.ControlDimension o_ControlDimension = p_Blocks.getControlDimension();
        Insets o_BlocksInsets = p_Blocks.getBlocksInsets();
        AbsoluteConstraints o_BlocksConstraints = p_Blocks.getConstraints();
        int intWidth = o_ThisRectangle.width - o_BlocksInsets.left - o_BlocksInsets.right;
        int intHeight = o_ThisRectangle.height - o_BlocksInsets.top - o_BlocksInsets.bottom;
        if (intWidth > intHeight) {
            o_BlocksConstraints.x = o_BlocksInsets.left + (int)((double)intWidth / 2.0 - (double)intHeight / 2.0);
            o_BlocksConstraints.width = intHeight;
            o_BlocksConstraints.y = o_BlocksInsets.top;
            o_BlocksConstraints.height = intHeight;
        } else if (intHeight > intWidth) {
            o_BlocksConstraints.x = o_BlocksInsets.left;
            o_BlocksConstraints.width = intWidth;
            o_BlocksConstraints.y = o_BlocksInsets.top + (int)((double)intHeight / 2.0 - (double)intWidth / 2.0);
            o_BlocksConstraints.height = intWidth;
        } else {
            o_BlocksConstraints.x = o_BlocksInsets.left;
            o_BlocksConstraints.width = intWidth;
            o_BlocksConstraints.y = o_BlocksInsets.top;
            o_BlocksConstraints.height = intHeight;
        }
        o_ControlDimension = p_Blocks.getControlDimension();
        AbsoluteConstraints o_TrackConstraints = this.m_Track.getConstraints();
        int intSize = Math.min(o_TrackConstraints.width, o_TrackConstraints.height);
        if (intSize <= 0) {
            return;
        }
        int intMidX = (int)((double)(o_TrackConstraints.x - o_BlocksConstraints.x) + (double)intSize / 2.0) - 1;
        int intMidY = (int)((double)(o_TrackConstraints.y - o_BlocksConstraints.y) + (double)intSize / 2.0) - 1;
        int intMaxDistance = 0;
        int intDistance = intMidX;
        if (intMaxDistance < intDistance) {
            intMaxDistance = intDistance;
        }
        if (intMaxDistance < (intDistance = intMidY)) {
            intMaxDistance = intDistance;
        }
        if (intMaxDistance < (intDistance = o_BlocksConstraints.width - intMidX)) {
            intMaxDistance = intDistance;
        }
        if (intMaxDistance < (intDistance = o_BlocksConstraints.height - intMidY)) {
            intMaxDistance = intDistance;
        }
        if ((intRadiusOuter = intMaxDistance) <= 0) {
            intRadiusOuter = 1;
        }
        KnobAdjuster o_Adjuster = this.m_Track.getAdjuster();
        double doubleDistance = (o_Adjuster.getKnobMaxAngle() - o_Adjuster.getKnobMinAngle()) / (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum());
        Dimension o_BlockDimension = p_Blocks.getBlocksSize();
        intSize = Math.max(o_BlockDimension.width, o_BlockDimension.height);
        int intRadiusInner = intRadiusOuter - intSize / 2;
        if (o_Adjuster.calculateX(doubleDistance * p_Blocks.getMinimalDistance(), intRadiusInner) - o_Adjuster.calculateX(0.0, intRadiusInner) < (double)intSize) {
            intSize = (int)(o_Adjuster.calculateX(doubleDistance * p_Blocks.getMinimalDistance(), intRadiusInner) - o_Adjuster.calculateX(0.0, intRadiusInner));
        }
        if ((intRadiusInner = intRadiusOuter - intSize / 2) <= 0) {
            intRadiusInner = 1;
        }
        for (int intLabel = 0; intLabel < p_Blocks.getControlBlocksCount(); ++intLabel) {
            ControlObject.ControlBlocks.ControlBlock o_ControlBlock = p_Blocks.getControlBlock(intLabel);
            AbsoluteConstraints o_ControlBlockConstraints = o_ControlBlock.getConstraints();
            double doubleAngle = !this.getInverted() ? o_Adjuster.getKnobMinAngle() + o_ControlBlock.getControlBlockDescription().getValueDefault() * doubleDistance : o_Adjuster.getKnobMaxAngle() - o_ControlBlock.getControlBlockDescription().getValueDefault() * doubleDistance;
            if (intSize < 0) {
                intSize = 0;
            }
            int intPosX = (int)o_Adjuster.calculateX(doubleAngle, intRadiusInner);
            int intPosY = (int)o_Adjuster.calculateY(doubleAngle, intRadiusInner);
            o_ControlBlockConstraints.x = intMidX + intPosX - intSize / 2;
            o_ControlBlockConstraints.y = intMidY + intPosY - intSize / 2 + (intSize - o_ControlBlock.getBaseline(intSize, intSize)) / 2;
            o_ControlBlockConstraints.width = intSize;
            o_ControlBlockConstraints.height = intSize;
            if (p_Blocks.getBlocksAlignment() == 2 || p_Blocks.getBlocksAlignment() == 1) {
                if (intPosX < 0) {
                    o_ControlBlock.setHorizontalAlignment(2);
                } else if (intPosX == 0) {
                    o_ControlBlock.setHorizontalAlignment(0);
                } else if (intPosX > 0) {
                    o_ControlBlock.setHorizontalAlignment(4);
                }
                if (intPosY < 0) {
                    o_ControlBlock.setVerticalAlignment(1);
                    continue;
                }
                if (intPosY == 0) {
                    o_ControlBlock.setVerticalAlignment(0);
                    continue;
                }
                if (intPosY <= 0) continue;
                o_ControlBlock.setVerticalAlignment(3);
                continue;
            }
            if (p_Blocks.getBlocksAlignment() == 4 || p_Blocks.getBlocksAlignment() == 3) {
                if (intPosX < 0) {
                    o_ControlBlock.setHorizontalAlignment(4);
                } else if (intPosX == 0) {
                    o_ControlBlock.setHorizontalAlignment(0);
                } else if (intPosX > 0) {
                    o_ControlBlock.setHorizontalAlignment(2);
                }
                if (intPosY < 0) {
                    o_ControlBlock.setVerticalAlignment(3);
                    continue;
                }
                if (intPosY == 0) {
                    o_ControlBlock.setVerticalAlignment(0);
                    continue;
                }
                if (intPosY <= 0) continue;
                o_ControlBlock.setVerticalAlignment(1);
                continue;
            }
            o_ControlBlock.setVerticalAlignment(0);
            o_ControlBlock.setHorizontalAlignment(0);
        }
        p_Blocks.revalidate();
    }

    @Override
    public void paintBlocks(Graphics p_Graphics, ControlObject.ControlBlocks p_ControlBlocks) {
    }

    public ControlObject.ControlTicks getControlTicks() {
        return this.m_ControlDimension.getControlTicks();
    }

    public boolean getTicksVisible() {
        return this.m_ControlDimension.getTicksVisible();
    }

    public void setTicksVisible(boolean p_TicksVisible) {
        this.m_ControlDimension.setTicksVisible(p_TicksVisible);
    }

    public double getTicksMajor() {
        return this.m_ControlDimension.getTicksMajor();
    }

    public void setTicksMajor(double p_TicksMajor) {
        this.m_ControlDimension.setTicksMajor(p_TicksMajor);
    }

    public double getTicksMinor() {
        return this.m_ControlDimension.getTicksMinor();
    }

    public void setTicksMinor(double p_TicksMinor) {
        this.m_ControlDimension.setTicksMinor(p_TicksMinor);
    }

    public int getTicksAlignment() {
        return this.m_ControlDimension.getTicksAlignment();
    }

    public void setTicksAlignment(int p_TicksAlignment) {
        this.m_ControlDimension.setTicksAlignment(p_TicksAlignment);
    }

    public int getTicksMajorLength() {
        return this.m_ControlDimension.getTicksMajorLength();
    }

    public void setTicksMajorLength(int p_TicksLength) {
        this.m_ControlDimension.setTicksMajorLength(p_TicksLength);
    }

    public int getTicksMinorLength() {
        return this.m_ControlDimension.getTicksMinorLength();
    }

    public void setTicksMinorLength(int p_TicksLength) {
        this.m_ControlDimension.setTicksMinorLength(p_TicksLength);
    }

    public boolean getTicksMirrored() {
        return this.m_ControlDimension.getTicksMirrored();
    }

    public void setTicksMirrored(boolean p_TicksMirrored) {
        this.m_ControlDimension.setTicksMirrored(p_TicksMirrored);
    }

    public Insets getTicksInsets() {
        return this.m_ControlDimension.getTicksInsets();
    }

    public void setTicksInsets(Insets p_TicksInsets) {
        this.m_ControlDimension.setTicksInsets(p_TicksInsets);
    }

    public boolean getLabelsAutomatic() {
        return this.m_ControlDimension.getLabelsAutomatic();
    }

    public void setLabelsAutomatic(boolean p_LabelsAutomatic) {
        this.m_ControlDimension.setLabelsAutomatic(p_LabelsAutomatic);
    }

    public boolean getLabelsVisible() {
        return this.m_ControlDimension.getLabelsVisible();
    }

    public void setLabelsVisible(boolean p_LabelsVisible) {
        this.m_ControlDimension.setLabelsVisible(p_LabelsVisible);
    }

    public Insets getLabelsInsets() {
        return this.m_ControlDimension.getLabelsInsets();
    }

    public void setLabelsInsets(Insets p_LabelsInsets) {
        this.m_ControlDimension.setLabelsInsets(p_LabelsInsets);
    }

    public int getLabelsAlignment() {
        return this.m_ControlDimension.getLabelsAlignment();
    }

    public void setLabelsAlignment(int p_LabelsAlignment) {
        this.m_ControlDimension.setLabelsAlignment(p_LabelsAlignment);
    }

    public boolean getLabelsMirrored() {
        return this.m_ControlDimension.getLabelsMirrored();
    }

    public void setLabelsMirrored(boolean p_LabelsMirrored) {
        this.m_ControlDimension.setLabelsMirrored(p_LabelsMirrored);
    }

    public Font getLabelsFont() {
        return this.m_ControlDimension.getLabelsFont();
    }

    public void setLabelsFont(Font p_LabelsFont) {
        this.m_ControlDimension.setLabelsFont(p_LabelsFont);
    }

    public void setLabelsTextRotation(double p_Degree) {
        this.m_ControlDimension.setLabelsTextRotation(p_Degree);
    }

    public Border getLabelsBorder() {
        return this.m_ControlDimension.getLabelsBorder();
    }

    public void setLabelsBorder(Border p_LabelsBorder) {
        this.m_ControlDimension.setLabelsBorder(p_LabelsBorder);
    }

    public ControlLabelModel getControlLabelModel() {
        return this.m_ControlDimension.getControlLabelModel();
    }

    public void setControlLabelModel(ControlLabelModel p_ControlLabelModel) {
        this.m_ControlDimension.setControlLabelModel(p_ControlLabelModel);
    }

    public Dimension getLabelsSize() {
        return this.m_ControlDimension.getLabelsSize();
    }

    public void setLabelsSize(Dimension p_LabelsSize) {
        this.m_ControlDimension.setLabelsSize(p_LabelsSize);
    }

    public void setLabelsSizeFixed(boolean p_LabelsSizeFixed) {
        this.m_ControlDimension.setLabelsSizeFixed(p_LabelsSizeFixed);
    }

    public boolean getLabelsSizeFixed() {
        return this.m_ControlDimension.getLabelsSizeFixed();
    }

    public boolean getBlocksVisible() {
        return this.m_ControlDimension.getBlocksVisible();
    }

    public void setBlocksVisible(boolean p_BlocksVisible) {
        this.m_ControlDimension.setBlocksVisible(p_BlocksVisible);
    }

    public Insets getBlocksInsets() {
        return this.m_ControlDimension.getBlocksInsets();
    }

    public void setBlocksInsets(Insets p_BlocksInsets) {
        this.m_ControlDimension.setBlocksInsets(p_BlocksInsets);
    }

    public int getBlocksAlignment() {
        return this.m_ControlDimension.getBlocksAlignment();
    }

    public void setBlocksAlignment(int p_BlocksAlignment) {
        this.m_ControlDimension.setBlocksAlignment(p_BlocksAlignment);
    }

    public boolean getBlocksMirrored() {
        return this.m_ControlDimension.getBlocksMirrored();
    }

    public void setBlocksMirrored(boolean p_BlocksMirrored) {
        this.m_ControlDimension.setBlocksMirrored(p_BlocksMirrored);
    }

    public Font getBlocksFont() {
        return this.m_ControlDimension.getBlocksFont();
    }

    public void setBlocksFont(Font p_BlocksFont) {
        this.m_ControlDimension.setBlocksFont(p_BlocksFont);
    }

    public void setBlocksTextRotation(double p_Degree) {
        this.m_ControlDimension.setBlocksTextRotation(p_Degree);
    }

    public Border getBlocksBorder() {
        return this.m_ControlDimension.getBlocksBorder();
    }

    public void setBlocksBorder(Border p_BlocksBorder) {
        this.m_ControlDimension.setBlocksBorder(p_BlocksBorder);
    }

    public ControlBlockModel getControlBlockModel() {
        return this.m_ControlDimension.getControlBlockModel();
    }

    public void setControlBlockModel(ControlBlockModel p_ControlBlockModel) {
        this.m_ControlDimension.setControlBlockModel(p_ControlBlockModel);
    }

    public Dimension getBlocksSize() {
        return this.m_ControlDimension.getBlocksSize();
    }

    public void setBlocksSize(Dimension p_BlocksSize) {
        this.m_ControlDimension.setBlocksSize(p_BlocksSize);
    }

    public int getOrientation() {
        return this.m_ControlDimension.getOrientation();
    }

    public void setOrientation(int p_Orientation) {
        this.m_ControlDimension.setOrientation(p_Orientation);
    }

    public boolean getInverted() {
        return this.m_ControlDimension.getInverted();
    }

    public void setInverted(boolean p_Inverted) {
        this.m_ControlDimension.setInverted(p_Inverted);
    }

    public double getValue() {
        return this.m_ControlDimension.getValue();
    }

    public double getValueOld() {
        return this.m_ControlDimension.getValueOld();
    }

    @Override
    public void adjustToValue(ControlObject.ControlDimension p_ControlDimension, double p_Value, boolean p_ManuallySet) {
        if (p_ControlDimension == null) {
            return;
        }
        if (this.m_ControlDimension != p_ControlDimension) {
            return;
        }
        p_ControlDimension.adjustToValue(p_Value, p_ManuallySet);
    }

    public void setValue(double p_Value, double p_ValueDiff, int p_ActionFlag) {
        this.m_ControlDimension.setValue(p_Value, p_Value - this.m_ControlDimension.getValue(), p_ActionFlag);
    }

    public void setValue(double p_Value) {
        this.m_ControlDimension.setValue(p_Value, p_Value - this.m_ControlDimension.getValue(), 0);
    }

    public int getValueInt() {
        return this.m_ControlDimension.getValueInt();
    }

    public void setValueInt(int p_Value, int p_ActionFlag) {
        this.m_ControlDimension.setValueInt(p_Value, p_Value - this.m_ControlDimension.getValueInt(), p_ActionFlag);
    }

    public double getValueTransformed() {
        return this.m_ControlDimension.getValueTransformed();
    }

    public void setValueTransformed(double p_MultipliedValue, int p_ActionFlag) {
        this.m_ControlDimension.setValueTransformed(p_MultipliedValue, p_ActionFlag);
    }

    public double getValueMultiplier() {
        return this.m_ControlDimension.getValueMultiplier();
    }

    public void setValueMultiplier(double p_ValueMultiplier) {
        this.m_ControlDimension.setValueMultiplier(p_ValueMultiplier);
    }

    public double getValueOffset() {
        return this.m_ControlDimension.getValueOffset();
    }

    public void setValueOffset(double p_ValueOffset) {
        this.m_ControlDimension.setValueOffset(p_ValueOffset);
    }

    public double getSnapDistance() {
        return this.m_ControlDimension.getSnapDistance();
    }

    public void setSnapDistance(double p_SnapDistance) {
        this.m_ControlDimension.setSnapDistance(p_SnapDistance);
    }

    public double getSnapDistanceTransformed() {
        return this.m_ControlDimension.getSnapDistanceTransformed();
    }

    public void setSnapDistanceTransformed(double p_SnapDistanceTransformed) {
        this.m_ControlDimension.setSnapDistanceTransformed(p_SnapDistanceTransformed);
    }

    public double getValueMaximum() {
        return this.m_ControlDimension.getValueMaximum();
    }

    public void setValueMaximum(double p_Maximum) {
        this.m_ControlDimension.setValueMaximum(p_Maximum);
    }

    public double getValueMinimum() {
        return this.m_ControlDimension.getValueMinimum();
    }

    public void setValueMinimum(double p_Minimum) {
        this.m_ControlDimension.setValueMinimum(p_Minimum);
    }

    public double getMouseWheelStep() {
        return this.m_ControlDimension.getMouseWheelStep();
    }

    public void setMouseWheelStep(double p_ValueDifference) {
        this.m_ControlDimension.setMouseWheelStep(p_ValueDifference);
    }

    public static class KnobAdjuster
    extends JComponent
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        protected JControlKnob m_ControlObject;
        protected ControlObject.ControlDimension m_ControlDimension;
        protected double m_ValueMinAngle;
        protected double m_ValueMaxAngle;
        protected Color m_AdjusterColor;
        protected BufferedImage m_AdjusterImage;
        protected KnobAdjuster m_SelfReference;
        protected AbsoluteConstraints m_AdjusterConstraints;
        protected int m_DragStartX;
        protected int m_DragStartY;
        protected double m_DragStartValue;
        protected Rectangle m_RectSize;
        protected Rectangle m_OldRectSize;
        protected boolean m_RepaintFlag;
        private SoftReference m_SoftReferenceBufferedImage;
        private Insets m_InsetsParent;

        public KnobAdjuster(ControlObject p_ControlObject) {
            this.m_ControlObject = (JControlKnob)p_ControlObject;
            this.m_ControlDimension = p_ControlObject.getControlDimension(0);
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_SelfReference = this;
            this.m_AdjusterColor = Color.LIGHT_GRAY;
            this.m_AdjusterImage = null;
            this.m_ValueMinAngle = 3.490658503988659;
            this.m_ValueMaxAngle = 9.075712110370514;
            this.m_RectSize = new Rectangle();
            this.m_OldRectSize = new Rectangle();
            this.m_RepaintFlag = true;
        }

        private Object readResolve() {
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
            p_ObjectOutput.writeInt(1);
            p_ObjectOutput.writeDouble(this.m_ValueMinAngle);
            p_ObjectOutput.writeDouble(this.m_ValueMaxAngle);
            ImagesTools.writeColor((ObjectOutput)p_ObjectOutput, (Color)this.m_AdjusterColor);
            ImagesTools.writeImage((ObjectOutput)p_ObjectOutput, (Image)this.m_AdjusterImage);
        }

        @Override
        public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = p_ObjectInput.readInt();
            this.m_ValueMinAngle = p_ObjectInput.readDouble();
            this.m_ValueMaxAngle = p_ObjectInput.readDouble();
            this.m_AdjusterColor = ImagesTools.readColor((ObjectInput)p_ObjectInput);
            Image o_Image = ImagesTools.readImage((ObjectInput)p_ObjectInput);
            this.m_AdjusterImage = ImagesTools.convertToBufferedImage((Image)o_Image);
            this.m_RepaintFlag = true;
            this.repaint();
            this.m_ControlObject.calculateAdjuster();
        }

        private void initComponents() {
            this.setOpaque(false);
            this.m_AdjusterConstraints = new AbsoluteConstraints(0, 0, 0, 0);
            MouseAdapter_Delayed o_MouseAdapter = new MouseAdapter_Delayed(){

                public void mousePressed_Delayed(MouseEvent me) {
                    if (!(me.getButton() != 1 || me.isAltDown() || me.isAltGraphDown() || me.isControlDown() || me.isMetaDown() || me.isShiftDown())) {
                        m_DragStartX = me.getX();
                        m_DragStartY = me.getY();
                        m_DragStartValue = m_ControlDimension.getValue();
                        this.requestFocus();
                    }
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseClicked_Delayed(MouseEvent me) {
                    if (!(me.getButton() != 1 || me.isAltDown() || me.isAltGraphDown() || me.isControlDown() || me.isMetaDown() || me.isShiftDown())) {
                        ControlObject.ControlLabels o_Labels = m_ControlDimension.getControlLabels();
                        Component o_Component = o_Labels.getComponentAt(me.getX() - o_Labels.getLabelsInsets().left + m_ControlObject.getTrackInsets().left, me.getY() - o_Labels.getLabelsInsets().top + m_ControlObject.getTrackInsets().top);
                        if (o_Component instanceof ControlObject.ControlLabels.ControlLabel) {
                            ((ControlObject.ControlLabels.ControlLabel)((Object)o_Component)).setValue(2);
                            return;
                        }
                        ControlObject.ControlBlocks o_Blocks = m_ControlDimension.getControlBlocks();
                        o_Component = o_Blocks.getComponentAt(me.getX() - o_Blocks.getBlocksInsets().left + m_ControlObject.getTrackInsets().left, me.getY() - o_Blocks.getBlocksInsets().top + m_ControlObject.getTrackInsets().top);
                        if (o_Component instanceof ControlObject.ControlBlocks.ControlBlock) {
                            ((ControlObject.ControlBlocks.ControlBlock)((Object)o_Component)).setValue(2);
                            return;
                        }
                        if (me.getX() == m_DragStartX && me.getY() == m_DragStartY) {
                            double doubleValueNew = m_ControlObject.getValuesFromTrackPosition(me.getX(), me.getY())[0];
                            double doubleValueDiff = doubleValueNew - m_ControlDimension.getValue();
                            m_ControlDimension.setValue(doubleValueNew, doubleValueDiff, 2);
                            m_ControlObject.setValueManuallyIsReady();
                        }
                    }
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseEntered_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseReleased_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseExited_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseDragged_Delayed(MouseEvent me) {
                    if (!(me.isAltDown() || me.isAltGraphDown() || me.isControlDown() || me.isMetaDown() || me.isShiftDown())) {
                        double doubleAngleStart = this.calculateAngle(m_DragStartX, m_DragStartY);
                        double doubleAngleEnd = this.calculateAngle(me.getX(), me.getY());
                        if (Math.abs(doubleAngleEnd - doubleAngleStart) < 5.283185307179586) {
                            double doubleDeltaValue = (doubleAngleEnd - doubleAngleStart) / (m_ValueMaxAngle - m_ValueMinAngle) * (m_ControlDimension.getValueMaximum() - m_ControlDimension.getValueMinimum());
                            m_ControlDimension.setValue(m_DragStartValue + doubleDeltaValue, doubleDeltaValue, 4);
                            m_ControlObject.setValueManuallyIsReady();
                        }
                        m_DragStartX = me.getX();
                        m_DragStartY = me.getY();
                        m_DragStartValue = m_ControlDimension.getValue();
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseMoved_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }
            };
            this.addMouseListener((MouseListener)o_MouseAdapter);
            this.addMouseMotionListener((MouseMotionListener)o_MouseAdapter);
        }

        public AbsoluteConstraints getConstraints() {
            return this.m_AdjusterConstraints;
        }

        public double calculateAngle(int p_X, int p_Y) {
            double x = p_X - this.getWidth() / 2;
            double y = this.getHeight() / 2 - p_Y;
            double doubleHypo = Math.sqrt(x * x + y * y);
            double doubleAngle = Math.asin(y / doubleHypo);
            doubleAngle = x > 0.0 ? 1.5707963267948966 - doubleAngle : 4.71238898038469 + doubleAngle;
            if (doubleAngle < this.m_ValueMinAngle) {
                doubleAngle += Math.PI * 2;
            }
            return doubleAngle;
        }

        public double calculateX(double p_Angle, double p_Radius) {
            double doubleX = Math.cos(p_Angle - 1.5707963267948966) * p_Radius;
            return doubleX;
        }

        public double calculateY(double p_Angle, double p_Radius) {
            double doubleY = Math.sin(p_Angle - 1.5707963267948966) * p_Radius;
            return doubleY;
        }

        @Override
        public void setForeground(Color p_Color) {
            this.m_RepaintFlag = true;
            super.setForeground(p_Color);
        }

        public double getKnobMinAngleDegree() {
            return this.m_ValueMinAngle * 180.0 / Math.PI;
        }

        public void setKnobMinAngleDegree(double p_AngleDegree) {
            this.setKnobMinAngle(Math.PI * p_AngleDegree / 180.0);
        }

        public double getKnobMinAngle() {
            return this.m_ValueMinAngle;
        }

        public void setKnobMinAngle(double p_AngleRadians) {
            double doubleWholeCircle = Math.PI * 2;
            int intwholeCircles = (int)(p_AngleRadians / doubleWholeCircle);
            double oldValue = this.m_ValueMinAngle;
            this.m_ValueMinAngle = p_AngleRadians -= (double)intwholeCircles * doubleWholeCircle;
            if (this.m_ValueMinAngle != oldValue) {
                if (this.m_ValueMinAngle > this.m_ValueMaxAngle) {
                    this.setKnobMaxAngle(this.m_ValueMaxAngle);
                }
                this.firePropertyChange(JControlKnob.PROP_KNOBMINANGLE, oldValue, this.m_ValueMinAngle);
                this.m_ControlObject.calculateInnerItems();
            }
        }

        public double getKnobMaxAngleDegree() {
            return this.m_ValueMaxAngle * 180.0 / Math.PI;
        }

        public void setKnobMaxAngleDegree(double p_AngleDegree) {
            this.setKnobMaxAngle(Math.PI * p_AngleDegree / 180.0);
        }

        public double getKnobMaxAngle() {
            return this.m_ValueMaxAngle;
        }

        public void setKnobMaxAngle(double p_AngleRadians) {
            double doubleWholeCircle = Math.PI * 2;
            int intwholeCircles = (int)(p_AngleRadians / doubleWholeCircle);
            p_AngleRadians -= (double)intwholeCircles * doubleWholeCircle;
            double oldValue = this.m_ValueMaxAngle;
            if (p_AngleRadians < this.m_ValueMinAngle) {
                p_AngleRadians += Math.PI * 2;
            }
            this.m_ValueMaxAngle = p_AngleRadians;
            if (this.m_ValueMaxAngle != oldValue) {
                this.firePropertyChange(JControlKnob.PROP_KNOBMAXANGLE, oldValue, this.m_ValueMaxAngle);
                this.m_ControlObject.calculateInnerItems();
            }
        }

        public Image getAdjusterImage() {
            return this.m_AdjusterImage;
        }

        public void setAdjusterImage(Image p_AdjusterImage) {
            BufferedImage oldValue = this.m_AdjusterImage;
            this.m_AdjusterImage = ImagesTools.convertToBufferedImage((Image)p_AdjusterImage);
            this.m_RepaintFlag = true;
            this.firePropertyChange(JControlKnob.PROP_ADJUSTERIMAGE, oldValue, this.m_AdjusterImage);
            this.repaint();
        }

        public Color getAdjusterColor() {
            return this.m_AdjusterColor;
        }

        public void setAdjusterColor(Color p_AdjusterColor) {
            Color oldValue = this.m_AdjusterColor;
            this.m_AdjusterColor = p_AdjusterColor;
            if (!oldValue.equals(this.m_AdjusterColor)) {
                this.m_RepaintFlag = true;
                this.firePropertyChange(JControlKnob.PROP_ADJUSTERCOLOR, oldValue, this.m_AdjusterColor);
                this.repaint();
            }
        }

        @Override
        public void paintComponent(Graphics p_Graphics) {
            Graphics2D g2d;
            BufferedImage o_GraphicsImage = null;
            boolean boolWidthChanged = false;
            boolean boolHeightChanged = false;
            super.paintComponent(p_Graphics);
            this.m_InsetsParent = this.getInsets(this.m_InsetsParent);
            this.m_RectSize.setRect(this.m_InsetsParent.left, this.m_InsetsParent.top, this.getWidth() - this.m_InsetsParent.left - this.m_InsetsParent.right - 1, this.getHeight() - this.m_InsetsParent.top - this.m_InsetsParent.bottom - 1);
            if (this.m_RectSize.getWidth() != this.m_OldRectSize.getWidth()) {
                boolWidthChanged = true;
            }
            if (this.m_RectSize.getHeight() != this.m_OldRectSize.getHeight()) {
                boolHeightChanged = true;
            }
            if (boolWidthChanged || boolHeightChanged) {
                this.m_RepaintFlag = true;
            }
            this.m_OldRectSize.setRect(this.m_RectSize.getX(), this.m_RectSize.getY(), this.m_RectSize.getWidth(), this.m_RectSize.getHeight());
            if (this.m_SoftReferenceBufferedImage != null) {
                o_GraphicsImage = (BufferedImage)this.m_SoftReferenceBufferedImage.get();
            }
            if (o_GraphicsImage == null) {
                this.m_RepaintFlag = true;
            }
            if (this.m_RepaintFlag) {
                if (o_GraphicsImage != null) {
                    o_GraphicsImage.flush();
                }
                if (this.m_SoftReferenceBufferedImage != null) {
                    this.m_SoftReferenceBufferedImage.clear();
                }
                this.m_SoftReferenceBufferedImage = null;
                try {
                    o_GraphicsImage = new BufferedImage((int)this.m_RectSize.getWidth(), (int)this.m_RectSize.getHeight(), 3);
                }
                catch (Exception e) {
                    return;
                }
                if (o_GraphicsImage == null) {
                    return;
                }
                g2d = (Graphics2D)o_GraphicsImage.getGraphics();
                if (this.m_AdjusterImage != null) {
                    BufferedImage o_BufferedImage = this.m_ControlDimension.getOrientation() == 1 ? this.m_AdjusterImage : ImagesTools.rotateImage90_right((BufferedImage)this.m_AdjusterImage);
                    ImagesTools.scaleImageSynchron((Image)o_BufferedImage, (int)0, (int)0, (int)o_BufferedImage.getWidth(), (int)o_BufferedImage.getHeight(), (Image)o_GraphicsImage, (int)0, (int)0, (int)o_GraphicsImage.getWidth(), (int)o_GraphicsImage.getHeight());
                } else {
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2d.setColor(this.m_AdjusterColor);
                    g2d.fillOval(1, 1, this.m_RectSize.width - 3, this.m_RectSize.height - 3);
                    g2d.setColor(this.getForeground());
                    g2d.drawOval(1, 1, this.m_RectSize.width - 3, this.m_RectSize.height - 3);
                    g2d.setColor(this.getForeground());
                    if (this.m_ControlDimension.getOrientation() == 1) {
                        g2d.drawLine(this.m_RectSize.width / 2, this.m_RectSize.height / 2, this.m_RectSize.width / 2, 0);
                    } else {
                        g2d.drawLine(this.m_RectSize.width / 2, this.m_RectSize.height / 2, this.m_RectSize.width, this.m_RectSize.height / 2);
                    }
                }
                g2d.dispose();
                g2d = null;
                this.m_RepaintFlag = false;
                this.m_SoftReferenceBufferedImage = new SoftReference<BufferedImage>(o_GraphicsImage);
            }
            if (o_GraphicsImage != null) {
                g2d = (Graphics2D)p_Graphics;
                double m_RotationRadians = !this.m_ControlDimension.getInverted() ? this.m_ValueMinAngle + this.m_ControlDimension.getValue() / (this.m_ControlDimension.getValueMaximum() - this.m_ControlDimension.getValueMinimum()) * (this.m_ValueMaxAngle - this.m_ValueMinAngle) : this.m_ValueMaxAngle - this.m_ControlDimension.getValue() / (this.m_ControlDimension.getValueMaximum() - this.m_ControlDimension.getValueMinimum()) * (this.m_ValueMaxAngle - this.m_ValueMinAngle);
                double doubleRadiansOf90Degree = 1.5707963267948966;
                Object o_Antialias = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                Object o_TextAntialias = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                if ((double)((long)(m_RotationRadians / doubleRadiansOf90Degree)) != m_RotationRadians / doubleRadiansOf90Degree) {
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
                }
                AffineTransform o_AffineTransformOld = g2d.getTransform();
                AffineTransform o_TransformRotate = new AffineTransform();
                o_TransformRotate.rotate(m_RotationRadians, this.m_RectSize.width / 2, this.m_RectSize.height / 2);
                o_TransformRotate.preConcatenate(o_AffineTransformOld);
                g2d.setTransform(o_TransformRotate);
                g2d.drawImage(o_GraphicsImage, this.m_RectSize.x, this.m_RectSize.y, this.m_RectSize.x + this.m_RectSize.width, this.m_RectSize.y + this.m_RectSize.height, this.m_RectSize.x - this.m_InsetsParent.left, this.m_RectSize.y - this.m_InsetsParent.top, this.m_RectSize.x - this.m_InsetsParent.left + this.m_RectSize.width, this.m_RectSize.y - this.m_InsetsParent.top + this.m_RectSize.height, this);
                g2d.setTransform(o_AffineTransformOld);
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, o_TextAntialias);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, o_Antialias);
            }
            o_GraphicsImage = null;
        }
    }

    protected static class KnobTrack
    extends JComponent
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        protected ControlObject m_ControlObject;
        protected ControlObject.ControlDimension m_ControlDimension;
        protected Insets m_TrackInsets;
        protected KnobAdjuster m_Adjuster;
        protected AbsoluteLayout m_LayoutManager;
        protected KnobTrack m_SelfReference;
        protected AbsoluteConstraints m_TrackConstraints;

        public KnobTrack(ControlObject p_ControlObject) {
            this.m_ControlObject = p_ControlObject;
            this.m_ControlDimension = this.m_ControlObject.getControlDimension(0);
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_SelfReference = this;
            this.setBackground(Color.LIGHT_GRAY);
            this.m_TrackInsets = new Insets(20, 20, 20, 20);
            this.m_Adjuster = new KnobAdjuster(this.m_ControlObject);
            this.readResolve();
        }

        private Object readResolve() {
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
            p_ObjectOutput.writeInt(1);
            ImagesTools.writeInsets((ObjectOutput)p_ObjectOutput, (Insets)this.m_TrackInsets);
            this.m_Adjuster.writeExternal(p_ObjectOutput);
        }

        @Override
        public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = p_ObjectInput.readInt();
            this.m_TrackInsets = ImagesTools.readInsets((ObjectInput)p_ObjectInput);
            this.m_Adjuster.readExternal(p_ObjectInput);
            this.m_ControlObject.calculateInnerItems();
        }

        private void initComponents() {
            this.setOpaque(false);
            this.m_LayoutManager = new AbsoluteLayout();
            this.setLayout(this.m_LayoutManager);
            this.m_TrackConstraints = new AbsoluteConstraints(0, 0, 0, 0);
            this.add(this.m_Adjuster, this.m_Adjuster.getConstraints(), 0);
            this.setVisible(true);
            MouseAdapter_Delayed o_MouseAdapter = new MouseAdapter_Delayed(){

                public void mousePressed_Delayed(MouseEvent me) {
                    if (!(me.getButton() != 1 || me.isAltDown() || me.isAltGraphDown() || me.isControlDown() || me.isMetaDown() || me.isShiftDown())) {
                        this.requestFocus();
                    }
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseClicked_Delayed(MouseEvent me) {
                    if (!(me.getButton() != 1 || me.isAltDown() || me.isAltGraphDown() || me.isControlDown() || me.isMetaDown() || me.isShiftDown())) {
                        ControlObject.ControlLabels o_Labels = m_ControlDimension.getControlLabels();
                        Component o_Component = o_Labels.getComponentAt(me.getX() - o_Labels.getLabelsInsets().left + m_TrackInsets.left, me.getY() - o_Labels.getLabelsInsets().top + m_TrackInsets.top);
                        if (o_Component instanceof ControlObject.ControlLabels.ControlLabel) {
                            ((ControlObject.ControlLabels.ControlLabel)((Object)o_Component)).setValue(2);
                            return;
                        }
                        ControlObject.ControlBlocks o_Blocks = m_ControlDimension.getControlBlocks();
                        o_Component = o_Blocks.getComponentAt(me.getX() - o_Blocks.getBlocksInsets().left + m_TrackInsets.left, me.getY() - o_Blocks.getBlocksInsets().top + m_TrackInsets.top);
                        if (o_Component instanceof ControlObject.ControlBlocks.ControlBlock) {
                            ((ControlObject.ControlBlocks.ControlBlock)((Object)o_Component)).setValue(2);
                            return;
                        }
                        double doubleVaueNew = m_ControlObject.getValuesFromInnerComponentPosition(m_SelfReference, me.getX(), me.getY())[0];
                        double doubleValueDiff = doubleVaueNew - m_ControlDimension.getValue();
                        m_ControlDimension.setValue(doubleVaueNew, doubleValueDiff, 2);
                        m_ControlObject.setValueManuallyIsReady();
                    }
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseEntered_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseReleased_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseExited_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }
            };
            this.addMouseListener((MouseListener)o_MouseAdapter);
        }

        @Override
        public void setForeground(Color p_Color) {
            this.m_Adjuster.setForeground(p_Color);
            super.setForeground(p_Color);
        }

        public KnobAdjuster getAdjuster() {
            return this.m_Adjuster;
        }

        public AbsoluteConstraints getConstraints() {
            return this.m_TrackConstraints;
        }

        public Insets getTrackInsets() {
            return this.m_TrackInsets;
        }

        public void setTrackInsets(Insets p_Insets) {
            Insets oldValue = this.m_TrackInsets;
            this.m_TrackInsets = p_Insets;
            if (!this.m_TrackInsets.equals(oldValue)) {
                this.m_ControlObject.calculateInnerItems();
                this.firePropertyChange(JControlKnob.PROP_TRACKINSETS, oldValue, this.m_TrackInsets);
            }
        }

        public void setTrackInsets(int p_Top, int p_Left, int p_Bottom, int p_Right) {
            this.setTrackInsets(new Insets(p_Top, p_Left, p_Bottom, p_Right));
        }

        private void calculateAdjuster() {
            int intSize = Math.min(this.m_TrackConstraints.width, this.m_TrackConstraints.height);
            if (this.m_Adjuster.getConstraints() != null) {
                this.m_Adjuster.getConstraints().x = 0;
                this.m_Adjuster.getConstraints().y = 0;
                this.m_Adjuster.getConstraints().width = intSize;
                this.m_Adjuster.getConstraints().height = intSize;
                this.m_Adjuster.revalidate();
                this.m_Adjuster.repaint();
            }
        }

        @Override
        public void paintComponent(Graphics p_Graphics) {
            super.paintComponent(p_Graphics);
        }
    }
}

