/*
 * Decompiled with CFR 0.152.
 */
package LiveShowControls;

import JarLoader.JarClassLoader;
import JarLoader.JarResources;
import LiveShowControlModels.ControlBlockModel;
import LiveShowControlModels.ControlLabelModel;
import LiveShowControlObjects.ControlGroup;
import LiveShowControlObjects.ControlObject;
import SwingComponents.MouseAdapter_Delayed;
import ToolsGraphics.GraphicsTools;
import ToolsGraphics.ImagesTools;
import ToolsGraphics.Polygon2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class JControlGrid
extends ControlObject {
    public static final String PROP_TRACKINSETS = "trackInsets";
    public static final String PROP_TRACKOPAQUE = "trackOpaque";
    public static final String PROP_TRACKGRIDVISIBLE = "trackGridVisible";
    public static final String PROP_ADJUSTERLENGTH = "adjusterLength";
    public static final String PROP_ADJUSTERCOLOR = "adjusterColor";
    public static final String PROP_ADJUSTERIMAGE = "adjusterImage";
    public static final String PROP_ADJUSTERAXISLENGTH = "adjusterAxisLength";
    public static final String PROP_ADJUSTERAXISCOLOR = "adjusterAxisColor";
    public static final String PROP_ADJUSTERAXISIMAGE = "adjusterAxisImage";
    protected GridTrack m_GridTrack;
    protected ArrayList<GridArea> m_GridAreas_AdjusterInside;
    protected ControlObject.ControlDimension m_ControlDimension_Y;
    protected ControlObject.ControlDimension m_ControlDimension_X;

    public JControlGrid() {
        this.initMembers();
        this.initComponents();
        this.calculateInnerItems();
    }

    private void initMembers() {
        this.setName("JControlGrid");
        this.m_ControlDimension_X = super.createNewControlDimension();
        this.m_ControlDimension_X.setDimensionName("- X -");
        this.m_ControlDimension_X.setOrientation(0);
        this.m_ControlDimension_X.setTicksMajorLength(7);
        this.m_ControlDimension_X.setTicksMinorLength(3);
        this.m_ControlDimension_X.setTicksInsets(new Insets(0, 0, 18, 0));
        this.m_ControlDimension_X.setTicksAlignment(3);
        this.m_ControlDimension_X.setLabelsAlignment(3);
        this.m_ControlDimension_X.setBlocksAlignment(3);
        this.m_ControlDimension_Y = super.createNewControlDimension();
        this.m_ControlDimension_Y.setDimensionName("- Y -");
        this.m_ControlDimension_Y.setOrientation(1);
        this.m_ControlDimension_Y.getControlBlocks().setBlocksTextRotation(-90.0);
        this.m_ControlDimension_Y.setTicksAlignment(2);
        this.m_ControlDimension_Y.setLabelsAlignment(2);
        this.m_ControlDimension_Y.setBlocksAlignment(2);
        this.m_ControlDimension_Y.setLabelsMirrored(true);
        this.m_ControlDimension_Y.setTicksMajorLength(7);
        this.m_ControlDimension_Y.setTicksMinorLength(3);
        this.m_ControlDimension_Y.setTicksInsets(new Insets(0, 18, 0, 0));
        this.m_GridTrack = new GridTrack(this);
        this.m_ControlDimension_Y.setValue(this.m_ControlDimension_Y.getValueMinimum(), 0.0, 0);
        this.m_ControlDimension_X.setValue(this.m_ControlDimension_X.getValueMinimum(), 0.0, 0);
        this.setPreferredSize(new Dimension(170, 170));
        this.setBackground(Color.WHITE);
        this.m_GridAreas_AdjusterInside = new ArrayList();
    }

    private Object readResolve() {
        this.m_ControlDimension_X = this.getControlDimension(0);
        this.m_ControlDimension_Y = this.getControlDimension(1);
        this.m_ControlDimension_Y.setValue(this.m_ControlDimension_Y.getValueMinimum(), 0.0, 0);
        this.m_ControlDimension_X.setValue(this.m_ControlDimension_X.getValueMinimum(), 0.0, 0);
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
        super.writeExternal(p_ObjectOutput);
        this.m_ControlDimension_X.writeExternal(p_ObjectOutput);
        this.m_ControlDimension_Y.writeExternal(p_ObjectOutput);
        this.m_GridTrack.writeExternal(p_ObjectOutput);
    }

    @Override
    public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
        super.readExternal(p_ObjectInput);
        this.m_ControlDimension_X.readExternal(p_ObjectInput);
        this.m_ControlDimension_Y.readExternal(p_ObjectInput);
        this.m_GridTrack.readExternal(p_ObjectInput);
        this.calculateInnerItems();
    }

    private void initComponents() {
        this.add(this.m_GridTrack, this.m_GridTrack.getConstraints(), 0);
        MouseWheelListener[] o_MouseWheelListeners = this.getMouseWheelListeners();
        for (int intListener = o_MouseWheelListeners.length - 1; intListener >= 0; --intListener) {
            this.removeMouseWheelListener(o_MouseWheelListeners[intListener]);
        }
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                double doubleNewValueY;
                double doubleNewValueX;
                if (JControlGrid.this.m_ActiveDimension == null) {
                    return;
                }
                double doubleValue = JControlGrid.this.m_ActiveDimension.getValue();
                double doubleJump = JControlGrid.this.m_ActiveDimension.getMouseWheelStep();
                if (JControlGrid.this.m_ActiveDimension.getSnapDistance() > doubleJump) {
                    doubleJump = JControlGrid.this.m_ActiveDimension.getSnapDistance();
                }
                if (JControlGrid.this.m_ActiveDimension.getValueMaximum() - JControlGrid.this.m_ActiveDimension.getValueMinimum() < doubleJump) {
                    doubleJump = (JControlGrid.this.m_ActiveDimension.getValueMaximum() - JControlGrid.this.m_ActiveDimension.getValueMinimum()) / 3.0;
                }
                doubleValue = !JControlGrid.this.m_ActiveDimension.getInverted() ? (doubleValue -= (double)e.getWheelRotation() * doubleJump) : (doubleValue += (double)e.getWheelRotation() * doubleJump);
                double doubleValueDiff = doubleValue - JControlGrid.this.m_ActiveDimension.getValue();
                if (JControlGrid.this.m_ActiveDimension == JControlGrid.this.m_ControlDimension_X) {
                    doubleNewValueX = doubleValue;
                    doubleNewValueY = JControlGrid.this.m_ControlDimension_Y.getValue();
                } else {
                    doubleNewValueX = JControlGrid.this.m_ControlDimension_X.getValue();
                    doubleNewValueY = doubleValue;
                }
                JControlGrid.this.setMousePressed(true);
                JControlGrid.this.setValues(doubleNewValueX, doubleNewValueX - JControlGrid.this.m_ControlDimension_X.getValue(), doubleNewValueY, doubleNewValueY - JControlGrid.this.m_ControlDimension_Y.getValue(), 8);
                JControlGrid.this.setMousePressed(false);
            }
        });
        this.setVisible(true);
    }

    @Override
    public void setToolTipText(String p_ToolTipText) {
        super.setToolTipText(p_ToolTipText);
        if (this.m_GridTrack == null) {
            return;
        }
        this.m_GridTrack.setToolTipText(p_ToolTipText);
        this.m_GridTrack.getAdjuster().setToolTipText(p_ToolTipText);
    }

    @Override
    public void setForeground(Color p_Color) {
        this.m_GridTrack.setForeground(p_Color);
        super.setForeground(p_Color);
    }

    @Override
    public ControlObject.ControlDimension getControlDimension(int p_DimensionIndex) {
        switch (p_DimensionIndex) {
            case 0: {
                return this.m_ControlDimension_X;
            }
            case 1: {
                return this.m_ControlDimension_Y;
            }
        }
        return null;
    }

    public void setValues(double p_X, double p_DiffX, double p_Y, double p_DiffY, int p_ActionFlag) {
        if (p_ActionFlag == 2 || p_ActionFlag == 4 || p_ActionFlag == 8) {
            double doubleNewValueX = p_X;
            double doubleNewValueY = p_Y;
            Point2D o_RestrictedPoint = this.m_GridTrack.checkValuesInAreas(doubleNewValueX, doubleNewValueY);
            if (o_RestrictedPoint != null) {
                doubleNewValueX = o_RestrictedPoint.getX();
                doubleNewValueY = o_RestrictedPoint.getY();
            }
            this.m_ControlDimension_Y.setValueWithoutGroups(doubleNewValueY, p_DiffY, p_ActionFlag);
            this.m_ControlDimension_X.setValueWithoutGroups(doubleNewValueX, p_DiffX, p_ActionFlag);
            for (int intGroup = 0; intGroup < this.getControlGroupCount(); ++intGroup) {
                ControlGroup o_ControlGroup = this.getControlGroup(intGroup);
                if (o_ControlGroup == null) continue;
                o_ControlGroup.setGroupValuesGrid(this, doubleNewValueX, doubleNewValueY);
            }
            this.setValueManuallyIsReady();
        } else {
            this.m_ControlDimension_X.setValue(p_X, p_DiffX, p_ActionFlag);
            this.m_ControlDimension_Y.setValue(p_Y, p_DiffY, p_ActionFlag);
        }
    }

    @Override
    public double[] getValuesFromInnerComponentPosition(JComponent p_Component, int p_X, int p_Y) {
        return this.getValuesFromTrackPosition(p_X - this.m_GridTrack.getX() + p_Component.getX(), p_Y - this.m_GridTrack.getY() + p_Component.getY());
    }

    @Override
    public double[] getValuesFromComponentPosition(int p_X, int p_Y) {
        return this.getValuesFromTrackPosition(p_X - this.m_GridTrack.getX(), p_Y - this.m_GridTrack.getY());
    }

    public double[] getValuesFromTrackPosition(int p_X, int p_Y) {
        int intLength = 1;
        int intPosition = 0;
        int intOffset = 0;
        double[] doubleResults = new double[this.m_ControlDimensions.size()];
        if (this.m_ControlDimension_Y.getOrientation() == 1) {
            intLength = this.m_GridTrack.getSize().height;
            intPosition = p_Y - intOffset;
            if (!this.m_ControlDimension_Y.getInverted()) {
                intPosition = intLength - intPosition;
            }
        } else {
            intLength = this.m_GridTrack.getSize().width;
            intPosition = p_X - intOffset;
            if (this.m_ControlDimension_Y.getInverted()) {
                intPosition = intLength - intPosition;
            }
        }
        int intDimensionIndex = this.m_ControlDimensions.indexOf(this.m_ControlDimension_Y);
        doubleResults[intDimensionIndex] = this.m_ControlDimension_Y.getValueMinimum() + (double)intPosition / (double)intLength * (this.m_ControlDimension_Y.getValueMaximum() - this.m_ControlDimension_Y.getValueMinimum());
        if (this.m_ControlDimension_X.getOrientation() == 1) {
            intLength = this.m_GridTrack.getSize().height;
            intPosition = p_Y - intOffset;
            if (!this.m_ControlDimension_X.getInverted()) {
                intPosition = intLength - intPosition;
            }
        } else {
            intLength = this.m_GridTrack.getSize().width;
            intPosition = p_X - intOffset;
            if (this.m_ControlDimension_X.getInverted()) {
                intPosition = intLength - intPosition;
            }
        }
        intDimensionIndex = this.m_ControlDimensions.indexOf(this.m_ControlDimension_X);
        doubleResults[intDimensionIndex] = this.m_ControlDimension_X.getValueMinimum() + (double)intPosition / (double)intLength * (this.m_ControlDimension_X.getValueMaximum() - this.m_ControlDimension_X.getValueMinimum());
        return doubleResults;
    }

    public Point2D checkValuesInAreas(double p_X, double p_Y) {
        if (this.m_GridTrack == null) {
            return null;
        }
        return this.m_GridTrack.checkValuesInAreas(p_X, p_Y);
    }

    @Override
    public void setJarResources(JarResources p_JarResources) {
        JarResources oldValue = this.m_Resources;
        this.m_Resources = p_JarResources;
        if (this.m_Resources != null) {
            byte[] o_Bytes = this.m_Resources.getResource("LiveShowControls/ControlGridAdjusterImage");
            Image o_Image = null;
            if (o_Bytes != null) {
                try {
                    o_Image = Toolkit.getDefaultToolkit().createImage(o_Bytes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setAdjusterImage(o_Image);
            o_Bytes = this.m_Resources.getResource("LiveShowControls/ControlGridAdjusterAxisImage");
            o_Image = null;
            if (o_Bytes != null) {
                try {
                    o_Image = Toolkit.getDefaultToolkit().createImage(o_Bytes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setAdjusterAxisXImage(o_Image);
            this.setAdjusterAxisYImage(o_Image);
            o_Bytes = this.m_Resources.getResource("LiveShowControls/ControlGridBackground");
            o_Image = null;
            if (o_Bytes != null) {
                try {
                    o_Image = Toolkit.getDefaultToolkit().createImage(o_Bytes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setBackgroundImage(o_Image);
            JarClassLoader o_JarClassLoader = this.m_Resources.getJarClassLoader();
            if (o_JarClassLoader != null) {
                try {
                    Class o_Class = o_JarClassLoader.loadClass("LiveShowControls.Colors");
                    Field o_Field = o_Class.getDeclaredField("Control_Foreground");
                    Color o_Color = (Color)o_Field.get(o_Class);
                    this.setForeground(o_Color);
                    o_Field = o_Class.getDeclaredField("Control_Background");
                    o_Color = (Color)o_Field.get(o_Class);
                    this.setBackground(o_Color);
                }
                catch (Exception e) {
                    e.getMessage();
                }
            }
        } else {
            this.setAdjusterImage(null);
            this.setAdjusterAxisXImage(null);
            this.setAdjusterAxisYImage(null);
            this.setBackgroundImage(null);
        }
        this.firePropertyChange("jarResources", oldValue, this.m_Resources);
        this.revalidate();
        this.repaint();
    }

    public void setMouseMoveFactor(double p_MouseMoveFactor) {
        this.m_ControlDimension_X.setMouseMoveFactor(p_MouseMoveFactor);
        this.m_ControlDimension_Y.setMouseMoveFactor(p_MouseMoveFactor);
    }

    public GridTrack getGridTrack() {
        return this.m_GridTrack;
    }

    public Insets getTrackInsets() {
        return this.m_GridTrack.getTrackInsets();
    }

    public void setTrackInsets(Insets p_Insets) {
        this.m_GridTrack.setTrackInsets(p_Insets);
    }

    public void setTrackInsets(int p_Top, int p_Left, int p_Bottom, int p_Right) {
        this.m_GridTrack.setTrackInsets(p_Top, p_Left, p_Bottom, p_Right);
    }

    public boolean getTrackOpaque() {
        return this.m_GridTrack.m_TrackOpaque;
    }

    public void setTrackOpaque(boolean p_TrackOpaque) {
        this.m_GridTrack.setTrackOpaque(p_TrackOpaque);
    }

    public boolean getTrackGridVisible() {
        return this.m_GridTrack.getTrackGridVisible();
    }

    public void setTrackGridVisible(boolean p_Visible) {
        this.m_GridTrack.setTrackGridVisible(p_Visible);
    }

    @Override
    public void calculateDisplayItem(ControlObject.ControlDisplayItem p_ControlDisplayItem) {
    }

    public GridPoint addGridPoint(double p_ValueHorizontal, double p_ValueVertical, Color p_Color) {
        if (this.m_GridTrack != null) {
            return this.m_GridTrack.addGridPoint(p_ValueHorizontal, p_ValueVertical, p_Color);
        }
        return null;
    }

    public void removeGridPoint(GridPoint p_GridPoint) {
        if (this.m_GridTrack != null) {
            this.m_GridTrack.removeGridPoint(p_GridPoint);
        }
    }

    public GridArea addGridArea(int p_SortID, String p_Text, Color p_Color, ArrayList<GridPoint> p_GridPoints, ArrayList<GridPoint> p_GridPointsMiddle, Object p_AreaObject) {
        if (this.m_GridTrack != null) {
            return this.m_GridTrack.addGridArea(p_SortID, p_Text, p_Color, p_GridPoints, p_GridPointsMiddle, p_AreaObject);
        }
        return null;
    }

    public void addGridArea(GridArea p_GridArea) {
        if (this.m_GridTrack != null) {
            this.m_GridTrack.addGridArea(p_GridArea);
        }
    }

    public void removeGridArea(GridArea p_GridArea) {
        if (this.m_GridTrack != null) {
            this.m_GridTrack.removeGridArea(p_GridArea);
        }
    }

    public int getGridAreaCount() {
        if (this.m_GridTrack == null) {
            return 0;
        }
        return this.m_GridTrack.getGridAreaCount();
    }

    public GridArea getGridArea(int p_Index) {
        if (this.m_GridTrack == null) {
            return null;
        }
        return this.m_GridTrack.getGridArea(p_Index);
    }

    public GridArea getGridAreaBySortID(int p_SortID) {
        if (this.m_GridTrack == null) {
            return null;
        }
        return this.m_GridTrack.getGridAreaBySortID(p_SortID);
    }

    public void addRestrictedGridArea(GridArea p_GridArea) {
        if (this.m_GridTrack != null) {
            this.m_GridTrack.addRestrictedGridArea(p_GridArea);
        }
    }

    public void removeRestrictedGridArea(GridArea p_GridArea) {
        if (this.m_GridTrack != null) {
            this.m_GridTrack.removeRestrictedGridArea(p_GridArea);
        }
    }

    public boolean containsRestrictedGridArea(GridArea p_GridArea) {
        if (this.m_GridTrack != null) {
            return this.m_GridTrack.containsRestrictedGridArea(p_GridArea);
        }
        return false;
    }

    public int getRestrictedGridAreaCount() {
        if (this.m_GridTrack != null) {
            return this.m_GridTrack.getRestrctedGridAreaCount();
        }
        return 0;
    }

    public GridArea getRestricteGridArea(int p_Indes) {
        if (this.m_GridTrack != null) {
            return this.m_GridTrack.getRestrictedGridArea(p_Indes);
        }
        return null;
    }

    public GridArea getRestricteGridAreaBySortID(int p_SortID) {
        if (this.m_GridTrack != null) {
            return this.m_GridTrack.getRestrictedGridAreaBySortID(p_SortID);
        }
        return null;
    }

    public ArrayList<GridArea> getGridAreas_AdjusterInside() {
        if (this.m_GridTrack == null) {
            return null;
        }
        this.m_GridAreas_AdjusterInside.clear();
        this.m_GridAreas_AdjusterInside.addAll(this.m_GridTrack.getGridAreas_AdjusterInside());
        return this.m_GridAreas_AdjusterInside;
    }

    public int getGrid_Area_AdjusterInsideCount() {
        if (this.m_GridTrack == null) {
            return 0;
        }
        return this.m_GridTrack.getGridArea_AdjusterInsideCount();
    }

    public GridArea getGridArea_AdjusterInside(int p_Index) {
        if (this.m_GridTrack == null) {
            return null;
        }
        return this.m_GridTrack.getGridArea(p_Index);
    }

    public ArrayList<GridArea> getGridAreas(double p_ValueX, double p_ValueY) {
        if (this.m_GridTrack == null) {
            return null;
        }
        return this.m_GridTrack.getGridAreas_Inside(p_ValueX, p_ValueY);
    }

    public ArrayList<GridArea> getGridAreasWithIntersection(double p_ValueX, double p_ValueY) {
        if (this.m_GridTrack == null) {
            return null;
        }
        return this.m_GridTrack.getGridAreas_InsideWithIntersection(p_ValueX, p_ValueY);
    }

    public void setGridAreas_AdjusterInsidefromOtherControl(ArrayList<GridArea> p_GridAreas) {
        if (this.m_GridTrack == null) {
            return;
        }
        this.m_GridTrack.clearGridAreas_AdjusterInside();
        if (p_GridAreas == null || p_GridAreas.size() <= 0) {
            return;
        }
        for (int intGridArea = 0; intGridArea < p_GridAreas.size(); ++intGridArea) {
            GridArea o_GridAreaAnotherControlGrid = p_GridAreas.get(intGridArea);
            int intSortID = o_GridAreaAnotherControlGrid.getSortID();
            GridArea o_GridAreaSelf = this.getGridAreaBySortID(intSortID);
            if (o_GridAreaSelf == null) continue;
            this.m_GridTrack.addGridArea_AdjusterInside(o_GridAreaSelf);
        }
    }

    public int getAdjusterLength() {
        return this.m_GridTrack.getAdjuster().getAdjusterLength();
    }

    public void setAdjusterLength(int p_AdjusterLength) {
        this.m_GridTrack.getAdjuster().setAdjusterLength(p_AdjusterLength);
        this.calculateInnerItems();
    }

    public Image getAdjusterImage() {
        return this.m_GridTrack.getAdjuster().getAdjusterImage();
    }

    public void setAdjusterImage(Image p_AdjusterImage) {
        this.m_GridTrack.getAdjuster().setAdjusterImage(p_AdjusterImage);
    }

    public Color getAdjusterColor() {
        return this.m_GridTrack.getAdjuster().getAdjusterColor();
    }

    public void setAdjusterColor(Color p_AdjusterColor) {
        this.m_GridTrack.getAdjuster().setAdjusterColor(p_AdjusterColor);
    }

    public boolean getAdjusterAxisXVisible() {
        return this.m_GridTrack.getAdjusterAxis_X().isVisible();
    }

    public void setAdjusterAxisXVisible(boolean p_Visible) {
        this.m_GridTrack.getAdjusterAxis_X().setVisible(p_Visible);
    }

    public int getAdjusterAxisXLength() {
        return this.m_GridTrack.getAdjusterAxis_X().getAdjusterLength();
    }

    public void setAdjusterAxisXLength(int p_AdjusterLength) {
        this.m_GridTrack.getAdjusterAxis_X().setAdjusterLength(p_AdjusterLength);
        this.calculateInnerItems();
    }

    public Image getAdjusterAxisXImage() {
        return this.m_GridTrack.getAdjusterAxis_X().getAdjusterImage();
    }

    public void setAdjusterAxisXImage(Image p_AdjusterImage) {
        this.m_GridTrack.getAdjusterAxis_X().setAdjusterImage(p_AdjusterImage);
    }

    public Color getAdjusterAxisXColor() {
        return this.m_GridTrack.getAdjusterAxis_X().getAdjusterColor();
    }

    public void setAdjusterAxisXColor(Color p_AdjusterColor) {
        this.m_GridTrack.getAdjusterAxis_X().setAdjusterColor(p_AdjusterColor);
    }

    public boolean getAdjusterAxisYVisible() {
        return this.m_GridTrack.getAdjusterAxis_Y().isVisible();
    }

    public void setAdjusterAxisYVisible(boolean p_Visible) {
        this.m_GridTrack.getAdjusterAxis_Y().setVisible(p_Visible);
    }

    public int getAdjusterAxisYLength() {
        return this.m_GridTrack.getAdjusterAxis_Y().getAdjusterLength();
    }

    public void setAdjusterAxisYLength(int p_AdjusterLength) {
        this.m_GridTrack.getAdjusterAxis_Y().setAdjusterLength(p_AdjusterLength);
        this.calculateInnerItems();
    }

    public Image getAdjusterAxisYImage() {
        return this.m_GridTrack.getAdjusterAxis_Y().getAdjusterImage();
    }

    public void setAdjusterAxisYImage(Image p_AdjusterImage) {
        this.m_GridTrack.getAdjusterAxis_Y().setAdjusterImage(p_AdjusterImage);
    }

    public Color getAdjusterAxisYColor() {
        return this.m_GridTrack.getAdjusterAxis_Y().getAdjusterColor();
    }

    public void setAdjusterAxisYColor(Color p_AdjusterColor) {
        this.m_GridTrack.getAdjusterAxis_Y().setAdjusterColor(p_AdjusterColor);
    }

    @Override
    public void calculateInnerItems() {
        if (this.m_GridTrack == null) {
            return;
        }
        Rectangle o_ThisRectangle = this.getBounds();
        Insets o_TrackInsets = this.m_GridTrack.getTrackInsets();
        AbsoluteConstraints o_TrackConstraints = this.m_GridTrack.getConstraints();
        int intWidth = o_ThisRectangle.width - o_TrackInsets.left - o_TrackInsets.right + 1;
        int intHight = o_ThisRectangle.height - o_TrackInsets.top - o_TrackInsets.bottom + 1;
        if (intWidth < intHight) {
            o_TrackConstraints.width = intWidth;
            o_TrackConstraints.height = intWidth;
        } else {
            o_TrackConstraints.width = intHight;
            o_TrackConstraints.height = intHight;
        }
        o_TrackConstraints.x = o_TrackInsets.left;
        o_TrackConstraints.y = o_TrackInsets.top;
        this.calculateAdjuster();
        this.calculateGridPoints();
        this.m_ControlDimension_Y.calculateDisplayItems();
        this.m_ControlDimension_Y.getControlTicks().calculate();
        this.m_ControlDimension_Y.recalculateControlLabels();
        this.m_ControlDimension_Y.getControlBlocks().calculate();
        this.m_ControlDimension_Y.getControlLabels().calculate();
        this.m_ControlDimension_X.calculateDisplayItems();
        this.m_ControlDimension_X.getControlTicks().calculate();
        this.m_ControlDimension_X.recalculateControlLabels();
        this.m_ControlDimension_X.getControlBlocks().calculate();
        this.m_ControlDimension_X.getControlLabels().calculate();
    }

    @Override
    public double calculatePixelPerValueLabel(ControlObject.ControlDimension p_ControlDimension) {
        if (p_ControlDimension == null) {
            return -1.0;
        }
        AbsoluteConstraints o_TrackConstraints = this.m_GridTrack.getConstraints();
        int intValueLength = p_ControlDimension.getOrientation() == 1 ? o_TrackConstraints.getHeight() - 1 : o_TrackConstraints.getWidth() - 1;
        double doublePixelPerValue = (double)intValueLength / (p_ControlDimension.getValueMaximum() - p_ControlDimension.getValueMinimum());
        return doublePixelPerValue;
    }

    @Override
    public void calculateAdjuster() {
        if (this.m_GridTrack != null) {
            this.m_GridTrack.calculateAdjuster();
        }
        this.m_ControlDimension_X.setValueAdjusted(this.m_ControlDimension_X.getValue());
        this.m_ControlDimension_Y.setValueAdjusted(this.m_ControlDimension_Y.getValue());
    }

    public void calculateGridPoints() {
        if (this.m_GridTrack != null) {
            this.m_GridTrack.calculateGridPoints();
        }
    }

    @Override
    public void calculateTicks(ControlObject.ControlTicks p_Ticks) {
        Rectangle o_ThisRectangle = this.getBounds();
        if (p_Ticks == null) {
            return;
        }
        Insets o_TicksInsets = p_Ticks.getTicksInsets();
        AbsoluteConstraints o_TicksConstraints = p_Ticks.getConstraints();
        o_TicksConstraints.width = o_ThisRectangle.width - o_TicksInsets.left - o_TicksInsets.right;
        o_TicksConstraints.height = o_ThisRectangle.height - o_TicksInsets.top - o_TicksInsets.bottom;
        o_TicksConstraints.x = o_TicksInsets.left;
        o_TicksConstraints.y = o_TicksInsets.top;
        p_Ticks.revalidate();
    }

    @Override
    public void paintTicks(Graphics p_Graphics, ControlObject.ControlTicks p_Ticks) {
        int intTrackValuePos;
        double doubleValue;
        int intPixelWide;
        int intTickLength;
        int intTickStart;
        double doubleJump;
        int intPassCount;
        int intValueLength;
        int intOffset;
        if (p_Ticks == null) {
            return;
        }
        if (p_Ticks.getTicksMajor() <= 0.0 && p_Ticks.getTicksMinor() <= 0.0) {
            return;
        }
        if (p_Ticks == null) {
            return;
        }
        ControlObject.ControlDimension o_ControlDimension = p_Ticks.getControlDimension();
        AbsoluteConstraints o_TrackConstraints = this.m_GridTrack.getConstraints();
        AbsoluteConstraints o_TicksConstraints = p_Ticks.getConstraints();
        if (o_ControlDimension.getOrientation() == 1) {
            intOffset = o_TrackConstraints.getY() - o_TicksConstraints.getY();
            intValueLength = o_TrackConstraints.getHeight() - 1;
        } else {
            intOffset = o_TrackConstraints.getX() - o_TicksConstraints.getX();
            intValueLength = o_TrackConstraints.getWidth() - 1;
        }
        if (intValueLength <= 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)p_Graphics.create();
        g2d.setColor(this.getForeground());
        double doubleDistance = this.calculatePixelPerValueLabel(o_ControlDimension);
        int intTickLongest = p_Ticks.getTicksMajorLength() > p_Ticks.getTicksMinorLength() ? p_Ticks.getTicksMajorLength() : p_Ticks.getTicksMinorLength();
        if (p_Ticks.getTicksMajor() > 0.0 && p_Ticks.getTicksMajorLength() > 0) {
            intPassCount = 1;
            if (doubleDistance * p_Ticks.getTicksMajor() < 7.0) {
                intPassCount = (int)(7.0 / (doubleDistance * p_Ticks.getTicksMajor()) + 1.0);
            }
            doubleJump = p_Ticks.getTicksMajor() * (double)intPassCount;
            p_Ticks.setTicksMajorPassCount(intPassCount);
            intTickStart = 0;
            intTickLength = p_Ticks.getTicksMajorLength();
            intPixelWide = o_ControlDimension.getOrientation() == 1 ? o_TicksConstraints.getWidth() : o_TicksConstraints.getHeight();
            intTickStart = p_Ticks.getTicksAlignment() == 2 || p_Ticks.getTicksAlignment() == 1 ? (p_Ticks.getTicksMirrored() ? 0 : intTickLongest - intTickLength) : (p_Ticks.getTicksAlignment() == 4 || p_Ticks.getTicksAlignment() == 3 ? (p_Ticks.getTicksMirrored() ? intPixelWide - intTickLength : intPixelWide - intTickLongest) : (intPixelWide - intTickLength) / 2);
            for (doubleValue = o_ControlDimension.getValueMinimum(); doubleValue <= o_ControlDimension.getValueMaximum(); doubleValue += doubleJump) {
                intTrackValuePos = (int)(doubleDistance * (doubleValue - o_ControlDimension.getValueMinimum()));
                if (o_ControlDimension.getOrientation() == 1) {
                    if (!o_ControlDimension.getInverted()) {
                        intTrackValuePos = intValueLength - intTrackValuePos;
                    }
                    g2d.drawLine(intTickStart, intTrackValuePos + intOffset, intTickStart + intTickLength, intTrackValuePos + intOffset);
                    continue;
                }
                if (o_ControlDimension.getInverted()) {
                    intTrackValuePos = intValueLength - intTrackValuePos;
                }
                g2d.drawLine(intTrackValuePos + intOffset, intTickStart, intTrackValuePos + intOffset, intTickStart + intTickLength);
            }
        }
        if (p_Ticks.getTicksMinor() > 0.0 && p_Ticks.getTicksMinorLength() > 0) {
            intPassCount = 1;
            if (doubleDistance * p_Ticks.getTicksMinor() < 5.0) {
                intPassCount = (int)(5.0 / (doubleDistance * p_Ticks.getTicksMinor()) + 1.0);
            }
            doubleJump = p_Ticks.getTicksMinor() * (double)intPassCount;
            intTickStart = 0;
            intTickLength = p_Ticks.getTicksMinorLength();
            intPixelWide = o_ControlDimension.getOrientation() == 1 ? o_TicksConstraints.getWidth() : o_TicksConstraints.getHeight();
            intTickStart = p_Ticks.getTicksAlignment() == 2 || p_Ticks.getTicksAlignment() == 1 ? (p_Ticks.getTicksMirrored() ? 0 : intTickLongest - intTickLength) : (p_Ticks.getTicksAlignment() == 4 || p_Ticks.getTicksAlignment() == 3 ? (p_Ticks.getTicksMirrored() ? intPixelWide - intTickLength : intPixelWide - intTickLongest) : (intPixelWide - intTickLength) / 2);
            for (doubleValue = o_ControlDimension.getValueMinimum(); doubleValue <= o_ControlDimension.getValueMaximum(); doubleValue += doubleJump) {
                intTrackValuePos = (int)(doubleDistance * (doubleValue - o_ControlDimension.getValueMinimum()));
                if (o_ControlDimension.getOrientation() == 1) {
                    if (!o_ControlDimension.getInverted()) {
                        intTrackValuePos = intValueLength - intTrackValuePos;
                    }
                    g2d.drawLine(intTickStart, intTrackValuePos + intOffset, intTickStart + intTickLength, intTrackValuePos + intOffset);
                    continue;
                }
                if (o_ControlDimension.getInverted()) {
                    intTrackValuePos = intValueLength - intTrackValuePos;
                }
                g2d.drawLine(intTrackValuePos + intOffset, intTickStart, intTrackValuePos + intOffset, intTickStart + intTickLength);
            }
        }
        g2d.dispose();
    }

    @Override
    public void calculateLabels(ControlObject.ControlLabels p_Labels) {
        double doubleDistance;
        int intValueLength;
        int intOffset;
        if (p_Labels == null) {
            return;
        }
        if (this.m_GridTrack == null) {
            return;
        }
        Rectangle o_ThisRectangle = this.getBounds();
        ControlObject.ControlDimension o_ControlDimension = p_Labels.getControlDimension();
        Insets o_LabelsInsets = p_Labels.getLabelsInsets();
        AbsoluteConstraints o_LabelsConstraints = p_Labels.getConstraints();
        o_LabelsConstraints.width = o_ThisRectangle.width - o_LabelsInsets.left - o_LabelsInsets.right;
        o_LabelsConstraints.height = o_ThisRectangle.height - o_LabelsInsets.top - o_LabelsInsets.bottom;
        o_LabelsConstraints.x = o_LabelsInsets.left;
        o_LabelsConstraints.y = o_LabelsInsets.top;
        AbsoluteConstraints o_TrackConstraints = this.m_GridTrack.getConstraints();
        double doubleLabelFactor1 = 1.0;
        double doubleLabelFactor2 = 1.0;
        double doubleLabelFactor = 1.0;
        if (o_ControlDimension.getOrientation() == 1) {
            intOffset = o_TrackConstraints.getY() - o_LabelsConstraints.y;
            intValueLength = o_TrackConstraints.getHeight();
            doubleDistance = (double)intValueLength / (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum());
            doubleLabelFactor1 = (double)o_LabelsConstraints.width / (double)p_Labels.getLabelsSize().width;
            doubleLabelFactor2 = p_Labels.getMinimalLabelsDistance() * doubleDistance / (double)p_Labels.getLabelsSize().height;
        } else {
            intOffset = o_TrackConstraints.getX() - o_LabelsConstraints.x;
            intValueLength = o_TrackConstraints.getWidth();
            doubleDistance = (double)intValueLength / (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum());
            doubleLabelFactor1 = (double)o_LabelsConstraints.height / (double)p_Labels.getLabelsSize().height;
            doubleLabelFactor2 = p_Labels.getMinimalLabelsDistance() * doubleDistance / (double)p_Labels.getLabelsSize().width;
        }
        if (doubleLabelFactor2 <= 0.0) {
            doubleLabelFactor2 = doubleLabelFactor1;
        }
        if (!p_Labels.getLabelsSizeFixed()) {
            doubleLabelFactor = doubleLabelFactor1 < doubleLabelFactor2 ? doubleLabelFactor1 : doubleLabelFactor2;
            if (doubleLabelFactor > 1.0) {
                doubleLabelFactor = 1.0;
            }
        } else {
            doubleLabelFactor = 1.0;
        }
        for (int intLabel = 0; intLabel < p_Labels.getControlLabelsCount(); ++intLabel) {
            int intLabelStart;
            ControlObject.ControlLabels.ControlLabel o_ControlLabel = p_Labels.getControlLabel(intLabel);
            if (o_ControlLabel == null) continue;
            AbsoluteConstraints o_LabelConstraints = o_ControlLabel.getConstraints();
            int intLabelPos = (int)(doubleDistance * (o_ControlLabel.getControlLabelDescription().getValueDefault() - o_ControlDimension.getValueMinimum()));
            o_LabelConstraints.width = (int)((double)p_Labels.getLabelsSize().width * doubleLabelFactor);
            o_LabelConstraints.height = (int)((double)p_Labels.getLabelsSize().height * doubleLabelFactor);
            if (o_ControlDimension.getOrientation() == 1) {
                if (!o_ControlDimension.getInverted()) {
                    intLabelPos = intValueLength - intLabelPos;
                }
                intLabelPos -= o_LabelConstraints.height / 2;
                if (p_Labels.getLabelsAlignment() == 2 || p_Labels.getLabelsAlignment() == 1) {
                    intLabelStart = 0;
                    if (!p_Labels.getLabelsMirrored()) {
                        o_ControlLabel.setHorizontalAlignment(2);
                    } else {
                        o_ControlLabel.setHorizontalAlignment(4);
                    }
                    o_ControlLabel.setVerticalAlignment(0);
                } else if (p_Labels.getLabelsAlignment() == 4 || p_Labels.getLabelsAlignment() == 3) {
                    intLabelStart = o_LabelsConstraints.width - o_LabelConstraints.width;
                    if (!p_Labels.getLabelsMirrored()) {
                        o_ControlLabel.setHorizontalAlignment(4);
                    } else {
                        o_ControlLabel.setHorizontalAlignment(2);
                    }
                    o_ControlLabel.setVerticalAlignment(0);
                } else {
                    intLabelStart = o_LabelsConstraints.width / 2 - o_LabelConstraints.width / 2;
                    o_ControlLabel.setHorizontalAlignment(0);
                    o_ControlLabel.setVerticalAlignment(0);
                }
                o_LabelConstraints.x = intLabelStart;
                o_LabelConstraints.y = intLabelPos + intOffset;
                continue;
            }
            if (o_ControlDimension.getInverted()) {
                intLabelPos = intValueLength - intLabelPos;
            }
            intLabelPos -= o_LabelConstraints.width / 2;
            if (p_Labels.getLabelsAlignment() == 2 || p_Labels.getLabelsAlignment() == 1) {
                intLabelStart = 0;
                if (!p_Labels.getLabelsMirrored()) {
                    o_ControlLabel.setVerticalAlignment(1);
                } else {
                    o_ControlLabel.setVerticalAlignment(3);
                }
                o_ControlLabel.setHorizontalAlignment(0);
            } else if (p_Labels.getLabelsAlignment() == 4 || p_Labels.getLabelsAlignment() == 3) {
                intLabelStart = o_LabelsConstraints.height - o_LabelConstraints.height;
                if (!p_Labels.getLabelsMirrored()) {
                    o_ControlLabel.setVerticalAlignment(3);
                } else {
                    o_ControlLabel.setVerticalAlignment(1);
                }
                o_ControlLabel.setHorizontalAlignment(0);
            } else {
                intLabelStart = o_LabelsConstraints.height / 2 - o_LabelConstraints.height / 2;
                o_ControlLabel.setVerticalAlignment(0);
                o_ControlLabel.setHorizontalAlignment(0);
            }
            o_LabelConstraints.x = intLabelPos + intOffset;
            o_LabelConstraints.y = intLabelStart;
        }
        p_Labels.revalidate();
    }

    @Override
    public void paintLabels(Graphics p_Graphics, ControlObject.ControlLabels p_ControlLabels) {
    }

    @Override
    public void calculateBlocks(ControlObject.ControlBlocks p_Blocks) {
        double doubleDistance;
        int intValueLength;
        int intOffset;
        if (p_Blocks == null) {
            return;
        }
        if (this.m_GridTrack == null) {
            return;
        }
        Rectangle o_ThisRectangle = this.getBounds();
        ControlObject.ControlDimension o_ControlDimension = p_Blocks.getControlDimension();
        Insets o_BlocksInsets = p_Blocks.getBlocksInsets();
        AbsoluteConstraints o_BlocksConstraints = p_Blocks.getConstraints();
        o_BlocksConstraints.width = o_ThisRectangle.width - o_BlocksInsets.left - o_BlocksInsets.right;
        o_BlocksConstraints.height = o_ThisRectangle.height - o_BlocksInsets.top - o_BlocksInsets.bottom;
        o_BlocksConstraints.x = o_BlocksInsets.left;
        o_BlocksConstraints.y = o_BlocksInsets.top;
        AbsoluteConstraints o_TrackConstraints = this.m_GridTrack.getConstraints();
        double doubleBlockWidth = 0.0;
        double doubleBlockHeight = 0.0;
        if (o_ControlDimension.getOrientation() == 1) {
            intOffset = o_TrackConstraints.getY() - o_BlocksConstraints.y;
            intValueLength = o_TrackConstraints.getHeight();
            doubleDistance = (double)intValueLength / (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum());
            doubleBlockWidth = o_BlocksConstraints.width < p_Blocks.getBlocksSize().width ? (double)o_BlocksConstraints.width : (double)p_Blocks.getBlocksSize().width;
        } else {
            intOffset = o_TrackConstraints.getX() - o_BlocksConstraints.x;
            intValueLength = o_TrackConstraints.getWidth();
            doubleDistance = (double)intValueLength / (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum());
            doubleBlockHeight = o_BlocksConstraints.height < p_Blocks.getBlocksSize().height ? (double)o_BlocksConstraints.height : (double)p_Blocks.getBlocksSize().height;
        }
        int intStartPos = 0;
        int intEndPos = 0;
        for (int intBlock = 0; intBlock < p_Blocks.getControlBlocksCount(); ++intBlock) {
            int intLabelStart;
            ControlObject.ControlBlocks.ControlBlock o_ControlBlock = p_Blocks.getControlBlock(intBlock);
            if (o_ControlBlock == null) continue;
            AbsoluteConstraints o_BlockConstraints = o_ControlBlock.getConstraints();
            int intDefaultPos = (int)(doubleDistance * (o_ControlBlock.getControlBlockDescription().getValueDefault() - o_ControlDimension.getValueMinimum()));
            intStartPos = (int)(doubleDistance * (o_ControlBlock.getControlBlockDescription().getValueStart() - o_ControlDimension.getValueMinimum()));
            intEndPos = (int)(doubleDistance * (o_ControlBlock.getControlBlockDescription().getValueEnd() - o_ControlDimension.getValueMinimum()));
            o_BlockConstraints.width = (int)doubleBlockWidth;
            o_BlockConstraints.height = (int)doubleBlockHeight;
            if (o_ControlDimension.getOrientation() == 1) {
                if (!o_ControlDimension.getInverted()) {
                    intStartPos = intValueLength - intStartPos;
                    intEndPos = intValueLength - intEndPos;
                    intDefaultPos = intValueLength - intDefaultPos;
                    o_BlockConstraints.height = intStartPos - intEndPos;
                    o_BlockConstraints.y = intEndPos + intOffset;
                } else {
                    o_BlockConstraints.height = intEndPos - intStartPos;
                    o_BlockConstraints.y = intStartPos + intOffset;
                }
                if (p_Blocks.getBlocksAlignment() == 2 || p_Blocks.getBlocksAlignment() == 1) {
                    intLabelStart = 0;
                    if (!p_Blocks.getBlocksMirrored()) {
                        o_ControlBlock.setHorizontalAlignment(2);
                    } else {
                        o_ControlBlock.setHorizontalAlignment(4);
                    }
                    o_ControlBlock.setVerticalAlignment(0);
                } else if (p_Blocks.getBlocksAlignment() == 4 || p_Blocks.getBlocksAlignment() == 3) {
                    intLabelStart = o_BlocksConstraints.width - o_BlockConstraints.width;
                    if (!p_Blocks.getBlocksMirrored()) {
                        o_ControlBlock.setHorizontalAlignment(4);
                    } else {
                        o_ControlBlock.setHorizontalAlignment(2);
                    }
                    o_ControlBlock.setVerticalAlignment(0);
                } else {
                    intLabelStart = o_BlocksConstraints.width / 2 - o_BlockConstraints.width / 2;
                    o_ControlBlock.setHorizontalAlignment(0);
                    o_ControlBlock.setVerticalAlignment(0);
                }
                o_BlockConstraints.x = intLabelStart;
                continue;
            }
            if (o_ControlDimension.getInverted()) {
                intStartPos = intValueLength - intStartPos;
                intEndPos = intValueLength - intEndPos;
                intDefaultPos = intValueLength - intDefaultPos;
                o_BlockConstraints.width = intStartPos - intEndPos;
                o_BlockConstraints.x = intEndPos + intOffset;
            } else {
                o_BlockConstraints.width = intEndPos - intStartPos;
                o_BlockConstraints.x = intStartPos + intOffset;
            }
            if (p_Blocks.getBlocksAlignment() == 2 || p_Blocks.getBlocksAlignment() == 1) {
                intLabelStart = 0;
                if (!p_Blocks.getBlocksMirrored()) {
                    o_ControlBlock.setVerticalAlignment(1);
                } else {
                    o_ControlBlock.setVerticalAlignment(3);
                }
                o_ControlBlock.setHorizontalAlignment(0);
            } else if (p_Blocks.getBlocksAlignment() == 4 || p_Blocks.getBlocksAlignment() == 3) {
                intLabelStart = o_BlocksConstraints.height - o_BlockConstraints.height;
                if (!p_Blocks.getBlocksMirrored()) {
                    o_ControlBlock.setVerticalAlignment(3);
                } else {
                    o_ControlBlock.setVerticalAlignment(1);
                }
                o_ControlBlock.setHorizontalAlignment(0);
            } else {
                intLabelStart = o_BlocksConstraints.height / 2 - o_BlockConstraints.height / 2;
                o_ControlBlock.setVerticalAlignment(0);
                o_ControlBlock.setHorizontalAlignment(0);
            }
            o_BlockConstraints.y = intLabelStart;
        }
        p_Blocks.revalidate();
    }

    @Override
    public void paintBlocks(Graphics p_Graphics, ControlObject.ControlBlocks p_ControlBlocks) {
    }

    public ControlObject.ControlTicks getControlTicks_Y() {
        return this.m_ControlDimension_Y.getControlTicks();
    }

    public boolean getTicksVisible_Y() {
        return this.m_ControlDimension_Y.getTicksVisible();
    }

    public void setTicksVisible_Y(boolean p_TicksVisible) {
        this.m_ControlDimension_Y.setTicksVisible(p_TicksVisible);
    }

    public double getTicksMajor_Y() {
        return this.m_ControlDimension_Y.getTicksMajor();
    }

    public void setTicksMajor_Y(double p_TicksMajor) {
        this.m_ControlDimension_Y.setTicksMajor(p_TicksMajor);
    }

    public double getTicksMinor_Y() {
        return this.m_ControlDimension_Y.getTicksMinor();
    }

    public void setTicksMinor_Y(double p_TicksMinor) {
        this.m_ControlDimension_Y.setTicksMinor(p_TicksMinor);
    }

    public int getTicksAlignment_Y() {
        return this.m_ControlDimension_Y.getTicksAlignment();
    }

    public void setTicksAlignment_Y(int p_TicksAlignment) {
        this.m_ControlDimension_Y.setTicksAlignment(p_TicksAlignment);
    }

    public int getTicksMajorLength_Y() {
        return this.m_ControlDimension_Y.getTicksMajorLength();
    }

    public void setTicksMajorLength_Y(int p_TicksLength) {
        this.m_ControlDimension_Y.setTicksMajorLength(p_TicksLength);
    }

    public int getTicksMinorLength_Y() {
        return this.m_ControlDimension_Y.getTicksMinorLength();
    }

    public void setTicksMinorLength_Y(int p_TicksLength) {
        this.m_ControlDimension_Y.setTicksMinorLength(p_TicksLength);
    }

    public boolean getTicksMirrored_Y() {
        return this.m_ControlDimension_Y.getTicksMirrored();
    }

    public void setTicksMirrored_Y(boolean p_TicksMirrored) {
        this.m_ControlDimension_Y.setTicksMirrored(p_TicksMirrored);
    }

    public Insets getTicksInsets_Y() {
        return this.m_ControlDimension_Y.getTicksInsets();
    }

    public void setTicksInsets_Y(Insets p_TicksInsets) {
        this.m_ControlDimension_Y.setTicksInsets(p_TicksInsets);
    }

    public ControlObject.ControlTicks getControlTicks_X() {
        return this.m_ControlDimension_X.getControlTicks();
    }

    public boolean getTicksVisible_X() {
        return this.m_ControlDimension_X.getTicksVisible();
    }

    public void setTicksVisible_X(boolean p_TicksVisible) {
        this.m_ControlDimension_X.setTicksVisible(p_TicksVisible);
    }

    public double getTicksMajor_X() {
        return this.m_ControlDimension_X.getTicksMajor();
    }

    public void setTicksMajor_X(double p_TicksMajor) {
        this.m_ControlDimension_X.setTicksMajor(p_TicksMajor);
    }

    public double getTicksMinor_X() {
        return this.m_ControlDimension_X.getTicksMinor();
    }

    public void setTicksMinor_X(double p_TicksMinor) {
        this.m_ControlDimension_X.setTicksMinor(p_TicksMinor);
    }

    public int getTicksAlignment_X() {
        return this.m_ControlDimension_X.getTicksAlignment();
    }

    public void setTicksAlignment_X(int p_TicksAlignment) {
        this.m_ControlDimension_X.setTicksAlignment(p_TicksAlignment);
    }

    public int getTicksMajorLength_X() {
        return this.m_ControlDimension_X.getTicksMajorLength();
    }

    public void setTicksMajorLength_X(int p_TicksLength) {
        this.m_ControlDimension_X.setTicksMajorLength(p_TicksLength);
    }

    public int getTicksMinorLength_X() {
        return this.m_ControlDimension_X.getTicksMinorLength();
    }

    public void setTicksMinorLength_X(int p_TicksLength) {
        this.m_ControlDimension_X.setTicksMinorLength(p_TicksLength);
    }

    public boolean getTicksMirrored_X() {
        return this.m_ControlDimension_X.getTicksMirrored();
    }

    public void setTicksMirrored_X(boolean p_TicksMirrored) {
        this.m_ControlDimension_X.setTicksMirrored(p_TicksMirrored);
    }

    public Insets getTicksInsets_X() {
        return this.m_ControlDimension_X.getTicksInsets();
    }

    public void setTicksInsets_X(Insets p_TicksInsets) {
        this.m_ControlDimension_X.setTicksInsets(p_TicksInsets);
    }

    public boolean getLabelsAutomatic_Y() {
        return this.m_ControlDimension_Y.getLabelsAutomatic();
    }

    public void setLabelsAutomatic_Y(boolean p_LabelsAutomatic) {
        this.m_ControlDimension_Y.setLabelsAutomatic(p_LabelsAutomatic);
    }

    public boolean getLabelsVisible_Y() {
        return this.m_ControlDimension_Y.getLabelsVisible();
    }

    public void setLabelsVisible_Y(boolean p_LabelsVisible) {
        this.m_ControlDimension_Y.setLabelsVisible(p_LabelsVisible);
    }

    public Insets getLabelsInsets_Y() {
        return this.m_ControlDimension_Y.getLabelsInsets();
    }

    public void setLabelsInsets_Y(Insets p_LabelsInsets) {
        this.m_ControlDimension_Y.setLabelsInsets(p_LabelsInsets);
    }

    public int getLabelsAlignment_Y() {
        return this.m_ControlDimension_Y.getLabelsAlignment();
    }

    public void setLabelsAlignment_Y(int p_LabelsAlignment) {
        this.m_ControlDimension_Y.setLabelsAlignment(p_LabelsAlignment);
    }

    public boolean getLabelsMirrored_Y() {
        return this.m_ControlDimension_Y.getLabelsMirrored();
    }

    public void setLabelsMirrored_Y(boolean p_LabelsMirrored) {
        this.m_ControlDimension_Y.setLabelsMirrored(p_LabelsMirrored);
    }

    public Font getLabelsFont_Y() {
        return this.m_ControlDimension_Y.getLabelsFont();
    }

    public void setLabelsFont_Y(Font p_LabelsFont) {
        this.m_ControlDimension_Y.setLabelsFont(p_LabelsFont);
    }

    public void setLabelsTextRotation_Y(double p_Degree) {
        this.m_ControlDimension_Y.setLabelsTextRotation(p_Degree);
    }

    public Border getLabelsBorder_Y() {
        return this.m_ControlDimension_Y.getLabelsBorder();
    }

    public void setLabelsBorder_Y(Border p_LabelsBorder) {
        this.m_ControlDimension_Y.setLabelsBorder(p_LabelsBorder);
    }

    public ControlLabelModel getControlLabelModel_Y() {
        return this.m_ControlDimension_Y.getControlLabelModel();
    }

    public void setControlLabelModel_Y(ControlLabelModel p_ControlLabelModel) {
        this.m_ControlDimension_Y.setControlLabelModel(p_ControlLabelModel);
    }

    public Dimension getLabelsSize_Y() {
        return this.m_ControlDimension_Y.getLabelsSize();
    }

    public void setLabelsSize_Y(Dimension p_LabelsSize) {
        this.m_ControlDimension_Y.setLabelsSize(p_LabelsSize);
    }

    public void setLabelsSizeFixed_Y(boolean p_LabelsSizeFixed) {
        this.m_ControlDimension_Y.setLabelsSizeFixed(p_LabelsSizeFixed);
    }

    public boolean getLabelsSizeFixed_Y() {
        return this.m_ControlDimension_Y.getLabelsSizeFixed();
    }

    public boolean getLabelsAutomatic_X() {
        return this.m_ControlDimension_X.getLabelsAutomatic();
    }

    public void setLabelsAutomatic_X(boolean p_LabelsAutomatic) {
        this.m_ControlDimension_X.setLabelsAutomatic(p_LabelsAutomatic);
    }

    public boolean getLabelsVisible_X() {
        return this.m_ControlDimension_X.getLabelsVisible();
    }

    public void setLabelsVisible_X(boolean p_LabelsVisible) {
        this.m_ControlDimension_X.setLabelsVisible(p_LabelsVisible);
    }

    public Insets getLabelsInsets_X() {
        return this.m_ControlDimension_X.getLabelsInsets();
    }

    public void setLabelsInsets_X(Insets p_LabelsInsets) {
        this.m_ControlDimension_X.setLabelsInsets(p_LabelsInsets);
    }

    public int getLabelsAlignment_X() {
        return this.m_ControlDimension_X.getLabelsAlignment();
    }

    public void setLabelsAlignment_X(int p_LabelsAlignment) {
        this.m_ControlDimension_X.setLabelsAlignment(p_LabelsAlignment);
    }

    public boolean getLabelsMirrored_X() {
        return this.m_ControlDimension_X.getLabelsMirrored();
    }

    public void setLabelsMirrored_X(boolean p_LabelsMirrored) {
        this.m_ControlDimension_X.setLabelsMirrored(p_LabelsMirrored);
    }

    public Font getLabelsFont_X() {
        return this.m_ControlDimension_X.getLabelsFont();
    }

    public void setLabelsFont_X(Font p_LabelsFont) {
        this.m_ControlDimension_X.setLabelsFont(p_LabelsFont);
    }

    public void setLabelsTextRotation_X(double p_Degree) {
        this.m_ControlDimension_X.setLabelsTextRotation(p_Degree);
    }

    public Border getLabelsBorder_X() {
        return this.m_ControlDimension_X.getLabelsBorder();
    }

    public void setLabelsBorder_X(Border p_LabelsBorder) {
        this.m_ControlDimension_X.setLabelsBorder(p_LabelsBorder);
    }

    public ControlLabelModel getControlLabelModel_X() {
        return this.m_ControlDimension_X.getControlLabelModel();
    }

    public void setControlLabelModel_X(ControlLabelModel p_ControlLabelModel) {
        this.m_ControlDimension_X.setControlLabelModel(p_ControlLabelModel);
    }

    public Dimension getLabelsSize_X() {
        return this.m_ControlDimension_X.getLabelsSize();
    }

    public void setLabelsSize_X(Dimension p_LabelsSize) {
        this.m_ControlDimension_X.setLabelsSize(p_LabelsSize);
    }

    public void setLabelsSizeFixed_X(boolean p_LabelsSizeFixed) {
        this.m_ControlDimension_X.setLabelsSizeFixed(p_LabelsSizeFixed);
    }

    public boolean getLabelsSizeFixed_X() {
        return this.m_ControlDimension_X.getLabelsSizeFixed();
    }

    public boolean getBlocks_Y() {
        return this.m_ControlDimension_Y.getBlocksVisible();
    }

    public void setBlocks_Y(boolean p_BlocksVisible) {
        this.m_ControlDimension_Y.setBlocksVisible(p_BlocksVisible);
    }

    public Insets getBlocksInsets_Y() {
        return this.m_ControlDimension_Y.getBlocksInsets();
    }

    public void setBlocksInsets_Y(Insets p_BlocksInsets) {
        this.m_ControlDimension_Y.setBlocksInsets(p_BlocksInsets);
    }

    public int getBlocksAlignment_Y() {
        return this.m_ControlDimension_Y.getBlocksAlignment();
    }

    public void setBlocksAlignment_Y(int p_BlocksAlignment) {
        this.m_ControlDimension_Y.setBlocksAlignment(p_BlocksAlignment);
    }

    public boolean getBlocksMirrored_Y() {
        return this.m_ControlDimension_Y.getBlocksMirrored();
    }

    public void setBlocksMirrored_Y(boolean p_BlocksMirrored) {
        this.m_ControlDimension_Y.setBlocksMirrored(p_BlocksMirrored);
    }

    public Font getBlocksFont_Y() {
        return this.m_ControlDimension_Y.getBlocksFont();
    }

    public void setBlocksFont_Y(Font p_BlocksFont) {
        this.m_ControlDimension_Y.setBlocksFont(p_BlocksFont);
    }

    public void setBlocksTextRotation_Y(double p_Degree) {
        this.m_ControlDimension_Y.setBlocksTextRotation(p_Degree);
    }

    public Border getBlocksBorder_Y() {
        return this.m_ControlDimension_Y.getBlocksBorder();
    }

    public void setBlocksBorder_Y(Border p_BlocksBorder) {
        this.m_ControlDimension_Y.setBlocksBorder(p_BlocksBorder);
    }

    public ControlBlockModel getControlBlockModel_Y() {
        return this.m_ControlDimension_Y.getControlBlockModel();
    }

    public void setControlBlockModel_Y(ControlBlockModel p_ControlBlockModel) {
        this.m_ControlDimension_Y.setControlBlockModel(p_ControlBlockModel);
    }

    public Dimension getBlocksSize_Y() {
        return this.m_ControlDimension_Y.getBlocksSize();
    }

    public void setBlocksSize_Y(Dimension p_BlocksSize) {
        this.m_ControlDimension_Y.setBlocksSize(p_BlocksSize);
    }

    public boolean getBlocks_X() {
        return this.m_ControlDimension_X.getBlocksVisible();
    }

    public void setBlocks_X(boolean p_BlocksVisible) {
        this.m_ControlDimension_X.setBlocksVisible(p_BlocksVisible);
    }

    public Insets getBlocksInsets_X() {
        return this.m_ControlDimension_X.getBlocksInsets();
    }

    public void setBlocksInsets_X(Insets p_BlocksInsets) {
        this.m_ControlDimension_X.setBlocksInsets(p_BlocksInsets);
    }

    public int getBlocksAlignment_X() {
        return this.m_ControlDimension_X.getBlocksAlignment();
    }

    public void setBlocksAlignment_X(int p_BlocksAlignment) {
        this.m_ControlDimension_X.setBlocksAlignment(p_BlocksAlignment);
    }

    public boolean getBlocksMirrored_X() {
        return this.m_ControlDimension_X.getBlocksMirrored();
    }

    public void setBlocksMirrored_X(boolean p_BlocksMirrored) {
        this.m_ControlDimension_X.setBlocksMirrored(p_BlocksMirrored);
    }

    public Font getBlocksFont_X() {
        return this.m_ControlDimension_X.getBlocksFont();
    }

    public void setBlocksFont_X(Font p_BlocksFont) {
        this.m_ControlDimension_X.setBlocksFont(p_BlocksFont);
    }

    public void setBlocksTextRotation_X(double p_Degree) {
        this.m_ControlDimension_X.setBlocksTextRotation(p_Degree);
    }

    public Border getBlocksBorder_X() {
        return this.m_ControlDimension_X.getBlocksBorder();
    }

    public void setBlocksBorder_X(Border p_BlocksBorder) {
        this.m_ControlDimension_X.setBlocksBorder(p_BlocksBorder);
    }

    public ControlBlockModel getControlBlockModel_X() {
        return this.m_ControlDimension_X.getControlBlockModel();
    }

    public void setControlBlockModel_X(ControlBlockModel p_ControlBlockModel) {
        this.m_ControlDimension_X.setControlBlockModel(p_ControlBlockModel);
    }

    public Dimension getBlocksSize_X() {
        return this.m_ControlDimension_X.getBlocksSize();
    }

    public void setBlocksSize_X(Dimension p_BlocksSize) {
        this.m_ControlDimension_X.setBlocksSize(p_BlocksSize);
    }

    @Override
    public void adjustToValue(ControlObject.ControlDimension p_ControlDimension, double p_Value, boolean p_ManuallySet) {
        if (p_ControlDimension == null) {
            return;
        }
        if (this.m_ControlDimension_X != p_ControlDimension && this.m_ControlDimension_Y != p_ControlDimension) {
            return;
        }
        p_ControlDimension.adjustToValue(p_Value, p_ManuallySet);
    }

    public int getOrientation_Y() {
        return this.m_ControlDimension_Y.getOrientation();
    }

    public void setOrientation_Y(int p_Orientation) {
        this.m_ControlDimension_Y.setOrientation(p_Orientation);
    }

    public boolean getInverted_Y() {
        return this.m_ControlDimension_Y.getInverted();
    }

    public void setInverted_Y(boolean p_Inverted) {
        this.m_ControlDimension_Y.setInverted(p_Inverted);
    }

    public int getOrientation_X() {
        return this.m_ControlDimension_X.getOrientation();
    }

    public void setOrientation_X(int p_Orientation) {
        this.m_ControlDimension_X.setOrientation(p_Orientation);
    }

    public boolean getInverted_X() {
        return this.m_ControlDimension_X.getInverted();
    }

    public void setInverted_X(boolean p_Inverted) {
        this.m_ControlDimension_X.setInverted(p_Inverted);
    }

    public double getValue_Y() {
        return this.m_ControlDimension_Y.getValue();
    }

    public double getValue_YOld() {
        return this.m_ControlDimension_Y.getValueOld();
    }

    public void setValue_Y(double p_Value, double p_ValueDiff, int p_ActionFlag) {
        this.m_ControlDimension_Y.setValue(p_Value, p_ValueDiff, p_ActionFlag);
    }

    public void setValue_Y(double p_Value) {
        this.m_ControlDimension_Y.setValue(p_Value, 0.0, 0);
    }

    public int getValue_YInt() {
        return this.m_ControlDimension_Y.getValueInt();
    }

    public void setValue_YInt(int p_Value, int p_ValueDIff, int p_ActionFlag) {
        this.m_ControlDimension_Y.setValueInt(p_Value, p_ValueDIff, p_ActionFlag);
    }

    public double getValue_YTransformed() {
        return this.m_ControlDimension_Y.getValueTransformed();
    }

    public void setValue_YTransformed(double p_MultipliedValue, int p_ActionFlag) {
        this.m_ControlDimension_Y.setValueTransformed(p_MultipliedValue, p_ActionFlag);
    }

    public double getValue_YMultiplier() {
        return this.m_ControlDimension_Y.getValueMultiplier();
    }

    public void setValue_YMultiplier(double p_ValueMultiplier) {
        this.m_ControlDimension_Y.setValueMultiplier(p_ValueMultiplier);
    }

    public double getValue_YOffset() {
        return this.m_ControlDimension_Y.getValueOffset();
    }

    public void setValue_YOffset(double p_ValueOffset) {
        this.m_ControlDimension_Y.setValueOffset(p_ValueOffset);
    }

    public double getSnapDistance_Y() {
        return this.m_ControlDimension_Y.getSnapDistance();
    }

    public void setSnapDistance_Y(double p_SnapDistance) {
        this.m_ControlDimension_Y.setSnapDistance(p_SnapDistance);
    }

    public double getSnapDistance_YTransformed() {
        return this.m_ControlDimension_Y.getSnapDistanceTransformed();
    }

    public void setSnapDistance_YTransformed(double p_SnapDistanceTransformed) {
        this.m_ControlDimension_Y.setSnapDistanceTransformed(p_SnapDistanceTransformed);
    }

    public double getValue_YMaximum() {
        return this.m_ControlDimension_Y.getValueMaximum();
    }

    public void setValue_YMaximum(double p_Maximum) {
        this.m_ControlDimension_Y.setValueMaximum(p_Maximum);
    }

    public double getValue_YMinimum() {
        return this.m_ControlDimension_Y.getValueMinimum();
    }

    public void setValue_YMinimum(double p_Minimum) {
        this.m_ControlDimension_Y.setValueMinimum(p_Minimum);
    }

    public double getMouseWheelStep_Y() {
        return this.m_ControlDimension_Y.getMouseWheelStep();
    }

    public void setMouseWheelStep_Y(double p_ValueDifference) {
        this.m_ControlDimension_Y.setMouseWheelStep(p_ValueDifference);
    }

    public double getMouseMoveFacror_Y() {
        return this.m_ControlDimension_Y.getMouseMoveFactor();
    }

    public void setMouseMoveFactor_Y(double p_MouseMoveFactor) {
        this.m_ControlDimension_Y.setMouseMoveFactor(p_MouseMoveFactor);
    }

    public double getValue_X() {
        return this.m_ControlDimension_X.getValue();
    }

    public double getValue_XOld() {
        return this.m_ControlDimension_X.getValueOld();
    }

    public void setValue_X(double p_Value, double p_ValueDiff, int p_ActionFlag) {
        this.m_ControlDimension_X.setValue(p_Value, p_ValueDiff, p_ActionFlag);
    }

    public void setValue_X(double p_Value) {
        this.m_ControlDimension_X.setValue(p_Value, 0.0, 0);
    }

    public int getValue_XInt() {
        return this.m_ControlDimension_X.getValueInt();
    }

    public void setValue_XInt(int p_Value, int p_ValueDiff, int p_ActionFlag) {
        this.m_ControlDimension_X.setValueInt(p_Value, p_ValueDiff, p_ActionFlag);
    }

    public double getValue_XTransformed() {
        return this.m_ControlDimension_X.getValueTransformed();
    }

    public void setValue_XTransformed(double p_MultipliedValue, int p_ActionFlag) {
        this.m_ControlDimension_X.setValueTransformed(p_MultipliedValue, p_ActionFlag);
    }

    public double getValue_XMultiplier() {
        return this.m_ControlDimension_X.getValueMultiplier();
    }

    public void setValue_XMultiplier(double p_ValueMultiplier) {
        this.m_ControlDimension_X.setValueMultiplier(p_ValueMultiplier);
    }

    public double getValue_XOffset() {
        return this.m_ControlDimension_X.getValueOffset();
    }

    public void setValue_XOffset(double p_ValueOffset) {
        this.m_ControlDimension_X.setValueOffset(p_ValueOffset);
    }

    public double getSnapDistance_X() {
        return this.m_ControlDimension_X.getSnapDistance();
    }

    public void setSnapDistance_X(double p_SnapDistance) {
        this.m_ControlDimension_X.setSnapDistance(p_SnapDistance);
    }

    public double getSnapDistance_XTransformed() {
        return this.m_ControlDimension_X.getSnapDistanceTransformed();
    }

    public void setSnapDistance_XTransformed(double p_SnapDistanceTransformed) {
        this.m_ControlDimension_X.setSnapDistanceTransformed(p_SnapDistanceTransformed);
    }

    public double getValue_XMaximum() {
        return this.m_ControlDimension_X.getValueMaximum();
    }

    public void setValue_XMaximum(double p_Maximum) {
        this.m_ControlDimension_X.setValueMaximum(p_Maximum);
    }

    public double getValue_XMinimum() {
        return this.m_ControlDimension_X.getValueMinimum();
    }

    public void setValue_XMinimum(double p_Minimum) {
        this.m_ControlDimension_X.setValueMinimum(p_Minimum);
    }

    public double getMouseWheelStep_X() {
        return this.m_ControlDimension_X.getMouseWheelStep();
    }

    public void setMouseWheelStep_X(double p_ValueDifference) {
        this.m_ControlDimension_X.setMouseWheelStep(p_ValueDifference);
    }

    public double getMouseMoveFacror_X() {
        return this.m_ControlDimension_Y.getMouseMoveFactor();
    }

    public void setMouseMoveFactor_X(double p_MouseMoveFactor) {
        this.m_ControlDimension_Y.setMouseMoveFactor(p_MouseMoveFactor);
    }

    protected static class GridAdjusterAxis
    extends JComponent
    implements Externalizable {
        protected ControlObject m_ControlObject;
        protected ControlObject.ControlDimension m_ControlDimension;
        protected int m_AdjusterLength;
        protected Color m_AdjusterColor;
        protected BufferedImage m_AdjusterImage;
        protected GridAdjusterAxis m_SelfReference;
        protected int m_DragPos_Y;
        protected int m_DragPos_X;
        protected int m_OldPos_Y;
        protected int m_OldPos_X;
        protected double m_OldValue_X;
        protected double m_OldValue_Y;
        protected Rectangle m_RectSize;
        protected Rectangle m_OldRectSize;
        protected boolean m_RepaintFlag;
        protected AbsoluteConstraints m_Constraints;
        private int[] intXPoints;
        private int[] intYPoints;
        protected BufferedImage m_Image;
        protected int m_OldOrientation;
        protected boolean m_MousePressed;
        private SoftReference m_SoftReferenceBufferedImage;
        private Insets m_InsetsParent;
        static final long serialVersionUID = 5742893707443127172L;

        public GridAdjusterAxis() {
            this.initMembers();
            this.initComponents();
        }

        public GridAdjusterAxis(ControlObject.ControlDimension p_ControlDimension) {
            this.m_ControlDimension = p_ControlDimension;
            this.m_ControlObject = this.m_ControlDimension.getControlObject();
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_SelfReference = this;
            this.m_RectSize = new Rectangle();
            this.m_OldRectSize = new Rectangle();
            this.m_RepaintFlag = true;
            this.m_AdjusterLength = 8;
            this.m_AdjusterColor = Color.BLACK;
            this.m_AdjusterImage = null;
            this.intXPoints = new int[7];
            this.intYPoints = new int[7];
            this.m_Image = null;
            this.m_OldOrientation = 1;
            this.m_MousePressed = false;
        }

        private Object readResolve() {
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
            p_ObjectOutput.writeInt(this.m_AdjusterLength);
            ImagesTools.writeColor((ObjectOutput)p_ObjectOutput, (Color)this.m_AdjusterColor);
            ImagesTools.writeImage((ObjectOutput)p_ObjectOutput, (Image)this.m_AdjusterImage);
        }

        @Override
        public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
            this.m_AdjusterLength = p_ObjectInput.readInt();
            this.m_AdjusterColor = ImagesTools.readColor((ObjectInput)p_ObjectInput);
            Image o_Image = ImagesTools.readImage((ObjectInput)p_ObjectInput);
            this.m_AdjusterImage = ImagesTools.convertToBufferedImage((Image)o_Image);
            this.m_RepaintFlag = true;
            this.repaint();
        }

        private void initComponents() {
            this.setOpaque(false);
            this.m_Constraints = new AbsoluteConstraints(0, 0, 0, 0);
            MouseAdapter_Delayed o_MouseAdapter_Delayed = new MouseAdapter_Delayed(){

                public void mousePressed_Delayed(MouseEvent me) {
                    if (!(me.getButton() != 1 || me.isAltDown() || me.isAltGraphDown() || me.isControlDown() || me.isMetaDown() || me.isShiftDown())) {
                        m_DragPos_Y = me.getYOnScreen();
                        m_DragPos_X = me.getXOnScreen();
                        m_OldPos_Y = me.getYOnScreen();
                        m_OldPos_X = me.getXOnScreen();
                        if (m_ControlDimension.getOrientation() == 1) {
                            m_OldValue_Y = m_ControlDimension.getValue();
                        } else {
                            m_OldValue_X = m_ControlDimension.getValue();
                        }
                        m_MousePressed = true;
                        m_ControlObject.setMousePressed(m_MousePressed);
                        this.requestFocus();
                    }
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseClicked_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseReleased_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                    m_MousePressed = false;
                    m_ControlObject.setMousePressed(m_MousePressed);
                }

                public void mouseEntered_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseExited_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseDragged_Delayed(MouseEvent me) {
                    if (!(me.isAltDown() || me.isAltGraphDown() || me.isControlDown() || me.isMetaDown() || me.isShiftDown())) {
                        double doubleNewValueX;
                        double doubleNewValueY;
                        int intLength = 1;
                        int intPosition = 0;
                        int intDiff = 0;
                        double doubleValue_Y_Diff = 0.0;
                        double doubleValue_X_Diff = 0.0;
                        if (m_ControlDimension.getOrientation() == 1) {
                            intLength = this.getParent().getHeight();
                            intPosition = me.getYOnScreen() - m_DragPos_Y;
                            intDiff = me.getYOnScreen() - m_OldPos_Y;
                            m_OldPos_Y = me.getYOnScreen();
                            if (!m_ControlDimension.getInverted()) {
                                intPosition = -intPosition;
                                intDiff = -intDiff;
                            }
                            doubleValue_Y_Diff = (double)intDiff / (double)intLength * (m_ControlDimension.getValueMaximum() - m_ControlDimension.getValueMinimum());
                            double doubleValue_Y = (double)intPosition / (double)intLength * (m_ControlDimension.getValueMaximum() - m_ControlDimension.getValueMinimum());
                            doubleNewValueY = m_OldValue_Y + doubleValue_Y;
                            doubleNewValueX = m_ControlObject.getControlDimension(0).getValue();
                        } else {
                            intLength = this.getParent().getWidth();
                            intPosition = me.getXOnScreen() - m_DragPos_X;
                            intDiff = me.getXOnScreen() - m_OldPos_X;
                            m_OldPos_X = me.getXOnScreen();
                            if (m_ControlDimension.getInverted()) {
                                intPosition = -intPosition;
                                intDiff = -intDiff;
                            }
                            doubleValue_X_Diff = (double)intDiff / (double)intLength * (m_ControlDimension.getValueMaximum() - m_ControlDimension.getValueMinimum());
                            double doubleValue_X = (double)intPosition / (double)intLength * (m_ControlDimension.getValueMaximum() - m_ControlDimension.getValueMinimum());
                            doubleNewValueX = m_OldValue_X + doubleValue_X;
                            doubleNewValueY = m_ControlObject.getControlDimension(1).getValue();
                        }
                        Point2D o_RestrictedPoint = ((JControlGrid)m_ControlObject).getGridTrack().checkValuesInAreas(doubleNewValueX, doubleNewValueY);
                        if (o_RestrictedPoint != null) {
                            doubleNewValueX = o_RestrictedPoint.getX();
                            doubleNewValueY = o_RestrictedPoint.getY();
                        }
                        m_ControlObject.getControlDimension(1).setValue(doubleNewValueY, doubleValue_Y_Diff, 4);
                        m_ControlObject.getControlDimension(0).setValue(doubleNewValueX, doubleValue_X_Diff, 4);
                        m_ControlObject.setValueManuallyIsReady();
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseMoved_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }
            };
            this.addMouseListener((MouseListener)o_MouseAdapter_Delayed);
            this.addMouseMotionListener((MouseMotionListener)o_MouseAdapter_Delayed);
        }

        public AbsoluteConstraints getConstraints() {
            return this.m_Constraints;
        }

        @Override
        public void setForeground(Color p_Color) {
            super.setForeground(p_Color);
        }

        public int getAdjusterLength() {
            return this.m_AdjusterLength;
        }

        public void setAdjusterLength(int p_AdjusterLength) {
            int oldValue = this.m_AdjusterLength;
            this.m_AdjusterLength = p_AdjusterLength;
            if (oldValue != this.m_AdjusterLength) {
                this.firePropertyChange(JControlGrid.PROP_ADJUSTERAXISLENGTH, oldValue, this.m_AdjusterLength);
                this.repaint();
            }
        }

        public Image getAdjusterImage() {
            return this.m_AdjusterImage;
        }

        public void setAdjusterImage(Image p_AdjusterImage) {
            BufferedImage oldValue = this.m_AdjusterImage;
            this.m_AdjusterImage = ImagesTools.convertToBufferedImage((Image)p_AdjusterImage);
            this.m_RepaintFlag = true;
            this.firePropertyChange(JControlGrid.PROP_ADJUSTERAXISIMAGE, oldValue, this.m_AdjusterImage);
            this.repaint();
        }

        public Color getAdjusterColor() {
            return this.m_AdjusterColor;
        }

        public void setAdjusterColor(Color p_AdjusterColor) {
            Color oldValue = this.m_AdjusterColor;
            this.m_AdjusterColor = p_AdjusterColor;
            if (!oldValue.equals(this.m_AdjusterColor)) {
                this.firePropertyChange(JControlGrid.PROP_ADJUSTERAXISCOLOR, oldValue, this.m_AdjusterColor);
                this.repaint();
            }
        }

        @Override
        public void paintComponent(Graphics p_Graphics) {
            boolean boolWidthChanged = false;
            boolean boolHeightChanged = false;
            super.paintComponent(p_Graphics);
            this.m_InsetsParent = this.getInsets(this.m_InsetsParent);
            this.m_RectSize.setRect(this.m_InsetsParent.left, this.m_InsetsParent.top, this.getWidth() - this.m_InsetsParent.left - this.m_InsetsParent.right, this.getHeight() - this.m_InsetsParent.top - this.m_InsetsParent.bottom);
            if (this.m_RectSize.getWidth() != this.m_OldRectSize.getWidth()) {
                boolWidthChanged = true;
            }
            if (this.m_RectSize.getHeight() != this.m_OldRectSize.getHeight()) {
                boolHeightChanged = true;
            }
            if (boolWidthChanged || boolHeightChanged) {
                // empty if block
            }
            this.m_OldRectSize.setRect(this.m_RectSize.getX(), this.m_RectSize.getY(), this.m_RectSize.getWidth(), this.m_RectSize.getHeight());
            if (this.m_RepaintFlag || this.m_OldOrientation != this.m_ControlDimension.getOrientation()) {
                this.m_Image = this.m_ControlDimension.getOrientation() == 1 ? this.m_AdjusterImage : ImagesTools.rotateImage90_right((BufferedImage)this.m_AdjusterImage);
                this.m_OldOrientation = this.m_ControlDimension.getOrientation();
            }
            if (this.m_Image != null) {
                p_Graphics.drawImage(this.m_Image, this.m_RectSize.x, this.m_RectSize.y, this.m_RectSize.x + this.m_RectSize.width, this.m_RectSize.y + this.m_RectSize.height, 0, 0, this.m_Image.getWidth(), this.m_Image.getHeight(), this);
            } else if (this.m_ControlDimension.getOrientation() == 1) {
                this.intXPoints[0] = this.m_RectSize.width;
                this.intYPoints[0] = 0;
                this.intXPoints[1] = 0;
                this.intYPoints[1] = this.m_RectSize.height / 2;
                this.intXPoints[2] = this.m_RectSize.width;
                this.intYPoints[2] = this.m_RectSize.height;
                p_Graphics.fillPolygon(this.intXPoints, this.intYPoints, 3);
            } else {
                this.intXPoints[0] = 0;
                this.intYPoints[0] = 0;
                this.intXPoints[1] = this.m_RectSize.width / 2;
                this.intYPoints[1] = this.m_RectSize.height;
                this.intXPoints[2] = this.m_RectSize.width;
                this.intYPoints[2] = 0;
                p_Graphics.fillPolygon(this.intXPoints, this.intYPoints, 3);
            }
            this.m_RepaintFlag = false;
        }
    }

    public static class GridAdjuster
    extends JComponent
    implements Externalizable {
        protected ControlObject m_ControlObject;
        protected ControlObject.ControlDimension m_ControlDimension_X;
        protected ControlObject.ControlDimension m_ControlDimension_Y;
        protected int m_DragPos_Y;
        protected int m_DragPos_X;
        protected int m_OldPos_Y;
        protected int m_OldPos_X;
        protected Rectangle m_RectSize;
        protected Rectangle m_OldRectSize;
        protected boolean m_RepaintFlag;
        protected AbsoluteConstraints m_AdjusterConstraints;
        protected int m_AdjusterLength;
        protected Color m_AdjusterColor;
        protected BufferedImage m_AdjusterImage;
        protected BufferedImage m_Image;
        protected int m_OldOrientation;
        protected GridAdjuster m_SelfReference;
        protected double m_OldValue_X;
        protected double m_OldValue_Y;
        protected SoftReference m_SoftReferenceBufferedImage;
        private Insets m_InsetsParent;
        protected boolean m_MousePressed;
        static final long serialVersionUID = 3034643531898126790L;

        public GridAdjuster() {
            this.initMembers();
            this.initComponents();
        }

        public GridAdjuster(ControlObject p_ControlObject) {
            this.m_ControlObject = p_ControlObject;
            this.m_ControlDimension_X = this.m_ControlObject.getControlDimension(0);
            this.m_ControlDimension_Y = this.m_ControlObject.getControlDimension(1);
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_SelfReference = this;
            this.m_AdjusterLength = 20;
            this.m_AdjusterColor = Color.LIGHT_GRAY;
            this.m_AdjusterImage = null;
            this.m_RectSize = new Rectangle();
            this.m_OldRectSize = new Rectangle();
            this.m_Image = null;
            this.m_OldOrientation = 1;
            this.m_RepaintFlag = true;
            this.m_MousePressed = false;
        }

        private Object readResolve() {
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
            p_ObjectOutput.writeInt(this.m_AdjusterLength);
            ImagesTools.writeColor((ObjectOutput)p_ObjectOutput, (Color)this.m_AdjusterColor);
            ImagesTools.writeImage((ObjectOutput)p_ObjectOutput, (Image)this.m_AdjusterImage);
        }

        @Override
        public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
            this.m_AdjusterLength = p_ObjectInput.readInt();
            this.m_AdjusterColor = ImagesTools.readColor((ObjectInput)p_ObjectInput);
            Image o_Image = ImagesTools.readImage((ObjectInput)p_ObjectInput);
            this.m_AdjusterImage = ImagesTools.convertToBufferedImage((Image)o_Image);
            this.m_RepaintFlag = true;
            this.repaint();
        }

        private void initComponents() {
            this.setOpaque(false);
            this.m_AdjusterConstraints = new AbsoluteConstraints(0, 0, 0, 0);
            MouseAdapter_Delayed o_MouseAdapter_Delayed = new MouseAdapter_Delayed(){

                public void mousePressed_Delayed(MouseEvent me) {
                    if (!(me.getButton() != 1 || me.isAltDown() || me.isAltGraphDown() || me.isControlDown() || me.isMetaDown() || me.isShiftDown())) {
                        m_DragPos_Y = me.getYOnScreen();
                        m_DragPos_X = me.getXOnScreen();
                        m_OldPos_Y = me.getYOnScreen();
                        m_OldPos_X = me.getXOnScreen();
                        m_OldValue_Y = m_ControlDimension_Y.getValue();
                        m_OldValue_X = m_ControlDimension_X.getValue();
                        m_MousePressed = true;
                        m_ControlObject.setMousePressed(m_MousePressed);
                        this.requestFocus();
                    }
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseClicked_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseReleased_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                    m_MousePressed = false;
                    m_ControlObject.setMousePressed(m_MousePressed);
                }

                public void mouseEntered_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseExited_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseDragged_Delayed(MouseEvent me) {
                    if (!(me.isAltDown() || me.isAltGraphDown() || me.isControlDown() || me.isMetaDown() || me.isShiftDown())) {
                        int intLength = 1;
                        int intPosition = 0;
                        int intDiffPos = 0;
                        intLength = this.getParent().getHeight();
                        intPosition = me.getYOnScreen() - m_DragPos_Y;
                        intDiffPos = me.getYOnScreen() - m_OldPos_Y;
                        m_OldPos_Y = me.getYOnScreen();
                        if (!m_ControlDimension_Y.getInverted()) {
                            intPosition = -intPosition;
                            intDiffPos = -intDiffPos;
                        }
                        double doubleValue_Y_Diff = (double)intDiffPos / (double)intLength * (m_ControlDimension_Y.getValueMaximum() - m_ControlDimension_Y.getValueMinimum());
                        double doubleValue_Y = (double)intPosition / (double)intLength * (m_ControlDimension_Y.getValueMaximum() - m_ControlDimension_Y.getValueMinimum());
                        double doubleNewValueY = m_OldValue_Y + doubleValue_Y;
                        intLength = this.getParent().getWidth();
                        intPosition = me.getXOnScreen() - m_DragPos_X;
                        intDiffPos = me.getXOnScreen() - m_OldPos_X;
                        m_OldPos_X = me.getXOnScreen();
                        if (m_ControlDimension_X.getInverted()) {
                            intPosition = -intPosition;
                            intDiffPos = -intDiffPos;
                        }
                        double doubleValue_X_Diff = (double)intDiffPos / (double)intLength * (m_ControlDimension_X.getValueMaximum() - m_ControlDimension_X.getValueMinimum());
                        double doubleValue_X = (double)intPosition / (double)intLength * (m_ControlDimension_X.getValueMaximum() - m_ControlDimension_X.getValueMinimum());
                        double doubleNewValueX = m_OldValue_X + doubleValue_X;
                        ((JControlGrid)m_ControlObject).setValues(doubleNewValueX, doubleValue_X_Diff, doubleNewValueY, doubleValue_Y_Diff, 4);
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseMoved_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }
            };
            this.addMouseListener((MouseListener)o_MouseAdapter_Delayed);
            this.addMouseMotionListener((MouseMotionListener)o_MouseAdapter_Delayed);
        }

        public AbsoluteConstraints getConstraints() {
            return this.m_AdjusterConstraints;
        }

        @Override
        public void setForeground(Color p_Color) {
            super.setForeground(p_Color);
        }

        public int getAdjusterLength() {
            return this.m_AdjusterLength;
        }

        public void setAdjusterLength(int p_AdjusterLength) {
            int oldValue = this.m_AdjusterLength;
            this.m_AdjusterLength = p_AdjusterLength;
            if (oldValue != this.m_AdjusterLength) {
                this.firePropertyChange(JControlGrid.PROP_ADJUSTERLENGTH, oldValue, this.m_AdjusterLength);
                this.repaint();
            }
        }

        public Image getAdjusterImage() {
            return this.m_AdjusterImage;
        }

        public void setAdjusterImage(Image p_AdjusterImage) {
            BufferedImage oldValue = this.m_AdjusterImage;
            this.m_AdjusterImage = ImagesTools.convertToBufferedImage((Image)p_AdjusterImage);
            this.m_RepaintFlag = true;
            this.firePropertyChange(JControlGrid.PROP_ADJUSTERIMAGE, oldValue, this.m_AdjusterImage);
            this.repaint();
        }

        public Color getAdjusterColor() {
            return this.m_AdjusterColor;
        }

        public void setAdjusterColor(Color p_AdjusterColor) {
            Color oldValue = this.m_AdjusterColor;
            this.m_AdjusterColor = p_AdjusterColor;
            if (!oldValue.equals(this.m_AdjusterColor)) {
                this.firePropertyChange(JControlGrid.PROP_ADJUSTERCOLOR, oldValue, this.m_AdjusterColor);
                this.repaint();
            }
        }

        @Override
        public void paintComponent(Graphics p_Graphics) {
            boolean boolWidthChanged = false;
            boolean boolHeightChanged = false;
            super.paintComponent(p_Graphics);
            this.m_InsetsParent = this.getInsets(this.m_InsetsParent);
            this.m_RectSize.setRect(this.m_InsetsParent.left, this.m_InsetsParent.top, this.getWidth() - this.m_InsetsParent.left - this.m_InsetsParent.right, this.getHeight() - this.m_InsetsParent.top - this.m_InsetsParent.bottom);
            if (this.m_RectSize.getWidth() != this.m_OldRectSize.getWidth()) {
                boolWidthChanged = true;
            }
            if (this.m_RectSize.getHeight() != this.m_OldRectSize.getHeight()) {
                boolHeightChanged = true;
            }
            if (boolWidthChanged || boolHeightChanged) {
                // empty if block
            }
            this.m_OldRectSize.setRect(this.m_RectSize.getX(), this.m_RectSize.getY(), this.m_RectSize.getWidth(), this.m_RectSize.getHeight());
            if (this.m_RepaintFlag || this.m_OldOrientation != this.m_ControlDimension_Y.getOrientation()) {
                this.m_Image = this.m_ControlDimension_Y.getOrientation() == 1 ? this.m_AdjusterImage : ImagesTools.rotateImage90_right((BufferedImage)this.m_AdjusterImage);
                this.m_OldOrientation = this.m_ControlDimension_Y.getOrientation();
            }
            if (this.m_Image != null) {
                p_Graphics.drawImage(this.m_Image, this.m_RectSize.x, this.m_RectSize.y, this.m_RectSize.x + this.m_RectSize.width, this.m_RectSize.y + this.m_RectSize.height, 0, 0, this.m_Image.getWidth(), this.m_Image.getHeight(), this);
            } else {
                p_Graphics.setColor(this.m_AdjusterColor);
                p_Graphics.fillRect(0, 0, this.m_RectSize.width - 1, this.m_RectSize.height - 1);
                p_Graphics.setColor(this.getForeground());
                p_Graphics.drawRect(this.m_RectSize.x, this.m_RectSize.y, this.m_RectSize.width - 1, this.m_RectSize.height - 1);
                p_Graphics.drawLine(0, this.m_RectSize.height / 2, this.m_RectSize.width, this.m_RectSize.height / 2);
                p_Graphics.drawLine(this.m_RectSize.width / 2, 0, this.m_RectSize.width / 2, this.m_RectSize.height);
            }
            this.m_RepaintFlag = false;
        }
    }

    public static class GridArea
    implements PropertyChangeListener {
        private int m_SortID;
        private ArrayList<GridPoint> m_GridPoints;
        private ArrayList<GridPoint> m_GridPointsMiddle;
        private ArrayList<GridPoint> m_GridPoints_Calculated;
        private Polygon m_Polygon_XY;
        private Polygon2D m_Polygon_Value;
        private Color m_Color;
        private String m_Text;
        private boolean m_IsComplete;
        private boolean m_Failure;
        private boolean m_Enabled;
        private Object m_AreaObject;
        private Point2D m_MiddlePoint;
        private JControlGrid m_JControlGrid;

        public GridArea(int p_SortID, String p_Text, JControlGrid p_JControlGrid, Object p_AreaObject) {
            this.initMembers();
            this.m_JControlGrid = p_JControlGrid;
            this.m_SortID = p_SortID;
            this.m_Text = p_Text;
            this.m_AreaObject = p_AreaObject;
            this.initComponents();
        }

        private void initMembers() {
            this.m_GridPoints = new ArrayList();
            this.m_GridPointsMiddle = new ArrayList();
            this.m_GridPoints_Calculated = new ArrayList();
            this.m_Color = Color.YELLOW;
            this.m_Polygon_XY = new Polygon();
            this.m_Polygon_Value = new Polygon2D();
            this.m_IsComplete = false;
            this.m_Failure = false;
            this.m_Enabled = false;
            this.m_Text = "";
            this.m_SortID = 0;
            this.m_MiddlePoint = null;
        }

        private void initComponents() {
        }

        public void close() {
            this.setGridPoints(null);
            this.setGridPointsMiddle(null);
        }

        public void setGridPoints(ArrayList<GridPoint> p_GridPoints) {
            GridPoint o_GridPoint;
            int intPoint;
            for (intPoint = this.m_GridPoints.size() - 1; intPoint >= 0; --intPoint) {
                o_GridPoint = this.m_GridPoints.get(intPoint);
                o_GridPoint.removePropertyChangeListener(this);
                this.m_GridPoints.remove(o_GridPoint);
            }
            this.m_Polygon_Value.reset();
            if (p_GridPoints != null) {
                for (intPoint = 0; intPoint < p_GridPoints.size(); ++intPoint) {
                    o_GridPoint = p_GridPoints.get(intPoint);
                    o_GridPoint.addPropertyChangeListener(this);
                    this.m_GridPoints.add(o_GridPoint);
                    this.m_Polygon_Value.addPoint(o_GridPoint.getValueX(), o_GridPoint.getValueY());
                }
            }
            this.m_JControlGrid.getGridTrack().repaint();
        }

        public void setGridPointsMiddle(ArrayList<GridPoint> p_GridPoints) {
            GridPoint o_GridPoint;
            int intPoint;
            for (intPoint = this.m_GridPointsMiddle.size() - 1; intPoint >= 0; --intPoint) {
                o_GridPoint = this.m_GridPointsMiddle.get(intPoint);
                this.m_GridPointsMiddle.remove(o_GridPoint);
            }
            if (p_GridPoints != null) {
                for (intPoint = 0; intPoint < p_GridPoints.size(); ++intPoint) {
                    o_GridPoint = p_GridPoints.get(intPoint);
                    this.m_GridPointsMiddle.add(o_GridPoint);
                }
            }
        }

        public Polygon2D getPolygonValue() {
            return this.m_Polygon_Value;
        }

        private void refreshPolygonValue() {
            this.m_Polygon_Value.reset();
            for (int intPoint = 0; intPoint < this.m_GridPoints.size(); ++intPoint) {
                GridPoint o_GridPoint = this.m_GridPoints.get(intPoint);
                this.m_Polygon_Value.addPoint(o_GridPoint.getValueX(), o_GridPoint.getValueY());
            }
        }

        public Polygon getPolygon(int p_LengthX, double p_ValueRangeX, int p_LengthY, double p_ValueRangeY, boolean p_invertedX, boolean p_InvertedY) {
            GridPoint o_GridPoint;
            this.m_Polygon_XY.reset();
            int intX0 = 0;
            int intY0 = 0;
            for (int intPoint = 0; intPoint < this.m_GridPoints.size(); ++intPoint) {
                o_GridPoint = this.m_GridPoints.get(intPoint);
                int intX = !p_invertedX ? (int)(o_GridPoint.getValueX() / p_ValueRangeX * (double)p_LengthX) : p_LengthX - (int)(o_GridPoint.getValueX() / p_ValueRangeX * (double)p_LengthX);
                int intY = !p_InvertedY ? p_LengthY - (int)(o_GridPoint.getValueY() / p_ValueRangeY * (double)p_LengthY) : (int)(o_GridPoint.getValueY() / p_ValueRangeY * (double)p_LengthY);
                this.m_Polygon_XY.addPoint(intX, intY);
                if (intPoint != 0) continue;
                intX0 = intX;
                intY0 = intY;
            }
            if (this.m_GridPoints.size() > 0) {
                o_GridPoint = this.m_GridPoints.get(0);
                this.m_Polygon_XY.addPoint(intX0, intY0);
            }
            return this.m_Polygon_XY;
        }

        public void setMiddlePoint(Point2D p_Point2D) {
            if (p_Point2D == null) {
                if (this.m_MiddlePoint == null) {
                    return;
                }
                this.m_MiddlePoint = null;
                this.m_JControlGrid.getGridTrack().repaint();
                return;
            }
            if (this.m_MiddlePoint != null && this.m_MiddlePoint.getX() == p_Point2D.getX() && this.m_MiddlePoint.getY() == p_Point2D.getY()) {
                return;
            }
            this.m_MiddlePoint = p_Point2D;
            this.m_JControlGrid.getGridTrack().repaint();
        }

        public Point2D getMiddlePoint() {
            return this.m_MiddlePoint;
        }

        public void setComplete(boolean p_Complete) {
            if (this.m_IsComplete == p_Complete) {
                return;
            }
            this.m_IsComplete = p_Complete;
            this.m_JControlGrid.getGridTrack().repaint();
        }

        public boolean getComplete() {
            return this.m_IsComplete;
        }

        public void setFailure(boolean p_Failure) {
            if (this.m_Failure == p_Failure) {
                return;
            }
            this.m_Failure = p_Failure;
            this.m_JControlGrid.getGridTrack().repaint();
        }

        public boolean getFailure() {
            return this.m_Failure;
        }

        public void setEnabled(boolean p_Enabled) {
            if (this.m_Enabled == p_Enabled) {
                return;
            }
            this.m_Enabled = p_Enabled;
            this.m_JControlGrid.getGridTrack().repaint();
        }

        public boolean getEnabled() {
            return this.m_Enabled;
        }

        public boolean isInside(double p_X, double p_Y) {
            return this.m_Polygon_Value.contains(p_X, p_Y);
        }

        public Point2D calculateIntersectionDirected(Point2D p_PointIntersection, double p_X, double p_Y) {
            if (this.m_GridPoints.size() <= 1) {
                return null;
            }
            Point2D o_Point2D = p_PointIntersection == null ? new Point2D.Double() : p_PointIntersection;
            double doubleDistance_Old = Double.MAX_VALUE;
            boolean boolFound = false;
            for (int intGridPoint = 0; intGridPoint < this.m_GridPoints.size(); ++intGridPoint) {
                double doubleDistance;
                double doubleY;
                double doubleX;
                GridPoint o_GridPoint = this.m_GridPoints.get(intGridPoint);
                GridPoint o_GridPoint_Next = intGridPoint == this.m_GridPoints.size() - 1 ? this.m_GridPoints.get(0) : this.m_GridPoints.get(intGridPoint + 1);
                boolean boolOk = true;
                if (o_GridPoint.getValueX() - o_GridPoint_Next.getValueX() == 0.0) {
                    doubleX = o_GridPoint.getValueX();
                    doubleY = p_Y;
                } else if (o_GridPoint.getValueY() - o_GridPoint_Next.getValueY() == 0.0) {
                    doubleX = p_X;
                    doubleY = o_GridPoint.getValueY();
                } else {
                    double doubleM = (o_GridPoint.getValueY() - o_GridPoint_Next.getValueY()) / (o_GridPoint.getValueX() - o_GridPoint_Next.getValueX());
                    double doubleC = o_GridPoint.getValueY() - doubleM * o_GridPoint.getValueX();
                    double doubleMP = -1.0 / doubleM;
                    double doubleCP = p_Y - doubleMP * p_X;
                    doubleX = (doubleCP - doubleC) / (doubleM - doubleMP);
                    doubleY = (doubleM * doubleCP - doubleMP * doubleC) / (doubleM - doubleMP);
                }
                if (boolOk) {
                    if (o_GridPoint.getValueX() < o_GridPoint_Next.getValueX()) {
                        if (doubleX < o_GridPoint.getValueX() || doubleX > o_GridPoint_Next.getValueX()) {
                            boolOk = false;
                        }
                    } else if (doubleX > o_GridPoint.getValueX() || doubleX < o_GridPoint_Next.getValueX()) {
                        boolOk = false;
                    }
                }
                if (boolOk) {
                    if (o_GridPoint.getValueY() < o_GridPoint_Next.getValueY()) {
                        if (doubleY < o_GridPoint.getValueY() || doubleY > o_GridPoint_Next.getValueY()) {
                            boolOk = false;
                        }
                    } else if (doubleY > o_GridPoint.getValueY() || doubleY < o_GridPoint_Next.getValueY()) {
                        boolOk = false;
                    }
                }
                if (!boolOk) {
                    doubleX = o_GridPoint.getValueX();
                    doubleY = o_GridPoint.getValueY();
                }
                if (doubleX > this.m_JControlGrid.getValue_XMaximum()) {
                    doubleX = this.m_JControlGrid.getValue_XMaximum();
                }
                if (doubleY > this.m_JControlGrid.getValue_YMaximum()) {
                    doubleY = this.m_JControlGrid.getValue_YMaximum();
                }
                if (!(doubleDistance_Old > (doubleDistance = Math.sqrt((p_X - doubleX) * (p_X - doubleX) + (p_Y - doubleY) * (p_Y - doubleY))))) continue;
                doubleDistance_Old = doubleDistance;
                o_Point2D.setLocation(doubleX, doubleY);
                boolFound = true;
            }
            if (!boolFound) {
                return null;
            }
            return o_Point2D;
        }

        public GridPoint findNearestGridPoint(double p_X, double p_Y) {
            GridPoint o_GridPoint;
            int intPoint;
            GridPoint o_GridPointFound = null;
            double o_MFound = 0.0;
            double o_CFound = 0.0;
            boolean boolFound = false;
            this.m_GridPoints_Calculated.clear();
            for (intPoint = 0; intPoint < this.m_GridPoints.size(); ++intPoint) {
                o_GridPoint = this.m_GridPoints.get(intPoint);
                this.m_GridPoints_Calculated.add(o_GridPoint);
            }
            block1: while (!boolFound) {
                o_GridPointFound = null;
                for (intPoint = 0; intPoint < this.m_GridPoints_Calculated.size(); ++intPoint) {
                    double doubleDiff2_Y;
                    double doubleDiff2_X;
                    double doubleDiff1_Y;
                    o_GridPoint = this.m_GridPoints_Calculated.get(intPoint);
                    if (o_GridPointFound == null) {
                        o_GridPointFound = o_GridPoint;
                        continue;
                    }
                    double doubleDiff1_X = p_X - Math.abs(o_GridPoint.getValueX());
                    if (!(doubleDiff1_X * doubleDiff1_X + (doubleDiff1_Y = p_Y - Math.abs(o_GridPoint.getValueY())) * doubleDiff1_Y < (doubleDiff2_X = p_X - Math.abs(o_GridPointFound.getValueX())) * doubleDiff2_X + (doubleDiff2_Y = p_Y - Math.abs(o_GridPointFound.getValueY())) * doubleDiff2_Y)) continue;
                    o_GridPointFound = o_GridPoint;
                }
                if (o_GridPointFound == null) {
                    return null;
                }
                if (p_X - o_GridPointFound.getValueX() != 0.0) {
                    o_MFound = (p_Y - o_GridPointFound.getValueY()) / (p_X - o_GridPointFound.getValueX());
                    o_CFound = p_Y - o_MFound * p_X;
                }
                boolFound = true;
                o_GridPoint = this.m_GridPoints.get(this.m_GridPoints.size() - 1);
                for (intPoint = 0; intPoint < this.m_GridPoints.size(); ++intPoint) {
                    double doubleY;
                    double doubleX;
                    GridPoint o_GridPoint_Previous = o_GridPoint;
                    o_GridPoint = this.m_GridPoints.get(intPoint);
                    if (o_GridPoint == o_GridPointFound || o_GridPoint_Previous == o_GridPointFound) continue;
                    if (o_GridPoint.getValueX() - o_GridPoint_Previous.getValueX() != 0.0) {
                        double o_MLine = (o_GridPoint.getValueY() - o_GridPoint_Previous.getValueY()) / (o_GridPoint.getValueX() - o_GridPoint_Previous.getValueX());
                        double o_CLine = o_GridPoint.getValueY() - o_MLine * o_GridPoint.getValueX();
                        if (p_X - o_GridPointFound.getValueX() != 0.0) {
                            if (o_MFound == o_MLine) continue;
                            doubleX = (o_CFound - o_CLine) / (o_MLine - o_MFound);
                            doubleY = (o_MLine * o_CFound - o_MFound * o_CLine) / (o_MLine - o_MFound);
                        } else {
                            doubleX = p_X;
                            doubleY = o_CLine + o_MLine * p_X;
                        }
                    } else {
                        if (p_X - o_GridPointFound.getValueX() == 0.0) continue;
                        doubleX = o_GridPointFound.getValueX();
                        doubleY = o_CFound + o_MFound * o_GridPoint.getValueX();
                    }
                    if (!(Math.abs(doubleX - p_X) < Math.abs(p_X - o_GridPointFound.getValueX())) || !(Math.abs(doubleX - o_GridPointFound.getValueX()) < Math.abs(p_X - o_GridPointFound.getValueX())) || !(Math.abs(doubleX - o_GridPoint.getValueX()) < Math.abs(o_GridPoint.getValueX() - o_GridPoint_Previous.getValueX())) || !(Math.abs(doubleX - o_GridPoint_Previous.getValueX()) < Math.abs(o_GridPoint.getValueX() - o_GridPoint_Previous.getValueX())) || !(Math.abs(doubleY - p_Y) < Math.abs(p_Y - o_GridPointFound.getValueY())) || !(Math.abs(doubleY - o_GridPointFound.getValueY()) < Math.abs(p_Y - o_GridPointFound.getValueY())) || !(Math.abs(doubleY - o_GridPoint.getValueY()) < Math.abs(o_GridPoint.getValueY() - o_GridPoint_Previous.getValueY())) || !(Math.abs(doubleY - o_GridPoint_Previous.getValueY()) < Math.abs(o_GridPoint.getValueY() - o_GridPoint_Previous.getValueY()))) continue;
                    this.m_GridPoints_Calculated.remove(o_GridPointFound);
                    boolFound = false;
                    continue block1;
                }
            }
            return o_GridPointFound;
        }

        public Point2D findMedianPoint(Point2D p_Point2D) {
            if (p_Point2D == null) {
                p_Point2D = new Point2D.Double();
            }
            p_Point2D.setLocation(0.0, 0.0);
            for (int intPoint = 0; intPoint < this.m_GridPoints.size(); ++intPoint) {
                GridPoint o_GridPoint = this.m_GridPoints.get(intPoint);
                p_Point2D.setLocation(p_Point2D.getX() + o_GridPoint.getValueX() / (double)this.m_GridPoints.size(), p_Point2D.getY() + o_GridPoint.getValueY() / (double)this.m_GridPoints.size());
            }
            return p_Point2D;
        }

        public int getGridPointCount() {
            return this.m_GridPoints.size();
        }

        public GridPoint getGridPoint(int p_Index) {
            if (p_Index < 0 || p_Index >= this.m_GridPoints.size()) {
                return null;
            }
            return this.m_GridPoints.get(p_Index);
        }

        public int getGridPointMiddleCount() {
            return this.m_GridPointsMiddle.size();
        }

        public GridPoint getGridPointMiddle(int p_Index) {
            if (p_Index < 0 || p_Index >= this.m_GridPointsMiddle.size()) {
                return null;
            }
            return this.m_GridPointsMiddle.get(p_Index);
        }

        public int getSortID() {
            return this.m_SortID;
        }

        public void setColor(Color p_Color) {
            if (p_Color == null) {
                return;
            }
            if (p_Color.equals(this.m_Color)) {
                return;
            }
            this.m_Color = p_Color;
            this.m_JControlGrid.getGridTrack().repaint();
        }

        public Color getColor() {
            return this.m_Color;
        }

        public void setText(String p_Text) {
            if (p_Text == null) {
                p_Text = "";
            }
            if (p_Text.equals(this.m_Text)) {
                return;
            }
            this.m_Text = p_Text;
            this.m_JControlGrid.getGridTrack().repaint();
        }

        public String getText() {
            return this.m_Text;
        }

        public Object getAreaObject() {
            return this.m_AreaObject;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof GridPoint && "position".equals(evt.getPropertyName())) {
                this.refreshPolygonValue();
                this.m_JControlGrid.getGridTrack().repaint();
            }
        }
    }

    public static class GridPoint
    extends JComponent {
        public static final String PROP_POSITION = "position";
        private double m_ValueHorizontal;
        private double m_ValueVertical;
        private Color m_Color;
        private String m_Text;
        private int m_Length;
        private AbsoluteConstraints m_Constraints;
        private JControlGrid m_JControlGrid;

        public GridPoint(JControlGrid p_JControlGrid) {
            this.m_JControlGrid = p_JControlGrid;
            this.initMembers();
            this.initComponents();
            this.m_Length = this.m_JControlGrid.getGridTrack().getAdjuster().getAdjusterLength();
        }

        private void initMembers() {
            this.m_ValueHorizontal = this.m_JControlGrid.getGridTrack().getControlDimension_X().getValueMinimum();
            this.m_ValueVertical = this.m_JControlGrid.getGridTrack().getControlDimension_Y().getValueMinimum();
            this.m_Color = Color.YELLOW;
        }

        private void initComponents() {
            this.m_Constraints = new AbsoluteConstraints(0, 0);
            MouseAdapter_Delayed o_MouseAdapter_Delayed = new MouseAdapter_Delayed(){

                public void mouseClicked_Delayed(MouseEvent e) {
                    double doubleNewValueX = m_ValueHorizontal;
                    double doubleNewValueY = m_ValueVertical;
                    double doubleDiffX = doubleNewValueX - m_JControlGrid.getValue_X();
                    double doubleDiffY = doubleNewValueY - m_JControlGrid.getValue_Y();
                    m_JControlGrid.setValues(doubleNewValueX, doubleDiffX, doubleNewValueY, doubleDiffY, 2);
                }

                public void mousePressed_Delayed(MouseEvent e) {
                }

                public void mouseReleased_Delayed(MouseEvent e) {
                }

                public void mouseEntered_Delayed(MouseEvent e) {
                }

                public void mouseExited_Delayed(MouseEvent e) {
                }
            };
            this.addMouseListener((MouseListener)o_MouseAdapter_Delayed);
        }

        public void close() {
            this.setVisible(false);
            if (this.m_JControlGrid != null) {
                this.m_JControlGrid.removeGridPoint(this);
            }
        }

        public AbsoluteConstraints getConstraints() {
            return this.m_Constraints;
        }

        public void setValues(double p_ValueHorizontal, double p_ValueVertical) {
            if (p_ValueHorizontal < this.m_JControlGrid.getGridTrack().getControlDimension_X().getValueMinimum()) {
                p_ValueHorizontal = this.m_JControlGrid.getGridTrack().getControlDimension_X().getValueMinimum();
            }
            if (p_ValueHorizontal > this.m_JControlGrid.getGridTrack().getControlDimension_X().getValueMaximum()) {
                p_ValueHorizontal = this.m_JControlGrid.getGridTrack().getControlDimension_X().getValueMaximum();
            }
            this.m_ValueHorizontal = p_ValueHorizontal;
            if (p_ValueVertical < this.m_JControlGrid.getGridTrack().getControlDimension_Y().getValueMinimum()) {
                p_ValueVertical = this.m_JControlGrid.getGridTrack().getControlDimension_Y().getValueMinimum();
            }
            if (p_ValueVertical > this.m_JControlGrid.getGridTrack().getControlDimension_Y().getValueMaximum()) {
                p_ValueVertical = this.m_JControlGrid.getGridTrack().getControlDimension_Y().getValueMaximum();
            }
            this.m_ValueVertical = p_ValueVertical;
            this.m_JControlGrid.getGridTrack().calculateGridPoints();
            this.repaint();
        }

        public double getValueX() {
            return this.m_ValueHorizontal;
        }

        public double getValueY() {
            return this.m_ValueVertical;
        }

        public void setColor(Color p_Color) {
            this.m_Color = p_Color;
            this.repaint();
        }

        public Color getColor() {
            return this.m_Color;
        }

        public void setText(String p_Text) {
            this.m_Text = p_Text == null ? "" : p_Text;
            this.setToolTipText(this.m_Text);
        }

        public String getText() {
            return this.m_Text;
        }

        public void setLength(int p_Length) {
            if (p_Length <= 0) {
                p_Length = 1;
            }
            if (this.m_Length == p_Length) {
                return;
            }
            this.m_Length = p_Length;
            this.m_JControlGrid.getGridTrack().calculateGridPoints();
            this.repaint();
        }

        public int getLength() {
            return this.m_Length;
        }

        @Override
        public void paintComponent(Graphics p_Graphics) {
            Graphics2D g2d = (Graphics2D)p_Graphics;
            g2d.setColor(this.m_Color);
            g2d.fillOval(0, 0, this.m_Length - 1, this.m_Length - 1);
            g2d.setColor(Color.BLACK);
            p_Graphics.drawOval(0, 0, this.m_Length - 1, this.m_Length - 1);
        }
    }

    public static class GridTrack
    extends JComponent
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        protected ControlObject m_ControlObject;
        protected ControlObject.ControlDimension m_ControlDimension_X;
        protected ControlObject.ControlDimension m_ControlDimension_Y;
        protected GridAdjuster m_Adjuster;
        protected GridAdjusterAxis m_AdjusterAxis_X;
        protected GridAdjusterAxis m_AdjusterAxis_Y;
        protected boolean m_TrackGridVisible;
        protected Insets m_TrackInsets;
        protected boolean m_TrackOpaque;
        protected Point m_Point;
        protected GridTrack m_SelfReference;
        protected AbsoluteLayout m_LayoutManager;
        protected AbsoluteConstraints m_TrackConstraints;
        private Rectangle m_RectInside;
        protected ArrayList<GridPoint> m_GridPoints;
        protected ArrayList<GridArea> m_GridAreas;
        protected ArrayList<GridArea> m_RestrictedGridAreas;
        protected ArrayList<GridArea> m_GridAreas_AdjusterInside;
        protected ArrayList<GridArea> m_GridAreas_AdjusterInside_Temp;
        protected final Object m_SyncGridAreas_AdjusterInside = new Object();
        protected Point2D m_Point2D_Calculated;
        protected Point2D m_Point2D_CalculatedNew;
        private int m_DragPos_X;
        private int m_DragPos_Y;
        private int m_OldPos_X;
        private int m_OldPos_Y;
        private double m_OldValue_X;
        private double m_OldValue_Y;
        static final long serialVersionUID = 1916776343808321099L;

        public GridTrack() {
            this.initMembers();
            this.initComponents();
        }

        public GridTrack(ControlObject p_ControlObject) {
            this.m_ControlObject = p_ControlObject;
            this.m_ControlDimension_X = this.m_ControlObject.getControlDimension(0);
            this.m_ControlDimension_Y = this.m_ControlObject.getControlDimension(1);
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_SelfReference = this;
            this.setBackground(Color.LIGHT_GRAY);
            this.m_TrackGridVisible = true;
            this.m_TrackInsets = new Insets(17, 25, 25, 10);
            this.m_TrackOpaque = true;
            this.m_Adjuster = new GridAdjuster(this.m_ControlObject);
            this.m_AdjusterAxis_X = new GridAdjusterAxis(this.m_ControlDimension_X);
            this.m_AdjusterAxis_Y = new GridAdjusterAxis(this.m_ControlDimension_Y);
            this.m_Point = new Point();
            this.m_RectInside = new Rectangle();
            this.m_GridPoints = new ArrayList();
            this.m_GridAreas = new ArrayList();
            this.m_RestrictedGridAreas = new ArrayList();
            this.m_GridAreas_AdjusterInside = new ArrayList();
            this.m_GridAreas_AdjusterInside_Temp = new ArrayList();
            this.m_Point2D_Calculated = new Point2D.Double();
            this.m_Point2D_CalculatedNew = new Point2D.Double();
        }

        private Object readResolve() {
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
            p_ObjectOutput.writeInt(1);
            p_ObjectOutput.writeBoolean(this.m_TrackOpaque);
            p_ObjectOutput.writeBoolean(this.m_TrackGridVisible);
            ImagesTools.writeInsets((ObjectOutput)p_ObjectOutput, (Insets)this.m_TrackInsets);
            this.m_Adjuster.writeExternal(p_ObjectOutput);
            this.m_AdjusterAxis_X.writeExternal(p_ObjectOutput);
            this.m_AdjusterAxis_Y.writeExternal(p_ObjectOutput);
        }

        @Override
        public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = p_ObjectInput.readInt();
            this.m_TrackOpaque = p_ObjectInput.readBoolean();
            this.m_TrackGridVisible = p_ObjectInput.readBoolean();
            this.m_TrackInsets = ImagesTools.readInsets((ObjectInput)p_ObjectInput);
            this.m_Adjuster.readExternal(p_ObjectInput);
            this.m_AdjusterAxis_X.readExternal(p_ObjectInput);
            this.m_AdjusterAxis_Y.readExternal(p_ObjectInput);
        }

        private void initComponents() {
            this.setOpaque(false);
            this.m_LayoutManager = new AbsoluteLayout();
            this.setLayout(this.m_LayoutManager);
            this.m_TrackConstraints = new AbsoluteConstraints(0, 0, 0, 0);
            this.add(this.m_AdjusterAxis_X, this.m_AdjusterAxis_X.getConstraints(), 0);
            this.add(this.m_AdjusterAxis_Y, this.m_AdjusterAxis_Y.getConstraints(), 0);
            this.add(this.m_Adjuster, this.m_Adjuster.getConstraints(), 0);
            this.setVisible(true);
            MouseAdapter_Delayed o_MouseAdapter_Delayed = new MouseAdapter_Delayed(){

                public void mousePressed_Delayed(MouseEvent me) {
                    if (!(me.getButton() != 1 || me.isAltDown() || me.isAltGraphDown() || me.isControlDown() || me.isMetaDown() || me.isShiftDown())) {
                        m_DragPos_X = me.getX();
                        m_OldPos_X = me.getX();
                        m_DragPos_Y = me.getY();
                        m_OldPos_Y = me.getY();
                        m_OldValue_X = m_ControlDimension_X.getValue();
                        m_OldValue_Y = m_ControlDimension_Y.getValue();
                        this.requestFocus();
                    }
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseClicked_Delayed(MouseEvent me) {
                    if (!(me.getButton() != 1 || me.isAltDown() || me.isAltGraphDown() || me.isControlDown() || me.isMetaDown() || me.isShiftDown())) {
                        ControlObject.ControlLabels o_Labels = m_ControlDimension_Y.getControlLabels();
                        Component o_Component = o_Labels.getComponentAt(me.getX() - o_Labels.getLabelsInsets().left + m_TrackInsets.left, me.getY() - o_Labels.getLabelsInsets().top + m_TrackInsets.top);
                        if (o_Component instanceof ControlObject.ControlLabels.ControlLabel) {
                            ((ControlObject.ControlLabels.ControlLabel)((Object)o_Component)).setValue(2);
                            return;
                        }
                        o_Labels = m_ControlDimension_X.getControlLabels();
                        o_Component = o_Labels.getComponentAt(me.getX() - o_Labels.getLabelsInsets().left + m_TrackInsets.left, me.getY() - o_Labels.getLabelsInsets().top + m_TrackInsets.top);
                        if (o_Component instanceof ControlObject.ControlLabels.ControlLabel) {
                            ((ControlObject.ControlLabels.ControlLabel)((Object)o_Component)).setValue(2);
                            return;
                        }
                        ControlObject.ControlBlocks o_Blocks = m_ControlDimension_Y.getControlBlocks();
                        o_Component = o_Blocks.getComponentAt(me.getX() - o_Blocks.getBlocksInsets().left + m_TrackInsets.left, me.getY() - o_Blocks.getBlocksInsets().top + m_TrackInsets.top);
                        if (o_Component instanceof ControlObject.ControlBlocks.ControlBlock) {
                            ((ControlObject.ControlBlocks.ControlBlock)((Object)o_Component)).setValue(2);
                            return;
                        }
                        o_Blocks = m_ControlDimension_X.getControlBlocks();
                        o_Component = o_Blocks.getComponentAt(me.getX() - o_Blocks.getBlocksInsets().left + m_TrackInsets.left, me.getY() - o_Blocks.getBlocksInsets().top + m_TrackInsets.top);
                        if (o_Component instanceof ControlObject.ControlBlocks.ControlBlock) {
                            ((ControlObject.ControlBlocks.ControlBlock)((Object)o_Component)).setValue(2);
                            return;
                        }
                        int intDimensionIndexY = m_ControlDimension_Y.getDimensionIndex();
                        int intDimensionIndexX = m_ControlDimension_X.getDimensionIndex();
                        double doubleNewValueX = m_ControlObject.getValuesFromInnerComponentPosition(m_SelfReference, me.getX(), me.getY())[intDimensionIndexX];
                        double doubleNewValueY = m_ControlObject.getValuesFromInnerComponentPosition(m_SelfReference, me.getX(), me.getY())[intDimensionIndexY];
                        ((JControlGrid)m_ControlObject).setValues(doubleNewValueX, doubleNewValueX - m_ControlDimension_X.getValue(), doubleNewValueY, doubleNewValueY - m_ControlDimension_Y.getValue(), 2);
                    }
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseReleased_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseEntered_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseExited_Delayed(MouseEvent me) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseDragged_Delayed(MouseEvent me) {
                    if (!(me.isAltDown() || me.isAltGraphDown() || me.isControlDown() || me.isMetaDown() || me.isShiftDown())) {
                        int intLength = 1;
                        int intPosition = 0;
                        int intDiff = 0;
                        intLength = this.getParent().getHeight() - m_Adjuster.getAdjusterLength();
                        intPosition = me.getY() - m_DragPos_Y;
                        intDiff = me.getY() - m_OldPos_Y;
                        m_OldPos_Y = me.getY();
                        if (!m_ControlDimension_Y.getInverted()) {
                            intPosition = -intPosition;
                            intDiff = -intDiff;
                        }
                        double doubleValue_Y_Diff = m_ControlDimension_Y.getMouseMoveFactor() * ((double)intDiff / (double)intLength * (m_ControlDimension_Y.getValueMaximum() - m_ControlDimension_Y.getValueMinimum()));
                        double doubleNewValueY = m_OldValue_Y + m_ControlDimension_Y.getMouseMoveFactor() * ((double)intPosition / (double)intLength * (m_ControlDimension_Y.getValueMaximum() - m_ControlDimension_Y.getValueMinimum()));
                        intLength = this.getParent().getWidth() - m_Adjuster.getAdjusterLength();
                        intPosition = me.getX() - m_DragPos_X;
                        intDiff = me.getX() - m_OldPos_X;
                        m_OldPos_X = me.getX();
                        if (m_ControlDimension_X.getInverted()) {
                            intPosition = -intPosition;
                            intDiff = -intDiff;
                        }
                        double doubleValue_X_Diff = m_ControlDimension_X.getMouseMoveFactor() * ((double)intDiff / (double)intLength) * (m_ControlDimension_X.getValueMaximum() - m_ControlDimension_X.getValueMinimum());
                        double doubleNewValueX = m_OldValue_X + m_ControlDimension_X.getMouseMoveFactor() * ((double)intPosition / (double)intLength) * (m_ControlDimension_X.getValueMaximum() - m_ControlDimension_X.getValueMinimum());
                        ((JControlGrid)m_ControlObject).setValues(doubleNewValueX, doubleValue_X_Diff, doubleNewValueY, doubleValue_Y_Diff, 4);
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, me);
                }

                public void mouseMoved_Delayed(MouseEvent e) {
                    m_ControlObject.fireMouseListenerEvent(m_SelfReference, e);
                }
            };
            this.addMouseListener((MouseListener)o_MouseAdapter_Delayed);
            this.addMouseMotionListener((MouseMotionListener)o_MouseAdapter_Delayed);
        }

        public void setValues(double p_ValueX, double p_ValueDiffX, double p_ValueY, double p_ValueDiffY, int p_ActionFlag) {
            this.m_ControlDimension_X.setValue(p_ValueX, p_ValueDiffX, p_ActionFlag);
            this.m_ControlDimension_Y.setValue(p_ValueY, p_ValueDiffY, p_ActionFlag);
            this.m_ControlObject.setValueManuallyIsReady();
        }

        public GridPoint addGridPoint(double p_ValueHorizontal, double p_ValueVertical, Color p_Color) {
            GridPoint o_GridPoint = new GridPoint((JControlGrid)this.getControlObject());
            o_GridPoint.setValues(p_ValueHorizontal, p_ValueVertical);
            o_GridPoint.setColor(p_Color);
            this.addGridPoint(o_GridPoint);
            return o_GridPoint;
        }

        public void addGridPoint(GridPoint p_GridPoint) {
            if (p_GridPoint == null) {
                return;
            }
            if (this.m_GridPoints.contains(p_GridPoint)) {
                return;
            }
            this.m_GridPoints.add(p_GridPoint);
            p_GridPoint.setVisible(true);
            this.add((Component)p_GridPoint, p_GridPoint.getConstraints());
            this.calculateGridPoints();
            this.repaint();
        }

        public void removeGridPoint(GridPoint p_GridPoint) {
            if (p_GridPoint == null) {
                return;
            }
            this.m_GridPoints.remove(p_GridPoint);
            p_GridPoint.setVisible(false);
            this.remove(p_GridPoint);
            this.calculateGridPoints();
            this.repaint();
        }

        public int getGridPointCount() {
            return this.m_GridPoints.size();
        }

        public GridPoint getGridPoint(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_GridPoints.size()) {
                return null;
            }
            return this.m_GridPoints.get(p_Index);
        }

        public GridArea addGridArea(int p_SortID, String p_Text, Color p_Color, ArrayList<GridPoint> p_GridPoints, ArrayList<GridPoint> p_GridPointsMiddle, Object p_AreaObject) {
            GridArea o_GridArea = new GridArea(p_SortID, p_Text, (JControlGrid)this.getControlObject(), p_AreaObject);
            o_GridArea.setGridPoints(p_GridPoints);
            o_GridArea.setGridPointsMiddle(p_GridPointsMiddle);
            o_GridArea.setColor(p_Color);
            this.addGridArea(o_GridArea);
            return o_GridArea;
        }

        public void addGridArea(GridArea p_GridArea) {
            if (p_GridArea == null) {
                return;
            }
            if (this.m_GridAreas.contains(p_GridArea)) {
                return;
            }
            int intArea = 0;
            for (intArea = 0; intArea < this.m_GridAreas.size(); ++intArea) {
                GridArea o_GridArea = this.m_GridAreas.get(intArea);
                if (p_GridArea.getSortID() < o_GridArea.getSortID()) break;
            }
            this.m_GridAreas.add(intArea, p_GridArea);
            this.calculateGridPoints();
            this.repaint();
        }

        public void removeGridArea(GridArea p_GridArea) {
            if (p_GridArea == null) {
                return;
            }
            this.m_GridAreas.remove(p_GridArea);
            this.removeRestrictedGridArea(p_GridArea);
            this.calculateGridPoints();
            this.repaint();
        }

        public int getGridAreaCount() {
            return this.m_GridAreas.size();
        }

        public GridArea getGridAreaBySortID(int p_SortID) {
            for (int intArea = 0; intArea < this.m_GridAreas.size(); ++intArea) {
                GridArea o_GridArea = this.m_GridAreas.get(intArea);
                if (o_GridArea.getSortID() != p_SortID) continue;
                return o_GridArea;
            }
            return null;
        }

        public GridArea getGridArea(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_GridAreas.size()) {
                return null;
            }
            return this.m_GridAreas.get(p_Index);
        }

        public ArrayList<GridArea> getGridAreas_Inside(double p_X, double p_Y) {
            this.m_GridAreas_AdjusterInside_Temp.clear();
            for (int intArea = 0; intArea < this.m_GridAreas.size(); ++intArea) {
                GridArea o_GridArea = this.m_GridAreas.get(intArea);
                boolean boolInside = false;
                if (!o_GridArea.getComplete() || o_GridArea.getFailure() || !o_GridArea.getEnabled()) continue;
                for (int intPoint = 0; intPoint < o_GridArea.getGridPointCount(); ++intPoint) {
                    GridPoint o_GridPoint = o_GridArea.getGridPoint(intPoint);
                    if (o_GridPoint.getValueX() != p_X || o_GridPoint.getValueY() != p_Y) continue;
                    this.m_GridAreas_AdjusterInside_Temp.add(o_GridArea);
                    boolInside = true;
                    break;
                }
                if (boolInside || !o_GridArea.isInside(p_X, p_Y)) continue;
                this.m_GridAreas_AdjusterInside_Temp.add(o_GridArea);
            }
            return this.m_GridAreas_AdjusterInside_Temp;
        }

        public ArrayList<GridArea> getGridAreas_InsideWithIntersection(double p_X, double p_Y) {
            this.m_GridAreas_AdjusterInside_Temp.clear();
            this.getGridAreas_Inside(p_X, p_Y);
            if (this.m_GridAreas_AdjusterInside_Temp.size() > 0) {
                // empty if block
            }
            for (int intArea = 0; intArea < this.m_GridAreas.size(); ++intArea) {
                GridArea o_GridArea = this.m_GridAreas.get(intArea);
                Point2D o_Point2D = null;
                if ((o_Point2D = o_GridArea.calculateIntersectionDirected(o_Point2D, p_X, p_Y)) == null || (int)o_Point2D.getX() != (int)p_X || (int)o_Point2D.getY() != (int)p_Y || this.m_GridAreas_AdjusterInside_Temp.contains(o_GridArea)) continue;
                this.m_GridAreas_AdjusterInside_Temp.add(o_GridArea);
            }
            return this.m_GridAreas_AdjusterInside_Temp;
        }

        public void addRestrictedGridArea(GridArea p_GridArea) {
            if (p_GridArea == null) {
                return;
            }
            if (this.m_RestrictedGridAreas.contains(p_GridArea)) {
                return;
            }
            int intArea = 0;
            for (intArea = 0; intArea < this.m_RestrictedGridAreas.size(); ++intArea) {
                GridArea o_GridArea = this.m_RestrictedGridAreas.get(intArea);
                if (p_GridArea.getSortID() < o_GridArea.getSortID()) break;
            }
            this.m_RestrictedGridAreas.add(intArea, p_GridArea);
        }

        public void removeRestrictedGridArea(GridArea p_GridArea) {
            if (p_GridArea == null) {
                return;
            }
            if (!this.m_RestrictedGridAreas.contains(p_GridArea)) {
                return;
            }
            this.m_RestrictedGridAreas.remove(p_GridArea);
        }

        public boolean containsRestrictedGridArea(GridArea p_GridArea) {
            if (p_GridArea == null) {
                return false;
            }
            return this.m_RestrictedGridAreas.contains(p_GridArea);
        }

        public int getRestrctedGridAreaCount() {
            return this.m_RestrictedGridAreas.size();
        }

        public GridArea getRestrictedGridArea(int p_Indes) {
            if (p_Indes < 0) {
                return null;
            }
            if (p_Indes >= this.m_RestrictedGridAreas.size()) {
                return null;
            }
            return this.m_RestrictedGridAreas.get(p_Indes);
        }

        public GridArea getRestrictedGridAreaBySortID(int p_SortID) {
            for (int intArea = 0; intArea < this.m_RestrictedGridAreas.size(); ++intArea) {
                GridArea o_GridArea = this.m_RestrictedGridAreas.get(intArea);
                if (o_GridArea.getSortID() != p_SortID) continue;
                return o_GridArea;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Point2D checkValuesInAreas(double p_X, double p_Y) {
            GridArea o_GridArea;
            ArrayList<GridArea> o_GridAreas_AdjusterInside = this.getGridAreas_Inside(p_X, p_Y);
            if (o_GridAreas_AdjusterInside != null) {
                for (int intGridArea = 0; intGridArea < o_GridAreas_AdjusterInside.size(); ++intGridArea) {
                    o_GridArea = o_GridAreas_AdjusterInside.get(intGridArea);
                    if (!o_GridArea.getComplete() || o_GridArea.getFailure() || !o_GridArea.getEnabled() || !this.containsRestrictedGridArea(o_GridArea)) continue;
                    Object object = this.m_SyncGridAreas_AdjusterInside;
                    synchronized (object) {
                        this.m_GridAreas_AdjusterInside.clear();
                        this.m_GridAreas_AdjusterInside.add(o_GridArea);
                    }
                    return null;
                }
            }
            GridArea o_GridArea_Found = null;
            boolean boolPointFound = false;
            for (int intArea = 0; intArea < this.m_RestrictedGridAreas.size(); ++intArea) {
                double doubleDiff2_Y;
                Point2D o_Point2D;
                o_GridArea = this.m_RestrictedGridAreas.get(intArea);
                if (!o_GridArea.getComplete() || o_GridArea.getFailure() || !o_GridArea.getEnabled() || (o_Point2D = o_GridArea.calculateIntersectionDirected(this.m_Point2D_CalculatedNew, p_X, p_Y)) == null) continue;
                if (!boolPointFound) {
                    this.m_Point2D_Calculated.setLocation(o_Point2D.getX(), o_Point2D.getY());
                    this.m_GridAreas_AdjusterInside_Temp.clear();
                    this.m_GridAreas_AdjusterInside_Temp.add(o_GridArea);
                    boolPointFound = true;
                    continue;
                }
                double doubleDiff1_X = p_X - this.m_Point2D_Calculated.getX();
                double doubleDiff1_Y = p_Y - this.m_Point2D_Calculated.getY();
                double doubleDiff2_X = p_X - o_Point2D.getX();
                if (!(doubleDiff2_X * doubleDiff2_X + (doubleDiff2_Y = p_Y - o_Point2D.getY()) * doubleDiff2_Y < doubleDiff1_X * doubleDiff1_X + doubleDiff1_Y * doubleDiff1_Y)) continue;
                this.m_Point2D_Calculated.setLocation(o_Point2D);
                this.m_GridAreas_AdjusterInside_Temp.clear();
                this.m_GridAreas_AdjusterInside_Temp.add(o_GridArea);
                o_GridArea_Found = o_GridArea;
            }
            if (boolPointFound) {
                Object object = this.m_SyncGridAreas_AdjusterInside;
                synchronized (object) {
                    this.m_GridAreas_AdjusterInside.clear();
                    this.m_GridAreas_AdjusterInside.addAll(this.m_GridAreas_AdjusterInside_Temp);
                }
                return this.m_Point2D_Calculated;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearGridAreas_AdjusterInside() {
            Object object = this.m_SyncGridAreas_AdjusterInside;
            synchronized (object) {
                this.m_GridAreas_AdjusterInside.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addGridArea_AdjusterInside(GridArea p_GridArea) {
            if (p_GridArea == null) {
                return;
            }
            Object object = this.m_SyncGridAreas_AdjusterInside;
            synchronized (object) {
                if (this.m_GridAreas_AdjusterInside.contains(p_GridArea)) {
                    return;
                }
                this.m_GridAreas_AdjusterInside.add(p_GridArea);
            }
        }

        public ArrayList<GridArea> getGridAreas_AdjusterInside() {
            return this.m_GridAreas_AdjusterInside;
        }

        public int getGridArea_AdjusterInsideCount() {
            return this.m_GridAreas_AdjusterInside.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GridArea getGridArea_AdjusterInside(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncGridAreas_AdjusterInside;
            synchronized (object) {
                if (p_Index >= this.m_GridAreas_AdjusterInside.size()) {
                    return null;
                }
                return this.m_GridAreas_AdjusterInside.get(p_Index);
            }
        }

        public void calculateGridPoints() {
            int intHeight = this.m_TrackConstraints.height;
            int intWidth = this.m_TrackConstraints.width;
            for (int intPoint = 0; intPoint < this.m_GridPoints.size(); ++intPoint) {
                GridPoint o_GridPoint = this.m_GridPoints.get(intPoint);
                int intValueMidPosition_Y = (int)((double)intHeight * (o_GridPoint.getValueY() - this.m_ControlDimension_Y.getValueMinimum()) / (this.m_ControlDimension_Y.getValueMaximum() - this.m_ControlDimension_Y.getValueMinimum()));
                if (!this.m_ControlDimension_Y.getInverted()) {
                    intValueMidPosition_Y = intHeight - intValueMidPosition_Y;
                }
                int intValueMidPosition_X = (int)((double)intWidth * (o_GridPoint.getValueX() - this.m_ControlDimension_X.getValueMinimum()) / (this.m_ControlDimension_X.getValueMaximum() - this.m_ControlDimension_X.getValueMinimum()));
                if (this.m_ControlDimension_X.getInverted()) {
                    intValueMidPosition_X = intWidth - intValueMidPosition_X;
                }
                int intGridPointX = intValueMidPosition_X - o_GridPoint.getLength() / 2;
                int intGridPointY = intValueMidPosition_Y - o_GridPoint.getLength() / 2;
                if (o_GridPoint.getConstraints() == null) continue;
                o_GridPoint.getConstraints().x = intGridPointX;
                o_GridPoint.getConstraints().y = intGridPointY;
                o_GridPoint.getConstraints().width = o_GridPoint.getLength();
                o_GridPoint.getConstraints().height = o_GridPoint.getLength();
                o_GridPoint.revalidate();
            }
        }

        @Override
        public void setForeground(Color p_Color) {
            this.m_Adjuster.setForeground(p_Color);
            super.setForeground(p_Color);
        }

        public ControlObject getControlObject() {
            return this.m_ControlObject;
        }

        public GridAdjuster getAdjuster() {
            return this.m_Adjuster;
        }

        public GridAdjusterAxis getAdjusterAxis_X() {
            return this.m_AdjusterAxis_X;
        }

        public GridAdjusterAxis getAdjusterAxis_Y() {
            return this.m_AdjusterAxis_Y;
        }

        public AbsoluteConstraints getConstraints() {
            return this.m_TrackConstraints;
        }

        public boolean getTrackGridVisible() {
            return this.m_TrackGridVisible;
        }

        public void setTrackGridVisible(boolean p_Visible) {
            boolean oldValue = this.m_TrackGridVisible;
            this.m_TrackGridVisible = p_Visible;
            if (oldValue != this.m_TrackGridVisible) {
                this.firePropertyChange(JControlGrid.PROP_TRACKGRIDVISIBLE, oldValue, this.m_TrackGridVisible);
            }
        }

        public boolean getTrackOpaque() {
            return this.m_TrackOpaque;
        }

        public void setTrackOpaque(boolean p_Visible) {
            boolean oldValue = this.m_TrackOpaque;
            this.m_TrackOpaque = p_Visible;
            if (oldValue != this.m_TrackOpaque) {
                this.firePropertyChange(JControlGrid.PROP_TRACKOPAQUE, oldValue, this.m_TrackOpaque);
            }
        }

        public Insets getTrackInsets() {
            return this.m_TrackInsets;
        }

        public void setTrackInsets(Insets p_Insets) {
            Insets oldValue = this.m_TrackInsets;
            this.m_TrackInsets = p_Insets;
            if (!this.m_TrackInsets.equals(oldValue)) {
                this.m_ControlObject.calculateInnerItems();
                this.firePropertyChange(JControlGrid.PROP_TRACKINSETS, oldValue, this.m_TrackInsets);
            }
        }

        public void setTrackInsets(int p_Top, int p_Left, int p_Bottom, int p_Right) {
            this.setTrackInsets(new Insets(p_Top, p_Left, p_Bottom, p_Right));
        }

        public ControlObject.ControlDimension getControlDimension_X() {
            return this.m_ControlDimension_X;
        }

        public ControlObject.ControlDimension getControlDimension_Y() {
            return this.m_ControlDimension_Y;
        }

        private void calculateAdjuster() {
            AbsoluteConstraints o_Constraints;
            int intAdjusterHight = this.m_Adjuster.getAdjusterLength();
            int intAdjusterWidth = this.m_Adjuster.getAdjusterLength();
            int intValueLength_Y = this.m_TrackConstraints.height;
            int intValueLength_X = this.m_TrackConstraints.width;
            int intValueMidPosition_Y = (int)((double)intValueLength_Y * (this.m_ControlDimension_Y.getValue() - this.m_ControlDimension_Y.getValueMinimum()) / (this.m_ControlDimension_Y.getValueMaximum() - this.m_ControlDimension_Y.getValueMinimum()));
            if (!this.m_ControlDimension_Y.getInverted()) {
                intValueMidPosition_Y = intValueLength_Y - intValueMidPosition_Y;
            }
            int intValueMidPosition_X = (int)((double)intValueLength_X * (this.m_ControlDimension_X.getValue() - this.m_ControlDimension_X.getValueMinimum()) / (this.m_ControlDimension_X.getValueMaximum() - this.m_ControlDimension_X.getValueMinimum()));
            if (this.m_ControlDimension_X.getInverted()) {
                intValueMidPosition_X = intValueLength_X - intValueMidPosition_X;
            }
            int intAdjusterX = intValueMidPosition_X;
            int intAdjusterY = intValueMidPosition_Y;
            if (this.m_Adjuster.getConstraints() != null) {
                this.m_Adjuster.getConstraints().x = intAdjusterX - intAdjusterWidth / 2;
                this.m_Adjuster.getConstraints().y = intAdjusterY - intAdjusterHight / 2;
                this.m_Adjuster.getConstraints().width = intAdjusterWidth;
                this.m_Adjuster.getConstraints().height = intAdjusterHight;
                this.m_Adjuster.revalidate();
            }
            if (this.m_AdjusterAxis_X != null) {
                intAdjusterHight = this.m_AdjusterAxis_X.getAdjusterLength();
                intAdjusterWidth = this.m_AdjusterAxis_X.getAdjusterLength();
                o_Constraints = this.m_AdjusterAxis_X.getConstraints();
                o_Constraints.x = intAdjusterX - intAdjusterWidth / 2;
                o_Constraints.y = intValueLength_Y - intAdjusterHight;
                o_Constraints.width = intAdjusterWidth;
                o_Constraints.height = intAdjusterHight;
                this.m_AdjusterAxis_X.revalidate();
            }
            if (this.m_AdjusterAxis_Y != null) {
                intAdjusterHight = this.m_AdjusterAxis_Y.getAdjusterLength();
                intAdjusterWidth = this.m_AdjusterAxis_Y.getAdjusterLength();
                o_Constraints = this.m_AdjusterAxis_Y.getConstraints();
                o_Constraints.x = 0;
                o_Constraints.y = intAdjusterY - intAdjusterWidth / 2;
                o_Constraints.width = intAdjusterWidth;
                o_Constraints.height = intAdjusterHight;
                this.m_AdjusterAxis_Y.revalidate();
            }
        }

        @Override
        public void paintComponent(Graphics p_Graphics) {
            this.m_RectInside = this.getBounds(this.m_RectInside);
            Graphics2D g2d = (Graphics2D)p_Graphics;
            g2d.setColor(this.getForeground());
            g2d.drawRect(0, 0, this.m_RectInside.width - 1, this.m_RectInside.height - 1);
            int intLength_X = this.m_RectInside.width;
            int intLength_Y = this.m_RectInside.height;
            double doubleLengthValue_X = this.m_ControlDimension_X.getValueMaximum() - this.m_ControlDimension_X.getValueMinimum();
            double doubleLengthValue_Y = this.m_ControlDimension_Y.getValueMaximum() - this.m_ControlDimension_Y.getValueMinimum();
            this.m_RectInside.x = 1;
            this.m_RectInside.y = 1;
            this.m_RectInside.width -= 2;
            this.m_RectInside.height -= 2;
            if (this.m_TrackOpaque) {
                g2d.setColor(this.getParent().getBackground());
                g2d.fillRect(this.m_RectInside.x, this.m_RectInside.y, this.m_RectInside.width, this.m_RectInside.height);
            }
            for (int intArea = 0; intArea < this.m_GridAreas.size(); ++intArea) {
                Polygon o_Polygon;
                GridArea o_GridArea = this.m_GridAreas.get(intArea);
                if (!o_GridArea.getComplete()) continue;
                if (!o_GridArea.getFailure()) {
                    o_Polygon = o_GridArea.getPolygon(intLength_X, doubleLengthValue_X, intLength_Y, doubleLengthValue_Y, this.m_ControlDimension_X.getInverted(), this.m_ControlDimension_Y.getInverted());
                    Color o_Color_GridArea = o_GridArea.getColor();
                    if (!o_GridArea.getEnabled()) {
                        o_Color_GridArea = GraphicsTools.newColorSave((int)o_Color_GridArea.getRed(), (int)o_Color_GridArea.getGreen(), (int)o_Color_GridArea.getBlue(), (int)30);
                    }
                    g2d.setColor(o_Color_GridArea);
                    g2d.fillPolygon(o_Polygon);
                    if (o_GridArea.getMiddlePoint() == null) continue;
                    double doubleX = o_GridArea.getMiddlePoint().getX();
                    double doubleY = o_GridArea.getMiddlePoint().getY();
                    int intX = !this.m_ControlDimension_X.getInverted() ? (int)(doubleX / doubleLengthValue_X * (double)intLength_X) : intLength_X - (int)(doubleX / doubleLengthValue_Y * (double)intLength_X);
                    int intY = !this.m_ControlDimension_Y.getInverted() ? intLength_Y - (int)(doubleY / doubleLengthValue_Y * (double)intLength_Y) : (int)(doubleY / doubleLengthValue_Y * (double)intLength_Y);
                    g2d.setColor(Color.BLACK);
                    g2d.drawOval(intX - 3, intY - 3, 7, 7);
                    continue;
                }
                o_Polygon = o_GridArea.getPolygon(intLength_X, doubleLengthValue_X, intLength_Y, doubleLengthValue_Y, this.m_ControlDimension_X.getInverted(), this.m_ControlDimension_Y.getInverted());
                g2d.setColor(Color.GRAY);
                g2d.fillPolygon(o_Polygon);
                g2d.setColor(Color.RED);
                g2d.drawPolygon(o_Polygon);
            }
            g2d.setColor(this.getForeground());
            if (this.m_TrackGridVisible && this.m_ControlDimension_X.getTicksMajor() > 0.0 && this.m_ControlDimension_Y.getTicksMajor() > 0.0) {
                for (double doubleValueX = this.m_ControlDimension_X.getValueMinimum(); doubleValueX <= this.m_ControlDimension_X.getValueMaximum(); doubleValueX += this.m_ControlDimension_X.getTicksMajor()) {
                    for (double doubleValueY = this.m_ControlDimension_Y.getValueMinimum(); doubleValueY <= this.m_ControlDimension_Y.getValueMaximum(); doubleValueY += this.m_ControlDimension_Y.getTicksMajor()) {
                        this.m_Point.x = !this.m_ControlDimension_X.getInverted() ? (int)(doubleValueX / doubleLengthValue_X * (double)intLength_X) : intLength_X - (int)(doubleValueX / doubleLengthValue_X * (double)intLength_X);
                        this.m_Point.y = this.m_ControlDimension_Y.getInverted() ? (int)(doubleValueY / doubleLengthValue_Y * (double)intLength_Y) : intLength_Y - (int)(doubleValueY / doubleLengthValue_Y * (double)intLength_Y);
                        g2d.drawLine(this.m_Point.x - 1, this.m_Point.y, this.m_Point.x + 1, this.m_Point.y);
                        g2d.drawLine(this.m_Point.x, this.m_Point.y - 1, this.m_Point.x, this.m_Point.y + 1);
                    }
                }
            }
            super.paintComponent(p_Graphics);
        }
    }
}

