/*
 * Decompiled with CFR 0.152.
 */
package LiveShowControlObjects;

import LiveShowControlObjects.ControlObject;
import ToolsGraphics.ImagesTools;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class ControlGroupSimple
implements PropertyChangeListener,
Externalizable {
    public static final int CHANGETYPE_VALUE = 0;
    public static final int CHANGETYPE_VALUE_DIFFERENCE = 1;
    public static final int CHANGETYPE_VALUE_DIFFERENCERANGESTOP = 2;
    public static final int CHANGETYPE_VALUETRANSFORMED = 3;
    public static final int CHANGETYPE_VALUETRANSFORMED_DIFFERENCE = 4;
    public static final int CHANGETYPE_VALUETRANSFORMED_DIFFERENCERANGESTOP = 5;
    protected int m_ChangeType;
    protected boolean m_Active;
    protected Color m_Color;
    protected ControlObject.ControlDimension m_ActorControlDimension;
    protected ArrayList<ControlObject> m_ControlObjects;

    public ControlGroupSimple() {
        this.initMembers();
    }

    public ControlGroupSimple(int p_ChangeType) {
        this.initMembers();
        this.m_ChangeType = p_ChangeType;
    }

    private void initMembers() {
        this.m_ControlObjects = new ArrayList();
        this.m_ChangeType = 1;
        this.m_Color = Color.RED;
        this.m_Active = true;
        this.m_ActorControlDimension = null;
    }

    private Object readResolve() {
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
        p_ObjectOutput.writeInt(this.m_ChangeType);
        p_ObjectOutput.writeBoolean(this.m_Active);
        ImagesTools.writeColor((ObjectOutput)p_ObjectOutput, (Color)this.m_Color);
    }

    @Override
    public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
        this.m_ChangeType = p_ObjectInput.readInt();
        this.m_Active = p_ObjectInput.readBoolean();
        this.m_Color = ImagesTools.readColor((ObjectInput)p_ObjectInput);
    }

    public void addControlObject(ControlObject p_ControlObject) {
        if (p_ControlObject == null) {
            return;
        }
        if (this.m_ControlObjects.contains(p_ControlObject)) {
            return;
        }
        this.m_ControlObjects.add(p_ControlObject);
    }

    public void removeControlObject(ControlObject p_ControlObject) {
        if (p_ControlObject == null) {
            return;
        }
        int intIndex = this.m_ControlObjects.indexOf(p_ControlObject);
        if (intIndex < 0) {
            return;
        }
        this.m_ControlObjects.remove(intIndex);
    }

    public void clearControlObjects() {
        int intControlObjectsCount = this.m_ControlObjects.size();
        for (int intControl = intControlObjectsCount - 1; intControl >= 0; --intControl) {
            ControlObject o_ControlObject = this.m_ControlObjects.get(intControl);
            this.removeControlObject(o_ControlObject);
        }
    }

    public boolean contains(ControlObject p_ControlObject) {
        if (p_ControlObject == null) {
            return false;
        }
        int intIndex = this.m_ControlObjects.indexOf(p_ControlObject);
        return intIndex >= 0;
    }

    public boolean getActive() {
        return this.m_Active;
    }

    public void setActive(boolean p_Active) {
        this.m_Active = p_Active;
        this.m_ActorControlDimension = null;
    }

    public int getChangeType() {
        return this.m_ChangeType;
    }

    public void setChangeType(int p_ChangeType) {
        if (p_ChangeType != 0 && p_ChangeType != 1 && p_ChangeType != 2 && p_ChangeType != 3 && p_ChangeType != 4 && p_ChangeType != 5) {
            return;
        }
        this.m_ChangeType = p_ChangeType;
    }

    private boolean setActorControlDimension(ControlObject.ControlDimension p_ControlDimension) {
        if (this.m_ActorControlDimension != null) {
            return false;
        }
        this.m_ActorControlDimension = p_ControlDimension;
        return this.m_ActorControlDimension != null;
    }

    public double checkRange(ControlObject.ControlDimension p_ControlDimension, double p_Value) {
        if (!this.setActorControlDimension(p_ControlDimension)) {
            return p_Value;
        }
        if (!this.m_Active) {
            this.m_ActorControlDimension = null;
            return p_Value;
        }
        int intActorIndex = this.m_ControlObjects.indexOf(this.m_ActorControlDimension.getControlObject());
        double doubleActorValue = p_Value;
        if (this.m_ChangeType == 2 || this.m_ChangeType == 5) {
            block3: for (int intControl = 0; intControl < this.m_ControlObjects.size(); ++intControl) {
                ControlObject.ControlDimension o_ControlDimension = this.m_ControlObjects.get(intControl).getControlDimension(this.m_ActorControlDimension.getDimensionIndex());
                if (o_ControlDimension == null || o_ControlDimension == this.m_ActorControlDimension) continue;
                switch (this.m_ChangeType) {
                    case 2: {
                        double doubleDifferenceObjects = p_Value - o_ControlDimension.getValueLastSet();
                        double doubleNewValueObject = doubleActorValue - doubleDifferenceObjects;
                        if (doubleNewValueObject > p_ControlDimension.getValueMaximum()) {
                            doubleActorValue -= doubleNewValueObject - p_ControlDimension.getValueMaximum();
                            continue block3;
                        }
                        if (!(doubleNewValueObject < p_ControlDimension.getValueMinimum())) continue block3;
                        doubleActorValue += p_ControlDimension.getValueMinimum() - doubleNewValueObject;
                    }
                }
            }
        }
        if (doubleActorValue != p_Value) {
            this.m_ActorControlDimension = null;
            return doubleActorValue;
        }
        this.m_ActorControlDimension = null;
        return p_Value;
    }

    public void refreshLastValue(ControlObject.ControlDimension p_ControlDimension) {
    }

    public void setGroupValues(ControlObject.ControlDimension p_ActorControlDimension, double p_ValueNewDiff, double p_ValueNew, int p_ActionFlag) {
        double doubleValue;
        double doubleValueDiff;
        ControlObject.ControlDimension o_ControlDimension = p_ActorControlDimension;
        if (!this.m_Active) {
            return;
        }
        if (!this.setActorControlDimension(o_ControlDimension)) {
            return;
        }
        int intActorIndex = this.m_ControlObjects.indexOf(this.m_ActorControlDimension.getControlObject());
        if (p_ActorControlDimension.getValueMaximum() < 65535.0) {
            doubleValueDiff = p_ValueNewDiff * 256.0;
            doubleValue = p_ValueNew * 256.0;
        } else {
            doubleValueDiff = p_ValueNewDiff;
            doubleValue = p_ValueNew;
        }
        for (int intControl = 0; intControl < this.m_ControlObjects.size(); ++intControl) {
            ControlObject o_ControlObject = this.m_ControlObjects.get(intControl);
            if (o_ControlObject == null || (o_ControlDimension = o_ControlObject.getControlDimension(this.m_ActorControlDimension.getDimensionIndex())) == null || o_ControlDimension == this.m_ActorControlDimension) continue;
            switch (this.m_ChangeType) {
                case 0: {
                    double doubleValueNew = o_ControlDimension.getValueMaximum() < 65535.0 ? doubleValue / 256.0 : doubleValue;
                    o_ControlDimension.setValue(doubleValueNew, 0.0, 16);
                    break;
                }
                case 3: {
                    break;
                }
                case 1: 
                case 2: {
                    double doubleValueNew = o_ControlDimension.getValueMaximum() < 65535.0 ? o_ControlDimension.getValueLastSet() + doubleValueDiff / 256.0 : o_ControlDimension.getValueLastSet() + doubleValueDiff;
                    o_ControlDimension.setValue(doubleValueNew, 0.0, 16);
                }
            }
            o_ControlObject.setValueManuallyIsReady();
        }
        this.m_ActorControlDimension = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public Color getGroupColor() {
        return this.m_Color;
    }

    public void setGroupColor(Color p_Color) {
        this.m_Color = p_Color;
    }

    public void paintGroup(ControlObject p_ControlObject, Graphics p_Graphics, Rectangle p_RectInsideControl, int p_Deepth) {
        p_Graphics.setColor(this.m_Color);
        Rectangle rectGroup = new Rectangle(p_RectInsideControl);
        rectGroup.x = p_Deepth * 2;
        rectGroup.y = p_Deepth * 2;
        rectGroup.width = rectGroup.width - p_Deepth * 4 - 1;
        rectGroup.height = rectGroup.height - p_Deepth * 4 - 1;
        p_Graphics.drawRect(rectGroup.x, rectGroup.x, rectGroup.width, rectGroup.height);
    }
}

