/*
 * Decompiled with CFR 0.152.
 */
package LiveShowControlModels;

import LiveShowControlObjects.ControlObject;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import SwingModelPackage.TableAndListModel;
import ToolsGraphics.ImagesTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ControlLabelModel
implements Externalizable,
ComboBoxModel,
PropertyChangeListener {
    public static final int SOFTWAREVERSION = 2;
    public static final String PROP_SELECTEDLIST = "listSelected";
    public static final String PROP_LISTADDED = "listAdded";
    public static final String PROP_LISTREMOVED = "listRemoved";
    public static final Dimension DIMENSION_SMALL = new Dimension(12, 12);
    public static final Dimension DIMENSION_BIG = new Dimension(28, 28);
    protected String m_Name;
    protected double m_MinValue;
    protected double m_MaxValue;
    protected int m_ByteCount;
    protected boolean m_OnlyInteger;
    protected ArrayList<ControlLabelList> m_ControlLabelLists;
    protected ControlLabelList m_SelectedControlLabelList;
    protected ControlLabelListSelection m_ControlLabelListSelection;
    protected ListCellRenderer m_ControlLabelDescriptionCellRenderer;
    protected ListCellRenderer m_ControlLabelListCellRenderer;
    protected ArrayList<ListDataListener> m_ArrayListDataListeners;
    protected SinglePropertyChangeSupport m_PropertyChangeSupport;
    private static final Object m_SyncListDataListeners = new Object();
    private static final Object m_SyncObjects = new Object();
    public static LabelListConditionCellRenderer s_LabelListConditionCellRenderer = new LabelListConditionCellRenderer();

    public ControlLabelModel(String p_Name, double p_MinValue, double p_MaxValue) {
        this.initMembers();
        if (p_Name == null) {
            p_Name = "";
        }
        this.m_Name = p_Name;
        this.m_MinValue = p_MinValue;
        this.m_MaxValue = p_MaxValue;
        this.calculateByteCount();
        this.readResolve();
    }

    private void initMembers() {
        this.m_ControlLabelLists = new ArrayList();
        ControlLabelList o_ControlLabelList = new ControlLabelList(this);
        this.m_ControlLabelLists.add(o_ControlLabelList);
        this.m_SelectedControlLabelList = o_ControlLabelList;
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport((Object)this);
        this.m_ArrayListDataListeners = new ArrayList();
        this.m_OnlyInteger = false;
        this.m_ByteCount = 0;
    }

    private Object readResolve() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
        p_ObjectOutput.writeInt(2);
        Object object = m_SyncObjects;
        synchronized (object) {
            p_ObjectOutput.writeInt(this.m_ControlLabelLists.size());
            for (int intList = 0; intList < this.m_ControlLabelLists.size(); ++intList) {
                ControlLabelList o_ControlLabelList = this.m_ControlLabelLists.get(intList);
                o_ControlLabelList.writeExternal(p_ObjectOutput);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = p_ObjectInput.readInt();
        this.clearControlLabelLists();
        int intListCount = intSoftwareVersion > 1 ? p_ObjectInput.readInt() : 1;
        for (int intList = 0; intList < intListCount; ++intList) {
            ControlLabelList o_ControlLabelList = intList < 0 || intList >= this.m_ControlLabelLists.size() ? new ControlLabelList(this) : this.m_ControlLabelLists.get(intList);
            o_ControlLabelList.setListModelSoftwareVersion(intSoftwareVersion);
            o_ControlLabelList.readExternal(p_ObjectInput);
            this.addControlLabelList(o_ControlLabelList);
        }
        Object object = m_SyncObjects;
        synchronized (object) {
            this.m_SelectedControlLabelList = this.m_ControlLabelLists.size() >= 0 ? this.m_ControlLabelLists.get(0) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDiskSpaceEstimated() {
        long longBytesCount = 0L;
        longBytesCount += 4L;
        longBytesCount += 4L;
        Object object = m_SyncObjects;
        synchronized (object) {
            for (int intList = 0; intList < this.m_ControlLabelLists.size(); ++intList) {
                ControlLabelList o_ControlLabelList = this.m_ControlLabelLists.get(intList);
                longBytesCount += o_ControlLabelList.getDiskSpaceEstimated();
            }
        }
        return longBytesCount;
    }

    public ControlLabelModel getCopy() {
        ControlLabelModel o_ControlLabelModel = new ControlLabelModel(this.m_Name, this.m_MinValue, this.m_MaxValue);
        o_ControlLabelModel.clearControlLabelLists();
        for (int intDescriptionList = 0; intDescriptionList < this.m_ControlLabelLists.size(); ++intDescriptionList) {
            ControlLabelList o_ControlLabelListSelf = this.getControlLabelList(intDescriptionList);
            if (o_ControlLabelListSelf == null) continue;
            ControlLabelList o_ControlLabelListCopy = o_ControlLabelListSelf.getCopy(o_ControlLabelModel);
            o_ControlLabelModel.addControlLabelList(o_ControlLabelListCopy);
        }
        return o_ControlLabelModel;
    }

    public String getName() {
        return this.m_Name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearControlLabelLists() {
        ArrayList<ControlLabelList> o_ControlLabelLists;
        Object object = m_SyncObjects;
        synchronized (object) {
            o_ControlLabelLists = new ArrayList<ControlLabelList>(this.m_ControlLabelLists.size());
            o_ControlLabelLists.addAll(this.m_ControlLabelLists);
        }
        for (int intList = o_ControlLabelLists.size() - 1; intList >= 0; --intList) {
            ControlLabelList o_ControlLabelList = (ControlLabelList)o_ControlLabelLists.get(intList);
            if (o_ControlLabelList == null) continue;
            o_ControlLabelList.clearControlLabelDescriptions();
            this.removeControlLabelList(o_ControlLabelList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addControlLabelList(ControlLabelList p_ControlLabelList) {
        int intIndex;
        if (p_ControlLabelList == null) {
            return;
        }
        Object object = m_SyncObjects;
        synchronized (object) {
            if (this.m_ControlLabelLists.contains(p_ControlLabelList)) {
                return;
            }
            this.m_ControlLabelLists.add(p_ControlLabelList);
            intIndex = this.m_ControlLabelLists.indexOf(p_ControlLabelList);
        }
        p_ControlLabelList.addPropertyChangeListener(this);
        this.fireDataList_ListAdded(intIndex);
        this.setSelectedControlLabelList(p_ControlLabelList);
        this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_LISTADDED, intIndex, null, (Object)p_ControlLabelList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeControlLabelList(ControlLabelList p_ControlLabelList) {
        int intIndex;
        if (p_ControlLabelList == null) {
            return;
        }
        Object object = m_SyncObjects;
        synchronized (object) {
            intIndex = this.m_ControlLabelLists.indexOf(p_ControlLabelList);
            if (intIndex < 0) {
                return;
            }
            this.m_ControlLabelLists.remove(p_ControlLabelList);
        }
        p_ControlLabelList.removePropertyChangeListener(this);
        this.fireDataList_ListRemoved(intIndex);
        if (this.m_SelectedControlLabelList == p_ControlLabelList) {
            this.setSelectedControlLabelList(0);
        }
        this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_LISTREMOVED, intIndex, (Object)p_ControlLabelList, null);
        p_ControlLabelList.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControlLabelList getControlLabelList(int p_Index) {
        Object object = m_SyncObjects;
        synchronized (object) {
            if (p_Index < 0 || p_Index >= this.m_ControlLabelLists.size()) {
                return null;
            }
            return this.m_ControlLabelLists.get(p_Index);
        }
    }

    public int getControlLabelListSize() {
        return this.m_ControlLabelLists.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexOf(ControlLabelList p_ControlLabelList) {
        if (p_ControlLabelList == null) {
            return -1;
        }
        Object object = m_SyncObjects;
        synchronized (object) {
            return this.m_ControlLabelLists.indexOf(p_ControlLabelList);
        }
    }

    public ControlLabelDescription getControlLabelDescription(double p_Value) {
        if (this.m_SelectedControlLabelList == null) {
            return null;
        }
        return this.m_SelectedControlLabelList.getControlLabelDescriptionFromValue(p_Value);
    }

    public void setOnlyIntegerValues(boolean p_OnlyIntegerValues) {
        this.m_OnlyInteger = p_OnlyIntegerValues;
        this.calculateByteCount();
    }

    public boolean getOnlyIntegerValues() {
        return this.m_OnlyInteger;
    }

    private void calculateByteCount() {
        if (!this.m_OnlyInteger) {
            this.m_ByteCount = 0;
        } else {
            int intByteCount = 1;
            for (double doubleValueMax = Math.max(Math.abs(this.m_MaxValue), Math.abs(this.m_MinValue)); doubleValueMax >= 256.0; doubleValueMax /= 256.0) {
                ++intByteCount;
            }
            this.m_ByteCount = intByteCount;
        }
    }

    public void setValueRange(double p_MinValue, double p_MaxValue) {
        this.m_MinValue = p_MinValue;
        this.m_MaxValue = p_MaxValue;
        this.calculateByteCount();
    }

    public int getByteCount() {
        return this.m_ByteCount;
    }

    public double getMinValue() {
        return this.m_MinValue;
    }

    public double getMaxValue() {
        return this.m_MaxValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSameAs(ControlLabelModel p_ControlLabelModel) {
        if (p_ControlLabelModel == null) {
            return false;
        }
        Object object = m_SyncObjects;
        synchronized (object) {
            if (this.m_ControlLabelLists.size() != p_ControlLabelModel.getControlLabelListSize()) {
                return false;
            }
            for (int intList = 0; intList < this.m_ControlLabelLists.size(); ++intList) {
                ControlLabelList o_ControlLabelList;
                ControlLabelList o_ControlLabelListSelf = this.m_ControlLabelLists.get(intList);
                if (o_ControlLabelListSelf == null || o_ControlLabelListSelf.isSameAs(o_ControlLabelList = p_ControlLabelModel.getControlLabelList(intList))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSameStructure(ControlLabelModel p_ControlLabelModel) {
        if (p_ControlLabelModel == null) {
            return false;
        }
        Object object = m_SyncObjects;
        synchronized (object) {
            if (this.m_ControlLabelLists.size() != p_ControlLabelModel.getControlLabelListSize()) {
                return false;
            }
            for (int intList = 0; intList < this.m_ControlLabelLists.size(); ++intList) {
                ControlLabelList o_ControlLabelList;
                ControlLabelList o_ControlLabelListSelf = this.m_ControlLabelLists.get(intList);
                if (o_ControlLabelListSelf == null || o_ControlLabelListSelf.isSameStructure(o_ControlLabelList = p_ControlLabelModel.getControlLabelList(intList))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDataList_ListAdded(int p_Index) {
        ArrayList<ListDataListener> o_ListDataListeners;
        if (p_Index < 0) {
            return;
        }
        if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
            return;
        }
        Object object = m_SyncListDataListeners;
        synchronized (object) {
            if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
                return;
            }
            o_ListDataListeners = new ArrayList<ListDataListener>();
            o_ListDataListeners.addAll(this.m_ArrayListDataListeners);
        }
        ListDataEvent o_Event = new ListDataEvent(this, 1, p_Index, p_Index);
        for (int intDataListener = 0; intDataListener < o_ListDataListeners.size(); ++intDataListener) {
            ((ListDataListener)o_ListDataListeners.get(intDataListener)).intervalAdded(o_Event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDataList_ListRemoved(int p_Index) {
        ArrayList<ListDataListener> o_ListDataListeners;
        if (p_Index < 0) {
            return;
        }
        if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
            return;
        }
        Object object = m_SyncListDataListeners;
        synchronized (object) {
            if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
                return;
            }
            o_ListDataListeners = new ArrayList<ListDataListener>();
            o_ListDataListeners.addAll(this.m_ArrayListDataListeners);
        }
        ListDataEvent o_Event = new ListDataEvent(this, 2, p_Index, p_Index);
        for (int intDataListener = 0; intDataListener < o_ListDataListeners.size(); ++intDataListener) {
            ((ListDataListener)o_ListDataListeners.get(intDataListener)).intervalRemoved(o_Event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDataList_ListChanged(int p_Index) {
        ArrayList<ListDataListener> o_ListDataListeners;
        if (p_Index < 0) {
            return;
        }
        if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
            return;
        }
        Object object = m_SyncListDataListeners;
        synchronized (object) {
            if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
                return;
            }
            o_ListDataListeners = new ArrayList<ListDataListener>();
            o_ListDataListeners.addAll(this.m_ArrayListDataListeners);
        }
        ListDataEvent o_Event = new ListDataEvent(this, 0, p_Index, p_Index);
        for (int intDataListener = 0; intDataListener < o_ListDataListeners.size(); ++intDataListener) {
            ((ListDataListener)o_ListDataListeners.get(intDataListener)).contentsChanged(o_Event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDataList_ListSelected(int p_Index) {
        ArrayList<ListDataListener> o_ListDataListeners;
        if (p_Index < 0) {
            return;
        }
        if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
            return;
        }
        Object object = m_SyncListDataListeners;
        synchronized (object) {
            if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
                return;
            }
            o_ListDataListeners = new ArrayList<ListDataListener>();
            o_ListDataListeners.addAll(this.m_ArrayListDataListeners);
        }
        ListDataEvent o_Event = new ListDataEvent(this, 0, p_Index, p_Index);
        for (int intDataListener = 0; intDataListener < o_ListDataListeners.size(); ++intDataListener) {
            ((ListDataListener)o_ListDataListeners.get(intDataListener)).contentsChanged(o_Event);
        }
    }

    @Override
    public int getSize() {
        return this.m_ControlLabelLists.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getElementAt(int p_Index) {
        Object object = m_SyncObjects;
        synchronized (object) {
            if (p_Index < 0 || p_Index >= this.m_ControlLabelLists.size()) {
                return null;
            }
            return this.m_ControlLabelLists.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListDataListener(ListDataListener p_ListDataListener) {
        if (p_ListDataListener == null) {
            return;
        }
        Object object = m_SyncListDataListeners;
        synchronized (object) {
            if (this.m_ArrayListDataListeners == null) {
                return;
            }
            if (this.m_ArrayListDataListeners.contains(p_ListDataListener)) {
                return;
            }
            this.m_ArrayListDataListeners.add(p_ListDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListDataListener(ListDataListener p_ListDataListener) {
        if (p_ListDataListener == null) {
            return;
        }
        Object object = m_SyncListDataListeners;
        synchronized (object) {
            if (this.m_ArrayListDataListeners == null) {
                return;
            }
            this.m_ArrayListDataListeners.remove(p_ListDataListener);
        }
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (!(anItem instanceof ControlLabelList)) {
            return;
        }
        ControlLabelList o_ControlLabelList = (ControlLabelList)anItem;
        this.setSelectedControlLabelList(o_ControlLabelList);
    }

    @Override
    public Object getSelectedItem() {
        return this.m_SelectedControlLabelList;
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void addPropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
    }

    public boolean setSelectedControlLabelList(ControlLabelList p_ControlLabelList) {
        if (this.m_SelectedControlLabelList == p_ControlLabelList) {
            return true;
        }
        ControlLabelList oldValue = this.m_SelectedControlLabelList;
        this.m_SelectedControlLabelList = p_ControlLabelList;
        int intIndex = this.m_SelectedControlLabelList == null ? -1 : this.m_ControlLabelLists.indexOf(this.m_SelectedControlLabelList);
        this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_SELECTEDLIST, intIndex, null, (Object)this.m_SelectedControlLabelList);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSelectedControlLabelList(int p_ControlLabellistIndex) {
        ControlLabelList o_ControlLabelList;
        Object object = m_SyncObjects;
        synchronized (object) {
            o_ControlLabelList = p_ControlLabellistIndex < 0 || p_ControlLabellistIndex >= this.m_ControlLabelLists.size() ? null : this.m_ControlLabelLists.get(p_ControlLabellistIndex);
        }
        this.setSelectedControlLabelList(o_ControlLabelList);
        return true;
    }

    public ControlLabelList getSelectedControlLabelList() {
        return this.m_SelectedControlLabelList;
    }

    public int getSelectedControlLabelListIndex() {
        if (this.m_SelectedControlLabelList == null) {
            return -1;
        }
        return this.m_ControlLabelLists.indexOf(this.m_SelectedControlLabelList);
    }

    public int getControlLabelDescriptionSize() {
        if (this.m_SelectedControlLabelList == null) {
            return 0;
        }
        return this.m_SelectedControlLabelList.getControlLabelDescriptionSize();
    }

    public ControlLabelDescription getControlLabelDescription(int p_LabelIndex) {
        if (this.m_SelectedControlLabelList == null) {
            return null;
        }
        return this.m_SelectedControlLabelList.getControlLabelDescription(p_LabelIndex);
    }

    public void addControlLabelDescription(ControlLabelDescription p_ControlLabelDescription) {
        if (this.m_SelectedControlLabelList != null) {
            this.m_SelectedControlLabelList.addControlLabelDescription(p_ControlLabelDescription);
        }
    }

    public void removeControlLabelDescription(ControlLabelDescription p_ControlLabelDescription) {
        if (this.m_SelectedControlLabelList != null) {
            this.m_SelectedControlLabelList.removeControlLabelDescription(p_ControlLabelDescription);
        }
    }

    public int getIndexOf(ControlLabelDescription p_ControlLabelDescription) {
        if (this.m_SelectedControlLabelList == null) {
            return -1;
        }
        return this.m_SelectedControlLabelList.getIndexOf(p_ControlLabelDescription);
    }

    public void clearControlLabelDescriptions() {
        if (this.m_SelectedControlLabelList == null) {
            return;
        }
        this.m_SelectedControlLabelList.clearControlLabelDescriptions();
    }

    public ControlLabelDescription createControlLabelDescription(double p_ValueStart, double p_ValueEnd, Double p_ValueDefault, String p_Text) {
        if (this.m_SelectedControlLabelList == null) {
            return null;
        }
        return this.m_SelectedControlLabelList.createControlLabelDescription(p_ValueStart, p_ValueEnd, p_ValueDefault, p_Text);
    }

    public ControlLabelDescription createControlLabelDescription(double p_ValueStart, double p_ValueEnd, Double p_ValueDefault, Image p_Image) {
        if (this.m_SelectedControlLabelList == null) {
            return null;
        }
        return this.m_SelectedControlLabelList.createControlLabelDescription(p_ValueStart, p_ValueEnd, p_ValueDefault, p_Image);
    }

    public ControlLabelDescription createControlLabelDescription(double p_ValueStart, double p_ValueEnd, Double p_ValueDefault, Color p_Color) {
        if (this.m_SelectedControlLabelList == null) {
            return null;
        }
        return this.m_SelectedControlLabelList.createControlLabelDescription(p_ValueStart, p_ValueEnd, p_ValueDefault, p_Color);
    }

    public ControlLabelDescription createControlLabelDescription(double p_ValueStart, double p_ValueEnd, Double p_ValueDefault, String p_Text, Image p_Image, Color p_Color) {
        if (this.m_SelectedControlLabelList == null) {
            return null;
        }
        return this.m_SelectedControlLabelList.createControlLabelDescription(p_ValueStart, p_ValueEnd, p_ValueDefault, p_Text, p_Image, p_Color);
    }

    public ControlLabelDescription getLastControlLabelDescription() {
        if (this.m_SelectedControlLabelList == null) {
            return null;
        }
        return this.m_SelectedControlLabelList.getLastControlLabelDescription();
    }

    public double getMinimalDistance() {
        if (this.m_SelectedControlLabelList == null) {
            return -1.0;
        }
        return this.m_SelectedControlLabelList.getMinimalDistance();
    }

    public void setLabelsAutomatic(boolean p_LabelsAutomatic) {
        if (this.m_SelectedControlLabelList == null) {
            return;
        }
        this.m_SelectedControlLabelList.setLabelsAutomatic(p_LabelsAutomatic);
    }

    public boolean getLabelsAutomatic() {
        if (this.m_SelectedControlLabelList == null) {
            return false;
        }
        return this.m_SelectedControlLabelList.getLabelsAutomatic();
    }

    public ListCellRenderer getControlLabelDescriptionCellRenderer() {
        if (this.m_ControlLabelDescriptionCellRenderer == null) {
            this.m_ControlLabelDescriptionCellRenderer = new ControlLabelDescriptionCellRenderer();
        }
        return this.m_ControlLabelDescriptionCellRenderer;
    }

    public ListCellRenderer getControlLabelListCellRenderer() {
        if (this.m_ControlLabelListCellRenderer == null) {
            this.m_ControlLabelListCellRenderer = new ControlLabelListCellRenderer();
        }
        return this.m_ControlLabelListCellRenderer;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof ControlLabelList) {
            ControlLabelList o_ControlLabelList = (ControlLabelList)evt.getSource();
            if ("listDescription".equals(evt.getPropertyName())) {
                int intIndex = this.m_ControlLabelLists.indexOf(o_ControlLabelList);
                if (intIndex < 0) {
                    return;
                }
                this.fireDataList_ListChanged(intIndex);
            }
        }
    }

    public void showControlLabelListSelection(int p_X, int p_Y) {
        if (this.m_ControlLabelListSelection == null) {
            this.m_ControlLabelListSelection = new ControlLabelListSelection(this, p_X, p_Y);
        } else {
            this.m_ControlLabelListSelection.setVisible(true);
        }
        if (this.m_ControlLabelListSelection != null) {
            this.m_ControlLabelListSelection.setLocation(p_X, p_Y);
        }
    }

    public static LabelListConditionCellRenderer getLabelListConditionCellRenderer() {
        return s_LabelListConditionCellRenderer;
    }

    public static class LabelListConditionCellRenderer
    extends JPanel
    implements ListCellRenderer {
        public static LineBorder s_LineBorder = new LineBorder(Color.BLACK, 1);
        private StringBuffer m_StringBuffer;
        private ArrayList<Integer> m_Bytes;
        private JLabel m_JLabelText;
        private JLabel m_JLabelValues;

        public LabelListConditionCellRenderer() {
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_StringBuffer = new StringBuffer();
            this.m_Bytes = new ArrayList();
        }

        private void initComponents() {
            GridBagLayout o_GridBagLayout = new GridBagLayout();
            this.setLayout(o_GridBagLayout);
            this.m_JLabelText = new JLabel();
            this.m_JLabelText.setHorizontalAlignment(10);
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 1.0;
            this.add((Component)this.m_JLabelText, o_GridBagConstraints);
            this.m_JLabelText.setVisible(true);
            this.m_JLabelValues = new JLabel();
            this.m_JLabelValues.setHorizontalAlignment(4);
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 1;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 0.5;
            this.add((Component)this.m_JLabelValues, o_GridBagConstraints);
            this.m_JLabelValues.setVisible(true);
        }

        public void calculateValueByte(LabelListCondition p_LabelListCondition, double p_Value) {
            int intByte;
            int intByteCount = p_LabelListCondition.getRemoteControlDimension() == null ? 0 : p_LabelListCondition.getRemoteControlDimension().getControlLabelModel().getByteCount();
            if (this.m_Bytes.size() < intByteCount) {
                for (intByte = this.m_Bytes.size(); intByte < intByteCount; ++intByte) {
                    this.m_Bytes.add(0);
                }
            }
            if (this.m_Bytes.size() > intByteCount) {
                for (intByte = this.m_Bytes.size(); intByte > intByteCount; --intByte) {
                    this.m_Bytes.remove(0);
                }
            }
            double doubleValue = p_Value;
            for (int intByte2 = this.m_Bytes.size() - 1; intByte2 >= 0; --intByte2) {
                double doubleByteValue = doubleValue - (double)((int)(doubleValue / 256.0) * 256);
                doubleValue = (int)(doubleValue / 256.0);
                this.m_Bytes.set(intByte2, (int)doubleByteValue);
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.m_JLabelText.setForeground(o_Foreground);
            this.m_JLabelText.setBackground(o_Background);
            this.m_JLabelValues.setForeground(o_Foreground);
            this.m_JLabelValues.setBackground(o_Background);
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            if (value instanceof LabelListCondition) {
                this.setPreferredSize(new Dimension(100, 20));
                LabelListCondition o_LabelListCondition = (LabelListCondition)value;
                this.m_StringBuffer.delete(0, this.m_StringBuffer.length());
                this.m_StringBuffer.append("<html>");
                this.m_StringBuffer.append("<b>");
                this.m_StringBuffer.append(o_LabelListCondition.getName());
                this.m_StringBuffer.append("</b>");
                this.m_StringBuffer.append("</html>");
                this.m_JLabelText.setText(this.m_StringBuffer.toString());
                this.m_StringBuffer.delete(0, this.m_StringBuffer.length());
                this.m_StringBuffer.append("<html>");
                if (o_LabelListCondition.getRemoteControlDimension() == null || !o_LabelListCondition.getRemoteControlDimension().getControlLabelModel().getOnlyIntegerValues()) {
                    this.m_StringBuffer.append(o_LabelListCondition.getRemoteValueStart());
                    this.m_StringBuffer.append(" - ");
                    this.m_StringBuffer.append(o_LabelListCondition.getRemoteValueEnd());
                } else {
                    int intByte;
                    this.calculateValueByte(o_LabelListCondition, o_LabelListCondition.getRemoteValueStart());
                    for (intByte = 0; intByte < this.m_Bytes.size(); ++intByte) {
                        if (intByte > 0) {
                            this.m_StringBuffer.append("/");
                        }
                        this.m_StringBuffer.append(this.m_Bytes.get(intByte));
                    }
                    this.m_StringBuffer.append(" - ");
                    this.calculateValueByte(o_LabelListCondition, o_LabelListCondition.getRemoteValueEnd());
                    for (intByte = 0; intByte < this.m_Bytes.size(); ++intByte) {
                        if (intByte > 0) {
                            this.m_StringBuffer.append("/");
                        }
                        this.m_StringBuffer.append(this.m_Bytes.get(intByte));
                    }
                }
                this.m_StringBuffer.append("</html>");
                this.m_JLabelValues.setText(this.m_StringBuffer.toString());
            }
            return this;
        }
    }

    public static class LabelListCondition
    implements Externalizable,
    PropertyChangeListener {
        public static final int SOFTWAREVERSION = 1;
        public static final String PROP_CONTENTCHANGED = "contentChanged";
        private ControlLabelList m_ControlLabelList;
        private String m_Name;
        private String m_RemoteID;
        private int m_RemoteControlIndex;
        private int m_RemoteControlDimensionIndex;
        private double m_RemoteValueStart;
        private double m_RemoteValueEnd;
        private ControlObject.ControlDimension m_RemoteControlDimension;
        private SinglePropertyChangeSupport m_PropertyChangeSupport1;

        public LabelListCondition(ControlLabelList p_ControlLabelList) {
            this.initMembers();
            this.m_ControlLabelList = p_ControlLabelList;
        }

        private void initMembers() {
            this.m_Name = "---";
            this.m_RemoteControlDimension = null;
            this.m_PropertyChangeSupport1 = new SinglePropertyChangeSupport((Object)this);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeUTF(this.m_Name);
            out.writeUTF(this.m_RemoteID);
            out.writeInt(this.m_RemoteControlIndex);
            out.writeInt(this.m_RemoteControlDimensionIndex);
            out.writeDouble(this.m_RemoteValueStart);
            out.writeDouble(this.m_RemoteValueEnd);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            this.m_Name = in.readUTF();
            this.m_RemoteID = in.readUTF();
            this.m_RemoteControlIndex = in.readInt();
            this.m_RemoteControlDimensionIndex = in.readInt();
            this.m_RemoteValueStart = in.readDouble();
            this.m_RemoteValueEnd = in.readDouble();
        }

        public long getDiskSpaceEstimated() {
            long longBytesCount = 0L;
            longBytesCount += 4L;
            longBytesCount += (long)(this.m_Name.length() * 2);
            longBytesCount += (long)(this.m_RemoteID.length() * 2);
            longBytesCount += 4L;
            longBytesCount += 4L;
            longBytesCount += 8L;
            return longBytesCount += 8L;
        }

        public void close() {
            this.unlink();
            if (this.m_PropertyChangeSupport1 != null) {
                this.m_PropertyChangeSupport1.clear();
            }
        }

        public void finalize() throws Throwable {
            super.finalize();
            this.m_PropertyChangeSupport1 = null;
        }

        public ControlLabelList getControlLabelList() {
            return this.m_ControlLabelList;
        }

        public LabelListCondition getCopy(ControlLabelList p_ControlLabelList) {
            LabelListCondition o_LabelListCondition = new LabelListCondition(p_ControlLabelList);
            o_LabelListCondition.setName(this.m_Name);
            o_LabelListCondition.setRemoteID(this.m_RemoteID);
            o_LabelListCondition.setRemoteControlIndex(this.m_RemoteControlIndex);
            o_LabelListCondition.setRemoteDimensionIndex(this.m_RemoteControlDimensionIndex);
            o_LabelListCondition.setRemoteValueStart(this.m_RemoteValueStart);
            o_LabelListCondition.setRemoteValueEnd(this.m_RemoteValueEnd);
            return o_LabelListCondition;
        }

        public void setName(String p_Name) {
            this.m_Name = p_Name;
        }

        public String getName() {
            return this.m_Name;
        }

        public void setRemoteID(String p_RemoteID) {
            this.m_RemoteID = p_RemoteID;
        }

        public String getRemoteID() {
            return this.m_RemoteID;
        }

        public void setRemoteControlIndex(int p_RemoteControlIndex) {
            this.m_RemoteControlIndex = p_RemoteControlIndex;
        }

        public int getRemoteControlIndex() {
            return this.m_RemoteControlIndex;
        }

        public void setRemoteDimensionIndex(int p_RemoteControlDimensionIndex) {
            this.m_RemoteControlDimensionIndex = p_RemoteControlDimensionIndex;
        }

        public int getRemoteDimensionIndex() {
            return this.m_RemoteControlDimensionIndex;
        }

        public void setRemoteValueStart(double p_ValueStart) {
            if (this.m_RemoteValueStart == p_ValueStart) {
                return;
            }
            this.m_RemoteValueStart = p_ValueStart;
            this.m_PropertyChangeSupport1.firePropertyChange(PROP_CONTENTCHANGED, null, (Object)this);
        }

        public double getRemoteValueStart() {
            return this.m_RemoteValueStart;
        }

        public void setRemoteValueEnd(double p_ValueEnd) {
            if (this.m_RemoteValueEnd == p_ValueEnd) {
                return;
            }
            this.m_RemoteValueEnd = p_ValueEnd;
            this.m_PropertyChangeSupport1.firePropertyChange(PROP_CONTENTCHANGED, null, (Object)this);
        }

        public double getRemoteValueEnd() {
            return this.m_RemoteValueEnd;
        }

        public ControlObject.ControlDimension getRemoteControlDimension() {
            return this.m_RemoteControlDimension;
        }

        public void link(ControlObject.ControlDimension p_ControlDimension) {
            if (this.m_RemoteControlDimension == p_ControlDimension) {
                return;
            }
            this.unlink();
            this.m_RemoteControlDimension = p_ControlDimension;
            if (this.m_RemoteControlDimension != null) {
                this.m_RemoteControlDimension.addPropertyChangeListener(this);
                this.m_RemoteControlDimension.getControlObject().addPropertyChangeListener(this);
                double doubleValue = this.m_RemoteControlDimension.getValue();
                this.checkValueEvent(doubleValue);
                this.calculateName();
            }
            this.m_PropertyChangeSupport1.firePropertyChange(PROP_CONTENTCHANGED, null, (Object)this);
        }

        public void unlink() {
            if (this.m_RemoteControlDimension != null) {
                this.m_RemoteControlDimension.removePropertyChangeListener(this);
                this.m_RemoteControlDimension.getControlObject().removePropertyChangeListener(this);
            }
            this.m_RemoteControlDimension = null;
            this.m_Name = "-";
            this.m_PropertyChangeSupport1.firePropertyChange(PROP_CONTENTCHANGED, null, (Object)this);
        }

        private void calculateName() {
            String stringName;
            if (this.m_RemoteControlDimension == null) {
                stringName = "---";
            } else {
                stringName = this.m_RemoteControlDimension.getControlObject().getName();
                if (this.m_RemoteControlDimension.getControlObject().getControlDimensionCount() > 1) {
                    stringName = stringName + " ";
                    stringName = stringName + this.m_RemoteControlDimension.getDimensionName();
                }
            }
            if (stringName.equals(this.m_Name)) {
                return;
            }
            this.m_Name = stringName;
            this.m_PropertyChangeSupport1.firePropertyChange(PROP_CONTENTCHANGED, null, (Object)this);
        }

        public void checkValueEvent(double p_Value) {
            if (p_Value < this.m_RemoteValueStart) {
                return;
            }
            if (p_Value > this.m_RemoteValueEnd) {
                return;
            }
            this.m_ControlLabelList.getControlLabelModel().setSelectedControlLabelList(this.m_ControlLabelList);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof ControlObject.ControlDimension) {
                if ("value".equals(evt.getPropertyName()) || "valueAdjustedManually".equals(evt.getPropertyName())) {
                    double doubleValue = (Double)evt.getNewValue();
                    this.checkValueEvent(doubleValue);
                } else {
                    this.calculateName();
                }
            } else if (evt.getSource() instanceof ControlObject) {
                this.calculateName();
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            if (p_PropertyChangeListener == null) {
                return;
            }
            this.m_PropertyChangeSupport1.addPropertyChangeListener(p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            if (p_PropertyChangeListener == null) {
                return;
            }
            this.m_PropertyChangeSupport1.removePropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public static class ControlLabelDescription
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        protected ControlLabelList m_ControlLabelList;
        private double m_ValueStart;
        private double m_ValueEnd;
        private double m_ValueDefault;
        private String m_Text;
        private Image m_Image;
        private boolean m_Visible;
        private Icon m_IconSmall;
        private Icon m_IconBig;
        private BufferedImage m_ImageSmall;
        private BufferedImage m_ImageBig;
        private Color m_Color;

        public ControlLabelDescription() {
            this.initMembers();
            this.readResolve();
        }

        public ControlLabelDescription(double p_ValueStart, double p_ValueEnd, Double p_ValueDefault, String p_Text, Image p_Image, Color p_Color) {
            this.initMembers();
            this.m_ValueStart = p_ValueStart;
            this.m_ValueEnd = p_ValueEnd;
            this.m_ValueDefault = p_ValueDefault == null || p_ValueDefault < this.m_ValueStart || p_ValueDefault > this.m_ValueEnd ? this.m_ValueStart + (this.m_ValueEnd - this.m_ValueStart) / 2.0 : p_ValueDefault;
            this.m_Text = p_Text == null ? "" : p_Text;
            this.m_Image = p_Image;
            this.m_Color = p_Color;
            this.calculateIcons();
            this.readResolve();
        }

        private void initMembers() {
            this.m_ControlLabelList = null;
            this.m_ValueStart = 0.0;
            this.m_ValueEnd = 0.0;
            this.m_ValueDefault = 0.0;
            this.m_Text = "";
            this.m_Image = null;
            this.m_IconSmall = null;
            this.m_Color = null;
            this.m_Visible = true;
        }

        private Object readResolve() {
            return this;
        }

        public void close() {
            this.m_ControlLabelList = null;
            this.m_IconSmall = null;
            this.m_IconBig = null;
            if (this.m_Image != null) {
                this.m_Image.flush();
            }
            if (this.m_ImageSmall != null) {
                this.m_ImageSmall.flush();
            }
            if (this.m_ImageBig != null) {
                this.m_ImageBig.flush();
            }
        }

        @Override
        public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
            p_ObjectOutput.writeInt(1);
            p_ObjectOutput.writeDouble(this.m_ValueStart);
            p_ObjectOutput.writeDouble(this.m_ValueDefault);
            p_ObjectOutput.writeDouble(this.m_ValueEnd);
            p_ObjectOutput.writeUTF(this.m_Text);
            ImagesTools.writeImage((ObjectOutput)p_ObjectOutput, (Image)this.m_Image);
            ImagesTools.writeColor((ObjectOutput)p_ObjectOutput, (Color)this.m_Color);
            p_ObjectOutput.writeBoolean(this.m_Visible);
        }

        @Override
        public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = p_ObjectInput.readInt();
            this.m_ValueStart = p_ObjectInput.readDouble();
            this.m_ValueDefault = p_ObjectInput.readDouble();
            this.m_ValueEnd = p_ObjectInput.readDouble();
            this.m_Text = p_ObjectInput.readUTF();
            this.m_Image = ImagesTools.readImage((ObjectInput)p_ObjectInput);
            this.m_Color = ImagesTools.readColor((ObjectInput)p_ObjectInput);
            this.m_Visible = p_ObjectInput.readBoolean();
            this.calculateIcons();
        }

        public long getDiskSpaceEstimated() {
            long longBytesCount = 0L;
            longBytesCount += 4L;
            longBytesCount += 8L;
            longBytesCount += 8L;
            longBytesCount += 8L;
            longBytesCount += (long)(this.m_Text.length() * 2);
            longBytesCount += ImagesTools.getDiskSpaceEstimated((Image)this.m_Image);
            ImagesTools.getDiskSpaceEstimated((Color)this.m_Color);
            return ++longBytesCount;
        }

        public void setControlLabelList(ControlLabelList p_ControlLabelList) {
            this.m_ControlLabelList = p_ControlLabelList;
        }

        public ControlLabelList getControlLabelModel() {
            return this.m_ControlLabelList;
        }

        public int getByteCount() {
            if (this.m_ControlLabelList == null) {
                return 0;
            }
            return this.m_ControlLabelList.getByteCount();
        }

        public double getMinValue() {
            if (this.m_ControlLabelList == null) {
                return 0.0;
            }
            return this.m_ControlLabelList.getMinValue();
        }

        public double getMaxValue() {
            if (this.m_ControlLabelList == null) {
                return 0.0;
            }
            return this.m_ControlLabelList.getMaxValue();
        }

        public boolean getOnlyIntegerValues() {
            if (this.m_ControlLabelList == null) {
                return false;
            }
            return this.m_ControlLabelList.getOnlyIntegerValues();
        }

        public ControlLabelDescription getCopy() {
            ControlLabelDescription o_ControlLabelDescription = new ControlLabelDescription();
            o_ControlLabelDescription.setProperties(this.m_ValueStart, this.m_ValueEnd, this.m_ValueDefault, this.m_Text, this.m_Image, this.m_Color);
            o_ControlLabelDescription.setVisible(this.m_Visible);
            return o_ControlLabelDescription;
        }

        public void setProperties(double p_ValueStart, double p_ValueEnd, Double p_ValueDefault, String p_Text, Image p_Image, Color p_Color) {
            if (p_ValueStart <= p_ValueEnd) {
                this.m_ValueStart = p_ValueStart;
                this.m_ValueEnd = p_ValueEnd;
            } else {
                this.m_ValueStart = p_ValueEnd;
                this.m_ValueEnd = p_ValueStart;
            }
            this.m_ValueDefault = p_ValueDefault == null || p_ValueDefault < this.m_ValueStart || p_ValueDefault > this.m_ValueEnd ? this.m_ValueStart + (this.m_ValueEnd - this.m_ValueStart) / 2.0 : p_ValueDefault;
            this.m_Text = p_Text;
            this.m_Image = p_Image;
            this.m_Color = p_Color;
            this.calculateIcons();
            if (this.m_ControlLabelList == null) {
                return;
            }
            this.m_ControlLabelList.resortDescriptions(this);
            this.m_ControlLabelList.fireIndexedPropertyChange("labelProperties", this.m_ControlLabelList.getIndexOf(this), false, true);
            this.m_ControlLabelList.fireDataListDescriptionChanged(this);
        }

        public double getValueStart() {
            return this.m_ValueStart;
        }

        public void setValueStart(double p_ValueStart) {
            double oldValue = this.m_ValueStart;
            this.m_ValueStart = p_ValueStart;
            if (this.m_ControlLabelList == null) {
                return;
            }
            if (oldValue != this.m_ValueStart) {
                if (this.m_ValueStart > this.m_ValueEnd) {
                    this.setValueEnd(this.m_ValueStart);
                }
                this.recalculateDefaultValue();
                this.m_ControlLabelList.fireIndexedPropertyChange("labelValueStart", this.m_ControlLabelList.getIndexOf(this), oldValue, this.m_ValueStart);
                this.m_ControlLabelList.fireDataListDescriptionChanged(this);
            }
        }

        public double getValueEnd() {
            return this.m_ValueEnd;
        }

        public void setValueEnd(double p_ValueEnd) {
            double oldValue = this.m_ValueEnd;
            this.m_ValueEnd = p_ValueEnd;
            if (this.m_ValueEnd < this.m_ValueStart) {
                this.m_ValueEnd = this.m_ValueStart;
            }
            if (this.m_ControlLabelList == null) {
                return;
            }
            if (oldValue != this.m_ValueEnd) {
                this.recalculateDefaultValue();
                this.m_ControlLabelList.fireIndexedPropertyChange("labelValueEnd", this.m_ControlLabelList.getIndexOf(this), oldValue, this.m_ValueEnd);
                this.m_ControlLabelList.fireDataListDescriptionChanged(this);
            }
        }

        public void recalculateDefaultValue() {
            double doubleDefaultValue = this.m_ValueStart == 0.0 ? 0.0 : this.m_ValueStart + (this.m_ValueEnd - this.m_ValueStart) / 2.0;
            this.setValueDefault(doubleDefaultValue);
        }

        public double getValueDefault() {
            return this.m_ValueDefault;
        }

        public void setValueDefault(double p_ValueDefault) {
            if (p_ValueDefault < this.m_ValueStart || p_ValueDefault > this.m_ValueEnd) {
                p_ValueDefault = this.m_ValueStart + (this.m_ValueEnd - this.m_ValueStart) / 2.0;
            }
            double oldValue = this.m_ValueDefault;
            this.m_ValueDefault = p_ValueDefault;
            if (this.m_ControlLabelList == null) {
                return;
            }
            if (oldValue != this.m_ValueDefault) {
                this.m_ControlLabelList.resortDescriptions(this);
                this.m_ControlLabelList.fireIndexedPropertyChange("labelValueDefault", this.m_ControlLabelList.getIndexOf(this), oldValue, this.m_Text);
                this.m_ControlLabelList.fireDataListDescriptionChanged(this);
            }
        }

        public String getLabelText() {
            return this.m_Text;
        }

        public void setLabelText(String p_Text) {
            if (p_Text == null) {
                p_Text = "";
            }
            String oldValue = this.m_Text;
            this.m_Text = p_Text;
            this.calculateIcons();
            if (this.m_ControlLabelList == null) {
                return;
            }
            this.m_ControlLabelList.fireIndexedPropertyChange("labelText", this.m_ControlLabelList.getIndexOf(this), oldValue, this.m_Text);
            this.m_ControlLabelList.fireDataListDescriptionChanged(this);
        }

        public Image getLabelImage() {
            return this.m_Image;
        }

        public void setLabelImage(Image p_Image) {
            if (this.m_Image == p_Image) {
                return;
            }
            Image oldValue = this.m_Image;
            this.m_Image = p_Image;
            if (this.m_Image != null) {
                this.setLabelColor(null);
            }
            this.calculateIcons();
            if (this.m_ControlLabelList == null) {
                return;
            }
            this.m_ControlLabelList.fireIndexedPropertyChange("labelIcon", this.m_ControlLabelList.getIndexOf(this), oldValue, this.m_Image);
            this.m_ControlLabelList.fireDataListDescriptionChanged(this);
        }

        public void setVisible(boolean p_Visible) {
            boolean oldValue = this.m_Visible;
            this.m_Visible = p_Visible;
            if (this.m_ControlLabelList == null) {
                return;
            }
            this.m_ControlLabelList.fireIndexedPropertyChange("labelVisible", this.m_ControlLabelList.getIndexOf(this), oldValue, this.m_Visible);
            this.m_ControlLabelList.fireDataListDescriptionChanged(this);
        }

        public boolean getVisible() {
            return this.m_Visible;
        }

        private void calculateIcons() {
            if (this.m_Image == null && this.m_Color == null) {
                this.m_ImageSmall = ImagesTools.createBufferedImage((String)this.m_Text, (Dimension)DIMENSION_SMALL);
                this.m_ImageBig = ImagesTools.createBufferedImage((String)this.m_Text, (Dimension)DIMENSION_BIG);
            } else if (this.m_Image == null) {
                this.m_ImageSmall = ImagesTools.createBufferedImage((Color)this.m_Color, (Dimension)DIMENSION_SMALL);
                this.m_ImageBig = ImagesTools.createBufferedImage((Color)this.m_Color, (Dimension)DIMENSION_BIG);
            } else {
                this.m_ImageSmall = ImagesTools.convertToBufferedImage((Image)this.m_Image, (Dimension)DIMENSION_SMALL);
                this.m_ImageBig = ImagesTools.convertToBufferedImage((Image)this.m_Image, (Dimension)DIMENSION_BIG);
            }
            this.m_IconSmall = new ImageIcon(this.m_ImageSmall);
            this.m_IconBig = new ImageIcon(this.m_ImageBig);
        }

        public Icon getLabelIconSmall() {
            return this.m_IconSmall;
        }

        public Icon getLabelIconBig() {
            return this.m_IconBig;
        }

        public Image getLabelImageSmall() {
            return this.m_ImageSmall;
        }

        public Image getLabelImageBig() {
            return this.m_ImageBig;
        }

        public Color getLabelColor() {
            return this.m_Color;
        }

        public void setLabelColor(Color p_Color) {
            if (this.m_Color == p_Color) {
                return;
            }
            Color oldValue = this.m_Color;
            this.m_Color = p_Color;
            if (this.m_Color != null) {
                this.setLabelImage(null);
            }
            this.calculateIcons();
            if (this.m_ControlLabelList == null) {
                return;
            }
            this.m_ControlLabelList.fireIndexedPropertyChange("labelColor", this.m_ControlLabelList.getIndexOf(this), oldValue, this.m_Color);
            this.m_ControlLabelList.fireDataListDescriptionChanged(this);
        }

        public boolean isSameAs(ControlLabelDescription p_ControlLabelDescription) {
            if (this.m_ValueDefault != p_ControlLabelDescription.getValueDefault()) {
                return false;
            }
            if (this.m_ValueStart != p_ControlLabelDescription.getValueStart()) {
                return false;
            }
            if (this.m_ValueEnd != p_ControlLabelDescription.getValueEnd()) {
                return false;
            }
            return this.m_Text.equals(p_ControlLabelDescription.getLabelText());
        }

        public boolean isSameStructure(ControlLabelDescription p_ControlLabelDescription) {
            if (this.m_ValueStart != p_ControlLabelDescription.getValueStart()) {
                return false;
            }
            return this.m_ValueEnd == p_ControlLabelDescription.getValueEnd();
        }
    }

    public static class ControlLabelDescriptionCellRenderer
    extends JPanel
    implements ListCellRenderer {
        public static LineBorder s_LineBorder = new LineBorder(Color.BLACK, 1);
        private StringBuilder m_StringBuilder;
        private ArrayList<Integer> m_Bytes;
        private JLabel m_JLabelText;
        private JLabel m_JLabelValues;

        public ControlLabelDescriptionCellRenderer() {
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_StringBuilder = new StringBuilder();
            this.m_Bytes = new ArrayList();
        }

        private void initComponents() {
            GridBagLayout o_GridBagLayout = new GridBagLayout();
            this.setLayout(o_GridBagLayout);
            this.m_JLabelText = new JLabel();
            this.m_JLabelText.setHorizontalAlignment(10);
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 1.0;
            this.add((Component)this.m_JLabelText, o_GridBagConstraints);
            this.m_JLabelText.setVisible(true);
            this.m_JLabelValues = new JLabel();
            this.m_JLabelValues.setHorizontalAlignment(4);
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 1;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 0.5;
            this.add((Component)this.m_JLabelValues, o_GridBagConstraints);
            this.m_JLabelValues.setVisible(true);
        }

        public void calculateValueByte(ControlLabelDescription p_ControlLabelDescription, double p_Value) {
            int intByte;
            if (this.m_Bytes.size() < p_ControlLabelDescription.getByteCount()) {
                for (intByte = this.m_Bytes.size(); intByte < p_ControlLabelDescription.getByteCount(); ++intByte) {
                    this.m_Bytes.add(0);
                }
            }
            if (this.m_Bytes.size() > p_ControlLabelDescription.getByteCount()) {
                for (intByte = this.m_Bytes.size(); intByte > p_ControlLabelDescription.getByteCount(); --intByte) {
                    this.m_Bytes.remove(0);
                }
            }
            double doubleValue = p_Value;
            for (int intByte2 = this.m_Bytes.size() - 1; intByte2 >= 0; --intByte2) {
                double doubleByteValue = doubleValue - (double)((int)(doubleValue / 256.0) * 256);
                doubleValue = (int)(doubleValue / 256.0);
                this.m_Bytes.set(intByte2, (int)doubleByteValue);
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.m_JLabelText.setForeground(o_Foreground);
            this.m_JLabelText.setBackground(o_Background);
            this.m_JLabelValues.setForeground(o_Foreground);
            this.m_JLabelValues.setBackground(o_Background);
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            if (value instanceof ControlLabelDescription) {
                this.setPreferredSize(new Dimension(100, 20));
                ControlLabelDescription o_ControlLabelDescription = (ControlLabelDescription)value;
                Icon o_Icon = o_ControlLabelDescription.getLabelIconSmall();
                this.m_JLabelText.setIcon(o_Icon);
                this.m_StringBuilder.delete(0, this.m_StringBuilder.length());
                this.m_StringBuilder.append("<html>");
                if (o_ControlLabelDescription.getLabelText() != null) {
                    this.m_StringBuilder.append("<b>");
                    this.m_StringBuilder.append(o_ControlLabelDescription.getLabelText());
                    this.m_StringBuilder.append("</b>");
                }
                this.m_StringBuilder.append("</html>");
                this.m_JLabelText.setText(this.m_StringBuilder.toString());
                this.m_StringBuilder.delete(0, this.m_StringBuilder.length());
                this.m_StringBuilder.append("<html>");
                if (!o_ControlLabelDescription.getOnlyIntegerValues()) {
                    this.m_StringBuilder.append(o_ControlLabelDescription.getValueDefault());
                    this.m_StringBuilder.append(" (");
                    this.m_StringBuilder.append(o_ControlLabelDescription.getValueStart());
                    this.m_StringBuilder.append(" - ");
                    this.m_StringBuilder.append(o_ControlLabelDescription.getValueEnd());
                    this.m_StringBuilder.append(")");
                } else {
                    int intByte;
                    this.calculateValueByte(o_ControlLabelDescription, o_ControlLabelDescription.getValueDefault());
                    for (intByte = 0; intByte < this.m_Bytes.size(); ++intByte) {
                        if (intByte > 0) {
                            this.m_StringBuilder.append("/");
                        }
                        this.m_StringBuilder.append(this.m_Bytes.get(intByte));
                    }
                    this.m_StringBuilder.append(" (");
                    this.calculateValueByte(o_ControlLabelDescription, o_ControlLabelDescription.getValueStart());
                    for (intByte = 0; intByte < this.m_Bytes.size(); ++intByte) {
                        if (intByte > 0) {
                            this.m_StringBuilder.append("/");
                        }
                        this.m_StringBuilder.append(this.m_Bytes.get(intByte));
                    }
                    this.m_StringBuilder.append(" - ");
                    this.calculateValueByte(o_ControlLabelDescription, o_ControlLabelDescription.getValueEnd());
                    for (intByte = 0; intByte < this.m_Bytes.size(); ++intByte) {
                        if (intByte > 0) {
                            this.m_StringBuilder.append("/");
                        }
                        this.m_StringBuilder.append(this.m_Bytes.get(intByte));
                    }
                    this.m_StringBuilder.append(")");
                }
                this.m_StringBuilder.append("</html>");
                this.m_JLabelValues.setText(this.m_StringBuilder.toString());
            }
            return this;
        }
    }

    public static class ControlLabelListSelection
    extends JDialog
    implements PropertyChangeListener {
        public static Icon s_Icon = new ImageIcon(ControlLabelListSelection.class.getResource("/IconsPackage/Slider.png"));
        private int m_DimensionIndex;
        private JScrollPane jScrollPane_Labels;
        private JList jList_LabelLists;
        private ControlLabelModel m_ControlLabelModel;

        public ControlLabelListSelection(ControlLabelModel p_ControlLabelModel, int p_X, int p_Y) {
            super((Window)null, "", Dialog.ModalityType.MODELESS);
            super.setAlwaysOnTop(true);
            this.m_ControlLabelModel = p_ControlLabelModel;
            if (this.m_ControlLabelModel == null) {
                this.setVisible(false);
                return;
            }
            this.initComponents();
            super.setTitle("");
            this.setBounds(p_X, p_Y, 350, 500);
            this.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    this.setVisible(false);
                }
            });
            this.setControlLabelModel(this.m_ControlLabelModel);
            this.setVisible(true);
        }

        private void initComponents() {
            this.setIconImage(((ImageIcon)s_Icon).getImage());
            this.setDefaultCloseOperation(1);
            this.setResizable(true);
            this.setUndecorated(false);
            GridBagLayout o_GridBagLayout = new GridBagLayout();
            JPanel o_JPanel = new JPanel(o_GridBagLayout);
            o_JPanel.setPreferredSize(new Dimension(150, 150));
            this.setContentPane(o_JPanel);
            this.jScrollPane_Labels = new JScrollPane();
            this.jList_LabelLists = new JList();
            this.setControlLabelModel(this.m_ControlLabelModel);
            this.jList_LabelLists.setCellRenderer(new ControlLabelListCellRenderer());
            this.jList_LabelLists.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ControlLabelList o_ControlLabelList = (ControlLabelList)jList_LabelLists.getSelectedValue();
                    if (o_ControlLabelList != null && m_ControlLabelModel != null) {
                        m_ControlLabelModel.setSelectedControlLabelList(o_ControlLabelList);
                    }
                    this.setVisible(false);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            this.jScrollPane_Labels.setViewportView(this.jList_LabelLists);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            o_JPanel.add((Component)this.jScrollPane_Labels, gridBagConstraints);
            this.pack();
        }

        private void setControlLabelModel(ControlLabelModel p_ControlLabelModel) {
            if (this.m_ControlLabelModel != null) {
                this.m_ControlLabelModel.removePropertyChangeListener(this);
            }
            this.m_ControlLabelModel = p_ControlLabelModel;
            if (this.m_ControlLabelModel != null) {
                this.m_ControlLabelModel.addPropertyChangeListener(this);
                this.jList_LabelLists.setModel(this.m_ControlLabelModel);
                ControlLabelList o_SelectedControlLabelList = this.m_ControlLabelModel.getSelectedControlLabelList();
                if (o_SelectedControlLabelList == null) {
                    this.jList_LabelLists.clearSelection();
                } else {
                    this.jList_LabelLists.setSelectedValue(o_SelectedControlLabelList, true);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof ControlLabelModel && ControlLabelModel.PROP_SELECTEDLIST.equals(evt.getPropertyName())) {
                this.setControlLabelModel(this.m_ControlLabelModel);
            }
        }
    }

    public static class ControlLabelListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        public static LineBorder s_LineBorder = new LineBorder(Color.BLACK, 1);
        private StringBuffer m_StringBuffer;
        private JLabel m_JLabelText;
        private Dimension m_Dimension_Size;

        public ControlLabelListCellRenderer() {
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_Dimension_Size = new Dimension(100, 20);
            this.m_StringBuffer = new StringBuffer();
        }

        private void initComponents() {
            GridBagLayout o_GridBagLayout = new GridBagLayout();
            this.setLayout(o_GridBagLayout);
            this.m_JLabelText = new JLabel();
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 1.0;
            this.add((Component)this.m_JLabelText, o_GridBagConstraints);
            this.m_JLabelText.setVisible(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.m_JLabelText.setForeground(o_Foreground);
            this.m_JLabelText.setBackground(o_Background);
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            if (value instanceof ControlLabelList) {
                ControlLabelList o_ControlLabelList = (ControlLabelList)value;
                int intIndex = o_ControlLabelList.getControlLabelModel().getIndexOf(o_ControlLabelList);
                this.setPreferredSize(this.m_Dimension_Size);
                this.m_StringBuffer.delete(0, this.m_StringBuffer.length());
                this.m_StringBuffer.append("<html>");
                this.m_StringBuffer.append(String.valueOf(intIndex + 1));
                this.m_StringBuffer.append(" ");
                this.m_StringBuffer.append("<b>");
                this.m_StringBuffer.append(o_ControlLabelList.getListDescription());
                this.m_StringBuffer.append("</b>");
                this.m_StringBuffer.append("</html>");
                this.m_JLabelText.setText(this.m_StringBuffer.toString());
            }
            return this;
        }
    }

    public static class ControlLabelList
    implements Externalizable,
    ComboBoxModel<ControlLabelDescription> {
        public static final int SOFTWAREVERSION = 2;
        public static final String PROP_LISTDESCRIPTION = "listDescription";
        public static final String PROP_LABELSAUTOMATIC = "labelsAutomatic";
        public static final String PROP_LABELDESCRIPTION = "labelDescription";
        public static final String PROP_LABELDESCRIPTIONRESORTED = "labelDescriptionResorted";
        public static final String PROP_LABELPROPERTIES = "labelProperties";
        public static final String PROP_LABELVALUESTART = "labelValueStart";
        public static final String PROP_LABELVALUEEND = "labelValueEnd";
        public static final String PROP_LABELVALUEDEFAULT = "labelValueDefault";
        public static final String PROP_LABELTEXT = "labelText";
        public static final String PROP_LABELIMAGE = "labelIcon";
        public static final String PROP_LABELCOLOR = "labelColor";
        public static final String PROP_LABELVISIBLE = "labelVisible";
        protected ControlLabelModel m_ControlLabelModel;
        private int m_ListModelSoftwareVersion;
        protected String m_ListDescription;
        protected ArrayList<ControlLabelDescription> m_ControlLabelDescriptions;
        protected ControlLabelDescription m_SelectedControlLabelDescription;
        protected boolean m_LabelsAutomatic;
        protected TableAndListModel.ListModel<LabelListCondition> m_LabellistConditions;
        protected SinglePropertyChangeSupport m_PropertyChangeSupport;
        protected ArrayList<ListDataListener> m_ArrayListDataListeners;
        protected double m_MinmalDistance;
        private final Object m_SyncListDataListeners = new Object();
        private final Object m_SyncObjects = new Object();

        public ControlLabelList(ControlLabelModel p_ControlLabelModel) {
            this.initMembers();
            this.m_ControlLabelModel = p_ControlLabelModel;
            this.readResolve();
        }

        private void initMembers() {
            this.m_ControlLabelDescriptions = new ArrayList();
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport((Object)this);
            this.m_ArrayListDataListeners = new ArrayList();
            this.m_LabelsAutomatic = false;
            this.m_ListModelSoftwareVersion = -1;
            this.m_ListDescription = "Standard";
            this.m_SelectedControlLabelDescription = null;
            this.m_LabellistConditions = new TableAndListModel.ListModel(false, true);
        }

        private Object readResolve() {
            this.calculateMinimalValueDistance();
            return this;
        }

        public void setListModelSoftwareVersion(int p_SoftwareVersion) {
            this.m_ListModelSoftwareVersion = p_SoftwareVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
            p_ObjectOutput.writeInt(2);
            p_ObjectOutput.writeUTF(this.m_ListDescription);
            p_ObjectOutput.writeBoolean(this.m_LabelsAutomatic);
            Object object = this.m_SyncObjects;
            synchronized (object) {
                p_ObjectOutput.writeInt(this.m_ControlLabelDescriptions.size());
                for (int intDescription = 0; intDescription < this.m_ControlLabelDescriptions.size(); ++intDescription) {
                    ControlLabelDescription o_ControlLabelDescription = this.m_ControlLabelDescriptions.get(intDescription);
                    o_ControlLabelDescription.writeExternal(p_ObjectOutput);
                }
            }
            p_ObjectOutput.writeInt(this.m_LabellistConditions.size());
            for (int intCondition = 0; intCondition < this.m_LabellistConditions.size(); ++intCondition) {
                LabelListCondition o_LabelListCondition = (LabelListCondition)this.m_LabellistConditions.get(intCondition);
                if (o_LabelListCondition == null) {
                    System.err.println("Error ControlLabelModel.ControlLabelList writeExternal NULL is in the list m_LabellistConditions");
                    continue;
                }
                o_LabelListCondition.writeExternal(p_ObjectOutput);
            }
        }

        @Override
        public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
            int intSoftwareVersion;
            if (this.m_ListModelSoftwareVersion == 1) {
                intSoftwareVersion = 1;
            } else {
                intSoftwareVersion = p_ObjectInput.readInt();
                this.m_ListDescription = p_ObjectInput.readUTF();
            }
            this.clearControlLabelDescriptions();
            this.m_LabelsAutomatic = p_ObjectInput.readBoolean();
            int intSize = p_ObjectInput.readInt();
            for (int intDescription = 0; intDescription < intSize; ++intDescription) {
                ControlLabelDescription o_ControlLabelDescription = new ControlLabelDescription();
                o_ControlLabelDescription.readExternal(p_ObjectInput);
                this.addControlLabelDescription(o_ControlLabelDescription);
            }
            if (intSoftwareVersion > 1) {
                int intConditionCount = p_ObjectInput.readInt();
                for (int intCondition = 0; intCondition < intConditionCount; ++intCondition) {
                    LabelListCondition o_LabelListCondition = new LabelListCondition(this);
                    o_LabelListCondition.readExternal(p_ObjectInput);
                    this.addLabelListCondition(o_LabelListCondition);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getDiskSpaceEstimated() {
            long longBytesCount = 0L;
            longBytesCount += 4L;
            longBytesCount += (long)(this.m_ListDescription.length() * 2);
            ++longBytesCount;
            longBytesCount += 4L;
            Object object = this.m_SyncObjects;
            synchronized (object) {
                for (int intDescription = 0; intDescription < this.m_ControlLabelDescriptions.size(); ++intDescription) {
                    ControlLabelDescription o_ControlLabelDescription = this.m_ControlLabelDescriptions.get(intDescription);
                    longBytesCount += o_ControlLabelDescription.getDiskSpaceEstimated();
                }
            }
            longBytesCount += 4L;
            for (int intCondition = 0; intCondition < this.m_LabellistConditions.size(); ++intCondition) {
                LabelListCondition o_LabelListCondition = (LabelListCondition)this.m_LabellistConditions.get(intCondition);
                if (o_LabelListCondition == null) continue;
                longBytesCount += o_LabelListCondition.getDiskSpaceEstimated();
            }
            return longBytesCount;
        }

        public void close() {
            this.clearControlLabelDescriptions();
            for (int intCondition = this.m_LabellistConditions.size() - 1; intCondition >= 0; --intCondition) {
                LabelListCondition o_LabelListCondition = (LabelListCondition)this.m_LabellistConditions.get(intCondition);
                this.removeLabelListCondition(o_LabelListCondition);
            }
            this.m_LabellistConditions.close();
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.clear();
            }
        }

        public void finalize() throws Throwable {
            super.finalize();
            this.m_PropertyChangeSupport = null;
        }

        public ControlLabelModel getControlLabelModel() {
            return this.m_ControlLabelModel;
        }

        public String getListDescription() {
            return this.m_ListDescription;
        }

        public void setListDescription(String p_ListDescription) {
            if (p_ListDescription == null) {
                p_ListDescription = "";
            }
            String oldValue = this.m_ListDescription;
            this.m_ListDescription = p_ListDescription;
            this.m_PropertyChangeSupport.firePropertyChange(PROP_LISTDESCRIPTION, (Object)oldValue, (Object)this.m_ListDescription);
        }

        public TableAndListModel.ListModel<LabelListCondition> getLabelListConditions() {
            return this.m_LabellistConditions;
        }

        public LabelListCondition createLabelListCondition(ControlObject.ControlDimension p_RemoteControlDimension, String p_RemoteID, int p_ControlIndex, int p_ControlDimensionIndex, double p_ValueStart, double p_ValueEnd) {
            LabelListCondition o_LabelListCondition = new LabelListCondition(this);
            o_LabelListCondition.setName("");
            o_LabelListCondition.setRemoteID(p_RemoteID);
            o_LabelListCondition.setRemoteControlIndex(p_ControlIndex);
            o_LabelListCondition.setRemoteDimensionIndex(p_ControlDimensionIndex);
            o_LabelListCondition.setRemoteValueStart(p_ValueStart);
            o_LabelListCondition.setRemoteValueEnd(p_ValueEnd);
            this.addLabelListCondition(o_LabelListCondition);
            o_LabelListCondition.link(p_RemoteControlDimension);
            return o_LabelListCondition;
        }

        public void addLabelListCondition(LabelListCondition p_LabelListCondition) {
            if (p_LabelListCondition == null) {
                return;
            }
            if (this.m_LabellistConditions.contains((Object)p_LabelListCondition)) {
                return;
            }
            if (this.m_LabellistConditions.add((Object)p_LabelListCondition)) {
                // empty if block
            }
        }

        public void removeLabelListCondition(LabelListCondition p_LabelListCondition) {
            if (p_LabelListCondition == null) {
                return;
            }
            if (!this.m_LabellistConditions.contains((Object)p_LabelListCondition)) {
                return;
            }
            if (this.m_LabellistConditions.remove((Object)p_LabelListCondition)) {
                p_LabelListCondition.close();
            }
        }

        public int getLabelListConditionSize() {
            return this.m_LabellistConditions.size();
        }

        public LabelListCondition getLabelListCondition(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_LabellistConditions.getSize()) {
                return null;
            }
            return (LabelListCondition)this.m_LabellistConditions.get(p_Index);
        }

        public ControlLabelList getCopy(ControlLabelModel p_ControlLabelModel) {
            ControlLabelList o_ControlLabelList = new ControlLabelList(p_ControlLabelModel);
            o_ControlLabelList.setListDescription(this.m_ListDescription);
            o_ControlLabelList.setLabelsAutomatic(this.m_LabelsAutomatic);
            for (int intDescription = 0; intDescription < this.getControlLabelDescriptionSize(); ++intDescription) {
                ControlLabelDescription o_ControlLabelDescriptionSelf = this.getControlLabelDescription(intDescription);
                if (o_ControlLabelDescriptionSelf == null) continue;
                ControlLabelDescription o_ControlLabelDescriptionCopy = o_ControlLabelDescriptionSelf.getCopy();
                o_ControlLabelList.addControlLabelDescription(o_ControlLabelDescriptionCopy);
            }
            for (int intCondition = 0; intCondition < this.m_LabellistConditions.size(); ++intCondition) {
                LabelListCondition o_LabelListCondition = (LabelListCondition)this.m_LabellistConditions.get(intCondition);
                if (o_LabelListCondition == null) continue;
                o_ControlLabelList.addLabelListCondition(o_LabelListCondition.getCopy(o_ControlLabelList));
            }
            return o_ControlLabelList;
        }

        public boolean getLabelsAutomatic() {
            return this.m_LabelsAutomatic;
        }

        public void setLabelsAutomatic(boolean p_LabelsAutomatic) {
            boolean oldValue = this.m_LabelsAutomatic;
            this.m_LabelsAutomatic = p_LabelsAutomatic;
            if (oldValue != this.m_LabelsAutomatic) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_LABELSAUTOMATIC, oldValue, this.m_LabelsAutomatic);
            }
        }

        public int getByteCount() {
            if (this.m_ControlLabelModel == null) {
                return 0;
            }
            return this.m_ControlLabelModel.getByteCount();
        }

        public double getMinValue() {
            if (this.m_ControlLabelModel == null) {
                return 0.0;
            }
            return this.m_ControlLabelModel.getMinValue();
        }

        public double getMaxValue() {
            if (this.m_ControlLabelModel == null) {
                return 0.0;
            }
            return this.m_ControlLabelModel.getMaxValue();
        }

        public boolean getOnlyIntegerValues() {
            if (this.m_ControlLabelModel == null) {
                return false;
            }
            return this.m_ControlLabelModel.getOnlyIntegerValues();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearControlLabelDescriptions() {
            Object object = this.m_SyncObjects;
            synchronized (object) {
                int intLabelsCount = this.m_ControlLabelDescriptions.size();
            }
            for (int intLabel = intLabelsCount - 1; intLabel >= 0; --intLabel) {
                this.removeControlLabelDescription(0);
            }
        }

        public ControlLabelDescription createControlLabelDescription(double p_ValueStart, double p_ValueEnd, Double p_ValueDefault, String p_Text) {
            return this.createControlLabelDescription(p_ValueStart, p_ValueEnd, p_ValueDefault, p_Text, null, null);
        }

        public ControlLabelDescription createControlLabelDescription(double p_ValueStart, double p_ValueEnd, Double p_ValueDefault, Image p_Image) {
            return this.createControlLabelDescription(p_ValueStart, p_ValueEnd, p_ValueDefault, null, p_Image, null);
        }

        public ControlLabelDescription createControlLabelDescription(double p_ValueStart, double p_ValueEnd, Double p_ValueDefault, Color p_Color) {
            return this.createControlLabelDescription(p_ValueStart, p_ValueEnd, p_ValueDefault, null, null, p_Color);
        }

        public ControlLabelDescription createControlLabelDescription(double p_ValueStart, double p_ValueEnd, Double p_ValueDefault, String p_Text, Image p_Image, Color p_Color) {
            ControlLabelDescription o_ControlLabelDescription = new ControlLabelDescription(p_ValueStart, p_ValueEnd, p_ValueDefault, p_Text, p_Image, p_Color);
            this.addControlLabelDescription(o_ControlLabelDescription);
            return o_ControlLabelDescription;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addControlLabelDescription(ControlLabelDescription p_ControlLabelDescription) {
            if (p_ControlLabelDescription == null) {
                return;
            }
            Object object = this.m_SyncObjects;
            synchronized (object) {
                if (this.m_ControlLabelDescriptions.contains(p_ControlLabelDescription)) {
                    return;
                }
                this.m_ControlLabelDescriptions.add(p_ControlLabelDescription);
            }
            if (p_ControlLabelDescription.getControlLabelModel() != null) {
                p_ControlLabelDescription.getControlLabelModel().removeControlLabelDescription(p_ControlLabelDescription);
            }
            p_ControlLabelDescription.setControlLabelList(this);
            int intIndex = this.m_ControlLabelDescriptions.indexOf(p_ControlLabelDescription);
            this.calculateMinimalValueDistance();
            this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_LABELDESCRIPTION, intIndex, null, (Object)p_ControlLabelDescription);
            this.fireDataListDescriptionAdded(p_ControlLabelDescription);
            this.resortDescriptions(p_ControlLabelDescription);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeControlLabelDescription(ControlLabelDescription p_ControlLabelDescription) {
            int intIndex;
            if (p_ControlLabelDescription == null) {
                return;
            }
            Object object = this.m_SyncObjects;
            synchronized (object) {
                intIndex = this.m_ControlLabelDescriptions.indexOf(p_ControlLabelDescription);
                if (intIndex < 0) {
                    return;
                }
            }
            p_ControlLabelDescription.setControlLabelList(null);
            this.removeControlLabelDescription(intIndex);
            p_ControlLabelDescription.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeControlLabelDescription(int p_Index) {
            ControlLabelDescription o_ControlLabelDescription;
            if (p_Index < 0) {
                return;
            }
            Object object = this.m_SyncObjects;
            synchronized (object) {
                if (this.m_ControlLabelDescriptions == null) {
                    return;
                }
                if (p_Index >= this.m_ControlLabelDescriptions.size()) {
                    return;
                }
                o_ControlLabelDescription = this.m_ControlLabelDescriptions.remove(p_Index);
            }
            if (o_ControlLabelDescription != null) {
                o_ControlLabelDescription.setControlLabelList(null);
            }
            this.fireDataListDescriptionRemoved(p_Index);
            this.calculateMinimalValueDistance();
            this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_LABELDESCRIPTION, p_Index, (Object)o_ControlLabelDescription, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getSortIndex(ControlLabelDescription p_ControlLabelDescription) {
            int intIndex;
            Object object = this.m_SyncObjects;
            synchronized (object) {
                for (intIndex = 0; intIndex < this.m_ControlLabelDescriptions.size(); ++intIndex) {
                    ControlLabelDescription o_ControlLabelDescription = this.m_ControlLabelDescriptions.get(intIndex);
                    if (o_ControlLabelDescription == p_ControlLabelDescription || o_ControlLabelDescription == null || p_ControlLabelDescription.getValueDefault() < o_ControlLabelDescription.getValueDefault()) continue;
                    ++intIndex;
                    break;
                }
            }
            return --intIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resortDescriptions(ControlLabelDescription p_ControlLabelDescription) {
            int intIndexFound;
            if (p_ControlLabelDescription == null) {
                return;
            }
            Object object = this.m_SyncObjects;
            synchronized (object) {
                if (this.m_ControlLabelDescriptions == null) {
                    return;
                }
                intIndexFound = this.m_ControlLabelDescriptions.indexOf(p_ControlLabelDescription);
            }
            int intSortIndex = this.getSortIndex(p_ControlLabelDescription);
            if (intIndexFound == intSortIndex) {
                return;
            }
            if (intIndexFound < intSortIndex) {
                --intSortIndex;
            }
            object = this.m_SyncObjects;
            synchronized (object) {
                this.m_ControlLabelDescriptions.remove(p_ControlLabelDescription);
                this.m_ControlLabelDescriptions.add(intSortIndex, p_ControlLabelDescription);
            }
            this.fireDataListDescriptionChanged(0, this.m_ControlLabelDescriptions.size() - 1);
            this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_LABELDESCRIPTIONRESORTED, intSortIndex, null, (Object)p_ControlLabelDescription);
        }

        public int getControlLabelDescriptionSize() {
            return this.m_ControlLabelDescriptions.size();
        }

        public ArrayList<ControlLabelDescription> getControlLabelDescriptions() {
            return this.m_ControlLabelDescriptions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ControlLabelDescription getControlLabelDescription(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncObjects;
            synchronized (object) {
                if (p_Index >= this.m_ControlLabelDescriptions.size()) {
                    return null;
                }
                return this.m_ControlLabelDescriptions.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ControlLabelDescription getControlLabelDescriptionFromValue(double p_Value) {
            Object object = this.m_SyncObjects;
            synchronized (object) {
                for (int intLabel = 0; intLabel < this.m_ControlLabelDescriptions.size(); ++intLabel) {
                    ControlLabelDescription o_ControlLabelDescription = this.m_ControlLabelDescriptions.get(intLabel);
                    if (o_ControlLabelDescription == null || o_ControlLabelDescription.getValueStart() > p_Value || o_ControlLabelDescription.getValueEnd() < p_Value) continue;
                    return o_ControlLabelDescription;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ControlLabelDescription getLastControlLabelDescription() {
            Object object = this.m_SyncObjects;
            synchronized (object) {
                if (this.m_ControlLabelDescriptions.size() <= 0) {
                    return null;
                }
                return this.m_ControlLabelDescriptions.get(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isSameAs(ControlLabelList p_ControlLabelList) {
            Object object = this.m_SyncObjects;
            synchronized (object) {
                if (this.m_ControlLabelDescriptions.size() != p_ControlLabelList.getControlLabelDescriptionSize()) {
                    return false;
                }
                for (int intDescription = 0; intDescription < this.m_ControlLabelDescriptions.size(); ++intDescription) {
                    ControlLabelDescription o_ControlLabelDescription;
                    ControlLabelDescription o_ControlLabelDescriptionSelf = this.m_ControlLabelDescriptions.get(intDescription);
                    if (o_ControlLabelDescriptionSelf == null || o_ControlLabelDescriptionSelf.isSameAs(o_ControlLabelDescription = p_ControlLabelList.getControlLabelDescription(intDescription))) continue;
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isSameStructure(ControlLabelList p_ControlLabelList) {
            Object object = this.m_SyncObjects;
            synchronized (object) {
                if (this.m_ControlLabelDescriptions.size() != p_ControlLabelList.getControlLabelDescriptionSize()) {
                    return false;
                }
                for (int intDescription = 0; intDescription < this.m_ControlLabelDescriptions.size(); ++intDescription) {
                    ControlLabelDescription o_ControlLabelDescription;
                    ControlLabelDescription o_ControlLabelDescriptionSelf = this.m_ControlLabelDescriptions.get(intDescription);
                    if (o_ControlLabelDescriptionSelf == null || o_ControlLabelDescriptionSelf.isSameStructure(o_ControlLabelDescription = p_ControlLabelList.getControlLabelDescription(intDescription))) continue;
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double calculateMinimalValueDistance() {
            double doubleDistance = 0.0;
            this.m_MinmalDistance = -1.0;
            Object object = this.m_SyncObjects;
            synchronized (object) {
                for (int intDescription = 1; intDescription < this.m_ControlLabelDescriptions.size(); ++intDescription) {
                    doubleDistance = this.m_ControlLabelDescriptions.get(intDescription).getValueStart() - this.m_ControlLabelDescriptions.get(intDescription - 1).getValueDefault();
                    if (doubleDistance < 0.0) {
                        doubleDistance = -doubleDistance;
                    }
                    if (intDescription == 1) {
                        this.m_MinmalDistance = doubleDistance;
                        continue;
                    }
                    if (!(this.m_MinmalDistance > doubleDistance)) continue;
                    this.m_MinmalDistance = doubleDistance;
                }
            }
            return this.m_MinmalDistance;
        }

        public double getMinimalDistance() {
            return this.m_MinmalDistance;
        }

        public void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
            this.m_PropertyChangeSupport.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
        }

        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }

        public void addPropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
        }

        public PropertyChangeListener[] getPropertyChangeListeners() {
            return this.m_PropertyChangeSupport.getPropertyChangeListeners();
        }

        public PropertyChangeListener[] getPropertyChangeListeners(String p_PropertyName) {
            return this.m_PropertyChangeSupport.getPropertyChangeListeners(p_PropertyName);
        }

        public boolean hasListeners(String p_PropertyName) {
            return this.m_PropertyChangeSupport.hasListeners(p_PropertyName);
        }

        @Override
        public int getSize() {
            return this.m_ControlLabelDescriptions.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ControlLabelDescription getElementAt(int index) {
            Object object = this.m_SyncObjects;
            synchronized (object) {
                if (index < 0 || index > this.m_ControlLabelDescriptions.size()) {
                    return null;
                }
                return this.m_ControlLabelDescriptions.get(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getIndexOf(ControlLabelDescription p_ControlLabelDescription) {
            if (p_ControlLabelDescription == null) {
                return -1;
            }
            Object object = this.m_SyncObjects;
            synchronized (object) {
                if (this.m_ControlLabelDescriptions == null) {
                    return -1;
                }
                return this.m_ControlLabelDescriptions.indexOf(p_ControlLabelDescription);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDataListDescriptionChanged(ControlLabelDescription p_ControlLabelDescription) {
            int intIndex;
            if (p_ControlLabelDescription == null) {
                return;
            }
            if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
                return;
            }
            Object object = this.m_SyncObjects;
            synchronized (object) {
                intIndex = this.m_ControlLabelDescriptions.indexOf(p_ControlLabelDescription);
            }
            this.fireDataListDescriptionChanged(intIndex, intIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDataListDescriptionChanged(int p_StartIndex, int p_EndIndex) {
            ArrayList<ListDataListener> o_ListDataListeners;
            if (this.m_ControlLabelDescriptions == null) {
                return;
            }
            if (p_StartIndex < 0 || p_StartIndex >= this.m_ControlLabelDescriptions.size()) {
                return;
            }
            if (p_EndIndex < 0 || p_EndIndex >= this.m_ControlLabelDescriptions.size()) {
                return;
            }
            Object object = this.m_SyncListDataListeners;
            synchronized (object) {
                if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
                    return;
                }
                o_ListDataListeners = new ArrayList<ListDataListener>();
                o_ListDataListeners.addAll(this.m_ArrayListDataListeners);
            }
            ListDataEvent o_Event = new ListDataEvent(this, 0, p_StartIndex, p_EndIndex);
            for (int intDataListener = 0; intDataListener < o_ListDataListeners.size(); ++intDataListener) {
                ((ListDataListener)o_ListDataListeners.get(intDataListener)).contentsChanged(o_Event);
            }
        }

        public void fireDataListDescriptionAdded(ControlLabelDescription p_ControlLabelDescription) {
            if (p_ControlLabelDescription == null) {
                return;
            }
            if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
                return;
            }
            this.fireDataListDescriptionAdded(this.m_ControlLabelDescriptions.indexOf(p_ControlLabelDescription));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDataListDescriptionAdded(int p_Index) {
            ArrayList<ListDataListener> o_ListDataListeners;
            if (p_Index < 0) {
                return;
            }
            if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
                return;
            }
            Object object = this.m_SyncListDataListeners;
            synchronized (object) {
                if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
                    return;
                }
                o_ListDataListeners = new ArrayList<ListDataListener>();
                o_ListDataListeners.addAll(this.m_ArrayListDataListeners);
            }
            ListDataEvent o_Event = new ListDataEvent(this, 1, p_Index, p_Index);
            for (int intDataListener = 0; intDataListener < o_ListDataListeners.size(); ++intDataListener) {
                ((ListDataListener)o_ListDataListeners.get(intDataListener)).intervalAdded(o_Event);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDataListDescriptionRemoved(int p_Index) {
            ArrayList<ListDataListener> o_ListDataListeners;
            if (p_Index < 0) {
                return;
            }
            if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
                return;
            }
            Object object = this.m_SyncListDataListeners;
            synchronized (object) {
                if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
                    return;
                }
                o_ListDataListeners = new ArrayList<ListDataListener>();
                o_ListDataListeners.addAll(this.m_ArrayListDataListeners);
            }
            ListDataEvent o_Event = new ListDataEvent(this, 2, p_Index, p_Index);
            for (int intDataListener = 0; intDataListener < o_ListDataListeners.size(); ++intDataListener) {
                ((ListDataListener)o_ListDataListeners.get(intDataListener)).intervalRemoved(o_Event);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListDataListener(ListDataListener p_DataListener) {
            if (p_DataListener == null) {
                return;
            }
            Object object = this.m_SyncListDataListeners;
            synchronized (object) {
                if (this.m_ArrayListDataListeners == null) {
                    return;
                }
                if (this.m_ArrayListDataListeners.contains(p_DataListener)) {
                    return;
                }
                this.m_ArrayListDataListeners.add(p_DataListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListDataListener(ListDataListener p_DataListener) {
            if (p_DataListener == null) {
                return;
            }
            Object object = this.m_SyncListDataListeners;
            synchronized (object) {
                if (this.m_ArrayListDataListeners == null) {
                    return;
                }
                this.m_ArrayListDataListeners.remove(p_DataListener);
            }
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (!(anItem instanceof ControlLabelDescription)) {
                return;
            }
            this.m_SelectedControlLabelDescription = (ControlLabelDescription)anItem;
        }

        @Override
        public Object getSelectedItem() {
            return this.m_SelectedControlLabelDescription;
        }
    }
}

