/*
 * Decompiled with CFR 0.152.
 */
package LiveShowControlModels;

import GUID.LiveGUID;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import SwingModelPackage.TableAndListModel;
import ToolsGraphics.ImagesTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ControlFunctionModel
implements Externalizable,
ListModel {
    public static final int SOFTWAREVERSION = 1;
    public static final String PROP_FUNCTIONDESCRIPTION = "functionDescription";
    public static final String PROP_FUNCTIONPROPERTIES = "functionProperties";
    public static final String PROP_FUNCTIONVALUE = "functionValue";
    public static final String PROP_FUNCTIONTYPE = "functionType";
    public static final Dimension DIMENSION_SMALL = new Dimension(12, 12);
    public static final Dimension DIMENSION_BIG = new Dimension(28, 28);
    protected double m_MinValue;
    protected double m_MaxValue;
    protected int m_ByteCount;
    protected ArrayList<ControlFunctionDescription> m_ControlFunctionDescriptions;
    private final Object m_SyncObjects = new Object();
    protected SinglePropertyChangeSupport m_PropertyChangeSupport;
    protected ListCellRenderer m_ListCellRenderer;
    protected ArrayList<ListDataListener> m_ArrayListDataListeners;
    protected double m_MinmalDistance;
    protected boolean m_OnlyInteger;
    static final long serialVersionUID = 3632205414771754672L;

    public ControlFunctionModel(double p_MinValue, double p_MaxValue) {
        this.initMembers();
        this.m_MinValue = p_MinValue;
        this.m_MaxValue = p_MaxValue;
        this.calculateByteCount();
        this.readResolve();
    }

    private void initMembers() {
        this.m_ControlFunctionDescriptions = new ArrayList();
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport((Object)this);
        this.m_ArrayListDataListeners = new ArrayList();
        this.m_OnlyInteger = false;
        this.m_ByteCount = 0;
    }

    private Object readResolve() {
        this.calculateMinimalValueDistance();
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
        p_ObjectOutput.writeInt(1);
        p_ObjectOutput.writeInt(this.m_ControlFunctionDescriptions.size());
        for (int intDescription = 0; intDescription < this.m_ControlFunctionDescriptions.size(); ++intDescription) {
            ControlFunctionDescription o_ControlFunctionDescription = this.m_ControlFunctionDescriptions.get(intDescription);
            o_ControlFunctionDescription.writeExternal(p_ObjectOutput);
        }
    }

    @Override
    public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = p_ObjectInput.readInt();
        this.clearControlFunctionDescriptions();
        int intSize = p_ObjectInput.readInt();
        for (int intDescription = 0; intDescription < intSize; ++intDescription) {
            ControlFunctionDescription o_ControlFunctionDescription = new ControlFunctionDescription();
            o_ControlFunctionDescription.readExternal(p_ObjectInput);
            if (o_ControlFunctionDescription.getControlFunctionType() == null) continue;
            this.addControlFunctionDescription(o_ControlFunctionDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDiskSpaceEstimated() {
        long longBytesCount = 0L;
        longBytesCount += 4L;
        longBytesCount += 4L;
        Object object = this.m_SyncObjects;
        synchronized (object) {
            for (int intDescription = 0; intDescription < this.m_ControlFunctionDescriptions.size(); ++intDescription) {
                ControlFunctionDescription o_ControlFunctionDescription = this.m_ControlFunctionDescriptions.get(intDescription);
                longBytesCount += o_ControlFunctionDescription.getDiskSpaceEstimated();
            }
        }
        return longBytesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControlFunctionModel getCopy() {
        ControlFunctionModel o_ControlFunctionModel = new ControlFunctionModel(this.m_MinValue, this.m_MaxValue);
        o_ControlFunctionModel.clearControlFunctionDescriptions();
        Object object = this.m_SyncObjects;
        synchronized (object) {
            for (int intDescription = 0; intDescription < this.m_ControlFunctionDescriptions.size(); ++intDescription) {
                ControlFunctionDescription o_ControlFunctionDescriptionSelf = this.m_ControlFunctionDescriptions.get(intDescription);
                ControlFunctionDescription o_ControlFunctionDescriptionCopy = o_ControlFunctionDescriptionSelf.getCopy();
                if (o_ControlFunctionDescriptionCopy.getControlFunctionType() == null) continue;
                o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescriptionCopy);
            }
        }
        return o_ControlFunctionModel;
    }

    public void clearControlFunctionDescriptions() {
        int intFunctionCount = this.m_ControlFunctionDescriptions.size();
        for (int intLabel = intFunctionCount - 1; intLabel >= 0; --intLabel) {
            this.removeControlFunctionDescription(0);
        }
    }

    public ControlFunctionDescription createControlFunctionDescription(String p_ControlFunctionTypeID, double p_Value) {
        ControlFunctionType o_ControlFunctionType = ControlFunctionType.getControlFunctionType(p_ControlFunctionTypeID);
        if (o_ControlFunctionType == null) {
            return null;
        }
        return this.createControlFunctionDescription(o_ControlFunctionType, p_Value);
    }

    public ControlFunctionDescription createControlFunctionDescription(ControlFunctionType p_ControlFunctionType, double p_Value) {
        ControlFunctionDescription o_ControlFunctionDescription = new ControlFunctionDescription(p_ControlFunctionType, p_Value);
        this.addControlFunctionDescription(o_ControlFunctionDescription);
        return o_ControlFunctionDescription;
    }

    public void setOnlyIntegerValues(boolean p_OnlyIntegerValues) {
        this.m_OnlyInteger = p_OnlyIntegerValues;
        this.calculateByteCount();
    }

    public boolean getOnlyIntegerValues() {
        return this.m_OnlyInteger;
    }

    private void calculateByteCount() {
        if (!this.m_OnlyInteger) {
            this.m_ByteCount = 0;
        } else {
            int intByteCount = 1;
            for (double doubleValueMax = Math.max(Math.abs(this.m_MaxValue), Math.abs(this.m_MinValue)); doubleValueMax >= 256.0; doubleValueMax /= 256.0) {
                ++intByteCount;
            }
            this.m_ByteCount = intByteCount;
        }
    }

    public int getByteCount() {
        return this.m_ByteCount;
    }

    public void setValueRange(double p_MinValue, double p_MaxValue) {
        this.m_MinValue = p_MinValue;
        this.m_MaxValue = p_MaxValue;
        this.calculateByteCount();
    }

    public double getMinValue() {
        return this.m_MinValue;
    }

    public double getMaxValue() {
        return this.m_MaxValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addControlFunctionDescription(ControlFunctionDescription p_ControlFunctionDescription) {
        int intIndex;
        if (p_ControlFunctionDescription == null) {
            return;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (this.m_ControlFunctionDescriptions.contains(p_ControlFunctionDescription)) {
                return;
            }
            this.m_ControlFunctionDescriptions.add(p_ControlFunctionDescription);
            if (p_ControlFunctionDescription.getControlFunctionModel() != null) {
                p_ControlFunctionDescription.getControlFunctionModel().removeControlFunctionDescription(p_ControlFunctionDescription);
            }
            p_ControlFunctionDescription.setControlFunctionModel(this);
            intIndex = this.m_ControlFunctionDescriptions.indexOf(p_ControlFunctionDescription);
        }
        this.calculateMinimalValueDistance();
        this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_FUNCTIONDESCRIPTION, intIndex, null, (Object)p_ControlFunctionDescription);
        this.fireDataListDescriptionAdded(p_ControlFunctionDescription);
        this.resortDescriptions(p_ControlFunctionDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeControlFunctionDescription(ControlFunctionDescription p_ControlFunctionDescription) {
        int intIndex;
        if (p_ControlFunctionDescription == null) {
            return;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            intIndex = this.m_ControlFunctionDescriptions.indexOf(p_ControlFunctionDescription);
            if (intIndex < 0) {
                return;
            }
        }
        p_ControlFunctionDescription.setControlFunctionModel(null);
        this.removeControlFunctionDescription(intIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeControlFunctionDescription(int p_Index) {
        ControlFunctionDescription o_ControlFunctionDescription;
        if (p_Index < 0) {
            return;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (this.m_ControlFunctionDescriptions == null) {
                return;
            }
            if (p_Index >= this.m_ControlFunctionDescriptions.size()) {
                return;
            }
            o_ControlFunctionDescription = this.m_ControlFunctionDescriptions.remove(p_Index);
        }
        if (o_ControlFunctionDescription != null) {
            o_ControlFunctionDescription.setControlFunctionModel(null);
        }
        this.fireDataListDescriptionRemoved(p_Index);
        this.calculateMinimalValueDistance();
        this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_FUNCTIONDESCRIPTION, p_Index, (Object)o_ControlFunctionDescription, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSortIndex(ControlFunctionDescription p_ControlFunctionDescription) {
        int intIndex;
        Object object = this.m_SyncObjects;
        synchronized (object) {
            for (intIndex = 0; intIndex < this.m_ControlFunctionDescriptions.size(); ++intIndex) {
                ControlFunctionDescription o_ControlFunctionDescription = this.m_ControlFunctionDescriptions.get(intIndex);
                if (o_ControlFunctionDescription == p_ControlFunctionDescription || p_ControlFunctionDescription.getValue() < o_ControlFunctionDescription.getValue()) continue;
                ++intIndex;
                break;
            }
        }
        return --intIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resortDescriptions(ControlFunctionDescription p_ControlFunctionDescription) {
        int intSortIndex;
        if (p_ControlFunctionDescription == null) {
            return;
        }
        if (this.m_ControlFunctionDescriptions == null) {
            return;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            int intIndexFound = this.m_ControlFunctionDescriptions.indexOf(p_ControlFunctionDescription);
            intSortIndex = this.getSortIndex(p_ControlFunctionDescription);
            if (intIndexFound == intSortIndex) {
                return;
            }
            if (intIndexFound < intSortIndex) {
                --intSortIndex;
            }
            this.m_ControlFunctionDescriptions.remove(p_ControlFunctionDescription);
            this.m_ControlFunctionDescriptions.add(intSortIndex, p_ControlFunctionDescription);
        }
        this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_FUNCTIONDESCRIPTION, intSortIndex, null, null);
        this.fireDataListDescriptionChanged(0, this.m_ControlFunctionDescriptions.size() - 1);
    }

    public int getControlFunctionDescriptionSize() {
        return this.m_ControlFunctionDescriptions.size();
    }

    public ArrayList<ControlFunctionDescription> getControlFunctionDescriptions() {
        return this.m_ControlFunctionDescriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControlFunctionDescription getControlFunctionDescription(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (p_Index >= this.m_ControlFunctionDescriptions.size()) {
                return null;
            }
            return this.m_ControlFunctionDescriptions.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControlFunctionDescription getControlFunctionDescription(String p_TypeID) {
        Object object = this.m_SyncObjects;
        synchronized (object) {
            for (int intDescription = 0; intDescription < this.m_ControlFunctionDescriptions.size(); ++intDescription) {
                ControlFunctionDescription o_ControlFunctionDescription = this.m_ControlFunctionDescriptions.get(intDescription);
                ControlFunctionType o_ControlFunctionType = o_ControlFunctionDescription.getControlFunctionType();
                if (o_ControlFunctionType == null || !o_ControlFunctionType.getID().equals(p_TypeID)) continue;
                return o_ControlFunctionDescription;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControlFunctionDescription getControlFunctionDescriptionFromValue(double p_Value) {
        Object object = this.m_SyncObjects;
        synchronized (object) {
            for (int intLabel = 0; intLabel < this.m_ControlFunctionDescriptions.size(); ++intLabel) {
                ControlFunctionDescription o_ControlFunctionDescription = this.m_ControlFunctionDescriptions.get(intLabel);
                if (o_ControlFunctionDescription.getValue() != p_Value) continue;
                return o_ControlFunctionDescription;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSameAs(ControlFunctionModel p_ControlFunctionModel) {
        if (this.m_ControlFunctionDescriptions.size() != p_ControlFunctionModel.getControlFunctionDescriptionSize()) {
            return false;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            for (int intDescription = 0; intDescription < this.m_ControlFunctionDescriptions.size(); ++intDescription) {
                ControlFunctionDescription o_ControlFunctionDescription;
                ControlFunctionDescription o_ControlFunctionDescriptionSelf = this.m_ControlFunctionDescriptions.get(intDescription);
                if (o_ControlFunctionDescriptionSelf.isSameAs(o_ControlFunctionDescription = p_ControlFunctionModel.getControlFunctionDescription(intDescription))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double calculateMinimalValueDistance() {
        double doubleDistance = 0.0;
        this.m_MinmalDistance = -1.0;
        Object object = this.m_SyncObjects;
        synchronized (object) {
            for (int intDescription = 1; intDescription < this.m_ControlFunctionDescriptions.size(); ++intDescription) {
                doubleDistance = this.m_ControlFunctionDescriptions.get(intDescription).getValue() - this.m_ControlFunctionDescriptions.get(intDescription - 1).getValue();
                if (doubleDistance < 0.0) {
                    doubleDistance = -doubleDistance;
                }
                if (intDescription == 1) {
                    this.m_MinmalDistance = doubleDistance;
                    continue;
                }
                if (!(this.m_MinmalDistance > doubleDistance)) continue;
                this.m_MinmalDistance = doubleDistance;
            }
        }
        return this.m_MinmalDistance;
    }

    public double getMinimalDistance() {
        return this.m_MinmalDistance;
    }

    public void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        this.m_PropertyChangeSupport.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    public void addPropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.m_PropertyChangeSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String p_PropertyName) {
        return this.m_PropertyChangeSupport.getPropertyChangeListeners(p_PropertyName);
    }

    public boolean hasListeners(String p_PropertyName) {
        return this.m_PropertyChangeSupport.hasListeners(p_PropertyName);
    }

    @Override
    public int getSize() {
        return this.m_ControlFunctionDescriptions.size();
    }

    public Object getElementAt(int index) {
        if (index < 0 || index > this.m_ControlFunctionDescriptions.size()) {
            return null;
        }
        return this.m_ControlFunctionDescriptions.get(index);
    }

    public int getIndexOf(ControlFunctionDescription p_ControlFunctionDescription) {
        if (p_ControlFunctionDescription == null) {
            return -1;
        }
        if (this.m_ControlFunctionDescriptions == null) {
            return -1;
        }
        return this.m_ControlFunctionDescriptions.indexOf(p_ControlFunctionDescription);
    }

    public void fireDataListDescriptionChanged(ControlFunctionDescription p_ControlFunctionDescription) {
        if (p_ControlFunctionDescription == null) {
            return;
        }
        if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
            return;
        }
        int intIndex = this.m_ControlFunctionDescriptions.indexOf(p_ControlFunctionDescription);
        this.fireDataListDescriptionChanged(intIndex, intIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDataListDescriptionChanged(int p_StartIndex, int p_EndIndex) {
        if (this.m_ControlFunctionDescriptions == null) {
            return;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (p_StartIndex < 0 || p_StartIndex >= this.m_ControlFunctionDescriptions.size()) {
                return;
            }
            if (p_EndIndex < 0 || p_EndIndex >= this.m_ControlFunctionDescriptions.size()) {
                return;
            }
        }
        ListDataEvent o_Event = new ListDataEvent(this, 0, p_StartIndex, p_EndIndex);
        for (int intDataListener = 0; intDataListener < this.m_ArrayListDataListeners.size(); ++intDataListener) {
            this.m_ArrayListDataListeners.get(intDataListener).contentsChanged(o_Event);
        }
    }

    public void fireDataListDescriptionAdded(ControlFunctionDescription p_ControlFunctionDescription) {
        if (p_ControlFunctionDescription == null) {
            return;
        }
        if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
            return;
        }
        this.fireDataListDescriptionAdded(this.m_ControlFunctionDescriptions.indexOf(p_ControlFunctionDescription));
    }

    public void fireDataListDescriptionAdded(int p_Index) {
        if (p_Index < 0) {
            return;
        }
        if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
            return;
        }
        ListDataEvent o_Event = new ListDataEvent(this, 1, p_Index, p_Index);
        for (int intDataListener = 0; intDataListener < this.m_ArrayListDataListeners.size(); ++intDataListener) {
            this.m_ArrayListDataListeners.get(intDataListener).intervalAdded(o_Event);
        }
    }

    public void fireDataListDescriptionRemoved(ControlFunctionDescription p_ControlFunctionDescription) {
        if (p_ControlFunctionDescription == null) {
            return;
        }
        int intIndex = this.m_ControlFunctionDescriptions.indexOf(p_ControlFunctionDescription);
        this.fireDataListDescriptionRemoved(intIndex);
    }

    public void fireDataListDescriptionRemoved(int p_Index) {
        if (p_Index < 0) {
            return;
        }
        if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
            return;
        }
        ListDataEvent o_Event = new ListDataEvent(this, 2, p_Index, p_Index);
        for (int intDataListener = 0; intDataListener < this.m_ArrayListDataListeners.size(); ++intDataListener) {
            this.m_ArrayListDataListeners.get(intDataListener).intervalRemoved(o_Event);
        }
    }

    @Override
    public void addListDataListener(ListDataListener p_DataListener) {
        if (p_DataListener == null) {
            return;
        }
        if (this.m_ArrayListDataListeners == null) {
            return;
        }
        if (this.m_ArrayListDataListeners.contains(p_DataListener)) {
            return;
        }
        this.m_ArrayListDataListeners.add(p_DataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener p_DataListener) {
        if (p_DataListener == null) {
            return;
        }
        if (this.m_ArrayListDataListeners == null) {
            return;
        }
        this.m_ArrayListDataListeners.remove(p_DataListener);
    }

    public ListCellRenderer getListCellRenderer() {
        if (this.m_ListCellRenderer == null) {
            this.m_ListCellRenderer = new ControlFunctionDescriptionCellRenderer();
        }
        return this.m_ListCellRenderer;
    }

    public static class ControlFunctionTypeCellRenderer
    implements ListCellRenderer {
        public static LineBorder s_LineBorder = new LineBorder(Color.BLACK, 1);
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
        private StringBuilder m_StringBuilder;
        private Dimension m_Dimension_Size;

        public ControlFunctionTypeCellRenderer() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_Dimension_Size = new Dimension(100, 20);
            this.m_StringBuilder = new StringBuilder();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.m_StringBuilder.delete(0, this.m_StringBuilder.length());
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            renderer.setForeground(o_Foreground);
            renderer.setBackground(o_Background);
            if (value instanceof ControlFunctionType) {
                renderer.setPreferredSize(this.m_Dimension_Size);
                ControlFunctionType o_ControlFunctionType = (ControlFunctionType)value;
                Icon o_Icon = o_ControlFunctionType.getLabelIconSmall();
                this.m_StringBuilder.append("<html>");
                if (o_ControlFunctionType.getFunctionName() != null) {
                    this.m_StringBuilder.append("<b>");
                    this.m_StringBuilder.append(o_ControlFunctionType.getFunctionName());
                    this.m_StringBuilder.append("</b>");
                }
                this.m_StringBuilder.append("</html>");
                renderer.setText(this.m_StringBuilder.toString());
                renderer.setIcon(o_Icon);
            }
            return renderer;
        }
    }

    public static class ControlFunctionType
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        public static TableAndListModel.ListModel<ControlFunctionType> s_ControlFunctionTypeList = new TableAndListModel.ListModel(false);
        public static ControlFunctionTypeCellRenderer s_ControlFunctionTypeCellRenderer = new ControlFunctionTypeCellRenderer();
        private String m_ID;
        private String m_FunctionName;
        private Image m_Image;
        private Icon m_IconSmall;
        private Icon m_IconBig;
        private BufferedImage m_ImageSmall;
        private BufferedImage m_ImageBig;

        public static TableAndListModel.ListModel<ControlFunctionType> getControlFunctionTypeList() {
            return s_ControlFunctionTypeList;
        }

        public static boolean addControlFunctionType(ControlFunctionType p_ControlFunctionType) {
            if (p_ControlFunctionType == null) {
                return false;
            }
            for (int intType = 0; intType < s_ControlFunctionTypeList.size(); ++intType) {
                ControlFunctionType o_ControlFunctionType = (ControlFunctionType)s_ControlFunctionTypeList.get(intType);
                if (!o_ControlFunctionType.getID().equals(p_ControlFunctionType.getID())) continue;
                o_ControlFunctionType.setProperties(p_ControlFunctionType.getID(), p_ControlFunctionType.getFunctionName(), p_ControlFunctionType.getImage());
                return true;
            }
            s_ControlFunctionTypeList.add((Object)p_ControlFunctionType);
            return true;
        }

        public static boolean removeControlFunctionType(ControlFunctionType p_ControlFunctionType) {
            if (p_ControlFunctionType == null) {
                return false;
            }
            for (int intType = 0; intType < s_ControlFunctionTypeList.size(); ++intType) {
                ControlFunctionType o_ControlFunctionType = (ControlFunctionType)s_ControlFunctionTypeList.get(intType);
                if (!o_ControlFunctionType.getID().equals(p_ControlFunctionType.getID())) continue;
                s_ControlFunctionTypeList.remove((Object)p_ControlFunctionType);
                return true;
            }
            return false;
        }

        public static ControlFunctionType getControlFunctionType(String p_ID) {
            if (p_ID == null) {
                return null;
            }
            for (int intType = 0; intType < s_ControlFunctionTypeList.size(); ++intType) {
                ControlFunctionType o_ControlFunctionType = (ControlFunctionType)s_ControlFunctionTypeList.get(intType);
                if (!o_ControlFunctionType.getID().equals(p_ID)) continue;
                return o_ControlFunctionType;
            }
            return null;
        }

        public static void loadControlFunctionList(File p_File) {
            if (p_File == null) {
                return;
            }
            if (!p_File.exists()) {
                return;
            }
            FileInputStream o_FileInputStream = null;
            ObjectInputStream o_ObjectInputStream = null;
            try {
                o_FileInputStream = new FileInputStream(p_File);
                o_ObjectInputStream = new ObjectInputStream(o_FileInputStream);
                int intTypeCount = o_ObjectInputStream.readInt();
                for (int intType = 0; intType < intTypeCount; ++intType) {
                    ControlFunctionType o_ControlFunctionType = new ControlFunctionType();
                    o_ControlFunctionType.readExternal(o_ObjectInputStream);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (o_ObjectInputStream != null) {
                    o_ObjectInputStream.close();
                }
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public ControlFunctionType() {
            this.initMembers();
        }

        public ControlFunctionType(String p_ID) {
            this.initMembers();
            if (p_ID != null) {
                this.m_ID = p_ID;
            }
        }

        public ControlFunctionType(String p_ID, String p_FunctionName, ImageIcon p_ImageIcon) {
            this.initMembers();
            if (p_ID != null) {
                this.m_ID = p_ID;
            }
            if (p_FunctionName != null) {
                this.m_FunctionName = p_FunctionName;
            }
            this.m_Image = p_ImageIcon == null ? null : p_ImageIcon.getImage();
            this.calculateIcons();
            s_ControlFunctionTypeList.add((Object)this);
        }

        private void initMembers() {
            this.m_ID = LiveGUID.getUID();
            this.m_FunctionName = "";
            this.m_Image = null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeUTF(this.m_FunctionName);
            ImagesTools.writeImage((ObjectOutput)out, (Image)this.m_Image);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            this.m_FunctionName = in.readUTF();
            this.m_Image = ImagesTools.readImage((ObjectInput)in);
            this.calculateIcons();
        }

        public void setProperties(String p_ID, String p_FunctionName, Image p_Image) {
            if (p_ID != null) {
                this.m_ID = p_ID;
            }
            if (p_FunctionName != null) {
                this.m_FunctionName = p_FunctionName;
            }
            this.m_Image = p_Image;
            this.calculateIcons();
        }

        public void setID(String p_ID) {
            if (p_ID == null) {
                return;
            }
            this.m_ID = p_ID;
        }

        public String getID() {
            return this.m_ID;
        }

        public String getFunctionName() {
            return this.m_FunctionName;
        }

        public Image getImage() {
            return this.m_Image;
        }

        public Icon getLabelIconSmall() {
            return this.m_IconSmall;
        }

        public Icon getLabelIconBig() {
            return this.m_IconBig;
        }

        private void calculateIcons() {
            if (this.m_Image == null) {
                this.m_ImageSmall = ImagesTools.createBufferedImage((String)this.m_FunctionName, (Dimension)DIMENSION_SMALL);
                this.m_ImageBig = ImagesTools.createBufferedImage((String)this.m_FunctionName, (Dimension)DIMENSION_BIG);
            } else {
                this.m_ImageSmall = ImagesTools.convertToBufferedImageAspectRatio((Image)this.m_Image, (Dimension)DIMENSION_SMALL);
                this.m_ImageBig = ImagesTools.convertToBufferedImageAspectRatio((Image)this.m_Image, (Dimension)DIMENSION_BIG);
            }
            this.m_IconSmall = new ImageIcon(this.m_ImageSmall);
            this.m_IconBig = new ImageIcon(this.m_ImageBig);
        }
    }

    public static class ControlFunctionDescription
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        private ControlFunctionModel m_ControlFunctionModel;
        private ControlFunctionType m_ControlFunctionType;
        private double m_Value;

        public ControlFunctionDescription() {
            this.initMembers();
        }

        public ControlFunctionDescription(ControlFunctionType p_ControlFunctionType, double p_Value) {
            this.m_ControlFunctionType = p_ControlFunctionType;
            this.m_Value = p_Value;
        }

        private void initMembers() {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            if (this.m_ControlFunctionType == null) {
                out.writeUTF("null");
            } else {
                out.writeUTF(this.m_ControlFunctionType.getID());
                out.writeDouble(this.m_Value);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            String stringTypeID = in.readUTF();
            if ("null".equals(stringTypeID)) {
                this.m_ControlFunctionType = null;
                this.m_Value = 0.0;
            } else {
                this.m_ControlFunctionType = ControlFunctionType.getControlFunctionType(stringTypeID);
                this.m_Value = in.readDouble();
            }
        }

        public long getDiskSpaceEstimated() {
            long longBytesCount = 0L;
            longBytesCount += 4L;
            if (this.m_ControlFunctionType == null) {
                longBytesCount += (long)("null".length() * 2);
            } else {
                longBytesCount += (long)(this.m_ControlFunctionType.getID().length() * 2);
                longBytesCount += 8L;
            }
            return longBytesCount;
        }

        public void setControlFunctionModel(ControlFunctionModel p_ControlFunctionModel) {
            this.m_ControlFunctionModel = p_ControlFunctionModel;
        }

        public ControlFunctionModel getControlFunctionModel() {
            return this.m_ControlFunctionModel;
        }

        public int getByteCount() {
            if (this.m_ControlFunctionModel == null) {
                return 0;
            }
            return this.m_ControlFunctionModel.getByteCount();
        }

        public double getMinValue() {
            if (this.m_ControlFunctionModel == null) {
                return 0.0;
            }
            return this.m_ControlFunctionModel.getMinValue();
        }

        public double getMaxValue() {
            if (this.m_ControlFunctionModel == null) {
                return 0.0;
            }
            return this.m_ControlFunctionModel.getMaxValue();
        }

        public boolean getOnlyIntegerValues() {
            if (this.m_ControlFunctionModel == null) {
                return false;
            }
            return this.m_ControlFunctionModel.getOnlyIntegerValues();
        }

        public void setProperties(ControlFunctionType p_ControlFunctionType, double p_Value) {
            this.m_ControlFunctionType = p_ControlFunctionType;
            this.m_Value = p_Value;
            if (this.m_ControlFunctionModel == null) {
                return;
            }
            this.m_ControlFunctionModel.fireIndexedPropertyChange(ControlFunctionModel.PROP_FUNCTIONPROPERTIES, this.m_ControlFunctionModel.getIndexOf(this), false, true);
            this.m_ControlFunctionModel.fireDataListDescriptionChanged(this);
        }

        public void setControlFunctionType(ControlFunctionType p_ControlFunctionType) {
            ControlFunctionType oldValue = this.m_ControlFunctionType;
            this.m_ControlFunctionType = p_ControlFunctionType;
            if (this.m_ControlFunctionModel == null) {
                return;
            }
            this.m_ControlFunctionModel.fireIndexedPropertyChange(ControlFunctionModel.PROP_FUNCTIONTYPE, this.m_ControlFunctionModel.getIndexOf(this), oldValue, this.m_ControlFunctionType);
            this.m_ControlFunctionModel.fireDataListDescriptionChanged(this);
        }

        public ControlFunctionType getControlFunctionType() {
            return this.m_ControlFunctionType;
        }

        public String getFunctionName() {
            if (this.m_ControlFunctionType == null) {
                return "";
            }
            return this.m_ControlFunctionType.getFunctionName();
        }

        public void setValue(double p_ValueDefault) {
            double oldValue = this.m_Value;
            this.m_Value = p_ValueDefault;
            if (this.m_ControlFunctionModel == null) {
                return;
            }
            if (oldValue != this.m_Value) {
                this.m_ControlFunctionModel.resortDescriptions(this);
                this.m_ControlFunctionModel.fireIndexedPropertyChange(ControlFunctionModel.PROP_FUNCTIONVALUE, this.m_ControlFunctionModel.getIndexOf(this), oldValue, this.m_Value);
                this.m_ControlFunctionModel.fireDataListDescriptionChanged(this);
            }
        }

        public double getValue() {
            return this.m_Value;
        }

        public Image getFunctionImage() {
            if (this.m_ControlFunctionType == null) {
                return null;
            }
            return this.m_ControlFunctionType.getImage();
        }

        public Icon getLabelIconSmall() {
            if (this.m_ControlFunctionType == null) {
                return null;
            }
            return this.m_ControlFunctionType.getLabelIconSmall();
        }

        public Icon getLabelIconBig() {
            if (this.m_ControlFunctionType == null) {
                return null;
            }
            return this.m_ControlFunctionType.getLabelIconBig();
        }

        public boolean isSameAs(ControlFunctionDescription p_ControlFunctionDescription) {
            if (p_ControlFunctionDescription == null) {
                return false;
            }
            ControlFunctionType o_ControlFunctionType = p_ControlFunctionDescription.getControlFunctionType();
            if (this.m_Value != p_ControlFunctionDescription.getValue()) {
                return false;
            }
            if (this.m_ControlFunctionType == null) {
                if (o_ControlFunctionType != null) {
                    return false;
                }
            } else {
                if (o_ControlFunctionType == null) {
                    return false;
                }
                if (!this.m_ControlFunctionType.getID().equals(o_ControlFunctionType.getID())) {
                    return false;
                }
            }
            return true;
        }

        public ControlFunctionDescription getCopy() {
            ControlFunctionDescription o_ControlFunctionDescription = new ControlFunctionDescription();
            o_ControlFunctionDescription.setProperties(this.m_ControlFunctionType, this.m_Value);
            return o_ControlFunctionDescription;
        }
    }

    public static class ControlFunctionDescriptionCellRenderer
    extends JPanel
    implements ListCellRenderer {
        public static LineBorder s_LineBorder = new LineBorder(Color.BLACK, 1);
        private StringBuffer m_StringBuffer;
        private ArrayList<Integer> m_Bytes;
        private JLabel m_JLabelText;
        private JLabel m_JLabelValues;
        private Dimension m_Dimension_Size;

        public ControlFunctionDescriptionCellRenderer() {
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_Dimension_Size = new Dimension(100, 20);
            this.m_StringBuffer = new StringBuffer();
            this.m_Bytes = new ArrayList();
        }

        private void initComponents() {
            GridBagLayout o_GridBagLayout = new GridBagLayout();
            this.setLayout(o_GridBagLayout);
            this.m_JLabelText = new JLabel();
            this.m_JLabelText.setHorizontalAlignment(10);
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 1.0;
            this.add((Component)this.m_JLabelText, o_GridBagConstraints);
            this.m_JLabelText.setVisible(true);
            this.m_JLabelValues = new JLabel();
            this.m_JLabelValues.setHorizontalAlignment(4);
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 1;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 0.5;
            this.add((Component)this.m_JLabelValues, o_GridBagConstraints);
            this.m_JLabelValues.setVisible(true);
        }

        public void calculateValueByte(ControlFunctionDescription p_ControlFunctionDescription, double p_Value) {
            int intByte;
            if (this.m_Bytes.size() < p_ControlFunctionDescription.getByteCount()) {
                for (intByte = this.m_Bytes.size(); intByte < p_ControlFunctionDescription.getByteCount(); ++intByte) {
                    this.m_Bytes.add(0);
                }
            }
            if (this.m_Bytes.size() > p_ControlFunctionDescription.getByteCount()) {
                for (intByte = this.m_Bytes.size(); intByte > p_ControlFunctionDescription.getByteCount(); --intByte) {
                    this.m_Bytes.remove(0);
                }
            }
            double doubleValue = p_Value;
            for (int intByte2 = this.m_Bytes.size() - 1; intByte2 >= 0; --intByte2) {
                double doubleByteValue = doubleValue - (double)((int)(doubleValue / 256.0) * 256);
                doubleValue = (int)(doubleValue / 256.0);
                this.m_Bytes.set(intByte2, (int)doubleByteValue);
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.m_JLabelText.setForeground(o_Foreground);
            this.m_JLabelText.setBackground(o_Background);
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            if (value instanceof ControlFunctionDescription) {
                this.setPreferredSize(this.m_Dimension_Size);
                ControlFunctionDescription o_ControlFunctionDescription = (ControlFunctionDescription)value;
                Icon o_Icon = o_ControlFunctionDescription.getLabelIconSmall();
                this.m_JLabelText.setIcon(o_Icon);
                this.m_StringBuffer.delete(0, this.m_StringBuffer.length());
                this.m_StringBuffer.append("<html>");
                if (o_ControlFunctionDescription.getFunctionName() != null) {
                    this.m_StringBuffer.append("<b>");
                    this.m_StringBuffer.append(o_ControlFunctionDescription.getFunctionName());
                    this.m_StringBuffer.append("</b>");
                }
                this.m_StringBuffer.append("</html>");
                this.m_JLabelText.setText(this.m_StringBuffer.toString());
                this.m_StringBuffer.delete(0, this.m_StringBuffer.length());
                this.m_StringBuffer.append("<html>");
                if (!o_ControlFunctionDescription.getOnlyIntegerValues()) {
                    this.m_StringBuffer.append(o_ControlFunctionDescription.getValue());
                } else {
                    this.calculateValueByte(o_ControlFunctionDescription, o_ControlFunctionDescription.getValue());
                    for (int intByte = 0; intByte < this.m_Bytes.size(); ++intByte) {
                        if (intByte > 0) {
                            this.m_StringBuffer.append("/");
                        }
                        this.m_StringBuffer.append(this.m_Bytes.get(intByte));
                    }
                }
                this.m_StringBuffer.append("</html>");
                this.m_JLabelValues.setText(this.m_StringBuffer.toString());
            }
            return this;
        }
    }
}

