/*
 * Decompiled with CFR 0.152.
 */
package LiveShowControlModels;

import LiveShowObjectPackage.SinglePropertyChangeSupport;
import ToolsGraphics.ImagesTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ControlBlockModel
implements Externalizable,
ComboBoxModel,
PropertyChangeListener {
    public static final int SOFTWAREVERSION = 2;
    public static final String PROP_SELECTEDLIST = "listSelected";
    public static final String PROP_LISTADDED = "listAdded";
    public static final String PROP_LISTREMOVED = "listRemoved";
    public static final Dimension DIMENSION_SMALL = new Dimension(12, 12);
    public static final Dimension DIMENSION_BIG = new Dimension(28, 28);
    protected double m_MinValue;
    protected double m_MaxValue;
    protected int m_ByteCount;
    protected boolean m_OnlyInteger;
    protected ArrayList<ControlBlockList> m_ControlBlockLists;
    protected ControlBlockList m_SelectedControlBlockList;
    protected ControBlockListSelection m_ControlBlockListSelection;
    protected ListCellRenderer m_ControBlockDescriptionCellRenderer;
    protected ListCellRenderer m_ControlBlockListCellRenderer;
    protected ArrayList<ListDataListener> m_ArrayListDataListeners;
    protected SinglePropertyChangeSupport m_PropertyChangeSupport;
    private static final Object m_SyncObjects = new Object();
    private static final Object m_SyncListDataListeners = new Object();

    public ControlBlockModel(double p_MinValue, double p_MaxValue) {
        this.initMembers();
        this.m_MinValue = p_MinValue;
        this.m_MaxValue = p_MaxValue;
        this.calculateByteCount();
        this.readResolve();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMembers() {
        this.m_ControlBlockLists = new ArrayList();
        ControlBlockList o_ControlBlockList = new ControlBlockList(this);
        Object object = m_SyncObjects;
        synchronized (object) {
            this.m_ControlBlockLists.add(o_ControlBlockList);
        }
        this.m_SelectedControlBlockList = o_ControlBlockList;
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport((Object)this);
        this.m_ArrayListDataListeners = new ArrayList();
        this.m_OnlyInteger = false;
        this.m_ByteCount = 0;
    }

    private Object readResolve() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
        p_ObjectOutput.writeInt(2);
        Object object = m_SyncObjects;
        synchronized (object) {
            p_ObjectOutput.writeInt(this.m_ControlBlockLists.size());
            for (int intList = 0; intList < this.m_ControlBlockLists.size(); ++intList) {
                ControlBlockList o_ControlBlockList = this.m_ControlBlockLists.get(intList);
                o_ControlBlockList.writeExternal(p_ObjectOutput);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = p_ObjectInput.readInt();
        this.clearControlBlockLists();
        int intListCount = intSoftwareVersion > 1 ? p_ObjectInput.readInt() : 1;
        for (int intList = 0; intList < intListCount; ++intList) {
            ControlBlockList o_ControlBlockList = intList < 0 || intList >= this.m_ControlBlockLists.size() ? new ControlBlockList(this) : this.m_ControlBlockLists.get(intList);
            o_ControlBlockList.setListModelSoftwareVersion(intSoftwareVersion);
            o_ControlBlockList.readExternal(p_ObjectInput);
            this.addControlBlockList(o_ControlBlockList);
        }
        this.m_SelectedControlBlockList = this.m_ControlBlockLists.size() >= 0 ? this.m_ControlBlockLists.get(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDiskSpaceEstimated() {
        long longBytesCount = 0L;
        longBytesCount += 4L;
        longBytesCount += 4L;
        Object object = m_SyncObjects;
        synchronized (object) {
            for (int intList = 0; intList < this.m_ControlBlockLists.size(); ++intList) {
                ControlBlockList o_ControlBlockList = this.m_ControlBlockLists.get(intList);
                longBytesCount += o_ControlBlockList.getDiskSpaceEstimated();
            }
        }
        return longBytesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControlBlockModel getCopy() {
        ControlBlockModel o_ControlBlockModel = new ControlBlockModel(this.m_MinValue, this.m_MaxValue);
        o_ControlBlockModel.clearControlBlockLists();
        Object object = m_SyncObjects;
        synchronized (object) {
            for (int intDescriptionList = 0; intDescriptionList < this.m_ControlBlockLists.size(); ++intDescriptionList) {
                ControlBlockList o_ControlBlockListSelf = this.getControlBlockList(intDescriptionList);
                if (o_ControlBlockListSelf == null) continue;
                ControlBlockList o_ControlBlockListCopy = o_ControlBlockListSelf.getCopy(o_ControlBlockModel);
                o_ControlBlockModel.addControlBlockList(o_ControlBlockListCopy);
            }
        }
        return o_ControlBlockModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearControlBlockLists() {
        ArrayList<ControlBlockList> o_ControlBlockLists;
        Object object = m_SyncObjects;
        synchronized (object) {
            if (this.m_ControlBlockLists.size() <= 0) {
                return;
            }
            o_ControlBlockLists = new ArrayList<ControlBlockList>(this.m_ControlBlockLists.size());
            o_ControlBlockLists.addAll(this.m_ControlBlockLists);
        }
        for (int intList = o_ControlBlockLists.size() - 1; intList >= 0; --intList) {
            ControlBlockList o_ControlBlockList = (ControlBlockList)o_ControlBlockLists.get(intList);
            if (o_ControlBlockList == null) continue;
            o_ControlBlockList.clearControlBlockDescriptions();
            this.removeControlBlockList(o_ControlBlockList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addControlBlockList(ControlBlockList p_ControlBlockList) {
        int intIndex;
        if (p_ControlBlockList == null) {
            return;
        }
        if (this.m_ControlBlockLists.contains(p_ControlBlockList)) {
            return;
        }
        Object object = m_SyncObjects;
        synchronized (object) {
            this.m_ControlBlockLists.add(p_ControlBlockList);
            intIndex = this.m_ControlBlockLists.indexOf(p_ControlBlockList);
        }
        p_ControlBlockList.addPropertyChangeListener(this);
        this.fireDataList_ListAdded(intIndex);
        this.setSelectedBlockList(p_ControlBlockList);
        this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_LISTADDED, intIndex, null, (Object)p_ControlBlockList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeControlBlockList(ControlBlockList p_ControlBlockList) {
        int intIndex;
        if (p_ControlBlockList == null) {
            return;
        }
        p_ControlBlockList.removePropertyChangeListener(this);
        Object object = m_SyncObjects;
        synchronized (object) {
            intIndex = this.m_ControlBlockLists.indexOf(p_ControlBlockList);
            if (intIndex < 0) {
                return;
            }
            this.m_ControlBlockLists.remove(p_ControlBlockList);
        }
        this.fireDataList_ListRemoved(intIndex);
        if (this.m_SelectedControlBlockList == p_ControlBlockList) {
            this.setSelectedBlockList(0);
        }
        this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_LISTREMOVED, intIndex, (Object)p_ControlBlockList, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControlBlockList getControlBlockList(int p_Index) {
        Object object = m_SyncObjects;
        synchronized (object) {
            if (p_Index < 0 || p_Index >= this.m_ControlBlockLists.size()) {
                return null;
            }
            return this.m_ControlBlockLists.get(p_Index);
        }
    }

    public int getControlBlockListSize() {
        return this.m_ControlBlockLists.size();
    }

    public void setOnlyIntegerValues(boolean p_OnlyIntegerValues) {
        this.m_OnlyInteger = p_OnlyIntegerValues;
        this.calculateByteCount();
    }

    public boolean getOnlyIntegerValues() {
        return this.m_OnlyInteger;
    }

    private void calculateByteCount() {
        if (!this.m_OnlyInteger) {
            this.m_ByteCount = 0;
        } else {
            int intByteCount = 1;
            for (double doubleValueMax = Math.max(Math.abs(this.m_MaxValue), Math.abs(this.m_MinValue)); doubleValueMax >= 256.0; doubleValueMax /= 256.0) {
                ++intByteCount;
            }
            this.m_ByteCount = intByteCount;
        }
    }

    public void setValueRange(double p_MinValue, double p_MaxValue) {
        this.m_MinValue = p_MinValue;
        this.m_MaxValue = p_MaxValue;
        this.calculateByteCount();
    }

    public int getByteCount() {
        return this.m_ByteCount;
    }

    public double getMinValue() {
        return this.m_MinValue;
    }

    public double getMaxValue() {
        return this.m_MaxValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSameAs(ControlBlockModel p_ControlBlockModel) {
        if (p_ControlBlockModel == null) {
            return false;
        }
        Object object = m_SyncObjects;
        synchronized (object) {
            if (this.m_ControlBlockLists.size() != p_ControlBlockModel.getControlBlockListSize()) {
                return false;
            }
            for (int intList = 0; intList < this.m_ControlBlockLists.size(); ++intList) {
                ControlBlockList o_ControlBlockList;
                ControlBlockList o_ControlBlockListSelf = this.m_ControlBlockLists.get(intList);
                if (o_ControlBlockListSelf == null || o_ControlBlockListSelf.isSameAs(o_ControlBlockList = p_ControlBlockModel.getControlBlockList(intList))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDataList_ListAdded(int p_Index) {
        ArrayList<ListDataListener> o_ListDataListeners;
        if (p_Index < 0) {
            return;
        }
        Object object = m_SyncListDataListeners;
        synchronized (object) {
            if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
                return;
            }
            o_ListDataListeners = new ArrayList<ListDataListener>(this.m_ArrayListDataListeners.size());
            o_ListDataListeners.addAll(this.m_ArrayListDataListeners);
        }
        ListDataEvent o_Event = new ListDataEvent(this, 1, p_Index, p_Index);
        for (int intDataListener = 0; intDataListener < o_ListDataListeners.size(); ++intDataListener) {
            ((ListDataListener)o_ListDataListeners.get(intDataListener)).intervalAdded(o_Event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDataList_ListRemoved(int p_Index) {
        ArrayList<ListDataListener> o_ListDataListeners;
        if (p_Index < 0) {
            return;
        }
        if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
            return;
        }
        Object object = m_SyncListDataListeners;
        synchronized (object) {
            if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
                return;
            }
            o_ListDataListeners = new ArrayList<ListDataListener>(this.m_ArrayListDataListeners.size());
            o_ListDataListeners.addAll(this.m_ArrayListDataListeners);
        }
        ListDataEvent o_Event = new ListDataEvent(this, 2, p_Index, p_Index);
        for (int intDataListener = 0; intDataListener < o_ListDataListeners.size(); ++intDataListener) {
            ((ListDataListener)o_ListDataListeners.get(intDataListener)).intervalRemoved(o_Event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDataList_ListChanged(int p_Index) {
        ArrayList<ListDataListener> o_ListDataListeners;
        if (p_Index < 0) {
            return;
        }
        if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
            return;
        }
        Object object = m_SyncListDataListeners;
        synchronized (object) {
            if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
                return;
            }
            o_ListDataListeners = new ArrayList<ListDataListener>(this.m_ArrayListDataListeners.size());
            o_ListDataListeners.addAll(this.m_ArrayListDataListeners);
        }
        ListDataEvent o_Event = new ListDataEvent(this, 0, p_Index, p_Index);
        for (int intDataListener = 0; intDataListener < o_ListDataListeners.size(); ++intDataListener) {
            ((ListDataListener)o_ListDataListeners.get(intDataListener)).contentsChanged(o_Event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDataList_ListSelected(int p_Index) {
        ArrayList<ListDataListener> o_ListDataListeners;
        if (p_Index < 0) {
            return;
        }
        if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
            return;
        }
        Object object = m_SyncListDataListeners;
        synchronized (object) {
            if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
                return;
            }
            o_ListDataListeners = new ArrayList<ListDataListener>(this.m_ArrayListDataListeners.size());
            o_ListDataListeners.addAll(this.m_ArrayListDataListeners);
        }
        ListDataEvent o_Event = new ListDataEvent(this, 0, p_Index, p_Index);
        for (int intDataListener = 0; intDataListener < o_ListDataListeners.size(); ++intDataListener) {
            ((ListDataListener)o_ListDataListeners.get(intDataListener)).contentsChanged(o_Event);
        }
    }

    @Override
    public int getSize() {
        return this.m_ControlBlockLists.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getElementAt(int p_Index) {
        Object object = m_SyncObjects;
        synchronized (object) {
            if (p_Index < 0 || p_Index >= this.m_ControlBlockLists.size()) {
                return null;
            }
            return this.m_ControlBlockLists.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListDataListener(ListDataListener p_ListDataListener) {
        if (p_ListDataListener == null) {
            return;
        }
        Object object = m_SyncListDataListeners;
        synchronized (object) {
            if (this.m_ArrayListDataListeners == null) {
                return;
            }
            if (this.m_ArrayListDataListeners.contains(p_ListDataListener)) {
                return;
            }
            this.m_ArrayListDataListeners.add(p_ListDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListDataListener(ListDataListener p_ListDataListener) {
        if (p_ListDataListener == null) {
            return;
        }
        Object object = m_SyncListDataListeners;
        synchronized (object) {
            if (this.m_ArrayListDataListeners == null) {
                return;
            }
            this.m_ArrayListDataListeners.remove(p_ListDataListener);
        }
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (!(anItem instanceof ControlBlockList)) {
            return;
        }
        ControlBlockList o_ControlBlockList = (ControlBlockList)anItem;
        this.setSelectedBlockList(o_ControlBlockList);
    }

    @Override
    public Object getSelectedItem() {
        return this.m_SelectedControlBlockList;
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    public boolean setSelectedBlockList(ControlBlockList p_ControlBlockList) {
        if (this.m_SelectedControlBlockList == p_ControlBlockList) {
            return true;
        }
        ControlBlockList oldValue = this.m_SelectedControlBlockList;
        this.m_SelectedControlBlockList = p_ControlBlockList;
        int intIndex = this.m_SelectedControlBlockList == null ? -1 : this.m_ControlBlockLists.indexOf(this.m_SelectedControlBlockList);
        this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_SELECTEDLIST, intIndex, (Object)oldValue, (Object)this.m_SelectedControlBlockList);
        return true;
    }

    public boolean setSelectedBlockList(int p_ControlBlocklistIndex) {
        ControlBlockList o_ControlBlockList = p_ControlBlocklistIndex < 0 || p_ControlBlocklistIndex >= this.m_ControlBlockLists.size() ? null : this.m_ControlBlockLists.get(p_ControlBlocklistIndex);
        this.setSelectedBlockList(o_ControlBlockList);
        return true;
    }

    public ControlBlockList getSelectedControlBlockList() {
        return this.m_SelectedControlBlockList;
    }

    public int getSelectedControlBlockListIndex() {
        if (this.m_SelectedControlBlockList == null) {
            return -1;
        }
        return this.m_ControlBlockLists.indexOf(this.m_SelectedControlBlockList);
    }

    public int getControlBlockDescriptionSize() {
        if (this.m_SelectedControlBlockList == null) {
            return 0;
        }
        return this.m_SelectedControlBlockList.getControlBlockDescriptionSize();
    }

    public ControlBlockDescription getControlBlockDescription(int p_BlockIndex) {
        if (this.m_SelectedControlBlockList == null) {
            return null;
        }
        return this.m_SelectedControlBlockList.getControlBlockDescription(p_BlockIndex);
    }

    public void addControlBlockDescription(ControlBlockDescription p_ControlBlockDescription) {
        if (this.m_SelectedControlBlockList != null) {
            this.m_SelectedControlBlockList.addControlBlockDescription(p_ControlBlockDescription);
        }
    }

    public void removeControlBlockDescription(ControlBlockDescription p_ControlBlockDescription) {
        if (this.m_SelectedControlBlockList != null) {
            this.m_SelectedControlBlockList.removeControlBlockDescription(p_ControlBlockDescription);
        }
    }

    public int getIndexOf(ControlBlockDescription p_ControlBlockDescription) {
        if (this.m_SelectedControlBlockList == null) {
            return -1;
        }
        return this.m_SelectedControlBlockList.getIndexOf(p_ControlBlockDescription);
    }

    public void clearControlBlockDescriptions() {
        if (this.m_SelectedControlBlockList == null) {
            return;
        }
        this.m_SelectedControlBlockList.clearControlBlockDescriptions();
    }

    public ControlBlockDescription createControlBlockDescription(double p_ValueStart, double p_ValueEnd, Double p_ValueDefault, String p_Text) {
        if (this.m_SelectedControlBlockList == null) {
            return null;
        }
        return this.m_SelectedControlBlockList.createControlBlockDescription(p_ValueStart, p_ValueEnd, p_ValueDefault, p_Text);
    }

    public ControlBlockDescription createControlBlockDescription(double p_ValueStart, double p_ValueEnd, Double p_ValueDefault, Image p_Image) {
        if (this.m_SelectedControlBlockList == null) {
            return null;
        }
        return this.m_SelectedControlBlockList.createControlBlockDescription(p_ValueStart, p_ValueEnd, p_ValueDefault, p_Image);
    }

    public ControlBlockDescription createControlBlockDescription(double p_ValueStart, double p_ValueEnd, Double p_ValueDefault, Color p_Color) {
        if (this.m_SelectedControlBlockList == null) {
            return null;
        }
        return this.m_SelectedControlBlockList.createControBlockDescription(p_ValueStart, p_ValueEnd, p_ValueDefault, p_Color);
    }

    public ControlBlockDescription createControlBlockDescription(double p_ValueStart, double p_ValueEnd, Double p_ValueDefault, String p_Text, Image p_Image, Color p_Color) {
        if (this.m_SelectedControlBlockList == null) {
            return null;
        }
        return this.m_SelectedControlBlockList.createControlBlockDescription(p_ValueStart, p_ValueEnd, p_ValueDefault, p_Text, p_Image, p_Color);
    }

    public double getMinimalDistance() {
        if (this.m_SelectedControlBlockList == null) {
            return -1.0;
        }
        return this.m_SelectedControlBlockList.getMinimalDistance();
    }

    public ListCellRenderer getControlBlockDescriptionCellRenderer() {
        if (this.m_ControBlockDescriptionCellRenderer == null) {
            this.m_ControBlockDescriptionCellRenderer = new ControlBlockDescriptionCellRenderer();
        }
        return this.m_ControBlockDescriptionCellRenderer;
    }

    public ListCellRenderer getControlBlockListCellRenderer() {
        if (this.m_ControlBlockListCellRenderer == null) {
            this.m_ControlBlockListCellRenderer = new ControlBlockListCellRenderer();
        }
        return this.m_ControlBlockListCellRenderer;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof ControlBlockList) {
            ControlBlockList o_ControlBlockList = (ControlBlockList)evt.getSource();
            if ("listDescription".equals(evt.getPropertyName())) {
                int intIndex = this.m_ControlBlockLists.indexOf(o_ControlBlockList);
                if (intIndex < 0) {
                    return;
                }
                this.fireDataList_ListChanged(intIndex);
            }
        }
    }

    public void showControlBlockListSelection(int p_X, int p_Y) {
        if (this.m_ControlBlockListSelection == null) {
            this.m_ControlBlockListSelection = new ControBlockListSelection(this, p_X, p_Y);
        } else {
            this.m_ControlBlockListSelection.setVisible(true);
        }
        if (this.m_ControlBlockListSelection != null) {
            this.m_ControlBlockListSelection.setLocation(p_X, p_Y);
        }
    }

    public static class ControlBlockDescription
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        protected ControlBlockList m_ControlBlockList;
        private double m_ValueStart;
        private double m_ValueEnd;
        private double m_ValueDefault;
        private String m_Text;
        private Image m_Image;
        private boolean m_Visible;
        private Icon m_IconSmall;
        private Icon m_IconBig;
        private BufferedImage m_ImageSmall;
        private BufferedImage m_ImageBig;
        private Color m_Color;

        public ControlBlockDescription() {
            this.initMembers();
            this.readResolve();
        }

        public ControlBlockDescription(double p_ValueStart, double p_ValueEnd, Double p_ValueDefault, String p_Text, Image p_Image, Color p_Color) {
            this.initMembers();
            this.m_ValueStart = p_ValueStart;
            this.m_ValueEnd = p_ValueEnd;
            this.m_ValueDefault = p_ValueDefault == null || p_ValueDefault < this.m_ValueStart || p_ValueDefault > this.m_ValueEnd ? this.m_ValueStart + (this.m_ValueEnd - this.m_ValueStart) / 2.0 : p_ValueDefault;
            this.m_Text = p_Text == null ? "" : p_Text;
            this.m_Image = p_Image;
            this.m_Color = p_Color;
            this.calculateIcons();
            this.readResolve();
        }

        private void initMembers() {
            this.m_ControlBlockList = null;
            this.m_ValueStart = 0.0;
            this.m_ValueEnd = 0.0;
            this.m_ValueDefault = 0.0;
            this.m_Text = "";
            this.m_Image = null;
            this.m_IconSmall = null;
            this.m_Color = null;
            this.m_Visible = true;
        }

        public void close() {
            this.m_ControlBlockList = null;
            this.m_IconSmall = null;
            this.m_IconBig = null;
            if (this.m_Image != null) {
                this.m_Image.flush();
            }
            if (this.m_ImageSmall != null) {
                this.m_ImageSmall.flush();
            }
            if (this.m_ImageBig != null) {
                this.m_ImageBig.flush();
            }
        }

        private Object readResolve() {
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
            p_ObjectOutput.writeInt(1);
            p_ObjectOutput.writeDouble(this.m_ValueStart);
            p_ObjectOutput.writeDouble(this.m_ValueDefault);
            p_ObjectOutput.writeDouble(this.m_ValueEnd);
            p_ObjectOutput.writeUTF(this.m_Text);
            ImagesTools.writeImage((ObjectOutput)p_ObjectOutput, (Image)this.m_Image);
            ImagesTools.writeColor((ObjectOutput)p_ObjectOutput, (Color)this.m_Color);
            p_ObjectOutput.writeBoolean(this.m_Visible);
        }

        @Override
        public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = p_ObjectInput.readInt();
            this.m_ValueStart = p_ObjectInput.readDouble();
            this.m_ValueDefault = p_ObjectInput.readDouble();
            this.m_ValueEnd = p_ObjectInput.readDouble();
            this.m_Text = p_ObjectInput.readUTF();
            this.m_Image = ImagesTools.readImage((ObjectInput)p_ObjectInput);
            this.m_Color = ImagesTools.readColor((ObjectInput)p_ObjectInput);
            this.m_Visible = p_ObjectInput.readBoolean();
            this.calculateIcons();
        }

        public long getDiskSpaceEstimated() {
            long longBytesCount = 0L;
            longBytesCount += 4L;
            longBytesCount += 8L;
            longBytesCount += 8L;
            longBytesCount += 8L;
            longBytesCount += (long)(this.m_Text.length() * 2);
            longBytesCount += ImagesTools.getDiskSpaceEstimated((Image)this.m_Image);
            longBytesCount += ImagesTools.getDiskSpaceEstimated((Color)this.m_Color);
            return ++longBytesCount;
        }

        public void setControBlockList(ControlBlockList p_ControlBlockList) {
            this.m_ControlBlockList = p_ControlBlockList;
        }

        public ControlBlockList getControlBlockModel() {
            return this.m_ControlBlockList;
        }

        public int getByteCount() {
            if (this.m_ControlBlockList == null) {
                return 0;
            }
            return this.m_ControlBlockList.getByteCount();
        }

        public double getMinValue() {
            if (this.m_ControlBlockList == null) {
                return 0.0;
            }
            return this.m_ControlBlockList.getMinValue();
        }

        public double getMaxValue() {
            if (this.m_ControlBlockList == null) {
                return 0.0;
            }
            return this.m_ControlBlockList.getMaxValue();
        }

        public boolean getOnlyIntegerValues() {
            if (this.m_ControlBlockList == null) {
                return false;
            }
            return this.m_ControlBlockList.getOnlyIntegerValues();
        }

        public ControlBlockDescription getCopy() {
            ControlBlockDescription o_ControlBlockDescription = new ControlBlockDescription();
            o_ControlBlockDescription.setProperties(this.m_ValueStart, this.m_ValueEnd, this.m_ValueDefault, this.m_Text, this.m_Image, this.m_Color);
            o_ControlBlockDescription.setVisible(this.m_Visible);
            return o_ControlBlockDescription;
        }

        public void setProperties(double p_ValueStart, double p_ValueEnd, Double p_ValueDefault, String p_Text, Image p_Image, Color p_Color) {
            if (p_ValueStart <= p_ValueEnd) {
                this.m_ValueStart = p_ValueStart;
                this.m_ValueEnd = p_ValueEnd;
            } else {
                this.m_ValueStart = p_ValueEnd;
                this.m_ValueEnd = p_ValueStart;
            }
            this.m_ValueDefault = p_ValueDefault == null || p_ValueDefault < this.m_ValueStart || p_ValueDefault > this.m_ValueEnd ? this.m_ValueStart + (this.m_ValueEnd - this.m_ValueStart) / 2.0 : p_ValueDefault;
            this.m_Text = p_Text;
            this.m_Image = p_Image;
            this.m_Color = p_Color;
            this.calculateIcons();
            if (this.m_ControlBlockList == null) {
                return;
            }
            this.m_ControlBlockList.resortDescriptions(this);
            this.m_ControlBlockList.fireIndexedPropertyChange("blockProperties", this.m_ControlBlockList.getIndexOf(this), false, true);
            this.m_ControlBlockList.fireDataListDescriptionChanged(this);
        }

        public double getValueStart() {
            return this.m_ValueStart;
        }

        public void setValueStart(double p_ValueStart) {
            double oldValue = this.m_ValueStart;
            this.m_ValueStart = p_ValueStart;
            if (this.m_ControlBlockList == null) {
                return;
            }
            if (oldValue != this.m_ValueStart) {
                if (this.m_ValueStart > this.m_ValueEnd) {
                    this.setValueEnd(this.m_ValueStart);
                }
                if (this.m_ValueDefault < this.m_ValueStart) {
                    this.setValueDefault(this.m_ValueDefault);
                }
                this.m_ControlBlockList.fireIndexedPropertyChange("blockValueStart", this.m_ControlBlockList.getIndexOf(this), oldValue, this.m_ValueStart);
                this.m_ControlBlockList.fireDataListDescriptionChanged(this);
            }
        }

        public double getValueEnd() {
            return this.m_ValueEnd;
        }

        public void setValueEnd(double p_ValueEnd) {
            double oldValue = this.m_ValueEnd;
            this.m_ValueEnd = p_ValueEnd;
            if (this.m_ValueEnd < this.m_ValueStart) {
                this.m_ValueEnd = this.m_ValueStart;
            }
            if (this.m_ControlBlockList == null) {
                return;
            }
            if (oldValue != this.m_ValueEnd) {
                if (this.m_ValueDefault > this.m_ValueEnd) {
                    this.setValueDefault(this.m_ValueDefault);
                }
                this.m_ControlBlockList.fireIndexedPropertyChange("blockValueEnd", this.m_ControlBlockList.getIndexOf(this), oldValue, this.m_ValueEnd);
                this.m_ControlBlockList.fireDataListDescriptionChanged(this);
            }
        }

        public double getValueDefault() {
            return this.m_ValueDefault;
        }

        public void setValueDefault(double p_ValueDefault) {
            if (p_ValueDefault < this.m_ValueStart || p_ValueDefault > this.m_ValueEnd) {
                p_ValueDefault = this.m_ValueStart + (this.m_ValueEnd - this.m_ValueStart) / 2.0;
            }
            double oldValue = this.m_ValueDefault;
            this.m_ValueDefault = p_ValueDefault;
            if (this.m_ControlBlockList == null) {
                return;
            }
            if (oldValue != this.m_ValueDefault) {
                this.m_ControlBlockList.resortDescriptions(this);
                this.m_ControlBlockList.fireIndexedPropertyChange("blockValueDefault", this.m_ControlBlockList.getIndexOf(this), oldValue, this.m_Text);
                this.m_ControlBlockList.fireDataListDescriptionChanged(this);
            }
        }

        public String getBlockText() {
            return this.m_Text;
        }

        public void setBlockText(String p_Text) {
            if (p_Text == null) {
                p_Text = "";
            }
            String oldValue = this.m_Text;
            this.m_Text = p_Text;
            this.calculateIcons();
            if (this.m_ControlBlockList == null) {
                return;
            }
            this.m_ControlBlockList.fireIndexedPropertyChange("blockText", this.m_ControlBlockList.getIndexOf(this), oldValue, this.m_Text);
            this.m_ControlBlockList.fireDataListDescriptionChanged(this);
        }

        public Image getBlockImage() {
            return this.m_Image;
        }

        public void setBlockImage(Image p_Image) {
            if (this.m_Image == p_Image) {
                return;
            }
            Image oldValue = this.m_Image;
            this.m_Image = p_Image;
            if (this.m_Image != null) {
                this.setBlockColor(null);
            }
            this.calculateIcons();
            if (this.m_ControlBlockList == null) {
                return;
            }
            this.m_ControlBlockList.fireIndexedPropertyChange("blockIcon", this.m_ControlBlockList.getIndexOf(this), oldValue, this.m_Image);
            this.m_ControlBlockList.fireDataListDescriptionChanged(this);
        }

        public void setVisible(boolean p_Visible) {
            boolean oldValue = this.m_Visible;
            this.m_Visible = p_Visible;
            if (this.m_ControlBlockList == null) {
                return;
            }
            this.m_ControlBlockList.fireIndexedPropertyChange("blockVisible", this.m_ControlBlockList.getIndexOf(this), oldValue, this.m_Visible);
            this.m_ControlBlockList.fireDataListDescriptionChanged(this);
        }

        public boolean getVisible() {
            return this.m_Visible;
        }

        private void calculateIcons() {
            if (this.m_ImageSmall != null) {
                this.m_ImageSmall.flush();
            }
            if (this.m_IconBig != null) {
                this.m_ImageBig.flush();
            }
            if (this.m_Image == null && this.m_Color == null) {
                this.m_ImageSmall = ImagesTools.createBufferedImage((String)this.m_Text, (Dimension)DIMENSION_SMALL);
                this.m_ImageBig = ImagesTools.createBufferedImage((String)this.m_Text, (Dimension)DIMENSION_BIG);
            } else if (this.m_Image == null) {
                this.m_ImageSmall = ImagesTools.createBufferedImage((Color)this.m_Color, (Dimension)DIMENSION_SMALL);
                this.m_ImageBig = ImagesTools.createBufferedImage((Color)this.m_Color, (Dimension)DIMENSION_BIG);
            } else {
                this.m_ImageSmall = ImagesTools.convertToBufferedImage((Image)this.m_Image, (Dimension)DIMENSION_SMALL);
                this.m_ImageBig = ImagesTools.convertToBufferedImage((Image)this.m_Image, (Dimension)DIMENSION_BIG);
            }
            this.m_IconSmall = new ImageIcon(this.m_ImageSmall);
            this.m_IconBig = new ImageIcon(this.m_ImageBig);
        }

        public Icon getBlockIconSmall() {
            return this.m_IconSmall;
        }

        public Icon getBlockIconBig() {
            return this.m_IconBig;
        }

        public Image getBlockImageSmall() {
            return this.m_ImageSmall;
        }

        public Image getBlockImageBig() {
            return this.m_ImageBig;
        }

        public Color getBlockColor() {
            return this.m_Color;
        }

        public void setBlockColor(Color p_Color) {
            if (this.m_Color == p_Color) {
                return;
            }
            Color oldValue = this.m_Color;
            this.m_Color = p_Color;
            if (this.m_Color != null) {
                this.setBlockImage(null);
            }
            this.calculateIcons();
            if (this.m_ControlBlockList == null) {
                return;
            }
            this.m_ControlBlockList.fireIndexedPropertyChange("blockColor", this.m_ControlBlockList.getIndexOf(this), oldValue, this.m_Color);
            this.m_ControlBlockList.fireDataListDescriptionChanged(this);
        }

        public boolean isSameAs(ControlBlockDescription p_ControlBlockDescription) {
            if (this.m_ValueDefault != p_ControlBlockDescription.getValueDefault()) {
                return false;
            }
            if (this.m_ValueStart != p_ControlBlockDescription.getValueStart()) {
                return false;
            }
            if (this.m_ValueEnd != p_ControlBlockDescription.getValueEnd()) {
                return false;
            }
            return this.m_Text.equals(p_ControlBlockDescription.getBlockText());
        }
    }

    public static class ControlBlockDescriptionCellRenderer
    extends JPanel
    implements ListCellRenderer {
        public static LineBorder s_LineBorder = new LineBorder(Color.BLACK, 1);
        private StringBuffer m_StringBuffer;
        private ArrayList<Integer> m_Bytes;
        private JLabel m_JLabelText;
        private JLabel m_JLabelValues;
        private Dimension m_Dimension_Size;

        public ControlBlockDescriptionCellRenderer() {
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_StringBuffer = new StringBuffer();
            this.m_Bytes = new ArrayList();
            this.m_Dimension_Size = new Dimension(100, 20);
        }

        private void initComponents() {
            GridBagLayout o_GridBagLayout = new GridBagLayout();
            this.setLayout(o_GridBagLayout);
            this.m_JLabelText = new JLabel();
            this.m_JLabelText.setHorizontalAlignment(10);
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 1.0;
            this.add((Component)this.m_JLabelText, o_GridBagConstraints);
            this.m_JLabelText.setVisible(true);
            this.m_JLabelValues = new JLabel();
            this.m_JLabelValues.setHorizontalAlignment(4);
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 1;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 0.5;
            this.add((Component)this.m_JLabelValues, o_GridBagConstraints);
            this.m_JLabelValues.setVisible(true);
        }

        public void calculateValueByte(ControlBlockDescription p_ControlBlockDescription, double p_Value) {
            int intByte;
            if (this.m_Bytes.size() < p_ControlBlockDescription.getByteCount()) {
                for (intByte = this.m_Bytes.size(); intByte < p_ControlBlockDescription.getByteCount(); ++intByte) {
                    this.m_Bytes.add(0);
                }
            }
            if (this.m_Bytes.size() > p_ControlBlockDescription.getByteCount()) {
                for (intByte = this.m_Bytes.size(); intByte > p_ControlBlockDescription.getByteCount(); --intByte) {
                    this.m_Bytes.remove(0);
                }
            }
            double doubleValue = p_Value;
            for (int intByte2 = this.m_Bytes.size() - 1; intByte2 >= 0; --intByte2) {
                double doubleByteValue = doubleValue - (double)((int)(doubleValue / 256.0) * 256);
                doubleValue = (int)(doubleValue / 256.0);
                this.m_Bytes.set(intByte2, (int)doubleByteValue);
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.m_JLabelText.setForeground(o_Foreground);
            this.m_JLabelText.setBackground(o_Background);
            this.m_JLabelValues.setForeground(o_Foreground);
            this.m_JLabelValues.setBackground(o_Background);
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            if (value instanceof ControlBlockDescription) {
                this.setPreferredSize(this.m_Dimension_Size);
                ControlBlockDescription o_ControlBlockDescription = (ControlBlockDescription)value;
                Icon o_Icon = o_ControlBlockDescription.getBlockIconSmall();
                this.m_JLabelText.setIcon(o_Icon);
                this.m_StringBuffer.delete(0, this.m_StringBuffer.length());
                this.m_StringBuffer.append("<html>");
                if (o_ControlBlockDescription.getBlockText() != null) {
                    this.m_StringBuffer.append("<b>");
                    this.m_StringBuffer.append(o_ControlBlockDescription.getBlockText());
                    this.m_StringBuffer.append("</b>");
                }
                this.m_StringBuffer.append("</html>");
                this.m_JLabelText.setText(this.m_StringBuffer.toString());
                this.m_StringBuffer.delete(0, this.m_StringBuffer.length());
                this.m_StringBuffer.append("<html>");
                if (!o_ControlBlockDescription.getOnlyIntegerValues()) {
                    this.m_StringBuffer.append(o_ControlBlockDescription.getValueDefault());
                    this.m_StringBuffer.append(" (");
                    this.m_StringBuffer.append(o_ControlBlockDescription.getValueStart());
                    this.m_StringBuffer.append(" - ");
                    this.m_StringBuffer.append(o_ControlBlockDescription.getValueEnd());
                    this.m_StringBuffer.append(")");
                } else {
                    int intByte;
                    this.calculateValueByte(o_ControlBlockDescription, o_ControlBlockDescription.getValueDefault());
                    for (intByte = 0; intByte < this.m_Bytes.size(); ++intByte) {
                        if (intByte > 0) {
                            this.m_StringBuffer.append("/");
                        }
                        this.m_StringBuffer.append(this.m_Bytes.get(intByte));
                    }
                    this.m_StringBuffer.append(" (");
                    this.calculateValueByte(o_ControlBlockDescription, o_ControlBlockDescription.getValueStart());
                    for (intByte = 0; intByte < this.m_Bytes.size(); ++intByte) {
                        if (intByte > 0) {
                            this.m_StringBuffer.append("/");
                        }
                        this.m_StringBuffer.append(this.m_Bytes.get(intByte));
                    }
                    this.m_StringBuffer.append(" - ");
                    this.calculateValueByte(o_ControlBlockDescription, o_ControlBlockDescription.getValueEnd());
                    for (intByte = 0; intByte < this.m_Bytes.size(); ++intByte) {
                        if (intByte > 0) {
                            this.m_StringBuffer.append("/");
                        }
                        this.m_StringBuffer.append(this.m_Bytes.get(intByte));
                    }
                    this.m_StringBuffer.append(")");
                }
                this.m_StringBuffer.append("</html>");
                this.m_JLabelValues.setText(this.m_StringBuffer.toString());
            }
            return this;
        }
    }

    public static class ControBlockListSelection
    extends JDialog
    implements PropertyChangeListener {
        public static Icon s_Icon = new ImageIcon(ControBlockListSelection.class.getResource("/IconsPackage/Slider.png"));
        private int m_DimensionIndex;
        private JScrollPane jScrollPane_Blocks;
        private JList jList_BlockLists;
        private ControlBlockModel m_ControlBlockModel;

        public ControBlockListSelection(ControlBlockModel p_ControlBlockModel, int p_X, int p_Y) {
            super((Window)null, "", Dialog.ModalityType.MODELESS);
            this.m_ControlBlockModel = p_ControlBlockModel;
            if (this.m_ControlBlockModel == null) {
                this.setVisible(false);
                return;
            }
            this.initComponents();
            super.setTitle("");
            this.setBounds(p_X, p_Y, 200, 300);
            this.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    this.setVisible(false);
                }
            });
            this.setControlBlockModel(this.m_ControlBlockModel);
            this.setVisible(true);
        }

        private void initComponents() {
            this.setIconImage(((ImageIcon)s_Icon).getImage());
            this.setDefaultCloseOperation(1);
            this.setResizable(true);
            this.setUndecorated(false);
            GridBagLayout o_GridBagLayout = new GridBagLayout();
            JPanel o_JPanel = new JPanel(o_GridBagLayout);
            o_JPanel.setPreferredSize(new Dimension(60, 150));
            this.setContentPane(o_JPanel);
            this.jScrollPane_Blocks = new JScrollPane();
            this.jList_BlockLists = new JList();
            this.setControlBlockModel(this.m_ControlBlockModel);
            this.jList_BlockLists.setCellRenderer(new ControlBlockListCellRenderer());
            this.jList_BlockLists.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ControlBlockList o_ControlBlockList = (ControlBlockList)jList_BlockLists.getSelectedValue();
                    if (o_ControlBlockList != null && m_ControlBlockModel != null) {
                        m_ControlBlockModel.setSelectedBlockList(o_ControlBlockList);
                    }
                    this.setVisible(false);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            this.jScrollPane_Blocks.setViewportView(this.jList_BlockLists);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            o_JPanel.add((Component)this.jScrollPane_Blocks, gridBagConstraints);
            this.pack();
        }

        private void setControlBlockModel(ControlBlockModel p_ControlBlockModel) {
            if (this.m_ControlBlockModel != null) {
                this.m_ControlBlockModel.removePropertyChangeListener(this);
            }
            this.m_ControlBlockModel = p_ControlBlockModel;
            if (this.m_ControlBlockModel != null) {
                this.m_ControlBlockModel.addPropertyChangeListener(this);
                this.jList_BlockLists.setModel(this.m_ControlBlockModel);
                ControlBlockList o_SelectedControlBlockList = this.m_ControlBlockModel.getSelectedControlBlockList();
                if (o_SelectedControlBlockList == null) {
                    this.jList_BlockLists.clearSelection();
                } else {
                    this.jList_BlockLists.setSelectedValue(o_SelectedControlBlockList, true);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof ControlBlockModel && ControlBlockModel.PROP_SELECTEDLIST.equals(evt.getPropertyName())) {
                this.setControlBlockModel(this.m_ControlBlockModel);
            }
        }
    }

    public static class ControlBlockListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        public static LineBorder s_LineBorder = new LineBorder(Color.BLACK, 1);
        private StringBuffer m_StringBuilder;
        private JLabel m_JLabelText;
        private Dimension m_Dimension_Size;

        public ControlBlockListCellRenderer() {
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_Dimension_Size = new Dimension(100, 20);
            this.m_StringBuilder = new StringBuffer();
        }

        private void initComponents() {
            GridBagLayout o_GridBagLayout = new GridBagLayout();
            this.setLayout(o_GridBagLayout);
            this.m_JLabelText = new JLabel();
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 1.0;
            this.add((Component)this.m_JLabelText, o_GridBagConstraints);
            this.m_JLabelText.setVisible(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.m_JLabelText.setForeground(o_Foreground);
            this.m_JLabelText.setBackground(o_Background);
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            if (value instanceof ControlBlockList) {
                ControlBlockList o_ControlBlockList = (ControlBlockList)value;
                this.setPreferredSize(this.m_Dimension_Size);
                this.m_StringBuilder.delete(0, this.m_StringBuilder.length());
                this.m_StringBuilder.append("<html>");
                this.m_StringBuilder.append(String.valueOf(index + 1));
                this.m_StringBuilder.append(" ");
                this.m_StringBuilder.append("<b>");
                this.m_StringBuilder.append(o_ControlBlockList.getListDecription());
                this.m_StringBuilder.append("</b>");
                this.m_StringBuilder.append("</html>");
                this.m_JLabelText.setText(this.m_StringBuilder.toString());
            }
            return this;
        }
    }

    public static class ControlBlockList
    implements Externalizable,
    ComboBoxModel<ControlBlockDescription> {
        public static final int SOFTWAREVERSION = 2;
        public static final String PROP_LISTDESCRIPTION = "listDescription";
        public static final String PROP_BLOCKDESCRIPTION = "blockDescription";
        public static final String PROP_BLOCKDESCRIPTIONRESORTED = "blockDescriptionResorted";
        public static final String PROP_BLOCKPROPERTIES = "blockProperties";
        public static final String PROP_BLOCKVALUESTART = "blockValueStart";
        public static final String PROP_BLOCKVALUEEND = "blockValueEnd";
        public static final String PROP_BLOCKVALUEDEFAULT = "blockValueDefault";
        public static final String PROP_BLOCKTEXT = "blockText";
        public static final String PROP_BLOCKIMAGE = "blockIcon";
        public static final String PROP_BLOCKCOLOR = "blockColor";
        public static final String PROP_BLOCKVISIBLE = "blockVisible";
        protected ControlBlockModel m_ControBlockModel;
        private int m_ListModelSoftwareVersion;
        protected String m_ListDescription;
        protected ArrayList<ControlBlockDescription> m_ControlBlockDescriptions;
        protected ControlBlockDescription m_SelectedControlBlockDescription;
        protected SinglePropertyChangeSupport m_PropertyChangeSupport;
        protected ArrayList<ListDataListener> m_ArrayListDataListeners;
        protected double m_MinmalDistance;
        private final Object m_SyncObjects = new Object();
        private final Object m_SyncListDataListeners = new Object();

        public ControlBlockList(ControlBlockModel p_ControlBlockModel) {
            this.initMembers();
            this.m_ControBlockModel = p_ControlBlockModel;
            this.readResolve();
        }

        private void initMembers() {
            this.m_ControlBlockDescriptions = new ArrayList();
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport((Object)this);
            this.m_ArrayListDataListeners = new ArrayList();
            this.m_ListModelSoftwareVersion = -1;
            this.m_ListDescription = "Standard";
            this.m_SelectedControlBlockDescription = null;
        }

        private Object readResolve() {
            this.calculateMinimalValueDistance();
            return this;
        }

        public void setListModelSoftwareVersion(int p_SoftwareVersion) {
            this.m_ListModelSoftwareVersion = p_SoftwareVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeExternal(ObjectOutput p_ObjectOutput) throws IOException {
            p_ObjectOutput.writeInt(2);
            p_ObjectOutput.writeUTF(this.m_ListDescription);
            Object object = this.m_SyncObjects;
            synchronized (object) {
                p_ObjectOutput.writeInt(this.m_ControlBlockDescriptions.size());
                for (int intDescription = 0; intDescription < this.m_ControlBlockDescriptions.size(); ++intDescription) {
                    ControlBlockDescription o_ControlBlockDescription = this.m_ControlBlockDescriptions.get(intDescription);
                    o_ControlBlockDescription.writeExternal(p_ObjectOutput);
                }
            }
        }

        @Override
        public void readExternal(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
            int intSoftwareVersion;
            if (this.m_ListModelSoftwareVersion == 1) {
                intSoftwareVersion = 1;
            } else {
                intSoftwareVersion = p_ObjectInput.readInt();
                this.m_ListDescription = p_ObjectInput.readUTF();
            }
            this.clearControlBlockDescriptions();
            int intSize = p_ObjectInput.readInt();
            for (int intDescription = 0; intDescription < intSize; ++intDescription) {
                ControlBlockDescription o_ControlBlockDescription = new ControlBlockDescription();
                o_ControlBlockDescription.readExternal(p_ObjectInput);
                this.addControlBlockDescription(o_ControlBlockDescription);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getDiskSpaceEstimated() {
            long longBytesCount = 0L;
            longBytesCount += 4L;
            longBytesCount += (long)(this.m_ListDescription.length() * 2);
            longBytesCount += 4L;
            Object object = this.m_SyncObjects;
            synchronized (object) {
                for (int intDescription = 0; intDescription < this.m_ControlBlockDescriptions.size(); ++intDescription) {
                    ControlBlockDescription o_ControlBlockDescription = this.m_ControlBlockDescriptions.get(intDescription);
                    longBytesCount += o_ControlBlockDescription.getDiskSpaceEstimated();
                }
            }
            return longBytesCount;
        }

        public String getListDecription() {
            return this.m_ListDescription;
        }

        public void setListDescription(String p_ListDescription) {
            if (p_ListDescription == null) {
                p_ListDescription = "";
            }
            String oldValue = this.m_ListDescription;
            this.m_ListDescription = p_ListDescription;
            this.m_PropertyChangeSupport.firePropertyChange(PROP_LISTDESCRIPTION, (Object)oldValue, (Object)this.m_ListDescription);
        }

        public ControlBlockList getCopy(ControlBlockModel p_ControlBlockModel) {
            ControlBlockList o_ControlBlockList = new ControlBlockList(p_ControlBlockModel);
            for (int intDescription = 0; intDescription < this.getControlBlockDescriptionSize(); ++intDescription) {
                ControlBlockDescription o_ControlBlockDescriptionSelf = this.getControlBlockDescription(intDescription);
                ControlBlockDescription o_ControlBlockDescriptionCopy = o_ControlBlockDescriptionSelf.getCopy();
                o_ControlBlockList.addControlBlockDescription(o_ControlBlockDescriptionCopy);
            }
            return o_ControlBlockList;
        }

        public int getByteCount() {
            if (this.m_ControBlockModel == null) {
                return 0;
            }
            return this.m_ControBlockModel.getByteCount();
        }

        public double getMinValue() {
            if (this.m_ControBlockModel == null) {
                return 0.0;
            }
            return this.m_ControBlockModel.getMinValue();
        }

        public double getMaxValue() {
            if (this.m_ControBlockModel == null) {
                return 0.0;
            }
            return this.m_ControBlockModel.getMaxValue();
        }

        public boolean getOnlyIntegerValues() {
            if (this.m_ControBlockModel == null) {
                return false;
            }
            return this.m_ControBlockModel.getOnlyIntegerValues();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearControlBlockDescriptions() {
            ArrayList<ControlBlockDescription> o_ControlBlockDescriptions;
            Object object = this.m_SyncObjects;
            synchronized (object) {
                o_ControlBlockDescriptions = new ArrayList<ControlBlockDescription>(this.m_ControlBlockDescriptions.size());
                o_ControlBlockDescriptions.addAll(this.m_ControlBlockDescriptions);
            }
            int intBlocksCount = o_ControlBlockDescriptions.size();
            for (int intBlock = intBlocksCount - 1; intBlock >= 0; --intBlock) {
                ControlBlockDescription o_ControlBlockDescription = (ControlBlockDescription)o_ControlBlockDescriptions.get(intBlock);
                this.removeControlBlockDescription(o_ControlBlockDescription);
            }
        }

        public ControlBlockDescription createControlBlockDescription(double p_ValueStart, double p_ValueEnd, Double p_ValueDefault, String p_Text) {
            return this.createControlBlockDescription(p_ValueStart, p_ValueEnd, p_ValueDefault, p_Text, null, null);
        }

        public ControlBlockDescription createControlBlockDescription(double p_ValueStart, double p_ValueEnd, Double p_ValueDefault, Image p_Image) {
            return this.createControlBlockDescription(p_ValueStart, p_ValueEnd, p_ValueDefault, null, p_Image, null);
        }

        public ControlBlockDescription createControBlockDescription(double p_ValueStart, double p_ValueEnd, Double p_ValueDefault, Color p_Color) {
            return this.createControlBlockDescription(p_ValueStart, p_ValueEnd, p_ValueDefault, null, null, p_Color);
        }

        public ControlBlockDescription createControlBlockDescription(double p_ValueStart, double p_ValueEnd, Double p_ValueDefault, String p_Text, Image p_Image, Color p_Color) {
            ControlBlockDescription o_ControlBlockDescription = new ControlBlockDescription(p_ValueStart, p_ValueEnd, p_ValueDefault, p_Text, p_Image, p_Color);
            this.addControlBlockDescription(o_ControlBlockDescription);
            return o_ControlBlockDescription;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addControlBlockDescription(ControlBlockDescription p_ControlBlockDescription) {
            int intIndex;
            if (p_ControlBlockDescription == null) {
                return;
            }
            Object object = this.m_SyncObjects;
            synchronized (object) {
                if (this.m_ControlBlockDescriptions.contains(p_ControlBlockDescription)) {
                    return;
                }
                this.m_ControlBlockDescriptions.add(p_ControlBlockDescription);
                intIndex = this.m_ControlBlockDescriptions.indexOf(p_ControlBlockDescription);
            }
            if (p_ControlBlockDescription.getControlBlockModel() != null) {
                p_ControlBlockDescription.getControlBlockModel().removeControlBlockDescription(p_ControlBlockDescription);
            }
            p_ControlBlockDescription.setControBlockList(this);
            this.calculateMinimalValueDistance();
            this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_BLOCKDESCRIPTION, intIndex, null, (Object)p_ControlBlockDescription);
            this.fireDataListDescriptionAdded(p_ControlBlockDescription);
            this.resortDescriptions(p_ControlBlockDescription);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeControlBlockDescription(ControlBlockDescription p_ControlBlockDescription) {
            int intIndex;
            if (p_ControlBlockDescription == null) {
                return;
            }
            Object object = this.m_SyncObjects;
            synchronized (object) {
                intIndex = this.m_ControlBlockDescriptions.indexOf(p_ControlBlockDescription);
                if (intIndex < 0) {
                    return;
                }
            }
            p_ControlBlockDescription.setControBlockList(null);
            this.removeControlBlockDescription(intIndex);
            p_ControlBlockDescription.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeControlBlockDescription(int p_Index) {
            ControlBlockDescription o_ControlBlockDescription;
            if (p_Index < 0) {
                return;
            }
            Object object = this.m_SyncObjects;
            synchronized (object) {
                if (this.m_ControlBlockDescriptions == null) {
                    return;
                }
                if (p_Index >= this.m_ControlBlockDescriptions.size()) {
                    return;
                }
                o_ControlBlockDescription = this.m_ControlBlockDescriptions.remove(p_Index);
            }
            if (o_ControlBlockDescription != null) {
                o_ControlBlockDescription.setControBlockList(null);
            }
            this.fireDataListDescriptionRemoved(p_Index);
            this.calculateMinimalValueDistance();
            this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_BLOCKDESCRIPTION, p_Index, (Object)o_ControlBlockDescription, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getSortIndex(ControlBlockDescription p_ControlBlockDescription) {
            int intIndex;
            Object object = this.m_SyncObjects;
            synchronized (object) {
                for (intIndex = 0; intIndex < this.m_ControlBlockDescriptions.size(); ++intIndex) {
                    ControlBlockDescription o_ControlBlockDescription = this.m_ControlBlockDescriptions.get(intIndex);
                    if (o_ControlBlockDescription == p_ControlBlockDescription || p_ControlBlockDescription.getValueDefault() < o_ControlBlockDescription.getValueDefault()) continue;
                    ++intIndex;
                    break;
                }
            }
            return --intIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resortDescriptions(ControlBlockDescription p_ControlBlockDescription) {
            int intIndexFound;
            if (p_ControlBlockDescription == null) {
                return;
            }
            if (this.m_ControlBlockDescriptions == null) {
                return;
            }
            Object object = this.m_SyncObjects;
            synchronized (object) {
                intIndexFound = this.m_ControlBlockDescriptions.indexOf(p_ControlBlockDescription);
            }
            int intSortIndex = this.getSortIndex(p_ControlBlockDescription);
            if (intIndexFound == intSortIndex) {
                return;
            }
            if (intIndexFound < intSortIndex) {
                --intSortIndex;
            }
            object = this.m_SyncObjects;
            synchronized (object) {
                this.m_ControlBlockDescriptions.remove(p_ControlBlockDescription);
                this.m_ControlBlockDescriptions.add(intSortIndex, p_ControlBlockDescription);
            }
            this.fireDataListDescriptionChanged(0, intSortIndex);
            this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_BLOCKDESCRIPTIONRESORTED, intSortIndex, null, (Object)p_ControlBlockDescription);
        }

        public int getControlBlockDescriptionSize() {
            return this.m_ControlBlockDescriptions.size();
        }

        public ArrayList<ControlBlockDescription> getControlBlockDescriptions() {
            return this.m_ControlBlockDescriptions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ControlBlockDescription getControlBlockDescription(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncObjects;
            synchronized (object) {
                if (p_Index >= this.m_ControlBlockDescriptions.size()) {
                    return null;
                }
                return this.m_ControlBlockDescriptions.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ControlBlockDescription getControlBlockDescriptionFromValue(double p_Value) {
            Object object = this.m_SyncObjects;
            synchronized (object) {
                for (int intBlock = 0; intBlock < this.m_ControlBlockDescriptions.size(); ++intBlock) {
                    ControlBlockDescription o_ControlBlockDescription = this.m_ControlBlockDescriptions.get(intBlock);
                    if (o_ControlBlockDescription.getValueStart() > p_Value || o_ControlBlockDescription.getValueEnd() < p_Value) continue;
                    return o_ControlBlockDescription;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isSameAs(ControlBlockList p_ControlBlockList) {
            Object object = this.m_SyncObjects;
            synchronized (object) {
                if (this.m_ControlBlockDescriptions.size() != p_ControlBlockList.getControlBlockDescriptionSize()) {
                    return false;
                }
                for (int intDescription = 0; intDescription < this.m_ControlBlockDescriptions.size(); ++intDescription) {
                    ControlBlockDescription o_ControlBlockDescription;
                    ControlBlockDescription o_ControlBlockDescriptionSelf = this.m_ControlBlockDescriptions.get(intDescription);
                    if (o_ControlBlockDescriptionSelf.isSameAs(o_ControlBlockDescription = p_ControlBlockList.getControlBlockDescription(intDescription))) continue;
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double calculateMinimalValueDistance() {
            double doubleDistance = 0.0;
            this.m_MinmalDistance = -1.0;
            Object object = this.m_SyncObjects;
            synchronized (object) {
                for (int intDescription = 1; intDescription < this.m_ControlBlockDescriptions.size(); ++intDescription) {
                    doubleDistance = this.m_ControlBlockDescriptions.get(intDescription).getValueStart() - this.m_ControlBlockDescriptions.get(intDescription - 1).getValueDefault();
                    if (doubleDistance < 0.0) {
                        doubleDistance = -doubleDistance;
                    }
                    if (intDescription == 1) {
                        this.m_MinmalDistance = doubleDistance;
                        continue;
                    }
                    if (!(this.m_MinmalDistance > doubleDistance)) continue;
                    this.m_MinmalDistance = doubleDistance;
                }
            }
            return this.m_MinmalDistance;
        }

        public double getMinimalDistance() {
            return this.m_MinmalDistance;
        }

        public void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
            this.m_PropertyChangeSupport.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
        }

        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }

        public void addPropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
        }

        public PropertyChangeListener[] getPropertyChangeListeners() {
            return this.m_PropertyChangeSupport.getPropertyChangeListeners();
        }

        public PropertyChangeListener[] getPropertyChangeListeners(String p_PropertyName) {
            return this.m_PropertyChangeSupport.getPropertyChangeListeners(p_PropertyName);
        }

        public boolean hasListeners(String p_PropertyName) {
            return this.m_PropertyChangeSupport.hasListeners(p_PropertyName);
        }

        @Override
        public int getSize() {
            return this.m_ControlBlockDescriptions.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ControlBlockDescription getElementAt(int index) {
            Object object = this.m_SyncObjects;
            synchronized (object) {
                if (index < 0 || index > this.m_ControlBlockDescriptions.size()) {
                    return null;
                }
                return this.m_ControlBlockDescriptions.get(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getIndexOf(ControlBlockDescription p_ControlBlockDescription) {
            if (p_ControlBlockDescription == null) {
                return -1;
            }
            Object object = this.m_SyncObjects;
            synchronized (object) {
                if (this.m_ControlBlockDescriptions == null) {
                    return -1;
                }
                return this.m_ControlBlockDescriptions.indexOf(p_ControlBlockDescription);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDataListDescriptionChanged(ControlBlockDescription p_ControlBlockDescription) {
            int intIndex;
            if (p_ControlBlockDescription == null) {
                return;
            }
            Object object = this.m_SyncListDataListeners;
            synchronized (object) {
                if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
                    return;
                }
                intIndex = this.m_ControlBlockDescriptions.indexOf(p_ControlBlockDescription);
            }
            this.fireDataListDescriptionChanged(intIndex, intIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDataListDescriptionChanged(int p_StartIndex, int p_EndIndex) {
            ArrayList<ListDataListener> o_ListDataListeners;
            if (this.m_ControlBlockDescriptions == null) {
                return;
            }
            if (p_StartIndex < 0 || p_StartIndex >= this.m_ControlBlockDescriptions.size()) {
                return;
            }
            if (p_EndIndex < 0 || p_EndIndex >= this.m_ControlBlockDescriptions.size()) {
                return;
            }
            Object object = this.m_SyncListDataListeners;
            synchronized (object) {
                o_ListDataListeners = new ArrayList<ListDataListener>(this.m_ArrayListDataListeners.size());
                o_ListDataListeners.addAll(this.m_ArrayListDataListeners);
            }
            ListDataEvent o_Event = new ListDataEvent(this, 0, p_StartIndex, p_EndIndex);
            for (int intDataListener = 0; intDataListener < o_ListDataListeners.size(); ++intDataListener) {
                ((ListDataListener)o_ListDataListeners.get(intDataListener)).contentsChanged(o_Event);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDataListDescriptionAdded(ControlBlockDescription p_ControlBlockDescription) {
            if (p_ControlBlockDescription == null) {
                return;
            }
            Object object = this.m_SyncObjects;
            synchronized (object) {
                if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
                    return;
                }
                int intIndex = this.m_ControlBlockDescriptions.indexOf(p_ControlBlockDescription);
            }
            this.fireDataListDescriptionAdded(this.m_ControlBlockDescriptions.indexOf(p_ControlBlockDescription));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDataListDescriptionAdded(int p_Index) {
            ArrayList<ListDataListener> o_ListDataListeners;
            if (p_Index < 0) {
                return;
            }
            Object object = this.m_SyncListDataListeners;
            synchronized (object) {
                if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
                    return;
                }
                o_ListDataListeners = new ArrayList<ListDataListener>(this.m_ArrayListDataListeners.size());
                o_ListDataListeners.addAll(this.m_ArrayListDataListeners);
            }
            ListDataEvent o_Event = new ListDataEvent(this, 1, p_Index, p_Index);
            for (int intDataListener = 0; intDataListener < o_ListDataListeners.size(); ++intDataListener) {
                ((ListDataListener)o_ListDataListeners.get(intDataListener)).intervalAdded(o_Event);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDataListDescriptionRemoved(int p_Index) {
            ArrayList<ListDataListener> o_ListDataListeners;
            if (p_Index < 0) {
                return;
            }
            Object object = this.m_SyncListDataListeners;
            synchronized (object) {
                if (this.m_ArrayListDataListeners == null || this.m_ArrayListDataListeners.size() <= 0) {
                    return;
                }
                o_ListDataListeners = new ArrayList<ListDataListener>(this.m_ArrayListDataListeners.size());
                o_ListDataListeners.addAll(this.m_ArrayListDataListeners);
            }
            ListDataEvent o_Event = new ListDataEvent(this, 2, p_Index, p_Index);
            for (int intDataListener = 0; intDataListener < o_ListDataListeners.size(); ++intDataListener) {
                ((ListDataListener)o_ListDataListeners.get(intDataListener)).intervalRemoved(o_Event);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListDataListener(ListDataListener p_DataListener) {
            if (p_DataListener == null) {
                return;
            }
            Object object = this.m_SyncListDataListeners;
            synchronized (object) {
                if (this.m_ArrayListDataListeners == null) {
                    return;
                }
                if (this.m_ArrayListDataListeners.contains(p_DataListener)) {
                    return;
                }
                this.m_ArrayListDataListeners.add(p_DataListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListDataListener(ListDataListener p_DataListener) {
            if (p_DataListener == null) {
                return;
            }
            Object object = this.m_SyncListDataListeners;
            synchronized (object) {
                if (this.m_ArrayListDataListeners == null) {
                    return;
                }
                this.m_ArrayListDataListeners.remove(p_DataListener);
            }
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (!(anItem instanceof ControlBlockDescription)) {
                return;
            }
            this.m_SelectedControlBlockDescription = (ControlBlockDescription)anItem;
        }

        @Override
        public Object getSelectedItem() {
            return this.m_SelectedControlBlockDescription;
        }
    }
}

