/*
 * Decompiled with CFR 0.152.
 */
package SPITToolsPackage;

import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_TypeDescription;
import SPITServerPackage.SPITServer_Client;
import SPITServerPackage.SPIT_Type;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.JLabel_RightClickToolTip;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Method;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class SPITTypeConflictModel
extends TableAndListModel<Conflict> {
    public static final int COLUMNCOUNT = 2;
    public static final int COLUMNINDEX_SERVER = 0;
    public static final int COLUMNINDEX_CLIENT = 1;
    public static String COLUMN_SERVERNAME = "LiveShow";
    public static String COLUMN_CLIENTNAME = "Client";
    private TableRowSorter m_TableRowSorter;
    private SPITRowFilter m_SPITRowFilter;
    private final Object m_SyncObject = new Object();

    public SPITTypeConflictModel() {
        super(false);
        this.initMembers();
    }

    private void initMembers() {
        this.m_TableRowSorter = new TableRowSorter<SPITTypeConflictModel>(this);
    }

    public void finishJTable(JTable p_JTable) {
        SPITTypeConflictRenderer o_TableCellEditorRenderer_String;
        if (p_JTable == null) {
            return;
        }
        this.m_TableRowSorter.setComparator(0, TableAndListModel.getStringComparator_Normal());
        this.m_TableRowSorter.setComparator(1, TableAndListModel.getStringComparator_Normal());
        this.m_SPITRowFilter = new SPITRowFilter(this);
        super.finishJTable(p_JTable, this.m_TableRowSorter, this.m_SPITRowFilter);
        TableColumnModel o_TableColumnModel = p_JTable.getColumnModel();
        TableColumn o_TableColumn = o_TableColumnModel.getColumn(0);
        if (o_TableColumn != null) {
            o_TableCellEditorRenderer_String = new SPITTypeConflictRenderer();
            o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
            o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(1)) != null) {
            o_TableCellEditorRenderer_String = new SPITTypeConflictRenderer();
            o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
            o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
        }
        p_JTable.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            super.clear();
        }
    }

    public static String getObjectName(Object p_Object) {
        String stringName;
        if (p_Object == null) {
            return null;
        }
        try {
            Method o_Method = p_Object.getClass().getMethod("getName", new Class[0]);
            if (o_Method == null) {
                return null;
            }
            stringName = (String)o_Method.invoke(p_Object, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
        return stringName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConflict(String p_ClientID, SPIT_TypeDescription p_Description_Server, SPIT_TypeDescription p_Description_Client) {
        Conflict o_Conflict;
        if (p_ClientID == null) {
            return false;
        }
        if (p_Description_Server == null && p_Description_Client == null) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            int intFoundIndex = this.findConflictIndex(p_ClientID, p_Description_Server, p_Description_Client);
            if (intFoundIndex >= 0 && (o_Conflict = (Conflict)this.get(intFoundIndex)) != null) {
                o_Conflict.setServerTypeDescription(p_Description_Server);
                o_Conflict.setClientTypeDescription(p_Description_Client);
                o_Conflict.setClientID(p_ClientID);
                return false;
            }
        }
        object = this.m_SyncObject;
        synchronized (object) {
            o_Conflict = new Conflict(p_Description_Server, p_Description_Client, p_ClientID);
            this.add(o_Conflict);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConflict(String p_ClientID, String p_SPIT_TypeID, boolean p_ClientSide) {
        if (p_SPIT_TypeID == null) {
            return false;
        }
        boolean boolFound = false;
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_ClientSide) {
                for (int intIndex = this.size() - 1; intIndex >= 0; --intIndex) {
                    SPIT_TypeDescription o_TypeDescription;
                    Conflict o_Conflict = (Conflict)this.get(intIndex);
                    if (o_Conflict == null || (o_TypeDescription = o_Conflict.getClientTypeDescription()) == null || !p_SPIT_TypeID.equals(o_TypeDescription.getID()) || p_ClientID != null && !p_ClientID.equals(o_Conflict.getClientID())) continue;
                    this.remove(o_Conflict);
                    boolFound = true;
                }
            } else {
                for (int intIndex = this.size() - 1; intIndex >= 0; --intIndex) {
                    SPIT_TypeDescription o_TypeDescription;
                    Conflict o_Conflict = (Conflict)this.get(intIndex);
                    if (o_Conflict == null || (o_TypeDescription = o_Conflict.getServerTypeDescription()) == null || !p_SPIT_TypeID.equals(o_TypeDescription.getID())) continue;
                    this.remove(o_Conflict);
                    boolFound = true;
                }
            }
        }
        if (boolFound) {
            // empty if block
        }
        return boolFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConflict(String p_ClientID) {
        if (p_ClientID == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intIndex = this.size() - 1; intIndex >= 0; --intIndex) {
                Conflict o_Conflict = (Conflict)this.get(intIndex);
                if (o_Conflict == null || !p_ClientID.equals(o_Conflict.getClientID())) continue;
                this.remove(o_Conflict);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findConflictIndex(String p_ClientID, SPIT_TypeDescription p_Description_Server, SPIT_TypeDescription p_Description_Client) {
        if (p_ClientID == null) {
            return -1;
        }
        if (p_Description_Server == null && p_Description_Client == null) {
            return -1;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intIndex = 0; intIndex < this.size(); ++intIndex) {
                SPIT_TypeDescription o_TypeDescription;
                Conflict o_Conflict = (Conflict)this.get(intIndex);
                if (o_Conflict == null || !p_ClientID.equals(o_Conflict.getClientID())) continue;
                if (p_Description_Server != null && (o_TypeDescription = o_Conflict.getServerTypeDescription()) != null && p_Description_Server.getID().equals(o_TypeDescription.getID())) {
                    return intIndex;
                }
                if (p_Description_Client == null || (o_TypeDescription = o_Conflict.getClientTypeDescription()) == null || !p_Description_Client.getID().equals(o_TypeDescription.getID())) continue;
                return intIndex;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPIT_TypeDescription getTypeDescription_Server(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Index >= this.size()) {
                return null;
            }
            Conflict o_Conflict = (Conflict)this.get(p_Index);
            if (o_Conflict == null) {
                return null;
            }
            return o_Conflict.getServerTypeDescription();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPIT_TypeDescription getTypeDescription_Server(String p_SPIT_TypeID, String p_ClientID) {
        if (p_SPIT_TypeID == null) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intIndex = 0; intIndex < this.size(); ++intIndex) {
                SPIT_TypeDescription o_Description;
                Conflict o_Conflict = (Conflict)this.get(intIndex);
                if (o_Conflict == null || (o_Description = o_Conflict.getServerTypeDescription()) == null || !p_SPIT_TypeID.equals(o_Description.getID())) continue;
                if (p_ClientID == null) {
                    return o_Description;
                }
                if (!p_ClientID.equals(o_Conflict.getClientID())) continue;
                return o_Description;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPIT_TypeDescription getTypeDescription_Client(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Index >= this.size()) {
                return null;
            }
            Conflict o_Conflict = (Conflict)this.get(p_Index);
            if (o_Conflict == null) {
                return null;
            }
            return o_Conflict.getClientTypeDescription();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPIT_TypeDescription getTypeDescription_Client(String p_SPIT_TypeID, String p_ClientID) {
        if (p_SPIT_TypeID == null) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intIndex = 0; intIndex < this.size(); ++intIndex) {
                SPIT_TypeDescription o_Description;
                Conflict o_Conflict = (Conflict)this.get(intIndex);
                if (o_Conflict == null || (o_Description = o_Conflict.getClientTypeDescription()) == null || !p_SPIT_TypeID.equals(o_Description.getID())) continue;
                if (p_ClientID == null) {
                    return o_Description;
                }
                if (!p_ClientID.equals(o_Conflict.getClientID())) continue;
                return o_Description;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientID(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Index >= this.size()) {
                return null;
            }
            Conflict o_Conflict = (Conflict)this.get(p_Index);
            if (o_Conflict == null) {
                return null;
            }
            return o_Conflict.getClientID();
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return COLUMN_SERVERNAME;
            }
            case 1: {
                return COLUMN_CLIENTNAME;
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(Conflict p_Conflict, int columnIndex) {
        if (p_Conflict == null) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            switch (columnIndex) {
                case 0: {
                    return p_Conflict.getServerTypeDescription();
                }
                case 1: {
                    return p_Conflict.getClientTypeDescription();
                }
            }
            return null;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValue(Conflict p_Conflict, Object p_Value, int p_Column) {
    }

    public void filter(String p_FilterString) {
        if (this.m_SPITRowFilter == null) {
            return;
        }
        this.m_SPITRowFilter.setFilterString(p_FilterString);
    }

    public static class SPITTypeConflictRenderer
    extends TableAndListModel.TableCellEditorRenderer_String {
        public static Color s_ColorWarning = new Color(255, 200, 200);

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            SPIT_ClientInterface o_SPITServer_Client;
            JLabel_RightClickToolTip o_JLabel = (JLabel_RightClickToolTip)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            o_JLabel.setForeground(s_ColorWarning);
            try {
                int intRowModel = table.convertRowIndexToModel(row);
                o_SPITServer_Client = SPITServer_Client.getSPIT_ClientInterface(SPIT_Type.s_SPITTypeConflictModel.getClientID(intRowModel));
            }
            catch (Exception e) {
                o_SPITServer_Client = null;
            }
            SPIT_TypeDescription o_TypeDescription = (SPIT_TypeDescription)value;
            try {
                if (table.convertColumnIndexToModel(column) == 0) {
                    this.setIcon(null);
                } else {
                    this.setIcon(null);
                }
            }
            catch (Exception e) {
                this.setIcon(null);
            }
            if (o_TypeDescription == null) {
                o_JLabel.setText("");
                o_JLabel.setToolTipText(null);
            } else {
                StringBuilder o_StringBuilder = new StringBuilder();
                o_StringBuilder.append(o_TypeDescription.getName());
                try {
                    if (table.convertColumnIndexToModel(column) == 1 && o_SPITServer_Client != null) {
                        o_StringBuilder.append(" (");
                        o_StringBuilder.append(o_SPITServer_Client.getClientComputerName());
                        o_StringBuilder.append(" ");
                        o_StringBuilder.append(o_SPITServer_Client.getClientProjectName());
                        o_StringBuilder.append(")");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                o_JLabel.setText(o_StringBuilder.toString());
                if (o_SPITServer_Client != null) {
                    o_StringBuilder.delete(0, o_StringBuilder.length());
                    o_StringBuilder.append(o_SPITServer_Client.getClientComputerName());
                    o_StringBuilder.append(" ");
                    o_StringBuilder.append(o_SPITServer_Client.getName());
                    o_StringBuilder.append(" (");
                    o_StringBuilder.append(o_SPITServer_Client.getIPAddress());
                    o_StringBuilder.append(" ");
                    o_StringBuilder.append(String.valueOf(o_SPITServer_Client.getPort()));
                    o_StringBuilder.append(" )");
                    o_JLabel.setToolTipText(o_StringBuilder.toString());
                    o_JLabel.setToolTipText_RightClick(o_StringBuilder.toString());
                } else {
                    o_JLabel.setToolTipText(null);
                    o_JLabel.setToolTipText_RightClick(null);
                }
            }
            return o_JLabel;
        }
    }

    public static class SPITRowFilter
    extends RowFilter<SPIT_TypeDescription, Integer> {
        private SPITTypeConflictModel m_SPITTypeConflictModel;
        private String m_FilterString;

        public SPITRowFilter(SPITTypeConflictModel p_SPITTypeConflictModel) {
            this.initMembers();
            this.m_SPITTypeConflictModel = p_SPITTypeConflictModel;
        }

        private void initMembers() {
            this.m_FilterString = null;
        }

        public void setFilterString(String p_FilterString) {
            this.m_FilterString = p_FilterString == null ? "" : p_FilterString.toLowerCase();
            if (this.m_SPITTypeConflictModel != null) {
                this.m_SPITTypeConflictModel.fireTableDataChanged();
            }
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            SPIT_ClientInterface o_SPIT_ClientInterface;
            if (this.m_SPITTypeConflictModel == null) {
                return false;
            }
            if (this.m_FilterString == null) {
                return true;
            }
            if (this.m_FilterString.length() <= 0) {
                return true;
            }
            int intRow = (Integer)entry.getIdentifier();
            SPIT_TypeDescription o_SPIT_TypeDescription = this.m_SPITTypeConflictModel.getTypeDescription_Client(intRow);
            if (o_SPIT_TypeDescription != null) {
                if (o_SPIT_TypeDescription.getName().toLowerCase().contains(this.m_FilterString)) {
                    return true;
                }
                if (o_SPIT_TypeDescription.getGroupName().toLowerCase().contains(this.m_FilterString)) {
                    return true;
                }
            }
            if ((o_SPIT_TypeDescription = this.m_SPITTypeConflictModel.getTypeDescription_Server(intRow)) != null) {
                if (o_SPIT_TypeDescription.getName().toLowerCase().contains(this.m_FilterString)) {
                    return true;
                }
                if (o_SPIT_TypeDescription.getGroupName().toLowerCase().contains(this.m_FilterString)) {
                    return true;
                }
            }
            if ((o_SPIT_ClientInterface = SPITServer_Client.getSPIT_ClientInterface(this.m_SPITTypeConflictModel.getClientID(intRow))) != null) {
                if (o_SPIT_ClientInterface.getClientProjectName().toLowerCase().contains(this.m_FilterString)) {
                    return true;
                }
                if (o_SPIT_ClientInterface.getClientComputerName().toLowerCase().contains(this.m_FilterString)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class Conflict {
        private SPIT_TypeDescription m_ClientTypeDescription;
        private SPIT_TypeDescription m_ServerTypeDescription;
        private String m_ClientID;

        public Conflict(SPIT_TypeDescription p_ServerTypeDescription, SPIT_TypeDescription p_ClientTypeDescription, String p_ClientID) {
            this.m_ServerTypeDescription = p_ServerTypeDescription;
            this.m_ClientTypeDescription = p_ClientTypeDescription;
            this.m_ClientID = p_ClientID;
        }

        public void setServerTypeDescription(SPIT_TypeDescription p_ServerTypeDescription) {
            this.m_ServerTypeDescription = p_ServerTypeDescription;
        }

        public SPIT_TypeDescription getServerTypeDescription() {
            return this.m_ServerTypeDescription;
        }

        public void setClientTypeDescription(SPIT_TypeDescription p_ClientTypeDescription) {
            this.m_ClientTypeDescription = p_ClientTypeDescription;
        }

        public SPIT_TypeDescription getClientTypeDescription() {
            return this.m_ClientTypeDescription;
        }

        public void setClientID(String p_ClientID) {
            this.m_ClientID = p_ClientID;
        }

        public String getClientID() {
            return this.m_ClientID;
        }
    }
}

