/*
 * Decompiled with CFR 0.152.
 */
package SPITServerPackage;

import GUID.LiveGUID;
import LiveShowObjectPackage.LiveShowObjectInterface;
import MediaVirtualPackage.LiveShowMediaVIP;
import PlayMediaPackage.PlayMedia;
import SPITActionPackage.SPIT_ActionPlayer;
import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_Message;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITLibraryPackage.SPIT_Watchdog;
import SPITModelPackage.SPITClientTableModel;
import SPITRemotePackage.SPITRemote;
import SPITServerPackage.LiveShowSPITObject;
import SPITServerPackage.SPITServer;
import SPITServerPackage.SPIT_Type;
import SPITToolsPackage.SinglePropertyChangeSupport;
import StartPackage.LiveShowMediaSystem;
import TimerPackage.JavaTimer;
import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.util.ArrayList;

public class SPITServer_Client
implements SPIT_ClientInterface {
    public static SPITClientTableModel s_SPITClientTableModel = new SPITClientTableModel();
    private static final Object s_SyncObject = new Object();
    public static final String PROP_CLIENTPROJECTNAME = "clientProjectName";
    public static final String PROP_CLIENTSPITPROJECTCLOSED = "clientClosed";
    private InetAddress m_InetAddress;
    private int m_Port;
    private int m_MessageNumber_Send;
    private int m_MessageNumber_Received;
    private final Object m_SyncMessageNumber = new Object();
    private String m_ID;
    private String m_Name;
    private String m_ClientComputerName;
    private String m_ClientSPITProjectID;
    private String m_ClientSPITProjectName;
    private ArrayList<SPIT_Message> m_OvertakingSPIT_Messages;
    private String m_ServerIP;
    private int m_ServerPort;
    private boolean m_TransferringProject;
    private SPIT_Watchdog m_SPIT_Watchdog;
    private JavaTimer m_JavaTimer;
    private boolean m_Closed;
    private SinglePropertyChangeSupport m_SinglePropertyChangeSupport;
    public static int s_MAX_OVERTAKING_SPIT_MESSAGES = 10;

    public static int getSPITClientsCount() {
        return s_SPITClientTableModel.size();
    }

    public SPITServer_Client(String p_ID, String p_ClientComputerName, String p_Name, InetAddress p_InetAddress, int p_Port, String p_ServerIP, int p_ServerPort) {
        this.initMembers();
        this.m_ID = p_ID;
        this.m_ClientComputerName = p_ClientComputerName;
        this.m_Name = p_Name;
        this.m_InetAddress = p_InetAddress;
        this.m_Port = p_Port;
        this.m_ServerIP = p_ServerIP;
        this.m_ServerPort = p_ServerPort;
    }

    private void initMembers() {
        this.m_Closed = false;
        this.m_ID = LiveGUID.getGUID();
        this.m_InetAddress = null;
        this.m_Name = "";
        this.m_ClientComputerName = "";
        this.m_ClientSPITProjectID = "";
        this.m_ClientSPITProjectName = "";
        this.m_SinglePropertyChangeSupport = new SinglePropertyChangeSupport(this);
        this.m_SPIT_Watchdog = new SPIT_Watchdog((SPIT_ClientInterface)this);
        this.m_OvertakingSPIT_Messages = new ArrayList();
        this.m_TransferringProject = false;
        this.m_MessageNumber_Send = 1;
        this.m_MessageNumber_Received = -1;
        this.m_JavaTimer = new JavaTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.m_Closed) {
            return;
        }
        this.m_Closed = true;
        this.m_SPIT_Watchdog.close();
        SPIT_Type.parseCloseProject_Client(this);
        LiveShowSPITObject.parseCloseProject_Client(this);
        Object object = s_SyncObject;
        synchronized (object) {
            boolean boolRemoved = s_SPITClientTableModel.removeSPIT_ClientInterface((SPIT_ClientInterface)this);
        }
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_CLIENTSPITPROJECTCLOSED, this, null);
        this.m_TransferringProject = false;
        SPIT_Message o_SPIT_Message = SPIT_Message.createDisconnect();
        this.sendSPIT_Message(o_SPIT_Message);
        System.out.println("SPITServer_Client DISCONNECT Address: " + this.m_InetAddress);
    }

    public String getID() {
        return this.m_ID;
    }

    public String getServerID() {
        return SPITServer.s_ServerID;
    }

    public String getName() {
        return this.m_Name;
    }

    public String getClientComputerName() {
        return this.m_ClientComputerName;
    }

    public String getServerIP() {
        return this.m_ServerIP;
    }

    public int getServerPort() {
        return this.m_ServerPort;
    }

    public String getServerComputerName() {
        return SPITServer.s_ServerComputerName;
    }

    public String getServerName() {
        return SPITServer.s_ServerName;
    }

    public void setServerProjectName(String p_ServerProjectName) {
    }

    public String getServerProjectName() {
        return LiveShowMediaSystem.getLiveShowProjectDescription().getProjectName();
    }

    public int getServerStepTime() {
        return PlayMedia.BUFFER_MILLISECONDS;
    }

    public int getServerFramesPerSecond() {
        return SPITServer.getFramesPerSecond();
    }

    public void setClientProjectID(String p_ClientProjectID) {
        if (p_ClientProjectID == null) {
            p_ClientProjectID = "";
        }
        if (p_ClientProjectID.equals(this.m_ClientSPITProjectID)) {
            return;
        }
        this.m_ClientSPITProjectID = p_ClientProjectID;
    }

    public String getClientProjectID() {
        return this.m_ClientSPITProjectID;
    }

    public void setClientProjectName(String p_ClientProjectName) {
        if (p_ClientProjectName == null) {
            return;
        }
        if (this.m_ClientSPITProjectName.equals(p_ClientProjectName)) {
            return;
        }
        String oldValue = this.m_ClientSPITProjectName;
        this.m_ClientSPITProjectName = p_ClientProjectName;
        this.firePropertyChange(PROP_CLIENTPROJECTNAME, oldValue, this.m_ClientSPITProjectName);
    }

    public String getClientProjectName() {
        return this.m_ClientSPITProjectName;
    }

    public InetAddress getInetAddress() {
        return this.m_InetAddress;
    }

    public String getIPAddress() {
        InetAddress o_InetAddress = this.m_InetAddress;
        if (o_InetAddress == null) {
            return "";
        }
        return o_InetAddress.getHostAddress();
    }

    public int getPort() {
        return this.m_Port;
    }

    public int getMessageNumberSend() {
        return this.m_MessageNumber_Send;
    }

    public void setMessageNumberSend(int p_MessageNumber) {
        if (p_MessageNumber == 0) {
            return;
        }
        this.m_MessageNumber_Send = p_MessageNumber > 255 || p_MessageNumber < 1 ? 1 : p_MessageNumber;
    }

    public void resetMessageNumberReceived() {
        this.m_MessageNumber_Received = -1;
        this.m_OvertakingSPIT_Messages.clear();
    }

    public int getMessageNumberReceived() {
        return this.m_MessageNumber_Received;
    }

    public void setMessageNumberReceived(int p_MessageNumber) {
        if (p_MessageNumber == 0) {
            return;
        }
        this.m_MessageNumber_Received = p_MessageNumber > 255 || p_MessageNumber < 1 ? 1 : p_MessageNumber;
    }

    public boolean checkParseSPIT_Message(SPIT_Message p_SPIT_Message) {
        if (p_SPIT_Message == null) {
            return false;
        }
        if (this.m_Closed) {
            return false;
        }
        SPIT_Message.Header o_Header = p_SPIT_Message.getHeader();
        SPIT_Message.OPPart o_OPPart = p_SPIT_Message.getOPPart();
        if (o_Header == null || o_OPPart == null) {
            System.out.println("SPITServer_Client parseSPIT_Message Header or OPPart wrong");
            return false;
        }
        int intActualMessageNumber = p_SPIT_Message.getMessageNumber();
        if (intActualMessageNumber == 0) {
            return this.parseSPIT_Message(p_SPIT_Message);
        }
        if (this.m_MessageNumber_Received < 0) {
            this.setMessageNumberReceived(intActualMessageNumber);
            return this.parseSPIT_Message(p_SPIT_Message);
        }
        int intNextMessageNumber = this.m_MessageNumber_Received + 1;
        if (intNextMessageNumber > 255 || intNextMessageNumber < 1) {
            intNextMessageNumber = 1;
        }
        if (intActualMessageNumber == intNextMessageNumber) {
            boolean boolParsed = true;
            this.setMessageNumberReceived(intActualMessageNumber);
            if (!this.parseSPIT_Message(p_SPIT_Message)) {
                boolParsed = false;
            }
            while (this.m_OvertakingSPIT_Messages.size() > 0) {
                SPIT_Message o_OvertakingSPIT_Message;
                int intOvertakingMessageNumber;
                intNextMessageNumber = this.m_MessageNumber_Received + 1;
                if (intNextMessageNumber > 255 || intNextMessageNumber < 1) {
                    intNextMessageNumber = 1;
                }
                if ((intOvertakingMessageNumber = (o_OvertakingSPIT_Message = this.m_OvertakingSPIT_Messages.get(0)).getMessageNumber()) != intNextMessageNumber) break;
                System.out.println("        SPITServer_Client checkParseSPIT_Message SPIT_Message parse overtaking message: " + intOvertakingMessageNumber + "   OPFlag: " + o_OvertakingSPIT_Message.getOPFlag());
                this.setMessageNumberReceived(intOvertakingMessageNumber);
                if (!this.parseSPIT_Message(o_OvertakingSPIT_Message)) {
                    boolParsed = false;
                }
                this.m_OvertakingSPIT_Messages.remove(0);
            }
            return boolParsed;
        }
        System.out.println("SPITServer_Client Client: " + this.m_ClientComputerName + " checkParseSPIT_Message SPIT_Message " + intActualMessageNumber + " has overtaken " + intNextMessageNumber);
        if (this.addOvertakingSPIT_Message(p_SPIT_Message)) {
            return true;
        }
        this.close();
        return false;
    }

    private boolean addOvertakingSPIT_Message(SPIT_Message p_SPIT_Message) {
        if (p_SPIT_Message == null) {
            return true;
        }
        boolean boolAdded = true;
        if (this.m_OvertakingSPIT_Messages.size() >= s_MAX_OVERTAKING_SPIT_MESSAGES) {
            boolAdded = false;
            System.err.println("SPITServer_Client --------------------------------------------- SPITMessage overtaking more than " + s_MAX_OVERTAKING_SPIT_MESSAGES + " messages");
            return false;
        }
        byte intMessageNumber = p_SPIT_Message.getHeader().getMessageNumber();
        for (int intMessage = 0; intMessage < this.m_OvertakingSPIT_Messages.size(); ++intMessage) {
            SPIT_Message o_OvertakingSPIT_Message = this.m_OvertakingSPIT_Messages.get(intMessage);
            byte intOvertakingMessageNumber = o_OvertakingSPIT_Message.getHeader().getMessageNumber();
            if (intMessageNumber >= intOvertakingMessageNumber) continue;
            this.m_OvertakingSPIT_Messages.add(intMessage, p_SPIT_Message);
            return boolAdded;
        }
        this.m_OvertakingSPIT_Messages.add(p_SPIT_Message);
        return boolAdded;
    }

    public boolean parseSPIT_Message(SPIT_Message p_SPIT_Message) {
        if (p_SPIT_Message == null) {
            return false;
        }
        boolean boolOK = false;
        SPIT_Message.Header o_Header = p_SPIT_Message.getHeader();
        SPIT_Message.OPPart o_OPPart = p_SPIT_Message.getOPPart();
        if (o_Header == null || o_OPPart == null) {
            return false;
        }
        if (o_OPPart instanceof SPIT_Message.Disconnect) {
            boolOK = this.parseDisconnect((SPIT_Message.Disconnect)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.Watchdog) {
            boolOK = this.parseWatchdog((SPIT_Message.Watchdog)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.WatchdogAnswer) {
            boolOK = this.parseWatchdogAnswer((SPIT_Message.WatchdogAnswer)o_OPPart);
        }
        if (o_OPPart instanceof SPIT_Message.ReportSPITProject) {
            boolOK = this.parseReportSPITProject((SPIT_Message.ReportSPITProject)o_OPPart);
        }
        if (o_OPPart instanceof SPIT_Message.CloseSPITProject) {
            boolOK = this.parseCloseSPITProject((SPIT_Message.CloseSPITProject)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.RequestProjectTransfer) {
            boolOK = this.parseRequestProjectTransfer((SPIT_Message.RequestProjectTransfer)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.StartProjectTransfer) {
            boolOK = this.parseStartProjectTransfer((SPIT_Message.StartProjectTransfer)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.EndProjectTransfer) {
            boolOK = this.parseEndProjectTransfer((SPIT_Message.EndProjectTransfer)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.ReportSPITType) {
            boolOK = this.parseReportSPITType((SPIT_Message.ReportSPITType)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.RemoveSPITType) {
            boolOK = this.parseRemoveSPITType((SPIT_Message.RemoveSPITType)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.ReportSPITObject) {
            boolOK = this.parseReportSPITObject((SPIT_Message.ReportSPITObject)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.RemoveSPITObject) {
            boolOK = this.parseRemoveSPITObject((SPIT_Message.RemoveSPITObject)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.PlaySPITStart) {
            boolOK = this.parsePlaySPITStart_Remote((SPIT_Message.PlaySPITStart)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.PlaySPITObject) {
            boolOK = this.parsePlaySPITObject_Remote((SPIT_Message.PlaySPITObject)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.PlaySPITEnd) {
            boolOK = this.parsePlaySPITEnd_Remote((SPIT_Message.PlaySPITEnd)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.ReportPlayStatus) {
            boolOK = this.parseReportPlayStatus((SPIT_Message.ReportPlayStatus)o_OPPart);
        }
        SPIT_Message.addEmpty((SPIT_Message)p_SPIT_Message);
        return boolOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendSPIT_Message_ForAllClients(SPIT_Message p_SPIT_Message) {
        boolean boolSended;
        if (p_SPIT_Message == null) {
            return false;
        }
        Object object = this.m_SyncMessageNumber;
        synchronized (object) {
            p_SPIT_Message.getHeader().setServerID(SPITServer.s_ServerID);
            p_SPIT_Message.getHeader().setClientID(this.m_ID);
            p_SPIT_Message.getHeader().setMessageNumber((byte)this.m_MessageNumber_Send);
            this.m_MessageNumber_Send = this.m_MessageNumber_Send == 255 ? 1 : ++this.m_MessageNumber_Send;
            boolSended = SPITServer.sendSPIT_Message(p_SPIT_Message, this.m_InetAddress, this.m_Port);
        }
        return boolSended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendSPIT_Message(SPIT_Message p_SPIT_Message) {
        boolean boolSended;
        if (p_SPIT_Message == null) {
            return false;
        }
        Object object = this.m_SyncMessageNumber;
        synchronized (object) {
            p_SPIT_Message.getHeader().setServerID(SPITServer.s_ServerID);
            p_SPIT_Message.getHeader().setClientID(this.m_ID);
            p_SPIT_Message.getHeader().setMessageNumber((byte)this.m_MessageNumber_Send);
            this.m_MessageNumber_Send = this.m_MessageNumber_Send == 255 ? 1 : ++this.m_MessageNumber_Send;
            boolSended = SPITServer.sendSPIT_Message(p_SPIT_Message, this.m_InetAddress, this.m_Port);
            SPIT_Message.addEmpty((SPIT_Message)p_SPIT_Message);
        }
        return boolSended;
    }

    public boolean parseDisconnect(SPIT_Message.Disconnect p_Disconnect) {
        if (p_Disconnect == null) {
            return false;
        }
        this.close();
        return true;
    }

    private boolean parseWatchdog(SPIT_Message.Watchdog p_Watchdog) {
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        SPIT_Message o_SPIT_Message = SPIT_Message.createWatchdogAnswer();
        this.sendSPIT_Message(o_SPIT_Message);
        return true;
    }

    public void startWatchdog() {
        if (this.m_SPIT_Watchdog != null) {
            this.m_SPIT_Watchdog.startWatchdog();
        }
    }

    public void stopWatchdog() {
        if (this.m_SPIT_Watchdog != null) {
            this.m_SPIT_Watchdog.stopWatchdog();
        }
    }

    private boolean parseWatchdogAnswer(SPIT_Message.WatchdogAnswer p_WatchdogAnswer) {
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        return true;
    }

    public void watchdogMissed() {
        System.out.println("SPITServer_Client " + this.getClientComputerName() + "Watchdog missed -> disconnect");
        this.close();
    }

    private boolean parseReportSPITProject(SPIT_Message.ReportSPITProject p_OPPart) {
        if (p_OPPart == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        this.setClientProjectName(p_OPPart.getProjectName());
        SPIT_Message o_SPIT_Message = SPIT_Message.createRequestProjectTransfer();
        this.sendSPIT_Message(o_SPIT_Message);
        return true;
    }

    public boolean parseCloseSPITProject(SPIT_Message.CloseSPITProject p_CloseSPITProject) {
        if (p_CloseSPITProject == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        this.setClientProjectName("");
        SPIT_Type.parseCloseProject_Client(this);
        LiveShowSPITObject.parseCloseProject_Client(this);
        return true;
    }

    private boolean parseRequestProjectTransfer(SPIT_Message.RequestProjectTransfer p_Request) {
        if (p_Request == null) {
            return false;
        }
        final SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        Runnable o_Runnable_ProjectTransfer = new Runnable(){

            @Override
            public void run() {
                SPIT_Object_Interface o_SPIT_Object_Interface;
                LiveShowObjectInterface o_LiveShowObjectInterface;
                int intObject;
                SPIT_Type_Interface o_SPIT_Type_Interface;
                int intSPITType;
                SPIT_Message o_SPIT_Message = SPIT_Message.createStartProjectTransfer();
                if (!SPITServer_Client.this.sendSPIT_Message(o_SPIT_Message)) {
                    return;
                }
                int intCount = SPIT_Type.getSPIT_TypeCount();
                for (intSPITType = 0; intSPITType < intCount; ++intSPITType) {
                    o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(intSPITType);
                    if (o_SPIT_Type_Interface == null) continue;
                    o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)o_SPIT_Type_Interface);
                    if (!SPITServer_Client.this.sendSPIT_Message(o_SPIT_Message)) {
                        return;
                    }
                    if (o_SPIT_Watchdog != null) {
                        o_SPIT_Watchdog.eventWatchdogAnswer();
                    }
                    SPITServer_Client.this.sleepSend();
                }
                LiveShowMediaVIP o_LiveShowMediaVIP = LiveShowMediaSystem.getLiveShowMediaVIP();
                if (o_LiveShowMediaVIP != null) {
                    intCount = o_LiveShowMediaVIP.getLiveShowObjectInterfaceCount();
                    for (intObject = 0; intObject < intCount; ++intObject) {
                        o_LiveShowObjectInterface = o_LiveShowMediaVIP.getLiveShowObjectInterface(intObject);
                        if (o_LiveShowObjectInterface == null || !(o_LiveShowObjectInterface instanceof SPIT_Object_Interface)) continue;
                        o_SPIT_Object_Interface = (SPIT_Object_Interface)o_LiveShowObjectInterface;
                        o_SPIT_Message = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)o_SPIT_Object_Interface);
                        if (!SPITServer_Client.this.sendSPIT_Message(o_SPIT_Message)) {
                            return;
                        }
                        if (o_SPIT_Watchdog != null) {
                            o_SPIT_Watchdog.eventWatchdogAnswer();
                        }
                        SPITServer_Client.this.sleepSend();
                    }
                }
                intCount = LiveShowMediaSystem.getJingleObjectCount();
                for (intObject = 0; intObject < intCount; ++intObject) {
                    o_LiveShowObjectInterface = LiveShowMediaSystem.getJingleObject(intObject);
                    if (o_LiveShowObjectInterface == null || !(o_LiveShowObjectInterface instanceof SPIT_Object_Interface)) continue;
                    o_SPIT_Object_Interface = (SPIT_Object_Interface)o_LiveShowObjectInterface;
                    o_SPIT_Message = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)o_SPIT_Object_Interface);
                    if (!SPITServer_Client.this.sendSPIT_Message(o_SPIT_Message)) {
                        return;
                    }
                    if (o_SPIT_Watchdog != null) {
                        o_SPIT_Watchdog.eventWatchdogAnswer();
                    }
                    SPITServer_Client.this.sleepSend();
                }
                intCount = SPITRemote.getRemoteSPIT_TypeCount();
                for (intSPITType = 0; intSPITType < intCount; ++intSPITType) {
                    o_SPIT_Type_Interface = SPITRemote.getRemoteSPIT_Type((int)intSPITType);
                    if (o_SPIT_Type_Interface == null) continue;
                    o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)o_SPIT_Type_Interface);
                    if (!SPITServer_Client.this.sendSPIT_Message(o_SPIT_Message)) {
                        return;
                    }
                    if (o_SPIT_Watchdog != null) {
                        o_SPIT_Watchdog.eventWatchdogAnswer();
                    }
                    SPITServer_Client.this.sleepSend();
                }
                intCount = SPITRemote.getRemoteSPIT_ObjectCount();
                for (int intSPITObject = 0; intSPITObject < intCount; ++intSPITObject) {
                    o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object((int)intSPITObject);
                    if (o_SPIT_Object_Interface == null) continue;
                    o_SPIT_Message = SPIT_Message.createReportSPITObject((SPIT_Object_Interface)o_SPIT_Object_Interface);
                    if (!SPITServer_Client.this.sendSPIT_Message(o_SPIT_Message)) {
                        return;
                    }
                    o_SPIT_Message = SPIT_Message.createReportPlayStatus((SPIT_Object_Interface)o_SPIT_Object_Interface);
                    if (!SPITServer_Client.this.sendSPIT_Message(o_SPIT_Message)) {
                        return;
                    }
                    if (o_SPIT_Watchdog != null) {
                        o_SPIT_Watchdog.eventWatchdogAnswer();
                    }
                    SPITServer_Client.this.sleepSend();
                }
                o_SPIT_Message = SPIT_Message.createEndProjectTransfer();
                if (!SPITServer_Client.this.sendSPIT_Message(o_SPIT_Message)) {
                    return;
                }
            }
        };
        Thread o_Thread_Sender = new Thread(o_Runnable_ProjectTransfer);
        o_Thread_Sender.start();
        return true;
    }

    private void sleepSend() {
        this.m_JavaTimer.sleep((long)SPITServer.SEND_WAITTIME_MUCHMESSAGES);
    }

    private boolean parseStartProjectTransfer(SPIT_Message.StartProjectTransfer p_StartProjectTransfer) {
        if (p_StartProjectTransfer == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        this.m_TransferringProject = true;
        return true;
    }

    private boolean parseEndProjectTransfer(SPIT_Message.EndProjectTransfer p_EndProjectTransfer) {
        if (p_EndProjectTransfer == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        this.m_TransferringProject = false;
        return true;
    }

    private boolean parseReportSPITType(SPIT_Message.ReportSPITType p_ReportSPITType) {
        if (p_ReportSPITType == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        return SPIT_Type.parseReportSPITType(p_ReportSPITType, this, this.m_TransferringProject);
    }

    private boolean parseRemoveSPITType(SPIT_Message.RemoveSPITType p_RemoveSPITType) {
        if (p_RemoveSPITType == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        return SPIT_Type.parseRemoveSPITType(p_RemoveSPITType, this);
    }

    public boolean parseReportSPITObject(SPIT_Message.ReportSPITObject p_ReportSPITObject) {
        if (p_ReportSPITObject == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        return LiveShowSPITObject.parseReportSPITObject(p_ReportSPITObject, this, this.m_TransferringProject);
    }

    public boolean parseRemoveSPITObject(SPIT_Message.RemoveSPITObject p_RemoveSPITObject) {
        if (p_RemoveSPITObject == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        return LiveShowSPITObject.parseRemoveSPITObject(p_RemoveSPITObject, this);
    }

    public boolean parsePlaySPITStart_Remote(SPIT_Message.PlaySPITStart p_PlaySPITStart) {
        SPIT_ActionPlayer o_SPIT_ActionPlayer;
        if (p_PlaySPITStart == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        if ((o_SPIT_ActionPlayer = SPIT_ActionPlayer.getSPIT_ActionPlayer((String)p_PlaySPITStart.getPlayerID())) == null) {
            o_SPIT_ActionPlayer = new SPIT_ActionPlayer(p_PlaySPITStart.getPlayerID(), p_PlaySPITStart.getPlayerName(), p_PlaySPITStart.getPlayerType());
            SPIT_ActionPlayer.addSPIT_ActionPlayer((SPIT_ActionPlayer)o_SPIT_ActionPlayer);
        }
        o_SPIT_ActionPlayer.startPlayTransfer((SPIT_ClientInterface)this, p_PlaySPITStart.getPlayerIsRunning(), p_PlaySPITStart.getTime());
        return true;
    }

    public boolean parsePlaySPITObject_Remote(SPIT_Message.PlaySPITObject p_PlaySPITObject) {
        SPIT_ActionPlayer o_SPIT_ActionPlayer;
        if (p_PlaySPITObject == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        if ((o_SPIT_ActionPlayer = SPIT_ActionPlayer.getSPIT_ActionPlayer((String)p_PlaySPITObject.getPlayerID())) == null) {
            return false;
        }
        SPIT_Object_Interface o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object((String)p_PlaySPITObject.getID());
        o_SPIT_ActionPlayer.playObjectTransfer((SPIT_ClientInterface)this, o_SPIT_Object_Interface, p_PlaySPITObject.getPlayPrePosition(), p_PlaySPITObject.getFrameInsideObject(), p_PlaySPITObject.getValue(), p_PlaySPITObject.getValueFlag());
        return true;
    }

    public boolean parsePlaySPITEnd_Remote(SPIT_Message.PlaySPITEnd p_PlaySPITEnd) {
        SPIT_ActionPlayer o_SPIT_ActionPlayer;
        if (p_PlaySPITEnd == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        if ((o_SPIT_ActionPlayer = SPIT_ActionPlayer.getSPIT_ActionPlayer((String)p_PlaySPITEnd.getPlayerID())) == null) {
            return false;
        }
        o_SPIT_ActionPlayer.endPlayTransfer((SPIT_ClientInterface)this);
        return true;
    }

    public boolean parseReportPlayStatus(SPIT_Message.ReportPlayStatus p_ReportPlayStatus) {
        if (p_ReportPlayStatus == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        return LiveShowSPITObject.parseReportPlayStatus(p_ReportPlayStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        ArrayList o_SPIT_ClientInterfaces;
        SPIT_ClientInterface o_SPIT_ClientInterface = null;
        Object object = s_SyncObject;
        synchronized (object) {
            o_SPIT_ClientInterfaces = s_SPITClientTableModel.getArrayList();
        }
        for (int intClient = 0; intClient < o_SPIT_ClientInterfaces.size(); ++intClient) {
            o_SPIT_ClientInterface = (SPIT_ClientInterface)o_SPIT_ClientInterfaces.get(intClient);
            if (o_SPIT_ClientInterface == null) continue;
            SPIT_Message o_SPIT_Message = SPIT_Message.createDisconnect();
            o_SPIT_ClientInterface.sendSPIT_Message(o_SPIT_Message);
            o_SPIT_ClientInterface.close();
        }
    }

    public static int getSPIT_ClientInterfaceCount() {
        return s_SPITClientTableModel.size();
    }

    public static boolean addSPIT_ClientInterface(SPIT_ClientInterface p_SPIT_ClientInterface) {
        if (p_SPIT_ClientInterface == null) {
            return false;
        }
        SPIT_ClientInterface o_SPIT_ClientInterface = s_SPITClientTableModel.getSPIT_ClientInterface(p_SPIT_ClientInterface.getID());
        if (o_SPIT_ClientInterface == null) {
            return s_SPITClientTableModel.addSPIT_ClientInterface(p_SPIT_ClientInterface);
        }
        o_SPIT_ClientInterface.setClientProjectName(p_SPIT_ClientInterface.getClientProjectName());
        return true;
    }

    public static SPIT_ClientInterface getSPIT_ClientInterface(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        return s_SPITClientTableModel.getSPIT_ClientInterface(p_ID);
    }

    public static SPIT_ClientInterface getSPIT_ClientInterface(int p_Index) {
        return s_SPITClientTableModel.getSPIT_ClientInterface(p_Index);
    }

    public static boolean removeSPIT_ClientInterface(SPIT_ClientInterface p_SPIT_ClientInterface) {
        if (p_SPIT_ClientInterface == null) {
            return false;
        }
        return s_SPITClientTableModel.removeSPIT_ClientInterface(p_SPIT_ClientInterface);
    }

    public static boolean parseSPIT_Message(InetAddress p_ClientInetAddress, int p_ClientPort, SPIT_Message p_SPIT_Message) {
        if (p_ClientInetAddress == null) {
            return false;
        }
        if (p_SPIT_Message == null) {
            return false;
        }
        SPIT_Message.OPPart o_OPPart = p_SPIT_Message.getOPPart();
        if (o_OPPart == null) {
            return false;
        }
        SPIT_Message.Header o_Header = p_SPIT_Message.getHeader();
        if (o_Header == null) {
            return false;
        }
        String stringServerID = o_Header.getServerID();
        String stringClientID = o_Header.getClientID();
        SPIT_ClientInterface o_SPIT_ClientInterface = SPITServer_Client.getSPIT_ClientInterface(stringClientID, p_ClientInetAddress, p_ClientPort);
        if (o_OPPart instanceof SPIT_Message.Connect) {
            boolean boolSuccess = SPITServer_Client.parseConnect((SPIT_Message.Connect)o_OPPart, o_SPIT_ClientInterface, p_ClientInetAddress, p_ClientPort);
            SPIT_Message.addEmpty((SPIT_Message)p_SPIT_Message);
            return boolSuccess;
        }
        if (o_SPIT_ClientInterface == null) {
            return false;
        }
        o_SPIT_ClientInterface.checkParseSPIT_Message(p_SPIT_Message);
        return true;
    }

    public static boolean checkLogin(String p_LoginName, String p_LoginPassword) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean parseConnect(SPIT_Message.Connect p_OPPart, SPIT_ClientInterface p_Client, InetAddress p_ClientInetAddress, int p_ClientPort) {
        if (p_OPPart == null) {
            return false;
        }
        SPIT_Message.Header o_Header = p_OPPart.getHeader();
        boolean boolConnectOK = true;
        boolConnectOK = SPITServer_Client.checkLogin(p_OPPart.getLoginName(), p_OPPart.getLoginPassword());
        if (!boolConnectOK) {
            SPIT_Message o_SPIT_Message = SPIT_Message.createConnectAnswer((boolean)boolConnectOK, (String)SPITServer.s_ServerComputerName, (String)SPITServer.s_ServerName, (int)SPITServer.getFramesPerSecond());
            SPITServer.sendSPIT_Message(o_SPIT_Message, p_ClientInetAddress, p_ClientPort);
            if (p_Client != null) {
                p_Client.close();
            }
            return false;
        }
        if (p_Client == null) {
            p_Client = new SPITServer_Client(o_Header.getClientID(), p_OPPart.getClientComputerName(), p_OPPart.getClientName(), p_ClientInetAddress, p_ClientPort, p_OPPart.getServerIP(), p_OPPart.getServerPort());
            p_Client.resetMessageNumberReceived();
            Object object = s_SyncObject;
            synchronized (object) {
                SPITServer_Client.addSPIT_ClientInterface(p_Client);
            }
        } else {
            p_Client.resetMessageNumberReceived();
            return boolConnectOK;
        }
        System.out.println("SPITServer_Client CONNECTION ACCEPTED Address: " + p_ClientInetAddress);
        SPIT_Message o_SPIT_Message = SPIT_Message.createConnectAnswer((boolean)boolConnectOK, (String)p_Client.getServerComputerName(), (String)p_Client.getServerName(), (int)p_Client.getServerStepTime());
        p_Client.sendSPIT_Message(o_SPIT_Message);
        o_SPIT_Message = SPIT_Message.createReportSPITProject((String)p_Client.getServerProjectName(), (String)p_Client.getServerProjectName(), (int)SPITServer.getFramesPerSecond());
        p_Client.sendSPIT_Message(o_SPIT_Message);
        p_Client.startWatchdog();
        return boolConnectOK;
    }

    public boolean isConnected() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SPIT_ClientInterface getSPIT_ClientInterface(String p_ClientID, InetAddress p_CLientInetAddress, int p_ClientPort) {
        if (p_ClientID == null) {
            return null;
        }
        if (p_CLientInetAddress == null) {
            return null;
        }
        SPIT_ClientInterface o_SPIT_ClientInterface = null;
        Object object = s_SyncObject;
        synchronized (object) {
            for (int intClient = 0; intClient < s_SPITClientTableModel.size(); ++intClient) {
                o_SPIT_ClientInterface = s_SPITClientTableModel.getSPIT_ClientInterface(intClient);
                if (o_SPIT_ClientInterface == null) continue;
                if (!p_ClientID.equals(o_SPIT_ClientInterface.getID())) {
                    o_SPIT_ClientInterface = null;
                    continue;
                }
                if (!p_CLientInetAddress.equals(o_SPIT_ClientInterface.getInetAddress())) {
                    o_SPIT_ClientInterface = null;
                    continue;
                }
                if (p_ClientPort == o_SPIT_ClientInterface.getPort()) break;
                o_SPIT_ClientInterface = null;
            }
        }
        return o_SPIT_ClientInterface;
    }

    public static void sendSPIT_Message(SPIT_Message p_SPIT_Message, SPIT_ClientInterface p_ExcludedClient) {
        if (p_SPIT_Message == null) {
            return;
        }
        int intSPIT_ClientInterfaceCount = s_SPITClientTableModel.size();
        for (int intClient = 0; intClient < intSPIT_ClientInterfaceCount; ++intClient) {
            SPIT_ClientInterface o_SPIT_ClientInterface = s_SPITClientTableModel.getSPIT_ClientInterface(intClient);
            if (o_SPIT_ClientInterface == null || o_SPIT_ClientInterface == p_ExcludedClient) continue;
            p_SPIT_Message.getHeader().setServerID(SPITServer.s_ServerID);
            p_SPIT_Message.getHeader().setClientID(o_SPIT_ClientInterface.getID());
            o_SPIT_ClientInterface.sendSPIT_Message_ForAllClients(p_SPIT_Message);
        }
        SPIT_Message.addEmpty((SPIT_Message)p_SPIT_Message);
    }

    public void firePropertyChange(String PropertyName, Object p_OldValue, Object p_NewValue) {
        this.m_SinglePropertyChangeSupport.firePropertyChange(PropertyName, p_OldValue, p_NewValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_SinglePropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        this.m_SinglePropertyChangeSupport.fireIndexedPropertyChange(this.m_Name, this.m_Port, s_SyncObject, s_SyncObject);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_SinglePropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }
}

