/*
 * Decompiled with CFR 0.152.
 */
package SPITServerPackage;

import OS.OSChecker;
import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_Message;
import SPITRemotePackage.SPITRemote;
import SPITServerPackage.LiveShowSPITObject;
import SPITServerPackage.SPITServer_Client;
import SPITServerPackage.SPIT_ServerInterface;
import SPITServerPackage.SPIT_Type;
import SPITToolsPackage.SinglePropertyChangeSupport;
import ServerAutoDetectPackage.ServerAutoDetect_Server;
import SoundPackage.SoundMixers;
import StartPackage.LiveShowMediaSystem;
import TimerPackage.JavaTimer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.UUID;

public class SPITServer
implements SPIT_ServerInterface {
    public static int SEND_WAITTIME_MUCHMESSAGES = 5;
    public static int SEND_WAITTIME_NORMAL = 1;
    public static String INIFILE_NAME = "LiveShow_SPITServer.ini";
    public static final String INIFILE_FIELDSEPERATOR = "=";
    public static final String INIFILE_REMARK = "//";
    public static String s_ServerID = UUID.randomUUID().toString();
    public static String s_ServerComputerName = "";
    public static String s_ServerName = "liveSHOW";
    public static int s_LocalPort = 15120;
    public static final String SPITSERVER_TASKID = "#spit#";
    public static String SPITSERVER_TASKNAME = "liveShowSPIT";
    public static boolean s_ClosingProject = false;
    public static boolean s_ReportProjectSended = false;
    private DatagramSocket m_DatagramSocket;
    private final Object m_SyncSendMessage = new Object();
    private boolean m_StopServer;
    private ArrayList<DatagramPacket> m_Send_DatagramPackets;
    private Runnable m_Send_Runnable;
    private Thread m_SendThread;
    private Runnable m_RunnableReceive;
    private Thread m_ThreadReceive;
    private static final Object s_SyncServer = new Object();
    private static int s_FramesPerSecond = (int)SoundMixers.DEFAULT_AUDIOFORMAT.getFrameRate();
    private static SinglePropertyChangeSupport s_SinglePropertyChangeSupport = new SinglePropertyChangeSupport(SPITServer.class);
    public static SPITServer s_SelfReference = new SPITServer();
    public static final Object s_SyncWriteIni = new Object();

    public static SinglePropertyChangeSupport getPropertyChangeSupport() {
        return s_SinglePropertyChangeSupport;
    }

    public SPITServer() {
        this.initMembers();
        this.readIni();
        this.initRunnableSend();
        this.initRunnableReceive();
        SPITRemote.setSPIT_ServerInterface((SPIT_ServerInterface)this);
    }

    private void initMembers() {
        this.m_Send_DatagramPackets = new ArrayList();
        this.m_StopServer = true;
        try {
            s_ServerComputerName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            s_ServerComputerName = "";
        }
    }

    public void closeInstance() {
        SPITServer_Client.closeAll();
        this.stopServer();
    }

    private void initRunnableReceive() {
        this.m_RunnableReceive = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] o_BytesReceived = new byte[512];
                DatagramPacket o_DatagramPacket = new DatagramPacket(o_BytesReceived, o_BytesReceived.length);
                while (!SPITServer.this.m_StopServer) {
                    Object object = s_SyncServer;
                    synchronized (object) {
                        if (SPITServer.this.m_DatagramSocket == null || SPITServer.this.m_DatagramSocket.isClosed()) {
                            SPITServer.this.m_StopServer = true;
                            continue;
                        }
                    }
                    try {
                        SPITServer.this.m_DatagramSocket.receive(o_DatagramPacket);
                    }
                    catch (SocketTimeoutException e_SocketTimeoutException) {
                        continue;
                    }
                    catch (Exception e) {
                        SPITServer.this.m_StopServer = true;
                        continue;
                    }
                    SPIT_Message o_SPIT_Message = SPIT_Message.createSPIT_Message((byte[])o_DatagramPacket.getData(), (int)o_DatagramPacket.getLength());
                    if (o_SPIT_Message == null) continue;
                    if (o_SPIT_Message.getHeader() == null) {
                        o_SPIT_Message = null;
                        continue;
                    }
                    if (o_SPIT_Message.getOPPart() == null) {
                        o_SPIT_Message = null;
                        continue;
                    }
                    InetAddress o_ClientInetAddress = o_DatagramPacket.getAddress();
                    int intClientPort = o_DatagramPacket.getPort();
                    SPITServer_Client.parseSPIT_Message(o_ClientInetAddress, intClientPort, o_SPIT_Message);
                }
            }
        };
    }

    public int getSPIT_ClientInterfaceCount() {
        return SPITServer_Client.s_SPITClientTableModel.size();
    }

    public boolean sendedReportProject() {
        return s_ReportProjectSended;
    }

    public boolean sendSPIT_Message(SPIT_Message p_SPIT_Message, SPIT_ClientInterface p_ExcludedClient) {
        boolean boolSended = false;
        int intSPIT_ClientInterfaceCount = SPITServer_Client.s_SPITClientTableModel.size();
        for (int intClient = 0; intClient < intSPIT_ClientInterfaceCount; ++intClient) {
            SPIT_ClientInterface o_SPIT_ClientInterface = SPITServer_Client.s_SPITClientTableModel.getSPIT_ClientInterface(intClient);
            if (o_SPIT_ClientInterface == null || o_SPIT_ClientInterface == p_ExcludedClient) continue;
            p_SPIT_Message.getHeader().setServerID(s_ServerID);
            p_SPIT_Message.getHeader().setClientID(o_SPIT_ClientInterface.getID());
            if (!o_SPIT_ClientInterface.sendSPIT_Message_ForAllClients(p_SPIT_Message)) continue;
            boolSended = true;
        }
        SPIT_Message.addEmpty((SPIT_Message)p_SPIT_Message);
        return boolSended;
    }

    public static boolean sendSPIT_Message(SPIT_Message p_SPIT_Message, InetAddress p_InetAddress, int p_Port) {
        if (p_SPIT_Message == null) {
            return false;
        }
        if (p_InetAddress == null) {
            return false;
        }
        if (p_Port < 0) {
            return false;
        }
        DatagramSocket o_DatagramSocket = s_SelfReference.getDatagramSocket();
        if (o_DatagramSocket == null) {
            return false;
        }
        if (o_DatagramSocket.isClosed()) {
            return false;
        }
        byte[] o_MessageBytes = p_SPIT_Message.getMessageBytes();
        if (o_MessageBytes == null) {
            return false;
        }
        byte[] o_DataBytes = SPIT_Message.getDataBytes((int)o_MessageBytes.length);
        System.arraycopy(o_MessageBytes, 0, o_DataBytes, 0, o_DataBytes.length);
        DatagramPacket o_DatagramPacket = new DatagramPacket(o_DataBytes, o_DataBytes.length, p_InetAddress, p_Port);
        boolean boolSended = s_SelfReference.addDatagramPacketToSend(o_DatagramPacket);
        return boolSended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addDatagramPacketToSend(DatagramPacket p_DatagramPacket) {
        if (p_DatagramPacket == null) {
            return false;
        }
        Object object = s_SyncServer;
        synchronized (object) {
            if (this.m_StopServer || this.m_DatagramSocket == null || this.m_DatagramSocket.isClosed()) {
                return false;
            }
            this.m_Send_DatagramPackets.add(p_DatagramPacket);
            s_SyncServer.notifyAll();
        }
        return true;
    }

    private void initRunnableSend() {
        this.m_Send_Runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DatagramPacket o_DatagramPacket;
                ArrayList o_Rest_DatagramPackets = null;
                JavaTimer o_JavaTimer = new JavaTimer();
                while (!SPITServer.this.m_StopServer) {
                    Object object = s_SyncServer;
                    synchronized (object) {
                        if (SPITServer.this.m_Send_DatagramPackets.size() <= 0) {
                            try {
                                s_SyncServer.wait(2000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (SPITServer.this.m_DatagramSocket == null || SPITServer.this.m_DatagramSocket.isClosed()) {
                                break;
                            }
                        }
                        if (SPITServer.this.m_StopServer) {
                            if (SPITServer.this.m_Send_DatagramPackets.size() > 0) {
                                o_Rest_DatagramPackets = new ArrayList(SPITServer.this.m_Send_DatagramPackets.size());
                                o_Rest_DatagramPackets.addAll(SPITServer.this.m_Send_DatagramPackets);
                            }
                            SPITServer.this.m_Send_DatagramPackets.clear();
                            continue;
                        }
                        if (SPITServer.this.m_Send_DatagramPackets.size() <= 0) {
                            continue;
                        }
                    }
                    o_DatagramPacket = null;
                    object = s_SyncServer;
                    synchronized (object) {
                        if (SPITServer.this.m_Send_DatagramPackets.size() > 0) {
                            o_DatagramPacket = (DatagramPacket)SPITServer.this.m_Send_DatagramPackets.get(0);
                            try {
                                SPITServer.this.m_DatagramSocket.send(o_DatagramPacket);
                                o_JavaTimer.sleep((long)SEND_WAITTIME_NORMAL);
                            }
                            catch (Exception e) {
                                System.out.println("SPITServer m_Send_Runnable sendDatagramm to: " + o_DatagramPacket.getAddress() + " Error:");
                                System.out.println("     " + e.getMessage());
                            }
                            SPITServer.this.m_Send_DatagramPackets.remove(0);
                            SPIT_Message.addEmpty((byte[])o_DatagramPacket.getData());
                        }
                    }
                }
                if (o_Rest_DatagramPackets != null) {
                    try {
                        for (int intMessage = 0; intMessage < o_Rest_DatagramPackets.size(); ++intMessage) {
                            o_DatagramPacket = (DatagramPacket)o_Rest_DatagramPackets.get(intMessage);
                            SPITServer.this.m_DatagramSocket.send(o_DatagramPacket);
                            o_JavaTimer.sleep((long)SEND_WAITTIME_MUCHMESSAGES);
                            SPIT_Message.addEmpty((byte[])o_DatagramPacket.getData());
                        }
                        o_Rest_DatagramPackets.clear();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Object object = s_SyncServer;
                synchronized (object) {
                    SPITServer.this.m_Send_DatagramPackets.clear();
                }
                o_JavaTimer.close();
            }
        };
    }

    public static void close() {
        if (s_SelfReference != null) {
            s_SelfReference.closeInstance();
        }
    }

    public static void closeProject() {
        if (s_SelfReference != null) {
            // empty if block
        }
        s_ClosingProject = true;
        s_ReportProjectSended = false;
        SPITRemote.parseCloseSPITProject_Server();
        SPIT_Message o_SPIT_Message = SPIT_Message.createCloseSPITProject((String)LiveShowMediaSystem.getLiveShowProjectDescription().getProjectName());
        SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
        LiveShowSPITObject.parseCloseProject();
        SPIT_Type.parseCloseProject();
        SPIT_Message.poolClear();
    }

    public static void newProject(boolean p_EmptyProject) {
        if (s_SelfReference != null) {
            s_SelfReference.startServer();
        }
        s_ClosingProject = false;
        LiveShowSPITObject.parseNewProject();
        SPIT_Type.parseNewProject();
        SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITProject((String)LiveShowMediaSystem.getProjectName(), (String)LiveShowMediaSystem.getProjectName(), (int)SPITServer.getFramesPerSecond());
        SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
        s_ReportProjectSended = true;
    }

    public static void savedProject() {
        if (s_SelfReference != null) {
            s_SelfReference.startServer();
        }
        s_ClosingProject = false;
        SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITProject((String)LiveShowMediaSystem.getProjectName(), (String)LiveShowMediaSystem.getProjectName(), (int)SPITServer.getFramesPerSecond());
        SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
        s_ReportProjectSended = true;
    }

    public static boolean getClosingProject() {
        return s_ClosingProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer() {
        if (!this.m_StopServer) {
            ServerAutoDetect_Server o_ServerAutoDetect_Server = ServerAutoDetect_Server.getServerAutoDetect_Server((String)s_ServerID);
            if (o_ServerAutoDetect_Server != null) {
                o_ServerAutoDetect_Server.setServerProjectName(LiveShowMediaSystem.getProjectName());
            }
            return;
        }
        this.m_StopServer = false;
        Object object = s_SyncServer;
        synchronized (object) {
            try {
                this.m_DatagramSocket = new DatagramSocket(s_LocalPort);
                try {
                    this.m_DatagramSocket.setSendBufferSize(65024);
                    this.m_DatagramSocket.setReceiveBufferSize(65024);
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                this.m_DatagramSocket = null;
                this.m_StopServer = true;
                return;
            }
        }
        this.m_SendThread = new Thread(this.m_Send_Runnable);
        this.m_SendThread.start();
        Thread o_Thread = new Thread(this.m_RunnableReceive);
        o_Thread.start();
        ServerAutoDetect_Server.startServerAutoDetect((String)s_ServerID, (String)SPITSERVER_TASKID, (String)SPITSERVER_TASKNAME, (int)15110, (int)s_LocalPort, null, (String)LiveShowMediaSystem.getProjectName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        this.m_StopServer = true;
        Object object = s_SyncServer;
        synchronized (object) {
            ServerAutoDetect_Server.stopServerAutoDetect((String)s_ServerID);
        }
        this.closeDatagramSocket();
        this.writeIni();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDatagramSocket() {
        Object object = s_SyncServer;
        synchronized (object) {
            this.m_StopServer = true;
            s_SyncServer.notifyAll();
        }
        try {
            if (this.m_SendThread != null) {
                this.m_SendThread.join(2000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_SendThread = null;
        object = s_SyncServer;
        synchronized (object) {
            try {
                if (this.m_DatagramSocket != null) {
                    this.m_DatagramSocket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_DatagramSocket = null;
        }
    }

    public String getComputerName() {
        return s_ServerComputerName;
    }

    public DatagramSocket getDatagramSocket() {
        return this.m_DatagramSocket;
    }

    public Object getSyncSendMessage() {
        return this.m_SyncSendMessage;
    }

    public boolean readIni() {
        String stringSPITServerAddition = this.getServer_Addition();
        String stringFileName = stringSPITServerAddition != null && stringSPITServerAddition.length() > 0 ? OSChecker.getPathUserHomeConfigDirectory() + "/" + stringSPITServerAddition + "/" + INIFILE_NAME : OSChecker.getPathUserHomeConfigDirectory() + "/" + INIFILE_NAME;
        File o_FileIni = new File(stringFileName);
        if (!o_FileIni.exists()) {
            return false;
        }
        boolean boolIni = false;
        FileReader o_FileReaderIni = null;
        BufferedReader o_BufferedReader = null;
        try {
            o_FileReaderIni = new FileReader(o_FileIni);
            o_BufferedReader = new BufferedReader(o_FileReaderIni);
            String stringLine = o_BufferedReader.readLine();
            while (stringLine != null) {
                String[] stringValuePair = stringLine.split(INIFILE_FIELDSEPERATOR);
                if (stringValuePair == null) {
                    stringLine = o_BufferedReader.readLine();
                    continue;
                }
                if (stringValuePair.length < 2) {
                    stringLine = o_BufferedReader.readLine();
                    continue;
                }
                if (stringValuePair[1].trim().length() > 0) {
                    String stringPropertyName = stringValuePair[0].trim();
                    String stringPropertyValue = stringValuePair[1].trim();
                    if (stringPropertyName.trim().toLowerCase().equals("ServerID".toLowerCase())) {
                        String stringID;
                        s_ServerID = stringID = stringPropertyValue.trim();
                    }
                    if (stringPropertyName.trim().toLowerCase().equals("ServerPort".toLowerCase())) {
                        String stringPort = stringPropertyValue.trim();
                        try {
                            int intPort;
                            s_LocalPort = intPort = Integer.valueOf(stringPort).intValue();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                stringLine = o_BufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (o_BufferedReader != null) {
                o_BufferedReader.close();
            }
            if (o_FileReaderIni != null) {
                o_FileReaderIni.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return boolIni;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeIni() {
        Object object = s_SyncWriteIni;
        synchronized (object) {
            File o_FileIni;
            String stringSPITServerAddition = this.getServer_Addition();
            boolean boolOK = true;
            try {
                String stringFileName = stringSPITServerAddition != null && stringSPITServerAddition.length() > 0 ? OSChecker.getPathUserHomeConfigDirectory() + "/" + stringSPITServerAddition + "/" + INIFILE_NAME : OSChecker.getPathUserHomeConfigDirectory() + "/" + INIFILE_NAME;
                o_FileIni = new File(stringFileName);
                if (o_FileIni.exists()) {
                    boolOK = o_FileIni.delete();
                }
                if (!boolOK) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            boolean boolIni = false;
            FileWriter o_FileWriterIni = null;
            BufferedWriter o_BufferedWriter = null;
            try {
                o_FileWriterIni = new FileWriter(o_FileIni);
                o_BufferedWriter = new BufferedWriter(o_FileWriterIni);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.delete(0, stringBuilder.length());
                stringBuilder.append("ServerID");
                stringBuilder.append(INIFILE_FIELDSEPERATOR);
                stringBuilder.append(s_ServerID);
                stringBuilder.append(INIFILE_FIELDSEPERATOR);
                stringBuilder.append("UUID of the SPITServer");
                o_BufferedWriter.append(stringBuilder.toString());
                o_BufferedWriter.newLine();
                stringBuilder.delete(0, stringBuilder.length());
                stringBuilder.append("ServerPort");
                stringBuilder.append(INIFILE_FIELDSEPERATOR);
                stringBuilder.append(s_LocalPort);
                stringBuilder.append(INIFILE_FIELDSEPERATOR);
                stringBuilder.append("port of the SPITServer");
                o_BufferedWriter.append(stringBuilder.toString());
                boolIni = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (o_BufferedWriter != null) {
                    o_BufferedWriter.flush();
                    o_BufferedWriter.close();
                }
                if (o_FileWriterIni != null) {
                    o_FileWriterIni.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return boolIni;
        }
    }

    public String getServer_Addition() {
        return "";
    }

    public void setFramesPerSecond(int p_FramesPerSecond) {
        if (p_FramesPerSecond < 1) {
            p_FramesPerSecond = 1;
        }
        s_FramesPerSecond = p_FramesPerSecond;
    }

    public static int getFramesPerSecond() {
        return s_FramesPerSecond;
    }
}

