/*
 * Decompiled with CFR 0.152.
 */
package SPITServerPackage;

import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectListener;
import LiveShowPlayPackage.Playable;
import MediaPackage.MediaServer;
import PlayMediaPackage.PlayMedia;
import SPITActionPackage.SPIT_ActionPlayer;
import SPITLibraryPackage.SPIT_Message;
import SPITServerPackage.LiveShowSPITObject;
import SPITServerPackage.SPITServer_Client;
import java.util.ArrayList;
import java.util.HashMap;

public class PlaySPIT {
    public static int BUFFER_MILLISECONDS = 40;
    public static int NEW_BUFFER_MILLISECONDS = 40;
    public static double s_MainTransparency;
    private PlayMedia m_PlayMedia;
    private String m_ID;
    private String m_ProducerName;
    private long m_PlayStartTime;
    private long m_FramesToReadTime;
    private long m_FramesToReadDefault;
    private long m_FramePositionToWrite;
    private long m_FramesRead;
    private Playable m_Playable;
    private SPITPlayObject m_SPITPlayObject;

    public static int getNewBufferMilliseconds() {
        return NEW_BUFFER_MILLISECONDS;
    }

    public static void setNewBufferMilliseconds(int p_Milliseconds) {
        NEW_BUFFER_MILLISECONDS = p_Milliseconds;
    }

    public PlaySPIT(String p_ID, String p_ProducerName, Playable p_Playable, PlayMedia p_PlayMedia) {
        this.m_ID = p_ID;
        this.m_ProducerName = p_ProducerName;
        this.m_Playable = p_Playable;
        this.m_PlayMedia = p_PlayMedia;
        this.initMembers();
    }

    private void initMembers() {
        this.initPlayObject();
        this.m_FramesToReadTime = BUFFER_MILLISECONDS;
        this.m_FramesRead = -1L;
    }

    public void setPlayable(Playable p_Playable) {
        if (p_Playable == null) {
            return;
        }
        this.m_Playable = p_Playable;
    }

    public void setSPITPlayObject(SPITPlayObject p_SPITPlayObject) {
        this.m_SPITPlayObject = p_SPITPlayObject;
    }

    public void close() {
        if (this.m_SPITPlayObject != null) {
            this.m_SPITPlayObject.close();
        }
    }

    public void reworkStop() {
    }

    protected void initPlayObject() {
    }

    public String getID() {
        return this.m_ID;
    }

    public String getProducerName() {
        return this.m_ProducerName;
    }

    public Playable.PlayObject getPlayObject() {
        return this.m_SPITPlayObject;
    }

    public boolean isRunning() {
        return this.m_PlayMedia.isRunning();
    }

    public long getPlayCursorJumpPerReadCycle() {
        return this.m_FramesToReadDefault;
    }

    public static void setMainTransparency(double p_MainTransparency) {
        if (p_MainTransparency < 0.0) {
            p_MainTransparency = 0.0;
        }
        s_MainTransparency = p_MainTransparency;
        PlaySPIT.sendMainTransparency();
    }

    public static double getMainTransparency() {
        return s_MainTransparency;
    }

    public void sendPlayStatus() {
        SPITPlayObject o_SPITPlayObject = (SPITPlayObject)this.getPlayObject();
        o_SPITPlayObject.sendPlayStatus();
    }

    public static void sendMainTransparency() {
        MediaServer.sendMainTransparency((float)s_MainTransparency);
    }

    public static class PlayStatus
    implements LiveShowObjectListener {
        public static int s_PoolSize = 100;
        public static ArrayList<PlayStatus> s_PlayStatusPool = new ArrayList(100);
        public static final Object s_SyncPool = new Object();
        private LiveShowSPITObject m_LiveShowSPITObject;
        private boolean m_IsSetPreObject;
        private boolean m_IsSetActualObject;
        private long m_FrameInside;
        private float m_VolumeFactor;
        private double m_FadeFactor;
        private double m_FadeInFactor;
        private double m_FadeOutFactor;
        private boolean m_FadeIn;
        private boolean m_FadeOut;
        private boolean m_Closed;
        private final Object m_SyncObject = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static PlayStatus poolGet() {
            PlayStatus o_PlayStatus;
            Object object = s_SyncPool;
            synchronized (object) {
                if (s_PlayStatusPool.size() > 0) {
                    int intIndex = s_PlayStatusPool.size() - 1;
                    o_PlayStatus = s_PlayStatusPool.get(intIndex);
                    o_PlayStatus.reactivate();
                    s_PlayStatusPool.remove(intIndex);
                } else {
                    o_PlayStatus = new PlayStatus();
                }
            }
            return o_PlayStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean poolAddEmpty(PlayStatus p_PlayStatus) {
            if (p_PlayStatus == null) {
                return false;
            }
            Object object = s_SyncPool;
            synchronized (object) {
                if (s_PlayStatusPool.size() < s_PoolSize) {
                    s_PlayStatusPool.add(p_PlayStatus);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void poolClear() {
            Object object = s_SyncPool;
            synchronized (object) {
                s_PlayStatusPool.clear();
            }
        }

        public PlayStatus() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_LiveShowSPITObject = null;
            this.m_IsSetPreObject = false;
            this.m_IsSetActualObject = false;
            this.m_FrameInside = 0L;
            this.m_VolumeFactor = 0.0f;
            this.m_FadeFactor = 0.0;
            this.m_FadeInFactor = 0.0;
            this.m_FadeOutFactor = 0.0;
            this.m_FadeIn = false;
            this.m_FadeOut = false;
            this.m_Closed = false;
        }

        public void reactivate() {
            this.initMembers();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_Closed) {
                    return;
                }
                this.m_Closed = true;
                if (this.m_LiveShowSPITObject != null) {
                    this.m_LiveShowSPITObject.removeLiveShowObjectListener(this);
                }
                PlayStatus.poolAddEmpty(this);
            }
        }

        public void setStatus(LiveShowSPITObject p_LiveShowSPITObject, boolean p_IsPreObject, long p_FrameInside, float p_VolumeFactor, double p_FadeFactor, boolean p_FadeIN, boolean p_FadeOut) {
            if (p_LiveShowSPITObject == null) {
                return;
            }
            this.m_LiveShowSPITObject = p_LiveShowSPITObject;
            if (p_IsPreObject) {
                this.m_IsSetPreObject = true;
            } else {
                this.m_IsSetActualObject = true;
            }
            this.m_LiveShowSPITObject.addLiveShowObjectListener(this);
            this.m_FrameInside = p_FrameInside;
            this.m_VolumeFactor = p_VolumeFactor;
            this.m_FadeFactor = p_FadeFactor;
            this.m_FadeIn = p_FadeIN;
            this.m_FadeOut = p_FadeOut;
        }

        public LiveShowSPITObject getSpit_Object() {
            return this.m_LiveShowSPITObject;
        }

        public long getFrameInside() {
            return this.m_FrameInside;
        }

        public boolean getIsSetPreObject() {
            return this.m_IsSetPreObject;
        }

        public boolean getIsSetActualObject() {
            return this.m_IsSetActualObject;
        }

        public boolean getIsPurPreObject() {
            if (!this.m_IsSetPreObject) {
                return false;
            }
            return !this.m_IsSetActualObject;
        }

        public float getVolumeFactor() {
            return this.m_VolumeFactor;
        }

        public void setFadeInFactor(double p_FadeFactor) {
            this.m_FadeInFactor = p_FadeFactor;
        }

        public void setFadeOutFactor(double p_FadeFactor) {
            this.m_FadeOutFactor = p_FadeFactor;
        }

        public void setFadeFactor(double p_Factor) {
            this.m_FadeFactor = p_Factor;
        }

        public double getFadeFactor() {
            return this.m_FadeFactor;
        }

        public boolean getFadeIn() {
            return this.m_FadeIn;
        }

        public boolean getFadeOut() {
            return this.m_FadeOut;
        }

        @Override
        public void eventObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        }

        @Override
        public void eventObjectVolumeChanged(LiveShowObjectInterface p_LiveShowObjectInterface, float p_Volume) {
        }

        @Override
        public void eventObjectAdditionalChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        }

        @Override
        public void eventObjectClosed(LiveShowObjectInterface p_LiveShowObjectInterface) {
            this.close();
        }

        @Override
        public void eventObjectSelection(LiveShowObjectInterface p_LiveShowObjectInterface, boolean p_IsSelected, boolean p_Added) {
        }
    }

    public static class SPITPlayObject
    implements Playable.PlayObject {
        public static final int SOFTWAREVERSION = 1;
        private HashMap<LiveShowSPITObject, PlayStatus> m_PlayStatuses;
        private Playable m_Playable;
        private String m_ProducerName;
        private PlayMedia.MediaPlayObject m_MediaPlayObject;
        private PlaySPIT m_PlaySPIT;
        private ArrayList<SPITServer_Client> m_SPIT_Clients;
        private long m_FramePosition;
        private long m_FramesToRead;
        private int m_FramesBuffered;
        private double m_FrameTime;
        private boolean m_EditMode;
        private final Object m_SyncPlayStatus = new Object();

        public SPITPlayObject(String p_ProducerName, PlaySPIT p_PlaySPIT, Playable p_Playable, PlayMedia.MediaPlayObject p_MediaPlayObject) {
            this.m_ProducerName = p_ProducerName;
            this.m_PlaySPIT = p_PlaySPIT;
            this.m_Playable = p_Playable;
            this.m_MediaPlayObject = p_MediaPlayObject;
            this.initMembers();
        }

        private void initMembers() {
            this.m_SPIT_Clients = new ArrayList();
            this.m_PlayStatuses = new HashMap(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                this.m_PlayStatuses.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pause() {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Playable getPlayable() {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                return this.m_Playable;
            }
        }

        public boolean getEditMode() {
            return this.m_EditMode;
        }

        @Override
        public void setFramePosition(long p_FramePosition) {
            this.m_FramePosition = p_FramePosition;
        }

        @Override
        public long getFramePosition() {
            return this.m_FramePosition;
        }

        @Override
        public void setFramesToRead(long p_FrameLength) {
            this.m_FramesToRead = p_FrameLength;
        }

        @Override
        public long getFramesToRead() {
            return this.m_FramesToRead;
        }

        @Override
        public void setFramesBuffered(int p_FramesBuffered) {
            this.m_FramesBuffered = p_FramesBuffered;
        }

        @Override
        public int getFramesBuffered() {
            return this.m_FramesBuffered;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getData() {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                return this.m_PlayStatuses;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                for (PlayStatus o_PlayStatus : this.m_PlayStatuses.values()) {
                    o_PlayStatus.close();
                }
                this.m_PlayStatuses.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFrameTime(double p_FrameTime) {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                this.m_FrameTime = p_FrameTime;
            }
        }

        @Override
        public double getFadeProgress() {
            return this.m_MediaPlayObject.getFadeProgress();
        }

        public double getFadeProgress(boolean p_PreObject) {
            return this.m_MediaPlayObject.getFadeProgress(p_PreObject);
        }

        @Override
        public double getFadeInProgress() {
            return this.m_MediaPlayObject.getFadeInProgress();
        }

        public double getFadeInProgress(boolean p_PreObject) {
            return this.m_MediaPlayObject.getFadeInProgress(p_PreObject);
        }

        @Override
        public double getFadeOutProgress() {
            return this.m_MediaPlayObject.getFadeOutProgress();
        }

        public double getFadeOutProgress(boolean p_PreObject) {
            return this.m_MediaPlayObject.getFadeOutProgress(p_PreObject);
        }

        public void setFadeInProgress(double p_FadeInProgress) {
        }

        public void setFadeOutProgress(double p_FadeOutProgress) {
        }

        public void setFadeProgress(double p_FadeProgress) {
        }

        public void setVolumeFactor(float p_Factor) {
        }

        public float getVolumeFactor() {
            return this.m_MediaPlayObject.getVolumeFactor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPlayObjectStatus(LiveShowSPITObject p_LiveShowSPITObject, boolean p_IsPreObject, long p_FramePositionInside, float p_VolumeFactor, double p_FadeFactor, boolean p_FadeIN, boolean p_FadeOut) {
            PlayStatus o_PlayStatus;
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                o_PlayStatus = this.m_PlayStatuses.get(p_LiveShowSPITObject);
            }
            if (o_PlayStatus == null) {
                o_PlayStatus = PlayStatus.poolGet();
            }
            o_PlayStatus.setStatus(p_LiveShowSPITObject, p_IsPreObject, p_FramePositionInside, p_VolumeFactor, p_FadeFactor, p_FadeIN, p_FadeOut);
            object = this.m_SyncPlayStatus;
            synchronized (object) {
                this.m_PlayStatuses.put(p_LiveShowSPITObject, o_PlayStatus);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendPlayStatus() {
            SPIT_Message o_SPIT_Message;
            String stringPlayerName;
            byte bytePlayerType;
            if (this.m_PlaySPIT.getProducerName().equals("vip")) {
                bytePlayerType = SPIT_ActionPlayer.PLAYERFLAG_MAIN;
                stringPlayerName = "Timeline";
            } else {
                bytePlayerType = SPIT_ActionPlayer.PLAYERFLAG_CONTINOUS;
                stringPlayerName = "Jingle";
            }
            if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0) {
                o_SPIT_Message = SPIT_Message.createPlaySPITStart((String)this.m_PlaySPIT.getID(), (String)stringPlayerName, (byte)bytePlayerType, (boolean)this.m_PlaySPIT.isRunning(), (long)this.m_MediaPlayObject.getFramePosition());
                SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
            }
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                for (PlayStatus o_PlayStatus : this.m_PlayStatuses.values()) {
                    if (o_PlayStatus == null) continue;
                    LiveShowSPITObject o_LiveShowSPITObject = o_PlayStatus.getSpit_Object();
                    if (o_LiveShowSPITObject == null) {
                        o_PlayStatus.close();
                        continue;
                    }
                    double doubleFadeInProgressActual = 0.0;
                    double doubleFadeOutProgressActual = 0.0;
                    double doubleFadeFactor = 0.0;
                    if (o_PlayStatus.getIsSetPreObject()) {
                        doubleFadeOutProgressActual = this.getFadeProgress(true);
                    }
                    if (o_PlayStatus.getIsSetActualObject()) {
                        doubleFadeInProgressActual = this.getFadeProgress(false);
                    }
                    o_PlayStatus.setFadeFactor(o_PlayStatus.getFadeFactor() * (doubleFadeFactor += doubleFadeInProgressActual + doubleFadeOutProgressActual));
                    if (SPITServer_Client.getSPIT_ClientInterfaceCount() <= 0) continue;
                    o_SPIT_Message = SPIT_Message.createPlaySPITObject((String)this.m_PlaySPIT.getID(), (String)o_LiveShowSPITObject.getID(), (long)o_PlayStatus.getFrameInside(), (boolean)o_PlayStatus.getIsPurPreObject(), (int)((int)(o_PlayStatus.getFadeFactor() * 1000000.0)), (byte)0);
                    SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
                }
            }
            if (SPITServer_Client.getSPIT_ClientInterfaceCount() > 0) {
                o_SPIT_Message = SPIT_Message.createPlaySPITEnd((String)this.m_PlaySPIT.getID());
                SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
            }
        }
    }
}

