/*
 * Decompiled with CFR 0.152.
 */
package SPITServerPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectListener;
import LiveShowVirtualPackage.LiveShowVIP;
import SPITLibraryPackage.SPIT_TypeDescription;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITServerPackage.LiveShowSPITObject;
import SPITServerPackage.SPIT_Type;
import SwingTextPackage.DocumentFilter_Time;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LiveShowSPITSettingsPanel
extends LiveShowObjectInterface.EffectPanel
implements LiveShowObjectListener,
DocumentListener,
FocusListener {
    @LiveLanguageString
    protected String m_Header;
    protected LiveShowObjectInterface.EffectPanelContainer m_EffectPanelContainer;
    protected LiveShowSPITObject m_LiveShowSPITObject;
    protected boolean m_SPITTypeManuallySet;
    protected boolean m_DelayManuallySet;
    protected boolean m_DurationManuallySet;
    protected boolean m_RemarkManuallySet;
    protected boolean m_InternalChange;
    protected boolean m_Changed_SPITType;
    protected KeyAdapter m_KeyAdapter;
    private JButton jButton_Resize;
    private JComboBox<SPIT_Type_Interface> jComboBox_SPIT_Types;
    private JLabel jLabel_Delay;
    private JLabel jLabel_Duration;
    private JLabel jLabel_Remark;
    private JTextField jTextField_Delay;
    private JTextField jTextField_Duration;
    private JTextField jTextField_Remark;

    public LiveShowSPITSettingsPanel() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private void initMembers() {
        this.m_Header = SPIT_TypeDescription.DEFAULTNAME;
        this.m_InternalChange = true;
        this.m_Changed_SPITType = false;
        this.m_SPITTypeManuallySet = false;
        this.m_DelayManuallySet = false;
        this.m_DurationManuallySet = false;
        this.m_RemarkManuallySet = false;
    }

    private void initComponents() {
        this.jComboBox_SPIT_Types = new JComboBox();
        this.jLabel_Duration = new JLabel();
        this.jTextField_Duration = new JTextField();
        this.jButton_Resize = new JButton();
        this.jLabel_Delay = new JLabel();
        this.jTextField_Delay = new JTextField();
        this.jTextField_Remark = new JTextField();
        this.jLabel_Remark = new JLabel();
        this.setMinimumSize(new Dimension(335, 100));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(100, 50));
        this.setLayout(new GridBagLayout());
        this.jComboBox_SPIT_Types.setToolTipText("Select a DMXEffect");
        this.jComboBox_SPIT_Types.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.jComboBox_SPIT_Types.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowSPITSettingsPanel.this.jComboBox_SPIT_TypesActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.jComboBox_SPIT_Types, gridBagConstraints);
        this.jLabel_Duration.setText("Duration");
        this.jLabel_Duration.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Duration, gridBagConstraints);
        this.jTextField_Duration.setFont(new Font("Tahoma", 0, 12));
        this.jTextField_Duration.setHorizontalAlignment(0);
        this.jTextField_Duration.setToolTipText("Enter the duration in milliseconds of the action");
        this.jTextField_Duration.setMinimumSize(new Dimension(85, 20));
        this.jTextField_Duration.setPreferredSize(new Dimension(85, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextField_Duration, gridBagConstraints);
        this.jButton_Resize.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Adjust.png")));
        this.jButton_Resize.setToolTipText("<html>Set the length of the object<br>to match the length of the effect</html>");
        this.jButton_Resize.setContentAreaFilled(false);
        this.jButton_Resize.setMargin(new Insets(2, 5, 2, 5));
        this.jButton_Resize.setMaximumSize(new Dimension(64, 32));
        this.jButton_Resize.setMinimumSize(new Dimension(64, 32));
        this.jButton_Resize.setPreferredSize(new Dimension(64, 32));
        this.jButton_Resize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowSPITSettingsPanel.this.jButton_ResizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.jButton_Resize, gridBagConstraints);
        this.jLabel_Delay.setText("Delay");
        this.jLabel_Delay.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Delay, gridBagConstraints);
        this.jTextField_Delay.setFont(new Font("Tahoma", 0, 12));
        this.jTextField_Delay.setHorizontalAlignment(0);
        this.jTextField_Delay.setToolTipText("Enter the delay in Milliseconds when the action should start");
        this.jTextField_Delay.setMinimumSize(new Dimension(85, 20));
        this.jTextField_Delay.setPreferredSize(new Dimension(85, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextField_Delay, gridBagConstraints);
        this.jTextField_Remark.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextField_Remark, gridBagConstraints);
        this.jLabel_Remark.setText("Remark");
        this.jLabel_Remark.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Remark, gridBagConstraints);
    }

    @Override
    public String getHeader() {
        return this.m_Header;
    }

    private void jComboBox_SPIT_TypesActionPerformed(ActionEvent evt) {
        this.changeSPIT_Type();
    }

    private void jButton_ResizeActionPerformed(ActionEvent evt) {
        if (this.m_LiveShowSPITObject == null) {
            return;
        }
        if (this.m_EffectPanelContainer == null) {
            return;
        }
        if (this.m_EffectPanelContainer != null && this.m_EffectPanelContainer.getSelectedUnit() == 1) {
            long longValue;
            try {
                longValue = Long.parseLong(this.jTextField_Delay.getText());
                longValue += Long.parseLong(this.jTextField_Duration.getText());
            }
            catch (Exception e) {
                longValue = this.m_LiveShowSPITObject.getDelay() + this.m_LiveShowSPITObject.getDuration();
            }
            this.m_EffectPanelContainer.setObjectLengthToEffectLength(longValue);
        } else {
            long longValue = (long)((double)DocumentFilter_Time.getMillisecondsFromString(this.jTextField_Delay.getText()) / LiveShowVIP.FRAMETIME);
            this.m_EffectPanelContainer.setObjectLengthToEffectLength(longValue += (long)((double)DocumentFilter_Time.getMillisecondsFromString(this.jTextField_Duration.getText()) / LiveShowVIP.FRAMETIME));
        }
    }

    private void initComponentsFurther() {
        this.m_KeyAdapter = new KeyAdapter(){
            long longValue;

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    LiveShowSPITSettingsPanel.this.correctText(evt.getSource());
                }
            }
        };
        this.jComboBox_SPIT_Types.setModel(SPIT_Type.s_SPITTypeListModel.createListModelWrapper());
        this.jComboBox_SPIT_Types.setRenderer((ListCellRenderer<SPIT_Type_Interface>)SPIT_Type.s_SPITTypeListRenderer);
        DocumentFilter_Time o_DocumentFilter_Time = new DocumentFilter_Time(this.jTextField_Delay);
        this.jTextField_Delay.setText(String.valueOf(0));
        this.jTextField_Delay.getDocument().addDocumentListener(this);
        this.jTextField_Delay.addKeyListener(this.m_KeyAdapter);
        this.jTextField_Delay.addFocusListener(this);
        o_DocumentFilter_Time = new DocumentFilter_Time(this.jTextField_Duration);
        this.jTextField_Duration.setText(String.valueOf(0));
        this.jTextField_Duration.getDocument().addDocumentListener(this);
        this.jTextField_Duration.addKeyListener(this.m_KeyAdapter);
        this.jTextField_Duration.addFocusListener(this);
        this.jTextField_Remark.setText(String.valueOf(0));
        this.jTextField_Remark.getDocument().addDocumentListener(this);
        this.jTextField_Remark.addKeyListener(this.m_KeyAdapter);
        this.jTextField_Remark.addFocusListener(this);
        this.jTextField_Delay.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTextField_Duration.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTextField_Remark.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Resize.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    @Override
    public void setLiveShowObject(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        if (!(p_LiveShowObjectInterface instanceof LiveShowSPITObject)) {
            return;
        }
        if (this.m_LiveShowSPITObject == p_LiveShowObjectInterface) {
            return;
        }
        this.m_SPITTypeManuallySet = false;
        this.m_DelayManuallySet = false;
        this.m_DurationManuallySet = false;
        this.m_RemarkManuallySet = false;
        if (this.m_LiveShowSPITObject != null) {
            this.m_LiveShowSPITObject.removeLiveShowObjectListener(this);
        }
        this.m_LiveShowSPITObject = (LiveShowSPITObject)p_LiveShowObjectInterface;
        if (this.m_LiveShowSPITObject != null) {
            this.m_LiveShowSPITObject.addLiveShowObjectListener(this);
        }
        this.refresh();
    }

    @Override
    public void setSelectedUnit(int p_SelectedUnit) {
    }

    @Override
    public void refresh() {
        SPIT_Type o_SPIT_Type_Interface;
        this.m_InternalChange = true;
        if (this.m_LiveShowSPITObject == null) {
            this.jComboBox_SPIT_Types.setEnabled(false);
            this.jTextField_Delay.setEnabled(false);
            this.jTextField_Duration.setEnabled(false);
            this.jTextField_Remark.setEnabled(false);
            this.jComboBox_SPIT_Types.setVisible(false);
            this.m_InternalChange = false;
            return;
        }
        this.jComboBox_SPIT_Types.setVisible(true);
        this.jComboBox_SPIT_Types.setEnabled(true);
        if (!this.m_SPITTypeManuallySet) {
            this.jComboBox_SPIT_Types.setSelectedItem(this.m_LiveShowSPITObject.getSPIT_Type());
        }
        this.m_Changed_SPITType = (o_SPIT_Type_Interface = (SPIT_Type)this.jComboBox_SPIT_Types.getSelectedItem()) != this.m_LiveShowSPITObject.getSPIT_Type();
        if (o_SPIT_Type_Interface == null) {
            this.jTextField_Delay.setEnabled(false);
            this.jTextField_Duration.setEnabled(false);
            this.jTextField_Remark.setEnabled(false);
            this.jButton_Resize.setEnabled(false);
        } else {
            long longValue;
            if (!this.m_DelayManuallySet) {
                longValue = this.m_LiveShowSPITObject.getDelay();
                if (this.m_EffectPanelContainer != null && this.m_EffectPanelContainer.getSelectedUnit() == 1) {
                    this.jTextField_Delay.setText(String.valueOf(longValue));
                } else {
                    this.jTextField_Delay.setText(DocumentFilter_Time.getTimeStringFromMillis((long)((double)longValue * LiveShowVIP.FRAMETIME)));
                }
                this.m_DelayManuallySet = false;
            }
            this.jTextField_Delay.setEnabled(true);
            if (!this.m_DurationManuallySet) {
                longValue = this.m_LiveShowSPITObject.getDuration();
                if (this.m_EffectPanelContainer != null && this.m_EffectPanelContainer.getSelectedUnit() == 1) {
                    this.jTextField_Duration.setText(String.valueOf(longValue));
                } else {
                    this.jTextField_Duration.setText(DocumentFilter_Time.getTimeStringFromMillis((long)((double)longValue * LiveShowVIP.FRAMETIME)));
                }
                this.m_DurationManuallySet = false;
            }
            this.jTextField_Duration.setEnabled(true);
            if (!this.m_RemarkManuallySet) {
                this.jTextField_Remark.setText(this.m_LiveShowSPITObject.getRemark());
                this.m_RemarkManuallySet = false;
            }
            this.jTextField_Remark.setEnabled(true);
            this.jButton_Resize.setEnabled(true);
        }
        this.m_InternalChange = false;
        if (this.m_EffectPanelContainer != null) {
            this.m_EffectPanelContainer.eventEffectChanged(this.getChanged());
        }
    }

    private void changeSPIT_Type() {
        SPIT_Type o_SPIT_Type_Interface = (SPIT_Type)this.jComboBox_SPIT_Types.getSelectedItem();
        if (this.m_LiveShowSPITObject != null) {
            if (o_SPIT_Type_Interface != this.m_LiveShowSPITObject.getSPIT_Type()) {
                this.m_Changed_SPITType = true;
                this.m_SPITTypeManuallySet = true;
            } else {
                this.m_Changed_SPITType = false;
                this.m_SPITTypeManuallySet = false;
            }
        }
        if (this.m_EffectPanelContainer != null) {
            this.m_EffectPanelContainer.eventEffectChanged(this.getChanged());
        }
        this.refresh();
    }

    @Override
    public void save() {
        if (this.getChanged()) {
            if (this.m_LiveShowSPITObject == null) {
                return;
            }
            if (this.m_Changed_SPITType) {
                SPIT_Type_Interface o_SPIT_Type_Interface = (SPIT_Type_Interface)this.jComboBox_SPIT_Types.getSelectedItem();
                this.m_LiveShowSPITObject.changeSPIT_Type(o_SPIT_Type_Interface);
            }
            if (this.m_EffectPanelContainer != null && this.m_EffectPanelContainer.getSelectedUnit() == 1) {
                try {
                    if (this.m_DelayManuallySet) {
                        this.m_LiveShowSPITObject.changeDelay(Long.parseLong(this.jTextField_Delay.getText()));
                    }
                    if (this.m_DurationManuallySet) {
                        this.m_LiveShowSPITObject.changeDuration(Long.parseLong(this.jTextField_Duration.getText()));
                    }
                }
                catch (Exception exception) {}
            } else {
                if (this.m_DelayManuallySet) {
                    this.m_LiveShowSPITObject.changeDelay((long)((double)DocumentFilter_Time.getMillisecondsFromString(this.jTextField_Delay.getText()) / LiveShowVIP.FRAMETIME));
                }
                if (this.m_DurationManuallySet) {
                    this.m_LiveShowSPITObject.changeDuration((long)((double)DocumentFilter_Time.getMillisecondsFromString(this.jTextField_Duration.getText()) / LiveShowVIP.FRAMETIME));
                }
            }
            if (this.m_RemarkManuallySet) {
                this.m_LiveShowSPITObject.changeRemark(this.jTextField_Remark.getText());
            }
        }
        this.m_SPITTypeManuallySet = false;
        this.m_DelayManuallySet = false;
        this.m_DurationManuallySet = false;
        this.m_RemarkManuallySet = false;
        this.refresh();
    }

    @Override
    public void cancel() {
        this.m_SPITTypeManuallySet = false;
        this.m_DelayManuallySet = false;
        this.m_DurationManuallySet = false;
        this.m_RemarkManuallySet = false;
        this.refresh();
    }

    public String getString(long p_Miliiseconds) {
        if (this.m_LiveShowSPITObject == null) {
            return "";
        }
        return DocumentFilter_Time.getTimeStringFromMillis(p_Miliiseconds);
    }

    @Override
    public boolean getChanged() {
        if (this.m_Changed_SPITType) {
            return true;
        }
        if (this.m_DelayManuallySet) {
            return true;
        }
        if (this.m_DurationManuallySet) {
            return true;
        }
        return this.m_RemarkManuallySet;
    }

    @Override
    public void setEffectPanelContainer(LiveShowObjectInterface.EffectPanelContainer p_EffectPanelContainer) {
        this.m_EffectPanelContainer = p_EffectPanelContainer;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedText(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedText(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.changedText(e);
    }

    private void changedText(DocumentEvent e) {
        if (this.m_LiveShowSPITObject == null) {
            return;
        }
        if (this.m_InternalChange) {
            return;
        }
        if (e.getDocument() == this.jTextField_Delay.getDocument()) {
            this.m_DelayManuallySet = true;
        } else if (e.getDocument() == this.jTextField_Duration.getDocument()) {
            this.m_DurationManuallySet = true;
        } else if (e.getDocument() == this.jTextField_Remark.getDocument() && !this.jTextField_Remark.getText().equals(this.m_LiveShowSPITObject.getRemark())) {
            this.m_RemarkManuallySet = true;
        }
        if (this.m_EffectPanelContainer != null) {
            this.m_EffectPanelContainer.eventEffectChanged(this.getChanged());
        }
    }

    @Override
    public void eventObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        this.refresh();
    }

    @Override
    public void eventObjectVolumeChanged(LiveShowObjectInterface p_LiveShowObjectInterface, float p_Volume) {
    }

    @Override
    public void eventObjectAdditionalChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
    }

    @Override
    public void eventObjectClosed(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == this.m_LiveShowSPITObject) {
            this.setLiveShowObject(null);
        }
    }

    @Override
    public void eventObjectSelection(LiveShowObjectInterface p_LiveShowObjectInterface, boolean p_IsSelected, boolean p_Added) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.correctText(e.getSource());
    }

    public void correctText(Object p_Object) {
        String stringNew;
        String stringOld;
        long longValue;
        if (p_Object == null) {
            return;
        }
        if (p_Object == this.jTextField_Delay) {
            if (this.m_EffectPanelContainer != null && this.m_EffectPanelContainer.getSelectedUnit() == 1) {
                try {
                    longValue = Long.parseLong(this.jTextField_Delay.getText());
                    if (this.m_LiveShowSPITObject != null && longValue == this.m_LiveShowSPITObject.getDelay()) {
                        this.m_DelayManuallySet = false;
                    }
                }
                catch (Exception e) {
                    if (this.m_LiveShowSPITObject != null) {
                        this.jTextField_Delay.setText(String.valueOf(this.m_LiveShowSPITObject.getDelay()));
                    } else {
                        this.jTextField_Delay.setText("0");
                    }
                    this.m_DelayManuallySet = false;
                }
            } else {
                stringOld = this.jTextField_Delay.getText();
                if (!stringOld.equals(stringNew = DocumentFilter_Time.getTimeStringFromMillis(longValue = DocumentFilter_Time.getMillisecondsFromString(this.jTextField_Delay.getText())))) {
                    this.jTextField_Delay.setText(DocumentFilter_Time.getTimeStringFromMillis(longValue));
                }
            }
        }
        if (p_Object == this.jTextField_Duration) {
            if (this.m_EffectPanelContainer != null && this.m_EffectPanelContainer.getSelectedUnit() == 1) {
                try {
                    longValue = Long.parseLong(this.jTextField_Duration.getText());
                    if (this.m_LiveShowSPITObject != null && longValue == this.m_LiveShowSPITObject.getDuration()) {
                        this.m_DurationManuallySet = false;
                    }
                }
                catch (Exception e) {
                    if (this.m_LiveShowSPITObject != null) {
                        this.jTextField_Duration.setText(String.valueOf(this.m_LiveShowSPITObject.getDuration()));
                    } else {
                        this.jTextField_Duration.setText("0");
                    }
                    this.m_DurationManuallySet = false;
                }
            } else {
                stringOld = this.jTextField_Duration.getText();
                if (!stringOld.equals(stringNew = DocumentFilter_Time.getTimeStringFromMillis(longValue = DocumentFilter_Time.getMillisecondsFromString(this.jTextField_Duration.getText())))) {
                    this.jTextField_Duration.setText(DocumentFilter_Time.getTimeStringFromMillis(longValue));
                }
            }
        }
    }
}

