/*
 * Decompiled with CFR 0.152.
 */
package MediaVirtualPackage;

import LiveShowObjectPackage.SinglePropertyChangeSupport;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowVIP;
import MediaObjectPackage.LiveShowMediaObjectDescription;
import MediaObjectPackage.MediaObject_PlayStatus;
import MediaObjectPackage.MediaSource;
import MediaPlayerPackage.FFmpegVideoAnalyzer;
import MediaPlayerPackage.LiveShow_MediaPlayer;
import MediaPlayerPackage.LiveShow_MediaPlayer_Image;
import MediaPlayerPackage.LiveShow_MediaPlayer_Text;
import MediaPlayerPackage.LiveShow_MediaPlayer_Video_FFmpeg;
import MediaToolsPackage.MediaSource_FileWatcher;
import MediaVirtualPackage.LiveShowMediaObject;
import MediaVirtualPackage.LiveShowMediaVIP;
import PlayMediaPackage.PlayMedia;
import SynchronizationPackage.LiveCloseSemaphore;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;

public class MediaSource_Client
extends MediaSource
implements LiveShow_MediaPlayer.MediaPlayerListener,
Playable,
MediaSource_FileWatcher.ChangeListener {
    private LiveShowMediaObject m_LiveShowMediaObject;
    private PlayMedia m_PlayMedia;
    private Play.PlaySynchronisizer m_PlaySynchronisizer;
    private LiveShow_MediaPlayer m_LiveShow_MediaPlayer_0;
    private BufferedImage m_SnapShotMiddle;
    private final Object m_SyncMediaPlayer = new Object();
    private LiveCloseSemaphore m_LiveCloseSemaphore;
    private SinglePropertyChangeSupport m_PropertyChangeSupport;

    public MediaSource_Client(File p_File) {
        super(p_File);
        this.initMembers();
        this.createLiveShow_MediaPlayer();
        LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = LiveShowMediaObjectDescription.poolGet();
        o_LiveShowMediaObjectDescription.setFrameStartOffset(0L);
        o_LiveShowMediaObjectDescription.setFrameLength(this.getLength_Frames());
        o_LiveShowMediaObjectDescription.setMediaType(this.getMediaType());
        o_LiveShowMediaObjectDescription.setCheckSum(super.getCheckSum());
        this.m_LiveShowMediaObject = new LiveShowMediaObject(this, o_LiveShowMediaObjectDescription);
        this.m_LiveShowMediaObject.setProducer("mediasourceclient");
        this.setLiveShowObject(this.m_LiveShowMediaObject);
        this.m_PlaySynchronisizer = new Play.PlaySynchronisizer();
        this.m_PlayMedia = new PlayMedia("mediasourceclient", this);
        this.m_PlayMedia.setPlaySynchronizer(this.m_PlaySynchronisizer);
        PlayMedia.MediaPlayObject o_MediaPlayObject = (PlayMedia.MediaPlayObject)this.m_PlayMedia.getPlayObject();
        o_MediaPlayObject.addLiveShowMediaObject(this.m_LiveShowMediaObject);
        MediaSource_FileWatcher.registerMediaSource((MediaSource)this);
    }

    private void initMembers() {
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_LiveShowMediaObject = null;
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
        this.m_SnapShotMiddle = null;
    }

    public void close() {
        LiveShow_MediaPlayer o_LiveShow_MediaPlayer_0;
        MediaSource_FileWatcher.unregisterMediaSource((MediaSource)this);
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        super.close();
        if (this.m_PlayMedia != null) {
            PlayMedia.MediaPlayObject o_MediaPlayObject = (PlayMedia.MediaPlayObject)this.m_PlayMedia.getPlayObject();
            o_MediaPlayObject.removeLiveShowMediaObject(this.m_LiveShowMediaObject);
            this.m_PlayMedia.close();
            this.m_PlayMedia = null;
        }
        if (this.m_PlaySynchronisizer != null) {
            this.m_PlaySynchronisizer.close();
        }
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange("liveShowObject_SourceClose", this, null);
            this.m_PropertyChangeSupport.clear();
        }
        if ((o_LiveShow_MediaPlayer_0 = this.m_LiveShow_MediaPlayer_0) != null) {
            this.m_LiveShow_MediaPlayer_0 = null;
            o_LiveShow_MediaPlayer_0.removeMediaPlayerListener((LiveShow_MediaPlayer.MediaPlayerListener)this);
            o_LiveShow_MediaPlayer_0.close();
            o_LiveShow_MediaPlayer_0 = null;
        }
        if (this.m_LiveShowMediaObject != null) {
            this.m_LiveShowMediaObject.close(true);
            this.m_LiveShowMediaObject = null;
        }
        this.m_LiveCloseSemaphore.leaveCloseSection();
    }

    public void refresh() {
        LiveShow_MediaPlayer o_LiveShow_MediaPlayer_0 = this.m_LiveShow_MediaPlayer_0;
        if (o_LiveShow_MediaPlayer_0 != null) {
            o_LiveShow_MediaPlayer_0.removeMediaPlayerListener((LiveShow_MediaPlayer.MediaPlayerListener)this);
            o_LiveShow_MediaPlayer_0.close();
            o_LiveShow_MediaPlayer_0 = null;
        }
        this.m_LiveShow_MediaPlayer_0 = null;
        this.createCheckSum();
        o_LiveShow_MediaPlayer_0 = this.createLiveShow_MediaPlayer();
        if (o_LiveShow_MediaPlayer_0 != null) {
            o_LiveShow_MediaPlayer_0.load();
        }
        this.notifyListener_Refreshing();
    }

    public PlayMedia getPlay() {
        return this.m_PlayMedia;
    }

    public long setFramePlayCursor(long p_FramePosition) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return 0L;
        }
        LiveShowMediaObject o_LiveShowMediaObject = this.m_LiveShowMediaObject;
        if (o_LiveShowMediaObject != null) {
            LiveShow_MediaPlayer o_LiveShow_MediaPlayer;
            PlayMedia o_Play;
            if (p_FramePosition < o_LiveShowMediaObject.getFrameStartOffset()) {
                p_FramePosition = o_LiveShowMediaObject.getFrameStartOffset();
            }
            if (p_FramePosition > o_LiveShowMediaObject.getFrameStartOffset() + o_LiveShowMediaObject.getFrameLength()) {
                p_FramePosition = o_LiveShowMediaObject.getFrameStartOffset() + o_LiveShowMediaObject.getFrameLength();
            }
            if ((o_Play = this.m_PlayMedia) != null) {
                ((Play)o_Play).setPlayCursor(p_FramePosition);
            }
            if ((o_LiveShow_MediaPlayer = this.m_LiveShow_MediaPlayer_0) != null) {
                o_LiveShow_MediaPlayer.setPlayStatus(o_LiveShow_MediaPlayer.getFade(), o_LiveShow_MediaPlayer.getSoundVolume(), (long)((double)p_FramePosition * this.getFrameTime() + 0.5), o_LiveShow_MediaPlayer.isPlaying(), this.m_LiveShowMediaObject.isCursorPositionInside(p_FramePosition));
            }
        } else {
            p_FramePosition = 0L;
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return p_FramePosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LiveShow_MediaPlayer createLiveShow_MediaPlayer() {
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            if (this.m_LiveShow_MediaPlayer_0 == null) {
                if (this.getMediaType() == 1001) {
                    this.m_LiveShow_MediaPlayer_0 = LiveShow_MediaPlayer_Image.poolGet((MediaSource)this);
                    this.m_LiveShow_MediaPlayer_0.setName("Image");
                } else if (this.getMediaType() == 1002) {
                    this.m_LiveShow_MediaPlayer_0 = new LiveShow_MediaPlayer_Video_FFmpeg((MediaSource)this);
                    this.m_LiveShow_MediaPlayer_0.setName("Video");
                } else if (this.getMediaType() == 1003) {
                    this.m_LiveShow_MediaPlayer_0 = LiveShow_MediaPlayer_Text.poolGet((MediaSource)this);
                    this.m_LiveShow_MediaPlayer_0.setName("Text");
                    this.m_LiveShow_MediaPlayer_0.load();
                }
                if (this.m_LiveShow_MediaPlayer_0 != null) {
                    this.m_LiveShow_MediaPlayer_0.addMediaPlayerListener((LiveShow_MediaPlayer.MediaPlayerListener)this);
                }
            }
            return this.m_LiveShow_MediaPlayer_0;
        }
    }

    public LiveShow_MediaPlayer getLiveShow_MediaPlayer() {
        return this.m_LiveShow_MediaPlayer_0;
    }

    public long getLength_Milliseconds() {
        LiveShow_MediaPlayer o_LiveShow_MediaPlayer = this.m_LiveShow_MediaPlayer_0;
        if (o_LiveShow_MediaPlayer == null) {
            return -1L;
        }
        return o_LiveShow_MediaPlayer.getLength();
    }

    public long getLength_Frames() {
        LiveShow_MediaPlayer o_LiveShow_MediaPlayer = this.m_LiveShow_MediaPlayer_0;
        if (o_LiveShow_MediaPlayer == null) {
            return -1L;
        }
        if (this.getFrameTime() <= 0.0) {
            return 0L;
        }
        return (long)((double)o_LiveShow_MediaPlayer.getLength() / this.getFrameTime() + 0.5);
    }

    public LiveShowMediaObject getLiveShowMediaObject() {
        return this.m_LiveShowMediaObject;
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public void eventReady(LiveShow_MediaPlayer p_LiveShow_MediaPlayer, boolean p_MediaReady) {
        if (this.m_LiveShowMediaObject != null && this.m_LiveShowMediaObject.getFrameLength() <= 0L) {
            this.m_LiveShowMediaObject.setFrameLength((long)((double)p_LiveShow_MediaPlayer.getLength() / LiveShowMediaVIP.getFRAMETIME()));
        }
    }

    public void eventError(LiveShow_MediaPlayer p_LiveShow_MediaPlayer, String p_ErrorString) {
    }

    public void eventClose(LiveShow_MediaPlayer p_LiveShow_MediaPlayer) {
    }

    public void analyzeVideo() {
        if (this.getMediaType() != 1002) {
            return;
        }
        if (this.getVideoAnalyzed()) {
            return;
        }
        if (s_VideoAnalyzer_ON) {
            FFmpegVideoAnalyzer.VideoAnalyzerResult o_VideoAnalyzerResult = FFmpegVideoAnalyzer.analyzeVideo((File)this.getFile(), (String)"liveSHOW");
            this.setVideoAnalyzed(true);
            if (!o_VideoAnalyzerResult.getVideoOK() || !o_VideoAnalyzerResult.getAudioOK()) {
                FFmpegVideoAnalyzer.showWarningDialog((FFmpegVideoAnalyzer.VideoAnalyzerResult)o_VideoAnalyzerResult);
            }
        }
    }

    @Override
    public Playable.PlayObject read(Play p_Play, Playable.PlayObject p_PlayObject) {
        if (p_PlayObject == null) {
            return null;
        }
        if (p_PlayObject.getData() == null) {
            return null;
        }
        MediaObject_PlayStatus.ObjectPlayStatus o_ObjectPlayStatus = null;
        boolean boolInsideObject = false;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveShowMediaObject o_LiveShowMediaObject = this.m_LiveShowMediaObject;
        Playable.PlayObject o_PlayObject = o_LiveShowMediaObject != null ? o_LiveShowMediaObject.read(p_Play, p_PlayObject, null, -1L, 1.0, false) : null;
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        LiveShow_MediaPlayer o_LiveShow_MediaPlayer = this.m_LiveShow_MediaPlayer_0;
        if (o_PlayObject != null && this.m_LiveShowMediaObject != null) {
            o_ObjectPlayStatus = ((PlayMedia.MediaPlayObject)o_PlayObject).getObjectPlayStatus(this.m_LiveShowMediaObject.getID());
        }
        if (o_LiveShow_MediaPlayer != null) {
            if (o_ObjectPlayStatus != null) {
                MediaObject_PlayStatus.ObjectPlayStatusPlayer o_ObjectPlayStatusPlayer = o_ObjectPlayStatus.getObjectPlayStatusPlayer();
                o_LiveShow_MediaPlayer.setPlayStatus((float)(o_ObjectPlayStatusPlayer.getFadeFactor() * (double)o_ObjectPlayStatusPlayer.getVolumeFactor()), (float)((double)this.m_LiveShowMediaObject.getMediaSoundVolume() * o_ObjectPlayStatusPlayer.getFadeFactor()), (long)((double)o_ObjectPlayStatusPlayer.getMediaPositionFrame() * this.getFrameTime() + 0.5), o_ObjectPlayStatusPlayer.getIsPlaying(), this.m_LiveShowMediaObject.isCursorPositionInside(p_Play.getPlayCursor()));
            } else {
                o_LiveShow_MediaPlayer.setPlayStatus(0.0f, 0.0f, 0L, false, false);
            }
        }
        return o_PlayObject;
    }

    @Override
    public Playable.PlayObject readInternal(Play p_Play, Playable.PlayObject p_PlayObject, LiveShowSceneBridge p_LiveShowSceneBridge, long p_SceneBridgeFrameInside, double p_SceneBridgeFadeProgress, boolean p_IsPreObject) {
        return p_PlayObject;
    }

    @Override
    public boolean getActive() {
        return true;
    }

    @Override
    public long getFrameStart() {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return 0L;
        }
        LiveShowMediaObject o_LiveShowMediaObject = this.m_LiveShowMediaObject;
        long longPosition = o_LiveShowMediaObject != null ? o_LiveShowMediaObject.getFrameStart() : 0L;
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return longPosition;
    }

    @Override
    public long getFrameEnd() {
        long longPosition = 0L;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return 0L;
        }
        LiveShowMediaObject o_LiveShowMediaObject = this.m_LiveShowMediaObject;
        longPosition = o_LiveShowMediaObject != null ? o_LiveShowMediaObject.getFrameStart() + o_LiveShowMediaObject.getFrameLength() : 0L;
        if (longPosition < 0L) {
            longPosition = 0L;
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return longPosition;
    }

    @Override
    public long getFrameEndToPlay() {
        return this.getFrameEnd();
    }

    @Override
    public boolean setFadeOutDirect(long p_ActualFramePlay, double p_FadeInProgress, double p_FadeOutProgress) {
        return false;
    }

    @Override
    public void resetFadeOutDirect() {
    }

    @Override
    public long getFrameLength_FadeOutDirect() {
        return 0L;
    }

    public long getFrameLength() {
        long longFrameLength = 0L;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return 0L;
        }
        LiveShowMediaObject o_LiveShowMediaObject = this.m_LiveShowMediaObject;
        if (o_LiveShowMediaObject != null) {
            longFrameLength = o_LiveShowMediaObject.getFrameLength();
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return longFrameLength;
    }

    @Override
    public double getFrameTime() {
        return LiveShowVIP.FRAMETIME;
    }

    @Override
    public long findFramePosition_FadeIn(double p_FadeProgress) {
        LiveShowMediaObject o_LiveShowMediaObject = this.m_LiveShowMediaObject;
        if (o_LiveShowMediaObject == null) {
            return 0L;
        }
        return o_LiveShowMediaObject.findFramePosition_FadeIn(p_FadeProgress);
    }

    @Override
    public long findFramePosition_FadeOut(double p_FadeProgress) {
        LiveShowMediaObject o_LiveShowMediaObject = this.m_LiveShowMediaObject;
        if (o_LiveShowMediaObject == null) {
            return 0L;
        }
        return o_LiveShowMediaObject.findFramePosition_FadeOut(p_FadeProgress);
    }

    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_Cursor() {
        return null;
    }

    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_EditCursor() {
        return null;
    }

    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_Actual() {
        return null;
    }

    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_Next(long p_FramePosition, boolean p_OnlyMainBridges, boolean p_OnlyActiveBridges) {
        return null;
    }

    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_NextToPlay(long p_StartFrame, boolean p_OnlyMainScenes) {
        return null;
    }

    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_Previous(long p_FramePosition, boolean p_OnlyMainBridges, boolean p_OnlyActiveBridges) {
        return null;
    }

    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_PreviousToPlay(long p_StartFrame, boolean p_OnlyMainScenes) {
        return null;
    }

    @Override
    public void gotoSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_Friends, boolean p_JumpInternal) {
    }

    @Override
    public ImageIcon getImageIcon() {
        return s_Icon;
    }

    @Override
    public void eventPlayStart(Play p_Play) {
    }

    @Override
    public void eventPlayStop(Play p_Play) {
        LiveShow_MediaPlayer o_LiveShow_MediaPlayer = this.m_LiveShow_MediaPlayer_0;
        if (o_LiveShow_MediaPlayer != null) {
            LiveShowMediaObject o_LiveShowMediaObject = this.m_LiveShowMediaObject;
            if (o_LiveShowMediaObject != null) {
                o_LiveShow_MediaPlayer.setPlayStatus(o_LiveShow_MediaPlayer.getFade(), 0.0f, (long)((double)o_LiveShowMediaObject.getFrameStartOffset() * this.getFrameTime() + 0.5), false, o_LiveShowMediaObject.isCursorPositionInside(p_Play.getPlayCursor()));
            } else {
                o_LiveShow_MediaPlayer.setPlayStatus(o_LiveShow_MediaPlayer.getFade(), 0.0f, 0L, false, false);
            }
        }
    }

    @Override
    public void eventPlayPause(Play p_Play) {
        LiveShow_MediaPlayer o_LiveShow_MediaPlayer = this.m_LiveShow_MediaPlayer_0;
        if (o_LiveShow_MediaPlayer != null) {
            LiveShowMediaObject o_LiveShowMediaObject = this.m_LiveShowMediaObject;
            if (o_LiveShowMediaObject != null) {
                o_LiveShow_MediaPlayer.setPlayStatus(o_LiveShow_MediaPlayer.getFade(), o_LiveShow_MediaPlayer.getSoundVolume(), (long)((double)p_Play.getPlayCursor() * this.getFrameTime() + 0.5), false, o_LiveShowMediaObject.isCursorPositionInside(p_Play.getPlayCursor()));
            } else {
                o_LiveShow_MediaPlayer.setPlayStatus(0.0f, 0.0f, 0L, false, false);
            }
        }
    }

    @Override
    public void eventPlayRewind(Play p_Play) {
    }

    @Override
    public void eventPlayFastForward(Play p_Play) {
    }

    @Override
    public void eventPlayFadePossibility(Play p_Play, boolean p_FadeInPossible, boolean p_FadeOutPossible, double p_FadeProgress) {
    }

    @Override
    public void eventPlayFadedIn(Play p_Play, boolean p_FadedIn, double p_FadeProgress) {
    }

    @Override
    public long eventPlayCheckRead(Play p_Play, long p_FrameStart, long p_FramesToRead) {
        return p_FramesToRead;
    }

    @Override
    public void eventEditModeOn(Play p_Play, boolean p_EditModeOn) {
    }

    @Override
    public void eventEditCursorSet(Play p_Play, long p_PlayCursor) {
    }

    @Override
    public void eventPlayCursorSet(Play p_Play, long p_PlayCursor) {
    }

    @Override
    public void eventPlayCursor(Play p_Play, long p_OldPlayCursor, long p_PlayCursor) {
    }

    @Override
    public void eventPlayClosing(Play p_Play) {
    }

    @Override
    public void eventPlayError(Play p_Play, Exception p_Exception, String p_Remark) {
    }

    @Override
    public void eventPlayTimelineEnd(Play p_Play) {
    }

    public void eventMediaSource_Changed(MediaSource p_MediaSource) {
        if (p_MediaSource != this) {
            return;
        }
        MediaSource_Client o_MediaSource_Client = (MediaSource_Client)p_MediaSource;
        o_MediaSource_Client.refresh();
    }

    public void eventMediaSource_Deleted(MediaSource p_MediaSource) {
        if (p_MediaSource != this) {
            return;
        }
        MediaSource_Client o_MediaSource_Client = (MediaSource_Client)p_MediaSource;
        o_MediaSource_Client.close();
    }
}

