/*
 * Decompiled with CFR 0.152.
 */
package MediaVirtualPackage;

import Icons.IconManager;
import LiveShowNotificationPackage.LiveShowNotification;
import LiveShowObjectPackage.LiveShowDragDrop;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectListener;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowSceneBridgeMain;
import LiveShowVirtualPackage.LiveShowTimer;
import LiveShowVirtualPackage.LiveShowVIP;
import LiveShowVirtualPackage.LiveShowVIPTrack;
import LiveShowVirtualPackage.LiveShow_ExportDescription;
import LiveShowVirtualPackage.LiveShow_ImportDescription;
import MediaObjectPackage.LiveShowMediaObjectDescription;
import MediaObjectPackage.MediaSource;
import MediaPackage.MediaServer;
import MediaVirtualPackage.LiveShowMediaObject;
import MediaVirtualPackage.LiveShowMediaSceneBridge;
import MediaVirtualPackage.LiveShowMediaVIPTrack;
import PlayMediaPackage.PlayMedia;
import SPITLibraryPackage.SPIT_Message;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITServerPackage.LiveShowSPITObject;
import SPITServerPackage.LiveShowSPITObjectDescription;
import SPITServerPackage.SPITServer_Client;
import SPITServerPackage.SPIT_Type;
import StartPackage.LiveShowMediaSystem;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class LiveShowMediaVIP
extends LiveShowVIP
implements Externalizable,
LiveShowObjectListener,
MediaServer.MediaRefreshListener {
    public static final int SOFTWAREVERSION = 2;
    public static final String FILESUFFIX_MEDIA = ".lmv";
    public static final String FILESUFFIX_SPIT = ".spi";
    public static ImageIcon s_Icon = IconManager.getImageIcon("Media.png");
    private final Object m_SyncPlay = new Object();
    public static Exception s_LoadException = null;

    public LiveShowMediaVIP(boolean p_Create) {
        this.initMembers();
        if (p_Create) {
            this.initializeVIP();
        }
    }

    public void initializeVIP() {
        this.createPlay();
        for (int intVipTrack = 0; intVipTrack < DEFAULT_TRACKSCOUNT; ++intVipTrack) {
            this.createLiveShowVipTrack();
        }
        LiveShowTimer.selfReference().addLiveShowVIP(this);
        this.notifyLiveShowVIPListeners_MaxFrame(this.getFramePositionMax());
    }

    public void createPlay() {
        if (this.m_Play != null) {
            this.m_Play.close();
        }
        this.m_Play = new PlayMedia("vip", this);
        this.m_Play.createOutputLine();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeExternal_Objects_Media(ObjectOutput out, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ExportDescription p_LiveShowExportDescription) throws IOException {
        LiveShowObjectInterface o_LiveShowObjectInterface;
        if (out == null) {
            return false;
        }
        out.writeInt(2);
        out.writeBoolean(this.m_Active);
        LiveShowNotification o_LiveShowNotification = null;
        int intVipTrackCount = this.m_LiveShowVIPTracks.size();
        ArrayList<LiveShowSceneBridge> o_ArrayListSceneBridges = new ArrayList<LiveShowSceneBridge>();
        ArrayList<LiveShowObjectInterface> o_ArrayListObjects = new ArrayList<LiveShowObjectInterface>();
        Object object = this.m_SyncObjects;
        synchronized (object) {
            Object[] o_SceneBridges = this.m_SceneBridges.toArray();
            for (int intSceneBridge = 0; intSceneBridge < o_SceneBridges.length; ++intSceneBridge) {
                LiveShowSceneBridge o_LiveShowSceneBridge = (LiveShowSceneBridge)o_SceneBridges[intSceneBridge];
                if (o_LiveShowSceneBridge == null || !p_LiveShowExportDescription.getSaveProject() && !p_LiveShowExportDescription.getExportProjectAll() && !o_LiveShowSceneBridge.getSelected()) continue;
                o_ArrayListSceneBridges.add(o_LiveShowSceneBridge);
            }
            Object[] o_Objects = this.m_LiveShowObjects.toArray();
            for (int intObject = 0; intObject < o_Objects.length; ++intObject) {
                o_LiveShowObjectInterface = (LiveShowObjectInterface)o_Objects[intObject];
                if (o_LiveShowObjectInterface == null || !(o_LiveShowObjectInterface instanceof LiveShowMediaObject) || o_LiveShowObjectInterface instanceof LiveShowSceneBridge || !p_LiveShowExportDescription.getSaveProject() && !p_LiveShowExportDescription.getExportProjectAll() && !o_LiveShowObjectInterface.getSelected()) continue;
                o_ArrayListObjects.add(o_LiveShowObjectInterface);
            }
        }
        if (!p_LiveShowExportDescription.getSaveProject() && !p_LiveShowExportDescription.getExportProjectAll() && o_ArrayListSceneBridges.size() <= 0 && o_ArrayListObjects.size() <= 0) {
            return false;
        }
        if (this.m_LiveShowNotification != null) {
            o_LiveShowNotification = new LiveShowNotification(this.m_LiveShowNotification, "-", (long)o_ArrayListObjects.size(), 0L);
        }
        out.writeInt(intVipTrackCount);
        out.writeInt(o_ArrayListSceneBridges.size());
        for (int intMediaObject = 0; intMediaObject < o_ArrayListSceneBridges.size(); ++intMediaObject) {
            o_LiveShowObjectInterface = (LiveShowObjectInterface)o_ArrayListSceneBridges.get(intMediaObject);
            o_LiveShowObjectInterface.getDescription().writeExternal(out);
            p_LiveShowExportDescription.addLiveShowSceneBridge(this, (LiveShowSceneBridge)o_LiveShowObjectInterface);
        }
        out.writeInt(o_ArrayListObjects.size());
        int intMediaObjectCount = 0;
        for (int intMediaObject = 0; intMediaObject < o_ArrayListObjects.size(); ++intMediaObject) {
            o_LiveShowObjectInterface = (LiveShowObjectInterface)o_ArrayListObjects.get(intMediaObject);
            if (o_LiveShowObjectInterface instanceof LiveShowSceneBridge) continue;
            if (o_LiveShowNotification != null) {
                o_LiveShowNotification.setText(o_LiveShowObjectInterface.getDescription().getSourceString());
            }
            if (p_LiveShowExportDescription.getSaveProject()) {
                o_LiveShowObjectInterface.getDescription().writeExternal(out);
            } else if (!LiveShowMediaSystem.exportLiveShowMediaObject(out, (LiveShowMediaObject)o_LiveShowObjectInterface, p_LiveShowProjectDescription)) {
                // empty if block
            }
            p_LiveShowExportDescription.addLiveShowObject(this, o_LiveShowObjectInterface);
            ++intMediaObjectCount;
            if (o_LiveShowNotification == null) continue;
            o_LiveShowNotification.setProgress(intMediaObjectCount);
        }
        if (o_LiveShowNotification != null) {
            o_LiveShowNotification.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeExternal_Objects_SPIT(ObjectOutput out, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ExportDescription p_LiveShowExportDescription) throws IOException {
        if (out == null) {
            return false;
        }
        out.writeInt(2);
        LiveShowNotification o_LiveShowNotification = null;
        ArrayList<LiveShowObjectInterface> o_ArrayListObjects = new ArrayList<LiveShowObjectInterface>();
        ArrayList<SPIT_Type_Interface> o_ArrayListSPITType_Interfaces = new ArrayList<SPIT_Type_Interface>();
        boolean boolWritten = true;
        try {
            SPIT_Type o_SPIT_Type;
            SPIT_Type_Interface o_SPIT_Type_Interface;
            LiveShowSPITObject o_LiveShowSPITObject;
            LiveShowObjectInterface o_LiveShowObjectInterface;
            Object object = this.m_SyncObjects;
            synchronized (object) {
                Object[] o_Objects = this.m_LiveShowObjects.toArray();
                for (int intObject = 0; intObject < o_Objects.length; ++intObject) {
                    o_LiveShowObjectInterface = (LiveShowObjectInterface)o_Objects[intObject];
                    if (o_LiveShowObjectInterface == null || !(o_LiveShowObjectInterface instanceof LiveShowSPITObject) || o_LiveShowObjectInterface instanceof LiveShowSceneBridge || !p_LiveShowExportDescription.getSaveProject() && !p_LiveShowExportDescription.getExportProjectAll() && !o_LiveShowObjectInterface.getSelected()) continue;
                    o_LiveShowSPITObject = (LiveShowSPITObject)o_LiveShowObjectInterface;
                    o_ArrayListObjects.add(o_LiveShowObjectInterface);
                    if (p_LiveShowExportDescription.getSaveProject() || p_LiveShowExportDescription.getExportProjectAll() || (o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(o_LiveShowSPITObject.getSPITTypeID())) == null || o_ArrayListSPITType_Interfaces.contains(o_SPIT_Type_Interface)) continue;
                    o_ArrayListSPITType_Interfaces.add(o_SPIT_Type_Interface);
                }
            }
            int intJingleCount = p_LiveShowExportDescription.getLiveShowJingleObjectCount(this);
            for (int intJingle = 0; intJingle < intJingleCount; ++intJingle) {
                o_LiveShowObjectInterface = p_LiveShowExportDescription.getLiveShowJingleObject(this, intJingle);
                if (o_LiveShowObjectInterface == null || !(o_LiveShowObjectInterface instanceof LiveShowSPITObject) || (o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type((o_LiveShowSPITObject = (LiveShowSPITObject)o_LiveShowObjectInterface).getSPITTypeID())) == null || o_ArrayListSPITType_Interfaces.contains(o_SPIT_Type_Interface)) continue;
                o_ArrayListSPITType_Interfaces.add(o_SPIT_Type_Interface);
            }
            if (!p_LiveShowExportDescription.getSaveProject() && !p_LiveShowExportDescription.getExportProjectAll()) {
                if (o_ArrayListObjects.size() <= 0 && o_ArrayListSPITType_Interfaces.size() <= 0) {
                    return false;
                }
            } else {
                Object[] o_SPIT_Types = SPIT_Type.getSPIT_Types();
                for (int intSPITType = 0; intSPITType < o_SPIT_Types.length; ++intSPITType) {
                    o_SPIT_Type = (SPIT_Type)o_SPIT_Types[intSPITType];
                    if (o_SPIT_Type == null || o_ArrayListSPITType_Interfaces.contains(o_SPIT_Type)) continue;
                    o_ArrayListSPITType_Interfaces.add(o_SPIT_Type);
                }
            }
            if (this.m_LiveShowNotification != null) {
                o_LiveShowNotification = new LiveShowNotification(this.m_LiveShowNotification, "SPIT", (long)o_ArrayListObjects.size(), 0L);
            }
            out.writeInt(o_ArrayListSPITType_Interfaces.size());
            for (int intSPIT_Type = 0; intSPIT_Type < o_ArrayListSPITType_Interfaces.size(); ++intSPIT_Type) {
                o_SPIT_Type = (SPIT_Type)o_ArrayListSPITType_Interfaces.get(intSPIT_Type);
                o_SPIT_Type.writeExternal(out);
            }
            out.writeInt(o_ArrayListObjects.size());
            int intMediaObjectCount = 0;
            for (int intMediaObject = 0; intMediaObject < o_ArrayListObjects.size(); ++intMediaObject) {
                o_LiveShowObjectInterface = (LiveShowObjectInterface)o_ArrayListObjects.get(intMediaObject);
                if (o_LiveShowObjectInterface instanceof LiveShowSceneBridge) continue;
                if (o_LiveShowNotification != null) {
                    o_LiveShowNotification.setText(o_LiveShowObjectInterface.getDescription().getSourceString());
                }
                o_LiveShowObjectInterface.getDescription().writeExternal(out);
                p_LiveShowExportDescription.addLiveShowObject(this, o_LiveShowObjectInterface);
                ++intMediaObjectCount;
                if (o_LiveShowNotification == null) continue;
                o_LiveShowNotification.setProgress(intMediaObjectCount);
            }
        }
        catch (Exception e) {
            boolWritten = false;
        }
        if (o_LiveShowNotification != null) {
            o_LiveShowNotification.close();
        }
        return boolWritten;
    }

    @Override
    public long getDiskSpaceEstimated(File p_ExportDirectory, boolean p_OnlySelectedObjects, ArrayList<Object> p_SourceObjects) {
        long longBytesCount = 0L;
        File o_ExportDirectoryMediaFiles = null;
        if (p_ExportDirectory != null) {
            o_ExportDirectoryMediaFiles = new File(p_ExportDirectory.getAbsolutePath() + LiveShowMediaSystem.FILENAME_MEDIADIRECTORY);
        }
        longBytesCount += 4L;
        ++longBytesCount;
        longBytesCount += 4L;
        longBytesCount += 4L;
        longBytesCount += 4L;
        Object[] o_Objects = this.m_LiveShowObjects.toArray();
        for (int intObject = 0; intObject < o_Objects.length; ++intObject) {
            LiveShowObjectInterface o_LiveShowObjectInterface = (LiveShowObjectInterface)o_Objects[intObject];
            if (p_OnlySelectedObjects && !o_LiveShowObjectInterface.getSelected()) continue;
            if (o_LiveShowObjectInterface instanceof LiveShowSceneBridge) {
                longBytesCount += o_LiveShowObjectInterface.getDiskSpaceEstimated();
                continue;
            }
            if (o_LiveShowObjectInterface instanceof LiveShowMediaObject) {
                longBytesCount += o_LiveShowObjectInterface.getDiskSpaceEstimated();
                MediaSource o_MediaSource = ((LiveShowMediaObject)o_LiveShowObjectInterface).getMediaSource();
                if (o_MediaSource == null || p_SourceObjects != null && p_SourceObjects.contains(o_MediaSource)) continue;
                longBytesCount += o_MediaSource.getDiskSpaceEstimated(o_ExportDirectoryMediaFiles);
                if (p_SourceObjects == null) continue;
                p_SourceObjects.add(o_MediaSource);
                continue;
            }
            if (!(o_LiveShowObjectInterface instanceof LiveShowSPITObject)) continue;
            longBytesCount += o_LiveShowObjectInterface.getDiskSpaceEstimated();
        }
        return longBytesCount;
    }

    public static boolean saveMediaVIP(LiveShowMediaVIP o_LiveShowMediaVIP, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ExportDescription p_LiveShowExportDescription) {
        boolean boolError_Media = LiveShowMediaVIP.saveMediaObjects(o_LiveShowMediaVIP, p_LiveShowProjectDescription, p_LiveShowExportDescription);
        boolean boolError_SPIT = LiveShowMediaVIP.saveSPITObjects(o_LiveShowMediaVIP, p_LiveShowProjectDescription, p_LiveShowExportDescription);
        return boolError_Media || boolError_SPIT;
    }

    public static boolean saveMediaObjects(LiveShowMediaVIP o_LiveShowMediaVIP, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ExportDescription p_LiveShowExportDescription) {
        if (o_LiveShowMediaVIP == null) {
            return false;
        }
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        FileOutputStream o_OutputStream = null;
        ObjectOutputStream o_ObjectOutput = null;
        boolean boolHasSomething = true;
        boolean boolError = false;
        File o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX_MEDIA);
        if (o_File.exists()) {
            o_File.delete();
        }
        try {
            o_OutputStream = new FileOutputStream(o_File);
            o_ObjectOutput = new ObjectOutputStream(o_OutputStream);
            o_ObjectOutput.writeInt(2);
            MediaServer.saveMediaServers(p_LiveShowProjectDescription);
            boolHasSomething = o_LiveShowMediaVIP.writeExternal_Objects_Media(o_ObjectOutput, p_LiveShowProjectDescription, p_LiveShowExportDescription);
            o_ObjectOutput.close();
            ((OutputStream)o_OutputStream).close();
            if (!boolHasSomething) {
                LiveShowMediaVIP.deleteMediaVIP(o_LiveShowMediaVIP, p_LiveShowProjectDescription);
            }
        }
        catch (Exception e) {
            boolError = true;
            System.out.println("Error cannot write LiveShowMediaVIP: " + o_File.getAbsolutePath());
            try {
                if (o_ObjectOutput != null) {
                    o_ObjectOutput.close();
                }
                if (o_OutputStream != null) {
                    ((OutputStream)o_OutputStream).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return boolError;
    }

    public static boolean saveSPITObjects(LiveShowMediaVIP o_LiveShowMediaVIP, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ExportDescription p_LiveShowExportDescription) {
        if (o_LiveShowMediaVIP == null) {
            return false;
        }
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        FileOutputStream o_OutputStream = null;
        ObjectOutputStream o_ObjectOutput = null;
        boolean boolHasSomething = true;
        boolean boolError = false;
        File o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX_SPIT);
        if (o_File.exists()) {
            o_File.delete();
        }
        try {
            o_OutputStream = new FileOutputStream(o_File);
            o_ObjectOutput = new ObjectOutputStream(o_OutputStream);
            o_ObjectOutput.writeInt(2);
            boolHasSomething = o_LiveShowMediaVIP.writeExternal_Objects_SPIT(o_ObjectOutput, p_LiveShowProjectDescription, p_LiveShowExportDescription);
            o_ObjectOutput.close();
            ((OutputStream)o_OutputStream).close();
            if (!boolHasSomething) {
                LiveShowMediaVIP.deleteSPITVIP(o_LiveShowMediaVIP, p_LiveShowProjectDescription);
            }
        }
        catch (Exception e) {
            boolError = true;
            System.out.println("Error cannot write LiveShowMediaVIP: " + o_File.getAbsolutePath());
            try {
                if (o_ObjectOutput != null) {
                    o_ObjectOutput.close();
                }
                if (o_OutputStream != null) {
                    ((OutputStream)o_OutputStream).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return boolError;
    }

    private static boolean deleteMediaVIP(LiveShowMediaVIP p_LiveShowMediaVIP, LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowMediaVIP == null) {
            return false;
        }
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        boolean boolSuccess = false;
        File o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX_MEDIA);
        if (o_File.exists()) {
            boolSuccess = o_File.delete();
        }
        return boolSuccess;
    }

    private static boolean deleteSPITVIP(LiveShowMediaVIP p_LiveShowMediaVIP, LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowMediaVIP == null) {
            return false;
        }
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        boolean boolSuccess = false;
        File o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX_SPIT);
        if (o_File.exists()) {
            boolSuccess = o_File.delete();
        }
        return boolSuccess;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void readExternal_Objects_Media(ObjectInput in, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        if (intSoftwareVersion >= 2) {
            boolean boolActive = in.readBoolean();
            if (p_LiveShow_ImportDescription.getLoadNewProject()) {
                this.m_Active = boolActive;
            }
        }
        LiveShowNotification o_LiveShowNotification = null;
        boolean boolOK = true;
        int intTrackCount = in.readInt();
        if (intTrackCount <= 0) {
            intTrackCount = 1;
        }
        if (p_LiveShow_ImportDescription.getLoadNewProject()) {
            this.createPlay();
            if (intTrackCount > this.m_LiveShowVIPTracks.size()) {
                for (int intVipTrack = this.m_LiveShowVIPTracks.size(); intVipTrack < intTrackCount; ++intVipTrack) {
                    this.createLiveShowVipTrack();
                }
            }
        }
        if (boolOK) {
            LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription;
            int intObject;
            int intObjectCount = in.readInt();
            for (intObject = 0; intObject < intObjectCount; ++intObject) {
                o_LiveShowMediaObjectDescription = LiveShowMediaObjectDescription.poolGet();
                o_LiveShowMediaObjectDescription.readExternal(in);
                p_LiveShow_ImportDescription.checkImportObject(this, (LiveShowObjectDescription)o_LiveShowMediaObjectDescription);
                LiveShowSceneBridge o_LiveShowSceneBridge = this.createLiveShowSceneBridge((LiveShowObjectDescription)o_LiveShowMediaObjectDescription);
                if (o_LiveShowSceneBridge == null) continue;
                this.addLiveShowSceneBridge(o_LiveShowSceneBridge, o_LiveShowSceneBridge.getFrameStart());
                p_LiveShow_ImportDescription.addLiveShowSceneBridge(this, o_LiveShowSceneBridge);
                o_LiveShowMediaObjectDescription.close(true);
            }
            this.refreshJumps();
            intObjectCount = in.readInt();
            if (this.m_LiveShowNotification != null) {
                o_LiveShowNotification = new LiveShowNotification(this.m_LiveShowNotification, "-", (long)intObjectCount, 0L);
            }
            for (intObject = 0; intObject < intObjectCount; ++intObject) {
                o_LiveShowMediaObjectDescription = LiveShowMediaObjectDescription.poolGet();
                o_LiveShowMediaObjectDescription.readExternal(in);
                int intVipTrackNumber = o_LiveShowMediaObjectDescription.getVIPTrackNumber();
                if (intVipTrackNumber >= 0) {
                    if (intVipTrackNumber >= this.m_LiveShowVIPTracks.size()) {
                        for (int intVipTrack = this.m_LiveShowVIPTracks.size(); intVipTrack <= intVipTrackNumber; ++intVipTrack) {
                            this.createLiveShowVipTrack();
                        }
                    }
                    p_LiveShow_ImportDescription.checkImportObject(this, (LiveShowObjectDescription)o_LiveShowMediaObjectDescription);
                    if (o_LiveShowNotification != null) {
                        String stringSourceFile = o_LiveShowMediaObjectDescription.getSourceString();
                        if (stringSourceFile != null) {
                            stringSourceFile = "";
                        }
                        stringSourceFile = stringSourceFile.replace("\\", "/");
                        File o_File = new File(stringSourceFile);
                        File o_FileParent = o_File.getParentFile();
                        StringBuffer stringBufferNotificationText = new StringBuffer();
                        stringBufferNotificationText.append("<html>");
                        stringBufferNotificationText.append("<center>");
                        stringBufferNotificationText.append("<b>");
                        stringBufferNotificationText.append(o_File.getName());
                        stringBufferNotificationText.append("</b>");
                        if (o_FileParent != null) {
                            stringBufferNotificationText.append("<br>");
                            stringBufferNotificationText.append(o_FileParent.getPath());
                        }
                        stringBufferNotificationText.append("</center>");
                        stringBufferNotificationText.append("</html>");
                        o_LiveShowNotification.setText(stringBufferNotificationText.toString());
                    } else {
                        o_LiveShowNotification.setText("");
                    }
                    LiveShowObjectInterface o_LiveShowObjectInterface = this.createLiveShowObject((LiveShowObjectDescription)o_LiveShowMediaObjectDescription, p_LiveShowProjectDescription);
                    if (o_LiveShowObjectInterface == null) {
                        o_LiveShowMediaObjectDescription.close(true);
                        continue;
                    }
                    LiveShowVIPTrack o_LiveShowVIPTrack = (LiveShowVIPTrack)this.m_LiveShowVIPTracks.get(o_LiveShowMediaObjectDescription.getVIPTrackNumber());
                    if (o_LiveShowVIPTrack != null) {
                        o_LiveShowVIPTrack.addLiveShowObjectInterface(o_LiveShowObjectInterface, o_LiveShowObjectInterface.getFrameStart());
                        p_LiveShow_ImportDescription.addLiveShowObject(this, o_LiveShowObjectInterface);
                    }
                    int intMediaServerCount = o_LiveShowMediaObjectDescription.getMediaServerIDCount();
                    for (int intMediaServer = 0; intMediaServer < intMediaServerCount; ++intMediaServer) {
                        MediaServer o_MediaServer = MediaServer.getMediaServer(o_LiveShowMediaObjectDescription.getMediaServerID(intMediaServer));
                        if (o_MediaServer == null) {
                            o_MediaServer = MediaServer.getMediaServer(o_LiveShowMediaObjectDescription.getMediaServerURL(intMediaServer), o_LiveShowMediaObjectDescription.getMediaServerPort(intMediaServer));
                        }
                        ((LiveShowMediaObject)o_LiveShowObjectInterface).addMediaServer(o_MediaServer);
                    }
                }
                o_LiveShowMediaObjectDescription.close(true);
                if (o_LiveShowNotification == null) continue;
                o_LiveShowNotification.setProgress(intObject);
            }
        }
        if (this.m_LiveShowVIPTracks.size() == 0) {
            this.createLiveShowVipTrack();
        }
        if (o_LiveShowNotification != null) {
            o_LiveShowNotification.close();
        }
        this.calculateFramesToNextSceneBridge();
        this.notifyLiveShowVIPListeners_MaxFrame(this.getFramePositionMax());
        LiveShowTimer.selfReference().addLiveShowVIP(this);
    }

    public void readExternal_Objects_SPIT(ObjectInput in, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        LiveShowNotification o_LiveShowNotification = null;
        if (p_LiveShow_ImportDescription.getLoadNewProject()) {
            // empty if block
        }
        int intSPITTypeCount = in.readInt();
        for (int intSPITType = 0; intSPITType < intSPITTypeCount; ++intSPITType) {
            SPIT_Type_Interface o_SPIT_TypeExists;
            SPIT_Type o_SPIT_Type = new SPIT_Type();
            o_SPIT_Type.readExternal(in);
            if (p_LiveShow_ImportDescription.getLoadNewProject()) {
                o_SPIT_TypeExists = SPIT_Type.getSPIT_Type(o_SPIT_Type.getID());
                if (o_SPIT_TypeExists != null && o_SPIT_TypeExists.getFixed()) continue;
                o_SPIT_Type.setJustLoadProject(true);
            } else {
                o_SPIT_TypeExists = SPIT_Type.getSPIT_Type(o_SPIT_Type.getID());
                if (o_SPIT_TypeExists != null) {
                    if (SPITServer_Client.getSPIT_ClientInterfaceCount() <= 0) continue;
                    SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITType((SPIT_Type_Interface)o_SPIT_TypeExists);
                    SPITServer_Client.sendSPIT_Message(o_SPIT_Message, null);
                    continue;
                }
                o_SPIT_Type.setName(LiveShow_ImportDescription.createImportedName(o_SPIT_Type.getName()));
            }
            if (SPIT_Type.addSPIT_Type(o_SPIT_Type, null)) continue;
        }
        int intObjectCount = in.readInt();
        if (this.m_LiveShowNotification != null) {
            o_LiveShowNotification = new LiveShowNotification(this.m_LiveShowNotification, "SPIT", (long)intObjectCount, 0L);
        }
        for (int intObject = 0; intObject < intObjectCount; ++intObject) {
            LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = LiveShowSPITObjectDescription.poolGet();
            o_LiveShowSPITObjectDescription.readExternal(in);
            int intVipTrackNumber = o_LiveShowSPITObjectDescription.getVIPTrackNumber();
            if (intVipTrackNumber >= 0) {
                if (intVipTrackNumber >= this.m_LiveShowVIPTracks.size()) {
                    for (int intVipTrack = this.m_LiveShowVIPTracks.size(); intVipTrack <= intVipTrackNumber; ++intVipTrack) {
                        this.createLiveShowVipTrack();
                    }
                }
                p_LiveShow_ImportDescription.checkImportObject(this, o_LiveShowSPITObjectDescription);
                if (o_LiveShowNotification != null) {
                    String stringSourceName = o_LiveShowSPITObjectDescription.getSourceName();
                    if (stringSourceName == null) {
                        stringSourceName = "";
                    }
                    o_LiveShowNotification.setText(stringSourceName);
                }
                LiveShowSPITObject o_LiveShowObjectInterface_Exists = LiveShowSPITObject.getSPIT_Object(o_LiveShowSPITObjectDescription.getID());
                LiveShowObjectInterface o_LiveShowObjectInterface = this.createLiveShowObject(o_LiveShowSPITObjectDescription, p_LiveShowProjectDescription);
                if (p_LiveShow_ImportDescription.getLoadNewProject()) {
                    if (o_LiveShowObjectInterface_Exists != null && o_LiveShowObjectInterface_Exists.getFixed()) {
                        o_LiveShowSPITObjectDescription.close(true);
                        continue;
                    }
                    ((LiveShowSPITObject)o_LiveShowObjectInterface).setJustLoadProject(true);
                }
                if (o_LiveShowObjectInterface == null) {
                    o_LiveShowSPITObjectDescription.close(true);
                    continue;
                }
                LiveShowVIPTrack o_LiveShowVIPTrack = (LiveShowVIPTrack)this.m_LiveShowVIPTracks.get(o_LiveShowSPITObjectDescription.getVIPTrackNumber());
                if (o_LiveShowVIPTrack != null) {
                    o_LiveShowVIPTrack.addLiveShowObjectInterface(o_LiveShowObjectInterface, o_LiveShowObjectInterface.getFrameStart());
                    p_LiveShow_ImportDescription.addLiveShowObject(this, o_LiveShowObjectInterface);
                }
            }
            o_LiveShowSPITObjectDescription.close(true);
            if (o_LiveShowNotification == null) continue;
            o_LiveShowNotification.setProgress(intObject);
        }
        if (this.m_LiveShowVIPTracks.size() == 0) {
            this.createLiveShowVipTrack();
        }
        if (o_LiveShowNotification != null) {
            o_LiveShowNotification.close();
        }
        this.notifyLiveShowVIPListeners_MaxFrame(this.getFramePositionMax());
    }

    public static LiveShowMediaVIP loadLiveShowMediaVIP(LiveShowMediaVIP p_LiveShowMediaVIP, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription, LiveShowNotification p_LiveShowNotification) {
        s_LoadException = null;
        LiveShowMediaVIP o_LiveShowMediaVIP = LiveShowMediaVIP.loadLiveShowMediaVIP_Media(p_LiveShowMediaVIP, p_LiveShowProjectDescription, p_LiveShow_ImportDescription, p_LiveShowNotification);
        if (o_LiveShowMediaVIP == null) {
            return null;
        }
        LiveShowMediaVIP.loadLiveShowMediaVIP_SPIT(p_LiveShowMediaVIP, p_LiveShowProjectDescription, p_LiveShow_ImportDescription, p_LiveShowNotification);
        return o_LiveShowMediaVIP;
    }

    public static LiveShowMediaVIP loadLiveShowMediaVIP_Media(LiveShowMediaVIP p_LiveShowMediaVIP, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription, LiveShowNotification p_LiveShowNotification) {
        if (p_LiveShowMediaVIP == null) {
            return null;
        }
        if (p_LiveShowProjectDescription == null) {
            return null;
        }
        if (p_LiveShow_ImportDescription == null) {
            return null;
        }
        FileInputStream o_InputStream = null;
        ObjectInputStream o_ObjectInput = null;
        p_LiveShowMediaVIP.clearSelectedObjects(false);
        File o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX_MEDIA);
        if (!o_File.exists()) {
            if (p_LiveShow_ImportDescription.getLoadNewProject()) {
                p_LiveShowMediaVIP.initializeVIP();
            }
            return p_LiveShowMediaVIP;
        }
        try {
            o_InputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_InputStream);
            int intSoftwareVersion = o_ObjectInput.readInt();
            p_LiveShowMediaVIP.setLiveShowNotification(p_LiveShowNotification);
            MediaServer.loadMediaServers(p_LiveShowProjectDescription, p_LiveShow_ImportDescription);
            p_LiveShowMediaVIP.readExternal_Objects_Media(o_ObjectInput, p_LiveShowProjectDescription, p_LiveShow_ImportDescription);
            o_ObjectInput.close();
            ((InputStream)o_InputStream).close();
        }
        catch (Exception e) {
            s_LoadException = e;
            System.err.println("Error LiveShowMediaVIP loadLiveShowMediaVIP_Media File: " + o_File.getAbsolutePath());
            e.printStackTrace();
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_InputStream != null) {
                    ((InputStream)o_InputStream).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return p_LiveShowMediaVIP;
        }
        return p_LiveShowMediaVIP;
    }

    public static void loadLiveShowMediaVIP_SPIT(LiveShowMediaVIP p_LiveShowMediaVIP, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription, LiveShowNotification p_LiveShowNotification) {
        if (p_LiveShowMediaVIP == null) {
            return;
        }
        if (p_LiveShowProjectDescription == null) {
            return;
        }
        if (p_LiveShow_ImportDescription == null) {
            return;
        }
        FileInputStream o_InputStream = null;
        ObjectInputStream o_ObjectInput = null;
        p_LiveShowMediaVIP.clearSelectedObjects(false);
        File o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX_SPIT);
        if (!o_File.exists()) {
            return;
        }
        try {
            o_InputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_InputStream);
            int intSoftwareVersion = o_ObjectInput.readInt();
            p_LiveShowMediaVIP.setLiveShowNotification(p_LiveShowNotification);
            p_LiveShowMediaVIP.readExternal_Objects_SPIT(o_ObjectInput, p_LiveShowProjectDescription, p_LiveShow_ImportDescription);
            o_ObjectInput.close();
            ((InputStream)o_InputStream).close();
        }
        catch (Exception e) {
            s_LoadException = e;
            System.err.println("Error LiveShowMediaVIP loadLiveShowMediaVIP_SPIT File: " + o_File.getAbsolutePath());
            e.printStackTrace();
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_InputStream != null) {
                    ((InputStream)o_InputStream).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    private void initMembers() {
        super.setType("Media");
    }

    @Override
    public void close() {
        LiveShowTimer.selfReference().removeLiveShowVIP(this);
        super.close();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public boolean accepts(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return false;
        }
        if (p_LiveShowObjectInterface.getObjectType() == 21) {
            return true;
        }
        if (p_LiveShowObjectInterface.getObjectType() == 22) {
            return true;
        }
        return p_LiveShowObjectInterface.getObjectType() == 25;
    }

    @Override
    public DataFlavor getDataFlavor() {
        return LiveShowDragDrop.LiveShowTransferable.MEDIAOBJECTFLAVOUR;
    }

    @Override
    public FlavorMap getDataFlavorMap() {
        return LiveShowDragDrop.LiveShowTransferable.getFlavorMapMedia();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LiveShowVIPTrack createLiveShowVipTrack() {
        LiveShowMediaVIPTrack o_LiveShowMediaVIPTrack = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Object object = this.m_SyncVIPTracks;
        synchronized (object) {
            o_LiveShowMediaVIPTrack = new LiveShowMediaVIPTrack(this);
            this.addLiveShowVIPTrack(o_LiveShowMediaVIPTrack);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowMediaVIPTrack;
    }

    @Override
    public LiveShowObjectInterface createLiveShowObject(LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowObjectDescription == null) {
            return null;
        }
        LiveShowMediaObject o_LiveShowMediaObject = null;
        LiveShowSPITObject o_LiveShowSPITObject = null;
        if (p_LiveShowObjectDescription.getObjectType() == 21) {
            LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = (LiveShowMediaObjectDescription)p_LiveShowObjectDescription;
            o_LiveShowMediaObjectDescription.setProducer("vip");
            o_LiveShowMediaObject = new LiveShowMediaObject((LiveShowMediaObjectDescription)p_LiveShowObjectDescription);
            if (o_LiveShowMediaObject.getSource() == null) {
                o_LiveShowMediaObject.close(true);
                o_LiveShowMediaObject = null;
            }
            return o_LiveShowMediaObject;
        }
        if (p_LiveShowObjectDescription.getObjectType() == 25) {
            LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)p_LiveShowObjectDescription;
            o_LiveShowSPITObjectDescription.setServerParams("vip");
            o_LiveShowSPITObject = new LiveShowSPITObject(o_LiveShowSPITObjectDescription);
            if (o_LiveShowSPITObject.getSource() == null) {
                o_LiveShowSPITObject.close(true);
                o_LiveShowSPITObject = null;
            }
            return o_LiveShowSPITObject;
        }
        return null;
    }

    public LiveShowObjectInterface createLiveShowObject(LiveShowObjectDescription p_LiveShowObjectDescription, LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowObjectDescription == null) {
            return null;
        }
        LiveShowMediaObject o_LiveShowMediaObject = null;
        LiveShowSPITObject o_LiveShowSPITObject = null;
        if (p_LiveShowObjectDescription.getObjectType() == 21) {
            LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = (LiveShowMediaObjectDescription)p_LiveShowObjectDescription;
            o_LiveShowMediaObjectDescription.setProducer("vip");
            o_LiveShowMediaObject = new LiveShowMediaObject((LiveShowMediaObjectDescription)p_LiveShowObjectDescription, p_LiveShowProjectDescription);
            if (o_LiveShowMediaObject.getSource() == null) {
                o_LiveShowMediaObject.close(true);
                o_LiveShowMediaObject = null;
            }
            return o_LiveShowMediaObject;
        }
        if (p_LiveShowObjectDescription.getObjectType() == 25) {
            LiveShowSPITObjectDescription o_LiveShowSPITObjectDescription = (LiveShowSPITObjectDescription)p_LiveShowObjectDescription;
            o_LiveShowSPITObjectDescription.setServerParams("vip");
            o_LiveShowSPITObject = new LiveShowSPITObject((LiveShowSPITObjectDescription)p_LiveShowObjectDescription);
            return o_LiveShowSPITObject;
        }
        return null;
    }

    @Override
    public LiveShowSceneBridge createLiveShowSceneBridge(LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowObjectDescription == null) {
            p_LiveShowObjectDescription = LiveShowMediaObjectDescription.poolGet();
            p_LiveShowObjectDescription.setObjectType(22);
            long longLength = LiveShowSceneBridge.DEFAULTFRAMELENGTHSCENEBRIDGE;
            p_LiveShowObjectDescription.setFrameStart(0L);
            p_LiveShowObjectDescription.setFrameLength(longLength);
            p_LiveShowObjectDescription.setFrameFadeInLength(longLength);
            p_LiveShowObjectDescription.setFrameFadeOutLength(longLength);
            p_LiveShowObjectDescription.setName("newSceneBridge");
            LiveShowMediaSceneBridge o_LiveShowMediaSceneBridge = new LiveShowMediaSceneBridge(p_LiveShowObjectDescription);
            return o_LiveShowMediaSceneBridge;
        }
        if (p_LiveShowObjectDescription.getObjectType() != 22) {
            return null;
        }
        LiveShowMediaSceneBridge o_LiveShowMediaSceneBridge = new LiveShowMediaSceneBridge(p_LiveShowObjectDescription);
        return o_LiveShowMediaSceneBridge;
    }

    @Override
    public LiveShowSceneBridge createLiveShowSceneBridge(LiveShowSceneBridgeMain p_LiveShowSceneBridgeMain, LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowObjectDescription == null) {
            return null;
        }
        if (p_LiveShowSceneBridgeMain == null) {
            return null;
        }
        LiveShowMediaObjectDescription o_LiveShowObjectDescription = LiveShowMediaObjectDescription.poolGet();
        o_LiveShowObjectDescription.setID(p_LiveShowSceneBridgeMain.getID());
        o_LiveShowObjectDescription.setObjectType(22);
        o_LiveShowObjectDescription.setName(p_LiveShowObjectDescription.getName());
        o_LiveShowObjectDescription.setIsMainBridge(true);
        long longLength = p_LiveShowObjectDescription.getFrameLength();
        o_LiveShowObjectDescription.setFrameStart(p_LiveShowObjectDescription.getFrameStart());
        o_LiveShowObjectDescription.setFrameLength(longLength);
        o_LiveShowObjectDescription.setFrameFadeInLength(longLength);
        o_LiveShowObjectDescription.setFrameFadeOutLength(longLength);
        o_LiveShowObjectDescription.setStopAtStart(p_LiveShowObjectDescription.getStopAtStart());
        o_LiveShowObjectDescription.setActive(p_LiveShowObjectDescription.getActive());
        LiveShowMediaSceneBridge o_LiveShowMediaSceneBridge = new LiveShowMediaSceneBridge((LiveShowObjectDescription)o_LiveShowObjectDescription);
        this.addLiveShowSceneBridge(o_LiveShowMediaSceneBridge, o_LiveShowMediaSceneBridge.getFrameStart());
        return o_LiveShowMediaSceneBridge;
    }

    @Override
    public boolean addLiveShowObject(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return false;
        }
        boolean boolAdded = super.addLiveShowObject(p_LiveShowObjectInterface);
        if (boolAdded) {
            if (p_LiveShowObjectInterface instanceof LiveShowMediaObject) {
                LiveShowMediaObject o_LiveShowMediaObject = (LiveShowMediaObject)p_LiveShowObjectInterface;
                LiveShowMediaObjectDescription o_LiveShowObjectDescription = (LiveShowMediaObjectDescription)o_LiveShowMediaObject.getDescription();
                int intMediaServerCount = o_LiveShowObjectDescription.getMediaServerIDCount();
                for (int intMediaServer = 0; intMediaServer < intMediaServerCount; ++intMediaServer) {
                    MediaServer o_MediaServer = MediaServer.getMediaServer(o_LiveShowObjectDescription.getMediaServerID(intMediaServer));
                    o_LiveShowMediaObject.addMediaServer(o_MediaServer);
                }
                if (this.m_Play != null) {
                    PlayMedia o_PlayMedia = (PlayMedia)this.m_Play;
                    PlayMedia.MediaPlayObject o_MediaPlayObject = (PlayMedia.MediaPlayObject)o_PlayMedia.getPlayObject();
                    o_MediaPlayObject.addLiveShowMediaObject(o_LiveShowMediaObject);
                }
                MediaServer.addMediaRefreshListener(this);
            } else if (p_LiveShowObjectInterface instanceof LiveShowSPITObject) {
                LiveShowSPITObject o_SPITObject = (LiveShowSPITObject)p_LiveShowObjectInterface;
                LiveShowSPITObject.addSPITObject(o_SPITObject, null);
            }
        }
        return boolAdded;
    }

    @Override
    public boolean removeLiveShowObject(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return false;
        }
        boolean boolRemoved = super.removeLiveShowObject(p_LiveShowObjectInterface);
        if (boolRemoved) {
            if (p_LiveShowObjectInterface instanceof LiveShowMediaObject) {
                LiveShowMediaObject o_LiveShowMediaObject = (LiveShowMediaObject)p_LiveShowObjectInterface;
                if (this.m_Play != null) {
                    PlayMedia o_PlayMedia = (PlayMedia)this.m_Play;
                    PlayMedia.MediaPlayObject o_MediaPlayObject = (PlayMedia.MediaPlayObject)o_PlayMedia.getPlayObject();
                    o_MediaPlayObject.removeLiveShowMediaObject(o_LiveShowMediaObject);
                }
                MediaServer.removeMediaRefreshListener(this);
                o_LiveShowMediaObject.clearMediaServers();
            } else if (p_LiveShowObjectInterface instanceof LiveShowSPITObject) {
                LiveShowSPITObject o_LiveShowSPITObject = (LiveShowSPITObject)p_LiveShowObjectInterface;
                LiveShowSPITObject.removeSPITObject_ByServer(o_LiveShowSPITObject);
            }
        }
        return boolRemoved;
    }

    @Override
    public void event_MediaServerObjectChanged(MediaServer p_MediaServer) {
        if (this.m_Play != null) {
            switch (this.m_Play.getStatus()) {
                case 0: 
                case 1: {
                    this.m_Play.playFramePositionOnce();
                }
            }
        }
    }

    @Override
    public Playable.PlayObject read(Play p_Play, Playable.PlayObject p_PlayObject) {
        if (p_PlayObject == null) {
            return null;
        }
        if (p_PlayObject.getFramePosition() < 0L) {
            return null;
        }
        if (p_PlayObject.getData() == null) {
            return null;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Playable.PlayObject o_PlayObject = null;
        LiveShowSceneBridge o_ActualSceneBridge = this.m_ActualSceneBridge;
        o_PlayObject = o_ActualSceneBridge != null ? o_ActualSceneBridge.read(p_Play, p_PlayObject, null, -1L, 1.0, false) : this.readInternal(p_Play, p_PlayObject, null, -1L, 1.0, false);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if (!this.m_Active) {
            return null;
        }
        return p_PlayObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Playable.PlayObject readInternal(Play p_Play, Playable.PlayObject p_PlayObject, LiveShowSceneBridge p_LiveShowSceneBridge, long p_SceneBridgeFrameInside, double p_SceneBridgeFadeProgress, boolean p_IsPreObject) {
        if (!this.m_Active) {
            return p_PlayObject;
        }
        if (p_PlayObject == null) {
            return null;
        }
        if (p_PlayObject.getFramePosition() < 0L) {
            return null;
        }
        if (p_PlayObject.getData() == null) {
            return null;
        }
        if (!(p_PlayObject instanceof PlayMedia.MediaPlayObject)) {
            return null;
        }
        PlayMedia.MediaPlayObject o_MediaPlayObject = (PlayMedia.MediaPlayObject)p_PlayObject;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Object object = this.m_SyncPlay;
        synchronized (object) {
            for (int intTrack = 0; intTrack < this.m_LiveShowVIPTracks.size(); ++intTrack) {
                PlayMedia.MediaPlayObject o_PlayObject;
                LiveShowMediaVIPTrack o_LiveShowMediaVIPTrack = (LiveShowMediaVIPTrack)this.m_LiveShowVIPTracks.get(intTrack);
                if (o_LiveShowMediaVIPTrack != null && (o_PlayObject = (PlayMedia.MediaPlayObject)o_LiveShowMediaVIPTrack.read(p_Play, o_MediaPlayObject, p_LiveShowSceneBridge, p_SceneBridgeFrameInside, p_SceneBridgeFadeProgress, p_IsPreObject)) != null) continue;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_MediaPlayObject;
    }

    @Override
    public ImageIcon getImageIcon() {
        return s_Icon;
    }

    @Override
    public void eventEndOfAction(LiveShowVIP.LiveShowVIPStatus p_LiveShowVIPStatus, boolean p_Success, int p_Action) {
        super.eventEndOfAction(p_LiveShowVIPStatus, p_Success, p_Action);
    }

    @Override
    public void setSceneBridgeCursorChanged(LiveShowSceneBridge p_LiveShowSceneBridge) {
    }

    @Override
    public long checkSnappingSpecial(long p_ActorFramePosition, int p_ActorLabelType, LiveShowObjectDescription p_LiveShowObjectDescription, boolean p_ObjectItself) {
        long longSpitDuration;
        long longFramePositionDelay;
        long longFramePositionCheck;
        if (p_LiveShowObjectDescription == null) {
            return p_ActorFramePosition;
        }
        if (!(p_LiveShowObjectDescription instanceof LiveShowSPITObjectDescription)) {
            return p_ActorFramePosition;
        }
        if (p_ObjectItself) {
            switch (p_ActorLabelType) {
                case 5: {
                    break;
                }
                default: {
                    return p_ActorFramePosition;
                }
            }
        }
        boolean boolSnapped = false;
        LiveShowSPITObjectDescription o_SPITObjectDescription = (LiveShowSPITObjectDescription)p_LiveShowObjectDescription;
        long longFrameObjectStart = o_SPITObjectDescription.getFrameStart();
        long longNewFramePosition = p_ActorFramePosition;
        long longSPITDelay = o_SPITObjectDescription.getDelay();
        if (longSPITDelay > 0L && Math.abs((longFramePositionCheck = longFrameObjectStart + (longFramePositionDelay = longSPITDelay)) - p_ActorFramePosition) < this.getSnapFramesDistance()) {
            longNewFramePosition = longFramePositionCheck;
            boolSnapped = true;
        }
        if ((longSpitDuration = o_SPITObjectDescription.getDuration()) > 0L && Math.abs((longFramePositionCheck = longFrameObjectStart + (longFramePositionDelay = longSPITDelay + longSpitDuration)) - p_ActorFramePosition) < this.getSnapFramesDistance()) {
            longNewFramePosition = longFramePositionCheck;
            boolSnapped = true;
        }
        return longNewFramePosition;
    }
}

