/*
 * Decompiled with CFR 0.152.
 */
package MediaPackage;

import Models.LiveDBListTools;
import ServerAutoDetectPackage.ServerAutoDetect;
import ServerAutoDetectPackage.ServerAutoDetect_Client;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.net.InetAddress;
import java.util.HashMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class ServerAutoDetect_Client_ListModel {
    private static DetectedServer_ListCellRenderer m_DetectedServer_CellRenderer;
    public static HashMap<ServerAutoDetect_Client, DetectedServerComboBoxUtil> s_ListModels;
    public static final Object s_SyncObject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiveDBListTools.LiveDBListModel<ServerAutoDetect.DetectedServer> getDetectedServerListModel(ServerAutoDetect_Client p_ServerAutoDetect_Client) {
        DetectedServerComboBoxUtil o_DetectedServerComboBoxUtil;
        if (p_ServerAutoDetect_Client == null) {
            return null;
        }
        Object object = s_SyncObject;
        synchronized (object) {
            o_DetectedServerComboBoxUtil = s_ListModels.get(p_ServerAutoDetect_Client);
            if (o_DetectedServerComboBoxUtil == null) {
                o_DetectedServerComboBoxUtil = new DetectedServerComboBoxUtil(p_ServerAutoDetect_Client);
                s_ListModels.put(p_ServerAutoDetect_Client, o_DetectedServerComboBoxUtil);
            }
        }
        return o_DetectedServerComboBoxUtil.getDetectedServerListModel();
    }

    public static DetectedServer_ListCellRenderer getDetectedServer_CellRenderer() {
        if (m_DetectedServer_CellRenderer == null) {
            m_DetectedServer_CellRenderer = new DetectedServer_ListCellRenderer(false, true, true, true, true, true);
        }
        return m_DetectedServer_CellRenderer;
    }

    static {
        s_ListModels = new HashMap();
        s_SyncObject = new Object();
    }

    public static class DetectedServer_TableCellRenderer
    extends DefaultTableCellRenderer {
        private StringBuffer m_StringBuffer;
        private boolean m_ShowServerTaskID;
        private boolean m_ShowServerTaskName;
        private boolean m_ShowComputerName;
        private boolean m_ShowServerIP;
        private boolean m_ShowServerPort;
        private boolean m_ShowServerAddition;

        public DetectedServer_TableCellRenderer() {
            this.initMembers();
        }

        public DetectedServer_TableCellRenderer(boolean p_ShowServerTaskID, boolean p_ShowServerTaskName, boolean p_ShowComputerName, boolean p_ShowServerIP, boolean p_ShowServerPort, boolean p_ShowServerAddition) {
            this.initMembers();
            this.m_ShowServerTaskID = p_ShowServerTaskID;
            this.m_ShowServerTaskName = p_ShowServerTaskName;
            this.m_ShowComputerName = p_ShowComputerName;
            this.m_ShowServerIP = p_ShowServerIP;
            this.m_ShowServerPort = p_ShowServerPort;
        }

        private void initMembers() {
            this.m_StringBuffer = new StringBuffer();
            this.m_ShowServerTaskID = false;
            this.m_ShowComputerName = true;
            this.m_ShowServerIP = false;
            this.m_ShowServerPort = true;
            this.m_ShowServerAddition = true;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color o_Background = table.getBackground();
            Color o_Foreground = table.getForeground();
            if (isSelected) {
                if (table.hasFocus()) {
                    o_Background = UIManager.getColor("Table.selectionBackground");
                    o_Foreground = UIManager.getColor("Table.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("Table.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("Table.selectionInactiveForeground");
                }
            }
            this.setBackground(o_Background);
            this.setForeground(o_Foreground);
            if (value == null || !(value instanceof ServerAutoDetect.DetectedServer)) {
                boolean boolServerFound = false;
                if (ServerAutoDetect_Client.s_ServerAutoDetect_Clients.size() > 0) {
                    for (int intClient = 0; intClient < ServerAutoDetect_Client.s_ServerAutoDetect_Clients.size(); ++intClient) {
                        ServerAutoDetect_Client o_ServerAutoDetect_Client = ServerAutoDetect_Client.getServerAutoDetect_Client((int)intClient);
                        if (o_ServerAutoDetect_Client == null || o_ServerAutoDetect_Client.getDetectedServerCount() <= 0) continue;
                        boolServerFound = true;
                        break;
                    }
                }
                if (boolServerFound) {
                    this.setText("...");
                } else {
                    this.setText("-");
                }
            } else {
                String stringAddition;
                ServerAutoDetect.DetectedServer o_DetectedServer = (ServerAutoDetect.DetectedServer)value;
                InetAddress o_InetAddress = o_DetectedServer.getFirstInetAddress();
                this.m_StringBuffer.delete(0, this.m_StringBuffer.length());
                if (this.m_ShowServerTaskID) {
                    this.m_StringBuffer.append(o_DetectedServer.getServerTaskID());
                    this.m_StringBuffer.append(" ");
                }
                if (this.m_ShowServerTaskName) {
                    this.m_StringBuffer.append(o_DetectedServer.getServerTaskName());
                    this.m_StringBuffer.append(" ");
                }
                if (this.m_ShowComputerName) {
                    this.m_StringBuffer.append(o_DetectedServer.getComputerName());
                    this.m_StringBuffer.append(" ");
                }
                if (this.m_ShowServerAddition && (stringAddition = o_DetectedServer.getServerAddition()) != null && stringAddition.length() > 0) {
                    this.m_StringBuffer.append(stringAddition);
                    this.m_StringBuffer.append(" ");
                }
                if (this.m_ShowServerIP || this.m_ShowServerPort) {
                    this.m_StringBuffer.append(" (");
                    if (this.m_ShowServerIP && o_InetAddress != null) {
                        this.m_StringBuffer.append(o_InetAddress.getHostAddress());
                        this.m_StringBuffer.append("  ");
                    }
                    if (this.m_ShowServerPort) {
                        this.m_StringBuffer.append(o_DetectedServer.getServerPort());
                    }
                    this.m_StringBuffer.append(") ");
                }
                this.setIcon(null);
                if (this.m_StringBuffer.length() > 2) {
                    this.m_StringBuffer.delete(this.m_StringBuffer.length() - 1, this.m_StringBuffer.length());
                }
                this.setText(this.m_StringBuffer.toString());
            }
            this.setFont(table.getFont());
            return this;
        }
    }

    public static class DetectedServer_ListCellRenderer
    extends DefaultListCellRenderer {
        protected static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        protected static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        protected static final Border SELECTED_BORDER = new LineBorder(Color.BLUE, 2, true);
        private Dimension m_PreferredDimension;
        private StringBuffer m_StringBuffer;
        private boolean m_ShowServerTaskID;
        private boolean m_ShowServerTaskName;
        private boolean m_ShowComputerName;
        private boolean m_ShowServerIP;
        private boolean m_ShowServerPort;
        private boolean m_ShowServerAddition;

        public DetectedServer_ListCellRenderer() {
            this.initMembers();
        }

        public DetectedServer_ListCellRenderer(boolean p_ShowServerTaskID, boolean p_ShowServerTaskName, boolean p_ShowComputerName, boolean p_ShowServerIP, boolean p_ShowServerPort, boolean p_ShowServerAddition) {
            this.initMembers();
            this.m_ShowServerTaskID = p_ShowServerTaskID;
            this.m_ShowServerTaskName = p_ShowServerTaskName;
            this.m_ShowComputerName = p_ShowComputerName;
            this.m_ShowServerIP = p_ShowServerIP;
            this.m_ShowServerPort = p_ShowServerPort;
            this.m_ShowServerAddition = p_ShowServerAddition;
        }

        private void initMembers() {
            this.m_PreferredDimension = new Dimension(60, 28);
            this.m_StringBuffer = new StringBuffer();
            this.m_ShowServerTaskID = false;
            this.m_ShowServerTaskName = false;
            this.m_ShowComputerName = true;
            this.m_ShowServerIP = false;
            this.m_ShowServerPort = true;
            this.m_ShowServerAddition = true;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            if (isSelected) {
                // empty if block
            }
            if (value == null || !(value instanceof ServerAutoDetect.DetectedServer)) {
                if (list.getModel().getSize() > 1) {
                    this.setText("...");
                } else {
                    this.setText("-");
                }
            } else {
                String stringAddition;
                ServerAutoDetect.DetectedServer o_DetectedServer = (ServerAutoDetect.DetectedServer)value;
                InetAddress o_InetAddress = o_DetectedServer.getFirstInetAddress();
                this.m_StringBuffer.delete(0, this.m_StringBuffer.length());
                if (this.m_ShowServerTaskID) {
                    this.m_StringBuffer.append(o_DetectedServer.getServerTaskID());
                    this.m_StringBuffer.append(" ");
                }
                if (this.m_ShowServerTaskName) {
                    if (o_DetectedServer.getServerTaskName() != null) {
                        this.m_StringBuffer.append(o_DetectedServer.getServerTaskName());
                    }
                    this.m_StringBuffer.append(" ");
                }
                if (this.m_ShowComputerName) {
                    this.m_StringBuffer.append(o_DetectedServer.getComputerName());
                    this.m_StringBuffer.append(" ");
                }
                if (this.m_ShowServerAddition && (stringAddition = o_DetectedServer.getServerAddition()) != null && stringAddition.length() > 0) {
                    this.m_StringBuffer.append(stringAddition);
                    this.m_StringBuffer.append(" ");
                }
                if (this.m_ShowServerIP || this.m_ShowServerPort) {
                    this.m_StringBuffer.append(" (");
                    if (this.m_ShowServerIP && o_InetAddress != null) {
                        this.m_StringBuffer.append(o_InetAddress.getHostAddress());
                        this.m_StringBuffer.append("  ");
                    }
                    if (this.m_ShowServerPort) {
                        this.m_StringBuffer.append(o_DetectedServer.getServerPort());
                    }
                    this.m_StringBuffer.append(") ");
                }
                this.setIcon(null);
                if (this.m_StringBuffer.length() > 2) {
                    this.m_StringBuffer.delete(this.m_StringBuffer.length() - 1, this.m_StringBuffer.length());
                }
                this.setText(this.m_StringBuffer.toString());
                this.m_StringBuffer.delete(0, this.m_StringBuffer.length());
                this.m_StringBuffer.append("<html>");
                this.m_StringBuffer.append(o_DetectedServer.getComputerName());
                this.m_StringBuffer.append(" ");
                int intInnetAddressCount = o_DetectedServer.getInetAddressCount();
                for (int intAddress = 0; intAddress < intInnetAddressCount; ++intAddress) {
                    o_InetAddress = o_DetectedServer.getInetAddress(intAddress);
                    if (o_InetAddress == null) continue;
                    this.m_StringBuffer.append(o_InetAddress.getHostAddress());
                    if (intAddress >= intInnetAddressCount - 1) continue;
                    this.m_StringBuffer.append("<br>");
                }
                this.m_StringBuffer.append(" (");
                this.m_StringBuffer.append(o_DetectedServer.getServerPort());
                this.m_StringBuffer.append(")");
                this.m_StringBuffer.append("</html>");
                this.setToolTipText(this.m_StringBuffer.toString());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            Border border = null;
            if (isSelected) {
                border = SELECTED_BORDER;
            }
            if (border == null) {
                border = this.getNoFocusBorder();
            }
            this.setPreferredSize(this.m_PreferredDimension);
            return this;
        }

        private Border getNoFocusBorder() {
            Border border = null;
            if (System.getSecurityManager() != null) {
                if (border != null) {
                    return border;
                }
                return SAFE_NO_FOCUS_BORDER;
            }
            if (border != null && (noFocusBorder == null || noFocusBorder == DEFAULT_NO_FOCUS_BORDER)) {
                return border;
            }
            return noFocusBorder;
        }
    }

    protected static class DetectedServerComboBoxUtil
    implements ServerAutoDetect.ServerAutoDetect_Listener {
        private ServerAutoDetect_Client m_ServerAutoDetect_Client;
        private LiveDBListTools.LiveDBListModel<ServerAutoDetect.DetectedServer> m_DetectedServer_ListModel;
        private final Object m_SyncModel = new Object();

        public DetectedServerComboBoxUtil(ServerAutoDetect_Client p_ServerAutoDetect_Client) {
            this.initMembers();
            this.m_ServerAutoDetect_Client = p_ServerAutoDetect_Client;
            this.m_DetectedServer_ListModel = new LiveDBListTools.LiveDBListModel(null);
            this.m_ServerAutoDetect_Client.addServerAutoDetectListener((ServerAutoDetect.ServerAutoDetect_Listener)this);
        }

        private void initMembers() {
            this.m_DetectedServer_ListModel = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncModel;
            synchronized (object) {
                this.m_ServerAutoDetect_Client.removeServerAutoDetectListener((ServerAutoDetect.ServerAutoDetect_Listener)this);
                this.m_DetectedServer_ListModel.clear();
                this.m_DetectedServer_ListModel = null;
            }
        }

        public void eventDetectedServer_Added(ServerAutoDetect.DetectedServer p_DetectedServer) {
            if (p_DetectedServer == null) {
                return;
            }
            LiveDBListTools.LiveDBListModel<ServerAutoDetect.DetectedServer> o_DetectedServer_ListModel = this.m_DetectedServer_ListModel;
            if (o_DetectedServer_ListModel != null) {
                o_DetectedServer_ListModel.add((Object)p_DetectedServer);
            }
        }

        public void eventDetectedServer_Changed(ServerAutoDetect.DetectedServer p_DetectedServer) {
            if (p_DetectedServer == null) {
                return;
            }
            LiveDBListTools.LiveDBListModel<ServerAutoDetect.DetectedServer> o_DetectedServer_ListModel = this.m_DetectedServer_ListModel;
            if (o_DetectedServer_ListModel != null) {
                o_DetectedServer_ListModel.changed((Object)p_DetectedServer);
            }
        }

        public void eventDetectedServer_Removed(ServerAutoDetect.DetectedServer p_DetectedServer) {
            if (p_DetectedServer == null) {
                return;
            }
            LiveDBListTools.LiveDBListModel<ServerAutoDetect.DetectedServer> o_DetectedServer_ListModel = this.m_DetectedServer_ListModel;
            if (o_DetectedServer_ListModel != null) {
                o_DetectedServer_ListModel.remove((Object)p_DetectedServer);
            }
        }

        public LiveDBListTools.LiveDBListModel<ServerAutoDetect.DetectedServer> getDetectedServerListModel() {
            return this.m_DetectedServer_ListModel;
        }
    }
}

