/*
 * Decompiled with CFR 0.152.
 */
package MediaPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import MediaPackage.MediaServer;
import StartPackage.LiveShowMediaSystem;
import SwingToolTipPackage.PopUpToolTip;
import ToolsGraphics.JLabel_ResizeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class MediaServerPanel
extends JPanel
implements ListSelectionListener,
TableModelListener {
    private JButton jButton_AddMediaServer;
    private JButton jButton_RemoveMediaServer;
    private JButton jButton_ShutdownMediaServer;
    private JButton jButton_ShutdownRestartMediaServer;
    private JLabel_ResizeFrame jLabel_ResizeFrame1;
    private JLabel jLabel_Titel;
    private JScrollPane jScrollPane_MediaClients;
    private JTable jTable_MediaClients;

    public MediaServerPanel() {
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
        this.refreshButtons();
    }

    private void initComponents() {
        this.jLabel_ResizeFrame1 = new JLabel_ResizeFrame();
        this.jButton_AddMediaServer = new JButton();
        this.jButton_RemoveMediaServer = new JButton();
        this.jScrollPane_MediaClients = new JScrollPane();
        this.jTable_MediaClients = new JTable();
        this.jLabel_Titel = new JLabel();
        this.jButton_ShutdownMediaServer = new JButton();
        this.jButton_ShutdownRestartMediaServer = new JButton();
        this.setPreferredSize(new Dimension(500, 511));
        this.setLayout(new GridBagLayout());
        this.jLabel_ResizeFrame1.setToolTipText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 14;
        this.add((Component)this.jLabel_ResizeFrame1, gridBagConstraints);
        this.jButton_AddMediaServer.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Plus.png")));
        this.jButton_AddMediaServer.setToolTipText("Add MediaServer");
        this.jButton_AddMediaServer.setContentAreaFilled(false);
        this.jButton_AddMediaServer.setIconTextGap(0);
        this.jButton_AddMediaServer.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_AddMediaServer.setMaximumSize(new Dimension(34, 34));
        this.jButton_AddMediaServer.setMinimumSize(new Dimension(34, 34));
        this.jButton_AddMediaServer.setPreferredSize(new Dimension(34, 34));
        this.jButton_AddMediaServer.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_AddMediaServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaServerPanel.this.jButton_AddMediaServerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_AddMediaServer, gridBagConstraints);
        this.jButton_RemoveMediaServer.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Delete.png")));
        this.jButton_RemoveMediaServer.setToolTipText("Delete MediaServer");
        this.jButton_RemoveMediaServer.setContentAreaFilled(false);
        this.jButton_RemoveMediaServer.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_RemoveMediaServer.setMaximumSize(new Dimension(34, 34));
        this.jButton_RemoveMediaServer.setMinimumSize(new Dimension(34, 34));
        this.jButton_RemoveMediaServer.setPreferredSize(new Dimension(34, 34));
        this.jButton_RemoveMediaServer.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_RemoveMediaServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaServerPanel.this.jButton_RemoveMediaServerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_RemoveMediaServer, gridBagConstraints);
        this.jTable_MediaClients.setFont(new Font("Tahoma", 0, 14));
        this.jTable_MediaClients.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}));
        this.jTable_MediaClients.setRowHeight(30);
        this.jTable_MediaClients.setRowMargin(3);
        this.jTable_MediaClients.setSelectionMode(0);
        this.jScrollPane_MediaClients.setViewportView(this.jTable_MediaClients);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jScrollPane_MediaClients, gridBagConstraints);
        this.jLabel_Titel.setFont(new Font("Tahoma", 0, 14));
        this.jLabel_Titel.setHorizontalAlignment(0);
        this.jLabel_Titel.setText("Media Server");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Titel, gridBagConstraints);
        this.jButton_ShutdownMediaServer.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Computer_Shutdown.png")));
        this.jButton_ShutdownMediaServer.setToolTipText("Shutdown MediaServer");
        this.jButton_ShutdownMediaServer.setContentAreaFilled(false);
        this.jButton_ShutdownMediaServer.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_ShutdownMediaServer.setMaximumSize(new Dimension(34, 34));
        this.jButton_ShutdownMediaServer.setMinimumSize(new Dimension(34, 34));
        this.jButton_ShutdownMediaServer.setPreferredSize(new Dimension(34, 34));
        this.jButton_ShutdownMediaServer.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_ShutdownMediaServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaServerPanel.this.jButton_ShutdownMediaServerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(25, 3, 3, 3);
        this.add((Component)this.jButton_ShutdownMediaServer, gridBagConstraints);
        this.jButton_ShutdownRestartMediaServer.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Computer_Restart.png")));
        this.jButton_ShutdownRestartMediaServer.setToolTipText("Shutdown and restart MediaServer");
        this.jButton_ShutdownRestartMediaServer.setContentAreaFilled(false);
        this.jButton_ShutdownRestartMediaServer.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_ShutdownRestartMediaServer.setMaximumSize(new Dimension(34, 34));
        this.jButton_ShutdownRestartMediaServer.setMinimumSize(new Dimension(34, 34));
        this.jButton_ShutdownRestartMediaServer.setPreferredSize(new Dimension(34, 34));
        this.jButton_ShutdownRestartMediaServer.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_ShutdownRestartMediaServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaServerPanel.this.jButton_ShutdownRestartMediaServerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(25, 3, 3, 3);
        this.add((Component)this.jButton_ShutdownRestartMediaServer, gridBagConstraints);
    }

    private void jButton_AddMediaServerActionPerformed(ActionEvent evt) {
        MediaServer o_MediaServer = new MediaServer();
        LiveShowMediaSystem.s_MediaServerTableModel.addMediaServer(o_MediaServer);
    }

    private void jButton_RemoveMediaServerActionPerformed(ActionEvent evt) {
        MediaServer o_MediaServer;
        int intRow = this.jTable_MediaClients.getSelectedRow();
        if (intRow < 0) {
            return;
        }
        try {
            intRow = this.jTable_MediaClients.convertRowIndexToModel(intRow);
            o_MediaServer = LiveShowMediaSystem.s_MediaServerTableModel.getMediaServer(intRow);
        }
        catch (Exception e) {
            o_MediaServer = null;
        }
        if (o_MediaServer != null) {
            o_MediaServer.close();
        }
    }

    private void jButton_ShutdownMediaServerActionPerformed(ActionEvent evt) {
        MediaServer o_MediaServer;
        int intRow = this.jTable_MediaClients.getSelectedRow();
        if (intRow < 0) {
            return;
        }
        try {
            intRow = this.jTable_MediaClients.convertRowIndexToModel(intRow);
            o_MediaServer = LiveShowMediaSystem.s_MediaServerTableModel.getMediaServer(intRow);
        }
        catch (Exception e) {
            o_MediaServer = null;
        }
        if (o_MediaServer != null) {
            o_MediaServer.sendMessage_Shutdown(false);
        }
    }

    private void jButton_ShutdownRestartMediaServerActionPerformed(ActionEvent evt) {
        MediaServer o_MediaServer;
        int intRow = this.jTable_MediaClients.getSelectedRow();
        if (intRow < 0) {
            return;
        }
        try {
            intRow = this.jTable_MediaClients.convertRowIndexToModel(intRow);
            o_MediaServer = LiveShowMediaSystem.s_MediaServerTableModel.getMediaServer(intRow);
        }
        catch (Exception e) {
            o_MediaServer = null;
        }
        if (o_MediaServer != null) {
            o_MediaServer.sendMessage_Shutdown(true);
        }
    }

    public JLabel_ResizeFrame getLabel_ResizeFrame() {
        return this.jLabel_ResizeFrame1;
    }

    public MediaServer getSelectedMediaServer() {
        MediaServer o_MediaServer;
        int intRow = this.jTable_MediaClients.getSelectedRow();
        if (intRow < 0) {
            return null;
        }
        try {
            intRow = this.jTable_MediaClients.convertRowIndexToModel(intRow);
            o_MediaServer = LiveShowMediaSystem.s_MediaServerTableModel.getMediaServer(intRow);
        }
        catch (Exception e) {
            o_MediaServer = null;
        }
        return o_MediaServer;
    }

    private void initComponentsFurther() {
        this.jScrollPane_MediaClients.getViewport().setBackground(Color.BLACK);
        this.jTable_MediaClients.setModel(LiveShowMediaSystem.s_MediaServerTableModel);
        LiveShowMediaSystem.s_MediaServerTableModel.finishJTable(this.jTable_MediaClients);
        this.jTable_MediaClients.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_AddMediaServer.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_RemoveMediaServer.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ShutdownMediaServer.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ShutdownRestartMediaServer.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTable_MediaClients.getSelectionModel().addListSelectionListener(this);
        LiveShowMediaSystem.s_MediaServerTableModel.addTableModelListener(this);
    }

    private void refreshButtons() {
        this.jButton_RemoveMediaServer.setEnabled(false);
        this.jButton_ShutdownMediaServer.setEnabled(false);
        this.jButton_ShutdownRestartMediaServer.setEnabled(false);
        MediaServer o_MediaServer = this.getSelectedMediaServer();
        if (o_MediaServer != null) {
            this.jButton_RemoveMediaServer.setEnabled(true);
            if (o_MediaServer.isConnected() && !o_MediaServer.getMediaServerRunsLocal()) {
                this.jButton_ShutdownMediaServer.setEnabled(true);
                this.jButton_ShutdownRestartMediaServer.setEnabled(true);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.refreshButtons();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        try {
            if (LiveShowMediaSystem.s_MediaServerTableModel.size() <= 0) {
                return;
            }
            this.refreshButtons();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

