/*
 * Decompiled with CFR 0.152.
 */
package MediaPackage;

import ClientKernelPackage.LiveDBClientKernel;
import ClientPackage.LiveDBClient;
import ClientPackage.LiveDBClientListener;
import GUID.LiveGUID;
import LiveShowNotificationPackage.LiveShowNotification;
import LiveShowNotificationPackage.LiveShowNotificationListener;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectListener;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import LiveShowVirtualPackage.LiveShow_ImportDescription;
import MediaMessagePackage.MediaMessage_AddLiveShowMediaObject;
import MediaMessagePackage.MediaMessage_MainSoundVolume;
import MediaMessagePackage.MediaMessage_MainTransparency;
import MediaMessagePackage.MediaMessage_MediaObjectChanged;
import MediaMessagePackage.MediaMessage_MediaServerInfo;
import MediaMessagePackage.MediaMessage_PlayStatus;
import MediaMessagePackage.MediaMessage_RefreshMediaSource_Error;
import MediaMessagePackage.MediaMessage_RemoveLiveShowMediaObject;
import MediaMessagePackage.MediaMessage_RequestMediaSource;
import MediaMessagePackage.MediaMessage_Shutdown;
import MediaMessagePackage.MediaMessage_Sweep;
import MediaMessagePackage.MediaMessage_VideoAnanlyzer;
import MediaMessagePackage.MediaMessage_VideoAnanlyzerResult;
import MediaObjectPackage.LiveShowMediaObjectDescription;
import MediaObjectPackage.MediaConstants;
import MediaObjectPackage.MediaObject_PlayStatus;
import MediaObjectPackage.MediaSource;
import MediaPlayerPackage.FFmpegVideoAnalyzer;
import MediaPlayerPackage.LiveShow_MediaPlayer;
import MediaVirtualPackage.LiveShowMediaObject;
import PlayMediaPackage.PlayMedia;
import ServerAutoDetectPackage.ServerAutoDetect;
import ServerAutoDetectPackage.ServerAutoDetect_Client;
import SocketManagementPackage.LiveDBStream;
import SocketMessagePackage.LiveDBConnectionDescription;
import SocketMessagePackage.LiveDBMessageStreamInfo;
import StartPackage.LiveShowMediaSystem;
import SynchronizationPackage.EventQueueHandler;
import SynchronizationPackage.JobHandler;
import Text.NameExtension;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class MediaServer
implements LiveDBClientListener,
LiveShowObjectListener,
ServerAutoDetect.ServerAutoDetect_Listener,
Externalizable {
    public static final int SOFTWAREVERSION = 1;
    public static final String FILESUFFIX = ".lms";
    public static String DEFAULTMEDIASERVERNAME = "MediaServer";
    public static final String PROP_CHANGED = "mediaserverChanged";
    public static final String PROP_CLOSED = "mediaserverClosed";
    private static ArrayList<MediaRefreshListener> s_MediaRefreshListeners = new ArrayList();
    private static final Object s_SyncMediaObjectListener = new Object();
    private String m_ID;
    private String m_Name;
    private ServerAutoDetect.DetectedServer m_DetectedServer;
    private String m_ServerName;
    private LiveDBClient m_LiveDBClient;
    private LiveDBConnectionDescription m_ConnectionDescription;
    private boolean m_WasConnected;
    private boolean m_MediaServerRunsLocal;
    private ServerAutoDetect_Client m_ServerAutoDetect_Client;
    private ArrayList<MediaServerListener> m_MediaServerListeners;
    private final Object m_SyncMediaServerListeners = new Object();
    private Dimension m_ScreenSize;
    private ArrayList<LiveShowMediaObject> m_LiveShowMediaObjects;
    protected SinglePropertyChangeSupport m_PropertyChangeSupport;
    private final Object m_SyncLiveShowMediaObjects = new Object();
    private UploadNotifications m_UploadNotifications;
    public MediaServer m_SelfReference;
    private Runnable m_Runnable_MediaServerRefresh = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList o_MediaRefreshListeners;
            Object object = s_SyncMediaObjectListener;
            synchronized (object) {
                o_MediaRefreshListeners = new ArrayList(s_MediaRefreshListeners.size());
                o_MediaRefreshListeners.addAll(s_MediaRefreshListeners);
            }
            for (int intListener = 0; intListener < o_MediaRefreshListeners.size(); ++intListener) {
                MediaRefreshListener o_MediaRefreshListener = (MediaRefreshListener)o_MediaRefreshListeners.get(intListener);
                o_MediaRefreshListener.event_MediaServerObjectChanged(MediaServer.this.m_SelfReference);
            }
        }
    };

    public MediaServer() {
        this.initMembers();
        this.m_SelfReference = this;
        this.m_Name = this.createName(DEFAULTMEDIASERVERNAME);
        this.m_ServerAutoDetect_Client = ServerAutoDetect_Client.startServerAutoDetect((Object)this, (String)MediaConstants.MEDIASERVERTASKID, (int)15109);
    }

    private void initMembers() {
        this.m_MediaServerListeners = new ArrayList();
        this.m_ScreenSize = new Dimension(LiveShow_MediaPlayer.RENDER_SIZE_HD_1080);
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
        this.m_ID = LiveGUID.getUID();
        this.m_ServerName = "";
        this.m_LiveDBClient = null;
        try {
            InetAddress o_InetAddress = InetAddress.getLocalHost();
            String stringIP = o_InetAddress.getHostAddress();
        }
        catch (Exception e) {
            String stringIP = "127.0.0.1";
        }
        this.m_ConnectionDescription = LiveDBClientKernel.createConnectionDescription_ClientSide((String)"", (int)0, null, (boolean)true, (String)String.valueOf(1), (String)"LiveShow", (String)"XXX", (int)0);
        this.refreshMediaServerDescription();
        this.m_LiveShowMediaObjects = new ArrayList();
        this.m_WasConnected = false;
        this.m_MediaServerRunsLocal = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.m_UploadNotifications != null) {
            this.m_UploadNotifications.cancelUploads();
        }
        ServerAutoDetect_Client.stopServerAutoDetect((Object)this, (String)MediaConstants.MEDIASERVERTASKID);
        ServerAutoDetect_Client o_ServerAutoDetect_Client = LiveShowMediaSystem.getServerAutoDetect_Client();
        if (o_ServerAutoDetect_Client != null) {
            o_ServerAutoDetect_Client.removeServerAutoDetectListener((ServerAutoDetect.ServerAutoDetect_Listener)this);
        }
        LiveDBClient o_LiveDBClient = this.m_LiveDBClient;
        LiveShowMediaSystem.s_MediaServerTableModel.removeMediaServer(this);
        if (o_LiveDBClient != null) {
            o_LiveDBClient.removeLiveDBClientListener((LiveDBClientListener)this);
            o_LiveDBClient.close();
        }
        this.m_LiveDBClient = null;
        Object object = this.m_SyncLiveShowMediaObjects;
        synchronized (object) {
            for (int intMediaObject = this.m_LiveShowMediaObjects.size() - 1; intMediaObject >= 0; --intMediaObject) {
                LiveShowMediaObject o_LiveShowMediaObject = this.m_LiveShowMediaObjects.get(intMediaObject);
                if (o_LiveShowMediaObject == null) continue;
                o_LiveShowMediaObject.removeMediaServer(this);
            }
        }
        this.m_PropertyChangeSupport.firePropertyChange(PROP_CLOSED, this, null);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeUTF(this.m_ID);
        out.writeUTF(this.m_Name);
        this.m_ConnectionDescription.writeExternal(out);
        out.writeBoolean(this.m_WasConnected);
        out.writeInt(this.m_ScreenSize.width);
        out.writeInt(this.m_ScreenSize.height);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        this.m_ID = in.readUTF();
        this.m_Name = in.readUTF();
        this.m_ConnectionDescription = new LiveDBConnectionDescription();
        this.m_ConnectionDescription.readExternal(in);
        this.m_WasConnected = in.readBoolean();
        int intScreenWidth = in.readInt();
        int intScreenHeight = in.readInt();
        this.m_ScreenSize.setSize(intScreenWidth, intScreenHeight);
        if (this.m_WasConnected) {
            // empty if block
        }
    }

    public static int getMediaServerCount() {
        return LiveShowMediaSystem.getMediaServerCount();
    }

    public static MediaServer getMediaServer(int p_Index) {
        return LiveShowMediaSystem.getMediaServer(p_Index);
    }

    public static boolean saveMediaServers(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        try {
            File o_File = new File(stringFileName);
            if (o_File.exists()) {
                try {
                    o_File.delete();
                }
                catch (Exception e) {
                    return false;
                }
            }
            o_File.createNewFile();
            FileOutputStream o_FileOutputStream = new FileOutputStream(o_File);
            ObjectOutputStream o_ObjectOutput = new ObjectOutputStream(o_FileOutputStream);
            o_ObjectOutput.writeInt(1);
            int intMediaServerCount = MediaServer.getMediaServerCount();
            o_ObjectOutput.writeInt(intMediaServerCount);
            for (int intMediaServer = 0; intMediaServer < intMediaServerCount; ++intMediaServer) {
                MediaServer o_MediaServer = MediaServer.getMediaServer(intMediaServer);
                if (o_MediaServer == null) continue;
                o_MediaServer.writeExternal(o_ObjectOutput);
            }
            o_ObjectOutput.close();
            o_FileOutputStream.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean deleteMediaServers(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        boolean boolSuccess = false;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        File o_File = new File(stringFileName);
        if (o_File.exists()) {
            try {
                boolSuccess = o_File.delete();
            }
            catch (Exception e) {
                return false;
            }
        }
        return boolSuccess;
    }

    public static boolean loadMediaServers(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        FileInputStream o_FileInputStream = null;
        ObjectInput o_ObjectInput = null;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        boolean boolIsImport = p_LiveShowProjectDescription != null && !p_LiveShow_ImportDescription.getLoadNewProject();
        try {
            File o_File = new File(stringFileName);
            o_FileInputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_FileInputStream);
            int intSoftwareVersion = o_ObjectInput.readInt();
            int intMediaServerCount = o_ObjectInput.readInt();
            for (int intMediaServer = 0; intMediaServer < intMediaServerCount; ++intMediaServer) {
                MediaServer o_MediaServer = new MediaServer();
                o_MediaServer.readExternal(o_ObjectInput);
                if (MediaServer.getMediaServer(o_MediaServer.getID()) != null) {
                    o_MediaServer.close();
                    continue;
                }
                LiveDBConnectionDescription o_LiveDBConnectionDescription = o_MediaServer.getLiveDBConnectionDescription();
                if (o_LiveDBConnectionDescription == null) {
                    o_MediaServer.close();
                    continue;
                }
                if (MediaServer.getMediaServer(o_LiveDBConnectionDescription.getServerRemoteURL(), String.valueOf(o_LiveDBConnectionDescription.getServerPort())) != null) {
                    o_MediaServer.close();
                    continue;
                }
                if (boolIsImport) {
                    String stringNewMediaServerName = LiveShow_ImportDescription.createImportedName(o_MediaServer.getName());
                    o_MediaServer.setName(stringNewMediaServerName);
                }
                LiveShowMediaSystem.s_MediaServerTableModel.addMediaServer(o_MediaServer);
            }
            o_ObjectInput.close();
            o_FileInputStream.close();
        }
        catch (Exception e) {
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public static void sendPlayStatus(String p_ProducerName, MediaObject_PlayStatus p_MediaObject_PlayStatus) {
        if (p_ProducerName == null) {
            return;
        }
        if (p_MediaObject_PlayStatus == null) {
            return;
        }
        int intMediaServerCount = MediaServer.getMediaServerCount();
        for (int intMediaServer = 0; intMediaServer < intMediaServerCount; ++intMediaServer) {
            MediaServer o_MediaServer = MediaServer.getMediaServer(intMediaServer);
            if (o_MediaServer == null) continue;
            o_MediaServer.sendMessage_PlayStatus(p_ProducerName, p_MediaObject_PlayStatus);
        }
    }

    public static void sendMainTransparency(float p_MainTransparency) {
        int intMediaServerCount = MediaServer.getMediaServerCount();
        for (int intMediaServer = 0; intMediaServer < intMediaServerCount; ++intMediaServer) {
            MediaServer o_MediaServer = MediaServer.getMediaServer(intMediaServer);
            if (o_MediaServer == null) continue;
            o_MediaServer.sendMessage_MainTransparency(p_MainTransparency);
        }
    }

    public static void sendMainSoundVolume(float p_MainSounndVolume) {
        int intMediaServerCount = MediaServer.getMediaServerCount();
        for (int intMediaServer = 0; intMediaServer < intMediaServerCount; ++intMediaServer) {
            MediaServer o_MediaServer = MediaServer.getMediaServer(intMediaServer);
            if (o_MediaServer == null) continue;
            o_MediaServer.sendMessage_MainSoundVolume(p_MainSounndVolume);
        }
    }

    public static void sendShutdownAll(boolean p_Restart) {
        int intMediaServerCount = MediaServer.getMediaServerCount();
        for (int intMediaServer = 0; intMediaServer < intMediaServerCount; ++intMediaServer) {
            MediaServer o_MediaServer = MediaServer.getMediaServer(intMediaServer);
            if (o_MediaServer == null) continue;
            o_MediaServer.sendMessage_Shutdown(p_Restart);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public String getID() {
        return this.m_ID;
    }

    public String createName(String p_Name) {
        int intPrefixCount = 0;
        int intMaxPostFix = 0;
        String stringPrefix = p_Name == null || p_Name.length() <= 0 ? DEFAULTMEDIASERVERNAME : NameExtension.getPrefix(p_Name);
        for (int intServer = 0; intServer < MediaServer.getMediaServerCount(); ++intServer) {
            int intPostfix;
            MediaServer o_MediaServer = MediaServer.getMediaServer(intServer);
            if (o_MediaServer == null || (intPostfix = NameExtension.getPostfix_Int(o_MediaServer.getName(), stringPrefix)) == -2) continue;
            if (intPostfix == -1) {
                intPostfix = ++intPrefixCount;
            }
            if (intPostfix <= intMaxPostFix) continue;
            intMaxPostFix = intPostfix;
        }
        return NameExtension.createName(stringPrefix, ++intMaxPostFix, "000", true);
    }

    public String getName() {
        return this.m_Name;
    }

    public void setName(String p_Name) {
        if (p_Name == null) {
            return;
        }
        this.m_Name = p_Name;
        this.refreshMediaServerDescription();
    }

    public static MediaServer getMediaServer(LiveDBClient p_LiveDBClient) {
        return LiveShowMediaSystem.s_MediaServerTableModel.getMediaServer(p_LiveDBClient);
    }

    public static MediaServer getMediaServer(String p_MediaServerID) {
        return LiveShowMediaSystem.s_MediaServerTableModel.getMediaServer(p_MediaServerID);
    }

    public static MediaServer getMediaServer(String p_ServerURL, String p_ServerPort) {
        return LiveShowMediaSystem.s_MediaServerTableModel.getMediaServer(p_ServerURL, p_ServerPort);
    }

    public LiveDBClient getLiveDBClient() {
        return this.m_LiveDBClient;
    }

    public int getConnectionStatus() {
        LiveDBClient o_LiveDBClient = this.m_LiveDBClient;
        if (o_LiveDBClient == null) {
            return 0;
        }
        return o_LiveDBClient.getConnectionStatus();
    }

    public void setDetectedServer(ServerAutoDetect.DetectedServer p_DetectedServer) {
        this.m_DetectedServer = p_DetectedServer;
        if (this.m_DetectedServer == null) {
            this.setServerURL("");
            this.setServerPort(0);
            this.setServerName("");
            this.setClientLocalIP("");
        } else {
            this.setServerID(this.m_DetectedServer.getServerID());
            this.setServerURL(this.m_DetectedServer.getServerIP());
            this.setServerPort(this.m_DetectedServer.getServerPort());
            this.setServerName(this.m_DetectedServer.getComputerName());
            this.setClientLocalIP(this.m_DetectedServer.getClientIP());
        }
        this.refreshMediaServerDescription();
    }

    public ServerAutoDetect.DetectedServer getDetectedServer() {
        return this.m_DetectedServer;
    }

    public void setServerName(String p_ServerName) {
        this.m_ServerName = p_ServerName == null ? "" : p_ServerName;
    }

    public String getServerName() {
        return this.m_ServerName;
    }

    public void setServerURL(String p_ServerURL) {
        if (p_ServerURL == null) {
            return;
        }
        this.m_ConnectionDescription.setServerRemoteURL(p_ServerURL);
    }

    public String getServerURL() {
        return this.m_ConnectionDescription.getServerRemoteURL();
    }

    public void setServerPort(int p_ServerPort) {
        this.m_ConnectionDescription.setServerPort(p_ServerPort);
    }

    public void setServerPort(String p_ServerPort) {
        int intServerPort;
        if (p_ServerPort == null) {
            return;
        }
        try {
            intServerPort = Integer.valueOf(p_ServerPort);
        }
        catch (Exception e) {
            return;
        }
        this.m_ConnectionDescription.setServerPort(intServerPort);
        this.refreshMediaServerDescription();
    }

    public String getServerPort() {
        return String.valueOf(this.m_ConnectionDescription.getServerPort());
    }

    public void setServerID(String p_ServerID) {
        if (p_ServerID == null) {
            return;
        }
        this.m_ConnectionDescription.setServerID(p_ServerID);
    }

    public String getServerID() {
        return this.m_ConnectionDescription.getServerID();
    }

    public LiveDBConnectionDescription getLiveDBConnectionDescription() {
        return this.m_ConnectionDescription;
    }

    public boolean getMediaServerRunsLocal() {
        return this.m_MediaServerRunsLocal;
    }

    public void setClientLocalIP(String p_ClientLocalIP) {
        this.m_ConnectionDescription.setClientLocalIP(p_ClientLocalIP);
    }

    public void connectToServer() {
        LiveDBClient o_LiveDBClient = this.m_LiveDBClient;
        if (o_LiveDBClient != null) {
            if (o_LiveDBClient.getConnectionStatus() == 1) {
                return;
            }
            if (o_LiveDBClient.getConnectionStatus() == 9) {
                return;
            }
            o_LiveDBClient.close();
        }
        if (this.m_DetectedServer != null) {
            this.m_ConnectionDescription.setServerRemoteURL(this.m_DetectedServer.getServerIP());
        }
        if ((o_LiveDBClient = (this.m_LiveDBClient = LiveDBClientKernel.createLiveDBClient((LiveDBConnectionDescription)this.m_ConnectionDescription))) != null) {
            o_LiveDBClient.addLiveDBClientListener((LiveDBClientListener)this);
        }
        LiveDBClientKernel.connectClient((LiveDBClient)o_LiveDBClient);
        this.refreshMediaServerDescription();
    }

    public void disconnectServer() {
        this.m_WasConnected = false;
        LiveDBClient o_LiveDBClient = this.m_LiveDBClient;
        if (o_LiveDBClient != null) {
            o_LiveDBClient.close();
            this.m_LiveDBClient = null;
        }
        this.refreshMediaServerDescription();
    }

    public boolean getWasConnected() {
        return this.m_WasConnected;
    }

    public boolean isConnected() {
        LiveDBClient o_LiveDBClient = this.m_LiveDBClient;
        if (o_LiveDBClient == null) {
            return false;
        }
        return o_LiveDBClient.isConnected();
    }

    public void refreshMediaServerDescription() {
        LiveShowMediaSystem.s_MediaServerTableModel.refreshMediaServer(this);
        LiveShowMediaSystem.s_MediaServerSelectionTableModel.refreshMediaServer(this);
        boolean boolChanged = false;
        if (boolChanged) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_CHANGED, null, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLiveShowMediaObject(LiveShowMediaObject p_LiveShowMediaObject) {
        if (p_LiveShowMediaObject == null) {
            return;
        }
        Object object = this.m_SyncLiveShowMediaObjects;
        synchronized (object) {
            if (this.m_LiveShowMediaObjects.contains(p_LiveShowMediaObject)) {
                return;
            }
            this.m_LiveShowMediaObjects.add(p_LiveShowMediaObject);
            p_LiveShowMediaObject.addLiveShowObjectListener(this);
        }
        this.sendMessage_AddLiveShowMediaObject(p_LiveShowMediaObject);
        this.notifyMediaRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLiveShowMediaObject(LiveShowMediaObject p_LiveShowMediaObject) {
        if (p_LiveShowMediaObject == null) {
            return;
        }
        Object object = this.m_SyncLiveShowMediaObjects;
        synchronized (object) {
            int intIndex = this.m_LiveShowMediaObjects.indexOf(p_LiveShowMediaObject);
            if (intIndex < 0) {
                return;
            }
            p_LiveShowMediaObject.removeLiveShowObjectListener(this);
            this.m_LiveShowMediaObjects.remove(intIndex);
        }
        this.sendMessage_RemoveLiveShowMediaObject(p_LiveShowMediaObject);
    }

    private void sendMessage_AddLiveShowMediaObject(LiveShowMediaObject p_LiveShowMediaObject) {
        if (p_LiveShowMediaObject == null) {
            return;
        }
        LiveDBClient o_LiveDBClient = this.m_LiveDBClient;
        if (o_LiveDBClient == null) {
            return;
        }
        if (!o_LiveDBClient.isConnected()) {
            return;
        }
        MediaMessage_AddLiveShowMediaObject o_MediaMessage_AddLiveShowMediaObject = new MediaMessage_AddLiveShowMediaObject((LiveShowMediaObjectDescription)p_LiveShowMediaObject.getDescription(), p_LiveShowMediaObject.getMediaSource());
        o_LiveDBClient.sendMessage((Serializable)o_MediaMessage_AddLiveShowMediaObject);
    }

    private void sendMessage_RemoveLiveShowMediaObject(LiveShowMediaObject p_LiveShowMediaObject) {
        if (p_LiveShowMediaObject == null) {
            return;
        }
        LiveDBClient o_LiveDBClient = this.m_LiveDBClient;
        if (o_LiveDBClient == null) {
            return;
        }
        if (!o_LiveDBClient.isConnected()) {
            return;
        }
        MediaMessage_RemoveLiveShowMediaObject o_MediaMessage_RemoveLiveShowMediaObject = new MediaMessage_RemoveLiveShowMediaObject((LiveShowMediaObjectDescription)p_LiveShowMediaObject.getDescription());
        o_LiveDBClient.sendMessage((Serializable)o_MediaMessage_RemoveLiveShowMediaObject);
    }

    private void sendMessage_PlayStatus(String p_ProducerName, MediaObject_PlayStatus p_MediaObject_PlayStatus) {
        if (p_ProducerName == null) {
            return;
        }
        if (p_MediaObject_PlayStatus == null) {
            return;
        }
        LiveDBClient o_LiveDBClient = this.m_LiveDBClient;
        if (o_LiveDBClient == null) {
            return;
        }
        if (!o_LiveDBClient.isConnected()) {
            return;
        }
        MediaMessage_PlayStatus o_MediaMessage_PlayStatus = new MediaMessage_PlayStatus(p_ProducerName, p_MediaObject_PlayStatus);
        o_LiveDBClient.sendMessage((Serializable)o_MediaMessage_PlayStatus);
    }

    private void sendMessage_MainTransparency(float p_MainTransparency) {
        LiveDBClient o_LiveDBClient = this.m_LiveDBClient;
        if (o_LiveDBClient == null) {
            return;
        }
        if (!o_LiveDBClient.isConnected()) {
            return;
        }
        MediaMessage_MainTransparency o_MediaMessage_MainTransparency = new MediaMessage_MainTransparency(p_MainTransparency);
        o_LiveDBClient.sendMessage((Serializable)o_MediaMessage_MainTransparency);
    }

    private void sendMessage_MainSoundVolume(float p_MainSoundVolume) {
        LiveDBClient o_LiveDBClient = this.m_LiveDBClient;
        if (o_LiveDBClient == null) {
            return;
        }
        if (!o_LiveDBClient.isConnected()) {
            return;
        }
        MediaMessage_MainSoundVolume o_MediaMessage_MainSoundVolume = new MediaMessage_MainSoundVolume(p_MainSoundVolume);
        o_LiveDBClient.sendMessage((Serializable)o_MediaMessage_MainSoundVolume);
    }

    public void sendMessage_Sweep() {
        LiveDBClient o_LiveDBClient = this.m_LiveDBClient;
        if (o_LiveDBClient == null) {
            return;
        }
        if (!o_LiveDBClient.isConnected()) {
            return;
        }
        MediaMessage_Sweep o_MediaMessage_Sweep = new MediaMessage_Sweep();
        o_LiveDBClient.sendMessage((Serializable)o_MediaMessage_Sweep);
    }

    public void sendMessage_VideoAnalyzer() {
        LiveDBClient o_LiveDBClient = this.m_LiveDBClient;
        if (o_LiveDBClient == null) {
            return;
        }
        if (!o_LiveDBClient.isConnected()) {
            return;
        }
        MediaMessage_VideoAnanlyzer o_MediaMessage_VideoAnanlyzer = new MediaMessage_VideoAnanlyzer(MediaSource.s_VideoAnalyzer_ON);
        o_LiveDBClient.sendMessage((Serializable)o_MediaMessage_VideoAnanlyzer);
    }

    public void sendMessage_MediaObjectChanged(LiveShowMediaObject p_LiveShowMediaObject, LiveShowMediaObjectDescription p_LiveShowMediaObjectDescription) {
        if (p_LiveShowMediaObject == null) {
            return;
        }
        if (p_LiveShowMediaObjectDescription == null) {
            return;
        }
        LiveDBClient o_LiveDBClient = this.m_LiveDBClient;
        if (o_LiveDBClient == null) {
            return;
        }
        if (!o_LiveDBClient.isConnected()) {
            return;
        }
        MediaMessage_MediaObjectChanged o_MediaMessage_MediaObjectChanged = new MediaMessage_MediaObjectChanged(p_LiveShowMediaObjectDescription);
        o_LiveDBClient.sendMessage((Serializable)o_MediaMessage_MediaObjectChanged);
    }

    public void sendMessage_Shutdown(boolean p_Restart) {
        LiveDBClient o_LiveDBClient = this.m_LiveDBClient;
        if (o_LiveDBClient == null) {
            return;
        }
        if (!o_LiveDBClient.isConnected()) {
            return;
        }
        if (this.m_MediaServerRunsLocal) {
            return;
        }
        MediaMessage_Shutdown o_MediaMessage_Shutdown = new MediaMessage_Shutdown(p_Restart);
        o_LiveDBClient.sendMessage((Serializable)o_MediaMessage_Shutdown);
    }

    public void sendMediaFile(final File p_MediaFile) {
        if (p_MediaFile == null) {
            return;
        }
        if (!p_MediaFile.exists()) {
            return;
        }
        final LiveDBClient o_LiveDBClient = this.m_LiveDBClient;
        if (o_LiveDBClient == null) {
            return;
        }
        final int intFileType = MediaSource.autoDetectMediaType((File)p_MediaFile);
        if (intFileType != 1003 && intFileType != 1001 && intFileType != 1002 && intFileType != 1003) {
            return;
        }
        Runnable o_RunnableSend = new Runnable(){

            @Override
            public void run() {
                LiveDBStream o_LiveDBStream = null;
                FileInputStream o_FileInputStream = null;
                try {
                    o_FileInputStream = new FileInputStream(p_MediaFile);
                }
                catch (Exception e) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(2000L);
                        o_FileInputStream = new FileInputStream(p_MediaFile);
                    }
                    catch (Exception e_wait) {
                        MediaMessage_RefreshMediaSource_Error o_MediaMessage_RefreshMediaSource_Error = new MediaMessage_RefreshMediaSource_Error(p_MediaFile.getName(), p_MediaFile.getAbsolutePath());
                        o_LiveDBClient.sendMessage((Serializable)o_MediaMessage_RefreshMediaSource_Error);
                        return;
                    }
                }
                try {
                    o_LiveDBStream = o_LiveDBClient.sendMessageAsStream((InputStream)o_FileInputStream, intFileType, 0, p_MediaFile.length(), p_MediaFile.getName());
                }
                catch (Exception e) {
                    if (o_LiveDBStream != null) {
                        o_LiveDBStream.cancel(e.getMessage());
                    }
                    return;
                }
                if (!(o_LiveDBStream == null || o_LiveDBStream.getCanceled() || o_LiveDBStream.getError() || o_LiveDBStream.getEndOfStream())) {
                    if (MediaServer.this.m_UploadNotifications == null) {
                        MediaServer.this.m_UploadNotifications = new UploadNotifications();
                    }
                    MediaServer.this.m_UploadNotifications.startUpload(MediaServer.this.m_SelfReference, o_LiveDBStream, p_MediaFile);
                }
            }
        };
        JobHandler.addJob(o_RunnableSend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConnectionStatus_Objects(int p_ConnectionStatus) {
        LiveShowMediaObject o_LiveShowMediaObject;
        int intObject;
        ArrayList<LiveShowMediaObject> o_LiveShowMediaObjects;
        LiveShowMediaSystem.s_MediaServerTableModel.refreshMediaServer(this);
        LiveShowMediaSystem.s_MediaServerSelectionTableModel.refreshMediaServer(this);
        Object object = this.m_SyncLiveShowMediaObjects;
        synchronized (object) {
            if (this.m_LiveShowMediaObjects.size() <= 0) {
                return;
            }
            o_LiveShowMediaObjects = new ArrayList<LiveShowMediaObject>(this.m_LiveShowMediaObjects.size());
            o_LiveShowMediaObjects.addAll(this.m_LiveShowMediaObjects);
        }
        for (intObject = 0; intObject < o_LiveShowMediaObjects.size(); ++intObject) {
            o_LiveShowMediaObject = (LiveShowMediaObject)o_LiveShowMediaObjects.get(intObject);
            if (o_LiveShowMediaObject == null) continue;
            o_LiveShowMediaObject.eventMediaServerConnection(this, p_ConnectionStatus);
        }
        switch (p_ConnectionStatus) {
            case 2: 
            case 3: {
                for (intObject = 0; intObject < o_LiveShowMediaObjects.size(); ++intObject) {
                    o_LiveShowMediaObject = (LiveShowMediaObject)o_LiveShowMediaObjects.get(intObject);
                    if (o_LiveShowMediaObject == null) continue;
                    this.sendMessage_AddLiveShowMediaObject(o_LiveShowMediaObject);
                }
                this.notifyMediaRefresh();
            }
        }
    }

    public void eventClientConnectionStatus(LiveDBClient p_LiveDBClient, final int p_ConnectionStatus) {
        switch (p_ConnectionStatus) {
            case 2: 
            case 3: {
                this.m_WasConnected = true;
                this.m_ConnectionDescription = p_LiveDBClient.getLiveDBConnectionDescription().clone(this.m_ConnectionDescription);
                ServerAutoDetect_Client.stopServerAutoDetect((Object)this, (String)MediaConstants.MEDIASERVERTASKID);
                String stringClientLocalIP = this.m_ConnectionDescription.getClientLocalIP();
                String stringServerRemoteIP = this.m_ConnectionDescription.getServerRemoteIP();
                if (stringClientLocalIP.equals(stringServerRemoteIP)) {
                    this.m_MediaServerRunsLocal = true;
                }
                MediaServer.sendMainSoundVolume((float)PlayMedia.s_MainSoundVolume);
                MediaServer.sendMainTransparency((float)PlayMedia.s_MainTransparency);
                this.sendMessage_VideoAnalyzer();
                break;
            }
            case 0: 
            case 6: 
            case 8: {
                if (this.m_UploadNotifications != null) {
                    this.m_UploadNotifications.cancelUploads();
                }
                this.m_MediaServerRunsLocal = false;
                this.m_ServerAutoDetect_Client = ServerAutoDetect_Client.startServerAutoDetect((Object)this, (String)MediaConstants.MEDIASERVERTASKID, (int)15109);
                break;
            }
            case 1: 
            case 9: {
                this.m_MediaServerRunsLocal = false;
            }
        }
        EventQueueHandler.invokeLater(new Runnable(){

            @Override
            public void run() {
                MediaServer.this.notifyConnectionStatus_Objects(p_ConnectionStatus);
            }
        });
    }

    public void eventClientMessageReadUnknown(LiveDBClient p_LiveDBClient) {
    }

    public void eventClientMessageWritten(LiveDBClient p_LiveDBClient, Object p_MessageObject) {
    }

    public void eventClientError(LiveDBClient p_LiveDBClient, Exception p_Exception, String p_Remark) {
    }

    @Override
    public void eventObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        if (p_LiveShowObjectDescription == null) {
            return;
        }
        if (!this.m_LiveShowMediaObjects.contains(p_LiveShowObjectInterface)) {
            return;
        }
        LiveShowMediaObject o_LiveShowMediaObject = (LiveShowMediaObject)p_LiveShowObjectInterface;
        LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = (LiveShowMediaObjectDescription)p_LiveShowObjectDescription;
        this.sendMessage_MediaObjectChanged(o_LiveShowMediaObject, o_LiveShowMediaObjectDescription);
        this.notifyMediaRefresh();
    }

    @Override
    public void eventObjectVolumeChanged(LiveShowObjectInterface p_LiveShowObjectInterface, float p_Volume) {
    }

    @Override
    public void eventObjectAdditionalChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
    }

    @Override
    public void eventObjectClosed(LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventObjectSelection(LiveShowObjectInterface p_LiveShowObjectInterface, boolean p_IsSelected, boolean p_Added) {
    }

    public void parseMessage(LiveDBClient p_LiveDBClient, Serializable p_MessageObject) {
        if (p_LiveDBClient != this.m_LiveDBClient) {
            return;
        }
        if (p_MessageObject instanceof MediaMessage_RequestMediaSource) {
            MediaMessage_RequestMediaSource o_Message_RequestSource = (MediaMessage_RequestMediaSource)p_MessageObject;
            String stringOriginalFilePathName = o_Message_RequestSource.getOriginalFilePathName();
            File o_MediaFile = new File(stringOriginalFilePathName);
            if (!o_MediaFile.exists()) {
                return;
            }
            this.sendMediaFile(o_MediaFile);
        } else if (p_MessageObject instanceof MediaMessage_MediaServerInfo) {
            MediaMessage_MediaServerInfo o_Message_MediaServerInfo = (MediaMessage_MediaServerInfo)p_MessageObject;
            this.setScreenSize(o_Message_MediaServerInfo.getScreenSize());
            this.notifyMediaServerListener_Info();
        } else if (p_MessageObject instanceof MediaMessage_VideoAnanlyzerResult) {
            this.parseMessage_VideoAnalyzerResult((MediaMessage_VideoAnanlyzerResult)p_MessageObject);
        }
    }

    public void parseMessageIncomingStreamStart(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, LiveDBMessageStreamInfo p_StreamInfo) {
    }

    public void parseMessageIncomingStreamEnd(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
    }

    public void parseMessageIncomingStreamPackage(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, long p_ReceivedBytesCount) {
    }

    public void parseMessageOutgoingStreamStart(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingingStream, LiveDBMessageStreamInfo p_StreamInfo) {
    }

    public void parseMessageOutgoingStreamEnd(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
        if (p_EndOfStream) {
            if (this.m_UploadNotifications != null) {
                this.m_UploadNotifications.setEnd(p_OutgoingStream);
            }
        } else if (p_Canceled) {
            if (this.m_UploadNotifications != null) {
                this.m_UploadNotifications.setCancelled(p_OutgoingStream);
            }
        } else if (p_Error && this.m_UploadNotifications != null) {
            this.m_UploadNotifications.setError(p_OutgoingStream);
        }
    }

    public void parseMessageOutgoingStreamConfirmed(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingStream, long p_ReceivedBytesCount) {
        if (this.m_UploadNotifications != null) {
            this.m_UploadNotifications.setProgress(p_OutgoingStream);
        }
    }

    public void parseMessage_VideoAnalyzerResult(MediaMessage_VideoAnanlyzerResult p_MediaMessage_VideoAnanlyzerResult) {
        FFmpegVideoAnalyzer.VideoAnalyzerResult o_VideoAnalyzerResult = p_MediaMessage_VideoAnanlyzerResult.getVideoAnalyzerResult();
        if (o_VideoAnalyzerResult == null) {
            return;
        }
        if (MediaSource.s_VideoAnalyzer_ON) {
            if (o_VideoAnalyzerResult.getVideoOK() && o_VideoAnalyzerResult.getAudioOK()) {
                return;
            }
            FFmpegVideoAnalyzer.showWarningDialog((FFmpegVideoAnalyzer.VideoAnalyzerResult)o_VideoAnalyzerResult);
        }
    }

    public void setScreenSize(Dimension p_ScreenSize) {
        if (p_ScreenSize == null) {
            return;
        }
        this.m_ScreenSize.setSize(p_ScreenSize);
    }

    public Dimension getScreenSize() {
        return this.m_ScreenSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMediaServerListener(MediaServerListener p_MediaServerListener) {
        if (p_MediaServerListener == null) {
            return;
        }
        Object object = this.m_SyncMediaServerListeners;
        synchronized (object) {
            if (this.m_MediaServerListeners.contains(p_MediaServerListener)) {
                return;
            }
            this.m_MediaServerListeners.add(p_MediaServerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMediaServerListener(MediaServerListener p_MediaServerListener) {
        if (p_MediaServerListener == null) {
            return;
        }
        Object object = this.m_SyncMediaServerListeners;
        synchronized (object) {
            this.m_MediaServerListeners.remove(p_MediaServerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaServerListener_Info() {
        ArrayList<MediaServerListener> o_MediaServerListeners;
        Object object = this.m_SyncMediaServerListeners;
        synchronized (object) {
            o_MediaServerListeners = new ArrayList<MediaServerListener>(this.m_MediaServerListeners.size());
            o_MediaServerListeners.addAll(this.m_MediaServerListeners);
        }
        for (int intListener = 0; intListener < o_MediaServerListeners.size(); ++intListener) {
            MediaServerListener o_MediaServerListener = (MediaServerListener)o_MediaServerListeners.get(intListener);
            o_MediaServerListener.eventMediaRefresh(this);
        }
    }

    public void eventDetectedServer_Added(ServerAutoDetect.DetectedServer p_DetectedServer) {
        if (p_DetectedServer == null) {
            return;
        }
        LiveDBClient o_LiveDBClient = this.m_LiveDBClient;
        if (o_LiveDBClient != null && o_LiveDBClient.isConnected()) {
            return;
        }
        String stringDetectedServerID = p_DetectedServer.getServerID();
        if (stringDetectedServerID == null || stringDetectedServerID.length() <= 0) {
            return;
        }
        LiveDBConnectionDescription o_LiveDBConnectionDescription = this.m_ConnectionDescription;
        if (o_LiveDBConnectionDescription == null) {
            this.checkOneDetectedServerSelection();
            return;
        }
        if (this.m_WasConnected) {
            if (stringDetectedServerID.equals(o_LiveDBConnectionDescription.getServerID())) {
                int intRow = LiveShowMediaSystem.s_MediaServerTableModel.indexOf(this);
                if (intRow < 0) {
                    return;
                }
                LiveShowMediaSystem.s_MediaServerTableModel.setValueAt(p_DetectedServer, intRow, 1);
                this.connectToServer();
                return;
            }
            this.checkOneDetectedServerSelection();
        } else {
            this.checkOneDetectedServerSelection();
        }
        LiveShowMediaSystem.s_MediaServerTableModel.refreshMediaServer(this);
    }

    public void eventDetectedServer_Changed(ServerAutoDetect.DetectedServer p_DetectedServer) {
    }

    public void eventDetectedServer_Removed(ServerAutoDetect.DetectedServer p_DetectedServer) {
        if (p_DetectedServer == this.m_DetectedServer) {
            int intRow = LiveShowMediaSystem.s_MediaServerTableModel.indexOf(this);
            if (intRow < 0) {
                return;
            }
            LiveShowMediaSystem.s_MediaServerTableModel.setValueAt(null, intRow, 1);
        }
        LiveShowMediaSystem.s_MediaServerTableModel.refreshMediaServer(this);
    }

    public void checkOneDetectedServerSelection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMediaRefreshListener(MediaRefreshListener p_MediaRefreshListener) {
        if (p_MediaRefreshListener == null) {
            return;
        }
        Object object = s_SyncMediaObjectListener;
        synchronized (object) {
            if (s_MediaRefreshListeners.contains(p_MediaRefreshListener)) {
                return;
            }
            s_MediaRefreshListeners.add(p_MediaRefreshListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMediaRefreshListener(MediaRefreshListener p_MediaRefreshListener) {
        if (p_MediaRefreshListener == null) {
            return;
        }
        Object object = s_SyncMediaObjectListener;
        synchronized (object) {
            s_MediaRefreshListeners.remove(p_MediaRefreshListener);
        }
    }

    public void notifyMediaRefresh() {
        EventQueueHandler.invokeLater(this.m_Runnable_MediaServerRefresh);
    }

    public static class UploadNotifications
    implements LiveShowNotificationListener {
        private ArrayList<LiveDBStream> m_ActiveLiveDBStreams;
        private HashMap<String, LiveShowNotification> m_Notifications_Stream;
        private HashMap<String, LiveShowNotification> m_Notifications_File;
        private final Object m_SyncNotifications = new Object();

        public UploadNotifications() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_ActiveLiveDBStreams = new ArrayList();
            this.m_Notifications_Stream = new HashMap();
            this.m_Notifications_File = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelUploads() {
            ArrayList<LiveDBStream> o_LiveDBStreams;
            Object object = this.m_SyncNotifications;
            synchronized (object) {
                o_LiveDBStreams = new ArrayList<LiveDBStream>(this.m_ActiveLiveDBStreams.size());
                o_LiveDBStreams.addAll(this.m_ActiveLiveDBStreams);
            }
            for (int intStream = 0; intStream < o_LiveDBStreams.size(); ++intStream) {
                LiveDBStream o_LiveDBStream = (LiveDBStream)o_LiveDBStreams.get(intStream);
                if (o_LiveDBStream == null) continue;
                Object object2 = this.m_SyncNotifications;
                synchronized (object2) {
                    this.m_ActiveLiveDBStreams.remove(o_LiveDBStream);
                }
                o_LiveDBStream.cancel("MediaServer disconnacted");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startUpload(MediaServer p_MediaServer, LiveDBStream p_LiveDBStream, File p_File) {
            if (p_MediaServer == null) {
                return;
            }
            if (p_LiveDBStream == null) {
                return;
            }
            if (p_File == null) {
                return;
            }
            String stringID = p_LiveDBStream.getID();
            LiveShowNotification o_LiveShowNotification = this.getLiveShowNotification(stringID);
            if (o_LiveShowNotification == null) {
                o_LiveShowNotification = this.m_Notifications_File.get(p_File.getAbsolutePath());
                if (o_LiveShowNotification != null) {
                    o_LiveShowNotification.close();
                }
                o_LiveShowNotification = new LiveShowNotification(LiveShowMediaSystem.UPLOAD_MEDIAFILE + p_MediaServer.getName(), p_LiveDBStream.getDataBytesCount(), 0L, false);
                o_LiveShowNotification.setActionText(p_File.getName());
                o_LiveShowNotification.addListener(this);
                Object object = this.m_SyncNotifications;
                synchronized (object) {
                    if (!this.m_ActiveLiveDBStreams.contains(p_LiveDBStream)) {
                        this.m_ActiveLiveDBStreams.add(p_LiveDBStream);
                    }
                    this.m_Notifications_Stream.put(stringID, o_LiveShowNotification);
                    this.m_Notifications_File.put(p_File.getAbsolutePath(), o_LiveShowNotification);
                    if (p_LiveDBStream.getError()) {
                        this.setError(p_LiveDBStream);
                    } else if (p_LiveDBStream.getCanceled()) {
                        this.setCancelled(p_LiveDBStream);
                    }
                }
            }
        }

        public void setProgress(LiveDBStream p_LiveDBStream) {
            if (p_LiveDBStream == null) {
                return;
            }
            LiveShowNotification o_LiveShowNotification = this.getLiveShowNotification(p_LiveDBStream.getID());
            if (o_LiveShowNotification == null) {
                return;
            }
            o_LiveShowNotification.setProgress(p_LiveDBStream.getDataPositionConfirmed());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setEnd(final LiveDBStream p_LiveDBStream) {
            if (p_LiveDBStream == null) {
                return;
            }
            Object object = this.m_SyncNotifications;
            synchronized (object) {
                this.m_ActiveLiveDBStreams.remove(p_LiveDBStream);
            }
            Runnable o_Runnable = new Runnable(){

                @Override
                public void run() {
                    LiveShowNotification o_LiveShowNotification = this.getLiveShowNotification(p_LiveDBStream.getID());
                    if (o_LiveShowNotification == null) {
                        return;
                    }
                    o_LiveShowNotification.close();
                }
            };
            EventQueueHandler.invokeLater(o_Runnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCancelled(LiveDBStream p_LiveDBStream) {
            if (p_LiveDBStream == null) {
                return;
            }
            Object object = this.m_SyncNotifications;
            synchronized (object) {
                this.m_ActiveLiveDBStreams.remove(p_LiveDBStream);
            }
            LiveShowNotification o_LiveShowNotification = this.getLiveShowNotification(p_LiveDBStream.getID());
            if (o_LiveShowNotification == null) {
                return;
            }
            o_LiveShowNotification.setText("<html><b>" + LiveShowMediaSystem.UPLOAD_CANCELLED + "</b> </html>");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setError(LiveDBStream p_LiveDBStream) {
            if (p_LiveDBStream == null) {
                return;
            }
            Object object = this.m_SyncNotifications;
            synchronized (object) {
                this.m_ActiveLiveDBStreams.remove(p_LiveDBStream);
            }
            LiveShowNotification o_LiveShowNotification = this.getLiveShowNotification(p_LiveDBStream.getID());
            if (o_LiveShowNotification == null) {
                return;
            }
            o_LiveShowNotification.setText("<html><b>" + LiveShowMediaSystem.UPLOAD_ERROR + "</b></html>");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LiveShowNotification getLiveShowNotification(String p_ID) {
            Object object = this.m_SyncNotifications;
            synchronized (object) {
                return this.m_Notifications_Stream.get(p_ID);
            }
        }

        @Override
        public void eventNotificationAdded(LiveShowNotification p_LiveShowNotification) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void eventNotificationClose(LiveShowNotification p_LiveShowNotification) {
            Object object = this.m_SyncNotifications;
            synchronized (object) {
                LiveShowNotification o_LiveShowNotification;
                Iterator<LiveShowNotification> o_Iterator = this.m_Notifications_Stream.values().iterator();
                while (o_Iterator.hasNext()) {
                    o_LiveShowNotification = o_Iterator.next();
                    if (o_LiveShowNotification != p_LiveShowNotification) continue;
                    o_Iterator.remove();
                }
                o_Iterator = this.m_Notifications_File.values().iterator();
                while (o_Iterator.hasNext()) {
                    o_LiveShowNotification = o_Iterator.next();
                    if (o_LiveShowNotification != p_LiveShowNotification) continue;
                    o_Iterator.remove();
                }
            }
        }

        @Override
        public void eventNotificationText(LiveShowNotification p_LiveShowNotification, String p_Text) {
        }

        @Override
        public void eventNotificationActionText(LiveShowNotification p_LiveShowNotification, String p_Text) {
        }

        @Override
        public void eventNotificationProgress(LiveShowNotification p_LiveShowNotification, long p_Progress) {
        }

        @Override
        public void eventNotificationProgressMax(LiveShowNotification p_LiveShowNotification, long p_ProgressMax) {
        }
    }

    public static interface MediaRefreshListener {
        public void event_MediaServerObjectChanged(MediaServer var1);
    }

    public static interface MediaServerListener {
        public void eventMediaRefresh(MediaServer var1);
    }
}

