/*
 * Decompiled with CFR 0.152.
 */
package MediaGraphicsPackage;

import FileToolPackage.FileSelection;
import FileToolPackage.FileTools;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowDragDrop;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.PlayControlCursor;
import LiveShowPlayPackage.PlayControlPanel;
import LiveShowPlayPackage.PlayControlTimePanel;
import LiveShowPlayPackage.PlayJumpInterface;
import LiveShowPlayPackage.PlayListener;
import LiveShowScrollPackage.LiveShowMarkControlPanel;
import LiveShowScrollPackage.LiveShowScrollBarListener;
import LiveShowScrollPackage.LiveShowScrollBarPanel;
import LiveShowScrollPackage.LiveShowTimeBar;
import LiveShowScrollPackage.LiveShowViewListener;
import LiveShowVirtualPackage.LiveShowVIP;
import MediaObjectPackage.LiveShowMediaObjectDescription;
import MediaObjectPackage.MediaSource;
import MediaObjectPackage.MediaSourceListener;
import MediaPlayerPackage.JPanel_MediaSurface;
import MediaPlayerPackage.LiveShow_ImagePool;
import MediaPlayerPackage.LiveShow_MediaPlayer;
import MediaPlayerPackage.LiveShow_MediaPlayer_Image;
import MediaVirtualPackage.LiveShowMediaObject;
import MediaVirtualPackage.LiveShowMediaObjectPanel;
import MediaVirtualPackage.MediaSource_Client;
import PlayMediaPackage.PlayMedia;
import SoundPackage.SoundMixers;
import StartPackage.LiveShowMediaSystem;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import SynchronizationPackage.LiveCloseSemaphore;
import ToolsGraphics.JLabel_ResizeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class LiveShowMediaPanel
extends JPanel
implements ComponentListener,
PlayListener,
MouseInputListener,
MouseWheelListener,
LiveShowScrollBarListener,
DragGestureListener,
DragSourceListener,
LiveShow_MediaPlayer.MediaPlayerListener,
MediaSourceListener {
    public static ImageIcon s_Icon_MenuSoundSettings = new ImageIcon(LiveShowMediaPanel.class.getResource("/IconsPackage/Menu_SoundcardSettings.png"));
    @LiveLanguageString
    public static String LABEL_START = "Start";
    @LiveLanguageString
    public static String LABEL_END = "End";
    @LiveLanguageString
    public static String LABEL_DURATION = "Duration";
    private MediaSource_Client m_MediaSource_Client;
    private LiveShow_MediaPlayer m_LiveShow_MediaPlayer;
    private LiveShowMediaObject m_LiveShowMediaObject;
    private LiveShowMediaObjectPanel m_LiveShowMediaObjectPanel;
    private long m_MediaObjectFrameStart;
    private long m_MediaObjectFrameEnd;
    private long m_VisibleFrameStart;
    private long m_VisibleFrameEnd;
    private boolean m_AutoScroll;
    private boolean m_AutoScrollBlocked;
    private long m_FramePlayCursor;
    private PlayControlCursor m_LiveShowMediaPlayCursor;
    private Section m_Section;
    private PlayControlPanel m_PlayControlPanel;
    private PlayControlTimePanel m_PlayControlTimePanel;
    private LiveShowMarkControlPanel m_LiveShowMarkControlPanel;
    private LiveShowScrollBarPanel m_LiveShowScrollBarPanel;
    private JLabel_ResizeFrame m_JLabel_ResizeFrame;
    public static Color BUTTON_DEFAULTBACKGROUND;
    private ArrayList<LiveShowViewListener> m_LiveShowViewListeners;
    private DragSource m_DragSource;
    private boolean m_DragStartet;
    private LiveCloseSemaphore m_LiveCloseSemaphore;
    private final Object m_SyncViewListeners = new Object();
    private Dimension m_OldSize_jPanel_MediaView;
    private Runnable m_Runnable_EventPlayCursor = new Runnable(){

        @Override
        public void run() {
            try {
                LiveShowMediaPanel.this.calculatePlayCursor();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    };
    private Runnable m_Runnable_RevalidateJPanelMediaView = new Runnable(){

        @Override
        public void run() {
            try {
                LiveShowMediaPanel.this.jPanel_MediaView.revalidate();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    };
    private boolean isSettingZoom = false;
    private Runnable m_RunnableEndZoom = new Runnable(){

        @Override
        public void run() {
            LiveShowMediaPanel.this.isSettingZoom = false;
        }
    };
    public static FileNameExtensionFilter s_FileNameExtensionFilter_PNG;
    private JButton jButton_SaveActualImage;
    private JButton jButton_SoundSettings;
    private JPanel jPanel_Mark;
    private JPanel_MediaSurface jPanel_MediaSurface1;
    private JPanel jPanel_MediaView;
    private JPanel jPanel_PlayControl;
    private JPanel jPanel_Tools;
    private JToolBar jToolBar1;
    private LiveShowTimeBar liveShowTimeBar1;

    public LiveShowMediaPanel(MediaSource_Client p_MediaSource_Client) {
        String stringFileName;
        this.initMembers();
        this.m_MediaSource_Client = p_MediaSource_Client;
        if (this.m_MediaSource_Client == null) {
            return;
        }
        this.m_MediaSource_Client.addMediaSourceListener(this);
        this.m_MediaSource_Client.addReference(this);
        this.m_LiveShowMediaObject = this.m_MediaSource_Client.getLiveShowMediaObject();
        this.m_LiveShow_MediaPlayer = this.m_MediaSource_Client.getLiveShow_MediaPlayer();
        if (this.m_LiveShow_MediaPlayer != null) {
            // empty if block
        }
        this.m_MediaObjectFrameStart = 0L;
        this.m_MediaObjectFrameEnd = this.m_MediaSource_Client.getFrameLength();
        this.m_VisibleFrameStart = this.m_MediaObjectFrameStart;
        this.m_VisibleFrameEnd = this.m_MediaObjectFrameEnd;
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
        if (this.m_LiveShow_MediaPlayer != null) {
            this.m_LiveShow_MediaPlayer.addMediaPlayerListener((LiveShow_MediaPlayer.MediaPlayerListener)this);
        }
        this.setVisibleRegion(this.m_VisibleFrameStart, this.m_VisibleFrameEnd);
        PlayMedia o_PlayMedia = null;
        o_PlayMedia = this.m_MediaSource_Client.getPlay();
        this.m_LiveShowScrollBarPanel.addLiveShowScrollBarListener(this);
        this.addLiveShowViewListener(this.m_LiveShowScrollBarPanel);
        if (o_PlayMedia != null) {
            o_PlayMedia.addPlayListener(this);
            o_PlayMedia.addPlayListener(this.m_LiveShowScrollBarPanel);
        }
        if ((stringFileName = this.liveShowTimeBar1.calculateMarksFilePath(this.m_MediaSource_Client.getFile())) != null) {
            File o_FileMarks = new File(stringFileName);
            this.liveShowTimeBar1.readMarks(o_FileMarks);
        }
        this.notifyMediaObjectViewListeners_ViewChanged(this.getFrameStart(), this.getFrameEnd(), this.m_VisibleFrameStart, this.m_VisibleFrameEnd, this.jPanel_MediaView.getBounds());
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private void initMembers() {
        BUTTON_DEFAULTBACKGROUND = new Color(240, 240, 240);
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_LiveShowMediaObject = null;
        this.m_LiveShowViewListeners = new ArrayList();
        this.m_FramePlayCursor = 0L;
        this.m_AutoScroll = true;
        this.m_AutoScrollBlocked = false;
        this.m_Section = null;
        this.m_LiveShow_MediaPlayer = null;
        this.m_OldSize_jPanel_MediaView = new Dimension(0, 0);
        this.m_DragStartet = false;
    }

    private void initComponentsFurther() {
        PlayMedia o_PlayMedia = null;
        Play.PlaySynchronisizer o_PlaySynchronisizer = null;
        o_PlayMedia = this.m_MediaSource_Client.getPlay();
        if (o_PlayMedia != null) {
            o_PlaySynchronisizer = o_PlayMedia.getPlaySynchronizer();
        }
        this.m_LiveShowScrollBarPanel = new LiveShowScrollBarPanel();
        GridBagConstraints o_Constraints = new GridBagConstraints();
        o_Constraints.gridx = 1;
        o_Constraints.gridy = 2;
        o_Constraints.weightx = 1.0;
        o_Constraints.fill = 2;
        o_Constraints.anchor = 11;
        this.m_LiveShowScrollBarPanel.setVisible(true);
        this.add((Component)this.m_LiveShowScrollBarPanel, o_Constraints);
        this.m_LiveShowMarkControlPanel = new LiveShowMarkControlPanel(this.liveShowTimeBar1);
        o_Constraints = new GridBagConstraints();
        o_Constraints.gridx = 0;
        o_Constraints.gridy = 0;
        o_Constraints.fill = 1;
        o_Constraints.anchor = 11;
        this.m_LiveShowMarkControlPanel.setVisible(true);
        this.jPanel_Mark.add((Component)this.m_LiveShowMarkControlPanel, o_Constraints);
        this.m_PlayControlTimePanel = new PlayControlTimePanel(o_PlayMedia, false, false);
        o_Constraints = new GridBagConstraints();
        o_Constraints.gridx = 0;
        o_Constraints.gridy = 0;
        o_Constraints.fill = 2;
        o_Constraints.anchor = 11;
        this.m_PlayControlTimePanel.setVisible(true);
        this.m_PlayControlTimePanel.setMinimumSize(new Dimension(100, 40));
        this.m_PlayControlTimePanel.setPreferredSize(new Dimension(100, 40));
        this.jPanel_PlayControl.add((Component)this.m_PlayControlTimePanel, o_Constraints);
        this.m_PlayControlPanel = new PlayControlPanel(o_PlaySynchronisizer, 2, true, true, true, true, true, true, false, false, false, false);
        this.m_PlayControlPanel.addPlay(o_PlayMedia);
        o_Constraints = new GridBagConstraints();
        o_Constraints.gridx = 0;
        o_Constraints.gridy = 1;
        o_Constraints.fill = 2;
        o_Constraints.anchor = 11;
        this.m_PlayControlPanel.setVisible(true);
        this.jPanel_PlayControl.add((Component)this.m_PlayControlPanel, o_Constraints);
        this.jPanel_MediaView.setBackground(Color.GRAY);
        this.m_LiveShowMediaObjectPanel = new LiveShowMediaObjectPanel(this.m_LiveShowMediaObject, false);
        this.addLiveShowViewListener(this.m_LiveShowMediaObjectPanel);
        this.jPanel_MediaView.add((Component)this.m_LiveShowMediaObjectPanel, this.m_LiveShowMediaObjectPanel.getAbsoluteConstraints());
        this.m_LiveShowMediaObjectPanel.setVisible(true);
        this.m_LiveShowMediaPlayCursor = new PlayControlCursor();
        this.m_LiveShowMediaPlayCursor.setForeground(Color.GREEN);
        this.jPanel_MediaView.add(this.m_LiveShowMediaPlayCursor, this.m_LiveShowMediaPlayCursor.getAbsoluteConstraints(), 0);
        this.m_LiveShowMediaPlayCursor.setVisible(true);
        this.jPanel_MediaView.addComponentListener(this);
        this.m_LiveShowMediaObjectPanel.addMouseMotionListener(this);
        this.m_LiveShowMediaObjectPanel.addMouseListener(this);
        this.m_LiveShowMediaObjectPanel.addMouseWheelListener(this);
        this.m_DragSource = new DragSource();
        LiveShowDragDrop.LiveShowGestureRecognizer o_DragGestureRecognizer = new LiveShowDragDrop.LiveShowGestureRecognizer(this.m_DragSource, this.m_LiveShowMediaObjectPanel, 2, this, 2);
        this.liveShowTimeBar1.addPlay(o_PlayMedia);
        this.addLiveShowViewListener(this.liveShowTimeBar1);
        this.jPanel_MediaSurface1.addLiveShow_MediaPlayer(this.m_LiveShow_MediaPlayer);
        this.m_JLabel_ResizeFrame = new JLabel_ResizeFrame();
        o_Constraints = new GridBagConstraints();
        o_Constraints.gridx = 2;
        o_Constraints.gridy = 4;
        o_Constraints.weightx = 0.0;
        o_Constraints.anchor = 14;
        this.m_JLabel_ResizeFrame.setVisible(true);
        this.add((Component)this.m_JLabel_ResizeFrame, o_Constraints);
        this.setComponentZOrder(this.m_JLabel_ResizeFrame, 0);
        this.jButton_SaveActualImage.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.jButton_SaveActualImage.setComponentPopupMenu(null);
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        LiveLanguage.removeLanguageListener((Object)this);
        EventQueueHandler.removeRunnable(this.m_Runnable_EventPlayCursor);
        EventQueueHandler.removeRunnable(this.m_Runnable_RevalidateJPanelMediaView);
        this.saveMarks();
        if (this.m_LiveShow_MediaPlayer != null) {
            LiveShow_ImagePool.ImageElement o_ImageElement;
            this.m_LiveShow_MediaPlayer.removeMediaPlayerListener((LiveShow_MediaPlayer.MediaPlayerListener)this);
            if (!(this.m_LiveShow_MediaPlayer instanceof LiveShow_MediaPlayer_Image) || (o_ImageElement = LiveShow_ImagePool.getImageElement((LiveShow_MediaPlayer)this.m_LiveShow_MediaPlayer)) != null) {
                // empty if block
            }
        }
        this.jPanel_MediaSurface1.removeLiveShow_MediaPlayer(this.m_LiveShow_MediaPlayer);
        this.jPanel_MediaSurface1.close();
        this.m_JLabel_ResizeFrame.setContainer(null);
        if (this.m_MediaSource_Client != null) {
            this.m_MediaSource_Client.removeMediaSourceListener(this);
            PlayMedia o_PlayMedia = this.m_MediaSource_Client.getPlay();
            if (o_PlayMedia != null) {
                this.liveShowTimeBar1.removePlay(o_PlayMedia);
                if (this.m_PlayControlPanel != null) {
                    this.m_PlayControlPanel.actionPlayStop();
                    this.m_PlayControlPanel.removePlay(o_PlayMedia);
                    this.m_PlayControlPanel.close();
                }
                o_PlayMedia.removePlayListener(this);
                o_PlayMedia.removePlayListener(this.m_LiveShowScrollBarPanel);
            }
        }
        if (this.m_LiveShowScrollBarPanel != null) {
            this.m_LiveShowScrollBarPanel.removeLiveShowScrollBarListener(this);
        }
        this.removeLiveShowViewListener(this.m_LiveShowScrollBarPanel);
        if (this.m_LiveShowMediaObjectPanel != null) {
            this.removeLiveShowViewListener(this.m_LiveShowMediaObjectPanel);
            this.m_LiveShowMediaObjectPanel.close();
            this.m_LiveShowMediaObjectPanel = null;
        }
        this.removeLiveShowViewListener(this.liveShowTimeBar1);
        this.liveShowTimeBar1.close();
        if (this.m_MediaSource_Client != null) {
            this.m_MediaSource_Client.removeReference(this, true);
        }
        if (this.m_LiveShowMarkControlPanel != null) {
            this.m_LiveShowMarkControlPanel.close();
        }
        Object object = this.m_SyncViewListeners;
        synchronized (object) {
            this.m_LiveShowViewListeners.clear();
        }
        this.m_LiveCloseSemaphore.leaveCloseSection();
        LiveLanguage.removeLanguageListener((Object)this);
    }

    public void showSound_Lines_Settings() {
        SoundMixers.s_JDialog_Sound_Lines_Preview.setVisible(true);
    }

    public void refreshMediaSource() {
        if (this.m_LiveShow_MediaPlayer != null) {
            this.m_LiveShow_MediaPlayer.removeMediaPlayerListener((LiveShow_MediaPlayer.MediaPlayerListener)this);
            this.jPanel_MediaSurface1.removeLiveShow_MediaPlayer(this.m_LiveShow_MediaPlayer);
        }
        if (this.m_MediaSource_Client != null) {
            this.m_LiveShow_MediaPlayer = this.m_MediaSource_Client.getLiveShow_MediaPlayer();
            if (this.m_LiveShow_MediaPlayer != null) {
                this.m_LiveShow_MediaPlayer.setPlayStatus(1.0f, 0.0f, 0L, false, true);
            }
        }
        if (this.m_LiveShow_MediaPlayer != null) {
            this.m_LiveShow_MediaPlayer.addMediaPlayerListener((LiveShow_MediaPlayer.MediaPlayerListener)this);
            this.jPanel_MediaSurface1.addLiveShow_MediaPlayer(this.m_LiveShow_MediaPlayer);
        }
    }

    public void eventReady(LiveShow_MediaPlayer p_LiveShow_MediaPlayer, boolean p_MediaReady) {
        PlayMedia o_Play;
        String stringFileName;
        this.m_MediaObjectFrameStart = 0L;
        this.m_VisibleFrameStart = 0L;
        MediaSource_Client o_MediaSource_Client = this.m_MediaSource_Client;
        if (o_MediaSource_Client != null) {
            this.m_MediaObjectFrameEnd = o_MediaSource_Client.getLength_Frames();
            this.m_VisibleFrameEnd = o_MediaSource_Client.getLength_Frames();
        } else {
            this.m_MediaObjectFrameEnd = 0L;
            this.m_VisibleFrameEnd = 0L;
        }
        this.setVisibleRegion(this.m_VisibleFrameStart, this.m_VisibleFrameEnd);
        if (o_MediaSource_Client != null && (stringFileName = this.liveShowTimeBar1.calculateMarksFilePath(o_MediaSource_Client.getFile())) != null) {
            File o_FileMarks = new File(stringFileName);
            this.liveShowTimeBar1.readMarks(o_FileMarks);
        }
        this.notifyMediaObjectViewListeners_ViewChanged(this.getFrameStart(), this.getFrameEnd(), this.m_VisibleFrameStart, this.m_VisibleFrameEnd, this.jPanel_MediaView.getBounds());
        if (o_MediaSource_Client != null && (o_Play = o_MediaSource_Client.getPlay()) != null) {
            ((Play)o_Play).playFramePositionOnce(0L);
        }
        if (this.m_LiveShow_MediaPlayer != null && p_MediaReady) {
            this.m_LiveShow_MediaPlayer.setPlayStatus(1.0f, 0.0f, 0L, false, true);
        }
    }

    public void eventError(LiveShow_MediaPlayer p_LiveShow_MediaPlayer, String p_ErrorString) {
        this.m_MediaObjectFrameStart = 0L;
        this.m_MediaObjectFrameEnd = -1L;
    }

    public void eventClose(LiveShow_MediaPlayer p_LiveShow_MediaPlayer) {
    }

    public boolean getMarksChanged() {
        if (this.liveShowTimeBar1 == null) {
            return false;
        }
        return this.liveShowTimeBar1.getMarksChanged();
    }

    public void saveMarks() {
        String stringFileName;
        if (this.liveShowTimeBar1 != null && (stringFileName = this.liveShowTimeBar1.calculateMarksFilePath(this.m_MediaSource_Client.getFile())) != null) {
            File o_FileMarks = new File(stringFileName);
            this.liveShowTimeBar1.saveMarks(o_FileMarks);
        }
    }

    public MediaSource getMediaSource() {
        return this.m_MediaSource_Client;
    }

    public LiveShowTimeBar getLiveShowTimeBar() {
        return this.liveShowTimeBar1;
    }

    public JLabel_ResizeFrame getLabelResizeFrame() {
        return this.m_JLabel_ResizeFrame;
    }

    public JPanel getMediaObjectViewContainer() {
        return this.jPanel_MediaView;
    }

    public boolean getIsSetingZoom() {
        return this.isSettingZoom;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int intX = e.getX();
        if (this.isSettingZoom) {
            return;
        }
        long longFramePosition = this.m_LiveShowMediaObjectPanel.getPositionFrame(intX);
        if (e.getWheelRotation() > 0) {
            this.zoomMinus(false, longFramePosition);
        } else if (e.getWheelRotation() < 0) {
            this.zoomPlus(false, longFramePosition);
        }
    }

    public void zoomPlus(boolean p_AdjustFramePosition, long p_FramePosition) {
        this.isSettingZoom = true;
        this.m_LiveShowScrollBarPanel.zoomPlus(p_AdjustFramePosition, p_FramePosition);
        EventQueueHandler.invokeLater(this.m_RunnableEndZoom);
    }

    public void zoomMinus(boolean p_AdjustFramePosition, long p_FramePosition) {
        this.isSettingZoom = true;
        this.m_LiveShowScrollBarPanel.zoomMinus(p_AdjustFramePosition, p_FramePosition);
        EventQueueHandler.invokeLater(this.m_RunnableEndZoom);
    }

    public double getFramesPerPoint() {
        return this.m_LiveShowMediaObjectPanel.getFramesPerPoint();
    }

    public long getPositionFrame(Point p_Point) {
        return this.getPositionFrame(p_Point.x);
    }

    public long getPositionFrame(int p_X) {
        long longFrame = (long)((double)p_X * this.getFramesPerPoint());
        return longFrame;
    }

    public int getPositionX(long p_Frame) {
        if (p_Frame < this.m_MediaObjectFrameStart) {
            p_Frame = this.m_MediaObjectFrameStart;
        }
        if (p_Frame > this.m_MediaObjectFrameEnd) {
            p_Frame = this.m_MediaObjectFrameEnd;
        }
        if (this.getFramesPerPoint() <= 0.0) {
            return 0;
        }
        int intX = (int)((double)p_Frame / this.getFramesPerPoint());
        return intX;
    }

    @Override
    public void setVisibleRegion(long p_VisibleFrameStart, long p_VisibleFrameEnd) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        long longFrameLength = p_VisibleFrameEnd - p_VisibleFrameStart;
        if (longFrameLength > this.m_MediaObjectFrameEnd - this.m_MediaObjectFrameStart) {
            longFrameLength = this.m_MediaObjectFrameEnd - this.m_MediaObjectFrameStart;
        }
        if (p_VisibleFrameStart < this.m_MediaObjectFrameStart) {
            p_VisibleFrameStart = this.m_MediaObjectFrameStart;
            p_VisibleFrameEnd = p_VisibleFrameStart + longFrameLength;
        }
        if (p_VisibleFrameEnd > this.m_MediaObjectFrameEnd) {
            p_VisibleFrameEnd = this.m_MediaObjectFrameEnd;
            p_VisibleFrameStart = p_VisibleFrameEnd - longFrameLength;
        }
        if (p_VisibleFrameStart != this.m_VisibleFrameStart || p_VisibleFrameEnd != this.m_VisibleFrameEnd) {
            this.m_VisibleFrameStart = p_VisibleFrameStart;
            this.m_VisibleFrameEnd = p_VisibleFrameEnd;
            this.notifyMediaObjectViewListeners_ViewChanged(this.getFrameStart(), this.getFrameEnd(), this.m_VisibleFrameStart, this.m_VisibleFrameEnd, this.jPanel_MediaView.getBounds());
            this.jPanel_MediaView.revalidate();
        }
        this.calculatePlayCursor();
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public long getVisibleFrameStart() {
        return this.m_VisibleFrameStart;
    }

    @Override
    public long getVisibleFrameEnd() {
        return this.m_VisibleFrameEnd;
    }

    @Override
    public long getFrameStart() {
        return 0L;
    }

    @Override
    public long getFrameEnd() {
        if (this.m_MediaSource_Client == null) {
            return 0L;
        }
        return this.m_MediaSource_Client.getFrameLength();
    }

    public void setSection(long p_FrameStart, long p_FrameEnd) {
        PlayMedia o_PlayMedia = this.m_MediaSource_Client.getPlay();
        this.deleteSection();
        if (p_FrameStart < 0L || p_FrameEnd < 0L) {
            this.m_Section = null;
            if (o_PlayMedia != null) {
                o_PlayMedia.setActualPlayJump(this.m_Section);
            }
            return;
        }
        this.m_Section = new Section(this, p_FrameStart);
        this.m_Section.setFrameEnd(p_FrameEnd);
        if (o_PlayMedia != null) {
            o_PlayMedia.setActualPlayJump(this.m_Section);
        }
    }

    public void deleteSection() {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        PlayMedia o_PlayMedia = this.m_MediaSource_Client.getPlay();
        if (this.m_Section != null) {
            this.m_Section.close();
            this.m_Section = null;
            if (o_PlayMedia != null) {
                o_PlayMedia.setActualPlayJump(this.m_Section);
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addLiveShowViewListener(LiveShowViewListener p_Listener) {
        if (p_Listener == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolAdded = false;
        Object object = this.m_SyncViewListeners;
        synchronized (object) {
            if (this.m_LiveShowViewListeners != null && !this.m_LiveShowViewListeners.contains(p_Listener)) {
                this.m_LiveShowViewListeners.add(p_Listener);
                boolAdded = true;
            }
        }
        if (boolAdded) {
            p_Listener.eventViewChanged(this.getFrameStart(), this.getFrameEnd(), this.m_VisibleFrameStart, this.m_VisibleFrameEnd, this.jPanel_MediaView.getBounds());
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLiveShowViewListener(LiveShowViewListener p_Listener) {
        if (p_Listener == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncViewListeners;
        synchronized (object) {
            if (this.m_LiveShowViewListeners != null) {
                boolRemoved = this.m_LiveShowViewListeners.remove(p_Listener);
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyMediaObjectViewListeners_ViewChanged(long p_FrameStart, long p_FrameEnd, long p_VisibleFrameStart, long p_VisibleFrameEnd, Rectangle p_Bounds) {
        ArrayList<LiveShowViewListener> o_LiveShowViewListeners;
        Object object = this.m_SyncViewListeners;
        synchronized (object) {
            if (this.m_LiveShowViewListeners == null) {
                return;
            }
            o_LiveShowViewListeners = new ArrayList<LiveShowViewListener>(this.m_LiveShowViewListeners.size());
            o_LiveShowViewListeners.addAll(this.m_LiveShowViewListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowViewListeners.size(); ++intListener) {
            LiveShowViewListener o_Listener = (LiveShowViewListener)o_LiveShowViewListeners.get(intListener);
            o_Listener.eventViewChanged(p_FrameStart, p_FrameEnd, p_VisibleFrameStart, p_VisibleFrameEnd, p_Bounds);
        }
    }

    public void setFramePlayCursor(long p_FramePlayCursor) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (p_FramePlayCursor < this.m_MediaObjectFrameStart) {
            p_FramePlayCursor = this.m_MediaObjectFrameStart;
        }
        if (p_FramePlayCursor > this.m_MediaObjectFrameEnd) {
            p_FramePlayCursor = this.m_MediaObjectFrameEnd;
        }
        this.m_FramePlayCursor = p_FramePlayCursor;
        this.m_MediaSource_Client.setFramePlayCursor(this.m_FramePlayCursor);
        this.calculatePlayCursor();
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    private boolean calculatePlayCursor() {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        AbsoluteConstraints o_AbsoluteConstraints = this.m_LiveShowMediaPlayCursor.getAbsoluteConstraints();
        o_AbsoluteConstraints.width = 5;
        o_AbsoluteConstraints.height = this.jPanel_MediaView.getHeight();
        int intNewX = this.getPositionX(this.m_FramePlayCursor) - this.getPositionX(this.m_VisibleFrameStart);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if ((intNewX -= o_AbsoluteConstraints.width / 2) != o_AbsoluteConstraints.x) {
            o_AbsoluteConstraints.x = intNewX;
            EventQueueHandler.invokeLater(this.m_Runnable_RevalidateJPanelMediaView);
            this.jPanel_MediaView.revalidate();
            return true;
        }
        return false;
    }

    public void setAutoScroll(boolean p_AutoScroll) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (this.m_LiveShowScrollBarPanel != null) {
            this.m_LiveShowScrollBarPanel.setAutoScroll(p_AutoScroll);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (e.getComponent() == this.jPanel_MediaView) {
            if (this.jPanel_MediaView.getWidth() == this.m_OldSize_jPanel_MediaView.width && this.jPanel_MediaView.getHeight() == this.m_OldSize_jPanel_MediaView.height) {
                return;
            }
            this.m_OldSize_jPanel_MediaView.setSize(this.jPanel_MediaView.getWidth(), this.jPanel_MediaView.getHeight());
            this.notifyMediaObjectViewListeners_ViewChanged(this.getFrameStart(), this.getFrameEnd(), this.m_VisibleFrameStart, this.m_VisibleFrameEnd, e.getComponent().getBounds());
            this.revalidate();
            this.jPanel_MediaView.revalidate();
            this.calculatePlayCursor();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void eventPlayStart(Play p_Play) {
    }

    @Override
    public void eventPlayStop(Play p_Play) {
        if (p_Play == null) {
            return;
        }
        p_Play.playFramePositionOnce();
    }

    @Override
    public void eventPlayPause(Play p_Play) {
    }

    @Override
    public void eventPlayRewind(Play p_Play) {
        if (p_Play == null) {
            return;
        }
        if (p_Play.getStatus() != 3) {
            p_Play.playFramePositionOnce();
        }
    }

    @Override
    public void eventPlayCursorSet(Play p_Play, long p_FramePlayCursor) {
    }

    @Override
    public void eventEditModeOn(Play p_Play, boolean p_EditModeOn) {
    }

    @Override
    public void eventEditCursorSet(Play p_Play, long p_FrameEditCursor) {
    }

    @Override
    public void eventPlayFastForward(Play p_Play) {
        if (p_Play == null) {
            return;
        }
        if (p_Play.getStatus() != 3) {
            p_Play.playFramePositionOnce();
        }
    }

    @Override
    public void eventPlayFadePossibility(Play p_Play, boolean p_FadeInPossible, boolean p_FadeOutPossible, double p_FadeProgress) {
    }

    @Override
    public void eventPlayFadedIn(Play p_Play, boolean p_FadedIn, double p_FadeProgress) {
    }

    @Override
    public long eventPlayCheckRead(Play p_Play, long p_FrameStart, long p_FramesToRead) {
        return p_FramesToRead;
    }

    @Override
    public void eventPlayCursor(Play p_Play, long p_OldFramePlayCursor, long p_FramePlayCursor) {
        if (p_FramePlayCursor < this.m_MediaObjectFrameStart) {
            p_FramePlayCursor = this.m_MediaObjectFrameStart;
        }
        if (p_FramePlayCursor > this.m_MediaObjectFrameEnd) {
            p_FramePlayCursor = this.m_MediaObjectFrameEnd;
        }
        if (this.m_FramePlayCursor == p_OldFramePlayCursor) {
            return;
        }
        this.m_FramePlayCursor = p_OldFramePlayCursor;
        this.calculatePlayCursor();
    }

    @Override
    public void eventPlayError(Play p_Play, Exception p_Exception, String p_Remark) {
    }

    @Override
    public void eventPlayClosing(Play p_Play) {
    }

    @Override
    public void eventPlayTimelineEnd(Play p_Play) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (e.getComponent() == this.jPanel_MediaView) {
            // empty if block
        }
        if (e.getComponent() == this.jPanel_MediaView || e.getComponent() == this.m_LiveShowMediaObjectPanel) {
            long longFrameClicked = this.getPositionFrame(e.getX());
            this.setFramePlayCursor(longFrameClicked);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (e.getComponent() == this.jPanel_MediaView || e.getComponent() == this.m_LiveShowMediaObjectPanel) {
            if (this.m_Section == null) {
                this.setSection(this.getPositionFrame(e.getPoint()), this.getPositionFrame(e.getPoint()));
            } else {
                this.m_Section.setFrameEnd(this.m_Section.checkSnapping(e.getPoint().x));
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
    }

    private void initComponents() {
        this.jPanel_MediaView = new JPanel();
        this.jPanel_PlayControl = new JPanel();
        this.liveShowTimeBar1 = new LiveShowTimeBar();
        this.jPanel_Mark = new JPanel();
        this.jPanel_Tools = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.jButton_SaveActualImage = new JButton();
        this.jButton_SoundSettings = new JButton();
        this.jPanel_MediaSurface1 = new JPanel_MediaSurface();
        this.setMinimumSize(new Dimension(256, 400));
        this.setPreferredSize(new Dimension(500, 500));
        this.setLayout(new GridBagLayout());
        this.jPanel_MediaView.setMinimumSize(new Dimension(80, 80));
        this.jPanel_MediaView.setName("");
        this.jPanel_MediaView.setPreferredSize(new Dimension(80, 80));
        this.jPanel_MediaView.setLayout((LayoutManager)new AbsoluteLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel_MediaView, gridBagConstraints);
        this.jPanel_PlayControl.setBackground(new Color(255, 255, 255));
        this.jPanel_PlayControl.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.jPanel_PlayControl.setOpaque(false);
        this.jPanel_PlayControl.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.add((Component)this.jPanel_PlayControl, gridBagConstraints);
        this.liveShowTimeBar1.setMinimumSize(new Dimension(0, 32));
        this.liveShowTimeBar1.setPreferredSize(new Dimension(100, 32));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.liveShowTimeBar1, gridBagConstraints);
        this.jPanel_Mark.setMinimumSize(new Dimension(64, 32));
        this.jPanel_Mark.setOpaque(false);
        this.jPanel_Mark.setPreferredSize(new Dimension(64, 32));
        this.jPanel_Mark.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_Mark, gridBagConstraints);
        this.jPanel_Tools.setLayout(new GridBagLayout());
        this.jToolBar1.setBorder(null);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButton_SaveActualImage.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/File_Save.png")));
        this.jButton_SaveActualImage.setToolTipText("Save current image as png file");
        this.jButton_SaveActualImage.setContentAreaFilled(false);
        this.jButton_SaveActualImage.setFocusable(false);
        this.jButton_SaveActualImage.setHorizontalTextPosition(0);
        this.jButton_SaveActualImage.setMargin(new Insets(2, 3, 2, 3));
        this.jButton_SaveActualImage.setMaximumSize(new Dimension(32, 32));
        this.jButton_SaveActualImage.setMinimumSize(new Dimension(32, 32));
        this.jButton_SaveActualImage.setPreferredSize(new Dimension(34, 34));
        this.jButton_SaveActualImage.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_SaveActualImage.setVerticalTextPosition(3);
        this.jButton_SaveActualImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowMediaPanel.this.jButton_SaveActualImageActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_SaveActualImage);
        this.jButton_SoundSettings.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Menu_SoundcardSettings.png")));
        this.jButton_SoundSettings.setToolTipText("Save current image as png file");
        this.jButton_SoundSettings.setContentAreaFilled(false);
        this.jButton_SoundSettings.setFocusable(false);
        this.jButton_SoundSettings.setHorizontalTextPosition(0);
        this.jButton_SoundSettings.setMargin(new Insets(2, 3, 2, 3));
        this.jButton_SoundSettings.setMaximumSize(new Dimension(32, 32));
        this.jButton_SoundSettings.setMinimumSize(new Dimension(32, 32));
        this.jButton_SoundSettings.setPreferredSize(new Dimension(34, 34));
        this.jButton_SoundSettings.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_SoundSettings.setVerticalTextPosition(3);
        this.jButton_SoundSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowMediaPanel.this.jButton_SoundSettingsActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_SoundSettings);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel_Tools.add((Component)this.jToolBar1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_Tools, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_MediaSurface1, gridBagConstraints);
    }

    private void jButton_SaveActualImageActionPerformed(ActionEvent evt) {
        File o_SelectedFile = null;
        File o_File = null;
        LiveShow_MediaPlayer o_LiveShow_MediaPlayer = this.m_LiveShow_MediaPlayer;
        if (o_LiveShow_MediaPlayer == null) {
            return;
        }
        MediaSource o_MediaSource = o_LiveShow_MediaPlayer.getMediaSource();
        if (o_MediaSource == null) {
            return;
        }
        o_File = o_LiveShow_MediaPlayer.getMediaSource().getFile();
        if (o_File == null) {
            return;
        }
        String stringFileName = FileTools.getPathName(o_File) + File.separator + FileTools.getFileNameBase(o_File) + ".png";
        o_SelectedFile = FileSelection.showSave(this, "Snapshot", o_File = new File(stringFileName), s_FileNameExtensionFilter_PNG, true, true, s_FileNameExtensionFilter_PNG, null, null, null);
        if (o_SelectedFile != null) {
            String stringFilePathName = o_SelectedFile.getAbsolutePath();
            int intIndex = stringFilePathName.lastIndexOf(".");
            if (intIndex > 0) {
                stringFilePathName = stringFilePathName.substring(0, intIndex);
            }
            o_SelectedFile = new File(stringFilePathName + ".png");
        }
        if (o_SelectedFile != null) {
            if (!FileTools.checkWritable(o_SelectedFile)) {
                LiveShowMediaSystem.showOptionPane_WarningWritable_Save(o_SelectedFile, o_SelectedFile.getParentFile());
                return;
            }
            o_LiveShow_MediaPlayer.saveActualImage_PNG(o_SelectedFile);
        }
    }

    private void jButton_SoundSettingsActionPerformed(ActionEvent evt) {
        this.showSound_Lines_Settings();
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        if (this.m_DragStartet) {
            return;
        }
        this.m_DragStartet = true;
        LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = LiveShowMediaObjectDescription.poolGet();
        o_LiveShowMediaObjectDescription.setFrameLength(LiveShowObjectDescription.DEFAULTFRAMELENGTH);
        o_LiveShowMediaObjectDescription.setObjectType(21);
        if (this.m_MediaSource_Client != null) {
            o_LiveShowMediaObjectDescription.setSourceName(this.m_MediaSource_Client.getFile().getName());
            o_LiveShowMediaObjectDescription.setSourceString(this.m_MediaSource_Client.getFile().getPath());
            o_LiveShowMediaObjectDescription.setCheckSum(this.m_MediaSource_Client.getCheckSum());
        } else {
            o_LiveShowMediaObjectDescription.setSourceName("-");
            o_LiveShowMediaObjectDescription.setSourceString("-");
            o_LiveShowMediaObjectDescription.setCheckSum("");
        }
        o_LiveShowMediaObjectDescription.setFrameStartOffset(this.m_MediaObjectFrameStart);
        o_LiveShowMediaObjectDescription.setFrameLength(this.m_MediaObjectFrameEnd);
        this.setSection(this.m_MediaObjectFrameStart, this.m_MediaObjectFrameEnd);
        LiveShowDragDrop.LiveShowTransferable o_Transferable = new LiveShowDragDrop.LiveShowTransferable((LiveShowObjectDescription)o_LiveShowMediaObjectDescription, LiveShowDragDrop.LiveShowTransferable.MEDIAOBJECTFLAVOUR);
        try {
            LiveShowDragDrop.setSource(this);
            dge.startDrag(null, o_Transferable, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (!dsde.getDropSuccess()) {
            LiveShowDragDrop.notifyDropCancelled();
        }
        this.m_DragStartet = false;
    }

    public void eventMediaSourceInvalidFile(MediaSource p_MediaSource, File p_MediaFile) {
    }

    public void eventMediaSourceOpened(MediaSource p_MediaSource, File p_MediaFile, long p_SectionStart, long p_SectionEnd) {
    }

    public void eventMediaSourceClosing(MediaSource p_MediaSource) {
    }

    public void eventMediaSourceRefreshing(MediaSource p_MediaSource) {
        this.refreshMediaSource();
    }

    static {
        s_FileNameExtensionFilter_PNG = FileSelection.createFileNameExtensionFilter("Image (.png)", ".png");
    }

    public static class Section
    extends JPanel
    implements LiveShowViewListener,
    PlayJumpInterface,
    MouseInputListener,
    MouseWheelListener,
    DragGestureListener,
    DragSourceListener {
        public static int MOUSEFETCHSIZE = 16;
        private LiveShowMediaPanel m_LiveShowMediaPanel;
        private long m_FrameStart;
        private long m_FrameEnd;
        private AbsoluteConstraints m_AbsoluteConstraints;
        private JComponent m_MediaObjectViewContainer;
        private JLabel m_JLabelClose;
        private AbsoluteConstraints m_JButtonCloseConstraints;
        private boolean m_MouseResizeEast;
        private boolean m_MouseResizeWest;
        private DragSource m_DragSource;
        private boolean m_DragStartet;
        private LiveShowDragDrop.LiveShowGestureRecognizer m_DragGestureRecognizer;
        private Color m_ColorSection;

        public Section(LiveShowMediaPanel p_LiveShowMediaPanel, long p_FrameStart) {
            this.initMembers();
            this.initComponents();
            this.m_LiveShowMediaPanel = p_LiveShowMediaPanel;
            this.m_FrameStart = p_FrameStart;
            this.m_FrameEnd = p_FrameStart;
            this.m_MediaObjectViewContainer = p_LiveShowMediaPanel.getMediaObjectViewContainer();
            this.m_MediaObjectViewContainer.add(this, this.m_AbsoluteConstraints, 0);
            this.m_LiveShowMediaPanel.addLiveShowViewListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.setVisible(true);
        }

        private void initMembers() {
            this.m_FrameEnd = 0L;
            this.m_FrameStart = 0L;
            this.m_MouseResizeWest = false;
            this.m_MouseResizeEast = false;
            this.m_ColorSection = new Color(0.0f, 0.0f, 0.5f, 0.3f);
            this.m_DragStartet = false;
        }

        private void initComponents() {
            this.setBorder(new LineBorder(Color.BLUE, 1));
            this.setOpaque(false);
            this.setLayout((LayoutManager)new AbsoluteLayout());
            this.m_AbsoluteConstraints = new AbsoluteConstraints(0, 0, 0, 0);
            this.m_JButtonCloseConstraints = new AbsoluteConstraints(0, 0, 0, 0);
            this.m_JLabelClose = new JLabel("X");
            this.m_JLabelClose.setHorizontalAlignment(0);
            this.m_JLabelClose.setVerticalAlignment(0);
            this.m_JLabelClose.setForeground(Color.WHITE);
            this.m_JLabelClose.setBackground(Color.red);
            this.m_JLabelClose.setOpaque(true);
            this.add((Component)this.m_JLabelClose, this.m_JButtonCloseConstraints);
            this.m_JLabelClose.setVisible(true);
            this.m_JLabelClose.setCursor(Cursor.getPredefinedCursor(12));
            this.m_JLabelClose.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (m_LiveShowMediaPanel instanceof LiveShowMediaPanel) {
                        m_LiveShowMediaPanel.deleteSection();
                    }
                }
            });
            this.m_DragSource = new DragSource();
            this.m_DragGestureRecognizer = new LiveShowDragDrop.LiveShowGestureRecognizer(this.m_DragSource, this, 2, this, 2);
            this.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        }

        public void close() {
            this.setComponentPopupMenu(null);
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
            if (this.m_LiveShowMediaPanel != null) {
                this.m_LiveShowMediaPanel.removeLiveShowViewListener(this);
                this.setVisible(false);
                this.m_LiveShowMediaPanel.getMediaObjectViewContainer().remove(this);
                if (!SwingUtilities.isEventDispatchThread()) {
                    // empty if block
                }
                this.m_LiveShowMediaPanel.getMediaObjectViewContainer().repaint();
                this.m_LiveShowMediaPanel = null;
            }
        }

        public void setFrameEnd(long p_FrameEnd) {
            if (p_FrameEnd < 0L) {
                p_FrameEnd = 0L;
            }
            if (this.m_LiveShowMediaPanel.getFrameEnd() > 0L && p_FrameEnd > this.m_LiveShowMediaPanel.getFrameEnd()) {
                p_FrameEnd = this.m_LiveShowMediaPanel.getFrameEnd();
            }
            this.m_FrameEnd = p_FrameEnd;
            if (this.m_FrameEnd < this.m_FrameStart) {
                long longOldFrameStart = this.m_FrameStart;
                this.m_FrameStart = this.m_FrameEnd;
                this.m_FrameEnd = longOldFrameStart;
            }
            this.calculateSection();
        }

        public void setFrameStart(long p_FrameStart) {
            if (p_FrameStart < 0L) {
                p_FrameStart = 0L;
            }
            if (this.m_LiveShowMediaPanel.getFrameEnd() > 0L && p_FrameStart > this.m_LiveShowMediaPanel.getFrameEnd()) {
                p_FrameStart = this.m_LiveShowMediaPanel.getFrameEnd();
            }
            this.m_FrameStart = p_FrameStart;
            if (this.m_FrameEnd < this.m_FrameStart) {
                long longOldFrameStart = this.m_FrameStart;
                this.m_FrameStart = this.m_FrameEnd;
                this.m_FrameEnd = longOldFrameStart;
            }
            this.calculateSection();
        }

        public void moveSection(long p_Frames) {
            if (p_Frames == 0L) {
                return;
            }
            long longFrameLength = this.m_FrameEnd - this.m_FrameStart;
            this.m_FrameStart += p_Frames;
            this.m_FrameEnd = this.m_FrameStart + longFrameLength;
            this.calculateSection();
        }

        public long checkSnapping(int p_X) {
            ArrayList<LiveShowTimeBar.Mark> o_Marks = this.m_LiveShowMediaPanel.getLiveShowTimeBar().getMarks();
            for (int intMark = 0; intMark < o_Marks.size(); ++intMark) {
                LiveShowTimeBar.Mark o_Mark = o_Marks.get(intMark);
                int intMarkX = this.m_LiveShowMediaPanel.getPositionX(o_Mark.getFramePosition());
                if (p_X > intMarkX + MOUSEFETCHSIZE || p_X < intMarkX - MOUSEFETCHSIZE) continue;
                return o_Mark.getFramePosition();
            }
            return this.m_LiveShowMediaPanel.getPositionFrame(p_X);
        }

        public void calculateSection() {
            this.m_AbsoluteConstraints.y = 0;
            this.m_AbsoluteConstraints.height = this.m_MediaObjectViewContainer.getHeight();
            this.m_AbsoluteConstraints.x = this.m_LiveShowMediaPanel.getPositionX(this.m_FrameStart) - this.m_LiveShowMediaPanel.getPositionX(this.m_LiveShowMediaPanel.getVisibleFrameStart());
            this.m_AbsoluteConstraints.width = this.m_LiveShowMediaPanel.getPositionX(this.m_FrameEnd) - this.m_LiveShowMediaPanel.getPositionX(this.m_LiveShowMediaPanel.getVisibleFrameStart()) - this.m_AbsoluteConstraints.x;
            if (this.m_AbsoluteConstraints.width <= 0) {
                this.m_AbsoluteConstraints.width = 2;
            }
            this.m_MediaObjectViewContainer.revalidate();
            this.m_JButtonCloseConstraints.y = 0;
            this.m_JButtonCloseConstraints.x = this.m_AbsoluteConstraints.width - 16;
            this.m_JButtonCloseConstraints.height = 16;
            this.m_JButtonCloseConstraints.width = 16;
            this.createToolTipText();
            this.revalidate();
        }

        public void createToolTipText() {
            StringBuffer o_StringBuffer = new StringBuffer();
            o_StringBuffer.append("<html>");
            o_StringBuffer.append("<table>");
            o_StringBuffer.append("<tr>");
            o_StringBuffer.append("<td>");
            o_StringBuffer.append(LABEL_START);
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("<td>");
            o_StringBuffer.append(LiveShowObject.getTimeStringFromMillis((long)((double)this.m_FrameStart * LiveShowVIP.getFRAMETIME())));
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("</tr>");
            o_StringBuffer.append("<tr>");
            o_StringBuffer.append("<td>");
            o_StringBuffer.append(LABEL_END);
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("<td>");
            o_StringBuffer.append(LiveShowObject.getTimeStringFromMillis((long)((double)this.m_FrameEnd * LiveShowVIP.getFRAMETIME())));
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("</tr>");
            o_StringBuffer.append("<tr>");
            o_StringBuffer.append("<td>");
            o_StringBuffer.append("<b>");
            o_StringBuffer.append(LABEL_DURATION);
            o_StringBuffer.append("</b>");
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("<td>");
            o_StringBuffer.append("<b>");
            o_StringBuffer.append(LiveShowObject.getTimeStringFromMillis((long)((double)(this.m_FrameEnd - this.m_FrameStart) * LiveShowVIP.getFRAMETIME())));
            o_StringBuffer.append("</b>");
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("</tr>");
            o_StringBuffer.append("</table>");
            this.setToolTipText(o_StringBuffer.toString());
        }

        @Override
        public void eventViewChanged(long p_FrameStart, long p_FrameEnd, long p_VisibleFrameStart, long p_VisibleFrameEnd, Rectangle p_Bounds) {
            this.calculateSection();
        }

        @Override
        public void eventViewScrollAutomaticStart() {
        }

        @Override
        public void eventZoomPlus(boolean p_AdjustFramePosition, long p_FramePosition) {
        }

        @Override
        public void eventZoomMinus(boolean p_AdjustFramePosition, long p_FramePosition) {
        }

        @Override
        public void eventZoomReset() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int intX = e.getX();
            if (this.mouseNearEast(intX)) {
                this.m_MouseResizeEast = true;
                this.m_DragGestureRecognizer.setActive(false);
            } else if (this.mouseNearWest(intX)) {
                this.m_MouseResizeWest = true;
                this.m_DragGestureRecognizer.setActive(false);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.m_MouseResizeWest = false;
            this.m_MouseResizeEast = false;
            this.m_DragGestureRecognizer.setActive(true);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int intX = e.getPoint().x;
            long longPositionFrame = this.checkSnapping(intX + this.m_LiveShowMediaPanel.getPositionX(this.m_FrameStart));
            if (longPositionFrame < 0L) {
                return;
            }
            if (this.m_MouseResizeEast) {
                this.setFrameEnd(longPositionFrame);
            } else if (this.m_MouseResizeWest) {
                this.setFrameStart(longPositionFrame);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int intX = e.getPoint().x;
            if (this.mouseNearEast(intX)) {
                this.setCursor(Cursor.getPredefinedCursor(11));
            } else if (this.mouseNearWest(intX)) {
                this.setCursor(Cursor.getPredefinedCursor(10));
            } else {
                this.setCursor(null);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (this.m_LiveShowMediaPanel.getIsSetingZoom()) {
                return;
            }
            long longFramePosition = this.m_LiveShowMediaPanel.getPositionFrame(e.getX());
            if (e.getWheelRotation() > 0) {
                this.m_LiveShowMediaPanel.zoomMinus(false, this.m_FrameStart + longFramePosition);
            } else if (e.getWheelRotation() < 0) {
                this.m_LiveShowMediaPanel.zoomPlus(false, this.m_FrameStart + longFramePosition);
            }
        }

        boolean mouseNearEast(int p_X) {
            boolean boolIs = false;
            boolIs = this.getWidth() <= 2 * MOUSEFETCHSIZE ? p_X > this.getWidth() / 2 : p_X >= this.getWidth() - MOUSEFETCHSIZE && p_X <= this.getWidth() + MOUSEFETCHSIZE;
            return boolIs;
        }

        boolean mouseNearWest(int p_X) {
            boolean boolIs = false;
            boolIs = this.getWidth() <= 2 * MOUSEFETCHSIZE ? p_X < this.getWidth() / 2 : p_X <= MOUSEFETCHSIZE && p_X >= -MOUSEFETCHSIZE;
            return boolIs;
        }

        @Override
        public void paintComponent(Graphics p_Graphics) {
            super.paintComponent(p_Graphics);
            Graphics2D g2d = (Graphics2D)p_Graphics;
            g2d.setColor(this.m_ColorSection);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }

        @Override
        public long getJumpFrameFrom() {
            return this.m_FrameEnd;
        }

        @Override
        public long getJumpFrameTo() {
            return this.m_FrameStart;
        }

        @Override
        public boolean getJumpIsActive() {
            return true;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            if (this.m_DragStartet) {
                return;
            }
            this.m_DragStartet = true;
            LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = LiveShowMediaObjectDescription.poolGet();
            o_LiveShowMediaObjectDescription.setObjectType(21);
            if (this.m_LiveShowMediaPanel.getMediaSource() != null) {
                o_LiveShowMediaObjectDescription.setSourceName(this.m_LiveShowMediaPanel.getMediaSource().getFile().getName());
                o_LiveShowMediaObjectDescription.setSourceString(this.m_LiveShowMediaPanel.getMediaSource().getFile().getPath());
                o_LiveShowMediaObjectDescription.setCheckSum(this.m_LiveShowMediaPanel.getMediaSource().getCheckSum());
            } else {
                o_LiveShowMediaObjectDescription.setSourceName("-");
                o_LiveShowMediaObjectDescription.setSourceString("-");
                o_LiveShowMediaObjectDescription.setCheckSum("");
            }
            o_LiveShowMediaObjectDescription.setFrameStartOffset(this.m_FrameStart);
            o_LiveShowMediaObjectDescription.setFrameLength(this.m_FrameEnd - this.m_FrameStart);
            LiveShowDragDrop.LiveShowTransferable o_Transferable = new LiveShowDragDrop.LiveShowTransferable((LiveShowObjectDescription)o_LiveShowMediaObjectDescription, LiveShowDragDrop.LiveShowTransferable.MEDIAOBJECTFLAVOUR);
            LiveShowDragDrop.setSource(this.m_LiveShowMediaPanel);
            dge.startDrag(null, o_Transferable, this);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (!dsde.getDropSuccess()) {
                LiveShowDragDrop.notifyDropCancelled();
            }
            this.m_DragStartet = false;
        }
    }
}

