/*
 * Decompiled with CFR 0.152.
 */
package LiveShowSoundPackage;

import FileToolPackage.FileTools;
import LiveShowNotificationPackage.LiveShowNotification;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import MainPackage.LiveShowProjectDesktop;
import SoundPackage.SoundMixers;
import SoundSamplePackage.LiveShowSoundHD;
import SoundSamplePackage.LiveShowSoundHDListener;
import SoundVirtualPackage.LiveShowSoundObject;
import SoundVirtualPackage.LiveShowSoundVIP;
import StartPackage.LiveShowSoundSystem;
import SynchronizationPackage.JobHandler;
import SynchronizationPackage.LiveCloseSemaphore;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;

public class LiveShowSoundManagement
implements LiveShowSoundHDListener {
    private LiveShowProjectDesktop m_LiveShowDesktop;
    private ArrayList<LiveShowSoundHD> m_LiveShowSoundHDs;
    private LiveShowSoundVIP m_LiveShowSoundVIP;
    private static LiveShowSoundManagement s_SelfReference;
    private LiveCloseSemaphore m_LiveCloseSemaphore;

    public LiveShowSoundManagement(LiveShowProjectDesktop p_LiveShowDesktop) {
        this.initMembers();
        this.m_LiveShowDesktop = p_LiveShowDesktop;
    }

    private void initMembers() {
        s_SelfReference = this;
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_LiveShowSoundHDs = new ArrayList();
    }

    public void close() {
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        this.closeLiveShowSoundVIP();
        this.m_LiveShowSoundVIP = null;
        if (this.m_LiveShowSoundHDs != null) {
            for (int intHD = this.m_LiveShowSoundHDs.size() - 1; intHD >= 0; --intHD) {
                LiveShowSoundHD o_LiveShowSoundHD = this.m_LiveShowSoundHDs.get(intHD);
                if (o_LiveShowSoundHD == null) continue;
                o_LiveShowSoundHD.close();
            }
        }
        this.m_LiveShowDesktop = null;
        if (LiveShowSoundSystem.s_ThreadFillPlayBuffer != null) {
            LiveShowSoundSystem.s_ThreadFillPlayBuffer.close();
        }
        SoundMixers.closeProgram();
        this.m_LiveCloseSemaphore.leaveCloseSection();
    }

    public void closeProject() {
        LiveShowSoundSystem.closeProject();
    }

    public boolean newLiveShowSoundVIP() {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        this.closeLiveShowSoundVIP();
        LiveShowSoundVIP o_LiveShowSoundVIP = new LiveShowSoundVIP(true);
        this.setLiveShowSoundVIP(o_LiveShowSoundVIP);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return true;
    }

    public void closeLiveShowSoundVIP() {
        if (this.m_LiveShowSoundVIP == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveShowSoundVIP.close();
        LiveShowSoundSystem.removeLiveShowSoundVIP((LiveShowSoundVIP)this.m_LiveShowSoundVIP);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public void setLiveShowSoundVIP(LiveShowSoundVIP p_LiveShowSoundVIP) {
        if (this.m_LiveShowSoundVIP == p_LiveShowSoundVIP) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.closeLiveShowSoundVIP();
        this.m_LiveShowSoundVIP = p_LiveShowSoundVIP;
        LiveShowSoundSystem.setLiveShowSoundVIP((LiveShowSoundVIP)this.m_LiveShowSoundVIP);
        this.m_LiveShowDesktop.eventLiveShowSoundVIP(this.m_LiveShowSoundVIP);
        if (this.m_LiveShowSoundVIP != null) {
            this.m_LiveShowSoundVIP.setFrameMaxObjects(this.m_LiveShowSoundVIP.calculateFrameMaxObjects(null));
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public LiveShowSoundVIP getLiveShowSoundVIP() {
        return this.m_LiveShowSoundVIP;
    }

    public static LiveShowSoundVIP getLiveShowVIP() {
        if (s_SelfReference == null) {
            return null;
        }
        return s_SelfReference.getLiveShowSoundVIP();
    }

    public void deleteAllJumps() {
        if (this.m_LiveShowSoundVIP == null) {
            return;
        }
        int intSceneBridgeCount = this.m_LiveShowSoundVIP.getLiveShowSceneBridgeCount();
        for (int intSceneBridge = 0; intSceneBridge < intSceneBridgeCount; ++intSceneBridge) {
            LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSoundVIP.getLiveShowSceneBridge(intSceneBridge);
            o_LiveShowSceneBridge.setJumpSceneBridge(null);
        }
    }

    public boolean loadSoundFile() {
        boolean boolLoad = false;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        File o_SelectedFile = LiveShowSoundSystem.loadSoundFile((String)LiveShowSoundSystem.LOAD_SOUNDFILE, (File)LiveShowSoundSystem.getLastOpenedFilePath());
        if (o_SelectedFile != null) {
            if (o_SelectedFile.isDirectory()) {
                boolLoad = false;
            } else {
                int intAnswer;
                boolLoad = true;
                if (!FileTools.checkWritable((File)o_SelectedFile.getParentFile()) && (intAnswer = LiveShowSoundSystem.showOptionPane_WarningWritable((File)o_SelectedFile, (File)o_SelectedFile.getParentFile())) == 1) {
                    boolLoad = false;
                }
                if (boolLoad) {
                    LiveShowSoundSystem.setLastOpenedFilePath((File)o_SelectedFile);
                    File o_ProblemFile = LiveShowSoundSystem.checkSoundFileNameDuplicated_load((File)o_SelectedFile, (AudioFormat)this.m_LiveShowSoundVIP.getAudioFormat());
                    if (o_ProblemFile != null) {
                        LiveShowSoundHD o_LiveShowSoundHD = LiveShowSoundSystem.getLiveShowSoundHDByFileName((String)o_ProblemFile.getName());
                        LiveShowProjectDesktop.getLiveShowInternalFrame_SoundHDView().setSelectedSoundHD(o_LiveShowSoundHD);
                        LiveShowProjectDesktop.toFrontInternalFrame(LiveShowProjectDesktop.getLiveShowInternalFrame_SoundHDView());
                        if (FileTools.getCheckSum_MD5_Partial((File)o_ProblemFile).equals(FileTools.getCheckSum_MD5_Partial((File)o_SelectedFile))) {
                            intAnswer = LiveShowSoundSystem.showOptionPane_WarningFileDuplication_SameContent((File)o_SelectedFile, (File)o_ProblemFile);
                            if (intAnswer == 1) {
                                boolLoad = false;
                            } else {
                                o_SelectedFile = o_ProblemFile;
                            }
                        } else {
                            intAnswer = LiveShowSoundSystem.showOptionPane_WarningFileDuplication((File)o_SelectedFile, (File)o_ProblemFile);
                            if (intAnswer == 1) {
                                boolLoad = false;
                            }
                        }
                    } else {
                        AudioFormat o_AudioFormat = SoundMixers.getAudioFormat((File)o_SelectedFile);
                        if (!LiveShowSoundSystem.matchesAudioFormat((AudioFormat)o_AudioFormat, (AudioFormat)SoundMixers.DEFAULT_AUDIOFORMAT, (boolean)true)) {
                            o_AudioFormat = LiveShowSoundSystem.getAudioFormatMatching((AudioFormat)o_AudioFormat);
                            String stringConvertedFilename = LiveShowSoundSystem.calculateConvertedSoundFileName((File)o_SelectedFile, (AudioFormat)o_AudioFormat);
                            File o_FileExisting = new File(o_SelectedFile.getParentFile().getAbsoluteFile() + stringConvertedFilename);
                            if (o_FileExisting.exists()) {
                                o_SelectedFile = o_FileExisting;
                            }
                        }
                    }
                }
            }
        }
        if (boolLoad) {
            this.loadSoundFile(o_SelectedFile, -1L, -1L);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolLoad;
    }

    public void loadSoundFile(LiveShowSoundObject p_LiveShowSoundObject) {
        if (p_LiveShowSoundObject == null) {
            return;
        }
        String stringSourceString = p_LiveShowSoundObject.getDescription().getSourceString();
        if (stringSourceString == null) {
            return;
        }
        File o_File = new File(stringSourceString);
        this.loadSoundFile(o_File, p_LiveShowSoundObject.getFrameStartOffset(), p_LiveShowSoundObject.getFrameStartOffset() + p_LiveShowSoundObject.getFrameLength());
    }

    public void loadSoundFile(LiveShowSoundHD p_LiveShowSoundHD) {
        if (p_LiveShowSoundHD == null) {
            return;
        }
        File o_File = p_LiveShowSoundHD.getSoundFile();
        this.loadSoundFile(o_File, -1L, -1L);
    }

    public void loadSoundFile(final File p_SoundFile, final long p_SectionStart, final long p_SectionEnd) {
        if (p_SoundFile == null) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                if (!LiveShowSoundManagement.this.m_LiveCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveShowNotification o_LiveShowNotification = new LiveShowNotification(LiveShowSoundSystem.LOAD_SOUNDFILE, 0L, 0L, false);
                o_LiveShowNotification.setActionText(p_SoundFile.getName());
                LiveShowSoundHD o_LiveShowSoundHD = LiveShowSoundSystem.createLiveShowSoundHD((File)p_SoundFile);
                if (o_LiveShowSoundHD != null) {
                    o_LiveShowSoundHD.addLiveShowSoundHDListener((LiveShowSoundHDListener)s_SelfReference);
                    LiveShowSoundManagement.this.eventHDOpened(o_LiveShowSoundHD, o_LiveShowSoundHD.getSoundFile(), p_SectionStart, p_SectionEnd);
                }
                o_LiveShowNotification.close();
                LiveShowSoundManagement.this.m_LiveCloseSemaphore.leaveWorkerSection();
            }
        };
        JobHandler.addJob((Runnable)o_Runnable);
    }

    public void eventHDNoMixerFound(LiveShowSoundHD p_LiveShowSoundHD, AudioFormat p_AudioFormat) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public void eventHDInvalidSoundFile(LiveShowSoundHD p_LiveShowSoundHD, File p_SoundFile) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public void eventHDClosing(LiveShowSoundHD p_LiveShowSoundHD) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveShowSoundHDs.remove(p_LiveShowSoundHD);
        this.m_LiveShowDesktop.eventHDClosing(p_LiveShowSoundHD);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public void eventHDOpened(LiveShowSoundHD p_LiveShowSoundHD, File p_SoundFile, long p_SectionStart, long p_SectionEnd) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveShowSoundHDs.add(p_LiveShowSoundHD);
        this.m_LiveShowDesktop.eventHDOpened(p_LiveShowSoundHD, p_SoundFile, p_SectionStart, p_SectionEnd);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public void setHelpFocusListener(WindowFocusListener p_HelpFocusListener) {
        LiveShowSoundSystem.setHelpFocusListener((WindowFocusListener)p_HelpFocusListener);
    }
}

