/*
 * Decompiled with CFR 0.152.
 */
package LiveShowRemoteBoardPackage;

import DMXVirtualPackage.LiveShowDMXVIP;
import LiveShowControlObjects.ControlObject;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.PlayControlPanel;
import LiveShowPlayPackage.PlayRemoteActions;
import LiveShowProjectPackage.LiveShowInternalFrame_MixerMain;
import LiveShowProjectPackage.LiveShowInternalFrame_PlayJingles;
import LiveShowProjectPackage.LiveShowJingleGroup;
import LiveShowRemoteBoardPackage.JPanel_RemoteBoard;
import LiveShowRemoteBoardPackage.RemoteBoard_ActionsTableModel;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowSceneBridgeMain;
import LiveShowVirtualPackage.LiveShowVIP;
import MainPackage.LiveShowProjectDesktop;
import MediaVirtualPackage.LiveShowMediaVIP;
import SoundVirtualPackage.LiveShowSoundVIP;
import java.awt.Image;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public abstract class RemoteBoard_Action {
    public static final String ACTION_TYPE_JINGLE = "Jingle";
    public static final String ACTION_TYPE_JINGLEGROUP = "JingleGroup";
    public static final String ACTION_TYPE_MAINSOUND = "Main";
    public static final String ACTION_TYPE_MAINMEDIASOUND = "Main";
    public static final int ACTIONCOMMAND_UNKNOWN = 0;
    public static final int ACTIONCOMMAND_MINUS = 1;
    public static final int ACTIONCOMMAND_PLUS = 2;
    public static final int ACTIONCOMMAND_PLAY = 3;
    public static final int ACTIONCOMMAND_PLAYPAUSE = 4;
    public static final int ACTIONCOMMAND_PLAYSTOP = 5;
    public static final int ACTIONCOMMAND_FADEINOUT = 6;
    public static final int ACTIONCOMMAND_PLAYFADEOUT = 7;
    public static String ACTIONCOMMAND_UNKNOWN_NAME = "";
    public static RemoteBoard_ActionsTableModel s_RemoteBoard_ActionsTableModel = new RemoteBoard_ActionsTableModel();
    public static LiveShowSceneBridge s_LiveShowSceneBridge_Sound = null;
    public static LiveShowSceneBridge s_LiveShowSceneBridge_DMX = null;
    public static LiveShowSceneBridge s_LiveShowSceneBridge_Media = null;
    protected String m_ID;
    protected String m_ActionObjectType;
    protected int m_VIPType;
    protected String m_ActionObjectID;
    protected int m_ActionCommand;
    protected String m_Name;
    protected boolean m_IsPlaying;
    protected boolean m_IsAllPlaying;
    protected boolean m_IsPlayingStopped;
    protected ArrayList<RemoteBoard_ActionListener> m_Listeners;
    protected final Object m_SyncListeners = new Object();

    public static void createRemoteActionsGlobal() {
        PlayControlPanel o_PlayControlPanel = LiveShowProjectDesktop.getPlayControlPanel_Timeline();
        if (o_PlayControlPanel != null) {
            RemoteBoard_Action_GlobalPlayControl o_RemoteBoard_Action = new RemoteBoard_Action_GlobalPlayControl(o_PlayControlPanel, "sourceIDTimelinePlayStop", PlayRemoteActions.SOURCENAME_TIMELINE, 4);
            RemoteBoard_Action.addRemoteBoard_Action(o_RemoteBoard_Action);
            o_RemoteBoard_Action = new RemoteBoard_Action_GlobalPlayControl(o_PlayControlPanel, "sourceIDTimelineNextScene", PlayControlPanel.NAME_NEXTSCENE, 3);
            RemoteBoard_Action.addRemoteBoard_Action(o_RemoteBoard_Action);
            o_RemoteBoard_Action = new RemoteBoard_Action_GlobalPlayControl(o_PlayControlPanel, "sourceIDTimelineNextMainScene", PlayControlPanel.NAME_NEXTMAINSCENE, 3);
            RemoteBoard_Action.addRemoteBoard_Action(o_RemoteBoard_Action);
            o_RemoteBoard_Action = new RemoteBoard_Action_GlobalPlayControl(o_PlayControlPanel, "sourceIDTimelinePreviousScene", PlayControlPanel.NAME_PREVIOUSSCENE, 3);
            RemoteBoard_Action.addRemoteBoard_Action(o_RemoteBoard_Action);
            o_RemoteBoard_Action = new RemoteBoard_Action_GlobalPlayControl(o_PlayControlPanel, "sourceIDTimelinePreviousMainScene", PlayControlPanel.NAME_PREVIOUSMAINSCENE, 3);
            RemoteBoard_Action.addRemoteBoard_Action(o_RemoteBoard_Action);
        }
        RemoteBoard_Action.eventMainSoundVolumeAdded(LiveShowInternalFrame_MixerMain.getSoundControl_Volume().getControlObject(0));
        RemoteBoard_Action.eventMainMediaVolumeAdded(LiveShowInternalFrame_MixerMain.getMediaControl_SoundVolume().getControlObject(0));
    }

    public static void addRemoteBoard_Action(RemoteBoard_Action p_RemoteBoard_Action) {
        if (p_RemoteBoard_Action == null) {
            return;
        }
        RemoteBoard_Action o_RemoteBoard_Action = RemoteBoard_Action.getRemoteBoard_Action(p_RemoteBoard_Action.getActionObjectID(), p_RemoteBoard_Action.getActionCommand());
        if (o_RemoteBoard_Action != null) {
            JPanel_RemoteBoard.notifyRemoteBoard_Action_Changed(p_RemoteBoard_Action);
            return;
        }
        if (s_RemoteBoard_ActionsTableModel.add(p_RemoteBoard_Action)) {
            JPanel_RemoteBoard.notifyRemoteBoard_Action_Added(p_RemoteBoard_Action);
        }
    }

    public static void removeRemoteBoard_Action(RemoteBoard_Action p_RemoteBoard_Action) {
        if (p_RemoteBoard_Action == null) {
            return;
        }
        s_RemoteBoard_ActionsTableModel.remove(p_RemoteBoard_Action);
        p_RemoteBoard_Action.close();
    }

    public static void removeRemoteBoard_Action(String p_ActionObjectID) {
        if (p_ActionObjectID == null) {
            return;
        }
        for (int intAction = s_RemoteBoard_ActionsTableModel.size() - 1; intAction >= 0; --intAction) {
            RemoteBoard_Action o_RemoteBoard_Action = (RemoteBoard_Action)s_RemoteBoard_ActionsTableModel.get(intAction);
            if (o_RemoteBoard_Action == null || !o_RemoteBoard_Action.getActionObjectID().equals(p_ActionObjectID)) continue;
            RemoteBoard_Action.removeRemoteBoard_Action(o_RemoteBoard_Action);
        }
    }

    public static void changeRemoteBoard_Action(String p_ActionObjectID) {
        if (p_ActionObjectID == null) {
            return;
        }
        for (int intAction = s_RemoteBoard_ActionsTableModel.size() - 1; intAction >= 0; --intAction) {
            RemoteBoard_Action o_RemoteBoard_Action = (RemoteBoard_Action)s_RemoteBoard_ActionsTableModel.get(intAction);
            if (o_RemoteBoard_Action == null || !o_RemoteBoard_Action.getActionObjectID().equals(p_ActionObjectID)) continue;
            o_RemoteBoard_Action.eventActionObjectChanged();
            RemoteBoard_Action.eventChangedRemoteBoard_Action(o_RemoteBoard_Action);
        }
    }

    public static void eventChangedRemoteBoard_Action(RemoteBoard_Action p_RemoteBoard_Action) {
        s_RemoteBoard_ActionsTableModel.changedElement(p_RemoteBoard_Action);
        JPanel_RemoteBoard.notifyRemoteBoard_Action_Changed(p_RemoteBoard_Action);
    }

    public static RemoteBoard_Action getRemoteBoard_Action(String p_ID) {
        return s_RemoteBoard_ActionsTableModel.getRemoteBoard_Action(p_ID);
    }

    public static RemoteBoard_Action getRemoteBoard_Action(String p_ActionObjectID, int p_ActionCommand) {
        return s_RemoteBoard_ActionsTableModel.getRemoteBoard_Action(p_ActionObjectID, p_ActionCommand);
    }

    public static RemoteBoard_Action getRemoteBoard_Action(int p_Index) {
        return (RemoteBoard_Action)s_RemoteBoard_ActionsTableModel.get(p_Index);
    }

    public static void eventLiveShowSceneBridgeAdded(LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowSceneBridge == null) {
            return;
        }
        RemoteBoard_Action o_RemoteBoard_Action_SceneBridge = RemoteBoard_Action.getRemoteBoard_Action(p_LiveShowSceneBridge.getID(), 3);
        if (o_RemoteBoard_Action_SceneBridge == null) {
            o_RemoteBoard_Action_SceneBridge = new RemoteBoard_Action_SceneBridge(p_LiveShowSceneBridge, 3);
            RemoteBoard_Action.addRemoteBoard_Action(o_RemoteBoard_Action_SceneBridge);
        }
    }

    public static void eventLiveShowSceneBridgeRemoved(LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowSceneBridge == null) {
            return;
        }
        RemoteBoard_Action.removeRemoteBoard_Action(p_LiveShowSceneBridge.getID());
    }

    public static void eventLiveShowSceneBridgeChanged(LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowSceneBridge == null) {
            return;
        }
        RemoteBoard_Action.changeRemoteBoard_Action(p_LiveShowSceneBridge.getID());
    }

    public static void eventLiveShowSceneBridge_PlayStatus(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_CursorSceneBridge, LiveShowSceneBridge p_OldCursorSceneBridge, boolean p_ActualPlayInside, boolean p_ActualStopAtStart) {
        if (p_LiveShowVIP == null) {
            return;
        }
        LiveShowSceneBridge o_LiveShowSceneBridge_Actual = null;
        LiveShowSceneBridge o_LiveShowSceneBridge_Old = null;
        String stringSceneBridge_ActualID = null;
        String stringSceneBridge_OldID = null;
        if (p_LiveShowVIP instanceof LiveShowSoundVIP) {
            if (p_CursorSceneBridge != s_LiveShowSceneBridge_Sound) {
                o_LiveShowSceneBridge_Old = s_LiveShowSceneBridge_Sound;
                s_LiveShowSceneBridge_Sound = p_CursorSceneBridge;
            }
            o_LiveShowSceneBridge_Actual = s_LiveShowSceneBridge_Sound;
        } else if (p_LiveShowVIP instanceof LiveShowDMXVIP) {
            if (p_CursorSceneBridge != s_LiveShowSceneBridge_DMX) {
                o_LiveShowSceneBridge_Old = s_LiveShowSceneBridge_DMX;
                s_LiveShowSceneBridge_DMX = p_CursorSceneBridge;
            }
            o_LiveShowSceneBridge_Actual = s_LiveShowSceneBridge_DMX;
        }
        if (p_LiveShowVIP instanceof LiveShowMediaVIP) {
            if (p_CursorSceneBridge != s_LiveShowSceneBridge_Media) {
                o_LiveShowSceneBridge_Old = s_LiveShowSceneBridge_Media;
                s_LiveShowSceneBridge_Media = p_CursorSceneBridge;
            }
            o_LiveShowSceneBridge_Actual = s_LiveShowSceneBridge_Media;
        }
        if (o_LiveShowSceneBridge_Actual != null) {
            stringSceneBridge_ActualID = o_LiveShowSceneBridge_Actual.getID();
        }
        if (o_LiveShowSceneBridge_Old != null) {
            stringSceneBridge_OldID = o_LiveShowSceneBridge_Old.getID();
        }
        for (int intAction = s_RemoteBoard_ActionsTableModel.size() - 1; intAction >= 0; --intAction) {
            RemoteBoard_Action o_RemoteBoard_Action = (RemoteBoard_Action)s_RemoteBoard_ActionsTableModel.get(intAction);
            if (o_RemoteBoard_Action == null || !(o_RemoteBoard_Action instanceof RemoteBoard_Action_SceneBridge)) continue;
            RemoteBoard_Action_SceneBridge o_RemoteBoard_Action_SceneBridge = (RemoteBoard_Action_SceneBridge)o_RemoteBoard_Action;
            if (stringSceneBridge_ActualID != null && o_RemoteBoard_Action.getActionObjectID().equals(stringSceneBridge_ActualID)) {
                o_RemoteBoard_Action_SceneBridge.eventPlayStatus(p_LiveShowVIP, o_LiveShowSceneBridge_Actual, true, p_ActualPlayInside, p_ActualStopAtStart);
            }
            if (stringSceneBridge_OldID == null || !o_RemoteBoard_Action.getActionObjectID().equals(stringSceneBridge_OldID)) continue;
            o_RemoteBoard_Action_SceneBridge.eventPlayStatus(p_LiveShowVIP, o_LiveShowSceneBridge_Old, false, false, false);
        }
    }

    public static void eventJingleAdded(LiveShowInternalFrame_PlayJingles.JingleView p_JingleView) {
        if (p_JingleView == null) {
            return;
        }
        RemoteBoard_Action o_RemoteBoard_Action_Jingle = RemoteBoard_Action.getRemoteBoard_Action(p_JingleView.getJingleID(), 5);
        if (o_RemoteBoard_Action_Jingle == null) {
            o_RemoteBoard_Action_Jingle = new RemoteBoard_Action_Jingle(p_JingleView, 5);
            RemoteBoard_Action.addRemoteBoard_Action(o_RemoteBoard_Action_Jingle);
        }
        if (RemoteBoard_Action_Jingle.getVIPType(p_JingleView) == 1) {
            o_RemoteBoard_Action_Jingle = RemoteBoard_Action.getRemoteBoard_Action(p_JingleView.getJingleID(), 6);
            if (o_RemoteBoard_Action_Jingle == null) {
                o_RemoteBoard_Action_Jingle = new RemoteBoard_Action_Jingle(p_JingleView, 6);
                RemoteBoard_Action.addRemoteBoard_Action(o_RemoteBoard_Action_Jingle);
            }
        } else {
            o_RemoteBoard_Action_Jingle = RemoteBoard_Action.getRemoteBoard_Action(p_JingleView.getJingleID(), 7);
            if (o_RemoteBoard_Action_Jingle == null) {
                o_RemoteBoard_Action_Jingle = new RemoteBoard_Action_Jingle(p_JingleView, 7);
                RemoteBoard_Action.addRemoteBoard_Action(o_RemoteBoard_Action_Jingle);
            }
        }
    }

    public static void eventJingleRemoved(LiveShowInternalFrame_PlayJingles.JingleView p_JingleView) {
        if (p_JingleView == null) {
            return;
        }
        RemoteBoard_Action.removeRemoteBoard_Action(p_JingleView.getJingleID());
    }

    public static void eventJingleChanged(LiveShowInternalFrame_PlayJingles.JingleView p_JingleView) {
        if (p_JingleView == null) {
            return;
        }
        RemoteBoard_Action.changeRemoteBoard_Action(p_JingleView.getJingleID());
    }

    public static void eventJinglePlayStatus(LiveShowInternalFrame_PlayJingles.JingleView p_JingleView, PlayControlPanel.PlayControlPanelStatus p_PlayControlPanelStatus) {
        if (p_JingleView == null) {
            return;
        }
        if (p_PlayControlPanelStatus == null) {
            return;
        }
        String stringActionObjectID = p_JingleView.getJingleID();
        if (stringActionObjectID == null) {
            return;
        }
        for (int intAction = 0; intAction < s_RemoteBoard_ActionsTableModel.size(); ++intAction) {
            RemoteBoard_Action o_RemoteBoard_Action = (RemoteBoard_Action)s_RemoteBoard_ActionsTableModel.get(intAction);
            if (o_RemoteBoard_Action == null || !(o_RemoteBoard_Action instanceof RemoteBoard_Action_Jingle) || !stringActionObjectID.equals(o_RemoteBoard_Action.getActionObjectID())) continue;
            RemoteBoard_Action_Jingle o_RemoteBoard_Action_Jingle = (RemoteBoard_Action_Jingle)o_RemoteBoard_Action;
            o_RemoteBoard_Action_Jingle.eventPlayStatusJingle(p_JingleView, p_PlayControlPanelStatus);
        }
    }

    public static void eventJingleGroupAdded(LiveShowJingleGroup p_JingleGroup) {
        if (p_JingleGroup == null) {
            return;
        }
        RemoteBoard_Action o_RemoteBoard_Action_JingleGroup = RemoteBoard_Action.getRemoteBoard_Action(p_JingleGroup.getID(), 5);
        if (o_RemoteBoard_Action_JingleGroup == null) {
            o_RemoteBoard_Action_JingleGroup = new RemoteBoard_Action_JingleGroup(p_JingleGroup, 5);
            RemoteBoard_Action.addRemoteBoard_Action(o_RemoteBoard_Action_JingleGroup);
        }
        if ((o_RemoteBoard_Action_JingleGroup = RemoteBoard_Action.getRemoteBoard_Action(p_JingleGroup.getID(), 7)) == null) {
            o_RemoteBoard_Action_JingleGroup = new RemoteBoard_Action_JingleGroup(p_JingleGroup, 7);
            RemoteBoard_Action.addRemoteBoard_Action(o_RemoteBoard_Action_JingleGroup);
        }
        if ((o_RemoteBoard_Action_JingleGroup = RemoteBoard_Action.getRemoteBoard_Action(p_JingleGroup.getID(), 6)) == null) {
            o_RemoteBoard_Action_JingleGroup = new RemoteBoard_Action_JingleGroup(p_JingleGroup, 6);
            RemoteBoard_Action.addRemoteBoard_Action(o_RemoteBoard_Action_JingleGroup);
        }
    }

    public static void eventJingleGroupRemoved(LiveShowJingleGroup p_JingleGroup) {
        if (p_JingleGroup == null) {
            return;
        }
        RemoteBoard_Action.removeRemoteBoard_Action(p_JingleGroup.getID());
    }

    public static void eventJingleGroupChanged(LiveShowJingleGroup p_JingleGroup) {
        if (p_JingleGroup == null) {
            return;
        }
        RemoteBoard_Action.changeRemoteBoard_Action(p_JingleGroup.getID());
    }

    public static void eventJingleGroupPlayStatus(LiveShowJingleGroup p_JingleGroup) {
        if (p_JingleGroup == null) {
            return;
        }
        String stringActionObjectID = p_JingleGroup.getID();
        if (stringActionObjectID == null) {
            return;
        }
        for (int intAction = 0; intAction < s_RemoteBoard_ActionsTableModel.size(); ++intAction) {
            RemoteBoard_Action o_RemoteBoard_Action = (RemoteBoard_Action)s_RemoteBoard_ActionsTableModel.get(intAction);
            if (o_RemoteBoard_Action == null || !(o_RemoteBoard_Action instanceof RemoteBoard_Action_JingleGroup) || !stringActionObjectID.equals(o_RemoteBoard_Action.getActionObjectID())) continue;
            RemoteBoard_Action_JingleGroup o_RemoteBoard_Action_JingleGroup = (RemoteBoard_Action_JingleGroup)o_RemoteBoard_Action;
            o_RemoteBoard_Action_JingleGroup.eventPlayStatusJingleGroup(p_JingleGroup);
        }
    }

    public static void eventMainSoundVolumeAdded(ControlObject p_ControlObject) {
        RemoteBoard_Action o_RemoteBoard_Action_MainSoundVolume = RemoteBoard_Action.getRemoteBoard_Action(RemoteBoard_Action_MainSoundVolume.s_ID, 2);
        if (o_RemoteBoard_Action_MainSoundVolume == null) {
            o_RemoteBoard_Action_MainSoundVolume = new RemoteBoard_Action_MainSoundVolume(p_ControlObject, 2);
            RemoteBoard_Action.addRemoteBoard_Action(o_RemoteBoard_Action_MainSoundVolume);
        }
        if ((o_RemoteBoard_Action_MainSoundVolume = RemoteBoard_Action.getRemoteBoard_Action(RemoteBoard_Action_MainSoundVolume.s_ID, 1)) == null) {
            o_RemoteBoard_Action_MainSoundVolume = new RemoteBoard_Action_MainSoundVolume(p_ControlObject, 1);
            RemoteBoard_Action.addRemoteBoard_Action(o_RemoteBoard_Action_MainSoundVolume);
        }
    }

    public static void eventMainSoundVolumeRemoved(ControlObject p_ControlObject) {
        RemoteBoard_Action.removeRemoteBoard_Action(RemoteBoard_Action_MainSoundVolume.s_ID);
    }

    public static void eventMainMediaVolumeAdded(ControlObject p_ControlObject) {
        RemoteBoard_Action o_RemoteBoard_Action_MainMediaVolume = RemoteBoard_Action.getRemoteBoard_Action(RemoteBoard_Action_MainMediaVolume.s_ID, 2);
        if (o_RemoteBoard_Action_MainMediaVolume == null) {
            o_RemoteBoard_Action_MainMediaVolume = new RemoteBoard_Action_MainMediaVolume(p_ControlObject, 2);
            RemoteBoard_Action.addRemoteBoard_Action(o_RemoteBoard_Action_MainMediaVolume);
        }
        if ((o_RemoteBoard_Action_MainMediaVolume = RemoteBoard_Action.getRemoteBoard_Action(RemoteBoard_Action_MainMediaVolume.s_ID, 1)) == null) {
            o_RemoteBoard_Action_MainMediaVolume = new RemoteBoard_Action_MainMediaVolume(p_ControlObject, 1);
            RemoteBoard_Action.addRemoteBoard_Action(o_RemoteBoard_Action_MainMediaVolume);
        }
    }

    public static void eventMainMediaVolumeRemoved(ControlObject p_ControlObject) {
        RemoteBoard_Action.removeRemoteBoard_Action(RemoteBoard_Action_MainMediaVolume.s_ID);
    }

    public RemoteBoard_Action(String p_ObjectID, int p_ActionCommand) {
        this.initMembers();
        this.m_ActionCommand = p_ActionCommand;
        this.m_ID = p_ObjectID + String.valueOf(p_ActionCommand);
    }

    private void initMembers() {
        this.m_ID = "";
        this.m_Listeners = new ArrayList();
        this.m_ActionObjectType = "";
        this.m_ActionObjectID = null;
        this.m_VIPType = -1;
        this.m_ActionCommand = 0;
        this.m_Name = "";
        this.m_IsPlaying = false;
        this.m_IsAllPlaying = false;
        this.m_IsPlayingStopped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.notifyClosed();
        Object object = this.m_SyncListeners;
        synchronized (object) {
            this.m_Listeners.clear();
        }
    }

    public abstract String getActionObjectID();

    public abstract String getActionGroupName();

    public abstract String getName();

    public abstract String getSourceName();

    public abstract int getActionVIPType();

    public abstract void doAction();

    public abstract void eventActionObjectChanged();

    public abstract Image getDisplayImage_Default();

    public abstract String getDisplayText_Default();

    public abstract String getDisplayToolTip();

    public String getID() {
        return this.m_ID;
    }

    public String getActionVIPName() {
        switch (this.getActionVIPType()) {
            case 0: {
                return "Sound";
            }
            case 1: {
                return "DMX";
            }
            case 2: {
                return "Media";
            }
        }
        return "";
    }

    public String getActionTypeFullName() {
        StringBuilder o_StringBuilder = new StringBuilder();
        o_StringBuilder.append(this.getActionGroupName());
        o_StringBuilder.append(" ");
        o_StringBuilder.append(this.getActionVIPName());
        return o_StringBuilder.toString();
    }

    public int getActionCommand() {
        return this.m_ActionCommand;
    }

    public String getActionCommandName() {
        switch (this.m_ActionCommand) {
            case 0: {
                return ACTIONCOMMAND_UNKNOWN_NAME;
            }
            case 2: {
                return PlayRemoteActions.ACTIONNAME_UP;
            }
            case 1: {
                return PlayRemoteActions.ACTIONNAME_DOWN;
            }
            case 3: {
                return PlayRemoteActions.ACTIONNAME_PLAY;
            }
            case 4: {
                return PlayRemoteActions.ACTIONNAME_PLAYPAUSE;
            }
            case 5: {
                return PlayRemoteActions.ACTIONNAME_PLAYSTOP;
            }
            case 6: {
                return PlayRemoteActions.ACTIONNAME_FADEINOUT;
            }
            case 7: {
                return PlayRemoteActions.ACTIONNAME_PLAYFADEOUT;
            }
        }
        return "";
    }

    public void setIsPlaying(boolean p_IsPlaying, boolean p_IsAllPlaying, boolean p_IsStopped) {
        if (this.m_IsPlaying == p_IsPlaying && this.m_IsAllPlaying == p_IsAllPlaying && this.m_IsPlayingStopped == p_IsStopped) {
            return;
        }
        this.m_IsPlaying = p_IsPlaying;
        this.m_IsAllPlaying = p_IsAllPlaying;
        this.m_IsPlayingStopped = p_IsStopped;
        this.notifyIsPlaying();
    }

    public boolean getIsPlaying() {
        return this.m_IsPlaying;
    }

    public boolean getIsAllPlaying() {
        return this.m_IsAllPlaying;
    }

    public boolean getIsPlayingStopped() {
        return this.m_IsPlayingStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteBoard_ActionListener(RemoteBoard_ActionListener p_RemoteBoard_ActionListener) {
        if (p_RemoteBoard_ActionListener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_Listeners.contains(p_RemoteBoard_ActionListener)) {
                return;
            }
            this.m_Listeners.add(p_RemoteBoard_ActionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteBoard_ActionListener(RemoteBoard_ActionListener p_RemoteBoard_ActionListener) {
        if (p_RemoteBoard_ActionListener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            this.m_Listeners.remove(p_RemoteBoard_ActionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyClosed() {
        ArrayList<RemoteBoard_ActionListener> o_Listeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_Listeners.size() <= 0) {
                return;
            }
            o_Listeners = new ArrayList<RemoteBoard_ActionListener>(this.m_Listeners.size());
            o_Listeners.addAll(this.m_Listeners);
        }
        for (int intListener = 0; intListener < o_Listeners.size(); ++intListener) {
            RemoteBoard_ActionListener o_RemoteBoard_ActionListener = (RemoteBoard_ActionListener)o_Listeners.get(intListener);
            if (o_RemoteBoard_ActionListener == null) continue;
            o_RemoteBoard_ActionListener.eventRemoteBoard_ActionClosed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyChanged() {
        ArrayList<RemoteBoard_ActionListener> o_Listeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_Listeners.size() <= 0) {
                return;
            }
            o_Listeners = new ArrayList<RemoteBoard_ActionListener>(this.m_Listeners.size());
            o_Listeners.addAll(this.m_Listeners);
        }
        for (int intListener = 0; intListener < o_Listeners.size(); ++intListener) {
            RemoteBoard_ActionListener o_RemoteBoard_ActionListener = (RemoteBoard_ActionListener)o_Listeners.get(intListener);
            if (o_RemoteBoard_ActionListener == null) continue;
            o_RemoteBoard_ActionListener.eventRemoteBoard_ActionObjectChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyIsPlaying() {
        ArrayList<RemoteBoard_ActionListener> o_Listeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_Listeners.size() <= 0) {
                return;
            }
            o_Listeners = new ArrayList<RemoteBoard_ActionListener>(this.m_Listeners.size());
            o_Listeners.addAll(this.m_Listeners);
        }
        for (int intListener = 0; intListener < o_Listeners.size(); ++intListener) {
            RemoteBoard_ActionListener o_RemoteBoard_ActionListener = (RemoteBoard_ActionListener)o_Listeners.get(intListener);
            if (o_RemoteBoard_ActionListener == null) continue;
            o_RemoteBoard_ActionListener.eventRemoteBoard_ActionObjectPlaying(this, this.m_IsPlaying, this.m_IsAllPlaying, this.m_IsPlayingStopped);
        }
    }

    public static class RemoteBoard_Action_GlobalPlayControl
    extends RemoteBoard_Action {
        public static ImageIcon s_ImageIcon_TimelinePlayStartPause = new ImageIcon(RemoteBoard_Action_SceneBridge.class.getResource("/IconsPackage/PlayStartPause64.png"));
        public static ImageIcon s_ImageIcon_NextSceneBridge = new ImageIcon(RemoteBoard_Action_SceneBridge.class.getResource("/IconsPackage/Play_ScenebridgeNext.png"));
        public static ImageIcon s_ImageIcon_PrevioudSceneBridge = new ImageIcon(RemoteBoard_Action_SceneBridge.class.getResource("/IconsPackage/Play_ScenebridgePrevious.png"));
        public static ImageIcon s_ImageIcon_NextMainSceneBridge = new ImageIcon(RemoteBoard_Action_SceneBridge.class.getResource("/IconsPackage/Play_ScenebridgeMainNext.png"));
        public static ImageIcon s_ImageIcon_PreviousMainSceneBridge = new ImageIcon(RemoteBoard_Action_SceneBridge.class.getResource("/IconsPackage/Play_ScenebridgeMainPrevious.png"));
        private PlayControlPanel m_PlayControlPanel;
        private String m_SourceID;
        private String m_SourceName;

        public RemoteBoard_Action_GlobalPlayControl(PlayControlPanel p_PlayControlPanel, String p_SourceID, String p_SourceName, int p_Command) {
            super(p_SourceID, p_Command);
            this.initMembers();
            this.m_PlayControlPanel = p_PlayControlPanel;
            this.m_SourceID = p_SourceID;
            this.m_SourceName = p_SourceName;
        }

        @Override
        private void initMembers() {
            this.m_PlayControlPanel = null;
        }

        @Override
        public void close() {
            super.close();
            this.m_PlayControlPanel = null;
        }

        @Override
        public String getActionObjectID() {
            return this.m_SourceID;
        }

        @Override
        public String getActionGroupName() {
            return PlayRemoteActions.ACTIONGROUPNAME_GLOBAL;
        }

        @Override
        public int getActionVIPType() {
            return -1;
        }

        @Override
        public String getName() {
            return PlayRemoteActions.SOURCENAME_TIMELINE;
        }

        @Override
        public String getSourceName() {
            return this.m_SourceName;
        }

        @Override
        public Image getDisplayImage_Default() {
            switch (this.m_SourceID) {
                case "sourceIDTimelinePlayStop": {
                    return s_ImageIcon_TimelinePlayStartPause.getImage();
                }
                case "sourceIDTimelineNextScene": {
                    return s_ImageIcon_NextSceneBridge.getImage();
                }
                case "sourceIDTimelineNextMainScene": {
                    return s_ImageIcon_NextMainSceneBridge.getImage();
                }
                case "sourceIDTimelinePreviousScene": {
                    return s_ImageIcon_PrevioudSceneBridge.getImage();
                }
                case "sourceIDTimelinePreviousMainScene": {
                    return s_ImageIcon_PreviousMainSceneBridge.getImage();
                }
            }
            return null;
        }

        @Override
        public String getDisplayToolTip() {
            if (this.m_PlayControlPanel == null) {
                return null;
            }
            return this.m_PlayControlPanel.getToolTipText();
        }

        @Override
        public String getDisplayText_Default() {
            StringBuilder o_StringBuilder = new StringBuilder();
            o_StringBuilder.append(this.getSourceName());
            return o_StringBuilder.toString();
        }

        @Override
        public void doAction() {
            PlayControlPanel o_PlayControlPanel = this.m_PlayControlPanel;
            if (o_PlayControlPanel == null) {
                return;
            }
            switch (this.m_SourceID) {
                case "sourceIDTimelinePlayStop": {
                    o_PlayControlPanel.actionPlayStartPause();
                    break;
                }
                case "sourceIDTimelineNextScene": {
                    o_PlayControlPanel.actionNextScene();
                    break;
                }
                case "sourceIDTimelineNextMainScene": {
                    o_PlayControlPanel.actionNextMainScene();
                    break;
                }
                case "sourceIDTimelinePreviousScene": {
                    o_PlayControlPanel.actionPreviousScene();
                    break;
                }
                case "sourceIDTimelinePreviousMainScene": {
                    o_PlayControlPanel.actionPreviousMainScene();
                }
            }
        }

        @Override
        public void eventActionObjectChanged() {
            this.notifyChanged();
        }
    }

    public static class RemoteBoard_Action_MainMediaVolume
    extends RemoteBoard_Action {
        public static ImageIcon s_ImageIcon_MediaLouder = new ImageIcon(RemoteBoard_Action_SceneBridge.class.getResource("/IconsPackage/Loudspeaker_MediaLouder_128.png"));
        public static ImageIcon s_ImageIcon_MediaQuieter = new ImageIcon(RemoteBoard_Action_SceneBridge.class.getResource("/IconsPackage/Loudspeaker_MediaQuieter_128.png"));
        public static String s_ID = "mainmediavolume";
        public static double s_Step = 0.05;
        private ControlObject m_ControlObject;

        public RemoteBoard_Action_MainMediaVolume(ControlObject p_ControlObject, int p_Command) {
            super(s_ID, p_Command);
            this.initMembers();
            this.m_ControlObject = p_ControlObject;
        }

        @Override
        private void initMembers() {
            this.m_ControlObject = null;
        }

        @Override
        public void close() {
            super.close();
            this.m_ControlObject = null;
        }

        @Override
        public String getActionObjectID() {
            return s_ID;
        }

        @Override
        public String getActionGroupName() {
            return this.getActionVIPName();
        }

        @Override
        public int getActionVIPType() {
            return 2;
        }

        @Override
        public String getName() {
            return this.m_ControlObject.getName();
        }

        @Override
        public String getSourceName() {
            return "";
        }

        @Override
        public Image getDisplayImage_Default() {
            if (this.m_ActionCommand == 2) {
                return s_ImageIcon_MediaLouder.getImage();
            }
            if (this.m_ActionCommand == 1) {
                return s_ImageIcon_MediaQuieter.getImage();
            }
            return null;
        }

        @Override
        public String getDisplayToolTip() {
            return null;
        }

        @Override
        public String getDisplayText_Default() {
            StringBuilder o_StringBuilder = new StringBuilder();
            o_StringBuilder.append(this.getActionGroupName());
            o_StringBuilder.append(" ");
            o_StringBuilder.append(this.getActionCommandName());
            return o_StringBuilder.toString();
        }

        @Override
        public void doAction() {
            ControlObject o_ControlObject = this.m_ControlObject;
            if (o_ControlObject == null) {
                return;
            }
            double doubleValueNormed = o_ControlObject.getControlDimension(0).getValueNormed();
            if (this.m_ActionCommand == 2) {
                o_ControlObject.getControlDimension(0).setValueNormed(doubleValueNormed += s_Step, 2);
                o_ControlObject.setValueManuallyIsReady();
            } else if (this.m_ActionCommand == 1) {
                o_ControlObject.getControlDimension(0).setValueNormed(doubleValueNormed -= s_Step, 2);
                o_ControlObject.setValueManuallyIsReady();
            }
        }

        @Override
        public void eventActionObjectChanged() {
            this.notifyChanged();
        }
    }

    public static class RemoteBoard_Action_MainSoundVolume
    extends RemoteBoard_Action {
        public static ImageIcon s_ImageIcon_Louder = new ImageIcon(RemoteBoard_Action_SceneBridge.class.getResource("/IconsPackage/Loudspeaker_Louder_128.png"));
        public static ImageIcon s_ImageIcon_Quieter = new ImageIcon(RemoteBoard_Action_SceneBridge.class.getResource("/IconsPackage/Loudspeaker_Quieter_128.png"));
        public static String s_ID = "mainsoundvolume";
        public static double s_Step = 0.05;
        private ControlObject m_ControlObject;

        public RemoteBoard_Action_MainSoundVolume(ControlObject p_ControlObject, int p_Command) {
            super(s_ID, p_Command);
            this.initMembers();
            this.m_ControlObject = p_ControlObject;
        }

        @Override
        private void initMembers() {
            this.m_ControlObject = null;
        }

        @Override
        public void close() {
            super.close();
            this.m_ControlObject = null;
        }

        @Override
        public String getActionObjectID() {
            return s_ID;
        }

        @Override
        public String getActionGroupName() {
            return this.getActionVIPName();
        }

        @Override
        public int getActionVIPType() {
            return 0;
        }

        @Override
        public String getName() {
            return this.m_ControlObject.getName();
        }

        @Override
        public String getSourceName() {
            return "";
        }

        @Override
        public Image getDisplayImage_Default() {
            if (this.m_ActionCommand == 2) {
                return s_ImageIcon_Louder.getImage();
            }
            if (this.m_ActionCommand == 1) {
                return s_ImageIcon_Quieter.getImage();
            }
            return null;
        }

        @Override
        public String getDisplayToolTip() {
            return null;
        }

        @Override
        public String getDisplayText_Default() {
            StringBuilder o_StringBuilder = new StringBuilder();
            o_StringBuilder.append(this.getActionGroupName());
            o_StringBuilder.append(" ");
            o_StringBuilder.append(this.getActionCommandName());
            return o_StringBuilder.toString();
        }

        @Override
        public void doAction() {
            ControlObject o_ControlObject = this.m_ControlObject;
            if (o_ControlObject == null) {
                return;
            }
            double doubleValueNormed = o_ControlObject.getControlDimension(0).getValueNormed();
            if (this.m_ActionCommand == 2) {
                o_ControlObject.getControlDimension(0).setValueNormed(doubleValueNormed += s_Step, 2);
                o_ControlObject.setValueManuallyIsReady();
            } else if (this.m_ActionCommand == 1) {
                o_ControlObject.getControlDimension(0).setValueNormed(doubleValueNormed -= s_Step, 2);
                o_ControlObject.setValueManuallyIsReady();
            }
        }

        @Override
        public void eventActionObjectChanged() {
            this.notifyChanged();
        }
    }

    public static class RemoteBoard_Action_SceneBridge
    extends RemoteBoard_Action {
        public static ImageIcon s_ImageIcon_SceneBridge = new ImageIcon(RemoteBoard_Action_SceneBridge.class.getResource("/IconsPackage/Scenebridge.png"));
        public static ImageIcon s_ImageIcon_MainSceneBridge = new ImageIcon(RemoteBoard_Action_SceneBridge.class.getResource("/IconsPackage/Scenebridge_Main.png"));
        private LiveShowSceneBridge m_LiveShowSceneBridge;
        private boolean m_MainBridge_IsPlaying_Sound;
        private boolean m_MainBridge_IsPlaying_DMX;
        private boolean m_MainBridge_IsPlaying_Media;

        public RemoteBoard_Action_SceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge, int p_Command) {
            super(p_LiveShowSceneBridge.getID(), p_Command);
            this.initMembers();
            this.m_LiveShowSceneBridge = p_LiveShowSceneBridge;
        }

        @Override
        private void initMembers() {
            this.m_LiveShowSceneBridge = null;
            this.m_MainBridge_IsPlaying_Sound = false;
            this.m_MainBridge_IsPlaying_DMX = false;
            this.m_MainBridge_IsPlaying_Media = false;
        }

        @Override
        public void close() {
            super.close();
            this.m_LiveShowSceneBridge = null;
        }

        @Override
        public String getActionObjectID() {
            LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSceneBridge;
            if (o_LiveShowSceneBridge == null) {
                return "";
            }
            return o_LiveShowSceneBridge.getID();
        }

        @Override
        public String getActionGroupName() {
            LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSceneBridge;
            if (o_LiveShowSceneBridge == null) {
                return "";
            }
            if (o_LiveShowSceneBridge.getIsMainBridge()) {
                return LiveShowSceneBridgeMain.s_MainBridgeRemoteGroupName;
            }
            return o_LiveShowSceneBridge.getRemoteGroupName();
        }

        @Override
        public int getActionVIPType() {
            LiveShowVIP o_LiveShowVIP = null;
            LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSceneBridge;
            if (o_LiveShowSceneBridge != null) {
                o_LiveShowVIP = o_LiveShowSceneBridge.getLiveShowVIP();
            }
            if (o_LiveShowVIP == null) {
                return -1;
            }
            if (o_LiveShowVIP instanceof LiveShowSoundVIP) {
                return 0;
            }
            if (o_LiveShowVIP instanceof LiveShowDMXVIP) {
                return 1;
            }
            if (o_LiveShowVIP instanceof LiveShowMediaVIP) {
                return 2;
            }
            return -1;
        }

        @Override
        public String getName() {
            LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSceneBridge;
            if (o_LiveShowSceneBridge == null) {
                return "";
            }
            return o_LiveShowSceneBridge.getName();
        }

        @Override
        public String getSourceName() {
            return "";
        }

        @Override
        public Image getDisplayImage_Default() {
            LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSceneBridge;
            if (o_LiveShowSceneBridge == null) {
                return null;
            }
            if (o_LiveShowSceneBridge.getIsMainBridge()) {
                return s_ImageIcon_MainSceneBridge.getImage();
            }
            return s_ImageIcon_SceneBridge.getImage();
        }

        @Override
        public String getDisplayToolTip() {
            if (this.m_LiveShowSceneBridge == null) {
                return null;
            }
            return this.m_LiveShowSceneBridge.getToolTipText();
        }

        @Override
        public String getDisplayText_Default() {
            StringBuilder o_StringBuilder = new StringBuilder();
            LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSceneBridge;
            if (o_LiveShowSceneBridge != null) {
                if (o_LiveShowSceneBridge.getIsMainBridge()) {
                    o_StringBuilder.append(o_LiveShowSceneBridge.getName());
                } else {
                    o_StringBuilder.append(this.getActionVIPName());
                    o_StringBuilder.append(" ");
                    o_StringBuilder.append(o_LiveShowSceneBridge.getName());
                }
            }
            return o_StringBuilder.toString();
        }

        @Override
        public void doAction() {
            Play.PlaySynchronisizer o_PlaySynchronisizer;
            LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSceneBridge;
            if (o_LiveShowSceneBridge == null) {
                return;
            }
            LiveShowVIP o_LiveShowVIP = o_LiveShowSceneBridge.getLiveShowVIP();
            if (o_LiveShowVIP == null) {
                return;
            }
            o_LiveShowVIP.gotoSceneBridge(o_LiveShowSceneBridge, false);
            PlayControlPanel o_PlayControlPanel = LiveShowProjectDesktop.getPlayControlPanel_Main();
            if (o_PlayControlPanel != null && (o_PlaySynchronisizer = o_PlayControlPanel.getPlaySynchronisizer()) != null) {
                o_PlaySynchronisizer.actionStartPlaysSceneBridge();
            }
        }

        @Override
        public void eventActionObjectChanged() {
            this.notifyChanged();
        }

        public void eventPlayStatus(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_IsPlaying, boolean p_IsPlayingInside, boolean p_IsStoppedAtStart) {
            if (p_LiveShowVIP == null) {
                return;
            }
            if (p_LiveShowSceneBridge == null) {
                return;
            }
            boolean boolIsPlaying = false;
            boolean boolIsAllPlaying = false;
            if (p_LiveShowSceneBridge.getIsMainBridge()) {
                if (p_LiveShowVIP instanceof LiveShowSoundVIP) {
                    this.m_MainBridge_IsPlaying_Sound = p_IsPlaying;
                } else if (p_LiveShowVIP instanceof LiveShowDMXVIP) {
                    this.m_MainBridge_IsPlaying_DMX = p_IsPlaying;
                } else if (p_LiveShowVIP instanceof LiveShowMediaVIP) {
                    this.m_MainBridge_IsPlaying_Media = p_IsPlaying;
                }
                if (this.m_MainBridge_IsPlaying_Sound || this.m_MainBridge_IsPlaying_DMX || this.m_MainBridge_IsPlaying_Media) {
                    boolIsPlaying = true;
                    boolIsAllPlaying = this.m_MainBridge_IsPlaying_Sound && this.m_MainBridge_IsPlaying_DMX && this.m_MainBridge_IsPlaying_Media;
                }
            } else {
                boolIsPlaying = p_IsPlaying;
                boolIsAllPlaying = boolIsAllPlaying ? true : true;
            }
            super.setIsPlaying(boolIsPlaying, boolIsAllPlaying, p_IsStoppedAtStart);
        }
    }

    public static class RemoteBoard_Action_JingleGroup
    extends RemoteBoard_Action {
        public static ImageIcon s_ImageIcon_JingleGroup = new ImageIcon(RemoteBoard_Action_SceneBridge.class.getResource("/IconsPackage/JingleGroup.png"));
        private LiveShowJingleGroup m_JingleGroup;

        public RemoteBoard_Action_JingleGroup(LiveShowJingleGroup p_JingleGroup, int p_Command) {
            super(p_JingleGroup.getID(), p_Command);
            this.initMembers();
            this.m_JingleGroup = p_JingleGroup;
        }

        @Override
        private void initMembers() {
            this.m_JingleGroup = null;
        }

        @Override
        public void close() {
            super.close();
            this.m_JingleGroup = null;
        }

        @Override
        public String getActionObjectID() {
            LiveShowJingleGroup o_JingleGroup = this.m_JingleGroup;
            if (o_JingleGroup == null) {
                return "";
            }
            return o_JingleGroup.getID();
        }

        @Override
        public String getActionGroupName() {
            return PlayRemoteActions.ACTIONGROUPNAME_JINGLEGROUP;
        }

        @Override
        public int getActionVIPType() {
            return -1;
        }

        @Override
        public String getName() {
            LiveShowJingleGroup o_JingleGroup = this.m_JingleGroup;
            if (o_JingleGroup == null) {
                return "";
            }
            return o_JingleGroup.getName();
        }

        @Override
        public String getSourceName() {
            return "";
        }

        @Override
        public Image getDisplayImage_Default() {
            return s_ImageIcon_JingleGroup.getImage();
        }

        @Override
        public String getDisplayToolTip() {
            if (this.m_JingleGroup == null) {
                return null;
            }
            return this.m_JingleGroup.getToolTipText();
        }

        @Override
        public String getDisplayText_Default() {
            StringBuilder o_StringBuilder = new StringBuilder();
            LiveShowJingleGroup o_LiveShowJingleGroup = this.m_JingleGroup;
            if (o_LiveShowJingleGroup != null) {
                o_StringBuilder.append(o_LiveShowJingleGroup.getName());
            }
            return o_StringBuilder.toString();
        }

        @Override
        public void doAction() {
            LiveShowJingleGroup o_JingleGroup = this.m_JingleGroup;
            if (o_JingleGroup == null) {
                return;
            }
            if (this.m_ActionCommand == 5) {
                o_JingleGroup.playStartStop();
            }
            if (this.m_ActionCommand == 7) {
                o_JingleGroup.playStartFadeOut();
            } else if (this.m_ActionCommand == 6) {
                o_JingleGroup.playFadeInOut();
            }
        }

        @Override
        public void eventActionObjectChanged() {
            this.notifyChanged();
        }

        public void eventPlayStatusJingleGroup(LiveShowJingleGroup p_JingleGroup) {
            if (p_JingleGroup == null) {
                return;
            }
            boolean boolPlaying = false;
            boolean boolAllPlaying = false;
            boolean boolPlayingStopped = false;
            if (p_JingleGroup.getPlayJingleRunning() || p_JingleGroup.getPlayJingleWaiting()) {
                boolPlaying = true;
                if (p_JingleGroup.getPlayJingleWaiting()) {
                    boolAllPlaying = false;
                } else if (p_JingleGroup.getPlayJingleCount() == p_JingleGroup.getJingleInterfaceCount()) {
                    boolAllPlaying = true;
                }
                if (!p_JingleGroup.getPlayJingleRunning()) {
                    boolPlayingStopped = true;
                }
            }
            this.setIsPlaying(boolPlaying, boolAllPlaying, boolPlayingStopped);
        }
    }

    public static class RemoteBoard_Action_Jingle
    extends RemoteBoard_Action {
        public static ImageIcon s_ImageIcon_Jingle = new ImageIcon(RemoteBoard_Action_SceneBridge.class.getResource("/IconsPackage/Jingle.png"));
        private LiveShowInternalFrame_PlayJingles.JingleView m_JingleView;

        public RemoteBoard_Action_Jingle(LiveShowInternalFrame_PlayJingles.JingleView p_JingleView, int p_Command) {
            super(p_JingleView.getJingleID(), p_Command);
            this.initMembers();
            this.m_JingleView = p_JingleView;
        }

        @Override
        private void initMembers() {
            this.m_JingleView = null;
        }

        @Override
        public void close() {
            super.close();
            this.m_JingleView = null;
        }

        @Override
        public String getActionObjectID() {
            LiveShowInternalFrame_PlayJingles.JingleView o_JingleView = this.m_JingleView;
            if (o_JingleView == null) {
                return "";
            }
            return o_JingleView.getJingleID();
        }

        @Override
        public String getActionGroupName() {
            return PlayRemoteActions.ACTIONGROUPNAME_JINGLE;
        }

        public static int getVIPType(LiveShowInternalFrame_PlayJingles.JingleView o_JingleView) {
            LiveShowObject o_LiveShowObjectInterface;
            LiveShowVIP o_LiveShowVIP = null;
            if (o_JingleView != null && (o_LiveShowObjectInterface = o_JingleView.getLiveShowObject()) != null) {
                o_LiveShowVIP = o_LiveShowObjectInterface.getLiveShowVIP();
            }
            if (o_LiveShowVIP == null) {
                return -1;
            }
            if (o_LiveShowVIP instanceof LiveShowSoundVIP) {
                return 0;
            }
            if (o_LiveShowVIP instanceof LiveShowDMXVIP) {
                return 1;
            }
            if (o_LiveShowVIP instanceof LiveShowMediaVIP) {
                return 2;
            }
            return -1;
        }

        @Override
        public int getActionVIPType() {
            LiveShowInternalFrame_PlayJingles.JingleView o_JingleView = this.m_JingleView;
            return RemoteBoard_Action_Jingle.getVIPType(o_JingleView);
        }

        @Override
        public String getName() {
            LiveShowInternalFrame_PlayJingles.JingleView o_JingleView = this.m_JingleView;
            if (o_JingleView == null) {
                return "";
            }
            String stringName = o_JingleView.getName();
            if (stringName == null) {
                stringName = "";
            }
            return stringName;
        }

        @Override
        public String getSourceName() {
            LiveShowInternalFrame_PlayJingles.JingleView o_JingleView = this.m_JingleView;
            if (o_JingleView == null) {
                return "";
            }
            String stringSourceName = o_JingleView.getJingleSourceName();
            if (stringSourceName == null) {
                stringSourceName = "";
            }
            return stringSourceName;
        }

        @Override
        public Image getDisplayImage_Default() {
            return s_ImageIcon_Jingle.getImage();
        }

        @Override
        public String getDisplayToolTip() {
            if (this.m_JingleView == null) {
                return null;
            }
            return this.m_JingleView.getToolTipText_RightClick();
        }

        @Override
        public String getDisplayText_Default() {
            StringBuilder o_StringBuilder = new StringBuilder();
            o_StringBuilder.append(this.getActionVIPName());
            LiveShowInternalFrame_PlayJingles.JingleView o_JingleView = this.m_JingleView;
            if (o_JingleView != null) {
                o_StringBuilder.append(" ");
                o_StringBuilder.append(o_JingleView.getJingleName());
            }
            return o_StringBuilder.toString();
        }

        @Override
        public void doAction() {
            LiveShowInternalFrame_PlayJingles.JingleView o_JingleView = this.m_JingleView;
            if (o_JingleView == null) {
                return;
            }
            PlayControlPanel.PlayControlPanelStatus o_PlayControlPanelStatus = o_JingleView.getPlayControlPanelStatus();
            if (o_PlayControlPanelStatus == null) {
                return;
            }
            if (this.m_ActionCommand == 5) {
                if (o_PlayControlPanelStatus.getStopEnabled()) {
                    o_JingleView.playStop();
                } else {
                    o_JingleView.playStart();
                }
            } else if (this.m_ActionCommand == 6 || this.m_ActionCommand == 7) {
                if (o_PlayControlPanelStatus.getFadeOutDirectEnabled()) {
                    o_JingleView.playFadeOut();
                } else if (o_PlayControlPanelStatus.getFadeOutEnabled()) {
                    o_JingleView.playFadeOut();
                } else if (this.getActionVIPType() == 1) {
                    o_JingleView.playFadeIn();
                } else {
                    o_JingleView.playStart();
                }
            }
        }

        @Override
        public void eventActionObjectChanged() {
            this.notifyChanged();
        }

        public void eventPlayStatusJingle(LiveShowInternalFrame_PlayJingles.JingleView p_JingleView, PlayControlPanel.PlayControlPanelStatus p_PlayControlPanelStatus) {
            if (p_JingleView == null) {
                return;
            }
            if (p_PlayControlPanelStatus == null) {
                return;
            }
            this.setIsPlaying(p_PlayControlPanelStatus.getStopEnabled(), true, !p_PlayControlPanelStatus.getPauseEnabled());
        }
    }

    public static interface RemoteBoard_ActionListener {
        public void eventRemoteBoard_ActionClosed(RemoteBoard_Action var1);

        public void eventRemoteBoard_ActionObjectChanged(RemoteBoard_Action var1);

        public void eventRemoteBoard_ActionObjectPlaying(RemoteBoard_Action var1, boolean var2, boolean var3, boolean var4);
    }
}

