/*
 * Decompiled with CFR 0.152.
 */
package LiveShowRemoteBoardPackage;

import LiveShowRemoteBoardPackage.JPanel_RemoteBoard;
import LiveShowRemoteBoardPackage.RemoteBoard_Action;
import SwingToolTipPackage.JLabel_RightClickToolTip;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import ToolsGraphics.ImagesTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class JPanel_RemoteBoardItem
extends JPanel
implements RemoteBoard_Action.RemoteBoard_ActionListener {
    private static Dimension s_DisplaySize = new Dimension(72, 72);
    private static Dimension s_ImageSize = new Dimension(200, 200);
    private static Border s_Border_Selected = new LineBorder(Color.BLUE, 1);
    private static Border s_Border_Edit = new LineBorder(Color.GRAY, 1);
    private static Border s_Border_Pressed = new LineBorder(Color.RED, 1);
    private static Border s_Border_Normal = null;
    private static Border s_Border_AllPlaying = new LineBorder(Color.GREEN, 1);
    private static Border s_Border_SomePlaying = new LineBorder(new Color(255, 255, 100), 1);
    private static Border s_Border_PlayingStopped = new LineBorder(Color.ORANGE, 1);
    private static ImageIcon s_Icon_Pressed = new ImageIcon(JPanel_RemoteBoardItem.class.getResource("/IconsPackage/ButtonPressed.png"));
    public static final int DISPLAY_IMAGE_NOIMAGE = 0;
    public static final int DISPLAY_IMAGE_DEFAULTIMAGE = 1;
    public static final int DISPLAY_IMAGE_CUSTOMIMAGE = 2;
    public static final int DISPLAY_TEXT_NOTEXT = 0;
    public static final int DISPLAY_TEXT_DEFAULTTEXT = 1;
    public static final int DISPLAY_TEXT_CUSTOMTEXT = 2;
    public static final int DISPLAY_TEXT_ANCHOR_SOUTH = 0;
    public static final int DISPLAY_TEXT_ANCHOR_CENTER = 1;
    public static final int DISPLAY_TEXT_ANCHOR_NORD = 2;
    private JPanel_RemoteBoard m_JPanel_RemoteBoard;
    private GridBagConstraints m_GridBagConstraints;
    private ItemDescription m_ItemDescription;
    private RemoteBoard_Action m_RemoteBoard_Action;
    private boolean m_IsPlaying;
    private boolean m_IsPlayingAll;
    private boolean m_IsPlayingStopped;
    private ImageIcon m_Icon_Image_Custom;
    private BufferedImage m_Image_Default;
    private ImageIcon m_Icon_Image_Default;
    private ImageIcon m_Icon_ToShow;
    private String m_Text_Default;
    private JPanel_RemoteBoardItem m_SelfReference = this;
    private boolean m_Selected;
    ItemDrag m_ItemDrag;
    ItemDrop m_ItemDrop;
    private JLabel_RightClickToolTip jLabel_Icon;
    private JLabel_RightClickToolTip jLabel_Text;
    public static DataFlavor s_RemoteBoardItem_DataFlavor = new DataFlavor(JPanel_RemoteBoardItem.class, "RemoteBoardItem");
    public static DataFlavor[] s_DataFlavors = new DataFlavor[]{s_RemoteBoardItem_DataFlavor};

    public JPanel_RemoteBoardItem(JPanel_RemoteBoard p_JPanel_RemoteBoard, int p_GridX, int p_GridY) {
        this.initMembers();
        this.m_ItemDescription.setGridX(p_GridX);
        this.m_ItemDescription.setGridY(p_GridY);
        this.m_JPanel_RemoteBoard = p_JPanel_RemoteBoard;
        this.initComponents();
        this.initComponentsFurther();
        this.m_GridBagConstraints.gridx = p_GridX;
        this.m_GridBagConstraints.gridy = p_GridY;
        this.refreshGUI();
    }

    private void initComponents() {
        this.jLabel_Text = new JLabel_RightClickToolTip();
        this.jLabel_Icon = new JLabel_RightClickToolTip();
        this.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.setMaximumSize(new Dimension(72, 72));
        this.setMinimumSize(new Dimension(72, 72));
        this.setName("");
        this.setPreferredSize(new Dimension(72, 72));
        this.setLayout(new GridBagLayout());
        this.jLabel_Text.setHorizontalAlignment(0);
        this.jLabel_Text.setFont(new Font("Arial", 0, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jLabel_Text, gridBagConstraints);
        this.jLabel_Icon.setHorizontalAlignment(0);
        this.jLabel_Icon.setFont(new Font("Tahoma", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jLabel_Icon, gridBagConstraints);
    }

    private void initMembers() {
        this.m_Selected = false;
        this.m_ItemDescription = new ItemDescription();
        this.m_RemoteBoard_Action = null;
        this.m_ItemDescription.setRemoteBoard_ActionID("");
        this.m_ItemDescription.setBackground_Transparent(true);
        this.m_ItemDescription.setBackground_Color(Color.BLACK);
        this.m_ItemDescription.setImage(null);
        this.m_ItemDescription.setImage_Flag(1);
        this.m_ItemDescription.setText("");
        this.m_ItemDescription.setText_Color(Color.WHITE);
        this.m_ItemDescription.setText_Flag(1);
        this.m_ItemDescription.setText_AnchorFlag(1);
        this.m_Icon_Image_Custom = null;
        this.m_Image_Default = null;
        this.m_Icon_Image_Default = null;
        this.m_Icon_ToShow = null;
        this.m_Text_Default = "";
        this.m_IsPlaying = false;
        this.m_IsPlayingAll = false;
        this.m_IsPlayingStopped = false;
    }

    private void initComponentsFurther() {
        this.m_GridBagConstraints = new GridBagConstraints();
        this.m_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
        MouseAdapter o_MouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                JPanel_RemoteBoard o_JPanel_RemoteBoard = JPanel_RemoteBoardItem.this.m_JPanel_RemoteBoard;
                if (o_JPanel_RemoteBoard == null) {
                    return;
                }
                if (!o_JPanel_RemoteBoard.getEditMode() && JPanel_RemoteBoardItem.this.getRemoteBoard_Action() != null) {
                    JPanel_RemoteBoardItem.this.jLabel_Icon.setIcon((Icon)s_Icon_Pressed);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (e.getX() < 0 || e.getX() > JPanel_RemoteBoardItem.this.getWidth() || e.getY() < 0 || e.getY() > JPanel_RemoteBoardItem.this.getHeight()) {
                    JPanel_RemoteBoard o_JPanel_RemoteBoard = JPanel_RemoteBoardItem.this.m_JPanel_RemoteBoard;
                    if (o_JPanel_RemoteBoard == null) {
                        return;
                    }
                    if (!o_JPanel_RemoteBoard.getEditMode()) {
                        JPanel_RemoteBoardItem.this.jLabel_Icon.setIcon((Icon)JPanel_RemoteBoardItem.this.m_Icon_ToShow);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                JPanel_RemoteBoardItem.this.jLabel_Icon.setIcon((Icon)JPanel_RemoteBoardItem.this.m_Icon_ToShow);
                JPanel_RemoteBoard o_JPanel_RemoteBoard = JPanel_RemoteBoardItem.this.m_JPanel_RemoteBoard;
                if (o_JPanel_RemoteBoard == null) {
                    return;
                }
                if (!o_JPanel_RemoteBoard.getEditMode()) {
                    if (JPanel_RemoteBoardItem.this.getRemoteBoard_Action() != null && e.getX() >= 0 && e.getX() <= JPanel_RemoteBoardItem.this.getWidth() && e.getY() >= 0 && e.getY() <= JPanel_RemoteBoardItem.this.getHeight()) {
                        JPanel_RemoteBoardItem.this.doAction();
                    }
                } else {
                    o_JPanel_RemoteBoard.setSelectedRemoteBoardItem(JPanel_RemoteBoardItem.this.m_SelfReference);
                }
            }
        };
        this.addMouseListener(o_MouseAdapter);
        this.addMouseMotionListener(o_MouseAdapter);
        this.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.setMinimumSize(s_DisplaySize);
        this.setMaximumSize(s_DisplaySize);
        this.setPreferredSize(s_DisplaySize);
        this.m_ItemDrag = new ItemDrag(this.m_SelfReference);
        this.m_ItemDrop = new ItemDrop(this.m_SelfReference);
    }

    public void close() {
        this.m_ItemDrop.close();
        this.m_ItemDrag.close();
        JPanel_RemoteBoard o_JPanel_RemoteBoard = this.m_JPanel_RemoteBoard;
        if (this.m_Selected) {
            if (o_JPanel_RemoteBoard != null) {
                o_JPanel_RemoteBoard.setSelectedRemoteBoardItem(null);
            }
            this.m_Selected = false;
        }
        this.setRemoteBoard_Action(null);
        this.m_ItemDescription.close();
    }

    public void setItemDescription(ItemDescription p_ItemDescription) {
        if (p_ItemDescription == null) {
            return;
        }
        if (!p_ItemDescription.copyContentTo(this.m_ItemDescription)) {
            return;
        }
        String stringActionID = this.m_ItemDescription.getRemoteBoard_ActionID();
        RemoteBoard_Action o_RemoteBoard_Action = RemoteBoard_Action.getRemoteBoard_Action(stringActionID);
        if (o_RemoteBoard_Action == null) {
            String stringActionID_Lost = this.m_ItemDescription.getRemoteBoard_ActionID_Lost();
            if (stringActionID_Lost != null && stringActionID_Lost.length() > 0) {
                o_RemoteBoard_Action = RemoteBoard_Action.getRemoteBoard_Action(stringActionID_Lost);
            } else {
                this.m_ItemDescription.setRemoteBoard_ActionID_Lost(stringActionID);
            }
        }
        this.setRemoteBoard_Action(o_RemoteBoard_Action);
        BufferedImage o_BufferedImage_Icon = ImagesTools.convertToBufferedImageAspectRatio((Image)this.m_ItemDescription.getImage(), (Dimension)s_DisplaySize);
        this.m_Icon_Image_Custom = o_BufferedImage_Icon == null ? null : new ImageIcon(o_BufferedImage_Icon);
        this.refreshToolTip();
        this.refreshGUI();
        this.notifyRemoteBoardItemChanged(true);
    }

    public ItemDescription getItemDescription() {
        return this.m_ItemDescription;
    }

    public void clearContent() {
        if (this.m_RemoteBoard_Action != null) {
            this.m_RemoteBoard_Action.removeRemoteBoard_ActionListener(this.m_SelfReference);
        }
        this.m_RemoteBoard_Action = null;
        this.m_IsPlaying = false;
        this.m_IsPlayingAll = false;
        this.m_IsPlayingStopped = false;
        this.m_ItemDescription.setRemoteBoard_ActionID("");
        this.m_ItemDescription.setRemoteBoard_ActionID_Lost("");
        this.m_ItemDescription.setBackground_Transparent(true);
        this.m_ItemDescription.setBackground_Color(Color.BLACK);
        this.calculateImage_Default(null);
        this.m_Icon_Image_Default = null;
        this.m_ItemDescription.setImage(null);
        this.m_Icon_Image_Custom = null;
        this.m_ItemDescription.setImage_Flag(1);
        this.m_ItemDescription.setText("");
        this.m_Text_Default = "";
        this.m_ItemDescription.setText_Flag(1);
        this.m_ItemDescription.setText_AnchorFlag(1);
        this.m_ItemDescription.setText_Color(Color.WHITE);
        this.refreshToolTip();
        this.refreshGUI();
        JPanel_RemoteBoard o_JPanel_RemoteBoard = this.m_JPanel_RemoteBoard;
        if (o_JPanel_RemoteBoard != null) {
            o_JPanel_RemoteBoard.notifyRemoteBoardItemChanged(this, true);
        }
    }

    public boolean isEmpty() {
        if (this.getRemoteBoard_Action() != null) {
            return false;
        }
        if (!this.getDisplayBackground_Transparent()) {
            return false;
        }
        if (this.getDisplayImage_Flag() == 2) {
            return false;
        }
        return this.getDisplayText_Flag() != 2;
    }

    public JPanel_RemoteBoard getJPanel_RemoteBoard() {
        return this.m_JPanel_RemoteBoard;
    }

    public void setDisplaySize(int p_Width, int p_Height) {
        JPanel_RemoteBoardItem.s_DisplaySize.width = p_Width;
        JPanel_RemoteBoardItem.s_DisplaySize.height = p_Height;
        this.setMinimumSize(s_DisplaySize);
        this.setMaximumSize(s_DisplaySize);
        this.setPreferredSize(s_DisplaySize);
    }

    public void notifyRemoteBoardItemChanged(boolean p_ImageChanged) {
        JPanel_RemoteBoard o_JPanel_RemoteBoard = this.m_JPanel_RemoteBoard;
        if (o_JPanel_RemoteBoard != null) {
            o_JPanel_RemoteBoard.notifyRemoteBoardItemChanged(this, p_ImageChanged);
        }
    }

    public void notifyRemoteBoardItemPlayStatus() {
        JPanel_RemoteBoard o_JPanel_RemoteBoard = this.m_JPanel_RemoteBoard;
        if (o_JPanel_RemoteBoard != null) {
            o_JPanel_RemoteBoard.notifyRemoteBoardItemPlayStatus(this);
        }
    }

    public boolean setRemoteBoard_Action(RemoteBoard_Action p_RemoteBoard_Action) {
        boolean boolImageChanged = false;
        if (this.m_RemoteBoard_Action == p_RemoteBoard_Action) {
            return false;
        }
        if (this.m_RemoteBoard_Action != null) {
            this.m_RemoteBoard_Action.removeRemoteBoard_ActionListener(this);
            this.eventRemoteBoard_ActionObjectPlaying(this.m_RemoteBoard_Action, false, false, false);
        }
        this.m_RemoteBoard_Action = p_RemoteBoard_Action;
        if (this.m_RemoteBoard_Action != null) {
            this.m_ItemDescription.setRemoteBoard_ActionID(this.m_RemoteBoard_Action.getID());
            this.m_RemoteBoard_Action.addRemoteBoard_ActionListener(this);
            this.m_ItemDescription.setRemoteBoard_ActionID_Lost("");
            this.eventRemoteBoard_ActionObjectPlaying(p_RemoteBoard_Action, this.m_RemoteBoard_Action.getIsPlaying(), this.m_RemoteBoard_Action.getIsAllPlaying(), this.m_RemoteBoard_Action.getIsPlayingStopped());
            this.calculateImage_Default(this.m_RemoteBoard_Action.getDisplayImage_Default());
            this.m_Text_Default = this.m_RemoteBoard_Action.getDisplayText_Default();
        } else {
            this.m_ItemDescription.setRemoteBoard_ActionID("");
            this.calculateImage_Default(null);
            this.m_Text_Default = "";
        }
        if (this.getDisplayImage_Flag() == 1) {
            boolImageChanged = true;
        }
        this.refreshToolTip();
        this.refreshGUI();
        this.notifyRemoteBoardItemChanged(boolImageChanged);
        return true;
    }

    public RemoteBoard_Action getRemoteBoard_Action() {
        return this.m_RemoteBoard_Action;
    }

    public int getDisplayGridX() {
        return this.m_ItemDescription.getDisplayGridX();
    }

    public int getDisplayGridY() {
        return this.m_ItemDescription.getDisplayGridY();
    }

    public void setDisplayBackground_Transparent(boolean p_BackgroundTransparent) {
        if (this.m_ItemDescription.setBackground_Transparent(p_BackgroundTransparent)) {
            this.refreshGUI();
            this.notifyRemoteBoardItemChanged(false);
        }
    }

    public boolean getDisplayBackground_Transparent() {
        return this.m_ItemDescription.getBackground_Transparent();
    }

    public void setDisplayBackground_Color(Color p_Color) {
        if (this.m_ItemDescription.setBackground_Color(p_Color)) {
            this.refreshGUI();
            this.notifyRemoteBoardItemChanged(false);
        }
    }

    public Color getDisplayBackground_Color() {
        return this.m_ItemDescription.getBackground_Color();
    }

    public void setDisplayImage_Flag(int p_DiaplayImage_Flag) {
        if (this.m_ItemDescription.setImage_Flag(p_DiaplayImage_Flag)) {
            this.refreshGUI();
            this.notifyRemoteBoardItemChanged(true);
        }
    }

    public int getDisplayImage_Flag() {
        return this.m_ItemDescription.getImage_Flag();
    }

    public void setDisplayImage_Default(Image p_DefaultImage) {
        if (this.calculateImage_Default(p_DefaultImage)) {
            this.refreshGUI();
            if (this.getDisplayImage_Flag() == 1) {
                this.notifyRemoteBoardItemChanged(true);
            }
        }
    }

    private boolean calculateImage_Default(Image p_DefaultImage) {
        if (p_DefaultImage == null) {
            if (this.m_Image_Default == null) {
                return false;
            }
            this.m_Image_Default = null;
            this.m_Icon_Image_Default = null;
            return true;
        }
        this.m_Image_Default = ImagesTools.convertToBufferedImageAspectRatio((Image)p_DefaultImage, (Dimension)s_ImageSize);
        BufferedImage o_BufferedImage_Icon = ImagesTools.convertToBufferedImageAspectRatio((Image)p_DefaultImage, (Dimension)s_DisplaySize);
        this.m_Icon_Image_Default = new ImageIcon(o_BufferedImage_Icon);
        return true;
    }

    public BufferedImage getDisplayImage_Default() {
        return this.m_Image_Default;
    }

    public void setDisplayImage_Custom(Image p_Image) {
        if (this.m_ItemDescription.setImage(p_Image)) {
            if (this.m_ItemDescription.getImage() == null) {
                this.m_Icon_Image_Custom = null;
            } else {
                BufferedImage o_BufferedImage_Icon = ImagesTools.convertToBufferedImageAspectRatio((Image)p_Image, (Dimension)s_DisplaySize);
                this.m_Icon_Image_Custom = new ImageIcon(o_BufferedImage_Icon);
            }
            this.refreshGUI();
            if (this.getDisplayImage_Flag() == 2) {
                this.notifyRemoteBoardItemChanged(true);
            }
        }
    }

    public BufferedImage getDisplayImage_Custom() {
        return this.m_ItemDescription.getImage();
    }

    public BufferedImage getDisplayImage_ToShow() {
        switch (this.m_ItemDescription.getImage_Flag()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.m_Image_Default;
            }
            case 2: {
                return this.m_ItemDescription.getImage();
            }
        }
        return null;
    }

    public void setDisplayText_Flag(int p_DiaplayText_Flag) {
        if (this.m_ItemDescription.setText_Flag(p_DiaplayText_Flag)) {
            this.refreshGUI();
            this.notifyRemoteBoardItemChanged(false);
        }
    }

    public int getDisplayText_Flag() {
        return this.m_ItemDescription.getText_Flag();
    }

    public void setDisplayText(String p_Text) {
        if (this.m_ItemDescription.setText(p_Text)) {
            this.refreshGUI();
            if (this.getDisplayText_Flag() == 2) {
                this.notifyRemoteBoardItemChanged(false);
            }
        }
    }

    public String getDisplayText() {
        return this.m_ItemDescription.getText();
    }

    public boolean setDisplayText_Default(String p_DisplayText) {
        if (p_DisplayText == null) {
            p_DisplayText = "";
        }
        if (p_DisplayText.equals(this.m_Text_Default)) {
            return false;
        }
        this.m_Text_Default = p_DisplayText;
        this.refreshGUI();
        if (this.getDisplayText_Flag() == 1) {
            this.notifyRemoteBoardItemChanged(false);
        }
        return true;
    }

    public String getDisplayText_Default() {
        return this.m_Text_Default;
    }

    public void setDisplayText_AnchorFlag(int p_DiaplayText_Anchor_Flag) {
        if (this.m_ItemDescription.setText_AnchorFlag(p_DiaplayText_Anchor_Flag)) {
            this.refreshGUI();
            this.notifyRemoteBoardItemChanged(false);
        }
    }

    public int getDisplayText_AnchorFlag() {
        return this.m_ItemDescription.getText_AnchorFlag();
    }

    public void setDisplayText_Color(Color p_Color) {
        if (this.m_ItemDescription.setText_Color(p_Color)) {
            this.refreshGUI();
            this.notifyRemoteBoardItemChanged(false);
        }
    }

    public Color getDisplayText_Color() {
        return this.m_ItemDescription.getText_Color();
    }

    public void doAction() {
        RemoteBoard_Action o_RemoteBoard_Action = this.m_RemoteBoard_Action;
        if (o_RemoteBoard_Action == null) {
            return;
        }
        o_RemoteBoard_Action.doAction();
    }

    public void refreshToolTip() {
        if (this.m_RemoteBoard_Action == null) {
            this.setToolTip_RightClick(null);
            return;
        }
        this.setToolTip_RightClick(this.m_RemoteBoard_Action.getDisplayToolTip());
    }

    private void setToolTip_RightClick(String p_ToolTip) {
        this.jLabel_Icon.setToolTipText_RightClick(p_ToolTip);
        this.jLabel_Text.setToolTipText_RightClick(p_ToolTip);
    }

    public void setSelected(boolean p_Selected) {
        if (this.m_Selected == p_Selected) {
            return;
        }
        this.m_Selected = p_Selected;
        this.refreshGUI();
    }

    public GridBagConstraints getGridBagConstraints() {
        return this.m_GridBagConstraints;
    }

    public void refreshGUI() {
        JPanel_RemoteBoard o_JPanel_RemoteBoard = this.m_JPanel_RemoteBoard;
        if (o_JPanel_RemoteBoard == null) {
            return;
        }
        GridBagLayout o_GridBagLayout = (GridBagLayout)this.getLayout();
        this.refreshBorder();
        if (this.m_ItemDescription.getBackground_Transparent()) {
            this.setOpaque(false);
        } else {
            this.setOpaque(true);
            this.setBackground(this.m_ItemDescription.getBackground_Color());
        }
        switch (this.m_ItemDescription.getImage_Flag()) {
            case 0: {
                this.m_Icon_ToShow = null;
                break;
            }
            case 1: {
                this.m_Icon_ToShow = this.m_Icon_Image_Default;
                break;
            }
            case 2: {
                this.m_Icon_ToShow = this.m_Icon_Image_Custom;
            }
        }
        this.jLabel_Icon.setIcon((Icon)this.m_Icon_ToShow);
        GridBagConstraints o_GridBagConstraints = o_GridBagLayout.getConstraints((Component)this.jLabel_Text);
        switch (this.m_ItemDescription.getText_AnchorFlag()) {
            case 0: {
                o_GridBagConstraints.anchor = 15;
                break;
            }
            case 1: {
                o_GridBagConstraints.anchor = 10;
                break;
            }
            case 2: {
                o_GridBagConstraints.anchor = 11;
            }
        }
        o_GridBagLayout.setConstraints((Component)this.jLabel_Text, o_GridBagConstraints);
        switch (this.m_ItemDescription.getText_Flag()) {
            case 0: {
                this.jLabel_Text.setText("");
                break;
            }
            case 1: {
                StringBuilder o_StringBuilder = new StringBuilder();
                o_StringBuilder.append("<html>");
                o_StringBuilder.append("<center>");
                o_StringBuilder.append(this.m_Text_Default);
                o_StringBuilder.append("</center>");
                o_StringBuilder.append("</html>");
                this.jLabel_Text.setText(o_StringBuilder.toString());
                break;
            }
            case 2: {
                StringBuilder o_StringBuilder = new StringBuilder();
                o_StringBuilder.append("<html>");
                o_StringBuilder.append("<center>");
                o_StringBuilder.append(this.m_ItemDescription.getText());
                o_StringBuilder.append("</center>");
                o_StringBuilder.append("</html>");
                this.jLabel_Text.setText(o_StringBuilder.toString());
            }
        }
        this.jLabel_Text.setForeground(this.m_ItemDescription.getText_Color());
        this.revalidate();
        this.repaint();
    }

    public void refreshBorder() {
        JPanel_RemoteBoard o_JPanel_RemoteBoard = this.m_JPanel_RemoteBoard;
        if (o_JPanel_RemoteBoard == null) {
            this.setBorder(s_Border_Normal);
        }
        if (this.m_Selected) {
            this.setBorder(s_Border_Selected);
        } else if (o_JPanel_RemoteBoard.getEditMode()) {
            this.setBorder(s_Border_Edit);
        } else if (this.getRemoteBoard_Action() == null) {
            this.setBorder(s_Border_Normal);
        } else if (this.m_IsPlaying) {
            if (!o_JPanel_RemoteBoard.getEditMode()) {
                if (this.m_IsPlayingStopped) {
                    this.setBorder(s_Border_PlayingStopped);
                } else if (this.m_IsPlayingAll) {
                    this.setBorder(s_Border_AllPlaying);
                } else {
                    this.setBorder(s_Border_SomePlaying);
                }
            }
        } else if (!o_JPanel_RemoteBoard.getEditMode()) {
            this.setBorder(s_Border_Normal);
        }
    }

    public String getRemoteBoard_ActionID_Lost() {
        return this.m_ItemDescription.getRemoteBoard_ActionID_Lost();
    }

    @Override
    public void eventRemoteBoard_ActionClosed(RemoteBoard_Action p_RemoteBoard_Action) {
        if (p_RemoteBoard_Action == null) {
            return;
        }
        if (this.m_RemoteBoard_Action == p_RemoteBoard_Action) {
            this.m_ItemDescription.setRemoteBoard_ActionID_Lost(p_RemoteBoard_Action.getID());
            this.setRemoteBoard_Action(null);
        }
    }

    @Override
    public void eventRemoteBoard_ActionObjectChanged(RemoteBoard_Action p_RemoteBoard_Action) {
        if (p_RemoteBoard_Action == null) {
            return;
        }
        this.setDisplayText_Default(p_RemoteBoard_Action.getDisplayText_Default());
        this.refreshToolTip();
    }

    @Override
    public void eventRemoteBoard_ActionObjectPlaying(RemoteBoard_Action p_RemoteBoard_Action, boolean p_IsPlaying, boolean p_IsPlayingAll, boolean p_IsPlayingStopped) {
        if (this.m_IsPlaying == p_IsPlaying && this.m_IsPlayingAll == p_IsPlayingAll && this.m_IsPlayingStopped == p_IsPlayingStopped) {
            return;
        }
        this.m_IsPlaying = p_IsPlaying;
        this.m_IsPlayingAll = p_IsPlayingAll;
        this.m_IsPlayingStopped = p_IsPlayingStopped;
        EventQueueHandler.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JPanel_RemoteBoardItem.this.refreshBorder();
            }
        });
        this.notifyRemoteBoardItemPlayStatus();
    }

    public boolean getIsPlaying() {
        return this.m_IsPlaying;
    }

    public boolean getIsPlayingAll() {
        return this.m_IsPlayingAll;
    }

    public boolean getIsPlayingStopped() {
        return this.m_IsPlayingStopped;
    }

    public static FlavorMap getItemFlavorMap() {
        SystemFlavorMap o_FlavorMap = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
        o_FlavorMap.addUnencodedNativeForFlavor(s_RemoteBoardItem_DataFlavor, "RemoteBoardItem");
        return o_FlavorMap;
    }

    public static class ItemDrop {
        private JPanel_RemoteBoardItem m_JPanel_RemoteBoardItem;
        private ItemDropListener m_ItemDropListener;
        private ItemDropTarget m_ItemDropTarget;

        public ItemDrop(JPanel_RemoteBoardItem p_JPanel_RemoteBoardItem) {
            this.m_JPanel_RemoteBoardItem = p_JPanel_RemoteBoardItem;
            this.m_ItemDropListener = new ItemDropListener();
            this.m_ItemDropTarget = new ItemDropTarget(p_JPanel_RemoteBoardItem, this.m_ItemDropListener);
        }

        public void close() {
            this.m_ItemDropTarget.removeDropTargetListener(this.m_ItemDropListener);
            this.m_ItemDropTarget.close();
            this.m_ItemDropListener.close();
            this.m_JPanel_RemoteBoardItem = null;
        }

        public static class ItemDropListener
        implements DropTargetListener {
            public void close() {
            }

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                if (!dtde.isDataFlavorSupported(s_RemoteBoardItem_DataFlavor)) {
                    dtde.rejectDrag();
                    return;
                }
                ItemDropTarget o_ItemDropTarget = (ItemDropTarget)dtde.getSource();
                JPanel_RemoteBoardItem o_JPanel_RemoteBoardItem_Target = o_ItemDropTarget.getJPanel_RemoteBoardItem();
                if (o_JPanel_RemoteBoardItem_Target == null || !o_JPanel_RemoteBoardItem_Target.isEmpty()) {
                    dtde.rejectDrag();
                    return;
                }
                o_JPanel_RemoteBoardItem_Target.setBorder(new LineBorder(Color.CYAN, 1));
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
                if (!(dte.getSource() instanceof ItemDropTarget)) {
                    return;
                }
                ItemDropTarget o_ItemDropTarget = (ItemDropTarget)dte.getSource();
                JPanel_RemoteBoardItem o_JPanel_RemoteBoardItem_Target = o_ItemDropTarget.getJPanel_RemoteBoardItem();
                if (o_JPanel_RemoteBoardItem_Target == null) {
                    return;
                }
                o_JPanel_RemoteBoardItem_Target.refreshBorder();
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                Object o_TransferData;
                if (!dtde.isDataFlavorSupported(s_RemoteBoardItem_DataFlavor)) {
                    dtde.rejectDrop();
                    return;
                }
                if (!(dtde.getSource() instanceof ItemDropTarget)) {
                    dtde.rejectDrop();
                    return;
                }
                ItemDropTarget o_ItemDropTarget = (ItemDropTarget)dtde.getSource();
                JPanel_RemoteBoardItem o_JPanel_RemoteBoardItem_Target = o_ItemDropTarget.getJPanel_RemoteBoardItem();
                if (o_JPanel_RemoteBoardItem_Target == null || !o_JPanel_RemoteBoardItem_Target.isEmpty()) {
                    dtde.rejectDrop();
                    return;
                }
                try {
                    o_TransferData = dtde.getTransferable().getTransferData(s_RemoteBoardItem_DataFlavor);
                }
                catch (Exception e) {
                    o_TransferData = null;
                }
                if (!(o_TransferData instanceof ItemDescription)) {
                    dtde.rejectDrop();
                    return;
                }
                ItemDescription o_ItemDescription_Source = (ItemDescription)o_TransferData;
                if (o_ItemDescription_Source == null) {
                    dtde.rejectDrop();
                    return;
                }
                o_JPanel_RemoteBoardItem_Target.setItemDescription(o_ItemDescription_Source);
                dtde.acceptDrop(dtde.getDropAction());
                dtde.dropComplete(true);
            }
        }

        public static class ItemDropTarget
        extends DropTarget {
            private JPanel_RemoteBoardItem m_JPanel_RemoteBoardItem;

            public ItemDropTarget(JPanel_RemoteBoardItem p_JPanel_RemoteBoardItem, ItemDropListener p_ItemDropListener) throws HeadlessException {
                super(p_JPanel_RemoteBoardItem, 2, p_ItemDropListener, true, JPanel_RemoteBoardItem.getItemFlavorMap());
                this.m_JPanel_RemoteBoardItem = p_JPanel_RemoteBoardItem;
            }

            public void close() {
                this.m_JPanel_RemoteBoardItem = null;
            }

            public JPanel_RemoteBoardItem getJPanel_RemoteBoardItem() {
                return this.m_JPanel_RemoteBoardItem;
            }
        }
    }

    public static class ItemDrag {
        protected JPanel_RemoteBoardItem m_JPanel_RemoteBoardItem;
        protected ItemDragSource m_ItemDragSource;
        protected ItemDragGestureRecognizer m_ItemDragGestureRecognizer;
        protected ItemDragGestureListener m_ItemDragGestureListener;
        protected ItemDragSourceListener m_ItemDragSourceListener;

        public ItemDrag(JPanel_RemoteBoardItem p_JPanel_RemoteBoardItem) {
            this.m_JPanel_RemoteBoardItem = p_JPanel_RemoteBoardItem;
            this.m_ItemDragSource = new ItemDragSource(p_JPanel_RemoteBoardItem);
            this.m_ItemDragSourceListener = new ItemDragSourceListener();
            this.m_ItemDragGestureListener = new ItemDragGestureListener(this.m_ItemDragSourceListener);
            this.m_ItemDragGestureRecognizer = new ItemDragGestureRecognizer((DragSource)this.m_ItemDragSource, p_JPanel_RemoteBoardItem, this.m_ItemDragGestureListener);
        }

        public void close() {
            this.m_ItemDragGestureRecognizer.removeDragGestureListener(this.m_ItemDragGestureListener);
            this.m_ItemDragGestureRecognizer.close();
            this.m_ItemDragGestureListener.close();
            this.m_ItemDragSourceListener.close();
            this.m_ItemDragSource.close();
            this.m_JPanel_RemoteBoardItem = null;
        }

        public static class ItemDragSourceListener
        implements DragSourceListener {
            public void close() {
            }

            @Override
            public void dragEnter(DragSourceDragEvent dsde) {
            }

            @Override
            public void dragOver(DragSourceDragEvent dsde) {
            }

            @Override
            public void dropActionChanged(DragSourceDragEvent dsde) {
            }

            @Override
            public void dragExit(DragSourceEvent dse) {
            }

            @Override
            public void dragDropEnd(DragSourceDropEvent dsde) {
                DragSourceContext o_DragSourceContext = (DragSourceContext)dsde.getSource();
                ItemDragSource o_ItemDragSource = (ItemDragSource)o_DragSourceContext.getDragSource();
                if (dsde.getDropSuccess()) {
                    JPanel_RemoteBoardItem o_JPanel_RemoteBoardItem = o_ItemDragSource.getJPanel_RemoteBoardItem();
                    if (o_JPanel_RemoteBoardItem == null) {
                        return;
                    }
                    o_JPanel_RemoteBoardItem.clearContent();
                }
            }
        }

        public static class ItemDragGestureListener
        implements DragGestureListener {
            public static Cursor s_DragCursor = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(ItemDragGestureListener.class.getResource("/IconsPackage/MousePointer_DragAndDrop_Object.png")).getImage(), new Point(16, 16), "CursorCopy");
            private DragSourceListener m_DragSourceListener;

            public ItemDragGestureListener(DragSourceListener p_DragSourceListener) {
                this.m_DragSourceListener = p_DragSourceListener;
            }

            public void close() {
                this.m_DragSourceListener = null;
            }

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                if (!(dge.getSource() instanceof ItemDragGestureRecognizer)) {
                    return;
                }
                ItemDragGestureRecognizer o_ItemDragGestureRecognizer = (ItemDragGestureRecognizer)dge.getSource();
                JPanel_RemoteBoardItem o_JPanel_RemoteBoardItem = o_ItemDragGestureRecognizer.getJPanel_RemoteBoardItem();
                if (o_JPanel_RemoteBoardItem == null) {
                    return;
                }
                if (o_JPanel_RemoteBoardItem.isEmpty()) {
                    return;
                }
                JPanel_RemoteBoard o_JPanel_RemoteBoard = o_JPanel_RemoteBoardItem.getJPanel_RemoteBoard();
                if (o_JPanel_RemoteBoard == null || !o_JPanel_RemoteBoard.getEditMode()) {
                    return;
                }
                if (this.m_DragSourceListener == null) {
                    return;
                }
                dge.getDragSource().startDrag(dge, s_DragCursor, o_JPanel_RemoteBoardItem.getItemDescription(), this.m_DragSourceListener, JPanel_RemoteBoardItem.getItemFlavorMap());
            }
        }

        public static class ItemDragGestureRecognizer
        extends DragGestureRecognizer
        implements MouseListener,
        MouseMotionListener {
            public ItemDragGestureRecognizer(DragSource p_DragSource, JPanel_RemoteBoardItem p_JPanel_RemoteBoardItem, ItemDragGestureListener p_ItemDragGestureListener) {
                super(p_DragSource, p_JPanel_RemoteBoardItem, 2, p_ItemDragGestureListener);
            }

            public void close() {
                this.unregisterListeners();
            }

            public JPanel_RemoteBoardItem getJPanel_RemoteBoardItem() {
                return (JPanel_RemoteBoardItem)this.component;
            }

            @Override
            protected void registerListeners() {
                this.component.addMouseMotionListener(this);
            }

            @Override
            protected void unregisterListeners() {
                this.component.removeMouseMotionListener(this);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int intX = e.getX();
                int intY = e.getY();
                boolean boolRecognized = false;
                if (intY < 0 || intY > this.component.getHeight() || intX < 0 || intX > this.component.getWidth()) {
                    boolRecognized = true;
                }
                if (boolRecognized) {
                    this.appendEvent(e);
                    this.fireDragGestureRecognized(2, e.getPoint());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        }

        public static class ItemDragSource
        extends DragSource {
            private JPanel_RemoteBoardItem m_JPanel_RemoteBoardItem;

            public ItemDragSource(JPanel_RemoteBoardItem p_JPanel_RemoteBoardItem) throws HeadlessException {
                this.m_JPanel_RemoteBoardItem = p_JPanel_RemoteBoardItem;
            }

            public void close() {
            }

            public JPanel_RemoteBoardItem getJPanel_RemoteBoardItem() {
                return this.m_JPanel_RemoteBoardItem;
            }
        }
    }

    public static class ItemDescription
    implements Externalizable,
    Transferable {
        public static final int SOFTWAREVERSION = 1;
        private int m_GridX;
        private int m_GridY;
        private String m_RemoteBoard_ActionID;
        private String m_RemoteBoard_ActionID_Lost;
        private boolean m_Background_Transparent;
        private Color m_Background_Color;
        private BufferedImage m_Image;
        private int m_Image_Flag;
        private String m_Text;
        private int m_Text_Flag;
        private int m_Text_Anchor_Flag;
        private Color m_Text_Color;

        public ItemDescription() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_GridX = -1;
            this.m_GridY = -1;
            this.m_RemoteBoard_ActionID = "";
            this.m_RemoteBoard_ActionID_Lost = "";
            this.m_Background_Transparent = true;
            this.m_Background_Color = Color.BLACK;
            this.m_Text = "";
            this.m_Text_Flag = 1;
            this.m_Text_Anchor_Flag = 1;
            this.m_Text_Color = Color.WHITE;
            this.m_Image_Flag = 1;
            this.m_Image = null;
        }

        public void close() {
            if (this.m_Image != null) {
                this.m_Image.flush();
            }
            this.m_Image = null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            int[] imageValues;
            int intImageHeight;
            int intImageWidth;
            out.writeInt(1);
            out.writeInt(this.m_GridX);
            out.writeInt(this.m_GridY);
            out.writeUTF(this.m_RemoteBoard_ActionID);
            out.writeBoolean(this.m_Background_Transparent);
            if (this.m_Background_Color == null) {
                this.m_Background_Color = Color.BLACK;
            }
            out.writeInt(this.m_Background_Color.getRed());
            out.writeInt(this.m_Background_Color.getGreen());
            out.writeInt(this.m_Background_Color.getBlue());
            out.writeUTF(this.m_Text);
            out.writeInt(this.m_Text_Flag);
            out.writeInt(this.m_Text_Anchor_Flag);
            if (this.m_Text_Color == null) {
                this.m_Text_Color = Color.WHITE;
            }
            out.writeInt(this.m_Text_Color.getRed());
            out.writeInt(this.m_Text_Color.getGreen());
            out.writeInt(this.m_Text_Color.getBlue());
            out.writeInt(this.m_Image_Flag);
            if (this.m_Image == null) {
                intImageWidth = 0;
                intImageHeight = 0;
                imageValues = null;
            } else {
                intImageWidth = this.m_Image.getWidth();
                intImageHeight = this.m_Image.getHeight();
                try {
                    imageValues = ImagesTools.getArrayFromImage((Image)this.m_Image, (int)intImageWidth, (int)intImageHeight);
                }
                catch (Exception e) {
                    intImageWidth = 0;
                    intImageHeight = 0;
                    imageValues = null;
                }
            }
            out.writeInt(intImageWidth);
            out.writeInt(intImageHeight);
            if (intImageWidth > 0 && intImageHeight > 0) {
                out.writeObject(imageValues);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            this.m_GridX = in.readInt();
            this.m_GridY = in.readInt();
            this.m_RemoteBoard_ActionID = in.readUTF();
            this.m_Background_Transparent = in.readBoolean();
            int intColor_Red = in.readInt();
            int intColor_Green = in.readInt();
            int intColor_Blue = in.readInt();
            this.m_Background_Color = new Color(intColor_Red, intColor_Green, intColor_Blue);
            this.m_Text = in.readUTF();
            this.m_Text_Flag = in.readInt();
            this.m_Text_Anchor_Flag = in.readInt();
            intColor_Red = in.readInt();
            intColor_Green = in.readInt();
            intColor_Blue = in.readInt();
            this.m_Text_Color = new Color(intColor_Red, intColor_Green, intColor_Blue);
            this.m_Image_Flag = in.readInt();
            int intImageWidth = in.readInt();
            int intImageHeight = in.readInt();
            if (intImageWidth <= 0 || intImageHeight <= 0) {
                this.m_Image = null;
            } else {
                int[] imageValues = (int[])in.readObject();
                try {
                    Image o_Image = ImagesTools.getImageFromArray((int[])imageValues, (int)intImageWidth, (int)intImageHeight);
                    this.m_Image = ImagesTools.convertToBufferedImage((Image)o_Image);
                }
                catch (Exception e) {
                    this.m_Image = null;
                }
            }
            boolean intTest = false;
        }

        public boolean copyContentTo(ItemDescription p_ItemDescription) {
            if (p_ItemDescription == null) {
                return false;
            }
            boolean boolChanged = false;
            if (p_ItemDescription.setRemoteBoard_ActionID(this.m_RemoteBoard_ActionID)) {
                boolChanged = true;
            }
            if (p_ItemDescription.setRemoteBoard_ActionID_Lost(this.m_RemoteBoard_ActionID_Lost)) {
                boolChanged = true;
            }
            if (p_ItemDescription.setBackground_Color(this.m_Background_Color)) {
                boolChanged = true;
            }
            if (p_ItemDescription.setBackground_Transparent(this.m_Background_Transparent)) {
                boolChanged = true;
            }
            if (p_ItemDescription.setImage(this.m_Image)) {
                boolChanged = true;
            }
            if (p_ItemDescription.setImage_Flag(this.m_Image_Flag)) {
                boolChanged = true;
            }
            if (p_ItemDescription.setText(this.m_Text)) {
                boolChanged = true;
            }
            if (p_ItemDescription.setText_Color(this.m_Text_Color)) {
                boolChanged = true;
            }
            if (p_ItemDescription.setText_Flag(this.m_Text_Flag)) {
                boolChanged = true;
            }
            if (p_ItemDescription.setText_AnchorFlag(this.m_Text_Anchor_Flag)) {
                boolChanged = true;
            }
            return boolChanged;
        }

        public boolean setGridX(int p_GridX) {
            if (this.m_GridX == p_GridX) {
                return false;
            }
            this.m_GridX = p_GridX;
            return true;
        }

        public int getDisplayGridX() {
            return this.m_GridX;
        }

        public boolean setGridY(int p_GridY) {
            if (this.m_GridY == p_GridY) {
                return false;
            }
            this.m_GridY = p_GridY;
            return true;
        }

        public int getDisplayGridY() {
            return this.m_GridY;
        }

        public boolean setRemoteBoard_ActionID(String p_RemoteBoard_ActionID) {
            if (p_RemoteBoard_ActionID == null) {
                p_RemoteBoard_ActionID = "";
            }
            if (p_RemoteBoard_ActionID.equals(this.m_RemoteBoard_ActionID)) {
                return false;
            }
            this.m_RemoteBoard_ActionID = p_RemoteBoard_ActionID;
            return true;
        }

        public String getRemoteBoard_ActionID() {
            return this.m_RemoteBoard_ActionID;
        }

        public boolean setRemoteBoard_ActionID_Lost(String p_ID) {
            if (p_ID == null) {
                p_ID = "";
            }
            if (p_ID.equals(this.m_RemoteBoard_ActionID_Lost)) {
                return false;
            }
            this.m_RemoteBoard_ActionID_Lost = p_ID;
            return true;
        }

        public String getRemoteBoard_ActionID_Lost() {
            return this.m_RemoteBoard_ActionID_Lost;
        }

        public boolean setBackground_Transparent(boolean p_BackgroundTransparent) {
            if (this.m_Background_Transparent == p_BackgroundTransparent) {
                return false;
            }
            this.m_Background_Transparent = p_BackgroundTransparent;
            return true;
        }

        public boolean getBackground_Transparent() {
            return this.m_Background_Transparent;
        }

        public boolean setBackground_Color(Color p_Color) {
            if (p_Color == null) {
                p_Color = Color.BLACK;
            }
            if (p_Color.equals(this.m_Background_Color)) {
                return false;
            }
            this.m_Background_Color = p_Color;
            return true;
        }

        public Color getBackground_Color() {
            return this.m_Background_Color;
        }

        public boolean setImage_Flag(int p_DiaplayImage_Flag) {
            if (this.m_Image_Flag == p_DiaplayImage_Flag) {
                return false;
            }
            this.m_Image_Flag = p_DiaplayImage_Flag;
            switch (p_DiaplayImage_Flag) {
                case 0: {
                    this.m_Image_Flag = 0;
                    return true;
                }
                case 1: {
                    this.m_Image_Flag = 1;
                    return true;
                }
                case 2: {
                    this.m_Image_Flag = 2;
                    return true;
                }
            }
            return false;
        }

        public int getImage_Flag() {
            return this.m_Image_Flag;
        }

        public boolean setImage(Image p_Image) {
            return this.calculateImage(p_Image);
        }

        private boolean calculateImage(Image p_Image) {
            if (p_Image == null) {
                if (this.m_Image == null) {
                    return false;
                }
                this.m_Image.flush();
                this.m_Image = null;
                return true;
            }
            if (this.m_Image != null) {
                this.m_Image.flush();
            }
            this.m_Image = ImagesTools.convertToBufferedImageAspectRatio((Image)p_Image, (Dimension)s_ImageSize);
            return this.m_Image != null;
        }

        public BufferedImage getImage() {
            return this.m_Image;
        }

        public boolean setText_Flag(int p_DiaplayText_Flag) {
            if (this.m_Text_Flag == p_DiaplayText_Flag) {
                return false;
            }
            switch (p_DiaplayText_Flag) {
                case 0: {
                    this.m_Text_Flag = 0;
                    return true;
                }
                case 1: {
                    this.m_Text_Flag = 1;
                    return true;
                }
                case 2: {
                    this.m_Text_Flag = 2;
                    return true;
                }
            }
            return false;
        }

        public int getText_Flag() {
            return this.m_Text_Flag;
        }

        public boolean setText(String p_Text) {
            if (p_Text == null) {
                p_Text = "";
            }
            if (p_Text.equals(this.m_Text)) {
                return false;
            }
            this.m_Text = p_Text;
            return true;
        }

        public String getText() {
            return this.m_Text;
        }

        public boolean setText_AnchorFlag(int p_DiaplayText_Anchor_Flag) {
            if (this.m_Text_Anchor_Flag == p_DiaplayText_Anchor_Flag) {
                return false;
            }
            switch (p_DiaplayText_Anchor_Flag) {
                case 1: {
                    this.m_Text_Anchor_Flag = 1;
                    return true;
                }
                case 0: {
                    this.m_Text_Anchor_Flag = 0;
                    return true;
                }
                case 2: {
                    this.m_Text_Anchor_Flag = 2;
                    return true;
                }
            }
            return false;
        }

        public int getText_AnchorFlag() {
            return this.m_Text_Anchor_Flag;
        }

        public boolean setText_Color(Color p_Color) {
            if (p_Color == null) {
                p_Color = Color.BLACK;
            }
            if (p_Color.equals(this.m_Text_Color)) {
                return false;
            }
            this.m_Text_Color = p_Color;
            return true;
        }

        public Color getText_Color() {
            return this.m_Text_Color;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return s_DataFlavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == s_RemoteBoardItem_DataFlavor;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this;
        }
    }
}

