/*
 * Decompiled with CFR 0.152.
 */
package LiveShowProjectPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.PlayControlPanel;
import LiveShowPlayPackage.PlayControlTimePanel;
import LiveShowPlayPackage.PlayRemoteActions;
import LiveShowVirtualPackage.LiveShowTimerDisplay;
import MainPackage.LiveShowProjectDesktop;
import ToolsGraphics.JLabel_ResizeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class LiveShowInternalFrame_Play
extends JInternalFrame
implements InternalFrameListener {
    private JPanel m_PlayPanel;
    private PlayControlPanel m_PlayControlPanel;
    private LiveShowTimerDisplay m_LiveShowTimerDisplay;
    private JLabel_ResizeFrame m_JLabel_ResizeFrame;
    private ArrayList<PlayControlTimePanel> m_PlayControlTimePanels;
    private Play.PlaySynchronisizer m_PlaySynchronisizer;
    public static LiveShowInternalFrame_Play s_SelfReference;

    public LiveShowInternalFrame_Play(Play.PlaySynchronisizer p_PlaySynchronisizer) {
        this.initMembers();
        this.m_PlaySynchronisizer = p_PlaySynchronisizer;
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
        this.m_PlayControlPanel.createSPITRemote(this.getTitle());
        s_SelfReference = this;
    }

    private void initMembers() {
        this.m_PlayControlTimePanels = new ArrayList();
    }

    private void initComponents() {
        this.setClosable(true);
        this.setDefaultCloseOperation(1);
        this.setIconifiable(true);
        this.setResizable(true);
        this.setTitle("Playcontrol");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/PlayStart32.png")));
        this.setMinimumSize(new Dimension(350, 400));
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(400, 500));
        this.getContentPane().setLayout(new GridBagLayout());
    }

    private void initComponentsFurther() {
        this.getContentPane().setBackground(Color.BLACK);
        this.m_PlayPanel = new JPanel();
        this.m_PlayPanel.setBorder(null);
        this.m_PlayPanel.setOpaque(false);
        this.m_PlayPanel.setLayout(new GridBagLayout());
        GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
        o_GridBagConstraints.gridx = 0;
        o_GridBagConstraints.gridy = 0;
        o_GridBagConstraints.gridwidth = 1;
        o_GridBagConstraints.gridheight = 1;
        o_GridBagConstraints.weightx = 1.0;
        o_GridBagConstraints.weighty = 1.0;
        o_GridBagConstraints.fill = 1;
        this.m_PlayPanel.setMinimumSize(new Dimension(300, 400));
        this.getContentPane().add((Component)this.m_PlayPanel, o_GridBagConstraints);
        this.m_LiveShowTimerDisplay = new LiveShowTimerDisplay();
        o_GridBagConstraints = new GridBagConstraints();
        o_GridBagConstraints.gridx = 0;
        o_GridBagConstraints.gridy = 3;
        o_GridBagConstraints.fill = 2;
        o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
        o_GridBagConstraints.anchor = 11;
        this.m_LiveShowTimerDisplay.setVisible(true);
        this.m_PlayPanel.add((Component)this.m_LiveShowTimerDisplay, o_GridBagConstraints);
        this.m_PlayControlPanel = new PlayControlPanel(this.m_PlaySynchronisizer, 1, true, true, false, true, true, true, false, false, true, true);
        this.m_PlayControlPanel.setMinimumSize(new Dimension(200, 120));
        o_GridBagConstraints = new GridBagConstraints();
        o_GridBagConstraints.gridx = 0;
        o_GridBagConstraints.gridy = 4;
        o_GridBagConstraints.fill = 1;
        o_GridBagConstraints.weightx = 1.0;
        o_GridBagConstraints.weighty = 1.0;
        o_GridBagConstraints.anchor = 11;
        this.m_PlayControlPanel.setVisible(true);
        this.m_PlayPanel.add((Component)this.m_PlayControlPanel, o_GridBagConstraints);
        PlayRemoteActions.RemoteActionSettingsPanel o_RemoteActionSettingsPanel = new PlayRemoteActions.RemoteActionSettingsPanel();
        o_GridBagConstraints = new GridBagConstraints();
        o_GridBagConstraints.gridx = 0;
        o_GridBagConstraints.gridy = 6;
        o_GridBagConstraints.weightx = 1.0;
        o_GridBagConstraints.weighty = 0.0;
        o_GridBagConstraints.fill = 2;
        o_GridBagConstraints.anchor = 17;
        o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
        o_RemoteActionSettingsPanel.setVisible(true);
        this.m_PlayPanel.add((Component)o_RemoteActionSettingsPanel, o_GridBagConstraints);
        PlayRemoteActions.RemoteGlobalStartPanel o_RemoteGlobalStartPanel = new PlayRemoteActions.RemoteGlobalStartPanel();
        o_GridBagConstraints = new GridBagConstraints();
        o_GridBagConstraints.gridx = 0;
        o_GridBagConstraints.gridy = 7;
        o_GridBagConstraints.weightx = 1.0;
        o_GridBagConstraints.weighty = 0.0;
        o_GridBagConstraints.fill = 2;
        o_GridBagConstraints.anchor = 17;
        o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
        o_RemoteGlobalStartPanel.setVisible(true);
        this.m_PlayPanel.add((Component)o_RemoteGlobalStartPanel, o_GridBagConstraints);
        this.m_JLabel_ResizeFrame = new JLabel_ResizeFrame();
        o_GridBagConstraints = new GridBagConstraints();
        o_GridBagConstraints.gridx = 0;
        o_GridBagConstraints.gridy = 7;
        o_GridBagConstraints.weightx = 0.0;
        o_GridBagConstraints.weighty = 0.0;
        o_GridBagConstraints.anchor = 14;
        this.m_JLabel_ResizeFrame.setVisible(true);
        this.m_PlayPanel.add((Component)this.m_JLabel_ResizeFrame, o_GridBagConstraints);
        this.m_JLabel_ResizeFrame.setContainer((Container)this);
        this.addInternalFrameListener(this);
    }

    public void close() {
        LiveLanguage.removeLanguageListener((Object)this);
        if (this.m_PlayControlPanel != null) {
            this.m_PlayControlPanel.close();
        }
        LiveLanguage.removeLanguageListener((Object)this);
    }

    public PlayControlPanel getPlayControlPanel() {
        return this.m_PlayControlPanel;
    }

    public Play.PlaySynchronisizer getPlaySynchronisizer() {
        PlayControlPanel o_PlayControlPanel = this.m_PlayControlPanel;
        if (o_PlayControlPanel == null) {
            return null;
        }
        return o_PlayControlPanel.getPlaySynchronisizer();
    }

    public void refresh() {
        GridBagConstraints o_GridBagConstraints;
        GridBagLayout o_GridBagLayout = (GridBagLayout)this.m_PlayPanel.getLayout();
        int intTimePanel = 0;
        while (intTimePanel < this.m_PlayControlTimePanels.size()) {
            PlayControlTimePanel o_PlayControlTimePanel = this.m_PlayControlTimePanels.get(intTimePanel);
            o_GridBagConstraints = o_GridBagLayout.getConstraints((Component)o_PlayControlTimePanel);
            o_GridBagConstraints.gridy = intTimePanel++;
            o_GridBagLayout.setConstraints((Component)o_PlayControlTimePanel, o_GridBagConstraints);
        }
        o_GridBagConstraints = o_GridBagLayout.getConstraints((Component)this.m_LiveShowTimerDisplay);
        o_GridBagConstraints.gridy = this.m_PlayControlTimePanels.size();
        o_GridBagLayout.setConstraints((Component)this.m_LiveShowTimerDisplay, o_GridBagConstraints);
        o_GridBagConstraints = o_GridBagLayout.getConstraints((Component)this.m_PlayControlPanel);
        o_GridBagConstraints.gridy = this.m_PlayControlTimePanels.size() + 1;
        o_GridBagLayout.setConstraints((Component)this.m_PlayControlPanel, o_GridBagConstraints);
        this.m_PlayPanel.revalidate();
    }

    public void addPlay(Play p_Play) {
        if (p_Play == null) {
            return;
        }
        this.m_PlayControlPanel.addPlay(p_Play);
        PlayControlTimePanel o_PlayControlTimePanel = new PlayControlTimePanel(p_Play, true, true);
        o_PlayControlTimePanel.setFontResizable(false);
        o_PlayControlTimePanel.setBorder(null);
        this.m_PlayControlTimePanels.add(o_PlayControlTimePanel);
        GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
        o_GridBagConstraints.gridy = this.m_PlayControlTimePanels.size() - 1;
        o_GridBagConstraints.gridx = 0;
        o_GridBagConstraints.fill = 2;
        o_GridBagConstraints.weightx = 1.0;
        o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
        o_GridBagConstraints.anchor = 11;
        this.m_PlayPanel.add((Component)o_PlayControlTimePanel, o_GridBagConstraints);
        o_PlayControlTimePanel.setVisible(true);
        this.refresh();
    }

    public PlayControlTimePanel getPlayControlTimePanel(Play p_Play) {
        for (int intTimePanel = 0; intTimePanel < this.m_PlayControlTimePanels.size(); ++intTimePanel) {
            PlayControlTimePanel o_PlayControlTimePanel = this.m_PlayControlTimePanels.get(intTimePanel);
            if (o_PlayControlTimePanel.getPlay() != p_Play) continue;
            return o_PlayControlTimePanel;
        }
        return null;
    }

    public void removePlay(Play p_Play) {
        if (p_Play == null) {
            return;
        }
        if (!this.m_PlayControlPanel.containsPlay(p_Play)) {
            return;
        }
        this.m_PlayControlPanel.removePlay(p_Play);
        PlayControlTimePanel o_PlayControlTimePanel = this.getPlayControlTimePanel(p_Play);
        if (o_PlayControlTimePanel != null) {
            o_PlayControlTimePanel.setVisible(false);
            this.m_PlayPanel.remove((Component)o_PlayControlTimePanel);
            this.m_PlayControlTimePanels.remove(o_PlayControlTimePanel);
            o_PlayControlTimePanel.close();
        }
        this.refresh();
    }

    public static void automaticSetupMouseRemote() {
        LiveShowProjectDesktop.toFrontInternalFrame(s_SelfReference);
        LiveShowInternalFrame_Play.s_SelfReference.m_PlayControlPanel.moveMouseToMouseControl();
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }
}

