/*
 * Decompiled with CFR 0.152.
 */
package ToolsGraphics;

import FileToolPackage.FileSelection;
import ToolsGraphics.GraphicsTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public final class ImagesTools {
    public static Color COLOR_TRANSPARENT = new Color(0, 0, 0, 0);
    public static JPanel s_JPanel_Dummy = new JPanel();
    public static myImageObserver s_ImageObserver = new myImageObserver();
    public static File s_LastOpenFile = null;
    boolean m_Success;
    public static FileNameExtensionFilter s_FileNameExtensionFilter_Image = FileSelection.createFileNameExtensionFilter("Images", ".gif", ".jpeg", ".jpg", ".png");

    public static BufferedImage loadImageFileDialog(String p_Title, Component p_Parent) {
        File o_File = FileSelection.showOpen(p_Parent, p_Title, s_LastOpenFile, s_FileNameExtensionFilter_Image, true, true, s_FileNameExtensionFilter_Image, null, null, null);
        if (o_File == null) {
            return null;
        }
        s_LastOpenFile = o_File;
        return ImagesTools.loadImage(o_File);
    }

    public static Dimension getImageSize_WithoutLoad(File p_ImageFile) {
        Dimension o_Dimension = new Dimension(0, 0);
        ImageReader reader = null;
        ImageInputStream in = null;
        try {
            in = ImageIO.createImageInputStream(p_ImageFile);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
            if (readers.hasNext()) {
                reader = readers.next();
                try {
                    reader.setInput(in);
                    o_Dimension.setSize(reader.getWidth(0), reader.getHeight(0));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            o_Dimension.setSize(0, 0);
        }
        if (reader != null) {
            reader.dispose();
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return o_Dimension;
    }

    public static BufferedImage loadImage(File p_File) {
        BufferedImage o_BufferedImage;
        if (p_File == null) {
            return null;
        }
        if (!p_File.exists()) {
            return null;
        }
        try {
            o_BufferedImage = ImageIO.read(p_File);
        }
        catch (IOException e) {
            o_BufferedImage = null;
        }
        return o_BufferedImage;
    }

    public static int[] getArrayFromImage(Image img, int width, int height) throws InterruptedException {
        if (img == null) {
            return null;
        }
        int[] pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, width, height, pixels, 0, width);
        pg.grabPixels();
        return pixels;
    }

    public static Image getImageFromArray(int[] pixels, int width, int height) {
        if (pixels == null) {
            return null;
        }
        MemoryImageSource mis = new MemoryImageSource(width, height, pixels, 0, width);
        Toolkit tk = Toolkit.getDefaultToolkit();
        return tk.createImage(mis);
    }

    public static void writeImage(ObjectOutput p_ObjectOutput, Image p_Image) throws IOException {
        int[] arrayImage = null;
        int intWidth = 0;
        int intHeight = 0;
        if (p_Image != null) {
            intWidth = p_Image.getWidth(s_ImageObserver);
            intHeight = p_Image.getHeight(s_ImageObserver);
            try {
                arrayImage = ImagesTools.getArrayFromImage(p_Image, intWidth, intHeight);
            }
            catch (InterruptedException error) {
                throw new IOException(error.getMessage(), error.getCause());
            }
        }
        p_ObjectOutput.writeInt(intWidth);
        p_ObjectOutput.writeInt(intHeight);
        p_ObjectOutput.writeObject(arrayImage);
    }

    public static BufferedImage readBufferedImage(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
        Image o_Image;
        try {
            o_Image = ImagesTools.readImage(p_ObjectInput);
        }
        catch (Exception e) {
            return null;
        }
        BufferedImage o_BufferedImage = ImagesTools.convertToBufferedImage(o_Image);
        return o_BufferedImage;
    }

    public static Image readImage(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
        int intWidth = p_ObjectInput.readInt();
        int intHeight = p_ObjectInput.readInt();
        int[] arrayImage = (int[])p_ObjectInput.readObject();
        Image o_Image = ImagesTools.getImageFromArray(arrayImage, intWidth, intHeight);
        return o_Image;
    }

    public static long getDiskSpaceEstimated(int p_Width, int p_Height) {
        long longBytesCount = 0L;
        longBytesCount += 4L;
        longBytesCount += 4L;
        return longBytesCount += (long)(4 * p_Width * p_Height);
    }

    public static long getDiskSpaceEstimated(Image p_Image) {
        long longBytesCount = 0L;
        int intWidth = 0;
        int intHeight = 0;
        if (p_Image != null) {
            intWidth = p_Image.getWidth(s_ImageObserver);
            intHeight = p_Image.getHeight(s_ImageObserver);
        }
        longBytesCount += 4L;
        longBytesCount += 4L;
        return longBytesCount += (long)(4 * intWidth * intHeight);
    }

    public static void writeColor(ObjectOutput p_ObjectOutput, Color p_Color) throws IOException {
        if (p_Color == null) {
            p_ObjectOutput.writeUTF("null");
        } else {
            p_ObjectOutput.writeUTF("");
            p_ObjectOutput.writeInt(p_Color.getRed());
            p_ObjectOutput.writeInt(p_Color.getGreen());
            p_ObjectOutput.writeInt(p_Color.getBlue());
            p_ObjectOutput.writeInt(p_Color.getAlpha());
        }
    }

    public static Color readColor(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
        String stringNull = p_ObjectInput.readUTF();
        if ("null".equals(stringNull)) {
            return null;
        }
        int intRed = p_ObjectInput.readInt();
        int intGreen = p_ObjectInput.readInt();
        int intBlue = p_ObjectInput.readInt();
        int intAlpha = p_ObjectInput.readInt();
        Color o_Color = GraphicsTools.newColorSave(intRed, intGreen, intBlue, intAlpha);
        return o_Color;
    }

    public static long getDiskSpaceEstimated(Color p_Color) {
        long longBytesCount = 0L;
        if (p_Color == null) {
            longBytesCount += (long)("null".length() * 2);
        } else {
            longBytesCount += 2L;
            longBytesCount += 4L;
            longBytesCount += 4L;
            longBytesCount += 4L;
            longBytesCount += 4L;
        }
        return longBytesCount;
    }

    public static void writeInsets(ObjectOutput p_ObjectOutput, Insets p_Insets) throws IOException {
        if (p_Insets == null) {
            p_ObjectOutput.writeUTF("null");
        } else {
            p_ObjectOutput.writeUTF("");
            p_ObjectOutput.writeInt(p_Insets.top);
            p_ObjectOutput.writeInt(p_Insets.left);
            p_ObjectOutput.writeInt(p_Insets.bottom);
            p_ObjectOutput.writeInt(p_Insets.right);
        }
    }

    public static Insets readInsets(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
        String stringNull = p_ObjectInput.readUTF();
        if ("null".equals(stringNull)) {
            return null;
        }
        int intTop = p_ObjectInput.readInt();
        int intLeft = p_ObjectInput.readInt();
        int intBottom = p_ObjectInput.readInt();
        int intRight = p_ObjectInput.readInt();
        Insets o_Insets = new Insets(intTop, intLeft, intBottom, intRight);
        return o_Insets;
    }

    public static BufferedImage convertToBufferedImage(Image p_Image) {
        return ImagesTools.convertToBufferedImage(p_Image, null);
    }

    public static BufferedImage convertToBufferedImageAspectRatio(Image p_Image, Dimension p_Size) {
        Dimension o_DimensionRatio;
        if (p_Image == null) {
            return null;
        }
        if (p_Size == null) {
            p_Size = new Dimension(p_Image.getWidth(s_ImageObserver), p_Image.getHeight(s_ImageObserver));
        }
        int intImageWidth = p_Image.getWidth(s_ImageObserver);
        int intImageHeight = p_Image.getHeight(s_ImageObserver);
        if (intImageHeight == 0 || intImageWidth == 0) {
            return null;
        }
        if (intImageHeight > intImageWidth) {
            double doubleRatio = (double)intImageWidth / (double)intImageHeight;
            o_DimensionRatio = new Dimension((int)((double)p_Size.height * doubleRatio + 0.5), p_Size.height);
        } else if (intImageWidth > intImageHeight) {
            double doubleRatio = (double)intImageHeight / (double)intImageWidth;
            o_DimensionRatio = new Dimension(p_Size.width, (int)((double)p_Size.width * doubleRatio + 0.5));
        } else {
            o_DimensionRatio = p_Size;
        }
        return ImagesTools.convertToBufferedImage(p_Image, o_DimensionRatio);
    }

    public static BufferedImage convertToBufferedImage(Image p_Image, Dimension p_Size) {
        if (p_Image == null) {
            return null;
        }
        if (p_Image instanceof BufferedImage && (p_Size == null || p_Image.getWidth(s_ImageObserver) == p_Size.width && p_Image.getHeight(s_ImageObserver) == p_Size.height)) {
            return (BufferedImage)p_Image;
        }
        p_Image = new ImageIcon(p_Image).getImage();
        boolean hasAlpha = ImagesTools.hasAlpha(p_Image);
        BufferedImage bufferedImage = null;
        if (bufferedImage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bufferedImage = p_Size == null ? new BufferedImage(p_Image.getWidth(s_ImageObserver), p_Image.getHeight(s_ImageObserver), type) : new BufferedImage(p_Size.width, p_Size.height, type);
        }
        Graphics2D g = bufferedImage.createGraphics();
        if (p_Size == null) {
            g.drawImage(p_Image, 0, 0, null);
        } else {
            g.drawImage(p_Image, 0, 0, p_Size.width, p_Size.height, 0, 0, p_Image.getWidth(s_ImageObserver), p_Image.getHeight(s_ImageObserver), null);
        }
        g.dispose();
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage convertToBufferedImage(Icon p_Icon) {
        if (p_Icon == null) {
            return null;
        }
        BufferedImage bufferedImage = null;
        int type = 2;
        bufferedImage = new BufferedImage(p_Icon.getIconWidth(), p_Icon.getIconHeight(), type);
        Graphics2D g = bufferedImage.createGraphics();
        try {
            p_Icon.paintIcon(s_JPanel_Dummy, g, 0, 0);
        }
        catch (Exception e) {
            if (bufferedImage != null) {
                bufferedImage.flush();
                bufferedImage = null;
            }
        }
        finally {
            g.dispose();
        }
        return bufferedImage;
    }

    public static BufferedImage createBufferedImage(Color p_Color, Dimension p_Size) {
        BufferedImage bufferedImage = null;
        Color o_Color = p_Color == null ? Color.WHITE : p_Color;
        int type = 1;
        bufferedImage = new BufferedImage(p_Size.width, p_Size.height, type);
        Graphics2D g = bufferedImage.createGraphics();
        g.setColor(o_Color);
        g.fillRect(0, 0, p_Size.width, p_Size.height);
        g.dispose();
        return bufferedImage;
    }

    public static BufferedImage createBufferedImage(String p_String, Dimension p_Size) {
        BufferedImage bufferedImage = null;
        String stringText = p_String == null ? "" : p_String;
        int type = 1;
        bufferedImage = new BufferedImage(p_Size.width, p_Size.height, type);
        Graphics2D g = bufferedImage.createGraphics();
        Font o_Font = g.getFont();
        FontMetrics o_FontMetrics = g.getFontMetrics();
        Rectangle2D rectFont = o_FontMetrics.getStringBounds(stringText, g);
        double floatSizefactor = rectFont.getWidth() <= 0.0 || rectFont.getHeight() <= 0.0 ? 1.0 : Math.min((double)p_Size.width / rectFont.getWidth(), (double)p_Size.height / rectFont.getHeight());
        o_Font = o_Font.deriveFont((float)((double)o_Font.getSize() * floatSizefactor));
        g.setFont(o_Font);
        o_FontMetrics = g.getFontMetrics();
        rectFont = o_FontMetrics.getStringBounds(stringText, g);
        int intX = (int)((double)(p_Size.width / 2) - rectFont.getWidth() / 2.0 + 0.5);
        int intY = (int)((double)(p_Size.height / 2) - rectFont.getHeight() / 2.0 + (double)o_FontMetrics.getAscent() + 0.5);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, p_Size.width, p_Size.height);
        g.setColor(Color.BLACK);
        ((Graphics)g).drawString(stringText, intX, intY);
        g.dispose();
        return bufferedImage;
    }

    public static boolean hasAlpha(Image p_Image) {
        if (p_Image == null) {
            return false;
        }
        if (p_Image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)p_Image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(p_Image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean scaleImageSynchron(Image p_SrcImage, int p_SrcX, int p_SrcY, int p_SrcWidth, int p_SrcHeight, Image p_DestImage, int p_DestX, int p_DestY, int p_DestWidth, int p_DestHeight) {
        boolean bl;
        myImageObserver myImageObserver2;
        if (p_SrcImage == null || p_DestImage == null) {
            return false;
        }
        myImageObserver o_ImageObserverObject = s_ImageObserver;
        boolean boolTest = false;
        Image o_DestImage = p_SrcImage == p_DestImage ? new BufferedImage(p_DestX + p_DestWidth, p_DestY + p_DestHeight, 2) : p_DestImage;
        Graphics o_Graphics = o_DestImage.getGraphics();
        boolTest = o_Graphics.drawImage(p_SrcImage, p_DestX, p_DestY, p_DestX + p_DestWidth, p_DestY + p_DestHeight, p_SrcX, p_SrcY, p_SrcX + p_SrcWidth, p_SrcY + p_SrcHeight, o_ImageObserverObject);
        if (!boolTest) {
            myImageObserver2 = o_ImageObserverObject;
            synchronized (myImageObserver2) {
                try {
                    o_ImageObserverObject.wait();
                }
                catch (InterruptedException e) {
                    bl = false;
                }
            }
        }
        o_Graphics.dispose();
        if (p_SrcImage == p_DestImage) {
            o_Graphics = p_DestImage.getGraphics();
            o_Graphics.setColor(COLOR_TRANSPARENT);
            o_Graphics.fillRect(0, 0, p_DestX + p_DestWidth, p_DestY + p_DestHeight);
            boolTest = o_Graphics.drawImage(o_DestImage, 0, 0, s_ImageObserver);
            if (!boolTest) {
                myImageObserver2 = o_ImageObserverObject;
                synchronized (myImageObserver2) {
                    try {
                        o_ImageObserverObject.wait();
                    }
                    catch (InterruptedException e) {
                        bl = false;
                    }
                }
            }
            o_Graphics.dispose();
            o_DestImage.flush();
            o_DestImage = null;
        }
        return p_DestImage != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean drawImageSynchron(Graphics2D p_Graphics, Image p_SrcImage, int p_SrcX, int p_SrcY, int p_SrcWidth, int p_SrcHeight, int p_DestX, int p_DestY, int p_DestWidth, int p_DestHeight) {
        if (p_SrcImage == null) {
            return false;
        }
        myImageObserver o_ImageObserverObject = s_ImageObserver;
        boolean boolTest = false;
        boolTest = p_Graphics.drawImage(p_SrcImage, p_DestX, p_DestY, p_DestX + p_DestWidth, p_DestY + p_DestHeight, p_SrcX, p_SrcY, p_SrcX + p_SrcWidth, p_SrcY + p_SrcHeight, o_ImageObserverObject);
        if (!boolTest) {
            myImageObserver myImageObserver2 = o_ImageObserverObject;
            synchronized (myImageObserver2) {
                try {
                    o_ImageObserverObject.wait();
                }
                catch (InterruptedException e) {
                    boolean bl = false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean clipImageSynchron(Image p_SrcImage, int p_SrcX, int p_SrcY, int p_SrcWidth, int p_SrcHeight, Image p_DestImage, int p_DestX, int p_DestY, int p_DestWidth, int p_DestHeight) {
        Graphics o_Graphics;
        if (p_SrcImage == null || p_DestImage == null) {
            return false;
        }
        myImageObserver o_ImageObserverObject = s_ImageObserver;
        boolean boolTest = false;
        if (p_SrcWidth != p_DestWidth) {
            p_DestX = (p_DestWidth - p_SrcWidth) / 2;
        }
        if (p_SrcHeight != p_DestHeight) {
            p_DestY = (p_DestHeight - p_SrcHeight) / 2;
        }
        if (!(boolTest = (o_Graphics = p_DestImage.getGraphics()).drawImage(p_SrcImage, p_DestX, p_DestY, p_DestX + p_SrcWidth, p_DestY + p_SrcHeight, p_SrcX, p_SrcY, p_SrcX + p_SrcWidth, p_SrcY + p_SrcHeight, o_ImageObserverObject))) {
            myImageObserver myImageObserver2 = o_ImageObserverObject;
            synchronized (myImageObserver2) {
                try {
                    o_ImageObserverObject.wait();
                }
                catch (InterruptedException e) {
                    boolean bl = false;
                }
            }
        }
        o_Graphics.dispose();
        return p_DestImage != null;
    }

    public static BufferedImage resizeImage(Image p_Image, int p_Width, int p_Height) {
        int intNewWidth;
        int intNewHeight;
        if (p_Image == null) {
            return null;
        }
        if (p_Width <= 0) {
            p_Width = 1;
        }
        if (p_Height <= 0) {
            p_Height = 1;
        }
        int intImageWidth = p_Image.getWidth(null);
        int intImageHeight = p_Image.getHeight(null);
        if (intImageHeight <= 0 || intImageWidth <= 0) {
            p_Image.flush();
            return new BufferedImage(0, 0, 3);
        }
        double doubleHeightFactor = (double)p_Height / (double)intImageHeight;
        double doubleWidthFactor = (double)p_Width / (double)intImageWidth;
        if (doubleHeightFactor < doubleWidthFactor) {
            intNewHeight = (int)((double)intImageHeight * doubleHeightFactor);
            intNewWidth = (int)((double)intImageWidth * doubleHeightFactor);
        } else {
            intNewHeight = (int)((double)intImageHeight * doubleWidthFactor);
            intNewWidth = (int)((double)intImageWidth * doubleWidthFactor);
        }
        BufferedImage o_NewBufferedImage = new BufferedImage(intNewWidth, intNewHeight, 3);
        Graphics2D g2d = o_NewBufferedImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.drawImage(p_Image, 0, 0, intNewWidth, intNewHeight, 0, 0, intImageWidth, intImageHeight, null);
        p_Image.flush();
        p_Image = null;
        return o_NewBufferedImage;
    }

    public static Icon clipIcon(Icon p_Icon, BufferedImage p_Image, int p_Width, int p_Height) {
        if (p_Image == null) {
            return null;
        }
        if (p_Width <= 0) {
            p_Width = 1;
        }
        if (p_Height <= 0) {
            p_Height = 1;
        }
        BufferedImage o_NewBufferedImage = new BufferedImage(p_Width, p_Height, 3);
        BufferedImage o_OldBufferedImage = p_Image;
        ImagesTools.clipImageSynchron(o_OldBufferedImage, 0, 0, o_OldBufferedImage.getWidth(), o_OldBufferedImage.getHeight(), o_NewBufferedImage, 0, 0, p_Width, p_Height);
        p_Icon = new ImageIcon(o_NewBufferedImage);
        return p_Icon;
    }

    public static BufferedImage rotateImage90_right(BufferedImage p_BufferedImage) {
        if (p_BufferedImage == null) {
            return null;
        }
        int width = p_BufferedImage.getWidth();
        int height = p_BufferedImage.getHeight();
        BufferedImage biFlip = new BufferedImage(height, width, 3);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                biFlip.setRGB(height - 1 - j, width - 1 - i, p_BufferedImage.getRGB(i, j));
            }
        }
        return biFlip;
    }

    public static BufferedImage rotateImage90_left(BufferedImage bi) {
        if (bi == null) {
            return null;
        }
        int width = bi.getWidth();
        int height = bi.getHeight();
        BufferedImage biFlip = new BufferedImage(height, width, 3);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                biFlip.setRGB(j, i, bi.getRGB(i, j));
            }
        }
        return biFlip;
    }

    public static BufferedImage rotateImage180(BufferedImage bi) {
        if (bi == null) {
            return null;
        }
        int width = bi.getWidth();
        int height = bi.getHeight();
        BufferedImage biFlip = new BufferedImage(width, height, 3);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                biFlip.setRGB(width - 1 - i, height - 1 - j, bi.getRGB(i, j));
            }
        }
        return biFlip;
    }

    public static Image RotateImage(Image inputImage, float p_Degree) {
        if (inputImage == null) {
            return null;
        }
        if (p_Degree == 0.0f) {
            return inputImage;
        }
        if (Math.abs(p_Degree) > 360.0f) {
            int int360 = (int)(p_Degree / 360.0f);
            p_Degree -= (float)(int360 * 360);
        }
        BufferedImage sourceBI = new BufferedImage(inputImage.getWidth(s_ImageObserver), inputImage.getHeight(s_ImageObserver), 2);
        Graphics2D g = (Graphics2D)sourceBI.getGraphics();
        g.drawImage(inputImage, 0, 0, null);
        AffineTransform at = new AffineTransform();
        at.scale(2.0, 2.0);
        at.rotate((double)p_Degree / 360.0 * (Math.PI * 2), (double)sourceBI.getWidth() / 2.0, (double)sourceBI.getHeight() / 2.0);
        at.scale(0.5, 0.5);
        AffineTransform translationTransform = ImagesTools.findTranslation(at, sourceBI);
        at.preConcatenate(translationTransform);
        AffineTransformOp bio = new AffineTransformOp(at, 2);
        BufferedImage destinationBI = bio.filter(sourceBI, null);
        g.dispose();
        return destinationBI;
    }

    private static AffineTransform findTranslation(AffineTransform at, Image bi) {
        Point2D.Double p2din = new Point2D.Double(0.0, 0.0);
        Point2D p2dout = at.transform(p2din, null);
        double ytrans = p2dout.getY();
        p2din = new Point2D.Double(0.0, bi.getHeight(null));
        p2dout = at.transform(p2din, null);
        double xtrans = p2dout.getX();
        AffineTransform tat = new AffineTransform();
        tat.translate(-xtrans, -ytrans);
        return tat;
    }

    public static BufferedImage replaceColor(BufferedImage p_BufferedImage, Color p_ColorOrigin, Color p_ColorNew, int p_TolerancePercent) {
        if (p_BufferedImage == null) {
            return null;
        }
        if (p_ColorNew == null || p_ColorOrigin == null) {
            return p_BufferedImage;
        }
        if (p_ColorOrigin.equals(p_ColorNew)) {
            return p_BufferedImage;
        }
        int intTolerance = 255 * p_TolerancePercent / 100;
        for (int intX = 0; intX < p_BufferedImage.getWidth(); ++intX) {
            for (int intY = 0; intY < p_BufferedImage.getHeight(); ++intY) {
                int intColor = p_BufferedImage.getRGB(intX, intY);
                Color o_Color = new Color(intColor);
                int intDiff = o_Color.getRed() - p_ColorOrigin.getRed();
                if (Math.abs(intDiff) > intTolerance || Math.abs(intDiff = o_Color.getGreen() - p_ColorOrigin.getGreen()) > intTolerance || Math.abs(intDiff = o_Color.getBlue() - p_ColorOrigin.getBlue()) > intTolerance) continue;
                p_BufferedImage.setRGB(intX, intY, p_ColorNew.getRGB());
            }
        }
        return p_BufferedImage;
    }

    public static Point getPointOnRectangleBorder(Point p_PointRectangle, Rectangle p_Rectangle, double p_Degree) {
        double doubleCorrectX;
        double doubleCorrectY;
        double doubleAngleRadianr = (p_Degree + 90.0) * Math.PI / 180.0;
        double doubleSin = Math.sin(doubleAngleRadianr);
        double doubleCos = Math.cos(doubleAngleRadianr);
        double doubleRectHalfHeight = p_Rectangle.getHeight() / 2.0;
        double doubleRectHalfWidth = p_Rectangle.getWidth() / 2.0;
        double doubleHypothenuse = Math.sqrt(doubleRectHalfWidth * doubleRectHalfWidth + doubleRectHalfHeight * doubleRectHalfHeight);
        double doubleCircleX = doubleHypothenuse * doubleCos;
        double doubleCircleY = doubleHypothenuse * doubleSin;
        double doubleFactorX = doubleCircleX >= 0.0 ? 1.0 : -1.0;
        double doubleFactorY = doubleCircleY >= 0.0 ? 1.0 : -1.0;
        if (Math.abs(doubleCircleY) >= doubleRectHalfHeight) {
            doubleCorrectY = doubleRectHalfHeight * doubleFactorY;
            double doubleCorrectDistance = doubleCircleY - doubleRectHalfHeight * doubleFactorY;
            if (doubleSin == 0.0) {
                doubleCorrectX = doubleRectHalfWidth * doubleFactorX;
            } else {
                double doubleCorrectionHypothenuse = doubleCorrectDistance / doubleSin;
                doubleCorrectX = doubleCircleX - doubleCos * doubleCorrectionHypothenuse;
            }
        } else {
            doubleCorrectX = doubleRectHalfWidth * doubleFactorX;
            double doubleCorrectDistance = doubleCircleX - doubleRectHalfWidth * doubleFactorX;
            if (doubleCos == 0.0) {
                doubleCorrectY = doubleRectHalfHeight * doubleFactorY;
            } else {
                double doubleCorrectionHypothenuse = doubleCorrectDistance / doubleCos;
                doubleCorrectY = doubleCircleY - doubleSin * doubleCorrectionHypothenuse;
            }
        }
        if (p_PointRectangle == null) {
            p_PointRectangle = new Point();
        }
        p_PointRectangle.x = Math.round((float)(p_Rectangle.getCenterX() + doubleCorrectX));
        p_PointRectangle.y = Math.round((float)(p_Rectangle.getCenterY() - doubleCorrectY));
        if ((double)p_PointRectangle.x < p_Rectangle.getX()) {
            p_PointRectangle.x = (int)p_Rectangle.getX();
        } else if ((double)p_PointRectangle.x > p_Rectangle.getX() + p_Rectangle.getWidth()) {
            p_Rectangle.x = (int)(p_Rectangle.getX() + p_Rectangle.getWidth());
        }
        if ((double)p_PointRectangle.y < p_Rectangle.getY()) {
            p_PointRectangle.y = (int)p_Rectangle.getY();
        } else if ((double)p_PointRectangle.y > p_Rectangle.getY() + p_Rectangle.getHeight()) {
            p_Rectangle.y = (int)(p_Rectangle.getY() + p_Rectangle.getHeight());
        }
        return p_PointRectangle;
    }

    public static Point getDiagonalPoint(Point p_PointDiaogonal, Rectangle p_Rectangle, Point p_Point) {
        if (p_PointDiaogonal == null) {
            p_PointDiaogonal = new Point();
        }
        p_PointDiaogonal.x = (int)(2.0 * p_Rectangle.getCenterX() - (double)p_Point.x);
        p_PointDiaogonal.y = (int)(2.0 * p_Rectangle.getCenterY() - (double)p_Point.y);
        return p_PointDiaogonal;
    }

    public static int[] translateColor_RGBToCMY(Color p_ColorRGB) {
        int C = 255 - p_ColorRGB.getRed();
        int M = 255 - p_ColorRGB.getGreen();
        int Y = 255 - p_ColorRGB.getBlue();
        if (C < 0) {
            C = 0;
        }
        if (C > 255) {
            C = 255;
        }
        if (M < 0) {
            M = 0;
        }
        if (M > 255) {
            M = 255;
        }
        if (Y < 0) {
            Y = 0;
        }
        if (Y > 255) {
            Y = 255;
        }
        return new int[]{C, M, Y};
    }

    public static Color translateColor_CMYToRGB(int cyan, int magenta, int yellow) {
        int R = 255 - cyan;
        int G = 255 - magenta;
        int B = 255 - yellow;
        if (R < 0) {
            R = 0;
        }
        if (R > 255) {
            R = 255;
        }
        if (G < 0) {
            G = 0;
        }
        if (G > 255) {
            G = 255;
        }
        if (B < 0) {
            B = 0;
        }
        if (B > 255) {
            B = 255;
        }
        return new Color(R, G, B);
    }

    public static Image getImageFromIcon(Icon p_Icon) {
        if (p_Icon == null) {
            return null;
        }
        if (p_Icon instanceof ImageIcon) {
            return ((ImageIcon)p_Icon).getImage();
        }
        int w = p_Icon.getIconWidth();
        int h = p_Icon.getIconHeight();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h);
        Graphics2D g = image.createGraphics();
        p_Icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public ImageIcon getImageIconFromIcon(Icon p_Icon) {
        if (p_Icon == null) {
            return null;
        }
        if (p_Icon instanceof ImageIcon) {
            return (ImageIcon)p_Icon;
        }
        Image o_Image = ImagesTools.getImageFromIcon(p_Icon);
        if (o_Image == null) {
            return null;
        }
        ImageIcon o_ImageIcon = new ImageIcon(o_Image);
        return o_ImageIcon;
    }

    public static ImageIcon getDisabledImageIcon(Icon p_Icon) {
        if (p_Icon == null) {
            return null;
        }
        try {
            Image o_Image = ImagesTools.getImageFromIcon(p_Icon);
            if (o_Image == null) {
                return null;
            }
            Image o_ImageDisabled = GrayFilter.createDisabledImage(o_Image);
            if (o_ImageDisabled == null) {
                return null;
            }
            ImageIcon o_ImageIcon = new ImageIcon(o_ImageDisabled);
            return o_ImageIcon;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class FileFilter_Image
    extends FileFilter {
        @Override
        public boolean accept(File p_File) {
            if (p_File == null) {
                return false;
            }
            if (p_File.isDirectory()) {
                return true;
            }
            String extension = p_File.getName();
            if (extension != null) {
                return extension.contains(".gif") || extension.contains(".jpeg") || extension.contains(".jpg") || extension.contains(".png");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "jpg, gif, png";
        }
    }

    public static class myImageObserver
    implements ImageObserver {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
            myImageObserver myImageObserver2 = this;
            synchronized (myImageObserver2) {
                if ((infoflags & 0x80) == 0) {
                    this.notifyAll();
                }
                if ((infoflags & 0x20) == 0) {
                    this.notifyAll();
                }
                if ((infoflags & 2) == 0) {
                    this.notifyAll();
                }
                if ((infoflags & 1) == 0) {
                    this.notifyAll();
                }
                return (infoflags & 0xA3) == 0;
            }
        }
    }
}

