/*
 * Decompiled with CFR 0.152.
 */
package SwingComponents;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;

public class RotationLabelUI
extends BasicLabelUI {
    protected double m_RotationRadians;
    private Point m_Point0 = new Point();
    private Point m_DeltaPoint1 = new Point();
    private Point m_DeltaPoint2 = new Point();
    private Point deltaPoint;
    private Point m_AlignPoint = new Point();
    private Point m_TempPoint;
    private Rectangle m_RectContent;

    public RotationLabelUI() {
        this.initMembers();
        this.m_RotationRadians = 0.0;
    }

    public RotationLabelUI(double p_Degree) {
        this.initMembers();
        this.setRotationDegree(p_Degree);
    }

    public static RotationLabelUI createUI(double p_Degree) {
        return new RotationLabelUI(p_Degree);
    }

    private void initMembers() {
        this.m_Point0 = new Point();
        this.m_DeltaPoint1 = new Point();
        this.m_DeltaPoint2 = new Point();
        this.m_AlignPoint = new Point();
        this.m_TempPoint = new Point();
        this.m_RectContent = new Rectangle();
    }

    public double getRotationDegree() {
        return this.m_RotationRadians * 180.0 / Math.PI;
    }

    public void setRotationDegree(double p_Degree) {
        int intWhole = (int)(p_Degree / 360.0);
        this.m_RotationRadians = Math.PI * (p_Degree -= (double)(intWhole * 360)) / 180.0;
    }

    public void setRotationRadians(double p_Radians) {
        this.m_RotationRadians = p_Radians;
    }

    public double getRotationRadians() {
        return this.m_RotationRadians;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Icon o_Icon;
        Graphics2D g2d = (Graphics2D)g;
        JLabel o_JLabel = (JLabel)c;
        String stringText = o_JLabel.getText();
        Icon icon = o_Icon = o_JLabel.isEnabled() ? o_JLabel.getIcon() : o_JLabel.getDisabledIcon();
        if (o_Icon == null && stringText == null) {
            return;
        }
        double doubleRadiansOf90Degree = 1.5707963267948966;
        Object o_Antialias = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object o_TextAntialias = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        if ((double)((long)(this.m_RotationRadians / doubleRadiansOf90Degree)) != this.m_RotationRadians / doubleRadiansOf90Degree) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        }
        this.m_RectContent.width = 0;
        if (o_Icon != null) {
            this.m_RectContent.x = 0;
            this.m_RectContent.y = 0;
            this.m_RectContent.width = o_Icon.getIconWidth();
            this.m_RectContent.height = o_Icon.getIconHeight();
        }
        FontMetrics fm = g.getFontMetrics();
        if (stringText != null) {
            this.m_RectContent.width = (int)((double)this.m_RectContent.width + fm.getStringBounds(stringText, g).getWidth());
            if (o_Icon != null) {
                this.m_RectContent.width += o_JLabel.getIconTextGap();
            }
            if (this.m_RectContent.height < fm.getHeight()) {
                this.m_RectContent.height = fm.getHeight();
            }
        }
        AffineTransform o_AffineTransformOld = g2d.getTransform();
        this.m_TempPoint.setLocation(0, 0);
        o_AffineTransformOld.transform(this.m_TempPoint, this.m_Point0);
        AffineTransform o_TransformRotate = new AffineTransform();
        o_TransformRotate.rotate(this.m_RotationRadians, 0.0, 0.0);
        this.m_TempPoint.setLocation(-this.m_RectContent.width / 2, -this.m_RectContent.height / 2);
        o_TransformRotate.transform(this.m_TempPoint, this.m_DeltaPoint1);
        this.m_TempPoint.setLocation(-this.m_RectContent.width / 2, this.m_RectContent.height / 2);
        o_TransformRotate.transform(this.m_TempPoint, this.m_DeltaPoint2);
        this.deltaPoint = Math.abs(this.m_DeltaPoint1.y) > Math.abs(this.m_DeltaPoint2.y) ? this.m_DeltaPoint1 : this.m_DeltaPoint2;
        switch (o_JLabel.getVerticalAlignment()) {
            case 1: {
                this.m_AlignPoint.y = Math.abs(this.deltaPoint.y) - o_JLabel.getHeight() / 2 + o_JLabel.getInsets().top;
                break;
            }
            case 0: {
                this.m_AlignPoint.y = 0;
                break;
            }
            case 3: {
                this.m_AlignPoint.y = -(Math.abs(this.deltaPoint.y) - o_JLabel.getHeight() / 2) - o_JLabel.getInsets().bottom;
            }
        }
        this.deltaPoint = Math.abs(this.m_DeltaPoint1.x) > Math.abs(this.m_DeltaPoint2.x) ? this.m_DeltaPoint1 : this.m_DeltaPoint2;
        switch (o_JLabel.getHorizontalAlignment()) {
            case 2: 
            case 10: {
                this.m_AlignPoint.x = Math.abs(this.deltaPoint.x) - o_JLabel.getWidth() / 2 + o_JLabel.getInsets().left;
                break;
            }
            case 0: {
                this.m_AlignPoint.x = 0;
                break;
            }
            case 4: 
            case 11: {
                this.m_AlignPoint.x = -(Math.abs(this.deltaPoint.x) - o_JLabel.getWidth() / 2) - o_JLabel.getInsets().right;
            }
        }
        AffineTransform o_TransformTranslate = new AffineTransform();
        o_TransformTranslate.translate(this.m_Point0.x + o_JLabel.getWidth() / 2 + this.m_AlignPoint.x, this.m_Point0.y + o_JLabel.getHeight() / 2 + this.m_AlignPoint.y);
        o_TransformRotate.preConcatenate(o_TransformTranslate);
        g2d.setTransform(o_TransformRotate);
        int intTextXStart = 0;
        if (o_Icon != null) {
            o_Icon.paintIcon(c, g2d, -this.m_RectContent.width / 2, -o_Icon.getIconHeight() / 2);
            intTextXStart += o_Icon.getIconWidth() + o_JLabel.getIconTextGap();
        }
        g2d.drawString(stringText, -this.m_RectContent.width / 2 + intTextXStart, -fm.getHeight() / 2 + fm.getAscent());
        g2d.setTransform(o_AffineTransformOld);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, o_TextAntialias);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, o_Antialias);
    }
}

