/*
 * Decompiled with CFR 0.152.
 */
package SwingComponents;

import SwingComponents.MouseAdapter_Delayed;
import SynchronizationPackage.EventQueueHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class JSplitPaneMulti
extends JPanel
implements ComponentListener {
    private ArrayList<SplitContainer> m_SplitContainers;
    private boolean m_IsVertical;
    private int m_DividerSize;
    private Color m_DividerColor;
    private AbsoluteLayout m_AbsoluteLayout;
    private Rectangle m_Bounds;
    private Dimension m_Dimension;
    private final Object m_SyncComponents = new Object();
    private Runnable m_RunnableRepaint = new Runnable(){

        @Override
        public void run() {
            JSplitPaneMulti.this.revalidate();
            JSplitPaneMulti.this.repaint();
        }
    };

    public JSplitPaneMulti() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
    }

    private void initMembers() {
        this.m_SplitContainers = new ArrayList();
        this.m_Bounds = new Rectangle(10, 10);
        this.m_Dimension = new Dimension(10, 10);
        this.m_DividerSize = 10;
        this.m_IsVertical = true;
    }

    private void initComponents() {
        this.setLayout(new AbsoluteLayout());
    }

    private void initComponentsFurther() {
        this.m_AbsoluteLayout = (AbsoluteLayout)this.getLayout();
        this.addComponentListener(this);
        this.m_DividerColor = this.getForeground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SplitContainer addJComponent(JComponent p_JComponent) {
        SplitContainer o_SplitContainerAdded;
        if (p_JComponent == null) {
            return null;
        }
        SplitContainer o_SplitContainer = this.getSplitContainer(p_JComponent);
        if (o_SplitContainer != null) {
            return o_SplitContainer;
        }
        Object object = this.m_SyncComponents;
        synchronized (object) {
            o_SplitContainerAdded = new SplitContainer(p_JComponent, this, this.m_SplitContainers.size());
            this.m_SplitContainers.add(o_SplitContainerAdded);
            this.resetSizes();
        }
        return o_SplitContainerAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SplitContainer removeJComponent(JComponent p_JComponent) {
        if (p_JComponent == null) {
            return null;
        }
        SplitContainer o_SplitContainerRemoved = this.getSplitContainer(p_JComponent);
        if (o_SplitContainerRemoved == null) {
            return o_SplitContainerRemoved;
        }
        Object object = this.m_SyncComponents;
        synchronized (object) {
            o_SplitContainerRemoved.close();
            this.m_SplitContainers.remove(o_SplitContainerRemoved);
            this.resetSizes();
        }
        return o_SplitContainerRemoved;
    }

    public void setVisible(JComponent p_JComponent, boolean p_Visible) {
        if (p_JComponent == null) {
            return;
        }
        SplitContainer o_SplitContainer = this.getSplitContainer(p_JComponent);
        if (o_SplitContainer == null) {
            return;
        }
        o_SplitContainer.setVisible(p_Visible);
        this.resetSizes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SplitContainer getSplitContainer(JComponent p_JComponent) {
        if (p_JComponent == null) {
            return null;
        }
        SplitContainer o_SplitContainer = null;
        Object object = this.m_SyncComponents;
        synchronized (object) {
            for (int intContainer = 0; intContainer < this.m_SplitContainers.size(); ++intContainer) {
                o_SplitContainer = this.m_SplitContainers.get(intContainer);
                if (o_SplitContainer.getJComponent() != p_JComponent) continue;
                return o_SplitContainer;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSizes() {
        int intVisibleComponents = 0;
        Object object = this.m_SyncComponents;
        synchronized (object) {
            SplitContainer o_SplitContainer;
            int intContainer;
            for (intContainer = 0; intContainer < this.m_SplitContainers.size(); ++intContainer) {
                o_SplitContainer = this.m_SplitContainers.get(intContainer);
                if (!o_SplitContainer.getVisible()) continue;
                ++intVisibleComponents;
            }
            if (intVisibleComponents == 0) {
                return;
            }
            double doubleRelativeSize = 1.0 / (double)intVisibleComponents;
            for (intContainer = 0; intContainer < this.m_SplitContainers.size(); ++intContainer) {
                o_SplitContainer = this.m_SplitContainers.get(intContainer);
                o_SplitContainer.setPosition(intContainer);
                o_SplitContainer.setRelativeSize(doubleRelativeSize);
            }
        }
        this.refreshLayout();
    }

    public void setVertical(boolean p_IsVertical) {
        if (this.m_IsVertical == p_IsVertical) {
            return;
        }
        this.m_IsVertical = p_IsVertical;
        this.refreshLayout();
    }

    public boolean getVertical() {
        return this.m_IsVertical;
    }

    public void setDividerSize(int p_DividerSize) {
        if (this.m_DividerSize == p_DividerSize) {
            return;
        }
        this.m_DividerSize = p_DividerSize;
        this.refreshLayout();
    }

    public int getDividerSize() {
        return this.m_DividerSize;
    }

    public void setDividerColor(Color p_Color) {
        if (this.m_DividerColor.equals(p_Color)) {
            return;
        }
        this.m_DividerColor = p_Color;
        this.refreshLayout();
    }

    public Color getDividerColor() {
        return this.m_DividerColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshLayout() {
        this.m_Bounds = super.getBounds(this.m_Bounds);
        this.m_Dimension.setSize(this.m_Bounds.width, this.m_Bounds.height);
        SplitContainer o_LastVisibie_SplitContainer = null;
        int intDividersSize = 0;
        int intLastDividerSize = 0;
        Object object = this.m_SyncComponents;
        synchronized (object) {
            SplitContainer o_SplitContainer;
            for (int intContainer = 0; intContainer < this.m_SplitContainers.size(); ++intContainer) {
                o_SplitContainer = this.m_SplitContainers.get(intContainer);
                if (o_SplitContainer.getVisible()) {
                    if (o_LastVisibie_SplitContainer != null) {
                        o_LastVisibie_SplitContainer.setNextVisible_SplitContainer(o_SplitContainer);
                    }
                    o_LastVisibie_SplitContainer = o_SplitContainer;
                    intDividersSize += o_SplitContainer.getDividerSize();
                    intLastDividerSize = o_SplitContainer.getDividerSize();
                    continue;
                }
                o_SplitContainer.setNextVisible_SplitContainer(null);
            }
            this.m_Dimension.setSize(this.m_Dimension.width - (intDividersSize -= intLastDividerSize), this.m_Dimension.height - intDividersSize);
            int intPosition = 0;
            for (int intContainer = 0; intContainer < this.m_SplitContainers.size(); ++intContainer) {
                o_SplitContainer = this.m_SplitContainers.get(intContainer);
                intPosition = o_SplitContainer.refreshLayout(intPosition);
            }
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        } else {
            this.revalidate();
            this.repaint();
        }
    }

    public int getSize_WithoutDividers() {
        if (this.m_IsVertical) {
            return this.m_Dimension.height;
        }
        return this.m_Dimension.width;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.refreshLayout();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public static class Divider
    extends JPanel {
        private GridBagLayout m_GridBagLayout;
        private int m_DividerSize;
        private Dimension m_Dimension;
        private SplitContainer m_SplitContainer;
        private AbsoluteConstraints m_AbsoluteConstraints;
        private Rectangle m_Bounds;

        public Divider(SplitContainer p_SplitContainer) {
            this.initMembers();
            this.initComponents();
            this.m_SplitContainer = p_SplitContainer;
            this.refreshLayout();
        }

        private void initMembers() {
            this.m_DividerSize = -1;
            this.m_Dimension = new Dimension(10, 10);
        }

        private void initComponents() {
            this.m_AbsoluteConstraints = new AbsoluteConstraints(0, 0);
            this.setOpaque(false);
            this.setForeground(Color.lightGray);
        }

        public void close() {
        }

        public void refreshLayout() {
            boolean boolVertical = this.getVertical();
            if (boolVertical) {
                this.setCursor(Cursor.getPredefinedCursor(8));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(11));
            }
            this.revalidate();
        }

        public boolean getVertical() {
            return this.m_SplitContainer.getVertical();
        }

        public AbsoluteConstraints getAbsoluteConstraints() {
            return this.m_AbsoluteConstraints;
        }

        public SplitContainer getSplitContainer() {
            return this.m_SplitContainer;
        }

        public void setDividerSize(int p_DividerSize) {
            if (p_DividerSize < 0) {
                return;
            }
            this.m_DividerSize = p_DividerSize;
            this.refreshLayout();
        }

        public int getDividerSize() {
            if (this.m_DividerSize < 0) {
                return this.m_SplitContainer.getJSplitPaneMulti().getDividerSize();
            }
            return this.m_DividerSize;
        }

        @Override
        public void paintComponent(Graphics g) {
            this.m_Bounds = this.getBounds(this.m_Bounds);
            g.setColor(this.getForeground());
            if (this.getVertical()) {
                g.drawLine(0, this.m_Bounds.height / 2, this.m_Bounds.width, this.m_Bounds.height / 2);
            } else {
                g.drawLine(this.m_Bounds.width / 2, 0, this.m_Bounds.width / 2, this.m_Bounds.height);
            }
        }
    }

    public static class SplitContainer {
        private JSplitPaneMulti m_JSplitPaneMulti;
        private int m_Position;
        private JComponent m_JComponent;
        private AbsoluteConstraints m_AbsoluteConstraints_JComponent;
        private SplitContainer m_NextVisible_SplitContainer;
        private Divider m_Divider_Bottom;
        private AbsoluteConstraints m_AbsoluteConstraints_Divider;
        private double m_RelativeSize;
        private boolean m_Visible;
        private Point m_Point_MouseClicked;
        private int m_SizeParent_MouseClicked;
        private MouseAdapter_Delayed m_MouseAdapter_Delayed;

        public SplitContainer(JComponent p_JComponent, JSplitPaneMulti p_JSplitPaneMulti, int p_Position) {
            this.initMembers();
            this.m_JSplitPaneMulti = p_JSplitPaneMulti;
            this.m_JComponent = p_JComponent;
            this.initComponents();
        }

        private void initMembers() {
            this.m_JComponent = null;
            this.m_RelativeSize = 1.0;
            this.m_Visible = true;
            this.m_Position = 0;
            this.m_Point_MouseClicked = new Point(0, 0);
        }

        private void initComponents() {
            this.m_AbsoluteConstraints_JComponent = new AbsoluteConstraints(0, 0);
            this.m_JSplitPaneMulti.add((Component)this.m_JComponent, this.m_AbsoluteConstraints_JComponent);
            this.m_MouseAdapter_Delayed = new MouseAdapter_Delayed(){

                @Override
                public void mousePressed_Delayed(MouseEvent e) {
                    m_Point_MouseClicked.setLocation(e.getX(), e.getY());
                    m_SizeParent_MouseClicked = m_JSplitPaneMulti.getSize_WithoutDividers();
                }

                @Override
                public void mouseDragged_Delayed(MouseEvent e) {
                    double doubleRelativeSizeNext;
                    if (m_NextVisible_SplitContainer == null) {
                        return;
                    }
                    int intDiffSize = this.getVertical() ? e.getY() - ((SplitContainer)this).m_Point_MouseClicked.y : e.getX() - ((SplitContainer)this).m_Point_MouseClicked.x;
                    if (m_SizeParent_MouseClicked == 0) {
                        return;
                    }
                    double doubleDiffRelativeSize = (double)intDiffSize / (double)m_SizeParent_MouseClicked;
                    double doubleRelativeSize = m_RelativeSize + doubleDiffRelativeSize;
                    if (doubleRelativeSize < 0.0) {
                        doubleDiffRelativeSize = -m_RelativeSize;
                        doubleRelativeSize = 0.0;
                    }
                    if ((doubleRelativeSizeNext = m_NextVisible_SplitContainer.getRelativeSize() - doubleDiffRelativeSize) < 0.0) {
                        doubleDiffRelativeSize = m_NextVisible_SplitContainer.getRelativeSize();
                        doubleRelativeSize = m_RelativeSize + doubleDiffRelativeSize;
                        doubleRelativeSizeNext = 0.0;
                    }
                    m_NextVisible_SplitContainer.setRelativeSize(doubleRelativeSizeNext);
                    this.setRelativeSize(doubleRelativeSize);
                    m_JSplitPaneMulti.refreshLayout();
                }

                @Override
                public void mouseClicked_Delayed(MouseEvent e) {
                    if (e.getClickCount() > 1) {
                        m_JSplitPaneMulti.resetSizes();
                    }
                }
            };
            this.createDivider();
            this.m_AbsoluteConstraints_Divider = this.m_Divider_Bottom.getAbsoluteConstraints();
            this.m_JSplitPaneMulti.add((Component)this.m_Divider_Bottom, this.m_AbsoluteConstraints_Divider);
        }

        public void close() {
            this.m_Divider_Bottom.removeMouseListener(this.m_MouseAdapter_Delayed);
            this.m_Divider_Bottom.removeMouseMotionListener(this.m_MouseAdapter_Delayed);
            this.m_JSplitPaneMulti.remove(this.m_JComponent);
            this.m_JSplitPaneMulti.remove(this.m_Divider_Bottom);
            this.m_NextVisible_SplitContainer = null;
            this.m_Divider_Bottom.close();
        }

        public int refreshLayout(int p_Position) {
            this.m_Divider_Bottom.setForeground(this.m_JSplitPaneMulti.getDividerColor());
            int intSize_Parent = this.m_JSplitPaneMulti.getSize_WithoutDividers();
            int intComponentSize = (int)((double)intSize_Parent * this.m_RelativeSize + 0.5);
            int intNextPosition = p_Position;
            if (this.m_JComponent != null) {
                this.m_JComponent.setVisible(this.m_Visible);
                if (this.m_JSplitPaneMulti.getVertical()) {
                    this.m_AbsoluteConstraints_JComponent.x = 0;
                    this.m_AbsoluteConstraints_JComponent.y = p_Position;
                    this.m_AbsoluteConstraints_JComponent.width = this.m_JSplitPaneMulti.getWidth();
                    this.m_AbsoluteConstraints_JComponent.height = intComponentSize;
                    this.m_AbsoluteConstraints_Divider.x = 0;
                    this.m_AbsoluteConstraints_Divider.y = p_Position + intComponentSize;
                    this.m_AbsoluteConstraints_Divider.width = this.m_JSplitPaneMulti.getWidth();
                    this.m_AbsoluteConstraints_Divider.height = this.m_Divider_Bottom.getDividerSize();
                } else {
                    this.m_AbsoluteConstraints_JComponent.x = p_Position;
                    this.m_AbsoluteConstraints_JComponent.y = 0;
                    this.m_AbsoluteConstraints_JComponent.height = this.m_JSplitPaneMulti.getHeight();
                    this.m_AbsoluteConstraints_JComponent.width = intComponentSize;
                    this.m_AbsoluteConstraints_Divider.x = p_Position + intComponentSize;
                    this.m_AbsoluteConstraints_Divider.y = 0;
                    this.m_AbsoluteConstraints_Divider.width = this.m_Divider_Bottom.getDividerSize();
                    this.m_AbsoluteConstraints_Divider.height = this.m_JSplitPaneMulti.getHeight();
                }
                if (this.m_Visible) {
                    intNextPosition += intComponentSize;
                }
                if (this.m_NextVisible_SplitContainer != null) {
                    this.m_Divider_Bottom.setVisible(true);
                    if (this.m_Visible) {
                        intNextPosition += this.m_Divider_Bottom.getDividerSize();
                    }
                } else {
                    this.m_Divider_Bottom.setVisible(false);
                }
            }
            this.m_Divider_Bottom.refreshLayout();
            return intNextPosition;
        }

        private Divider createDivider() {
            this.m_Divider_Bottom = new Divider(this);
            this.m_Divider_Bottom.addMouseListener(this.m_MouseAdapter_Delayed);
            this.m_Divider_Bottom.addMouseMotionListener(this.m_MouseAdapter_Delayed);
            return this.m_Divider_Bottom;
        }

        public void setPosition(int p_Position) {
            if (this.m_Position == p_Position) {
                return;
            }
            this.m_Position = p_Position;
        }

        public int getPosition() {
            return this.m_Position;
        }

        public boolean getVertical() {
            return this.m_JSplitPaneMulti.getVertical();
        }

        public void setVisible(boolean p_Visible) {
            if (this.m_Visible == p_Visible) {
                return;
            }
            this.m_Visible = p_Visible;
        }

        public boolean getVisible() {
            return this.m_Visible;
        }

        public void setRelativeSize(double p_RelativeSize) {
            if (this.m_RelativeSize == p_RelativeSize) {
                return;
            }
            this.m_RelativeSize = p_RelativeSize;
        }

        public double getRelativeSize() {
            return this.m_RelativeSize;
        }

        public void setDividerSize(int p_DividerSize) {
            if (this.m_Divider_Bottom == null) {
                return;
            }
            if (this.m_Divider_Bottom != null) {
                if (this.m_Divider_Bottom.getDividerSize() == p_DividerSize) {
                    return;
                }
                this.m_Divider_Bottom.setDividerSize(p_DividerSize);
            }
        }

        public int getDividerSize() {
            return this.m_Divider_Bottom.getDividerSize();
        }

        public JSplitPaneMulti getJSplitPaneMulti() {
            return this.m_JSplitPaneMulti;
        }

        public JComponent getJComponent() {
            return this.m_JComponent;
        }

        public void setNextVisible_SplitContainer(SplitContainer p_SplitContainer) {
            if (this.m_NextVisible_SplitContainer == p_SplitContainer) {
                return;
            }
            this.m_NextVisible_SplitContainer = p_SplitContainer;
        }
    }
}

