/*
 * Decompiled with CFR 0.152.
 */
package LiveShowVirtualPackage;

import GUID.LiveGUID;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowVIP;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class LiveShow_ImportDescription {
    public static File s_LastFile;
    public static final int IMPORTPOSITION_ORIGINAL = 0;
    public static final int IMPORTPOSITION_SOUNDCURSOR = 1;
    public static final int IMPORTPOSITION_DMXCURSOR = 2;
    public static final int IMPORTPOSITION_MEDIACURSOR = 3;
    public static final int IMPORTPOSITION_ENDOFPROJECT = 10;
    @LiveLanguageString
    private static String DEFAULT_IMPORTPREFIX;
    private boolean m_LoadNewProject;
    private HashMap<LiveShowVIP, VIPImportDescription> m_VIPImportDescriptions;
    private HashMap<String, String> m_ImportSceneBridgeIDReplacements;
    private long m_FrameEndOfProject;
    private int m_ImportPosition;
    private HashMap<String, String> m_ImportDMXDeviceIDReplacements;

    public static String createImportedName(String p_Name) {
        if (p_Name == null) {
            return DEFAULT_IMPORTPREFIX;
        }
        StringBuilder o_StringBuffer = new StringBuilder();
        if (p_Name.length() >= DEFAULT_IMPORTPREFIX.length() && DEFAULT_IMPORTPREFIX.equals(p_Name.substring(0, DEFAULT_IMPORTPREFIX.length()))) {
            return p_Name;
        }
        o_StringBuffer.append(DEFAULT_IMPORTPREFIX);
        o_StringBuffer.append(p_Name);
        return o_StringBuffer.toString();
    }

    public LiveShow_ImportDescription() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_LoadNewProject = true;
        this.m_VIPImportDescriptions = new HashMap();
        this.m_ImportSceneBridgeIDReplacements = new HashMap();
        this.m_ImportDMXDeviceIDReplacements = new HashMap();
        LiveLanguage.addLanguageListener(this, null);
    }

    public void setLoadNewProject(boolean p_IsImport) {
        this.m_LoadNewProject = p_IsImport;
    }

    public boolean getLoadNewProject() {
        return this.m_LoadNewProject;
    }

    public void clearImport() {
        for (LiveShowVIP o_LiveShowVIP : this.m_VIPImportDescriptions.keySet()) {
            VIPImportDescription o_VIPImportDescription = this.m_VIPImportDescriptions.get(o_LiveShowVIP);
            o_VIPImportDescription.clearImport();
        }
        this.m_ImportSceneBridgeIDReplacements.clear();
        this.m_ImportDMXDeviceIDReplacements.clear();
    }

    public void addLiveShowVIP(LiveShowVIP p_LiveShowVIP) {
        VIPImportDescription o_VIPImportDescription;
        if (p_LiveShowVIP == null) {
            return;
        }
        if (this.m_VIPImportDescriptions.containsKey(p_LiveShowVIP)) {
            return;
        }
        Iterator<LiveShowVIP> o_LiveShowVips = this.m_VIPImportDescriptions.keySet().iterator();
        while (o_LiveShowVips.hasNext()) {
            LiveShowVIP o_LiveShowVIP = o_LiveShowVips.next();
            if (!o_LiveShowVIP.getClass().getName().equals(p_LiveShowVIP.getClass().getName())) continue;
            o_VIPImportDescription = this.m_VIPImportDescriptions.get(o_LiveShowVIP);
            if (o_VIPImportDescription != null) {
                o_VIPImportDescription.clearImport();
            }
            o_LiveShowVips.remove();
            break;
        }
        o_VIPImportDescription = new VIPImportDescription(p_LiveShowVIP);
        this.m_VIPImportDescriptions.put(p_LiveShowVIP, o_VIPImportDescription);
    }

    public LiveShowVIP getLiveShowVIP(String p_VIPType) {
        if (p_VIPType == null) {
            return null;
        }
        for (LiveShowVIP o_LiveShowVIP : this.m_VIPImportDescriptions.keySet()) {
            if (!p_VIPType.equals(o_LiveShowVIP.getType())) continue;
            return o_LiveShowVIP;
        }
        return null;
    }

    public LiveShowVIP getLiveShowVIP(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= this.m_VIPImportDescriptions.size()) {
            return null;
        }
        Iterator<LiveShowVIP> o_Iterator = this.m_VIPImportDescriptions.keySet().iterator();
        int intIndex = 0;
        while (o_Iterator.hasNext()) {
            LiveShowVIP o_LiveShowVIP = o_Iterator.next();
            if (intIndex != p_Index) continue;
            return o_LiveShowVIP;
        }
        return null;
    }

    public void setImportPosition(int p_ImportPosition) {
        if (p_ImportPosition == 0 || p_ImportPosition == 1 || p_ImportPosition == 2 || p_ImportPosition == 3 || p_ImportPosition == 10) {
            this.m_ImportPosition = p_ImportPosition;
        }
    }

    public int getImportPosition() {
        return this.m_ImportPosition;
    }

    public void setFrameMaxBeforeImport(long p_FramePositionMax) {
        this.m_FrameEndOfProject = p_FramePositionMax;
    }

    public long getFrameMaxBeforeImport() {
        return this.m_FrameEndOfProject;
    }

    public void checkImportObject(LiveShowVIP p_LiveShowVIP, LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowVIP == null) {
            return;
        }
        if (p_LiveShowObjectDescription == null) {
            return;
        }
        VIPImportDescription o_VIPImportDescription = this.m_VIPImportDescriptions.get(p_LiveShowVIP);
        if (o_VIPImportDescription != null) {
            if (p_LiveShowObjectDescription.getIsSceneBridge()) {
                String stringID = p_LiveShowObjectDescription.getID();
                String stringIDNew = this.m_ImportSceneBridgeIDReplacements.get(stringID);
                if (stringIDNew == null) {
                    LiveShowSceneBridge o_LiveShowSceneBridge = p_LiveShowVIP.getLiveShowSceneBridge(p_LiveShowObjectDescription.getID());
                    if (o_LiveShowSceneBridge != null) {
                        stringIDNew = LiveGUID.getUID();
                        this.m_ImportSceneBridgeIDReplacements.put(stringID, stringIDNew);
                    } else {
                        stringIDNew = null;
                    }
                }
                if (stringIDNew != null) {
                    p_LiveShowObjectDescription.setID(stringIDNew);
                }
            } else {
                String stringID = p_LiveShowObjectDescription.getID();
                LiveShowObjectInterface o_LiveShowObjectInterface = p_LiveShowVIP.getLiveShowObjectInterface(stringID);
                String stringIDNew = o_LiveShowObjectInterface != null ? LiveGUID.getUID() : null;
                if (stringIDNew != null) {
                    p_LiveShowObjectDescription.setID(stringIDNew);
                }
            }
        }
    }

    public String getReplacedID(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        String stringNewID = this.m_ImportSceneBridgeIDReplacements.get(p_ID);
        if (stringNewID == null) {
            return p_ID;
        }
        return stringNewID;
    }

    public void addDMXDeviceIDReplacement(String p_OldDeviceID, String p_NewDeviceID) {
        this.m_ImportDMXDeviceIDReplacements.put(p_OldDeviceID, p_NewDeviceID);
    }

    public String getDMXDeviceIDReplacement(String p_OldDeviceID) {
        return this.m_ImportDMXDeviceIDReplacements.get(p_OldDeviceID);
    }

    public void addLiveShowObject(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowVIP == null) {
            return;
        }
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        VIPImportDescription o_VIPImportDescription = this.m_VIPImportDescriptions.get(p_LiveShowVIP);
        if (o_VIPImportDescription == null) {
            return;
        }
        o_VIPImportDescription.addLiveShowObject(p_LiveShowObjectInterface);
    }

    public ArrayList<LiveShowObjectInterface> getLiveShowObjects() {
        ArrayList<LiveShowObjectInterface> o_ResultObjects = new ArrayList<LiveShowObjectInterface>();
        for (LiveShowVIP o_LiveShowVIP : this.m_VIPImportDescriptions.keySet()) {
            VIPImportDescription o_VIPImportDescription = this.m_VIPImportDescriptions.get(o_LiveShowVIP);
            for (int intObject = 0; intObject < o_VIPImportDescription.getLiveShowObjectInterfaceCount(); ++intObject) {
                LiveShowObjectInterface o_LiveShowObject = o_VIPImportDescription.getLiveShowObject(intObject);
                o_ResultObjects.add(o_LiveShowObject);
            }
        }
        return o_ResultObjects;
    }

    public int getLiveShowObjectCount(LiveShowVIP p_LiveShowVIP) {
        if (p_LiveShowVIP == null) {
            return 0;
        }
        VIPImportDescription o_VIPImportDescription = this.m_VIPImportDescriptions.get(p_LiveShowVIP);
        if (o_VIPImportDescription == null) {
            return 0;
        }
        return o_VIPImportDescription.getLiveShowObjectInterfaceCount();
    }

    public LiveShowObjectInterface getLiveShowObject(LiveShowVIP p_LiveShowVIP, int p_Index) {
        if (p_LiveShowVIP == null) {
            return null;
        }
        VIPImportDescription o_VIPImportDescription = this.m_VIPImportDescriptions.get(p_LiveShowVIP);
        if (o_VIPImportDescription == null) {
            return null;
        }
        return o_VIPImportDescription.getLiveShowObject(p_Index);
    }

    public void addLiveShowSceneBridge(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowObjectSceneBridge) {
        if (p_LiveShowVIP == null) {
            return;
        }
        if (p_LiveShowObjectSceneBridge == null) {
            return;
        }
        VIPImportDescription o_VIPImportDescription = this.m_VIPImportDescriptions.get(p_LiveShowVIP);
        if (o_VIPImportDescription == null) {
            return;
        }
        o_VIPImportDescription.addLiveShowSceneBridge(p_LiveShowObjectSceneBridge);
    }

    public ArrayList<LiveShowSceneBridge> getLiveShowSceneBridges() {
        ArrayList<LiveShowSceneBridge> o_ResultSceneBridges = new ArrayList<LiveShowSceneBridge>();
        for (LiveShowVIP o_LiveShowVIP : this.m_VIPImportDescriptions.keySet()) {
            VIPImportDescription o_VIPImportDescription = this.m_VIPImportDescriptions.get(o_LiveShowVIP);
            for (int intSceneBridge = 0; intSceneBridge < o_VIPImportDescription.getLiveShowSceneBridgeCount(); ++intSceneBridge) {
                LiveShowSceneBridge o_LiveShowSceneBridge = o_VIPImportDescription.getLiveShowSceneBridge(intSceneBridge);
                o_ResultSceneBridges.add(o_LiveShowSceneBridge);
            }
        }
        return o_ResultSceneBridges;
    }

    public int getLiveShowSceneBridgeCount(LiveShowVIP p_LiveShowVIP) {
        if (p_LiveShowVIP == null) {
            return 0;
        }
        VIPImportDescription o_VIPImportDescription = this.m_VIPImportDescriptions.get(p_LiveShowVIP);
        if (o_VIPImportDescription == null) {
            return 0;
        }
        return o_VIPImportDescription.getLiveShowSceneBridgeCount();
    }

    public LiveShowSceneBridge getLiveShowSceneBridge(LiveShowVIP p_LiveShowVIP, int p_Index) {
        if (p_LiveShowVIP == null) {
            return null;
        }
        VIPImportDescription o_VIPImportDescription = this.m_VIPImportDescriptions.get(p_LiveShowVIP);
        if (o_VIPImportDescription == null) {
            return null;
        }
        return o_VIPImportDescription.getLiveShowSceneBridge(p_Index);
    }

    static {
        DEFAULT_IMPORTPREFIX = "*";
    }

    public static class VIPImportDescription {
        private LiveShowVIP m_LiveShowVIP;
        private ArrayList<LiveShowSceneBridge> m_LiveShowSceneBridges;
        private ArrayList<LiveShowObjectInterface> m_LiveShowObjectInterfaces;

        public VIPImportDescription(LiveShowVIP p_LiveShowVIP) {
            this.initMembers();
            this.m_LiveShowVIP = p_LiveShowVIP;
        }

        private void initMembers() {
            this.m_LiveShowSceneBridges = new ArrayList();
            this.m_LiveShowObjectInterfaces = new ArrayList();
        }

        public void clearImport() {
            this.m_LiveShowSceneBridges.clear();
            this.m_LiveShowObjectInterfaces.clear();
        }

        public void addLiveShowObject(LiveShowObjectInterface p_LiveShowObjectInterface) {
            if (p_LiveShowObjectInterface == null) {
                return;
            }
            if (this.m_LiveShowObjectInterfaces.contains(p_LiveShowObjectInterface)) {
                return;
            }
            this.m_LiveShowObjectInterfaces.add(p_LiveShowObjectInterface);
        }

        public int getLiveShowObjectInterfaceCount() {
            return this.m_LiveShowObjectInterfaces.size();
        }

        public LiveShowObjectInterface getLiveShowObject(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_LiveShowObjectInterfaces.size()) {
                return null;
            }
            return this.m_LiveShowObjectInterfaces.get(p_Index);
        }

        public void addLiveShowSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge) {
            if (p_LiveShowSceneBridge == null) {
                return;
            }
            if (this.m_LiveShowSceneBridges.contains(p_LiveShowSceneBridge)) {
                return;
            }
            this.m_LiveShowSceneBridges.add(p_LiveShowSceneBridge);
        }

        public int getLiveShowSceneBridgeCount() {
            return this.m_LiveShowSceneBridges.size();
        }

        public LiveShowSceneBridge getLiveShowSceneBridge(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_LiveShowSceneBridges.size()) {
                return null;
            }
            return this.m_LiveShowSceneBridges.get(p_Index);
        }
    }
}

