/*
 * Decompiled with CFR 0.152.
 */
package LiveShowVirtualPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowVIP;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class LiveShow_ExportDescription {
    public static File s_LastFile;
    private boolean m_SaveProject;
    private boolean m_ExportProjectAll;
    private boolean m_IncludeJingles;
    private HashMap<LiveShowVIP, VIPExportDescription> m_VIPExportDescriptions;

    public LiveShow_ExportDescription() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_SaveProject = true;
        this.m_VIPExportDescriptions = new HashMap();
        this.m_ExportProjectAll = true;
        this.m_IncludeJingles = false;
        LiveLanguage.addLanguageListener(this, null);
    }

    public void setSaveProject(boolean p_SaveProject) {
        this.m_SaveProject = p_SaveProject;
    }

    public boolean getSaveProject() {
        return this.m_SaveProject;
    }

    public void clearExport() {
        for (LiveShowVIP o_LiveShowVIP : this.m_VIPExportDescriptions.keySet()) {
            VIPExportDescription o_VIPExportDescription = this.m_VIPExportDescriptions.get(o_LiveShowVIP);
            o_VIPExportDescription.clearExport();
        }
    }

    public void addLiveShowVIP(LiveShowVIP p_LiveShowVIP) {
        VIPExportDescription o_VIPExportDescription;
        if (p_LiveShowVIP == null) {
            return;
        }
        if (this.m_VIPExportDescriptions.containsKey(p_LiveShowVIP)) {
            return;
        }
        Iterator<LiveShowVIP> o_LiveShowVips = this.m_VIPExportDescriptions.keySet().iterator();
        while (o_LiveShowVips.hasNext()) {
            LiveShowVIP o_LiveShowVIP = o_LiveShowVips.next();
            if (!o_LiveShowVIP.getClass().getName().equals(p_LiveShowVIP.getClass().getName())) continue;
            o_VIPExportDescription = this.m_VIPExportDescriptions.get(o_LiveShowVIP);
            if (o_VIPExportDescription != null) {
                o_VIPExportDescription.clearExport();
            }
            o_LiveShowVips.remove();
            break;
        }
        o_VIPExportDescription = new VIPExportDescription(p_LiveShowVIP);
        this.m_VIPExportDescriptions.put(p_LiveShowVIP, o_VIPExportDescription);
    }

    public int getLiveShowVIPCount() {
        return this.m_VIPExportDescriptions.size();
    }

    public LiveShowVIP getLiveShowVIP(String p_VIPType) {
        if (p_VIPType == null) {
            return null;
        }
        for (LiveShowVIP o_LiveShowVIP : this.m_VIPExportDescriptions.keySet()) {
            if (!p_VIPType.equals(o_LiveShowVIP.getType())) continue;
            return o_LiveShowVIP;
        }
        return null;
    }

    public LiveShowVIP getLiveShowVIP(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= this.m_VIPExportDescriptions.size()) {
            return null;
        }
        Iterator<LiveShowVIP> o_Iterator = this.m_VIPExportDescriptions.keySet().iterator();
        int intIndex = 0;
        while (o_Iterator.hasNext()) {
            LiveShowVIP o_LiveShowVIP = o_Iterator.next();
            if (intIndex == p_Index) {
                return o_LiveShowVIP;
            }
            ++intIndex;
        }
        return null;
    }

    public void setExportProjectAll(boolean p_Export) {
        this.m_ExportProjectAll = p_Export;
        if (this.m_ExportProjectAll) {
            // empty if block
        }
    }

    public boolean getExportProjectAll() {
        return this.m_ExportProjectAll;
    }

    public void setIncludeJingles(boolean p_IncludeJingles) {
        this.m_IncludeJingles = p_IncludeJingles;
    }

    public boolean getIncludeJingles() {
        return this.m_IncludeJingles;
    }

    public void clearLiveShowJingleObjects() {
        for (LiveShowVIP o_LiveShowVIP : this.m_VIPExportDescriptions.keySet()) {
            VIPExportDescription o_VIPExportDescription = this.m_VIPExportDescriptions.get(o_LiveShowVIP);
            o_VIPExportDescription.clearLiveShowJingleObjects();
        }
    }

    public void addLiveShowJingleObject(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowVIP == null) {
            return;
        }
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        VIPExportDescription o_VIPImportDescription = this.m_VIPExportDescriptions.get(p_LiveShowVIP);
        if (o_VIPImportDescription == null) {
            return;
        }
        o_VIPImportDescription.addLiveShowJingleObject(p_LiveShowObjectInterface);
    }

    public int getLiveShowJingleObjectCount(LiveShowVIP p_LiveShowVIP) {
        if (p_LiveShowVIP == null) {
            return 0;
        }
        VIPExportDescription o_VIPExportDescription = this.m_VIPExportDescriptions.get(p_LiveShowVIP);
        if (o_VIPExportDescription == null) {
            return 0;
        }
        return o_VIPExportDescription.getLiveShowJingleObjectCount();
    }

    public LiveShowObjectInterface getLiveShowJingleObject(LiveShowVIP p_LiveShowVIP, int p_Index) {
        if (p_LiveShowVIP == null) {
            return null;
        }
        VIPExportDescription o_VIPExportDescription = this.m_VIPExportDescriptions.get(p_LiveShowVIP);
        if (o_VIPExportDescription == null) {
            return null;
        }
        return o_VIPExportDescription.getLiveShowJingleObject(p_Index);
    }

    public void addLiveShowObject(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowVIP == null) {
            return;
        }
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        VIPExportDescription o_VIPImportDescription = this.m_VIPExportDescriptions.get(p_LiveShowVIP);
        if (o_VIPImportDescription == null) {
            return;
        }
        o_VIPImportDescription.addLiveShowObject(p_LiveShowObjectInterface);
    }

    public ArrayList<LiveShowObjectInterface> getLiveShowObjects() {
        ArrayList<LiveShowObjectInterface> o_ResultObjects = new ArrayList<LiveShowObjectInterface>();
        for (LiveShowVIP o_LiveShowVIP : this.m_VIPExportDescriptions.keySet()) {
            VIPExportDescription o_VIPExportDescription = this.m_VIPExportDescriptions.get(o_LiveShowVIP);
            for (int intObject = 0; intObject < o_VIPExportDescription.getLiveShowObjectCount(); ++intObject) {
                LiveShowObjectInterface o_LiveShowObject = o_VIPExportDescription.getLiveShowObject(intObject);
                o_ResultObjects.add(o_LiveShowObject);
            }
        }
        return o_ResultObjects;
    }

    public ArrayList<LiveShowObjectInterface> getLiveShowObjects(LiveShowVIP p_LiveShowVIP) {
        if (p_LiveShowVIP == null) {
            return null;
        }
        VIPExportDescription o_VIPImportDescription = this.m_VIPExportDescriptions.get(p_LiveShowVIP);
        if (o_VIPImportDescription == null) {
            return null;
        }
        return o_VIPImportDescription.getLiveShowObjects();
    }

    public int getLiveShowObjectCount(LiveShowVIP p_LiveShowVIP) {
        if (p_LiveShowVIP == null) {
            return 0;
        }
        VIPExportDescription o_VIPImportDescription = this.m_VIPExportDescriptions.get(p_LiveShowVIP);
        if (o_VIPImportDescription == null) {
            return 0;
        }
        return o_VIPImportDescription.getLiveShowObjectCount();
    }

    public LiveShowObjectInterface getLiveShowObject(LiveShowVIP p_LiveShowVIP, int p_Index) {
        if (p_LiveShowVIP == null) {
            return null;
        }
        VIPExportDescription o_VIPImportDescription = this.m_VIPExportDescriptions.get(p_LiveShowVIP);
        if (o_VIPImportDescription == null) {
            return null;
        }
        return o_VIPImportDescription.getLiveShowObject(p_Index);
    }

    public void addLiveShowSceneBridge(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowObjectSceneBridge) {
        if (p_LiveShowVIP == null) {
            return;
        }
        if (p_LiveShowObjectSceneBridge == null) {
            return;
        }
        VIPExportDescription o_VIPImportDescription = this.m_VIPExportDescriptions.get(p_LiveShowVIP);
        if (o_VIPImportDescription == null) {
            return;
        }
        o_VIPImportDescription.addLiveShowSceneBridge(p_LiveShowObjectSceneBridge);
    }

    public ArrayList<LiveShowSceneBridge> getLiveShowSceneBridges() {
        ArrayList<LiveShowSceneBridge> o_ResultSceneBridges = new ArrayList<LiveShowSceneBridge>();
        for (LiveShowVIP o_LiveShowVIP : this.m_VIPExportDescriptions.keySet()) {
            VIPExportDescription o_VIPExportDescription = this.m_VIPExportDescriptions.get(o_LiveShowVIP);
            for (int intSceneBridge = 0; intSceneBridge < o_VIPExportDescription.getLiveShowSceneBridgeCount(); ++intSceneBridge) {
                LiveShowSceneBridge o_LiveShowSceneBridge = o_VIPExportDescription.getLiveShowSceneBridge(intSceneBridge);
                o_ResultSceneBridges.add(o_LiveShowSceneBridge);
            }
        }
        return o_ResultSceneBridges;
    }

    public ArrayList<LiveShowSceneBridge> getLiveShowSceneBridges(LiveShowVIP p_LiveShowVIP) {
        if (p_LiveShowVIP == null) {
            return null;
        }
        VIPExportDescription o_VIPImportDescription = this.m_VIPExportDescriptions.get(p_LiveShowVIP);
        if (o_VIPImportDescription == null) {
            return null;
        }
        return o_VIPImportDescription.getLiveShowSceneBridges();
    }

    public int getLiveShowSceneBridgeCount(LiveShowVIP p_LiveShowVIP) {
        if (p_LiveShowVIP == null) {
            return 0;
        }
        VIPExportDescription o_VIPImportDescription = this.m_VIPExportDescriptions.get(p_LiveShowVIP);
        if (o_VIPImportDescription == null) {
            return 0;
        }
        return o_VIPImportDescription.getLiveShowSceneBridgeCount();
    }

    public LiveShowSceneBridge getLiveShowSceneBridge(LiveShowVIP p_LiveShowVIP, int p_Index) {
        if (p_LiveShowVIP == null) {
            return null;
        }
        VIPExportDescription o_VIPImportDescription = this.m_VIPExportDescriptions.get(p_LiveShowVIP);
        if (o_VIPImportDescription == null) {
            return null;
        }
        return o_VIPImportDescription.getLiveShowSceneBridge(p_Index);
    }

    public static class VIPExportDescription {
        private LiveShowVIP m_LiveShowVIP;
        private ArrayList<LiveShowSceneBridge> m_LiveShowSceneBridges;
        private ArrayList<LiveShowObjectInterface> m_LiveShowObjects;
        private ArrayList<LiveShowObjectInterface> m_LiveShowJingleObjects;
        private ArrayList<String> m_Sources;

        public VIPExportDescription(LiveShowVIP p_LiveShowVIP) {
            this.initMembers();
            this.m_LiveShowVIP = p_LiveShowVIP;
        }

        private void initMembers() {
            this.m_LiveShowSceneBridges = new ArrayList();
            this.m_LiveShowObjects = new ArrayList();
            this.m_LiveShowJingleObjects = new ArrayList();
        }

        public void clearExport() {
            this.m_LiveShowSceneBridges.clear();
            this.m_LiveShowObjects.clear();
        }

        public void addLiveShowObject(LiveShowObjectInterface p_LiveShowObjectInterface) {
            if (p_LiveShowObjectInterface == null) {
                return;
            }
            if (this.m_LiveShowObjects.contains(p_LiveShowObjectInterface)) {
                return;
            }
            this.m_LiveShowObjects.add(p_LiveShowObjectInterface);
        }

        public ArrayList<LiveShowObjectInterface> getLiveShowObjects() {
            return this.m_LiveShowObjects;
        }

        public int getLiveShowObjectCount() {
            return this.m_LiveShowObjects.size();
        }

        public LiveShowObjectInterface getLiveShowObject(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_LiveShowObjects.size()) {
                return null;
            }
            return this.m_LiveShowObjects.get(p_Index);
        }

        public void addLiveShowSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge) {
            if (p_LiveShowSceneBridge == null) {
                return;
            }
            if (this.m_LiveShowSceneBridges.contains(p_LiveShowSceneBridge)) {
                return;
            }
            this.m_LiveShowSceneBridges.add(p_LiveShowSceneBridge);
        }

        public ArrayList<LiveShowSceneBridge> getLiveShowSceneBridges() {
            return this.m_LiveShowSceneBridges;
        }

        public int getLiveShowSceneBridgeCount() {
            return this.m_LiveShowSceneBridges.size();
        }

        public LiveShowSceneBridge getLiveShowSceneBridge(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_LiveShowSceneBridges.size()) {
                return null;
            }
            return this.m_LiveShowSceneBridges.get(p_Index);
        }

        public void clearLiveShowJingleObjects() {
            this.m_LiveShowJingleObjects.clear();
        }

        public void addLiveShowJingleObject(LiveShowObjectInterface p_LiveShowObjectInterface) {
            if (p_LiveShowObjectInterface == null) {
                return;
            }
            if (this.m_LiveShowJingleObjects.contains(p_LiveShowObjectInterface)) {
                return;
            }
            this.m_LiveShowJingleObjects.add(p_LiveShowObjectInterface);
        }

        public ArrayList<LiveShowObjectInterface> getLiveShowJingleObjects() {
            return this.m_LiveShowJingleObjects;
        }

        public int getLiveShowJingleObjectCount() {
            return this.m_LiveShowJingleObjects.size();
        }

        public LiveShowObjectInterface getLiveShowJingleObject(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_LiveShowJingleObjects.size()) {
                return null;
            }
            return this.m_LiveShowJingleObjects.get(p_Index);
        }
    }
}

