/*
 * Decompiled with CFR 0.152.
 */
package LiveShowVirtualPackage;

import LiveShowObjectPackage.LiveShowDragDrop;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectPanel;
import LiveShowObjectPackage.LiveShowUndo;
import LiveShowScrollPackage.LiveShowViewListener;
import LiveShowVirtualPackage.LiveShowSceneBridgePanel;
import LiveShowVirtualPackage.LiveShowVIP;
import LiveShowVirtualPackage.LiveShowVIPPanel;
import LiveShowVirtualPackage.LiveShowVIPTrack;
import LiveShowVirtualPackage.LiveShowVIPTrackListener;
import SwingComponents.MouseAdapter_Delayed;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.LiveCloseSemaphore;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GrayFilter;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class LiveShowVIPTrackPanel
extends JPanel
implements LiveShowVIPTrackListener,
LiveShowViewListener,
ComponentListener,
DragSourceListener,
DropTargetListener,
DragGestureListener,
LiveShowDragDrop.DropListener {
    private LiveShowVIPPanel m_LiveShowVIPPanel;
    private LiveShowVIPTrack m_LiveShowVIPTrack;
    private AbsoluteConstraints m_AbsoluteConstraints;
    private ArrayList<LiveShowObjectPanel> m_LiveShowObjectPanels;
    private ArrayList<LiveShowViewListener> m_LiveShowViewListeners;
    private LiveShowObjectPanel m_ActorObjectPanel;
    private DragSource m_DragSource;
    private DropTarget m_DropTarget;
    protected LiveShowDragDrop.LiveShowTransferable.LiveShowTransferData m_ActualTransferData;
    private LiveCloseSemaphore m_LiveCloseSemaphore;
    private final Object m_SyncObjects = new Object();
    private final Object m_SyncViewListeners = new Object();
    private int m_OldMousePositionX;
    private long m_MouseFramePositionInside;
    private Dimension m_OldSize;
    private MouseAdapter_Delayed m_MouseAdapter_Delayed;
    private Rectangle m_ExternalMouseBounds;
    private boolean m_ExternalMouseInside;
    private Integer m_ExternalMouseLastX;
    private Integer m_ExternalMouseLastY;
    private LiveShowVIPTrackPanel m_SelfReference;
    private Image m_BackgroundImage;

    public LiveShowVIPTrackPanel(LiveShowVIPPanel p_LiveShowVIPPanel, LiveShowVIPTrack p_LiveShowVIPTrack) {
        this.initMembers();
        this.m_SelfReference = this;
        this.m_LiveShowVIPPanel = p_LiveShowVIPPanel;
        this.m_LiveShowVIPTrack = p_LiveShowVIPTrack;
        GrayFilter filter = new GrayFilter(true, 20);
        FilteredImageSource prod = new FilteredImageSource(this.m_LiveShowVIPTrack.getLiveShowVIP().getImageIcon().getImage().getSource(), filter);
        this.m_BackgroundImage = Toolkit.getDefaultToolkit().createImage(prod);
        this.initComponents();
        this.m_LiveShowVIPTrack.addLiveShowVIPTrackListener(this);
        for (int intObject = 0; intObject < this.m_LiveShowVIPTrack.getLiveShowObjectInterfaceCount(); ++intObject) {
            LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowVIPTrack.getLiveShowObjectInterface(intObject);
            this.eventVIPTrackObjectInterfaceAdded(this.m_LiveShowVIPTrack, o_LiveShowObjectInterface);
        }
    }

    private void initMembers() {
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_OldSize = new Dimension(0, 0);
        this.m_LiveShowObjectPanels = new ArrayList();
        this.m_LiveShowViewListeners = new ArrayList();
        this.m_ActorObjectPanel = null;
        this.m_OldMousePositionX = 0;
        LiveShowDragDrop.addDropListener(this);
        this.m_ExternalMouseBounds = new Rectangle();
        this.m_ExternalMouseInside = false;
        this.m_ExternalMouseLastX = null;
        this.m_ExternalMouseLastY = null;
    }

    private void initComponents() {
        this.createMouseAdapter_Delayed();
        this.setLayout(new AbsoluteLayout());
        this.setDoubleBuffered(false);
        this.m_AbsoluteConstraints = new AbsoluteConstraints(0, 0, 0, 0);
        this.setBackground(Color.DARK_GRAY);
        this.setBorder(new LineBorder(Color.BLACK, 1));
        this.addComponentListener(this);
        this.addMouseListener(this.m_MouseAdapter_Delayed);
        this.addMouseMotionListener(this.m_MouseAdapter_Delayed);
        this.m_DragSource = new DragSource();
        this.m_DropTarget = new DropTarget(this, 2, this, true, this.m_LiveShowVIPTrack.getDataFlavorMap());
        this.m_LiveShowVIPPanel.addLiveShowViewListener(this);
        this.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIPPanel.getLiveShowVIP();
        if (o_LiveShowVIP != null) {
            this.setToolTipText(o_LiveShowVIP.getType());
        }
        MouseAdapter o_MouseAdapter = new MouseAdapter(){
            private ArrayList<LiveShowObjectPanel> o_LiveShowObjectPanels = new ArrayList();

            @Override
            public void mouseDragged(MouseEvent e) {
                LiveShowVIPPanel o_LiveShowVIPPanel = LiveShowVIPTrackPanel.this.getLiveShowVIPPanel();
                if (o_LiveShowVIPPanel == null) {
                    return;
                }
                LiveShowVIP o_LiveShowVIP = o_LiveShowVIPPanel.getLiveShowVIP();
                if (o_LiveShowVIP == null) {
                    return;
                }
                if (LiveShowVIPTrackPanel.this.m_ExternalMouseLastX == null) {
                    LiveShowVIPTrackPanel.this.m_ExternalMouseLastX = e.getX();
                    LiveShowVIPTrackPanel.this.m_ExternalMouseLastY = e.getY();
                }
                o_LiveShowVIP.externalMouseDrag(true, o_LiveShowVIPPanel, LiveShowVIPTrackPanel.this.m_SelfReference, LiveShowVIPTrackPanel.this.m_ExternalMouseLastX, LiveShowVIPTrackPanel.this.m_ExternalMouseLastY, e.getX(), e.getY());
                LiveShowVIPTrackPanel.this.m_ExternalMouseLastX = e.getX();
                LiveShowVIPTrackPanel.this.m_ExternalMouseLastY = e.getY();
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                LiveShowVIPPanel o_LiveShowVIPPanel = LiveShowVIPTrackPanel.this.getLiveShowVIPPanel();
                if (o_LiveShowVIPPanel == null) {
                    return;
                }
                LiveShowVIP o_LiveShowVIP = o_LiveShowVIPPanel.getLiveShowVIP();
                if (o_LiveShowVIP == null) {
                    return;
                }
                LiveShowVIPTrackPanel.this.m_ExternalMouseLastX = null;
                LiveShowVIPTrackPanel.this.m_ExternalMouseLastY = null;
                o_LiveShowVIP.externalMouseReleased(true, o_LiveShowVIPPanel, LiveShowVIPTrackPanel.this.m_SelfReference, e.getX(), e.getY());
            }
        };
        this.addMouseListener(o_MouseAdapter);
        this.addMouseMotionListener(o_MouseAdapter);
        this.setOpaque(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        LiveShowDragDrop.removeDropListener(this);
        this.setComponentPopupMenu(null);
        this.removeComponentListener(this);
        this.removeMouseListener(this.m_MouseAdapter_Delayed);
        this.removeMouseMotionListener(this.m_MouseAdapter_Delayed);
        if (this.m_LiveShowVIPPanel != null) {
            this.m_LiveShowVIPPanel.removeLiveShowViewListener(this);
        }
        if (this.m_LiveShowVIPTrack != null) {
            this.m_LiveShowVIPTrack.removeLiveShowVIPTrackListener(this);
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (this.m_LiveShowObjectPanels != null) {
                int intLiveShowObjectPanelCount = this.m_LiveShowObjectPanels.size();
                for (int intObjectPanel = intLiveShowObjectPanelCount - 1; intObjectPanel >= 0; --intObjectPanel) {
                    LiveShowObjectPanel o_LiveShowObjectPanel = this.m_LiveShowObjectPanels.get(intObjectPanel);
                    this.m_LiveShowObjectPanels.remove(intObjectPanel);
                    if (o_LiveShowObjectPanel == null) continue;
                    o_LiveShowObjectPanel.close();
                }
                this.m_LiveShowObjectPanels = null;
            }
        }
        this.m_LiveCloseSemaphore.leaveCloseSection();
    }

    public AbsoluteConstraints getAbsoluteConstraints() {
        return this.m_AbsoluteConstraints;
    }

    public LiveShowVIP getLiveShowVIP() {
        LiveShowVIP o_LiveShowVIP = null;
        LiveShowVIPPanel o_LiveShowVIPPanel = this.getLiveShowVIPPanel();
        if (o_LiveShowVIPPanel != null) {
            o_LiveShowVIP = o_LiveShowVIPPanel.getLiveShowVIP();
        }
        return o_LiveShowVIP;
    }

    public LiveShowVIPPanel getLiveShowVIPPanel() {
        return this.m_LiveShowVIPPanel;
    }

    public LiveShowVIPTrack getLiveShowVIPTrack() {
        return this.m_LiveShowVIPTrack;
    }

    @Override
    public void paintComponent(Graphics p_Graphics) {
        super.paintComponent(p_Graphics);
        this.paintBackground(p_Graphics);
    }

    public void paintBackground(Graphics p_Graphics) {
        Color o_Color = p_Graphics.getColor();
        p_Graphics.setColor(this.getBackground());
        p_Graphics.drawRect(this.m_AbsoluteConstraints.x, this.m_AbsoluteConstraints.y, this.m_AbsoluteConstraints.width, this.m_AbsoluteConstraints.height);
        if (this.m_BackgroundImage != null) {
            p_Graphics.drawImage(this.m_BackgroundImage, 10, this.m_AbsoluteConstraints.height / 2 - 16, 32, 32, this);
        }
        p_Graphics.setColor(o_Color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventVIPTrackObjectInterfaceAdded(LiveShowVIPTrack p_LiveShowVIPTrack, LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            LiveShowObjectPanel o_LiveShowObjectPanel = p_LiveShowObjectInterface.createLiveShowObjectPanel(true);
            this.m_LiveShowObjectPanels.add(o_LiveShowObjectPanel);
            this.addLiveShowViewListener(o_LiveShowObjectPanel);
            o_LiveShowObjectPanel.eventViewChanged(this.m_LiveShowVIPPanel.getFrameStart(), this.m_LiveShowVIPPanel.getFrameEnd(), this.m_LiveShowVIPPanel.getVisibleFrameStart(), this.m_LiveShowVIPPanel.getVisibleFrameEnd(), this.getBounds());
            o_LiveShowObjectPanel.setVisible(true);
            this.add(o_LiveShowObjectPanel, o_LiveShowObjectPanel.getAbsoluteConstraints(), 0);
            o_LiveShowObjectPanel.addMouseListener(this.m_MouseAdapter_Delayed);
            o_LiveShowObjectPanel.addMouseMotionListener(this.m_MouseAdapter_Delayed);
            o_LiveShowObjectPanel.setGestureRecognizer(new LiveShowDragDrop.LiveShowGestureRecognizer(this.m_DragSource, o_LiveShowObjectPanel, 2, this, 0));
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        this.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventVIPTrackObjectInterfaceRemoved(LiveShowVIPTrack p_LiveShowVIPTrack, LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            int intObjectPanelCount = this.m_LiveShowObjectPanels.size();
            for (int intObject = 0; intObject < intObjectPanelCount; ++intObject) {
                LiveShowObjectPanel o_LiveShowObjectPanel = this.m_LiveShowObjectPanels.get(intObject);
                if (o_LiveShowObjectPanel == null || o_LiveShowObjectPanel.getLiveShowObjectInterface() != p_LiveShowObjectInterface) continue;
                o_LiveShowObjectPanel.setVisible(false);
                this.remove(o_LiveShowObjectPanel);
                this.removeLiveShowViewListener(o_LiveShowObjectPanel);
                o_LiveShowObjectPanel.removeGestureRecognizer();
                o_LiveShowObjectPanel.removeMouseListener(this.m_MouseAdapter_Delayed);
                o_LiveShowObjectPanel.removeMouseMotionListener(this.m_MouseAdapter_Delayed);
                o_LiveShowObjectPanel.close();
                this.m_LiveShowObjectPanels.remove(o_LiveShowObjectPanel);
                break;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        this.revalidate();
    }

    public int getLiveShowOBjectPanelCount() {
        return this.m_LiveShowObjectPanels.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowObjectPanel getLiveShowObjectPanel(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (p_Index >= this.m_LiveShowObjectPanels.size()) {
                return null;
            }
            return this.m_LiveShowObjectPanels.get(p_Index);
        }
    }

    public boolean externalMouseEnter(int p_X, int p_Y) {
        this.m_ExternalMouseBounds = this.getBounds(this.m_ExternalMouseBounds);
        if (p_X > this.m_AbsoluteConstraints.x && p_X < this.m_AbsoluteConstraints.x + this.m_ExternalMouseBounds.width && p_Y > this.m_AbsoluteConstraints.y && p_Y < this.m_AbsoluteConstraints.y + this.m_ExternalMouseBounds.height) {
            if (this.m_ExternalMouseInside) {
                return false;
            }
            this.m_ExternalMouseInside = true;
            return true;
        }
        this.m_ExternalMouseInside = false;
        return false;
    }

    public void externalMouseExit(int p_X, int p_Y) {
        this.m_ExternalMouseInside = false;
    }

    @Override
    public void eventVIPTrackObjectParamChanged(LiveShowVIPTrack p_LiveShowVIPTrack, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPTrackClosing(LiveShowVIPTrack p_LiveShowVIPTrack) {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLiveShowViewListener(LiveShowViewListener p_Listener) {
        if (p_Listener == null) {
            return false;
        }
        boolean boolAdded = false;
        Object object = this.m_SyncViewListeners;
        synchronized (object) {
            if (this.m_LiveShowViewListeners != null && !this.m_LiveShowViewListeners.contains(p_Listener)) {
                this.m_LiveShowViewListeners.add(p_Listener);
                boolAdded = true;
            }
        }
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLiveShowViewListener(LiveShowViewListener p_Listener) {
        if (p_Listener == null) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncViewListeners;
        synchronized (object) {
            if (this.m_LiveShowViewListeners != null) {
                boolRemoved = this.m_LiveShowViewListeners.remove(p_Listener);
            }
        }
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyViewListeners_ViewChanged(long p_FrameStart, long p_FrameEnd, long p_VisibleFrameStart, long p_VisibleFrameEnd, Rectangle p_Bounds) {
        ArrayList<LiveShowViewListener> o_LiveShowViewListeners;
        Object object = this.m_SyncViewListeners;
        synchronized (object) {
            if (this.m_LiveShowViewListeners == null) {
                return;
            }
            if (this.m_LiveShowViewListeners.size() <= 0) {
                return;
            }
            o_LiveShowViewListeners = new ArrayList<LiveShowViewListener>(this.m_LiveShowViewListeners);
            o_LiveShowViewListeners.addAll(this.m_LiveShowViewListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowViewListeners.size(); ++intListener) {
            LiveShowViewListener o_Listener = o_LiveShowViewListeners.get(intListener);
            o_Listener.eventViewChanged(p_FrameStart, p_FrameEnd, p_VisibleFrameStart, p_VisibleFrameEnd, p_Bounds);
        }
        o_LiveShowViewListeners.clear();
    }

    @Override
    public void eventViewChanged(long p_FrameStart, long p_FrameEnd, long p_VisibleFrameStart, long p_VisibleFrameEnd, Rectangle p_Bounds) {
        this.notifyViewListeners_ViewChanged(p_FrameStart, p_FrameEnd, this.m_LiveShowVIPPanel.getVisibleFrameStart(), this.m_LiveShowVIPPanel.getVisibleFrameEnd(), this.getBounds());
    }

    @Override
    public void eventViewScrollAutomaticStart() {
    }

    @Override
    public void eventZoomPlus(boolean p_AdjustFramePosition, long p_FramePosition) {
    }

    @Override
    public void eventZoomMinus(boolean p_AdjustFramePosition, long p_FramePosition) {
    }

    @Override
    public void eventZoomReset() {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.getWidth() == this.m_OldSize.width && this.getHeight() == this.m_OldSize.height) {
            return;
        }
        this.m_OldSize.setSize(this.getWidth(), this.getHeight());
        this.notifyViewListeners_ViewChanged(this.m_LiveShowVIPPanel.getFrameStart(), this.m_LiveShowVIPPanel.getFrameEnd(), this.m_LiveShowVIPPanel.getVisibleFrameStart(), this.m_LiveShowVIPPanel.getVisibleFrameEnd(), this.getBounds());
        this.m_LiveShowVIPPanel.revalidate();
        if (!SwingUtilities.isEventDispatchThread()) {
            System.out.println(this.getClass().getName() + "componentResized");
        }
        this.m_LiveShowVIPPanel.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public LiveShowObjectPanel getMouseActiveObjectPanel(int p_X, int p_Y) {
        Component o_Component = this.getComponentAt(p_X, p_Y);
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIPPanel.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return null;
        }
        if (o_Component != null) {
            if (o_LiveShowVIP.getMouseCursorMode(p_X, p_Y, o_Component) != 2) {
                return null;
            }
            if (o_Component instanceof LiveShowObjectInterface) {
                return (LiveShowObjectPanel)o_Component;
            }
        }
        return null;
    }

    private void createMouseAdapter_Delayed() {
        this.m_MouseAdapter_Delayed = new MouseAdapter_Delayed(){

            @Override
            public void mouseClicked_Delayed(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                int intX = e.getX();
                int intY = e.getY();
                LiveShowObjectPanel o_LiveShowObjectPanel = null;
                LiveShowObjectInterface o_LiveShowObjectInterface = null;
                LiveShowVIP o_LiveShowVIP = LiveShowVIPTrackPanel.this.m_LiveShowVIPPanel.getLiveShowVIP();
                if (o_LiveShowVIP == null) {
                    return;
                }
                if (e.getComponent() instanceof LiveShowObjectPanel) {
                    o_LiveShowObjectPanel = (LiveShowObjectPanel)e.getSource();
                    intX += e.getComponent().getX();
                    o_LiveShowObjectInterface = o_LiveShowObjectPanel.getLiveShowObjectInterface();
                    if (e.getClickCount() > 1) {
                        o_LiveShowVIP.notifyLiveShowVIPListeners_ShowObjectSettings(o_LiveShowObjectInterface);
                        return;
                    }
                } else if (e.getComponent() instanceof LiveShowSceneBridgePanel) {
                    LiveShowSceneBridgePanel o_LiveShowSceneBridgePanel = (LiveShowSceneBridgePanel)e.getSource();
                    intX += e.getComponent().getX();
                    o_LiveShowObjectInterface = o_LiveShowSceneBridgePanel.getLiveShowSceneBridge();
                    if (e.getClickCount() > 1) {
                        o_LiveShowVIP.notifyLiveShowVIPListeners_ShowObjectSettings(o_LiveShowObjectInterface);
                        return;
                    }
                }
                long longFramePosition = LiveShowVIPTrackPanel.this.m_LiveShowVIPPanel.getPositionFrame(intX);
                switch (o_LiveShowVIP.getMouseCursorMode(intX, intY, e.getComponent())) {
                    case 1: {
                        if (e.isAltDown() && (e.isShiftDown() || e.isControlDown())) {
                            if (!o_LiveShowObjectInterface.getSelected()) {
                                o_LiveShowVIP.selectObjectsFromPosition(o_LiveShowObjectInterface.getFrameStart(), true);
                                break;
                            }
                            o_LiveShowVIP.removeObjectsFromPositionToSelection(o_LiveShowObjectInterface.getFrameStart(), true);
                            break;
                        }
                        if (e.isAltDown() || e.isShiftDown() || e.isControlDown()) break;
                        if (o_LiveShowVIP.getPlay().getEditModeOn()) {
                            o_LiveShowVIP.getPlay().setEditCursor(longFramePosition);
                            o_LiveShowVIP.getPlay().playFramePositionOnce(longFramePosition);
                            break;
                        }
                        o_LiveShowVIP.getPlay().setPlayCursor(longFramePosition);
                        LiveShowVIPTrackPanel.this.m_LiveShowVIPPanel.calculatePlayCursor(longFramePosition);
                        o_LiveShowVIP.getPlay().playFramePositionOnce(longFramePosition);
                        break;
                    }
                    case 2: {
                        if (o_LiveShowObjectInterface == null) break;
                        if (e.isAltDown() && (e.isShiftDown() || e.isControlDown())) {
                            if (!o_LiveShowObjectInterface.getSelected()) {
                                o_LiveShowVIP.selectObjectsFromPosition(o_LiveShowObjectInterface.getFrameStart(), true);
                                break;
                            }
                            o_LiveShowVIP.removeObjectsFromPositionToSelection(o_LiveShowObjectInterface.getFrameStart(), true);
                            break;
                        }
                        if (!e.isAltDown() && (e.isShiftDown() || e.isControlDown())) {
                            if (!o_LiveShowObjectPanel.getSelected()) {
                                o_LiveShowVIP.addSelectedObject(o_LiveShowObjectInterface);
                                break;
                            }
                            o_LiveShowVIP.removeSelectedObject(o_LiveShowObjectInterface);
                            break;
                        }
                        if (e.isAltDown() || e.isShiftDown() || e.isControlDown()) break;
                        o_LiveShowVIP.setSelectedObject(o_LiveShowObjectInterface);
                        break;
                    }
                    case 3: {
                        if (o_LiveShowObjectInterface == null) break;
                        if (e.isAltDown() && (e.isShiftDown() || e.isControlDown())) {
                            if (!o_LiveShowObjectInterface.getSelected()) {
                                o_LiveShowVIP.selectObjectsFromPosition(o_LiveShowObjectInterface.getFrameStart(), true);
                                break;
                            }
                            o_LiveShowVIP.removeObjectsFromPositionToSelection(o_LiveShowObjectInterface.getFrameStart(), true);
                            break;
                        }
                        if (o_LiveShowObjectPanel.getSelected()) break;
                        o_LiveShowVIP.addSelectedObject(o_LiveShowObjectInterface);
                        break;
                    }
                    case 4: {
                        if (o_LiveShowObjectInterface == null) break;
                        if (e.isAltDown() && (e.isShiftDown() || e.isControlDown())) {
                            if (!o_LiveShowObjectInterface.getSelected()) {
                                o_LiveShowVIP.selectObjectsFromPosition(o_LiveShowObjectInterface.getFrameStart(), true);
                                break;
                            }
                            o_LiveShowVIP.removeObjectsFromPositionToSelection(o_LiveShowObjectInterface.getFrameStart(), true);
                            break;
                        }
                        if (!o_LiveShowObjectPanel.getSelected()) break;
                        o_LiveShowVIP.removeSelectedObject(o_LiveShowObjectInterface);
                        break;
                    }
                    case 5: {
                        if (o_LiveShowObjectInterface == null) break;
                        if (e.isAltDown() && (e.isShiftDown() || e.isControlDown())) {
                            if (!o_LiveShowObjectInterface.getSelected()) {
                                o_LiveShowVIP.selectObjectsFromPosition(o_LiveShowObjectInterface.getFrameStart(), true);
                                break;
                            }
                            o_LiveShowVIP.removeObjectsFromPositionToSelection(o_LiveShowObjectInterface.getFrameStart(), true);
                            break;
                        }
                        o_LiveShowVIP.selectObjectsFromPosition(o_LiveShowObjectInterface.getFrameStart(), true);
                        break;
                    }
                    case 6: {
                        if (o_LiveShowObjectInterface == null) break;
                        if (e.isAltDown() && (e.isShiftDown() || e.isControlDown())) {
                            if (!o_LiveShowObjectInterface.getSelected()) {
                                o_LiveShowVIP.selectObjectsFromPosition(o_LiveShowObjectInterface.getFrameStart(), true);
                                break;
                            }
                            o_LiveShowVIP.removeObjectsFromPositionToSelection(o_LiveShowObjectInterface.getFrameStart(), true);
                            break;
                        }
                        o_LiveShowVIP.addObjectsFromPositionToSelection(o_LiveShowObjectInterface.getFrameStart(), true);
                        break;
                    }
                    case 7: {
                        if (o_LiveShowObjectInterface == null) break;
                        if (e.isAltDown() && (e.isShiftDown() || e.isControlDown())) {
                            if (!o_LiveShowObjectInterface.getSelected()) {
                                o_LiveShowVIP.selectObjectsFromPosition(o_LiveShowObjectInterface.getFrameStart(), true);
                                break;
                            }
                            o_LiveShowVIP.removeObjectsFromPositionToSelection(o_LiveShowObjectInterface.getFrameStart(), true);
                            break;
                        }
                        o_LiveShowVIP.removeObjectsFromPositionToSelection(o_LiveShowObjectInterface.getFrameStart(), true);
                        break;
                    }
                    case 8: {
                        LiveShowVIPTrackPanel.this.m_LiveShowVIPPanel.zoomPlus(false, longFramePosition);
                        break;
                    }
                    case 9: {
                        LiveShowVIPTrackPanel.this.m_LiveShowVIPPanel.zoomMinus(false, longFramePosition);
                    }
                }
            }

            @Override
            public void mousePressed_Delayed(MouseEvent e) {
                LiveShowVIPTrackPanel.this.m_OldMousePositionX = e.getX();
                if (e.getComponent() instanceof LiveShowObjectPanel) {
                    LiveShowVIPTrackPanel.this.m_MouseFramePositionInside = LiveShowVIPTrackPanel.this.m_LiveShowVIPPanel.getPositionFrame(LiveShowVIPTrackPanel.this.m_OldMousePositionX) - LiveShowVIPTrackPanel.this.m_LiveShowVIPPanel.getVisibleFrameStart();
                } else {
                    LiveShowVIPTrackPanel.this.m_MouseFramePositionInside = 0L;
                }
                if (e.isConsumed()) {
                    return;
                }
                int intX = e.getX();
                if (e.getComponent() instanceof LiveShowObjectPanel && LiveShowVIPTrackPanel.this.m_ActorObjectPanel == null) {
                    LiveShowVIPTrackPanel.this.m_ActorObjectPanel = (LiveShowObjectPanel)e.getComponent();
                    long longFramePosition = LiveShowVIPTrackPanel.this.m_ActorObjectPanel.getPositionFrame(intX) - LiveShowVIPTrackPanel.this.m_ActorObjectPanel.getLiveShowObjectInterface().getFrameStartOffset();
                    LiveShowVIPTrackPanel.this.m_ActorObjectPanel.getLiveShowObjectInterface().setMouseFramePositionInside(longFramePosition);
                }
            }

            @Override
            public void mouseReleased_Delayed(MouseEvent e) {
                LiveShowVIPTrackPanel.this.m_OldMousePositionX = 0;
                if (e.isConsumed()) {
                    return;
                }
                LiveShowVIPTrackPanel.this.m_ActorObjectPanel = null;
                if (e.getComponent() instanceof LiveShowObjectPanel) {
                    if (LiveShowVIPTrackPanel.this.m_LiveShowVIPPanel == null) {
                        return;
                    }
                    LiveShowVIPTrackPanel.this.m_LiveShowVIPPanel.stopScrollAutomatic();
                    LiveShowVIP o_LiveShowVIP = LiveShowVIPTrackPanel.this.m_LiveShowVIPPanel.getLiveShowVIP();
                    if (o_LiveShowVIP == null) {
                        return;
                    }
                    LiveShowUndo o_LiveShowUndo = o_LiveShowVIP.getLiveShowUndo();
                    if (o_LiveShowUndo == null) {
                        return;
                    }
                    if (!o_LiveShowUndo.checkEndAction(13)) {
                        return;
                    }
                    o_LiveShowVIP.endUndoAction(13, true, (LiveShowVIP.LiveShowVIPStatus)o_LiveShowVIP.getStatusSelected_ForEndAction());
                }
            }

            @Override
            public void mouseEntered_Delayed(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
            }

            @Override
            public void mouseExited_Delayed(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
            }

            @Override
            public void mouseDragged_Delayed(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                int intX = e.getX();
                if (intX == LiveShowVIPTrackPanel.this.m_OldMousePositionX) {
                    return;
                }
                this.sleep(20L);
                if (e.getComponent() instanceof LiveShowObjectPanel) {
                    if (LiveShowVIPTrackPanel.this.m_ActorObjectPanel == null) {
                        LiveShowVIPTrackPanel.this.m_ActorObjectPanel = (LiveShowObjectPanel)e.getComponent();
                    }
                    if (LiveShowVIPTrackPanel.this.m_ActorObjectPanel == null || !LiveShowVIPTrackPanel.this.m_ActorObjectPanel.getSelected()) {
                        return;
                    }
                    long longFramePositionX = LiveShowVIPTrackPanel.this.m_LiveShowVIPPanel.getPositionFrame(intX);
                    long longOldFramePosition = LiveShowVIPTrackPanel.this.m_ActorObjectPanel.getLiveShowObjectInterface().getFrameStart();
                    long longNewFramePosition = LiveShowVIPTrackPanel.this.m_ActorObjectPanel.getLiveShowObjectInterface().getFrameStart() + longFramePositionX - LiveShowVIPTrackPanel.this.m_LiveShowVIPPanel.getPositionFrame(LiveShowVIPTrackPanel.this.m_OldMousePositionX);
                    LiveShowVIP o_LiveShowVIP = LiveShowVIPTrackPanel.this.m_LiveShowVIPPanel.getLiveShowVIP();
                    if (o_LiveShowVIP == null) {
                        return;
                    }
                    LiveShowVIP.LiveShowVIPStatus o_LiveShowVIPStatus = (LiveShowVIP.LiveShowVIPStatus)o_LiveShowVIP.getStatusSelected_ForStartAction();
                    if (!LiveShowVIPTrackPanel.this.m_LiveShowVIPPanel.checkScroll(99, false, longOldFramePosition, longNewFramePosition, LiveShowVIPTrackPanel.this.m_MouseFramePositionInside, LiveShowVIPTrackPanel.this.m_ActorObjectPanel.getLiveShowObjectInterface(), LiveShowVIPTrackPanel.this.m_ActorObjectPanel.getLiveShowObjectInterface().getDescription(), o_LiveShowVIPStatus)) {
                        o_LiveShowVIP.doActionMoveObjects(longNewFramePosition, LiveShowVIPTrackPanel.this.m_ActorObjectPanel.getLiveShowObjectInterface().getDescription(), o_LiveShowVIPStatus);
                    }
                }
            }

            @Override
            public void mouseMoved_Delayed(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                int intX = e.getX();
                int intY = e.getY();
                LiveShowVIP o_LiveShowVIP = LiveShowVIPTrackPanel.this.m_LiveShowVIPPanel.getLiveShowVIP();
                if (o_LiveShowVIP == null) {
                    return;
                }
                if (e.getComponent() instanceof LiveShowObjectPanel) {
                    LiveShowVIPTrackPanel.this.setCursor(((LiveShowObjectPanel)e.getComponent()).getCursor(intX, intY));
                } else {
                    LiveShowVIPTrackPanel.this.setCursor(LiveShowVIPTrackPanel.this.getCursor(intX, intY));
                }
            }
        };
    }

    public Cursor getCursor(int intX, int intY) {
        LiveShowVIP o_LiveShowVIP = this.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return Cursor.getDefaultCursor();
        }
        switch (o_LiveShowVIP.getMouseCursorMode(intX, intY, this)) {
            case 1: {
                return LiveShowVIP.CURSOR_PLAYCURSOR;
            }
            case 2: {
                return LiveShowVIP.CURSOR_SELECTOBJECT;
            }
            case 3: {
                return LiveShowVIP.CURSOR_SELECTPLUS;
            }
            case 4: {
                return LiveShowVIP.CURSOR_SELECTMINUS;
            }
            case 5: {
                return LiveShowVIP.CURSOR_SELECTFROM;
            }
            case 6: {
                return LiveShowVIP.CURSOR_SELECTFROMPLUS;
            }
            case 7: {
                return LiveShowVIP.CURSOR_SELECTFROMMINUS;
            }
            case 8: {
                return LiveShowVIP.CURSOR_ZOOMPLUS;
            }
            case 9: {
                return LiveShowVIP.CURSOR_ZOOMMINUS;
            }
        }
        return Cursor.getDefaultCursor();
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.m_ActorObjectPanel = null;
        this.m_DropTarget.setActive(true);
        LiveShowDragDrop.LiveShowTransferable.LiveShowTransferData o_TransferData = null;
        try {
            DragSourceContext o_DragSourceContext = dsde.getDragSourceContext();
            if (o_DragSourceContext != null) {
                o_TransferData = (LiveShowDragDrop.LiveShowTransferable.LiveShowTransferData)o_DragSourceContext.getTransferable().getTransferData(this.m_LiveShowVIPTrack.getDataFlavor());
                this.m_LiveShowVIPTrack.getLiveShowVIP().getSelectedObjectDescriptions();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean boolSuccess = dsde.getDropSuccess();
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIPPanel.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return;
        }
        o_LiveShowVIP.endActionDrag(boolSuccess, o_TransferData.getLiveShowVIPStatus());
        if (!boolSuccess) {
            LiveShowDragDrop.notifyDropCancelled();
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        if (this.m_LiveShowVIPPanel == null) {
            return;
        }
        Point pointDragOrigin = dge.getDragOrigin();
        if (this.m_ActorObjectPanel == null) {
            this.m_ActorObjectPanel = this.getMouseActiveObjectPanel(pointDragOrigin.x, pointDragOrigin.y);
        }
        if (this.m_ActorObjectPanel == null || !this.m_ActorObjectPanel.getSelected()) {
            return;
        }
        long longFramePosition = this.m_LiveShowVIPPanel.getPositionFrame(dge.getComponent().getX());
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIPPanel.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return;
        }
        int intActualTrackIndex = o_LiveShowVIP.getLiveShowVIPTrackNumber(this.m_LiveShowVIPTrack);
        boolean boolDragOK = true;
        LiveShowVIPTrack o_VIPTrackTarget = pointDragOrigin.y <= 0 ? o_LiveShowVIP.getLiveShowVIPTrack(intActualTrackIndex - 1) : o_LiveShowVIP.getLiveShowVIPTrack(intActualTrackIndex + 1);
        if (o_VIPTrackTarget == null) {
            return;
        }
        LiveShowVIP.LiveShowVIPStatus o_LiveShowVIPStatus = (LiveShowVIP.LiveShowVIPStatus)o_LiveShowVIP.getStatusSelected_ForStartAction();
        if (o_LiveShowVIPStatus == null) {
            return;
        }
        boolDragOK = o_LiveShowVIP.actionCheckDragStart(o_VIPTrackTarget, longFramePosition, this.m_ActorObjectPanel.getLiveShowObjectInterface().getDescription(), o_LiveShowVIPStatus);
        if (!boolDragOK) {
            return;
        }
        this.m_LiveShowVIPPanel.stopScrollAutomatic();
        LiveShowDragDrop.LiveShowTransferable o_Transferable = new LiveShowDragDrop.LiveShowTransferable(this.m_ActorObjectPanel.getLiveShowObjectInterface(), o_LiveShowVIPStatus, this.m_LiveShowVIPTrack.getDataFlavor());
        LiveShowDragDrop.setSource(this.m_LiveShowVIPPanel);
        dge.startDrag(null, o_Transferable, this);
        if (dge.getDragAction() == 2) {
            this.m_MouseAdapter_Delayed.clearMouseEventDelegate();
            o_LiveShowVIP.doActionDragMove(this.m_LiveShowVIPTrack, longFramePosition, o_Transferable.getTransferData());
        } else if (dge.getDragAction() == 1) {
            this.m_MouseAdapter_Delayed.clearMouseEventDelegate();
            o_LiveShowVIP.doActionDragCopy(this.m_LiveShowVIPTrack, longFramePosition, o_Transferable.getTransferData());
        }
        if (o_Transferable != null) {
            // empty if block
        }
    }

    public void actionDragRemove(LiveShowVIP.LiveShowVIPStatus p_LiveShowVIPStatus) {
        if (p_LiveShowVIPStatus == null) {
            return;
        }
        boolean boolRemoved = false;
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIPPanel.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return;
        }
        for (int intVIP = 0; intVIP < p_LiveShowVIPStatus.getLiveShowVIPCount(); ++intVIP) {
            LiveShowUndo o_LiveShowUndo;
            ArrayList<LiveShowObjectDescription> o_Status_ObjectDescriptions = p_LiveShowVIPStatus.getLiveShowObjectDescriptions(intVIP);
            if (o_Status_ObjectDescriptions == null) continue;
            for (int intObject = 0; intObject < o_Status_ObjectDescriptions.size(); ++intObject) {
                LiveShowObjectInterface o_LiveShowObjectInterface;
                LiveShowObjectDescription o_Status_ObjectDescription = o_Status_ObjectDescriptions.get(intObject);
                if (o_Status_ObjectDescription == null || (o_LiveShowObjectInterface = o_LiveShowVIP.findLiveShowObjectInterface(o_Status_ObjectDescription.getID())) == null) continue;
                o_LiveShowObjectInterface.close(true);
                boolRemoved = true;
            }
            if (!boolRemoved || (o_LiveShowUndo = o_LiveShowVIP.getLiveShowUndo()) == null) continue;
            o_LiveShowUndo.endAction(false, 26, o_LiveShowVIP, null);
        }
        this.revalidate();
    }

    @Override
    public void eventDropCancelled(Object p_Source) {
        if (this.m_ActualTransferData == null) {
            return;
        }
        if (p_Source != this.m_LiveShowVIPPanel && p_Source != null) {
            this.actionDragRemove(this.m_ActualTransferData.getLiveShowVIPStatus());
        }
        this.m_ActualTransferData.close();
        this.m_ActualTransferData = null;
    }

    @Override
    public void eventDroppedAt(Object p_Target, Object p_Source) {
        if (this.m_ActualTransferData == null) {
            return;
        }
        if (p_Target != this.m_LiveShowVIPPanel && p_Source != this.m_LiveShowVIPPanel) {
            this.actionDragRemove(this.m_ActualTransferData.getLiveShowVIPStatus());
        }
        this.m_ActualTransferData.close();
        this.m_ActualTransferData = null;
    }

    @Override
    public void eventDragEnterAt(Object p_Target, Object p_Source) {
        if (this.m_ActualTransferData == null) {
            return;
        }
        if (p_Target != this.m_LiveShowVIPPanel && p_Source != this.m_LiveShowVIPPanel) {
            this.actionDragRemove(this.m_ActualTransferData.getLiveShowVIPStatus());
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        LiveShowDragDrop.LiveShowTransferable.LiveShowTransferData o_TransferData;
        if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            List dropppedFiles = null;
            try {
                dropppedFiles = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dropppedFiles != null) {
                // empty if block
            }
            dtde.rejectDrag();
            return;
        }
        if (!dtde.isDataFlavorSupported(this.m_LiveShowVIPTrack.getDataFlavor())) {
            dtde.rejectDrag();
            return;
        }
        if (!LiveShowDragDrop.checkDragDrop(dtde, true)) {
            dtde.rejectDrag();
            return;
        }
        LiveShowDragDrop.notifyDragEnterAt(this.m_LiveShowVIPPanel);
        dtde.acceptDrag(dtde.getDropAction());
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIPPanel.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return;
        }
        try {
            o_TransferData = (LiveShowDragDrop.LiveShowTransferable.LiveShowTransferData)dtde.getTransferable().getTransferData(this.m_LiveShowVIPTrack.getDataFlavor());
        }
        catch (Exception e) {
            return;
        }
        int intX = dtde.getLocation().x;
        long longFramePosition = this.m_LiveShowVIPPanel.getPositionFrame(intX);
        boolean boolDragOK = true;
        LiveShowObjectDescription o_ActorDescription = o_TransferData.getActorDescription();
        LiveShowObjectInterface o_ActorInterface = o_LiveShowVIP.findLiveShowObjectInterface(o_ActorDescription.getID());
        boolDragOK = o_LiveShowVIP.actionCheckDragStart(this.m_LiveShowVIPTrack, longFramePosition - o_ActorDescription.getMouseFramePositionInside(), o_ActorDescription, o_TransferData.getLiveShowVIPStatus());
        if (!boolDragOK) {
            if (o_TransferData != null) {
                o_TransferData.close();
            }
            return;
        }
        this.m_ActualTransferData = o_TransferData;
        if (o_ActorInterface != null) {
            LiveShowVIPTrack o_LiveShowVIPTrack = o_LiveShowVIP.getLiveShowVIPTrack(o_ActorInterface.getVIPTrackNumber());
            o_LiveShowVIP.doActionDragMove(o_LiveShowVIPTrack, longFramePosition - o_ActorDescription.getMouseFramePositionInside(), o_ActorDescription, o_TransferData.getLiveShowVIPStatus());
        }
        o_LiveShowVIP.doActionDragEnter(this.m_LiveShowVIPTrack, longFramePosition - o_TransferData.getActorDescription().getMouseFramePositionInside(), o_TransferData);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        LiveShowDragDrop.LiveShowTransferable.LiveShowTransferData o_TransferData;
        if (!dtde.isDataFlavorSupported(this.m_LiveShowVIPTrack.getDataFlavor())) {
            dtde.rejectDrag();
            return;
        }
        if (!LiveShowDragDrop.checkDragDrop(dtde, true)) {
            dtde.rejectDrag();
            return;
        }
        if (this.m_ActualTransferData == null) {
            this.dragEnter(dtde);
            return;
        }
        dtde.acceptDrag(dtde.getDropAction());
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int intX = dtde.getLocation().x;
        long longFramePositionX = this.m_LiveShowVIPPanel.getPositionFrame(intX);
        try {
            long longMousePositionInside;
            long longNewFramePosition;
            o_TransferData = (LiveShowDragDrop.LiveShowTransferable.LiveShowTransferData)dtde.getTransferable().getTransferData(this.m_LiveShowVIPTrack.getDataFlavor());
            LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIPPanel.getLiveShowVIP();
            if (o_LiveShowVIP == null) {
                return;
            }
            LiveShowObjectDescription o_ActorDescription = o_TransferData.getActorDescription();
            long longOldFramePosition = o_ActorDescription.getFrameStart();
            if (!this.m_LiveShowVIPPanel.checkScroll(99, true, longOldFramePosition, longNewFramePosition = longFramePositionX - o_ActorDescription.getMouseFramePositionInside(), longMousePositionInside = o_ActorDescription.getMouseFramePositionInside(), null, o_ActorDescription, o_TransferData.getLiveShowVIPStatus())) {
                o_LiveShowVIP.doActionDragOver(this.m_LiveShowVIPTrack, longNewFramePosition, o_TransferData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (o_TransferData != null) {
            o_TransferData.close();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        if (this.m_LiveShowVIPPanel != null) {
            this.m_LiveShowVIPPanel.stopScrollAutomatic();
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (!dtde.isDataFlavorSupported(this.m_LiveShowVIPTrack.getDataFlavor())) {
            dtde.dropComplete(false);
            return;
        }
        if (!LiveShowDragDrop.checkDragDrop(dtde, true)) {
            dtde.dropComplete(false);
            return;
        }
        LiveShowDragDrop.LiveShowTransferable.LiveShowTransferData o_TransferData = null;
        try {
            o_TransferData = (LiveShowDragDrop.LiveShowTransferable.LiveShowTransferData)dtde.getTransferable().getTransferData(this.m_LiveShowVIPTrack.getDataFlavor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dtde.acceptDrop(dtde.getDropAction());
        try {
            LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIPPanel.getLiveShowVIP();
            o_LiveShowVIP.doActionDragDrop();
            o_LiveShowVIP.endUndoAction(26, true, (LiveShowVIP.LiveShowVIPStatus)o_LiveShowVIP.getStatusSelected_ForEndAction());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dtde.dropComplete(true);
        if (o_TransferData != null) {
            o_TransferData.close();
        }
        LiveShowDragDrop.notifyDroppedAt(this.m_LiveShowVIPPanel);
    }
}

