/*
 * Decompiled with CFR 0.152.
 */
package LiveShowVirtualPackage;

import GUID.LiveGUID;
import LiveShowNotificationPackage.LiveShowNotification;
import LiveShowObjectPackage.LiveShowDragDrop;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectListener;
import LiveShowObjectPackage.LiveShowObjectPanel;
import LiveShowObjectPackage.LiveShowUndo;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.PlayListener;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowSceneBridgeMain;
import LiveShowVirtualPackage.LiveShowSceneBridgePanel;
import LiveShowVirtualPackage.LiveShowTimer;
import LiveShowVirtualPackage.LiveShowVIPListener;
import LiveShowVirtualPackage.LiveShowVIPPanel;
import LiveShowVirtualPackage.LiveShowVIPTrack;
import LiveShowVirtualPackage.LiveShowVIPTrackListener;
import LiveShowVirtualPackage.LiveShowVIPTrackPanel;
import SwingModelPackage.TableAndListModel;
import SynchronizationPackage.EventQueueHandler;
import SynchronizationPackage.LiveCloseSemaphore;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;

public abstract class LiveShowVIP
implements Playable,
PlayListener,
LiveShowObjectListener,
LiveShowVIPTrackListener,
LiveShowUndo.ActionOwnerInterface {
    public static ArrayList<LiveShowVIP> s_LiveShowVIPs = new ArrayList();
    public static final Object s_SyncLiveSHowVIPs = new Object();
    public static long MINIMAL_VISIBLEFRAMELENGTH = 13230000L;
    public static int DEFAULT_TRACKSCOUNT = 3;
    public static final String VIPTYPE_SOUND = "Sound";
    public static final String VIPTYPE_DMX = "DMX";
    public static final String VIPTYPE_MEDIA = "Media";
    public static final int CURSORMODE_UNIVERSAL = 0;
    public static final int CURSORMODE_CURSOR = 1;
    public static final int CURSORMODE_SELECTOBJECT = 2;
    public static final int CURSORMODE_SELECTPLUS = 3;
    public static final int CURSORMODE_SELECTMINUS = 4;
    public static final int CURSORMODE_SELECTFROM = 5;
    public static final int CURSORMODE_SELECTFROMPLUS = 6;
    public static final int CURSORMODE_SELECTFROMMINUS = 7;
    public static final int CURSORMODE_ZOOMPLUS = 8;
    public static final int CURSORMODE_ZOOMMINUS = 9;
    public static Cursor CURSOR_ZOOMPLUS;
    public static Cursor CURSOR_ZOOMMINUS;
    public static Cursor CURSOR_PLAYCURSOR;
    public static Cursor CURSOR_SELECTOBJECT;
    public static Cursor CURSOR_SELECTPLUS;
    public static Cursor CURSOR_SELECTMINUS;
    public static Cursor CURSOR_SELECTFROM;
    public static Cursor CURSOR_SELECTFROMPLUS;
    public static Cursor CURSOR_SELECTFROMMINUS;
    public static double FRAMETIME;
    public static boolean EDITMODEON;
    protected String m_ID;
    protected String m_Type;
    protected ArrayList<LiveShowVIPTrack> m_LiveShowVIPTracks;
    protected ArrayList<LiveShowVIPListener> m_LiveShowVIPListeners;
    protected LiveShowVIPPanel m_LiveShowVIPPanel;
    protected int m_CursorMode;
    protected boolean m_Active;
    protected Play m_Play;
    protected long m_FrameMaxObjects;
    protected long m_FramePositionMax;
    protected ArrayList<LiveShowObjectInterface> m_LiveShowObjects;
    protected ArrayList<LiveShowObjectInterface> m_SelectedObjectInterfaces;
    protected ArrayList<LiveShowSceneBridge> m_SelectedSceneBridges_Only;
    protected ArrayList<LiveShowObjectInterface> m_SelectedObjects_Only;
    protected ArrayList<LiveShowObjectInterface> m_MaxFrameLiveShowObjects;
    protected TableAndListModel.ListModel<LiveShowSceneBridge> m_SceneBridgesListModel;
    protected ArrayList<LiveShowSceneBridge> m_SceneBridges;
    protected LiveShowSceneBridge m_ActualSceneBridge;
    protected boolean m_ActualSceneBridge_PlayInside;
    protected boolean m_ActualSceneBridge_StopAtStart;
    protected boolean boolOldActualSceneBridge_PlayInside;
    protected boolean boolOldActualSceneBridge_StopAtStart;
    protected boolean m_OldNextSceneBridge_StopAtStartIsSet;
    protected LiveShowSceneBridge m_CursorSceneBridge;
    protected LiveShowSceneBridge m_CursorSceneBridge_Old;
    protected LiveShowSceneBridge m_CursorSceneBridgeNext;
    protected LiveShowSceneBridge m_EditCursorSceneBridge;
    protected LiveShowSceneBridge m_EditCursorSceneBridgeNext;
    protected LiveShowSceneBridge m_ExcludedSceneBridge;
    protected long m_SnapFramesDistance;
    protected ArrayList<LiveShowVIP> m_FriendVIPs;
    protected LiveShowUndo m_LiveShowUndo;
    protected LiveShowVIPStatus m_LiveShowVIPStatusSelected;
    protected Runnable m_Runnable_NotifySceneBridgeCursorChanged;
    protected Runnable m_Runnable_NotifySceneBridgeEditCursorChanged;
    protected LiveShowNotification m_LiveShowNotification;
    protected LiveCloseSemaphore m_LiveCloseSemaphore;
    protected final Object m_SyncVIPTracks = new Object();
    protected final Object m_SyncObjects = new Object();
    protected final Object m_SyncVIPListeners = new Object();
    protected final Object m_SyncSelection = new Object();
    private static ArrayList<LiveShowObjectPanel> s_ExternalMouseObjectPanels;
    private static ArrayList<LiveShowSceneBridgePanel> s_ExternalMouseSceneBridgePanels;
    private static Object s_ExternalMouseFirstPanel;
    private static boolean s_ExternalMouseFirstWasSelected;
    private static Rectangle s_ExternalMouseBounds;
    private long m_DragLastFramePosition;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLiveShowVIPCount() {
        Object object = s_SyncLiveSHowVIPs;
        synchronized (object) {
            return s_LiveShowVIPs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiveShowVIP getLiveShowVIP(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = s_SyncLiveSHowVIPs;
        synchronized (object) {
            if (p_Index >= s_LiveShowVIPs.size()) {
                return null;
            }
            return s_LiveShowVIPs.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiveShowObjectInterface getLiveShowObject(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        Object object = s_SyncLiveSHowVIPs;
        synchronized (object) {
            int intVIPCount = s_LiveShowVIPs.size();
            for (int intVIP = 0; intVIP < intVIPCount; ++intVIP) {
                LiveShowVIP o_LiveShowVIP = s_LiveShowVIPs.get(intVIP);
                LiveShowObjectInterface o_LiveShowObjectInterface = o_LiveShowVIP.getLiveShowObjectInterface(p_ID);
                if (o_LiveShowObjectInterface != null) {
                    return o_LiveShowObjectInterface;
                }
                o_LiveShowObjectInterface = o_LiveShowVIP.getLiveShowSceneBridge(p_ID);
                if (o_LiveShowObjectInterface == null) continue;
                return o_LiveShowObjectInterface;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowVIP() {
        this.initMembers();
        Object object = s_SyncLiveSHowVIPs;
        synchronized (object) {
            if (!s_LiveShowVIPs.contains(this)) {
                s_LiveShowVIPs.add(this);
            }
        }
    }

    private void initMembers() {
        this.m_ID = LiveGUID.getUID();
        this.m_Active = true;
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_LiveShowVIPListeners = new ArrayList();
        this.m_LiveShowVIPTracks = new ArrayList();
        this.m_FramePositionMax = MINIMAL_VISIBLEFRAMELENGTH;
        this.m_LiveShowObjects = new ArrayList();
        this.m_SelectedObjectInterfaces = new ArrayList();
        this.m_SelectedSceneBridges_Only = new ArrayList();
        this.m_SelectedObjects_Only = new ArrayList();
        this.m_MaxFrameLiveShowObjects = new ArrayList();
        this.m_SceneBridgesListModel = new TableAndListModel.ListModel(true);
        this.m_SceneBridgesListModel.add(null);
        this.m_SceneBridgesListModel.setSortComparator((Comparator)new SceneBridgeComparator());
        this.m_SceneBridges = new ArrayList();
        this.m_ActualSceneBridge = null;
        this.m_CursorSceneBridge = null;
        this.m_CursorSceneBridge_Old = null;
        this.m_CursorSceneBridgeNext = null;
        this.m_ExcludedSceneBridge = null;
        this.m_EditCursorSceneBridge = null;
        this.m_EditCursorSceneBridgeNext = null;
        this.m_FriendVIPs = new ArrayList();
        LiveShowSceneBridgeMain.getMainBridgeContainer().addLiveShowVIP(this);
        this.m_CursorMode = 0;
        CURSOR_PLAYCURSOR = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getResource("/IconsPackage/MousePointer_Object_SelectCursor.png")).getImage(), new Point(0, 0), "CursorPlayCursor");
        CURSOR_ZOOMPLUS = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getResource("/IconsPackage/MousePointer_ZoomPlus.png")).getImage(), new Point(0, 0), "CursorZoomPlus");
        CURSOR_ZOOMMINUS = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getResource("/IconsPackage/MousePointer_ZoomMinus.png")).getImage(), new Point(0, 0), "CursorZoomPlus");
        CURSOR_SELECTOBJECT = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getResource("/IconsPackage/MousePointer_Object_Select.png")).getImage(), new Point(0, 0), "CursorSelectOnject");
        CURSOR_SELECTPLUS = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getResource("/IconsPackage/MousePointer_Object_SelectAdd.png")).getImage(), new Point(0, 0), "CursorSelectPlus");
        CURSOR_SELECTMINUS = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getResource("/IconsPackage/MousePointer_Object_SelectMinus.png")).getImage(), new Point(0, 0), "CursorSelectMinus");
        CURSOR_SELECTFROM = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getResource("/IconsPackage/MousePointer_Object_SelectTillEnd.png")).getImage(), new Point(0, 0), "CursorSelectFrom");
        CURSOR_SELECTFROMPLUS = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getResource("/IconsPackage/MousePointer_Object_SelectTillEndAdd.png")).getImage(), new Point(0, 0), "CursorSelectFromPlus");
        CURSOR_SELECTFROMMINUS = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getResource("/IconsPackage/MousePointer_Object_SelectTillEndMinus.png")).getImage(), new Point(0, 0), "CursorSelectFromMinus");
        this.m_Runnable_NotifySceneBridgeCursorChanged = new Runnable(){

            @Override
            public void run() {
                try {
                    LiveShowVIP.this.notifyLiveShowVIPListeners_SceneBridgeCursorChanged();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        };
        this.m_Runnable_NotifySceneBridgeEditCursorChanged = new Runnable(){

            @Override
            public void run() {
                try {
                    LiveShowVIP.this.notifyLiveShowVIPListeners_SceneBridgeEditCursorChanged();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        };
        this.m_LiveShowNotification = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = s_SyncLiveSHowVIPs;
        synchronized (object) {
            s_LiveShowVIPs.remove(this);
        }
        LiveShowTimer.selfReference().removeLiveShowVIP(this);
        EventQueueHandler.removeRunnable(this.m_Runnable_NotifySceneBridgeCursorChanged);
        EventQueueHandler.removeRunnable(this.m_Runnable_NotifySceneBridgeEditCursorChanged);
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        this.notifyLiveShowVIPListeners_Closing();
        if (this.m_FriendVIPs != null) {
            this.m_FriendVIPs.clear();
        }
        object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners != null) {
                this.m_LiveShowVIPListeners.clear();
            }
        }
        if (this.m_SceneBridges != null) {
            for (int intSceneBridge = this.m_SceneBridges.size() - 1; intSceneBridge >= 0; --intSceneBridge) {
                LiveShowSceneBridgeMain o_LiveShowSceneBridgeMain;
                LiveShowSceneBridge o_LiveShowSceneBridge = this.m_SceneBridges.get(intSceneBridge);
                this.m_SceneBridges.remove(intSceneBridge);
                if (o_LiveShowSceneBridge == null) continue;
                o_LiveShowSceneBridge.setJumpSceneBridge(null);
                if (o_LiveShowSceneBridge.getIsMainBridge() && (o_LiveShowSceneBridgeMain = LiveShowSceneBridgeMain.getMainBridgeContainer().findLiveShowSceneBridgeMain(o_LiveShowSceneBridge.getID())) != null) {
                    o_LiveShowSceneBridgeMain.removeSceneBridge(o_LiveShowSceneBridge);
                }
                o_LiveShowSceneBridge.close(true);
                if (this.m_SceneBridgesListModel == null) continue;
                this.m_SceneBridgesListModel.remove((Object)o_LiveShowSceneBridge);
            }
            if (this.m_SceneBridgesListModel != null) {
                this.m_SceneBridgesListModel.close();
            }
        }
        LiveShowSceneBridgeMain.getMainBridgeContainer().removeLiveShowVIP(this);
        object = this.m_SyncVIPTracks;
        synchronized (object) {
            if (this.m_LiveShowVIPTracks != null) {
                int intVIPTracksCount = this.m_LiveShowVIPTracks.size();
                for (int intVIPTrack = intVIPTracksCount - 1; intVIPTrack >= 0; --intVIPTrack) {
                    LiveShowVIPTrack o_LiveShowVIPTrack = this.m_LiveShowVIPTracks.get(intVIPTrack);
                    this.removeLiveShowVIPTrack(o_LiveShowVIPTrack);
                }
            }
        }
        if (this.m_Play != null) {
            this.m_Play.close();
        }
        this.m_LiveCloseSemaphore.leaveCloseSection();
    }

    @Override
    public boolean getActive() {
        return this.m_Active;
    }

    public void setActive(boolean p_Active) {
        this.m_Active = p_Active;
        this.notifyLiveShowVIPListeners_Active(p_Active);
        if (this.m_Play != null) {
            this.m_Play.playFramePositionOnce();
        }
    }

    public void refreshJumps() {
        for (int intBridge = 0; intBridge < this.m_SceneBridges.size(); ++intBridge) {
            LiveShowSceneBridge o_LiveShowSceneBridge = this.m_SceneBridges.get(intBridge);
            if (o_LiveShowSceneBridge == null) continue;
            o_LiveShowSceneBridge.refreshJumps();
        }
    }

    public String getID() {
        return this.m_ID;
    }

    public String getType() {
        return this.m_Type;
    }

    public void setType(String p_Type) {
        this.m_Type = p_Type;
    }

    public abstract DataFlavor getDataFlavor();

    public abstract FlavorMap getDataFlavorMap();

    public abstract boolean accepts(LiveShowObjectInterface var1);

    public abstract long getDiskSpaceEstimated(File var1, boolean var2, ArrayList<Object> var3);

    public TableAndListModel.ListModel<LiveShowSceneBridge> getListModelSceneBridges() {
        return this.m_SceneBridgesListModel;
    }

    public void toFront() {
        this.notifyLiveShowVIPListeners_ToFront();
    }

    public void setLiveShowVIPPanel(LiveShowVIPPanel p_LiveShowVIPPanel) {
        this.m_LiveShowVIPPanel = p_LiveShowVIPPanel;
    }

    public LiveShowVIPPanel getLiveShowVIPPanel() {
        return this.m_LiveShowVIPPanel;
    }

    public void addFriendVIP(LiveShowVIP p_FriendVIP) {
        if (p_FriendVIP == null) {
            return;
        }
        if (this.m_FriendVIPs.contains(p_FriendVIP)) {
            return;
        }
        this.m_FriendVIPs.add(p_FriendVIP);
    }

    public void removeFriendVIP(LiveShowVIP p_FriendVIP) {
        if (p_FriendVIP == null) {
            return;
        }
        this.m_FriendVIPs.remove(p_FriendVIP);
    }

    public int getFriendVIPCount() {
        return this.m_FriendVIPs.size();
    }

    public LiveShowVIP getFriendVip(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        LiveShowVIP o_LiveShowVIP = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        if (p_Index < this.m_FriendVIPs.size()) {
            o_LiveShowVIP = this.m_FriendVIPs.get(p_Index);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowVIP;
    }

    public LiveShowVIP getLiveShowVIP_ByID(String p_ID) {
        if (p_ID == null || p_ID.length() <= 0) {
            return null;
        }
        if (p_ID.equals(this.m_ID)) {
            return this;
        }
        for (int intVIP = 0; intVIP < this.m_FriendVIPs.size(); ++intVIP) {
            LiveShowVIP o_LiveShowVIP = this.m_FriendVIPs.get(intVIP);
            if (o_LiveShowVIP == null || !p_ID.equals(o_LiveShowVIP.getID())) continue;
            return o_LiveShowVIP;
        }
        return null;
    }

    public LiveShowVIP getLiveShowVIP_FirstByType(String p_Type) {
        if (p_Type == null || p_Type.length() <= 0) {
            return null;
        }
        if (p_Type.equals(this.m_Type)) {
            return this;
        }
        for (int intVIP = 0; intVIP < this.m_FriendVIPs.size(); ++intVIP) {
            LiveShowVIP o_LiveShowVIP = this.m_FriendVIPs.get(intVIP);
            if (o_LiveShowVIP == null || !p_Type.equals(o_LiveShowVIP.getType())) continue;
            return o_LiveShowVIP;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void externalMouseDrag(boolean p_FriendVIPS, LiveShowVIPPanel p_LiveShowVIPPanel, LiveShowVIPTrackPanel p_LiveShowVIPTrackPanel, int p_LastX, int p_LastY, int p_X, int p_Y) {
        LiveShowSceneBridgePanel o_LiveShowSceneBridgePanel;
        LiveShowObjectPanel o_LiveShowObjectPanel;
        if (p_LiveShowVIPPanel == null) {
            return;
        }
        if (p_LiveShowVIPTrackPanel == null) {
            return;
        }
        LiveShowVIPPanel o_LiveShowVIPPanel = this.getLiveShowVIPPanel();
        if (o_LiveShowVIPPanel == null) {
            return;
        }
        Object object = this.m_SyncVIPTracks;
        synchronized (object) {
            s_ExternalMouseObjectPanels.clear();
            s_ExternalMouseSceneBridgePanels.clear();
            for (int intVIPTrack = 0; intVIPTrack < o_LiveShowVIPPanel.getLiveShowVIPTrackPanelCount(); ++intVIPTrack) {
                LiveShowVIPTrackPanel o_LiveShowVIPTrackPanel = o_LiveShowVIPPanel.getLiveShowVIPTrackPanel(intVIPTrack);
                if (o_LiveShowVIPTrackPanel == null) continue;
                int intMouseCorrectX = o_LiveShowVIPTrackPanel.getBounds((Rectangle)LiveShowVIP.s_ExternalMouseBounds).x - p_LiveShowVIPTrackPanel.getBounds((Rectangle)LiveShowVIP.s_ExternalMouseBounds).x + (o_LiveShowVIPPanel.getBounds((Rectangle)LiveShowVIP.s_ExternalMouseBounds).x - p_LiveShowVIPPanel.getBounds((Rectangle)LiveShowVIP.s_ExternalMouseBounds).x);
                int intMouseCorrectY = o_LiveShowVIPTrackPanel.getBounds((Rectangle)LiveShowVIP.s_ExternalMouseBounds).y - p_LiveShowVIPTrackPanel.getBounds((Rectangle)LiveShowVIP.s_ExternalMouseBounds).y + (o_LiveShowVIPPanel.getBounds((Rectangle)LiveShowVIP.s_ExternalMouseBounds).y - p_LiveShowVIPPanel.getBounds((Rectangle)LiveShowVIP.s_ExternalMouseBounds).y);
                for (int intObjectPanel = 0; intObjectPanel < o_LiveShowVIPTrackPanel.getLiveShowOBjectPanelCount(); ++intObjectPanel) {
                    o_LiveShowObjectPanel = o_LiveShowVIPTrackPanel.getLiveShowObjectPanel(intObjectPanel);
                    if (o_LiveShowObjectPanel == null || !o_LiveShowObjectPanel.externalMouseSelect(p_LastX - intMouseCorrectX, p_LastY - intMouseCorrectY, p_X - intMouseCorrectX, p_Y - intMouseCorrectY)) continue;
                    if (s_ExternalMouseFirstPanel == null) {
                        s_ExternalMouseFirstPanel = o_LiveShowObjectPanel;
                        s_ExternalMouseFirstWasSelected = o_LiveShowObjectPanel.getSelected();
                    }
                    s_ExternalMouseObjectPanels.add(o_LiveShowObjectPanel);
                }
                for (int intSceneBridge = 0; intSceneBridge < o_LiveShowVIPPanel.getLiveShowSceneBridgePanelCount(); ++intSceneBridge) {
                    o_LiveShowSceneBridgePanel = o_LiveShowVIPPanel.getLiveShowSceneBridgePanel(intSceneBridge);
                    if (o_LiveShowSceneBridgePanel == null || !o_LiveShowSceneBridgePanel.externalMouseSelect(p_LastX + (intMouseCorrectX = p_LiveShowVIPTrackPanel.getBounds((Rectangle)LiveShowVIP.s_ExternalMouseBounds).x - (o_LiveShowVIPPanel.getBounds((Rectangle)LiveShowVIP.s_ExternalMouseBounds).x - p_LiveShowVIPPanel.getBounds((Rectangle)LiveShowVIP.s_ExternalMouseBounds).x)), p_LastY + (intMouseCorrectY = p_LiveShowVIPTrackPanel.getBounds((Rectangle)LiveShowVIP.s_ExternalMouseBounds).y - (o_LiveShowVIPPanel.getBounds((Rectangle)LiveShowVIP.s_ExternalMouseBounds).y - p_LiveShowVIPPanel.getBounds((Rectangle)LiveShowVIP.s_ExternalMouseBounds).y)), p_X + intMouseCorrectX, p_Y + intMouseCorrectY)) continue;
                    if (s_ExternalMouseFirstPanel == null) {
                        s_ExternalMouseFirstPanel = o_LiveShowSceneBridgePanel;
                        s_ExternalMouseFirstWasSelected = o_LiveShowSceneBridgePanel.getSelected();
                    }
                    s_ExternalMouseSceneBridgePanels.add(o_LiveShowSceneBridgePanel);
                }
            }
        }
        for (int intObjectPanel = 0; intObjectPanel < s_ExternalMouseObjectPanels.size(); ++intObjectPanel) {
            o_LiveShowObjectPanel = s_ExternalMouseObjectPanels.get(intObjectPanel);
            if (!s_ExternalMouseFirstWasSelected) {
                this.addSelectedObject(o_LiveShowObjectPanel.getLiveShowObjectInterface());
                continue;
            }
            this.removeSelectedObject(o_LiveShowObjectPanel.getLiveShowObjectInterface());
        }
        for (int intSceneBridgePanel = 0; intSceneBridgePanel < s_ExternalMouseSceneBridgePanels.size(); ++intSceneBridgePanel) {
            o_LiveShowSceneBridgePanel = s_ExternalMouseSceneBridgePanels.get(intSceneBridgePanel);
            if (!s_ExternalMouseFirstWasSelected) {
                this.addSelectedObject(o_LiveShowSceneBridgePanel.getLiveShowSceneBridge());
                continue;
            }
            this.removeSelectedObject(o_LiveShowSceneBridgePanel.getLiveShowSceneBridge());
        }
        if (p_FriendVIPS) {
            for (int intVIP = 0; intVIP < this.m_FriendVIPs.size(); ++intVIP) {
                LiveShowVIP o_LiveShowVIP = this.m_FriendVIPs.get(intVIP);
                o_LiveShowVIP.externalMouseDrag(false, p_LiveShowVIPPanel, p_LiveShowVIPTrackPanel, p_LastX, p_LastY, p_X, p_Y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void externalMouseReleased(boolean p_FriendVIPS, LiveShowVIPPanel p_LiveShowVIPPanel, LiveShowVIPTrackPanel p_LiveShowVIPTrackPanel, int p_X, int p_Y) {
        if (p_LiveShowVIPPanel == null) {
            return;
        }
        if (p_LiveShowVIPTrackPanel == null) {
            return;
        }
        LiveShowVIPPanel o_LiveShowVIPPanel = this.getLiveShowVIPPanel();
        if (o_LiveShowVIPPanel == null) {
            return;
        }
        s_ExternalMouseFirstPanel = null;
        Object object = this.m_SyncVIPTracks;
        synchronized (object) {
            for (int intVIPTrack = 0; intVIPTrack < o_LiveShowVIPPanel.getLiveShowVIPTrackPanelCount(); ++intVIPTrack) {
                LiveShowVIPTrackPanel o_LiveShowVIPTrackPanel = o_LiveShowVIPPanel.getLiveShowVIPTrackPanel(intVIPTrack);
                if (o_LiveShowVIPTrackPanel == null) continue;
                for (int intObjectPanel = 0; intObjectPanel < o_LiveShowVIPTrackPanel.getLiveShowOBjectPanelCount(); ++intObjectPanel) {
                    LiveShowObjectPanel o_LiveShowObjectPanel = o_LiveShowVIPTrackPanel.getLiveShowObjectPanel(intObjectPanel);
                    if (o_LiveShowObjectPanel == null) continue;
                    o_LiveShowObjectPanel.externalMouseReleased(p_X, p_Y);
                }
            }
            for (int intSceneBridge = 0; intSceneBridge < o_LiveShowVIPPanel.getLiveShowSceneBridgePanelCount(); ++intSceneBridge) {
                LiveShowSceneBridgePanel o_LiveShowSceneBridgePanel = o_LiveShowVIPPanel.getLiveShowSceneBridgePanel(intSceneBridge);
                if (o_LiveShowSceneBridgePanel == null) continue;
                o_LiveShowSceneBridgePanel.externalMouseReleased(p_X, p_Y);
            }
        }
        if (p_FriendVIPS) {
            for (int intVIP = 0; intVIP < this.m_FriendVIPs.size(); ++intVIP) {
                LiveShowVIP o_LiveShowVIP = this.m_FriendVIPs.get(intVIP);
                o_LiveShowVIP.externalMouseReleased(false, p_LiveShowVIPPanel, p_LiveShowVIPTrackPanel, p_X, p_Y);
            }
        }
    }

    public abstract LiveShowVIPTrack createLiveShowVipTrack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEmptyLiveShowVipTracks() {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncVIPTracks;
        synchronized (object) {
            LiveShowVIPTrack o_LiveShowVIPTrack;
            int intTrack;
            ArrayList<LiveShowVIPTrack> o_LiveShowVIPTracks = new ArrayList<LiveShowVIPTrack>();
            int intTrackCount = this.getLiveShowVipTrackCount();
            for (intTrack = 0; intTrack < intTrackCount; ++intTrack) {
                o_LiveShowVIPTrack = this.getLiveShowVIPTrack(intTrack);
                if (o_LiveShowVIPTrack == null || o_LiveShowVIPTrack.getLiveShowObjectInterfaceCount() > 0) continue;
                o_LiveShowVIPTracks.add(o_LiveShowVIPTrack);
            }
            for (intTrack = o_LiveShowVIPTracks.size() - 1; intTrack >= 0 && intTrackCount > 1; --intTrackCount, --intTrack) {
                o_LiveShowVIPTrack = (LiveShowVIPTrack)o_LiveShowVIPTracks.get(intTrack);
                this.removeLiveShowVIPTrack(o_LiveShowVIPTrack);
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void eventVIPTrackClosing(LiveShowVIPTrack p_LiveShowVIPTrack) {
    }

    @Override
    public void eventVIPTrackObjectInterfaceAdded(LiveShowVIPTrack p_LiveShowVIPTrack, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPTrackObjectInterfaceRemoved(LiveShowVIPTrack p_LiveShowVIPTrack, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPTrackObjectParamChanged(LiveShowVIPTrack p_LiveShowVIPTrack, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLiveShowVIPTrackNumber(LiveShowVIPTrack p_LiveShowVIPTrack) {
        if (p_LiveShowVIPTrack == null) {
            return -1;
        }
        int intTrackIndex = -1;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return -1;
        }
        Object object = this.m_SyncVIPTracks;
        synchronized (object) {
            intTrackIndex = this.m_LiveShowVIPTracks.indexOf(p_LiveShowVIPTrack);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return intTrackIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLiveShowVIPTrack(LiveShowVIPTrack p_LiveShowVIPTrack) {
        if (p_LiveShowVIPTrack == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolAdded = false;
        Object object = this.m_SyncVIPTracks;
        synchronized (object) {
            if (this.m_LiveShowVIPTracks != null && !this.m_LiveShowVIPTracks.contains(p_LiveShowVIPTrack)) {
                this.m_LiveShowVIPTracks.add(p_LiveShowVIPTrack);
                p_LiveShowVIPTrack.addLiveShowVIPTrackListener(this);
                boolAdded = true;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if (boolAdded) {
            this.notifyLiveShowVIPListeners_VIPTrackAdded(p_LiveShowVIPTrack);
        }
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLiveShowVIPTrack(LiveShowVIPTrack p_LiveShowVIPTrack) {
        if (p_LiveShowVIPTrack == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncVIPTracks;
        synchronized (object) {
            if (this.m_LiveShowVIPTracks != null && (boolRemoved = this.m_LiveShowVIPTracks.remove(p_LiveShowVIPTrack))) {
                p_LiveShowVIPTrack.removeLiveShowVIPTrackListener(this);
                p_LiveShowVIPTrack.close();
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if (boolRemoved) {
            this.notifyLiveShowVIPListeners_VIPTrackRemoved(p_LiveShowVIPTrack);
        }
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLiveShowVipTrackCount() {
        int intTrackCount = 0;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return 0;
        }
        Object object = this.m_SyncVIPTracks;
        synchronized (object) {
            if (this.m_LiveShowVIPTracks != null) {
                intTrackCount = this.m_LiveShowVIPTracks.size();
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return intTrackCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowVIPTrack getLiveShowVIPTrack(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        LiveShowVIPTrack o_LiveShowVIPTrack = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Object object = this.m_SyncVIPTracks;
        synchronized (object) {
            if (this.m_LiveShowVIPTracks != null && p_Index < this.m_LiveShowVIPTracks.size()) {
                o_LiveShowVIPTrack = this.m_LiveShowVIPTracks.get(p_Index);
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowVIPTrack;
    }

    public void setEditModeOn(boolean p_EditModeOn, boolean p_SetEditModusFriends) {
        EDITMODEON = p_EditModeOn;
        this.m_Play.setEditModeOn(p_EditModeOn);
        if (p_SetEditModusFriends) {
            for (int intFriendVIP = 0; intFriendVIP < this.m_FriendVIPs.size(); ++intFriendVIP) {
                LiveShowVIP o_LiveShowVIP = this.m_FriendVIPs.get(intFriendVIP);
                if (o_LiveShowVIP == null || o_LiveShowVIP.getEditModeOn() == p_EditModeOn) continue;
                o_LiveShowVIP.setEditModeOn(p_EditModeOn, false);
            }
        }
        this.notifyLiveShowVIPListeners_EditModeOn(EDITMODEON);
    }

    public boolean getEditModeOn() {
        Play o_Play = this.m_Play;
        if (o_Play == null) {
            return true;
        }
        return o_Play.getEditModeOn();
    }

    public void setCursorMode(int p_CursorMode) {
        this.m_CursorMode = p_CursorMode;
        this.notifyLiveShowVIPListeners_EditMode(this.m_CursorMode);
    }

    public int getCursorMode() {
        return this.m_CursorMode;
    }

    public int getMouseCursorMode(int p_X, int p_Y, Component p_Component) {
        int intEditMode = this.getCursorMode();
        switch (intEditMode) {
            case 0: {
                if ((p_Component instanceof LiveShowObjectPanel || p_Component instanceof LiveShowSceneBridgePanel) && p_Y > p_Component.getHeight() / 2) {
                    return 2;
                }
                return 1;
            }
        }
        return intEditMode;
    }

    @Override
    public long getFrameStart() {
        return 0L;
    }

    @Override
    public long getFrameEnd() {
        return this.m_FramePositionMax;
    }

    @Override
    public long getFrameEndToPlay() {
        return this.m_FramePositionMax;
    }

    @Override
    public double getFrameTime() {
        return FRAMETIME;
    }

    @Override
    public long findFramePosition_FadeIn(double p_FadeProgress) {
        return 0L;
    }

    @Override
    public long findFramePosition_FadeOut(double p_FadeProgress) {
        return this.getFrameEnd();
    }

    @Override
    public boolean setFadeOutDirect(long p_ActualFramePlay, double p_FadeInProgress, double p_FadeOutPrgress) {
        return false;
    }

    @Override
    public void resetFadeOutDirect() {
    }

    @Override
    public long getFrameLength_FadeOutDirect() {
        return 0L;
    }

    public static void setFrameTime(double p_FrameTime) {
        if (p_FrameTime <= 0.0) {
            return;
        }
        FRAMETIME = p_FrameTime;
    }

    public static double getFRAMETIME() {
        return FRAMETIME;
    }

    @Override
    public abstract Playable.PlayObject read(Play var1, Playable.PlayObject var2);

    @Override
    public abstract Playable.PlayObject readInternal(Play var1, Playable.PlayObject var2, LiveShowSceneBridge var3, long var4, double var6, boolean var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long calculateFrameMaxObjects(LiveShowObjectInterface p_LiveShowObjectInterface) {
        long longObjectEndFrame = 0L;
        long longMaxFrame = 0L;
        boolean boolCalculateAll = false;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return 0L;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (p_LiveShowObjectInterface == null) {
                boolCalculateAll = true;
            } else if (this.m_MaxFrameLiveShowObjects.contains(p_LiveShowObjectInterface)) {
                boolCalculateAll = true;
            } else {
                longMaxFrame = this.m_FrameMaxObjects;
                longObjectEndFrame = p_LiveShowObjectInterface.getFrameStart() + p_LiveShowObjectInterface.getFrameLength();
                if (longObjectEndFrame == this.m_FrameMaxObjects) {
                    this.m_MaxFrameLiveShowObjects.add(p_LiveShowObjectInterface);
                }
                if (longObjectEndFrame > this.m_FrameMaxObjects) {
                    longMaxFrame = longObjectEndFrame;
                    this.m_MaxFrameLiveShowObjects.clear();
                    this.m_MaxFrameLiveShowObjects.add(p_LiveShowObjectInterface);
                }
            }
            if (boolCalculateAll) {
                longMaxFrame = 0L;
                this.m_MaxFrameLiveShowObjects.clear();
                for (int intObject = 0; intObject < this.m_LiveShowObjects.size(); ++intObject) {
                    LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowObjects.get(intObject);
                    if (o_LiveShowObjectInterface == null) continue;
                    longObjectEndFrame = o_LiveShowObjectInterface.getFrameStart() + o_LiveShowObjectInterface.getFrameLength();
                    if (longObjectEndFrame == longMaxFrame) {
                        this.m_MaxFrameLiveShowObjects.add(o_LiveShowObjectInterface);
                    }
                    if (longObjectEndFrame <= longMaxFrame) continue;
                    longMaxFrame = longObjectEndFrame;
                    this.m_MaxFrameLiveShowObjects.clear();
                    this.m_MaxFrameLiveShowObjects.add(o_LiveShowObjectInterface);
                }
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return longMaxFrame;
    }

    public void setFrameMaxObjects(long p_FrameMaxObjects) {
        if (p_FrameMaxObjects == this.m_FrameMaxObjects) {
            return;
        }
        this.m_FrameMaxObjects = p_FrameMaxObjects;
        this.notifyLiveShowVIPListeners_FrameMaxObjects(this.m_FrameMaxObjects);
    }

    public void setFrameMaxObjects_NotifyListeners(long p_FrameMaxObjects) {
        this.m_FrameMaxObjects = p_FrameMaxObjects;
        this.notifyLiveShowVIPListeners_FrameMaxObjects(this.m_FrameMaxObjects);
    }

    public long getFrameMaxObjects() {
        return this.m_FrameMaxObjects;
    }

    public void setFramePositionMax(long p_FramePositionMax) {
        if (this.m_FramePositionMax != p_FramePositionMax) {
            this.m_FramePositionMax = p_FramePositionMax;
            if (this.m_FramePositionMax < MINIMAL_VISIBLEFRAMELENGTH) {
                this.m_FramePositionMax = MINIMAL_VISIBLEFRAMELENGTH;
            }
            this.notifyLiveShowVIPListeners_MaxFrame(this.m_FramePositionMax);
        }
    }

    public long getFramePositionMax() {
        return this.m_FramePositionMax;
    }

    public Play getPlay() {
        return this.m_Play;
    }

    public boolean isRunning() {
        Play o_Play = this.getPlay();
        if (o_Play == null) {
            return false;
        }
        return o_Play.isRunning();
    }

    private void checkSceneBridge_PlayCursor(long p_PlayCursor) {
        LiveShowSceneBridge o_ActualSceneBridge = this.m_ActualSceneBridge;
        LiveShowSceneBridge o_OldLiveShowSceneBridge = this.m_CursorSceneBridge;
        LiveShowSceneBridge o_OldLiveShowSceneBridgeNext = this.m_CursorSceneBridgeNext;
        if (o_ActualSceneBridge != null) {
            if (p_PlayCursor < o_ActualSceneBridge.getFrameStart() || p_PlayCursor >= o_ActualSceneBridge.getFrameStart() + o_ActualSceneBridge.getFrameLength()) {
                this.m_CursorSceneBridge = this.getLiveShowSceneBridge_Previous(p_PlayCursor, false, true);
                this.m_ActualSceneBridge_PlayInside = false;
                this.m_ActualSceneBridge_StopAtStart = false;
            } else {
                this.m_CursorSceneBridge = o_ActualSceneBridge;
                this.m_ActualSceneBridge_PlayInside = true;
                if (p_PlayCursor != o_ActualSceneBridge.getFrameStart()) {
                    this.m_ActualSceneBridge_StopAtStart = false;
                }
            }
        } else {
            this.m_CursorSceneBridge = this.getLiveShowSceneBridge_Previous(p_PlayCursor, false, true);
            this.m_ActualSceneBridge_PlayInside = false;
            this.m_ActualSceneBridge_StopAtStart = false;
        }
        this.m_CursorSceneBridgeNext = this.getLiveShowSceneBridge_Next(p_PlayCursor, false, true);
        boolean boolNextSceneBridge_StopAtStart = this.m_CursorSceneBridgeNext == null ? false : this.m_CursorSceneBridgeNext.getStopAtStart();
        if (this.m_CursorSceneBridge != o_OldLiveShowSceneBridge || this.m_CursorSceneBridgeNext != o_OldLiveShowSceneBridgeNext || this.m_CursorSceneBridgeNext == o_OldLiveShowSceneBridgeNext && this.m_OldNextSceneBridge_StopAtStartIsSet != boolNextSceneBridge_StopAtStart || this.boolOldActualSceneBridge_PlayInside != this.m_ActualSceneBridge_PlayInside || this.boolOldActualSceneBridge_StopAtStart != this.m_ActualSceneBridge_StopAtStart) {
            this.m_CursorSceneBridge_Old = o_OldLiveShowSceneBridge;
            EventQueueHandler.invokeLater(this.m_Runnable_NotifySceneBridgeCursorChanged);
        }
        this.boolOldActualSceneBridge_PlayInside = this.m_ActualSceneBridge_PlayInside;
        this.boolOldActualSceneBridge_StopAtStart = this.m_ActualSceneBridge_StopAtStart;
        this.m_OldNextSceneBridge_StopAtStartIsSet = this.m_CursorSceneBridgeNext == null ? false : this.m_CursorSceneBridgeNext.getStopAtStart();
    }

    public abstract void setSceneBridgeCursorChanged(LiveShowSceneBridge var1);

    private void checkSceneBridge_EditCursor(long p_PlayCursor) {
        LiveShowSceneBridge o_OldLiveShowSceneBridge = this.m_EditCursorSceneBridge;
        this.m_EditCursorSceneBridge = this.getLiveShowSceneBridge_Previous(p_PlayCursor, false, true);
        this.m_EditCursorSceneBridgeNext = this.getLiveShowSceneBridge_Next(p_PlayCursor, false, true);
        if (this.m_EditCursorSceneBridge != o_OldLiveShowSceneBridge) {
            EventQueueHandler.invokeLater(this.m_Runnable_NotifySceneBridgeEditCursorChanged);
        }
    }

    @Override
    public void eventPlayStart(Play p_Play) {
        this.m_ActualSceneBridge_StopAtStart = false;
        this.checkSceneBridge_PlayCursor(p_Play.getPlayCursor());
    }

    @Override
    public void eventPlayStop(Play p_Play) {
    }

    @Override
    public void eventPlayPause(Play p_Play) {
    }

    @Override
    public void eventPlayRewind(Play p_Play) {
    }

    @Override
    public void eventPlayFastForward(Play p_Play) {
    }

    @Override
    public void eventPlayFadePossibility(Play p_Play, boolean p_FadeInPossible, boolean p_FadeOutPossible, double p_FadeProgress) {
    }

    @Override
    public void eventPlayFadedIn(Play p_Play, boolean p_FadedIn, double p_FadeProgress) {
    }

    @Override
    public long eventPlayCheckRead(Play p_Play, long p_FrameStart, long p_FramesToRead) {
        return p_FramesToRead;
    }

    @Override
    public void eventPlayCursorSet(Play p_Play, long p_PlayCursor) {
        this.checkSceneBridge_PlayCursor(p_PlayCursor);
    }

    @Override
    public void eventEditModeOn(Play p_Play, boolean p_EditModeOn) {
    }

    @Override
    public void eventEditCursorSet(Play p_Play, long p_EditCursor) {
        this.checkSceneBridge_EditCursor(p_EditCursor);
    }

    @Override
    public void eventPlayCursor(Play p_Play, long p_OldPlayCursor, long p_PlayCursor) {
    }

    @Override
    public void eventPlayClosing(Play p_Play) {
    }

    @Override
    public void eventPlayError(Play p_Play, Exception p_Exception, String p_Remark) {
    }

    @Override
    public void eventPlayTimelineEnd(Play p_Play) {
    }

    @Override
    public void eventObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        long longMaxFrame = this.calculateFrameMaxObjects(p_LiveShowObjectInterface);
        this.setFrameMaxObjects(longMaxFrame);
        if (p_LiveShowObjectInterface.getChangedStartLengthSinceLastNotification()) {
            this.resort_LiveShowObject(p_LiveShowObjectInterface);
        }
        if (p_LiveShowObjectInterface instanceof LiveShowSceneBridge) {
            if (p_LiveShowObjectInterface.getChangedStartLengthSinceLastNotification()) {
                this.resort_LiveShowSceneBridge((LiveShowSceneBridge)p_LiveShowObjectInterface);
            } else {
                this.m_SceneBridgesListModel.changedElement((Object)((LiveShowSceneBridge)p_LiveShowObjectInterface));
            }
            Play o_Play = this.m_Play;
            if (o_Play != null) {
                this.checkSceneBridge_PlayCursor(o_Play.getPlayCursor());
            }
        } else if (p_LiveShowObjectInterface.getIsJingle()) {
            this.m_Play.addLiveShowObjectInterface_Jingle(p_LiveShowObjectInterface);
        } else {
            this.m_Play.removeLiveShowObjectInterface_Jingle(p_LiveShowObjectInterface);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        this.notifyLiveShowVIPListeners_ObjectParamChanged(p_LiveShowObjectInterface);
    }

    public void startUndoAction_VolumeChange(LiveShowObjectInterface p_LiveShowObjectInterface, int p_Action, String p_ActionString) {
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        int intSelectedCount = this.getSelectedObjectsCount();
        LiveShowUndo o_LiveShowUndo = this.getLiveShowUndo();
        if (o_LiveShowUndo == null) {
            return;
        }
        if (!o_LiveShowUndo.checkStartAction(p_Action)) {
            return;
        }
        LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIPStatus();
        boolean boolIsSceneBridge = p_LiveShowObjectInterface instanceof LiveShowSceneBridge;
        for (int intObject = 0; intObject < intSelectedCount; ++intObject) {
            LiveShowObjectInterface o_LiveShowObject = this.getSelectedObjectInterface(intObject);
            if (o_LiveShowObject == null || (!boolIsSceneBridge ? o_LiveShowObject instanceof LiveShowSceneBridge : !(o_LiveShowObject instanceof LiveShowSceneBridge))) continue;
            o_LiveShowVIPStatus.addLiveShowObject_Cloned(o_LiveShowObject);
        }
        o_LiveShowUndo.startAction(p_Action, p_ActionString, this, o_LiveShowVIPStatus);
    }

    @Override
    public void eventObjectVolumeChanged(LiveShowObjectInterface p_LiveShowObjectInterface, float p_Volume) {
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        if (!this.m_SelectedObjectInterfaces.contains(p_LiveShowObjectInterface)) {
            return;
        }
        int intSelectedCount = this.getSelectedObjectsCount();
        boolean boolIsSceneBridge = p_LiveShowObjectInterface instanceof LiveShowSceneBridge;
        for (int intObject = 0; intObject < intSelectedCount; ++intObject) {
            LiveShowObjectInterface o_LiveShowObject = this.getSelectedObjectInterface(intObject);
            if (o_LiveShowObject == null || o_LiveShowObject == p_LiveShowObjectInterface || (!boolIsSceneBridge ? o_LiveShowObject instanceof LiveShowSceneBridge : !(o_LiveShowObject instanceof LiveShowSceneBridge))) continue;
            o_LiveShowObject.setVolumeFactor(p_Volume, false);
        }
    }

    public void endUndoAction_VolumeChange(LiveShowObjectInterface p_LiveShowObjectInterface, int p_Action, boolean p_Success) {
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        int intSelectedCount = this.getSelectedObjectsCount();
        LiveShowUndo o_LiveShowUndo = this.getLiveShowUndo();
        if (o_LiveShowUndo == null) {
            return;
        }
        if (!o_LiveShowUndo.checkEndAction(p_Action)) {
            return;
        }
        LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIPStatus();
        boolean boolIsSceneBridge = p_LiveShowObjectInterface instanceof LiveShowSceneBridge;
        for (int intObject = 0; intObject < intSelectedCount; ++intObject) {
            LiveShowObjectInterface o_LiveShowObject = this.getSelectedObjectInterface(intObject);
            if (o_LiveShowObject == null || (!boolIsSceneBridge ? o_LiveShowObject instanceof LiveShowSceneBridge : !(o_LiveShowObject instanceof LiveShowSceneBridge))) continue;
            o_LiveShowVIPStatus.addLiveShowObject_Cloned(o_LiveShowObject);
        }
        o_LiveShowUndo.endAction(p_Success, p_Action, this, o_LiveShowVIPStatus);
    }

    @Override
    public void eventObjectAdditionalChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
    }

    @Override
    public void eventObjectClosed(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (p_LiveShowObjectInterface instanceof LiveShowSceneBridge) {
            this.removeSceneBridge((LiveShowSceneBridge)p_LiveShowObjectInterface);
        }
        this.removeLiveShowObject(p_LiveShowObjectInterface);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void eventObjectSelection(LiveShowObjectInterface p_LiveShowObjectInterface, boolean p_IsSelected, boolean p_Added) {
    }

    public abstract LiveShowObjectInterface createLiveShowObject(LiveShowObjectDescription var1);

    public boolean addLiveShowObject(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return false;
        }
        if (!this.accepts(p_LiveShowObjectInterface)) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolAdded = true;
        if (!this.m_LiveShowObjects.contains(p_LiveShowObjectInterface)) {
            this.addSorted_LiveShowObject(p_LiveShowObjectInterface);
            p_LiveShowObjectInterface.addLiveShowObjectListener(this);
            long longMaxFrame = this.calculateFrameMaxObjects(p_LiveShowObjectInterface);
            this.setFrameMaxObjects(longMaxFrame);
            this.notifyLiveShowVIPListeners_ObjectAdded(p_LiveShowObjectInterface);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSorted_LiveShowObject(LiveShowObjectInterface p_LiveShowObject) {
        int intLiveShowObject;
        Object object = this.m_SyncObjects;
        synchronized (object) {
            LiveShowObjectInterface o_LiveShowObject;
            for (intLiveShowObject = 0; intLiveShowObject < this.m_LiveShowObjects.size() && ((o_LiveShowObject = this.m_LiveShowObjects.get(intLiveShowObject)) == null || o_LiveShowObject.getFrameStart() < p_LiveShowObject.getFrameStart() || o_LiveShowObject.getFrameStart() == p_LiveShowObject.getFrameStart() && (o_LiveShowObject instanceof LiveShowSceneBridge && !(p_LiveShowObject instanceof LiveShowSceneBridge) || o_LiveShowObject.getFrameStart() + o_LiveShowObject.getFrameLength() > p_LiveShowObject.getFrameStart() + p_LiveShowObject.getFrameLength())); ++intLiveShowObject) {
            }
        }
        this.m_LiveShowObjects.add(intLiveShowObject, p_LiveShowObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resort_LiveShowObject(LiveShowObjectInterface p_LiveShowObject) {
        Object object = this.m_SyncObjects;
        synchronized (object) {
            LiveShowObjectInterface o_LiveShowObject;
            int intObject;
            if (this.m_LiveShowObjects.size() < 2) {
                return;
            }
            int intIndex = this.m_LiveShowObjects.indexOf(p_LiveShowObject);
            if (intIndex < 0) {
                return;
            }
            for (intObject = 0; intObject < this.m_LiveShowObjects.size() && ((o_LiveShowObject = this.m_LiveShowObjects.get(intObject)) == null || intObject == intIndex || o_LiveShowObject.getFrameStart() < p_LiveShowObject.getFrameStart() || o_LiveShowObject.getFrameStart() == p_LiveShowObject.getFrameStart() && (o_LiveShowObject instanceof LiveShowSceneBridge && !(p_LiveShowObject instanceof LiveShowSceneBridge) || o_LiveShowObject.getFrameStart() + o_LiveShowObject.getFrameLength() > p_LiveShowObject.getFrameStart() + p_LiveShowObject.getFrameLength())); ++intObject) {
            }
            if (intObject == intIndex + 1) {
                return;
            }
            if (intObject < intIndex) {
                this.m_LiveShowObjects.remove(intIndex);
                this.m_LiveShowObjects.add(intObject, p_LiveShowObject);
            }
            if (intObject > intIndex) {
                this.m_LiveShowObjects.remove(intIndex);
                this.m_LiveShowObjects.add(intObject - 1, p_LiveShowObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLiveShowObject(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return false;
        }
        if (!this.accepts(p_LiveShowObjectInterface)) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncObjects;
        synchronized (object) {
            boolRemoved = this.m_LiveShowObjects.remove(p_LiveShowObjectInterface);
        }
        this.removeSelectedObject(p_LiveShowObjectInterface);
        if (boolRemoved) {
            p_LiveShowObjectInterface.removeLiveShowObjectListener(this);
            this.notifyLiveShowVIPListeners_ObjectRemoved(p_LiveShowObjectInterface);
            long longMaxFrameObjects = this.calculateFrameMaxObjects(p_LiveShowObjectInterface);
            this.setFrameMaxObjects(longMaxFrameObjects);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<LiveShowObjectInterface> getLiveShowObjects_HitsFrame(ArrayList<LiveShowObjectInterface> p_LiveShowObjectInterfaces, long p_FramePosition, boolean p_ContainsLiveShowObjects, boolean p_ContainsSceneBridges) {
        if (p_FramePosition < 0L) {
            return null;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        if (p_LiveShowObjectInterfaces == null) {
            p_LiveShowObjectInterfaces = new ArrayList();
        }
        p_LiveShowObjectInterfaces.clear();
        Object object = this.m_SyncObjects;
        synchronized (object) {
            for (int intObject = 0; intObject < this.m_LiveShowObjects.size(); ++intObject) {
                LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowObjects.get(intObject);
                if (o_LiveShowObjectInterface == null || (!(o_LiveShowObjectInterface instanceof LiveShowSceneBridge) ? !p_ContainsLiveShowObjects : !p_ContainsSceneBridges)) continue;
                if (o_LiveShowObjectInterface.getFrameStart() > p_FramePosition) break;
                if (o_LiveShowObjectInterface.getFrameStart() + o_LiveShowObjectInterface.getFrameLength() < p_FramePosition) continue;
                p_LiveShowObjectInterfaces.add(o_LiveShowObjectInterface);
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return p_LiveShowObjectInterfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedObject(LiveShowObjectInterface p_LiveShowObjectInterface) {
        this.clearSelectedObjects(true);
        if (p_LiveShowObjectInterface != null) {
            if (!this.accepts(p_LiveShowObjectInterface)) {
                return;
            }
            if (!p_LiveShowObjectInterface.setSelected(true, false)) {
                return;
            }
            Object object = this.m_SyncSelection;
            synchronized (object) {
                this.m_SelectedObjectInterfaces.add(p_LiveShowObjectInterface);
                if (p_LiveShowObjectInterface instanceof LiveShowSceneBridge) {
                    if (!this.m_SelectedSceneBridges_Only.contains(p_LiveShowObjectInterface)) {
                        this.m_SelectedSceneBridges_Only.add((LiveShowSceneBridge)p_LiveShowObjectInterface);
                    }
                } else if (!this.m_SelectedObjects_Only.contains(p_LiveShowObjectInterface)) {
                    this.m_SelectedObjects_Only.add(p_LiveShowObjectInterface);
                }
            }
        }
        if (p_LiveShowObjectInterface instanceof LiveShowSceneBridge) {
            this.setSelectionSceneBridgeOther((LiveShowSceneBridge)p_LiveShowObjectInterface, true, false);
        }
        this.notifyLiveShowVIPListeners_ObjectSelection(p_LiveShowObjectInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectedObject(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        if (!this.accepts(p_LiveShowObjectInterface)) {
            return;
        }
        Object object = this.m_SyncSelection;
        synchronized (object) {
            if (this.m_SelectedObjectInterfaces.contains(p_LiveShowObjectInterface)) {
                return;
            }
            this.m_SelectedObjectInterfaces.add(p_LiveShowObjectInterface);
        }
        if (!p_LiveShowObjectInterface.setSelected(true, true)) {
            return;
        }
        if (p_LiveShowObjectInterface instanceof LiveShowSceneBridge) {
            object = this.m_SyncSelection;
            synchronized (object) {
                if (!this.m_SelectedSceneBridges_Only.contains(p_LiveShowObjectInterface)) {
                    this.m_SelectedSceneBridges_Only.add((LiveShowSceneBridge)p_LiveShowObjectInterface);
                }
            }
        }
        object = this.m_SyncSelection;
        synchronized (object) {
            if (!this.m_SelectedObjects_Only.contains(p_LiveShowObjectInterface)) {
                this.m_SelectedObjects_Only.add(p_LiveShowObjectInterface);
            }
        }
        if (p_LiveShowObjectInterface instanceof LiveShowSceneBridge) {
            this.setSelectionSceneBridgeOther((LiveShowSceneBridge)p_LiveShowObjectInterface, true, true);
        }
        this.notifyLiveShowVIPListeners_ObjectSelection(p_LiveShowObjectInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectedObject(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        if (!this.accepts(p_LiveShowObjectInterface)) {
            return;
        }
        boolean boolRemoved = false;
        if (!p_LiveShowObjectInterface.setSelected(false, true)) {
            return;
        }
        Object object = this.m_SyncSelection;
        synchronized (object) {
            if (this.m_SelectedObjectInterfaces.remove(p_LiveShowObjectInterface)) {
                boolRemoved = true;
                this.m_SelectedSceneBridges_Only.remove(p_LiveShowObjectInterface);
                this.m_SelectedObjects_Only.remove(p_LiveShowObjectInterface);
            }
            this.m_SelectedObjects_Only.remove(p_LiveShowObjectInterface);
        }
        if (boolRemoved) {
            if (p_LiveShowObjectInterface instanceof LiveShowSceneBridge) {
                this.setSelectionSceneBridgeOther((LiveShowSceneBridge)p_LiveShowObjectInterface, false, true);
            }
            this.notifyLiveShowVIPListeners_ObjectSelection(p_LiveShowObjectInterface);
        }
    }

    private void setSelectionSceneBridgeOther(LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_Selected, boolean p_Added) {
        LiveShowSceneBridgeMain o_LiveShowSceneBridgeMain;
        if (p_LiveShowSceneBridge.getIsMainBridge() && (o_LiveShowSceneBridgeMain = p_LiveShowSceneBridge.getLiveShowSceneBridgeMain()) != null) {
            for (int intBridge = 0; intBridge < o_LiveShowSceneBridgeMain.getLiveShowSceneBridgeCount(); ++intBridge) {
                LiveShowVIP o_LiveShowVIP;
                LiveShowSceneBridge o_LiveShowSceneBridge = o_LiveShowSceneBridgeMain.getLiveShowSceneBridge(intBridge);
                if (o_LiveShowSceneBridge == null || o_LiveShowSceneBridge == p_LiveShowSceneBridge || (o_LiveShowVIP = o_LiveShowSceneBridge.getLiveShowVIP()) == null) continue;
                o_LiveShowVIP.setSelectionSceneBridgeMain(o_LiveShowSceneBridge, p_Selected, p_Added);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectionSceneBridgeMain(LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_Selected, boolean p_Added) {
        if (p_LiveShowSceneBridge == null) {
            return;
        }
        boolean boolChanged = false;
        Object object = this.m_SyncSelection;
        synchronized (object) {
            if (p_Selected) {
                p_LiveShowSceneBridge.setSelected(true, p_Added);
                if (this.m_SelectedObjectInterfaces.contains(p_LiveShowSceneBridge)) {
                    return;
                }
                boolChanged = true;
                this.m_SelectedObjectInterfaces.add(p_LiveShowSceneBridge);
                this.m_SelectedSceneBridges_Only.add(p_LiveShowSceneBridge);
            } else {
                p_LiveShowSceneBridge.setSelected(false, p_Added);
                if (this.m_SelectedObjectInterfaces.remove(p_LiveShowSceneBridge)) {
                    boolChanged = true;
                    this.m_SelectedSceneBridges_Only.remove(p_LiveShowSceneBridge);
                }
            }
        }
        if (boolChanged) {
            this.notifyLiveShowVIPListeners_ObjectSelection(p_LiveShowSceneBridge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSelectedObjects(boolean p_ClearFriends) {
        Object object;
        while (true) {
            LiveShowObjectInterface o_LiveShowObjectInterface;
            object = this.m_SyncSelection;
            synchronized (object) {
                if (this.m_SelectedObjectInterfaces.size() <= 0) {
                    break;
                }
                o_LiveShowObjectInterface = this.m_SelectedObjectInterfaces.get(this.m_SelectedObjectInterfaces.size() - 1);
            }
            this.removeSelectedObject(o_LiveShowObjectInterface);
        }
        object = this.m_SyncSelection;
        synchronized (object) {
            this.m_SelectedObjectInterfaces.clear();
            this.m_SelectedSceneBridges_Only.clear();
            this.m_SelectedObjects_Only.clear();
        }
        if (p_ClearFriends) {
            for (int intVIP = this.m_FriendVIPs.size() - 1; intVIP >= 0; --intVIP) {
                LiveShowVIP o_LiveShowVIP = this.m_FriendVIPs.get(intVIP);
                if (o_LiveShowVIP == null) continue;
                o_LiveShowVIP.clearSelectedObjects(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectObjectsFromPosition(long p_FramePosition, boolean p_SelectFriends) {
        this.clearSelectedObjects(false);
        Object object = this.m_SyncObjects;
        synchronized (object) {
            for (int intObject = 0; intObject < this.m_LiveShowObjects.size(); ++intObject) {
                LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowObjects.get(intObject);
                if (o_LiveShowObjectInterface == null || o_LiveShowObjectInterface.getFrameStart() < p_FramePosition) continue;
                this.addSelectedObject(o_LiveShowObjectInterface);
            }
        }
        if (p_SelectFriends) {
            for (int intVIP = 0; intVIP < this.m_FriendVIPs.size(); ++intVIP) {
                LiveShowVIP o_LiveShowVIP = this.m_FriendVIPs.get(intVIP);
                if (o_LiveShowVIP == null) continue;
                o_LiveShowVIP.selectObjectsFromPosition(p_FramePosition, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObjectsFromPositionToSelection(long p_FramePosition, boolean p_SelectFriends) {
        Object object = this.m_SyncObjects;
        synchronized (object) {
            for (int intObject = 0; intObject < this.m_LiveShowObjects.size(); ++intObject) {
                LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowObjects.get(intObject);
                if (o_LiveShowObjectInterface == null || o_LiveShowObjectInterface.getFrameStart() < p_FramePosition) continue;
                this.addSelectedObject(o_LiveShowObjectInterface);
            }
        }
        if (p_SelectFriends) {
            for (int intVIP = 0; intVIP < this.m_FriendVIPs.size(); ++intVIP) {
                LiveShowVIP o_LiveShowVIP = this.m_FriendVIPs.get(intVIP);
                if (o_LiveShowVIP == null) continue;
                o_LiveShowVIP.addObjectsFromPositionToSelection(p_FramePosition, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObjectsFromPositionToSelection(long p_FramePosition, boolean p_SelectFriends) {
        Object object = this.m_SyncObjects;
        synchronized (object) {
            for (int intObject = 0; intObject < this.m_LiveShowObjects.size(); ++intObject) {
                LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowObjects.get(intObject);
                if (o_LiveShowObjectInterface.getFrameStart() < p_FramePosition) continue;
                this.removeSelectedObject(o_LiveShowObjectInterface);
            }
        }
        if (p_SelectFriends) {
            for (int intVIP = 0; intVIP < this.m_FriendVIPs.size(); ++intVIP) {
                LiveShowVIP o_LiveShowVIP = this.m_FriendVIPs.get(intVIP);
                if (o_LiveShowVIP == null) continue;
                o_LiveShowVIP.removeObjectsFromPositionToSelection(p_FramePosition, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSelectedObjectsCount() {
        Object object = this.m_SyncSelection;
        synchronized (object) {
            return this.m_SelectedObjectInterfaces.size();
        }
    }

    public ArrayList<LiveShowObjectInterface> getSelectedObjectInterfaces() {
        return this.m_SelectedObjectInterfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowObjectInterface getSelectedObjectInterface(int p_Index) {
        Object object = this.m_SyncSelection;
        synchronized (object) {
            if (p_Index < 0 || p_Index >= this.m_SelectedObjectInterfaces.size()) {
                return null;
            }
            return this.m_SelectedObjectInterfaces.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<LiveShowObjectDescription> getSelectedObjectDescriptions() {
        ArrayList<LiveShowObjectDescription> o_ObjectDescriptions = new ArrayList<LiveShowObjectDescription>();
        Object object = this.m_SyncSelection;
        synchronized (object) {
            for (int intObject = 0; intObject < this.m_SelectedObjectInterfaces.size(); ++intObject) {
                o_ObjectDescriptions.add(this.m_SelectedObjectInterfaces.get(intObject).getDescription());
            }
        }
        return o_ObjectDescriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowObjectDescription getSelectedObjectDescription(int p_Index) {
        Object object = this.m_SyncSelection;
        synchronized (object) {
            if (p_Index < 0 || p_Index >= this.m_SelectedObjectInterfaces.size()) {
                return null;
            }
            return this.m_SelectedObjectInterfaces.get(p_Index).getDescription();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSelectedObjects() {
        ArrayList<LiveShowObjectInterface> o_LiveShowObjectInterfaces;
        Object object = this.m_SyncSelection;
        synchronized (object) {
            if (this.m_SelectedObjectInterfaces == null || this.m_SelectedObjectInterfaces.size() <= 0) {
                return;
            }
            int intObjectCount = this.m_SelectedObjectInterfaces.size();
            o_LiveShowObjectInterfaces = new ArrayList<LiveShowObjectInterface>(intObjectCount);
            o_LiveShowObjectInterfaces.addAll(this.m_SelectedObjectInterfaces);
            this.m_SelectedObjectInterfaces.clear();
            this.m_SelectedSceneBridges_Only.clear();
            this.m_SelectedObjects_Only.clear();
        }
        for (int intObject = o_LiveShowObjectInterfaces.size() - 1; intObject >= 0; --intObject) {
            LiveShowObjectInterface o_LiveShowObjectInterface = (LiveShowObjectInterface)o_LiveShowObjectInterfaces.get(intObject);
            if (o_LiveShowObjectInterface == null) continue;
            o_LiveShowObjectInterface.close(true);
        }
        o_LiveShowObjectInterfaces.clear();
    }

    public ArrayList<LiveShowSceneBridge> getSelectedSceneBridges_Only() {
        return this.m_SelectedSceneBridges_Only;
    }

    public ArrayList<LiveShowObjectInterface> getSelectedObjects_Only() {
        return this.m_SelectedObjects_Only;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowObjectInterface findLiveShowObjectInterface(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveShowObjectInterface o_LiveShowObjectInterface = null;
        Object object = this.m_SyncObjects;
        synchronized (object) {
            for (int intObject = 0; intObject < this.m_LiveShowObjects.size(); ++intObject) {
                o_LiveShowObjectInterface = this.m_LiveShowObjects.get(intObject);
                if (o_LiveShowObjectInterface == null) continue;
                if (p_ID.equals(o_LiveShowObjectInterface.getID())) break;
                o_LiveShowObjectInterface = null;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowObjectInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsLiveShowObjectInterface(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolContains = false;
        Object object = this.m_SyncObjects;
        synchronized (object) {
            for (int intObject = 0; intObject < this.m_LiveShowObjects.size(); ++intObject) {
                LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowObjects.get(intObject);
                if (o_LiveShowObjectInterface != p_LiveShowObjectInterface) continue;
                boolContains = true;
                break;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolContains;
    }

    public ArrayList<LiveShowObjectInterface> getLiveShowObjectInterfaces() {
        return this.m_LiveShowObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLiveShowObjectInterfaceCount() {
        Object object = this.m_SyncObjects;
        synchronized (object) {
            return this.m_LiveShowObjects.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowObjectInterface getLiveShowObjectInterface(int p_Index) {
        if (this.m_LiveShowObjects == null) {
            return null;
        }
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (p_Index >= this.m_LiveShowObjects.size()) {
                return null;
            }
            return this.m_LiveShowObjects.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLiveShowObjectInterfaceIndex(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return -1;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            return this.m_LiveShowObjects.indexOf(p_LiveShowObjectInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowObjectInterface getLiveShowObjectInterface(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        LiveShowObjectInterface o_LiveShowObjectInterface = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (this.m_LiveShowObjects != null) {
                for (int intObject = 0; intObject < this.m_LiveShowObjects.size(); ++intObject) {
                    o_LiveShowObjectInterface = this.m_LiveShowObjects.get(intObject);
                    if (o_LiveShowObjectInterface == null) continue;
                    if (o_LiveShowObjectInterface.getIsSceneBridge()) {
                        o_LiveShowObjectInterface = null;
                        continue;
                    }
                    if (p_ID.equals(o_LiveShowObjectInterface.getID())) break;
                    o_LiveShowObjectInterface = null;
                }
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowObjectInterface;
    }

    public abstract LiveShowSceneBridge createLiveShowSceneBridge(LiveShowObjectDescription var1);

    public abstract LiveShowSceneBridge createLiveShowSceneBridge(LiveShowSceneBridgeMain var1, LiveShowObjectDescription var2);

    public boolean addLiveShowSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge, long p_FramePosition) {
        if (p_LiveShowSceneBridge == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolAdded = false;
        if (!this.m_SceneBridges.contains(p_LiveShowSceneBridge)) {
            p_LiveShowSceneBridge.changeStartPosition(p_FramePosition);
            this.addSorted_LiveShowSceneBridge(p_LiveShowSceneBridge);
            p_LiveShowSceneBridge.setLiveShowVIP(this);
            boolAdded = true;
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if (boolAdded) {
            if (p_LiveShowSceneBridge.getIsMainBridge()) {
                LiveShowSceneBridgeMain o_LiveShowSceneBridgeMain = LiveShowSceneBridgeMain.getMainBridgeContainer().getCreateMainBridge(p_LiveShowSceneBridge.getID(), p_LiveShowSceneBridge.getFrameStart(), false);
                o_LiveShowSceneBridgeMain.addSceneBridge(p_LiveShowSceneBridge);
            }
            this.addLiveShowObject(p_LiveShowSceneBridge);
            this.notifyLiveShowVIPListeners_SceneBridgeAdded(p_LiveShowSceneBridge);
            Play o_Play = this.m_Play;
            if (o_Play != null) {
                this.checkSceneBridge_PlayCursor(o_Play.getPlayCursor());
            }
        }
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSorted_LiveShowSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowSceneBridge == null) {
            return;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            LiveShowSceneBridge o_LiveShowSceneBridge;
            int intBridge;
            for (intBridge = 0; intBridge < this.m_SceneBridges.size() && ((o_LiveShowSceneBridge = this.m_SceneBridges.get(intBridge)) == null || o_LiveShowSceneBridge.getFrameStart() < p_LiveShowSceneBridge.getFrameStart()); ++intBridge) {
            }
            this.m_SceneBridges.add(intBridge, p_LiveShowSceneBridge);
        }
        this.m_SceneBridgesListModel.add((Object)p_LiveShowSceneBridge);
        this.checkOverlappingSceneBridges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resort_LiveShowSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge) {
        Object object = this.m_SyncObjects;
        synchronized (object) {
            LiveShowSceneBridge o_LiveShowSceneBridge;
            int intBridge;
            if (this.m_SceneBridges.size() < 2) {
                return;
            }
            int intIndex = this.m_SceneBridges.indexOf(p_LiveShowSceneBridge);
            if (intIndex < 0) {
                return;
            }
            boolean boolResorted = false;
            for (intBridge = 0; intBridge < this.m_SceneBridges.size() && (intBridge == intIndex || (o_LiveShowSceneBridge = this.m_SceneBridges.get(intBridge)) == null || p_LiveShowSceneBridge.getFrameStart() > o_LiveShowSceneBridge.getFrameStart()); ++intBridge) {
            }
            if (intBridge == intIndex + 1) {
                this.checkOverlappingSceneBridges();
                return;
            }
            if (intBridge < intIndex) {
                this.m_SceneBridges.remove(intIndex);
                this.m_SceneBridges.add(intBridge, p_LiveShowSceneBridge);
                this.m_SceneBridgesListModel.remove((Object)p_LiveShowSceneBridge);
                this.m_SceneBridgesListModel.add((Object)p_LiveShowSceneBridge);
                boolResorted = true;
            }
            if (intBridge > intIndex) {
                this.m_SceneBridges.remove(intIndex);
                this.m_SceneBridges.add(intBridge - 1, p_LiveShowSceneBridge);
                this.m_SceneBridgesListModel.remove((Object)p_LiveShowSceneBridge);
                this.m_SceneBridgesListModel.add((Object)p_LiveShowSceneBridge);
                boolResorted = true;
            }
        }
        this.checkOverlappingSceneBridges();
        this.notifyLiveShowVIPListeners_SceneBridgesResorted(p_LiveShowSceneBridge, this.m_SceneBridges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkOverlappingSceneBridges() {
        ArrayList<LiveShowSceneBridge> o_LiveShowSceneBridges;
        LiveShowSceneBridge o_SceneBridge_Previous = null;
        LiveShowSceneBridge o_SceneBridge = null;
        LiveShowSceneBridge o_SceneBridge_Next = null;
        Object object = this.m_SyncObjects;
        synchronized (object) {
            o_LiveShowSceneBridges = new ArrayList<LiveShowSceneBridge>(this.m_SceneBridges.size());
            o_LiveShowSceneBridges.addAll(this.m_SceneBridges);
        }
        long longMinFramesDistance = LiveShowObject.MIN_FRAMELENGTH;
        for (int intBridge = 0; intBridge < o_LiveShowSceneBridges.size(); ++intBridge) {
            o_SceneBridge = (LiveShowSceneBridge)o_LiveShowSceneBridges.get(intBridge);
            if (o_SceneBridge == null) continue;
            if (intBridge > 0) {
                o_SceneBridge_Previous = (LiveShowSceneBridge)o_LiveShowSceneBridges.get(intBridge - 1);
            }
            if (intBridge < o_LiveShowSceneBridges.size() - 1) {
                o_SceneBridge_Next = (LiveShowSceneBridge)o_LiveShowSceneBridges.get(intBridge + 1);
            }
            boolean boolOverlap = false;
            if (o_SceneBridge_Previous != null && o_SceneBridge.getFrameStart() >= o_SceneBridge_Previous.getFrameStart() && o_SceneBridge.getFrameStart() < o_SceneBridge_Previous.getFrameEnd() + longMinFramesDistance) {
                boolOverlap = true;
            }
            if (o_SceneBridge_Next != null && o_SceneBridge.getFrameEnd() >= o_SceneBridge_Next.getFrameStart() - longMinFramesDistance && o_SceneBridge.getFrameStart() < o_SceneBridge_Next.getFrameEnd()) {
                boolOverlap = true;
            }
            o_SceneBridge_Previous = null;
            o_SceneBridge_Next = null;
            o_SceneBridge.setOverlap(boolOverlap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateFramesToNextSceneBridge() {
        ArrayList<LiveShowSceneBridge> o_LiveShowSceneBridges;
        Object object = this.m_SyncObjects;
        synchronized (object) {
            o_LiveShowSceneBridges = new ArrayList<LiveShowSceneBridge>(this.m_SceneBridges.size());
            o_LiveShowSceneBridges.addAll(this.m_SceneBridges);
        }
        for (int intSceneBridge = 0; intSceneBridge < o_LiveShowSceneBridges.size(); ++intSceneBridge) {
            LiveShowSceneBridge o_LiveShowSceneBridge = (LiveShowSceneBridge)o_LiveShowSceneBridges.get(intSceneBridge);
            if (o_LiveShowSceneBridge == null) continue;
            if (intSceneBridge < o_LiveShowSceneBridges.size() - 1) {
                LiveShowSceneBridge o_LiveShowSceneBridgeNext = (LiveShowSceneBridge)o_LiveShowSceneBridges.get(intSceneBridge + 1);
                o_LiveShowSceneBridge.setFramesToNextSceneBridge(o_LiveShowSceneBridgeNext.getFrameStart() - o_LiveShowSceneBridge.getFrameStart());
                continue;
            }
            o_LiveShowSceneBridge.setFramesToNextSceneBridge(this.getFrameEnd() - o_LiveShowSceneBridge.getFrameStart());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge) {
        boolean boolRemoved;
        if (p_LiveShowSceneBridge == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            boolRemoved = this.m_SceneBridges.remove(p_LiveShowSceneBridge);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if (boolRemoved) {
            this.m_SceneBridgesListModel.remove((Object)p_LiveShowSceneBridge);
            this.removeLiveShowObject(p_LiveShowSceneBridge);
            p_LiveShowSceneBridge.setLiveShowVIP(null);
            p_LiveShowSceneBridge.close(true);
            this.notifyLiveShowVIPListeners_SceneBridgeRemoved(p_LiveShowSceneBridge);
            Play o_Play = this.m_Play;
            if (o_Play != null) {
                this.checkSceneBridge_PlayCursor(o_Play.getPlayCursor());
            }
            this.checkOverlappingSceneBridges();
        }
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLiveShowSceneBridgeCount() {
        int intSceneBridgeCount = 0;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return 0;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (this.m_SceneBridges != null) {
                intSceneBridgeCount = this.m_SceneBridges.size();
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return intSceneBridgeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowSceneBridge getLiveShowSceneBridge(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        LiveShowSceneBridge o_LiveShowSoundSceneBridge = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (this.m_SceneBridges != null && p_Index < this.m_SceneBridges.size()) {
                o_LiveShowSoundSceneBridge = this.m_SceneBridges.get(p_Index);
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowSoundSceneBridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowSceneBridge getLiveShowSceneBridge(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        LiveShowSceneBridge o_LiveShowSoundSceneBridge = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (this.m_SceneBridges != null) {
                for (int intBridge = 0; intBridge < this.m_SceneBridges.size(); ++intBridge) {
                    o_LiveShowSoundSceneBridge = this.m_SceneBridges.get(intBridge);
                    if (o_LiveShowSoundSceneBridge == null) continue;
                    if (p_ID.equals(o_LiveShowSoundSceneBridge.getID())) break;
                    o_LiveShowSoundSceneBridge = null;
                }
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowSoundSceneBridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowSceneBridge getLiveShowSceneBridge(long p_StartFrame) {
        if (p_StartFrame < 0L) {
            return null;
        }
        LiveShowSceneBridge o_LiveShowSoundSceneBridge = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (this.m_SceneBridges != null) {
                for (int intBridge = 0; intBridge < this.m_SceneBridges.size(); ++intBridge) {
                    o_LiveShowSoundSceneBridge = this.m_SceneBridges.get(intBridge);
                    if (o_LiveShowSoundSceneBridge == null) continue;
                    if (p_StartFrame == o_LiveShowSoundSceneBridge.getFrameStart()) break;
                    if (o_LiveShowSoundSceneBridge.getFrameStart() > p_StartFrame) {
                        o_LiveShowSoundSceneBridge = null;
                        break;
                    }
                    o_LiveShowSoundSceneBridge = null;
                }
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowSoundSceneBridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLiveShowSceneBridgeNumber(LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_CountOnlyMainBridges) {
        if (p_LiveShowSceneBridge == null) {
            return -1;
        }
        int intSceneBridgeNumber = -1;
        if (p_CountOnlyMainBridges && !this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return -1;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (!p_CountOnlyMainBridges) {
                intSceneBridgeNumber = this.m_SceneBridges.indexOf(p_LiveShowSceneBridge);
            } else {
                LiveShowSceneBridge o_LiveShowSceneBridge;
                intSceneBridgeNumber = 0;
                for (int intSceneBridge = 0; intSceneBridge < this.m_SceneBridges.size() && (o_LiveShowSceneBridge = this.m_SceneBridges.get(intSceneBridge)) != p_LiveShowSceneBridge; ++intSceneBridge) {
                    if (o_LiveShowSceneBridge == null || !o_LiveShowSceneBridge.getIsMainBridge()) continue;
                    ++intSceneBridgeNumber;
                }
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return intSceneBridgeNumber;
    }

    public int getIndexOfSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge) {
        int intIndex = -1;
        if (p_LiveShowSceneBridge == null) {
            return -1;
        }
        if (this.m_SceneBridges == null || this.m_SceneBridges.size() <= 0) {
            return -1;
        }
        intIndex = this.getLiveShowSceneBridgeIndex_At(p_LiveShowSceneBridge.getFrameStart());
        return intIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLiveShowSceneBridgeIndex_At(long p_FramePosition) {
        LiveShowSceneBridge o_LiveShowSceneBridge = null;
        int intBridgeIndex = -1;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return -1;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (this.m_SceneBridges == null || this.m_SceneBridges.size() <= 0) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return -1;
            }
            int intBridgeIndex_Start = 0;
            int intBridgeIndex_End = this.m_SceneBridges.size() - 1;
            intBridgeIndex = (intBridgeIndex_End - intBridgeIndex_Start) / 2;
            while (o_LiveShowSceneBridge == null && (p_FramePosition < (o_LiveShowSceneBridge = this.m_SceneBridges.get(intBridgeIndex)).getFrameStart() || p_FramePosition >= o_LiveShowSceneBridge.getFrameStart() + o_LiveShowSceneBridge.getFrameLength())) {
                if (p_FramePosition > o_LiveShowSceneBridge.getFrameStart()) {
                    intBridgeIndex_Start = intBridgeIndex + 1;
                    if (intBridgeIndex_Start > intBridgeIndex_End) {
                        intBridgeIndex = -1;
                        break;
                    }
                    intBridgeIndex = intBridgeIndex_Start + (intBridgeIndex_End - intBridgeIndex_Start) / 2;
                } else if (p_FramePosition < o_LiveShowSceneBridge.getFrameStart()) {
                    intBridgeIndex_End = intBridgeIndex - 1;
                    if (intBridgeIndex_End < intBridgeIndex_Start) {
                        intBridgeIndex = -1;
                        break;
                    }
                    intBridgeIndex = intBridgeIndex_Start + (intBridgeIndex_End - intBridgeIndex_Start) / 2;
                }
                o_LiveShowSceneBridge = null;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return intBridgeIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowSceneBridge getLiveShowSceneBridge_NextOLD(long p_FramePosition, boolean p_OnlyMainBridges, boolean p_OnlyActiveBridges) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        if (this.m_SceneBridges.size() <= 0) {
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            return null;
        }
        LiveShowSceneBridge o_ResultSceneBridge = null;
        Object object = this.m_SyncObjects;
        synchronized (object) {
            int intStartIndex = this.m_SceneBridges.size() / 2;
            if (this.m_SceneBridges.get(intStartIndex).getFrameStart() >= p_FramePosition) {
                intStartIndex = 0;
            }
            for (int intBridge = intStartIndex; intBridge < this.m_SceneBridges.size(); ++intBridge) {
                LiveShowSceneBridge o_LiveShowSceneBridge = this.m_SceneBridges.get(intBridge);
                if (o_LiveShowSceneBridge == null || p_OnlyActiveBridges && !o_LiveShowSceneBridge.getActive() || p_OnlyMainBridges && !o_LiveShowSceneBridge.getIsMainBridge() || o_LiveShowSceneBridge.getFrameStart() < p_FramePosition || o_ResultSceneBridge != null) continue;
                o_ResultSceneBridge = o_LiveShowSceneBridge;
                break;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_ResultSceneBridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_Next(long p_FramePosition, boolean p_OnlyMainBridges, boolean p_OnlyActiveBridges) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveShowSceneBridge o_LiveShowSceneBridge = null;
        LiveShowSceneBridge o_LiveShowSceneBridgeResult = null;
        int intBridgeIndex = -1;
        int intTestCounter = 0;
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (this.m_SceneBridges == null || this.m_SceneBridges.size() <= 0) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return null;
            }
            int intBridgeIndex_Start = 0;
            int intBridgeIndex_End = this.m_SceneBridges.size() - 1;
            intBridgeIndex = (intBridgeIndex_End - intBridgeIndex_Start) / 2;
            while (o_LiveShowSceneBridge == null) {
                ++intTestCounter;
                o_LiveShowSceneBridge = this.m_SceneBridges.get(intBridgeIndex);
                if (p_FramePosition == o_LiveShowSceneBridge.getFrameStart()) {
                    if (p_OnlyActiveBridges && !o_LiveShowSceneBridge.getActive() || p_OnlyMainBridges && !o_LiveShowSceneBridge.getIsMainBridge()) {
                        ++p_FramePosition;
                    } else {
                        o_LiveShowSceneBridgeResult = o_LiveShowSceneBridge;
                        break;
                    }
                }
                if (p_FramePosition > o_LiveShowSceneBridge.getFrameStart()) {
                    intBridgeIndex_Start = intBridgeIndex + 1;
                    if (intBridgeIndex_Start > intBridgeIndex_End) break;
                    intBridgeIndex = intBridgeIndex_Start + (intBridgeIndex_End - intBridgeIndex_Start) / 2;
                } else {
                    intBridgeIndex_End = intBridgeIndex - 1;
                    if (intBridgeIndex_End < intBridgeIndex_Start) break;
                    intBridgeIndex = intBridgeIndex_Start + (intBridgeIndex_End - intBridgeIndex_Start) / 2;
                }
                o_LiveShowSceneBridge = null;
            }
            if (o_LiveShowSceneBridgeResult == null) {
                for (intBridgeIndex = intBridgeIndex_Start; intBridgeIndex < this.m_SceneBridges.size(); ++intBridgeIndex) {
                    ++intTestCounter;
                    o_LiveShowSceneBridge = this.m_SceneBridges.get(intBridgeIndex);
                    if (p_FramePosition > o_LiveShowSceneBridge.getFrameStart() || p_OnlyActiveBridges && !o_LiveShowSceneBridge.getActive() || p_OnlyMainBridges && !o_LiveShowSceneBridge.getIsMainBridge()) continue;
                    o_LiveShowSceneBridgeResult = o_LiveShowSceneBridge;
                    break;
                }
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowSceneBridgeResult;
    }

    private void tempPrintResult(String p_Direction, LiveShowSceneBridge o_LiveShowSceneBridgeResult, LiveShowSceneBridge o_LiveShowSceneBridge_OLD, long p_FramePosition, boolean p_OnlyMainBridges, boolean p_OnlyActiveBridges) {
        if (o_LiveShowSceneBridgeResult != o_LiveShowSceneBridge_OLD) {
            System.out.println("ERROR_GetSceneBridge");
        }
        System.out.print("LiveShowVIP " + this.getType() + " getSceneBridge " + p_Direction + " (" + p_FramePosition + ")   onlyMain: " + p_OnlyMainBridges + " onlyActive: " + p_OnlyActiveBridges);
        System.out.print("   ResultNew: ");
        if (o_LiveShowSceneBridgeResult != null) {
            System.out.print(o_LiveShowSceneBridgeResult.getName());
        } else {
            System.out.print("NULL");
        }
        System.out.print("     OLD: ");
        if (o_LiveShowSceneBridge_OLD != null) {
            System.out.println(o_LiveShowSceneBridge_OLD.getName());
        } else {
            System.out.println("NULL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowSceneBridge getLiveShowSceneBridge_Next(LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_OnlyMainBridges, boolean p_OnlyActiveBridges) {
        Play o_Play = this.m_Play;
        if (p_LiveShowSceneBridge == null) {
            if (o_Play == null) {
                return null;
            }
            return this.getLiveShowSceneBridge_Next(o_Play.getPlayCursor(), p_OnlyMainBridges, p_OnlyActiveBridges);
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveShowSceneBridge o_LiveShowSceneBridge = null;
        Object object = this.m_SyncObjects;
        synchronized (object) {
            int intIndex = this.m_SceneBridges.indexOf(p_LiveShowSceneBridge);
            if (intIndex < 0) {
                intIndex = 0;
            }
            ++intIndex;
            while (intIndex < this.m_SceneBridges.size()) {
                o_LiveShowSceneBridge = this.m_SceneBridges.get(intIndex);
                if (p_OnlyMainBridges && !o_LiveShowSceneBridge.getIsMainBridge()) {
                    ++intIndex;
                    o_LiveShowSceneBridge = null;
                    continue;
                }
                if (!p_OnlyActiveBridges || o_LiveShowSceneBridge.getActive()) break;
                ++intIndex;
                o_LiveShowSceneBridge = null;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowSceneBridge;
    }

    public LiveShowSceneBridge getLiveShowSceneBridge_NextToPlay(LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_OnlyMainScenes) {
        long longFrameStart;
        Play o_Play = this.m_Play;
        if (p_LiveShowSceneBridge == null) {
            if (o_Play == null) {
                return null;
            }
            longFrameStart = o_Play.getPlayCursor();
        } else {
            longFrameStart = p_LiveShowSceneBridge.getFrameStart() + 1L;
        }
        LiveShowSceneBridge o_LiveShowSceneBridge = this.getLiveShowSceneBridge_NextToPlay(longFrameStart, p_OnlyMainScenes);
        return o_LiveShowSceneBridge;
    }

    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_NextToPlay(long p_StartFrame, boolean p_OnlyMainScenes) {
        LiveShowSceneBridge o_LiveShowSceneBridge = null;
        LiveShowSceneBridge o_LiveShowMainSceneBridge = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        if (!p_OnlyMainScenes) {
            long longStartFrame = p_StartFrame;
            boolean boolActive = false;
            while (!boolActive) {
                o_LiveShowSceneBridge = this.getLiveShowSceneBridge_Next(longStartFrame, p_OnlyMainScenes, false);
                if (o_LiveShowSceneBridge == null) {
                    boolActive = true;
                    continue;
                }
                if (!o_LiveShowSceneBridge.getActive()) {
                    if (o_LiveShowSceneBridge.getIsMainBridge()) {
                        boolActive = true;
                        o_LiveShowSceneBridge = this.getLiveShowSceneBridge_Next(longStartFrame, true, true);
                        continue;
                    }
                    longStartFrame = o_LiveShowSceneBridge.getFrameStart() + 1L;
                    continue;
                }
                o_LiveShowMainSceneBridge = this.getLiveShowSceneBridge_Previous(longStartFrame, true, false);
                if (o_LiveShowMainSceneBridge == null) {
                    boolActive = true;
                    continue;
                }
                if (!o_LiveShowMainSceneBridge.getActive()) {
                    boolActive = true;
                    o_LiveShowSceneBridge = this.getLiveShowSceneBridge_Next(longStartFrame, true, true);
                    continue;
                }
                boolActive = true;
            }
        } else {
            o_LiveShowSceneBridge = this.getLiveShowSceneBridge_Next(p_StartFrame, true, true);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowSceneBridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowSceneBridge getLiveShowSceneBridge_PreviousOLD(long p_FramePosition, boolean p_OnlyMainBridges, boolean p_OnlyActiveBridges) {
        LiveShowSceneBridge o_ResultSceneBridge = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (this.m_SceneBridges == null || this.m_SceneBridges.size() <= 0) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return null;
            }
            int intStartIndex = this.m_SceneBridges.size() / 2;
            if (this.m_SceneBridges.get(intStartIndex).getFrameStart() < p_FramePosition) {
                intStartIndex = this.m_SceneBridges.size() - 1;
            }
            for (int intBridge = intStartIndex; intBridge >= 0; --intBridge) {
                LiveShowSceneBridge o_LiveShowSceneBridge = this.m_SceneBridges.get(intBridge);
                if (o_LiveShowSceneBridge == null || p_OnlyActiveBridges && !o_LiveShowSceneBridge.getActive() || p_OnlyMainBridges && !o_LiveShowSceneBridge.getIsMainBridge() || o_LiveShowSceneBridge == this.m_ActualSceneBridge || o_LiveShowSceneBridge.getFrameStart() >= p_FramePosition || o_ResultSceneBridge != null) continue;
                o_ResultSceneBridge = o_LiveShowSceneBridge;
                break;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_ResultSceneBridge;
    }

    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_Previous(long p_FramePosition, boolean p_OnlyMainBridges, boolean p_OnlyActiveBridges) {
        return this.getLiveShowSceneBridge_Previous(p_FramePosition, false, false, p_OnlyMainBridges, p_OnlyActiveBridges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LiveShowSceneBridge getLiveShowSceneBridge_Previous(long p_FramePosition, boolean p_IncludeEqualFrameStart, boolean p_IncludeActualBridge, boolean p_OnlyMainBridges, boolean p_OnlyActiveBridges) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveShowSceneBridge o_LiveShowSceneBridge = null;
        LiveShowSceneBridge o_LiveShowSceneBridgeResult = null;
        int intBridgeIndex = -1;
        int intCounter = 0;
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (this.m_SceneBridges == null || this.m_SceneBridges.size() <= 0) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return null;
            }
            int intBridgeIndex_Start = 0;
            int intBridgeIndex_End = this.m_SceneBridges.size() - 1;
            intBridgeIndex = (intBridgeIndex_End - intBridgeIndex_Start) / 2;
            while (o_LiveShowSceneBridge == null) {
                ++intCounter;
                o_LiveShowSceneBridge = this.m_SceneBridges.get(intBridgeIndex);
                if (p_FramePosition > o_LiveShowSceneBridge.getFrameStart()) {
                    intBridgeIndex_Start = intBridgeIndex + 1;
                    if (intBridgeIndex_End < intBridgeIndex_Start) {
                        if (intBridgeIndex_Start < this.m_SceneBridges.size()) break;
                        intBridgeIndex_Start = this.m_SceneBridges.size() - 1;
                        break;
                    }
                    intBridgeIndex = intBridgeIndex_End - (intBridgeIndex_End - intBridgeIndex_Start) / 2;
                } else {
                    intBridgeIndex_End = intBridgeIndex - 1;
                    if (intBridgeIndex_Start > intBridgeIndex_End) break;
                    intBridgeIndex = intBridgeIndex_End - (intBridgeIndex_End - intBridgeIndex_Start) / 2;
                }
                o_LiveShowSceneBridge = null;
            }
            if (o_LiveShowSceneBridgeResult == null) {
                for (intBridgeIndex = intBridgeIndex_Start; intBridgeIndex >= 0; --intBridgeIndex) {
                    o_LiveShowSceneBridge = this.m_SceneBridges.get(intBridgeIndex);
                    if (!p_IncludeActualBridge && o_LiveShowSceneBridge == this.m_ActualSceneBridge || (p_IncludeEqualFrameStart || p_FramePosition <= o_LiveShowSceneBridge.getFrameStart()) && (!p_IncludeEqualFrameStart || p_FramePosition < o_LiveShowSceneBridge.getFrameStart()) || p_OnlyActiveBridges && !o_LiveShowSceneBridge.getActive() || p_OnlyMainBridges && !o_LiveShowSceneBridge.getIsMainBridge()) continue;
                    o_LiveShowSceneBridgeResult = o_LiveShowSceneBridge;
                    break;
                }
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowSceneBridgeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowSceneBridge getLiveShowSceneBridge_Previous(LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_OnlyMainBridges, boolean p_OnlyActiveBridges) {
        Play o_Play = this.m_Play;
        if (p_LiveShowSceneBridge == null) {
            if (o_Play == null) {
                return null;
            }
            return this.getLiveShowSceneBridge_Previous(o_Play.getPlayCursor(), p_OnlyMainBridges, p_OnlyActiveBridges);
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveShowSceneBridge o_LiveShowSceneBridge = null;
        Object object = this.m_SyncObjects;
        synchronized (object) {
            int intIndex = this.m_SceneBridges.indexOf(p_LiveShowSceneBridge);
            if (intIndex < 0) {
                intIndex = 0;
            }
            --intIndex;
            while (intIndex >= 0) {
                o_LiveShowSceneBridge = this.m_SceneBridges.get(intIndex);
                if (p_OnlyMainBridges && !o_LiveShowSceneBridge.getIsMainBridge()) {
                    --intIndex;
                    o_LiveShowSceneBridge = null;
                    continue;
                }
                if (!p_OnlyActiveBridges || o_LiveShowSceneBridge.getActive()) break;
                --intIndex;
                o_LiveShowSceneBridge = null;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowSceneBridge;
    }

    public LiveShowSceneBridge getLiveShowSceneBridge_PreviousToPlay(LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_OnlyMainScenes) {
        long longFrameStart;
        Play o_Play = this.m_Play;
        if (p_LiveShowSceneBridge == null) {
            if (o_Play == null) {
                return null;
            }
            longFrameStart = o_Play.getPlayCursor();
        } else {
            longFrameStart = p_LiveShowSceneBridge.getFrameStart();
        }
        LiveShowSceneBridge o_LiveShowSceneBridge = this.getLiveShowSceneBridge_PreviousToPlay(longFrameStart, p_OnlyMainScenes);
        return o_LiveShowSceneBridge;
    }

    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_PreviousToPlay(long p_StartFrame, boolean p_OnlyMainScenes) {
        LiveShowSceneBridge o_LiveShowSceneBridge = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        if (!p_OnlyMainScenes) {
            long longStartFrame = p_StartFrame;
            boolean boolActive = false;
            while (!boolActive) {
                o_LiveShowSceneBridge = this.getLiveShowSceneBridge_Previous(longStartFrame, false, false);
                if (o_LiveShowSceneBridge == null) {
                    boolActive = true;
                    continue;
                }
                if (o_LiveShowSceneBridge.getActive()) {
                    if (o_LiveShowSceneBridge.getIsMainBridge()) {
                        boolActive = true;
                        continue;
                    }
                    LiveShowSceneBridge o_LiveShowMainSceneBridge = this.getLiveShowSceneBridge_Previous(longStartFrame, true, false);
                    if (o_LiveShowMainSceneBridge == null) {
                        boolActive = true;
                        continue;
                    }
                    if (!o_LiveShowMainSceneBridge.getActive()) {
                        longStartFrame = o_LiveShowMainSceneBridge.getFrameStart();
                        continue;
                    }
                    boolActive = true;
                    continue;
                }
                longStartFrame = o_LiveShowSceneBridge.getFrameStart();
            }
        } else {
            o_LiveShowSceneBridge = this.getLiveShowSceneBridge_Previous(p_StartFrame, true, true);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowSceneBridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowSceneBridge getLiveShowSceneBridge_PositionOLD(long p_FramePosition, boolean p_OnlyMainBridges, boolean p_OnlyActiveBridges) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveShowSceneBridge o_ResultSceneBridge = null;
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (this.m_SceneBridges != null) {
                for (int intBridge = this.m_SceneBridges.size() - 1; intBridge >= 0; --intBridge) {
                    LiveShowSceneBridge o_LiveShowSceneBridge = this.m_SceneBridges.get(intBridge);
                    if (o_LiveShowSceneBridge == null || p_OnlyActiveBridges && !o_LiveShowSceneBridge.getActive() || p_OnlyMainBridges && !o_LiveShowSceneBridge.getIsMainBridge() || o_LiveShowSceneBridge.getFrameStart() > p_FramePosition || o_ResultSceneBridge != null) continue;
                    o_ResultSceneBridge = o_LiveShowSceneBridge;
                    break;
                }
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_ResultSceneBridge;
    }

    public LiveShowSceneBridge getLiveShowSceneBridge_Position(long p_FramePosition, boolean p_OnlyMainBridges, boolean p_OnlyActiveBridges) {
        LiveShowSceneBridge o_ResultSceneBridge = null;
        o_ResultSceneBridge = this.getLiveShowSceneBridge_Previous(p_FramePosition, true, true, p_OnlyMainBridges, p_OnlyActiveBridges);
        return o_ResultSceneBridge;
    }

    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_Cursor() {
        return this.m_CursorSceneBridge;
    }

    public LiveShowSceneBridge getLiveShowSceneBridge_Cursor_Old() {
        return this.m_CursorSceneBridge_Old;
    }

    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_EditCursor() {
        return this.m_EditCursorSceneBridge;
    }

    public LiveShowSceneBridge getLiveShowSceneBridge_EditCursorNext() {
        return this.m_EditCursorSceneBridgeNext;
    }

    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_Actual() {
        return this.m_ActualSceneBridge;
    }

    public void setLiveShowSceneBridge_Exluded(LiveShowSceneBridge p_ExcludedLiveShowSceneBridge) {
        this.m_ExcludedSceneBridge = p_ExcludedLiveShowSceneBridge;
    }

    public LiveShowSceneBridge getLiveShowSceneBridge_Exluded() {
        return this.m_ExcludedSceneBridge;
    }

    public ArrayList<LiveShowSceneBridge> getLiveShowSceneBridges(ArrayList<LiveShowSceneBridge> p_LiveShowSceneBridges, boolean p_OnlyMainBridges) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        if (p_LiveShowSceneBridges == null) {
            p_LiveShowSceneBridges = new ArrayList();
        }
        p_LiveShowSceneBridges.clear();
        for (int intBridge = 0; intBridge < this.m_SceneBridges.size(); ++intBridge) {
            LiveShowSceneBridge o_LiveShowSceneBridge = this.m_SceneBridges.get(intBridge);
            if (o_LiveShowSceneBridge == null || p_OnlyMainBridges && !o_LiveShowSceneBridge.getIsMainBridge()) continue;
            p_LiveShowSceneBridges.add(o_LiveShowSceneBridge);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return p_LiveShowSceneBridges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<LiveShowSceneBridge> getLiveShowSceneBridges_OfMainBridge(ArrayList<LiveShowSceneBridge> p_LiveShowSceneBridges, LiveShowSceneBridge p_LiveShowSceneBridgeMain) {
        if (p_LiveShowSceneBridges == null) {
            p_LiveShowSceneBridges = new ArrayList();
        }
        p_LiveShowSceneBridges.clear();
        if (p_LiveShowSceneBridgeMain == null) {
            return p_LiveShowSceneBridges;
        }
        if (!p_LiveShowSceneBridgeMain.getIsMainBridge()) {
            return p_LiveShowSceneBridges;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return p_LiveShowSceneBridges;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            LiveShowSceneBridge o_LiveShowSceneBridge = null;
            int intIndex = this.m_SceneBridges.indexOf(p_LiveShowSceneBridgeMain);
            if (intIndex < 0) {
                intIndex = 0;
            }
            ++intIndex;
            while (intIndex < this.m_SceneBridges.size() && !(o_LiveShowSceneBridge = this.m_SceneBridges.get(intIndex)).getIsMainBridge()) {
                p_LiveShowSceneBridges.add(o_LiveShowSceneBridge);
                ++intIndex;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return p_LiveShowSceneBridges;
    }

    public ArrayList<LiveShowSceneBridge> getLiveShowSceneBridges(ArrayList<LiveShowSceneBridge> p_LiveShowSceneBridges, long p_FrameStart, long p_FrameEnd, boolean p_OnlyMainBridges) {
        LiveShowSceneBridge o_LiveShowSceneBridge;
        if (p_FrameStart < 0L) {
            p_FrameStart = 0L;
        }
        if (p_FrameEnd < 0L) {
            p_FrameEnd = 0L;
        }
        if (p_LiveShowSceneBridges == null) {
            p_LiveShowSceneBridges = new ArrayList();
        }
        p_LiveShowSceneBridges.clear();
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return p_LiveShowSceneBridges;
        }
        if (p_FrameEnd < p_FrameStart) {
            long longFrame = p_FrameEnd;
            p_FrameEnd = p_FrameStart;
            p_FrameStart = longFrame;
        }
        p_LiveShowSceneBridges.clear();
        for (int intBridge = 0; intBridge < this.m_SceneBridges.size(); ++intBridge) {
            o_LiveShowSceneBridge = this.m_SceneBridges.get(intBridge);
            if (o_LiveShowSceneBridge == null || p_OnlyMainBridges && !o_LiveShowSceneBridge.getIsMainBridge() || o_LiveShowSceneBridge.getFrameStart() >= p_FrameEnd || o_LiveShowSceneBridge.getFrameStart() + o_LiveShowSceneBridge.getFrameLength() < p_FrameStart) continue;
            p_LiveShowSceneBridges.add(o_LiveShowSceneBridge);
        }
        o_LiveShowSceneBridge = this.getLiveShowSceneBridge_Previous(p_FrameStart, p_OnlyMainBridges, false);
        if (o_LiveShowSceneBridge != null && !p_LiveShowSceneBridges.contains(o_LiveShowSceneBridge)) {
            p_LiveShowSceneBridges.add(0, o_LiveShowSceneBridge);
        }
        if ((o_LiveShowSceneBridge = this.getLiveShowSceneBridge_Next(p_FrameEnd, p_OnlyMainBridges, false)) != null && !p_LiveShowSceneBridges.contains(o_LiveShowSceneBridge)) {
            p_LiveShowSceneBridges.add(o_LiveShowSceneBridge);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return p_LiveShowSceneBridges;
    }

    public void gotoSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_JumpInternal) {
        if (p_LiveShowSceneBridge == null || !p_LiveShowSceneBridge.getActive()) {
            return;
        }
        this.gotoSceneBridge(p_LiveShowSceneBridge, true, p_JumpInternal);
    }

    public void gotoSceneBridge(String p_ID, boolean p_Friends, boolean p_JumpInternal) {
        LiveShowSceneBridge o_LiveShowSceneBridge = this.getLiveShowSceneBridge(p_ID);
        if (o_LiveShowSceneBridge == null || !o_LiveShowSceneBridge.getActive()) {
            return;
        }
        this.gotoSceneBridge(o_LiveShowSceneBridge, p_Friends, p_JumpInternal);
    }

    public void gotoSceneBridge(long p_StartFrame, boolean p_Friends, boolean p_JumpInternal) {
        LiveShowSceneBridge o_LiveShowSceneBridge = this.getLiveShowSceneBridge(p_StartFrame);
        if (o_LiveShowSceneBridge == null || !o_LiveShowSceneBridge.getActive()) {
            return;
        }
        this.gotoSceneBridge(o_LiveShowSceneBridge, p_Friends, p_JumpInternal);
    }

    @Override
    public void gotoSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_Friends, boolean p_JumpInternal) {
        LiveShowSceneBridge o_ActualSceneBridge;
        if (p_LiveShowSceneBridge == null || !p_LiveShowSceneBridge.getActive()) {
            return;
        }
        Play o_Play = this.m_Play;
        if (o_Play == null) {
            return;
        }
        if (!o_Play.getActive()) {
            if (p_Friends) {
                for (int intFriendVIP = 0; intFriendVIP < this.m_FriendVIPs.size(); ++intFriendVIP) {
                    LiveShowVIP o_FriendVIP = this.m_FriendVIPs.get(intFriendVIP);
                    if (o_FriendVIP == null) continue;
                    o_FriendVIP.gotoSceneBridge(p_LiveShowSceneBridge.getFrameStart(), false, p_JumpInternal);
                }
            }
            return;
        }
        Play.PlaySynchronisizer o_PlaySynchronisizer = o_Play.getPlaySynchronizer();
        if (o_PlaySynchronisizer == null) {
            return;
        }
        if (p_Friends) {
            o_PlaySynchronisizer.clearPlaysTriggerSceneBridge();
        }
        if ((o_ActualSceneBridge = this.m_ActualSceneBridge) == p_LiveShowSceneBridge) {
            if (!o_Play.isRunning() || p_JumpInternal) {
                o_PlaySynchronisizer.addPlayTriggerSceneBridge(o_Play);
            }
            if (p_Friends) {
                for (int intFriendVIP = 0; intFriendVIP < this.m_FriendVIPs.size(); ++intFriendVIP) {
                    LiveShowVIP o_FriendVIP = this.m_FriendVIPs.get(intFriendVIP);
                    if (o_FriendVIP == null) continue;
                    o_FriendVIP.gotoSceneBridge(p_LiveShowSceneBridge.getFrameStart(), false, p_JumpInternal);
                }
            }
            return;
        }
        if (o_ActualSceneBridge != null) {
            o_ActualSceneBridge.stopSceneBridge();
        }
        LiveShowSceneBridge o_LiveShowSceneBridge = p_LiveShowSceneBridge;
        LiveShowSceneBridge o_LiveShowSceneBridge_Next = this.getLiveShowSceneBridge_Next(o_Play.getPlayCursor(), false, false);
        this.setLiveShowSceneBridge_Exluded(o_LiveShowSceneBridge_Next);
        if (o_LiveShowSceneBridge != null) {
            o_LiveShowSceneBridge.setJumpedInternal(p_JumpInternal);
        }
        if (p_Friends) {
            for (int intFriendVIP = 0; intFriendVIP < this.m_FriendVIPs.size(); ++intFriendVIP) {
                LiveShowVIP o_FriendVIP = this.m_FriendVIPs.get(intFriendVIP);
                if (o_FriendVIP == null) continue;
                o_FriendVIP.gotoSceneBridge(o_LiveShowSceneBridge.getFrameStart(), false, p_JumpInternal);
            }
        }
        if (o_LiveShowSceneBridge == null) {
            return;
        }
        if (!o_Play.isRunning() || p_JumpInternal) {
            o_PlaySynchronisizer.addPlayTriggerSceneBridge(o_Play);
        }
        if (!o_Play.isRunning() || p_JumpInternal) {
            if (o_Play.isRunning() && o_LiveShowSceneBridge.getStopAtStart()) {
                o_Play.stop();
            }
            o_Play.setPlayCursor(o_LiveShowSceneBridge.getFrameStart());
        } else {
            o_LiveShowSceneBridge.startSceneBridge(true);
        }
    }

    public void startSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_WillPlay) {
        Play o_Play = this.m_Play;
        if (!this.accepts(p_LiveShowSceneBridge)) {
            return;
        }
        this.m_ActualSceneBridge = p_LiveShowSceneBridge;
        this.m_ActualSceneBridge_PlayInside = true;
        boolean bl = this.m_ActualSceneBridge_StopAtStart = !p_WillPlay;
        if (o_Play != null) {
            o_Play.setOverwriteManualValues(true);
        }
        this.notifyLiveShowVIPListeners_SceneBridgeStart(p_LiveShowSceneBridge, p_WillPlay);
    }

    public void stopSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge) {
        Play o_Play = this.m_Play;
        if (!this.accepts(p_LiveShowSceneBridge)) {
            return;
        }
        this.m_ActualSceneBridge = null;
        this.m_ActualSceneBridge_PlayInside = false;
        this.m_ActualSceneBridge_StopAtStart = false;
        this.m_ExcludedSceneBridge = null;
        if (o_Play != null) {
            o_Play.setOverwriteManualValues(false);
            this.checkSceneBridge_PlayCursor(o_Play.getPlayCursor());
        }
        this.notifyLiveShowVIPListeners_SceneBridgeEnd(p_LiveShowSceneBridge);
    }

    public void setSnapFramesDistance(long p_FramesCount) {
        this.m_SnapFramesDistance = p_FramesCount;
    }

    public long getSnapFramesDistance() {
        return this.m_SnapFramesDistance;
    }

    public abstract long checkSnappingSpecial(long var1, int var3, LiveShowObjectDescription var4, boolean var5);

    public long checkSnapping(int p_LabelType, LiveShowObjectDescription p_LiveShowObjectDescription, LiveShowVIPStatus p_LiveShowVIPStatus, long p_FramePosition, boolean p_CheckFriends) {
        long longFramePosition;
        if (p_LiveShowObjectDescription == null) {
            return p_FramePosition;
        }
        Object o_SnapObject = null;
        boolean boolObjectItself = false;
        boolean boolSnapped = false;
        String stringID = p_LiveShowObjectDescription.getID();
        if (stringID == null) {
            return p_FramePosition;
        }
        long longNewFramePosition = p_FramePosition;
        if (p_FramePosition < this.m_SnapFramesDistance) {
            longNewFramePosition = 0L;
            boolSnapped = true;
        }
        for (int intObject = 0; intObject < this.getLiveShowObjectInterfaceCount(); ++intObject) {
            long longFrame;
            boolObjectItself = false;
            LiveShowObjectInterface o_LiveShowObjectInterface = this.getLiveShowObjectInterface(intObject);
            if (o_LiveShowObjectInterface == null || o_LiveShowObjectInterface.getID() == null) continue;
            if (stringID.equals(o_LiveShowObjectInterface.getID())) {
                boolObjectItself = true;
            } else if (p_LiveShowVIPStatus != null && p_LiveShowVIPStatus.contains(o_LiveShowObjectInterface.getDescription())) continue;
            if (!boolObjectItself) {
                longFrame = o_LiveShowObjectInterface.getFrameStart() + o_LiveShowObjectInterface.getFrameLength();
                if (Math.abs(p_FramePosition - longFrame) < this.m_SnapFramesDistance) {
                    longFramePosition = longFrame;
                    if (!boolSnapped) {
                        longNewFramePosition = longFramePosition;
                    } else if (Math.abs(p_FramePosition - longFramePosition) < Math.abs(p_FramePosition - longNewFramePosition)) {
                        longNewFramePosition = longFramePosition;
                    }
                    boolSnapped = true;
                }
                if (Math.abs(p_FramePosition - (longFrame = o_LiveShowObjectInterface.getFrameStart())) < this.m_SnapFramesDistance) {
                    longFramePosition = longFrame;
                    if (!boolSnapped) {
                        longNewFramePosition = longFramePosition;
                    } else if (Math.abs(p_FramePosition - longFramePosition) < Math.abs(p_FramePosition - longNewFramePosition)) {
                        longNewFramePosition = longFramePosition;
                    }
                    boolSnapped = true;
                }
            }
            if (!(boolObjectItself && (p_LabelType == 5 || p_LabelType == 4 || p_LabelType == 0) || boolObjectItself && p_LabelType == 2 && p_CheckFriends || Math.abs(p_FramePosition - (longFrame = o_LiveShowObjectInterface instanceof LiveShowSceneBridge ? o_LiveShowObjectInterface.getFrameStart() + o_LiveShowObjectInterface.getFrameFadeOutLength() : o_LiveShowObjectInterface.getFrameStart() + o_LiveShowObjectInterface.getFrameLength() - o_LiveShowObjectInterface.getFrameFadeOutLength())) >= this.m_SnapFramesDistance)) {
                longFramePosition = longFrame;
                if (!boolSnapped) {
                    longNewFramePosition = longFramePosition;
                } else if (Math.abs(p_FramePosition - longFramePosition) < Math.abs(p_FramePosition - longNewFramePosition)) {
                    longNewFramePosition = longFramePosition;
                }
                boolSnapped = true;
            }
            if (!(boolObjectItself && (p_LabelType == 5 || p_LabelType == 4 || p_LabelType == 0) || boolObjectItself && p_LabelType == 1 && p_CheckFriends || Math.abs(p_FramePosition - (longFrame = o_LiveShowObjectInterface instanceof LiveShowSceneBridge ? o_LiveShowObjectInterface.getFrameStart() + o_LiveShowObjectInterface.getFrameLength() - o_LiveShowObjectInterface.getFrameFadeInLength() : o_LiveShowObjectInterface.getFrameStart() + o_LiveShowObjectInterface.getFrameFadeInLength())) >= this.m_SnapFramesDistance)) {
                longFramePosition = longFrame;
                if (!boolSnapped) {
                    longNewFramePosition = longFramePosition;
                } else if (Math.abs(p_FramePosition - longFramePosition) < Math.abs(p_FramePosition - longNewFramePosition)) {
                    longNewFramePosition = longFramePosition;
                }
                boolSnapped = true;
            }
            if (!(!(o_LiveShowObjectInterface instanceof LiveShowSceneBridge) || boolObjectItself && (p_LabelType == 5 || p_LabelType == 4 || p_LabelType == 0) || boolObjectItself && p_LabelType == 6 && p_CheckFriends || Math.abs(p_FramePosition - (longFrame = o_LiveShowObjectInterface.getFrameStart() + o_LiveShowObjectInterface.getFrameFadeOutOffset())) >= this.m_SnapFramesDistance)) {
                longFramePosition = longFrame;
                if (!boolSnapped) {
                    longNewFramePosition = longFramePosition;
                } else if (Math.abs(p_FramePosition - longFramePosition) < Math.abs(p_FramePosition - longNewFramePosition)) {
                    longNewFramePosition = longFramePosition;
                }
                boolSnapped = true;
            }
            if (!(!(o_LiveShowObjectInterface instanceof LiveShowSceneBridge) || boolObjectItself && (p_LabelType == 5 || p_LabelType == 4 || p_LabelType == 0) || boolObjectItself && p_LabelType == 7 && p_CheckFriends || Math.abs(p_FramePosition - (longFrame = o_LiveShowObjectInterface.getFrameStart() + o_LiveShowObjectInterface.getFrameLength() - o_LiveShowObjectInterface.getFrameFadeInOffset())) >= this.m_SnapFramesDistance)) {
                longFramePosition = longFrame;
                if (!boolSnapped) {
                    longNewFramePosition = longFramePosition;
                } else if (Math.abs(p_FramePosition - longFramePosition) < Math.abs(p_FramePosition - longNewFramePosition)) {
                    longNewFramePosition = longFramePosition;
                }
                boolSnapped = true;
            }
            if ((longFramePosition = this.checkSnappingSpecial(p_FramePosition, p_LabelType, o_LiveShowObjectInterface.getDescription(), boolObjectItself)) == p_FramePosition) continue;
            if (!boolSnapped) {
                longNewFramePosition = longFramePosition;
            } else if (Math.abs(p_FramePosition - longFramePosition) < Math.abs(p_FramePosition - longNewFramePosition)) {
                longNewFramePosition = longFramePosition;
            }
            boolSnapped = true;
        }
        if (p_CheckFriends) {
            for (int intVIP = 0; intVIP < this.getFriendVIPCount(); ++intVIP) {
                LiveShowVIP o_FriendVIP = this.getFriendVip(intVIP);
                if (o_FriendVIP == null || (longFramePosition = o_FriendVIP.checkSnapping(p_LabelType, p_LiveShowObjectDescription, p_LiveShowVIPStatus, p_FramePosition, false)) < 0L) continue;
                if (!boolSnapped) {
                    longNewFramePosition = longFramePosition;
                } else if (Math.abs(p_FramePosition - longFramePosition) < Math.abs(p_FramePosition - longNewFramePosition)) {
                    longNewFramePosition = longFramePosition;
                }
                boolSnapped = true;
            }
        }
        if (boolSnapped) {
            return longNewFramePosition;
        }
        return -1L;
    }

    public long checkLeftBound(LiveShowVIPStatus p_LiveShowVIPStatus, long p_FrameDiff, boolean p_CheckFriends) {
        if (p_LiveShowVIPStatus == null) {
            return p_FrameDiff;
        }
        ArrayList<LiveShowObjectDescription> o_LiveShowObjectDescriptions = p_LiveShowVIPStatus.getLiveShowObjectDescriptions(this.getType());
        if (o_LiveShowObjectDescriptions == null) {
            return p_FrameDiff;
        }
        long longNewFrameDiff = p_FrameDiff;
        for (int intObject = 0; intObject < o_LiveShowObjectDescriptions.size(); ++intObject) {
            LiveShowObjectDescription o_LiveShowObjectDescription = o_LiveShowObjectDescriptions.get(intObject);
            if (o_LiveShowObjectDescription == null || o_LiveShowObjectDescription.getFrameStart() + longNewFrameDiff >= 0L) continue;
            longNewFrameDiff = -o_LiveShowObjectDescription.getFrameStart();
        }
        if (p_CheckFriends) {
            for (int intVIP = 0; intVIP < this.getFriendVIPCount(); ++intVIP) {
                long longNewFrameDiffFriends;
                LiveShowVIP o_FriendVIP = this.getFriendVip(intVIP);
                if (o_FriendVIP == null || Math.abs(longNewFrameDiffFriends = o_FriendVIP.checkLeftBound(p_LiveShowVIPStatus, longNewFrameDiff, false)) >= Math.abs(longNewFrameDiff)) continue;
                longNewFrameDiff = longNewFrameDiffFriends;
            }
        }
        return longNewFrameDiff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLiveShowVIPListener(LiveShowVIPListener p_LiveShowVIPListener) {
        if (p_LiveShowVIPListener == null) {
            return false;
        }
        boolean boolAdded = false;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners != null && !this.m_LiveShowVIPListeners.contains(p_LiveShowVIPListener)) {
                this.m_LiveShowVIPListeners.add(p_LiveShowVIPListener);
                boolAdded = true;
            }
        }
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLiveShowVIPListener(LiveShowVIPListener p_LiveShowVIPListener) {
        if (p_LiveShowVIPListener == null) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners != null) {
                boolRemoved = this.m_LiveShowVIPListeners.remove(p_LiveShowVIPListener);
            }
        }
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_Active(boolean p_Active) {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPActive(this, p_Active);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_ToFront() {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPToFront(this);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_VIPTrackAdded(LiveShowVIPTrack p_LiveShowVIPTrack) {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPTrackAdded(this, p_LiveShowVIPTrack);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_VIPTrackRemoved(LiveShowVIPTrack p_LiveShowVIPTrack) {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPTrackRemoved(this, p_LiveShowVIPTrack);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_Closing() {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
            this.m_LiveShowVIPListeners.clear();
        }
        int intListenerCount = o_LiveShowVIPListeners.size();
        for (int intListener = intListenerCount - 1; intListener >= 0 && o_LiveShowVIPListeners.size() > 0; --intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPClosing(this);
            o_LiveShowVIPListeners.remove(o_Listener);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_FrameMaxObjects(long p_Maxframe) {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPFrameMaxObjects(this, p_Maxframe);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_MaxFrame(long p_Maxframe) {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPMaxFrame(this, p_Maxframe);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_FrameTime(double p_FrameTime) {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPFrameTime(this, p_FrameTime);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_SceneBridgeAdded(LiveShowSceneBridge p_LiveShowSceneBridge) {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPSceneBridgeAdded(this, p_LiveShowSceneBridge);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_SceneBridgeRemoved(LiveShowSceneBridge p_LiveShowSceneBridge) {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPSceneBridgeRemoved(this, p_LiveShowSceneBridge);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_SceneBridgesResorted(LiveShowSceneBridge p_LiveShowSceneBridge, ArrayList<LiveShowSceneBridge> p_LiveShowSceneBridges) {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPSceneBridgesResorted(this, p_LiveShowSceneBridge, p_LiveShowSceneBridges);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_SceneBridgeCursorChanged() {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        this.setSceneBridgeCursorChanged(this.m_CursorSceneBridge);
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPSceneBridgeCursorChanged(this, this.m_ActualSceneBridge_PlayInside, this.m_ActualSceneBridge_StopAtStart);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_SceneBridgeEditCursorChanged() {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        this.setSceneBridgeCursorChanged(this.m_CursorSceneBridge);
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPSceneBridgeEditCursorChanged(this);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_SceneBridgeStart(LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_WillPlay) {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPSceneBridgeStart(this, p_LiveShowSceneBridge, p_WillPlay);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_SceneBridgeEnd(LiveShowSceneBridge p_LiveShowSceneBridge) {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPSceneBridgeEnd(this, p_LiveShowSceneBridge);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_ObjectAdded(LiveShowObjectInterface p_LiveShowObjectInterface) {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPObjectAdded(this, p_LiveShowObjectInterface);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_ObjectRemoved(LiveShowObjectInterface p_LiveShowObjectInterface) {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPObjectRemoved(this, p_LiveShowObjectInterface);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_ObjectParamChanged(LiveShowObjectInterface p_LiveShowObjectInterface) {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPObjectParamChanged(this, p_LiveShowObjectInterface);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyLiveShowVIPListeners_ShowObjectSettings(LiveShowObjectInterface p_LiveShowObjectInterface) {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPObjectShowSettings(this, p_LiveShowObjectInterface);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_ObjectSelection(LiveShowObjectInterface p_LiveShowObjectInterface) {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPObjectSelection(this, p_LiveShowObjectInterface);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_EditModeOn(boolean p_EditMode) {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPEditModeOn(this, EDITMODEON);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_EditMode(int p_EditMode) {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPCursorMode(this, p_EditMode);
        }
        o_LiveShowVIPListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLiveShowVIPListeners_EndOfAction(LiveShowVIP p_ActorVip, boolean p_Success, int p_Action) {
        ArrayList<LiveShowVIPListener> o_LiveShowVIPListeners;
        Object object = this.m_SyncVIPListeners;
        synchronized (object) {
            if (this.m_LiveShowVIPListeners == null) {
                return;
            }
            if (this.m_LiveShowVIPListeners.size() <= 0) {
                return;
            }
            o_LiveShowVIPListeners = new ArrayList<LiveShowVIPListener>(this.m_LiveShowVIPListeners.size());
            o_LiveShowVIPListeners.addAll(this.m_LiveShowVIPListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowVIPListeners.size(); ++intListener) {
            LiveShowVIPListener o_Listener = (LiveShowVIPListener)o_LiveShowVIPListeners.get(intListener);
            o_Listener.eventVIPEndOfAction(this, p_ActorVip, p_Success, p_Action);
        }
        o_LiveShowVIPListeners.clear();
    }

    public void setLiveShowUndo(LiveShowUndo p_LiveShowUndo) {
        if (this.m_LiveShowUndo != null) {
            this.m_LiveShowUndo = null;
        }
        if (p_LiveShowUndo != null) {
            this.m_LiveShowUndo = p_LiveShowUndo;
        }
    }

    public LiveShowUndo getLiveShowUndo() {
        return this.m_LiveShowUndo;
    }

    public UndoManager getUndoManager() {
        if (this.m_LiveShowUndo == null) {
            return null;
        }
        return this.m_LiveShowUndo.getUndoManager();
    }

    public UndoableEditSupport getUndoableEditSupport() {
        if (this.m_LiveShowUndo == null) {
            return null;
        }
        return this.m_LiveShowUndo.getUndoableEditSupport();
    }

    public int getActualUndoAction() {
        if (this.m_LiveShowUndo == null) {
            return -1;
        }
        return this.m_LiveShowUndo.getActualAction();
    }

    @Override
    public Object getStatusSelected_Cloned() {
        LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIPStatus();
        o_LiveShowVIPStatus.addLiveShowVIPsSelectedObjects_Cloned(this);
        for (int intFriendVIP = 0; intFriendVIP < this.m_FriendVIPs.size(); ++intFriendVIP) {
            o_LiveShowVIPStatus.addLiveShowVIPsSelectedObjects_Cloned(this.m_FriendVIPs.get(intFriendVIP));
        }
        return o_LiveShowVIPStatus;
    }

    @Override
    public Object getStatusSelected_ForStartAction() {
        if (this.m_LiveShowVIPStatusSelected == null) {
            LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIPStatus();
            o_LiveShowVIPStatus.addLiveShowVIPsSelectedObjects_ForAction(this);
            for (int intFriendVIP = 0; intFriendVIP < this.m_FriendVIPs.size(); ++intFriendVIP) {
                o_LiveShowVIPStatus.addLiveShowVIPsSelectedObjects_ForAction(this.m_FriendVIPs.get(intFriendVIP));
            }
            this.m_LiveShowVIPStatusSelected = o_LiveShowVIPStatus;
        }
        return this.m_LiveShowVIPStatusSelected;
    }

    @Override
    public Object getStatusSelected_ForEndAction() {
        LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIPStatus();
        o_LiveShowVIPStatus.addLiveShowVIPsSelectedObjects_ForAction(this);
        for (int intFriendVIP = 0; intFriendVIP < this.m_FriendVIPs.size(); ++intFriendVIP) {
            o_LiveShowVIPStatus.addLiveShowVIPsSelectedObjects_ForAction(this.m_FriendVIPs.get(intFriendVIP));
        }
        return o_LiveShowVIPStatus;
    }

    @Override
    public void eventEndOfAction(LiveShowVIPStatus p_LiveShowVIPStatus, boolean p_Success, int p_Action) {
        this.calculateFramesToNextSceneBridge();
        this.doEndofAction(this, p_Success, p_Action);
        for (int intFriendVIP = 0; intFriendVIP < this.m_FriendVIPs.size(); ++intFriendVIP) {
            LiveShowVIP o_FriendVIP = this.m_FriendVIPs.get(intFriendVIP);
            if (o_FriendVIP == null) continue;
            o_FriendVIP.calculateFramesToNextSceneBridge();
            if (p_LiveShowVIPStatus == null || !p_LiveShowVIPStatus.affectsLiveShowVipType(o_FriendVIP)) continue;
            o_FriendVIP.doEndofAction(this, p_Success, p_Action);
        }
        LiveShowSceneBridgeMain.s_MainBridgeContainer.eventEndOfAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEndofAction(LiveShowVIP p_ActorLiveShowVIP, boolean p_Success, int p_Action) {
        ArrayList<LiveShowObjectInterface> o_LiveShowObjectInterfaces;
        this.notifyLiveShowVIPListeners_EndOfAction(p_ActorLiveShowVIP, p_Success, p_Action);
        Object object = this.m_SyncObjects;
        synchronized (object) {
            o_LiveShowObjectInterfaces = new ArrayList<LiveShowObjectInterface>(this.m_LiveShowObjects.size());
            o_LiveShowObjectInterfaces.addAll(this.m_LiveShowObjects);
        }
        for (int intObject = 0; intObject < o_LiveShowObjectInterfaces.size(); ++intObject) {
            LiveShowObjectInterface o_LiveShowObjectInterface = (LiveShowObjectInterface)o_LiveShowObjectInterfaces.get(intObject);
            if (o_LiveShowObjectInterface == null) continue;
            o_LiveShowObjectInterface.eventEndOfAction(p_ActorLiveShowVIP, p_Success, p_Action);
        }
    }

    @Override
    public void undo(LiveShowUndo.ActionUndoableEdit p_ActionUndoableEdit) {
        String stringVIPType;
        int intLiveShowVIP;
        LiveShowVIPStatus o_NewLiveShowVIPStatus;
        LiveShowVIPStatus o_OldLiveShowVIPStatus;
        if (p_ActionUndoableEdit == null) {
            return;
        }
        Object o_StatusOld = p_ActionUndoableEdit.getStatusOld();
        Object o_StatusNew = p_ActionUndoableEdit.getStatusNew();
        try {
            o_OldLiveShowVIPStatus = (LiveShowVIPStatus)o_StatusOld;
            o_NewLiveShowVIPStatus = (LiveShowVIPStatus)o_StatusNew;
        }
        catch (Exception e) {
            return;
        }
        ArrayList<LiveShowObjectDescription> o_OldLiveShowObjectDescriptions = null;
        ArrayList<LiveShowObjectDescription> o_NewLiveShowObjectDescriptions = null;
        ArrayList<String> o_VipTypes = new ArrayList<String>();
        if (o_OldLiveShowVIPStatus != null) {
            for (intLiveShowVIP = 0; intLiveShowVIP < o_OldLiveShowVIPStatus.getLiveShowVIPCount(); ++intLiveShowVIP) {
                stringVIPType = o_OldLiveShowVIPStatus.getLiveShowVIPType(intLiveShowVIP);
                if (stringVIPType == null || o_VipTypes.contains(stringVIPType)) continue;
                o_VipTypes.add(stringVIPType);
            }
        }
        if (o_NewLiveShowVIPStatus != null) {
            for (intLiveShowVIP = 0; intLiveShowVIP < o_NewLiveShowVIPStatus.getLiveShowVIPCount(); ++intLiveShowVIP) {
                stringVIPType = o_NewLiveShowVIPStatus.getLiveShowVIPType(intLiveShowVIP);
                if (stringVIPType == null || o_VipTypes.contains(stringVIPType)) continue;
                o_VipTypes.add(stringVIPType);
            }
        }
        for (intLiveShowVIP = 0; intLiveShowVIP < o_VipTypes.size(); ++intLiveShowVIP) {
            stringVIPType = (String)o_VipTypes.get(intLiveShowVIP);
            LiveShowVIP o_LiveShowVIP = this.getLiveShowVIP_FirstByType(stringVIPType);
            if (o_LiveShowVIP == null) continue;
            if (o_OldLiveShowVIPStatus != null) {
                o_OldLiveShowObjectDescriptions = o_OldLiveShowVIPStatus.getLiveShowObjectDescriptions(stringVIPType);
            }
            if (o_NewLiveShowVIPStatus != null) {
                o_NewLiveShowObjectDescriptions = o_NewLiveShowVIPStatus.getLiveShowObjectDescriptions(stringVIPType);
            }
            o_LiveShowVIP.setStatus(o_NewLiveShowObjectDescriptions, o_OldLiveShowObjectDescriptions, this);
        }
        this.eventEndOfAction(o_OldLiveShowVIPStatus, true, p_ActionUndoableEdit.getAction());
    }

    @Override
    public void redo(LiveShowUndo.ActionUndoableEdit p_ActionUndoableEdit) {
        String stringVIPType;
        int intLiveShowVIP;
        LiveShowVIPStatus o_NewLiveShowVIPStatus;
        LiveShowVIPStatus o_OldLiveShowVIPStatus;
        if (p_ActionUndoableEdit == null) {
            return;
        }
        Object o_StatusOld = p_ActionUndoableEdit.getStatusOld();
        Object o_StatusNew = p_ActionUndoableEdit.getStatusNew();
        try {
            o_OldLiveShowVIPStatus = (LiveShowVIPStatus)o_StatusOld;
            o_NewLiveShowVIPStatus = (LiveShowVIPStatus)o_StatusNew;
        }
        catch (Exception e) {
            return;
        }
        ArrayList<LiveShowObjectDescription> o_OldLiveShowObjectDescriptions = null;
        ArrayList<LiveShowObjectDescription> o_NewLiveShowObjectDescriptions = null;
        ArrayList<String> o_VipTypes = new ArrayList<String>();
        if (o_OldLiveShowVIPStatus != null) {
            for (intLiveShowVIP = 0; intLiveShowVIP < o_OldLiveShowVIPStatus.getLiveShowVIPCount(); ++intLiveShowVIP) {
                stringVIPType = o_OldLiveShowVIPStatus.getLiveShowVIPType(intLiveShowVIP);
                if (stringVIPType == null || o_VipTypes.contains(stringVIPType)) continue;
                o_VipTypes.add(stringVIPType);
            }
        }
        if (o_NewLiveShowVIPStatus != null) {
            for (intLiveShowVIP = 0; intLiveShowVIP < o_NewLiveShowVIPStatus.getLiveShowVIPCount(); ++intLiveShowVIP) {
                stringVIPType = o_NewLiveShowVIPStatus.getLiveShowVIPType(intLiveShowVIP);
                if (stringVIPType == null || o_VipTypes.contains(stringVIPType)) continue;
                o_VipTypes.add(stringVIPType);
            }
        }
        for (intLiveShowVIP = 0; intLiveShowVIP < o_VipTypes.size(); ++intLiveShowVIP) {
            stringVIPType = (String)o_VipTypes.get(intLiveShowVIP);
            LiveShowVIP o_LiveShowVIP = this.getLiveShowVIP_FirstByType(stringVIPType);
            if (o_LiveShowVIP == null) continue;
            if (o_OldLiveShowVIPStatus != null) {
                o_OldLiveShowObjectDescriptions = o_OldLiveShowVIPStatus.getLiveShowObjectDescriptions(stringVIPType);
            }
            if (o_NewLiveShowVIPStatus != null) {
                o_NewLiveShowObjectDescriptions = o_NewLiveShowVIPStatus.getLiveShowObjectDescriptions(stringVIPType);
            }
            o_LiveShowVIP.setStatus(o_OldLiveShowObjectDescriptions, o_NewLiveShowObjectDescriptions, this);
        }
        this.eventEndOfAction(o_NewLiveShowVIPStatus, true, p_ActionUndoableEdit.getAction());
    }

    public void setStatus(ArrayList<LiveShowObjectDescription> p_OldLiveShowObjectDescriptions, ArrayList<LiveShowObjectDescription> p_NewLiveShowObjectDescriptions, LiveShowUndo.ActionOwnerInterface p_ActionOwnerInterface) {
        LiveShowVIPTrack o_LiveShowVIPTrack;
        LiveShowObjectInterface o_LiveShowObjectInterface;
        LiveShowObjectDescription o_LiveShowObjectDescription;
        int intObject;
        ArrayList<LiveShowObjectDescription> o_ObjectDescriptionsToRemove;
        if (p_OldLiveShowObjectDescriptions != null) {
            o_ObjectDescriptionsToRemove = new ArrayList(p_OldLiveShowObjectDescriptions.size());
            o_ObjectDescriptionsToRemove.addAll(p_OldLiveShowObjectDescriptions);
        } else {
            o_ObjectDescriptionsToRemove = new ArrayList<LiveShowObjectDescription>();
        }
        ArrayList<LiveShowObjectDescription> o_ObjectDescriptionsToAdd = new ArrayList<LiveShowObjectDescription>();
        if (p_NewLiveShowObjectDescriptions != null) {
            for (intObject = 0; intObject < p_NewLiveShowObjectDescriptions.size(); ++intObject) {
                o_LiveShowObjectDescription = p_NewLiveShowObjectDescriptions.get(intObject);
                if (o_LiveShowObjectDescription == null) continue;
                LiveShowObjectDescription o_OldLiveShowObjectDescription = this.findLiveShowObjectDescription(o_LiveShowObjectDescription.getID(), p_OldLiveShowObjectDescriptions);
                if (o_OldLiveShowObjectDescription == null) {
                    o_ObjectDescriptionsToAdd.add(o_LiveShowObjectDescription);
                    continue;
                }
                o_LiveShowObjectInterface = this.findLiveShowObjectInterface(o_OldLiveShowObjectDescription.getID());
                if (o_LiveShowObjectInterface != null) {
                    if (o_OldLiveShowObjectDescription.getVIPTrackNumber() != o_LiveShowObjectDescription.getVIPTrackNumber()) {
                        o_LiveShowVIPTrack = this.getLiveShowVIPTrack(o_LiveShowObjectInterface.getVIPTrackNumber());
                        if (o_LiveShowVIPTrack != null) {
                            o_LiveShowVIPTrack.removeLiveShowObjectInterface(o_LiveShowObjectInterface);
                        }
                        if ((o_LiveShowVIPTrack = this.getLiveShowVIPTrack(o_LiveShowObjectDescription.getVIPTrackNumber())) != null) {
                            o_LiveShowVIPTrack.addLiveShowObjectInterface(o_LiveShowObjectInterface, o_LiveShowObjectDescription.getFrameStart());
                        }
                    }
                    o_LiveShowObjectInterface.setDescription(o_LiveShowObjectDescription);
                }
                o_ObjectDescriptionsToRemove.remove(o_OldLiveShowObjectDescription);
            }
        }
        for (intObject = 0; intObject < o_ObjectDescriptionsToRemove.size(); ++intObject) {
            o_LiveShowObjectInterface = this.findLiveShowObjectInterface(((LiveShowObjectDescription)o_ObjectDescriptionsToRemove.get(intObject)).getID());
            if (o_LiveShowObjectInterface == null) continue;
            o_LiveShowObjectInterface.close(true);
        }
        o_ObjectDescriptionsToRemove.clear();
        block6: for (int intObject2 = 0; intObject2 < o_ObjectDescriptionsToAdd.size(); ++intObject2) {
            o_LiveShowObjectDescription = (LiveShowObjectDescription)o_ObjectDescriptionsToAdd.get(intObject2);
            switch (o_LiveShowObjectDescription.getObjectType()) {
                case 1: 
                case 11: 
                case 21: 
                case 25: {
                    o_LiveShowObjectInterface = this.createLiveShowObject(o_LiveShowObjectDescription);
                    if (o_LiveShowObjectInterface == null) continue block6;
                    int intVIPTrackObjectIndex = o_LiveShowObjectDescription.getVIPTrackNumber();
                    if (intVIPTrackObjectIndex < 0) {
                        intVIPTrackObjectIndex = 0;
                    }
                    if ((o_LiveShowVIPTrack = this.getLiveShowVIPTrack(intVIPTrackObjectIndex)) == null) continue block6;
                    o_LiveShowVIPTrack.addLiveShowObjectInterface(o_LiveShowObjectInterface, o_LiveShowObjectDescription.getFrameStart());
                    continue block6;
                }
                case 2: 
                case 12: 
                case 22: {
                    LiveShowSceneBridge o_LiveShowSceneBridge = this.createLiveShowSceneBridge(o_LiveShowObjectDescription);
                    this.addLiveShowSceneBridge(o_LiveShowSceneBridge, o_LiveShowSceneBridge.getFrameStart());
                    continue block6;
                }
            }
        }
        this.refreshJumps();
    }

    private LiveShowObjectDescription findLiveShowObjectDescription(String p_ID, ArrayList<LiveShowObjectDescription> p_LiveShowObjectDescriptions) {
        if (p_ID == null) {
            return null;
        }
        if (p_LiveShowObjectDescriptions == null) {
            return null;
        }
        LiveShowObjectDescription o_LiveShowObjectDescription = null;
        for (int intObject = 0; intObject < p_LiveShowObjectDescriptions.size(); ++intObject) {
            o_LiveShowObjectDescription = p_LiveShowObjectDescriptions.get(intObject);
            if (o_LiveShowObjectDescription == null) continue;
            if (p_ID.equals(o_LiveShowObjectDescription.getID())) break;
            o_LiveShowObjectDescription = null;
        }
        return o_LiveShowObjectDescription;
    }

    public void startUndoAction(int p_Action, String p_ActionString, LiveShowVIPStatus p_LiveShowVIPStatus) {
        LiveShowUndo o_LiveShowUndo = null;
        o_LiveShowUndo = this.getLiveShowUndo();
        if (o_LiveShowUndo == null) {
            return;
        }
        if (o_LiveShowUndo.checkStartAction(p_Action)) {
            LiveShowVIPStatus o_LiveShowVIPStatus = p_LiveShowVIPStatus != null ? p_LiveShowVIPStatus.clone() : null;
            o_LiveShowUndo.startAction(p_Action, p_ActionString, this, o_LiveShowVIPStatus);
        }
    }

    public void endUndoAction(int p_Action, boolean p_Success, LiveShowVIPStatus p_LiveShowVIPStatus) {
        LiveShowUndo o_LiveShowUndo = null;
        o_LiveShowUndo = this.getLiveShowUndo();
        if (o_LiveShowUndo != null && o_LiveShowUndo.checkEndAction(p_Action)) {
            LiveShowVIPStatus o_LiveShowVIPStatus = p_LiveShowVIPStatus != null ? p_LiveShowVIPStatus.clone() : null;
            o_LiveShowUndo.endAction(p_Success, p_Action, this, o_LiveShowVIPStatus);
        }
        this.m_LiveShowVIPStatusSelected = null;
    }

    public void doActionAddSceneBridge(LiveShowVIPTrack p_LiveShowVIPTrack, long p_FramePosition, LiveShowObjectDescription p_ActorDescription, LiveShowVIPStatus p_LiveShowVIPStatus) {
        this.startUndoAction(11, LiveShowUndo.ACTION_ADD_STRING, null);
        this.actionDragAdd(p_LiveShowVIPTrack, p_FramePosition, p_ActorDescription, p_LiveShowVIPStatus);
        this.endUndoAction(11, true, p_LiveShowVIPStatus);
    }

    public void doActionAddMainScenebridge(LiveShowVIPTrack p_LiveShowVIPTrack, long p_FramePosition, LiveShowSceneBridgeMain p_LiveShowSceneBridgeMain, LiveShowVIPStatus p_LiveShowVIPStatus) {
        this.startUndoAction(11, LiveShowUndo.ACTION_ADD_STRING, null);
        this.clearSelectedObjects(true);
        long longFramePositionDiff = p_FramePosition - p_LiveShowSceneBridgeMain.getFrameStart();
        for (int intObject = 0; intObject < p_LiveShowSceneBridgeMain.getLiveShowSceneBridgeCount(); ++intObject) {
            LiveShowSceneBridge o_LiveShowObjectInterface = p_LiveShowSceneBridgeMain.getLiveShowSceneBridge(intObject);
            if (o_LiveShowObjectInterface == null) continue;
            LiveShowVIP o_LiveShowVIP = null;
            switch (o_LiveShowObjectInterface.getObjectType()) {
                case 2: {
                    o_LiveShowVIP = this.getLiveShowVIP_FirstByType(VIPTYPE_SOUND);
                    break;
                }
                case 12: {
                    o_LiveShowVIP = this.getLiveShowVIP_FirstByType(VIPTYPE_DMX);
                    break;
                }
                case 22: {
                    o_LiveShowVIP = this.getLiveShowVIP_FirstByType(VIPTYPE_MEDIA);
                }
            }
            if (o_LiveShowVIP == null) continue;
            switch (o_LiveShowObjectInterface.getObjectType()) {
                case 2: 
                case 12: 
                case 22: {
                    o_LiveShowVIP.addLiveShowSceneBridge(o_LiveShowObjectInterface, o_LiveShowObjectInterface.getFrameStart() + longFramePositionDiff);
                    o_LiveShowVIP.addSelectedObject(o_LiveShowObjectInterface);
                }
            }
        }
        this.endUndoAction(11, true, p_LiveShowVIPStatus);
    }

    public void doActionMoveObjects(long p_FramePosition, LiveShowObjectDescription p_ActorDescription, LiveShowVIPStatus p_LiveShowVIPStatus) {
        if (p_ActorDescription == null) {
            return;
        }
        if (p_LiveShowVIPStatus == null) {
            return;
        }
        this.actionDragMove(null, p_FramePosition, p_ActorDescription, p_LiveShowVIPStatus);
    }

    public void doActionDragMove(LiveShowVIPTrack p_LiveShowVIPTrack, long p_FramePosition, LiveShowDragDrop.LiveShowTransferable.LiveShowTransferData p_LiveShowTransferData) {
        this.doActionDragMove(p_LiveShowVIPTrack, this.m_DragLastFramePosition, p_LiveShowTransferData.getActorDescription(), p_LiveShowTransferData.getLiveShowVIPStatus());
    }

    public void doActionDragMove(LiveShowVIPTrack p_LiveShowVIPTrack, long p_FramePosition, LiveShowObjectDescription p_ActorDescription, LiveShowVIPStatus p_LiveShowVIPStatus) {
        this.m_DragLastFramePosition = p_FramePosition;
        this.startUndoAction(20, LiveShowUndo.ACTION_DRAGMOVE_STRING, p_LiveShowVIPStatus);
        this.actionDragRemove(p_LiveShowVIPTrack, this.m_DragLastFramePosition, p_ActorDescription, p_LiveShowVIPStatus);
    }

    public void doActionDragCopy(LiveShowVIPTrack p_LiveShowVIPTrack, long p_FramePosition, LiveShowDragDrop.LiveShowTransferable.LiveShowTransferData p_LiveShowTransferData) {
        this.m_DragLastFramePosition = p_FramePosition;
        this.startUndoAction(21, LiveShowUndo.ACTION_DRAGCOPY_STRING, p_LiveShowTransferData.getLiveShowVIPStatus());
        this.actionDragAdd(p_LiveShowVIPTrack, this.m_DragLastFramePosition, p_LiveShowTransferData.getActorDescription(), p_LiveShowTransferData.getLiveShowVIPStatus());
    }

    public void doActionDragEnter(LiveShowVIPTrack p_LiveShowVIPTrack, long p_FramePosition, LiveShowDragDrop.LiveShowTransferable.LiveShowTransferData p_LiveShowTransferData) {
        this.startUndoAction(11, LiveShowUndo.ACTION_ADD_STRING, null);
        this.m_DragLastFramePosition = p_FramePosition;
        this.actionDragAdd(p_LiveShowVIPTrack, this.m_DragLastFramePosition, p_LiveShowTransferData.getActorDescription(), p_LiveShowTransferData.getLiveShowVIPStatus());
    }

    public void doActionDragOver(LiveShowVIPTrack p_LiveShowVIPTrack, long p_FramePosition, LiveShowDragDrop.LiveShowTransferable.LiveShowTransferData p_LiveShowTransferData) {
        this.actionDragMove(p_LiveShowVIPTrack, p_FramePosition, p_LiveShowTransferData.getActorDescription(), p_LiveShowTransferData.getLiveShowVIPStatus());
        this.m_DragLastFramePosition = p_FramePosition;
    }

    public void doActionDragDrop() {
        this.m_DragLastFramePosition = 0L;
    }

    public void endActionDrag(boolean p_Success, LiveShowVIPStatus p_LiveShowVIPStatus) {
        this.m_DragLastFramePosition = 0L;
        this.endUndoAction(26, true, p_LiveShowVIPStatus);
    }

    public boolean actionCheckDragStart(LiveShowVIPTrack p_LiveShowVIPTrackTarget, long p_FramePosition, LiveShowObjectDescription p_ActorDescription, LiveShowVIPStatus p_LiveShowVIPStatus) {
        int intVipTrackDifference = 0;
        int intVIPTrackIndex = this.getLiveShowVIPTrackNumber(p_LiveShowVIPTrackTarget);
        if (p_ActorDescription.getObjectType() == 1 || p_ActorDescription.getObjectType() == 11 || p_ActorDescription.getObjectType() == 21 || p_ActorDescription.getObjectType() == 25) {
            int intVIPTrackIndexOfObject = p_ActorDescription.getVIPTrackNumber();
            intVipTrackDifference = intVIPTrackIndexOfObject - intVIPTrackIndex;
        }
        boolean boolOK = true;
        for (int intVIP = 0; intVIP < p_LiveShowVIPStatus.getLiveShowVIPCount(); ++intVIP) {
            ArrayList<LiveShowObjectDescription> o_Status_ObjectDescriptions;
            String stringVIPType = p_LiveShowVIPStatus.getLiveShowVIPType(intVIP);
            LiveShowVIP o_LiveShowVIP = this.getLiveShowVIP_FirstByType(stringVIPType);
            if (o_LiveShowVIP == null || (o_Status_ObjectDescriptions = p_LiveShowVIPStatus.getLiveShowObjectDescriptions(intVIP)) == null) continue;
            block4: for (int intObject = 0; intObject < o_Status_ObjectDescriptions.size(); ++intObject) {
                LiveShowObjectDescription o_Status_ObjectDescription = o_Status_ObjectDescriptions.get(intObject);
                if (o_Status_ObjectDescription == null) continue;
                LiveShowObjectInterface o_LiveShowObjectInterface = o_LiveShowVIP.findLiveShowObjectInterface(o_Status_ObjectDescription.getID());
                switch (o_Status_ObjectDescription.getObjectType()) {
                    case 1: 
                    case 11: 
                    case 21: 
                    case 25: {
                        LiveShowVIPTrack o_LiveShowVIPTrack = o_LiveShowVIP.getLiveShowVIPTrack(o_Status_ObjectDescription.getVIPTrackNumber() - intVipTrackDifference);
                        if (o_LiveShowVIPTrack != null) continue block4;
                        boolOK = false;
                        continue block4;
                    }
                }
            }
            if (!boolOK) break;
        }
        return boolOK;
    }

    public void actionDragAdd(LiveShowVIPTrack p_LiveShowVIPTrack, long p_FramePosition, LiveShowObjectDescription p_ActorDescription, LiveShowVIPStatus p_LiveShowVIPStatus) {
        if (p_ActorDescription == null) {
            return;
        }
        if (p_LiveShowVIPStatus == null) {
            return;
        }
        int intVipTrackDifference = 0;
        int intVIPTrackIndex = this.getLiveShowVIPTrackNumber(p_LiveShowVIPTrack);
        long longFrameDiff = p_FramePosition - p_ActorDescription.getFrameStart();
        if (p_ActorDescription.getObjectType() == 1 || p_ActorDescription.getObjectType() == 11 || p_ActorDescription.getObjectType() == 21 || p_ActorDescription.getObjectType() == 25) {
            int intVIPTrackIndexOfObject = p_ActorDescription.getVIPTrackNumber();
            intVipTrackDifference = intVIPTrackIndexOfObject - intVIPTrackIndex;
        }
        this.clearSelectedObjects(true);
        for (int intVIP = 0; intVIP < p_LiveShowVIPStatus.getLiveShowVIPCount(); ++intVIP) {
            ArrayList<LiveShowObjectDescription> o_Status_ObjectDescriptions;
            String stringVIPType = p_LiveShowVIPStatus.getLiveShowVIPType(intVIP);
            LiveShowVIP o_LiveShowVIP = this.getLiveShowVIP_FirstByType(stringVIPType);
            if (o_LiveShowVIP == null || (o_Status_ObjectDescriptions = p_LiveShowVIPStatus.getLiveShowObjectDescriptions(intVIP)) == null) continue;
            block5: for (int intObject = 0; intObject < o_Status_ObjectDescriptions.size(); ++intObject) {
                LiveShowObjectDescription o_Status_ObjectDescription = o_Status_ObjectDescriptions.get(intObject);
                if (o_Status_ObjectDescription == null) continue;
                LiveShowObjectInterface o_LiveShowObjectInterface = o_LiveShowVIP.findLiveShowObjectInterface(o_Status_ObjectDescription.getID());
                long longObjectStartFrame = o_Status_ObjectDescription.getFrameStart() + longFrameDiff;
                switch (o_Status_ObjectDescription.getObjectType()) {
                    case 1: 
                    case 11: 
                    case 21: 
                    case 25: {
                        LiveShowVIPTrack o_LiveShowVIPTrack = o_LiveShowVIP.getLiveShowVIPTrack(o_Status_ObjectDescription.getVIPTrackNumber() - intVipTrackDifference);
                        if (o_LiveShowVIPTrack == null) continue block5;
                        if (o_LiveShowObjectInterface == null) {
                            o_LiveShowObjectInterface = o_LiveShowVIP.createLiveShowObject(o_Status_ObjectDescription);
                        }
                        o_LiveShowVIPTrack.addLiveShowObjectInterface(o_LiveShowObjectInterface, longObjectStartFrame);
                        o_LiveShowVIP.addSelectedObject(o_LiveShowObjectInterface);
                        continue block5;
                    }
                    case 2: 
                    case 12: 
                    case 22: {
                        if (o_LiveShowObjectInterface == null) {
                            o_LiveShowObjectInterface = o_LiveShowVIP.createLiveShowSceneBridge(o_Status_ObjectDescription);
                            o_LiveShowVIP.addLiveShowSceneBridge((LiveShowSceneBridge)o_LiveShowObjectInterface, longObjectStartFrame);
                        } else {
                            o_LiveShowObjectInterface.changeStartPosition(longObjectStartFrame);
                        }
                        o_LiveShowVIP.addSelectedObject(o_LiveShowObjectInterface);
                    }
                }
            }
        }
    }

    public void actionDragRemove(LiveShowVIPTrack p_LiveShowVIPTrack, long p_FramePosition, LiveShowObjectDescription p_ActorDescription, LiveShowVIPStatus p_LiveShowVIPStatus) {
        if (p_ActorDescription == null) {
            return;
        }
        if (p_LiveShowVIPStatus == null) {
            return;
        }
        int intVipTrackDifference = 0;
        int intVIPTrackIndex = this.getLiveShowVIPTrackNumber(p_LiveShowVIPTrack);
        long longFrameDiff = p_FramePosition - p_ActorDescription.getFrameStart();
        if (p_ActorDescription.getObjectType() == 1 || p_ActorDescription.getObjectType() == 11 || p_ActorDescription.getObjectType() == 21 || p_ActorDescription.getObjectType() == 25) {
            int intVIPTrackIndexOfObject = p_ActorDescription.getVIPTrackNumber();
            intVipTrackDifference = intVIPTrackIndexOfObject - intVIPTrackIndex;
        }
        this.clearSelectedObjects(true);
        for (int intVIP = 0; intVIP < p_LiveShowVIPStatus.getLiveShowVIPCount(); ++intVIP) {
            ArrayList<LiveShowObjectDescription> o_Status_ObjectDescriptions;
            String stringVIPType = p_LiveShowVIPStatus.getLiveShowVIPType(intVIP);
            LiveShowVIP o_LiveShowVIP = this.getLiveShowVIP_FirstByType(stringVIPType);
            if (o_LiveShowVIP == null || (o_Status_ObjectDescriptions = p_LiveShowVIPStatus.getLiveShowObjectDescriptions(intVIP)) == null) continue;
            block4: for (int intObject = 0; intObject < o_Status_ObjectDescriptions.size(); ++intObject) {
                LiveShowObjectInterface o_LiveShowObjectInterface;
                LiveShowObjectDescription o_Status_ObjectDescription = o_Status_ObjectDescriptions.get(intObject);
                if (o_Status_ObjectDescription == null || (o_LiveShowObjectInterface = o_LiveShowVIP.findLiveShowObjectInterface(o_Status_ObjectDescription.getID())) == null) continue;
                switch (o_Status_ObjectDescription.getObjectType()) {
                    case 1: 
                    case 11: 
                    case 21: 
                    case 25: {
                        LiveShowVIPTrack o_LiveShowVIPTrack = o_LiveShowVIP.getLiveShowVIPTrack(o_Status_ObjectDescription.getVIPTrackNumber() - intVipTrackDifference);
                        if (o_LiveShowVIPTrack == null) continue block4;
                        o_LiveShowVIPTrack.removeLiveShowObjectInterface(o_LiveShowObjectInterface);
                        o_LiveShowVIP.removeSelectedObject(o_LiveShowObjectInterface);
                        continue block4;
                    }
                }
            }
        }
    }

    public void actionDragMove(LiveShowVIPTrack p_LiveShowVIPTrack, long p_FramePosition, LiveShowObjectDescription p_ActorDescription, LiveShowVIPStatus p_LiveShowVIPStatus) {
        if (p_ActorDescription == null) {
            return;
        }
        if (p_LiveShowVIPStatus == null) {
            return;
        }
        long longActorStartFrame = p_FramePosition;
        long longCheckedFramePosition = this.checkSnapping(0, p_ActorDescription, p_LiveShowVIPStatus, longActorStartFrame, true);
        if (longCheckedFramePosition >= 0L) {
            longActorStartFrame = longCheckedFramePosition;
        }
        long longFrameDiff = longActorStartFrame - p_ActorDescription.getFrameStart();
        if ((longFrameDiff = this.checkLeftBound(p_LiveShowVIPStatus, longFrameDiff, true)) == 0L) {
            return;
        }
        this.startUndoAction(13, LiveShowUndo.ACTION_MOVE_STRING, p_LiveShowVIPStatus);
        for (int intVIP = 0; intVIP < p_LiveShowVIPStatus.getLiveShowVIPCount(); ++intVIP) {
            ArrayList<LiveShowObjectDescription> o_Status_ObjectDescriptions;
            String stringVIPType = p_LiveShowVIPStatus.getLiveShowVIPType(intVIP);
            LiveShowVIP o_LiveShowVIP = this.getLiveShowVIP_FirstByType(stringVIPType);
            if (o_LiveShowVIP == null || (o_Status_ObjectDescriptions = p_LiveShowVIPStatus.getLiveShowObjectDescriptions(intVIP)) == null) continue;
            block5: for (int intObject = 0; intObject < o_Status_ObjectDescriptions.size(); ++intObject) {
                LiveShowObjectDescription o_Status_ObjectDescription = o_Status_ObjectDescriptions.get(intObject);
                LiveShowObjectInterface o_LiveShowObjectInterface = o_LiveShowVIP.findLiveShowObjectInterface(o_Status_ObjectDescription.getID());
                if (o_LiveShowObjectInterface == null) continue;
                switch (o_Status_ObjectDescription.getObjectType()) {
                    case 1: 
                    case 11: 
                    case 21: 
                    case 25: {
                        o_LiveShowObjectInterface.changeStartPosition(o_Status_ObjectDescription.getFrameStart() + longFrameDiff);
                        continue block5;
                    }
                    case 2: 
                    case 12: 
                    case 22: {
                        LiveShowSceneBridge o_LiveShowSceneBridge = (LiveShowSceneBridge)o_LiveShowObjectInterface;
                        if (o_LiveShowSceneBridge.getIsMainBridge()) {
                            if (o_Status_ObjectDescription.getObjectType() != 2) continue block5;
                            o_LiveShowObjectInterface.changeStartPosition(o_Status_ObjectDescription.getFrameStart() + longFrameDiff);
                            continue block5;
                        }
                        o_LiveShowObjectInterface.changeStartPosition(o_Status_ObjectDescription.getFrameStart() + longFrameDiff);
                    }
                }
            }
        }
    }

    public void setLiveShowNotification(LiveShowNotification p_LiveShowNotification) {
        this.m_LiveShowNotification = p_LiveShowNotification;
    }

    public LiveShowNotification getLiveShowNotification() {
        return this.m_LiveShowNotification;
    }

    static {
        FRAMETIME = 1.0;
        EDITMODEON = false;
        s_ExternalMouseObjectPanels = new ArrayList();
        s_ExternalMouseSceneBridgePanels = new ArrayList();
        s_ExternalMouseFirstPanel = null;
        s_ExternalMouseFirstWasSelected = false;
        s_ExternalMouseBounds = new Rectangle();
    }

    public static class LiveShowVIPStatus
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        private ArrayList<String> m_LiveShowVIPTypes;
        private ArrayList<ArrayList<LiveShowObjectDescription>> m_LiveShowVIPObjectDescriptions;
        private final Object m_SyncDecriptions = new Object();

        public LiveShowVIPStatus() {
            this.initMembers();
            this.m_LiveShowVIPTypes = new ArrayList();
            this.m_LiveShowVIPObjectDescriptions = new ArrayList();
        }

        public LiveShowVIPStatus(LiveShowVIPStatus p_LiveShowVIPStatus) {
            this.initMembers();
            if (p_LiveShowVIPStatus != null) {
                this.m_LiveShowVIPTypes = new ArrayList(p_LiveShowVIPStatus.getLiveShowVIPCount());
                this.m_LiveShowVIPObjectDescriptions = new ArrayList();
                for (int intVip = 0; intVip < p_LiveShowVIPStatus.getLiveShowVIPCount(); ++intVip) {
                    ArrayList<LiveShowObjectDescription> o_ArrayListDescriptionsExist = p_LiveShowVIPStatus.getLiveShowObjectDescriptions(intVip);
                    ArrayList o_ArrayListDescriptions = o_ArrayListDescriptionsExist == null ? new ArrayList() : new ArrayList(o_ArrayListDescriptionsExist.size());
                    this.m_LiveShowVIPObjectDescriptions.add(o_ArrayListDescriptions);
                }
            } else {
                this.m_LiveShowVIPTypes = new ArrayList();
                this.m_LiveShowVIPObjectDescriptions = new ArrayList();
            }
        }

        private void initMembers() {
        }

        public void close() {
            this.close(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(boolean p_CloseDescriptions) {
            Object object = this.m_SyncDecriptions;
            synchronized (object) {
                this.m_LiveShowVIPTypes.clear();
                if (this.m_LiveShowVIPObjectDescriptions != null) {
                    for (int intDescriptions = this.m_LiveShowVIPObjectDescriptions.size() - 1; intDescriptions >= 0; --intDescriptions) {
                        ArrayList<LiveShowObjectDescription> o_LiveShowObjectDescriptions = this.m_LiveShowVIPObjectDescriptions.get(intDescriptions);
                        if (o_LiveShowObjectDescriptions == null) continue;
                        if (p_CloseDescriptions) {
                            for (int intDescription = o_LiveShowObjectDescriptions.size() - 1; intDescription >= 0; --intDescription) {
                                LiveShowObjectDescription o_LiveShowObjectDescription = o_LiveShowObjectDescriptions.get(intDescription);
                                if (o_LiveShowObjectDescription == null) continue;
                                o_LiveShowObjectDescription.close(true);
                            }
                        }
                        o_LiveShowObjectDescriptions.clear();
                    }
                    this.m_LiveShowVIPObjectDescriptions.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            Object object = this.m_SyncDecriptions;
            synchronized (object) {
                out.writeObject(this.m_LiveShowVIPTypes);
                out.writeObject(this.m_LiveShowVIPObjectDescriptions);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            Object object = this.m_SyncDecriptions;
            synchronized (object) {
                this.m_LiveShowVIPTypes = (ArrayList)in.readObject();
                this.m_LiveShowVIPObjectDescriptions = (ArrayList)in.readObject();
            }
        }

        public int getLiveShowVIPCount() {
            return this.m_LiveShowVIPTypes.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLiveShowVIPsAllObjects_Cloned(LiveShowVIP p_LiveShowVIP) {
            if (p_LiveShowVIP == null) {
                return;
            }
            Object object = this.m_SyncDecriptions;
            synchronized (object) {
                if (this.m_LiveShowVIPTypes.contains(p_LiveShowVIP.getType())) {
                    return;
                }
                this.m_LiveShowVIPTypes.add(p_LiveShowVIP.getType());
                ArrayList<LiveShowObjectDescription> o_LiveShowObjectDescriptions = new ArrayList<LiveShowObjectDescription>();
                for (int intObject = 0; intObject < p_LiveShowVIP.getLiveShowObjectInterfaceCount(); ++intObject) {
                    LiveShowObjectInterface o_LiveShowObjectInterface = p_LiveShowVIP.getLiveShowObjectInterface(intObject);
                    if (o_LiveShowObjectInterface == null) continue;
                    LiveShowObjectDescription o_LiveShowObjectDescription = o_LiveShowObjectInterface.getDescription().clone(null);
                    o_LiveShowObjectDescriptions.add(o_LiveShowObjectDescription);
                }
                this.m_LiveShowVIPObjectDescriptions.add(o_LiveShowObjectDescriptions);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLiveShowVIPsSelectedObjects_ForAction(LiveShowVIP p_LiveShowVIP) {
            if (p_LiveShowVIP == null) {
                return;
            }
            Object object = this.m_SyncDecriptions;
            synchronized (object) {
                if (this.m_LiveShowVIPTypes.contains(p_LiveShowVIP.getType())) {
                    return;
                }
                this.m_LiveShowVIPTypes.add(p_LiveShowVIP.getType());
                ArrayList<LiveShowObjectDescription> o_LiveShowObjectDescriptions = new ArrayList<LiveShowObjectDescription>();
                for (int intObject = 0; intObject < p_LiveShowVIP.getSelectedObjectsCount(); ++intObject) {
                    LiveShowObjectDescription o_LiveShowObjectDescription = p_LiveShowVIP.getSelectedObjectDescription(intObject);
                    if (o_LiveShowObjectDescription == null) continue;
                    o_LiveShowObjectDescriptions.add(o_LiveShowObjectDescription);
                }
                this.m_LiveShowVIPObjectDescriptions.add(o_LiveShowObjectDescriptions);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLiveShowVIPsSelectedObjects_Cloned(LiveShowVIP p_LiveShowVIP) {
            if (p_LiveShowVIP == null) {
                return;
            }
            Object object = this.m_SyncDecriptions;
            synchronized (object) {
                if (this.m_LiveShowVIPTypes.contains(p_LiveShowVIP.getType())) {
                    return;
                }
                this.m_LiveShowVIPTypes.add(p_LiveShowVIP.getType());
                ArrayList<LiveShowObjectDescription> o_LiveShowObjectDescriptions = new ArrayList<LiveShowObjectDescription>();
                for (int intObject = 0; intObject < p_LiveShowVIP.getSelectedObjectsCount(); ++intObject) {
                    LiveShowObjectDescription o_LiveShowObjectDescription = p_LiveShowVIP.getSelectedObjectDescription(intObject).clone(null);
                    if (o_LiveShowObjectDescription == null) continue;
                    o_LiveShowObjectDescriptions.add(o_LiveShowObjectDescription);
                }
                this.m_LiveShowVIPObjectDescriptions.add(o_LiveShowObjectDescriptions);
            }
        }

        public void addLiveShowObject_ForAction(LiveShowObjectInterface p_LiveShowObjectInterface) {
            if (p_LiveShowObjectInterface == null) {
                return;
            }
            this.addLiveShowObjectDescription_ForAction(p_LiveShowObjectInterface.getDescription());
        }

        public void addLiveShowObject_Cloned(LiveShowObjectInterface p_LiveShowObjectInterface) {
            if (p_LiveShowObjectInterface == null) {
                return;
            }
            this.addLiveShowObjectDescription_Cloned(p_LiveShowObjectInterface.getDescription());
        }

        public void addLiveShowObjects_ForAction(ArrayList<LiveShowObjectInterface> p_LiveShowObjectDescriptions) {
            if (p_LiveShowObjectDescriptions == null) {
                return;
            }
            for (int intObject = 0; intObject < p_LiveShowObjectDescriptions.size(); ++intObject) {
                LiveShowObjectInterface o_LiveShowObjectInterface = p_LiveShowObjectDescriptions.get(intObject);
                if (o_LiveShowObjectInterface == null) continue;
                this.addLiveShowObjectDescription_ForAction(o_LiveShowObjectInterface.getDescription());
            }
        }

        public void addLiveShowSceneBridge_Cloned(LiveShowSceneBridge p_LiveShowSceneBridge) {
            if (p_LiveShowSceneBridge == null) {
                return;
            }
            if (!p_LiveShowSceneBridge.getIsMainBridge()) {
                this.addLiveShowObjectDescription_Cloned(p_LiveShowSceneBridge.getDescription());
            } else {
                LiveShowSceneBridgeMain o_LiveShowSceneBridgeMain = p_LiveShowSceneBridge.getLiveShowSceneBridgeMain();
                if (o_LiveShowSceneBridgeMain == null) {
                    return;
                }
                for (int intBridge = 0; intBridge < o_LiveShowSceneBridgeMain.getLiveShowSceneBridgeCount(); ++intBridge) {
                    LiveShowSceneBridge o_LiveShowSceneBridge = o_LiveShowSceneBridgeMain.getLiveShowSceneBridge(intBridge);
                    if (o_LiveShowSceneBridge == null) continue;
                    this.addLiveShowObjectDescription_Cloned(o_LiveShowSceneBridge.getDescription());
                }
            }
        }

        public void addLiveShowObjectDescriptions_Cloned(ArrayList<LiveShowObjectDescription> p_LiveShowObjectDescriptions) {
            if (p_LiveShowObjectDescriptions == null) {
                return;
            }
            for (int intDescription = 0; intDescription < p_LiveShowObjectDescriptions.size(); ++intDescription) {
                LiveShowObjectDescription o_LiveShowObjectDescription = p_LiveShowObjectDescriptions.get(intDescription);
                if (o_LiveShowObjectDescription == null) continue;
                this.addLiveShowObjectDescription_Cloned(o_LiveShowObjectDescription);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLiveShowObjectDescription_ForAction(LiveShowObjectDescription p_LiveShowObjectDescription) {
            String stringVIPType;
            if (p_LiveShowObjectDescription == null) {
                return;
            }
            switch (p_LiveShowObjectDescription.getObjectType()) {
                case 1: 
                case 2: {
                    stringVIPType = LiveShowVIP.VIPTYPE_SOUND;
                    break;
                }
                case 11: 
                case 12: {
                    stringVIPType = LiveShowVIP.VIPTYPE_DMX;
                    break;
                }
                case 21: 
                case 22: 
                case 25: {
                    stringVIPType = LiveShowVIP.VIPTYPE_MEDIA;
                    break;
                }
                default: {
                    return;
                }
            }
            Object object = this.m_SyncDecriptions;
            synchronized (object) {
                int intIndex;
                if (!this.m_LiveShowVIPTypes.contains(stringVIPType)) {
                    this.m_LiveShowVIPTypes.add(stringVIPType);
                    this.m_LiveShowVIPObjectDescriptions.add(new ArrayList());
                }
                if ((intIndex = this.m_LiveShowVIPTypes.indexOf(stringVIPType)) >= 0) {
                    ArrayList<LiveShowObjectDescription> o_LiveShowObjectDescriptions = this.m_LiveShowVIPObjectDescriptions.get(intIndex);
                    o_LiveShowObjectDescriptions.add(p_LiveShowObjectDescription);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLiveShowObjectDescription_Cloned(LiveShowObjectDescription p_LiveShowObjectDescription) {
            String stringVIPType;
            if (p_LiveShowObjectDescription == null) {
                return;
            }
            switch (p_LiveShowObjectDescription.getObjectType()) {
                case 1: 
                case 2: {
                    stringVIPType = LiveShowVIP.VIPTYPE_SOUND;
                    break;
                }
                case 11: 
                case 12: {
                    stringVIPType = LiveShowVIP.VIPTYPE_DMX;
                    break;
                }
                case 21: 
                case 22: 
                case 25: {
                    stringVIPType = LiveShowVIP.VIPTYPE_MEDIA;
                    break;
                }
                default: {
                    return;
                }
            }
            Object object = this.m_SyncDecriptions;
            synchronized (object) {
                int intIndex;
                if (!this.m_LiveShowVIPTypes.contains(stringVIPType)) {
                    this.m_LiveShowVIPTypes.add(stringVIPType);
                    this.m_LiveShowVIPObjectDescriptions.add(new ArrayList());
                }
                if ((intIndex = this.m_LiveShowVIPTypes.indexOf(stringVIPType)) >= 0) {
                    ArrayList<LiveShowObjectDescription> o_LiveShowObjectDescriptions = this.m_LiveShowVIPObjectDescriptions.get(intIndex);
                    o_LiveShowObjectDescriptions.add(p_LiveShowObjectDescription.clone(null));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSingleObjectDescription(String p_VIPType, LiveShowObjectDescription p_LiveShowObjectDescription) {
            if (p_VIPType == null || p_VIPType.length() <= 0) {
                return;
            }
            if (p_LiveShowObjectDescription == null) {
                return;
            }
            Object object = this.m_SyncDecriptions;
            synchronized (object) {
                int intIndex;
                if (!this.m_LiveShowVIPTypes.contains(p_VIPType)) {
                    this.m_LiveShowVIPTypes.add(p_VIPType);
                    this.m_LiveShowVIPObjectDescriptions.add(new ArrayList());
                }
                if ((intIndex = this.m_LiveShowVIPTypes.indexOf(p_VIPType)) < 0) {
                    return;
                }
                ArrayList<LiveShowObjectDescription> o_LiveShowObjectDescriptions = this.m_LiveShowVIPObjectDescriptions.get(intIndex);
                o_LiveShowObjectDescriptions.add(p_LiveShowObjectDescription);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LiveShowVIPStatus clone() {
            LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIPStatus(this);
            Object object = this.m_SyncDecriptions;
            synchronized (object) {
                for (int intVip = 0; intVip < this.m_LiveShowVIPObjectDescriptions.size(); ++intVip) {
                    ArrayList<LiveShowObjectDescription> o_LiveShowObjectDescriptions = this.m_LiveShowVIPObjectDescriptions.get(intVip);
                    if (o_LiveShowObjectDescriptions == null) continue;
                    for (int intObject = 0; intObject < o_LiveShowObjectDescriptions.size(); ++intObject) {
                        LiveShowObjectDescription o_LiveShowObjectDescription = o_LiveShowObjectDescriptions.get(intObject);
                        if (o_LiveShowObjectDescription == null) continue;
                        o_LiveShowVIPStatus.addLiveShowObjectDescription_Cloned(o_LiveShowObjectDescription);
                    }
                }
            }
            return o_LiveShowVIPStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getLiveShowVIPType(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncDecriptions;
            synchronized (object) {
                if (p_Index >= this.m_LiveShowVIPTypes.size()) {
                    return null;
                }
                return this.m_LiveShowVIPTypes.get(p_Index);
            }
        }

        public boolean affectsLiveShowVipType(LiveShowVIP p_LiveShowVIP) {
            if (p_LiveShowVIP == null) {
                return false;
            }
            ArrayList<LiveShowObjectDescription> o_LiveShowObjectDescriptions = this.getLiveShowObjectDescriptions(p_LiveShowVIP.getType());
            return o_LiveShowObjectDescriptions != null && o_LiveShowObjectDescriptions.size() > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<LiveShowObjectDescription> getLiveShowObjectDescriptions(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncDecriptions;
            synchronized (object) {
                if (p_Index >= this.m_LiveShowVIPObjectDescriptions.size()) {
                    return null;
                }
                return this.m_LiveShowVIPObjectDescriptions.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<LiveShowObjectDescription> getLiveShowObjectDescriptions(String p_LiveShowVIPType) {
            if (p_LiveShowVIPType == null) {
                return null;
            }
            Object object = this.m_SyncDecriptions;
            synchronized (object) {
                int intIndex = this.m_LiveShowVIPTypes.indexOf(p_LiveShowVIPType);
                if (intIndex < 0) {
                    return null;
                }
                if (intIndex >= this.m_LiveShowVIPObjectDescriptions.size()) {
                    return null;
                }
                return this.m_LiveShowVIPObjectDescriptions.get(intIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(LiveShowObjectDescription p_LiveShowObjectDescription) {
            if (p_LiveShowObjectDescription == null) {
                return true;
            }
            String stringID = p_LiveShowObjectDescription.getID();
            if (stringID == null) {
                return true;
            }
            Object object = this.m_SyncDecriptions;
            synchronized (object) {
                for (int intVIPType = 0; intVIPType < this.m_LiveShowVIPObjectDescriptions.size(); ++intVIPType) {
                    ArrayList<LiveShowObjectDescription> o_LiveShowObjectDescriptions = this.m_LiveShowVIPObjectDescriptions.get(intVIPType);
                    if (o_LiveShowObjectDescriptions == null) continue;
                    for (int intObjectDescription = 0; intObjectDescription < o_LiveShowObjectDescriptions.size(); ++intObjectDescription) {
                        LiveShowObjectDescription o_LiveShowObjectDescription = o_LiveShowObjectDescriptions.get(intObjectDescription);
                        if (o_LiveShowObjectDescription == null || !stringID.equals(o_LiveShowObjectDescription.getID())) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    public static class SceneBridgeComparator
    implements Comparator<LiveShowSceneBridge> {
        @Override
        public int compare(LiveShowSceneBridge p_Scene1, LiveShowSceneBridge p_Scene2) {
            if (p_Scene1 == null && p_Scene2 == null) {
                return 0;
            }
            if (p_Scene1 == null) {
                return -1;
            }
            if (p_Scene2 == null) {
                return 1;
            }
            if (p_Scene1.getFrameStart() == p_Scene2.getFrameStart()) {
                return 0;
            }
            if (p_Scene1.getFrameStart() < p_Scene2.getFrameStart()) {
                return -1;
            }
            return 1;
        }
    }
}

