/*
 * Decompiled with CFR 0.152.
 */
package LiveShowVirtualPackage;

import OS.OSChecker;
import java.util.ArrayList;

public class LiveShowTimerSignal {
    private Thread m_ThreadSignal;
    private Runnable m_RunnableSignal;
    private Object m_SyncSignal = new Object();
    private boolean m_StopSignal;
    private boolean m_IsRunning;
    private long m_WaitMilliseconds;
    private long m_StartMilliseconds;
    private Object m_Source;
    private ArrayList<TimerSignalListener> m_TimerSignalListeners;
    private Object m_SyncListeners = new Object();

    public LiveShowTimerSignal(Object p_Source, long p_Milliseconds) {
        this.initMembers();
        this.m_WaitMilliseconds = p_Milliseconds;
        if (this.m_WaitMilliseconds < 10L) {
            this.m_WaitMilliseconds = 10L;
        }
        if (this.m_WaitMilliseconds > 50L) {
            this.m_WaitMilliseconds = 50L;
        }
        this.m_Source = p_Source;
    }

    private void initMembers() {
        this.m_TimerSignalListeners = new ArrayList();
        this.m_StopSignal = false;
        this.m_IsRunning = false;
        this.m_RunnableSignal = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (LiveShowTimerSignal.this.m_ThreadSignal == null) {
                    return;
                }
                LiveShowTimerSignal.this.m_IsRunning = true;
                LiveShowTimerSignal.this.notify_Started();
                Object object = LiveShowTimerSignal.this.m_SyncSignal;
                synchronized (object) {
                    LiveShowTimerSignal.this.m_StartMilliseconds = LiveShowTimerSignal.this.getSystemTimeMilliseconds();
                    while (!LiveShowTimerSignal.this.m_StopSignal) {
                        LiveShowTimerSignal.this.notify_SignalFire((long)((double)System.nanoTime() / 1000000.0 + 0.5) - LiveShowTimerSignal.this.m_StartMilliseconds);
                        try {
                            if (LiveShowTimerSignal.this.m_WaitMilliseconds <= 0L) continue;
                            if (OSChecker.getIsWindows()) {
                                long longWaitStart;
                                for (long longWaitTime = LiveShowTimerSignal.this.m_WaitMilliseconds; longWaitTime > 0L && !LiveShowTimerSignal.this.m_StopSignal; longWaitTime -= System.nanoTime() / 1000000L - longWaitStart) {
                                    longWaitStart = System.nanoTime() / 1000000L;
                                    LiveShowTimerSignal.this.m_SyncSignal.wait(longWaitTime);
                                }
                                continue;
                            }
                            LiveShowTimerSignal.this.m_SyncSignal.wait(LiveShowTimerSignal.this.m_WaitMilliseconds);
                        }
                        catch (Exception exception) {}
                    }
                    LiveShowTimerSignal.this.m_IsRunning = false;
                    LiveShowTimerSignal.this.m_ThreadSignal = null;
                }
                LiveShowTimerSignal.this.notify_Stopped();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.m_SyncListeners;
        synchronized (object) {
            this.m_TimerSignalListeners.clear();
        }
        this.stop();
    }

    public Object getSource() {
        return this.m_Source;
    }

    public void start() {
        if (this.m_IsRunning) {
            return;
        }
        this.m_StopSignal = false;
        this.m_ThreadSignal = new Thread(this.m_RunnableSignal, this.getClass().getSimpleName());
        this.m_ThreadSignal.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.m_StopSignal = true;
        Object object = this.m_SyncSignal;
        synchronized (object) {
            this.m_SyncSignal.notifyAll();
        }
    }

    public boolean isRunning() {
        return this.m_IsRunning;
    }

    public long getDurationMilliseconds() {
        if (this.m_StopSignal) {
            return 0L;
        }
        return (long)((double)System.nanoTime() / 1000000.0 + 0.5) - this.m_StartMilliseconds;
    }

    public long getSystemTimeMilliseconds() {
        return (long)((double)System.nanoTime() / 1000000.0 + 0.5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimerSignalListener(TimerSignalListener p_TimerSignalListener) {
        if (p_TimerSignalListener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_TimerSignalListeners.contains(p_TimerSignalListener)) {
                return;
            }
            this.m_TimerSignalListeners.add(p_TimerSignalListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimerSignalListener(TimerSignalListener p_TimerSignalListener) {
        if (p_TimerSignalListener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (!this.m_TimerSignalListeners.contains(p_TimerSignalListener)) {
                return;
            }
            this.m_TimerSignalListeners.remove(p_TimerSignalListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify_SignalFire(long p_MilliSeconds) {
        ArrayList<TimerSignalListener> o_TimerSignalListeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_TimerSignalListeners.size() <= 0) {
                return;
            }
            o_TimerSignalListeners = new ArrayList<TimerSignalListener>(this.m_TimerSignalListeners.size());
            o_TimerSignalListeners.addAll(this.m_TimerSignalListeners);
        }
        for (int intListener = 0; intListener < o_TimerSignalListeners.size(); ++intListener) {
            TimerSignalListener o_TimerSignalListener = (TimerSignalListener)o_TimerSignalListeners.get(intListener);
            o_TimerSignalListener.eventTimerSignal_FireSignal(this, this.m_Source, p_MilliSeconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify_Started() {
        ArrayList<TimerSignalListener> o_TimerSignalListeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_TimerSignalListeners.size() <= 0) {
                return;
            }
            o_TimerSignalListeners = new ArrayList<TimerSignalListener>(this.m_TimerSignalListeners.size());
            o_TimerSignalListeners.addAll(this.m_TimerSignalListeners);
        }
        for (int intListener = 0; intListener < o_TimerSignalListeners.size(); ++intListener) {
            TimerSignalListener o_TimerSignalListener = (TimerSignalListener)o_TimerSignalListeners.get(intListener);
            o_TimerSignalListener.eventTimerSignal_Started(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify_Stopped() {
        ArrayList<TimerSignalListener> o_TimerSignalListeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_TimerSignalListeners.size() <= 0) {
                return;
            }
            o_TimerSignalListeners = new ArrayList<TimerSignalListener>(this.m_TimerSignalListeners.size());
            o_TimerSignalListeners.addAll(this.m_TimerSignalListeners);
        }
        for (int intListener = 0; intListener < o_TimerSignalListeners.size(); ++intListener) {
            TimerSignalListener o_TimerSignalListener = (TimerSignalListener)o_TimerSignalListeners.get(intListener);
            o_TimerSignalListener.eventTimerSignal_Stopped(this);
        }
    }

    public static interface TimerSignalListener {
        public void eventTimerSignal_FireSignal(LiveShowTimerSignal var1, Object var2, long var3);

        public void eventTimerSignal_Started(LiveShowTimerSignal var1);

        public void eventTimerSignal_Stopped(LiveShowTimerSignal var1);
    }
}

