/*
 * Decompiled with CFR 0.152.
 */
package LiveShowVirtualPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowTimer;
import LiveShowVirtualPackage.LiveShowVIP;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class LiveShowTimerDisplay
extends JPanel
implements LiveShowTimer.LiveShowTimerListener,
ComponentListener {
    public static Border s_BorderWarning = new LineBorder(Color.RED, 3);
    public static Color s_ColorStopped = new Color(150, 40, 0);
    public static Border s_BorderSelected = new LineBorder(Color.BLUE, 1);
    public static Border s_BorderNormal = null;
    public static Border s_BorderRecordOn = new LineBorder(Color.RED, 2);
    private LiveShowTimer m_LiveShowTimer;
    private Dimension m_OldJLabel_Time_Size;
    private boolean m_FontResizable;
    private int m_OriginFontSize;
    private long m_TimeFramesRest;
    private JButton jButton_TimeDelete;
    private JButton jButton_TimeRecord;
    private JButton jButton_TimeSwitch;
    private JLabel jLabel_Time;

    public LiveShowTimerDisplay() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener(this, null);
    }

    private void initMembers() {
        this.m_LiveShowTimer = LiveShowTimer.selfReference();
        this.m_OldJLabel_Time_Size = new Dimension(0, 0);
        this.m_FontResizable = true;
        this.m_TimeFramesRest = Long.MIN_VALUE;
    }

    private void initComponentsFurther() {
        this.m_OriginFontSize = this.jLabel_Time.getFont().getSize();
        this.jLabel_Time.addComponentListener(this);
        this.calculateFont();
        this.m_LiveShowTimer.addLiveShowTimerListener(this);
        this.eventTimeNextOneStopped(null, true);
        this.jButton_TimeRecord.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_TimeRecord.setCursor(Cursor.getPredefinedCursor(12));
        this.jButton_TimeSwitch.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_TimeSwitch.setCursor(Cursor.getPredefinedCursor(12));
        this.jButton_TimeDelete.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_TimeDelete.setCursor(Cursor.getPredefinedCursor(12));
        this.jLabel_Time.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    public void close() {
        this.jButton_TimeRecord.setComponentPopupMenu(null);
        this.jButton_TimeSwitch.setComponentPopupMenu(null);
        this.jButton_TimeDelete.setComponentPopupMenu(null);
        this.jLabel_Time.setComponentPopupMenu(null);
        LiveLanguage.removeLanguageListener(this);
        this.jLabel_Time.removeComponentListener(this);
        this.m_LiveShowTimer.removeLiveShowTimerListener(this);
        LiveLanguage.removeLanguageListener(this);
    }

    public void setFontResizable(boolean p_Resizable) {
        if (this.m_FontResizable == p_Resizable) {
            return;
        }
        Font o_Font = this.jLabel_Time.getFont();
        this.m_FontResizable = p_Resizable;
        this.m_FontResizable = false;
        if (false) {
            Font o_NewFont = o_Font.deriveFont(this.m_OriginFontSize);
            this.jLabel_Time.setFont(o_NewFont);
        }
    }

    public void refreshGUI() {
        if (this.m_LiveShowTimer.getTimeRecordOn()) {
            this.jButton_TimeRecord.setBorder(s_BorderRecordOn);
            this.jButton_TimeRecord.setBorderPainted(true);
        } else {
            this.jButton_TimeRecord.setBorder(s_BorderNormal);
            this.jButton_TimeRecord.setBorderPainted(false);
        }
        if (this.m_LiveShowTimer.getShowTimeRecorded()) {
            this.jButton_TimeSwitch.setBorder(s_BorderSelected);
            this.jButton_TimeSwitch.setBorderPainted(true);
        } else {
            this.jButton_TimeSwitch.setBorder(s_BorderNormal);
            this.jButton_TimeSwitch.setBorderPainted(false);
        }
    }

    private void initComponents() {
        this.jButton_TimeRecord = new JButton();
        this.jLabel_Time = new JLabel();
        this.jButton_TimeSwitch = new JButton();
        this.jButton_TimeDelete = new JButton();
        this.setLayout(new GridBagLayout());
        this.jButton_TimeRecord.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Time_Record.png")));
        this.jButton_TimeRecord.setToolTipText("Record Time");
        this.jButton_TimeRecord.setContentAreaFilled(false);
        this.jButton_TimeRecord.setMaximumSize(new Dimension(35, 35));
        this.jButton_TimeRecord.setMinimumSize(new Dimension(35, 35));
        this.jButton_TimeRecord.setPreferredSize(new Dimension(35, 35));
        this.jButton_TimeRecord.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_TimeRecord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowTimerDisplay.this.jButton_TimeRecordActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        this.add((Component)this.jButton_TimeRecord, gridBagConstraints);
        this.jLabel_Time.setFont(new Font("Tahoma", 0, 24));
        this.jLabel_Time.setHorizontalAlignment(0);
        this.jLabel_Time.setText("00:00:00:0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.add((Component)this.jLabel_Time, gridBagConstraints);
        this.jButton_TimeSwitch.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Time_Switch.png")));
        this.jButton_TimeSwitch.setToolTipText("Switch Time Record<->Timeline");
        this.jButton_TimeSwitch.setContentAreaFilled(false);
        this.jButton_TimeSwitch.setMaximumSize(new Dimension(35, 35));
        this.jButton_TimeSwitch.setMinimumSize(new Dimension(35, 35));
        this.jButton_TimeSwitch.setPreferredSize(new Dimension(35, 35));
        this.jButton_TimeSwitch.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_TimeSwitch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowTimerDisplay.this.jButton_TimeSwitchActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        this.add((Component)this.jButton_TimeSwitch, gridBagConstraints);
        this.jButton_TimeDelete.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Time_RecordDelete.png")));
        this.jButton_TimeDelete.setToolTipText("Delete all recorded times");
        this.jButton_TimeDelete.setContentAreaFilled(false);
        this.jButton_TimeDelete.setMaximumSize(new Dimension(35, 35));
        this.jButton_TimeDelete.setMinimumSize(new Dimension(35, 35));
        this.jButton_TimeDelete.setPreferredSize(new Dimension(35, 35));
        this.jButton_TimeDelete.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_TimeDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowTimerDisplay.this.jButton_TimeDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 1);
        this.add((Component)this.jButton_TimeDelete, gridBagConstraints);
    }

    private void jButton_TimeRecordActionPerformed(ActionEvent evt) {
        if (this.m_LiveShowTimer != null) {
            if (this.m_LiveShowTimer.getTimeRecordOn()) {
                this.m_LiveShowTimer.setTimeRecordOn(false);
            } else {
                this.m_LiveShowTimer.setTimeRecordOn(true);
            }
        }
    }

    private void jButton_TimeSwitchActionPerformed(ActionEvent evt) {
        if (this.m_LiveShowTimer != null) {
            if (this.m_LiveShowTimer.getShowTimeRecorded()) {
                this.m_LiveShowTimer.setShowTimeRecorded(false);
            } else {
                this.m_LiveShowTimer.setShowTimeRecorded(true);
            }
        }
    }

    private void jButton_TimeDeleteActionPerformed(ActionEvent evt) {
        if (this.m_LiveShowTimer != null) {
            this.m_LiveShowTimer.deleteTimesAll();
        }
    }

    @Override
    public void eventTimeNextAction(LiveShowTimer p_LiveShowTimer, LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge, long p_TimeFramesRest, String p_TimeString, boolean p_TimeRecorded, Color p_ColorForeground) {
        if (this.m_TimeFramesRest == p_TimeFramesRest && p_ColorForeground.equals(this.jLabel_Time.getForeground())) {
            return;
        }
        this.m_TimeFramesRest = p_TimeFramesRest;
        this.jLabel_Time.setForeground(p_ColorForeground);
        this.jLabel_Time.setText(p_TimeString);
        this.jLabel_Time.repaint();
    }

    @Override
    public void eventTimeWarning1(LiveShowTimer p_LiveShowTimer, boolean p_On) {
        if (p_On) {
            // empty if block
        }
    }

    @Override
    public void eventTimeWarning2(LiveShowTimer p_LiveShowTimer, boolean p_On) {
        if (p_On) {
            this.jLabel_Time.setBorder(s_BorderWarning);
        } else {
            this.jLabel_Time.setBorder(null);
        }
    }

    @Override
    public void eventTimeNextOneStopped(LiveShowTimer p_LiveShowTimer, boolean p_OneStopped) {
        if (p_OneStopped) {
            this.jLabel_Time.setBackground(s_ColorStopped);
            this.jLabel_Time.setOpaque(true);
        } else {
            this.jLabel_Time.setOpaque(false);
        }
        this.jLabel_Time.repaint();
    }

    @Override
    public void eventTimeRecordOn(LiveShowTimer p_LiveShowTimer, boolean p_RecordRunning) {
        this.refreshGUI();
    }

    @Override
    public void eventShowTimeRecorded(LiveShowTimer p_LiveShowTimer, boolean p_ShowTimeRecorded) {
        this.refreshGUI();
    }

    private void calculateFont() {
        Font o_Font = this.jLabel_Time.getFont();
        FontMetrics o_FontMetrics = this.jLabel_Time.getFontMetrics(o_Font);
        int intFontWidth = o_FontMetrics.stringWidth("00:00:00:000");
        float floatWidth = this.jLabel_Time.getWidth() - 2;
        float floatHeight = this.jLabel_Time.getHeight();
        if (floatHeight == 0.0f || floatWidth == 0.0f || intFontWidth == 0) {
            return;
        }
        Font o_NewFont = o_Font.deriveFont(Math.min(floatWidth / (float)intFontWidth * (float)o_Font.getSize(), floatHeight));
        this.jLabel_Time.setFont(o_NewFont);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (e.getComponent() == this.jLabel_Time) {
            boolean boolRecalculate = false;
            if (Math.abs((double)this.jLabel_Time.getWidth() - this.m_OldJLabel_Time_Size.getWidth()) > 6.0) {
                boolRecalculate = true;
            }
            if (Math.abs((double)this.jLabel_Time.getHeight() - this.m_OldJLabel_Time_Size.getHeight()) > 6.0) {
                boolRecalculate = true;
            }
            if (!boolRecalculate) {
                return;
            }
            this.m_OldJLabel_Time_Size = this.jLabel_Time.getSize();
            this.calculateFont();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

