/*
 * Decompiled with CFR 0.152.
 */
package LiveShowVirtualPackage;

import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.PlayListener;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowTimerSignal;
import LiveShowVirtualPackage.LiveShowVIP;
import LiveShowVirtualPackage.LiveShowVIPListener;
import LiveShowVirtualPackage.LiveShowVIPTrack;
import SynchronizationPackage.EventQueueHandler;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class LiveShowTimer
implements LiveShowVIPListener,
PlayListener {
    public static long s_TimeWarning1_Milliseconds = 30000L;
    public static long s_TimeWarning1_Frames = 0L;
    public static long s_TimeWarning2_Milliseconds = 10000L;
    public static long s_TimeWarning2_Frames = 0L;
    public static Color s_Color_Warning1 = new Color(255, 150, 10);
    public static Color s_Color_Warning2 = new Color(255, 50, 50);
    public static Color s_Color_Normal = Color.WHITE;
    public static Color s_Color_Recorded = new Color(0, 200, 0);
    private HashMap<LiveShowVIP, VIPTime> m_VIPTimes;
    private final Object m_SyncVIPTimes = new Object();
    private ArrayList<LiveShowTimerListener> m_LiveShowTimerListeners;
    private boolean m_RecordOn;
    private boolean m_ShowTimeRecorded;
    private boolean m_OneStopped;
    private VIPTime m_NextAction_VIPTimeLowest;
    private LiveShowVIP m_NextAction_LiveShowVIP;
    private LiveShowSceneBridge m_NextAction_SceneBridge;
    private long m_NextAction_FramesRest;
    private String m_NextAction_TimeString;
    private boolean m_NextAction_TimeRecorded;
    private boolean m_NextAction_TimerWarning1;
    private Color m_NextAction_ColorForeground;
    private boolean m_NextAction_TimerWarning2;
    private Runnable m_RunnableNotifyTimeNextAction;
    private Runnable m_RunnableTimeNextOneStopped;
    private LiveShowTimer m_SelfReference;
    private static StringBuilder s_StringBuilderTime = new StringBuilder();
    private static final Object s_SyncTimeString = new Object();
    private static final Object s_SyncListeners = new Object();
    private static LiveShowTimer s_SelfReference = new LiveShowTimer();

    public static LiveShowTimer selfReference() {
        return s_SelfReference;
    }

    public static void setTimeWarning1(long p_Milliseconds) {
        if (p_Milliseconds < 0L) {
            p_Milliseconds = 0L;
        }
        s_TimeWarning1_Milliseconds = p_Milliseconds;
    }

    public static long getTimeWarning1() {
        return s_TimeWarning1_Milliseconds;
    }

    public static void setTimeWarning2(long p_Milliseconds) {
        if (p_Milliseconds < 0L) {
            p_Milliseconds = 0L;
        }
        s_TimeWarning1_Milliseconds = p_Milliseconds;
    }

    public static long getTimeWarning2() {
        return s_TimeWarning1_Milliseconds;
    }

    public LiveShowTimer() {
        this.initMembers();
        this.m_SelfReference = this;
    }

    private void initMembers() {
        this.m_LiveShowTimerListeners = new ArrayList();
        this.m_VIPTimes = new HashMap();
        this.m_OneStopped = true;
        this.m_RecordOn = false;
        this.m_NextAction_VIPTimeLowest = null;
        this.m_NextAction_LiveShowVIP = null;
        this.m_NextAction_SceneBridge = null;
        this.m_NextAction_FramesRest = -1L;
        this.m_NextAction_TimeString = "-";
        this.m_NextAction_TimeRecorded = false;
        this.m_NextAction_TimerWarning1 = false;
        this.m_NextAction_TimerWarning2 = false;
        this.m_NextAction_ColorForeground = s_Color_Normal;
        this.m_RunnableNotifyTimeNextAction = new Runnable(){

            @Override
            public void run() {
                LiveShowTimer.this.notifyTimerListeners_TimeNextAction();
            }
        };
        this.m_RunnableTimeNextOneStopped = new Runnable(){

            @Override
            public void run() {
                LiveShowTimer.this.refreshOneStopped();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLiveShowVIP(LiveShowVIP p_LiveShowVIP) {
        if (p_LiveShowVIP == null) {
            return;
        }
        Object object = this.m_SyncVIPTimes;
        synchronized (object) {
            if (this.m_VIPTimes.containsKey(p_LiveShowVIP)) {
                return;
            }
            this.m_VIPTimes.put(p_LiveShowVIP, new VIPTime(this, p_LiveShowVIP));
        }
        p_LiveShowVIP.addLiveShowVIPListener(this);
        p_LiveShowVIP.getPlay().addPlayListener(this);
        if (p_LiveShowVIP.getFrameTime() <= 0.0) {
            s_TimeWarning1_Frames = 0L;
            s_TimeWarning2_Frames = 0L;
        } else {
            s_TimeWarning1_Frames = (long)((double)s_TimeWarning1_Milliseconds / p_LiveShowVIP.getFrameTime());
            s_TimeWarning2_Frames = (long)((double)s_TimeWarning2_Milliseconds / p_LiveShowVIP.getFrameTime());
        }
        this.refreshTimesLiveShowVIP(p_LiveShowVIP);
        EventQueueHandler.invokeLater(this.m_RunnableTimeNextOneStopped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLiveShowVIP(LiveShowVIP p_LiveShowVIP) {
        VIPTime o_VIPTime;
        if (p_LiveShowVIP == null) {
            return;
        }
        this.setTimeRecordOn(false);
        Object object = this.m_SyncVIPTimes;
        synchronized (object) {
            o_VIPTime = this.m_VIPTimes.get(p_LiveShowVIP);
            if (o_VIPTime != null) {
                o_VIPTime.close();
            }
            if (this.m_VIPTimes.remove(p_LiveShowVIP) == null) {
                return;
            }
        }
        if (this.m_NextAction_VIPTimeLowest == o_VIPTime) {
            this.m_NextAction_VIPTimeLowest = null;
        }
        p_LiveShowVIP.removeLiveShowVIPListener(this);
        p_LiveShowVIP.getPlay().removePlayListener(this);
        EventQueueHandler.invokeLater(this.m_RunnableTimeNextOneStopped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VIPTime getVIPTime(LiveShowVIP p_LiveShowVIP) {
        if (p_LiveShowVIP == null) {
            return null;
        }
        Object object = this.m_SyncVIPTimes;
        synchronized (object) {
            return this.m_VIPTimes.get(p_LiveShowVIP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeRecordOn(boolean p_TimeRecordOn) {
        if (this.m_RecordOn == p_TimeRecordOn) {
            return;
        }
        Object object = this.m_SyncVIPTimes;
        synchronized (object) {
            for (LiveShowVIP o_LiveShowVIP : this.m_VIPTimes.keySet()) {
                VIPTime o_VIPTime = this.m_VIPTimes.get(o_LiveShowVIP);
                if (o_VIPTime == null) continue;
                this.m_RecordOn = p_TimeRecordOn;
                o_VIPTime.setRecordOn(this.m_RecordOn);
            }
        }
        this.notifyTimerListeners_TimeRecordOn(this.m_RecordOn);
    }

    public boolean getTimeRecordOn() {
        return this.m_RecordOn;
    }

    public void setShowTimeRecorded(boolean p_ShowTimeRecorded) {
        if (this.m_ShowTimeRecorded == p_ShowTimeRecorded) {
            return;
        }
        this.m_ShowTimeRecorded = p_ShowTimeRecorded;
        this.refreshTimesAll();
        this.notifyTimerListeners_ShowTimeRecorded(this.m_ShowTimeRecorded);
    }

    public boolean getShowTimeRecorded() {
        return this.m_ShowTimeRecorded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTimesAll() {
        Object object = this.m_SyncVIPTimes;
        synchronized (object) {
            for (LiveShowVIP o_LiveShowVIP : this.m_VIPTimes.keySet()) {
                if (o_LiveShowVIP == null) continue;
                this.deleteTimesLiveShowVIP(o_LiveShowVIP);
            }
        }
    }

    public void deleteTimesLiveShowVIP(LiveShowVIP p_LiveShowVIP) {
        if (p_LiveShowVIP == null) {
            return;
        }
        if (p_LiveShowVIP == null) {
            return;
        }
        for (int intSceneBridge = 0; intSceneBridge < p_LiveShowVIP.getLiveShowSceneBridgeCount(); ++intSceneBridge) {
            LiveShowSceneBridge o_LiveShowSceneBridge = p_LiveShowVIP.getLiveShowSceneBridge(intSceneBridge);
            if (o_LiveShowSceneBridge == null) continue;
            o_LiveShowSceneBridge.setFramesRecordedNextSceneBridge(-1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTimesAll() {
        ArrayList<LiveShowVIP> o_LiveShowVIPs;
        Object object = this.m_SyncVIPTimes;
        synchronized (object) {
            o_LiveShowVIPs = new ArrayList<LiveShowVIP>(this.m_VIPTimes.size());
            o_LiveShowVIPs.addAll(this.m_VIPTimes.keySet());
        }
        for (int intLiveShowVIP = 0; intLiveShowVIP < o_LiveShowVIPs.size(); ++intLiveShowVIP) {
            LiveShowVIP o_LiveShowVIP = (LiveShowVIP)o_LiveShowVIPs.get(intLiveShowVIP);
            if (o_LiveShowVIP == null) continue;
            this.refreshTimesLiveShowVIP(o_LiveShowVIP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTimesLiveShowVIP(LiveShowVIP p_LiveShowVIP) {
        VIPTime o_VIPTime;
        if (p_LiveShowVIP == null) {
            return;
        }
        Object object = this.m_SyncVIPTimes;
        synchronized (object) {
            o_VIPTime = this.m_VIPTimes.get(p_LiveShowVIP);
        }
        if (o_VIPTime == null) {
            return;
        }
        o_VIPTime.calculateSceneBridge_Frames_StartEnd();
        this.refreshTimesLiveShowVIP(p_LiveShowVIP, o_VIPTime, null);
        for (int intSceneBridge = 0; intSceneBridge < p_LiveShowVIP.getLiveShowSceneBridgeCount(); ++intSceneBridge) {
            LiveShowSceneBridge o_LiveShowSceneBridge = p_LiveShowVIP.getLiveShowSceneBridge(intSceneBridge);
            if (o_LiveShowSceneBridge == null) continue;
            this.refreshTimesLiveShowVIP(p_LiveShowVIP, o_VIPTime, o_LiveShowSceneBridge);
        }
    }

    public void refreshTimesLiveShowVIP(LiveShowVIP p_LiveShowVIP, VIPTime p_VIPTime, LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowVIP == null) {
            return;
        }
        if (p_VIPTime == null) {
            return;
        }
        long longTimeFramesRest = 0L;
        boolean boolRecorded = false;
        if (this.m_ShowTimeRecorded && p_VIPTime.getHasRecordedFrames(p_LiveShowSceneBridge)) {
            longTimeFramesRest = p_VIPTime.getRecordedFramesRest(p_LiveShowSceneBridge);
            boolRecorded = true;
        } else {
            longTimeFramesRest = p_VIPTime.getTimelineFramesRest(p_LiveShowSceneBridge);
            boolRecorded = false;
        }
        String stringTimeString = LiveShowTimer.calculateTimeString(p_LiveShowVIP, longTimeFramesRest);
        SceneBridgeTimer o_SceneBridgeTimer = p_VIPTime.getSceneBridgeTimer(p_LiveShowSceneBridge);
        if (o_SceneBridgeTimer != null && o_SceneBridgeTimer.setParams(longTimeFramesRest, stringTimeString, boolRecorded)) {
            o_SceneBridgeTimer.notifyTimerListeners_ScenBridge();
        }
        if (p_LiveShowVIP.getActive() && p_VIPTime.getLiveShowSceneBridge_Playing() == p_LiveShowSceneBridge) {
            p_VIPTime.setTimeStringNextAction(longTimeFramesRest, stringTimeString);
            this.refreshTimeNextAction(p_LiveShowVIP, p_VIPTime, longTimeFramesRest, stringTimeString, boolRecorded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTimeNextAction(LiveShowVIP p_LiveShowVIP, VIPTime p_VIPTime, long p_TimeFrames, String p_TimeString, boolean p_TimeRecorded) {
        if (p_VIPTime == null) {
            return;
        }
        long longTimeFramesPlaying = Long.MAX_VALUE;
        VIPTime o_VIPTimePlaying = null;
        long longTimeFrames = Long.MAX_VALUE;
        VIPTime o_VIPTimeLowest = null;
        Object object = this.m_SyncVIPTimes;
        synchronized (object) {
            for (VIPTime o_VIPTimeCheck : this.m_VIPTimes.values()) {
                LiveShowVIP o_LiveShowVIP;
                if (o_VIPTimeCheck == null || (o_LiveShowVIP = o_VIPTimeCheck.getLiveShowVIP()) == null || !o_LiveShowVIP.getActive()) continue;
                long longFrames = o_VIPTimeCheck.getFramesRestNextAction();
                if (longFrames < longTimeFrames) {
                    longTimeFrames = longFrames;
                    o_VIPTimeLowest = o_VIPTimeCheck;
                }
                if (!o_LiveShowVIP.getPlay().isRunning() && (!o_VIPTimeCheck.isTimerSignalRunning() || !this.m_ShowTimeRecorded) || longFrames >= longTimeFramesPlaying) continue;
                longTimeFramesPlaying = longFrames;
                o_VIPTimePlaying = o_VIPTimeCheck;
            }
        }
        if (o_VIPTimePlaying != null) {
            this.m_NextAction_VIPTimeLowest = o_VIPTimePlaying;
        } else if (o_VIPTimeLowest != null) {
            this.m_NextAction_VIPTimeLowest = o_VIPTimeLowest;
        }
        if (this.m_NextAction_VIPTimeLowest != null && this.setParamsNextAction(this.m_NextAction_VIPTimeLowest, p_TimeRecorded)) {
            EventQueueHandler.invokeLater(this.m_RunnableNotifyTimeNextAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshOneStopped() {
        boolean boolStopped = false;
        Object object = this.m_SyncVIPTimes;
        synchronized (object) {
            for (LiveShowVIP o_LiveShowVIP : this.m_VIPTimes.keySet()) {
                Play o_Play;
                if (o_LiveShowVIP == null || !o_LiveShowVIP.getActive() || (o_Play = o_LiveShowVIP.getPlay()) == null || o_Play.isRunning()) continue;
                boolStopped = true;
                break;
            }
        }
        if (this.m_OneStopped == boolStopped) {
            return;
        }
        this.m_OneStopped = boolStopped;
        this.notifyTimerListeners_TimeNextOneStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String calculateTimeString(LiveShowVIP p_LiveShowVIP, long p_Frames) {
        if (p_LiveShowVIP == null) {
            return "---";
        }
        Play o_Play = p_LiveShowVIP.getPlay();
        if (o_Play == null) {
            return "---";
        }
        Playable o_Playable = o_Play.getPlayable();
        if (o_Playable == null) {
            return "---";
        }
        Object object = s_SyncTimeString;
        synchronized (object) {
            s_StringBuilderTime.delete(0, s_StringBuilderTime.length());
            double doubleMilliSeconds = (double)p_Frames * o_Playable.getFrameTime();
            if (doubleMilliSeconds < 0.0) {
                s_StringBuilderTime.append("-");
                return s_StringBuilderTime.toString();
            }
            int intHours = (int)(doubleMilliSeconds / 3600000.0);
            int intMinutes = (int)((doubleMilliSeconds -= (double)(intHours * 3600000)) / 60000.0);
            int intSeconds = (int)((doubleMilliSeconds -= (double)(intMinutes * 60000)) / 1000.0);
            int intMilliseconds = (int)((doubleMilliSeconds -= (double)(intSeconds * 1000)) / 100.0);
            boolean boolShow = false;
            if (intHours > 0) {
                if (intHours < 10) {
                    s_StringBuilderTime.append("0");
                }
                s_StringBuilderTime.append(intHours);
                s_StringBuilderTime.append(":");
                boolShow = true;
            }
            if (intMinutes > 0 || boolShow) {
                if (intMinutes < 10) {
                    s_StringBuilderTime.append("0");
                }
                s_StringBuilderTime.append(intMinutes);
                s_StringBuilderTime.append(":");
                boolShow = true;
            }
            if (intSeconds > 0 || boolShow) {
                if (intSeconds < 10) {
                    s_StringBuilderTime.append("0");
                }
                s_StringBuilderTime.append(intSeconds);
                s_StringBuilderTime.append(":");
                boolShow = true;
            }
            if (intMilliseconds >= 0 || boolShow) {
                s_StringBuilderTime.append(intMilliseconds);
            } else {
                s_StringBuilderTime.append("---");
            }
            return s_StringBuilderTime.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLiveShowTimerListener(final LiveShowTimerListener p_LiveShowTimerListener) {
        if (p_LiveShowTimerListener == null) {
            return;
        }
        Object object = s_SyncListeners;
        synchronized (object) {
            if (this.m_LiveShowTimerListeners.contains(p_LiveShowTimerListener)) {
                return;
            }
            this.m_LiveShowTimerListeners.add(p_LiveShowTimerListener);
        }
        EventQueueHandler.invokeLater(new Runnable(){

            @Override
            public void run() {
                EventQueueHandler.invokeLater(LiveShowTimer.this.m_RunnableNotifyTimeNextAction);
                p_LiveShowTimerListener.eventTimeNextOneStopped(LiveShowTimer.this.m_SelfReference, LiveShowTimer.this.m_OneStopped);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLiveShowTimerListener(LiveShowTimerListener p_LiveShowTimerListener) {
        Object object = s_SyncListeners;
        synchronized (object) {
            if (!this.m_LiveShowTimerListeners.contains(p_LiveShowTimerListener)) {
                return;
            }
            this.m_LiveShowTimerListeners.remove(p_LiveShowTimerListener);
        }
    }

    public void addLiveShowTimerListener_SceneBridge(LiveShowTimerListener_SceneBridge p_LiveShowTimerListener, LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowTimerListener == null) {
            return;
        }
        VIPTime o_VIPTime = this.getVIPTime(p_LiveShowVIP);
        if (o_VIPTime == null) {
            return;
        }
        SceneBridgeTimer o_SceneBridgeTimer = o_VIPTime.getSceneBridgeTimer(p_LiveShowSceneBridge);
        if (o_SceneBridgeTimer == null) {
            return;
        }
        o_SceneBridgeTimer.addLiveShowTimerListener_SceneBridge(p_LiveShowTimerListener);
        this.refreshTimesLiveShowVIP(p_LiveShowVIP, o_VIPTime, p_LiveShowSceneBridge);
    }

    public void removeLiveShowTimerListener_SceneBridge(LiveShowTimerListener_SceneBridge p_LiveShowTimerListener, LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowTimerListener == null) {
            return;
        }
        VIPTime o_VIPTime = this.getVIPTime(p_LiveShowVIP);
        if (o_VIPTime == null) {
            return;
        }
        SceneBridgeTimer o_SceneBridgeTimer = o_VIPTime.getSceneBridgeTimer(p_LiveShowSceneBridge);
        if (o_SceneBridgeTimer == null) {
            return;
        }
        o_SceneBridgeTimer.removeLiveShowTimerListener_SceneBridge(p_LiveShowTimerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setParamsNextAction(VIPTime p_VIPTimeLowest, boolean p_Recorded) {
        if (p_VIPTimeLowest == null) {
            return false;
        }
        boolean boolWarning1 = false;
        boolean boolWarning2 = false;
        boolean boolChanged = false;
        Object object = s_SyncListeners;
        synchronized (object) {
            Color o_ColorForeground;
            long longFramesRest = p_VIPTimeLowest.getFramesRestNextAction();
            if (longFramesRest <= s_TimeWarning2_Frames) {
                o_ColorForeground = s_Color_Warning2;
                boolWarning2 = true;
            } else if (longFramesRest <= s_TimeWarning1_Frames) {
                o_ColorForeground = s_Color_Warning1;
                boolWarning1 = true;
            } else {
                o_ColorForeground = p_Recorded ? s_Color_Recorded : s_Color_Normal;
            }
            this.m_NextAction_FramesRest = p_VIPTimeLowest.getFramesRestNextAction();
            if (this.m_NextAction_LiveShowVIP != p_VIPTimeLowest.getLiveShowVIP()) {
                this.m_NextAction_LiveShowVIP = p_VIPTimeLowest.getLiveShowVIP();
                boolChanged = true;
            }
            if (this.m_NextAction_SceneBridge != p_VIPTimeLowest.getLiveShowSceneBridge_Playing()) {
                this.m_NextAction_SceneBridge = p_VIPTimeLowest.getLiveShowSceneBridge_Playing();
                boolChanged = true;
            }
            if (!this.m_NextAction_TimeString.equals(p_VIPTimeLowest.getTimeStringNextAction())) {
                this.m_NextAction_TimeString = p_VIPTimeLowest.getTimeStringNextAction();
                boolChanged = true;
            }
            if (this.m_NextAction_TimerWarning1 != boolWarning1) {
                this.m_NextAction_TimerWarning1 = boolWarning1;
                boolChanged = true;
            }
            if (this.m_NextAction_TimerWarning2 != boolWarning2) {
                this.m_NextAction_TimerWarning2 = boolWarning2;
                boolChanged = true;
            }
            if (!o_ColorForeground.equals(this.m_NextAction_ColorForeground)) {
                this.m_NextAction_ColorForeground = o_ColorForeground;
                boolChanged = true;
            }
            if (this.m_NextAction_TimeRecorded != p_Recorded) {
                this.m_NextAction_TimeRecorded = p_Recorded;
                boolChanged = true;
            }
        }
        return boolChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTimerListeners_TimeNextAction() {
        ArrayList<LiveShowTimerListener> o_LiveShowTimerListeners;
        Object object = s_SyncListeners;
        synchronized (object) {
            if (this.m_LiveShowTimerListeners == null) {
                return;
            }
            if (this.m_LiveShowTimerListeners.size() <= 0) {
                return;
            }
            o_LiveShowTimerListeners = new ArrayList<LiveShowTimerListener>(this.m_LiveShowTimerListeners.size());
            o_LiveShowTimerListeners.addAll(this.m_LiveShowTimerListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowTimerListeners.size(); ++intListener) {
            LiveShowTimerListener o_Listener = (LiveShowTimerListener)o_LiveShowTimerListeners.get(intListener);
            o_Listener.eventTimeNextAction(this, this.m_NextAction_LiveShowVIP, this.m_NextAction_SceneBridge, this.m_NextAction_FramesRest, this.m_NextAction_TimeString, this.m_NextAction_TimeRecorded, this.m_NextAction_ColorForeground);
            if (this.m_NextAction_TimerWarning1) {
                o_Listener.eventTimeWarning1(this, true);
            } else {
                o_Listener.eventTimeWarning1(this, false);
            }
            if (this.m_NextAction_TimerWarning2) {
                o_Listener.eventTimeWarning2(this, true);
                continue;
            }
            o_Listener.eventTimeWarning2(this, false);
        }
        o_LiveShowTimerListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTimerListeners_TimeNextOneStopped() {
        ArrayList<LiveShowTimerListener> o_LiveShowTimerListeners;
        Object object = s_SyncListeners;
        synchronized (object) {
            if (this.m_LiveShowTimerListeners == null) {
                return;
            }
            if (this.m_LiveShowTimerListeners.size() <= 0) {
                return;
            }
            o_LiveShowTimerListeners = new ArrayList<LiveShowTimerListener>(this.m_LiveShowTimerListeners.size());
            o_LiveShowTimerListeners.addAll(this.m_LiveShowTimerListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowTimerListeners.size(); ++intListener) {
            LiveShowTimerListener o_Listener = (LiveShowTimerListener)o_LiveShowTimerListeners.get(intListener);
            o_Listener.eventTimeNextOneStopped(this, this.m_OneStopped);
        }
        o_LiveShowTimerListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTimerListeners_TimeRecordOn(boolean p_RecordOn) {
        ArrayList<LiveShowTimerListener> o_LiveShowTimerListeners;
        Object object = s_SyncListeners;
        synchronized (object) {
            if (this.m_LiveShowTimerListeners == null) {
                return;
            }
            if (this.m_LiveShowTimerListeners.size() <= 0) {
                return;
            }
            o_LiveShowTimerListeners = new ArrayList<LiveShowTimerListener>(this.m_LiveShowTimerListeners.size());
            o_LiveShowTimerListeners.addAll(this.m_LiveShowTimerListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowTimerListeners.size(); ++intListener) {
            LiveShowTimerListener o_Listener = (LiveShowTimerListener)o_LiveShowTimerListeners.get(intListener);
            o_Listener.eventTimeRecordOn(this, p_RecordOn);
        }
        o_LiveShowTimerListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTimerListeners_ShowTimeRecorded(boolean p_ShowTimeRecorded) {
        ArrayList<LiveShowTimerListener> o_LiveShowTimerListeners;
        Object object = s_SyncListeners;
        synchronized (object) {
            if (this.m_LiveShowTimerListeners == null) {
                return;
            }
            if (this.m_LiveShowTimerListeners.size() <= 0) {
                return;
            }
            o_LiveShowTimerListeners = new ArrayList<LiveShowTimerListener>(this.m_LiveShowTimerListeners.size());
            o_LiveShowTimerListeners.addAll(this.m_LiveShowTimerListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowTimerListeners.size(); ++intListener) {
            LiveShowTimerListener o_Listener = (LiveShowTimerListener)o_LiveShowTimerListeners.get(intListener);
            o_Listener.eventShowTimeRecorded(this, p_ShowTimeRecorded);
        }
        o_LiveShowTimerListeners.clear();
    }

    @Override
    public void eventVIPActive(LiveShowVIP p_LiveShowVIP, boolean p_Active) {
        this.refreshTimesAll();
        EventQueueHandler.invokeLater(this.m_RunnableTimeNextOneStopped);
    }

    @Override
    public void eventVIPToFront(LiveShowVIP p_LiveShowVIP) {
    }

    @Override
    public void eventVIPTrackAdded(LiveShowVIP p_LiveShowVIP, LiveShowVIPTrack p_LiveShowVIPTrack) {
    }

    @Override
    public void eventVIPTrackRemoved(LiveShowVIP p_LiveShowVIP, LiveShowVIPTrack p_LiveShowVIPTrack) {
    }

    @Override
    public void eventVIPFrameMaxObjects(LiveShowVIP p_LiveShowVIP, long p_FrameMaxObjects) {
    }

    @Override
    public void eventVIPMaxFrame(LiveShowVIP p_LiveShowVIP, long p_FrameMax) {
    }

    @Override
    public void eventVIPFrameTime(LiveShowVIP p_LiveShowVIP, double p_FrameTime) {
    }

    @Override
    public void eventVIPClosing(LiveShowVIP p_LiveShowVIP) {
    }

    @Override
    public void eventVIPSceneBridgeAdded(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
        VIPTime o_VIPTime = this.m_VIPTimes.get(p_LiveShowVIP);
        if (o_VIPTime == null) {
            return;
        }
        o_VIPTime.addLiveShowSceneBridge(p_LiveShowSceneBridge);
        this.refreshTimesLiveShowVIP(p_LiveShowVIP);
    }

    @Override
    public void eventVIPSceneBridgeRemoved(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
        VIPTime o_VIPTime = this.m_VIPTimes.get(p_LiveShowVIP);
        if (o_VIPTime == null) {
            return;
        }
        o_VIPTime.removeLiveShowSceneBridge(p_LiveShowSceneBridge);
        this.refreshTimesLiveShowVIP(p_LiveShowVIP);
    }

    @Override
    public void eventVIPSceneBridgesResorted(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge, ArrayList<LiveShowSceneBridge> p_LiveShowSceneBridges) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventVIPSceneBridgeCursorChanged(LiveShowVIP p_LiveShowVIP, boolean p_ActualPlaying, boolean p_ActualStopAtStart) {
        VIPTime o_VIPTime;
        Object object = this.m_SyncVIPTimes;
        synchronized (object) {
            o_VIPTime = this.m_VIPTimes.get(p_LiveShowVIP);
        }
        if (o_VIPTime == null) {
            return;
        }
        o_VIPTime.eventVIPSceneBridgeCursorChanged(p_LiveShowVIP.getLiveShowSceneBridge_Cursor(), p_ActualPlaying, p_ActualStopAtStart);
    }

    @Override
    public void eventVIPSceneBridgeEditCursorChanged(LiveShowVIP p_LiveShowVIP) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventVIPSceneBridgeStart(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_WillPlay) {
        VIPTime o_VIPTime;
        Object object = this.m_SyncVIPTimes;
        synchronized (object) {
            o_VIPTime = this.m_VIPTimes.get(p_LiveShowVIP);
        }
        if (o_VIPTime == null) {
            return;
        }
        o_VIPTime.eventLiveShowSceneBridgeStart(p_LiveShowSceneBridge, p_WillPlay);
    }

    @Override
    public void eventVIPSceneBridgeEnd(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
    }

    @Override
    public void eventVIPObjectAdded(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectRemoved(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectParamChanged(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectShowSettings(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectSelection(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPEndOfAction(LiveShowVIP p_LiveShowVIP, LiveShowVIP p_ActorLiveShowVIP, boolean p_Success, int p_Action) {
        this.refreshTimesLiveShowVIP(p_LiveShowVIP);
    }

    @Override
    public void eventVIPEditModeOn(LiveShowVIP p_LiveShowVIP, boolean p_EditModeOn) {
    }

    @Override
    public void eventVIPCursorMode(LiveShowVIP p_LiveShowVIP, int p_EditMode) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventPlayStart(Play p_Play) {
        VIPTime o_VIPTime;
        if (p_Play == null) {
            return;
        }
        Playable o_Playable = p_Play.getPlayable();
        if (o_Playable == null) {
            return;
        }
        if (!(o_Playable instanceof LiveShowVIP)) {
            return;
        }
        LiveShowVIP o_LiveShowVIP = (LiveShowVIP)o_Playable;
        Object object = this.m_SyncVIPTimes;
        synchronized (object) {
            o_VIPTime = this.m_VIPTimes.get(o_LiveShowVIP);
        }
        if (o_VIPTime == null) {
            return;
        }
        o_VIPTime.eventPlayStart(p_Play);
        EventQueueHandler.invokeLater(this.m_RunnableTimeNextOneStopped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventPlayStop(Play p_Play) {
        VIPTime o_VIPTime;
        if (p_Play == null) {
            return;
        }
        Playable o_Playable = p_Play.getPlayable();
        if (o_Playable == null) {
            return;
        }
        if (!(o_Playable instanceof LiveShowVIP)) {
            return;
        }
        LiveShowVIP o_LiveShowVIP = (LiveShowVIP)o_Playable;
        Object object = this.m_SyncVIPTimes;
        synchronized (object) {
            o_VIPTime = this.m_VIPTimes.get(o_LiveShowVIP);
        }
        if (o_VIPTime == null) {
            return;
        }
        o_VIPTime.eventPlayStop(p_Play);
        EventQueueHandler.invokeLater(this.m_RunnableTimeNextOneStopped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventPlayPause(Play p_Play) {
        VIPTime o_VIPTime;
        if (p_Play == null) {
            return;
        }
        Playable o_Playable = p_Play.getPlayable();
        if (o_Playable == null) {
            return;
        }
        if (!(o_Playable instanceof LiveShowVIP)) {
            return;
        }
        LiveShowVIP o_LiveShowVIP = (LiveShowVIP)o_Playable;
        Object object = this.m_SyncVIPTimes;
        synchronized (object) {
            o_VIPTime = this.m_VIPTimes.get(o_LiveShowVIP);
        }
        if (o_VIPTime == null) {
            return;
        }
        o_VIPTime.eventPlayPause(p_Play);
        EventQueueHandler.invokeLater(this.m_RunnableTimeNextOneStopped);
    }

    @Override
    public void eventPlayRewind(Play p_Play) {
    }

    @Override
    public void eventPlayFastForward(Play p_Play) {
    }

    @Override
    public void eventPlayFadePossibility(Play p_Play, boolean p_FadeInPossible, boolean p_FadeOutPossible, double p_FadeProgress) {
    }

    @Override
    public void eventPlayFadedIn(Play p_Play, boolean p_FadedIn, double p_FadeProgress) {
    }

    @Override
    public long eventPlayCheckRead(Play p_Play, long p_FrameStart, long p_FramesToRead) {
        return p_FramesToRead;
    }

    @Override
    public void eventEditModeOn(Play p_Play, boolean p_EditModeOn) {
    }

    @Override
    public void eventEditCursorSet(Play p_Play, long p_PlayCursor) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventPlayCursorSet(Play p_Play, long p_PlayCursor) {
        VIPTime o_VIPTime;
        if (p_Play == null) {
            return;
        }
        Playable o_Playable = p_Play.getPlayable();
        if (o_Playable == null) {
            return;
        }
        if (!(o_Playable instanceof LiveShowVIP)) {
            return;
        }
        LiveShowVIP o_LiveShowVIP = (LiveShowVIP)o_Playable;
        Object object = this.m_SyncVIPTimes;
        synchronized (object) {
            o_VIPTime = this.m_VIPTimes.get(o_LiveShowVIP);
        }
        if (o_VIPTime == null) {
            return;
        }
        o_VIPTime.eventPlayCursorSet(p_PlayCursor);
    }

    @Override
    public void eventPlayCursor(Play p_Play, long p_OldPlayCursor, long p_PlayCursor) {
        if (p_Play == null) {
            return;
        }
        Playable o_Playable = p_Play.getPlayable();
        if (o_Playable == null) {
            return;
        }
        if (!(o_Playable instanceof LiveShowVIP)) {
            return;
        }
        LiveShowVIP o_LiveShowVIP = (LiveShowVIP)o_Playable;
        if (o_LiveShowVIP == null) {
            return;
        }
        VIPTime o_VIPTime = this.m_VIPTimes.get(o_LiveShowVIP);
        if (o_VIPTime == null) {
            return;
        }
        o_VIPTime.eventPlayCursor(p_Play, p_OldPlayCursor, p_PlayCursor);
    }

    @Override
    public void eventPlayClosing(Play p_Play) {
    }

    @Override
    public void eventPlayError(Play p_Play, Exception p_Exception, String p_Remark) {
    }

    @Override
    public void eventPlayTimelineEnd(Play p_Play) {
    }

    public static class VIPTime
    implements LiveShowTimerSignal.TimerSignalListener {
        private LiveShowTimer m_LiveShowTimer;
        private LiveShowVIP m_LiveShowVIP;
        private LiveShowTimerSignal m_LiveShowTimerSignal;
        private LiveShowSceneBridge m_SceneBridge_Reached;
        private LiveShowSceneBridge m_SceneBridge_Playing;
        private long m_SceneBridge_Playing_FrameStart;
        private long m_SceneBridge_Playing_FrameEnd;
        private boolean m_IsRunning;
        private String m_TimeStringRestAction;
        private long m_FramesRestNextAction;
        private boolean m_RecordOn;
        private long m_SystemFramesStart;
        private HashMap<LiveShowSceneBridge, SceneBridgeTimer> m_SceneBridgeTimers;
        private final Object m_SyncObjects = new Object();

        public VIPTime(LiveShowTimer p_LiveShowTimer, LiveShowVIP p_LiveShowVIP) {
            this.initMembers();
            this.m_LiveShowTimer = p_LiveShowTimer;
            this.m_LiveShowVIP = p_LiveShowVIP;
            this.m_SceneBridgeTimers.put(null, new SceneBridgeTimer(this.m_LiveShowTimer, this.m_LiveShowVIP, null));
            this.m_LiveShowTimerSignal = new LiveShowTimerSignal(this.m_LiveShowVIP, 40L);
            this.m_LiveShowTimerSignal.addTimerSignalListener(this);
            if (this.m_LiveShowVIP != null) {
                for (int intSceneBridge = 0; intSceneBridge < this.m_LiveShowVIP.getLiveShowSceneBridgeCount(); ++intSceneBridge) {
                    LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowVIP.getLiveShowSceneBridge(intSceneBridge);
                    this.addLiveShowSceneBridge(o_LiveShowSceneBridge);
                }
            }
        }

        private void initMembers() {
            this.m_LiveShowVIP = null;
            this.m_IsRunning = false;
            this.m_SceneBridge_Playing = null;
            this.m_SceneBridge_Reached = null;
            this.m_TimeStringRestAction = "---";
            this.m_FramesRestNextAction = 0L;
            this.m_SceneBridgeTimers = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.m_LiveShowTimerSignal.close();
            if (this.m_LiveShowVIP != null) {
                Object object = this.m_SyncObjects;
                synchronized (object) {
                    Iterator<LiveShowSceneBridge> o_Iterator = this.m_SceneBridgeTimers.keySet().iterator();
                    while (o_Iterator.hasNext()) {
                        LiveShowSceneBridge o_LiveShowSceneBridge = o_Iterator.next();
                        SceneBridgeTimer o_SceneBridgeTimer = this.m_SceneBridgeTimers.get(o_LiveShowSceneBridge);
                        if (o_SceneBridgeTimer != null) {
                            o_SceneBridgeTimer.close();
                        }
                        o_Iterator.remove();
                    }
                }
            }
            this.m_LiveShowVIP = null;
        }

        public LiveShowVIP getLiveShowVIP() {
            return this.m_LiveShowVIP;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLiveShowSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge) {
            if (p_LiveShowSceneBridge == null) {
                return;
            }
            Object object = this.m_SyncObjects;
            synchronized (object) {
                SceneBridgeTimer o_SceneBridgeTimer = this.m_SceneBridgeTimers.get(p_LiveShowSceneBridge);
                if (o_SceneBridgeTimer != null) {
                    return;
                }
                this.m_SceneBridgeTimers.put(p_LiveShowSceneBridge, new SceneBridgeTimer(this.m_LiveShowTimer, this.m_LiveShowVIP, p_LiveShowSceneBridge));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLiveShowSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge) {
            if (p_LiveShowSceneBridge == null) {
                return;
            }
            Object object = this.m_SyncObjects;
            synchronized (object) {
                SceneBridgeTimer o_SceneBridgeTimer = this.m_SceneBridgeTimers.get(p_LiveShowSceneBridge);
                if (o_SceneBridgeTimer == null) {
                    return;
                }
                o_SceneBridgeTimer.close();
                this.m_SceneBridgeTimers.remove(p_LiveShowSceneBridge);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SceneBridgeTimer getSceneBridgeTimer(LiveShowSceneBridge p_LiveShowSceneBridge) {
            Object object = this.m_SyncObjects;
            synchronized (object) {
                return this.m_SceneBridgeTimers.get(p_LiveShowSceneBridge);
            }
        }

        public void eventLiveShowSceneBridgeStart(LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_WillPlay) {
        }

        public void eventVIPSceneBridgeCursorChanged(LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_ActualPlaying, boolean p_ActualStopAtStart) {
            LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
            if (o_LiveShowVIP == null) {
                return;
            }
            if (p_ActualStopAtStart && p_LiveShowSceneBridge != null && o_LiveShowVIP.getPlay().getPlayCursor() == p_LiveShowSceneBridge.getFrameStart()) {
                if (this.m_SceneBridge_Reached == p_LiveShowSceneBridge) {
                    return;
                }
                this.m_SceneBridge_Reached = p_LiveShowSceneBridge;
                LiveShowSceneBridge o_SceneBridge_Playing = this.m_SceneBridge_Playing;
                if (o_SceneBridge_Playing != null && o_SceneBridge_Playing.getFramesRecordedNextSceneBridge() > 0L && this.getRecordedFramesRest(o_SceneBridge_Playing) > 0L) {
                    this.m_LiveShowTimerSignal.start();
                }
                return;
            }
            if (this.m_SceneBridge_Playing == p_LiveShowSceneBridge) {
                this.m_SceneBridge_Reached = this.m_SceneBridge_Playing;
                return;
            }
            this.setSceneBridge_PlayStart(p_LiveShowSceneBridge);
            this.m_LiveShowTimer.refreshTimesLiveShowVIP(o_LiveShowVIP, this, this.m_SceneBridge_Playing);
        }

        public void eventPlayStart(Play p_Play) {
            LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
            if (o_LiveShowVIP == null) {
                return;
            }
            this.m_IsRunning = true;
            this.setSceneBridge_PlayStart(this.m_SceneBridge_Reached);
        }

        public void eventPlayStop(Play p_Play) {
            LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
            if (o_LiveShowVIP == null) {
                return;
            }
            this.m_IsRunning = false;
            this.m_LiveShowTimer.refreshTimesLiveShowVIP(o_LiveShowVIP, this, this.m_SceneBridge_Playing);
        }

        public void eventPlayPause(Play p_Play) {
            LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
            if (o_LiveShowVIP == null) {
                return;
            }
            this.m_IsRunning = false;
            this.m_LiveShowTimer.refreshTimesLiveShowVIP(o_LiveShowVIP, this, this.m_SceneBridge_Playing);
        }

        public boolean isRunning() {
            return this.m_IsRunning;
        }

        public boolean isTimerSignalRunning() {
            if (this.m_LiveShowTimerSignal == null) {
                return false;
            }
            return this.m_LiveShowTimerSignal.isRunning();
        }

        public void setSceneBridge_PlayStart(LiveShowSceneBridge p_LiveShowSceneBridge) {
            LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
            if (o_LiveShowVIP == null) {
                return;
            }
            if (this.m_RecordOn && o_LiveShowVIP.getActive() && this.m_SceneBridge_Playing != null && (this.m_SceneBridge_Playing != this.m_SceneBridge_Reached || p_LiveShowSceneBridge != this.m_SceneBridge_Reached)) {
                long longSystemTimeStopped = this.getSystemTimeFrames();
                this.m_SceneBridge_Playing.setFramesRecordedNextSceneBridge(longSystemTimeStopped - this.m_SystemFramesStart);
            }
            if (this.m_SceneBridge_Playing == p_LiveShowSceneBridge) {
                this.m_SceneBridge_Reached = this.m_SceneBridge_Playing;
                return;
            }
            this.setSceneBridge_Playing(p_LiveShowSceneBridge);
            this.m_SceneBridge_Reached = this.m_SceneBridge_Playing;
            this.m_LiveShowTimer.refreshTimesLiveShowVIP(o_LiveShowVIP, this, this.m_SceneBridge_Playing);
        }

        public void setSceneBridge_Playing(LiveShowSceneBridge p_LiveShowSceneBridge) {
            LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
            if (o_LiveShowVIP == null) {
                return;
            }
            if (this.m_SceneBridge_Playing == p_LiveShowSceneBridge) {
                return;
            }
            this.m_LiveShowTimerSignal.stop();
            LiveShowSceneBridge o_SceneBridge_Playing_Old = this.m_SceneBridge_Playing;
            this.m_SceneBridge_Playing = p_LiveShowSceneBridge;
            this.calculateSceneBridge_Frames_StartEnd();
            this.m_SystemFramesStart = this.getSystemTimeFrames();
            if (this.m_SceneBridge_Playing != null) {
                this.m_SystemFramesStart -= o_LiveShowVIP.getPlay().getPlayCursor() - this.m_SceneBridge_Playing.getFrameStart();
            }
            this.m_LiveShowTimer.refreshTimesLiveShowVIP(o_LiveShowVIP, this, o_SceneBridge_Playing_Old);
        }

        public void calculateSceneBridge_Frames_StartEnd() {
            LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
            if (o_LiveShowVIP == null) {
                return;
            }
            LiveShowSceneBridge o_LiveShowSceneBridge = this.m_SceneBridge_Playing;
            if (o_LiveShowSceneBridge != null) {
                this.m_SceneBridge_Playing_FrameStart = o_LiveShowSceneBridge.getFrameStart();
                this.m_SceneBridge_Playing_FrameEnd = this.m_SceneBridge_Playing_FrameStart + this.m_SceneBridge_Playing.getFramesToNextSceneBridge();
            } else {
                o_LiveShowSceneBridge = o_LiveShowVIP.getLiveShowSceneBridge(0);
                this.m_SceneBridge_Playing_FrameStart = 0L;
                this.m_SceneBridge_Playing_FrameEnd = o_LiveShowSceneBridge != null ? o_LiveShowSceneBridge.getFrameStart() : o_LiveShowVIP.getFrameEndToPlay();
            }
        }

        public LiveShowSceneBridge getLiveShowSceneBridge_Playing() {
            return this.m_SceneBridge_Playing;
        }

        public LiveShowSceneBridge getLiveShowSceneBridge_Reached() {
            return this.m_SceneBridge_Reached;
        }

        public void eventPlayCursorSet(long p_PlayCursor) {
        }

        public void eventPlayCursor(Play p_Play, long p_OldPlayCursor, long p_PlayCursor) {
            LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
            if (o_LiveShowVIP == null) {
                return;
            }
            if (p_PlayCursor < this.m_SceneBridge_Playing_FrameEnd && p_PlayCursor >= this.m_SceneBridge_Playing_FrameStart) {
                this.m_LiveShowTimer.refreshTimesLiveShowVIP(o_LiveShowVIP, this, this.m_SceneBridge_Playing);
            }
        }

        public void setTimeStringNextAction(long p_FramesRest, String p_String) {
            this.m_FramesRestNextAction = p_FramesRest;
            this.m_TimeStringRestAction = p_String;
        }

        public String getTimeStringNextAction() {
            return this.m_TimeStringRestAction;
        }

        public long getFramesRestNextAction() {
            return this.m_FramesRestNextAction;
        }

        public long getTimeLineFrames(LiveShowSceneBridge p_LiveShowSceneBridge) {
            LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
            if (o_LiveShowVIP == null) {
                return 0L;
            }
            if (p_LiveShowSceneBridge != null) {
                return p_LiveShowSceneBridge.getFramesToNextSceneBridge();
            }
            LiveShowSceneBridge o_LiveShowSceneBridge = o_LiveShowVIP.getLiveShowSceneBridge(0);
            if (o_LiveShowSceneBridge == null) {
                return o_LiveShowVIP.getFrameEnd();
            }
            return o_LiveShowSceneBridge.getFrameStart();
        }

        public long getTimelineFramesRest(LiveShowSceneBridge p_LiveShowSceneBridge) {
            if (this.m_SceneBridge_Playing == p_LiveShowSceneBridge) {
                LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
                if (o_LiveShowVIP == null) {
                    return 0L;
                }
                Play o_Play = o_LiveShowVIP.getPlay();
                if (o_Play == null) {
                    return 0L;
                }
                long longPlayCursor = o_Play.getPlayCursor();
                long longTimelineFrames = this.getTimeLineFrames(p_LiveShowSceneBridge);
                if (p_LiveShowSceneBridge == null) {
                    return longTimelineFrames - longPlayCursor;
                }
                return longTimelineFrames - (longPlayCursor - p_LiveShowSceneBridge.getFrameStart());
            }
            return this.getTimeLineFrames(p_LiveShowSceneBridge);
        }

        public boolean getHasRecordedFrames(LiveShowSceneBridge p_LiveShowSceneBridge) {
            if (p_LiveShowSceneBridge == null) {
                return false;
            }
            return p_LiveShowSceneBridge.getFramesRecordedNextSceneBridge() > 0L;
        }

        public long getRecordedFrames(LiveShowSceneBridge p_LiveShowSceneBridge) {
            if (p_LiveShowSceneBridge == null) {
                return -1L;
            }
            return p_LiveShowSceneBridge.getFramesRecordedNextSceneBridge();
        }

        public long getRecordedFramesRest(LiveShowSceneBridge p_LiveShowSceneBridge) {
            long longFramesRest;
            LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
            if (o_LiveShowVIP == null) {
                return -1L;
            }
            if (p_LiveShowSceneBridge == null) {
                longFramesRest = -1L;
            } else if (!this.getHasRecordedFrames(p_LiveShowSceneBridge)) {
                longFramesRest = -1L;
            } else if (this.m_SceneBridge_Playing == p_LiveShowSceneBridge) {
                long longFramesTimer = this.m_LiveShowVIP.getPlay().getPlayCursor() - p_LiveShowSceneBridge.getFrameStart();
                if (this.m_LiveShowTimerSignal.isRunning()) {
                    longFramesTimer += this.getFramesFromMilliseconds(this.m_LiveShowTimerSignal.getDurationMilliseconds());
                }
                longFramesRest = this.getRecordedFrames(p_LiveShowSceneBridge) - longFramesTimer;
            } else {
                longFramesRest = p_LiveShowSceneBridge.getFramesRecordedNextSceneBridge();
            }
            return longFramesRest;
        }

        public void setRecordOn(boolean p_RecordOn) {
            this.m_RecordOn = p_RecordOn;
        }

        public boolean getRecordOn() {
            return this.m_RecordOn;
        }

        public long getSystemTimeFrames() {
            LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
            if (o_LiveShowVIP == null) {
                return 0L;
            }
            if (o_LiveShowVIP.getFrameTime() <= 0.0) {
                return 0L;
            }
            return (long)(((double)System.nanoTime() / 1000000.0 + 0.5) / o_LiveShowVIP.getFrameTime());
        }

        public long getFramesFromMilliseconds(long p_Milliseconds) {
            if (p_Milliseconds <= 0L) {
                return 0L;
            }
            LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
            if (o_LiveShowVIP == null) {
                return 0L;
            }
            if (o_LiveShowVIP.getFrameTime() <= 0.0) {
                return 0L;
            }
            return (long)((double)p_Milliseconds / o_LiveShowVIP.getFrameTime());
        }

        @Override
        public void eventTimerSignal_FireSignal(LiveShowTimerSignal p_LiveShowTimerSignal, Object Source, long p_Milliseconds) {
            LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
            if (o_LiveShowVIP == null) {
                return;
            }
            this.m_LiveShowTimer.refreshTimesLiveShowVIP(o_LiveShowVIP, this, this.m_SceneBridge_Playing);
            long longRecordFramesRest = this.getRecordedFramesRest(this.m_SceneBridge_Playing);
            if (longRecordFramesRest <= 0L) {
                this.m_LiveShowTimerSignal.stop();
            }
        }

        @Override
        public void eventTimerSignal_Started(LiveShowTimerSignal p_LiveShowTimerSignal) {
        }

        @Override
        public void eventTimerSignal_Stopped(LiveShowTimerSignal p_LiveShowTimerSignal) {
        }
    }

    public static interface LiveShowTimerListener_SceneBridge {
        public void eventSceneBridgeTime(LiveShowTimer var1, LiveShowVIP var2, LiveShowSceneBridge var3, long var4, String var6, boolean var7, Color var8);
    }

    public static interface LiveShowTimerListener {
        public void eventTimeNextAction(LiveShowTimer var1, LiveShowVIP var2, LiveShowSceneBridge var3, long var4, String var6, boolean var7, Color var8);

        public void eventTimeNextOneStopped(LiveShowTimer var1, boolean var2);

        public void eventTimeWarning1(LiveShowTimer var1, boolean var2);

        public void eventTimeWarning2(LiveShowTimer var1, boolean var2);

        public void eventTimeRecordOn(LiveShowTimer var1, boolean var2);

        public void eventShowTimeRecorded(LiveShowTimer var1, boolean var2);
    }

    public static class SceneBridgeTimer {
        private LiveShowVIP m_LiveShowVIP;
        private LiveShowTimer m_LiveShowTimer;
        private LiveShowSceneBridge m_LiveShowSceneBridge;
        private long m_TimeFrames;
        private String m_TimeString;
        private boolean m_RecordedTime;
        private Color m_ColorForeground;
        private Runnable m_RunnableNotifyTimerListeners_SceneBridge;
        private ArrayList<LiveShowTimerListener_SceneBridge> m_LiveShowTimerListeners_SceneBridge;
        private final Object m_SyncListeners = new Object();

        public SceneBridgeTimer(LiveShowTimer p_LiveShowTimer, LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
            this.initMembers();
            this.m_LiveShowTimer = p_LiveShowTimer;
            this.m_LiveShowVIP = p_LiveShowVIP;
            this.m_LiveShowSceneBridge = p_LiveShowSceneBridge;
        }

        private void initMembers() {
            this.m_TimeFrames = 0L;
            this.m_TimeString = "";
            this.m_ColorForeground = s_Color_Normal;
            this.m_RecordedTime = false;
            this.m_LiveShowTimerListeners_SceneBridge = new ArrayList();
            this.m_RunnableNotifyTimerListeners_SceneBridge = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList o_LiveShowTimerListeners;
                    LiveShowTimer o_LiveShowTimer = m_LiveShowTimer;
                    if (o_LiveShowTimer == null) {
                        return;
                    }
                    Object object = m_SyncListeners;
                    synchronized (object) {
                        o_LiveShowTimerListeners = new ArrayList(m_LiveShowTimerListeners_SceneBridge.size());
                        o_LiveShowTimerListeners.addAll(m_LiveShowTimerListeners_SceneBridge);
                    }
                    for (int intListener = 0; intListener < o_LiveShowTimerListeners.size(); ++intListener) {
                        LiveShowTimerListener_SceneBridge o_Listener = (LiveShowTimerListener_SceneBridge)o_LiveShowTimerListeners.get(intListener);
                        o_Listener.eventSceneBridgeTime(o_LiveShowTimer, m_LiveShowVIP, m_LiveShowSceneBridge, m_TimeFrames, m_TimeString, m_RecordedTime, m_ColorForeground);
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncListeners;
            synchronized (object) {
                this.m_LiveShowTimerListeners_SceneBridge.clear();
            }
        }

        public boolean setParams(long p_TimeFrames, String p_TimeString, boolean p_TimeRecorded) {
            boolean boolChanged = false;
            Color o_ColorForeground = s_Color_Normal;
            o_ColorForeground = p_TimeFrames <= s_TimeWarning2_Frames ? s_Color_Warning2 : (p_TimeFrames <= s_TimeWarning1_Frames ? s_Color_Warning1 : (p_TimeRecorded ? s_Color_Recorded : s_Color_Normal));
            this.m_TimeFrames = p_TimeFrames;
            if (!this.m_TimeString.equals(p_TimeString)) {
                this.m_TimeString = p_TimeString;
                boolChanged = true;
            }
            if (!this.m_ColorForeground.equals(o_ColorForeground)) {
                this.m_ColorForeground = o_ColorForeground;
                boolChanged = true;
            }
            if (this.m_RecordedTime != p_TimeRecorded) {
                this.m_RecordedTime = p_TimeRecorded;
                boolChanged = true;
            }
            return boolChanged;
        }

        public void notifyTimerListeners_ScenBridge() {
            EventQueueHandler.invokeLater(this.m_RunnableNotifyTimerListeners_SceneBridge);
        }

        public LiveShowTimer getLiveShowTimer() {
            return this.m_LiveShowTimer;
        }

        public LiveShowVIP getLiveShowVIP() {
            return this.m_LiveShowVIP;
        }

        public LiveShowSceneBridge getLiveShowSceneBridge() {
            return this.m_LiveShowSceneBridge;
        }

        public long getTimeFrames() {
            return this.m_TimeFrames;
        }

        public String getTimeString() {
            return this.m_TimeString;
        }

        public Color getColor() {
            return this.m_ColorForeground;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLiveShowTimerListener_SceneBridge(final LiveShowTimerListener_SceneBridge p_LiveShowTimerListener_SceneBridge) {
            if (p_LiveShowTimerListener_SceneBridge == null) {
                return;
            }
            Object object = this.m_SyncListeners;
            synchronized (object) {
                if (this.m_LiveShowTimerListeners_SceneBridge.contains(p_LiveShowTimerListener_SceneBridge)) {
                    return;
                }
                this.m_LiveShowTimerListeners_SceneBridge.add(p_LiveShowTimerListener_SceneBridge);
            }
            Runnable o_Runnable = new Runnable(){

                @Override
                public void run() {
                    p_LiveShowTimerListener_SceneBridge.eventSceneBridgeTime(m_LiveShowTimer, m_LiveShowVIP, m_LiveShowSceneBridge, m_TimeFrames, m_TimeString, m_RecordedTime, m_ColorForeground);
                }
            };
            EventQueueHandler.invokeLater(o_Runnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLiveShowTimerListener_SceneBridge(LiveShowTimerListener_SceneBridge p_LiveShowTimerListener_SceneBridge) {
            if (p_LiveShowTimerListener_SceneBridge == null) {
                return;
            }
            Object object = this.m_SyncListeners;
            synchronized (object) {
                if (this.m_LiveShowTimerListeners_SceneBridge.contains(p_LiveShowTimerListener_SceneBridge)) {
                    return;
                }
                this.m_LiveShowTimerListeners_SceneBridge.remove(p_LiveShowTimerListener_SceneBridge);
            }
        }
    }
}

