/*
 * Decompiled with CFR 0.152.
 */
package LiveShowVirtualPackage;

import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectListener;
import LiveShowObjectPackage.LiveShowObjectPanel;
import LiveShowObjectPackage.LiveShowUndo;
import LiveShowScrollPackage.LiveShowViewListener;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowVIP;
import LiveShowVirtualPackage.LiveShowVIPPanel;
import SwingComponents.MouseAdapter_Delayed;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import SynchronizationPackage.LiveCloseSemaphore;
import ToolsGraphics.GraphicsTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class LiveShowSceneBridgePanel
extends JPanel
implements ComponentListener,
LiveShowObjectListener,
LiveShowViewListener,
PopUpToolTip.ComponentRightClickToolTip,
MouseAdapter_Delayed.MouseEventDelegate {
    public static final int MOUSEFETCHSIZE = 7;
    public static Font DEFAULTFONT = new Font("Times New Roman", 0, 16);
    private LiveShowVIPPanel m_LiveShowVIPPanel;
    private LiveShowSceneBridge m_LiveShowSceneBridge;
    private Color m_ColorBridgeMain;
    protected Color m_ColorBackgroundNormal;
    protected Color m_ColorBackgroundSelected;
    protected Color m_ColorForeground;
    protected Color m_ColorFill;
    protected Color m_ColorBorder;
    protected Color m_ColorBorderSelected;
    private Color m_ColorFill_Paint;
    private Color m_ColorBridgeMain_Paint;
    private Color m_ColorBackgroundSelected_Paint;
    private Color m_ColorFill_Line;
    private Color m_ColorBridgeMain_Line;
    private Color m_ColorBackgroundSelected_Line;
    protected Border m_Border_Normal;
    protected Border m_Border_Selected;
    private boolean m_IsVisible;
    private long m_ContainerVisibleFrameStart;
    private long m_ContainerVisibleFrameEnd;
    private int m_ContainerViewWidth;
    private int m_ContainerViewHeight;
    private long m_StartFrame;
    private long m_FrameLength;
    private boolean m_RedrawWidth;
    private boolean m_RedrawHeight;
    private boolean m_MouseResizeEast;
    private boolean m_MouseResizeWest;
    private AbsoluteConstraints m_AbsoluteConstraints;
    private boolean m_IsSelected;
    private LabelFade m_LabelFadeIn;
    private LabelFade m_LabelFadeOut;
    private LabelFade m_LabelFadeVolume;
    private LabelFade m_LabelFadeOffset;
    private LabelFade m_LabelFadeLength;
    private LabelFade m_LabelResizeWest;
    private LabelFade m_LabelResizeEast;
    private int[] m_FadePolygonX;
    private int[] m_FadePolygonY;
    private LabelFade m_LabelActive;
    private LabelFade m_LabelStopAtStart;
    private LabelFade m_LabelJumpSceneBridge;
    private int m_OldMousePositionX;
    private long m_MouseFramePositionInside;
    private LiveCloseSemaphore m_LiveCloseSemaphore;
    private final Object m_SyncPainting = new Object();
    private Dimension m_OldSize;
    private MouseAdapter_Delayed m_MouseAdapter_Delayed;
    private Rectangle m_ExternalMouseBounds;
    private boolean m_ExternalMouseWasInside;
    private Runnable m_RunnableRepaint;
    protected String m_ToolTipText_RightClick;

    public LiveShowSceneBridgePanel(LiveShowVIPPanel p_LiveShowVIPPanel, LiveShowSceneBridge p_LiveShowSceneBridge) {
        this.initMembers();
        this.m_LiveShowVIPPanel = p_LiveShowVIPPanel;
        this.m_LiveShowSceneBridge = p_LiveShowSceneBridge;
        this.m_LiveShowSceneBridge.addLiveShowObjectListener(this);
        this.initComponents();
        this.m_StartFrame = p_LiveShowSceneBridge.getFrameStart();
        this.m_FrameLength = p_LiveShowSceneBridge.getFrameLength();
    }

    private void initMembers() {
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_RunnableRepaint = new Runnable(){

            @Override
            public void run() {
                LiveShowSceneBridgePanel.this.revalidate();
                LiveShowSceneBridgePanel.this.repaint();
            }
        };
        this.m_OldSize = new Dimension(0, 0);
        this.m_ContainerVisibleFrameStart = 0L;
        this.m_ContainerVisibleFrameEnd = 0L;
        this.m_ContainerViewWidth = 0;
        this.m_ContainerViewHeight = 0;
        this.m_StartFrame = 0L;
        this.m_FrameLength = 0L;
        this.m_RedrawWidth = false;
        this.m_RedrawHeight = false;
        this.m_IsVisible = false;
        this.m_IsSelected = false;
        this.m_ColorFill = new Color(200, 200, 200);
        this.m_ColorFill_Paint = GraphicsTools.newColorSave(this.m_ColorFill.getRed(), this.m_ColorFill.getGreen(), this.m_ColorFill.getBlue(), 90);
        this.m_ColorFill_Line = GraphicsTools.newColorSave(this.m_ColorFill.getRed(), this.m_ColorFill.getGreen(), this.m_ColorFill.getBlue());
        this.m_ColorBridgeMain = new Color(200, 50, 50);
        this.m_ColorBridgeMain_Paint = GraphicsTools.newColorSave(this.m_ColorBridgeMain.getRed(), this.m_ColorBridgeMain.getGreen(), this.m_ColorBridgeMain.getBlue(), 90);
        this.m_ColorBridgeMain_Line = GraphicsTools.newColorSave(this.m_ColorBridgeMain.getRed(), this.m_ColorBridgeMain.getGreen(), this.m_ColorBridgeMain.getBlue());
        this.m_ColorBackgroundSelected = new Color(0, 0, 255);
        this.m_ColorBackgroundSelected_Paint = GraphicsTools.newColorSave(this.m_ColorBackgroundSelected.getRed(), this.m_ColorBackgroundSelected.getGreen(), this.m_ColorBackgroundSelected.getBlue(), 50);
        this.m_ColorBackgroundSelected_Line = GraphicsTools.newColorSave(this.m_ColorBackgroundSelected.getRed(), this.m_ColorBackgroundSelected.getGreen(), this.m_ColorBackgroundSelected.getBlue());
        this.m_ColorBorder = new Color(255, 255, 0);
        this.m_ColorBorderSelected = new Color(0, 0, 255);
        this.m_ColorForeground = new Color(255, 255, 255);
        this.m_FadePolygonX = new int[4];
        this.m_FadePolygonY = new int[4];
        this.m_MouseResizeWest = false;
        this.m_MouseResizeEast = false;
        this.m_OldMousePositionX = 0;
    }

    private void initComponents() {
        this.createMouseAdapter_Delayed();
        this.setMinimumSize(new Dimension(3, 3));
        this.setLayout(new AbsoluteLayout());
        this.setDoubleBuffered(false);
        this.setOpaque(false);
        this.m_AbsoluteConstraints = new AbsoluteConstraints(0, 0, 0, 0);
        this.m_Border_Normal = new LineBorder(this.m_ColorBorder, 1);
        this.m_Border_Selected = new LineBorder(this.m_ColorBorderSelected, 1);
        this.m_LabelResizeWest = new LabelFade(this, 4);
        this.add((Component)this.m_LabelResizeWest, this.m_LabelResizeWest.getAbsoluteConstraints());
        this.m_LabelResizeEast = new LabelFade(this, 5);
        this.add((Component)this.m_LabelResizeEast, this.m_LabelResizeEast.getAbsoluteConstraints());
        this.m_LabelFadeIn = new LabelFade(this, 1);
        this.add(this.m_LabelFadeIn, this.m_LabelFadeIn.getAbsoluteConstraints(), 0);
        this.m_LabelFadeOut = new LabelFade(this, 2);
        this.add(this.m_LabelFadeOut, this.m_LabelFadeOut.getAbsoluteConstraints(), 0);
        this.m_LabelFadeVolume = new LabelFade(this, 3);
        this.add(this.m_LabelFadeVolume, this.m_LabelFadeVolume.getAbsoluteConstraints(), 0);
        this.m_LabelFadeOffset = new LabelFade(this, 6);
        this.add(this.m_LabelFadeOffset, this.m_LabelFadeOffset.getAbsoluteConstraints(), 0);
        this.m_LabelFadeLength = new LabelFade(this, 7);
        this.add(this.m_LabelFadeLength, this.m_LabelFadeLength.getAbsoluteConstraints(), 0);
        this.m_LabelJumpSceneBridge = new LabelFade(this, 10);
        this.add(this.m_LabelJumpSceneBridge, this.m_LabelJumpSceneBridge.getAbsoluteConstraints(), 0);
        this.m_LabelActive = new LabelFade(this, 9);
        this.add(this.m_LabelActive, this.m_LabelActive.getAbsoluteConstraints(), 0);
        this.m_LabelStopAtStart = new LabelFade(this, 8);
        this.add(this.m_LabelStopAtStart, this.m_LabelStopAtStart.getAbsoluteConstraints(), 0);
        this.addMouseListener(this.m_MouseAdapter_Delayed);
        this.addMouseMotionListener(this.m_MouseAdapter_Delayed);
        this.addComponentListener(this);
        this.createToolTipText();
        this.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        if (this.m_LiveShowSceneBridge != null) {
            this.m_IsSelected = this.m_LiveShowSceneBridge.getSelected();
        }
        this.resetBorder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        this.setComponentPopupMenu(null);
        Object object = this.m_SyncPainting;
        synchronized (object) {
            if (this.m_LiveShowSceneBridge != null) {
                this.m_LiveShowSceneBridge.removeLiveShowObjectListener(this);
                this.m_LiveShowSceneBridge = null;
            }
        }
        this.m_LiveCloseSemaphore.leaveCloseSection();
    }

    public void createToolTipText() {
        LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSceneBridge;
        if (o_LiveShowSceneBridge == null) {
            this.m_ToolTipText_RightClick = null;
            return;
        }
        StringBuilder o_StringBuffer = new StringBuilder();
        o_StringBuffer.append("<html>");
        o_StringBuffer.append("<center><b>");
        o_StringBuffer.append(o_LiveShowSceneBridge.getName());
        o_StringBuffer.append("<br>");
        o_StringBuffer.append("</b></center>");
        LiveShowSceneBridge o_JumpSceneBridge = o_LiveShowSceneBridge.getJumpSceneBridge();
        if (o_JumpSceneBridge != null && o_LiveShowSceneBridge.getJumpActive()) {
            o_StringBuffer.append("<center>");
            o_StringBuffer.append(LiveShowObjectDescription.DescriptionStrings.s_Jump);
            o_StringBuffer.append(": ");
            o_StringBuffer.append(o_JumpSceneBridge.getName());
            o_StringBuffer.append("<br>");
            o_StringBuffer.append("</center>");
        }
        o_StringBuffer.append("<table align=center>");
        if (o_LiveShowSceneBridge.getFramesRecordedNextSceneBridge() > 0L) {
            o_StringBuffer.append("<tr>");
            o_StringBuffer.append("<td align=right>");
            o_StringBuffer.append(LiveShowObjectDescription.DescriptionStrings.s_TimeRecordedToNext);
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("<td align=right>");
            o_StringBuffer.append(o_LiveShowSceneBridge.getTimeStringFromFrames(o_LiveShowSceneBridge.getFramesRecordedNextSceneBridge()));
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("</tr>");
        }
        o_StringBuffer.append("<tr>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append(LiveShowObjectDescription.DescriptionStrings.s_Length);
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append(o_LiveShowSceneBridge.getTimeStringFromFrames(o_LiveShowSceneBridge.getFrameLength()));
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("</tr>");
        o_StringBuffer.append("<tr>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append(LiveShowObjectDescription.DescriptionStrings.s_FadeIn);
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append(o_LiveShowSceneBridge.getTimeStringFromFrames(o_LiveShowSceneBridge.getFrameFadeInLength()));
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append(LiveShowObjectDescription.DescriptionStrings.s_FadeInOffset);
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append(o_LiveShowSceneBridge.getTimeStringFromFrames(o_LiveShowSceneBridge.getFrameFadeInOffset()));
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("</tr>");
        o_StringBuffer.append("<tr>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append(LiveShowObjectDescription.DescriptionStrings.s_FadeOut);
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append(o_LiveShowSceneBridge.getTimeStringFromFrames(o_LiveShowSceneBridge.getFrameFadeOutLength()));
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append(LiveShowObjectDescription.DescriptionStrings.s_FadeOutOffset);
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append(o_LiveShowSceneBridge.getTimeStringFromFrames(o_LiveShowSceneBridge.getFrameFadeOutOffset()));
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("</tr>");
        o_StringBuffer.append("<table>");
        o_StringBuffer.append("</html>");
        this.m_ToolTipText_RightClick = o_StringBuffer.toString();
    }

    public String getToolTipText_RightClick() {
        return this.m_ToolTipText_RightClick;
    }

    public LiveShowSceneBridge getLiveShowSceneBridge() {
        return this.m_LiveShowSceneBridge;
    }

    public AbsoluteConstraints getAbsoluteConstraints() {
        return this.m_AbsoluteConstraints;
    }

    public boolean externalMouseSelect(int p_LastX, int p_LastY, int p_X, int p_Y) {
        this.m_ExternalMouseBounds = this.getBounds(this.m_ExternalMouseBounds);
        if (!(p_LastX <= this.m_AbsoluteConstraints.x && p_X <= this.m_AbsoluteConstraints.x || p_LastX >= this.m_AbsoluteConstraints.x + this.m_ExternalMouseBounds.width && p_X >= this.m_AbsoluteConstraints.x + this.m_ExternalMouseBounds.width || p_LastY <= this.m_AbsoluteConstraints.y && p_Y <= this.m_AbsoluteConstraints.y || p_LastY >= this.m_AbsoluteConstraints.y + this.m_ExternalMouseBounds.height && p_Y >= this.m_AbsoluteConstraints.y + this.m_ExternalMouseBounds.height)) {
            if (this.m_ExternalMouseWasInside) {
                return false;
            }
            this.m_ExternalMouseWasInside = true;
            return true;
        }
        this.m_ExternalMouseWasInside = false;
        return false;
    }

    public void externalMouseReleased(int p_X, int p_Y) {
        this.m_ExternalMouseWasInside = false;
    }

    @Override
    public Color getBackground() {
        if (this.m_IsSelected) {
            return this.m_ColorBackgroundSelected;
        }
        return this.m_ColorBackgroundNormal;
    }

    public void setColorBackgroundNormal(Color p_Color) {
        this.m_ColorBackgroundNormal = p_Color;
        if (!this.m_IsSelected) {
            super.setBackground(this.m_ColorBackgroundNormal);
            this.repaint();
        }
    }

    public Color getColorBackgroundNormal() {
        return this.m_ColorBackgroundNormal;
    }

    public void setColorBackgroundSelected(Color p_Color) {
        this.m_ColorBackgroundSelected = p_Color;
        this.m_ColorBackgroundSelected_Paint = GraphicsTools.newColorSave(this.m_ColorBackgroundSelected.getRed(), this.m_ColorBackgroundSelected.getGreen(), this.m_ColorBackgroundSelected.getBlue(), 50);
        this.m_ColorBackgroundSelected_Line = GraphicsTools.newColorSave(this.m_ColorBackgroundSelected.getRed(), this.m_ColorBackgroundSelected.getGreen(), this.m_ColorBackgroundSelected.getBlue());
        if (this.m_IsSelected) {
            super.setBackground(this.m_ColorBackgroundSelected);
            this.repaint();
        }
    }

    public Color getColorBackgroundSelected() {
        return this.m_ColorBackgroundSelected;
    }

    public void setColorForegroud(Color p_Color) {
        if (p_Color == null) {
            return;
        }
        if (this.m_ColorForeground.equals(p_Color)) {
            return;
        }
        this.m_ColorForeground = p_Color;
        super.setForeground(this.m_ColorForeground);
        this.repaint();
    }

    public Color getColorForeground() {
        return this.m_ColorForeground;
    }

    public void setColorFill(Color p_Color) {
        if (this.m_ColorFill.equals(p_Color)) {
            return;
        }
        this.m_ColorFill = p_Color;
        this.m_ColorFill_Paint = GraphicsTools.newColorSave(this.m_ColorFill.getRed(), this.m_ColorFill.getGreen(), this.m_ColorFill.getBlue(), 90);
        this.m_ColorFill_Line = GraphicsTools.newColorSave(this.m_ColorFill.getRed(), this.m_ColorFill.getGreen(), this.m_ColorFill.getBlue());
        this.repaint();
    }

    public Color getColorFill() {
        return this.m_ColorFill;
    }

    public void setColorBorder(Color p_Color) {
        if (this.m_ColorBorder.equals(p_Color)) {
            return;
        }
        this.m_ColorBorder = p_Color;
        this.m_Border_Normal = new LineBorder(this.m_ColorBorder, 1);
        this.resetBorder();
    }

    public Color getColorBorder() {
        return this.m_ColorBorder;
    }

    public void setColorBridgeMain(Color p_Color) {
        if (this.m_ColorBridgeMain.equals(p_Color)) {
            return;
        }
        this.m_ColorBridgeMain = p_Color;
        this.m_ColorBridgeMain_Paint = GraphicsTools.newColorSave(this.m_ColorBridgeMain.getRed(), this.m_ColorBridgeMain.getGreen(), this.m_ColorBridgeMain.getBlue(), 90);
        this.m_ColorBridgeMain_Line = GraphicsTools.newColorSave(this.m_ColorBridgeMain.getRed(), this.m_ColorBridgeMain.getGreen(), this.m_ColorBridgeMain.getBlue());
        this.repaint();
    }

    public Color getColorBridgeMain() {
        return this.m_ColorBridgeMain;
    }

    public AbsoluteConstraints getConstraints() {
        return this.m_AbsoluteConstraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculatePaint(long p_ViewVisibleFrameStart, long p_ViewVisibleFrameEnd, int p_ViewWidth, int p_ViewHeigth) {
        LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSceneBridge;
        if (o_LiveShowSceneBridge == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncPainting;
        synchronized (object) {
            if (this.m_ContainerVisibleFrameStart != p_ViewVisibleFrameStart) {
                this.m_RedrawWidth = true;
                this.m_ContainerVisibleFrameStart = p_ViewVisibleFrameStart;
            }
            if (this.m_ContainerVisibleFrameEnd != p_ViewVisibleFrameEnd) {
                this.m_RedrawWidth = true;
                this.m_ContainerVisibleFrameEnd = p_ViewVisibleFrameEnd;
            }
            if (this.m_ContainerViewWidth != p_ViewWidth) {
                this.m_RedrawWidth = true;
                this.m_ContainerViewWidth = p_ViewWidth;
            }
            if (this.m_ContainerViewHeight != p_ViewHeigth) {
                this.m_RedrawHeight = true;
                this.m_ContainerViewHeight = p_ViewHeigth;
            }
            if (this.m_ContainerViewWidth < 1 || this.m_ContainerViewHeight < 1) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return;
            }
            if (this.m_ContainerVisibleFrameEnd == this.m_ContainerVisibleFrameStart) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return;
            }
            double doubleFramesPerPoint = (double)(this.m_ContainerVisibleFrameEnd - this.m_ContainerVisibleFrameStart) / (double)this.m_ContainerViewWidth;
            if (this.m_RedrawHeight) {
                this.m_AbsoluteConstraints.height = this.m_ContainerViewHeight;
                this.m_AbsoluteConstraints.y = 0;
            }
            this.m_AbsoluteConstraints.width = (int)((double)o_LiveShowSceneBridge.getFrameLength() / doubleFramesPerPoint);
            if (this.m_AbsoluteConstraints.width < 3) {
                this.m_AbsoluteConstraints.width = 3;
            }
            this.m_AbsoluteConstraints.x = (int)((double)(o_LiveShowSceneBridge.getFrameStart() - this.m_ContainerVisibleFrameStart) / doubleFramesPerPoint);
            this.m_IsVisible = true;
            if (this.m_AbsoluteConstraints.x + this.m_AbsoluteConstraints.width < 0) {
                this.m_IsVisible = false;
            }
            if (this.m_AbsoluteConstraints.x > this.m_ContainerViewWidth) {
                this.m_IsVisible = false;
            }
            if (this.m_RedrawHeight || this.m_RedrawWidth) {
                // empty if block
            }
            this.m_LabelFadeIn.calculatePosition();
            this.m_LabelFadeOut.calculatePosition();
            this.m_LabelFadeVolume.calculatePosition();
            this.m_LabelFadeOffset.calculatePosition();
            this.m_LabelFadeLength.calculatePosition();
            this.m_LabelResizeWest.calculatePosition();
            this.m_LabelResizeEast.calculatePosition();
            this.m_LabelJumpSceneBridge.calculatePosition();
            this.m_LabelStopAtStart.calculatePosition();
            this.m_LabelActive.calculatePosition();
            if (!SwingUtilities.isEventDispatchThread()) {
                EventQueueHandler.invokeLater(this.m_RunnableRepaint);
            } else {
                this.revalidate();
                this.repaint();
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    private int getInsidePositionX(long p_Frame) {
        LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSceneBridge;
        if (o_LiveShowSceneBridge == null) {
            return 0;
        }
        int intWidth = this.m_AbsoluteConstraints.width;
        if (intWidth == 0) {
            return 0;
        }
        double doubleFramesPerPoint = (double)o_LiveShowSceneBridge.getFrameLength() / (double)intWidth;
        int intX = (int)((double)p_Frame / doubleFramesPerPoint);
        return intX;
    }

    private long getPositionFrame(int p_X) {
        LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSceneBridge;
        if (o_LiveShowSceneBridge == null) {
            return 0L;
        }
        int intWidth = this.m_AbsoluteConstraints.width;
        if (intWidth == 0) {
            return 0L;
        }
        double doubleFramesPerPoint = (double)o_LiveShowSceneBridge.getFrameLength() / (double)intWidth;
        long longFrame = (long)((double)p_X * doubleFramesPerPoint);
        return longFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics p_Graphics) {
        if (p_Graphics == null) {
            return;
        }
        super.paintComponent(p_Graphics);
        LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSceneBridge;
        if (o_LiveShowSceneBridge == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        Object object = this.m_SyncPainting;
        synchronized (object) {
            Color o_ColorLine;
            Color o_ColorFill;
            if (!this.m_IsVisible) {
                return;
            }
            if (this.m_AbsoluteConstraints.height <= 2 || this.m_AbsoluteConstraints.width <= 2) {
                super.paintBorder(p_Graphics);
                return;
            }
            Graphics2D g2d = (Graphics2D)p_Graphics;
            if (!this.m_IsSelected) {
                if (o_LiveShowSceneBridge.getIsMainBridge()) {
                    o_ColorFill = this.m_ColorBridgeMain_Paint;
                    o_ColorLine = this.m_ColorBridgeMain_Line;
                } else {
                    o_ColorFill = this.m_ColorFill_Paint;
                    o_ColorLine = this.m_ColorFill_Line;
                }
            } else {
                o_ColorFill = this.m_ColorBackgroundSelected_Paint;
                o_ColorLine = this.m_ColorBackgroundSelected_Line;
            }
            g2d.setColor(o_ColorFill);
            g2d.fillRect(0, 0, this.m_AbsoluteConstraints.width, this.m_AbsoluteConstraints.height);
            int intY = (int)((float)this.m_AbsoluteConstraints.height - (float)(this.m_AbsoluteConstraints.height / 2) * o_LiveShowSceneBridge.getVolumeFactor());
            int intFadeInX = this.getInsidePositionX(o_LiveShowSceneBridge.getFrameLength() - o_LiveShowSceneBridge.getFrameFadeInLength());
            int intFadeInOffsetX = this.getInsidePositionX(o_LiveShowSceneBridge.getFrameLength() - o_LiveShowSceneBridge.getFrameFadeInOffset());
            int intFadeOutX = this.getInsidePositionX(o_LiveShowSceneBridge.getFrameFadeOutLength());
            int intFadeOutOffsetX = this.getInsidePositionX(o_LiveShowSceneBridge.getFrameFadeOutOffset());
            this.m_FadePolygonX[0] = intFadeInX;
            this.m_FadePolygonY[0] = this.m_AbsoluteConstraints.height;
            this.m_FadePolygonX[1] = intFadeInOffsetX;
            this.m_FadePolygonY[1] = intY;
            this.m_FadePolygonX[2] = this.m_AbsoluteConstraints.width;
            this.m_FadePolygonY[2] = intY;
            this.m_FadePolygonX[3] = this.m_AbsoluteConstraints.width;
            this.m_FadePolygonY[3] = this.m_AbsoluteConstraints.height;
            g2d.fillPolygon(this.m_FadePolygonX, this.m_FadePolygonY, 4);
            g2d.setColor(o_ColorLine);
            g2d.drawPolygon(this.m_FadePolygonX, this.m_FadePolygonY, 4);
            g2d.setColor(o_ColorFill);
            this.m_FadePolygonX[0] = 0;
            this.m_FadePolygonY[0] = intY;
            this.m_FadePolygonX[1] = intFadeOutOffsetX;
            this.m_FadePolygonY[1] = intY;
            this.m_FadePolygonX[2] = intFadeOutX;
            this.m_FadePolygonY[2] = this.m_AbsoluteConstraints.height;
            this.m_FadePolygonX[3] = 0;
            this.m_FadePolygonY[3] = this.m_AbsoluteConstraints.height;
            g2d.fillPolygon(this.m_FadePolygonX, this.m_FadePolygonY, 4);
            g2d.setColor(o_ColorLine);
            g2d.drawPolygon(this.m_FadePolygonX, this.m_FadePolygonY, 4);
            g2d.setColor(this.m_ColorForeground);
            String stringName = o_LiveShowSceneBridge.getName();
            if (stringName == null) {
                stringName = "";
            }
            if (stringName.length() > 0) {
                g2d.setFont(DEFAULTFONT);
                Rectangle2D o_RectangleString = g2d.getFontMetrics().getStringBounds(stringName, g2d);
                g2d.drawString(stringName, (float)(((double)this.m_AbsoluteConstraints.getWidth() - o_RectangleString.getWidth()) / 2.0), (float)(((double)this.m_AbsoluteConstraints.getHeight() - o_RectangleString.getHeight()) / 2.0));
            }
            if (!o_LiveShowSceneBridge.isEqualDefaultSettings()) {
                Stroke o_StrokeOld = g2d.getStroke();
                g2d.setStroke(LiveShowObjectDescription.s_BasicStroke_NotDefault);
                g2d.setColor(LiveShowObjectDescription.s_ColorNotDefault);
                int intWidth = this.m_AbsoluteConstraints.getWidth();
                int intHeight = this.m_AbsoluteConstraints.getHeight();
                g2d.drawRect(2, 2, intWidth - 4, intHeight - 4);
                g2d.setStroke(o_StrokeOld);
            }
            if (o_LiveShowSceneBridge.getOverlap()) {
                g2d.setColor(LiveShowObjectDescription.s_ColorOverlap);
                g2d.drawLine(0, 0, this.m_AbsoluteConstraints.getWidth(), this.m_AbsoluteConstraints.getHeight());
                g2d.drawLine(this.m_AbsoluteConstraints.getWidth(), 0, 0, this.m_AbsoluteConstraints.getHeight());
            }
        }
        super.paintBorder(p_Graphics);
    }

    @Override
    public void eventViewChanged(long p_FrameStart, long p_FrameEnd, long p_VisibleFrameStart, long p_VisibleFrameEnd, Rectangle p_Bounds) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.calculatePaint(p_VisibleFrameStart, p_VisibleFrameEnd, p_Bounds.width, p_Bounds.height);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void eventViewScrollAutomaticStart() {
    }

    @Override
    public void eventZoomPlus(boolean p_AdjustFramePosition, long p_FramePosition) {
    }

    @Override
    public void eventZoomMinus(boolean p_AdjustFramePosition, long p_FramePosition) {
    }

    @Override
    public void eventZoomReset() {
    }

    protected void setSelected(boolean p_Selected) {
        if (this.m_IsSelected == p_Selected) {
            return;
        }
        this.m_IsSelected = p_Selected;
        if (this.m_IsSelected) {
            this.m_LabelFadeVolume.setToolTipText(LiveShowObject.TOOLTIP_VOLUME_SELECTEDOBJECT);
        } else {
            this.m_LabelFadeVolume.setToolTipText(LiveShowObject.TOOLTIP_VOLUME);
        }
        this.resetBorder();
    }

    public boolean getSelected() {
        return this.m_LiveShowSceneBridge.getSelected();
    }

    public void resetBorder() {
        LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSceneBridge;
        if (o_LiveShowSceneBridge != null) {
            if (o_LiveShowSceneBridge.getOverlap()) {
                super.setBorder(LiveShowObjectDescription.s_OverlapBorder);
            } else if (!this.m_IsSelected) {
                this.setBorder(this.m_Border_Normal);
            } else {
                this.setBorder(this.m_Border_Selected);
            }
        } else {
            super.setBorder(null);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.getWidth() == this.m_OldSize.width && this.getHeight() == this.m_OldSize.height) {
            return;
        }
        this.m_OldSize.setSize(this.getWidth(), this.getHeight());
        this.revalidate();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void eventObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowObjectInterface != this.m_LiveShowSceneBridge) {
            return;
        }
        if (p_LiveShowObjectDescription == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (this.m_StartFrame != p_LiveShowObjectDescription.getFrameStart()) {
            this.m_RedrawWidth = true;
        }
        if (this.m_FrameLength != p_LiveShowObjectDescription.getFrameLength()) {
            this.m_RedrawWidth = true;
        }
        this.calculatePaint(this.m_ContainerVisibleFrameStart, this.m_ContainerVisibleFrameEnd, this.m_ContainerViewWidth, this.m_ContainerViewHeight);
        this.resetBorder();
        this.createToolTipText();
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void eventObjectVolumeChanged(LiveShowObjectInterface p_LiveShowObjectInterface, float p_Volume) {
    }

    @Override
    public void eventObjectAdditionalChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (!SwingUtilities.isEventDispatchThread()) {
            System.out.println(this.getClass().getName() + "eventObjectAdditionalChanged");
        }
        this.repaint();
    }

    @Override
    public void eventObjectClosed(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface != this.m_LiveShowSceneBridge) {
            return;
        }
    }

    @Override
    public void eventObjectSelection(LiveShowObjectInterface p_LiveShowObjectInterface, boolean p_IsSelected, boolean p_Added) {
        if (p_LiveShowObjectInterface != this.m_LiveShowSceneBridge) {
            return;
        }
        this.setSelected(p_IsSelected);
    }

    @Override
    public Component getMouseEventDelegate_ComponentDest(MouseEvent p_MouseEvent) {
        Component o_Component = null;
        LiveShowObjectPanel o_LiveShowObjectPanel = this.m_LiveShowVIPPanel.getLiveShowObjectPanel(p_MouseEvent.getXOnScreen(), p_MouseEvent.getYOnScreen());
        if (o_LiveShowObjectPanel != null) {
            Point o_Point = new Point(p_MouseEvent.getXOnScreen(), p_MouseEvent.getYOnScreen());
            SwingUtilities.convertPointFromScreen(o_Point, o_LiveShowObjectPanel);
            o_Component = o_LiveShowObjectPanel.getComponentFrom_MousePosition(o_Point);
            if (o_Component != null) {
                o_Point.setLocation(p_MouseEvent.getXOnScreen(), p_MouseEvent.getYOnScreen());
                SwingUtilities.convertPointFromScreen(o_Point, o_Component);
                if (o_Component instanceof LiveShowObjectPanel) {
                    this.setCursor(o_LiveShowObjectPanel.getCursor(o_Point.x, o_Point.y));
                } else {
                    this.setCursor(o_Component.getCursor());
                }
            }
        }
        return o_Component;
    }

    @Override
    public boolean getMouseEventDelegate_IsActive(MouseEvent p_MouseEvent) {
        return p_MouseEvent.isAltDown() && !p_MouseEvent.isAltGraphDown() && !p_MouseEvent.isControlDown() && !p_MouseEvent.isMetaDown() && !p_MouseEvent.isShiftDown();
    }

    public void createMouseAdapter_Delayed() {
        this.m_MouseAdapter_Delayed = new MouseAdapter_Delayed(){

            @Override
            public void mouseClicked_Delayed(MouseEvent e) {
                if (LiveShowSceneBridgePanel.this.getMouseEventDelegate_IsActive(e)) {
                    return;
                }
                LiveShowSceneBridge o_LiveShowSceneBridge = LiveShowSceneBridgePanel.this.m_LiveShowSceneBridge;
                if (o_LiveShowSceneBridge == null) {
                    return;
                }
                int intX = e.getX();
                int intY = e.getY();
                intX += e.getComponent().getX();
                LiveShowVIP o_LiveShowVIP = o_LiveShowSceneBridge.getLiveShowVIP();
                if (o_LiveShowVIP == null) {
                    return;
                }
                if (e.getClickCount() > 1) {
                    o_LiveShowVIP.notifyLiveShowVIPListeners_ShowObjectSettings(o_LiveShowSceneBridge);
                }
                long longFramePosition = LiveShowSceneBridgePanel.this.m_LiveShowVIPPanel.getPositionFrame(intX);
                switch (o_LiveShowVIP.getMouseCursorMode(intX, intY, e.getComponent())) {
                    case 1: {
                        if (e.isAltDown() && (e.isShiftDown() || e.isControlDown())) {
                            if (!o_LiveShowSceneBridge.getSelected()) {
                                o_LiveShowVIP.selectObjectsFromPosition(o_LiveShowSceneBridge.getFrameStart(), true);
                                break;
                            }
                            o_LiveShowVIP.removeObjectsFromPositionToSelection(o_LiveShowSceneBridge.getFrameStart(), true);
                            break;
                        }
                        if (e.isAltDown() || e.isShiftDown() || e.isControlDown()) break;
                        if (LiveShowSceneBridgePanel.this.m_LiveShowVIPPanel.getLiveShowVIP().getPlay().getEditModeOn()) {
                            LiveShowSceneBridgePanel.this.m_LiveShowVIPPanel.getLiveShowVIP().getPlay().setEditCursor(longFramePosition);
                            break;
                        }
                        if (!o_LiveShowSceneBridge.getActive()) break;
                        LiveShowSceneBridgePanel.this.m_LiveShowVIPPanel.getLiveShowVIP().gotoSceneBridge(o_LiveShowSceneBridge, false);
                        break;
                    }
                    case 2: {
                        if (e.isAltDown() && (e.isShiftDown() || e.isControlDown())) {
                            if (!o_LiveShowSceneBridge.getSelected()) {
                                o_LiveShowVIP.selectObjectsFromPosition(o_LiveShowSceneBridge.getFrameStart(), true);
                                break;
                            }
                            o_LiveShowVIP.removeObjectsFromPositionToSelection(o_LiveShowSceneBridge.getFrameStart(), true);
                            break;
                        }
                        if (!e.isAltDown() && (e.isShiftDown() || e.isControlDown())) {
                            if (!LiveShowSceneBridgePanel.this.getSelected()) {
                                o_LiveShowVIP.addSelectedObject(o_LiveShowSceneBridge);
                                break;
                            }
                            o_LiveShowVIP.removeSelectedObject(o_LiveShowSceneBridge);
                            break;
                        }
                        if (e.isAltDown() || e.isShiftDown() || e.isControlDown()) break;
                        o_LiveShowVIP.setSelectedObject(o_LiveShowSceneBridge);
                        break;
                    }
                    case 3: {
                        if (e.isAltDown() && (e.isShiftDown() || e.isControlDown())) {
                            if (!o_LiveShowSceneBridge.getSelected()) {
                                o_LiveShowVIP.selectObjectsFromPosition(o_LiveShowSceneBridge.getFrameStart(), true);
                                break;
                            }
                            o_LiveShowVIP.removeObjectsFromPositionToSelection(o_LiveShowSceneBridge.getFrameStart(), true);
                            break;
                        }
                        if (LiveShowSceneBridgePanel.this.getSelected()) break;
                        o_LiveShowVIP.addSelectedObject(o_LiveShowSceneBridge);
                        break;
                    }
                    case 4: {
                        if (e.isAltDown() && (e.isShiftDown() || e.isControlDown())) {
                            if (!o_LiveShowSceneBridge.getSelected()) {
                                o_LiveShowVIP.selectObjectsFromPosition(o_LiveShowSceneBridge.getFrameStart(), true);
                                break;
                            }
                            o_LiveShowVIP.removeObjectsFromPositionToSelection(o_LiveShowSceneBridge.getFrameStart(), true);
                            break;
                        }
                        if (!LiveShowSceneBridgePanel.this.getSelected()) break;
                        o_LiveShowVIP.removeSelectedObject(o_LiveShowSceneBridge);
                        break;
                    }
                    case 5: {
                        if (e.isAltDown() && (e.isShiftDown() || e.isControlDown())) {
                            if (!o_LiveShowSceneBridge.getSelected()) {
                                o_LiveShowVIP.selectObjectsFromPosition(o_LiveShowSceneBridge.getFrameStart(), true);
                                break;
                            }
                            o_LiveShowVIP.removeObjectsFromPositionToSelection(o_LiveShowSceneBridge.getFrameStart(), true);
                            break;
                        }
                        o_LiveShowVIP.selectObjectsFromPosition(o_LiveShowSceneBridge.getFrameStart(), true);
                        break;
                    }
                    case 6: {
                        if (e.isAltDown() && (e.isShiftDown() || e.isControlDown())) {
                            if (!o_LiveShowSceneBridge.getSelected()) {
                                o_LiveShowVIP.selectObjectsFromPosition(o_LiveShowSceneBridge.getFrameStart(), true);
                                break;
                            }
                            o_LiveShowVIP.removeObjectsFromPositionToSelection(o_LiveShowSceneBridge.getFrameStart(), true);
                            break;
                        }
                        o_LiveShowVIP.addObjectsFromPositionToSelection(o_LiveShowSceneBridge.getFrameStart(), true);
                        break;
                    }
                    case 7: {
                        if (e.isAltDown() && (e.isShiftDown() || e.isControlDown())) {
                            if (!o_LiveShowSceneBridge.getSelected()) {
                                o_LiveShowVIP.selectObjectsFromPosition(o_LiveShowSceneBridge.getFrameStart(), true);
                                break;
                            }
                            o_LiveShowVIP.removeObjectsFromPositionToSelection(o_LiveShowSceneBridge.getFrameStart(), true);
                            break;
                        }
                        o_LiveShowVIP.removeObjectsFromPositionToSelection(o_LiveShowSceneBridge.getFrameStart(), true);
                        break;
                    }
                    case 8: {
                        LiveShowSceneBridgePanel.this.m_LiveShowVIPPanel.zoomPlus(true, longFramePosition);
                        break;
                    }
                    case 9: {
                        LiveShowSceneBridgePanel.this.m_LiveShowVIPPanel.zoomMinus(true, longFramePosition);
                    }
                }
            }

            @Override
            public void mousePressed_Delayed(MouseEvent e) {
                if (LiveShowSceneBridgePanel.this.getMouseEventDelegate_IsActive(e)) {
                    return;
                }
                LiveShowSceneBridgePanel.this.m_OldMousePositionX = e.getX();
                if (e.getComponent() instanceof LiveShowSceneBridgePanel) {
                    LiveShowSceneBridgePanel.this.m_MouseFramePositionInside = LiveShowSceneBridgePanel.this.m_LiveShowVIPPanel.getPositionFrame(LiveShowSceneBridgePanel.this.m_OldMousePositionX) - LiveShowSceneBridgePanel.this.m_LiveShowVIPPanel.getVisibleFrameStart();
                } else {
                    LiveShowSceneBridgePanel.this.m_MouseFramePositionInside = 0L;
                }
            }

            @Override
            public void mouseReleased_Delayed(MouseEvent e) {
                if (LiveShowSceneBridgePanel.this.getMouseEventDelegate_IsActive(e)) {
                    return;
                }
                LiveShowSceneBridgePanel.this.m_OldMousePositionX = 0;
                if (e.getComponent() instanceof LiveShowSceneBridgePanel) {
                    LiveShowVIPPanel o_LiveShowVIPPanel = LiveShowSceneBridgePanel.this.m_LiveShowVIPPanel;
                    if (o_LiveShowVIPPanel == null) {
                        return;
                    }
                    o_LiveShowVIPPanel.stopScrollAutomatic();
                    LiveShowVIP o_LiveShowVIP = o_LiveShowVIPPanel.getLiveShowVIP();
                    if (o_LiveShowVIP == null) {
                        return;
                    }
                    LiveShowUndo o_LiveShowUndo = o_LiveShowVIP.getLiveShowUndo();
                    if (o_LiveShowUndo == null) {
                        return;
                    }
                    if (!o_LiveShowUndo.checkEndAction(13)) {
                        return;
                    }
                    o_LiveShowVIP.endUndoAction(13, true, (LiveShowVIP.LiveShowVIPStatus)o_LiveShowVIP.getStatusSelected_ForEndAction());
                }
            }

            @Override
            public void mouseEntered_Delayed(MouseEvent e) {
            }

            @Override
            public void mouseExited_Delayed(MouseEvent e) {
            }

            @Override
            public void mouseDragged_Delayed(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                if (LiveShowSceneBridgePanel.this.getMouseEventDelegate_IsActive(e)) {
                    return;
                }
                LiveShowSceneBridge o_LiveShowSceneBridge = LiveShowSceneBridgePanel.this.m_LiveShowSceneBridge;
                if (o_LiveShowSceneBridge == null) {
                    return;
                }
                int intX = e.getX();
                if (intX == LiveShowSceneBridgePanel.this.m_OldMousePositionX) {
                    return;
                }
                if (!LiveShowSceneBridgePanel.this.m_IsSelected) {
                    return;
                }
                if (LiveShowSceneBridgePanel.this.m_LiveShowVIPPanel == null) {
                    return;
                }
                this.sleep(20L);
                if (e.getComponent() instanceof LiveShowSceneBridgePanel) {
                    long longFramePositionX = LiveShowSceneBridgePanel.this.m_LiveShowVIPPanel.getPositionFrame(intX);
                    long longMousePositionInside = longFramePositionX - o_LiveShowSceneBridge.getFrameStart();
                    long longOldFramePosition = o_LiveShowSceneBridge.getFrameStart();
                    long longNewFramePosition = o_LiveShowSceneBridge.getFrameStart() + longFramePositionX - LiveShowSceneBridgePanel.this.m_LiveShowVIPPanel.getPositionFrame(LiveShowSceneBridgePanel.this.m_OldMousePositionX);
                    LiveShowVIP o_LiveShowVIP = LiveShowSceneBridgePanel.this.m_LiveShowVIPPanel.getLiveShowVIP();
                    if (o_LiveShowVIP == null) {
                        return;
                    }
                    LiveShowVIP.LiveShowVIPStatus o_LiveShowVIPStatus = (LiveShowVIP.LiveShowVIPStatus)o_LiveShowVIP.getStatusSelected_ForStartAction();
                    if (o_LiveShowVIPStatus == null) {
                        return;
                    }
                    if (!LiveShowSceneBridgePanel.this.m_LiveShowVIPPanel.checkScroll(99, false, longOldFramePosition, longNewFramePosition, LiveShowSceneBridgePanel.this.m_MouseFramePositionInside, o_LiveShowSceneBridge, o_LiveShowSceneBridge.getDescription(), o_LiveShowVIPStatus)) {
                        o_LiveShowVIP.doActionMoveObjects(longNewFramePosition, o_LiveShowSceneBridge.getDescription(), o_LiveShowVIPStatus);
                    }
                }
            }

            @Override
            public void mouseMoved_Delayed(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                int intX = e.getX();
                int intY = e.getY();
                if (e.getComponent() instanceof LiveShowSceneBridgePanel) {
                    LiveShowSceneBridgePanel.this.setCursor(LiveShowSceneBridgePanel.this.getCursor(intX, intY));
                } else {
                    LiveShowSceneBridgePanel.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        };
    }

    public Cursor getCursor(int intX, int intY) {
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIPPanel.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return Cursor.getDefaultCursor();
        }
        switch (o_LiveShowVIP.getMouseCursorMode(intX, intY, this)) {
            case 1: {
                return LiveShowVIP.CURSOR_PLAYCURSOR;
            }
            case 2: {
                return LiveShowVIP.CURSOR_SELECTOBJECT;
            }
            case 3: {
                return LiveShowVIP.CURSOR_SELECTPLUS;
            }
            case 4: {
                return LiveShowVIP.CURSOR_SELECTMINUS;
            }
            case 5: {
                return LiveShowVIP.CURSOR_SELECTFROM;
            }
            case 6: {
                return LiveShowVIP.CURSOR_SELECTFROMPLUS;
            }
            case 7: {
                return LiveShowVIP.CURSOR_SELECTFROMMINUS;
            }
            case 8: {
                return LiveShowVIP.CURSOR_ZOOMPLUS;
            }
            case 9: {
                return LiveShowVIP.CURSOR_ZOOMMINUS;
            }
        }
        return Cursor.getDefaultCursor();
    }

    public void startUndoAction_Volume(int p_Action, String p_ActionString) {
        LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSceneBridge;
        if (o_LiveShowSceneBridge == null) {
            return;
        }
        if (!o_LiveShowSceneBridge.getSelected()) {
            this.startUndoAction(p_Action, p_ActionString);
            return;
        }
        LiveShowVIP o_LiveShowVIP = o_LiveShowSceneBridge.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return;
        }
        o_LiveShowVIP.startUndoAction_VolumeChange(o_LiveShowSceneBridge, p_Action, p_ActionString);
    }

    public void startUndoAction(int p_Action, String p_ActionString) {
        LiveShowUndo o_LiveShowUndo = null;
        LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSceneBridge;
        if (o_LiveShowSceneBridge == null) {
            return;
        }
        LiveShowVIP o_LiveShowVIP = o_LiveShowSceneBridge.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return;
        }
        o_LiveShowUndo = o_LiveShowVIP.getLiveShowUndo();
        if (o_LiveShowUndo == null) {
            return;
        }
        if (o_LiveShowUndo.checkStartAction(p_Action)) {
            LiveShowVIP.LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIP.LiveShowVIPStatus();
            o_LiveShowVIPStatus.addLiveShowSceneBridge_Cloned(o_LiveShowSceneBridge);
            o_LiveShowUndo.startAction(p_Action, p_ActionString, o_LiveShowVIP, o_LiveShowVIPStatus);
        }
    }

    public void endUndoAction_Volume(int p_Action, boolean p_Success) {
        LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSceneBridge;
        if (o_LiveShowSceneBridge == null) {
            return;
        }
        if (!o_LiveShowSceneBridge.getSelected()) {
            this.endUndoAction(p_Action, p_Success);
            return;
        }
        LiveShowVIP o_LiveShowVIP = o_LiveShowSceneBridge.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return;
        }
        o_LiveShowVIP.endUndoAction_VolumeChange(o_LiveShowSceneBridge, p_Action, p_Success);
    }

    public void endUndoAction(int p_Action, boolean p_Success) {
        LiveShowUndo o_LiveShowUndo = null;
        LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSceneBridge;
        if (o_LiveShowSceneBridge == null) {
            return;
        }
        LiveShowVIP o_LiveShowVIP = o_LiveShowSceneBridge.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return;
        }
        o_LiveShowUndo = o_LiveShowVIP.getLiveShowUndo();
        if (o_LiveShowUndo == null) {
            return;
        }
        if (o_LiveShowUndo.checkEndAction(p_Action)) {
            LiveShowVIP.LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIP.LiveShowVIPStatus();
            o_LiveShowVIPStatus.addLiveShowSceneBridge_Cloned(o_LiveShowSceneBridge);
            o_LiveShowUndo.endAction(p_Success, p_Action, o_LiveShowVIP, o_LiveShowVIPStatus);
        }
    }

    public class LabelFade
    extends JLabel
    implements MouseAdapter_Delayed.MouseEventDelegate {
        public static final int SIZE = 17;
        public static final int OVALSIZE = 13;
        public Icon Icon_Jump;
        public Icon Icon_JumpDisabled;
        public Cursor m_Cursor;
        private AbsoluteConstraints m_Constraints;
        private int m_FadeType;
        private LiveShowSceneBridgePanel m_LiveShowSceneBridgePanel;
        private MouseAdapter_Delayed m_MouseAdapter_Delayed;

        public LabelFade(LiveShowSceneBridgePanel p_LiveShowSceneBridgePanel, int p_FadeType) {
            this.m_LiveShowSceneBridgePanel = p_LiveShowSceneBridgePanel;
            this.m_FadeType = p_FadeType;
            this.initComponents();
            this.createMouseAdapter_Delayed();
            this.addMouseMotionListener(this.m_MouseAdapter_Delayed);
            this.addMouseListener(this.m_MouseAdapter_Delayed);
        }

        private void initComponents() {
            this.m_Constraints = new AbsoluteConstraints(0, 0, 0, 0);
            switch (this.m_FadeType) {
                case 1: {
                    this.m_Cursor = Cursor.getPredefinedCursor(4);
                    this.setToolTipText(LiveShowObject.TOOLTIP_FADEIN);
                    break;
                }
                case 2: {
                    this.setOpaque(true);
                    this.m_Cursor = Cursor.getPredefinedCursor(6);
                    this.setToolTipText(LiveShowObject.TOOLTIP_FADEOUT);
                    break;
                }
                case 3: {
                    this.m_Cursor = Cursor.getPredefinedCursor(8);
                    this.setToolTipText(LiveShowObject.TOOLTIP_VOLUME);
                    break;
                }
                case 6: {
                    this.setOpaque(true);
                    this.m_Cursor = Cursor.getPredefinedCursor(6);
                    this.setToolTipText(LiveShowObject.TOOLTIP_FADEOUT_OFFSET);
                    break;
                }
                case 7: {
                    this.m_Cursor = Cursor.getPredefinedCursor(4);
                    this.setToolTipText(LiveShowObject.TOOLTIP_FADEIN_OFFSET);
                    break;
                }
                case 4: {
                    this.m_Cursor = Cursor.getPredefinedCursor(10);
                    break;
                }
                case 5: {
                    this.m_Cursor = Cursor.getPredefinedCursor(11);
                    break;
                }
                case 8: {
                    this.m_Cursor = Cursor.getPredefinedCursor(12);
                    this.setToolTipText(LiveShowObject.TOOLTIP_STOP);
                    this.setBackground(Color.RED);
                    this.setBorder(new EtchedBorder(1, Color.WHITE, Color.RED));
                    break;
                }
                case 9: {
                    this.m_Cursor = Cursor.getPredefinedCursor(12);
                    this.setToolTipText(LiveShowObject.TOOLTIP_ACTIVE);
                    this.setBackground(Color.GREEN);
                    this.setBorder(new EtchedBorder(1, Color.WHITE, Color.GREEN));
                    break;
                }
                case 10: {
                    this.Icon_Jump = new ImageIcon(this.getClass().getResource("/IconsPackage/Scenebridge_Jump.png"));
                    this.Icon_JumpDisabled = new ImageIcon(this.getClass().getResource("/IconsPackage/Scenebridge_JumpDisabled.png"));
                    this.m_Cursor = Cursor.getPredefinedCursor(12);
                    this.setToolTipText(LiveShowObject.TOOLTIP_JUMP);
                    this.setOpaque(false);
                    this.setForeground(Color.WHITE);
                    this.setIconTextGap(3);
                }
            }
            this.setCursor(this.m_Cursor);
        }

        public void calculatePosition() {
            LiveShowSceneBridge o_LiveShowSceneBridge = LiveShowSceneBridgePanel.this.m_LiveShowSceneBridge;
            if (o_LiveShowSceneBridge == null) {
                return;
            }
            this.m_Constraints.width = 17;
            this.m_Constraints.height = 17;
            int intY = (int)((float)((LiveShowSceneBridgePanel)LiveShowSceneBridgePanel.this).m_AbsoluteConstraints.height - (float)(((LiveShowSceneBridgePanel)LiveShowSceneBridgePanel.this).m_AbsoluteConstraints.height / 2) * o_LiveShowSceneBridge.getVolumeFactor());
            switch (this.m_FadeType) {
                case 1: {
                    this.m_Constraints.x = LiveShowSceneBridgePanel.this.getInsidePositionX(o_LiveShowSceneBridge.getFrameLength() - o_LiveShowSceneBridge.getFrameFadeInLength()) - 8;
                    this.m_Constraints.y = ((LiveShowSceneBridgePanel)LiveShowSceneBridgePanel.this).m_AbsoluteConstraints.height - 17;
                    break;
                }
                case 2: {
                    this.m_Constraints.x = LiveShowSceneBridgePanel.this.getInsidePositionX(o_LiveShowSceneBridge.getFrameFadeOutLength()) - 8;
                    this.m_Constraints.y = ((LiveShowSceneBridgePanel)LiveShowSceneBridgePanel.this).m_AbsoluteConstraints.height - 17;
                    break;
                }
                case 3: {
                    this.m_Constraints.x = ((LiveShowSceneBridgePanel)LiveShowSceneBridgePanel.this).m_AbsoluteConstraints.width / 2 - 8;
                    this.m_Constraints.y = intY - 8;
                    break;
                }
                case 6: {
                    this.m_Constraints.x = LiveShowSceneBridgePanel.this.getInsidePositionX(o_LiveShowSceneBridge.getFrameFadeOutOffset()) - 8;
                    this.m_Constraints.y = intY - 8;
                    break;
                }
                case 7: {
                    this.m_Constraints.x = LiveShowSceneBridgePanel.this.getInsidePositionX(o_LiveShowSceneBridge.getFrameLength() - o_LiveShowSceneBridge.getFrameFadeInOffset()) - 8;
                    this.m_Constraints.y = intY - 8;
                    break;
                }
                case 4: {
                    this.m_Constraints.x = LiveShowSceneBridgePanel.this.getInsidePositionX(0L);
                    this.m_Constraints.y = 0;
                    this.m_Constraints.height = ((LiveShowSceneBridgePanel)LiveShowSceneBridgePanel.this).m_AbsoluteConstraints.height / 2;
                    break;
                }
                case 5: {
                    this.m_Constraints.x = LiveShowSceneBridgePanel.this.getInsidePositionX(o_LiveShowSceneBridge.getFrameLength()) - 17;
                    this.m_Constraints.y = 0;
                    this.m_Constraints.height = ((LiveShowSceneBridgePanel)LiveShowSceneBridgePanel.this).m_AbsoluteConstraints.height / 2;
                    break;
                }
                case 8: {
                    this.m_Constraints.x = 0;
                    this.m_Constraints.y = 0;
                    if (o_LiveShowSceneBridge.getStopAtStart()) {
                        this.setOpaque(true);
                        break;
                    }
                    this.setOpaque(false);
                    break;
                }
                case 9: {
                    this.m_Constraints.x = LiveShowSceneBridgePanel.this.m_AbsoluteConstraints.getWidth() - 17;
                    this.m_Constraints.y = 0;
                    if (o_LiveShowSceneBridge.getActive()) {
                        this.setOpaque(true);
                        break;
                    }
                    this.setOpaque(false);
                    break;
                }
                case 10: {
                    this.m_Constraints.x = 17;
                    this.m_Constraints.y = 0;
                    this.m_Constraints.width = LiveShowSceneBridgePanel.this.m_AbsoluteConstraints.getWidth() - 34;
                    if (o_LiveShowSceneBridge.getJumpSceneBridge() != null) {
                        this.setText(o_LiveShowSceneBridge.getJumpSceneBridge().getName());
                        if (o_LiveShowSceneBridge.getJumpActive()) {
                            this.setIcon(this.Icon_Jump);
                        } else {
                            this.setIcon(this.Icon_JumpDisabled);
                        }
                        this.setVisible(true);
                        break;
                    }
                    this.setText("");
                    this.setVisible(false);
                }
            }
        }

        public AbsoluteConstraints getAbsoluteConstraints() {
            return this.m_Constraints;
        }

        @Override
        public void paintComponent(Graphics p_Graphics) {
            if (p_Graphics == null) {
                return;
            }
            Graphics2D o_Graphics2D = (Graphics2D)p_Graphics;
            Color o_OldColor = p_Graphics.getColor();
            switch (this.m_FadeType) {
                case 3: 
                case 6: 
                case 7: {
                    o_Graphics2D.setColor(Color.BLACK);
                    o_Graphics2D.drawOval(3, 3, 12, 12);
                    o_Graphics2D.setColor(Color.WHITE);
                    o_Graphics2D.drawOval(2, 2, 12, 12);
                    if (!this.isOpaque()) break;
                    o_Graphics2D.fillOval(2, 2, 12, 12);
                    break;
                }
                case 1: 
                case 2: {
                    o_Graphics2D.setColor(Color.BLACK);
                    o_Graphics2D.drawOval(3, 5, 12, 12);
                    o_Graphics2D.setColor(Color.WHITE);
                    o_Graphics2D.drawOval(2, 4, 12, 12);
                    if (!this.isOpaque()) break;
                    o_Graphics2D.fillOval(2, 4, 12, 12);
                    break;
                }
                default: {
                    super.paintComponent(p_Graphics);
                }
            }
            o_Graphics2D.setColor(o_OldColor);
            super.paintBorder(p_Graphics);
            p_Graphics.dispose();
        }

        public LiveShowVIP getLiveShowVIP() {
            LiveShowVIP o_LiveShowVIP = null;
            Container o_Container = this.getParent().getParent();
            if (o_Container instanceof LiveShowVIPPanel) {
                LiveShowVIPPanel o_LiveShowVIPPanel = (LiveShowVIPPanel)o_Container;
                o_LiveShowVIP = o_LiveShowVIPPanel.getLiveShowVIP();
            }
            return o_LiveShowVIP;
        }

        private void createMouseAdapter_Delayed() {
            this.m_MouseAdapter_Delayed = new MouseAdapter_Delayed(){

                @Override
                public void mouseDragged_Delayed(MouseEvent e) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    LiveShowSceneBridge o_LiveShowSceneBridge = LiveShowSceneBridgePanel.this.m_LiveShowSceneBridge;
                    if (o_LiveShowSceneBridge == null) {
                        return;
                    }
                    int intX = e.getPoint().x;
                    int intY = e.getPoint().y;
                    int intTransferredX = intX + ((LabelFade)LabelFade.this).m_Constraints.x;
                    int intTransferredY = ((LabelFade)LabelFade.this).m_Constraints.y + intY;
                    long longPositionFrame = -1L;
                    LiveShowVIP o_LiveShowVIP = LabelFade.this.getLiveShowVIP();
                    LiveShowVIPPanel o_LiveShowVIPPanel = LiveShowSceneBridgePanel.this.m_LiveShowVIPPanel;
                    switch (LabelFade.this.m_FadeType) {
                        case 1: {
                            long longCheckedFramePosition;
                            longPositionFrame = LiveShowSceneBridgePanel.this.getPositionFrame(intTransferredX);
                            long longNewValue = o_LiveShowSceneBridge.getFrameLength() - longPositionFrame;
                            if (o_LiveShowSceneBridge.getFrameFadeInLength() == longNewValue) {
                                return;
                            }
                            long longNewFramePosition = o_LiveShowSceneBridge.getFrameStart() - o_LiveShowSceneBridge.getFrameStartOffset() + longPositionFrame;
                            if (o_LiveShowVIP != null && (longCheckedFramePosition = o_LiveShowVIP.checkSnapping(1, o_LiveShowSceneBridge.getDescription(), null, longNewFramePosition, true)) >= 0L) {
                                longNewValue = o_LiveShowSceneBridge.getFrameLength() - (longCheckedFramePosition - o_LiveShowSceneBridge.getFrameStart());
                            }
                            LiveShowSceneBridgePanel.this.startUndoAction(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
                            o_LiveShowSceneBridge.setFrameFadeInLength(longNewValue);
                            break;
                        }
                        case 2: {
                            long longCheckedFramePosition;
                            long longNewValue = longPositionFrame = LiveShowSceneBridgePanel.this.getPositionFrame(intTransferredX);
                            if (o_LiveShowSceneBridge.getFrameFadeOutLength() == longNewValue) {
                                return;
                            }
                            long longNewFramePosition = o_LiveShowSceneBridge.getFrameStart() - o_LiveShowSceneBridge.getFrameStartOffset() + longPositionFrame;
                            if (o_LiveShowVIP != null && (longCheckedFramePosition = o_LiveShowVIP.checkSnapping(2, o_LiveShowSceneBridge.getDescription(), null, longNewFramePosition, true)) >= 0L) {
                                longNewValue = longCheckedFramePosition - o_LiveShowSceneBridge.getFrameStart();
                            }
                            LiveShowSceneBridgePanel.this.startUndoAction(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
                            o_LiveShowSceneBridge.setFrameFadeOutLength(longNewValue);
                            break;
                        }
                        case 3: {
                            if (LiveShowSceneBridgePanel.this.m_AbsoluteConstraints == null || LiveShowSceneBridgePanel.this.m_AbsoluteConstraints.getHeight() <= 0) break;
                            float floatVolume = ((float)LiveShowSceneBridgePanel.this.m_AbsoluteConstraints.getHeight() - (float)intTransferredY) / ((float)LiveShowSceneBridgePanel.this.m_AbsoluteConstraints.getHeight() / 2.0f);
                            if (floatVolume < 0.0f) {
                                floatVolume = 0.0f;
                            }
                            if (floatVolume > 2.0f) {
                                floatVolume = 2.0f;
                            }
                            if (o_LiveShowSceneBridge.getVolumeFactor() == floatVolume) {
                                return;
                            }
                            LiveShowSceneBridgePanel.this.startUndoAction_Volume(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
                            o_LiveShowSceneBridge.setVolumeFactor(floatVolume, true);
                            break;
                        }
                        case 6: {
                            long longCheckedFramePosition;
                            long longNewValue = longPositionFrame = LiveShowSceneBridgePanel.this.getPositionFrame(intTransferredX);
                            if (o_LiveShowSceneBridge.getFrameFadeOutOffset() == longNewValue) {
                                return;
                            }
                            long longNewFramePosition = o_LiveShowSceneBridge.getFrameStart() - o_LiveShowSceneBridge.getFrameStartOffset() + longPositionFrame;
                            if (o_LiveShowVIP != null && (longCheckedFramePosition = o_LiveShowVIP.checkSnapping(6, o_LiveShowSceneBridge.getDescription(), null, longNewFramePosition, true)) >= 0L) {
                                longNewValue = longCheckedFramePosition - o_LiveShowSceneBridge.getFrameStart();
                            }
                            LiveShowSceneBridgePanel.this.startUndoAction(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
                            o_LiveShowSceneBridge.setFrameFadeOutOffset(longNewValue);
                            break;
                        }
                        case 7: {
                            long longCheckedFramePosition;
                            longPositionFrame = LiveShowSceneBridgePanel.this.getPositionFrame(intTransferredX);
                            long longNewValue = o_LiveShowSceneBridge.getFrameLength() - longPositionFrame;
                            if (o_LiveShowSceneBridge.getFrameFadeInOffset() == longNewValue) {
                                return;
                            }
                            long longNewFramePosition = o_LiveShowSceneBridge.getFrameStart() - o_LiveShowSceneBridge.getFrameStartOffset() + longPositionFrame;
                            if (o_LiveShowVIP != null && (longCheckedFramePosition = o_LiveShowVIP.checkSnapping(7, o_LiveShowSceneBridge.getDescription(), null, longNewFramePosition, true)) >= 0L) {
                                longNewValue = o_LiveShowSceneBridge.getFrameLength() - (longCheckedFramePosition - o_LiveShowSceneBridge.getFrameStart());
                            }
                            LiveShowSceneBridgePanel.this.startUndoAction(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
                            o_LiveShowSceneBridge.setFrameFadeInOffset(longNewValue);
                            break;
                        }
                        case 4: {
                            long longCheckedFramePosition;
                            longPositionFrame = LiveShowSceneBridgePanel.this.getPositionFrame(intTransferredX);
                            long longOldFramePosition = o_LiveShowSceneBridge.getFrameStart();
                            long longNewFramePosition = o_LiveShowSceneBridge.getFrameStart() + longPositionFrame;
                            if (o_LiveShowVIP != null && o_LiveShowVIPPanel != null && o_LiveShowSceneBridge.getFrameLength() > o_LiveShowVIPPanel.getSnapDistanceFrames() && (longCheckedFramePosition = o_LiveShowVIP.checkSnapping(4, o_LiveShowSceneBridge.getDescription(), null, longNewFramePosition, true)) >= 0L) {
                                longNewFramePosition = longCheckedFramePosition;
                            }
                            long longNewValue = longNewFramePosition;
                            if (o_LiveShowSceneBridge.getFrameStart() == longNewValue) {
                                return;
                            }
                            LiveShowSceneBridgePanel.this.startUndoAction(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
                            if (o_LiveShowVIPPanel == null || o_LiveShowVIPPanel.checkScroll(4, false, longOldFramePosition, longNewFramePosition, 0L, o_LiveShowSceneBridge, o_LiveShowSceneBridge.getDescription(), null)) break;
                            o_LiveShowSceneBridge.setFrameStartResize(longNewValue);
                            break;
                        }
                        case 5: {
                            long longNewValue;
                            long longCheckedFramePosition;
                            longPositionFrame = LiveShowSceneBridgePanel.this.getPositionFrame(intTransferredX);
                            long longOldFramePosition = o_LiveShowSceneBridge.getFrameStart() + o_LiveShowSceneBridge.getFrameLength();
                            long longNewFramePosition = o_LiveShowSceneBridge.getFrameStart() + longPositionFrame;
                            if (o_LiveShowVIP != null && o_LiveShowVIPPanel != null && o_LiveShowSceneBridge.getFrameLength() > o_LiveShowVIPPanel.getSnapDistanceFrames() && (longCheckedFramePosition = o_LiveShowVIP.checkSnapping(5, o_LiveShowSceneBridge.getDescription(), null, longNewFramePosition, true)) >= 0L) {
                                longNewFramePosition = longCheckedFramePosition;
                            }
                            if ((longNewValue = longNewFramePosition - o_LiveShowSceneBridge.getFrameStart()) < 0L) {
                                return;
                            }
                            if (o_LiveShowSceneBridge.getFrameLength() == longNewValue) {
                                return;
                            }
                            LiveShowSceneBridgePanel.this.startUndoAction(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
                            if (o_LiveShowVIPPanel == null || o_LiveShowVIPPanel.checkScroll(5, false, longOldFramePosition, longNewFramePosition, 0L, o_LiveShowSceneBridge, o_LiveShowSceneBridge.getDescription(), null)) break;
                            o_LiveShowSceneBridge.setFrameLength(longNewValue);
                        }
                    }
                }

                @Override
                public void mouseMoved_Delayed(MouseEvent e) {
                    LabelFade.this.setCursor(LabelFade.this.m_Cursor);
                }

                @Override
                public void mouseClicked_Delayed(MouseEvent e) {
                    LiveShowSceneBridge o_LiveShowSceneBridge = LiveShowSceneBridgePanel.this.m_LiveShowSceneBridge;
                    if (o_LiveShowSceneBridge == null) {
                        return;
                    }
                    int intMouseClickCount = e.getClickCount();
                    LiveShowVIP o_LiveShowVIP = LabelFade.this.getLiveShowVIP();
                    switch (LabelFade.this.m_FadeType) {
                        case 1: {
                            if (intMouseClickCount <= 1) break;
                            if (o_LiveShowSceneBridge.getFrameFadeInLength() == 0L) {
                                return;
                            }
                            LiveShowSceneBridgePanel.this.startUndoAction(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
                            o_LiveShowSceneBridge.setFrameFadeInLength(o_LiveShowSceneBridge.getFrameLength());
                            LiveShowSceneBridgePanel.this.endUndoAction(14, true);
                            break;
                        }
                        case 2: {
                            if (intMouseClickCount <= 1) break;
                            if (o_LiveShowSceneBridge.getFrameFadeOutLength() == 0L) {
                                return;
                            }
                            LiveShowSceneBridgePanel.this.startUndoAction(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
                            o_LiveShowSceneBridge.setFrameFadeOutLength(o_LiveShowSceneBridge.getFrameLength());
                            LiveShowSceneBridgePanel.this.endUndoAction(14, true);
                            break;
                        }
                        case 3: {
                            if (intMouseClickCount <= 1) break;
                            if (o_LiveShowSceneBridge.getVolumeFactor() == 1.0f) {
                                return;
                            }
                            LiveShowSceneBridgePanel.this.startUndoAction_Volume(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
                            o_LiveShowSceneBridge.setVolumeFactor(1.0f, true);
                            LiveShowSceneBridgePanel.this.endUndoAction_Volume(14, true);
                            break;
                        }
                        case 6: {
                            if (intMouseClickCount <= 1) break;
                            if (o_LiveShowSceneBridge.getFrameFadeOutOffset() == 0L) {
                                return;
                            }
                            LiveShowSceneBridgePanel.this.startUndoAction(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
                            o_LiveShowSceneBridge.setFrameFadeOutOffset(0L);
                            LiveShowSceneBridgePanel.this.endUndoAction(14, true);
                            break;
                        }
                        case 7: {
                            if (intMouseClickCount <= 1) break;
                            if (o_LiveShowSceneBridge.getFrameFadeInOffset() == 0L) {
                                return;
                            }
                            LiveShowSceneBridgePanel.this.startUndoAction(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
                            o_LiveShowSceneBridge.setFrameFadeInOffset(0L);
                            LiveShowSceneBridgePanel.this.endUndoAction(14, true);
                            break;
                        }
                        case 8: {
                            boolean boolStopAtStart = o_LiveShowSceneBridge.getStopAtStart();
                            boolStopAtStart = !boolStopAtStart;
                            LiveShowSceneBridgePanel.this.startUndoAction(110, LiveShowUndo.ACTION_OBJECTSTOPPER_STRING);
                            o_LiveShowSceneBridge.setStopAtStart(boolStopAtStart);
                            LiveShowSceneBridgePanel.this.endUndoAction(110, true);
                            break;
                        }
                        case 9: {
                            boolean boolActive = o_LiveShowSceneBridge.getActive();
                            boolActive = !boolActive;
                            LiveShowSceneBridgePanel.this.startUndoAction(111, LiveShowUndo.ACTION_OBJECTACTIVE_STRING);
                            o_LiveShowSceneBridge.setActive(boolActive);
                            LiveShowSceneBridgePanel.this.endUndoAction(111, true);
                            break;
                        }
                        case 10: {
                            boolean boolJumpActive = o_LiveShowSceneBridge.getJumpActive();
                            boolJumpActive = !boolJumpActive;
                            LiveShowSceneBridgePanel.this.startUndoAction(112, LiveShowUndo.ACTION_OBJECTJUMP_STRING);
                            o_LiveShowSceneBridge.setJumpActive(boolJumpActive);
                            LiveShowSceneBridgePanel.this.endUndoAction(112, true);
                        }
                    }
                }

                @Override
                public void mousePressed_Delayed(MouseEvent e) {
                }

                @Override
                public void mouseReleased_Delayed(MouseEvent e) {
                    LiveShowVIP o_LiveShowVIP = LabelFade.this.getLiveShowVIP();
                    LiveShowVIPPanel o_LiveShowVIPPanel = LiveShowSceneBridgePanel.this.m_LiveShowVIPPanel;
                    switch (LabelFade.this.m_FadeType) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            if (o_LiveShowVIPPanel != null) {
                                o_LiveShowVIPPanel.stopScrollAutomatic();
                            }
                            LiveShowSceneBridgePanel.this.endUndoAction(14, true);
                            break;
                        }
                        case 3: {
                            if (o_LiveShowVIPPanel != null) {
                                o_LiveShowVIPPanel.stopScrollAutomatic();
                            }
                            LiveShowSceneBridgePanel.this.endUndoAction_Volume(14, true);
                        }
                    }
                }

                @Override
                public void mouseEntered_Delayed(MouseEvent e) {
                }

                @Override
                public void mouseExited_Delayed(MouseEvent e) {
                }
            };
        }

        @Override
        public Component getMouseEventDelegate_ComponentDest(MouseEvent p_MouseEvent) {
            if (this.m_LiveShowSceneBridgePanel == null) {
                return null;
            }
            Component o_Component = this.m_LiveShowSceneBridgePanel.getMouseEventDelegate_ComponentDest(p_MouseEvent);
            if (o_Component != null) {
                Point o_Point = new Point(p_MouseEvent.getXOnScreen(), p_MouseEvent.getYOnScreen());
                o_Point.setLocation(p_MouseEvent.getXOnScreen(), p_MouseEvent.getYOnScreen());
                SwingUtilities.convertPointFromScreen(o_Point, o_Component);
                if (o_Component instanceof LiveShowObjectPanel) {
                    this.setCursor(((LiveShowObjectPanel)o_Component).getCursor(o_Point.x, o_Point.y));
                } else {
                    this.setCursor(o_Component.getCursor());
                }
            }
            return o_Component;
        }

        @Override
        public boolean getMouseEventDelegate_IsActive(MouseEvent p_MouseEvent) {
            if (this.m_LiveShowSceneBridgePanel == null) {
                return false;
            }
            return this.m_LiveShowSceneBridgePanel.getMouseEventDelegate_IsActive(p_MouseEvent);
        }
    }
}

