/*
 * Decompiled with CFR 0.152.
 */
package LiveShowVirtualPackage;

import GUID.LiveGUID;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectListener;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.PlayRemoteActions;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowVIP;
import SPITActionPackage.SPIT_ActionStatus;
import SPITActionPackage.SPIT_Action_Interface;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITRemotePackage.SPITRemote;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class LiveShowSceneBridgeMain
implements LiveShowObjectListener,
PlayRemoteActions.RemoteActionListener {
    public static ImageIcon s_Icon = new ImageIcon(LiveShowSceneBridgeMain.class.getResource("/IconsPackage/Scenebridge_Main.png"));
    public static MainBridgeContainer s_MainBridgeContainer = new MainBridgeContainer();
    @LiveLanguageString
    public static String s_MainBridgeRemoteGroupName = "MainSceneBridge";
    @LiveLanguageString
    public static String s_BridgeGroupName = "MainSceneBridge";
    protected String m_ID;
    protected ArrayList<LiveShowSceneBridge> m_MainPartnerSceneBridges;
    protected ArrayList<LiveShowSceneBridge> m_MainSceneBridgesHandled;
    protected long m_FrameStart;
    protected String m_Name;
    protected ArrayList<LiveShowObjectListener> m_LiveShowObjectListeners;
    protected final Object m_SyncObjectListeners = new Object();
    protected boolean m_IsClosing;
    private SPIT_Object_Interface m_SPIT_Object_Interface;
    private PlayRemoteActions.RemoteAction m_RemoteAction;

    public static MainBridgeContainer getMainBridgeContainer() {
        return s_MainBridgeContainer;
    }

    public static void checkMainBridges() {
        if (s_MainBridgeContainer == null) {
            return;
        }
        s_MainBridgeContainer.checkMainBridges_Complete();
    }

    public LiveShowSceneBridgeMain() {
        this.initMembers();
        LiveLanguage.addLanguageListener(this, null);
        s_MainBridgeContainer.addMainBridge(this);
    }

    public LiveShowSceneBridgeMain(String p_ID) {
        this.initMembers();
        LiveLanguage.addLanguageListener(this, null);
        if (p_ID != null && p_ID.length() > 0) {
            this.m_ID = p_ID;
        }
        s_MainBridgeContainer.addMainBridge(this);
    }

    private void initMembers() {
        this.m_ID = LiveGUID.getUID();
        this.m_MainPartnerSceneBridges = new ArrayList();
        this.m_FrameStart = 0L;
        this.m_Name = "";
        this.m_LiveShowObjectListeners = new ArrayList();
        this.m_MainSceneBridgesHandled = new ArrayList();
        this.m_SPIT_Object_Interface = null;
        this.m_RemoteAction = null;
        this.m_IsClosing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.m_IsClosing) {
            return;
        }
        this.m_IsClosing = true;
        if (this.m_MainPartnerSceneBridges != null) {
            for (int intSceneBridge = this.m_MainPartnerSceneBridges.size() - 1; intSceneBridge >= 0; --intSceneBridge) {
                LiveShowSceneBridge o_LiveShowSceneBridge = this.m_MainPartnerSceneBridges.get(intSceneBridge);
                this.removeSceneBridge(o_LiveShowSceneBridge);
                o_LiveShowSceneBridge.close(true);
            }
        }
        if (s_MainBridgeContainer != null) {
            s_MainBridgeContainer.removeMainBridge(this);
        }
        Object object = this.m_SyncObjectListeners;
        synchronized (object) {
            if (this.m_LiveShowObjectListeners != null) {
                this.m_LiveShowObjectListeners.clear();
            }
        }
        this.m_MainSceneBridgesHandled.clear();
        LiveLanguage.removeLanguageListener(this);
    }

    public String getID() {
        return this.m_ID;
    }

    public void setName(String p_Name) {
        if (this.m_Name.equals(p_Name)) {
            return;
        }
        this.m_Name = p_Name;
        for (int intSceneBridge = 0; intSceneBridge < this.m_MainPartnerSceneBridges.size(); ++intSceneBridge) {
            LiveShowSceneBridge o_LiveShowSceneBridge = this.m_MainPartnerSceneBridges.get(intSceneBridge);
            o_LiveShowSceneBridge.setName(this.m_Name);
        }
    }

    public String getName() {
        return this.m_Name;
    }

    public void setFrameStart(long p_NewPosition) {
        if (this.m_MainPartnerSceneBridges.size() <= 0) {
            return;
        }
        this.m_MainPartnerSceneBridges.get(0).setFrameStart(p_NewPosition);
    }

    public long getFrameStart() {
        return this.m_FrameStart;
    }

    public long getFrameLength() {
        if (this.m_MainPartnerSceneBridges.size() <= 0) {
            return 0L;
        }
        return this.m_MainPartnerSceneBridges.get(0).getFrameLength();
    }

    public void addSceneBridge(LiveShowSceneBridge p_PartnerLiveShowSceneBridge) {
        if (p_PartnerLiveShowSceneBridge == null) {
            return;
        }
        if (this.m_MainPartnerSceneBridges.contains(p_PartnerLiveShowSceneBridge)) {
            return;
        }
        this.m_MainPartnerSceneBridges.add(p_PartnerLiveShowSceneBridge);
        p_PartnerLiveShowSceneBridge.setID(this.m_ID);
        p_PartnerLiveShowSceneBridge.addLiveShowObjectListener(this);
        p_PartnerLiveShowSceneBridge.setLiveShowSceneBridgeMain(this);
        this.m_FrameStart = p_PartnerLiveShowSceneBridge.getFrameStart();
        this.m_Name = p_PartnerLiveShowSceneBridge.getName();
        if (this.m_MainPartnerSceneBridges.size() == 1) {
            s_MainBridgeContainer.addRemote_MainBridge(this);
        }
    }

    public void removeSceneBridge(LiveShowSceneBridge p_PartnerLiveShowSceneBridge) {
        if (p_PartnerLiveShowSceneBridge == null) {
            return;
        }
        if (!this.m_MainPartnerSceneBridges.contains(p_PartnerLiveShowSceneBridge)) {
            return;
        }
        this.m_MainPartnerSceneBridges.remove(p_PartnerLiveShowSceneBridge);
        p_PartnerLiveShowSceneBridge.removeLiveShowObjectListener(this);
        p_PartnerLiveShowSceneBridge.setLiveShowSceneBridgeMain(null);
        if (this.m_MainPartnerSceneBridges.size() <= 0) {
            this.close();
        }
    }

    public int getLiveShowSceneBridgeCount() {
        return this.m_MainPartnerSceneBridges.size();
    }

    public LiveShowSceneBridge getLiveShowSceneBridge(int p_PartnerIndex) {
        if (p_PartnerIndex < 0) {
            return null;
        }
        if (p_PartnerIndex >= this.m_MainPartnerSceneBridges.size()) {
            return null;
        }
        return this.m_MainPartnerSceneBridges.get(p_PartnerIndex);
    }

    public ArrayList<LiveShowSceneBridge> getLiveShowSceneBridges() {
        return this.m_MainPartnerSceneBridges;
    }

    public boolean getActive() {
        if (this.m_MainPartnerSceneBridges.size() <= 0) {
            return false;
        }
        return this.m_MainPartnerSceneBridges.get(0).getActive();
    }

    @Override
    public void eventObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (this.m_MainSceneBridgesHandled.contains((LiveShowSceneBridge)p_LiveShowObjectInterface)) {
            return;
        }
        this.m_MainSceneBridgesHandled.add((LiveShowSceneBridge)p_LiveShowObjectInterface);
        boolean boolOneChanged = false;
        for (int intSceneBridge = 0; intSceneBridge < this.m_MainPartnerSceneBridges.size(); ++intSceneBridge) {
            LiveShowSceneBridge o_LiveShowSceneBridge = this.m_MainPartnerSceneBridges.get(intSceneBridge);
            if (o_LiveShowSceneBridge == null || this.m_MainSceneBridgesHandled.contains(o_LiveShowSceneBridge)) continue;
            this.m_MainSceneBridgesHandled.add(o_LiveShowSceneBridge);
            if (o_LiveShowSceneBridge == p_LiveShowObjectInterface) continue;
            boolean boolChanged = false;
            o_LiveShowSceneBridge.setSendNotification(false);
            if (p_LiveShowObjectInterface.getFrameStart() != o_LiveShowSceneBridge.getFrameStart()) {
                boolChanged = true;
            }
            if (p_LiveShowObjectInterface.getFrameLength() != o_LiveShowSceneBridge.getFrameLength()) {
                boolChanged = true;
            }
            if (boolChanged) {
                o_LiveShowSceneBridge.setObjectParams(p_LiveShowObjectInterface.getFrameStart(), o_LiveShowSceneBridge.getFrameStartOffset(), p_LiveShowObjectInterface.getFrameLength(), o_LiveShowSceneBridge.getFrameFadeInLength(), o_LiveShowSceneBridge.getFrameFadeInOffset(), o_LiveShowSceneBridge.getFrameFadeOutLength(), o_LiveShowSceneBridge.getFrameFadeOutOffset(), o_LiveShowSceneBridge.getVolumeFactor());
            }
            if (!p_LiveShowObjectInterface.getName().equals(o_LiveShowSceneBridge.getName())) {
                o_LiveShowSceneBridge.setName(p_LiveShowObjectInterface.getName());
                boolChanged = true;
            }
            if (!p_LiveShowObjectInterface.getSourceName().equals(o_LiveShowSceneBridge.getSourceName())) {
                o_LiveShowSceneBridge.setSourceName(p_LiveShowObjectInterface.getSourceName());
                boolChanged = true;
            }
            if (p_LiveShowObjectInterface.getActive() != o_LiveShowSceneBridge.getActive()) {
                o_LiveShowSceneBridge.setActive(p_LiveShowObjectInterface.getActive());
                boolChanged = true;
            }
            if (p_LiveShowObjectInterface.getStopAtStart() != o_LiveShowSceneBridge.getStopAtStart()) {
                o_LiveShowSceneBridge.setStopAtStart(p_LiveShowObjectInterface.getStopAtStart());
                boolChanged = true;
            }
            o_LiveShowSceneBridge.setSendNotification(true);
            if (!boolChanged) continue;
            boolOneChanged = true;
            o_LiveShowSceneBridge.notifyObjectListeners_ObjectParameterChanged(o_LiveShowSceneBridge.getDescription());
        }
        this.m_FrameStart = p_LiveShowObjectInterface.getFrameStart();
        this.m_Name = p_LiveShowObjectInterface.getName();
        this.m_MainSceneBridgesHandled.clear();
        if (boolOneChanged) {
            this.notifyObjectListeners_ObjectParameterChanged(p_LiveShowObjectInterface, p_LiveShowObjectDescription);
        }
    }

    @Override
    public void eventObjectVolumeChanged(LiveShowObjectInterface p_LiveShowObjectInterface, float p_Volume) {
    }

    @Override
    public void eventObjectAdditionalChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
    }

    @Override
    public void eventObjectClosed(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        this.notifyObjectListeners_ObjectClosing(p_LiveShowObjectInterface);
        this.close();
    }

    @Override
    public void eventObjectSelection(LiveShowObjectInterface p_LiveShowObjectInterface, boolean p_IsSelected, boolean p_Added) {
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        if (!(p_LiveShowObjectInterface instanceof LiveShowSceneBridge)) {
            return;
        }
        this.notifyObjectListeners_Selection(p_LiveShowObjectInterface, p_Added);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLiveShowObjectListener(LiveShowObjectListener p_LiveShowObjectListener) {
        if (p_LiveShowObjectListener == null) {
            return;
        }
        Object object = this.m_SyncObjectListeners;
        synchronized (object) {
            if (this.m_LiveShowObjectListeners.contains(p_LiveShowObjectListener)) {
                return;
            }
            this.m_LiveShowObjectListeners.add(p_LiveShowObjectListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLiveShowObjectListener(LiveShowObjectListener p_LiveShowObjectListener) {
        if (p_LiveShowObjectListener == null) {
            return;
        }
        Object object = this.m_SyncObjectListeners;
        synchronized (object) {
            this.m_LiveShowObjectListeners.remove(p_LiveShowObjectListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyObjectListeners_ObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        ArrayList<LiveShowObjectListener> o_LiveShowObjectListeners;
        Object object = this.m_SyncObjectListeners;
        synchronized (object) {
            if (this.m_LiveShowObjectListeners == null) {
                return;
            }
            o_LiveShowObjectListeners = new ArrayList<LiveShowObjectListener>(this.m_LiveShowObjectListeners.size());
            o_LiveShowObjectListeners.addAll(this.m_LiveShowObjectListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowObjectListeners.size(); ++intListener) {
            LiveShowObjectListener o_Listener = (LiveShowObjectListener)o_LiveShowObjectListeners.get(intListener);
            o_Listener.eventObjectParameterChanged(p_LiveShowObjectInterface, p_LiveShowObjectDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyObjectListeners_ObjectClosing(LiveShowObjectInterface p_LiveShowObjectInterface) {
        LiveShowObjectListener o_Listener;
        ArrayList<LiveShowObjectListener> o_LiveShowObjectListeners;
        Object object = this.m_SyncObjectListeners;
        synchronized (object) {
            if (this.m_LiveShowObjectListeners == null) {
                return;
            }
            o_LiveShowObjectListeners = new ArrayList<LiveShowObjectListener>(this.m_LiveShowObjectListeners.size());
            int intListenerCount = this.m_LiveShowObjectListeners.size();
            for (int intListener = intListenerCount - 1; intListener >= 0 && this.m_LiveShowObjectListeners.size() > 0; --intListener) {
                o_Listener = this.m_LiveShowObjectListeners.get(intListener);
                o_LiveShowObjectListeners.add(o_Listener);
                this.m_LiveShowObjectListeners.remove(o_Listener);
            }
        }
        for (int intListener = 0; intListener < o_LiveShowObjectListeners.size(); ++intListener) {
            o_Listener = (LiveShowObjectListener)o_LiveShowObjectListeners.get(intListener);
            o_Listener.eventObjectClosed(p_LiveShowObjectInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyObjectListeners_Selection(LiveShowObjectInterface p_LiveShowObjectInterface, boolean p_Added) {
        ArrayList<LiveShowObjectListener> o_LiveShowObjectListeners;
        Object object = this.m_SyncObjectListeners;
        synchronized (object) {
            if (this.m_LiveShowObjectListeners == null) {
                return;
            }
            o_LiveShowObjectListeners = new ArrayList<LiveShowObjectListener>(this.m_LiveShowObjectListeners.size());
            o_LiveShowObjectListeners.addAll(this.m_LiveShowObjectListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowObjectListeners.size(); ++intListener) {
            LiveShowObjectListener o_Listener = (LiveShowObjectListener)o_LiveShowObjectListeners.get(intListener);
            o_Listener.eventObjectSelection(p_LiveShowObjectInterface, p_LiveShowObjectInterface.getSelected(), p_Added);
        }
    }

    public void setSPIT_Object_Interface(SPIT_Object_Interface p_SPIT_Object_Interface) {
        this.m_SPIT_Object_Interface = p_SPIT_Object_Interface;
    }

    public SPIT_Object_Interface getSPIT_Object_Interface() {
        return this.m_SPIT_Object_Interface;
    }

    public void setRemoteAction(PlayRemoteActions.RemoteAction p_RemoteAction) {
        this.m_RemoteAction = p_RemoteAction;
    }

    public PlayRemoteActions.RemoteAction getRemoteAction() {
        return this.m_RemoteAction;
    }

    @Override
    public void doAction(PlayRemoteActions.RemoteAction p_RemoteAction, double p_Value) {
        if (p_RemoteAction == null) {
            return;
        }
        if (!this.getActive()) {
            return;
        }
        LiveShowVIP o_LiveShowVIP = LiveShowVIP.getLiveShowVIP(0);
        if (o_LiveShowVIP == null) {
            return;
        }
        Play o_Play = o_LiveShowVIP.getPlay();
        if (o_Play == null) {
            return;
        }
        Play.PlaySynchronisizer o_PlaySynchronisizer = o_Play.getPlaySynchronizer();
        if (o_PlaySynchronisizer == null) {
            return;
        }
        o_LiveShowVIP.gotoSceneBridge(this.getID(), true, false);
        o_PlaySynchronisizer.actionStartPlaysSceneBridge();
    }

    public static class MainBridgeContainer
    implements SPIT_Action_Interface,
    LiveShowObjectListener {
        private ArrayList<LiveShowSceneBridgeMain> m_LiveShowSceneBridgeMains;
        private ArrayList<LiveShowVIP> m_LiveShowVIPs;
        private HashMap<String, LiveShowSceneBridgeMain> m_ChangedLiveShowScenebridgeMains;
        private final Object m_SyncChangedLiveShowSceneBridgeMain = new Object();
        private final Object m_SyncObject = new Object();

        public MainBridgeContainer() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_LiveShowVIPs = new ArrayList();
            this.m_LiveShowSceneBridgeMains = new ArrayList();
            this.m_ChangedLiveShowScenebridgeMains = new HashMap();
        }

        public String getName() {
            return "MainBridgeContainer";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLiveShowVIP(LiveShowVIP p_LiveShowVIP) {
            if (p_LiveShowVIP == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_LiveShowVIPs.contains(p_LiveShowVIP)) {
                    return;
                }
            }
            this.m_LiveShowVIPs.add(p_LiveShowVIP);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLiveShowVIP(LiveShowVIP p_LiveShowVIP) {
            if (p_LiveShowVIP == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!this.m_LiveShowVIPs.contains(p_LiveShowVIP)) {
                    return;
                }
            }
            this.m_LiveShowVIPs.remove(p_LiveShowVIP);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LiveShowVIP getLIveShowVIP(int p_Index) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_Index < 0) {
                    return null;
                }
                if (p_Index >= this.m_LiveShowVIPs.size()) {
                    return null;
                }
                return this.m_LiveShowVIPs.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getLiveShowSceneBridgeMain_Count() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                return this.m_LiveShowSceneBridgeMains.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LiveShowSceneBridgeMain getLiveShowSceneBridgeMain(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_Index >= this.m_LiveShowSceneBridgeMains.size()) {
                    return null;
                }
                return this.m_LiveShowSceneBridgeMains.get(p_Index);
            }
        }

        public LiveShowSceneBridgeMain getCreateMainBridge(String p_ID, long p_FramePosition, boolean p_CreateSubSceneBridges) {
            LiveShowSceneBridgeMain o_LiveShowSceneBridgeMain = this.findLiveShowSceneBridgeMain(p_ID);
            if (o_LiveShowSceneBridgeMain != null) {
                return o_LiveShowSceneBridgeMain;
            }
            o_LiveShowSceneBridgeMain = new LiveShowSceneBridgeMain(p_ID);
            if (!p_CreateSubSceneBridges) {
                return o_LiveShowSceneBridgeMain;
            }
            LiveShowVIP o_LiveShowVIP = null;
            LiveShowSceneBridge o_LiveShowSceneBridge = null;
            ArrayList<LiveShowObjectInterface> o_LiveShowSceneBridges = new ArrayList<LiveShowObjectInterface>();
            for (int intVIP = 0; intVIP < this.m_LiveShowVIPs.size(); ++intVIP) {
                o_LiveShowVIP = this.m_LiveShowVIPs.get(intVIP);
                if (o_LiveShowVIP == null || (o_LiveShowSceneBridge = o_LiveShowVIP.getLiveShowSceneBridge(o_LiveShowSceneBridgeMain.getID())) != null) continue;
                o_LiveShowSceneBridge = o_LiveShowVIP.createLiveShowSceneBridge(null);
                o_LiveShowSceneBridge.setFrameStart(p_FramePosition);
                o_LiveShowSceneBridge.setStopAtStart(true);
                o_LiveShowSceneBridgeMain.addSceneBridge(o_LiveShowSceneBridge);
                o_LiveShowSceneBridges.add(o_LiveShowSceneBridge);
            }
            if (o_LiveShowVIP == null || o_LiveShowSceneBridge == null) {
                return null;
            }
            LiveShowVIP.LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIP.LiveShowVIPStatus();
            o_LiveShowVIPStatus.addLiveShowObjects_ForAction(o_LiveShowSceneBridges);
            o_LiveShowVIP.doActionAddMainScenebridge(null, p_FramePosition, o_LiveShowSceneBridgeMain, o_LiveShowVIPStatus);
            return o_LiveShowSceneBridgeMain;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LiveShowSceneBridgeMain findLiveShowSceneBridgeMain(String p_ID) {
            if (p_ID == null || p_ID.length() <= 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intMainBridge = 0; intMainBridge < this.m_LiveShowSceneBridgeMains.size(); ++intMainBridge) {
                    LiveShowSceneBridgeMain o_LiveShowSceneBridgeMain = this.m_LiveShowSceneBridgeMains.get(intMainBridge);
                    if (o_LiveShowSceneBridgeMain == null || !p_ID.equals(o_LiveShowSceneBridgeMain.getID())) continue;
                    return o_LiveShowSceneBridgeMain;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addMainBridge(LiveShowSceneBridgeMain p_LiveShowSceneBridgeMain) {
            if (p_LiveShowSceneBridgeMain == null) {
                return;
            }
            LiveShowSceneBridgeMain o_LiveShowSceneBridgeMain = this.findLiveShowSceneBridgeMain(p_LiveShowSceneBridgeMain.getID());
            if (o_LiveShowSceneBridgeMain != null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.m_LiveShowSceneBridgeMains.add(p_LiveShowSceneBridgeMain);
            }
            p_LiveShowSceneBridgeMain.addLiveShowObjectListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeMainBridge(LiveShowSceneBridgeMain p_LiveShowSceneBridgeMain) {
            if (p_LiveShowSceneBridgeMain == null) {
                return;
            }
            LiveShowSceneBridgeMain o_LiveShowSceneBridgeMain = this.findLiveShowSceneBridgeMain(p_LiveShowSceneBridgeMain.getID());
            if (o_LiveShowSceneBridgeMain == null) {
                return;
            }
            o_LiveShowSceneBridgeMain.removeLiveShowObjectListener(this);
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.m_LiveShowSceneBridgeMains.remove(o_LiveShowSceneBridgeMain);
            }
            this.removeRemote_MainBridge(p_LiveShowSceneBridgeMain);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkMainBridges_Complete() {
            ArrayList<LiveShowVIP> o_MissingLiveShowVIPs = new ArrayList<LiveShowVIP>();
            boolean boolSelected = false;
            for (int intMainBridge = this.m_LiveShowSceneBridgeMains.size() - 1; intMainBridge >= 0; --intMainBridge) {
                LiveShowSceneBridge o_LiveShowSceneBridge;
                LiveShowVIP o_LiveShowVIP;
                LiveShowSceneBridgeMain o_LiveShowSceneBridgeMain;
                o_MissingLiveShowVIPs.clear();
                LiveShowObjectDescription o_LiveShowObjectDescription = null;
                Object object = this.m_SyncObject;
                synchronized (object) {
                    if (intMainBridge >= this.m_LiveShowSceneBridgeMains.size()) {
                        continue;
                    }
                    o_LiveShowSceneBridgeMain = this.m_LiveShowSceneBridgeMains.get(intMainBridge);
                    for (int intVIP = 0; intVIP < this.m_LiveShowVIPs.size(); ++intVIP) {
                        o_LiveShowVIP = this.m_LiveShowVIPs.get(intVIP);
                        if (o_LiveShowVIP == null) continue;
                        o_LiveShowSceneBridge = o_LiveShowVIP.getLiveShowSceneBridge(o_LiveShowSceneBridgeMain.getID());
                        if (o_LiveShowSceneBridge == null) {
                            o_MissingLiveShowVIPs.add(o_LiveShowVIP);
                            continue;
                        }
                        o_LiveShowObjectDescription = o_LiveShowSceneBridge.getDescription();
                        boolSelected = o_LiveShowSceneBridge.getSelected();
                    }
                }
                if (o_MissingLiveShowVIPs.size() <= 0 || o_LiveShowObjectDescription == null) {
                    return;
                }
                for (int intVIP = 0; intVIP < o_MissingLiveShowVIPs.size(); ++intVIP) {
                    o_LiveShowVIP = (LiveShowVIP)o_MissingLiveShowVIPs.get(intVIP);
                    if (o_LiveShowVIP == null) continue;
                    o_LiveShowSceneBridge = o_LiveShowVIP.createLiveShowSceneBridge(o_LiveShowSceneBridgeMain, o_LiveShowObjectDescription);
                    if (!boolSelected) continue;
                    o_LiveShowVIP.addSelectedObject(o_LiveShowSceneBridge);
                }
            }
        }

        public void splitLiveShowSceneBridgeMain(LiveShowSceneBridgeMain p_LiveShowSceneBridgeMain) {
            if (p_LiveShowSceneBridgeMain == null) {
                return;
            }
            int intSceneBridgeCount = p_LiveShowSceneBridgeMain.getLiveShowSceneBridgeCount();
            for (int intPartnerSceneBridge = intSceneBridgeCount - 1; intPartnerSceneBridge >= 0; --intPartnerSceneBridge) {
                LiveShowSceneBridge o_LiveShowSceneBridge = p_LiveShowSceneBridgeMain.getLiveShowSceneBridge(intPartnerSceneBridge);
                if (o_LiveShowSceneBridge == null) continue;
                p_LiveShowSceneBridgeMain.removeSceneBridge(o_LiveShowSceneBridge);
                o_LiveShowSceneBridge.setID(LiveGUID.getUID());
            }
            p_LiveShowSceneBridgeMain.close();
        }

        public void addRemote_MainBridge(LiveShowSceneBridgeMain p_LiveShowSceneBridgeMain) {
            if (p_LiveShowSceneBridgeMain == null) {
                return;
            }
            String stringID = p_LiveShowSceneBridgeMain.getID();
            SPIT_Object_Interface o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object((String)stringID);
            if (o_SPIT_Object_Interface != null) {
                return;
            }
            SPIT_Type_Interface o_SPIT_Type_Interface = SPITRemote.createServerRemoteSPIT_Type((String)stringID, (String)s_MainBridgeRemoteGroupName, (String)p_LiveShowSceneBridgeMain.getName(), (boolean)false);
            if (o_SPIT_Type_Interface != null) {
                SPITRemote.addRemoteSPIT_Type((SPIT_Type_Interface)o_SPIT_Type_Interface);
                o_SPIT_Object_Interface = SPITRemote.createServerRemoteSPIT_Object((SPIT_Type_Interface)o_SPIT_Type_Interface, (String)stringID, (String)"play", (byte)0);
                if (o_SPIT_Object_Interface != null) {
                    o_SPIT_Object_Interface.setFrameStart(p_LiveShowSceneBridgeMain.getFrameStart());
                    o_SPIT_Object_Interface.setFrameLength(p_LiveShowSceneBridgeMain.getFrameLength());
                    o_SPIT_Object_Interface.setSPIT_Action_Interface((SPIT_Action_Interface)this, null);
                    SPITRemote.addRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object_Interface);
                    p_LiveShowSceneBridgeMain.setSPIT_Object_Interface(o_SPIT_Object_Interface);
                }
            }
            PlayRemoteActions.RemoteAction o_RemoteAction = PlayRemoteActions.createRemoteAction(p_LiveShowSceneBridgeMain, s_Icon, "MainBridge", "actionPlay", stringID, p_LiveShowSceneBridgeMain.getName(), p_LiveShowSceneBridgeMain.getFrameStart());
            p_LiveShowSceneBridgeMain.setRemoteAction(o_RemoteAction);
        }

        public void removeRemote_MainBridge(LiveShowSceneBridgeMain p_LiveShowSceneBridgeMain) {
            if (p_LiveShowSceneBridgeMain == null) {
                return;
            }
            SPIT_Object_Interface o_SPIT_Object_Interface = p_LiveShowSceneBridgeMain.getSPIT_Object_Interface();
            if (o_SPIT_Object_Interface != null) {
                SPIT_Type_Interface o_SPIT_Type_Interface = o_SPIT_Object_Interface.getSPIT_Type();
                SPITRemote.removeRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object_Interface);
                SPITRemote.removeRemoteSPIT_Type((SPIT_Type_Interface)o_SPIT_Type_Interface);
            }
            p_LiveShowSceneBridgeMain.setSPIT_Object_Interface(null);
            PlayRemoteActions.RemoteAction o_RemoteAction = p_LiveShowSceneBridgeMain.getRemoteAction();
            PlayRemoteActions.removeRemoteAction(o_RemoteAction);
            p_LiveShowSceneBridgeMain.setRemoteAction(null);
        }

        public void changeRemote_Bridge(LiveShowSceneBridgeMain p_LiveShowSceneBridgeMain) {
            PlayRemoteActions.RemoteAction o_RemoteAction;
            SPIT_Type_Interface o_SPIT_Type_Interface;
            SPIT_Object_Interface o_SPIT_Object_Interface = p_LiveShowSceneBridgeMain.getSPIT_Object_Interface();
            if (o_SPIT_Object_Interface != null && (o_SPIT_Type_Interface = o_SPIT_Object_Interface.getSPIT_Type()) != null) {
                o_SPIT_Type_Interface.setName(p_LiveShowSceneBridgeMain.getName());
                o_SPIT_Object_Interface.setFrameStart(p_LiveShowSceneBridgeMain.getFrameStart());
                o_SPIT_Object_Interface.setFrameLength(p_LiveShowSceneBridgeMain.getFrameLength());
            }
            if ((o_RemoteAction = p_LiveShowSceneBridgeMain.getRemoteAction()) != null) {
                o_RemoteAction.setSourcePosition(p_LiveShowSceneBridgeMain.getFrameStart());
                o_RemoteAction.setSourceName(p_LiveShowSceneBridgeMain.getName());
            }
        }

        public void playStarted(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_ActionObject) {
        }

        public void play(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_ActionObject) {
            LiveShowSceneBridgeMain o_LiveShowSceneBridgeMain = this.findLiveShowSceneBridgeMain(p_SPIT_Object_Interface.getID());
            if (o_LiveShowSceneBridgeMain == null) {
                return;
            }
            if (!o_LiveShowSceneBridgeMain.getActive()) {
                return;
            }
            LiveShowVIP o_LiveShowVIP = this.getLIveShowVIP(0);
            if (o_LiveShowVIP == null) {
                return;
            }
            Play o_Play = o_LiveShowVIP.getPlay();
            if (o_Play == null) {
                return;
            }
            Play.PlaySynchronisizer o_PlaySynchronisizer = o_Play.getPlaySynchronizer();
            if (o_PlaySynchronisizer == null) {
                return;
            }
            o_LiveShowVIP.gotoSceneBridge(p_SPIT_Object_Interface.getID(), true, false);
            o_PlaySynchronisizer.actionStartPlaysSceneBridge();
        }

        public void playEnd(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_ActionObject) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void eventObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
            if (p_LiveShowObjectDescription == null) {
                return;
            }
            LiveShowSceneBridgeMain o_LiveShowSceneBridgeMain = this.findLiveShowSceneBridgeMain(p_LiveShowObjectDescription.getID());
            if (o_LiveShowSceneBridgeMain == null) {
                return;
            }
            Object object = this.m_SyncChangedLiveShowSceneBridgeMain;
            synchronized (object) {
                this.m_ChangedLiveShowScenebridgeMains.put(o_LiveShowSceneBridgeMain.getID(), o_LiveShowSceneBridgeMain);
            }
        }

        @Override
        public void eventObjectVolumeChanged(LiveShowObjectInterface p_LiveShowObjectInterface, float p_Volume) {
        }

        @Override
        public void eventObjectAdditionalChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        }

        @Override
        public void eventObjectClosed(LiveShowObjectInterface p_LiveShowObjectInterface) {
        }

        @Override
        public void eventObjectSelection(LiveShowObjectInterface p_LiveShowObjectInterface, boolean p_IsSelected, boolean p_Added) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eventEndOfAction() {
            Object object = this.m_SyncChangedLiveShowSceneBridgeMain;
            synchronized (object) {
                for (LiveShowSceneBridgeMain o_LiveShowSceneBridgeMain : this.m_ChangedLiveShowScenebridgeMains.values()) {
                    this.changeRemote_Bridge(o_LiveShowSceneBridgeMain);
                }
                this.m_ChangedLiveShowScenebridgeMains.clear();
            }
        }
    }
}

