/*
 * Decompiled with CFR 0.152.
 */
package LiveShowVirtualPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectListener;
import LiveShowObjectPackage.LiveShowObjectPanel;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.PlayListener;
import LiveShowPlayPackage.PlayRemoteActions;
import LiveShowVirtualPackage.LiveShowSceneBridgeMain;
import LiveShowVirtualPackage.LiveShowVIP;
import SPITActionPackage.SPIT_ActionStatus;
import SPITActionPackage.SPIT_Action_Interface;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITRemotePackage.SPITRemote;
import SwingModelPackage.TableAndListModel;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class LiveShowSceneBridge
extends LiveShowObject
implements PlayListener,
LiveShowObjectListener,
SPIT_Action_Interface,
PlayRemoteActions.RemoteActionListener {
    public static long DEFAULTFRAMELENGTHSCENEBRIDGE = 176400L;
    public static ImageIcon s_Icon = new ImageIcon(LiveShowSceneBridgeMain.class.getResource("/IconsPackage/Scenebridge.png"));
    @LiveLanguageString
    public static String SCENEBRIDGE = "SceneBridge";
    public static final String DEFAULT_NEWSCENBRIDGENAME = "newSceneBridge";
    public static final String PROP_SCENEBRIDGE_STOPATSTART = "scenebridgeStopAtStart";
    public static final TableAndListModel.ListRenderer s_SceneBridgeCellRenderer = new TableAndListModel.ListRenderer();
    public static Color s_ColorSceneBridge = new Color(150, 150, 150);
    public static Color s_ColorMainSceneBridge = new Color(150, 0, 0);
    protected LiveShowVIP m_LiveShowVIP;
    protected long m_FramePositionPre;
    protected boolean m_PlayPreObject;
    protected Play m_Play;
    protected long m_OldReadPosition;
    protected boolean m_PlayCursorJustSet;
    protected long m_OldPlayCursor;
    protected boolean m_JumpedInternal;
    protected LiveShowSceneBridge m_JumpSceneBridge;
    protected LiveShowSceneBridgeMain m_LiveShowSceneBridgeMain;
    protected long m_FramesToNextSceneBridge;
    protected boolean m_Closing;
    SPIT_Object_Interface m_SPIT_Object_Interface;
    PlayRemoteActions.RemoteAction m_RemoteAction;

    public LiveShowSceneBridge(LiveShowObjectDescription p_LiveShowObjectDescription) {
        super(p_LiveShowObjectDescription);
        ImageIcon o_Icon_Null = new ImageIcon(this.getClass().getResource("/IconsPackage/_Empty.png"));
        s_SceneBridgeCellRenderer.setNullLabel((Icon)o_Icon_Null, (Icon)o_Icon_Null, "---", null, 10, Color.DARK_GRAY, Color.WHITE);
        s_SceneBridgeCellRenderer.setMaximumSize(new Dimension(50, 24));
        this.initMembers();
        LiveLanguage.addLanguageListener(this, null);
        this.refreshToolTipText();
    }

    private void initMembers() {
        this.m_IsPlaying = false;
        this.m_JumpedInternal = false;
        this.m_OldReadPosition = 0L;
        this.m_PlayCursorJustSet = false;
        this.m_OldPlayCursor = 0L;
        this.m_LiveShowSceneBridgeMain = null;
        this.m_PlayPreObject = true;
        this.m_JumpSceneBridge = null;
        this.m_Closing = false;
        this.m_FramesToNextSceneBridge = -1L;
    }

    @Override
    public void close(boolean p_Finish) {
        if (this.m_Closing) {
            return;
        }
        this.m_Closing = true;
        this.stopSceneBridge();
        if (this.m_Play != null) {
            this.m_Play.removePlayListener(this);
        }
        this.setJumpSceneBridge(null);
        if (!this.getIsMainBridge()) {
            this.removeRemote_Bridge(this);
        }
        super.close(p_Finish);
    }

    public void setLiveShowVIP(LiveShowVIP p_LiveShowSoundVIP) {
        this.m_LiveShowVIP = p_LiveShowSoundVIP;
        if (this.m_LiveShowVIP != null) {
            this.m_Play = p_LiveShowSoundVIP.getPlay();
            this.m_Play.addPlayListener(this);
        } else {
            this.m_Play = null;
        }
        if (p_LiveShowSoundVIP != null && !this.getIsMainBridge()) {
            this.addRemote_Bridge(this);
        }
    }

    @Override
    public LiveShowVIP getLiveShowVIP() {
        return this.m_LiveShowVIP;
    }

    public Icon getIcon() {
        if (this.m_LiveShowVIP == null) {
            return null;
        }
        return this.m_LiveShowVIP.getImageIcon();
    }

    public Color getBackground() {
        if (this.getIsMainBridge()) {
            return s_ColorMainSceneBridge;
        }
        return s_ColorSceneBridge;
    }

    public Color getForeground() {
        return Color.WHITE;
    }

    public void startSceneBridge(boolean p_WillPlay) {
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP == null) {
            return;
        }
        o_LiveShowVIP.startSceneBridge(this, p_WillPlay);
        Play o_Play = o_LiveShowVIP.getPlay();
        this.m_PlayPreObject = o_Play != null && o_Play.isRunning();
    }

    public void stopSceneBridge() {
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP != null) {
            o_LiveShowVIP.stopSceneBridge(this);
        }
        this.m_FramePositionPre = 0L;
        this.m_IsPlaying = false;
        this.m_JumpedInternal = false;
    }

    public void setPlayPreObject(boolean p_PlayPreObject) {
        this.m_PlayPreObject = p_PlayPreObject;
    }

    public boolean getPlayPreObject() {
        return this.m_PlayPreObject;
    }

    public void setFramesToNextSceneBridge(long p_Frames) {
        this.m_FramesToNextSceneBridge = p_Frames;
    }

    public long getFramesToNextSceneBridge() {
        return this.m_FramesToNextSceneBridge;
    }

    public void setFramesRecordedNextSceneBridge(long p_FramesRecorded) {
        if (p_FramesRecorded < 0L) {
            p_FramesRecorded = 0L;
        }
        if (this.m_Description.getFramesRecordedToNext() != p_FramesRecorded) {
            this.m_Description.setFramesRecordedToNext(p_FramesRecorded);
            this.m_ChangedSinceLastAction = true;
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    public long getFramesRecordedNextSceneBridge() {
        return this.m_Description.getFramesRecordedToNext();
    }

    public long getTimeToNextSceneBridge() {
        long longFrames = -1L;
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP == null) {
            return 0L;
        }
        if (this.m_Description.getFramesRecordedToNext() > 0L) {
            longFrames = this.m_Description.getFramesRecordedToNext();
        } else if (this.m_FramesToNextSceneBridge > 0L) {
            longFrames = this.m_FramesToNextSceneBridge;
        }
        long longTime = longFrames <= 0L ? 0L : (long)((double)longFrames * o_LiveShowVIP.getFrameTime());
        return longTime;
    }

    public void setFramePositionPre(long p_FramePositionPre) {
        this.m_FramePositionPre = p_FramePositionPre;
    }

    public long getFramePositionPre() {
        return this.m_FramePositionPre;
    }

    @Override
    public long getSourceFrameLength() {
        return -1L;
    }

    @Override
    public LiveShowObjectPanel createLiveShowObjectPanel(boolean p_Resizable) {
        return null;
    }

    @Override
    public void eventPlayStart(Play p_Play) {
    }

    @Override
    public void eventPlayStop(Play p_Play) {
    }

    @Override
    public void eventPlayPause(Play p_Play) {
    }

    @Override
    public void eventPlayRewind(Play p_Play) {
    }

    @Override
    public void eventPlayFastForward(Play p_Play) {
    }

    @Override
    public void eventPlayCursorSet(Play p_Play, long p_PlayCursor) {
        boolean boolInsideBridge = false;
        if (p_PlayCursor >= this.getFrameStart() && p_PlayCursor < this.getFrameStart() + this.getFrameLength()) {
            boolInsideBridge = true;
        }
        this.m_PlayCursorJustSet = true;
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP == null) {
            return;
        }
        if (!boolInsideBridge) {
            if (o_LiveShowVIP.getLiveShowSceneBridge_Actual() == this) {
                this.stopSceneBridge();
                this.m_PlayCursorJustSet = false;
            }
            return;
        }
    }

    @Override
    public void eventEditModeOn(Play p_Play, boolean p_EditModeOn) {
    }

    @Override
    public void eventEditCursorSet(Play p_Play, long p_EditCursor) {
    }

    public void setJumpedInternal(boolean p_Check) {
        this.m_JumpedInternal = p_Check;
    }

    @Override
    public long eventPlayCheckRead(Play p_Play, long p_FrameStart, long p_FramesToRead) {
        boolean boolInsideBridge = false;
        boolean boolStop = false;
        boolean boolWillStopAtSceneBridge = false;
        boolean boolNotActive = false;
        long longNewFramesToRead = p_FramesToRead;
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP == null) {
            this.m_OldReadPosition = p_FrameStart;
            longNewFramesToRead = 0L;
            return longNewFramesToRead;
        }
        Play o_Play = this.m_Play;
        if (o_Play == null) {
            this.m_OldReadPosition = p_FrameStart;
            longNewFramesToRead = 0L;
            return longNewFramesToRead;
        }
        if (this.m_Overlap) {
            return p_FramesToRead;
        }
        if (p_FrameStart < this.getFrameStart() && p_FrameStart + p_FramesToRead >= this.getFrameStart()) {
            boolInsideBridge = false;
            longNewFramesToRead = this.getFrameStart() - p_FrameStart;
            if (this.getActive()) {
                if (this.getJumpActive() && this.getJumpPossible() && this.getJumpSceneBridge() != null) {
                    if (this.getJumpSceneBridge().getStopAtStart()) {
                        boolWillStopAtSceneBridge = true;
                    }
                } else if (this.getStopAtStart()) {
                    boolWillStopAtSceneBridge = true;
                }
            } else {
                LiveShowSceneBridge o_LiveShowSceneBridge_Next = o_LiveShowVIP.getLiveShowSceneBridge_NextToPlay(p_FrameStart, false);
                if (o_LiveShowSceneBridge_Next == null) {
                    boolWillStopAtSceneBridge = true;
                } else if (o_LiveShowSceneBridge_Next.getStopAtStart()) {
                    boolWillStopAtSceneBridge = true;
                }
            }
        } else if (p_FrameStart >= this.getFrameStart() && p_FrameStart < this.getFrameStart() + this.getFrameLength()) {
            if (p_FrameStart + p_FramesToRead >= this.getFrameStart() + this.getFrameLength()) {
                longNewFramesToRead = this.getFrameStart() + this.getFrameLength() - p_FrameStart;
            }
            boolInsideBridge = true;
        }
        if (boolWillStopAtSceneBridge) {
            p_Play.setWillStopAtSceneBridge(this);
        }
        if (!boolInsideBridge) {
            this.m_OldReadPosition = p_FrameStart;
            return longNewFramesToRead;
        }
        if (o_Play.isRunning() && this.m_OldReadPosition < this.getFrameStart() && o_LiveShowVIP.getLiveShowSceneBridge_Actual() != this) {
            if (!this.getActive()) {
                longNewFramesToRead = 0L;
                boolNotActive = true;
            }
            if (this.getStopAtStart()) {
                longNewFramesToRead = 0L;
                boolStop = true;
            }
        }
        this.m_OldReadPosition = boolNotActive ? p_FrameStart : (boolStop ? this.getFrameStart() : p_FrameStart);
        return longNewFramesToRead;
    }

    public LiveShowSceneBridge findJumpSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge, long p_PlayCursor) {
        LiveShowSceneBridge o_JumpSceneBridge;
        if (p_LiveShowSceneBridge == null) {
            return null;
        }
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP == null) {
            return null;
        }
        if (p_LiveShowSceneBridge.getActive() ? (o_JumpSceneBridge = p_LiveShowSceneBridge.getJumpSceneBridge()) == null || !p_LiveShowSceneBridge.getJumpActive() || !p_LiveShowSceneBridge.getJumpPossible() : (o_JumpSceneBridge = o_LiveShowVIP.getLiveShowSceneBridge_NextToPlay(p_PlayCursor, false)) == null) {
            return null;
        }
        if (!o_JumpSceneBridge.getActive() || o_JumpSceneBridge.getJumpSceneBridge() != null && o_JumpSceneBridge.getJumpActive() && o_JumpSceneBridge.getJumpPossible()) {
            o_JumpSceneBridge = o_JumpSceneBridge.findJumpSceneBridge(o_JumpSceneBridge, o_JumpSceneBridge.getFrameStart());
        }
        return o_JumpSceneBridge;
    }

    @Override
    public void eventPlayCursor(Play p_Play, long p_OldPlayCursor, long p_PlayCursor) {
        LiveShowObject o_JumpSceneBridge = null;
        boolean boolInsideBridge = false;
        boolean boolStop = false;
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP == null) {
            return;
        }
        Play o_Play = this.m_Play;
        if (o_Play == null) {
            return;
        }
        if (this.m_Overlap) {
            return;
        }
        boolInsideBridge = this.isCursorPositionInside(p_PlayCursor);
        if (!boolInsideBridge) {
            if (!this.m_PlayCursorJustSet) {
                this.m_OldPlayCursor = p_PlayCursor;
            }
            this.m_PlayCursorJustSet = false;
            if (o_LiveShowVIP.getLiveShowSceneBridge_Actual() != this || this.m_IsPlaying) {
                // empty if block
            }
            return;
        }
        if (p_Play.isRunning() && this.m_OldPlayCursor <= this.getFrameStart() && (o_LiveShowVIP.getLiveShowSceneBridge_Actual() != this || this.m_JumpedInternal)) {
            this.m_JumpedInternal = false;
            o_JumpSceneBridge = this.findJumpSceneBridge(this, p_PlayCursor);
            if (o_JumpSceneBridge != null) {
                this.stopSceneBridge();
                boolean boolInternalJump = o_JumpSceneBridge.getStopAtStart();
                o_LiveShowVIP.gotoSceneBridge((LiveShowSceneBridge)o_JumpSceneBridge, false, boolInternalJump);
            } else if (!this.getActive()) {
                this.startSceneBridge(false);
                o_Play.stopAtBridge();
                o_Play.setPlayCursor(this.getFrameStart());
                boolStop = true;
            } else {
                if (o_LiveShowVIP.getLiveShowSceneBridge_Actual() != null) {
                    o_LiveShowVIP.getLiveShowSceneBridge_Actual().stopSceneBridge();
                }
                if (this.getStopAtStart()) {
                    this.startSceneBridge(false);
                    this.setPlayPreObject(false);
                    o_Play.stopAtBridge();
                    o_Play.setPlayCursor(this.getFrameStart());
                    boolStop = true;
                } else {
                    this.startSceneBridge(true);
                }
            }
        } else if (!o_Play.isRunning()) {
            this.m_JumpedInternal = false;
            this.startSceneBridge(true);
        }
        this.m_OldPlayCursor = boolStop ? (o_JumpSceneBridge != null ? o_JumpSceneBridge.getFrameStart() : this.getFrameStart()) : p_PlayCursor;
    }

    @Override
    public void eventPlayClosing(Play p_Play) {
    }

    @Override
    public void eventPlayError(Play p_Play, Exception p_Exception, String p_Remark) {
    }

    @Override
    public void eventPlayTimelineEnd(Play p_Play) {
    }

    @Override
    public void eventEndOfAction(LiveShowVIP p_ActorLiveShowVIP, boolean p_Success, int p_Action) {
        if (this.m_ChangedSinceLastAction && !this.getIsMainBridge()) {
            this.changeRemote_Bridge(this);
        }
        super.eventEndOfAction(p_ActorLiveShowVIP, p_Success, p_Action);
    }

    public void setJumpSceneBridge(LiveShowSceneBridge p_JumpSceneBridge) {
        LiveShowSceneBridge o_JumpSceneBridge;
        if (this.m_LiveShowVIP == null) {
            return;
        }
        if (p_JumpSceneBridge == this) {
            p_JumpSceneBridge = null;
        }
        if ((o_JumpSceneBridge = this.m_JumpSceneBridge) == p_JumpSceneBridge) {
            return;
        }
        this.m_ChangedSinceLastAction = true;
        if (o_JumpSceneBridge != null) {
            o_JumpSceneBridge.removeLiveShowObjectListener(this);
        }
        if ((o_JumpSceneBridge = (this.m_JumpSceneBridge = p_JumpSceneBridge)) != null) {
            this.m_Description.setJumpID(o_JumpSceneBridge.getID());
            if (o_JumpSceneBridge.getActive()) {
                this.m_Description.setJumpPossible(true);
            } else {
                this.m_Description.setJumpPossible(false);
            }
            o_JumpSceneBridge.addLiveShowObjectListener(this);
        } else {
            this.m_Description.setJumpID(null);
            this.m_Description.setJumpActive(false);
            this.m_Description.setJumpPossible(false);
        }
        this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
    }

    public LiveShowSceneBridge getJumpSceneBridge() {
        return this.m_JumpSceneBridge;
    }

    public void setJumpActive(boolean p_LoopActive) {
        if (this.m_Description.getJumpID() == null) {
            p_LoopActive = false;
        }
        if (this.m_Description.getJumpActive() == p_LoopActive) {
            return;
        }
        this.m_ChangedSinceLastAction = true;
        this.m_Description.setJumpActive(p_LoopActive);
        this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
    }

    public boolean getJumpActive() {
        return this.m_Description.getJumpActive();
    }

    public boolean getJumpPossible() {
        return this.m_Description.getJumpPossible();
    }

    @Override
    public void refreshJumps() {
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP == null) {
            return;
        }
        LiveShowSceneBridge oldLiveShowSceneBridge = this.m_JumpSceneBridge;
        LiveShowSceneBridge o_JumpSceneBridge = this.m_JumpSceneBridge;
        if (o_JumpSceneBridge != null) {
            o_JumpSceneBridge.removeLiveShowObjectListener(this);
        }
        if (this.m_Description.getJumpID() != null) {
            this.m_JumpSceneBridge = o_LiveShowVIP.getLiveShowSceneBridge(this.m_Description.getJumpID());
            if (this.m_JumpSceneBridge == this) {
                this.m_JumpSceneBridge = null;
            }
        } else {
            this.m_JumpSceneBridge = null;
        }
        if ((o_JumpSceneBridge = this.m_JumpSceneBridge) != null) {
            o_JumpSceneBridge.addLiveShowObjectListener(this);
            if (o_JumpSceneBridge.getActive()) {
                this.m_Description.setJumpPossible(true);
            } else {
                this.m_Description.setJumpPossible(false);
            }
        } else {
            this.m_JumpSceneBridge = null;
            this.m_Description.setJumpPossible(false);
        }
        if (o_JumpSceneBridge != oldLiveShowSceneBridge) {
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    @Override
    public void eventObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowObjectInterface != null && p_LiveShowObjectInterface == this.m_JumpSceneBridge) {
            if (p_LiveShowObjectInterface.getActive()) {
                this.m_Description.setJumpPossible(true);
            } else {
                this.m_Description.setJumpPossible(false);
            }
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    @Override
    public void eventObjectVolumeChanged(LiveShowObjectInterface p_LiveShowObjectInterface, float p_Volume) {
    }

    @Override
    public void eventObjectAdditionalChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
    }

    @Override
    public void eventObjectClosed(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == this.m_JumpSceneBridge) {
            if (this.m_JumpSceneBridge != null) {
                this.m_JumpSceneBridge.removeLiveShowObjectListener(this);
            }
            this.m_JumpSceneBridge = null;
            this.m_Description.setJumpPossible(false);
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    @Override
    public void eventObjectSelection(LiveShowObjectInterface p_LiveShowObjectInterface, boolean p_IsSelected, boolean p_Added) {
    }

    public boolean getIsMainBridge() {
        return this.m_Description.getIsMainBridge();
    }

    public LiveShowSceneBridgeMain getLiveShowSceneBridgeMain() {
        return this.m_LiveShowSceneBridgeMain;
    }

    public void setLiveShowSceneBridgeMain(LiveShowSceneBridgeMain p_LiveShowSceneBridgeMain) {
        LiveShowSceneBridgeMain oldLiveShowSceneBridgeMain = this.m_LiveShowSceneBridgeMain;
        this.m_LiveShowSceneBridgeMain = p_LiveShowSceneBridgeMain;
        if (this.m_LiveShowSceneBridgeMain != null) {
            this.m_Description.setIsMainBridge(true);
        } else {
            this.m_Description.setIsMainBridge(false);
        }
        if (oldLiveShowSceneBridgeMain != this.m_LiveShowSceneBridgeMain) {
            this.m_ChangedSinceLastAction = true;
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    public static TableAndListModel.ListRenderer getSceneBridgeCellRenderer() {
        return s_SceneBridgeCellRenderer;
    }

    public abstract String getRemoteGroupName();

    public void addRemote_Bridge(LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowSceneBridge == null) {
            return;
        }
        String stringID = p_LiveShowSceneBridge.getID();
        if (this.m_SPIT_Object_Interface != null) {
            return;
        }
        SPIT_Type_Interface o_SPIT_Type_Interface = SPITRemote.createServerRemoteSPIT_Type((String)stringID, (String)this.getRemoteGroupName(), (String)p_LiveShowSceneBridge.getName(), (boolean)false);
        SPITRemote.addRemoteSPIT_Type((SPIT_Type_Interface)o_SPIT_Type_Interface);
        this.m_SPIT_Object_Interface = SPITRemote.createServerRemoteSPIT_Object((SPIT_Type_Interface)o_SPIT_Type_Interface, (String)stringID, (String)"play", (byte)0);
        if (this.m_SPIT_Object_Interface != null) {
            this.m_SPIT_Object_Interface.setFrameStart(p_LiveShowSceneBridge.getFrameStart());
            this.m_SPIT_Object_Interface.setFrameLength(p_LiveShowSceneBridge.getFrameLength());
            this.m_SPIT_Object_Interface.setSPIT_Action_Interface((SPIT_Action_Interface)this, null);
            SPITRemote.addRemoteSPIT_Object((SPIT_Object_Interface)this.m_SPIT_Object_Interface);
        }
        this.m_RemoteAction = PlayRemoteActions.createRemoteAction(p_LiveShowSceneBridge, s_Icon, "SceneBridge", "actionPlay", stringID, p_LiveShowSceneBridge.getName(), p_LiveShowSceneBridge.getFrameStart());
    }

    public void removeRemote_Bridge(LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowSceneBridge == null) {
            return;
        }
        if (this.m_SPIT_Object_Interface != null) {
            SPIT_Type_Interface o_SPIT_Type_Interface = this.m_SPIT_Object_Interface.getSPIT_Type();
            SPITRemote.removeRemoteSPIT_Object((SPIT_Object_Interface)this.m_SPIT_Object_Interface);
            SPITRemote.removeRemoteSPIT_Type((SPIT_Type_Interface)o_SPIT_Type_Interface);
            this.m_SPIT_Object_Interface = null;
        }
        PlayRemoteActions.removeRemoteAction(this.m_RemoteAction);
        this.m_RemoteAction = null;
    }

    public void changeRemote_Bridge(LiveShowSceneBridge p_LiveShowSceneBridge) {
        SPIT_Type_Interface o_SPIT_Type_Interface;
        if (p_LiveShowSceneBridge == null) {
            return;
        }
        if (this.m_SPIT_Object_Interface != null && (o_SPIT_Type_Interface = this.m_SPIT_Object_Interface.getSPIT_Type()) != null) {
            o_SPIT_Type_Interface.setName(p_LiveShowSceneBridge.getName());
            this.m_SPIT_Object_Interface.setFrameStart(p_LiveShowSceneBridge.getFrameStart());
            this.m_SPIT_Object_Interface.setFrameLength(p_LiveShowSceneBridge.getFrameLength());
        }
        if (this.m_RemoteAction != null) {
            this.m_RemoteAction.setSourceName(p_LiveShowSceneBridge.getName());
            this.m_RemoteAction.setSourcePosition(p_LiveShowSceneBridge.getFrameStart());
        }
    }

    public void playStarted(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_ActionObject) {
    }

    public void play(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_ActionObject) {
        if (!this.getActive()) {
            return;
        }
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP == null) {
            return;
        }
        Play o_Play = o_LiveShowVIP.getPlay();
        if (o_Play == null) {
            return;
        }
        Play.PlaySynchronisizer o_PlaySynchronisizer = o_Play.getPlaySynchronizer();
        if (o_PlaySynchronisizer == null) {
            return;
        }
        o_LiveShowVIP.gotoSceneBridge(p_SPIT_Object_Interface.getID(), true, false);
        o_PlaySynchronisizer.actionStartPlaysSceneBridge();
    }

    public void playEnd(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_ActionObject) {
    }

    @Override
    public void doAction(PlayRemoteActions.RemoteAction p_RemoteAction, double p_Value) {
        if (p_RemoteAction == null) {
            return;
        }
        if (!this.getActive()) {
            return;
        }
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP == null) {
            return;
        }
        Play o_Play = o_LiveShowVIP.getPlay();
        if (o_Play == null) {
            return;
        }
        Play.PlaySynchronisizer o_PlaySynchronisizer = o_Play.getPlaySynchronizer();
        if (o_PlaySynchronisizer == null) {
            return;
        }
        o_LiveShowVIP.gotoSceneBridge(this.getID(), true, false);
        o_PlaySynchronisizer.actionStartPlaysSceneBridge();
    }
}

