/*
 * Decompiled with CFR 0.152.
 */
package LiveShowScrollPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.PlayListener;
import LiveShowScrollPackage.LiveShowScrollBarListener;
import LiveShowScrollPackage.LiveShowViewListener;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import SynchronizationPackage.LiveCloseSemaphore;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ScrollBarUI;

public class LiveShowScrollBarPanel
extends JPanel
implements PlayListener,
LiveShowViewListener {
    public static Color BUTTON_DEFAULTBACKGROUND;
    public static Color s_Color_AutomaticOn;
    public static Color s_Color_AutomaticBlocked;
    public static Color s_Color_AutomaticOff;
    public static Icon s_AutomaticOn;
    public static Icon s_AutomaticBlocked;
    public static Icon s_AutomaticOff;
    private long m_FrameStart;
    private long m_FrameEnd;
    private long m_VisibleFrameStart;
    private long m_VisibleFrameEnd;
    private long m_FrameCursor;
    private boolean m_AutoScroll;
    private boolean m_AutoScrollBlocked;
    private boolean m_ScrollbarCalculating;
    private boolean m_ScrollbarAdjusting;
    private double m_Zoom;
    private double m_ZoomChange;
    private ArrayList<LiveShowScrollBarListener> m_Listeners;
    private final Object m_SynListeners = new Object();
    private Runnable m_Runnable_AdjustViewToPlayCursor = new Runnable(){

        @Override
        public void run() {
            try {
                LiveShowScrollBarPanel.this.adjustViewToPlayCursor(false);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    };
    private LiveCloseSemaphore m_LiveCloseSemaphore;
    private long m_VisibleFrameStart_New;
    private long m_VisibleFrameEnd_New;
    private Runnable m_RunnableNotifyScrollBarListeners = new Runnable(){

        @Override
        public void run() {
            LiveShowScrollBarPanel.this.notifyScrollBarListener_VisibleRegion(LiveShowScrollBarPanel.this.m_VisibleFrameStart_New, LiveShowScrollBarPanel.this.m_VisibleFrameEnd_New);
        }
    };
    private JButton jButton_AutoScroll;
    private JButton jButton_ZoomMinus;
    private JButton jButton_ZoomPlus;
    private JScrollBar jScrollBar_View;

    public LiveShowScrollBarPanel() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        this.changeAutoScroll(this.m_AutoScroll, this.m_AutoScrollBlocked);
        LiveLanguage.addLanguageListener(this, null);
        SwingUtilities.updateComponentTreeUI(this);
    }

    private void initMembers() {
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        BUTTON_DEFAULTBACKGROUND = new Color(240, 240, 240);
        this.m_Zoom = 1.0;
        this.m_ZoomChange = 2.0;
        this.m_AutoScroll = true;
        this.m_AutoScrollBlocked = false;
        this.m_ScrollbarCalculating = false;
        this.m_ScrollbarAdjusting = false;
        this.m_VisibleFrameStart = 0L;
        this.m_VisibleFrameEnd = 1L;
        this.m_FrameStart = 0L;
        this.m_FrameEnd = 1L;
        this.m_FrameCursor = 0L;
        this.m_Listeners = new ArrayList();
    }

    private void initComponentsFurther() {
        this.jButton_AutoScroll.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_ZoomMinus.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_ZoomPlus.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    public void setScrollBarUI(ScrollBarUI p_ScrollBarUI) {
        this.jScrollBar_View.setUI(p_ScrollBarUI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        EventQueueHandler.removeRunnable(this.m_Runnable_AdjustViewToPlayCursor);
        Object object = this.m_SynListeners;
        synchronized (object) {
            if (this.m_Listeners != null) {
                this.m_Listeners.clear();
                this.m_Listeners = null;
            }
        }
        this.jButton_AutoScroll.setComponentPopupMenu(null);
        this.jButton_ZoomMinus.setComponentPopupMenu(null);
        this.jButton_ZoomPlus.setComponentPopupMenu(null);
        this.m_LiveCloseSemaphore.leaveCloseSection();
        LiveLanguage.removeLanguageListener(this);
    }

    private void initComponents() {
        this.jScrollBar_View = new JScrollBar();
        this.jButton_ZoomPlus = new JButton();
        this.jButton_ZoomMinus = new JButton();
        this.jButton_AutoScroll = new JButton();
        this.setMinimumSize(new Dimension(83, 26));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(126, 26));
        this.setLayout(new GridBagLayout());
        this.jScrollBar_View.setMaximum(10000);
        this.jScrollBar_View.setOrientation(0);
        this.jScrollBar_View.setMinimumSize(new Dimension(5, 16));
        this.jScrollBar_View.setPreferredSize(new Dimension(48, 16));
        this.jScrollBar_View.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                LiveShowScrollBarPanel.this.jScrollBar_ViewAdjustmentValueChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.jScrollBar_View, gridBagConstraints);
        this.jButton_ZoomPlus.setFont(new Font("Tahoma", 0, 12));
        this.jButton_ZoomPlus.setText("+");
        this.jButton_ZoomPlus.setToolTipText("");
        this.jButton_ZoomPlus.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_ZoomPlus.setMaximumSize(new Dimension(16, 16));
        this.jButton_ZoomPlus.setMinimumSize(new Dimension(16, 16));
        this.jButton_ZoomPlus.setPreferredSize(new Dimension(16, 16));
        this.jButton_ZoomPlus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowScrollBarPanel.this.jButton_ZoomPlusActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.add((Component)this.jButton_ZoomPlus, gridBagConstraints);
        this.jButton_ZoomMinus.setFont(new Font("Tahoma", 0, 12));
        this.jButton_ZoomMinus.setText("-");
        this.jButton_ZoomMinus.setToolTipText("");
        this.jButton_ZoomMinus.setHorizontalTextPosition(0);
        this.jButton_ZoomMinus.setIconTextGap(0);
        this.jButton_ZoomMinus.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_ZoomMinus.setMaximumSize(new Dimension(16, 16));
        this.jButton_ZoomMinus.setMinimumSize(new Dimension(16, 16));
        this.jButton_ZoomMinus.setPreferredSize(new Dimension(16, 16));
        this.jButton_ZoomMinus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowScrollBarPanel.this.jButton_ZoomMinusActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.add((Component)this.jButton_ZoomMinus, gridBagConstraints);
        this.jButton_AutoScroll.setFont(new Font("Tahoma", 0, 12));
        this.jButton_AutoScroll.setForeground(new Color(0, 0, 1));
        this.jButton_AutoScroll.setText("A");
        this.jButton_AutoScroll.setToolTipText("");
        this.jButton_AutoScroll.setHorizontalTextPosition(0);
        this.jButton_AutoScroll.setIconTextGap(0);
        this.jButton_AutoScroll.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_AutoScroll.setMaximumSize(new Dimension(16, 16));
        this.jButton_AutoScroll.setMinimumSize(new Dimension(16, 16));
        this.jButton_AutoScroll.setPreferredSize(new Dimension(16, 16));
        this.jButton_AutoScroll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowScrollBarPanel.this.jButton_AutoScrollActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.add((Component)this.jButton_AutoScroll, gridBagConstraints);
    }

    private void jScrollBar_ViewAdjustmentValueChanged(AdjustmentEvent evt) {
        if (this.m_ScrollbarCalculating) {
            return;
        }
        this.m_ScrollbarAdjusting = true;
        int intValue = this.jScrollBar_View.getValue();
        long longVisibleLength = this.m_VisibleFrameEnd - this.m_VisibleFrameStart;
        long longMaximalLength = this.m_FrameEnd - this.m_FrameStart;
        long longVisibleStart = this.m_FrameStart + (long)((double)intValue / (double)(this.jScrollBar_View.getMaximum() - this.jScrollBar_View.getMinimum()) * (double)longMaximalLength);
        long longVisibleEnd = longVisibleStart + longVisibleLength;
        this.notifyScrollBarListener_VisibleRegion(longVisibleStart, longVisibleEnd);
        if (this.m_FrameCursor < longVisibleStart || this.m_FrameCursor > longVisibleEnd) {
            this.changeAutoScroll(this.m_AutoScroll, true);
        } else {
            this.changeAutoScroll(this.m_AutoScroll, false);
        }
        this.m_ScrollbarAdjusting = false;
        this.m_VisibleFrameStart = longVisibleStart;
        this.m_VisibleFrameEnd = longVisibleEnd;
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jButton_ZoomPlusActionPerformed(ActionEvent evt) {
        if (this.m_AutoScroll && !this.m_AutoScrollBlocked) {
            this.zoomPlus(true, this.m_FrameCursor);
        } else {
            this.zoomPlus(false, (this.m_VisibleFrameEnd - this.m_VisibleFrameStart) / 2L);
        }
    }

    private void jButton_ZoomMinusActionPerformed(ActionEvent evt) {
        boolean boolAdjustPlayCursor = false;
        if (this.m_AutoScroll && !this.m_AutoScrollBlocked) {
            this.zoomMinus(boolAdjustPlayCursor, this.m_FrameCursor);
        } else {
            this.zoomMinus(false, (this.m_VisibleFrameEnd - this.m_VisibleFrameStart) / 2L);
        }
    }

    private void jButton_AutoScrollActionPerformed(ActionEvent evt) {
        if (!this.m_AutoScrollBlocked) {
            this.changeAutoScroll(!this.m_AutoScroll, false);
        } else {
            this.changeAutoScroll(true, false);
        }
    }

    public void setAutoScroll(boolean p_AutoScroll) {
        if (this.m_AutoScroll == p_AutoScroll) {
            return;
        }
        this.changeAutoScroll(p_AutoScroll, this.m_AutoScrollBlocked);
    }

    public void setAutoscrollBlocked(boolean p_AutoScrollBlocked) {
        this.changeAutoScroll(this.m_AutoScroll, p_AutoScrollBlocked);
    }

    private void changeAutoScroll(boolean p_AutoScroll, boolean p_AutoScrollBlocking) {
        if (this.m_AutoScroll != p_AutoScroll || this.m_AutoScrollBlocked != p_AutoScrollBlocking) {
            if (this.m_AutoScroll != p_AutoScroll) {
                if (!this.m_AutoScroll) {
                    this.m_AutoScroll = true;
                    this.m_AutoScrollBlocked = false;
                } else {
                    this.m_AutoScroll = false;
                    this.m_AutoScrollBlocked = false;
                }
            } else if (this.m_AutoScrollBlocked != p_AutoScrollBlocking) {
                this.m_AutoScrollBlocked = p_AutoScrollBlocking;
            }
            if (this.m_AutoScroll && !this.m_AutoScrollBlocked) {
                this.adjustViewToPlayCursor(true);
            }
        }
        if (this.m_AutoScroll) {
            if (!this.m_AutoScrollBlocked) {
                this.jButton_AutoScroll.setBackground(s_Color_AutomaticOn);
            } else {
                this.jButton_AutoScroll.setBackground(s_Color_AutomaticBlocked);
            }
        } else {
            this.jButton_AutoScroll.setBackground(s_Color_AutomaticOff);
        }
    }

    private void adjustViewToPlayCursor(boolean p_FetchPlayCursor) {
        if (this.m_AutoScroll && !this.m_AutoScrollBlocked) {
            long longVisibleLength = this.m_VisibleFrameEnd - this.m_VisibleFrameStart;
            long longFrameThreshold = longVisibleLength / 10L;
            if ((this.m_FrameCursor > this.m_VisibleFrameEnd - longFrameThreshold || p_FetchPlayCursor) && this.m_VisibleFrameEnd < this.m_FrameEnd) {
                this.m_VisibleFrameStart_New = this.m_FrameCursor - longFrameThreshold;
                this.m_VisibleFrameEnd_New = this.m_FrameCursor + longVisibleLength - longFrameThreshold;
                EventQueueHandler.invokeLater(this.m_RunnableNotifyScrollBarListeners);
            } else if ((this.m_FrameCursor < this.m_VisibleFrameStart || p_FetchPlayCursor) && this.m_VisibleFrameStart > this.m_FrameStart) {
                this.m_VisibleFrameStart_New = this.m_FrameCursor - longFrameThreshold;
                this.m_VisibleFrameEnd_New = this.m_FrameCursor + longVisibleLength - longFrameThreshold;
                EventQueueHandler.invokeLater(this.m_RunnableNotifyScrollBarListeners);
            }
        }
    }

    public void calculateScrollBar(long p_FrameStart, long p_FrameEnd, long p_VisibleFrameStart, long p_VisibleFrameEnd) {
        this.m_ScrollbarCalculating = true;
        this.m_FrameStart = p_FrameStart;
        this.m_FrameEnd = p_FrameEnd;
        this.m_VisibleFrameStart = p_VisibleFrameStart;
        this.m_VisibleFrameEnd = p_VisibleFrameEnd;
        long longMaximalLength = this.m_FrameEnd - this.m_FrameStart;
        long longVisibleLength = this.m_VisibleFrameEnd - this.m_VisibleFrameStart;
        if (longMaximalLength <= 0L || longVisibleLength <= 0L) {
            return;
        }
        this.m_Zoom = (double)longMaximalLength / (double)longVisibleLength;
        if (this.m_Zoom < 1.0) {
            this.m_Zoom = 1.0;
        }
        int intBarWidth = (int)((double)(this.jScrollBar_View.getMaximum() - this.jScrollBar_View.getMinimum()) / this.m_Zoom);
        int intValue = (int)((double)(this.m_VisibleFrameStart - this.m_FrameStart) / (double)longMaximalLength * (double)(this.jScrollBar_View.getMaximum() - this.jScrollBar_View.getMinimum()));
        if (intValue < 0) {
            intValue = 0;
        }
        if (intValue + intBarWidth > this.jScrollBar_View.getMaximum()) {
            intValue = this.jScrollBar_View.getMaximum() - intBarWidth;
        }
        this.jScrollBar_View.setValues(intValue, intBarWidth, this.jScrollBar_View.getMinimum(), this.jScrollBar_View.getMaximum());
        int intUnitIncrement = (int)((double)(this.jScrollBar_View.getMaximum() - this.jScrollBar_View.getMinimum()) / this.m_Zoom / 5.0);
        if (intUnitIncrement <= 0) {
            intUnitIncrement = 1;
        }
        this.jScrollBar_View.setUnitIncrement(intUnitIncrement);
        this.m_ScrollbarCalculating = false;
    }

    public void zoomVisibleRegion(long p_VisibleRegionStart, long p_VisibleRegionEnd) {
        this.notifyScrollBarListener_VisibleRegion(p_VisibleRegionStart, p_VisibleRegionEnd);
    }

    public long getVisibleFrameStart() {
        return this.m_VisibleFrameStart;
    }

    public long getVisibleFrameEnd() {
        return this.m_VisibleFrameEnd;
    }

    public void setZoomChange(double p_ZoomFactor) {
        if (p_ZoomFactor <= 0.0) {
            return;
        }
        this.m_ZoomChange = p_ZoomFactor;
    }

    public double getZoomChange() {
        return this.m_ZoomChange;
    }

    public void zoomPlus(boolean p_AdjustFramePosition, long p_FramePosition) {
        this.m_Zoom *= this.m_ZoomChange;
        if (this.m_Zoom < 1.0) {
            this.m_Zoom = 1.0;
        }
        long longOldVisibleLength = this.m_VisibleFrameEnd - this.m_VisibleFrameStart;
        long longVisibleMiddle = this.m_VisibleFrameStart + longOldVisibleLength / 2L;
        long longNewVisibleLength = (long)((double)(this.m_FrameEnd - this.m_FrameStart) / this.m_Zoom);
        long longVisibleStart = p_AdjustFramePosition ? p_FramePosition - longNewVisibleLength / 2L : p_FramePosition - (long)((double)(p_FramePosition - this.m_VisibleFrameStart) / (double)longOldVisibleLength * (double)longNewVisibleLength);
        if (this.m_FrameCursor < longVisibleStart || this.m_FrameCursor > longVisibleStart + longNewVisibleLength) {
            this.changeAutoScroll(this.m_AutoScroll, true);
        } else {
            this.changeAutoScroll(this.m_AutoScroll, false);
        }
        this.notifyScrollBarListener_VisibleRegion(longVisibleStart, longVisibleStart + longNewVisibleLength);
    }

    public void zoomMinus(boolean p_AdjustFramePosition, long p_FramePosition) {
        this.m_Zoom /= this.m_ZoomChange;
        if (this.m_Zoom < 1.0) {
            this.m_Zoom = 1.0;
        }
        long longOldVisibleLength = this.m_VisibleFrameEnd - this.m_VisibleFrameStart;
        long longVisibleMiddle = this.m_VisibleFrameStart + longOldVisibleLength / 2L;
        long longNewVisibleLength = (long)((double)(this.m_FrameEnd - this.m_FrameStart) / this.m_Zoom);
        long longVisibleStart = p_AdjustFramePosition ? p_FramePosition - longNewVisibleLength / 2L : p_FramePosition - (long)((double)(p_FramePosition - this.m_VisibleFrameStart) / (double)longOldVisibleLength * (double)longNewVisibleLength);
        if (this.m_FrameCursor < longVisibleStart || this.m_FrameCursor > longVisibleStart + longNewVisibleLength) {
            this.changeAutoScroll(this.m_AutoScroll, true);
        } else {
            this.changeAutoScroll(this.m_AutoScroll, false);
        }
        this.notifyScrollBarListener_VisibleRegion(longVisibleStart, longVisibleStart + longNewVisibleLength);
    }

    public void zoomReset() {
        this.m_Zoom = 1.0;
        long longNewVisibleLength = (long)((double)(this.m_FrameEnd - this.m_FrameStart) / this.m_Zoom);
        this.notifyScrollBarListener_VisibleRegion(0L, longNewVisibleLength);
    }

    public double getZoomFactor() {
        return this.m_Zoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLiveShowScrollBarListener(LiveShowScrollBarListener p_LiveShowScrollBarListener) {
        if (p_LiveShowScrollBarListener == null) {
            return false;
        }
        Object object = this.m_SynListeners;
        synchronized (object) {
            if (this.m_Listeners == null) {
                return false;
            }
            if (this.m_Listeners.contains(p_LiveShowScrollBarListener)) {
                return true;
            }
            this.m_Listeners.add(p_LiveShowScrollBarListener);
        }
        this.calculateScrollBar(p_LiveShowScrollBarListener.getFrameStart(), p_LiveShowScrollBarListener.getFrameEnd(), p_LiveShowScrollBarListener.getVisibleFrameStart(), p_LiveShowScrollBarListener.getVisibleFrameEnd());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLiveShowScrollBarListener(LiveShowScrollBarListener p_LiveShowScrollBarListener) {
        if (p_LiveShowScrollBarListener == null) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = this.m_SynListeners;
        synchronized (object) {
            if (this.m_Listeners == null) {
                return false;
            }
            boolRemoved = this.m_Listeners.remove(p_LiveShowScrollBarListener);
        }
        p_LiveShowScrollBarListener.removeLiveShowViewListener(this);
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyScrollBarListener_VisibleRegion(long p_VisibleFrameStart, long p_VisibleFrameEnd) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        ArrayList<LiveShowScrollBarListener> o_Listeners = null;
        Object object = this.m_SynListeners;
        synchronized (object) {
            if (this.m_Listeners != null) {
                o_Listeners = new ArrayList<LiveShowScrollBarListener>(this.m_Listeners.size());
                o_Listeners.addAll(this.m_Listeners);
            }
        }
        if (o_Listeners != null) {
            for (int intListener = 0; intListener < o_Listeners.size(); ++intListener) {
                LiveShowScrollBarListener o_Listener = (LiveShowScrollBarListener)o_Listeners.get(intListener);
                o_Listener.setVisibleRegion(p_VisibleFrameStart, p_VisibleFrameEnd);
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void eventPlayStart(Play p_Play) {
    }

    @Override
    public void eventPlayStop(Play p_Play) {
    }

    @Override
    public void eventPlayPause(Play p_Play) {
    }

    @Override
    public void eventPlayRewind(Play p_Play) {
    }

    @Override
    public void eventPlayFastForward(Play p_Play) {
    }

    @Override
    public void eventPlayFadePossibility(Play p_Play, boolean p_FadeInPossible, boolean p_FadeOutPossible, double p_FadeProgress) {
    }

    @Override
    public void eventPlayFadedIn(Play p_Play, boolean p_FadedIn, double p_FadeProgress) {
    }

    @Override
    public void eventPlayCursorSet(Play p_Play, long p_PlayCursor) {
    }

    @Override
    public void eventEditModeOn(Play p_Play, boolean p_EditModeOn) {
        if (p_Play == null) {
            return;
        }
        this.m_FrameCursor = p_Play.getEditModeOn() ? p_Play.getEditCursor() : p_Play.getPlayCursor();
        this.adjustViewToPlayCursor(true);
    }

    @Override
    public void eventEditCursorSet(Play p_Play, long p_EditCursor) {
        if (p_Play == null) {
            return;
        }
        if (!p_Play.getEditModeOn()) {
            return;
        }
        this.m_FrameCursor = p_EditCursor;
        this.adjustViewToPlayCursor(false);
    }

    @Override
    public long eventPlayCheckRead(Play p_Play, long p_FrameStart, long p_FramesToRead) {
        return p_FramesToRead;
    }

    @Override
    public void eventPlayCursor(Play p_Play, long p_OldPlayCursor, long p_PlayCursor) {
        if (p_Play == null) {
            return;
        }
        if (p_Play.getEditModeOn()) {
            return;
        }
        if (this.m_FrameCursor == p_OldPlayCursor) {
            return;
        }
        this.m_FrameCursor = p_OldPlayCursor;
        this.adjustViewToPlayCursor(false);
    }

    public void scrollTo(long p_FramePosition) {
        long longVisibleLength = this.m_VisibleFrameEnd - this.m_VisibleFrameStart;
        long longFrameThreshold = longVisibleLength / 10L;
        if (p_FramePosition > this.m_VisibleFrameEnd - longFrameThreshold && this.m_VisibleFrameEnd < this.m_FrameEnd) {
            this.m_VisibleFrameStart_New = p_FramePosition - longFrameThreshold;
            this.m_VisibleFrameEnd_New = p_FramePosition + longVisibleLength - longFrameThreshold;
            EventQueueHandler.invokeLater(this.m_RunnableNotifyScrollBarListeners);
        } else if (p_FramePosition < this.m_VisibleFrameStart && this.m_VisibleFrameStart > this.m_FrameStart) {
            this.m_VisibleFrameStart_New = p_FramePosition - longFrameThreshold;
            this.m_VisibleFrameEnd_New = p_FramePosition + longVisibleLength - longFrameThreshold;
            EventQueueHandler.invokeLater(this.m_RunnableNotifyScrollBarListeners);
        }
    }

    @Override
    public void eventPlayClosing(Play p_Play) {
    }

    @Override
    public void eventPlayError(Play p_Play, Exception p_Exception, String p_Remark) {
    }

    @Override
    public void eventPlayTimelineEnd(Play p_Play) {
    }

    @Override
    public void eventViewChanged(long p_FrameStart, long p_FrameEnd, long p_VisibleFrameStart, long p_VisibleFrameEnd, Rectangle p_Bounds) {
        if (!this.m_ScrollbarAdjusting) {
            this.calculateScrollBar(p_FrameStart, p_FrameEnd, p_VisibleFrameStart, p_VisibleFrameEnd);
            this.notifyScrollBarListener_VisibleRegion(this.m_VisibleFrameStart, this.m_VisibleFrameEnd);
        }
    }

    @Override
    public void eventViewScrollAutomaticStart() {
        this.setAutoscrollBlocked(true);
    }

    @Override
    public void eventZoomPlus(boolean p_AdjustFramePosition, long p_FramePosition) {
        this.zoomPlus(p_AdjustFramePosition, p_FramePosition);
    }

    @Override
    public void eventZoomMinus(boolean p_AdjustFramePosition, long p_FramePosition) {
        this.zoomMinus(p_AdjustFramePosition, p_FramePosition);
    }

    @Override
    public void eventZoomReset() {
        this.zoomReset();
    }

    static {
        s_Color_AutomaticOn = Color.GREEN;
        s_Color_AutomaticBlocked = Color.YELLOW;
        s_Color_AutomaticOff = Color.LIGHT_GRAY;
        s_AutomaticOn = new ImageIcon(LiveShowScrollBarPanel.class.getResource("/IconsPackage/Scroll_ZoomAutomaticOn.png"));
        s_AutomaticBlocked = new ImageIcon(LiveShowScrollBarPanel.class.getResource("/IconsPackage/Scroll_ZoomAutomaticBlocked.png"));
        s_AutomaticOff = new ImageIcon(LiveShowScrollBarPanel.class.getResource("/IconsPackage/Scroll_ZoomAutomaticOff.png"));
    }
}

