/*
 * Decompiled with CFR 0.152.
 */
package LiveShowObjectPackage;

import GUID.LiveGUID;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectGroupPanel;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectListener;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowSceneBridgeMain;
import LiveShowVirtualPackage.LiveShowVIP;
import LiveShowVirtualPackage.LiveShowVIPListener;
import LiveShowVirtualPackage.LiveShowVIPTrack;
import LiveShowVirtualPackage.LiveShow_ExportDescription;
import LiveShowVirtualPackage.LiveShow_ImportDescription;
import SwingModelPackage.TableAndListModel;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

public class LiveShowObjectGroup
implements LiveShowObjectListener,
LiveShowVIPListener,
Externalizable {
    public static final int SOFTWAREVERSION = 1;
    public static final String FILESUFFIX = ".log";
    public static ImageIcon s_Icon = new ImageIcon(LiveShowObjectGroupPanel.class.getResource("/IconsPackage/Timeline_ObjectGroup.png"));
    @LiveLanguageString
    public static String DEFAULT_GROUPNAME = "ObjectGroup";
    @LiveLanguageString
    public static String DEFAULT_GROUPREMARK_ATOMATIC = "automatically generated";
    public static int s_GroupCounter = 0;
    public static LiveShowObjectGroupTableModel s_GroupTableModel = new LiveShowObjectGroupTableModel();
    public static final String PROP_NAME = "groupName";
    public static final String PROP_REMARK = "groupRemark";
    public static final String PROP_CLOSED = "groupClosed";
    private String m_ID;
    private String m_Name;
    private String m_Remark;
    private ArrayList<LiveShowObjectInterface> m_LiveShowObjects;
    private ArrayList<String> m_KeepRemovedObjectsIDs;
    private StringBuilder m_StringBuilderToolTip;
    private final Object m_SyncStringBuilder = new Object();
    protected SinglePropertyChangeSupport m_PropertyChangeSupport;
    protected final Object m_SyncObjects = new Object();

    public LiveShowObjectGroup() {
        this.initMembers();
        LiveLanguage.addLanguageListener(this, null);
        this.m_Name = DEFAULT_GROUPNAME + String.valueOf(s_GroupCounter);
        for (int intVIP = 0; intVIP < LiveShowVIP.getLiveShowVIPCount(); ++intVIP) {
            LiveShowVIP o_LiveShowVIP = LiveShowVIP.getLiveShowVIP(intVIP);
            if (o_LiveShowVIP == null) continue;
            o_LiveShowVIP.addLiveShowVIPListener(this);
        }
        this.refreshToolTipText();
    }

    private void initMembers() {
        this.m_StringBuilderToolTip = new StringBuilder();
        this.m_LiveShowObjects = new ArrayList();
        this.m_KeepRemovedObjectsIDs = new ArrayList();
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
        this.m_ID = LiveGUID.getGUID();
        if (++s_GroupCounter <= s_GroupTableModel.size()) {
            s_GroupCounter = s_GroupTableModel.size() + 1;
        }
        this.m_Remark = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeUTF(this.m_ID);
        out.writeUTF(this.m_Name);
        out.writeUTF(this.m_Remark);
        Object object = this.m_SyncObjects;
        synchronized (object) {
            out.writeInt(this.m_LiveShowObjects.size());
            for (int intObject = 0; intObject < this.m_LiveShowObjects.size(); ++intObject) {
                LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowObjects.get(intObject);
                out.writeUTF(o_LiveShowObjectInterface.getID());
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        String oldValue = this.m_Name;
        this.m_ID = in.readUTF();
        this.m_Name = in.readUTF();
        this.m_Remark = in.readUTF();
        int intObjectCount = in.readInt();
        for (int intObject = 0; intObject < intObjectCount; ++intObject) {
            String stringObjectID = in.readUTF();
            LiveShowObjectInterface o_LiveShowObjectInterface = LiveShowVIP.getLiveShowObject(stringObjectID);
            if (o_LiveShowObjectInterface == null) continue;
            this.addObject(o_LiveShowObjectInterface);
        }
        this.refreshToolTipText();
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_NAME, oldValue, this.m_Name);
        }
    }

    protected void close() {
        for (int intVIP = 0; intVIP < LiveShowVIP.getLiveShowVIPCount(); ++intVIP) {
            LiveShowVIP o_LiveShowVIP = LiveShowVIP.getLiveShowVIP(intVIP);
            if (o_LiveShowVIP == null) continue;
            o_LiveShowVIP.removeLiveShowVIPListener(this);
        }
        this.clearObjects();
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_CLOSED, this, null);
            this.m_PropertyChangeSupport.clear();
        }
        LiveLanguage.removeLanguageListener(this);
    }

    public String getID() {
        return this.m_ID;
    }

    private void setID(String p_ID) {
        if (p_ID == null) {
            return;
        }
        this.m_ID = p_ID;
    }

    public String getName() {
        return this.m_Name;
    }

    public void setName(String p_Name) {
        if (p_Name == null) {
            return;
        }
        if (p_Name.equals(this.m_Name)) {
            return;
        }
        String oldValue = this.m_Name;
        this.m_Name = p_Name;
        this.refreshToolTipText();
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_NAME, oldValue, this.m_Name);
        }
    }

    public String getRemark() {
        return this.m_Remark;
    }

    public void setRemark(String p_Remark) {
        if (p_Remark == null) {
            return;
        }
        if (p_Remark.equals(this.m_Remark)) {
            return;
        }
        String oldValue = this.m_Remark;
        this.m_Remark = p_Remark;
        this.refreshToolTipText();
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_REMARK, oldValue, this.m_Remark);
        }
    }

    public void resetObjects() {
        this.clearObjects();
        int intVIPCount = LiveShowVIP.getLiveShowVIPCount();
        for (int intVIP = 0; intVIP < intVIPCount; ++intVIP) {
            LiveShowVIP o_LiveShowVIP = LiveShowVIP.getLiveShowVIP(intVIP);
            if (o_LiveShowVIP == null) continue;
            int intSelectedObjectCount = o_LiveShowVIP.getSelectedObjectsCount();
            for (int intObject = 0; intObject < intSelectedObjectCount; ++intObject) {
                LiveShowObjectInterface o_LiveShowObjectInterface = o_LiveShowVIP.getSelectedObjectInterface(intObject);
                if (o_LiveShowObjectInterface == null) continue;
                this.addObject(o_LiveShowObjectInterface);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearObjects() {
        ArrayList<LiveShowObjectInterface> o_Objects;
        Object object = this.m_SyncObjects;
        synchronized (object) {
            this.m_KeepRemovedObjectsIDs.clear();
            o_Objects = new ArrayList<LiveShowObjectInterface>(this.m_LiveShowObjects.size());
            o_Objects.addAll(this.m_LiveShowObjects);
        }
        for (int intObject = o_Objects.size() - 1; intObject >= 0; --intObject) {
            LiveShowObjectInterface o_LiveShowObjectInterface = (LiveShowObjectInterface)o_Objects.get(intObject);
            this.removeObject(o_LiveShowObjectInterface, false);
        }
        this.m_LiveShowObjects.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getObjectCount() {
        Object object = this.m_SyncObjects;
        synchronized (object) {
            return this.m_LiveShowObjects.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addObject(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return false;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (this.m_LiveShowObjects.contains(p_LiveShowObjectInterface)) {
                return false;
            }
            this.m_LiveShowObjects.add(p_LiveShowObjectInterface);
            p_LiveShowObjectInterface.addLiveShowObjectListener(this);
        }
        s_GroupTableModel.changedElement(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeObject(LiveShowObjectInterface p_LiveShowObjectInterface, boolean p_KeepRemovedObjectID) {
        if (p_LiveShowObjectInterface == null) {
            return false;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (!this.m_LiveShowObjects.contains(p_LiveShowObjectInterface)) {
                return false;
            }
            this.m_LiveShowObjects.remove(p_LiveShowObjectInterface);
            p_LiveShowObjectInterface.removeLiveShowObjectListener(this);
            if (p_KeepRemovedObjectID) {
                this.m_KeepRemovedObjectsIDs.add(p_LiveShowObjectInterface.getID());
            }
        }
        s_GroupTableModel.changedElement(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowObjectInterface getObject(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            if (p_Index >= this.m_LiveShowObjects.size()) {
                return null;
            }
            return this.m_LiveShowObjects.get(p_Index);
        }
    }

    public int getKeepRemovedObjectIDCount() {
        return this.m_KeepRemovedObjectsIDs.size();
    }

    public String getToolTipText() {
        return this.m_StringBuilderToolTip.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshToolTipText() {
        Object object = this.m_SyncStringBuilder;
        synchronized (object) {
            this.m_StringBuilderToolTip.delete(0, this.m_StringBuilderToolTip.length());
            this.m_StringBuilderToolTip.append("<html><center>");
            this.m_StringBuilderToolTip.append("<b>");
            this.m_StringBuilderToolTip.append(this.getName());
            this.m_StringBuilderToolTip.append("</b><br>");
            this.m_StringBuilderToolTip.append(this.getRemark());
            this.m_StringBuilderToolTip.append("</center>");
            this.m_StringBuilderToolTip.append("</html>");
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public static LiveShowObjectGroupTableModel getGroupTableModel() {
        return s_GroupTableModel;
    }

    public static void addGroup(LiveShowObjectGroup p_Group) {
        if (p_Group == null) {
            return;
        }
        s_GroupTableModel.addGroup(p_Group);
    }

    public static void removeGroup(LiveShowObjectGroup p_Group, boolean p_ProjectClosed) {
        if (p_Group == null) {
            return;
        }
        s_GroupTableModel.removeGroup(p_Group);
        p_Group.close();
        if (!p_ProjectClosed) {
            // empty if block
        }
    }

    public static ArrayList<LiveShowObjectGroup> getGroups() {
        ArrayList o_Groups = s_GroupTableModel.getElementArrayList_Safe();
        return o_Groups;
    }

    public static int getGroupCount() {
        return s_GroupTableModel.size();
    }

    public static LiveShowObjectGroup getGroup(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        return (LiveShowObjectGroup)s_GroupTableModel.get(p_Index);
    }

    public static boolean contains(String p_ID) {
        return s_GroupTableModel.contains(p_ID);
    }

    public static LiveShowObjectGroup getGroup(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        Object o_Group = null;
        return s_GroupTableModel.getGroup(p_ID);
    }

    public static LiveShowObjectGroup getGroupByName(String p_Name) {
        if (p_Name == null) {
            return null;
        }
        LiveShowObjectGroup o_Group = null;
        int intGroupCount = LiveShowObjectGroup.getGroupCount();
        for (int intGroup = 0; intGroup < intGroupCount; ++intGroup) {
            o_Group = s_GroupTableModel.getGroup(intGroup);
            if (o_Group == null) continue;
            if (p_Name.equals(o_Group.getName())) break;
            o_Group = null;
        }
        return o_Group;
    }

    public static int indexOf(LiveShowObjectGroup p_Group) {
        if (p_Group == null) {
            return -1;
        }
        return s_GroupTableModel.indexOf(p_Group);
    }

    public static void clear() {
        int intGroupCount = LiveShowObjectGroup.getGroupCount();
        for (int intGroup = intGroupCount - 1; intGroup >= 0; --intGroup) {
            LiveShowObjectGroup o_Group = s_GroupTableModel.getGroup(intGroup);
            LiveShowObjectGroup.removeGroup(o_Group, true);
        }
    }

    public static void clearEmptyGroups() {
        for (int intGroup = LiveShowObjectGroup.getGroupCount() - 1; intGroup >= 0; --intGroup) {
            LiveShowObjectGroup o_Group = s_GroupTableModel.getGroup(intGroup);
            if (o_Group.getObjectCount() != 0) continue;
            LiveShowObjectGroup.removeGroup(o_Group, false);
        }
    }

    public static boolean saveGroups(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ExportDescription p_LiveShow_ExportDescription) {
        if (!p_LiveShow_ExportDescription.getSaveProject() && !p_LiveShow_ExportDescription.getExportProjectAll()) {
            LiveShowObjectInterface o_ObjectInterface;
            int intObject;
            ArrayList<LiveShowObjectGroup> o_Groups = new ArrayList<LiveShowObjectGroup>();
            ArrayList<LiveShowObjectInterface> o_SelectedObjectInterfaces = new ArrayList<LiveShowObjectInterface>();
            int intVIPCount = LiveShowVIP.getLiveShowVIPCount();
            for (int intVIP = 0; intVIP < intVIPCount; ++intVIP) {
                LiveShowVIP o_LiveShowVIP = LiveShowVIP.getLiveShowVIP(intVIP);
                if (o_LiveShowVIP == null) continue;
                int intSelectedObjectCount = o_LiveShowVIP.getSelectedObjectsCount();
                for (intObject = 0; intObject < intSelectedObjectCount; ++intObject) {
                    o_ObjectInterface = o_LiveShowVIP.getSelectedObjectInterface(intObject);
                    o_SelectedObjectInterfaces.add(o_ObjectInterface);
                }
            }
            for (int intGroup = 0; intGroup < s_GroupTableModel.size(); ++intGroup) {
                LiveShowObjectGroup o_Group = s_GroupTableModel.getGroup(intGroup);
                if (o_Group == null) continue;
                for (intObject = 0; intObject < o_Group.getObjectCount(); ++intObject) {
                    o_ObjectInterface = o_Group.getObject(intObject);
                    if (o_SelectedObjectInterfaces.contains(o_ObjectInterface)) continue;
                    o_Group = null;
                    break;
                }
                if (o_Group == null) continue;
                o_Groups.add(o_Group);
            }
            return LiveShowObjectGroup.saveGroups(p_LiveShowProjectDescription, o_Groups);
        }
        return LiveShowObjectGroup.saveGroups(p_LiveShowProjectDescription, (ArrayList<LiveShowObjectGroup>)null);
    }

    public static boolean saveGroups(LiveShowProjectDescription p_LiveShowProjectDescription, ArrayList<LiveShowObjectGroup> p_Groups) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        try {
            File o_File = new File(stringFileName);
            if (o_File.exists()) {
                try {
                    o_File.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (p_Groups == null ? s_GroupTableModel.size() <= 0 : p_Groups.size() <= 0) {
                return true;
            }
            o_File.createNewFile();
            FileOutputStream o_FileOutputStream = new FileOutputStream(o_File);
            ObjectOutputStream o_ObjectOutput = new ObjectOutputStream(o_FileOutputStream);
            o_ObjectOutput.writeInt(1);
            if (p_Groups == null) {
                int intGroupCount = LiveShowObjectGroup.getGroupCount();
                o_ObjectOutput.writeInt(intGroupCount);
                for (int intGroup = 0; intGroup < intGroupCount; ++intGroup) {
                    LiveShowObjectGroup o_Group = LiveShowObjectGroup.getGroup(intGroup);
                    if (o_Group == null) continue;
                    o_Group.writeExternal(o_ObjectOutput);
                }
            } else {
                int intGroupCount = p_Groups.size();
                o_ObjectOutput.writeInt(intGroupCount);
                for (int intGroup = 0; intGroup < intGroupCount; ++intGroup) {
                    LiveShowObjectGroup o_Group = p_Groups.get(intGroup);
                    if (o_Group == null) continue;
                    o_Group.writeExternal(o_ObjectOutput);
                }
            }
            o_ObjectOutput.close();
            o_FileOutputStream.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean deleteGroups(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        boolean boolSuccess = false;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        File o_File = new File(stringFileName);
        if (o_File.exists()) {
            try {
                boolSuccess = o_File.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return boolSuccess;
    }

    public static boolean loadGroups(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        FileInputStream o_FileInputStream = null;
        ObjectInputStream o_ObjectInput = null;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        try {
            File o_File = new File(stringFileName);
            if (!o_File.exists()) {
                return false;
            }
            o_FileInputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_FileInputStream);
            int intSoftwareVersion = o_ObjectInput.readInt();
            int intGroupCount = o_ObjectInput.readInt();
            for (int intGroup = 0; intGroup < intGroupCount; ++intGroup) {
                LiveShowObjectGroup o_Group = new LiveShowObjectGroup();
                o_Group.readExternal(o_ObjectInput);
                if (LiveShowObjectGroup.contains(o_Group.getID())) {
                    o_Group.close();
                    continue;
                }
                if (p_LiveShow_ImportDescription == null || p_LiveShow_ImportDescription.getLoadNewProject()) {
                    LiveShowObjectGroup.addGroup(o_Group);
                    continue;
                }
                String stringGroupName = o_Group.getName();
                stringGroupName = LiveShow_ImportDescription.createImportedName(stringGroupName);
                o_Group.setName(stringGroupName);
                LiveShowObjectGroup.addGroup(o_Group);
            }
            o_ObjectInput.close();
            o_FileInputStream.close();
        }
        catch (Exception e) {
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public static void createGroupsAutomatically() {
        LiveShowObjectInterface o_LiveShowObjectInterface;
        int intObject;
        LiveShowVIP o_LiveShowVIP;
        int intVIP;
        LiveShowObjectGroup o_Group;
        LiveShowSceneBridgeMain o_SortedMainBridge;
        int intSortedMainBridge;
        LiveShowSceneBridgeMain.MainBridgeContainer o_MainBridgeContainer = LiveShowSceneBridgeMain.getMainBridgeContainer();
        if (o_MainBridgeContainer == null) {
            return;
        }
        if (o_MainBridgeContainer.getLiveShowSceneBridgeMain_Count() <= 0) {
            return;
        }
        ArrayList<LiveShowSceneBridgeMain> o_SortedMainBridges = new ArrayList<LiveShowSceneBridgeMain>();
        int intMainBridgeCount = o_MainBridgeContainer.getLiveShowSceneBridgeMain_Count();
        if (intMainBridgeCount <= 1) {
            return;
        }
        for (int intMainBridge = 0; intMainBridge < intMainBridgeCount; ++intMainBridge) {
            LiveShowSceneBridgeMain o_MainBridge = o_MainBridgeContainer.getLiveShowSceneBridgeMain(intMainBridge);
            for (intSortedMainBridge = 0; intSortedMainBridge < o_SortedMainBridges.size() && (o_SortedMainBridge = (LiveShowSceneBridgeMain)o_SortedMainBridges.get(intSortedMainBridge)).getFrameStart() <= o_MainBridge.getFrameStart(); ++intSortedMainBridge) {
            }
            o_SortedMainBridges.add(intSortedMainBridge, o_MainBridge);
        }
        LiveShowSceneBridgeMain o_SortedMainBridgeStart = (LiveShowSceneBridgeMain)o_SortedMainBridges.get(0);
        for (intSortedMainBridge = 1; intSortedMainBridge < o_SortedMainBridges.size(); ++intSortedMainBridge) {
            o_SortedMainBridge = (LiveShowSceneBridgeMain)o_SortedMainBridges.get(intSortedMainBridge);
            if (o_SortedMainBridge == null) continue;
            o_Group = LiveShowObjectGroup.getGroupByName(o_SortedMainBridgeStart.getName());
            if (o_Group == null) {
                o_Group = new LiveShowObjectGroup();
                o_Group.setName(o_SortedMainBridgeStart.getName());
                o_Group.setRemark(DEFAULT_GROUPREMARK_ATOMATIC);
                LiveShowObjectGroup.addGroup(o_Group);
            }
            o_Group.clearObjects();
            block3: for (intVIP = 0; intVIP < LiveShowVIP.getLiveShowVIPCount(); ++intVIP) {
                o_LiveShowVIP = LiveShowVIP.getLiveShowVIP(intVIP);
                if (o_LiveShowVIP == null) continue;
                for (intObject = 0; intObject < o_LiveShowVIP.getLiveShowObjectInterfaceCount(); ++intObject) {
                    o_LiveShowObjectInterface = o_LiveShowVIP.getLiveShowObjectInterface(intObject);
                    if (o_LiveShowObjectInterface == null || o_LiveShowObjectInterface.getFrameStart() < o_SortedMainBridgeStart.getFrameStart()) continue;
                    if (o_LiveShowObjectInterface.getFrameStart() >= o_SortedMainBridge.getFrameStart()) continue block3;
                    if (o_LiveShowObjectInterface.getFrameStart() + o_LiveShowObjectInterface.getFrameLength() > o_SortedMainBridge.getFrameStart() + o_SortedMainBridge.getFrameLength()) continue;
                    o_Group.addObject(o_LiveShowObjectInterface);
                }
            }
            o_SortedMainBridgeStart = o_SortedMainBridge;
        }
        o_Group = LiveShowObjectGroup.getGroupByName(o_SortedMainBridgeStart.getName());
        if (o_Group == null) {
            o_Group = new LiveShowObjectGroup();
            o_Group.setName(o_SortedMainBridgeStart.getName());
            o_Group.setRemark(DEFAULT_GROUPREMARK_ATOMATIC);
            LiveShowObjectGroup.addGroup(o_Group);
        }
        o_Group.clearObjects();
        for (intVIP = 0; intVIP < LiveShowVIP.getLiveShowVIPCount(); ++intVIP) {
            o_LiveShowVIP = LiveShowVIP.getLiveShowVIP(intVIP);
            if (o_LiveShowVIP == null) continue;
            for (intObject = 0; intObject < o_LiveShowVIP.getLiveShowObjectInterfaceCount(); ++intObject) {
                o_LiveShowObjectInterface = o_LiveShowVIP.getLiveShowObjectInterface(intObject);
                if (o_LiveShowObjectInterface == null || o_LiveShowObjectInterface.getFrameStart() < o_SortedMainBridgeStart.getFrameStart()) continue;
                o_Group.addObject(o_LiveShowObjectInterface);
            }
        }
    }

    @Override
    public void eventObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
    }

    @Override
    public void eventObjectVolumeChanged(LiveShowObjectInterface p_LiveShowObjectInterface, float p_Volume) {
    }

    @Override
    public void eventObjectAdditionalChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
    }

    @Override
    public void eventObjectClosed(LiveShowObjectInterface p_LiveShowObjectInterface) {
        this.removeObject(p_LiveShowObjectInterface, true);
    }

    @Override
    public void eventObjectSelection(LiveShowObjectInterface p_LiveShowObjectInterface, boolean p_IsSelected, boolean p_Added) {
    }

    @Override
    public void eventVIPActive(LiveShowVIP p_LiveShowVIP, boolean p_Active) {
    }

    @Override
    public void eventVIPTrackAdded(LiveShowVIP p_LiveShowVIP, LiveShowVIPTrack p_LiveShowVIPTrack) {
    }

    @Override
    public void eventVIPTrackRemoved(LiveShowVIP p_LiveShowVIP, LiveShowVIPTrack p_LiveShowVIPTrack) {
    }

    @Override
    public void eventVIPFrameMaxObjects(LiveShowVIP p_LiveShowVIP, long p_FrameMaxObjects) {
    }

    @Override
    public void eventVIPMaxFrame(LiveShowVIP p_LiveShowVIP, long p_FrameMax) {
    }

    @Override
    public void eventVIPFrameTime(LiveShowVIP p_LiveShowVIP, double p_FrameTime) {
    }

    @Override
    public void eventVIPClosing(LiveShowVIP p_LiveShowVIP) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventVIPSceneBridgeAdded(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowSceneBridge == null) {
            return;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            int intIndex = this.m_KeepRemovedObjectsIDs.indexOf(p_LiveShowSceneBridge.getID());
            if (intIndex < 0) {
                return;
            }
            this.m_KeepRemovedObjectsIDs.remove(intIndex);
            this.addObject(p_LiveShowSceneBridge);
        }
    }

    @Override
    public void eventVIPSceneBridgeRemoved(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
    }

    @Override
    public void eventVIPSceneBridgesResorted(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge, ArrayList<LiveShowSceneBridge> p_LiveShowSceneBridges) {
    }

    @Override
    public void eventVIPSceneBridgeCursorChanged(LiveShowVIP p_LiveShowVIP, boolean p_ActualPlayInside, boolean p_ActualStopAtStart) {
    }

    @Override
    public void eventVIPSceneBridgeEditCursorChanged(LiveShowVIP p_LiveShowVIP) {
    }

    @Override
    public void eventVIPSceneBridgeStart(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_WillPlay) {
    }

    @Override
    public void eventVIPSceneBridgeEnd(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventVIPObjectAdded(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        Object object = this.m_SyncObjects;
        synchronized (object) {
            int intIndex = this.m_KeepRemovedObjectsIDs.indexOf(p_LiveShowObjectInterface.getID());
            if (intIndex < 0) {
                return;
            }
            this.m_KeepRemovedObjectsIDs.remove(intIndex);
            this.addObject(p_LiveShowObjectInterface);
        }
    }

    @Override
    public void eventVIPObjectRemoved(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectParamChanged(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectShowSettings(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectSelection(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPEndOfAction(LiveShowVIP p_LiveShowVIP, LiveShowVIP p_ActorLiveShowVIP, boolean p_Success, int p_Action) {
    }

    @Override
    public void eventVIPEditModeOn(LiveShowVIP p_LiveShowVIP, boolean p_EditModeOn) {
    }

    @Override
    public void eventVIPCursorMode(LiveShowVIP p_LiveShowVIP, int p_EditMode) {
    }

    @Override
    public void eventVIPToFront(LiveShowVIP p_LiveShowVIP) {
    }

    public static class GroupTableCellRenderer
    extends TableAndListModel.TableCellEditorRenderer_String {
        public static Border s_FailureBorder = new LineBorder(Color.RED, 2);

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent o_JComponent = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int intRowModel = table.convertRowIndexToModel(row);
            LiveShowObjectGroup o_Group = LiveShowObjectGroup.getGroup(intRowModel);
            if (o_Group != null && o_Group.getKeepRemovedObjectIDCount() > 0) {
                o_JComponent.setBorder(s_FailureBorder);
            }
            return o_JComponent;
        }
    }

    public static class LiveShowObjectGroup_RowFilter
    extends RowFilter<LiveShowObjectGroup, Integer> {
        private LiveShowObjectGroupTableModel m_ObjectGroupTableModel;
        private String m_FilterString;

        public LiveShowObjectGroup_RowFilter(LiveShowObjectGroupTableModel p_ObjectGroupTableModel) {
            this.initMembers();
            this.m_ObjectGroupTableModel = p_ObjectGroupTableModel;
        }

        private void initMembers() {
            this.m_FilterString = null;
        }

        public void setFilterString(String p_FilterString) {
            this.m_FilterString = p_FilterString == null ? "" : p_FilterString.toLowerCase();
            if (this.m_ObjectGroupTableModel != null) {
                this.m_ObjectGroupTableModel.fireTableDataChanged();
            }
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            if (this.m_ObjectGroupTableModel == null) {
                return false;
            }
            if (this.m_FilterString == null) {
                return true;
            }
            if (this.m_FilterString.length() <= 0) {
                return true;
            }
            int intRow = (Integer)entry.getIdentifier();
            LiveShowObjectGroup o_LiveShowObjectGroup = this.m_ObjectGroupTableModel.getGroup(intRow);
            if (o_LiveShowObjectGroup == null) {
                return false;
            }
            if (o_LiveShowObjectGroup.getName().toLowerCase().contains(this.m_FilterString)) {
                return true;
            }
            return o_LiveShowObjectGroup.getRemark().toLowerCase().contains(this.m_FilterString);
        }
    }

    public static class LiveShowObjectGroupTableModel
    extends TableAndListModel<LiveShowObjectGroup>
    implements PropertyChangeListener {
        public static final int COLUMNCOUNT = 2;
        public static final int COLUMNINDEX_GROUPNAME = 0;
        public static final int COLUMNINDEX_GROUPREMARK = 1;
        @LiveLanguageString
        public static String COLUMN_GROUPNAME = "Name";
        @LiveLanguageString
        public static String COLUMN_GROUPREMARK = "Description";
        private TableRowSorter m_TableRowSorter;
        private LiveShowObjectGroup_RowFilter m_LiveShowObjectGroup_RowFilter;
        private final Object m_SyncObject = new Object();

        public LiveShowObjectGroupTableModel() {
            super(false);
            this.initMembers();
            LiveLanguage.addLanguageListener(this, null);
        }

        private void initMembers() {
            this.m_TableRowSorter = new TableRowSorter<LiveShowObjectGroupTableModel>(this);
            this.m_LiveShowObjectGroup_RowFilter = new LiveShowObjectGroup_RowFilter(this);
        }

        public void finishJTable(JTable p_JTable) {
            GroupTableCellRenderer o_GroupTableCellRenderer;
            if (p_JTable == null) {
                return;
            }
            this.m_TableRowSorter.setComparator(0, (Comparator<?>)TableAndListModel.getStringComparator_Normal());
            this.m_TableRowSorter.setComparator(1, (Comparator<?>)TableAndListModel.getStringComparator_Normal());
            super.finishJTable(p_JTable, this.m_TableRowSorter, (RowFilter)this.m_LiveShowObjectGroup_RowFilter);
            TableColumn o_TableColumn = p_JTable.getColumnModel().getColumn(0);
            if (o_TableColumn != null) {
                o_TableColumn.setMinWidth(120);
                o_TableColumn.setPreferredWidth(150);
                o_TableColumn.setResizable(true);
                o_GroupTableCellRenderer = new GroupTableCellRenderer();
                o_GroupTableCellRenderer.setIcon(s_Icon);
                o_GroupTableCellRenderer.setToolTipText_Automatic(2);
                o_GroupTableCellRenderer.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor((TableCellEditor)((Object)o_GroupTableCellRenderer));
                o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_GroupTableCellRenderer));
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(1)) != null) {
                o_TableColumn.setMinWidth(120);
                o_TableColumn.setPreferredWidth(150);
                o_TableColumn.setResizable(true);
                o_GroupTableCellRenderer = new GroupTableCellRenderer();
                o_GroupTableCellRenderer.setToolTipText_Automatic(2);
                o_GroupTableCellRenderer.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor((TableCellEditor)((Object)o_GroupTableCellRenderer));
                o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_GroupTableCellRenderer));
            }
        }

        public void filter(String p_FilterString) {
            if (this.m_LiveShowObjectGroup_RowFilter != null) {
                this.m_LiveShowObjectGroup_RowFilter.setFilterString(p_FilterString);
            }
        }

        public boolean contains(String p_ID) {
            if (p_ID == null) {
                return false;
            }
            LiveShowObjectGroup o_Group = this.getGroup(p_ID);
            return o_Group != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LiveShowObjectGroup getGroup(String p_ID) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intGroup = 0; intGroup < this.size(); ++intGroup) {
                    LiveShowObjectGroup o_Group = (LiveShowObjectGroup)this.get(intGroup);
                    if (o_Group == null || !p_ID.equals(o_Group.getID())) continue;
                    return o_Group;
                }
            }
            return null;
        }

        public void addGroup(LiveShowObjectGroup p_Group) {
            if (p_Group == null) {
                return;
            }
            if (this.add(p_Group)) {
                p_Group.addPropertyChangeListener(this);
            }
        }

        public void removeGroup(LiveShowObjectGroup p_Group) {
            if (p_Group == null) {
                return;
            }
            if (this.remove(p_Group)) {
                p_Group.removePropertyChangeListener(this);
            }
        }

        public void addSelectedGroup(JTable p_JTable, LiveShowObjectGroup p_Group) {
            if (p_JTable == null) {
                return;
            }
            if (p_Group == null) {
                return;
            }
            this.addSelectedElement(p_JTable, p_Group);
        }

        public void removeSelectedGroup(JTable p_JTable, LiveShowObjectGroup p_Group) {
            if (p_JTable == null) {
                return;
            }
            if (p_Group == null) {
                return;
            }
            this.removeSelectedElement(p_JTable, p_Group);
        }

        public LiveShowObjectGroup getGroup(int p_Index) {
            return (LiveShowObjectGroup)this.get(p_Index);
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return COLUMN_GROUPNAME;
                }
                case 1: {
                    return COLUMN_GROUPREMARK;
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue(LiveShowObjectGroup p_Group, int columnIndex) {
            String stringValue = "";
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_Group == null) {
                    return stringValue;
                }
            }
            switch (columnIndex) {
                case 0: {
                    stringValue = p_Group.getName();
                    break;
                }
                case 1: {
                    stringValue = p_Group.getRemark();
                }
            }
            return stringValue;
        }

        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return true;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(LiveShowObjectGroup p_Group, Object value, int col) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_Group == null) {
                    return;
                }
            }
            switch (col) {
                case 0: {
                    String stringValue = (String)value;
                    p_Group.setName(stringValue);
                    break;
                }
                case 1: {
                    String stringValue = (String)value;
                    p_Group.setRemark(stringValue);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof LiveShowObjectGroup) {
                LiveShowObjectGroup o_LiveShowObjectGroup = (LiveShowObjectGroup)evt.getSource();
                if (LiveShowObjectGroup.PROP_NAME.equals(evt.getPropertyName())) {
                    this.changedElement(o_LiveShowObjectGroup);
                } else if (LiveShowObjectGroup.PROP_REMARK.equals(evt.getPropertyName())) {
                    this.changedElement(o_LiveShowObjectGroup);
                } else if (LiveShowObjectGroup.PROP_CLOSED.equals(evt.getPropertyName())) {
                    // empty if block
                }
            }
        }
    }
}

