/*
 * Decompiled with CFR 0.152.
 */
package LiveShowObjectPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectListener;
import LiveShowObjectPackage.LiveShowObjectPanel;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowVIP;
import SynchronizationPackage.LiveCloseSemaphore;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public abstract class LiveShowObject
implements LiveShowObjectInterface,
PropertyChangeListener,
Playable {
    @LiveLanguageString
    public static String TOOLTIP_VOLUME = "Volume";
    @LiveLanguageString
    public static String TOOLTIP_VOLUME_SELECTEDOBJECT = "Volume affects all other selected objects";
    @LiveLanguageString
    public static String TOOLTIP_FADEIN = "FadeIn";
    @LiveLanguageString
    public static String TOOLTIP_FADEIN_OFFSET = "FadeIn Offset";
    @LiveLanguageString
    public static String TOOLTIP_FADEOUT = "FadeOut";
    @LiveLanguageString
    public static String TOOLTIP_FADEOUT_OFFSET = "FadeOut Offset";
    @LiveLanguageString
    public static String TOOLTIP_STOP = "Stop";
    @LiveLanguageString
    public static String TOOLTIP_ACTIVE = "Active";
    @LiveLanguageString
    public static String TOOLTIP_JUMP = "Jump";
    public static final String PROP_OBJECTSOURCECLOSE = "liveShowObject_SourceClose";
    public static final String PROP_NAME = "name";
    public static final String PROP_SOURCENAME = "sourceName";
    public static final int FADE_ELSE = 0;
    public static final int FADEIN = 1;
    public static final int FADEOUT = 2;
    public static final int FADEVOLUME = 3;
    public static final int RESIZEWEST = 4;
    public static final int RESIZEEAST = 5;
    public static final int FADEOUTOFFSET = 6;
    public static final int FADEINOFFSET = 7;
    public static final int STOPATSTART = 8;
    public static final int ACTIVE = 9;
    public static final int JUMPSCENEBRIDGE = 10;
    public static final int MOVE = 99;
    public static long MIN_FRAMELENGTH = 5292L;
    protected Object m_Owner;
    protected LiveShowObjectDescription m_Description;
    protected long m_FrameLength_FadeOutDirect;
    protected boolean m_IsSelected;
    protected boolean m_IsPlaying;
    protected StringBuilder m_StringBuilderName;
    protected StringBuilder m_StringBuilderToolTip;
    protected final Object m_SyncStringBuilder = new Object();
    protected boolean m_Overlap;
    protected ArrayList<LiveShowObjectListener> m_LiveShowObjectListeners;
    protected boolean m_ChangedSinceLastAction;
    protected boolean m_ChangedStartLength_SinceLastNotification;
    protected boolean m_ChangedFrameStartOffset_SinceLastNotification;
    protected boolean m_SendNotification;
    protected LiveCloseSemaphore m_LiveCloseSemaphore;
    protected final Object m_SyncObjectListeners = new Object();

    public LiveShowObject() {
        this(null);
    }

    public LiveShowObject(LiveShowObjectDescription p_LiveShowObjectDescription) {
        this.initMembers();
        if (p_LiveShowObjectDescription == null) {
            this.m_Description = LiveShowObjectDescription.poolGet();
            this.m_Description.setObjectType(1);
        } else {
            this.m_Description = p_LiveShowObjectDescription.clone(null);
        }
        this.setDescription(p_LiveShowObjectDescription);
    }

    private void initMembers() {
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_LiveShowObjectListeners = new ArrayList();
        this.m_IsSelected = false;
        this.m_StringBuilderName = new StringBuilder();
        this.m_StringBuilderToolTip = new StringBuilder();
        this.m_Overlap = false;
        this.m_ChangedSinceLastAction = false;
        this.m_ChangedStartLength_SinceLastNotification = false;
        this.m_ChangedFrameStartOffset_SinceLastNotification = false;
        this.m_SendNotification = true;
        this.m_IsPlaying = false;
        this.m_FrameLength_FadeOutDirect = 0L;
        this.m_Owner = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean p_Finish) {
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        this.notifyObjectListeners_ObjectClosing();
        Object object = this.m_SyncObjectListeners;
        synchronized (object) {
            if (this.m_LiveShowObjectListeners != null) {
                this.m_LiveShowObjectListeners.clear();
            }
        }
        this.m_Description.setFrameStartOffset(0L);
        this.m_Description.setFrameLength(0L);
        this.m_Description.close(p_Finish);
        this.m_LiveCloseSemaphore.leaveCloseSection();
        this.m_Owner = null;
    }

    @Override
    public void setOwner(Object p_Owner) {
        this.m_Owner = p_Owner;
    }

    @Override
    public Object getOwner() {
        return this.m_Owner;
    }

    public void reactivate(LiveShowObjectDescription p_LiveShowDMXObjectDescription) {
        this.m_LiveCloseSemaphore.refresh();
        if (p_LiveShowDMXObjectDescription == null) {
            this.m_Description = LiveShowObjectDescription.poolGet();
            this.m_Description.setObjectType(1);
        } else {
            this.m_Description = p_LiveShowDMXObjectDescription.clone(null);
        }
        this.m_IsSelected = false;
        this.m_IsPlaying = false;
        this.m_Overlap = false;
        this.m_ChangedSinceLastAction = false;
        this.m_ChangedStartLength_SinceLastNotification = false;
        this.m_ChangedFrameStartOffset_SinceLastNotification = false;
        this.m_SendNotification = true;
        this.setDescription(p_LiveShowDMXObjectDescription);
    }

    @Override
    public void setSendNotification(boolean p_Send) {
        this.m_SendNotification = p_Send;
    }

    @Override
    public boolean getSendNotification() {
        return this.m_SendNotification;
    }

    @Override
    public boolean getChangedFrameStartOffsetSinceLastNotification() {
        return this.m_ChangedFrameStartOffset_SinceLastNotification;
    }

    @Override
    public boolean getChangedStartLengthSinceLastNotification() {
        return this.m_ChangedStartLength_SinceLastNotification;
    }

    @Override
    public LiveShowObjectDescription getDescription() {
        return this.m_Description;
    }

    @Override
    public void setDescription(LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowObjectDescription == null) {
            return;
        }
        boolean boolChanged = false;
        if (this.m_Description.getFrameStart() != p_LiveShowObjectDescription.getFrameStart()) {
            this.m_ChangedStartLength_SinceLastNotification = true;
        }
        if (this.m_Description.getFrameLength() != p_LiveShowObjectDescription.getFrameLength()) {
            this.m_ChangedStartLength_SinceLastNotification = true;
        }
        if (this.m_Description.getFrameStartOffset() != p_LiveShowObjectDescription.getFrameStartOffset()) {
            this.m_ChangedFrameStartOffset_SinceLastNotification = true;
        }
        boolChanged = this.m_Description.copyFrom(p_LiveShowObjectDescription);
        this.refreshJumps();
        if (boolChanged) {
            this.m_ChangedSinceLastAction = true;
            this.refreshToolTipText();
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    @Override
    public long getDiskSpaceEstimated() {
        return this.m_Description.getDiskSpaceEstimated();
    }

    @Override
    public String getID() {
        return this.m_Description.getID();
    }

    @Override
    public void setID(String p_ID) {
        if (p_ID == null) {
            return;
        }
        if (this.m_Description.getID().equals(p_ID)) {
            return;
        }
        this.m_Description.setID(p_ID);
    }

    @Override
    public String getName() {
        return this.m_Description.getName();
    }

    @Override
    public void setName(String p_Name) {
        if (p_Name == null) {
            return;
        }
        if (p_Name.equals(this.m_Description.getName())) {
            return;
        }
        this.m_ChangedSinceLastAction = true;
        this.m_Description.setName(p_Name);
        this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        this.refreshToolTipText();
    }

    @Override
    public String getSourceName() {
        return this.m_Description.getSourceName();
    }

    @Override
    public void setSourceName(String p_SourceName) {
        if (p_SourceName == null) {
            return;
        }
        if (p_SourceName.equals(this.m_Description.getSourceName())) {
            return;
        }
        this.m_ChangedSinceLastAction = true;
        this.m_Description.setSourceName(p_SourceName);
        this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        this.refreshToolTipText();
    }

    @Override
    public void setEffect(Object p_Effect) {
    }

    @Override
    public Object getEffect() {
        return null;
    }

    @Override
    public String getEffectName() {
        return null;
    }

    @Override
    public void setEffectParameters(ArrayList<Double> p_EffectParameters) {
    }

    @Override
    public ArrayList<Double> getEffectParameters() {
        return null;
    }

    @Override
    public LiveShowObjectInterface.EffectPanel getEffectPanel() {
        return null;
    }

    @Override
    public void changeStartPosition(long p_FramePosition) {
        if (p_FramePosition != this.m_Description.getFrameStart()) {
            this.m_ChangedSinceLastAction = true;
            this.m_ChangedStartLength_SinceLastNotification = true;
        }
        this.m_Description.setFrameStart(p_FramePosition);
        this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
    }

    @Override
    public long getFrameStart() {
        return this.m_Description.getFrameStart();
    }

    @Override
    public void setFrameStart(long p_StartFramePosition) {
        this.setObjectParams(p_StartFramePosition, this.m_Description.getFrameStartOffset(), this.m_Description.getFrameLength(), this.m_Description.getFrameFadeInLength(), this.m_Description.getFrameFadeInOffset(), this.m_Description.getFrameFadeOutLength(), this.m_Description.getFrameFadeOutOffset(), this.m_Description.getVolumeFactor());
    }

    @Override
    public void setFrameStartResize(long p_FramePosition) {
        if (p_FramePosition > this.m_Description.getFrameStart() + this.m_Description.getFrameLength() - MIN_FRAMELENGTH) {
            p_FramePosition = this.m_Description.getFrameStart() + this.m_Description.getFrameLength() - MIN_FRAMELENGTH;
        }
        this.setObjectParams(p_FramePosition, this.m_Description.getFrameStartOffset() - (this.m_Description.getFrameStart() - p_FramePosition), this.m_Description.getFrameLength() + (this.m_Description.getFrameStart() - p_FramePosition), this.m_Description.getFrameFadeInLength(), this.m_Description.getFrameFadeInOffset(), this.m_Description.getFrameFadeOutLength(), this.m_Description.getFrameFadeOutOffset(), this.m_Description.getVolumeFactor());
    }

    @Override
    public long getFrameLength() {
        return this.m_Description.getFrameLength();
    }

    @Override
    public long getFrameLengthToPlay() {
        if (this.m_FrameLength_FadeOutDirect > 0L) {
            return this.m_FrameLength_FadeOutDirect;
        }
        return this.m_Description.getFrameLength();
    }

    @Override
    public void setFrameLength(long p_FrameLength) {
        this.setObjectParams(this.m_Description.getFrameStart(), this.m_Description.getFrameStartOffset(), p_FrameLength, this.m_Description.getFrameFadeInLength(), this.m_Description.getFrameFadeInOffset(), this.m_Description.getFrameFadeOutLength(), this.m_Description.getFrameFadeOutOffset(), this.m_Description.getVolumeFactor());
    }

    @Override
    public long getFrameEnd() {
        return this.m_Description.getFrameStart() + this.m_Description.getFrameLength();
    }

    @Override
    public long getFrameEndToPlay() {
        if (this.m_FrameLength_FadeOutDirect > 0L) {
            return this.m_Description.getFrameStart() + this.m_FrameLength_FadeOutDirect;
        }
        return this.m_Description.getFrameStart() + this.m_Description.getFrameLength();
    }

    @Override
    public long getFrameStartOffset() {
        return this.m_Description.getFrameStartOffset();
    }

    @Override
    public void setFrameStartOffset(long p_FrameStartOffset) {
        this.setObjectParams(this.m_Description.getFrameStart(), p_FrameStartOffset, this.m_Description.getFrameLength(), this.m_Description.getFrameFadeInLength(), this.m_Description.getFrameFadeInOffset(), this.m_Description.getFrameFadeOutLength(), this.m_Description.getFrameFadeOutOffset(), this.m_Description.getVolumeFactor());
    }

    @Override
    public long getFrameEndOffset() {
        long longSourceFrameLength = this.getSourceFrameLength();
        if (longSourceFrameLength < 0L) {
            return 0L;
        }
        return longSourceFrameLength - this.m_Description.getFrameStartOffset() - this.m_Description.getFrameLength();
    }

    @Override
    public float getVolumeFactor() {
        return this.m_Description.getVolumeFactor();
    }

    @Override
    public void setVolumeFactor(float p_VolumeFactor, boolean p_NotifySelected) {
        this.setObjectParams(this.m_Description.getFrameStart(), this.m_Description.getFrameStartOffset(), this.m_Description.getFrameLength(), this.m_Description.getFrameFadeInLength(), this.m_Description.getFrameFadeInOffset(), this.m_Description.getFrameFadeOutLength(), this.m_Description.getFrameFadeOutOffset(), p_VolumeFactor);
        if (p_NotifySelected) {
            this.notifyObjectListeners_ObjectVolumeChanged(this.getVolumeFactor());
        }
    }

    public float getVolumeFactor_Logarithm() {
        return this.m_Description.getVolumeFactor_Logarithm();
    }

    @Override
    public long getFrameFadeInLength() {
        return this.m_Description.getFrameFadeInLength();
    }

    @Override
    public void setFrameFadeInLength(long p_FrameFadeInLength) {
        this.setObjectParams(this.m_Description.getFrameStart(), this.m_Description.getFrameStartOffset(), this.m_Description.getFrameLength(), p_FrameFadeInLength, this.m_Description.getFrameFadeInOffset(), this.m_Description.getFrameFadeOutLength(), this.m_Description.getFrameFadeOutOffset(), this.m_Description.getVolumeFactor());
    }

    @Override
    public long getFrameFadeInOffset() {
        return this.m_Description.getFrameFadeInOffset();
    }

    @Override
    public void setFrameFadeInOffset(long p_FrameFadeInOffset) {
        this.setObjectParams(this.m_Description.getFrameStart(), this.m_Description.getFrameStartOffset(), this.m_Description.getFrameLength(), this.m_Description.getFrameFadeInLength(), p_FrameFadeInOffset, this.m_Description.getFrameFadeOutLength(), this.m_Description.getFrameFadeOutOffset(), this.m_Description.getVolumeFactor());
    }

    @Override
    public long getFrameFadeOutLength() {
        return this.m_Description.getFrameFadeOutLength();
    }

    @Override
    public void setFrameFadeOutLength(long p_FrameFadeOutLength) {
        this.setObjectParams(this.m_Description.getFrameStart(), this.m_Description.getFrameStartOffset(), this.m_Description.getFrameLength(), this.m_Description.getFrameFadeInLength(), this.m_Description.getFrameFadeInOffset(), p_FrameFadeOutLength, this.m_Description.getFrameFadeOutOffset(), this.m_Description.getVolumeFactor());
    }

    @Override
    public long getFrameFadeOutOffset() {
        return this.m_Description.getFrameFadeOutOffset();
    }

    @Override
    public void setFrameFadeOutOffset(long p_FrameFadeOutOffset) {
        this.setObjectParams(this.m_Description.getFrameStart(), this.m_Description.getFrameStartOffset(), this.m_Description.getFrameLength(), this.m_Description.getFrameFadeInLength(), this.m_Description.getFrameFadeInOffset(), this.m_Description.getFrameFadeOutLength(), p_FrameFadeOutOffset, this.m_Description.getVolumeFactor());
    }

    public boolean isCursorPositionInside(long p_FramePosition) {
        return p_FramePosition < this.m_Description.getFrameStart() + this.m_Description.getFrameLength() && p_FramePosition >= this.m_Description.getFrameStart();
    }

    public boolean getIsPlaying() {
        return this.m_IsPlaying;
    }

    @Override
    public abstract double getFrameTime();

    public String getTimeStringFromFrames_Seconds(long p_Frames) {
        if (p_Frames < 0L) {
            return "";
        }
        long longMilliseconds = (long)((double)p_Frames * this.getFrameTime());
        long longSeconds = (long)((double)longMilliseconds / 1000.0 + 0.5);
        String stringTime = LiveShowObject.getTimeStringFromMillis(longMilliseconds = longSeconds * 1000L);
        if (stringTime.length() < 4) {
            return "0";
        }
        stringTime = stringTime.substring(0, stringTime.length() - 4);
        return stringTime;
    }

    public String getTimeStringFromFrames(long p_Frames) {
        return LiveShowObject.getTimeStringFromMillis((long)((double)p_Frames * this.getFrameTime()));
    }

    public static String getTimeStringFromMillis(long p_Milliseconds) {
        String stringTemp;
        String stringTime = "";
        boolean boolSetString = false;
        int intHours = (int)(p_Milliseconds / 3600000L);
        p_Milliseconds -= (long)(intHours * 3600000);
        if (boolSetString || intHours > 0) {
            stringTemp = "00";
            stringTemp = stringTemp + String.valueOf(intHours);
            stringTime = stringTime + stringTemp.substring(stringTemp.length() - 2, stringTemp.length()) + ":";
            boolSetString = true;
        }
        int intMinutes = (int)(p_Milliseconds / 60000L);
        p_Milliseconds -= (long)(intMinutes * 60000);
        if (boolSetString || intMinutes > 0) {
            stringTemp = "00";
            stringTemp = stringTemp + String.valueOf(intMinutes);
            stringTime = stringTime + stringTemp.substring(stringTemp.length() - 2, stringTemp.length()) + ":";
            boolSetString = true;
        }
        int intSeconds = (int)(p_Milliseconds / 1000L);
        p_Milliseconds -= (long)(intSeconds * 1000);
        if (boolSetString || intSeconds > 0) {
            stringTemp = "00";
            stringTemp = stringTemp + String.valueOf(intSeconds);
            stringTime = stringTime + stringTemp.substring(stringTemp.length() - 2, stringTemp.length()) + ":";
            boolSetString = true;
        }
        int intMilliseconds = (int)p_Milliseconds;
        stringTemp = "000";
        stringTemp = stringTemp + String.valueOf(intMilliseconds);
        stringTime = stringTime + stringTemp.substring(stringTemp.length() - 3, stringTemp.length());
        return stringTime;
    }

    public String getToolTipText() {
        return this.m_StringBuilderToolTip.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshToolTipText() {
        Object object = this.m_SyncStringBuilder;
        synchronized (object) {
            this.m_StringBuilderToolTip.delete(0, this.m_StringBuilderToolTip.length());
            this.m_StringBuilderToolTip.append("<html><center>");
            this.m_StringBuilderToolTip.append("<b>");
            this.m_StringBuilderToolTip.append(this.getName());
            this.m_StringBuilderToolTip.append("</b><br>");
            String stringSourceName = this.getSourceName();
            if (stringSourceName != null) {
                this.m_StringBuilderToolTip.append(this.getSourceName());
            }
            this.m_StringBuilderToolTip.append("</center>");
            this.m_StringBuilderToolTip.append("</html>");
        }
    }

    public void setOverlap(boolean p_Overlap) {
        if (this.m_Overlap != p_Overlap) {
            this.m_Overlap = p_Overlap;
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    public boolean getOverlap() {
        return this.m_Overlap;
    }

    @Override
    public Playable.PlayObject read(Play p_Play, Playable.PlayObject p_PlayObject) {
        if (p_PlayObject == null) {
            return null;
        }
        if (p_PlayObject.getData() == null) {
            return null;
        }
        Playable.PlayObject o_PlayObject = this.read(p_Play, p_PlayObject, null, -1L, 1.0, false);
        return o_PlayObject;
    }

    @Override
    public Playable.PlayObject readInternal(Play p_Play, Playable.PlayObject p_PlayObject, LiveShowSceneBridge p_LiveShowSceneBridge, long SceneBridgeFrameInside, double p_SceneBridgeFadeProgress, boolean p_IsPreObject) {
        return p_PlayObject;
    }

    @Override
    public void setObjectParams(long p_StartFramePosition, long p_FrameStartOffset, long p_FrameLength, long p_FrameFadeInLength, long p_FrameFadeInOffset, long p_FrameFadeOutLength, long p_FrameFadeOutOffset, float p_VolumeFactor) {
        long longNewFadeLength;
        long longSourceFrameLength;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        boolean boolStartFrame = false;
        boolean boolLength = false;
        boolean boolOffset = false;
        boolean boolFadeIn = false;
        boolean boolFadeOut = false;
        boolean boolVolume = false;
        boolean boolIsSceneBridge = false;
        double doubleFrameLengthFactor = 1.0;
        boolIsSceneBridge = this.getIsSceneBridge();
        if (p_StartFramePosition < 0L) {
            p_StartFramePosition = 0L;
        }
        if (this.m_Description.getFrameStart() != p_StartFramePosition) {
            boolStartFrame = true;
            this.m_Description.setFrameStart(p_StartFramePosition);
        }
        if ((longSourceFrameLength = this.getSourceFrameLength()) >= 0L) {
            if (p_FrameStartOffset < 0L) {
                p_FrameStartOffset = 0L;
            }
            if (p_FrameStartOffset > longSourceFrameLength) {
                p_FrameStartOffset = longSourceFrameLength;
            }
            if (p_FrameLength < MIN_FRAMELENGTH) {
                p_FrameLength = MIN_FRAMELENGTH;
            }
            if (p_FrameStartOffset + p_FrameLength > longSourceFrameLength) {
                p_FrameLength = longSourceFrameLength - p_FrameStartOffset;
            }
        }
        if (p_FrameStartOffset < 0L) {
            p_FrameStartOffset = 0L;
        }
        if (p_FrameLength < MIN_FRAMELENGTH) {
            p_FrameLength = MIN_FRAMELENGTH;
        }
        if (this.m_Description.getFrameLength() != p_FrameLength) {
            doubleFrameLengthFactor = this.m_Description.getFrameLength() == 0L ? 0.0 : (double)p_FrameLength / (double)this.m_Description.getFrameLength();
            if (doubleFrameLengthFactor < 0.0) {
                doubleFrameLengthFactor = 0.0;
            }
            boolLength = true;
            this.m_Description.setFrameLength(p_FrameLength);
        }
        if (p_FrameStartOffset < 0L) {
            p_FrameStartOffset = 0L;
        }
        if (this.m_Description.getFrameStartOffset() != p_FrameStartOffset) {
            boolOffset = true;
            this.m_Description.setFrameStartOffset(p_FrameStartOffset);
        }
        if (p_FrameFadeInOffset == this.m_Description.getFrameFadeInOffset()) {
            p_FrameFadeInOffset = (long)((double)p_FrameFadeInOffset * doubleFrameLengthFactor + 0.5);
        }
        if (p_FrameFadeInOffset < 0L) {
            p_FrameFadeInOffset = 0L;
        }
        if (p_FrameFadeInOffset > this.m_Description.getFrameLength()) {
            p_FrameFadeInOffset = this.m_Description.getFrameLength();
        }
        if (this.m_Description.getFrameFadeInOffset() != p_FrameFadeInOffset) {
            boolFadeIn = true;
            this.m_Description.setFrameFadeInOffset(p_FrameFadeInOffset);
        }
        if (p_FrameFadeOutOffset == this.m_Description.getFrameFadeOutOffset()) {
            p_FrameFadeOutOffset = (long)((double)p_FrameFadeOutOffset * doubleFrameLengthFactor + 0.5);
        }
        if (p_FrameFadeOutOffset < 0L) {
            p_FrameFadeOutOffset = 0L;
        }
        if (p_FrameFadeOutOffset > this.m_Description.getFrameLength()) {
            p_FrameFadeOutOffset = this.m_Description.getFrameLength();
        }
        if (this.m_Description.getFrameFadeOutOffset() != p_FrameFadeOutOffset) {
            boolFadeOut = true;
            this.m_Description.setFrameFadeOutOffset(p_FrameFadeOutOffset);
        }
        if (boolFadeIn && p_FrameFadeInOffset > this.m_Description.getFrameLength() - this.m_Description.getFrameFadeOutOffset()) {
            p_FrameFadeInOffset = this.m_Description.getFrameLength() - this.m_Description.getFrameFadeOutOffset();
            this.m_Description.setFrameFadeInOffset(p_FrameFadeInOffset);
        }
        if (boolFadeOut && p_FrameFadeOutOffset > this.m_Description.getFrameLength() - this.m_Description.getFrameFadeInOffset()) {
            p_FrameFadeOutOffset = this.m_Description.getFrameLength() - this.m_Description.getFrameFadeInOffset();
            this.m_Description.setFrameFadeOutOffset(p_FrameFadeOutOffset);
        }
        if (boolIsSceneBridge && p_FrameFadeInLength == this.m_Description.getFrameFadeInLength()) {
            p_FrameFadeInLength = (long)((double)p_FrameFadeInLength * doubleFrameLengthFactor + 0.5);
        }
        if (p_FrameFadeInLength < this.m_Description.getFrameFadeInOffset()) {
            p_FrameFadeInLength = this.m_Description.getFrameFadeInOffset();
        }
        if (p_FrameFadeInLength > this.m_Description.getFrameLength()) {
            p_FrameFadeInLength = this.m_Description.getFrameLength();
        }
        if (boolIsSceneBridge && p_FrameFadeOutLength == this.m_Description.getFrameFadeOutLength()) {
            p_FrameFadeOutLength = (long)((double)p_FrameFadeOutLength * doubleFrameLengthFactor + 0.5);
        }
        if (p_FrameFadeOutLength < this.m_Description.getFrameFadeOutOffset()) {
            p_FrameFadeOutLength = this.m_Description.getFrameFadeOutOffset();
        }
        if (p_FrameFadeOutLength > this.m_Description.getFrameLength()) {
            p_FrameFadeOutLength = this.m_Description.getFrameLength();
        }
        if (this.m_Description.getFrameFadeInLength() != p_FrameFadeInLength) {
            boolFadeIn = true;
            this.m_Description.setFrameFadeInLength(p_FrameFadeInLength);
        }
        if (this.m_Description.getFrameFadeOutLength() != p_FrameFadeOutLength) {
            boolFadeOut = true;
            this.m_Description.setFrameFadeOutLength(p_FrameFadeOutLength);
        }
        if (!boolFadeIn) {
            longNewFadeLength = this.m_Description.getFrameFadeInLength();
            if (longNewFadeLength < 0L) {
                longNewFadeLength = 0L;
            }
            if (longNewFadeLength > this.m_Description.getFrameLength()) {
                longNewFadeLength = this.m_Description.getFrameLength();
            }
            this.m_Description.setFrameFadeInLength(longNewFadeLength);
        }
        if (!boolFadeOut) {
            longNewFadeLength = this.m_Description.getFrameFadeOutLength();
            if (longNewFadeLength < 0L) {
                longNewFadeLength = 0L;
            }
            if (longNewFadeLength > this.m_Description.getFrameLength()) {
                longNewFadeLength = this.m_Description.getFrameLength();
            }
            this.m_Description.setFrameFadeOutLength(longNewFadeLength);
        }
        if (!boolIsSceneBridge && this.m_Description.getFrameFadeInLength() + this.m_Description.getFrameFadeOutLength() > this.m_Description.getFrameLength()) {
            longNewFadeLength = this.m_Description.getFrameLength() - this.m_Description.getFrameFadeInLength();
            this.m_Description.setFrameFadeOutLength(longNewFadeLength);
        }
        if (p_VolumeFactor < 0.0f) {
            p_VolumeFactor = 0.0f;
        }
        if (p_VolumeFactor > 2.0f) {
            p_VolumeFactor = 2.0f;
        }
        if (this.m_Description.getVolumeFactor() != p_VolumeFactor) {
            boolVolume = true;
            this.m_Description.setVolumeFactor(p_VolumeFactor);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if (boolOffset) {
            this.m_ChangedFrameStartOffset_SinceLastNotification = true;
        }
        if (boolStartFrame || boolLength) {
            this.m_ChangedStartLength_SinceLastNotification = true;
        }
        if (boolStartFrame || boolOffset || boolLength || boolFadeIn || boolFadeOut || boolVolume) {
            this.m_ChangedSinceLastAction = true;
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    @Override
    public void setIsJingle(boolean p_IsJingle) {
        if (this.m_Description.getIsJingle() == p_IsJingle) {
            return;
        }
        this.m_Description.setIsJingle(p_IsJingle);
        this.m_ChangedSinceLastAction = true;
        this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
    }

    @Override
    public boolean getIsJingle() {
        return this.m_Description.getIsJingle();
    }

    @Override
    public boolean getIsSceneBridge() {
        return this.m_Description.getIsSceneBridge();
    }

    @Override
    public void setActive(boolean p_Active) {
        if (this.m_Description.getActive() == p_Active) {
            return;
        }
        this.m_Description.setActive(p_Active);
        this.m_ChangedSinceLastAction = true;
        this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
    }

    @Override
    public boolean getActive() {
        return this.m_Description.getActive();
    }

    @Override
    public void setStopAtStart(boolean p_Stop) {
        if (this.m_Description.getStopAtStart() == p_Stop) {
            return;
        }
        this.m_Description.setStopAtStart(p_Stop);
        this.m_ChangedSinceLastAction = true;
        this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
    }

    @Override
    public boolean getStopAtStart() {
        return this.m_Description.getStopAtStart();
    }

    @Override
    public int getVIPTrackNumber() {
        return this.m_Description.getVIPTrackNumber();
    }

    @Override
    public void setVIPTrackNumber(int p_VIPTrackNumber) {
        if (this.m_Description.getVIPTrackNumber() == p_VIPTrackNumber) {
            return;
        }
        this.m_Description.setVIPTrackNumber(p_VIPTrackNumber);
        this.m_ChangedSinceLastAction = true;
        this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
    }

    @Override
    public long getMouseFramePositionInside() {
        return this.m_Description.getMouseFramePositionInside();
    }

    @Override
    public void setMouseFramePositionInside(long p_FramePositionInside) {
        this.m_Description.setMouseFramePositionInside(p_FramePositionInside);
    }

    @Override
    public boolean setSelected(boolean p_IsSelected, boolean p_Added) {
        if (this.m_IsSelected == p_IsSelected) {
            return false;
        }
        this.m_IsSelected = p_IsSelected;
        this.notifyObjectListeners_Selection(p_Added);
        return true;
    }

    @Override
    public boolean getSelected() {
        return this.m_IsSelected;
    }

    @Override
    public void setStringPre(String p_Text) {
        if (p_Text == null) {
            return;
        }
        if (this.m_Description.getStringPre().equals(p_Text)) {
            return;
        }
        this.m_Description.setStringPre(p_Text);
        this.m_ChangedSinceLastAction = true;
        this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
    }

    @Override
    public String getStringPre() {
        return this.m_Description.getStringPre();
    }

    @Override
    public void setStringPost(String p_Text) {
        if (p_Text == null) {
            return;
        }
        if (this.m_Description.getStringPost().equals(p_Text)) {
            return;
        }
        this.m_Description.setStringPost(p_Text);
        this.m_ChangedSinceLastAction = true;
        this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
    }

    @Override
    public String getStringPost() {
        return this.m_Description.getStringPost();
    }

    @Override
    public boolean isEqualDefaultSettings() {
        if (this.m_Description == null) {
            return false;
        }
        return this.m_Description.isEqualDefaultSettings();
    }

    @Override
    public String createToolTipText(boolean p_Complete) {
        StringBuffer o_StringBuffer = new StringBuffer();
        if (p_Complete) {
            o_StringBuffer.append("<html>");
        }
        o_StringBuffer.append("<center><b>");
        o_StringBuffer.append(this.getName());
        o_StringBuffer.append("</b></center>");
        o_StringBuffer.append("<br>");
        o_StringBuffer.append("<table align=center>");
        o_StringBuffer.append("<tbody>");
        o_StringBuffer.append("<tr>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append(LiveShowObjectDescription.DescriptionStrings.s_Source);
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("<td align=center>");
        o_StringBuffer.append("<b>");
        String stringSourceName = this.getSourceName();
        if (stringSourceName != null) {
            o_StringBuffer.append(this.getSourceName());
        }
        o_StringBuffer.append("</b>");
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("</tr>");
        String stringSourceAdditinalInfo = this.getSourceAdditionalInfo();
        if (stringSourceAdditinalInfo != null) {
            o_StringBuffer.append("<tr>");
            o_StringBuffer.append("<td align=right>");
            o_StringBuffer.append("");
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("<td align=center>");
            o_StringBuffer.append(stringSourceAdditinalInfo);
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("</tr>");
        }
        o_StringBuffer.append("<tr>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append(LiveShowObjectDescription.DescriptionStrings.s_Start);
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append(this.getTimeStringFromFrames(this.getFrameStart()));
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("</tr>");
        o_StringBuffer.append("<tr>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append(LiveShowObjectDescription.DescriptionStrings.s_Length);
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append(this.getTimeStringFromFrames(this.getFrameLength()));
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("</tr>");
        o_StringBuffer.append("<tr>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append(LiveShowObjectDescription.DescriptionStrings.s_FadeIn);
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append(this.getTimeStringFromFrames(this.getFrameFadeInLength()));
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("</tr>");
        o_StringBuffer.append("<tr>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append(LiveShowObjectDescription.DescriptionStrings.s_FadeOut);
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append(this.getTimeStringFromFrames(this.getFrameFadeOutLength()));
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("</tr>");
        o_StringBuffer.append("</tbody>");
        o_StringBuffer.append("</table>");
        if (p_Complete) {
            o_StringBuffer.append("</html>");
        }
        return o_StringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addLiveShowObjectListener(LiveShowObjectListener p_LiveShowObjectListener) {
        if (p_LiveShowObjectListener == null) {
            return false;
        }
        if (p_LiveShowObjectListener == this) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolAdded = false;
        Object object = this.m_SyncObjectListeners;
        synchronized (object) {
            if (this.m_LiveShowObjectListeners != null && !this.m_LiveShowObjectListeners.contains(p_LiveShowObjectListener)) {
                this.m_LiveShowObjectListeners.add(p_LiveShowObjectListener);
                boolAdded = true;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLiveShowObjectListener(LiveShowObjectListener p_LiveShowObjectListener) {
        if (p_LiveShowObjectListener == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncObjectListeners;
        synchronized (object) {
            if (this.m_LiveShowObjectListeners != null) {
                boolRemoved = this.m_LiveShowObjectListeners.remove(p_LiveShowObjectListener);
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObjectListeners_ObjectAdditionalChanged(LiveShowObjectDescription p_LiveShowObjectDescription) {
        ArrayList<LiveShowObjectListener> o_LiveShowObjectListeners;
        if (!this.m_SendNotification) {
            return;
        }
        Object object = this.m_SyncObjectListeners;
        synchronized (object) {
            if (this.m_LiveShowObjectListeners == null) {
                return;
            }
            if (this.m_LiveShowObjectListeners.size() <= 0) {
                return;
            }
            o_LiveShowObjectListeners = new ArrayList<LiveShowObjectListener>(this.m_LiveShowObjectListeners.size());
            o_LiveShowObjectListeners.addAll(this.m_LiveShowObjectListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowObjectListeners.size(); ++intListener) {
            LiveShowObjectListener o_Listener = (LiveShowObjectListener)o_LiveShowObjectListeners.get(intListener);
            o_Listener.eventObjectAdditionalChanged(this, p_LiveShowObjectDescription);
        }
        o_LiveShowObjectListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObjectListeners_ObjectParameterChanged(LiveShowObjectDescription p_LiveShowObjectDescription) {
        ArrayList<LiveShowObjectListener> o_LiveShowObjectListeners;
        if (p_LiveShowObjectDescription == null) {
            return;
        }
        if (!this.m_SendNotification) {
            return;
        }
        Object object = this.m_SyncObjectListeners;
        synchronized (object) {
            if (this.m_LiveShowObjectListeners == null) {
                return;
            }
            if (this.m_LiveShowObjectListeners.size() <= 0) {
                return;
            }
            o_LiveShowObjectListeners = new ArrayList<LiveShowObjectListener>(this.m_LiveShowObjectListeners.size());
            o_LiveShowObjectListeners.addAll(this.m_LiveShowObjectListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowObjectListeners.size(); ++intListener) {
            LiveShowObjectListener o_Listener = (LiveShowObjectListener)o_LiveShowObjectListeners.get(intListener);
            o_Listener.eventObjectParameterChanged(this, p_LiveShowObjectDescription);
        }
        o_LiveShowObjectListeners.clear();
        this.m_ChangedStartLength_SinceLastNotification = false;
        this.m_ChangedFrameStartOffset_SinceLastNotification = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObjectListeners_ObjectVolumeChanged(float p_Volume) {
        ArrayList<LiveShowObjectListener> o_LiveShowObjectListeners;
        Object object = this.m_SyncObjectListeners;
        synchronized (object) {
            if (this.m_LiveShowObjectListeners == null) {
                return;
            }
            if (this.m_LiveShowObjectListeners.size() <= 0) {
                return;
            }
            o_LiveShowObjectListeners = new ArrayList<LiveShowObjectListener>(this.m_LiveShowObjectListeners.size());
            o_LiveShowObjectListeners.addAll(this.m_LiveShowObjectListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowObjectListeners.size(); ++intListener) {
            LiveShowObjectListener o_Listener = (LiveShowObjectListener)o_LiveShowObjectListeners.get(intListener);
            o_Listener.eventObjectVolumeChanged(this, p_Volume);
        }
        o_LiveShowObjectListeners.clear();
        this.m_ChangedStartLength_SinceLastNotification = false;
        this.m_ChangedFrameStartOffset_SinceLastNotification = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObjectListeners_ObjectClosing() {
        ArrayList<LiveShowObjectListener> o_LiveShowObjectListeners;
        Object object = this.m_SyncObjectListeners;
        synchronized (object) {
            if (this.m_LiveShowObjectListeners == null) {
                return;
            }
            if (this.m_LiveShowObjectListeners.size() <= 0) {
                return;
            }
            o_LiveShowObjectListeners = new ArrayList<LiveShowObjectListener>(this.m_LiveShowObjectListeners.size());
            o_LiveShowObjectListeners.addAll(this.m_LiveShowObjectListeners);
            this.m_LiveShowObjectListeners.clear();
        }
        int intListenerCount = o_LiveShowObjectListeners.size();
        for (int intListener = intListenerCount - 1; intListener >= 0 && o_LiveShowObjectListeners.size() > 0; --intListener) {
            LiveShowObjectListener o_Listener = (LiveShowObjectListener)o_LiveShowObjectListeners.get(intListener);
            o_Listener.eventObjectClosed(this);
        }
        o_LiveShowObjectListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObjectListeners_Selection(boolean p_Added) {
        ArrayList<LiveShowObjectListener> o_LiveShowObjectListeners;
        Object object = this.m_SyncObjectListeners;
        synchronized (object) {
            if (this.m_LiveShowObjectListeners == null) {
                return;
            }
            if (this.m_LiveShowObjectListeners.size() <= 0) {
                return;
            }
            o_LiveShowObjectListeners = new ArrayList<LiveShowObjectListener>(this.m_LiveShowObjectListeners.size());
            o_LiveShowObjectListeners.addAll(this.m_LiveShowObjectListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowObjectListeners.size(); ++intListener) {
            LiveShowObjectListener o_Listener = (LiveShowObjectListener)o_LiveShowObjectListeners.get(intListener);
            o_Listener.eventObjectSelection(this, this.m_IsSelected, p_Added);
        }
        o_LiveShowObjectListeners.clear();
    }

    protected void setObjectType(int p_ObjectType) {
        this.m_Description.setObjectType(p_ObjectType);
    }

    @Override
    public int getObjectType() {
        return this.m_Description.getObjectType();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (PROP_NAME.equals(evt.getPropertyName())) {
            this.setName((String)evt.getNewValue());
        } else if (PROP_SOURCENAME.equals(evt.getPropertyName())) {
            this.setSourceName((String)evt.getNewValue());
        } else if (PROP_OBJECTSOURCECLOSE.equals(evt.getPropertyName())) {
            this.close(true);
        }
    }

    @Override
    public abstract long getSourceFrameLength();

    @Override
    public abstract LiveShowObjectPanel createLiveShowObjectPanel(boolean var1);

    public abstract Playable.PlayObject read(Play var1, Playable.PlayObject var2, LiveShowSceneBridge var3, long var4, double var6, boolean var8);

    public abstract void refreshJumps();

    @Override
    public long findFramePosition_FadeIn(double p_FadeProgress) {
        if (p_FadeProgress <= 0.0) {
            return this.m_Description.getFrameStart() + this.m_Description.getFrameFadeInOffset();
        }
        long longFadeInLength = this.m_Description.getFrameFadeInLength();
        if (p_FadeProgress >= 1.0) {
            return this.m_Description.getFrameStart() + longFadeInLength + 1L;
        }
        return this.m_Description.getFrameStart() + (long)((double)(longFadeInLength - this.getFrameFadeInOffset()) * p_FadeProgress + (double)this.m_Description.getFrameFadeInOffset());
    }

    @Override
    public long findFramePosition_FadeOut(double p_FadeProgress) {
        if (p_FadeProgress <= 0.0) {
            return this.m_Description.getFrameStart() + this.m_Description.getFrameLength();
        }
        long longFadeOutLength = this.m_Description.getFrameFadeOutLength();
        if (p_FadeProgress >= 1.0) {
            return this.m_Description.getFrameStart() + this.m_Description.getFrameLength() - longFadeOutLength;
        }
        return this.m_Description.getFrameStart() + (long)((double)(this.m_Description.getFrameLength() - longFadeOutLength) + (double)(longFadeOutLength - this.getFrameFadeOutOffset()) * (1.0 - p_FadeProgress));
    }

    @Override
    public boolean setFadeOutDirect(long p_ActualFramePlay, double p_FadeInProgress, double p_FadeOutProgress) {
        if (p_ActualFramePlay < this.getFrameStart()) {
            long longFrameLength_FadeOutDirect = 0L;
            this.m_FrameLength_FadeOutDirect = 0L;
            return false;
        }
        if (this.m_FrameLength_FadeOutDirect > 0L) {
            return false;
        }
        long longFrameLength_FadeOutDirect = p_FadeInProgress < 1.0 ? this.m_Description.getFrameFadeOutLength() : (long)(p_FadeOutProgress * (double)this.m_Description.getFrameFadeOutLength());
        longFrameLength_FadeOutDirect = p_ActualFramePlay - this.m_Description.getFrameStart() + longFrameLength_FadeOutDirect;
        if (longFrameLength_FadeOutDirect > this.getFrameLength()) {
            longFrameLength_FadeOutDirect = this.getFrameLength();
        }
        this.m_FrameLength_FadeOutDirect = longFrameLength_FadeOutDirect;
        return true;
    }

    @Override
    public void resetFadeOutDirect() {
        this.m_FrameLength_FadeOutDirect = 0L;
    }

    @Override
    public long getFrameLength_FadeOutDirect() {
        return this.m_FrameLength_FadeOutDirect;
    }

    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_Cursor() {
        return null;
    }

    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_EditCursor() {
        return null;
    }

    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_Actual() {
        return null;
    }

    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_Next(long p_FramePosition, boolean p_OnlyMainBridges, boolean p_OnlyActiveBridges) {
        return null;
    }

    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_NextToPlay(long p_StartFrame, boolean p_OnlyMainScenes) {
        return null;
    }

    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_Previous(long p_FramePosition, boolean p_OnlyMainBridges, boolean p_OnlyActiveBridges) {
        return null;
    }

    @Override
    public LiveShowSceneBridge getLiveShowSceneBridge_PreviousToPlay(long p_StartFrame, boolean p_OnlyMainScenes) {
        return null;
    }

    @Override
    public void gotoSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_Friends, boolean p_JumpInternal) {
    }

    @Override
    public ImageIcon getImageIcon() {
        return null;
    }

    @Override
    public void eventPlayStart(Play p_Play) {
    }

    @Override
    public void eventPlayStop(Play p_Play) {
    }

    @Override
    public void eventPlayPause(Play p_Play) {
    }

    @Override
    public void eventPlayRewind(Play p_Play) {
    }

    @Override
    public void eventPlayFastForward(Play p_Play) {
    }

    @Override
    public void eventPlayFadePossibility(Play p_Play, boolean p_FadeInPossible, boolean p_FadeOutPossible, double p_FadeProgress) {
    }

    @Override
    public void eventPlayFadedIn(Play p_Play, boolean p_FadedIn, double p_FadeProgress) {
    }

    @Override
    public long eventPlayCheckRead(Play p_Play, long p_FrameStart, long p_FramesToRead) {
        return p_FramesToRead;
    }

    @Override
    public void eventEditModeOn(Play p_Play, boolean p_EditModeOn) {
    }

    @Override
    public void eventEditCursorSet(Play p_Play, long p_PlayCursor) {
    }

    @Override
    public void eventPlayCursorSet(Play p_Play, long p_PlayCursor) {
    }

    @Override
    public void eventPlayCursor(Play p_Play, long p_OldPlayCursor, long p_PlayCursor) {
    }

    @Override
    public void eventPlayClosing(Play p_Play) {
    }

    @Override
    public void eventPlayError(Play p_Play, Exception p_Exception, String p_Remark) {
    }

    @Override
    public void eventPlayTimelineEnd(Play p_Play) {
    }

    @Override
    public void eventEndOfAction(LiveShowVIP p_LiveShowVIP, boolean p_Success, int p_Action) {
        this.m_ChangedSinceLastAction = false;
    }

    static {
        LiveLanguage.addLanguageListener(LiveShowObject.class, null);
    }

    public static interface LiveShowObjectOwner {
        public LiveShowObject getLiveShowObject();
    }
}

