/*
 * Decompiled with CFR 0.152.
 */
package LiveShowObjectPackage;

import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectPanel;
import LiveShowVirtualPackage.LiveShowVIP;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class LiveShowDragDrop {
    private static ArrayList<DropListener> s_DropListeners = new ArrayList();
    private static Object s_DragSourceObject = null;
    private static final Object s_SyncDropListeners = new Object();
    private static Container s_MainContainer = null;

    public static void setMainContainer(Container p_Container) {
        s_MainContainer = p_Container;
    }

    public static boolean checkDragDrop(DropTargetDragEvent p_DropTargetDragEvent, boolean p_AllowDropOnTargetParent) {
        if (p_DropTargetDragEvent == null) {
            return false;
        }
        return LiveShowDragDrop.checkDragDropAt(p_DropTargetDragEvent.getLocation(), p_DropTargetDragEvent, p_AllowDropOnTargetParent);
    }

    public static boolean checkDragDrop(DropTargetDropEvent p_DropTargetDropEvent, boolean p_AllowDropOnTargetParent) {
        if (p_DropTargetDropEvent == null) {
            return false;
        }
        return LiveShowDragDrop.checkDragDropAt(p_DropTargetDropEvent.getLocation(), p_DropTargetDropEvent, p_AllowDropOnTargetParent);
    }

    private static boolean checkDragDropAt(Point p_PointComponent, DropTargetEvent p_DropTargetEvent, boolean p_AllowDropOnTargetParent) {
        Component o_Component;
        if (p_PointComponent == null) {
            return false;
        }
        if (p_DropTargetEvent == null) {
            return false;
        }
        if (s_MainContainer == null) {
            return false;
        }
        DropTargetContext o_DropTargetContext = p_DropTargetEvent.getDropTargetContext();
        if (o_DropTargetContext == null) {
            return false;
        }
        Component o_ComponentTarget = o_DropTargetContext.getComponent();
        if (o_ComponentTarget == null) {
            return false;
        }
        Point o_Point = new Point(p_PointComponent);
        SwingUtilities.convertPointToScreen(o_Point, o_ComponentTarget);
        SwingUtilities.convertPointFromScreen(o_Point, s_MainContainer);
        if (o_Component == null) {
            return false;
        }
        if (o_Component == o_ComponentTarget) {
            return true;
        }
        for (o_Component = s_MainContainer.findComponentAt(o_Point); o_Component != null; o_Component = o_Component.getParent()) {
            if (o_Component == o_ComponentTarget) {
                return true;
            }
            if (!p_AllowDropOnTargetParent || o_Component != o_ComponentTarget.getParent()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDropListener(DropListener p_DropListener) {
        if (p_DropListener == null) {
            return;
        }
        Object object = s_SyncDropListeners;
        synchronized (object) {
            if (s_DropListeners.contains(p_DropListener)) {
                return;
            }
            s_DropListeners.add(p_DropListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDropListener(DropListener p_DropListener) {
        if (p_DropListener == null) {
            return;
        }
        Object object = s_SyncDropListeners;
        synchronized (object) {
            s_DropListeners.remove(p_DropListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyDropCancelled() {
        ArrayList<DropListener> o_DropListeners;
        Object object = s_SyncDropListeners;
        synchronized (object) {
            o_DropListeners = new ArrayList<DropListener>(s_DropListeners.size());
            o_DropListeners.addAll(s_DropListeners);
        }
        for (int intListener = 0; intListener < o_DropListeners.size(); ++intListener) {
            DropListener o_DropListener = (DropListener)o_DropListeners.get(intListener);
            o_DropListener.eventDropCancelled(s_DragSourceObject);
        }
        s_DragSourceObject = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyDroppedAt(Object p_Target) {
        ArrayList<DropListener> o_DropListeners;
        Object object = s_SyncDropListeners;
        synchronized (object) {
            o_DropListeners = new ArrayList<DropListener>(s_DropListeners.size());
            o_DropListeners.addAll(s_DropListeners);
        }
        for (int intListener = 0; intListener < o_DropListeners.size(); ++intListener) {
            DropListener o_DropListener = (DropListener)o_DropListeners.get(intListener);
            o_DropListener.eventDroppedAt(p_Target, s_DragSourceObject);
        }
        s_DragSourceObject = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyDragEnterAt(Object p_Target) {
        ArrayList<DropListener> o_DropListeners;
        Object object = s_SyncDropListeners;
        synchronized (object) {
            o_DropListeners = new ArrayList<DropListener>(s_DropListeners.size());
            o_DropListeners.addAll(s_DropListeners);
        }
        for (int intListener = 0; intListener < o_DropListeners.size(); ++intListener) {
            DropListener o_DropListener = (DropListener)o_DropListeners.get(intListener);
            o_DropListener.eventDragEnterAt(p_Target, s_DragSourceObject);
        }
    }

    public static void setSource(Object p_DragSource) {
        s_DragSourceObject = p_DragSource;
    }

    public static Object getSource() {
        return s_DragSourceObject;
    }

    public static class LiveShowGestureRecognizer
    extends DragGestureRecognizer
    implements MouseListener,
    MouseMotionListener {
        public static final int RECOGNIZE_TOPBOTTOM = 0;
        public static final int RECOGNIZE_LEFTRIGHT = 1;
        public static final int RECOGNIZE_ALL = 2;
        private DragGestureListener m_DragGestureListener;
        private InputEvent m_TriggerEvent;
        private int m_Recognize_Directions;
        private boolean m_Active;

        public LiveShowGestureRecognizer(DragSource p_DragSoutce, JComponent p_Component, int p_Actions, DragGestureListener p_DragGestureListener, int p_RecognizeDirections) {
            super(p_DragSoutce, p_Component, p_Actions, p_DragGestureListener);
            this.m_DragGestureListener = p_DragGestureListener;
            this.m_Recognize_Directions = p_RecognizeDirections;
            this.initMembers();
        }

        private void initMembers() {
            this.m_Active = true;
        }

        public void close() {
            this.unregisterListeners();
            this.m_DragGestureListener = null;
        }

        public void setActive(boolean p_Active) {
            this.m_Active = p_Active;
        }

        public boolean getActive() {
            return this.m_Active;
        }

        public DragGestureListener getDragGestureListener() {
            return this.m_DragGestureListener;
        }

        @Override
        protected void registerListeners() {
            this.component.addMouseMotionListener(this);
        }

        @Override
        protected void unregisterListeners() {
            this.component.removeMouseMotionListener(this);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.m_Active) {
                return;
            }
            int intX = e.getX();
            int intY = e.getY();
            boolean boolRecognized = false;
            Container o_Container = this.component.getParent();
            if (this.component instanceof LiveShowObjectPanel) {
                switch (this.m_Recognize_Directions) {
                    case 0: {
                        if (o_Container != null) {
                            int intXContainer = intX + this.component.getX();
                            int intYContainer = intY + this.component.getY();
                            if (intXContainer < 0 || intXContainer > o_Container.getWidth()) {
                                return;
                            }
                        }
                        if (intY >= 0 && intY <= this.component.getHeight()) break;
                        boolRecognized = true;
                        break;
                    }
                    case 1: {
                        if (o_Container != null) {
                            int intXContainer = intX + this.component.getX();
                            int intYContainer = intY + this.component.getY();
                            if (intYContainer < 0 || intYContainer > o_Container.getHeight()) {
                                return;
                            }
                        }
                        if (intX >= 0 && intX <= this.component.getWidth()) break;
                        boolRecognized = true;
                        break;
                    }
                    case 2: {
                        if (intY >= 0 && intY <= this.component.getHeight() && intX >= 0 && intX <= this.component.getWidth()) break;
                        boolRecognized = true;
                    }
                }
                if (boolRecognized) {
                    this.appendEvent(e);
                    this.fireDragGestureRecognized(2, e.getPoint());
                }
            } else {
                switch (this.m_Recognize_Directions) {
                    case 0: {
                        if (o_Container != null) {
                            int intXContainer = intX + this.component.getX();
                            int intYContainer = intY + this.component.getY();
                            if (intXContainer < 0 || intXContainer > o_Container.getWidth()) {
                                return;
                            }
                        }
                        if (intY >= 0 && (intY <= this.component.getHeight() || intX < 0 || intX >= this.component.getWidth())) break;
                        boolRecognized = true;
                        break;
                    }
                    case 1: {
                        if (o_Container != null) {
                            int intXContainer = intX + this.component.getX();
                            int intYContainer = intY + this.component.getY();
                            if (intYContainer < 0 || intYContainer > o_Container.getHeight()) {
                                return;
                            }
                        }
                        if (intX >= 0 && (intX <= this.component.getWidth() || intY < 0 || intY >= this.component.getHeight())) break;
                        boolRecognized = true;
                        break;
                    }
                    case 2: {
                        if (intY >= 0 && intY <= this.component.getHeight() && intX >= 0 && intX <= this.component.getWidth()) break;
                        boolRecognized = true;
                    }
                }
                if (boolRecognized) {
                    this.appendEvent(e);
                    this.fireDragGestureRecognized(1, e.getPoint());
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    public static class LiveShowTransferable
    implements Transferable,
    Serializable {
        static final long serialVersionUID = 780358661933716902L;
        private LiveShowTransferData m_LiveShowTransferData;
        private DataFlavor m_Category;
        public static final DataFlavor SOUNDOBJECTFLAVOUR = new DataFlavor(LiveShowTransferSound.class, "Sound");
        public static final DataFlavor DMXOBJECTFLAVOUR = new DataFlavor(LiveShowTransferDMX.class, "DMX");
        public static final DataFlavor MEDIAOBJECTFLAVOUR = new DataFlavor(LiveShowTransferMedia.class, "Media");
        public static DataFlavor[] SOUNDDATAFLAVOURS = new DataFlavor[]{SOUNDOBJECTFLAVOUR};
        public static DataFlavor[] DMXDATAFLAVOURS = new DataFlavor[]{DMXOBJECTFLAVOUR};
        public static DataFlavor[] MEDIADATAFLAVOURS = new DataFlavor[]{MEDIAOBJECTFLAVOUR};
        public static FlavorMap FlAVOEMAP_SOUND = LiveShowTransferable.getFlavorMapSound();
        public static FlavorMap FlAVOEMAP_DMX = LiveShowTransferable.getFlavorMapDMX();
        public static FlavorMap FlAVOEMAP_MEDIA = LiveShowTransferable.getFlavorMapMedia();

        public static FlavorMap getFlavorMapSound() {
            SystemFlavorMap o_FlavorMap = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
            o_FlavorMap.addUnencodedNativeForFlavor(SOUNDOBJECTFLAVOUR, "Sound");
            return o_FlavorMap;
        }

        public static FlavorMap getFlavorMapDMX() {
            SystemFlavorMap o_FlavorMap = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
            o_FlavorMap.addUnencodedNativeForFlavor(DMXOBJECTFLAVOUR, "DMX");
            return o_FlavorMap;
        }

        public static FlavorMap getFlavorMapMedia() {
            SystemFlavorMap o_FlavorMap = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
            o_FlavorMap.addUnencodedNativeForFlavor(MEDIAOBJECTFLAVOUR, "Media");
            return o_FlavorMap;
        }

        public LiveShowTransferable(LiveShowObjectInterface p_Actor, LiveShowVIP.LiveShowVIPStatus p_LiveShowVIPStatus, DataFlavor p_Category) {
            this.initMembers();
            this.m_Category = p_Category;
            this.m_LiveShowTransferData = new LiveShowTransferData(p_Actor.getDescription(), p_LiveShowVIPStatus);
        }

        public LiveShowTransferable(LiveShowObjectDescription p_ActorDescription, DataFlavor p_Category) {
            this.initMembers();
            this.m_Category = p_Category;
            LiveShowVIP.LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIP.LiveShowVIPStatus();
            o_LiveShowVIPStatus.addSingleObjectDescription(p_Category.getHumanPresentableName(), p_ActorDescription);
            this.m_LiveShowTransferData = new LiveShowTransferData(p_ActorDescription, o_LiveShowVIPStatus);
        }

        private void initMembers() {
        }

        public void close() {
            if (this.m_LiveShowTransferData != null) {
                this.m_LiveShowTransferData.close();
            }
            this.m_LiveShowTransferData = null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            if (SOUNDOBJECTFLAVOUR.equals(this.m_Category)) {
                return SOUNDDATAFLAVOURS;
            }
            if (DMXOBJECTFLAVOUR.equals(this.m_Category)) {
                return DMXDATAFLAVOURS;
            }
            if (MEDIAOBJECTFLAVOUR.equals(this.m_Category)) {
                return MEDIADATAFLAVOURS;
            }
            return null;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.m_Category.equals(flavor) && this.m_Category.getHumanPresentableName().equals(flavor.getHumanPresentableName());
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this.m_LiveShowTransferData;
        }

        public LiveShowTransferData getTransferData() {
            return this.m_LiveShowTransferData;
        }

        public static class LiveShowTransferMedia
        extends LiveShowTransferData {
        }

        public static class LiveShowTransferDMX
        extends LiveShowTransferData {
        }

        public static class LiveShowTransferSound
        extends LiveShowTransferData {
        }

        public static class LiveShowTransferData
        implements Externalizable {
            static final int SOFTWAREVERSION = 1;
            private LiveShowObjectDescription m_ActorObjectDescription;
            private LiveShowVIP.LiveShowVIPStatus m_LiveShowVIPSelectedStatus;
            private String m_ResumedString;

            public LiveShowTransferData() {
            }

            public LiveShowTransferData(LiveShowObjectDescription p_ActorObjectDescription, LiveShowVIP.LiveShowVIPStatus p_LiveShowVIPSelectedStatus) {
                this.m_ActorObjectDescription = p_ActorObjectDescription;
                this.m_LiveShowVIPSelectedStatus = p_LiveShowVIPSelectedStatus;
                this.m_ResumedString = "";
            }

            private void initMembers() {
            }

            @Override
            public void writeExternal(ObjectOutput out) throws IOException {
                out.writeInt(1);
                out.writeObject(this.m_ActorObjectDescription);
                out.writeObject(this.m_LiveShowVIPSelectedStatus);
                out.writeUTF(this.m_ResumedString);
            }

            @Override
            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
                int intSoftwareVersion = in.readInt();
                this.m_ActorObjectDescription = (LiveShowObjectDescription)in.readObject();
                this.m_LiveShowVIPSelectedStatus = (LiveShowVIP.LiveShowVIPStatus)in.readObject();
                this.m_ResumedString = in.readUTF();
            }

            public void close() {
                if (this.m_LiveShowVIPSelectedStatus != null) {
                    this.m_LiveShowVIPSelectedStatus.close(false);
                }
                if (this.m_ActorObjectDescription != null) {
                    this.m_ActorObjectDescription.close(false);
                }
            }

            public LiveShowObjectDescription getActorDescription() {
                return this.m_ActorObjectDescription;
            }

            public LiveShowVIP.LiveShowVIPStatus getLiveShowVIPStatus() {
                return this.m_LiveShowVIPSelectedStatus;
            }
        }
    }

    public static interface DropListener {
        public void eventDropCancelled(Object var1);

        public void eventDroppedAt(Object var1, Object var2);

        public void eventDragEnterAt(Object var1, Object var2);
    }
}

