/*
 * Decompiled with CFR 0.152.
 */
package LiveShowNotificationPackage;

import LiveShowNotificationPackage.LiveShowNotification;
import LiveShowNotificationPackage.LiveShowNotificationListener;
import SynchronizationPackage.EventQueueHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class LiveShowNotificationPanel
extends JPanel
implements LiveShowNotificationListener {
    private static int PROGRESSBAR_MAXVALUE = 10000;
    private LiveShowNotification m_LiveShowNotification;
    private ArrayList<LiveShowNotificationPanel> m_LiveShowNotificationPanels;
    private final Object m_SyncPanels = new Object();
    private GridBagConstraints m_GridBagConstraints;
    private int m_OwnComponentsCount;
    private boolean m_WillClose;
    private Dimension m_OriginalSize;
    private Runnable m_RunnableRepaint;
    private JLabel jLabel_NotificationActionText;
    private JLabel jLabel_NotificationText;
    private JProgressBar jProgressBar_Notificaton;

    public LiveShowNotificationPanel() {
        this.initMembers();
        this.initComponents();
        this.m_OriginalSize = this.jLabel_NotificationText.getPreferredSize();
        this.m_OwnComponentsCount = this.getComponentCount();
    }

    private void initMembers() {
        this.m_LiveShowNotificationPanels = new ArrayList();
        this.m_GridBagConstraints = new GridBagConstraints();
        this.m_GridBagConstraints.fill = 2;
        this.m_GridBagConstraints.weightx = 1.0;
        this.m_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.m_WillClose = false;
        this.m_RunnableRepaint = new Runnable(){

            @Override
            public void run() {
                LiveShowNotificationPanel.this.repaint();
            }
        };
    }

    private void initComponents() {
        this.jLabel_NotificationText = new JLabel();
        this.jProgressBar_Notificaton = new JProgressBar();
        this.jLabel_NotificationActionText = new JLabel();
        this.setMinimumSize(new Dimension(406, 92));
        this.setPreferredSize(new Dimension(406, 92));
        this.setLayout(new GridBagLayout());
        this.jLabel_NotificationText.setForeground(new Color(204, 204, 0));
        this.jLabel_NotificationText.setHorizontalAlignment(0);
        this.jLabel_NotificationText.setText("jLabel1");
        this.jLabel_NotificationText.setHorizontalTextPosition(0);
        this.jLabel_NotificationText.setMaximumSize(new Dimension(Short.MAX_VALUE, 500));
        this.jLabel_NotificationText.setMinimumSize(new Dimension(400, 30));
        this.jLabel_NotificationText.setPreferredSize(new Dimension(400, 30));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_NotificationText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jProgressBar_Notificaton, gridBagConstraints);
        this.jLabel_NotificationActionText.setForeground(new Color(204, 204, 0));
        this.jLabel_NotificationActionText.setHorizontalAlignment(0);
        this.jLabel_NotificationActionText.setText("jLabel1");
        this.jLabel_NotificationActionText.setHorizontalTextPosition(0);
        this.jLabel_NotificationActionText.setMaximumSize(new Dimension(Short.MAX_VALUE, 500));
        this.jLabel_NotificationActionText.setMinimumSize(new Dimension(34, 30));
        this.jLabel_NotificationActionText.setPreferredSize(new Dimension(400, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_NotificationActionText, gridBagConstraints);
    }

    public void close() {
        this.m_WillClose = true;
    }

    public void setLiveShowNotification(LiveShowNotification p_LiveShowNotification) {
        if (this.m_WillClose) {
            return;
        }
        if (this.m_LiveShowNotification != null) {
            this.m_LiveShowNotification.removeListener(this);
        }
        this.m_LiveShowNotification = p_LiveShowNotification;
        if (this.m_LiveShowNotification != null) {
            this.m_LiveShowNotification.addListener(this);
        }
        this.refresh();
    }

    public LiveShowNotification getLiveShowNotification() {
        return this.m_LiveShowNotification;
    }

    private void refresh() {
        if (this.m_LiveShowNotification == null) {
            this.jLabel_NotificationText.setText("");
            this.jLabel_NotificationActionText.setText("");
            this.jProgressBar_Notificaton.setVisible(false);
            this.jProgressBar_Notificaton.setMaximum(0);
            this.jProgressBar_Notificaton.setValue(0);
        } else {
            if (this.m_LiveShowNotification.getSimpleRemark() || this.m_LiveShowNotification.getActionText() == null || this.m_LiveShowNotification.getActionText().length() <= 0) {
                this.jLabel_NotificationActionText.setVisible(false);
                this.jLabel_NotificationText.setText(this.m_LiveShowNotification.getText());
                this.jLabel_NotificationActionText.setText("");
            } else {
                this.jLabel_NotificationActionText.setVisible(true);
                this.jLabel_NotificationText.setText(this.m_LiveShowNotification.getText());
                this.jLabel_NotificationActionText.setText(this.m_LiveShowNotification.getActionText());
            }
            if (this.m_LiveShowNotification.getProgressMax() <= 0L) {
                this.jProgressBar_Notificaton.setVisible(false);
            } else {
                this.jProgressBar_Notificaton.setVisible(true);
                this.jProgressBar_Notificaton.setMaximum(PROGRESSBAR_MAXVALUE);
                try {
                    this.jProgressBar_Notificaton.setValue((int)((double)this.m_LiveShowNotification.getProgress() / (double)this.m_LiveShowNotification.getProgressMax() * (double)PROGRESSBAR_MAXVALUE));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        } else {
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLiveShowNotification(LiveShowNotification p_LiveShowNotification) {
        if (p_LiveShowNotification == null) {
            return;
        }
        if (this.m_WillClose) {
            return;
        }
        Object object = this.m_SyncPanels;
        synchronized (object) {
            if (this.getLiveShowNotificationPanel(p_LiveShowNotification) != null) {
                return;
            }
            p_LiveShowNotification.addListener(this);
            LiveShowNotificationPanel o_LiveShowNotificationPanel = new LiveShowNotificationPanel();
            o_LiveShowNotificationPanel.setLiveShowNotification(p_LiveShowNotification);
            this.addLiveShowNotificationPanel(o_LiveShowNotificationPanel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLiveShowNotification(LiveShowNotification p_LiveShowNotification) {
        if (p_LiveShowNotification == null) {
            return;
        }
        if (this.m_WillClose) {
            return;
        }
        if (p_LiveShowNotification == this.m_LiveShowNotification) {
            Object object = this.m_SyncPanels;
            synchronized (object) {
                for (int intPanel = 0; intPanel < this.m_LiveShowNotificationPanels.size(); ++intPanel) {
                    this.m_LiveShowNotificationPanels.get(intPanel).setLiveShowNotification(null);
                }
                this.m_LiveShowNotificationPanels.clear();
            }
            return;
        }
        p_LiveShowNotification.removeListener(this);
        LiveShowNotificationPanel o_LiveShowNotificationPanel = this.getLiveShowNotificationPanel(p_LiveShowNotification);
        if (o_LiveShowNotificationPanel == null) {
            return;
        }
        this.removeLiveShowNotificationPanel(o_LiveShowNotificationPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLiveShowNotificationPanel(LiveShowNotificationPanel p_LiveShowNotificationPanel) {
        if (p_LiveShowNotificationPanel == null) {
            return;
        }
        if (this.m_WillClose) {
            return;
        }
        Object object = this.m_SyncPanels;
        synchronized (object) {
            if (this.m_LiveShowNotificationPanels.contains(p_LiveShowNotificationPanel)) {
                return;
            }
            this.m_LiveShowNotificationPanels.add(p_LiveShowNotificationPanel);
            GridBagConstraints o_GridBagConstraints = p_LiveShowNotificationPanel.getGridBagConstraints();
            o_GridBagConstraints.gridy = this.m_OwnComponentsCount + this.m_LiveShowNotificationPanels.size();
            o_GridBagConstraints.fill = 1;
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.weighty = 1.0;
            this.add((Component)p_LiveShowNotificationPanel, o_GridBagConstraints);
        }
        this.refreshPanels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLiveShowNotificationPanel(LiveShowNotificationPanel p_LiveShowNotificationPanel) {
        if (p_LiveShowNotificationPanel == null) {
            return;
        }
        if (this.m_WillClose) {
            return;
        }
        Object object = this.m_SyncPanels;
        synchronized (object) {
            if (!this.m_LiveShowNotificationPanels.contains(p_LiveShowNotificationPanel)) {
                return;
            }
            this.m_LiveShowNotificationPanels.remove(p_LiveShowNotificationPanel);
            p_LiveShowNotificationPanel.setVisible(false);
            p_LiveShowNotificationPanel.setLiveShowNotification(null);
            this.remove(p_LiveShowNotificationPanel);
        }
        this.refreshPanels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowNotificationPanel getLiveShowNotificationPanel(LiveShowNotification p_LiveShowNotification) {
        if (p_LiveShowNotification == null) {
            return null;
        }
        if (this.m_WillClose) {
            return null;
        }
        Object object = this.m_SyncPanels;
        synchronized (object) {
            for (int intPanel = 0; intPanel < this.m_LiveShowNotificationPanels.size(); ++intPanel) {
                LiveShowNotificationPanel o_LiveShowNotificationPanel = this.m_LiveShowNotificationPanels.get(intPanel);
                if (o_LiveShowNotificationPanel == null || o_LiveShowNotificationPanel.getLiveShowNotification() != p_LiveShowNotification) continue;
                return o_LiveShowNotificationPanel;
            }
        }
        return null;
    }

    public GridBagConstraints getGridBagConstraints() {
        return this.m_GridBagConstraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPanels() {
        if (this.m_WillClose) {
            return;
        }
        Object object = this.m_SyncPanels;
        synchronized (object) {
            Dimension o_Size = this.getMinimumSize();
            GridBagLayout o_GridBagLayout = (GridBagLayout)this.getLayout();
            for (int intPanel = 0; intPanel < this.m_LiveShowNotificationPanels.size(); ++intPanel) {
                LiveShowNotificationPanel o_LiveShowNotificationPanel = this.m_LiveShowNotificationPanels.get(intPanel);
                if (o_LiveShowNotificationPanel == null) continue;
                GridBagConstraints o_GridBagConstraints = o_LiveShowNotificationPanel.getGridBagConstraints();
                o_GridBagConstraints.gridy = this.m_OwnComponentsCount + intPanel;
                o_GridBagLayout.setConstraints(o_LiveShowNotificationPanel, o_GridBagConstraints);
                o_Size.setSize(o_Size.width, o_Size.height + o_LiveShowNotificationPanel.getPreferredSize().height);
            }
            this.setPreferredSize(o_Size);
        }
        if (this.m_LiveShowNotificationPanels.size() > 0) {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void eventNotificationAdded(LiveShowNotification p_LiveShowNotification) {
        this.addLiveShowNotification(p_LiveShowNotification);
    }

    @Override
    public void eventNotificationClose(LiveShowNotification p_LiveShowNotification) {
        this.removeLiveShowNotification(p_LiveShowNotification);
    }

    @Override
    public void eventNotificationText(LiveShowNotification p_LiveShowNotification, String p_Text) {
        if (p_LiveShowNotification != this.m_LiveShowNotification) {
            return;
        }
        this.refresh();
    }

    @Override
    public void eventNotificationActionText(LiveShowNotification p_LiveShowNotification, String p_ActionText) {
        if (p_LiveShowNotification != this.m_LiveShowNotification) {
            return;
        }
        this.refresh();
    }

    @Override
    public void eventNotificationProgress(LiveShowNotification p_LiveShowNotification, long p_Progress) {
        if (p_LiveShowNotification != this.m_LiveShowNotification) {
            return;
        }
        this.refresh();
    }

    @Override
    public void eventNotificationProgressMax(LiveShowNotification p_LiveShowNotification, long p_ProgressMax) {
        if (p_LiveShowNotification != this.m_LiveShowNotification) {
            return;
        }
        this.refresh();
    }
}

