/*
 * Decompiled with CFR 0.152.
 */
package Messages;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class Message_Status_JingleGroup
implements Externalizable {
    public static final int SOFTWAREVERSION = 1;
    private ArrayList<JingleGroupDescription> m_JingleGroupDescriptions;
    private ArrayList<PlayControlStatus> m_JingleGroupPlayStatus;

    public Message_Status_JingleGroup() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_JingleGroupDescriptions = new ArrayList();
        this.m_JingleGroupPlayStatus = new ArrayList();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        int intJingleCount = this.m_JingleGroupDescriptions.size();
        out.writeInt(intJingleCount);
        for (int intJingle = 0; intJingle < this.m_JingleGroupDescriptions.size(); ++intJingle) {
            JingleGroupDescription o_JingleGroupDescription = this.m_JingleGroupDescriptions.get(intJingle);
            o_JingleGroupDescription.writeExternal(out);
            PlayControlStatus o_JingleGroupPlayStatus = this.m_JingleGroupPlayStatus.get(intJingle);
            o_JingleGroupPlayStatus.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        int intJingleGroupCount = in.readInt();
        for (int intJingle = 0; intJingle < intJingleGroupCount; ++intJingle) {
            JingleGroupDescription o_JingleGroupDescription = new JingleGroupDescription();
            o_JingleGroupDescription.readExternal(in);
            PlayControlStatus o_JingleGroupPlayStatus = new PlayControlStatus();
            o_JingleGroupPlayStatus.readExternal(in);
            this.addJingleGroupDescriptionStatus(o_JingleGroupDescription, o_JingleGroupPlayStatus);
        }
    }

    public void addJingleGroupDescriptionStatus(JingleGroupDescription p_JingleGroupDescription, PlayControlStatus p_Status) {
        if (p_JingleGroupDescription == null) {
            return;
        }
        JingleGroupDescription o_JingleGroupDescriptionNew = new JingleGroupDescription(p_JingleGroupDescription.getJingleGroupID(), p_JingleGroupDescription.getJingleGroupName(), p_JingleGroupDescription.getJingleGroupRemark());
        this.m_JingleGroupDescriptions.add(o_JingleGroupDescriptionNew);
        this.m_JingleGroupPlayStatus.add(p_Status);
    }

    public int getJingleGroupDescriptionCount() {
        return this.m_JingleGroupDescriptions.size();
    }

    public JingleGroupDescription getJingleGroupDescription(int p_Index) {
        if (p_Index < 0 || p_Index >= this.m_JingleGroupDescriptions.size()) {
            return null;
        }
        return this.m_JingleGroupDescriptions.get(p_Index);
    }

    public PlayControlStatus getJingleGroupPlayStatus(int p_Index) {
        if (p_Index < 0 || p_Index >= this.m_JingleGroupPlayStatus.size()) {
            return null;
        }
        return this.m_JingleGroupPlayStatus.get(p_Index);
    }

    public static class PlayControlStatus
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        private boolean m_Start;
        private boolean m_Pause;
        private boolean m_Stop;
        private int m_JingleCount;
        private int m_PlayJingleCount;

        public PlayControlStatus() {
        }

        public PlayControlStatus(boolean p_Start, boolean p_Pause, boolean p_Stop, int p_PlayJingleCount, int p_JingleCount) {
            this.m_Start = p_Start;
            this.m_Pause = p_Pause;
            this.m_Stop = p_Stop;
            this.m_PlayJingleCount = p_PlayJingleCount;
            this.m_JingleCount = p_JingleCount;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeBoolean(this.m_Start);
            out.writeBoolean(this.m_Pause);
            out.writeBoolean(this.m_Stop);
            out.writeInt(this.m_PlayJingleCount);
            out.writeInt(this.m_JingleCount);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            this.m_Start = in.readBoolean();
            this.m_Pause = in.readBoolean();
            this.m_Stop = in.readBoolean();
            this.m_PlayJingleCount = in.readInt();
            this.m_JingleCount = in.readInt();
        }

        public boolean getStartEnabled() {
            return this.m_Start;
        }

        public boolean getPauseEnabled() {
            return this.m_Pause;
        }

        public boolean getStopEnabled() {
            return this.m_Stop;
        }

        public int getPlayJingleCount() {
            return this.m_PlayJingleCount;
        }

        public int getJingleCount() {
            return this.m_JingleCount;
        }
    }

    public static class JingleGroupDescription
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        String m_JingleGroupID;
        String m_JingleGroupName;
        String m_JingleGroupRemark;

        public JingleGroupDescription() {
        }

        public JingleGroupDescription(String p_JingleGroupID, String p_JingleGroupName, String p_JingleGroupRemark) {
            this.m_JingleGroupID = p_JingleGroupID;
            if (this.m_JingleGroupID == null) {
                this.m_JingleGroupID = "null";
            }
            this.m_JingleGroupName = p_JingleGroupName;
            if (this.m_JingleGroupName == null) {
                this.m_JingleGroupName = "null";
            }
            this.m_JingleGroupRemark = p_JingleGroupRemark;
            if (this.m_JingleGroupRemark == null) {
                this.m_JingleGroupRemark = "null";
            }
        }

        public String getJingleGroupID() {
            return this.m_JingleGroupID;
        }

        public String getJingleGroupName() {
            return this.m_JingleGroupName;
        }

        public String getJingleGroupRemark() {
            return this.m_JingleGroupRemark;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeUTF(this.m_JingleGroupID);
            out.writeUTF(this.m_JingleGroupName);
            out.writeUTF(this.m_JingleGroupRemark);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            this.m_JingleGroupID = in.readUTF();
            if ("null".equals(this.m_JingleGroupID)) {
                this.m_JingleGroupID = null;
            }
            this.m_JingleGroupName = in.readUTF();
            this.m_JingleGroupRemark = in.readUTF();
        }
    }
}

