/*
 * Decompiled with CFR 0.152.
 */
package DMXHardwarePackage;

import DMXHardwarePackage.DMXHardwareFeedbackInterface;
import DMXHardwarePackage.DMXHardwareInterface;
import DMXHardwarePackage.DMXHardwarePluginFeedbackInterface;
import DMXHardwarePackage.DMXHardwarePluginInterface;
import DMXHardwarePackage.Enttec_DMX_USB_Pro_Configuration;
import GUIDPackage.HardwareGUID;
import LiveCommSerial.CommSerialPortConnection;
import LiveCommSerial.CommSerialPortEvent;
import LiveCommSerial.CommSerialPortEventListener;
import LiveCommSerial.CommSerialPortException;
import java.awt.Frame;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class Enttec_DMX_USB_Pro
implements DMXHardwareInterface,
CommSerialPortEventListener {
    public static final int SOFTWAREVERSION = 2;
    public static int s_OSFlag = -1;
    public static int s_OSARchitectureFlag = -1;
    public static boolean s_DebugOn = false;
    public static boolean s_DebugFailureOn = false;
    private static final String PARAM_DIVIDER = ";";
    public static final int CONNECTION_TYPE = 1;
    public static final int DMXPLUGINTYPE_MIDI = 2;
    public static final byte LABELSEND_ENABLEAPI2 = 13;
    public static final byte LABELSEND_PORTASSIGNMENT = -116;
    public static final byte LABELSEND_PORT1_WIDGETPARAMETERS = 3;
    public static final byte LABELSEND_PORT2_WIDGETPARAMETERS = -32;
    public static final byte LABELSEND_PORT1_OUTPUT_DMXVALUES = 6;
    public static final byte LABELSEND_PORT2_OUTPUT_DMXVALUES = -95;
    public static final byte LABELSEND_PORT1_RECEIVEDMXVALUES = 8;
    public static final byte LABELSEND_PORT2_RECEIVEDMXVALUES = -68;
    public static final byte LABELRECEIVE_PORT1_DMXVALUES_ALWAYS = 5;
    public static final byte LABELRECEIVE_PORT2_DMXVALUES_ALWAYS = -126;
    public static final byte LABELRECEIVE_PORT1_DMXVALUES_ONLYCHANGED = 9;
    public static final byte LABELRECEIVE_PORT2_DMXVALUES_ONLYCHANGED = -78;
    public static final byte LABELSEND_PORT2_WRITEMIDI = -56;
    public static final byte LABELRECEIVE_PORT2_READMIDI = -118;
    private static final int ANSWER_UNREADY = 0;
    private static final int ANSWER_OK = 1;
    private static final int ANSWER_WRONG = 2;
    private static final int ANSWER_UNEXPECTED = 3;
    public static final int ADDRESS_FIRST = 0;
    public static final int ADDRESS_LAST = 511;
    public static final int REQUESTTIMEOUT = 10000;
    private boolean m_HardwareCheck_OK;
    private byte m_Firmware_LSB;
    private byte m_Firmware_MSB;
    private byte m_DMXOutputBreakTime;
    private byte m_DMXOutputMark;
    private byte m_DMXOutputRate;
    private ArrayList<DMXHardwarePlugIn> m_DMXHardwarePlugIns;
    private String m_ID;
    private ImageIcon m_IconInterface;
    private ImageIcon m_IconLogo;
    private Enttec_DMX_USB_Pro_Configuration m_Enttec_DMX_USB_Pro_Configuration;
    private CommSerialPortConnection m_CommSerialPortConnection;
    private int m_ConnectionStatus;
    private String m_CommPortName;
    private int m_CommBaudrate;
    private Charset m_Charset;
    private EnttecMessage m_ActualEnttecMessage;
    private ArrayList<DMXHardwareFeedbackInterface> m_DMXHardwareFeedbackInterfaces;
    private RequestTimeOut m_RequestTimeOut;
    private boolean m_RequestHardwareReady;
    private final Object m_SyncHardwareFeedbackInterface = new Object();
    private final Object m_SyncRequest = new Object();
    private final Object m_SyncDMXPlugins = new Object();
    public static ArrayList<RequestTimeOut> s_RequestTimeOuts = new ArrayList();
    public static final Object s_SyncRequestTimeOuts = new Object();

    public Enttec_DMX_USB_Pro() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_DMXHardwarePlugIns = new ArrayList(1);
        DMXHardwarePlugIn o_DMXHardwarePlugIn = new DMXHardwarePlugIn(this, 0);
        this.m_DMXHardwarePlugIns.add(o_DMXHardwarePlugIn);
        this.m_HardwareCheck_OK = false;
        this.m_ID = HardwareGUID.getUID();
        this.m_Charset = Charset.forName("ISO-8859-15");
        this.m_ActualEnttecMessage = null;
        this.m_RequestTimeOut = new RequestTimeOut();
        this.m_DMXHardwareFeedbackInterfaces = new ArrayList();
        s_DebugFailureOn = false;
        this.m_CommBaudrate = 230400;
        this.m_ConnectionStatus = 2;
        if (s_OSFlag <= 0) {
            Enttec_DMX_USB_Pro.checkOS();
        }
        this.m_IconInterface = new ImageIcon(this.getClass().getResource("/Image/Interface.png"));
        this.m_IconLogo = new ImageIcon(this.getClass().getResource("/Image/Logo.png"));
        this.m_RequestHardwareReady = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (s_DebugOn) {
            System.out.println(this.getClass().getSimpleName() + " close");
        }
        this.disconnect();
        CommSerialPortConnection o_CommSerialPortConnection = this.m_CommSerialPortConnection;
        if (o_CommSerialPortConnection != null) {
            o_CommSerialPortConnection.close();
        }
        for (int intPlugIn = 0; intPlugIn < this.m_DMXHardwarePlugIns.size(); ++intPlugIn) {
            this.requestDMXPlugConnection(this.m_DMXHardwarePlugIns.get(intPlugIn), null);
        }
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_Enttec_DMX_USB_Pro_Configuration != null) {
                this.m_Enttec_DMX_USB_Pro_Configuration.close();
            }
            if (this.m_DMXHardwareFeedbackInterfaces != null) {
                this.m_DMXHardwareFeedbackInterfaces.clear();
            }
        }
        this.m_IconInterface = null;
        this.m_IconLogo = null;
    }

    public Object getSyncRequest() {
        return this.m_SyncRequest;
    }

    @Override
    public String getID() {
        return this.m_ID;
    }

    @Override
    public void setID(String p_ID) {
        this.m_ID = p_ID == null ? HardwareGUID.getUID() : p_ID;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(2);
        out.writeInt(this.m_DMXHardwarePlugIns.size());
        for (int intPlugIn = 0; intPlugIn < this.m_DMXHardwarePlugIns.size(); ++intPlugIn) {
            DMXHardwarePlugIn o_DMXHardwarePlugIn = this.m_DMXHardwarePlugIns.get(intPlugIn);
            o_DMXHardwarePlugIn.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        if (intSoftwareVersion < 2) {
            int intDMXPlugInType = in.readInt();
            DMXHardwarePlugIn o_DMXHardwarePlugIn = this.m_DMXHardwarePlugIns.get(0);
            o_DMXHardwarePlugIn.setDMXPluginType(intDMXPlugInType);
        } else {
            int intDMXPlugInCount = in.readInt();
            for (int intPlugIn = 0; intPlugIn < intDMXPlugInCount && intPlugIn < this.m_DMXHardwarePlugIns.size(); ++intPlugIn) {
                DMXHardwarePlugIn o_DMXHardwarePlugIn = this.m_DMXHardwarePlugIns.get(intPlugIn);
                o_DMXHardwarePlugIn.readExternal(in);
            }
        }
    }

    @Override
    public ImageIcon getIconInterface() {
        return this.m_IconInterface;
    }

    @Override
    public ImageIcon getIconLogo() {
        return this.m_IconLogo;
    }

    @Override
    public void showConfigurationDialog(Frame p_Frame) {
        if (this.m_Enttec_DMX_USB_Pro_Configuration == null) {
            this.m_Enttec_DMX_USB_Pro_Configuration = new Enttec_DMX_USB_Pro_Configuration(p_Frame, false, this, s_DebugOn);
        }
        this.m_Enttec_DMX_USB_Pro_Configuration.setVisible(true);
        if (this.m_ConnectionStatus != 5) {
            this.m_Enttec_DMX_USB_Pro_Configuration.refreshCommPorts();
        }
    }

    public Enttec_DMX_USB_Pro_Configuration getConfigurationDMX_USB_Pro_Configuration() {
        return this.m_Enttec_DMX_USB_Pro_Configuration;
    }

    @Override
    public void closeConfigurationDialog() {
        if (this.m_Enttec_DMX_USB_Pro_Configuration != null) {
            this.m_Enttec_DMX_USB_Pro_Configuration.setVisible(false);
        }
    }

    public static String staticInterfaceName() {
        return "<html><b>Enttec DMX USB Pro</b></html>";
    }

    @Override
    public String getInterfaceName() {
        return Enttec_DMX_USB_Pro.staticInterfaceName();
    }

    @Override
    public String getInterfaceDescription() {
        return "<html>DMX USBPlugin via virtual CommPort<br>2 x 512 DMX addresses</html>";
    }

    @Override
    public int getInterfaceVersionGroup() {
        return 1;
    }

    public static String staticManufacturerName() {
        return "ENTTEC";
    }

    @Override
    public String getManufacturerName() {
        return Enttec_DMX_USB_Pro.staticManufacturerName();
    }

    @Override
    public String getManufacturerAddress() {
        return "<html><b>ENTTEC EUROPE/b><br>40 Martell Road<br>London SE21 8EN<br>United Kingdom<br></html>";
    }

    @Override
    public String getManufacturerHomepage() {
        return "<html>www.enttec.com</html>";
    }

    @Override
    public int getConnectionType() {
        return 1;
    }

    public void setComm_Port(String p_CommPortName) {
        this.m_CommPortName = p_CommPortName;
    }

    public String getComm_Port() {
        return this.m_CommPortName;
    }

    public void setComm_BaudRate(int p_BaudRate) {
        this.m_CommBaudrate = p_BaudRate;
    }

    public int getComm_BaudRate() {
        return this.m_CommBaudrate;
    }

    public int getComm_DataBits() {
        return 8;
    }

    public int getComm_StopBits() {
        return 1;
    }

    public int getComm_Parity() {
        return 0;
    }

    @Override
    public boolean connect(String p_ConnectionParam) {
        CommSerialPortConnection o_CommSerialPortConnection;
        if (this.m_CommSerialPortConnection == null) {
            this.m_CommSerialPortConnection = new CommSerialPortConnection();
            this.m_CommSerialPortConnection.addCommSerialPortEventListener((CommSerialPortEventListener)this);
        }
        if ((o_CommSerialPortConnection = this.m_CommSerialPortConnection) == null) {
            return false;
        }
        String[] arrayParams = p_ConnectionParam.split(PARAM_DIVIDER);
        if (arrayParams.length < 2) {
            return false;
        }
        this.m_CommPortName = arrayParams[0];
        this.m_CommBaudrate = Integer.valueOf(arrayParams[1]);
        if (s_DebugOn) {
            System.out.println("Enttec DMX USB Pro connect() Param: Port " + this.m_CommPortName + "Baud " + this.m_CommBaudrate);
        }
        boolean boolConnected = o_CommSerialPortConnection.connect(this.m_CommPortName, this.m_CommBaudrate, this.getComm_DataBits(), this.getComm_StopBits(), this.getComm_Parity());
        return boolConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disconnect() {
        Object object = this.m_SyncRequest;
        synchronized (object) {
            CommSerialPortConnection o_CommSerialPortConnection = this.m_CommSerialPortConnection;
            if (o_CommSerialPortConnection == null) {
                return true;
            }
            if (s_DebugOn) {
                System.out.println(this.getClass().getSimpleName() + " disconnect");
            }
            o_CommSerialPortConnection.disconnect();
            this.m_ActualEnttecMessage = null;
        }
        this.setConnectionStatus(2, this.getClass().getName() + " eventCommSerialPortConnection()");
        return true;
    }

    public boolean getIsConnected() {
        return this.m_ConnectionStatus == 5;
    }

    @Override
    public int getConnectionStatus() {
        return this.m_ConnectionStatus;
    }

    @Override
    public int getConnectionStatus(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        return this.m_ConnectionStatus;
    }

    private void setConnectionStatus(int p_ConnectionStatus, String p_Remark) {
        this.m_ConnectionStatus = p_ConnectionStatus;
        for (int intPlugin = 0; intPlugin < this.m_DMXHardwarePlugIns.size(); ++intPlugin) {
            DMXHardwarePlugIn o_DMXHardwarePlugIn = this.m_DMXHardwarePlugIns.get(intPlugin);
            o_DMXHardwarePlugIn.clearPlugInValues();
        }
        this.fireConnectionStatus(p_ConnectionStatus, p_Remark);
    }

    @Override
    public String getConnectionParameters() {
        String stringParams = this.m_CommPortName + PARAM_DIVIDER + String.valueOf(this.m_CommBaudrate);
        return stringParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeBytes(CommSerialPortConnection.ByteArray_Write p_ByteArray_Write, boolean p_WaitForThread) {
        block11: {
            if (p_ByteArray_Write == null) {
                return false;
            }
            CommSerialPortConnection o_CommSerialPortConnection = this.m_CommSerialPortConnection;
            if (o_CommSerialPortConnection == null) {
                return false;
            }
            try {
                this.m_CommSerialPortConnection.write(p_ByteArray_Write);
                if (!p_WaitForThread) break block11;
                Object object = this.m_SyncRequest;
                synchronized (object) {
                    long longWaitStart;
                    this.m_RequestTimeOut.start();
                    for (long longWaitTime = 10000L; longWaitTime > 0L && !this.m_RequestHardwareReady; longWaitTime -= System.nanoTime() / 1000000L - longWaitStart) {
                        longWaitStart = System.nanoTime() / 1000000L;
                        this.m_SyncRequest.wait(longWaitTime);
                    }
                    this.m_RequestTimeOut.stop();
                    if (this.m_RequestTimeOut.isTimedOut(10000L)) {
                        if (s_DebugOn || s_DebugFailureOn) {
                            System.out.println("Enttec DMX USB Pro writeBytes TimedOut");
                        }
                        return false;
                    }
                }
            }
            catch (Exception e) {
                if (s_DebugOn || s_DebugFailureOn) {
                    System.out.println("Enttec DMX USB Pro writeBytes InterruptedException");
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public int getAddressCount() {
        return 512;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDMXHardwareFeedbackInterface(DMXHardwareFeedbackInterface p_DMXHardwareFeedbackInterface) {
        if (p_DMXHardwareFeedbackInterface == null) {
            return;
        }
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.contains(p_DMXHardwareFeedbackInterface)) {
                return;
            }
            this.m_DMXHardwareFeedbackInterfaces.add(p_DMXHardwareFeedbackInterface);
        }
        for (int intPlugIn = 0; intPlugIn < this.m_DMXHardwarePlugIns.size(); ++intPlugIn) {
            p_DMXHardwareFeedbackInterface.eventHardwareConnectionStatus(this, this.m_DMXHardwarePlugIns.get(intPlugIn), this.m_ConnectionStatus, this.getClass().getName() + " addDMXHardwareFeedbackInterface()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDMXHardwareFeedbackInterface(DMXHardwareFeedbackInterface p_DMXHardwareFeedbackInterface) {
        if (p_DMXHardwareFeedbackInterface == null) {
            return;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            boolRemoved = this.m_DMXHardwareFeedbackInterfaces.remove(p_DMXHardwareFeedbackInterface);
        }
    }

    @Override
    public int getDMXPluginCount() {
        return this.m_DMXHardwarePlugIns.size();
    }

    @Override
    public String getDMXPluginInfo(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        if (p_DMXHardwarePluginInterface == null) {
            return "";
        }
        return p_DMXHardwarePluginInterface.getDMXPluginInfo();
    }

    @Override
    public int getDMXPluginType(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        if (p_DMXHardwarePluginInterface == null) {
            return 0;
        }
        return p_DMXHardwarePluginInterface.getDMXPluginType();
    }

    @Override
    public boolean changeDMXPluginType(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_DMXPlugInType) {
        if (p_DMXHardwarePluginInterface == null) {
            return false;
        }
        if (!(p_DMXHardwarePluginInterface instanceof DMXHardwarePlugIn)) {
            return false;
        }
        DMXHardwarePlugIn o_DMXHardwarePlugIn = (DMXHardwarePlugIn)p_DMXHardwarePluginInterface;
        o_DMXHardwarePlugIn.setDMXPluginType(p_DMXPlugInType);
        return true;
    }

    @Override
    public DMXHardwarePluginFeedbackInterface getDMXPluggedInUniverse(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        if (p_DMXHardwarePluginInterface == null) {
            return null;
        }
        return p_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
    }

    @Override
    public boolean requestDMXPlugConnection(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, DMXHardwarePluginFeedbackInterface p_DMXUniverseFeedbackInterface) {
        if (p_DMXHardwarePluginInterface == null) {
            return false;
        }
        return p_DMXHardwarePluginInterface.requestDMXPlugConnection(p_DMXUniverseFeedbackInterface);
    }

    @Override
    public int[] getDMXPluginValues(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        if (p_DMXHardwarePluginInterface == null) {
            return null;
        }
        return p_DMXHardwarePluginInterface.getDMXPluginValues();
    }

    @Override
    public void setDebugOn(boolean p_DebugOn) {
        s_DebugOn = p_DebugOn;
    }

    @Override
    public void setDebugFailureOn(boolean p_DebugOn) {
        s_DebugFailureOn = p_DebugOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestCheckHardware() {
        this.m_HardwareCheck_OK = false;
        boolean boolError = false;
        Object object = this.m_SyncRequest;
        synchronized (object) {
            CommSerialPortConnection.ByteArray_Write o_SendBytes;
            CommSerialPortConnection o_CommSerialPortConnection = this.m_CommSerialPortConnection;
            if (o_CommSerialPortConnection == null) {
                return false;
            }
            if (s_DebugOn) {
                System.out.println("Enttec_DMX_USB_Pro requestCheckHardware");
            }
            if ((o_SendBytes = this.getByteCode_CheckHardware()) == null) {
                return false;
            }
            this.m_RequestHardwareReady = false;
            if (!this.writeBytes(o_SendBytes, true)) {
                boolError = true;
            }
        }
        if (boolError) {
            this.fireCheckConnectionFailed(910, "Request Check Connection TimeOut");
            return false;
        }
        if (this.m_HardwareCheck_OK) {
            DMXHardwarePlugIn o_DMXHardwarePlugIn = (DMXHardwarePlugIn)this.getDMXHardwarePlugin(0);
            o_DMXHardwarePlugIn.setDMXPluginType(o_DMXHardwarePlugIn.getDMXPluginType());
            this.fireCheckConnectionSuccess();
            return true;
        }
        return false;
    }

    private CommSerialPortConnection.ByteArray_Write getByteCode_CheckHardware() {
        CommSerialPortConnection.ByteArray_Write o_ByteArray_Write = CommSerialPortConnection.getByteArrayWrite((int)5);
        byte[] o_ByteCode = o_ByteArray_Write.getByteArray();
        try {
            o_ByteCode[0] = 126;
            o_ByteCode[1] = 3;
            o_ByteCode[2] = 0;
            o_ByteCode[3] = 0;
            o_ByteCode[4] = -25;
        }
        catch (Exception e) {
            return null;
        }
        return o_ByteArray_Write;
    }

    private CommSerialPortConnection.ByteArray_Write getByteCode_EnableAPI2() {
        CommSerialPortConnection.ByteArray_Write o_ByteArray_Write = CommSerialPortConnection.getByteArrayWrite((int)9);
        byte[] o_ByteCode = o_ByteArray_Write.getByteArray();
        try {
            o_ByteCode[0] = 126;
            o_ByteCode[1] = 13;
            o_ByteCode[2] = 4;
            o_ByteCode[3] = 0;
            o_ByteCode[4] = 5;
            o_ByteCode[5] = 9;
            o_ByteCode[6] = -86;
            o_ByteCode[7] = -49;
            o_ByteCode[8] = -25;
        }
        catch (Exception e) {
            return null;
        }
        return o_ByteArray_Write;
    }

    public void refreshPortAssignment() {
    }

    private CommSerialPortConnection.ByteArray_Write getByteCode_PortAssignment() {
        CommSerialPortConnection.ByteArray_Write o_ByteArray_Write = CommSerialPortConnection.getByteArrayWrite((int)7);
        byte[] o_ByteCode = o_ByteArray_Write.getByteArray();
        try {
            int bytePort2Assignment;
            byte bytePort1Assignment;
            o_ByteCode[0] = 126;
            o_ByteCode[1] = -116;
            o_ByteCode[2] = 2;
            o_ByteCode[3] = 0;
            DMXHardwarePluginInterface o_DMXHardwarePluginInterface = this.m_DMXHardwarePlugIns.get(0);
            switch (o_DMXHardwarePluginInterface.getDMXPluginType()) {
                case 0: 
                case 1: {
                    bytePort1Assignment = 1;
                    break;
                }
                default: {
                    bytePort1Assignment = 0;
                }
            }
            o_DMXHardwarePluginInterface = this.m_DMXHardwarePlugIns.get(1);
            switch (o_DMXHardwarePluginInterface.getDMXPluginType()) {
                case 0: 
                case 1: {
                    bytePort2Assignment = 1;
                    break;
                }
                case 2: {
                    bytePort2Assignment = 2;
                    break;
                }
                default: {
                    bytePort2Assignment = 0;
                }
            }
            o_ByteCode[4] = bytePort1Assignment;
            o_ByteCode[5] = bytePort2Assignment;
            o_ByteCode[6] = -25;
        }
        catch (Exception e) {
            return null;
        }
        return o_ByteArray_Write;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseAnswer_CheckHardware(EnttecMessage p_EnttecMessage) {
        boolean boolOk = true;
        if (p_EnttecMessage == null) {
            this.fireCheckConnectionFailed(951, "<html>Wrong Hardware Answer<br> (request Check Hardware) -> <br></html>");
            boolOk = false;
        }
        if (boolOk && p_EnttecMessage.getMessageLabel() != 3) {
            this.fireCheckConnectionFailed(951, "<html>Wrong Hardware Answer<br> (request Check Hardware) -> <br></html>");
            boolOk = false;
        }
        int intMessageDataLength = 0;
        byte[] o_DataArray = null;
        if (boolOk) {
            intMessageDataLength = p_EnttecMessage.getMessageDataLength();
            o_DataArray = p_EnttecMessage.getMessageDataArray();
            if (o_DataArray == null || intMessageDataLength < 5 || o_DataArray.length != intMessageDataLength) {
                this.fireCheckConnectionFailed(951, "<html>Wrong Hardware Answer<br> (request Check Hardware) -> <br></html>");
                boolOk = false;
            }
        }
        if (boolOk) {
            this.m_Firmware_LSB = o_DataArray[0];
            this.m_Firmware_MSB = o_DataArray[1];
            this.m_DMXOutputBreakTime = o_DataArray[2];
            this.m_DMXOutputMark = o_DataArray[3];
            this.m_DMXOutputRate = o_DataArray[4];
            if (this.m_Firmware_MSB != 1) {
                this.fireCheckConnectionFailed(951, "<html>Wrong Firmware please flash DMX-Firmware<br> (request Check Hardware) -> <br></html>");
                boolOk = false;
            }
        }
        this.m_HardwareCheck_OK = boolOk;
        Object object = this.m_SyncRequest;
        synchronized (object) {
            this.m_RequestHardwareReady = true;
            this.m_SyncRequest.notifyAll();
        }
        return boolOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCheckConnectionFailed(int p_ExceptionType, String p_Remark) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        if (s_DebugOn || s_DebugFailureOn) {
            System.out.println(this.getClass().getSimpleName() + " fireCheckConnectionFailed -> disconnect");
        }
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareCheck(this, false, p_Remark);
            o_DMXHardwareFeedbackInterface.eventHardwareException(this, 910, p_Remark);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCheckConnectionSuccess() {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareCheck(this, true, "");
        }
        o_DMXHardwareFeedbackInterfaces.clear();
        if (s_DebugOn) {
            System.out.println(this.getClass().getSimpleName() + " fireCheckConnectionSuccess");
        }
        this.setConnectionStatus(5, this.getClass().getName() + " fireCheckConnectionSuccess()");
    }

    @Override
    public boolean requestHardwareInfo() {
        if (!this.m_HardwareCheck_OK) {
            this.fireHardwareInfoFailed(900, "Hardware Not Checked");
            return false;
        }
        StringBuffer o_StringBuffer = new StringBuffer();
        o_StringBuffer.append("<html>");
        o_StringBuffer.append("Enttec DMX USB Pro");
        o_StringBuffer.append("<br>");
        o_StringBuffer.append("OutputRate: ");
        o_StringBuffer.append(Byte.toUnsignedInt(this.m_DMXOutputRate));
        o_StringBuffer.append("/s");
        o_StringBuffer.append("<br>");
        o_StringBuffer.append("Firmware: ");
        o_StringBuffer.append(Byte.toUnsignedInt(this.m_Firmware_MSB));
        o_StringBuffer.append(" - ");
        o_StringBuffer.append(Byte.toUnsignedInt(this.m_Firmware_LSB));
        o_StringBuffer.append("</html>");
        this.fireHardwareInfoSuccess(o_StringBuffer.toString());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireHardwareInfoFailed(int p_ExceptionType, String p_Remark) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        if (s_DebugOn || s_DebugFailureOn) {
            System.out.println(this.getClass().getSimpleName() + " fireHardwareInfoFailed -> disconnect");
        }
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareException(this, p_ExceptionType, p_Remark);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireHardwareInfoSuccess(String p_Info) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareInfo(this, p_Info);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
    }

    @Override
    public DMXHardwarePluginInterface getDMXHardwarePlugin(int p_Index) {
        if (p_Index < 0 || p_Index >= this.m_DMXHardwarePlugIns.size()) {
            return null;
        }
        return this.m_DMXHardwarePlugIns.get(p_Index);
    }

    @Override
    public DMXHardwarePluginInterface getDMXHardwarePlugin_Output(int p_Index) {
        DMXHardwarePluginInterface o_DMXHardwarePluginInterface = this.getDMXHardwarePlugin(p_Index);
        if (o_DMXHardwarePluginInterface == null) {
            return null;
        }
        if (o_DMXHardwarePluginInterface.getDMXPluginType() == 0) {
            return o_DMXHardwarePluginInterface;
        }
        return null;
    }

    @Override
    public DMXHardwarePluginInterface getDMXHardwarePlugin_Input(int p_Index) {
        DMXHardwarePluginInterface o_DMXHardwarePluginInterface = this.getDMXHardwarePlugin(p_Index);
        if (o_DMXHardwarePluginInterface == null) {
            return null;
        }
        if (o_DMXHardwarePluginInterface.getDMXPluginType() == 1) {
            return o_DMXHardwarePluginInterface;
        }
        return null;
    }

    @Override
    public boolean requestWriteValues(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, ArrayList<Integer> p_ChangedAddresses, int[] p_AllValues) {
        if (p_DMXHardwarePluginInterface == null) {
            return false;
        }
        return p_DMXHardwarePluginInterface.requestWriteValues(p_ChangedAddresses, p_AllValues);
    }

    @Override
    public boolean requestReadValues(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, ArrayList<Integer> p_ChangedAddresses) {
        if (p_DMXHardwarePluginInterface == null) {
            return false;
        }
        if (this.m_CommSerialPortConnection == null) {
            return false;
        }
        return p_DMXHardwarePluginInterface.requestReadValues(p_ChangedAddresses);
    }

    public void eventCommSerialPortConnection(int p_ConnectionStatus) {
        if (s_DebugOn) {
            System.out.println("DMX4All_MiniUSBDMXInterface Comm Connection: " + p_ConnectionStatus);
        }
        switch (p_ConnectionStatus) {
            case 0: {
                this.setConnectionStatus(2, this.getClass().getName() + " eventCommSerialPortConnection()");
                DMXHardwareInterface.s_ConnectedHardwareInterfaces.remove(this);
                break;
            }
            case 1: {
                DMXHardwareInterface.s_ConnectedHardwareInterfaces.add(this);
                this.setConnectionStatus(4, this.getClass().getName() + " eventCommSerialPortConnection()");
            }
        }
    }

    public void eventCommSerialPortComm(CommSerialPortEvent p_CommSerialPortEvent) {
    }

    public void eventCommSerialPortDataReceived(byte[] p_BytesReadenAll, int p_DataLenght) {
        this.parseReceivedBytes(p_BytesReadenAll, p_DataLenght);
    }

    private void parseReceivedBytes(byte[] p_BytesReadenAll, int p_DataLenght) {
        EnttecMessage o_EnttecMessage;
        if (p_BytesReadenAll == null) {
            return;
        }
        if (p_DataLenght <= 0) {
            return;
        }
        int intByteOffset = 0;
        if (this.m_ActualEnttecMessage == null) {
            this.m_ActualEnttecMessage = new EnttecMessage();
        }
        if ((o_EnttecMessage = this.m_ActualEnttecMessage) == null) {
            return;
        }
        while (intByteOffset < p_DataLenght) {
            intByteOffset = o_EnttecMessage.parseBytes(p_BytesReadenAll, intByteOffset, p_DataLenght);
            if (!o_EnttecMessage.getMessageReady()) continue;
            this.parseEnttecMessage(o_EnttecMessage);
            o_EnttecMessage.clear();
        }
    }

    private void parseEnttecMessage(EnttecMessage p_EnttecMessage) {
        if (p_EnttecMessage == null) {
            return;
        }
        byte byteMessageLabel = p_EnttecMessage.getMessageLabel();
        switch (byteMessageLabel) {
            case 3: {
                this.parseAnswer_CheckHardware(p_EnttecMessage);
                break;
            }
            case 5: {
                DMXHardwarePlugIn o_DMXHardwarePlugIn = (DMXHardwarePlugIn)this.getDMXHardwarePlugin(0);
                if (o_DMXHardwarePlugIn == null) {
                    return;
                }
                o_DMXHardwarePlugIn.parseAnswer_ReadValues_Always(p_EnttecMessage);
                break;
            }
            case -126: {
                DMXHardwarePlugIn o_DMXHardwarePlugIn = (DMXHardwarePlugIn)this.getDMXHardwarePlugin(1);
                if (o_DMXHardwarePlugIn == null) {
                    return;
                }
                o_DMXHardwarePlugIn.parseAnswer_ReadValues_Always(p_EnttecMessage);
                break;
            }
            case 9: {
                DMXHardwarePlugIn o_DMXHardwarePlugIn = (DMXHardwarePlugIn)this.getDMXHardwarePlugin(0);
                if (o_DMXHardwarePlugIn == null) {
                    return;
                }
                o_DMXHardwarePlugIn.parseAnswer_ReadValues_OnlyChanged(p_EnttecMessage);
                break;
            }
            case -78: {
                DMXHardwarePlugIn o_DMXHardwarePlugIn = (DMXHardwarePlugIn)this.getDMXHardwarePlugin(1);
                if (o_DMXHardwarePlugIn == null) {
                    return;
                }
                o_DMXHardwarePlugIn.parseAnswer_ReadValues_OnlyChanged(p_EnttecMessage);
                break;
            }
            case -118: {
                DMXHardwarePlugIn o_DMXHardwarePlugIn = (DMXHardwarePlugIn)this.getDMXHardwarePlugin(1);
                if (o_DMXHardwarePlugIn == null) {
                    return;
                }
                o_DMXHardwarePlugIn.parseAnswerReadMIDI(p_EnttecMessage);
            }
        }
    }

    public void eventCommSerialPortException(Exception p_Exception) {
        if (s_DebugOn) {
            System.out.println("Comm Exception: " + p_Exception.toString());
        }
        CommSerialPortException o_CommSerialPortException = (CommSerialPortException)p_Exception;
        switch (o_CommSerialPortException.getExceptionType()) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 64: {
                this.fireException(900, "<html>CommPort Exception<br>" + o_CommSerialPortException.getMessage() + "</html>");
                this.disconnect();
                break;
            }
            case 256: {
                this.fireException(910, "<html>CommPort Exception<br>" + o_CommSerialPortException.getMessage() + "</html>");
                this.disconnect();
                break;
            }
            case 32: {
                this.fireException(900, "<html>CommPort Exception<br>" + o_CommSerialPortException.getMessage() + "</html>");
                this.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionStatus(int p_ConnectionStatus, String p_Remark) {
        int intPlugIn;
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            for (intPlugIn = 0; intPlugIn < this.m_DMXHardwarePlugIns.size(); ++intPlugIn) {
                o_DMXHardwareFeedbackInterface.eventHardwareConnectionStatus(this, this.getDMXHardwarePlugin(intPlugIn), p_ConnectionStatus, p_Remark);
            }
        }
        o_DMXHardwareFeedbackInterfaces.clear();
        for (intPlugIn = 0; intPlugIn < this.m_DMXHardwarePlugIns.size(); ++intPlugIn) {
            DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface;
            Object object2 = this.m_SyncDMXPlugins;
            synchronized (object2) {
                o_DMXUniverseFeedbackInterface = this.getDMXPluggedInUniverse(this.getDMXHardwarePlugin(intPlugIn));
            }
            if (o_DMXUniverseFeedbackInterface == null) continue;
            o_DMXUniverseFeedbackInterface.eventPluginConnectionStatus(this, this.m_DMXHardwarePlugIns.get(0), this.m_ConnectionStatus, p_Remark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePlugStatus(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, DMXHardwarePluginFeedbackInterface p_OldDMXUniverseFeedbackInterface, DMXHardwarePluginFeedbackInterface p_NewDMXUniverseFeedbackInterface) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwarePlugin(this, p_DMXHardwarePluginInterface, p_OldDMXUniverseFeedbackInterface, p_NewDMXUniverseFeedbackInterface);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHardwareInterfacePluginChanged(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwarePluginChanged(this, p_DMXHardwarePluginInterface);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
        DMXHardwarePluginFeedbackInterface o_DMXHardwarePluginFeedbackInterface = this.getDMXPluggedInUniverse(p_DMXHardwarePluginInterface);
        if (o_DMXHardwarePluginFeedbackInterface != null) {
            o_DMXHardwarePluginFeedbackInterface.eventPluginChanged(this, p_DMXHardwarePluginInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireException(int p_ExceptionType, String p_Remark) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareException(this, p_ExceptionType, p_Remark);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
        for (int intPlugIn = 0; intPlugIn < this.m_DMXHardwarePlugIns.size(); ++intPlugIn) {
            DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface;
            Object object2 = this.m_SyncDMXPlugins;
            synchronized (object2) {
                o_DMXUniverseFeedbackInterface = this.getDMXPluggedInUniverse(this.getDMXHardwarePlugin(intPlugIn));
            }
            if (o_DMXUniverseFeedbackInterface == null) continue;
            o_DMXUniverseFeedbackInterface.eventPluginException(this, null, p_ExceptionType, p_Remark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestTimeOut getPool_RequestTimeOut() {
        Object object = s_SyncRequestTimeOuts;
        synchronized (object) {
            if (s_RequestTimeOuts.size() <= 0) {
                RequestTimeOut o_RequestTimeOut = new RequestTimeOut();
                return o_RequestTimeOut;
            }
            RequestTimeOut o_RequestTimeOut = s_RequestTimeOuts.get(s_RequestTimeOuts.size() - 1);
            s_RequestTimeOuts.remove(s_RequestTimeOuts.size() - 1);
            o_RequestTimeOut.initMembers();
            return o_RequestTimeOut;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPool_RequestTimeOut(RequestTimeOut p_RequestTimeOut) {
        if (p_RequestTimeOut == null) {
            return;
        }
        Object object = s_SyncRequestTimeOuts;
        synchronized (object) {
            s_RequestTimeOuts.add(p_RequestTimeOut);
        }
    }

    public static int checkOS() {
        String stringOS = System.getProperty("os.name").toLowerCase();
        s_OSFlag = stringOS.indexOf("win") >= 0 ? (stringOS.indexOf("10") >= 0 ? 5 : (stringOS.indexOf("8") >= 0 ? 4 : (stringOS.indexOf("7") >= 0 ? 3 : (stringOS.indexOf("vista") >= 0 ? 2 : (stringOS.indexOf("xp") >= 0 ? 1 : 0))))) : (stringOS.indexOf("mac") >= 0 ? 1000 : (stringOS.indexOf("nix") >= 0 || stringOS.indexOf("nux") >= 0 ? 100 : (stringOS.indexOf("sunos") >= 0 ? 10000 : -1)));
        return s_OSFlag;
    }

    public static class EnttecMessage {
        public static byte STARTBYTE = (byte)126;
        public static byte ENDBYTE = (byte)-25;
        private byte m_MessageStartByte;
        private boolean m_MessageStartByte_IsSet;
        private byte m_MessageEndByte;
        private boolean m_MessageEndByte_IsSet;
        private byte m_MessageLabel;
        private boolean m_MessageLabel_IsSet;
        private byte m_MessageDataLength_LSB;
        private boolean m_MessageLength_LSB_IsSet;
        private byte m_MessageDataLength_MSB;
        private boolean m_MessageLength_MSB_IsSet;
        private int m_MessageDataLength;
        private byte[] m_MessageDataArray;
        private int m_MessageDataBytesReceived;
        private boolean m_MessageReady;

        public EnttecMessage() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_MessageStartByte = 0;
            this.m_MessageStartByte_IsSet = false;
            this.m_MessageEndByte = 0;
            this.m_MessageEndByte_IsSet = false;
            this.m_MessageLabel = 0;
            this.m_MessageLabel_IsSet = false;
            this.m_MessageDataLength_LSB = 0;
            this.m_MessageLength_LSB_IsSet = false;
            this.m_MessageDataLength_MSB = 0;
            this.m_MessageLength_MSB_IsSet = false;
            this.m_MessageDataLength = 0;
            this.m_MessageDataArray = null;
            this.m_MessageDataBytesReceived = 0;
            this.m_MessageReady = false;
        }

        public void clear() {
            this.m_MessageStartByte = 0;
            this.m_MessageStartByte_IsSet = false;
            this.m_MessageEndByte = 0;
            this.m_MessageEndByte_IsSet = false;
            this.m_MessageLabel = 0;
            this.m_MessageLabel_IsSet = false;
            this.m_MessageDataLength_LSB = 0;
            this.m_MessageLength_LSB_IsSet = false;
            this.m_MessageDataLength_MSB = 0;
            this.m_MessageLength_MSB_IsSet = false;
            this.m_MessageDataLength = 0;
            this.m_MessageDataArray = null;
            this.m_MessageDataBytesReceived = 0;
            this.m_MessageReady = false;
        }

        public int parseBytes(byte[] p_BytesReadenAll, int p_Offset, int p_DataLenght) {
            if (p_BytesReadenAll == null) {
                return -1;
            }
            if (p_DataLenght <= 0) {
                return -1;
            }
            int intBytesOffset = p_Offset;
            if (intBytesOffset < p_DataLenght && !this.m_MessageStartByte_IsSet) {
                this.m_MessageStartByte = p_BytesReadenAll[intBytesOffset];
                ++intBytesOffset;
                if (this.m_MessageStartByte != STARTBYTE) {
                    while (intBytesOffset < p_DataLenght - 1 && this.m_MessageStartByte != STARTBYTE) {
                        this.m_MessageStartByte = p_BytesReadenAll[intBytesOffset];
                        ++intBytesOffset;
                    }
                    if (this.m_MessageStartByte != STARTBYTE) {
                        return intBytesOffset;
                    }
                }
                this.m_MessageStartByte_IsSet = true;
            }
            if (intBytesOffset < p_DataLenght && !this.m_MessageLabel_IsSet) {
                this.m_MessageLabel = p_BytesReadenAll[intBytesOffset];
                this.m_MessageLabel_IsSet = true;
                ++intBytesOffset;
            }
            if (intBytesOffset < p_DataLenght && !this.m_MessageLength_LSB_IsSet) {
                this.m_MessageDataLength_LSB = p_BytesReadenAll[intBytesOffset];
                this.m_MessageLength_LSB_IsSet = true;
                ++intBytesOffset;
            }
            if (intBytesOffset < p_DataLenght && !this.m_MessageLength_MSB_IsSet) {
                this.m_MessageDataLength_MSB = p_BytesReadenAll[intBytesOffset];
                this.m_MessageLength_MSB_IsSet = true;
                ++intBytesOffset;
                this.m_MessageDataLength = Byte.toUnsignedInt(this.m_MessageDataLength_MSB) * 256 + Byte.toUnsignedInt(this.m_MessageDataLength_LSB);
                if (this.m_MessageDataLength > 0) {
                    this.m_MessageDataArray = new byte[this.m_MessageDataLength];
                    this.m_MessageDataBytesReceived = 0;
                }
            }
            while (intBytesOffset < p_DataLenght && this.m_MessageDataBytesReceived < this.m_MessageDataLength) {
                this.m_MessageDataArray[this.m_MessageDataBytesReceived] = p_BytesReadenAll[intBytesOffset];
                ++this.m_MessageDataBytesReceived;
                ++intBytesOffset;
            }
            if (intBytesOffset < p_DataLenght && !this.m_MessageEndByte_IsSet) {
                this.m_MessageEndByte = p_BytesReadenAll[intBytesOffset];
                if (this.m_MessageEndByte != ENDBYTE) {
                    // empty if block
                }
                this.m_MessageEndByte_IsSet = true;
                ++intBytesOffset;
                this.m_MessageReady = true;
            }
            return intBytesOffset;
        }

        public boolean getMessageReady() {
            return this.m_MessageReady;
        }

        public byte getMessageLabel() {
            return this.m_MessageLabel;
        }

        public int getMessageDataLength() {
            return this.m_MessageDataLength;
        }

        public byte[] getMessageDataArray() {
            return this.m_MessageDataArray;
        }
    }

    public static class RequestTimeOut {
        Long m_DateStart;
        Long m_DateEnd;
        boolean m_Closed;
        final Object m_SyncObject = new Object();

        public RequestTimeOut() {
            this.initMembers();
        }

        public void initMembers() {
            this.m_DateStart = System.nanoTime() / 1000000L;
            this.m_DateEnd = null;
            this.m_Closed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_Closed) {
                    return;
                }
                this.m_Closed = true;
                Enttec_DMX_USB_Pro.addPool_RequestTimeOut(this);
            }
        }

        public void start() {
            this.m_DateStart = System.nanoTime() / 1000000L;
            this.m_DateEnd = null;
        }

        public long stop() {
            this.m_DateEnd = System.nanoTime() / 1000000L;
            return this.getTimeUsed();
        }

        public boolean isTimedOut(long p_MillisecondsOfAllowedDuration) {
            return this.m_DateEnd != null ? this.m_DateEnd - this.m_DateStart >= p_MillisecondsOfAllowedDuration : System.nanoTime() / 1000000L - this.m_DateStart >= p_MillisecondsOfAllowedDuration;
        }

        public long getTimeUsed() {
            if (this.m_DateEnd != null) {
                return this.m_DateEnd - this.m_DateStart;
            }
            return System.nanoTime() / 1000000L - this.m_DateStart;
        }
    }

    public static class DMXHardwarePlugIn
    implements DMXHardwarePluginInterface,
    Externalizable {
        public static final int SOFTWAREVERSION = 1;
        private int m_Index;
        private Enttec_DMX_USB_Pro m_DMXHardwareInterface;
        private DMXHardwarePluginFeedbackInterface m_PluggedUniverse;
        private int m_DMXPluginType;
        private int[] m_ArrayPluginValues;
        private int[] m_ArrayAllNewValues;

        public DMXHardwarePlugIn(Enttec_DMX_USB_Pro p_DMXHardwareInterface, int p_Index) {
            this.m_DMXHardwareInterface = p_DMXHardwareInterface;
            this.m_Index = p_Index;
            this.initMembers();
        }

        private void initMembers() {
            this.m_DMXPluginType = 0;
            this.m_ArrayPluginValues = new int[512];
            this.m_ArrayAllNewValues = new int[512];
            this.m_PluggedUniverse = null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeInt(this.m_DMXPluginType);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            this.m_DMXPluginType = in.readInt();
        }

        public void clearPlugInValues() {
            for (int intValue = 0; intValue < this.m_ArrayPluginValues.length; ++intValue) {
                this.m_ArrayPluginValues[intValue] = 0;
            }
            if (this.m_DMXHardwareInterface.getConnectionStatus() == 5) {
                this.setDMXPluginType(this.m_DMXPluginType);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean requestDMXPlugConnection(DMXHardwarePluginFeedbackInterface p_DMXUniverseFeedbackInterface) {
            DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface = this.getDMXPluggedInUniverse();
            if (o_DMXUniverseFeedbackInterface == p_DMXUniverseFeedbackInterface) {
                return true;
            }
            if (o_DMXUniverseFeedbackInterface != null) {
                o_DMXUniverseFeedbackInterface.eventPlugin(this.m_DMXHardwareInterface, this, null);
            }
            Object object = this.m_DMXHardwareInterface.getSyncRequest();
            synchronized (object) {
                this.m_PluggedUniverse = p_DMXUniverseFeedbackInterface;
            }
            if (p_DMXUniverseFeedbackInterface != null) {
                p_DMXUniverseFeedbackInterface.eventPlugin(this.m_DMXHardwareInterface, this, p_DMXUniverseFeedbackInterface);
            }
            this.m_DMXHardwareInterface.firePlugStatus(this, o_DMXUniverseFeedbackInterface, p_DMXUniverseFeedbackInterface);
            if (p_DMXUniverseFeedbackInterface != null) {
                switch (this.m_DMXPluginType) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.fireReadValuesSuccess(this, this.m_ArrayPluginValues);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean requestWriteValues(ArrayList<Integer> p_ChangedAddresses, int[] p_AllValues) {
            if (this.m_DMXPluginType != 0) {
                return false;
            }
            if (p_AllValues == null) {
                return false;
            }
            int intAddressCount = p_ChangedAddresses.size();
            if (intAddressCount <= 0) {
                return true;
            }
            if (this.m_ArrayAllNewValues == null) {
                this.m_ArrayAllNewValues = new int[p_AllValues.length];
            }
            System.arraycopy(p_AllValues, 0, this.m_ArrayAllNewValues, 0, p_AllValues.length);
            DMXHardwarePluginFeedbackInterface o_DMXHardwarePluginFeedbackInterface = this.getDMXPluggedInUniverse();
            if (o_DMXHardwarePluginFeedbackInterface == null) {
                return false;
            }
            boolean boolError = false;
            Object object = this.m_DMXHardwareInterface.getSyncRequest();
            synchronized (object) {
                if (o_DMXHardwarePluginFeedbackInterface == null) {
                    return false;
                }
                CommSerialPortConnection.ByteArray_Write o_SendBytes = this.getByteCode_WriteValuesMultiple(0, 511, this.m_ArrayAllNewValues);
                if (o_SendBytes == null) {
                    return false;
                }
                if (!this.m_DMXHardwareInterface.writeBytes(o_SendBytes, false)) {
                    boolError = true;
                }
            }
            if (boolError) {
                this.fireWriteValuesFailed(this, 952, "Cannot send requestWriteValues");
                return false;
            }
            return this.parseAnswer_WriteValuesMultiple(this, 0, 511, p_AllValues);
        }

        private CommSerialPortConnection.ByteArray_Write getByteCode_WriteValuesMultiple(int p_AddressFirst, int p_AddressLast, int[] p_AllValues) {
            CommSerialPortConnection.ByteArray_Write o_ByteArray_Write = CommSerialPortConnection.getByteArrayWrite((int)518);
            byte[] o_ByteCode = o_ByteArray_Write.getByteArray();
            try {
                o_ByteCode[0] = 126;
                o_ByteCode[1] = this.m_Index == 0 ? 6 : -95;
                o_ByteCode[2] = 1;
                o_ByteCode[3] = 2;
            }
            catch (Exception e) {
                return null;
            }
            o_ByteCode[4] = 0;
            for (int intByte = 0; intByte < p_AllValues.length; ++intByte) {
                o_ByteCode[5 + intByte] = (byte)(p_AllValues[intByte] & 0xFF);
            }
            o_ByteCode[517] = -25;
            return o_ByteArray_Write;
        }

        public boolean parseAnswer_WriteValuesMultiple(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_StartAddress, int p_EndAddress, int[] p_AllValues) {
            int intAddressCount = p_EndAddress - p_StartAddress + 1;
            System.arraycopy(p_AllValues, p_StartAddress, this.m_ArrayPluginValues, p_StartAddress, intAddressCount);
            this.fireWriteValuesSuccess(p_DMXHardwarePluginInterface, this.m_ArrayPluginValues);
            return true;
        }

        private void fireWriteValuesFailed(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_ExceptionType, String p_Remark) {
            DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface;
            if (p_DMXHardwarePluginInterface == null) {
                return;
            }
            if (s_DebugOn || s_DebugFailureOn) {
                System.out.println(this.getClass().getSimpleName() + " DMXOutput: " + p_DMXHardwarePluginInterface.getDMXPluginInfo() + " fireWriteValuesFailed");
            }
            if ((o_DMXUniverseFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse()) == null) {
                return;
            }
            o_DMXUniverseFeedbackInterface.eventPluginException(this.m_DMXHardwareInterface, p_DMXHardwarePluginInterface, p_ExceptionType, p_Remark);
        }

        private void fireWriteValuesSuccess(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int[] p_AllInterfaceValues) {
            if (p_DMXHardwarePluginInterface == null) {
                return;
            }
            DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
            if (o_DMXUniverseFeedbackInterface == null) {
                return;
            }
            o_DMXUniverseFeedbackInterface.eventPluginWriteValues(this.m_DMXHardwareInterface, p_DMXHardwarePluginInterface, p_AllInterfaceValues);
            if (s_DebugOn) {
                System.out.println(this.getClass().getSimpleName() + " DMXOutput: " + p_DMXHardwarePluginInterface.getDMXPluginInfo() + " fireWriteValuesSuccess");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean requestReadValues(ArrayList<Integer> p_Addresses) {
            if (this.m_DMXPluginType != 1) {
                return false;
            }
            DMXHardwarePluginFeedbackInterface o_DMXHardwarePluginFeedbackInterface = this.getDMXPluggedInUniverse();
            if (o_DMXHardwarePluginFeedbackInterface == null) {
                return false;
            }
            boolean boolError = false;
            Object object = this.m_DMXHardwareInterface.getSyncRequest();
            synchronized (object) {
                if (o_DMXHardwarePluginFeedbackInterface == null) {
                    return false;
                }
                CommSerialPortConnection.ByteArray_Write o_SendBytes = this.getByteCode_ReadValuesOnlyChanged();
                if (o_SendBytes == null) {
                    return false;
                }
                if (!this.m_DMXHardwareInterface.writeBytes(o_SendBytes, false)) {
                    boolError = true;
                }
            }
            if (boolError) {
                this.fireReadValuesFailed(this, 952, "Cannot send requestReadValues");
                return false;
            }
            return true;
        }

        private CommSerialPortConnection.ByteArray_Write getByteCode_ReadValuesOnlyChanged() {
            CommSerialPortConnection.ByteArray_Write o_ByteArray_Write = CommSerialPortConnection.getByteArrayWrite((int)6);
            byte[] o_ByteCode = o_ByteArray_Write.getByteArray();
            try {
                o_ByteCode[0] = 126;
                o_ByteCode[1] = this.m_Index == 0 ? 8 : -68;
                o_ByteCode[2] = 1;
                o_ByteCode[3] = 0;
            }
            catch (Exception e) {
                return null;
            }
            o_ByteCode[4] = 1;
            o_ByteCode[5] = -25;
            return o_ByteArray_Write;
        }

        private boolean parseAnswer_ReadValues_Always(EnttecMessage p_EnttecMessage) {
            byte byteReceiveStatus;
            if (this.m_DMXHardwareInterface.getConnectionStatus() != 5) {
                return false;
            }
            if (this.m_DMXPluginType != 1) {
                return false;
            }
            boolean boolOK = true;
            if (p_EnttecMessage == null) {
                this.fireReadValuesFailed(this, 951, "<html>Wrong Hardware Answer<br> (read values) -> <br></html>");
                boolOK = false;
            }
            int intMessageDataLength = 0;
            byte[] o_DataArray = null;
            if (boolOK) {
                intMessageDataLength = p_EnttecMessage.getMessageDataLength();
                o_DataArray = p_EnttecMessage.getMessageDataArray();
                if (o_DataArray == null || o_DataArray.length != intMessageDataLength) {
                    this.fireReadValuesFailed(this, 951, "<html>Wrong Hardware Answer<br> (request Check Hardware) -> <br></html>");
                    boolOK = false;
                }
            }
            if (boolOK && (byteReceiveStatus = o_DataArray[0]) != 0) {
                if (byteReceiveStatus >> 1 != 0) {
                    boolOK = false;
                }
                if ((byteReceiveStatus & 2) != 0) {
                    boolOK = false;
                }
            }
            if (boolOK) {
                for (int intIndex = 1; intIndex < o_DataArray.length; ++intIndex) {
                    this.m_ArrayPluginValues[intIndex - 1] = Byte.toUnsignedInt(o_DataArray[intIndex]);
                }
            }
            if (boolOK) {
                this.fireReadValuesSuccess(this, this.m_ArrayPluginValues);
            }
            return boolOK;
        }

        private boolean parseAnswer_ReadValues_OnlyChanged(EnttecMessage p_EnttecMessage) {
            if (this.m_DMXHardwareInterface.getConnectionStatus() != 5) {
                return false;
            }
            if (this.m_DMXPluginType != 1) {
                return false;
            }
            boolean boolOK = true;
            if (p_EnttecMessage == null) {
                this.fireReadValuesFailed(this, 951, "<html>Wrong Hardware Answer<br> (read values) -> <br></html>");
                boolOK = false;
            }
            int intMessageDataLength = 0;
            byte[] o_DataArray = null;
            if (boolOK) {
                intMessageDataLength = p_EnttecMessage.getMessageDataLength();
                o_DataArray = p_EnttecMessage.getMessageDataArray();
                if (o_DataArray == null || o_DataArray.length != intMessageDataLength) {
                    this.fireReadValuesFailed(this, 951, "<html>Wrong Hardware Answer<br> (request Check Hardware) -> <br></html>");
                    boolOK = false;
                }
            }
            int intStartByteNumber = 0;
            if (boolOK && (intStartByteNumber = Byte.toUnsignedInt(o_DataArray[0])) < 0) {
                boolOK = false;
            }
            if (boolOK) {
                byte[] o_BitArray = new byte[5];
                System.arraycopy(o_DataArray, 1, o_BitArray, 0, 5);
                byte o_BitMuster = 1;
                int intChangedByteIndex = 6;
                for (int intBitByte = 0; intBitByte < 5; ++intBitByte) {
                    byte o_BitByte = o_BitArray[intBitByte];
                    for (int intBit = 0; intBit < 8; ++intBit) {
                        if ((o_BitByte & o_BitMuster) != 0) {
                            try {
                                int intValue;
                                int intValueByte = intBitByte * 8 + intBit;
                                this.m_ArrayPluginValues[intStartByteNumber * 8 + intValueByte - 1] = intValue = Byte.toUnsignedInt(o_DataArray[intChangedByteIndex]);
                                ++intChangedByteIndex;
                            }
                            catch (Exception e) {
                                boolOK = false;
                            }
                        }
                        o_BitMuster = (byte)(o_BitMuster * 2);
                    }
                    o_BitMuster = 1;
                }
            }
            if (boolOK) {
                this.fireReadValuesSuccess(this, this.m_ArrayPluginValues);
            }
            return boolOK;
        }

        private void fireReadValuesFailed(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_ExceptionType, String p_Remark) {
            DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface;
            if (p_DMXHardwarePluginInterface == null) {
                return;
            }
            if (s_DebugOn || s_DebugFailureOn) {
                System.out.println(this.getClass().getSimpleName() + " DMXOutput: " + p_DMXHardwarePluginInterface.getDMXPluginInfo() + " fireWriteValuesFailed");
            }
            if ((o_DMXUniverseFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse()) == null) {
                return;
            }
            o_DMXUniverseFeedbackInterface.eventPluginException(this.m_DMXHardwareInterface, p_DMXHardwarePluginInterface, p_ExceptionType, p_Remark);
        }

        private void fireReadValuesSuccess(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int[] p_AllInterfaceValues) {
            if (p_DMXHardwarePluginInterface == null) {
                return;
            }
            DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
            if (o_DMXUniverseFeedbackInterface == null) {
                return;
            }
            o_DMXUniverseFeedbackInterface.eventPluginReadValues(this.m_DMXHardwareInterface, p_DMXHardwarePluginInterface, p_AllInterfaceValues);
            if (s_DebugOn) {
                System.out.println(this.getClass().getSimpleName() + " DMXOutput: " + p_DMXHardwarePluginInterface.getDMXPluginInfo() + " fireWriteValuesSuccess");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean requestWriteMIDIMessage(byte[] p_MIDIMesageBytes) {
            if (p_MIDIMesageBytes == null) {
                return false;
            }
            if (this.m_DMXPluginType != 2) {
                return false;
            }
            boolean boolError = false;
            Object object = this.m_DMXHardwareInterface.getSyncRequest();
            synchronized (object) {
                CommSerialPortConnection.ByteArray_Write o_SendBytes = this.getByteCode_WriteMIDI(p_MIDIMesageBytes);
                if (o_SendBytes == null) {
                    return false;
                }
                if (!this.m_DMXHardwareInterface.writeBytes(o_SendBytes, false)) {
                    boolError = true;
                }
            }
            if (boolError) {
                this.fireWriteMIDIFailed(this, 952, "Cannot send requestWriteMIDIMessage");
                return false;
            }
            this.fireWriteMIDSuccess(this, p_MIDIMesageBytes);
            return true;
        }

        private CommSerialPortConnection.ByteArray_Write getByteCode_WriteMIDI(byte[] p_MIDIMessageBytes) {
            if (p_MIDIMessageBytes == null) {
                return null;
            }
            int intMIDIMessageLength = p_MIDIMessageBytes.length;
            CommSerialPortConnection.ByteArray_Write o_ByteArray_Write = CommSerialPortConnection.getByteArrayWrite((int)(5 + intMIDIMessageLength));
            byte[] o_ByteCode = o_ByteArray_Write.getByteArray();
            try {
                o_ByteCode[0] = 126;
                o_ByteCode[1] = -56;
                o_ByteCode[2] = (byte)(intMIDIMessageLength & 0xFF);
                o_ByteCode[3] = (byte)((intMIDIMessageLength & 0xFF00) >> 8);
            }
            catch (Exception e) {
                return null;
            }
            o_ByteCode[4] = 1;
            o_ByteCode[5] = -25;
            return o_ByteArray_Write;
        }

        public boolean parseAnswerReadMIDI(EnttecMessage p_EnttecMessage) {
            if (this.m_DMXHardwareInterface.getConnectionStatus() != 5) {
                return false;
            }
            if (this.m_DMXPluginType != 1) {
                return false;
            }
            boolean boolOK = true;
            if (p_EnttecMessage == null) {
                this.fireReadValuesFailed(this, 951, "<html>Wrong Hardware Answer<br> (read values) -> <br></html>");
                boolOK = false;
            }
            int intMessageDataLength = 0;
            byte[] o_DataArray = null;
            if (boolOK) {
                intMessageDataLength = p_EnttecMessage.getMessageDataLength();
                o_DataArray = p_EnttecMessage.getMessageDataArray();
                if (o_DataArray == null || o_DataArray.length != intMessageDataLength) {
                    this.fireReadMIDIFailed(this, 951, "<html>Wrong Hardware Answer<br> (readMIDI) -> <br></html>");
                    boolOK = false;
                }
            }
            if (boolOK) {
                this.fireReadMIDISuccess(this, o_DataArray);
            }
            return boolOK;
        }

        private void fireWriteMIDIFailed(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_ExceptionType, String p_Remark) {
            DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface;
            if (p_DMXHardwarePluginInterface == null) {
                return;
            }
            if (s_DebugOn || s_DebugFailureOn) {
                System.out.println(this.getClass().getSimpleName() + " DMXOutput: " + p_DMXHardwarePluginInterface.getDMXPluginInfo() + " fireWriteValuesFailed");
            }
            if ((o_DMXUniverseFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse()) == null) {
                return;
            }
            o_DMXUniverseFeedbackInterface.eventPluginException(this.m_DMXHardwareInterface, p_DMXHardwarePluginInterface, p_ExceptionType, p_Remark);
        }

        private void fireWriteMIDSuccess(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, byte[] p_MIDIMessage) {
            if (p_DMXHardwarePluginInterface == null) {
                return;
            }
            DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
            if (o_DMXUniverseFeedbackInterface == null) {
                return;
            }
            o_DMXUniverseFeedbackInterface.eventPluginWriteMIDIMessage(this.m_DMXHardwareInterface, p_DMXHardwarePluginInterface, p_MIDIMessage);
            if (s_DebugOn) {
                System.out.println(this.getClass().getSimpleName() + " Write MIDI message: " + p_DMXHardwarePluginInterface.getDMXPluginInfo() + " fireWriteMIDSuccess");
            }
        }

        private void fireReadMIDIFailed(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_ExceptionType, String p_Remark) {
            DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface;
            if (p_DMXHardwarePluginInterface == null) {
                return;
            }
            if (s_DebugOn || s_DebugFailureOn) {
                System.out.println(this.getClass().getSimpleName() + " Error MIDI received: " + p_DMXHardwarePluginInterface.getDMXPluginInfo() + " fireReadMIDIFailed");
            }
            if ((o_DMXUniverseFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse()) == null) {
                return;
            }
            o_DMXUniverseFeedbackInterface.eventPluginException(this.m_DMXHardwareInterface, p_DMXHardwarePluginInterface, p_ExceptionType, p_Remark);
        }

        private void fireReadMIDISuccess(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, byte[] p_MIDIDMessage) {
            if (p_DMXHardwarePluginInterface == null) {
                return;
            }
            DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
            if (o_DMXUniverseFeedbackInterface == null) {
                return;
            }
            o_DMXUniverseFeedbackInterface.eventPluginReadMIDIMessage(this.m_DMXHardwareInterface, p_DMXHardwarePluginInterface, p_MIDIDMessage);
            if (s_DebugOn) {
                System.out.println(this.getClass().getSimpleName() + " MIDI received: " + p_DMXHardwarePluginInterface.getDMXPluginInfo() + " fireReadMIDISuccess");
            }
        }

        @Override
        public int getPluginIndex() {
            return this.m_Index;
        }

        @Override
        public DMXHardwareInterface getDMXHardwareInterface() {
            return this.m_DMXHardwareInterface;
        }

        @Override
        public String getDMXPluginInfo() {
            StringBuilder stringInfo = new StringBuilder();
            stringInfo.append(this.getPluginIndex() + 1);
            stringInfo.append(") ");
            if (this.m_DMXPluginType == 0) {
                stringInfo.append("Output");
            } else if (this.m_DMXPluginType == 1) {
                stringInfo.append("Input");
            } else if (this.m_DMXPluginType == 2) {
                stringInfo.append("MIDI");
            }
            return stringInfo.toString();
        }

        public void setDMXPluginType(int p_DMXPluginType) {
            boolean boolChanged = false;
            switch (p_DMXPluginType) {
                case 0: {
                    if (this.m_DMXPluginType != p_DMXPluginType) {
                        boolChanged = true;
                    }
                    this.m_DMXPluginType = p_DMXPluginType;
                    break;
                }
                case 1: {
                    if (this.m_DMXPluginType != p_DMXPluginType) {
                        boolChanged = true;
                    }
                    this.m_DMXPluginType = p_DMXPluginType;
                    break;
                }
                case 2: {
                    if (this.m_DMXPluginType != p_DMXPluginType) {
                        boolChanged = true;
                    }
                    this.m_DMXPluginType = p_DMXPluginType;
                    break;
                }
            }
            if (boolChanged) {
                this.m_DMXHardwareInterface.fireHardwareInterfacePluginChanged(this);
                for (int intIndex = 0; intIndex < this.m_ArrayPluginValues.length; ++intIndex) {
                    this.m_ArrayPluginValues[intIndex] = 0;
                }
            }
            switch (this.m_DMXPluginType) {
                case 0: {
                    this.m_DMXHardwareInterface.refreshPortAssignment();
                    CommSerialPortConnection.ByteArray_Write o_SendBytes = this.getByteCode_WriteValuesMultiple(0, 511, this.m_ArrayPluginValues);
                    this.m_DMXHardwareInterface.writeBytes(o_SendBytes, false);
                    break;
                }
                case 1: {
                    this.m_DMXHardwareInterface.refreshPortAssignment();
                    CommSerialPortConnection.ByteArray_Write o_SendBytes = this.getByteCode_ReadValuesOnlyChanged();
                    this.m_DMXHardwareInterface.writeBytes(o_SendBytes, false);
                    break;
                }
                case 2: {
                    this.m_DMXHardwareInterface.refreshPortAssignment();
                    CommSerialPortConnection.ByteArray_Write o_SendBytes = this.getByteCode_ReadValuesOnlyChanged();
                    this.m_DMXHardwareInterface.writeBytes(o_SendBytes, false);
                }
            }
        }

        @Override
        public int getDMXPluginType() {
            return this.m_DMXPluginType;
        }

        @Override
        public boolean changeDMXPluginType(int p_DMXPlugInType) {
            return true;
        }

        @Override
        public DMXHardwarePluginFeedbackInterface getDMXPluggedInUniverse() {
            return this.m_PluggedUniverse;
        }

        @Override
        public int[] getDMXPluginValues() {
            return this.m_ArrayPluginValues;
        }

        @Override
        public void propertyChanged(DMXHardwarePluginFeedbackInterface p_DMXHardwarePluginFeedbackInterface) {
            this.m_DMXHardwareInterface.fireHardwareInterfacePluginChanged(this);
        }

        @Override
        public int getConnectionStatus() {
            Enttec_DMX_USB_Pro o_DMXHardwareInterface = this.m_DMXHardwareInterface;
            if (o_DMXHardwareInterface == null) {
                return 0;
            }
            return o_DMXHardwareInterface.getConnectionStatus();
        }
    }
}

