/*
 * Decompiled with CFR 0.152.
 */
package ClientPackage;

import ClientPackage.LiveDBClientListener;
import ClientPackage.LiveDBClientWrapperInterface;
import SocketManagementPackage.LiveDBAdminThread;
import SocketManagementPackage.LiveDBSocketChannelManagement;
import SocketManagementPackage.LiveDBStream;
import SocketMessagePackage.LiveDBConnectionDescription;
import SocketMessagePackage.LiveDBMessageSocketClose;
import SocketMessagePackage.LiveDBMessageStreamCancel;
import SocketMessagePackage.LiveDBMessageStreamInfo;
import SocketPackage.LiveDBSocket;
import SocketPackage.LiveDBSocketListener;
import SynchronizationPackage.LiveDBCloseSemaphore;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class LiveDBClient
implements LiveDBSocketListener {
    private String m_ID;
    private LiveDBConnectionDescription m_LiveDBConnectionDescription;
    private LiveDBSocket m_LiveDBSocket;
    private ArrayList<LiveDBClientListener> m_LiveDBClientListeners;
    private LiveDBClientWrapperInterface m_LiveDBClientWrapper;
    private LiveDBCloseSemaphore m_LiveDBCloseSemaphore;
    private final Object m_SyncClientListeners = new Object();

    public static LiveDBClient createLiveDBClient_ClientSide(LiveDBConnectionDescription p_ClientConnectionDescription) {
        LiveDBClient o_LiveDBClient = new LiveDBClient(p_ClientConnectionDescription);
        return o_LiveDBClient;
    }

    public LiveDBClient(LiveDBConnectionDescription p_ClientConnectionDescription) {
        this.initMembers();
        this.m_LiveDBSocket = new LiveDBSocket(p_ClientConnectionDescription);
        this.m_ID = this.m_LiveDBSocket.getID();
        this.m_LiveDBConnectionDescription = this.m_LiveDBSocket.getLiveDBConnectionDescription();
        this.m_LiveDBSocket.addLiveDBSocketListener((LiveDBSocketListener)this);
    }

    public static LiveDBClient createLiveDBClient_ServerSide(LiveDBSocket p_ClientLiveDBSocket) {
        LiveDBClient o_LiveDBClient = new LiveDBClient(p_ClientLiveDBSocket);
        return o_LiveDBClient;
    }

    public LiveDBClient(LiveDBSocket p_LiveDBSocket) {
        this.initMembers();
        this.m_LiveDBSocket = p_LiveDBSocket;
        this.m_ID = p_LiveDBSocket.getID();
        this.m_LiveDBConnectionDescription = p_LiveDBSocket.getLiveDBConnectionDescription();
        if (this.m_LiveDBSocket != null) {
            this.m_LiveDBSocket.addLiveDBSocketListener((LiveDBSocketListener)this);
        }
        this.m_LiveDBClientWrapper = null;
    }

    private void initMembers() {
        this.m_LiveDBCloseSemaphore = new LiveDBCloseSemaphore(this.getClass().getName());
        this.m_LiveDBClientListeners = new ArrayList();
    }

    public void close() {
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                LiveDBClient.this.handleClose();
            }
        };
        LiveDBAdminThread o_LiveDBAdminThread = LiveDBSocketChannelManagement.getLiveDBAdminThread();
        if (o_LiveDBAdminThread != null) {
            if (Thread.currentThread() == o_LiveDBAdminThread.getThread()) {
                o_Runnable.run();
            } else {
                o_LiveDBAdminThread.addRunnable(o_Runnable);
            }
        } else {
            o_Runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleClose() {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        switch (this.getConnectionStatus()) {
            case 2: 
            case 3: {
                this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                LiveDBSocketChannelManagement.actionCloseLiveDBSocket((LiveDBSocket)this.m_LiveDBSocket);
                return;
            }
            case 1: {
                break;
            }
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        if (!this.m_LiveDBCloseSemaphore.enterCloseSection()) {
            return;
        }
        if (this.m_LiveDBClientWrapper != null) {
            this.m_LiveDBClientWrapper.eventClientWillClose(this);
            this.m_LiveDBClientWrapper = null;
        }
        if (this.m_LiveDBSocket != null) {
            LiveDBSocketChannelManagement.actionCloseLiveDBSocket((LiveDBSocket)this.m_LiveDBSocket);
        }
        this.notifyClientListener_ConnectionStatus(0);
        Object object = this.m_SyncClientListeners;
        synchronized (object) {
            if (this.m_LiveDBClientListeners != null) {
                this.m_LiveDBClientListeners.clear();
                this.m_LiveDBClientListeners = null;
            }
        }
        this.m_LiveDBSocket = null;
        this.m_LiveDBCloseSemaphore.leaveCloseSection();
    }

    public void closeSuddenly() {
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                LiveDBClient.this.handleCloseSuddenly();
            }
        };
        LiveDBAdminThread o_LiveDBAdminThread = LiveDBSocketChannelManagement.getLiveDBAdminThread();
        if (o_LiveDBAdminThread != null) {
            if (Thread.currentThread() == o_LiveDBAdminThread.getThread()) {
                o_Runnable.run();
            } else {
                o_LiveDBAdminThread.addRunnable(o_Runnable);
            }
        } else {
            o_Runnable.run();
        }
    }

    public void handleCloseSuddenly() {
        this.setConnectionStatus(9);
        LiveDBSocketChannelManagement.actionCloseLiveDBSocket((LiveDBSocket)this.m_LiveDBSocket);
    }

    public LiveDBSocket getLiveDBSocket() {
        return this.m_LiveDBSocket;
    }

    public String getID() {
        return this.m_ID;
    }

    public LiveDBConnectionDescription getLiveDBConnectionDescription() {
        return this.m_LiveDBConnectionDescription;
    }

    public int getConnectionStatus() {
        LiveDBSocket o_LiveDBSocket = this.m_LiveDBSocket;
        if (o_LiveDBSocket == null) {
            return 0;
        }
        return o_LiveDBSocket.getConnectionStatus();
    }

    public void setConnectionStatus(int p_ConnectionStatus) {
        LiveDBSocket o_LiveDBSocket = this.m_LiveDBSocket;
        if (o_LiveDBSocket == null) {
            return;
        }
        o_LiveDBSocket.setConnectionStatus(p_ConnectionStatus);
    }

    public boolean isConnected() {
        LiveDBSocket o_LiveDBSocket = this.m_LiveDBSocket;
        if (o_LiveDBSocket == null) {
            return false;
        }
        return o_LiveDBSocket.isConnected();
    }

    public void connect() {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        LiveDBSocket o_LiveDBSocket = this.m_LiveDBSocket;
        if (o_LiveDBSocket != null) {
            o_LiveDBSocket.connect(this.m_LiveDBConnectionDescription.getClientLocalPort());
        }
    }

    public void sendMessage(Serializable p_MessageObject) {
        if (p_MessageObject == null) {
            return;
        }
        LiveDBSocket o_LiveDBSocket = this.m_LiveDBSocket;
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (o_LiveDBSocket == null) {
            this.m_LiveDBCloseSemaphore.leaveWorkerSection();
            return;
        }
        o_LiveDBSocket.addOutgoingMessage((Object)p_MessageObject);
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public LiveDBStream sendMessageAsStream(Serializable p_MessageObject, int p_Priority) {
        if (p_MessageObject == null) {
            return null;
        }
        LiveDBSocket o_LiveDBSocket = this.m_LiveDBSocket;
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        if (o_LiveDBSocket == null) {
            this.m_LiveDBCloseSemaphore.leaveWorkerSection();
            return null;
        }
        LiveDBStream o_LiveDBStream = o_LiveDBSocket.addOutgoingMessageAsStream(p_MessageObject, p_Priority);
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_LiveDBStream;
    }

    public LiveDBStream sendMessageAsStream(InputStream p_InputStream, int p_DataType, int p_Priority, long p_DataBytesCount, String p_Remark) {
        if (p_InputStream == null) {
            return null;
        }
        LiveDBSocket o_LiveDBSocket = this.m_LiveDBSocket;
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        if (o_LiveDBSocket == null) {
            this.m_LiveDBCloseSemaphore.leaveWorkerSection();
            return null;
        }
        LiveDBStream o_LiveDBStream = o_LiveDBSocket.addOutgoingMessageAsStream(p_InputStream, p_DataType, p_Priority, p_DataBytesCount, p_Remark);
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_LiveDBStream;
    }

    public void eventError(Exception p_Exception, String p_Remark) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.notifyClientListener_Error(p_Exception, p_Remark);
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public void eventSocketConnectionStatus(LiveDBSocket p_LiveDBSocket, int p_ConnectionStatus) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        switch (p_ConnectionStatus) {
            case 0: {
                this.close();
                this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                return;
            }
        }
        this.notifyClientListener_ConnectionStatus(p_ConnectionStatus);
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public void eventSocketMessageReadUnknown(LiveDBSocket p_LiveDBSocket) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.notifyClientListener_MessageReadUnknown();
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventSocketMessageWritten(LiveDBSocket p_LiveDBSocket, Object p_MessageObject) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.notifyClientListener_MessageWritten(p_MessageObject);
        if (p_MessageObject instanceof LiveDBMessageSocketClose) {
            Object o_SyncWaitClose;
            Object object = o_SyncWaitClose = new Object();
            synchronized (object) {
                try {
                    o_SyncWaitClose.wait(20L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            LiveDBSocketChannelManagement.finishCloseLiveDBSocket((LiveDBSocket)p_LiveDBSocket);
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public void eventSocketError(LiveDBSocket p_LiveDBSocket, Exception p_Exception, String p_Remark) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.notifyClientListener_Error(p_Exception, p_Remark);
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public void parseMessage(LiveDBSocket p_LiveDBSocket, Serializable p_MessageObject) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        this.notifyClientListener_ParseMessage(p_MessageObject);
    }

    public void parseMessageIncomingStreamStart(LiveDBSocket p_LiveDBSocket, LiveDBStream p_IncomingStream, LiveDBMessageStreamInfo p_StreamInfo) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.notifyClientListener_ParseMessageIncomingStreamStart(p_IncomingStream, p_StreamInfo);
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public void parseMessageIncomingStreamEnd(LiveDBSocket p_LiveDBSocket, LiveDBStream p_IncomingStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.notifyClientListener_ParseMessageIncomingStreamEnd(p_IncomingStream, p_EndOfStream, p_Canceled, p_Error, p_CancelRemark);
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public void parseMessageIncomingStreamPackage(LiveDBSocket p_LiveDBSocket, LiveDBStream p_IncomingStream, long p_ReceivedBytes) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.notifyClientListener_ParseMessageIncomingStreamPackage(p_IncomingStream, p_ReceivedBytes);
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public void parseMessageOutgoingStreamStart(LiveDBSocket p_LiveDBSocket, LiveDBStream p_OutgoingStream, LiveDBMessageStreamInfo p_StreamInfo) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.notifyClientListener_ParseMessageOutgoingStreamStart(p_OutgoingStream, p_StreamInfo);
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public void parseMessageOutgoingStreamEnd(LiveDBSocket p_LiveDBSocket, LiveDBStream p_OutgoingStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.notifyClientListener_ParseMessageOutgoingStreamEnd(p_OutgoingStream, p_EndOfStream, p_Canceled, p_Error, p_CancelRemark);
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public void parseMessageOutgoingStreamConfirmed(LiveDBSocket p_LiveDBSocket, LiveDBStream p_OutgoingStream, long p_ReceivedBytes) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.notifyClientListener_ParseMessageStreamConfirmed(p_OutgoingStream, p_ReceivedBytes);
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public void cancelIncomingStream(LiveDBMessageStreamInfo p_StreamInfo, String p_CancelRemark) {
        if (p_StreamInfo == null) {
            return;
        }
        this.cancelIncomingStream(p_StreamInfo.getStreamID(), p_CancelRemark);
    }

    public void cancelIncomingStream(String p_StreamID, String p_CancelRemark) {
        if (p_StreamID == null) {
            return;
        }
        LiveDBMessageStreamCancel o_LiveDBMessageStreamCancel = new LiveDBMessageStreamCancel(p_StreamID, p_CancelRemark);
        this.sendMessage((Serializable)o_LiveDBMessageStreamCancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClientListener_ConnectionStatus(int p_ConnectionStatus) {
        Object[] o_Listeners = null;
        Object object = this.m_SyncClientListeners;
        synchronized (object) {
            if (this.m_LiveDBClientListeners == null) {
                return;
            }
            o_Listeners = this.m_LiveDBClientListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientListener o_LiveDBClientListener = (LiveDBClientListener)o_Listeners[intListener];
                if (o_LiveDBClientListener == null) continue;
                o_LiveDBClientListener.eventClientConnectionStatus(this, p_ConnectionStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClientListener_MessageReadUnknown() {
        Object[] o_Listeners = null;
        Object object = this.m_SyncClientListeners;
        synchronized (object) {
            if (this.m_LiveDBClientListeners == null) {
                return;
            }
            o_Listeners = this.m_LiveDBClientListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientListener o_LiveDBClientListener = (LiveDBClientListener)o_Listeners[intListener];
                if (o_LiveDBClientListener == null) continue;
                o_LiveDBClientListener.eventClientMessageReadUnknown(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClientListener_MessageWritten(Object p_MessageObject) {
        Object[] o_Listeners = null;
        Object object = this.m_SyncClientListeners;
        synchronized (object) {
            if (this.m_LiveDBClientListeners == null) {
                return;
            }
            o_Listeners = this.m_LiveDBClientListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientListener o_LiveDBClientListener = (LiveDBClientListener)o_Listeners[intListener];
                if (o_LiveDBClientListener == null) continue;
                o_LiveDBClientListener.eventClientMessageWritten(this, p_MessageObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClientListener_Error(Exception p_Exception, String p_Remark) {
        Object[] o_Listeners = null;
        Object object = this.m_SyncClientListeners;
        synchronized (object) {
            if (this.m_LiveDBClientListeners == null) {
                return;
            }
            o_Listeners = this.m_LiveDBClientListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientListener o_LiveDBClientListener = (LiveDBClientListener)o_Listeners[intListener];
                if (o_LiveDBClientListener == null) continue;
                o_LiveDBClientListener.eventClientError(this, p_Exception, p_Remark);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClientListener_ParseMessage(Serializable p_Message) {
        Object[] o_Listeners = null;
        Object object = this.m_SyncClientListeners;
        synchronized (object) {
            if (this.m_LiveDBClientListeners == null) {
                return;
            }
            o_Listeners = this.m_LiveDBClientListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientListener o_LiveDBClientListener = (LiveDBClientListener)o_Listeners[intListener];
                if (o_LiveDBClientListener == null) continue;
                o_LiveDBClientListener.parseMessage(this, p_Message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClientListener_ParseMessageIncomingStreamStart(LiveDBStream p_LiveDBStream, LiveDBMessageStreamInfo p_StreamInfo) {
        Object[] o_Listeners = null;
        Object object = this.m_SyncClientListeners;
        synchronized (object) {
            if (this.m_LiveDBClientListeners == null) {
                return;
            }
            o_Listeners = this.m_LiveDBClientListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientListener o_LiveDBClientListener = (LiveDBClientListener)o_Listeners[intListener];
                if (o_LiveDBClientListener == null) continue;
                o_LiveDBClientListener.parseMessageIncomingStreamStart(this, p_LiveDBStream, p_StreamInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClientListener_ParseMessageIncomingStreamEnd(LiveDBStream p_LiveDBStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
        Object[] o_Listeners = null;
        Object object = this.m_SyncClientListeners;
        synchronized (object) {
            if (this.m_LiveDBClientListeners == null) {
                return;
            }
            o_Listeners = this.m_LiveDBClientListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientListener o_LiveDBClientListener = (LiveDBClientListener)o_Listeners[intListener];
                if (o_LiveDBClientListener == null) continue;
                o_LiveDBClientListener.parseMessageIncomingStreamEnd(this, p_LiveDBStream, p_EndOfStream, p_Canceled, p_Error, p_CancelRemark);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClientListener_ParseMessageIncomingStreamPackage(LiveDBStream p_LiveDBStream, long p_ValidBytesCount) {
        Object[] o_Listeners = null;
        Object object = this.m_SyncClientListeners;
        synchronized (object) {
            if (this.m_LiveDBClientListeners == null) {
                return;
            }
            o_Listeners = this.m_LiveDBClientListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientListener o_LiveDBClientListener = (LiveDBClientListener)o_Listeners[intListener];
                if (o_LiveDBClientListener == null) continue;
                o_LiveDBClientListener.parseMessageIncomingStreamPackage(this, p_LiveDBStream, p_ValidBytesCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClientListener_ParseMessageOutgoingStreamStart(LiveDBStream p_LiveDBStream, LiveDBMessageStreamInfo p_StreamInfo) {
        Object[] o_Listeners = null;
        Object object = this.m_SyncClientListeners;
        synchronized (object) {
            if (this.m_LiveDBClientListeners == null) {
                return;
            }
            o_Listeners = this.m_LiveDBClientListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientListener o_LiveDBClientListener = (LiveDBClientListener)o_Listeners[intListener];
                if (o_LiveDBClientListener == null) continue;
                o_LiveDBClientListener.parseMessageOutgoingStreamStart(this, p_LiveDBStream, p_StreamInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClientListener_ParseMessageOutgoingStreamEnd(LiveDBStream p_LiveDBStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
        Object[] o_Listeners = null;
        Object object = this.m_SyncClientListeners;
        synchronized (object) {
            if (this.m_LiveDBClientListeners == null) {
                return;
            }
            o_Listeners = this.m_LiveDBClientListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientListener o_LiveDBClientListener = (LiveDBClientListener)o_Listeners[intListener];
                if (o_LiveDBClientListener == null) continue;
                o_LiveDBClientListener.parseMessageOutgoingStreamEnd(this, p_LiveDBStream, p_EndOfStream, p_Canceled, p_Error, p_CancelRemark);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClientListener_ParseMessageStreamConfirmed(LiveDBStream p_LiveDBStream, long p_ReceivedBytesCount) {
        Object[] o_Listeners = null;
        Object object = this.m_SyncClientListeners;
        synchronized (object) {
            if (this.m_LiveDBClientListeners == null) {
                return;
            }
            o_Listeners = this.m_LiveDBClientListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientListener o_LiveDBClientListener = (LiveDBClientListener)o_Listeners[intListener];
                if (o_LiveDBClientListener == null) continue;
                o_LiveDBClientListener.parseMessageOutgoingStreamConfirmed(this, p_LiveDBStream, p_ReceivedBytesCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLiveDBClientListener(LiveDBClientListener p_LiveDBClientListener) {
        if (p_LiveDBClientListener == null) {
            return;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncClientListeners;
        synchronized (object) {
            if (this.m_LiveDBClientListeners != null && !this.m_LiveDBClientListeners.contains(p_LiveDBClientListener)) {
                this.m_LiveDBClientListeners.add(p_LiveDBClientListener);
            }
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveDBClientListener removeLiveDBClientListener(int p_Index) {
        LiveDBClientListener o_LiveDBClientListener;
        if (p_Index < 0) {
            return null;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Object object = this.m_SyncClientListeners;
        synchronized (object) {
            o_LiveDBClientListener = this.m_LiveDBClientListeners == null || p_Index < 0 || p_Index >= this.m_LiveDBClientListeners.size() ? null : this.m_LiveDBClientListeners.remove(p_Index);
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_LiveDBClientListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLiveDBClientListener(LiveDBClientListener p_LiveDBClientListener) {
        boolean boolRemoved;
        if (p_LiveDBClientListener == null) {
            return false;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        Object object = this.m_SyncClientListeners;
        synchronized (object) {
            boolRemoved = this.m_LiveDBClientListeners == null ? false : this.m_LiveDBClientListeners.remove(p_LiveDBClientListener);
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLiveDBClientListenersCount() {
        int intLiveDBClientListenersCount;
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return 0;
        }
        Object object = this.m_SyncClientListeners;
        synchronized (object) {
            intLiveDBClientListenersCount = this.m_LiveDBClientListeners == null ? 0 : this.m_LiveDBClientListeners.size();
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return intLiveDBClientListenersCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveDBClientListener getLiveDBClientListener(int p_Index) {
        LiveDBClientListener o_LiveDBClientListener;
        if (p_Index < 0) {
            return null;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Object object = this.m_SyncClientListeners;
        synchronized (object) {
            o_LiveDBClientListener = this.m_LiveDBClientListeners == null || p_Index < 0 || p_Index >= this.m_LiveDBClientListeners.size() ? null : this.m_LiveDBClientListeners.get(p_Index);
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_LiveDBClientListener;
    }

    public void setLiveDBClientWrapper(LiveDBClientWrapperInterface p_LiveDBClientWrapper) {
        LiveDBClientWrapperInterface o_LiveDBClientWrapper = this.m_LiveDBClientWrapper;
        if (o_LiveDBClientWrapper != null) {
            o_LiveDBClientWrapper.eventClientChangeWrapper(this, p_LiveDBClientWrapper);
        }
        this.m_LiveDBClientWrapper = p_LiveDBClientWrapper;
    }

    public LiveDBClientWrapperInterface getLiveDBClientWrapper() {
        return this.m_LiveDBClientWrapper;
    }
}

