/*
 * Decompiled with CFR 0.152.
 */
package MediaPlayerPackage;

import MediaObjectPackage.MediaSource;
import MediaPlayerPackage.FFmpeg_VideoFrameConverter;
import MediaPlayerPackage.LiveShow_MediaPlayer;
import OS.OSChecker;
import SoundPackage.SoundMixers;
import TimerPackage.JavaTimer;
import ToolsGraphics.ImagesTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import org.bytedeco.javacv.FFmpegFrameFilter;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameFilter;
import org.bytedeco.javacv.FrameGrabber;

public class LiveShow_MediaPlayer_Video_FFmpeg
extends LiveShow_MediaPlayer {
    public static long TIMETOLERANCE_WHILEPLAY = 350L;
    public static long TIMETOLERANCE_WHILEPAUSE = 100L;
    private static final double SC16 = 32767.5;
    private File m_VideoFile;
    private AudioFormat m_AudioFormat_Buffer;
    private AudioFormat m_AudioFormat_Output;
    private FFmpegFrameGrabber m_FFmpegFrameGrabber;
    private FFmpegFrameFilter m_FrameFilter_Audio;
    private boolean m_HasVideo;
    private boolean m_HasAudio;
    private long m_MinimalTimeStamp_Video;
    private long m_MinimalTimeStamp_Video_Milliseconds;
    private long m_MaximalTimeStamp_Video;
    private long m_MaximalTimeStamp_Video_Milliseconds;
    private FFmpegFrameGrabber m_Grabber_SnapShot;
    private boolean m_Grabber_Video_OK;
    private long m_Duration;
    private long m_ActualPlayTime;
    private long m_ActualPlayTime_Old;
    private boolean m_IsPlaying;
    private boolean m_IsInsideObject;
    private boolean m_ShouldPlay;
    private boolean m_ShouldSetTime;
    private boolean m_SoundDelayChanged;
    private Thread m_PlayThread;
    private final Object m_SyncPlay = new Object();
    private boolean m_Released;
    private VideoPlayBuffer m_VideoPlayBuffer;
    private AudioPlayBuffer m_AudioPlayBuffer;
    private boolean m_ReleasedSnapShot;
    private final Object m_SyncSnapShot = new Object();
    public static ArrayList<LiveShow_MediaPlayer_Video_FFmpeg> s_MediaPlayers_FFmpeg = new ArrayList();
    public static final Object s_SyncMediaPlayers = new Object();
    private Runnable m_RunnablePlay = new Runnable(){

        @Override
        public void run() {
            LiveShow_MediaPlayer_Video_FFmpeg.this.play();
        }
    };
    private static int FRAMETYPE_VIDEO = 1;
    private static int FRAMETYPE_SOUND = 2;
    private static BufferedImage s_BufferedImage_Sound = ImagesTools.convertToBufferedImage((Icon)new ImageIcon(LiveShow_MediaPlayer_Video_FFmpeg.class.getResource("/IconsPackage/Loudspeaker_128.png")));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addMediaPlayer_FFmpeg(LiveShow_MediaPlayer_Video_FFmpeg p_MediaPlayer_Video_FFmpeg) {
        if (p_MediaPlayer_Video_FFmpeg == null) {
            return;
        }
        Object object = s_SyncMediaPlayers;
        synchronized (object) {
            if (s_MediaPlayers_FFmpeg.contains(p_MediaPlayer_Video_FFmpeg)) {
                return;
            }
            s_MediaPlayers_FFmpeg.add(p_MediaPlayer_Video_FFmpeg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeMediaPlayer_FFmpeg(LiveShow_MediaPlayer_Video_FFmpeg p_MediaPlayer_Video_FFmpeg) {
        if (p_MediaPlayer_Video_FFmpeg == null) {
            return;
        }
        Object object = s_SyncMediaPlayers;
        synchronized (object) {
            s_MediaPlayers_FFmpeg.remove(p_MediaPlayer_Video_FFmpeg);
        }
    }

    public static int getMediaPlayer_FFmpegCount() {
        return s_MediaPlayers_FFmpeg.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiveShow_MediaPlayer_Video_FFmpeg getMediaPlayer_FFmpeg(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = s_SyncMediaPlayers;
        synchronized (object) {
            if (p_Index >= s_MediaPlayers_FFmpeg.size()) {
                return null;
            }
            return s_MediaPlayers_FFmpeg.get(p_Index);
        }
    }

    public LiveShow_MediaPlayer_Video_FFmpeg(MediaSource p_MediaSource) {
        super(p_MediaSource);
        this.initMembers();
        AudioFormat o_AudioFormat_Default = SoundMixers.DEFAULT_AUDIOFORMAT;
        this.m_AudioFormat_Output = new AudioFormat(o_AudioFormat_Default.getEncoding(), o_AudioFormat_Default.getSampleRate(), o_AudioFormat_Default.getSampleSizeInBits(), o_AudioFormat_Default.getChannels(), o_AudioFormat_Default.getFrameSize(), o_AudioFormat_Default.getFrameRate(), o_AudioFormat_Default.isBigEndian());
        LiveShow_MediaPlayer_Video_FFmpeg.addMediaPlayer_FFmpeg(this);
    }

    private void initMembers() {
        this.m_VideoFile = null;
        this.m_AudioFormat_Buffer = null;
        this.m_AudioFormat_Output = null;
        this.m_FFmpegFrameGrabber = null;
        this.m_FrameFilter_Audio = null;
        this.m_Grabber_Video_OK = false;
        this.m_Duration = -1L;
        this.m_HasVideo = false;
        this.m_HasAudio = false;
        this.m_VideoPlayBuffer = null;
        this.m_AudioPlayBuffer = null;
        this.m_ActualPlayTime = -1L;
        this.m_ActualPlayTime_Old = -1L;
        this.m_MinimalTimeStamp_Video = 0L;
        this.m_MinimalTimeStamp_Video_Milliseconds = 0L;
        this.m_MaximalTimeStamp_Video = 0L;
        this.m_MaximalTimeStamp_Video_Milliseconds = 0L;
        this.m_IsPlaying = false;
        this.m_IsInsideObject = false;
        this.m_ShouldPlay = false;
        this.m_ShouldSetTime = false;
        this.m_SoundDelayChanged = false;
        this.m_Released = false;
        this.m_PlayThread = null;
        this.m_ReleasedSnapShot = false;
        this.m_SoundVolume = 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            if (this.m_Closed) {
                return;
            }
        }
        super.close();
        LiveShow_MediaPlayer_Video_FFmpeg.removeMediaPlayer_FFmpeg(this);
        this.release();
        this.releaseSnapShot();
        if (!this.m_WillDestroy) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void release() {
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            if (this.m_Released) {
                return;
            }
            this.m_Released = true;
        }
        object = this.m_SyncPlay;
        synchronized (object) {
            this.m_SyncPlay.notifyAll();
        }
        if (this.m_PlayThread != null) {
            try {
                this.m_PlayThread.join(7000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_PlayThread = null;
        this.releaseAudioPlayBuffer();
        this.releaseVideoPlayBuffer();
        this.m_HasAudio = false;
        this.m_HasVideo = false;
        if (this.m_FFmpegFrameGrabber != null) {
            try {
                this.m_FFmpegFrameGrabber.stop();
                this.m_FFmpegFrameGrabber.release();
                this.m_FFmpegFrameGrabber.close();
            }
            catch (FrameGrabber.Exception e) {
                boolean bl = false;
            }
        }
        object = this.m_SyncPlay;
        synchronized (object) {
            this.m_FFmpegFrameGrabber = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseAudioPlayBuffer() {
        FFmpegFrameFilter o_FFmpegFrameFilter;
        AudioPlayBuffer o_AudioPlayBuffer;
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            o_AudioPlayBuffer = this.m_AudioPlayBuffer;
        }
        if (o_AudioPlayBuffer != null) {
            o_AudioPlayBuffer.close();
            object = this.m_SyncMediaPlayer;
            synchronized (object) {
                this.m_AudioPlayBuffer = null;
                this.m_AudioFormat_Buffer = null;
            }
        }
        object = this.m_SyncMediaPlayer;
        synchronized (object) {
            o_FFmpegFrameFilter = this.m_FrameFilter_Audio;
        }
        if (o_FFmpegFrameFilter != null) {
            try {
                o_FFmpegFrameFilter.close();
                object = this.m_SyncMediaPlayer;
                synchronized (object) {
                    this.m_FrameFilter_Audio = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseVideoPlayBuffer() {
        VideoPlayBuffer o_VideoPlayBuffer;
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            o_VideoPlayBuffer = this.m_VideoPlayBuffer;
        }
        if (o_VideoPlayBuffer != null) {
            o_VideoPlayBuffer.close();
            object = this.m_SyncMediaPlayer;
            synchronized (object) {
                this.m_VideoPlayBuffer = null;
            }
        }
    }

    @Override
    public void destroy() {
        if (this.m_Destroyed) {
            return;
        }
        this.m_WillDestroy = true;
        if (!this.m_Closed) {
            this.close();
        }
        super.destroy();
    }

    public static int getThreadCount_CPUCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initPlay(File p_File) {
        int intCPUThreads = LiveShow_MediaPlayer_Video_FFmpeg.getThreadCount_CPUCores();
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            if (this.m_Closed) {
                return false;
            }
        }
        this.m_FFmpegFrameGrabber = new FFmpegFrameGrabber(p_File);
        if (this.m_FFmpegFrameGrabber == null) {
            return false;
        }
        if (OSChecker.getIsMac()) {
            this.m_FFmpegFrameGrabber.setOption("hwaccel", "auto");
        } else if (OSChecker.getIsWindows()) {
            this.m_FFmpegFrameGrabber.setOption("hwaccel", "auto");
        } else if (OSChecker.getIsLinux()) {
            this.m_FFmpegFrameGrabber.setOption("hwaccel", "auto");
        }
        if (intCPUThreads < 4) {
            intCPUThreads = 4;
        }
        if (intCPUThreads > 8) {
            intCPUThreads = 8;
        }
        this.m_FFmpegFrameGrabber.setOption("threads", String.valueOf(intCPUThreads));
        this.m_FFmpegFrameGrabber.setVideoOption("threads", String.valueOf(intCPUThreads));
        this.m_FFmpegFrameGrabber.setAudioOption("threads", String.valueOf(intCPUThreads));
        if (p_File.getName().lastIndexOf(".mov") > 0) {
            this.m_FFmpegFrameGrabber.setPixelFormat(27);
        }
        try {
            this.m_FFmpegFrameGrabber.start();
            this.m_HasVideo = this.m_FFmpegFrameGrabber.hasVideo();
            this.m_HasAudio = this.m_FFmpegFrameGrabber.hasAudio();
            this.m_Duration = this.m_FFmpegFrameGrabber.getLengthInTime() / 1000L;
            if (this.m_HasVideo) {
                int intOriginHeight = this.m_FFmpegFrameGrabber.getImageHeight();
                int intOriginWidth = this.m_FFmpegFrameGrabber.getImageWidth();
                double doubleAspectRatio = this.m_FFmpegFrameGrabber.getAspectRatio();
                Dimension o_Dimension_Nearest = LiveShow_MediaPlayer_Video_FFmpeg.findNearestRenderDimension(this.m_RenderSize);
                int intNewHeight = intOriginHeight;
                int intNewWidth = intOriginWidth;
                if (o_Dimension_Nearest.height != intOriginHeight || o_Dimension_Nearest.width != intOriginWidth) {
                    double doubleFactorHeight = (double)o_Dimension_Nearest.height / (double)intOriginHeight;
                    doubleFactorHeight = 200.0;
                    double doubleFactorWidth = (double)o_Dimension_Nearest.width / (double)intOriginWidth;
                    double doubleSizeFactor = (double)intOriginWidth / (double)intOriginHeight;
                    if (doubleFactorWidth < doubleFactorHeight) {
                        intNewWidth = o_Dimension_Nearest.width;
                        intNewHeight = (int)((double)o_Dimension_Nearest.width / doubleSizeFactor + 0.5);
                    } else {
                        intNewHeight = o_Dimension_Nearest.height;
                        intNewWidth = (int)((double)o_Dimension_Nearest.height * doubleSizeFactor + 0.5);
                    }
                    this.m_FFmpegFrameGrabber.setImageWidth(intNewWidth);
                    this.m_FFmpegFrameGrabber.setImageHeight(intNewHeight);
                    intOriginHeight = intNewHeight;
                    intOriginWidth = intNewWidth;
                }
                if (doubleAspectRatio != 1.0 && doubleAspectRatio > 0.0) {
                    doubleAspectRatio *= (double)intNewWidth / (double)intNewHeight;
                    if (intNewWidth >= intNewHeight) {
                        intOriginHeight = (int)((double)intOriginWidth / doubleAspectRatio + 0.5);
                    } else {
                        intOriginWidth = (int)((double)intOriginHeight * doubleAspectRatio + 0.5);
                    }
                }
                this.setPlayerGrabSize(new Dimension(intOriginWidth, intOriginHeight));
                this.initVideo(this.m_FFmpegFrameGrabber);
            }
            if (this.m_HasAudio) {
                this.initAudio(this.m_FFmpegFrameGrabber);
            }
            this.m_Grabber_Video_OK = true;
            this.m_Released = false;
            this.m_PlayThread = new Thread(this.m_RunnablePlay, "Thread_MediaPlayer_Video_PlayThread");
            this.m_PlayThread.start();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void initVideo(FFmpegFrameGrabber p_FrameGrabber) {
        if (p_FrameGrabber == null) {
            return;
        }
        Frame o_Frame = null;
        this.m_VideoPlayBuffer = new VideoPlayBuffer(this, p_FrameGrabber.getVideoFrameRate());
        long longFrameTime = p_FrameGrabber.getLengthInTime();
        try {
            p_FrameGrabber.setTimestamp(0L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            o_Frame = p_FrameGrabber.grab();
            while (o_Frame != null && o_Frame.image == null) {
                o_Frame = p_FrameGrabber.grab();
            }
        }
        catch (FFmpegFrameGrabber.Exception exception) {
            // empty catch block
        }
        if (o_Frame != null && o_Frame.image != null) {
            this.m_MinimalTimeStamp_Video = o_Frame.timestamp;
            this.m_MinimalTimeStamp_Video_Milliseconds = this.m_MinimalTimeStamp_Video / 1000L;
            this.m_VideoPlayBuffer.preAllocateBufferedImages(o_Frame);
        }
        try {
            p_FrameGrabber.setTimestamp(longFrameTime);
        }
        catch (FFmpegFrameGrabber.Exception exception) {
            // empty catch block
        }
        while ((o_Frame == null || o_Frame.image == null) && longFrameTime > 0L) {
            try {
                p_FrameGrabber.setTimestamp(longFrameTime);
                o_Frame = p_FrameGrabber.grabFrame(false, true, false, false, true);
                longFrameTime -= TIMETOLERANCE_WHILEPAUSE / 2L * 1000L;
            }
            catch (FFmpegFrameGrabber.Exception exception) {}
        }
        if (o_Frame != null && o_Frame.image != null) {
            this.m_MaximalTimeStamp_Video = o_Frame.timestamp;
            this.m_MaximalTimeStamp_Video_Milliseconds = this.m_MaximalTimeStamp_Video / 1000L;
        }
        this.setFade(0.0f, true);
    }

    private void initAudio(FFmpegFrameGrabber p_FrameGrabber) {
        if (p_FrameGrabber == null) {
            return;
        }
        if ((float)p_FrameGrabber.getSampleRate() != this.m_AudioFormat_Output.getSampleRate()) {
            String stringSampleFormat = "sample_fmts=";
            if (this.m_AudioFormat_Output.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
                stringSampleFormat = stringSampleFormat + "s";
                stringSampleFormat = stringSampleFormat + String.valueOf(this.m_AudioFormat_Output.getSampleSizeInBits());
            } else if (this.m_AudioFormat_Output.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED) {
                stringSampleFormat = stringSampleFormat + "u";
                stringSampleFormat = stringSampleFormat + String.valueOf(this.m_AudioFormat_Output.getSampleSizeInBits());
            }
            this.m_FrameFilter_Audio = new FFmpegFrameFilter("aformat=" + stringSampleFormat + ":sample_rates=" + String.valueOf((int)this.m_AudioFormat_Output.getSampleRate()), p_FrameGrabber.getAudioChannels());
            try {
                this.m_FrameFilter_Audio.start();
            }
            catch (Exception e) {
                if (this.m_FrameFilter_Audio != null) {
                    try {
                        this.m_FrameFilter_Audio.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.m_FrameFilter_Audio = null;
                this.m_AudioPlayBuffer = null;
                return;
            }
        }
        this.m_AudioFormat_Buffer = new AudioFormat(this.m_AudioFormat_Output.getEncoding(), this.m_AudioFormat_Output.getSampleRate(), this.m_AudioFormat_Output.getSampleSizeInBits(), p_FrameGrabber.getAudioChannels(), p_FrameGrabber.getAudioChannels() * this.m_AudioFormat_Output.getSampleSizeInBits() / 8, this.m_AudioFormat_Output.getFrameRate(), this.m_AudioFormat_Output.isBigEndian());
        this.m_AudioPlayBuffer = new AudioPlayBuffer(this, p_FrameGrabber.getSampleFormat(), this.m_AudioFormat_Buffer, this.m_AudioFormat_Output);
    }

    public boolean hasVideo() {
        return this.m_HasVideo;
    }

    public boolean hasAudio() {
        return this.m_HasAudio;
    }

    @Override
    public BufferedImage getBufferedImage() {
        VideoPlayBuffer o_VideoPlayBuffer = this.m_VideoPlayBuffer;
        if (this.m_Closed || this.m_Released) {
            return null;
        }
        if (!this.m_IsInsideObject) {
            return null;
        }
        if (o_VideoPlayBuffer != null) {
            return o_VideoPlayBuffer.getBufferedImage();
        }
        return null;
    }

    @Override
    public LiveShow_MediaPlayer.MediaImage getMediaImage() {
        VideoPlayBuffer o_VideoPlayBuffer = this.m_VideoPlayBuffer;
        if (this.m_Closed || this.m_Released) {
            return null;
        }
        if (!this.m_IsInsideObject) {
            return null;
        }
        return o_VideoPlayBuffer.getMediaImage();
    }

    @Override
    public Object getSyncImage() {
        VideoPlayBuffer o_VideoPlayBuffer = this.m_VideoPlayBuffer;
        if (o_VideoPlayBuffer == null) {
            return null;
        }
        return o_VideoPlayBuffer.getSyncImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveActualImage_PNG(File p_ImageFile) {
        BufferedImage o_BufferedImage;
        Object object = this.m_SyncPlay;
        synchronized (object) {
            o_BufferedImage = this.getBufferedImage();
        }
        return super.saveActualImage_PNG(p_ImageFile, o_BufferedImage, this.getPlayerGrabSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean load() {
        MediaSource o_MediaSource;
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            if (this.m_Closed) {
                return false;
            }
            o_MediaSource = this.m_MediaSource;
        }
        if (o_MediaSource == null) {
            return false;
        }
        if (o_MediaSource.getMediaType() != 1002) {
            return false;
        }
        File o_File = o_MediaSource.getFile();
        if (o_File == null) {
            this.release();
            return false;
        }
        if (!o_File.exists()) {
            this.release();
            return false;
        }
        boolean boolOK = this.m_Grabber_Video_OK;
        if (this.m_VideoFile != null) {
            this.release();
            this.releaseSnapShot();
        }
        object = this.m_SyncMediaPlayer;
        synchronized (object) {
            this.m_VideoFile = o_File;
        }
        boolOK = this.initPlay(o_File);
        if (boolOK) {
            this.m_ReleasedSnapShot = false;
        }
        this.setMediaReady(boolOK);
        return boolOK;
    }

    public void reload() {
    }

    @Override
    public long getLength() {
        return this.m_Duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPlayStatus(float p_Fade, float p_SoundVolume, long p_Milliseconds, boolean p_Playing, boolean p_InsideObject) {
        VideoPlayBuffer o_VideoPlayBuffer;
        AudioPlayBuffer o_AudioPlayBuffer;
        boolean boolSetPlayTime = false;
        boolean boolPlayStart = false;
        boolean boolPlayPause = false;
        boolean boolSetSoundVolume = false;
        boolean boolChangedInsideObject = false;
        if (p_Fade < 0.0f) {
            p_Fade = 0.0f;
        }
        if (p_Fade > 2.0f) {
            p_Fade = 2.0f;
        }
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            if (this.m_Closed || !this.m_MediaReady || this.m_Released) {
                super.setFade(0.0f, true);
                return;
            }
            if (this.m_Fade != p_Fade) {
                super.setFade(p_Fade, false);
            }
            if (this.m_IsInsideObject != p_InsideObject) {
                this.m_IsInsideObject = p_InsideObject;
                boolChangedInsideObject = true;
            }
            if (p_InsideObject && p_Playing) {
                this.m_ShouldPlay = true;
                if (!this.m_IsPlaying) {
                    boolPlayStart = true;
                }
            } else {
                this.m_ShouldPlay = false;
                if (this.m_IsPlaying) {
                    boolPlayPause = true;
                }
            }
            if (p_Milliseconds < this.m_MinimalTimeStamp_Video_Milliseconds) {
                this.setFade(0.0f, false);
                this.m_ActualPlayTime = this.m_MinimalTimeStamp_Video_Milliseconds;
                this.m_ShouldPlay = false;
            } else if (p_Milliseconds > this.m_MaximalTimeStamp_Video_Milliseconds) {
                this.setFade(0.0f, false);
                this.m_ActualPlayTime = this.m_MaximalTimeStamp_Video_Milliseconds;
                this.m_ShouldPlay = false;
            } else {
                this.m_ActualPlayTime = p_Milliseconds;
            }
            long longMediaPlayerTime = this.getMediaPlayerTime();
            if (this.m_ShouldPlay) {
                if (!this.equalTime(this.m_ActualPlayTime, longMediaPlayerTime, TIMETOLERANCE_WHILEPLAY)) {
                    boolSetPlayTime = true;
                }
            } else if (!this.equalTime(this.m_ActualPlayTime, longMediaPlayerTime, TIMETOLERANCE_WHILEPAUSE)) {
                boolSetPlayTime = true;
            }
            if (this.m_SoundDelayChanged) {
                this.m_SoundDelayChanged = false;
                boolSetPlayTime = true;
                this.m_ShouldPlay = false;
            }
            o_AudioPlayBuffer = this.m_AudioPlayBuffer;
            o_VideoPlayBuffer = this.m_VideoPlayBuffer;
            if (o_AudioPlayBuffer != null && o_AudioPlayBuffer.getVolume() != p_SoundVolume) {
                boolSetSoundVolume = true;
            }
        }
        if (boolSetSoundVolume && o_AudioPlayBuffer != null) {
            o_AudioPlayBuffer.setVolume(p_SoundVolume);
        }
        if (boolPlayStart || boolPlayPause || boolSetPlayTime) {
            object = this.m_SyncPlay;
            synchronized (object) {
                if (!this.m_ShouldPlay) {
                    boolSetPlayTime = true;
                }
            }
            if (o_VideoPlayBuffer != null) {
                o_VideoPlayBuffer.setPlayStatus(this.m_ShouldPlay, !this.m_ShouldPlay, boolSetPlayTime, this.m_ActualPlayTime);
            }
            if (o_AudioPlayBuffer != null) {
                o_AudioPlayBuffer.setPlayStatus(this.m_ShouldPlay, !this.m_ShouldPlay, boolSetPlayTime, this.m_ActualPlayTime);
            }
            object = this.m_SyncPlay;
            synchronized (object) {
                this.m_ShouldSetTime = boolSetPlayTime;
                this.m_SyncPlay.notifyAll();
            }
        }
        if (boolChangedInsideObject) {
            this.paintImage();
        }
    }

    public void setActualVideoTimestamp(long p_ActualVideoTimestamp) {
        AudioPlayBuffer o_AudioPlayBuffer = this.m_AudioPlayBuffer;
        if (o_AudioPlayBuffer != null) {
            o_AudioPlayBuffer.setVideoTimeStamp(p_ActualVideoTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void play() {
        boolean boolSetTimestamp_Video = false;
        boolean boolSetTimestamp_Audio = false;
        long longFrameTimestamp = 0L;
        while (!this.m_Closed && !this.m_Released) {
            Object object = this.m_SyncPlay;
            synchronized (object) {
                this.m_IsPlaying = this.m_ShouldPlay;
                if (!this.m_MediaReady || !this.m_ShouldPlay && !this.m_ShouldSetTime && !boolSetTimestamp_Video) {
                    try {
                        long longWaitTime = 5000L;
                        this.m_SyncPlay.wait(longWaitTime);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    continue;
                }
            }
            FFmpegFrameGrabber o_FFmpegFrameGrabber = this.m_FFmpegFrameGrabber;
            FFmpegFrameFilter o_FrameFilter_Audio = this.m_FrameFilter_Audio;
            VideoPlayBuffer o_VideoPlayBuffer = this.m_VideoPlayBuffer;
            AudioPlayBuffer o_AudioPlayBuffer = this.m_AudioPlayBuffer;
            if (o_FFmpegFrameGrabber == null) continue;
            Frame o_Frame = null;
            if (this.m_ShouldSetTime) {
                this.setTimestamp();
                if (this.m_Closed || this.m_Released) continue;
                this.m_ShouldSetTime = false;
                boolSetTimestamp_Audio = true;
                boolSetTimestamp_Video = true;
            }
            try {
                if (!this.m_ShouldPlay && this.m_HasVideo && boolSetTimestamp_Video) {
                    o_Frame = o_FFmpegFrameGrabber.grabImage();
                    if (o_Frame != null) {
                        longFrameTimestamp = o_Frame.timestamp;
                    }
                } else {
                    o_Frame = o_FFmpegFrameGrabber.grab();
                    if (o_Frame != null) {
                        longFrameTimestamp = o_Frame.timestamp;
                        if (o_FrameFilter_Audio != null && o_Frame.samples != null) {
                            o_FrameFilter_Audio.push(o_Frame);
                            o_Frame = o_FrameFilter_Audio.pull();
                        }
                    }
                }
            }
            catch (Exception e) {
                o_Frame = null;
            }
            if (o_Frame == null) continue;
            if (o_Frame.samples != null) {
                if (!this.m_ShouldPlay || o_AudioPlayBuffer == null) continue;
                o_AudioPlayBuffer.addFrameSamples(o_Frame, longFrameTimestamp, boolSetTimestamp_Audio);
                boolSetTimestamp_Audio = false;
                continue;
            }
            if (o_Frame.image == null || o_VideoPlayBuffer == null) continue;
            o_VideoPlayBuffer.addFrameImage(o_Frame, longFrameTimestamp, boolSetTimestamp_Video);
            boolSetTimestamp_Video = false;
            if (o_AudioPlayBuffer == null || longFrameTimestamp / 1000L < this.m_Duration - TIMETOLERANCE_WHILEPLAY) continue;
            o_AudioPlayBuffer.stop_Audio();
        }
    }

    private Frame setTimestamp() {
        int intSetTimestampCount = 0;
        long longFrameTimestamp = -1L;
        Frame o_Frame = null;
        try {
            FFmpegFrameGrabber o_FFmpegFrameGrabber = this.m_FFmpegFrameGrabber;
            if (o_FFmpegFrameGrabber == null) {
                return null;
            }
            FFmpegFrameFilter o_FrameFilter_Audio = this.m_FrameFilter_Audio;
            if (o_FrameFilter_Audio != null) {
                try {
                    o_FrameFilter_Audio.flush();
                    o_FrameFilter_Audio.restart();
                }
                catch (FrameFilter.Exception exception) {
                    // empty catch block
                }
            }
            long longActualPlayTime = this.m_ActualPlayTime;
            long longTimeToSet = this.m_ActualPlayTime;
            if (!this.m_HasVideo) {
                while (this.m_ShouldSetTime) {
                    if (this.m_Closed || this.m_Released) {
                        return null;
                    }
                    if (longActualPlayTime != this.m_ActualPlayTime && !this.equalTime(this.m_ActualPlayTime, longFrameTimestamp / 1000L, TIMETOLERANCE_WHILEPLAY)) {
                        this.m_ShouldSetTime = true;
                        longActualPlayTime = this.m_ActualPlayTime;
                        longTimeToSet = this.m_ActualPlayTime;
                        intSetTimestampCount = 0;
                        continue;
                    }
                    if (this.m_ActualPlayTime < this.m_ActualPlayTime_Old) {
                        o_FFmpegFrameGrabber.setTimestamp(0L);
                    }
                    this.m_ActualPlayTime_Old = this.m_ActualPlayTime;
                    if (++intSetTimestampCount > 4) {
                        return null;
                    }
                    o_FFmpegFrameGrabber.setTimestamp(longTimeToSet * 1000L);
                    o_Frame = o_FFmpegFrameGrabber.grabFrame(true, false, false, false, false);
                    if (o_Frame == null) {
                        o_FFmpegFrameGrabber.setTimestamp(0L);
                        continue;
                    }
                    longFrameTimestamp = o_Frame.timestamp;
                    if (!this.m_IsPlaying) {
                        if (this.m_ActualPlayTime - longFrameTimestamp / 1000L > TIMETOLERANCE_WHILEPLAY) {
                            longTimeToSet += TIMETOLERANCE_WHILEPLAY;
                            continue;
                        }
                        if (this.m_ActualPlayTime - longFrameTimestamp / 1000L < -TIMETOLERANCE_WHILEPLAY) {
                            if ((longTimeToSet -= TIMETOLERANCE_WHILEPLAY) < 0L) {
                                longTimeToSet = 0L;
                            }
                            o_FFmpegFrameGrabber.setTimestamp(0L);
                            continue;
                        }
                    } else {
                        if (this.m_ActualPlayTime - longFrameTimestamp / 1000L > TIMETOLERANCE_WHILEPAUSE) {
                            longTimeToSet += TIMETOLERANCE_WHILEPAUSE;
                            continue;
                        }
                        if (this.m_ActualPlayTime - longFrameTimestamp / 1000L < -TIMETOLERANCE_WHILEPAUSE) {
                            if ((longTimeToSet -= TIMETOLERANCE_WHILEPAUSE) < 0L) {
                                longTimeToSet = 0L;
                            }
                            o_FFmpegFrameGrabber.setTimestamp(0L);
                            continue;
                        }
                    }
                    if (this.m_ActualPlayTime != longActualPlayTime && !this.equalTime(this.m_ActualPlayTime, longFrameTimestamp / 1000L, TIMETOLERANCE_WHILEPLAY)) continue;
                    this.m_ShouldSetTime = false;
                    while (!this.m_ShouldSetTime && o_Frame != null && (double)longFrameTimestamp < (double)(this.m_ActualPlayTime * 1000L) - 1000.0 / o_FFmpegFrameGrabber.getVideoFrameRate() && (o_Frame = o_FFmpegFrameGrabber.grabFrame(true, false, false, false, false)) != null) {
                        if (o_Frame.samples != null) {
                            longFrameTimestamp = o_Frame.timestamp;
                        }
                        if (this.m_ActualPlayTime == longActualPlayTime || this.equalTime(this.m_ActualPlayTime, longFrameTimestamp / 1000L, TIMETOLERANCE_WHILEPLAY)) continue;
                    }
                    if (this.m_ActualPlayTime == longActualPlayTime || this.equalTime(this.m_ActualPlayTime, longFrameTimestamp / 1000L, TIMETOLERANCE_WHILEPLAY)) continue;
                }
                return o_Frame;
            }
            while (this.m_ShouldSetTime) {
                if (this.m_Closed || this.m_Released) {
                    return null;
                }
                if (longActualPlayTime != this.m_ActualPlayTime && !this.equalTime(this.m_ActualPlayTime, longFrameTimestamp / 1000L, TIMETOLERANCE_WHILEPLAY)) {
                    this.m_ShouldSetTime = true;
                    longActualPlayTime = this.m_ActualPlayTime;
                    longTimeToSet = this.m_ActualPlayTime;
                    intSetTimestampCount = 0;
                    continue;
                }
                if (this.m_ActualPlayTime < this.m_ActualPlayTime_Old) {
                    o_FFmpegFrameGrabber.setTimestamp(0L);
                }
                this.m_ActualPlayTime_Old = this.m_ActualPlayTime;
                if (++intSetTimestampCount > 4) {
                    return null;
                }
                o_FFmpegFrameGrabber.setTimestamp(longTimeToSet * 1000L);
                o_Frame = o_FFmpegFrameGrabber.grabFrame(false, true, false, false, true);
                if (o_Frame == null) {
                    o_FFmpegFrameGrabber.setTimestamp(0L);
                    if (intSetTimestampCount <= 1 || (longTimeToSet -= TIMETOLERANCE_WHILEPLAY / 2L) >= 0L) continue;
                    longTimeToSet = 0L;
                    continue;
                }
                longFrameTimestamp = o_Frame.timestamp;
                if (this.m_IsPlaying) {
                    if (this.m_ActualPlayTime - longFrameTimestamp / 1000L > TIMETOLERANCE_WHILEPLAY) {
                        if (longFrameTimestamp >= this.m_MaximalTimeStamp_Video) {
                            return o_Frame;
                        }
                        longTimeToSet += TIMETOLERANCE_WHILEPLAY / 2L;
                        continue;
                    }
                    if (this.m_ActualPlayTime - longFrameTimestamp / 1000L < -TIMETOLERANCE_WHILEPLAY) {
                        if (longFrameTimestamp <= this.m_MinimalTimeStamp_Video) {
                            return o_Frame;
                        }
                        o_FFmpegFrameGrabber.setTimestamp(0L);
                        if ((longTimeToSet -= TIMETOLERANCE_WHILEPLAY / 2L) >= 0L) continue;
                        longTimeToSet = 0L;
                        continue;
                    }
                } else {
                    if (this.m_ActualPlayTime - longFrameTimestamp / 1000L > TIMETOLERANCE_WHILEPAUSE) {
                        if (longFrameTimestamp >= this.m_MaximalTimeStamp_Video) {
                            return o_Frame;
                        }
                        longTimeToSet += TIMETOLERANCE_WHILEPAUSE / 2L;
                        continue;
                    }
                    if (this.m_ActualPlayTime - longFrameTimestamp / 1000L < -TIMETOLERANCE_WHILEPAUSE) {
                        if (longFrameTimestamp <= this.m_MinimalTimeStamp_Video) {
                            return o_Frame;
                        }
                        o_FFmpegFrameGrabber.setTimestamp(0L);
                        if ((longTimeToSet -= TIMETOLERANCE_WHILEPAUSE / 2L) >= 0L) continue;
                        longTimeToSet = 0L;
                        continue;
                    }
                }
                if (this.m_ActualPlayTime != longActualPlayTime && !this.equalTime(this.m_ActualPlayTime, longFrameTimestamp / 1000L, TIMETOLERANCE_WHILEPLAY)) continue;
                this.m_ShouldSetTime = false;
                while (!this.m_ShouldSetTime && o_Frame != null && (double)longFrameTimestamp < (double)(this.m_ActualPlayTime * 1000L) - 1000000.0 / o_FFmpegFrameGrabber.getVideoFrameRate() && longFrameTimestamp < o_FFmpegFrameGrabber.getLengthInTime() - TIMETOLERANCE_WHILEPLAY * 1000L / 2L && (o_Frame = o_FFmpegFrameGrabber.grabFrame(false, true, false, false, true)) != null) {
                    if (o_Frame.image == null) continue;
                    longFrameTimestamp = o_Frame.timestamp;
                    if (this.m_ActualPlayTime == longActualPlayTime || this.equalTime(this.m_ActualPlayTime, longFrameTimestamp / 1000L, TIMETOLERANCE_WHILEPLAY)) continue;
                }
                if (this.m_ActualPlayTime == longActualPlayTime || this.equalTime(this.m_ActualPlayTime, longFrameTimestamp / 1000L, TIMETOLERANCE_WHILEPLAY)) continue;
            }
        }
        catch (FrameGrabber.Exception e) {
            e.printStackTrace();
            return null;
        }
        return o_Frame;
    }

    @Override
    public void setSoundDelay(long p_Delay_ms) {
        if (p_Delay_ms < 0L) {
            p_Delay_ms = 0L;
        }
        if (this.m_SoundDelay == p_Delay_ms) {
            return;
        }
        super.setSoundDelay(p_Delay_ms);
        this.m_SoundDelayChanged = true;
    }

    public boolean equalTime(long p_PlayStatusTime, long p_MediaPlayerTime, long p_Tolerance) {
        if (p_PlayStatusTime < p_MediaPlayerTime - p_Tolerance) {
            return false;
        }
        return p_PlayStatusTime <= p_MediaPlayerTime + p_Tolerance;
    }

    public long getMediaPlayerTime() {
        long longTimeStamp;
        VideoPlayBuffer o_VideoPlayBuffer = this.m_VideoPlayBuffer;
        AudioPlayBuffer o_AudioPlayBuffer = this.m_AudioPlayBuffer;
        if (o_VideoPlayBuffer != null && (longTimeStamp = o_VideoPlayBuffer.getMediaTimestamp()) >= 0L) {
            return longTimeStamp / 1000L;
        }
        if (o_AudioPlayBuffer != null) {
            longTimeStamp = o_AudioPlayBuffer.getMediaTimestamp();
            return longTimeStamp / 1000L;
        }
        return this.m_FFmpegFrameGrabber.getTimestamp() / 1000L;
    }

    @Override
    public boolean isPlaying() {
        return this.m_IsPlaying;
    }

    @Override
    public boolean isInsideObject() {
        return this.m_IsInsideObject;
    }

    @Override
    public long getPlayTime() {
        return this.m_ActualPlayTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestSnapshot(String p_ID, BufferedImage p_BufferedImage, long p_Milliseconds, LiveShow_MediaPlayer.SnapshotEventListener p_SnapshotEventListener) {
        Object object = this.m_SyncSnapShot;
        synchronized (object) {
            if (this.m_ReleasedSnapShot) {
                return false;
            }
            MediaSource o_MediaSource = this.m_MediaSource;
            if (o_MediaSource == null) {
                return false;
            }
            File o_FileSource = o_MediaSource.getFile();
            if (o_FileSource == null) {
                return false;
            }
            if (!o_FileSource.exists()) {
                return false;
            }
            if (this.m_Grabber_SnapShot == null) {
                this.m_Grabber_SnapShot = new FFmpegFrameGrabber(o_FileSource);
                this.m_Grabber_SnapShot.setPixelFormat(27);
                try {
                    this.m_Grabber_SnapShot.start();
                    this.m_Duration = this.m_Grabber_SnapShot.getLengthInTime() / 1000L;
                    int intOriginHeight = this.m_Grabber_SnapShot.getImageHeight();
                    int intOriginWidth = this.m_Grabber_SnapShot.getImageWidth();
                    double doubleAspectRatio = this.m_Grabber_SnapShot.getAspectRatio();
                    if (this.m_SourceSize.width == 0 && this.m_SourceSize.height == 0) {
                        if (doubleAspectRatio != 1.0 && doubleAspectRatio > 0.0) {
                            if (intOriginWidth >= intOriginHeight) {
                                this.setSourceSize(intOriginWidth, (int)((double)intOriginWidth / doubleAspectRatio + 0.5));
                            } else {
                                this.setSourceSize((int)((double)intOriginHeight * doubleAspectRatio + 0.5), intOriginHeight);
                            }
                        } else {
                            this.setSourceSize(intOriginWidth, intOriginHeight);
                        }
                    }
                    int intNewHeight = intOriginHeight;
                    int intNewWidth = intOriginWidth;
                    if (LiveShow_MediaPlayer_Video_FFmpeg.s_SnapShotSize.height != intOriginHeight || LiveShow_MediaPlayer_Video_FFmpeg.s_SnapShotSize.width != intOriginWidth) {
                        double doubleFactorHeight = (double)LiveShow_MediaPlayer_Video_FFmpeg.s_SnapShotSize.height / (double)intOriginHeight;
                        double doubleFactorWidth = (double)LiveShow_MediaPlayer_Video_FFmpeg.s_SnapShotSize.width / (double)intOriginWidth;
                        double doubleSizeFactor = (double)intOriginWidth / (double)intOriginHeight;
                        if (doubleFactorWidth < doubleFactorHeight) {
                            intNewWidth = LiveShow_MediaPlayer_Video_FFmpeg.s_SnapShotSize.width;
                            intNewHeight = (int)((double)LiveShow_MediaPlayer_Video_FFmpeg.s_SnapShotSize.width / doubleSizeFactor + 0.5);
                        } else {
                            intNewHeight = LiveShow_MediaPlayer_Video_FFmpeg.s_SnapShotSize.height;
                            intNewWidth = (int)((double)LiveShow_MediaPlayer_Video_FFmpeg.s_SnapShotSize.height * doubleSizeFactor + 0.5);
                        }
                        this.m_Grabber_SnapShot.setImageHeight(intNewHeight);
                        this.m_Grabber_SnapShot.setImageWidth(intNewWidth);
                    }
                }
                catch (FrameGrabber.Exception e) {
                    try {
                        this.m_Grabber_SnapShot.close();
                    }
                    catch (FrameGrabber.Exception exception) {
                        // empty catch block
                    }
                    this.m_Grabber_SnapShot = null;
                }
            }
        }
        boolean boolSuccess = super.requestSnapshot(p_ID, p_BufferedImage, p_Milliseconds, p_SnapshotEventListener);
        return boolSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSnapShot() {
        Object object = this.m_SyncSnapShot;
        synchronized (object) {
            if (this.m_ReleasedSnapShot) {
                return;
            }
            this.m_ReleasedSnapShot = true;
            if (this.m_Grabber_SnapShot == null) {
                return;
            }
            try {
                this.m_Grabber_SnapShot.stop();
                this.m_Grabber_SnapShot.close();
            }
            catch (FrameGrabber.Exception exception) {
                // empty catch block
            }
            this.m_Grabber_SnapShot = null;
        }
    }

    @Override
    public void findSnapShots() {
        this.findSnapShotsInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findSnapShotsInternal() {
        long longNextMillisecond = -1L;
        LiveShow_MediaPlayer.SnapshotRequest o_SnapshotRequest = null;
        Rectangle o_SnapShotOriginSize = new Rectangle();
        BufferedImage o_BufferedImage_Snapshot = null;
        Object object = this.m_SyncSnapShot;
        synchronized (object) {
            if (this.m_ReleasedSnapShot) {
                return false;
            }
            if (this.m_Grabber_SnapShot == null) {
                return false;
            }
            long longDuration = this.m_Grabber_SnapShot.getLengthInTime() / 1000L;
            if (longDuration <= 0L) {
                return false;
            }
            while (this.getSnapshotRequestCount() > 0) {
                BufferedImage o_BufferedImage_Request;
                LiveShow_MediaPlayer.SnapshotEventListener o_SnapshotEventListener;
                o_SnapshotRequest = this.getSnapshotRequest(0);
                this.removeSnapshotRequest(o_SnapshotRequest);
                if (o_SnapshotRequest == null || (o_SnapshotEventListener = o_SnapshotRequest.getSnapshotEventListener()) == null || (o_BufferedImage_Request = o_SnapshotRequest.getSnapShotImage()) == null) continue;
                if (!this.m_Grabber_SnapShot.hasAudio() && !this.m_Grabber_SnapShot.hasVideo()) {
                    return true;
                }
                if (this.m_Grabber_SnapShot.hasVideo()) {
                    if (o_SnapshotRequest.getTime() < 0L || o_SnapshotRequest.getTime() > longDuration) continue;
                    try {
                        longNextMillisecond = o_SnapshotRequest.getTime();
                        if (longNextMillisecond > longDuration - TIMETOLERANCE_WHILEPLAY) {
                            longNextMillisecond = longDuration - TIMETOLERANCE_WHILEPLAY;
                            if (longNextMillisecond < 0L) continue;
                            o_SnapshotRequest.setTime(longNextMillisecond);
                        }
                        this.m_Grabber_SnapShot.setTimestamp(o_SnapshotRequest.getTime() * 1000L);
                        Frame o_Frame = this.m_Grabber_SnapShot.grabImage();
                        if (o_Frame == null || o_Frame.image == null) continue;
                        o_BufferedImage_Snapshot = FFmpeg_VideoFrameConverter.getBufferedImage(o_Frame, o_BufferedImage_Snapshot);
                    }
                    catch (FrameGrabber.Exception exception) {}
                } else {
                    o_BufferedImage_Snapshot = s_BufferedImage_Sound;
                }
                try {
                    int intNewWidth;
                    int intNewHeight;
                    double doubleWidthFactor;
                    double doubleHeightFactor;
                    if (o_BufferedImage_Snapshot == null) {
                        return false;
                    }
                    double doubleAspectRatio = this.m_Grabber_SnapShot.getAspectRatio();
                    int intOriginWidth = o_BufferedImage_Snapshot.getWidth();
                    int intOriginHeight = o_BufferedImage_Snapshot.getHeight();
                    if (doubleAspectRatio != 1.0 && doubleAspectRatio != 0.0) {
                        doubleAspectRatio *= (double)intOriginWidth / (double)intOriginHeight;
                        if (intOriginWidth > intOriginHeight) {
                            intOriginWidth = o_BufferedImage_Request.getWidth();
                            intOriginHeight = (int)((double)o_BufferedImage_Request.getHeight() / doubleAspectRatio + 0.5);
                        } else {
                            intOriginHeight = o_BufferedImage_Request.getHeight();
                            intOriginWidth = (int)((double)o_BufferedImage_Request.getHeight() * doubleAspectRatio + 0.5);
                        }
                    }
                    if ((doubleHeightFactor = (double)o_BufferedImage_Request.getHeight() / (double)intOriginHeight) < (doubleWidthFactor = (double)o_BufferedImage_Request.getWidth() / (double)intOriginWidth)) {
                        intNewHeight = (int)((double)intOriginHeight * doubleHeightFactor);
                        intNewWidth = (int)((double)intOriginWidth * doubleHeightFactor);
                    } else {
                        intNewHeight = (int)((double)intOriginHeight * doubleWidthFactor);
                        intNewWidth = (int)((double)intOriginWidth * doubleWidthFactor);
                    }
                    int intX = (o_BufferedImage_Request.getWidth() - intNewWidth) / 2;
                    int intY = (o_BufferedImage_Request.getHeight() - intNewHeight) / 2;
                    Graphics2D o_Graphics2D = o_BufferedImage_Request.createGraphics();
                    o_Graphics2D.drawImage(o_BufferedImage_Snapshot, intX, intY, intX + intNewWidth, intY + intNewHeight, 0, 0, o_BufferedImage_Snapshot.getWidth(), o_BufferedImage_Snapshot.getHeight(), null);
                    o_SnapShotOriginSize.setRect(intX, intY, intNewWidth, intNewHeight);
                    o_Graphics2D.dispose();
                }
                catch (Exception e) {
                    continue;
                }
                o_SnapshotEventListener.eventSnapshotImage(o_SnapshotRequest.getID(), o_SnapshotRequest.getTime(), o_SnapshotRequest.getSnapShotImage(), o_SnapShotOriginSize);
            }
        }
        return true;
    }

    @Override
    public JEditorPane getJEditorPane() {
        return null;
    }

    public void setPaint_LastNanos(long p_Paint_LastMillis) {
        this.m_Paint_LastNanos = p_Paint_LastMillis;
    }

    public long getPaint_LastNanos() {
        return this.m_Paint_LastNanos;
    }

    public static class Video_Image
    implements LiveShow_MediaPlayer.MediaImage {
        private LiveShow_MediaPlayer_Video_FFmpeg m_LiveShow_MediaPlayer_Video_FFmpeg;
        private long m_TimeStamp;
        private long m_ImageNumber;
        private BufferedImage m_BufferedImage;
        private boolean m_SameImageType;
        private final Object m_SyncImage = new Object();

        public Video_Image(LiveShow_MediaPlayer_Video_FFmpeg p_LiveShow_MediaPlayer_Video_FFmpeg) {
            this.initMembers();
            this.m_LiveShow_MediaPlayer_Video_FFmpeg = p_LiveShow_MediaPlayer_Video_FFmpeg;
        }

        private void initMembers() {
            this.m_ImageNumber = -1L;
            this.m_TimeStamp = 0L;
            this.m_LiveShow_MediaPlayer_Video_FFmpeg = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncImage;
            synchronized (object) {
                if (this.m_BufferedImage != null) {
                    this.m_BufferedImage.flush();
                    this.m_BufferedImage = null;
                }
                this.m_LiveShow_MediaPlayer_Video_FFmpeg = null;
            }
        }

        public void setTimeStamp(long p_TimeStamp) {
            this.m_TimeStamp = p_TimeStamp;
        }

        @Override
        public long getTimeStamp() {
            return this.m_TimeStamp;
        }

        public void setImageNumber(long p_ImageNumber) {
            this.m_ImageNumber = p_ImageNumber;
        }

        @Override
        public long getImageNumber() {
            return this.m_ImageNumber;
        }

        public void preAllocateBufferedImage(Frame p_Frame) {
            if (p_Frame == null) {
                return;
            }
            if (p_Frame.image == null) {
                return;
            }
            this.m_ImageNumber = -1L;
            this.m_TimeStamp = p_Frame.timestamp;
            this.m_BufferedImage = FFmpeg_VideoFrameConverter.getBufferedImage(p_Frame, this.m_BufferedImage);
            boolean intTest = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setImage(Frame p_Frame) {
            if (p_Frame == null) {
                return false;
            }
            if (p_Frame.image == null) {
                return false;
            }
            Object object = this.m_SyncImage;
            synchronized (object) {
                if (this.m_LiveShow_MediaPlayer_Video_FFmpeg == null) {
                    return false;
                }
                try {
                    this.m_BufferedImage = FFmpeg_VideoFrameConverter.getBufferedImage(p_Frame, this.m_BufferedImage);
                }
                catch (Exception e) {
                    this.m_BufferedImage = null;
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearBufferedImage() {
            Object object = this.m_SyncImage;
            synchronized (object) {
                if (this.m_BufferedImage != null) {
                    Graphics2D o_Graphics2D = this.m_BufferedImage.createGraphics();
                    o_Graphics2D.setColor(Color.BLACK);
                    o_Graphics2D.clearRect(0, 0, this.m_BufferedImage.getWidth(), this.m_BufferedImage.getHeight());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BufferedImage getBufferedImage() {
            Object object = this.m_SyncImage;
            synchronized (object) {
                return this.m_BufferedImage;
            }
        }

        public Object getSyncImage() {
            return this.m_SyncImage;
        }
    }

    public static class VideoPlayBuffer {
        public static int BUFFERSIZE = 12;
        public JavaTimer m_JavaTimer;
        private LiveShow_MediaPlayer_Video_FFmpeg m_LiveShow_MediaPlayer_Video_FFmpeg;
        private double m_VideoFrameRate;
        private double m_TimePerFrame;
        private long m_TimePlayStart;
        private long m_TimeStampVideoPlayStart;
        private ArrayList<Video_Image> m_VideoImagesBuffer;
        private long m_Video_Image_Number;
        private int m_IndexAdd;
        private int m_IndexGet;
        private int m_IndexActual;
        private int m_ImagesFilled;
        private boolean m_StatusShouldPlay;
        private boolean m_StatusJustStarted;
        private boolean m_StatusShouldPause;
        private boolean m_StatusShouldReset;
        private boolean m_StatusTimeSet;
        private long m_ActualTimestamp;
        private Thread m_PlayThread;
        private boolean m_Closed;
        private final Object m_SyncVideoPlay = new Object();
        private final Object m_SyncBuffer = new Object();
        private boolean m_BufferStopped;

        public VideoPlayBuffer(LiveShow_MediaPlayer_Video_FFmpeg p_LiveShow_MediaPlayer_Video_FFmpeg, double p_VideoFrameRate) {
            this.initMembers();
            this.m_LiveShow_MediaPlayer_Video_FFmpeg = p_LiveShow_MediaPlayer_Video_FFmpeg;
            this.m_VideoFrameRate = p_VideoFrameRate;
            if (this.m_VideoFrameRate > 0.0) {
                this.m_TimePerFrame = 1000.0 / this.m_VideoFrameRate;
            }
            for (int intIndex = 0; intIndex < BUFFERSIZE; ++intIndex) {
                this.m_VideoImagesBuffer.add(new Video_Image(this.m_LiveShow_MediaPlayer_Video_FFmpeg));
            }
            this.m_PlayThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    this.play();
                }
            }, "Thread_MediaPlayer_Video_VideoPlayBuffer");
            this.m_PlayThread.setPriority(7);
            this.m_PlayThread.start();
        }

        private void initMembers() {
            this.m_JavaTimer = new JavaTimer();
            this.m_Closed = false;
            this.m_TimePlayStart = 0L;
            this.m_TimeStampVideoPlayStart = 0L;
            this.m_VideoFrameRate = -1.0;
            this.m_TimePerFrame = 1.0;
            this.m_VideoImagesBuffer = new ArrayList();
            this.m_IndexActual = -1;
            this.m_StatusShouldPlay = false;
            this.m_StatusJustStarted = false;
            this.m_StatusShouldPause = false;
            this.m_StatusShouldReset = false;
            this.m_BufferStopped = false;
            this.m_ActualTimestamp = Long.MAX_VALUE;
            this.m_StatusTimeSet = false;
            this.resetVideo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncVideoPlay;
            synchronized (object) {
                if (this.m_Closed) {
                    return;
                }
                this.m_Closed = true;
                this.m_SyncVideoPlay.notifyAll();
            }
            this.m_JavaTimer.close();
            object = this.m_SyncBuffer;
            synchronized (object) {
                this.m_SyncBuffer.notifyAll();
            }
            if (this.m_PlayThread == Thread.currentThread()) {
                // empty if block
            }
            if (this.m_PlayThread != null) {
                try {
                    this.m_PlayThread.join(7000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_PlayThread = null;
            Object object2 = this.m_SyncVideoPlay;
            synchronized (object2) {
                for (int intVideoImage = this.m_VideoImagesBuffer.size() - 1; intVideoImage >= 0; --intVideoImage) {
                    Video_Image o_Video_Image = this.m_VideoImagesBuffer.get(intVideoImage);
                    if (o_Video_Image == null) continue;
                    o_Video_Image.close();
                }
                this.m_VideoImagesBuffer.clear();
            }
        }

        public void preAllocateBufferedImages(Frame p_Frame) {
            if (p_Frame == null) {
                return;
            }
            if (p_Frame.image == null) {
                return;
            }
            int intVideo_ImageCount = this.getVideo_ImageCount();
            for (int intVideo_Image = 0; intVideo_Image < intVideo_ImageCount; ++intVideo_Image) {
                Video_Image o_Video_Image = this.getVideo_Image(intVideo_Image);
                if (o_Video_Image == null) continue;
                o_Video_Image.preAllocateBufferedImage(p_Frame);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetVideo() {
            Object object = this.m_SyncVideoPlay;
            synchronized (object) {
                this.m_IndexAdd = 0;
                this.m_IndexGet = 0;
                this.m_ImagesFilled = 0;
                this.m_Video_Image_Number = 0L;
                this.m_IndexActual = -1;
                if (this.m_LiveShow_MediaPlayer_Video_FFmpeg != null) {
                    // empty if block
                }
            }
            object = this.m_SyncBuffer;
            synchronized (object) {
                this.startBuffer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setPlayStatus(boolean p_ShouldPlay, boolean p_ShouldPause, boolean p_ShouldReset, long p_ActualTime) {
            Object object;
            if (this.m_Closed) {
                return;
            }
            if (this.m_StatusShouldPlay == p_ShouldPlay && this.m_StatusShouldPause == p_ShouldPause && this.m_StatusShouldReset == p_ShouldReset) {
                return;
            }
            if (!this.m_StatusShouldPlay && p_ShouldPlay) {
                this.m_StatusJustStarted = true;
            }
            this.m_StatusShouldPlay = p_ShouldPlay;
            this.m_StatusShouldPause = p_ShouldPause;
            if (p_ShouldReset) {
                object = this.m_SyncVideoPlay;
                synchronized (object) {
                    this.m_StatusTimeSet = true;
                    this.m_StatusShouldReset = p_ShouldReset;
                    this.m_ActualTimestamp = p_ActualTime * 1000L;
                    if (this.m_ActualTimestamp < this.m_LiveShow_MediaPlayer_Video_FFmpeg.m_MinimalTimeStamp_Video || this.m_ActualTimestamp > this.m_LiveShow_MediaPlayer_Video_FFmpeg.m_MaximalTimeStamp_Video) {
                        // empty if block
                    }
                }
                this.stopBuffer();
            }
            if (this.m_StatusShouldPause) {
                this.startBuffer();
            }
            object = this.m_SyncVideoPlay;
            synchronized (object) {
                this.m_SyncVideoPlay.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFrameImage(Frame p_Frame, long p_TimeStamp, boolean p_FirstAfterTimeSet) {
            if (this.m_Closed) {
                return;
            }
            if (p_Frame == null) {
                return;
            }
            if (p_Frame.image == null) {
                return;
            }
            Object object = this.m_SyncVideoPlay;
            synchronized (object) {
                if (this.m_Closed) {
                    return;
                }
            }
            Object object2 = this.m_SyncBuffer;
            synchronized (object2) {
                while (this.m_BufferStopped && !this.m_Closed) {
                    try {
                        long longWaitTime = 1000L;
                        this.m_SyncBuffer.wait(longWaitTime);
                    }
                    catch (Exception exception) {}
                }
            }
            object2 = this.m_SyncVideoPlay;
            synchronized (object2) {
                if (this.m_Closed) {
                    return;
                }
                if (this.m_StatusTimeSet && !p_FirstAfterTimeSet) {
                    return;
                }
                this.m_StatusTimeSet = false;
                Video_Image o_Video_Image = this.getVideo_Image(this.m_IndexAdd);
                if (o_Video_Image == null) {
                    return;
                }
                o_Video_Image.setImageNumber(this.m_Video_Image_Number);
                o_Video_Image.setTimeStamp(p_TimeStamp);
                o_Video_Image.setImage(p_Frame);
                ++this.m_Video_Image_Number;
                ++this.m_ImagesFilled;
                ++this.m_IndexAdd;
                if (this.m_IndexAdd >= this.m_VideoImagesBuffer.size()) {
                    this.m_IndexAdd = 0;
                }
                this.m_SyncVideoPlay.notifyAll();
            }
            object2 = this.m_SyncBuffer;
            synchronized (object2) {
                if (this.m_ImagesFilled >= this.m_VideoImagesBuffer.size() - 1) {
                    this.stopBuffer();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopBuffer() {
            if (this.m_BufferStopped) {
                return;
            }
            Object object = this.m_SyncBuffer;
            synchronized (object) {
                this.m_BufferStopped = true;
                if (this.m_Closed) {
                    this.m_SyncBuffer.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startBuffer() {
            if (!this.m_BufferStopped) {
                return;
            }
            this.m_BufferStopped = false;
            Object object = this.m_SyncBuffer;
            synchronized (object) {
                this.m_SyncBuffer.notifyAll();
            }
        }

        public int getVideo_ImageCount() {
            return this.m_VideoImagesBuffer.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Video_Image getVideo_Image(int p_Index) {
            Video_Image o_Video_Image = null;
            Object object = this.m_SyncVideoPlay;
            synchronized (object) {
                if (p_Index < 0 || p_Index >= this.m_VideoImagesBuffer.size()) {
                    return null;
                }
                o_Video_Image = this.m_VideoImagesBuffer.get(p_Index);
                return o_Video_Image;
            }
        }

        public BufferedImage getBufferedImage() {
            Video_Image o_Video_Image = this.getVideo_Image(this.m_IndexActual);
            if (o_Video_Image == null) {
                return null;
            }
            return o_Video_Image.getBufferedImage();
        }

        public LiveShow_MediaPlayer.MediaImage getMediaImage() {
            Video_Image o_Video_Image = this.getVideo_Image(this.m_IndexActual);
            if (o_Video_Image == null) {
                return null;
            }
            return o_Video_Image;
        }

        public Object getSyncImage() {
            Video_Image o_Video_Image = this.getVideo_Image(this.m_IndexActual);
            if (o_Video_Image == null) {
                return null;
            }
            return o_Video_Image.getSyncImage();
        }

        public long getMediaTimestamp() {
            return this.m_ActualTimestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void play() {
            long longSleepTime = 0L;
            boolean boolPlayOnce = false;
            while (!this.m_Closed) {
                Video_Image o_Video_Image;
                Object object = this.m_SyncVideoPlay;
                synchronized (object) {
                    if (!(this.m_Closed || (this.m_ImagesFilled > 0 || this.m_StatusShouldReset) && (this.m_StatusShouldPlay || boolPlayOnce || this.m_StatusShouldReset))) {
                        try {
                            long longWaitTime = 5000L;
                            this.m_SyncVideoPlay.wait(longWaitTime);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (this.m_Closed) {
                            continue;
                        }
                        LiveShow_MediaPlayer_Video_FFmpeg o_LiveShow_MediaPlayer_Video_FFmpeg = this.m_LiveShow_MediaPlayer_Video_FFmpeg;
                        if (this.m_StatusShouldReset) {
                            this.stopBuffer();
                            this.resetVideo();
                            this.startBuffer();
                            if (!this.m_StatusShouldPlay) {
                                boolPlayOnce = true;
                            }
                            this.m_StatusShouldReset = false;
                        }
                        continue;
                    }
                }
                if (this.m_StatusShouldReset) {
                    this.stopBuffer();
                    this.resetVideo();
                    this.startBuffer();
                    if (!this.m_StatusShouldPlay) {
                        boolPlayOnce = true;
                    }
                    this.m_StatusShouldReset = false;
                    continue;
                }
                if (boolPlayOnce) {
                    this.prepareActualImage();
                    this.paintImage();
                    boolPlayOnce = false;
                    continue;
                }
                if (!this.m_StatusShouldPlay || (o_Video_Image = this.getVideo_Image(this.m_IndexGet)) == null || this.m_StatusShouldReset) continue;
                long longImageNumber = o_Video_Image.getImageNumber();
                if (longImageNumber == 0L) {
                    this.m_TimePlayStart = System.nanoTime();
                    this.m_LiveShow_MediaPlayer_Video_FFmpeg.setPaint_LastNanos(this.m_TimePlayStart);
                    this.m_TimeStampVideoPlayStart = o_Video_Image.getTimeStamp();
                }
                if (this.m_StatusJustStarted) {
                    this.m_TimePlayStart = System.nanoTime();
                    this.m_LiveShow_MediaPlayer_Video_FFmpeg.setPaint_LastNanos(this.m_TimePlayStart);
                    this.m_TimeStampVideoPlayStart = o_Video_Image.getTimeStamp();
                    this.m_StatusJustStarted = false;
                }
                this.prepareActualImage();
                long longTimeSinceReset = (System.nanoTime() - this.m_TimePlayStart) / 1000000L;
                long longImageTimeStamp = (o_Video_Image.getTimeStamp() - this.m_TimeStampVideoPlayStart) / 1000L;
                longSleepTime = longImageTimeStamp - longTimeSinceReset;
                if (longSleepTime > 0L) {
                    this.m_JavaTimer.sleep(longSleepTime);
                }
                this.paintImage();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prepareActualImage() {
            Video_Image o_Video_Image;
            this.m_IndexActual = this.m_IndexGet++;
            Object object = this.m_SyncVideoPlay;
            synchronized (object) {
                if (this.m_Closed || this.m_StatusShouldReset) {
                    return;
                }
                o_Video_Image = this.getVideo_Image(this.m_IndexActual);
                if (this.m_IndexGet >= this.m_VideoImagesBuffer.size()) {
                    this.m_IndexGet = 0;
                }
                --this.m_ImagesFilled;
                if (this.m_ImagesFilled < 0) {
                    this.m_ImagesFilled = 0;
                }
            }
            if (o_Video_Image != null) {
                this.m_ActualTimestamp = o_Video_Image.getTimeStamp();
                LiveShow_MediaPlayer_Video_FFmpeg o_LiveShow_MediaPlayer_Video_FFmpeg = this.m_LiveShow_MediaPlayer_Video_FFmpeg;
                if (o_LiveShow_MediaPlayer_Video_FFmpeg != null) {
                    o_LiveShow_MediaPlayer_Video_FFmpeg.setActualVideoTimestamp(this.m_ActualTimestamp);
                }
            } else {
                boolean bl = false;
            }
            if (this.m_ImagesFilled <= this.m_VideoImagesBuffer.size() - 2) {
                this.startBuffer();
            }
        }

        public void paintImage() {
            LiveShow_MediaPlayer_Video_FFmpeg o_LiveShow_MediaPlayer_Video_FFmpeg = this.m_LiveShow_MediaPlayer_Video_FFmpeg;
            if (o_LiveShow_MediaPlayer_Video_FFmpeg != null) {
                o_LiveShow_MediaPlayer_Video_FFmpeg.paintImage();
            }
        }
    }

    public static class AudioPlayBuffer {
        public static int BUFFERSIZEINMILLISECONDS = 3000;
        public static int FRAMESTOWRITE = 2048;
        public DoubleBuffer m_Empty_FrameBuffer = null;
        private LiveShow_MediaPlayer_Video_FFmpeg m_LiveShow_MediaPlayer_Video_FFmpeg;
        private int m_AudioOriginal_SampleFormat;
        private AudioFormat m_AudioFormat_Buffer;
        private DoubleBuffer m_AudioOriginal_FrameBuffer;
        private float m_AudioOutput_Volume;
        private AudioFormat m_AudioFormat_Output = null;
        private SoundMixers.SoundBuffer_Player m_SoundBuffer_Player;
        private DoubleBuffer m_AudioOutput_LineValues;
        private boolean m_AudioOutput_LineIsStarted = false;
        private DoubleBuffer m_AudioOutput_Buffer;
        private int m_BufferedFrames;
        private int m_FrameAdd;
        private int m_FrameGet;
        private int m_FramesFilled;
        private boolean m_StatusShouldPlay;
        private boolean m_StatusJustStarted;
        private boolean m_StatusShouldPause;
        private boolean m_StatusShouldReset;
        private boolean m_StatusTimeSet;
        private long m_TimestampAfterReset;
        private long m_ActualTimestampAtReset;
        private double m_ActualTimestamp;
        private long m_ActualFramesWritten;
        private Thread m_PlayThread;
        private boolean m_Closed;
        private final Object m_SyncAudioPlay = new Object();
        private final Object m_SyncBuffer = new Object();
        private boolean m_BufferStopped;
        private int m_BufferStoppedBytesToAdd;

        public AudioPlayBuffer(LiveShow_MediaPlayer_Video_FFmpeg p_LiveShow_MediaPlayer_Video_FFmpeg, int p_SampleFormat, AudioFormat p_AudioFormat_Buffer, AudioFormat p_AudioFormat_Output) {
            this.m_LiveShow_MediaPlayer_Video_FFmpeg = p_LiveShow_MediaPlayer_Video_FFmpeg;
            this.m_AudioOriginal_SampleFormat = p_SampleFormat;
            this.m_AudioFormat_Buffer = p_AudioFormat_Buffer;
            this.m_AudioFormat_Output = p_AudioFormat_Output;
            this.m_SoundBuffer_Player = null;
            boolean boolInitAudioOK = this.initAudio();
            this.initMembers();
            if (boolInitAudioOK) {
                this.resetAudio();
                this.m_PlayThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        this.play();
                    }
                });
                this.m_PlayThread.start();
            }
        }

        private void initMembers() {
            this.m_AudioOutput_Volume = 1.0f;
            this.m_Closed = false;
            this.m_StatusShouldPlay = false;
            this.m_StatusJustStarted = false;
            this.m_StatusShouldPause = false;
            this.m_StatusShouldReset = false;
            this.m_BufferStopped = false;
            this.m_BufferStoppedBytesToAdd = 4096;
            this.m_StatusTimeSet = false;
            this.m_TimestampAfterReset = -1L;
            this.m_AudioOriginal_FrameBuffer = DoubleBuffer.allocate(SoundMixers.SOUND_SOUNDLINES_COUNT);
            this.m_Empty_FrameBuffer = DoubleBuffer.allocate(SoundMixers.SOUND_SOUNDLINES_COUNT);
            for (int intLine = 0; intLine < SoundMixers.SOUND_SOUNDLINES_COUNT; ++intLine) {
                this.m_Empty_FrameBuffer.put(intLine, 0.0);
            }
            this.m_AudioOutput_LineValues = DoubleBuffer.allocate(SoundMixers.SOUND_SOUNDLINES_COUNT * SoundMixers.BUFFERSIZE_FRAMES_MIXER);
            this.m_AudioOutput_LineIsStarted = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncAudioPlay;
            synchronized (object) {
                if (this.m_Closed) {
                    return;
                }
                this.m_Closed = true;
                this.m_SyncAudioPlay.notifyAll();
            }
            object = this.m_SyncBuffer;
            synchronized (object) {
                this.m_SyncBuffer.notifyAll();
            }
            if (this.m_PlayThread != null) {
                try {
                    this.m_PlayThread.join(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_PlayThread = null;
            if (this.m_SoundBuffer_Player != null) {
                this.m_SoundBuffer_Player.stopAndDrain();
                this.m_SoundBuffer_Player.close();
                this.m_SoundBuffer_Player = null;
            }
            if (this.m_AudioOutput_Buffer != null) {
                this.m_AudioOutput_Buffer.clear();
            }
        }

        public boolean getAudio_OK() {
            return this.m_SoundBuffer_Player != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setPlayStatus(boolean p_ShouldPlay, boolean p_ShouldPause, boolean p_ShouldReset, long p_ActualTime) {
            Object object;
            if (this.m_Closed) {
                return;
            }
            if (this.m_StatusShouldPlay == p_ShouldPlay && this.m_StatusShouldPause == p_ShouldPause && this.m_StatusShouldReset == p_ShouldReset) {
                return;
            }
            if (!this.m_StatusShouldPlay && p_ShouldPlay) {
                this.m_StatusJustStarted = true;
            }
            this.m_StatusShouldPlay = p_ShouldPlay;
            this.m_StatusShouldPause = p_ShouldPause;
            if (this.m_StatusShouldPause) {
                this.stopAndDrain_Audio();
            }
            if (p_ShouldReset) {
                object = this.m_SyncAudioPlay;
                synchronized (object) {
                    this.m_StatusTimeSet = true;
                    this.m_StatusShouldReset = p_ShouldReset;
                    this.m_ActualTimestamp = p_ActualTime * 1000L;
                    this.m_ActualTimestampAtReset = (long)this.m_ActualTimestamp;
                    this.m_ActualFramesWritten = 0L;
                }
            }
            object = this.m_SyncAudioPlay;
            synchronized (object) {
                this.m_SyncAudioPlay.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetAudio() {
            Object object = this.m_SyncAudioPlay;
            synchronized (object) {
                this.m_FrameAdd = this.m_FrameGet + SoundMixers.BUFFERSIZE_FRAMES_MIXER;
                if (this.m_FrameAdd >= this.m_BufferedFrames) {
                    this.m_FrameAdd = SoundMixers.BUFFERSIZE_FRAMES_MIXER;
                }
                this.m_FrameGet = this.m_FrameAdd;
                this.m_FramesFilled = 0;
                this.m_TimestampAfterReset = -1L;
            }
            this.startBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stop_Audio() {
            Object object = this.m_SyncAudioPlay;
            synchronized (object) {
                this.m_AudioOutput_LineIsStarted = false;
                if (this.m_SoundBuffer_Player != null) {
                    this.m_SoundBuffer_Player.stop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopAndDrain_Audio() {
            Object object = this.m_SyncAudioPlay;
            synchronized (object) {
                this.m_AudioOutput_LineIsStarted = false;
                if (this.m_SoundBuffer_Player != null) {
                    this.m_SoundBuffer_Player.stopAndDrain();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void start_Audio() {
            Object object = this.m_SyncAudioPlay;
            synchronized (object) {
                if (this.m_AudioOutput_LineIsStarted) {
                    return;
                }
                this.m_AudioOutput_LineIsStarted = true;
                if (this.m_SoundBuffer_Player != null) {
                    this.m_SoundBuffer_Player.startSynchronized();
                }
                this.m_SyncAudioPlay.notifyAll();
            }
            this.writeFrames();
        }

        private boolean initAudio() {
            this.m_SoundBuffer_Player = null;
            switch (this.m_AudioOriginal_SampleFormat) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                default: {
                    System.out.println(" Error Unsupported sound format");
                    return false;
                }
            }
            this.m_SoundBuffer_Player = SoundMixers.createSoundBuffer_Player((int)SoundMixers.BUFFERSIZE_FRAMES_PLAYBUFFER);
            this.m_BufferedFrames = (int)((double)this.m_AudioFormat_Output.getFrameRate() * ((double)BUFFERSIZEINMILLISECONDS / 1000.0));
            if (this.m_AudioOutput_Buffer == null) {
                this.m_AudioOutput_Buffer = DoubleBuffer.allocate(SoundMixers.SOUND_SOUNDLINES_COUNT * this.m_BufferedFrames);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addFrameSamples(Frame p_Frame, long p_TimeStamp, boolean p_FirstAfterTimeSet) {
            if (this.m_Closed) {
                return;
            }
            if (p_Frame == null) {
                return;
            }
            if (p_Frame.samples == null) {
                return;
            }
            if (this.m_SoundBuffer_Player == null) {
                return;
            }
            if (this.m_AudioOutput_Buffer == null) {
                return;
            }
            int intFramesConverted = 1;
            Object object = this.m_SyncBuffer;
            synchronized (object) {
                while (this.m_BufferStopped) {
                    try {
                        this.m_SyncBuffer.wait(1000L);
                    }
                    catch (Exception exception) {}
                }
            }
            object = this.m_SyncAudioPlay;
            synchronized (object) {
                if ((this.m_StatusTimeSet || this.m_StatusShouldReset) && !p_FirstAfterTimeSet) {
                    return;
                }
                if (p_FirstAfterTimeSet) {
                    this.m_TimestampAfterReset = p_TimeStamp;
                    this.m_ActualTimestamp = p_TimeStamp;
                    this.m_ActualTimestampAtReset = p_TimeStamp;
                    this.m_ActualFramesWritten = 0L;
                    this.m_StatusTimeSet = false;
                }
                Buffer[] o_Samples = p_Frame.samples;
                float floatVolume = this.m_AudioOutput_Volume;
                switch (this.m_AudioOriginal_SampleFormat) {
                    case 8: {
                        if (o_Samples.length < 1) {
                            return;
                        }
                        if (!(o_Samples[0] instanceof FloatBuffer)) {
                            return;
                        }
                        intFramesConverted = this.fillFloatBufferToByteBuffer(o_Samples, floatVolume);
                        break;
                    }
                    case 3: {
                        if (o_Samples.length < 1) {
                            return;
                        }
                        if (!(o_Samples[0] instanceof FloatBuffer)) {
                            return;
                        }
                        intFramesConverted = this.fillFloatBufferToByteBuffer(o_Samples, floatVolume);
                        break;
                    }
                    case 6: {
                        if (o_Samples.length < 1) {
                            return;
                        }
                        if (!(o_Samples[0] instanceof ShortBuffer)) {
                            return;
                        }
                        intFramesConverted = this.fillShortBufferToByteBuffer(o_Samples, floatVolume);
                        break;
                    }
                    case 1: {
                        if (o_Samples.length < 1) {
                            return;
                        }
                        if (!(o_Samples[0] instanceof ShortBuffer)) {
                            return;
                        }
                        intFramesConverted = this.fillShortBufferToByteBuffer(o_Samples, floatVolume);
                        break;
                    }
                    case 7: {
                        if (o_Samples.length < 1) {
                            return;
                        }
                        if (!(o_Samples[0] instanceof IntBuffer)) {
                            return;
                        }
                        intFramesConverted = this.fillIntegerBufferToByteBuffer(o_Samples, floatVolume);
                        break;
                    }
                    case 2: {
                        if (o_Samples.length < 1) {
                            return;
                        }
                        if (!(o_Samples[0] instanceof IntBuffer)) {
                            return;
                        }
                        intFramesConverted = this.fillIntegerBufferToByteBuffer(o_Samples, floatVolume);
                        break;
                    }
                    case 9: {
                        if (o_Samples.length < 1) {
                            return;
                        }
                        if (!(o_Samples[0] instanceof IntBuffer)) {
                            return;
                        }
                        intFramesConverted = this.fillDoubleBufferToByteBuffer(o_Samples, floatVolume);
                        break;
                    }
                    case 4: {
                        if (o_Samples.length < 1) {
                            return;
                        }
                        if (!(o_Samples[0] instanceof IntBuffer)) {
                            return;
                        }
                        intFramesConverted = this.fillDoubleBufferToByteBuffer(o_Samples, floatVolume);
                        break;
                    }
                    case 5: {
                        if (o_Samples.length < 1) {
                            return;
                        }
                        if (!(o_Samples[0] instanceof ByteBuffer)) {
                            return;
                        }
                        intFramesConverted = this.fillUnsigned8BitBufferToByteBuffer(o_Samples, floatVolume);
                        break;
                    }
                    case 0: {
                        if (o_Samples.length < 1) {
                            return;
                        }
                        if (!(o_Samples[0] instanceof ByteBuffer)) {
                            return;
                        }
                        intFramesConverted = this.fillUnsigned8BitBufferToByteBuffer(o_Samples, floatVolume);
                        break;
                    }
                    default: {
                        System.out.println("Audio NO VALID AUDIOFORMAT");
                    }
                }
                this.m_FramesFilled += intFramesConverted;
                this.m_SyncAudioPlay.notifyAll();
            }
            object = this.m_SyncAudioPlay;
            synchronized (object) {
                if (this.m_FramesFilled >= (int)((double)this.m_BufferedFrames * 0.75)) {
                    this.stopBuffer();
                    this.m_BufferStoppedBytesToAdd = intFramesConverted;
                }
            }
        }

        public int fillUnsigned8BitBufferToByteBuffer(Buffer[] p_Buffers, float p_Volume) {
            if (p_Buffers == null) {
                return 0;
            }
            if (p_Buffers.length <= 0) {
                return 0;
            }
            if (p_Volume < 0.0f) {
                p_Volume = 0.0f;
            }
            if (p_Volume > 1.0f) {
                p_Volume = 1.0f;
            }
            if (p_Volume < 0.0f) {
                p_Volume = 0.0f;
            }
            int intCapacity = p_Buffers[0].capacity();
            int intChannel = 0;
            int intFramesFilled = 0;
            this.m_AudioOriginal_FrameBuffer.clear();
            this.m_Empty_FrameBuffer.clear();
            this.m_AudioOriginal_FrameBuffer.put(this.m_Empty_FrameBuffer);
            this.m_AudioOriginal_FrameBuffer.clear();
            for (int intIndex = 0; intIndex < intCapacity; ++intIndex) {
                for (int intBuffer = 0; intBuffer < p_Buffers.length; ++intBuffer) {
                    ByteBuffer o_ByteBuffer = (ByteBuffer)p_Buffers[intBuffer];
                    int intCapacity_SoloBuffer = o_ByteBuffer.capacity();
                    double doubleValue = intIndex >= intCapacity_SoloBuffer ? 0.0 : (double)((float)(o_ByteBuffer.get(intIndex) & 0xFF) / 256.0f * p_Volume);
                    this.m_AudioOriginal_FrameBuffer.put(doubleValue);
                    if (intChannel == this.m_AudioFormat_Buffer.getChannels() - 1) {
                        intFramesFilled += this.putFrameBufferToAudioSamplesBuffer(this.m_AudioOriginal_FrameBuffer);
                        this.m_AudioOriginal_FrameBuffer.clear();
                        intChannel = 0;
                        continue;
                    }
                    ++intChannel;
                }
            }
            return intFramesFilled;
        }

        public int fillShortBufferToByteBuffer(Buffer[] p_Buffers, float p_Volume) {
            if (p_Buffers == null) {
                return 0;
            }
            if (p_Buffers.length <= 0) {
                return 0;
            }
            if (p_Volume < 0.0f) {
                p_Volume = 0.0f;
            }
            int intCapacity = p_Buffers[0].capacity();
            int intChannel = 0;
            int intBytesFilled = 0;
            this.m_AudioOriginal_FrameBuffer.clear();
            this.m_Empty_FrameBuffer.clear();
            this.m_AudioOriginal_FrameBuffer.put(this.m_Empty_FrameBuffer);
            this.m_AudioOriginal_FrameBuffer.clear();
            for (int intIndex = 0; intIndex < intCapacity; ++intIndex) {
                for (int intBuffer = 0; intBuffer < p_Buffers.length; ++intBuffer) {
                    ShortBuffer o_ShortBuffer = (ShortBuffer)p_Buffers[intBuffer];
                    o_ShortBuffer.clear();
                    int intCapacity_SoloBuffer = o_ShortBuffer.capacity();
                    double doubleValue = intIndex >= intCapacity_SoloBuffer ? 0.0 : (double)o_ShortBuffer.get(intIndex) / 32768.0 * (double)p_Volume;
                    this.m_AudioOriginal_FrameBuffer.put(doubleValue);
                    if (intChannel == this.m_AudioFormat_Buffer.getChannels() - 1) {
                        intBytesFilled += this.putFrameBufferToAudioSamplesBuffer(this.m_AudioOriginal_FrameBuffer);
                        this.m_AudioOriginal_FrameBuffer.clear();
                        intChannel = 0;
                        continue;
                    }
                    ++intChannel;
                }
            }
            return intBytesFilled;
        }

        public int fillIntegerBufferToByteBuffer(Buffer[] p_Buffers, float p_Volume) {
            if (p_Buffers == null) {
                return 0;
            }
            if (p_Buffers.length <= 0) {
                return 0;
            }
            if (p_Volume < 0.0f) {
                p_Volume = 0.0f;
            }
            int intCapacity = p_Buffers[0].capacity();
            int intChannel = 0;
            int intBytesFilled = 0;
            this.m_AudioOriginal_FrameBuffer.clear();
            this.m_Empty_FrameBuffer.clear();
            this.m_AudioOriginal_FrameBuffer.put(this.m_Empty_FrameBuffer);
            this.m_AudioOriginal_FrameBuffer.clear();
            for (int intIndex = 0; intIndex < intCapacity; ++intIndex) {
                for (int intBuffer = 0; intBuffer < p_Buffers.length; ++intBuffer) {
                    IntBuffer o_IntBuffer = (IntBuffer)p_Buffers[intBuffer];
                    int intCapacity_SoloBuffer = o_IntBuffer.capacity();
                    double doubleValue = intIndex >= intCapacity_SoloBuffer ? 0.0 : (double)((float)o_IntBuffer.get(intIndex) / 65536.0f * p_Volume);
                    this.m_AudioOriginal_FrameBuffer.put(doubleValue);
                    if (intChannel == this.m_AudioFormat_Buffer.getChannels() - 1) {
                        intBytesFilled += this.putFrameBufferToAudioSamplesBuffer(this.m_AudioOriginal_FrameBuffer);
                        this.m_AudioOriginal_FrameBuffer.clear();
                        intChannel = 0;
                        continue;
                    }
                    ++intChannel;
                }
            }
            return intBytesFilled;
        }

        public int fillFloatBufferToByteBuffer(Buffer[] p_Buffers, float p_Volume) {
            if (p_Buffers == null) {
                return 0;
            }
            if (p_Buffers.length <= 0) {
                return 0;
            }
            if (p_Volume < 0.0f) {
                p_Volume = 0.0f;
            }
            int intCapacity = p_Buffers[0].capacity();
            int intChannel = 0;
            int intBytesFilled = 0;
            this.m_AudioOriginal_FrameBuffer.clear();
            for (int intIndex = 0; intIndex < intCapacity; ++intIndex) {
                for (int intBuffer = 0; intBuffer < p_Buffers.length; ++intBuffer) {
                    FloatBuffer o_FloatBuffer = (FloatBuffer)p_Buffers[intBuffer];
                    int intCapacity_SoloBuffer = o_FloatBuffer.capacity();
                    double doubleValue = intIndex >= intCapacity_SoloBuffer ? 0.0 : (double)(o_FloatBuffer.get(intIndex) * p_Volume);
                    this.m_AudioOriginal_FrameBuffer.put(doubleValue);
                    if (intChannel == this.m_AudioFormat_Buffer.getChannels() - 1) {
                        intBytesFilled += this.putFrameBufferToAudioSamplesBuffer(this.m_AudioOriginal_FrameBuffer);
                        this.m_AudioOriginal_FrameBuffer.clear();
                        intChannel = 0;
                        continue;
                    }
                    ++intChannel;
                }
            }
            return intBytesFilled;
        }

        public int fillDoubleBufferToByteBuffer(Buffer[] p_Buffers, float p_Volume) {
            if (p_Buffers == null) {
                return 0;
            }
            if (p_Buffers.length <= 0) {
                return 0;
            }
            if (p_Volume < 0.0f) {
                p_Volume = 0.0f;
            }
            int intCapacity = p_Buffers[0].capacity();
            int intChannel = 0;
            int intBytesFilled = 0;
            this.m_AudioOriginal_FrameBuffer.clear();
            for (int intIndex = 0; intIndex < intCapacity; ++intIndex) {
                for (int intBuffer = 0; intBuffer < p_Buffers.length; ++intBuffer) {
                    DoubleBuffer o_DoubleBuffer = (DoubleBuffer)p_Buffers[intBuffer];
                    int intCapacity_SoloBuffer = o_DoubleBuffer.capacity();
                    double doubleValue = intIndex >= intCapacity_SoloBuffer ? 0.0 : o_DoubleBuffer.get(intIndex) * (double)p_Volume;
                    this.m_AudioOriginal_FrameBuffer.put(doubleValue);
                    if (intChannel == this.m_AudioFormat_Buffer.getChannels() - 1) {
                        intBytesFilled += this.putFrameBufferToAudioSamplesBuffer(this.m_AudioOriginal_FrameBuffer);
                        this.m_AudioOriginal_FrameBuffer.clear();
                        intChannel = 0;
                        continue;
                    }
                    ++intChannel;
                }
            }
            return intBytesFilled;
        }

        private int putFrameBufferToAudioSamplesBuffer(DoubleBuffer p_FrameBuffer) {
            if (p_FrameBuffer == null) {
                return 0;
            }
            int intPositionBase = this.m_FrameAdd * SoundMixers.SOUND_SOUNDLINES_COUNT;
            p_FrameBuffer.clear();
            this.m_AudioOutput_Buffer.position(intPositionBase);
            for (int intLine = 0; intLine < SoundMixers.SOUND_SOUNDLINES_COUNT; ++intLine) {
                this.m_AudioOutput_Buffer.put(0.0);
            }
            SoundMixers.Sound_Lines o_Sound_Lines = SoundMixers.s_Sound_Lines_Preview;
            for (int intChannel = 0; intChannel < this.m_AudioFormat_Buffer.getChannels(); ++intChannel) {
                SoundMixers.Sound_Channel_Lines o_Sound_Channel_Lines = o_Sound_Lines.getSound_Channel_Lines(intChannel);
                if (o_Sound_Channel_Lines == null) continue;
                for (int intIndex = 0; intIndex < o_Sound_Channel_Lines.getSoundLineFactorsCount(); ++intIndex) {
                    SoundMixers.SoundLineFactor o_SoundLineFactor = o_Sound_Channel_Lines.getSoundLineFactorByIndex(intIndex);
                    if (o_SoundLineFactor == null) continue;
                    double doubleValue = this.m_AudioOutput_Buffer.get(intPositionBase + o_SoundLineFactor.getSoundLineNumber());
                    this.m_AudioOutput_Buffer.put(intPositionBase + o_SoundLineFactor.getSoundLineNumber(), doubleValue += p_FrameBuffer.get(o_SoundLineFactor.getSoundLineNumber()));
                }
            }
            ++this.m_FrameAdd;
            if (this.m_FrameAdd >= this.m_BufferedFrames) {
                this.m_FrameAdd = 0;
                this.m_AudioOutput_Buffer.position(0);
            }
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopBuffer() {
            Object object = this.m_SyncBuffer;
            synchronized (object) {
                this.m_BufferStopped = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startBuffer() {
            this.m_BufferStopped = false;
            Object object = this.m_SyncBuffer;
            synchronized (object) {
                this.m_SyncBuffer.notifyAll();
            }
        }

        public void setVolume(float p_Volume) {
            if (this.m_AudioOutput_Volume == p_Volume) {
                return;
            }
            this.m_AudioOutput_Volume = p_Volume;
        }

        public float getVolume() {
            return this.m_AudioOutput_Volume;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setVideoTimeStamp(long p_VideoTimestamp) {
            if (this.m_StatusShouldReset) {
                return;
            }
            if (!this.m_StatusShouldPlay) {
                return;
            }
            if (this.m_TimestampAfterReset < 0L) {
                return;
            }
            long longSoundDelay = this.m_LiveShow_MediaPlayer_Video_FFmpeg.getSoundDelay();
            if (p_VideoTimestamp >= this.m_TimestampAfterReset + longSoundDelay * 1000L) {
                double longDiff_ms = ((double)p_VideoTimestamp - (double)this.m_TimestampAfterReset) / 1000.0 - (double)longSoundDelay;
                int intFrameDiff = (int)((double)(this.m_AudioFormat_Buffer.getFrameRate() / 1000.0f) * longDiff_ms);
                if (this.m_FramesFilled - intFrameDiff < SoundMixers.BUFFERSIZE_FRAMES_MIXER) {
                    return;
                }
                this.m_FrameGet = this.m_FrameGet + intFrameDiff >= this.m_BufferedFrames ? intFrameDiff - (this.m_BufferedFrames - this.m_FrameGet) : (this.m_FrameGet += intFrameDiff);
                this.m_FramesFilled -= intFrameDiff;
                this.start_Audio();
                this.m_TimestampAfterReset = -1L;
                Object object = this.m_SyncAudioPlay;
                synchronized (object) {
                    this.m_SyncAudioPlay.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void play() {
            while (!this.m_Closed) {
                Object object = this.m_SyncAudioPlay;
                synchronized (object) {
                    if (this.m_FramesFilled <= 0 && !this.m_StatusShouldReset || !this.m_StatusShouldPlay && !this.m_StatusShouldReset || !this.m_AudioOutput_LineIsStarted) {
                        try {
                            this.m_SyncAudioPlay.wait(5000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (this.m_StatusShouldReset) {
                    this.stop_Audio();
                    this.stopBuffer();
                    this.resetAudio();
                    this.startBuffer();
                    this.m_StatusShouldReset = false;
                }
                if (!this.m_StatusShouldPlay || this.m_FramesFilled <= 0) continue;
                if (!this.m_LiveShow_MediaPlayer_Video_FFmpeg.hasVideo()) {
                    this.start_Audio();
                }
                if (this.m_SoundBuffer_Player == null || !this.m_AudioOutput_LineIsStarted) continue;
                this.writeFrames();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeFrames() {
            SoundMixers.SoundBuffer_Player o_SoundBuffer_Player;
            int intFramesToWrite = SoundMixers.BUFFERSIZE_FRAMES_MIXER;
            if (this.m_AudioOutput_Buffer == null) {
                return;
            }
            Object object = this.m_SyncAudioPlay;
            synchronized (object) {
                if (intFramesToWrite > this.m_FramesFilled) {
                    intFramesToWrite = this.m_FramesFilled;
                }
                if (intFramesToWrite > this.m_SoundBuffer_Player.getFramesBuffered()) {
                    intFramesToWrite = this.m_SoundBuffer_Player.getFramesBuffered();
                }
                if (intFramesToWrite == 0) {
                    return;
                }
                this.m_AudioOutput_LineValues.clear();
                for (int intFrame = 0; intFrame < intFramesToWrite; ++intFrame) {
                    this.m_AudioOutput_LineValues.put(this.m_AudioOutput_Buffer.array(), this.m_FrameGet * SoundMixers.SOUND_SOUNDLINES_COUNT, SoundMixers.SOUND_SOUNDLINES_COUNT);
                    ++this.m_FrameGet;
                    if (this.m_FrameGet < this.m_BufferedFrames) continue;
                    this.m_FrameGet = 0;
                }
                o_SoundBuffer_Player = this.m_SoundBuffer_Player;
            }
            if (o_SoundBuffer_Player != null) {
                o_SoundBuffer_Player.writeFrames(this.m_AudioOutput_LineValues.array(), intFramesToWrite);
                this.m_ActualFramesWritten += (long)intFramesToWrite;
                this.m_ActualTimestamp = (float)this.m_ActualTimestampAtReset + (float)(this.m_ActualFramesWritten * 1000L) / this.m_AudioFormat_Output.getFrameRate() * 1000.0f;
            }
            object = this.m_SyncAudioPlay;
            synchronized (object) {
                this.m_FramesFilled -= intFramesToWrite;
                if (this.m_FramesFilled < 0) {
                    this.m_FramesFilled = 0;
                }
                if (this.m_BufferedFrames - this.m_FramesFilled >= SoundMixers.BUFFERSIZE_FRAMES_MIXER) {
                    this.startBuffer();
                }
            }
        }

        public long getMediaTimestamp() {
            return (long)this.m_ActualTimestamp;
        }
    }
}

