/*
 * Decompiled with CFR 0.152.
 */
package MediaPlayerPackage;

import GraphicsDeviceToolsPackage.GraphicsDeviceTools;
import MediaObjectPackage.MediaSource;
import MediaPlayerPackage.LiveShow_ImagePool;
import MediaPlayerPackage.LiveShow_MediaPlayer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JEditorPane;

public class LiveShow_MediaPlayer_Image
extends LiveShow_MediaPlayer {
    public static int s_PoolSize = 100;
    public static ArrayList<LiveShow_MediaPlayer_Image> s_LiveShowMediaPlayersPool = new ArrayList(50);
    public static final Object s_SyncPool = new Object();
    public static Color COLOR_TRANSPARENT = new Color(0, 0, 0, 0);
    public static long DEFAULTLENGTH_IMAGE = 10000L;
    private boolean m_IsPlaying;
    private boolean m_IsInsideObject;
    private long m_PlayTime;
    private Rectangle m_SnapShotOriginRect;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiveShow_MediaPlayer_Image poolGet(MediaSource p_MediaSource) {
        LiveShow_MediaPlayer_Image o_LiveShow_MediaPlayer_Image;
        Object object = s_SyncPool;
        synchronized (object) {
            if (s_LiveShowMediaPlayersPool.size() > 0) {
                int intIndex = s_LiveShowMediaPlayersPool.size() - 1;
                o_LiveShow_MediaPlayer_Image = s_LiveShowMediaPlayersPool.get(intIndex);
                o_LiveShow_MediaPlayer_Image.reactivate(p_MediaSource);
                s_LiveShowMediaPlayersPool.remove(intIndex);
            } else {
                o_LiveShow_MediaPlayer_Image = new LiveShow_MediaPlayer_Image(p_MediaSource);
            }
        }
        return o_LiveShow_MediaPlayer_Image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean poolAddEmpty(LiveShow_MediaPlayer_Image p_LiveShow_MediaPlayer_Image) {
        Object object = s_SyncPool;
        synchronized (object) {
            if (s_LiveShowMediaPlayersPool.size() < s_PoolSize) {
                s_LiveShowMediaPlayersPool.add(p_LiveShow_MediaPlayer_Image);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void poolClear() {
        Object object = s_SyncPool;
        synchronized (object) {
            for (int intPool = s_LiveShowMediaPlayersPool.size() - 1; intPool >= 0; --intPool) {
                LiveShow_MediaPlayer_Image o_LiveShow_MediaPlayer_Image = s_LiveShowMediaPlayersPool.get(intPool);
                o_LiveShow_MediaPlayer_Image.destroy();
                s_LiveShowMediaPlayersPool.remove(intPool);
            }
            s_LiveShowMediaPlayersPool.clear();
        }
    }

    public LiveShow_MediaPlayer_Image(MediaSource p_MediaSource) {
        super(p_MediaSource);
        this.initMembers();
        this.setSnapShotUseOriginal(false);
        Rectangle o_Bounds = GraphicsDeviceTools.getDefaultGraphicsDevice_Bounds();
        LiveShow_ImagePool.addLiveShow_MediaPlayer(this);
    }

    private void initMembers() {
        this.m_IsPlaying = false;
        this.m_IsInsideObject = false;
        this.m_PlayTime = 0L;
        this.m_SnapShotOriginRect = new Rectangle(0, 0, 100, 100);
        this.m_Fade = 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            if (this.m_Closed) {
                return;
            }
            LiveShow_ImagePool.removeLiveShow_MediaPlayer(this);
        }
        super.close();
        if (!this.m_WillDestroy && !LiveShow_MediaPlayer_Image.poolAddEmpty(this)) {
            this.destroy();
        }
    }

    @Override
    public void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            if (this.m_Destroyed) {
                return;
            }
            this.m_Destroyed = true;
            this.m_WillDestroy = true;
        }
        if (!this.m_Closed) {
            this.close();
        }
        object = this.m_SyncMediaPlayer;
        synchronized (object) {
            super.destroy();
            LiveShow_ImagePool.removeLiveShow_MediaPlayer(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reactivate(MediaSource p_MediaSource) {
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            if (this.m_Destroyed) {
                return;
            }
            super.reactivate(p_MediaSource);
            this.m_Closed = false;
        }
        LiveShow_ImagePool.addLiveShow_MediaPlayer(this);
    }

    @Override
    public BufferedImage getBufferedImage() {
        return LiveShow_ImagePool.getBufferedImage(this);
    }

    @Override
    public LiveShow_MediaPlayer.MediaImage getMediaImage() {
        return LiveShow_ImagePool.getImageElement(this);
    }

    @Override
    public Object getSyncImage() {
        return LiveShow_ImagePool.getSyncImage(this);
    }

    @Override
    public Dimension getPlayerGrabSize() {
        LiveShow_ImagePool.ImageElement o_ImageElement = LiveShow_ImagePool.getImageElement(this);
        if (o_ImageElement == null) {
            return this.m_PlayerGrabSize;
        }
        return o_ImageElement.getOriginSize();
    }

    @Override
    public Dimension getSourceSize() {
        LiveShow_ImagePool.ImageElement o_ImageElement = LiveShow_ImagePool.getImageElement(this);
        if (o_ImageElement == null) {
            return this.m_SourceSize;
        }
        return o_ImageElement.getOriginSize();
    }

    @Override
    public boolean saveActualImage_PNG(File p_ImageFile) {
        return super.saveActualImage_PNG(p_ImageFile, LiveShow_ImagePool.getBufferedImage(this), this.getPlayerGrabSize());
    }

    @Override
    public int getMediaType() {
        return 1001;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean load() {
        boolean boolLoaded;
        LiveShow_ImagePool.ImageElement o_ImageElement = LiveShow_ImagePool.getImageElement(this);
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            boolLoaded = o_ImageElement.load(this.m_RenderSize);
        }
        if (boolLoaded) {
            this.setMediaReady(true);
        }
        return boolLoaded;
    }

    @Override
    public long getLength() {
        return DEFAULTLENGTH_IMAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findSnapShots() {
        while (this.getSnapshotRequestCount() > 0) {
            LiveShow_MediaPlayer.SnapshotRequest o_SnapshotRequest = this.getSnapshotRequest(0);
            if (o_SnapshotRequest == null) {
                return;
            }
            this.removeSnapshotRequest(o_SnapshotRequest);
            LiveShow_ImagePool.ImageElement o_ImageElement = LiveShow_ImagePool.getImageElement(this);
            if (o_ImageElement == null) {
                return;
            }
            Object object = this.m_SyncMediaPlayer;
            synchronized (object) {
                if (this.m_Closed) {
                    return;
                }
                if (this.m_MediaSource == null) {
                    return;
                }
            }
            o_ImageElement.requestSnapShot(o_SnapshotRequest.getID(), o_SnapshotRequest.getSnapShotImage(), this.m_SnapShotOriginRect, o_SnapshotRequest.getTime(), o_SnapshotRequest.getSnapshotEventListener());
        }
    }

    @Override
    public void setPlayStatus(float p_Fade, float p_SoundVolume, long p_Milliseconds, boolean p_Playing, boolean p_InsideObject) {
        this.m_IsPlaying = p_Playing;
        this.m_IsInsideObject = p_InsideObject;
        this.m_PlayTime = p_Milliseconds;
        super.setFade(p_Fade, true);
    }

    @Override
    public boolean isPlaying() {
        return this.m_IsPlaying;
    }

    @Override
    public boolean isInsideObject() {
        return this.m_IsInsideObject;
    }

    @Override
    public long getPlayTime() {
        return this.m_PlayTime;
    }

    @Override
    public JEditorPane getJEditorPane() {
        return null;
    }
}

