/*
 * Decompiled with CFR 0.152.
 */
package MediaPlayerPackage;

import MediaPlayerPackage.FFmpegVideoWarningDialog;
import MediaPlayerPackage.LiveShow_MediaPlayer_Video_FFmpeg;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;

public class FFmpegVideoAnalyzer {
    public static VideoAnalyzerResult analyzeVideo(File p_VideoFile, String p_SourceSoftwareName) {
        long longDurationSetTimestamp = 0L;
        long longDurationSetTimestamp_Average = 0L;
        int intCountSetTimestampResults = 0;
        int intCountSetTimestampTests = 0;
        boolean boolProblemSetTimestamp = false;
        long longDurationGrabFrames = 0L;
        long longDurationGrabFrames_Average = 0L;
        int intCountGrabFrames = 0;
        boolean boolProblemGrabFrames = false;
        VideoAnalyzerResult o_VideoAnalyzerResult = new VideoAnalyzerResult();
        o_VideoAnalyzerResult.setSourceSoftwareName(p_SourceSoftwareName);
        if (p_VideoFile == null) {
            return o_VideoAnalyzerResult;
        }
        FFmpegFrameGrabber o_Grabber_Video = new FFmpegFrameGrabber(p_VideoFile);
        o_VideoAnalyzerResult.setVideoFileName(p_VideoFile.getName());
        o_VideoAnalyzerResult.setVideoFileDirectory(p_VideoFile.getParentFile().getAbsolutePath());
        try {
            o_Grabber_Video.start();
            if (o_Grabber_Video == null) {
                return o_VideoAnalyzerResult;
            }
            long longDuration = o_Grabber_Video.getLengthInTime() / 1000L;
            o_VideoAnalyzerResult.setVideoDuration(longDuration);
            if (o_Grabber_Video.hasAudio()) {
                o_VideoAnalyzerResult.setHasAudio(true);
                switch (o_Grabber_Video.getSampleFormat()) {
                    case 1: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        o_VideoAnalyzerResult.setAudioOK(true);
                        o_VideoAnalyzerResult.setAudioChannels(o_Grabber_Video.getAudioChannels());
                        o_VideoAnalyzerResult.setAudioSampleRate(o_Grabber_Video.getSampleRate());
                        break;
                    }
                    default: {
                        o_VideoAnalyzerResult.setAudioOK(false);
                        break;
                    }
                }
            } else {
                o_VideoAnalyzerResult.setHasAudio(false);
                o_VideoAnalyzerResult.setAudioOK(true);
            }
            if (!o_Grabber_Video.hasVideo()) {
                o_VideoAnalyzerResult.setHasVideo(false);
                o_VideoAnalyzerResult.setVideoOK(true);
                return o_VideoAnalyzerResult;
            }
            o_VideoAnalyzerResult.setHasVideo(true);
            int intWidth = o_Grabber_Video.getImageWidth();
            int intHeight = o_Grabber_Video.getImageHeight();
            double doubleFrameRate = o_Grabber_Video.getFrameRate();
            o_VideoAnalyzerResult.setToleranceSetTimestamp((int)(1000.0 / doubleFrameRate * 2.0));
            o_VideoAnalyzerResult.setVideoWidth(intWidth);
            o_VideoAnalyzerResult.setVideoHeight(intHeight);
            o_VideoAnalyzerResult.setVideoFrameRate(doubleFrameRate);
            o_VideoAnalyzerResult.setVideoAspectRation(o_Grabber_Video.getAspectRatio());
            o_Grabber_Video.setTimestamp(0L);
            ++intCountSetTimestampTests;
            long longTime = longDuration - o_VideoAnalyzerResult.getToleranceSetTimestamp() * 10L;
            longDurationSetTimestamp = FFmpegVideoAnalyzer.analyzeSetTimestamp(o_Grabber_Video, LiveShow_MediaPlayer_Video_FFmpeg.TIMETOLERANCE_WHILEPLAY, longTime);
            if (longDurationSetTimestamp >= 0L) {
                longDurationSetTimestamp_Average += longDurationSetTimestamp;
                ++intCountSetTimestampResults;
            }
            if ((longDurationGrabFrames = FFmpegVideoAnalyzer.analyzeGrabFrames(o_Grabber_Video)) >= 0L) {
                longDurationGrabFrames_Average += longDurationGrabFrames;
                ++intCountGrabFrames;
            }
            o_Grabber_Video.setTimestamp(0L);
            ++intCountSetTimestampTests;
            longTime = longDuration / 2L;
            if (longTime < 0L) {
                longTime = 0L;
            }
            if ((longDurationSetTimestamp = FFmpegVideoAnalyzer.analyzeSetTimestamp(o_Grabber_Video, LiveShow_MediaPlayer_Video_FFmpeg.TIMETOLERANCE_WHILEPLAY, longTime)) >= 0L) {
                longDurationSetTimestamp_Average += longDurationSetTimestamp;
                ++intCountSetTimestampResults;
            }
            if ((longDurationGrabFrames = FFmpegVideoAnalyzer.analyzeGrabFrames(o_Grabber_Video)) >= 0L) {
                longDurationGrabFrames_Average += longDurationGrabFrames;
                ++intCountGrabFrames;
            }
            o_Grabber_Video.setTimestamp(0L);
            ++intCountSetTimestampTests;
            longTime = longDuration - o_VideoAnalyzerResult.getToleranceSetTimestamp() * 10L;
            if (longTime < 0L) {
                longTime = 0L;
            }
            if ((longDurationSetTimestamp = FFmpegVideoAnalyzer.analyzeSetTimestamp(o_Grabber_Video, LiveShow_MediaPlayer_Video_FFmpeg.TIMETOLERANCE_WHILEPLAY, longTime)) >= 0L) {
                longDurationSetTimestamp_Average += longDurationSetTimestamp;
                ++intCountSetTimestampResults;
            }
            if ((longDurationGrabFrames = FFmpegVideoAnalyzer.analyzeGrabFrames(o_Grabber_Video)) >= 0L) {
                longDurationGrabFrames_Average += longDurationGrabFrames;
                ++intCountGrabFrames;
            }
            if (intCountGrabFrames > 0) {
                if ((double)(longDurationGrabFrames_Average /= (long)intCountGrabFrames) > 1000.0 / o_Grabber_Video.getFrameRate() / 4.0) {
                    boolProblemGrabFrames = true;
                }
            } else {
                longDurationGrabFrames = -1L;
                boolProblemGrabFrames = true;
            }
            if (intCountSetTimestampResults >= intCountSetTimestampTests) {
                if ((longDurationSetTimestamp_Average /= (long)intCountSetTimestampResults) > o_VideoAnalyzerResult.getToleranceSetTimestamp()) {
                    boolProblemSetTimestamp = true;
                }
            } else {
                longDurationSetTimestamp_Average = -1L;
                boolProblemSetTimestamp = true;
            }
            o_Grabber_Video.setTimestamp(0L);
        }
        catch (Exception e) {
            o_VideoAnalyzerResult.setVideoOK(false);
        }
        o_VideoAnalyzerResult.setDuration_SetTimestamp(longDurationSetTimestamp_Average);
        o_VideoAnalyzerResult.setDuration_GrabFrame(longDurationGrabFrames_Average);
        if (boolProblemSetTimestamp || boolProblemGrabFrames) {
            o_VideoAnalyzerResult.setVideoOK(false);
        } else {
            o_VideoAnalyzerResult.setVideoOK(true);
        }
        o_VideoAnalyzerResult.setVideoGrabOK(!boolProblemGrabFrames);
        o_VideoAnalyzerResult.setVideoSetTimestampOK(!boolProblemSetTimestamp);
        if (o_Grabber_Video != null) {
            try {
                o_Grabber_Video.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return o_VideoAnalyzerResult;
    }

    public static long analyzeSetTimestamp(FFmpegFrameGrabber p_Grabber_Video, long p_ToleranceSetTimestamp, long p_ActualPlayTime) {
        if (p_Grabber_Video == null) {
            return -1L;
        }
        int intsetCount = 0;
        if (p_ActualPlayTime < 0L) {
            p_ActualPlayTime = 0L;
        }
        long longStartNanoseconds = System.nanoTime();
        try {
            boolean boolShouldSetTime = true;
            long longTimeToSet = p_ActualPlayTime;
            while (boolShouldSetTime) {
                if (++intsetCount > 4) {
                    return -1L;
                }
                p_Grabber_Video.setTimestamp(longTimeToSet * 1000L);
                if (!p_Grabber_Video.hasVideo()) continue;
                Frame o_Frame = p_Grabber_Video.grabFrame(false, true, false, false, false);
                if (o_Frame == null) {
                    if ((longTimeToSet -= p_ToleranceSetTimestamp / 2L) >= 0L) continue;
                    longTimeToSet = 0L;
                    continue;
                }
                long longFoundVideoTimestamp = o_Frame.timestamp;
                if (p_ActualPlayTime - longFoundVideoTimestamp / 1000L > p_ToleranceSetTimestamp * 3L) {
                    longTimeToSet += p_ToleranceSetTimestamp / 2L;
                    continue;
                }
                if (p_ActualPlayTime - longFoundVideoTimestamp / 1000L < -p_ToleranceSetTimestamp * 3L) {
                    longTimeToSet += p_ToleranceSetTimestamp / 5L;
                    continue;
                }
                boolShouldSetTime = false;
                while (!boolShouldSetTime && o_Frame != null && (double)longFoundVideoTimestamp < (double)(p_ActualPlayTime * 1000L) - 1000.0 / p_Grabber_Video.getVideoFrameRate() && (o_Frame = p_Grabber_Video.grabFrame(true, true, true, false, false)) != null) {
                    if (o_Frame.image != null) {
                        longFoundVideoTimestamp = o_Frame.timestamp;
                    }
                    if (o_Frame.samples == null) continue;
                }
                if (!((double)Math.abs(longFoundVideoTimestamp / 1000L - p_ActualPlayTime) > 1000.0 / p_Grabber_Video.getVideoFrameRate() * 10.0)) continue;
                boolShouldSetTime = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
        long longEndNanoseconds = System.nanoTime();
        return (longEndNanoseconds - longStartNanoseconds) / 1000000L;
    }

    public static long analyzeGrabFrames(FFmpegFrameGrabber p_Grabber_Video) {
        if (p_Grabber_Video == null) {
            return -1L;
        }
        if (!p_Grabber_Video.hasVideo()) {
            return 0L;
        }
        long longStartNanoseconds = System.nanoTime();
        int intFrameCount = 0;
        while (intFrameCount < 10) {
            try {
                Frame o_Frame = p_Grabber_Video.grab();
                if (o_Frame == null) break;
                if (o_Frame.image == null) continue;
                ++intFrameCount;
            }
            catch (Exception e) {
                return -1L;
            }
        }
        if (intFrameCount <= 0) {
            return -1L;
        }
        long longEndNanoseconds = System.nanoTime();
        return (longEndNanoseconds - longStartNanoseconds) / (long)intFrameCount / 1000000L;
    }

    public static void showWarningDialog(VideoAnalyzerResult p_VideoAnalyzerResult) {
        if (p_VideoAnalyzerResult == null) {
            return;
        }
        FFmpegVideoWarningDialog o_FFmpegVideoWarningDialog = new FFmpegVideoWarningDialog(p_VideoAnalyzerResult, null, false);
        o_FFmpegVideoWarningDialog.setVisible(true);
    }

    public static class VideoAnalyzerResult
    implements Externalizable {
        private static final int SOFTWAREVERSION = 1;
        public static final String SOURCESOFTWARE_LIVSHOWSOFTWARE = "liveSHOW";
        public static final String SOURCESOFTWARE_MEDIASERVER = "liveSHOW_Media";
        private String m_SourceSoftwareName;
        private String m_ComputerName;
        private String m_VideoFileName;
        private String m_VideoFileDirecrory;
        private boolean m_HasAudio;
        private int m_AudioChannels;
        private double m_AudioSampleRate;
        private boolean m_AudioOK;
        private boolean m_HasVideo;
        private int m_VideoWidth;
        private int m_VideoHeight;
        private double m_VideoFrameRate;
        private double m_VideoAspectRatio;
        private long m_VideoDuration;
        private long m_ToleranceSetTimeStamp;
        private long m_Duration_SetTimestamp;
        private long m_Duration_GrabFrame;
        private boolean m_VideoOK;
        private boolean m_VideoGrabOK;
        private boolean m_VideoSetTimestampOK;

        public VideoAnalyzerResult() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_ComputerName = "";
            this.m_SourceSoftwareName = "";
            this.m_VideoOK = false;
            this.m_VideoGrabOK = false;
            this.m_VideoSetTimestampOK = false;
            this.m_HasAudio = false;
            this.m_AudioOK = false;
            this.m_AudioChannels = 0;
            this.m_AudioSampleRate = -1.0;
            this.m_HasVideo = false;
            this.m_SourceSoftwareName = "";
            this.m_VideoFileName = "";
            this.m_VideoFileDirecrory = "";
            this.m_VideoWidth = 0;
            this.m_VideoHeight = 0;
            this.m_VideoFrameRate = -1.0;
            this.m_VideoDuration = 0L;
            this.m_ToleranceSetTimeStamp = 300L;
            this.m_Duration_SetTimestamp = -1L;
            this.m_Duration_GrabFrame = -1L;
        }

        public void setResult(long p_DurationSetTimestamp, long p_DurationGrabFrame) {
            this.m_Duration_SetTimestamp = p_DurationSetTimestamp;
            this.m_Duration_GrabFrame = p_DurationGrabFrame;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeUTF(this.m_SourceSoftwareName);
            out.writeUTF(this.m_ComputerName);
            out.writeUTF(this.m_VideoFileName);
            out.writeUTF(this.m_VideoFileDirecrory);
            out.writeBoolean(this.m_HasAudio);
            out.writeBoolean(this.m_AudioOK);
            out.writeInt(this.m_AudioChannels);
            out.writeDouble(this.m_AudioSampleRate);
            out.writeBoolean(this.m_HasVideo);
            out.writeBoolean(this.m_VideoOK);
            out.writeBoolean(this.m_VideoGrabOK);
            out.writeBoolean(this.m_VideoSetTimestampOK);
            out.writeInt(this.m_VideoWidth);
            out.writeInt(this.m_VideoHeight);
            out.writeDouble(this.m_VideoFrameRate);
            out.writeDouble(this.m_VideoAspectRatio);
            out.writeLong(this.m_VideoDuration);
            out.writeLong(this.m_ToleranceSetTimeStamp);
            out.writeLong(this.m_Duration_SetTimestamp);
            out.writeLong(this.m_Duration_GrabFrame);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = 0;
            intSoftwareVersion = in.readInt();
            this.m_SourceSoftwareName = in.readUTF();
            this.m_ComputerName = in.readUTF();
            this.m_VideoFileName = in.readUTF();
            this.m_VideoFileDirecrory = in.readUTF();
            this.m_HasAudio = in.readBoolean();
            this.m_AudioOK = in.readBoolean();
            this.m_AudioChannels = in.readInt();
            this.m_AudioSampleRate = in.readDouble();
            this.m_HasVideo = in.readBoolean();
            this.m_VideoOK = in.readBoolean();
            this.m_VideoGrabOK = in.readBoolean();
            this.m_VideoSetTimestampOK = in.readBoolean();
            this.m_VideoWidth = in.readInt();
            this.m_VideoHeight = in.readInt();
            this.m_VideoFrameRate = in.readDouble();
            this.m_VideoAspectRatio = in.readDouble();
            this.m_VideoDuration = in.readLong();
            this.m_ToleranceSetTimeStamp = in.readLong();
            this.m_Duration_SetTimestamp = in.readLong();
            this.m_Duration_GrabFrame = in.readLong();
        }

        public String getComputerName() {
            return this.m_ComputerName;
        }

        public void setComputerName(String p_ComputerName) {
            this.m_ComputerName = p_ComputerName == null ? "" : p_ComputerName;
        }

        public String getSourceSoftwareName() {
            return this.m_SourceSoftwareName;
        }

        public void setSourceSoftwareName(String p_SoftwareName) {
            this.m_SourceSoftwareName = p_SoftwareName == null ? "" : p_SoftwareName;
        }

        public String getVideoFileName() {
            return this.m_VideoFileName;
        }

        public void setVideoFileName(String p_FileName) {
            this.m_VideoFileName = p_FileName == null ? "" : p_FileName;
        }

        public String getVideoFileDirectory() {
            return this.m_VideoFileDirecrory;
        }

        public void setVideoFileDirectory(String p_FileDirectory) {
            this.m_VideoFileDirecrory = p_FileDirectory == null ? "" : p_FileDirectory;
        }

        public boolean getVideoOK() {
            return this.m_VideoOK;
        }

        public void setVideoOK(boolean p_VideoOK) {
            this.m_VideoOK = p_VideoOK;
        }

        public boolean getVideoGrabOK() {
            return this.m_VideoGrabOK;
        }

        public void setVideoGrabOK(boolean p_VideoGrabOK) {
            this.m_VideoGrabOK = p_VideoGrabOK;
        }

        public boolean getVideoSetTimestampOK() {
            return this.m_VideoSetTimestampOK;
        }

        public void setVideoSetTimestampOK(boolean p_VideoSetTimestampOK) {
            this.m_VideoSetTimestampOK = p_VideoSetTimestampOK;
        }

        public boolean hasVideo() {
            return this.m_HasVideo;
        }

        public void setHasVideo(boolean p_HasVideo) {
            this.m_HasVideo = p_HasVideo;
        }

        public int getVideoWidth() {
            return this.m_VideoWidth;
        }

        public void setVideoWidth(int p_Width) {
            this.m_VideoWidth = p_Width;
        }

        public int getVideoHeight() {
            return this.m_VideoHeight;
        }

        public void setVideoHeight(int p_Height) {
            this.m_VideoHeight = p_Height;
        }

        public double getVideoFrameRate() {
            return this.m_VideoFrameRate;
        }

        public void setVideoFrameRate(double p_VideoFramerate) {
            this.m_VideoFrameRate = p_VideoFramerate;
        }

        public double getVideoAspectRatio() {
            return this.m_VideoAspectRatio;
        }

        public void setVideoAspectRation(double p_AspectRatio) {
            this.m_VideoAspectRatio = p_AspectRatio;
        }

        public long getVideoDuration() {
            return this.m_VideoDuration;
        }

        public void setVideoDuration(long p_Duration) {
            if (p_Duration < 0L) {
                p_Duration = 0L;
            }
            this.m_VideoDuration = p_Duration;
        }

        public long getToleranceSetTimestamp() {
            return this.m_ToleranceSetTimeStamp;
        }

        public void setToleranceSetTimestamp(long p_Milliseconds) {
            this.m_ToleranceSetTimeStamp = p_Milliseconds;
        }

        public long getDuration_SetTimestamp() {
            return this.m_Duration_SetTimestamp;
        }

        public void setDuration_SetTimestamp(long p_Duration) {
            this.m_Duration_SetTimestamp = p_Duration;
        }

        public long getDuration_GrabFrame() {
            return this.m_Duration_GrabFrame;
        }

        public void setDuration_GrabFrame(long p_Duration) {
            this.m_Duration_GrabFrame = p_Duration;
        }

        public boolean hasAudio() {
            return this.m_HasAudio;
        }

        public void setHasAudio(boolean p_HasAudio) {
            this.m_HasAudio = p_HasAudio;
        }

        public boolean getAudioOK() {
            return this.m_AudioOK;
        }

        public void setAudioOK(boolean p_AudioOK) {
            this.m_AudioOK = p_AudioOK;
        }

        public int getAudioChannels() {
            return this.m_AudioChannels;
        }

        public void setAudioChannels(int p_Channels) {
            this.m_AudioChannels = p_Channels;
        }

        public double getAudioSampleRate() {
            return this.m_AudioSampleRate;
        }

        public void setAudioSampleRate(double p_AudioFrameRate) {
            this.m_AudioSampleRate = p_AudioFrameRate;
        }
    }
}

