/*
 * Decompiled with CFR 0.152.
 */
package ACN_1_17_Package;

import ACN_1_17_Package.ACNData_Interface;
import ACN_1_17_Package.ACNLayer_Interface;
import ACN_1_17_Package.ACN_ByteData;

public class ACN_PDU {
    private int m_StartPosition;
    private ACNData_Interface m_ParentACNData;
    private ACNLayer_Interface m_ACNLayer;
    private ACNData_Interface m_ACNData;
    private PDU_FlagsLengthH m_PDU_FlagsLengthH;
    private PDU_LengthL m_PDU_LengthL;
    private PDU_LengthXH m_PDU_LengthXH;
    private PDU_Vector m_PDU_Vector;
    private PDU_Header m_PDU_Header;
    private int m_Size;
    private boolean m_IsReceived;
    private boolean m_HasReceivedData;
    private boolean m_IsFilled;
    private boolean m_HasFilledData;
    private boolean m_IsDiscarded;
    private boolean m_IsClosed;

    public ACN_PDU(ACNLayer_Interface p_ACNLayer_Interface, ACNData_Interface p_ACNData_Interface) {
        this.initMembers();
        this.m_PDU_FlagsLengthH.flag_L(false);
        this.m_PDU_FlagsLengthH.flag_V(true);
        this.m_PDU_FlagsLengthH.flag_H(true);
        this.m_PDU_FlagsLengthH.flag_D(true);
        this.m_ACNLayer = p_ACNLayer_Interface;
        this.m_PDU_Vector = new PDU_Vector(this.m_ACNLayer.getACN_Vector_Size(), this);
        this.m_PDU_Header = new PDU_Header(this.m_ACNLayer.getACN_PDU_HeaderLengthBytesCount(), this.m_ACNLayer.getACN_PDU_HeaderSize(), this);
        this.m_ACNData = p_ACNData_Interface;
    }

    public ACN_PDU(int p_StartPosition, ACNData_Interface p_ParentACNData, ACNLayer_Interface p_ACNLayer) {
        this.initMembers();
        this.m_StartPosition = p_StartPosition;
        this.m_ParentACNData = p_ParentACNData;
        this.m_ACNLayer = p_ACNLayer;
        this.m_PDU_Vector = p_ACNLayer != null ? new PDU_Vector(p_ACNLayer.getACN_Vector_Size(), this) : new PDU_Vector(1, this);
        this.m_PDU_Header = p_ACNLayer != null ? new PDU_Header(p_ACNLayer.getACN_PDU_HeaderLengthBytesCount(), p_ACNLayer.getACN_PDU_HeaderSize(), this) : new PDU_Header(0, 1, this);
    }

    private void initMembers() {
        this.m_IsReceived = false;
        this.m_HasReceivedData = false;
        this.m_IsFilled = false;
        this.m_HasFilledData = false;
        this.m_IsClosed = false;
        this.m_IsDiscarded = false;
        this.m_PDU_FlagsLengthH = new PDU_FlagsLengthH(this);
        this.m_PDU_LengthL = new PDU_LengthL(this);
        this.m_PDU_LengthXH = new PDU_LengthXH(this);
        this.m_PDU_Vector = null;
        this.m_PDU_Header = null;
        this.m_Size = 0;
        this.m_ACNData = null;
    }

    private void initMembersFurther() {
    }

    public void close() {
        if (this.m_IsClosed) {
            return;
        }
        this.m_IsClosed = true;
        if (this.m_ACNData != null) {
            this.m_ACNData.close();
        }
        if (this.m_PDU_Header != null) {
            this.m_PDU_Header.close();
        }
        if (this.m_PDU_Vector != null) {
            this.m_PDU_Vector.close();
        }
        if (this.m_PDU_LengthXH != null) {
            this.m_PDU_LengthXH.close();
        }
        if (this.m_PDU_LengthL != null) {
            this.m_PDU_LengthL.close();
        }
        if (this.m_PDU_FlagsLengthH != null) {
            this.m_PDU_FlagsLengthH.close();
        }
    }

    public void setStartPosition(int p_StartPosition) {
        this.m_StartPosition = p_StartPosition;
    }

    public int getStartPosition() {
        return this.m_StartPosition;
    }

    public ACNData_Interface getParentACNData() {
        return this.m_ParentACNData;
    }

    public ACNLayer_Interface getACNLayer() {
        return this.m_ACNLayer;
    }

    public void setACNLayer(ACNLayer_Interface p_ACNLayer_Interface) {
        if (this.m_ACNLayer == p_ACNLayer_Interface) {
            return;
        }
        this.m_ACNLayer = p_ACNLayer_Interface;
    }

    public int eventDataReceived(byte[] p_Data, int p_Offset, int p_Length, int p_Position) {
        this.m_HasReceivedData = true;
        if (this.m_IsReceived) {
            return p_Offset;
        }
        int intNewOffset = p_Offset;
        int intNewPosition = p_Position;
        if (!this.m_PDU_FlagsLengthH.isReceived()) {
            intNewOffset = this.m_PDU_FlagsLengthH.eventDataReceived(p_Data, intNewOffset, p_Length);
            if (!this.m_PDU_FlagsLengthH.isReceived()) {
                return intNewOffset;
            }
        }
        intNewPosition = p_Position + intNewOffset - p_Offset;
        if (!this.m_PDU_LengthL.isReceived()) {
            intNewOffset = this.m_PDU_LengthL.eventDataReceived(p_Data, intNewOffset, p_Length);
            if (!this.m_PDU_LengthL.isReceived()) {
                return intNewOffset;
            }
            if (!this.m_PDU_FlagsLengthH.flag_L()) {
                this.m_Size = (this.m_PDU_FlagsLengthH.getLengthH() & 0xF) << 8 | this.m_PDU_LengthL.getLengthL() & 0xFF;
            }
        }
        intNewPosition = p_Position + intNewOffset - p_Offset;
        if (this.m_PDU_FlagsLengthH.flag_L() && !this.m_PDU_LengthXH.isReceived()) {
            intNewOffset = this.m_PDU_LengthXH.eventDataReceived(p_Data, intNewOffset, p_Length);
            if (!this.m_PDU_LengthXH.isReceived()) {
                return intNewOffset;
            }
            this.m_Size = (this.m_PDU_FlagsLengthH.getLengthH() & 0xF) << 16 | (this.m_PDU_LengthL.getLengthL() & 0xFF) << 8 | this.m_PDU_LengthXH.getLengthXH() & 0xFF;
        }
        intNewPosition = p_Position + intNewOffset - p_Offset;
        if (this.m_PDU_FlagsLengthH.flag_V() && !this.m_PDU_Vector.isReceived()) {
            intNewOffset = this.m_PDU_Vector.eventDataReceived(p_Data, intNewOffset, p_Length);
            if (!this.m_PDU_Vector.isReceived()) {
                return intNewOffset;
            }
        }
        intNewPosition = p_Position + intNewOffset - p_Offset;
        if (this.m_PDU_FlagsLengthH.flag_H() && this.m_PDU_Header != null && !this.m_PDU_Header.isReceived()) {
            intNewOffset = this.m_PDU_Header.eventDataReceived(p_Data, intNewOffset, p_Length);
            if (!this.m_PDU_Header.isReceived()) {
                return intNewOffset;
            }
        }
        intNewPosition = p_Position + intNewOffset - p_Offset;
        this.m_ACNData = this.m_ACNLayer.createACNData(this);
        if (this.m_PDU_FlagsLengthH.flag_D()) {
            intNewOffset = this.m_ACNData.eventDataReceived(p_Data, intNewOffset, p_Length, intNewPosition);
        }
        intNewPosition = p_Position + intNewOffset - p_Offset;
        this.m_IsReceived = true;
        return intNewOffset;
    }

    public boolean isReceived() {
        return this.m_IsReceived;
    }

    public void resetReceive() {
        if (!this.m_HasReceivedData) {
            return;
        }
        this.m_HasReceivedData = true;
        this.m_PDU_FlagsLengthH.resetReceive();
        this.m_PDU_LengthL.resetReceive();
        this.m_PDU_LengthXH.resetReceive();
        this.m_PDU_Vector.resetReceive();
        this.m_PDU_Header.resetReceive();
        this.m_ACNData.resetReceive();
        this.m_IsReceived = false;
    }

    public boolean isFilled() {
        return this.m_IsFilled;
    }

    public void resetFilled() {
        if (!this.m_HasFilledData) {
            return;
        }
        this.m_HasFilledData = false;
        this.m_PDU_FlagsLengthH.resetFilled();
        this.m_PDU_LengthL.resetFilled();
        this.m_PDU_LengthXH.resetFilled();
        this.m_PDU_Vector.resetFilled();
        this.m_PDU_Header.resetFilled();
        this.m_ACNData.resetFilled();
        this.m_IsFilled = false;
    }

    public int fillByteArray(byte[] p_ByteArray, int p_Offset, int p_Position) {
        int intNewOffset = p_Offset;
        int intNewPosition = p_Position;
        this.m_HasFilledData = true;
        if (this.m_IsFilled) {
            return p_Offset;
        }
        if (this.m_PDU_FlagsLengthH != null && !this.m_PDU_FlagsLengthH.isFilled()) {
            intNewOffset = this.m_PDU_FlagsLengthH.fillByteArray(p_ByteArray, intNewOffset);
            if (!this.m_PDU_FlagsLengthH.isFilled()) {
                return intNewOffset;
            }
        }
        if (this.m_PDU_LengthL != null && !this.m_PDU_LengthL.isFilled()) {
            intNewOffset = this.m_PDU_LengthL.fillByteArray(p_ByteArray, intNewOffset);
            if (!this.m_PDU_LengthL.isFilled()) {
                return intNewOffset;
            }
        }
        if (this.m_PDU_FlagsLengthH.flag_L() && this.m_PDU_LengthXH != null && !this.m_PDU_LengthXH.isFilled()) {
            intNewOffset = this.m_PDU_LengthXH.fillByteArray(p_ByteArray, intNewOffset);
            if (!this.m_PDU_LengthXH.isFilled()) {
                return intNewOffset;
            }
        }
        if (this.m_PDU_FlagsLengthH.flag_V() && this.m_PDU_Vector != null && !this.m_PDU_Vector.isFilled()) {
            intNewOffset = this.m_PDU_Vector.fillByteArray(p_ByteArray, intNewOffset);
            if (!this.m_PDU_Vector.isFilled()) {
                return intNewOffset;
            }
        }
        if (this.m_PDU_FlagsLengthH.flag_H() && this.m_PDU_Header != null && !this.m_PDU_Header.isFilled()) {
            intNewOffset = this.m_PDU_Header.fillByteArray(p_ByteArray, intNewOffset);
            if (!this.m_PDU_Header.isFilled()) {
                return intNewOffset;
            }
        }
        intNewPosition = p_Position + intNewOffset - p_Offset;
        if (this.m_PDU_FlagsLengthH.flag_D() && this.m_ACNData != null && !this.m_ACNData.isFilled()) {
            intNewOffset = this.m_ACNData.fillByteArray(p_ByteArray, intNewOffset, intNewPosition);
            if (!this.m_ACNData.isFilled()) {
                return intNewOffset;
            }
        }
        this.m_IsFilled = true;
        return intNewOffset;
    }

    public void setDiscarded(boolean p_Discarded) {
        if (this.m_IsDiscarded == p_Discarded) {
            return;
        }
        this.m_IsDiscarded = p_Discarded;
        this.m_ACNData.setDiscarded(p_Discarded);
    }

    public boolean isDiscarded() {
        return this.m_IsDiscarded;
    }

    public PDU_Vector getPDU_Vector() {
        ACNData_Interface o_ParentACNData_Interface;
        PDU_Vector o_PDU_Vector = null;
        if (this.m_PDU_FlagsLengthH.flag_V()) {
            o_PDU_Vector = this.m_PDU_Vector;
        } else if (this.m_ACNData != null && (o_ParentACNData_Interface = this.m_ACNData.getParentACNData()) != null) {
            o_PDU_Vector = o_ParentACNData_Interface.getPDUVectorHeritage(this.m_ACNData);
        }
        return o_PDU_Vector;
    }

    public PDU_Header getPDU_Header() {
        ACNData_Interface o_ParentACNData_Interface;
        PDU_Header o_PDU_Header = null;
        if (this.m_PDU_FlagsLengthH.flag_H()) {
            o_PDU_Header = this.m_PDU_Header;
        } else if (this.m_ACNData != null && (o_ParentACNData_Interface = this.m_ACNData.getParentACNData()) != null) {
            o_PDU_Header = o_ParentACNData_Interface.getPDUHeaderHeritage(this.m_ACNData);
        }
        return o_PDU_Header;
    }

    public ACNData_Interface getACNData() {
        ACNData_Interface o_ParentACNData_Interface;
        ACNData_Interface o_ACNData_Interface = null;
        if (this.m_PDU_FlagsLengthH.flag_D()) {
            o_ACNData_Interface = this.m_ACNData;
        } else if (this.m_ACNData != null && (o_ParentACNData_Interface = this.m_ACNData.getParentACNData()) != null) {
            o_ACNData_Interface = o_ParentACNData_Interface.getACNDataHeritage(this.m_ACNData);
        }
        return o_ACNData_Interface;
    }

    public int getSize() {
        return this.m_Size;
    }

    public void setSize(int p_Size) {
        int intSize = p_Size;
        if (p_Size > 4095) {
            this.m_PDU_LengthXH.setByte(0, (byte)(intSize & 0xFF));
            this.m_PDU_LengthL.setByte(0, (byte)((intSize >>>= 8) & 0xFF));
            byte byteFlagsLangthH = this.m_PDU_FlagsLengthH.getByte(0);
            byteFlagsLangthH = (byte)((byte)(byteFlagsLangthH & 0xF0) + (byte)((intSize >>>= 8) & 0xF));
            this.m_PDU_FlagsLengthH.setByte(0, byteFlagsLangthH);
        } else {
            this.m_PDU_LengthXH.setByte(0, (byte)0);
            this.m_PDU_LengthL.setByte(0, (byte)(intSize & 0xFF));
            byte byteFlagsLangthH = this.m_PDU_FlagsLengthH.getByte(0);
            byteFlagsLangthH = (byte)((byte)(byteFlagsLangthH & 0xF0) + (byte)((intSize >>>= 8) & 0xF));
            this.m_PDU_FlagsLengthH.setByte(0, byteFlagsLangthH);
        }
        this.m_Size = p_Size;
    }

    public int calculateSize() {
        int intSize = 0;
        intSize += this.m_PDU_FlagsLengthH.getSize();
        intSize += this.m_PDU_LengthL.getSize();
        if (this.m_PDU_FlagsLengthH.flag_L()) {
            intSize += this.m_PDU_LengthXH.getSize();
        }
        if (this.m_PDU_FlagsLengthH.flag_V()) {
            intSize += this.m_PDU_Vector.getSize();
        }
        if (this.m_PDU_FlagsLengthH.flag_H()) {
            intSize += this.m_PDU_Header.getSize();
        }
        if (this.m_PDU_FlagsLengthH.flag_D() && this.m_ACNData != null) {
            intSize += this.m_ACNData.calculateSize();
        }
        this.setSize(intSize);
        return intSize;
    }

    public static class PDU_Header {
        private ACN_PDU m_ACN_PDU;
        private PDUHeaderLength m_PDUHeaderLength;
        private PDUHeaderContent m_PDUHeaderContent;
        private boolean m_IsReceived;
        private boolean m_IsFilled;

        public PDU_Header(int p_HeaderLengthSize, int p_HeaderSize, ACN_PDU p_ACN_PDU) {
            this.initMembers();
            this.m_PDUHeaderLength = new PDUHeaderLength(p_HeaderLengthSize, this);
            this.m_PDUHeaderContent = new PDUHeaderContent(p_HeaderSize, this);
        }

        private void initMembers() {
            this.m_IsReceived = false;
            this.m_IsFilled = false;
        }

        private void initMembersFurther() {
        }

        public void close() {
            if (this.m_PDUHeaderLength != null) {
                this.m_PDUHeaderLength.close();
            }
            if (this.m_PDUHeaderContent != null) {
                this.m_PDUHeaderContent.close();
            }
        }

        public ACN_PDU getACN_PDU() {
            return this.m_ACN_PDU;
        }

        public PDUHeaderLength getHeaderLength() {
            return this.m_PDUHeaderLength;
        }

        public PDUHeaderContent getHeaderContent() {
            return this.m_PDUHeaderContent;
        }

        public int eventDataReceived(byte[] p_Data, int p_Offset, int p_Length) {
            int intCOntentSize = 0;
            if (this.m_IsReceived) {
                return p_Offset;
            }
            int intOffset = p_Offset;
            if (this.m_PDUHeaderLength.getSize() > 0 && !this.m_PDUHeaderLength.isReceived()) {
                intOffset = this.m_PDUHeaderLength.eventDataReceived(p_Data, intOffset, p_Length);
                if (!this.m_PDUHeaderLength.isReceived()) {
                    return intOffset;
                }
                intCOntentSize = this.m_PDUHeaderLength.getLength();
                this.m_PDUHeaderContent.setSize(intCOntentSize);
            }
            if (!this.m_PDUHeaderContent.isReceived()) {
                intOffset = this.m_PDUHeaderContent.eventDataReceived(p_Data, intOffset, p_Length);
                if (!this.m_PDUHeaderContent.isReceived()) {
                    return intOffset;
                }
            }
            this.m_IsReceived = true;
            this.analyze();
            return intOffset;
        }

        public boolean isReceived() {
            return this.m_IsReceived;
        }

        public void resetReceive() {
            this.m_PDUHeaderLength.resetReceive();
            this.m_PDUHeaderContent.resetReceive();
            this.m_IsReceived = false;
        }

        public boolean analyze() {
            return true;
        }

        public int getSize() {
            int intSize = 0;
            intSize += this.m_PDUHeaderLength.getSize();
            return intSize += this.m_PDUHeaderContent.getSize();
        }

        public int fillByteArray(byte[] p_ByteArray, int p_Offset) {
            if (this.m_IsFilled) {
                return p_Offset;
            }
            int intNewOffset = p_Offset;
            if (this.m_PDUHeaderLength.getSize() > 0 && !this.m_PDUHeaderLength.isFilled()) {
                intNewOffset = this.m_PDUHeaderLength.fillByteArray(p_ByteArray, intNewOffset);
                if (!this.m_PDUHeaderLength.isFilled()) {
                    return intNewOffset;
                }
                this.m_PDUHeaderContent.setSize(this.m_PDUHeaderLength.getLength());
            }
            if (this.m_PDUHeaderContent != null && !this.m_PDUHeaderContent.isFilled()) {
                intNewOffset = this.m_PDUHeaderContent.fillByteArray(p_ByteArray, intNewOffset);
                if (!this.m_PDUHeaderContent.isFilled()) {
                    return intNewOffset;
                }
            }
            this.m_IsFilled = true;
            return intNewOffset;
        }

        public void resetFilled() {
            this.m_PDUHeaderLength.resetFilled();
            this.m_PDUHeaderContent.resetFilled();
            this.m_IsFilled = false;
        }

        public boolean isFilled() {
            return this.m_IsFilled;
        }

        public static class PDUHeaderContent
        extends ACN_ByteData {
            private PDU_Header m_PDU_Header;

            public PDUHeaderContent(int p_HeaderContentSize, PDU_Header p_PDU_Header) {
                super(p_HeaderContentSize);
                this.m_PDU_Header = p_PDU_Header;
            }

            @Override
            public void close() {
                super.closeByExtendedClass();
            }

            @Override
            public boolean analyze() {
                return true;
            }
        }

        public static class PDUHeaderLength
        extends ACN_ByteData {
            private PDU_Header m_PDU_Header;
            private int m_Length;

            public PDUHeaderLength(int p_HeaderLengthSize, PDU_Header p_PDU_Header) {
                super(p_HeaderLengthSize);
                this.m_PDU_Header = p_PDU_Header;
            }

            @Override
            public void close() {
                super.closeByExtendedClass();
            }

            @Override
            public boolean analyze() {
                this.m_Length = this.getInt();
                return true;
            }

            public int getLength() {
                return this.m_Length;
            }
        }
    }

    public static class PDU_Vector
    extends ACN_ByteData {
        private ACN_PDU m_ACN_PDU;

        public PDU_Vector(int p_VectorSize, ACN_PDU p_ACN_PDU) {
            super(p_VectorSize);
            this.m_ACN_PDU = p_ACN_PDU;
        }

        public PDU_Vector(ACN_PDU p_ACN_PDU) {
            super(p_ACN_PDU.getACNLayer().getACN_Vector_Size());
            this.m_ACN_PDU = p_ACN_PDU;
        }

        @Override
        public void close() {
            super.closeByExtendedClass();
        }

        public ACN_PDU getACN_PDU() {
            return this.m_ACN_PDU;
        }

        @Override
        public boolean analyze() {
            return true;
        }

        public int getVectorValue() {
            return this.getInt();
        }
    }

    public static class PDU_LengthXH
    extends ACN_ByteData {
        private ACN_PDU m_ACN_PDU;
        private byte m_LengthXH;

        public PDU_LengthXH(ACN_PDU p_ACN_PDU) {
            super(1);
            this.m_ACN_PDU = p_ACN_PDU;
        }

        private void initMembers() {
            this.m_LengthXH = 0;
        }

        @Override
        public void close() {
            super.closeByExtendedClass();
        }

        public ACN_PDU getACN_PDU() {
            return this.m_ACN_PDU;
        }

        @Override
        public boolean analyze() {
            this.m_LengthXH = this.m_Data[0];
            return true;
        }

        public byte getLengthXH() {
            return this.m_LengthXH;
        }
    }

    public static class PDU_LengthL
    extends ACN_ByteData {
        private ACN_PDU m_ACN_PDU;
        private byte m_LengthLow;

        public PDU_LengthL(ACN_PDU p_ACN_PDU) {
            super(1);
            this.initMembers();
            this.m_ACN_PDU = p_ACN_PDU;
        }

        private void initMembers() {
            this.m_LengthLow = 0;
        }

        @Override
        public void close() {
            super.closeByExtendedClass();
        }

        public ACN_PDU getACN_PDU() {
            return this.m_ACN_PDU;
        }

        @Override
        public boolean analyze() {
            if (this.m_Data != null) {
                this.m_LengthLow = this.m_Data[0];
            }
            return true;
        }

        public byte getLengthL() {
            return this.m_LengthLow;
        }
    }

    public static class PDU_FlagsLengthH
    extends ACN_ByteData {
        private ACN_PDU m_ACN_PDU;
        private byte m_LengthHigh;

        public PDU_FlagsLengthH(ACN_PDU p_ACN_PDU) {
            super(1);
            this.m_ACN_PDU = p_ACN_PDU;
        }

        public ACN_PDU getACN_PDU() {
            return this.m_ACN_PDU;
        }

        @Override
        public void close() {
            super.closeByExtendedClass();
        }

        @Override
        public boolean analyze() {
            this.m_LengthHigh = (byte)(this.m_Data[0] & 0xF);
            return true;
        }

        public void flag_L(boolean p_IsSet) {
            if (p_IsSet) {
                this.setByte(0, (byte)(this.m_Data[0] | 0x80));
            } else {
                this.setByte(0, (byte)(this.m_Data[0] & 0x7F));
            }
        }

        public boolean flag_L() {
            return (this.m_Data[0] & 0x80) > 0;
        }

        public void flag_V(boolean p_IsSet) {
            if (p_IsSet) {
                this.setByte(0, (byte)(this.m_Data[0] | 0x40));
            } else {
                this.setByte(0, (byte)(this.m_Data[0] & 0xBF));
            }
        }

        public boolean flag_V() {
            return (this.m_Data[0] & 0x40) > 0;
        }

        public void flag_H(boolean p_IsSet) {
            if (p_IsSet) {
                this.setByte(0, (byte)(this.m_Data[0] | 0x20));
            } else {
                this.setByte(0, (byte)(this.m_Data[0] & 0xDF));
            }
        }

        public boolean flag_H() {
            return (this.m_Data[0] & 0x20) > 0;
        }

        public void flag_D(boolean p_IsSet) {
            if (p_IsSet) {
                this.setByte(0, (byte)(this.m_Data[0] | 0x10));
            } else {
                this.setByte(0, (byte)(this.m_Data[0] & 0xEF));
            }
        }

        public boolean flag_D() {
            return (this.m_Data[0] & 0x10) > 0;
        }

        public byte getLengthH() {
            return this.m_LengthHigh;
        }
    }
}

