/*
 * Decompiled with CFR 0.152.
 */
package LiveCommSerial;

import LiveCommSerial.CommSerialPortEvent;
import LiveCommSerial.CommSerialPortEventListener;
import LiveCommSerial.CommSerialPortException;
import OSCheckerPackage.OSChecker;
import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.UUID;

public class CommSerialPortConnection
implements Serializable {
    static final long serialVersionUID = -3123491789822483146L;
    static final long s_SerialPortWaitTime = 30000L;
    public static final int DATABITS_5 = 5;
    public static final int DATABITS_6 = 6;
    public static final int DATABITS_7 = 7;
    public static final int DATABITS_8 = 8;
    public static final int PARITY_NONE = 0;
    public static final int PARITY_ODD = 1;
    public static final int PARITY_EVEN = 2;
    public static final int PARITY_MARK = 3;
    public static final int PARITY_SPACE = 4;
    public static final int STOPBITS_1 = 1;
    public static final int STOPBITS_2 = 3;
    public static final int STOPBITS_1_5 = 2;
    public static final int FLOWCONTROL_NONE = 0;
    public static final int FLOWCONTROL_RTS = 1;
    public static final int FLOWCONTROL_DSR = 256;
    public static final int FLOWCONTROL_DTR = 4096;
    public static final int FLOWCONTROL_CTS = 16;
    public static final int FLOWCONTROL_XONXOFF_IN = 65536;
    public static final int FLOWCONTROL_XONXOFF_OUT = 0x100000;
    public static final int BUFFERLENGTH_DEFAULT = 1024;
    private String m_PortName;
    private int m_Baud;
    private int m_DataBits;
    private int m_StopBits;
    private int m_Parity;
    private SerialPort m_RXTXPort;
    private SerialReader m_SerialReader;
    private SerialWriter m_SerialWriter;
    private final Object m_SyncWriterThread = new Object();
    private boolean m_IOExceptionOccured;
    private boolean m_ConnectionTrySuccess;
    private ArrayList<CommSerialPortEventListener> m_InputListeners;
    private final Object m_SyncConnection = new Object();
    private final Object m_SyncListener = new Object();
    private final Object m_SyncParseReadenBytes = new Object();
    public static boolean s_DebugOn = false;
    public static boolean s_LibraryLoaded = false;
    public static String s_LibraryAppID = "";
    public static ArrayList<ByteArray_Write> s_PoolByteArrayWrite = new ArrayList(5);
    public static final Object s_SyncPoolByteArrayWrite = new Object();
    public static int s_PoolSizeMax_ByteArrayWrite = 100;

    public static boolean loadLibrary(String p_AppID) throws Exception {
        if (s_LibraryLoaded) {
            return true;
        }
        if (p_AppID == null) {
            p_AppID = "CommSerialPortConnection";
        }
        s_LibraryAppID = UUID.randomUUID().toString();
        System.setProperty("fazecast.jSerialComm.appid", p_AppID);
        s_LibraryLoaded = true;
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                CommSerialPortConnection.unloadLibrary();
            }
        };
        SerialPort.addShutdownHook(new Thread(o_Runnable));
        return true;
    }

    public static boolean unloadLibrary() {
        if (!s_LibraryLoaded) {
            return false;
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        o_StringBuilder.append(System.getProperty("java.io.tmpdir"));
        o_StringBuilder.append(File.separator);
        o_StringBuilder.append("jSerialComm");
        o_StringBuilder.append(File.separator);
        o_StringBuilder.append(s_LibraryAppID);
        File o_File = new File(o_StringBuilder.toString());
        if (o_File.exists()) {
            CommSerialPortConnection.deleteDir(o_File);
        }
        s_LibraryLoaded = false;
        return true;
    }

    private static void deleteDir(File file) {
        boolean boolDelete = false;
        File[] contents = file.listFiles();
        if (contents != null) {
            for (File f : contents) {
                CommSerialPortConnection.deleteDir(f);
            }
        }
        try {
            boolDelete = file.delete();
        }
        catch (Exception e) {
            int n = 0;
        }
        boolean intTest = false;
    }

    public CommSerialPortConnection() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_Baud = 57600;
        this.m_DataBits = 8;
        this.m_StopBits = 1;
        this.m_Parity = 0;
        this.readResolve();
    }

    private Object readResolve() {
        this.m_RXTXPort = null;
        this.m_InputListeners = new ArrayList();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.m_SyncConnection;
        synchronized (object) {
            this.disconnect();
        }
        object = this.m_SyncListener;
        synchronized (object) {
            this.m_InputListeners.clear();
        }
    }

    public static ArrayList<SerialPort> getSerialPorts() {
        final ArrayList<SerialPort> o_ArrayListSerialPortNames = new ArrayList<SerialPort>();
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    SerialPort[] o_SerialPorts = SerialPort.getCommPorts();
                    if (o_SerialPorts == null) {
                        return;
                    }
                    for (int intPort = 0; intPort < o_SerialPorts.length; ++intPort) {
                        SerialPort o_SerialPort = o_SerialPorts[intPort];
                        if (o_SerialPort == null || o_SerialPort.isOpen() || OSChecker.getIsMac() && !o_SerialPort.getSystemPortName().toLowerCase().contains("cu.")) continue;
                        o_ArrayListSerialPortNames.add(o_SerialPort);
                    }
                }
                catch (Exception e) {
                    System.err.println("CommSerialPortConnection.getSerialPortNames Error " + e.getMessage());
                }
            }
        };
        Thread o_Thread = new Thread(o_Runnable, "Thread_Comm_GetSerialPortNames");
        o_Thread.start();
        try {
            o_Thread.join(30000L);
        }
        catch (Exception e) {
            System.err.println("CommSerialPortConnection.getSerialPortNames Error " + e.getMessage());
        }
        if (o_ArrayListSerialPortNames.size() <= 0) {
            // empty if block
        }
        return o_ArrayListSerialPortNames;
    }

    public static ArrayList<String> getSerialPortNames() {
        ArrayList<String> o_SerialPortNames = new ArrayList<String>();
        ArrayList<SerialPort> o_SerialPorts = CommSerialPortConnection.getSerialPorts();
        for (int intPort = 0; intPort < o_SerialPorts.size(); ++intPort) {
            SerialPort o_SerialPort = o_SerialPorts.get(intPort);
            if (o_SerialPort == null) continue;
            o_SerialPortNames.add(o_SerialPort.getSystemPortName());
        }
        return o_SerialPortNames;
    }

    public boolean connect(final String p_PortName, final int p_Baud, final int p_DataBits, final int p_StopBits, final int p_Parity) {
        this.m_ConnectionTrySuccess = false;
        Runnable o_Runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CommSerialPortConnection.this.m_SyncConnection;
                synchronized (object) {
                    try {
                        CommSerialPortConnection.this.m_ConnectionTrySuccess = CommSerialPortConnection.this.doConnect(p_PortName, p_Baud, p_DataBits, p_StopBits, p_Parity);
                    }
                    catch (Exception e) {
                        System.err.println("Comm Serial Port Connection connect: " + e.getMessage());
                    }
                }
                boolean intTest = false;
            }
        };
        Thread o_Thread = new Thread(o_Runnable, "Thread_Comm_Connect");
        o_Thread.start();
        try {
            o_Thread.join(60000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_ConnectionTrySuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doConnect(String p_PortName, int p_Baud, int p_DataBits, int p_StopBits, int p_Parity) {
        SerialPort o_SerialPort;
        Throwable throwableExceptioCause = null;
        boolean boolConnected = false;
        Object object = this.m_SyncConnection;
        synchronized (object) {
            o_SerialPort = this.m_RXTXPort;
            if (o_SerialPort != null) {
                if (o_SerialPort.isOpen()) {
                    return true;
                }
                o_SerialPort.closePort();
                this.m_RXTXPort = null;
            }
            if (s_DebugOn) {
                System.out.println(this.getClass().getSimpleName() + " doConnect()");
            }
            this.m_IOExceptionOccured = false;
            try {
                o_SerialPort = SerialPort.getCommPort(p_PortName);
                if (o_SerialPort.isOpen()) {
                    o_SerialPort = null;
                }
            }
            catch (Exception e_NoSuchPortException) {
                throwableExceptioCause = e_NoSuchPortException.getCause();
                o_SerialPort = null;
                this.m_RXTXPort = null;
                this.fireSerialPortException(new CommSerialPortException(1, "Port is unknown", throwableExceptioCause));
                return false;
            }
            if (o_SerialPort == null) {
                this.m_RXTXPort = null;
                this.fireSerialPortException(new CommSerialPortException(2, "Port is use", throwableExceptioCause));
                return false;
            }
            this.m_PortName = o_SerialPort.getSystemPortName();
            try {
                if (!o_SerialPort.setComPortParameters(p_Baud, p_DataBits, p_StopBits, p_Parity)) {
                    o_SerialPort = null;
                    this.m_RXTXPort = null;
                    this.fireSerialPortException(new CommSerialPortException(4, "Parameters wrong", null));
                    return false;
                }
                if (!o_SerialPort.openPort()) {
                    this.m_RXTXPort = null;
                    o_SerialPort.removeDataListener();
                    this.fireSerialPortException(new CommSerialPortException(32, "Port could not open", null));
                    return false;
                }
            }
            catch (Exception e_PortInUseException) {
                this.m_RXTXPort = null;
                this.fireSerialPortException(new CommSerialPortException(128, "Port could not open", e_PortInUseException.getCause()));
                return false;
            }
        }
        this.m_Baud = o_SerialPort.getBaudRate();
        this.m_DataBits = o_SerialPort.getNumDataBits();
        this.m_StopBits = o_SerialPort.getNumStopBits();
        this.m_Parity = o_SerialPort.getParity();
        this.m_SerialReader = new SerialReader(this, o_SerialPort);
        this.m_SerialWriter = new SerialWriter(this, o_SerialPort);
        if (!this.m_IOExceptionOccured) {
            this.m_RXTXPort = o_SerialPort;
            this.fireSerialPortConnection(1);
            return true;
        }
        if (o_SerialPort != null) {
            o_SerialPort.closePort();
        }
        this.m_RXTXPort = null;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.m_SyncConnection;
        synchronized (object) {
            if (this.m_RXTXPort == null) {
                return false;
            }
            return this.m_RXTXPort.isOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCommPort() {
        Object object = this.m_SyncConnection;
        synchronized (object) {
            SerialPort o_RXTXPort = this.m_RXTXPort;
            SerialWriter o_SerialWriter = this.m_SerialWriter;
            SerialReader o_SerialReader = this.m_SerialReader;
            if (o_SerialWriter != null) {
                o_SerialWriter.close();
            }
            this.m_SerialWriter = null;
            if (o_SerialReader != null) {
                try {
                    o_SerialReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_SerialReader = null;
            if (o_RXTXPort != null) {
                o_RXTXPort.removeDataListener();
                try {
                    o_RXTXPort.closePort();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_RXTXPort = null;
        }
        boolean intTest = false;
    }

    public boolean reconnect() throws CommSerialPortException {
        return this.connect(this.m_PortName, this.m_Baud, this.m_DataBits, this.m_StopBits, this.m_Parity);
    }

    public void sendBreak() {
        if (this.m_RXTXPort == null) {
            return;
        }
        try {
            this.m_RXTXPort.setBreak();
            this.m_RXTXPort.clearBreak();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void disconnect() {
        if (this.m_RXTXPort == null) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CommSerialPortConnection.this.m_SyncConnection;
                synchronized (object) {
                    if (CommSerialPortConnection.this.m_RXTXPort == null) {
                        return;
                    }
                    if (s_DebugOn) {
                        System.out.println(this.getClass().getSimpleName() + " diconnect()");
                    }
                    CommSerialPortConnection.this.closeCommPort();
                    CommSerialPortConnection.this.m_RXTXPort = null;
                }
                CommSerialPortConnection.this.fireSerialPortConnection(0);
            }
        };
        Thread o_Thread = new Thread(o_Runnable, "Thread_Comm_Disconnect");
        o_Thread.start();
        try {
            o_Thread.join(9000L);
        }
        catch (Exception e) {
            boolean bl = false;
        }
        boolean intTest = false;
    }

    public SerialPort getCommPort() {
        return this.m_RXTXPort;
    }

    public SerialPort getSerialPort() {
        return this.m_RXTXPort;
    }

    public int getFlowControlMode() {
        SerialPort o_CommPort = this.m_RXTXPort;
        if (o_CommPort == null) {
            return -1;
        }
        return o_CommPort.getFlowControlSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlowControlMode(int p_Mode) {
        Exception o_Exception = null;
        Object object = this.m_SyncConnection;
        synchronized (object) {
            SerialPort o_CommPort = this.m_RXTXPort;
            if (o_CommPort == null) {
                return;
            }
            try {
                o_CommPort.setFlowControl(p_Mode);
            }
            catch (Exception e_UnsupportedCommOperationException) {
                o_Exception = e_UnsupportedCommOperationException;
            }
        }
        if (o_Exception != null) {
            this.fireSerialPortException(new CommSerialPortException(4, "The FlowControlMode " + p_Mode + "cannot be set", o_Exception.getCause()));
        }
    }

    public String getPortName() {
        return this.m_PortName;
    }

    public int getBaudRate() {
        return this.m_Baud;
    }

    public int getDataBits() {
        return this.m_DataBits;
    }

    public int getStopBits() {
        return this.m_StopBits;
    }

    public int getParity() {
        return this.m_Parity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommSerialPortEventListener(CommSerialPortEventListener p_CommSerialPortEventListener) {
        Object object = this.m_SyncListener;
        synchronized (object) {
            if (p_CommSerialPortEventListener == null) {
                return;
            }
            if (this.m_InputListeners.contains(p_CommSerialPortEventListener)) {
                return;
            }
            this.m_InputListeners.add(p_CommSerialPortEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCommSerialPortEventListener(CommSerialPortEventListener p_CommSerialPortEventListener) {
        Object object = this.m_SyncListener;
        synchronized (object) {
            if (p_CommSerialPortEventListener == null) {
                return false;
            }
            if (this.m_InputListeners == null) {
                return false;
            }
            return this.m_InputListeners.remove(p_CommSerialPortEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSerialPortReadData() {
        ArrayList<CommSerialPortEventListener> o_CommSerialPortEventListeners;
        byte[] o_BytesReaden;
        int intBytesCount;
        SerialReader o_SerialReader;
        Object object = this.m_SyncListener;
        synchronized (object) {
            o_SerialReader = this.m_SerialReader;
            if (o_SerialReader == null) {
                return;
            }
            if (s_DebugOn) {
                System.out.println(this.getClass().getSimpleName() + " Data Received: Length = " + o_SerialReader.getBytesNewCount());
            }
            intBytesCount = o_SerialReader.getBytesNewCount();
            o_BytesReaden = o_SerialReader.getBytesNew();
            o_CommSerialPortEventListeners = new ArrayList<CommSerialPortEventListener>(this.m_InputListeners.size());
            o_CommSerialPortEventListeners.addAll(this.m_InputListeners);
        }
        object = this.m_SyncParseReadenBytes;
        synchronized (object) {
            for (int intListener = 0; intListener < o_CommSerialPortEventListeners.size(); ++intListener) {
                CommSerialPortEventListener o_CommSerialEventListener = (CommSerialPortEventListener)o_CommSerialPortEventListeners.get(intListener);
                try {
                    if (o_CommSerialEventListener == null) continue;
                    o_CommSerialEventListener.eventCommSerialPortDataReceived(o_BytesReaden, intBytesCount);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            o_CommSerialPortEventListeners.clear();
            o_SerialReader.resetBytesNewCount(intBytesCount);
            this.m_SyncParseReadenBytes.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSerialPortException(CommSerialPortException p_CommSerialPortException) {
        ArrayList<CommSerialPortEventListener> o_CommSerialPortEventListeners;
        if (p_CommSerialPortException == null) {
            return;
        }
        Object object = this.m_SyncListener;
        synchronized (object) {
            if (s_DebugOn) {
                System.out.println(this.getClass().getSimpleName() + " Exception: Type " + p_CommSerialPortException.getExceptionType() + "Message " + p_CommSerialPortException.getMessage());
            }
            o_CommSerialPortEventListeners = new ArrayList<CommSerialPortEventListener>(this.m_InputListeners.size());
            o_CommSerialPortEventListeners.addAll(this.m_InputListeners);
        }
        if (p_CommSerialPortException.getExceptionType() == 32) {
            this.m_IOExceptionOccured = true;
            this.disconnect();
        }
        for (int intListener = 0; intListener < o_CommSerialPortEventListeners.size(); ++intListener) {
            CommSerialPortEventListener o_CommSerialPortEventListener = (CommSerialPortEventListener)o_CommSerialPortEventListeners.get(intListener);
            if (o_CommSerialPortEventListener == null) continue;
            o_CommSerialPortEventListener.eventCommSerialPortException(p_CommSerialPortException);
        }
        o_CommSerialPortEventListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSerialPortEvent(CommSerialPortEvent p_CommSerialPortEvent) {
        ArrayList<CommSerialPortEventListener> o_CommSerialPortEventListeners;
        Object object = this.m_SyncListener;
        synchronized (object) {
            if (s_DebugOn) {
                if (p_CommSerialPortEvent != null) {
                    System.out.println(this.getClass().getSimpleName() + " SerialPortEvent: Type " + p_CommSerialPortEvent.getEventType());
                } else {
                    System.out.println(this.getClass().getSimpleName() + " SerialPortEvent: unknown");
                }
            }
            o_CommSerialPortEventListeners = new ArrayList<CommSerialPortEventListener>(this.m_InputListeners.size());
            o_CommSerialPortEventListeners.addAll(this.m_InputListeners);
        }
        for (int intListener = 0; intListener < o_CommSerialPortEventListeners.size(); ++intListener) {
            CommSerialPortEventListener o_CommSerialPortEventListener = (CommSerialPortEventListener)o_CommSerialPortEventListeners.get(intListener);
            if (o_CommSerialPortEventListener == null) continue;
            o_CommSerialPortEventListener.eventCommSerialPortComm(p_CommSerialPortEvent);
        }
        o_CommSerialPortEventListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSerialPortConnection(int p_ConnectionStatus) {
        ArrayList<CommSerialPortEventListener> o_CommSerialPortEventListeners;
        Object object = this.m_SyncListener;
        synchronized (object) {
            if (s_DebugOn) {
                System.out.println(this.getClass().getSimpleName() + " ConnectionStatus: " + p_ConnectionStatus);
            }
            o_CommSerialPortEventListeners = new ArrayList<CommSerialPortEventListener>(this.m_InputListeners.size());
            o_CommSerialPortEventListeners.addAll(this.m_InputListeners);
        }
        for (int intListener = 0; intListener < o_CommSerialPortEventListeners.size(); ++intListener) {
            CommSerialPortEventListener o_CommSerialPortEventListener = (CommSerialPortEventListener)o_CommSerialPortEventListeners.get(intListener);
            if (o_CommSerialPortEventListener == null) continue;
            o_CommSerialPortEventListener.eventCommSerialPortConnection(p_ConnectionStatus);
        }
        o_CommSerialPortEventListeners.clear();
    }

    public void eventRXTXPortDisconnected(SerialPort p_RXTXPort) {
        if (p_RXTXPort == this.m_RXTXPort) {
            this.fireSerialPortException(new CommSerialPortException(256, "Hardware was disconnected!"));
            this.disconnect();
        }
    }

    public void eventErrorOccured(SerialWriter p_SerialWriter, SerialReader p_SerialReader) {
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArray_Write getByteArrayWrite(int p_DataLength) {
        ByteArray_Write o_ByteArray_Write = null;
        Object object = s_SyncPoolByteArrayWrite;
        synchronized (object) {
            if (s_PoolByteArrayWrite.size() <= 0) {
                o_ByteArray_Write = new ByteArray_Write(p_DataLength);
                return o_ByteArray_Write;
            }
            for (int intArray = 0; intArray < s_PoolByteArrayWrite.size(); ++intArray) {
                o_ByteArray_Write = s_PoolByteArrayWrite.get(intArray);
                if (o_ByteArray_Write.getByteArrayLength() >= p_DataLength) {
                    s_PoolByteArrayWrite.remove(intArray);
                    o_ByteArray_Write.setDataLength(p_DataLength);
                    return o_ByteArray_Write;
                }
                o_ByteArray_Write = null;
            }
            if (o_ByteArray_Write == null) {
                if (s_PoolByteArrayWrite.size() < s_PoolSizeMax_ByteArrayWrite) {
                    o_ByteArray_Write = new ByteArray_Write(p_DataLength);
                    return o_ByteArray_Write;
                }
                o_ByteArray_Write = s_PoolByteArrayWrite.get(s_PoolByteArrayWrite.size() - 1);
                s_PoolByteArrayWrite.remove(s_PoolByteArrayWrite.size() - 1);
                o_ByteArray_Write.setDataLength(p_DataLength);
            }
            return o_ByteArray_Write;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEmptyByteArrayWrite(ByteArray_Write p_ByteArray_Write) {
        if (p_ByteArray_Write == null) {
            return;
        }
        Object object = s_SyncPoolByteArrayWrite;
        synchronized (object) {
            if (s_PoolByteArrayWrite.size() >= s_PoolSizeMax_ByteArrayWrite) {
                return;
            }
            s_PoolByteArrayWrite.add(p_ByteArray_Write);
        }
    }

    public void write(byte[] p_ByteArray) {
        if (p_ByteArray == null) {
            return;
        }
        if (p_ByteArray.length <= 0) {
            return;
        }
        SerialWriter o_SerialWriter = this.m_SerialWriter;
        if (o_SerialWriter != null) {
            ByteArray_Write o_ByteArray_Write = CommSerialPortConnection.getByteArrayWrite(p_ByteArray.length);
            System.arraycopy(p_ByteArray, 0, o_ByteArray_Write.getByteArray(), 0, p_ByteArray.length);
            this.write(o_ByteArray_Write);
        }
    }

    public void write(ByteArray_Write p_ByteArrayWrite) {
        if (p_ByteArrayWrite == null) {
            return;
        }
        SerialWriter o_SerialWriter = this.m_SerialWriter;
        if (o_SerialWriter != null) {
            o_SerialWriter.write(p_ByteArrayWrite);
        }
    }

    public class SerialWriter
    implements Runnable {
        private CommSerialPortConnection m_CommSerialPortConnection;
        private SerialPort m_SerialPort;
        private OutputStream m_OutputStream;
        private ArrayList<ByteArray_Write> m_DataArrays;
        private Thread m_WriterThread;
        private boolean m_WriterEndFlag;
        private boolean m_WriterErrorFlag;

        public SerialWriter(CommSerialPortConnection p_CommSerialPortConnection, SerialPort p_SerialPort) {
            this.m_CommSerialPortConnection = p_CommSerialPortConnection;
            this.m_SerialPort = p_SerialPort;
            try {
                this.m_OutputStream = this.m_SerialPort.getOutputStream();
            }
            catch (Exception e) {
                this.m_CommSerialPortConnection.disconnect();
            }
            this.readResolve();
        }

        private Object readResolve() {
            this.m_WriterThread = new Thread((Runnable)this, "Thread_Comm_SerialWriter");
            try {
                this.m_WriterThread.setPriority(7);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_DataArrays = new ArrayList();
            this.m_WriterEndFlag = false;
            this.m_WriterErrorFlag = false;
            this.m_WriterThread.start();
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.m_WriterEndFlag = true;
            Object object = CommSerialPortConnection.this.m_SyncWriterThread;
            synchronized (object) {
                CommSerialPortConnection.this.m_SyncWriterThread.notifyAll();
            }
            try {
                if (Thread.currentThread() != this.m_WriterThread) {
                    this.m_WriterThread.join(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.m_DataArrays != null) {
                object = CommSerialPortConnection.this.m_SyncWriterThread;
                synchronized (object) {
                    this.m_DataArrays.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ByteArray_Write p_ByteArrayWrite) {
            if (p_ByteArrayWrite == null || p_ByteArrayWrite.getDataLength() <= 0) {
                return;
            }
            Object object = CommSerialPortConnection.this.m_SyncWriterThread;
            synchronized (object) {
                this.m_DataArrays.add(p_ByteArrayWrite);
                CommSerialPortConnection.this.m_SyncWriterThread.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            while (!this.m_WriterEndFlag && !this.m_WriterErrorFlag || this.m_OutputStream == null) {
                CommSerialPortException o_CommException;
                ByteArray_Write o_ByteArray_Write = null;
                object = CommSerialPortConnection.this.m_SyncWriterThread;
                synchronized (object) {
                    if (this.m_OutputStream == null) {
                        o_CommException = new CommSerialPortException(32, "Error SerialWriter: OutputStream == null");
                        CommSerialPortConnection.this.fireSerialPortException(o_CommException);
                        this.m_WriterErrorFlag = true;
                        break;
                    }
                    if (this.m_DataArrays.size() <= 0) {
                        try {
                            CommSerialPortConnection.this.m_SyncWriterThread.wait();
                        }
                        catch (InterruptedException e_InterruptedException) {
                            CommSerialPortException o_CommException2 = new CommSerialPortException(32, e_InterruptedException.getMessage(), e_InterruptedException.getCause());
                            CommSerialPortConnection.this.fireSerialPortException(o_CommException2);
                            this.m_WriterErrorFlag = true;
                        }
                        continue;
                    }
                    o_ByteArray_Write = this.m_DataArrays.get(0);
                    this.m_DataArrays.remove(0);
                }
                if (o_ByteArray_Write != null && o_ByteArray_Write.getDataLength() > 0) {
                    try {
                        this.m_OutputStream.write(o_ByteArray_Write.getByteArray(), 0, o_ByteArray_Write.getDataLength());
                    }
                    catch (IOException e_IOException) {
                        o_CommException = new CommSerialPortException(32, e_IOException.getMessage(), e_IOException.getCause());
                        CommSerialPortConnection.this.fireSerialPortException(o_CommException);
                        this.m_WriterErrorFlag = true;
                        continue;
                    }
                }
                CommSerialPortConnection.addEmptyByteArrayWrite(o_ByteArray_Write);
            }
            object = CommSerialPortConnection.this.m_SyncWriterThread;
            synchronized (object) {
                if (this.m_OutputStream != null) {
                    try {
                        this.m_OutputStream.close();
                        this.m_OutputStream = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.m_WriterErrorFlag) {
                    this.m_CommSerialPortConnection.eventErrorOccured(this, null);
                }
            }
        }
    }

    public static class ByteArray_Write {
        private byte[] m_ByteArray;
        private int m_DataLength;

        public ByteArray_Write(int p_DataLength) {
            this.m_DataLength = p_DataLength;
            this.initMembers();
        }

        private void initMembers() {
            this.m_ByteArray = new byte[this.m_DataLength];
        }

        public int getByteArrayLength() {
            return this.m_ByteArray.length;
        }

        public int getDataLength() {
            return this.m_DataLength;
        }

        public void setDataLength(int p_DataLength) {
            if (p_DataLength > this.m_ByteArray.length) {
                this.m_ByteArray = new byte[p_DataLength];
            }
            this.m_DataLength = p_DataLength;
        }

        public byte[] getByteArray() {
            return this.m_ByteArray;
        }
    }

    public class SerialReader
    implements Runnable {
        private CommSerialPortConnection m_CommSerialPortConnection;
        private SerialPort m_SerialPort;
        private InputStream m_InputStream;
        private byte[] m_ByteArray;
        private byte[] m_BytesReaden;
        private int m_BytesNewCount;
        private ArrayList<Runnable> m_ReaderJobs;
        private Thread m_ReaderThread;
        private boolean m_ReaderEndFlag;
        private boolean m_ReaderErrorFlag;
        private final Object m_SyncReaderThread = new Object();
        private Runnable m_Runnable_FireSerialPortReadData;
        private SerialPortDataListener m_SerialPortEventListener;

        public SerialReader(CommSerialPortConnection p_CommSerialPortConnection, SerialPort p_SerialPort) {
            this.m_CommSerialPortConnection = p_CommSerialPortConnection;
            this.m_SerialPort = p_SerialPort;
            this.initMembers();
            try {
                this.m_InputStream = this.m_SerialPort.getInputStream();
                try {
                    this.m_SerialPort.addDataListener(this.getSerialPortEventListener());
                }
                catch (Exception e_TooManyListenersException) {
                    this.m_CommSerialPortConnection.disconnect();
                    CommSerialPortConnection.this.fireSerialPortException(new CommSerialPortException(64, "Error: too many serialport listeners " + this.getClass().getName() + " - " + this.m_SerialPort.getSystemPortName() + ""));
                }
            }
            catch (Exception e) {
                this.m_CommSerialPortConnection.disconnect();
            }
            this.m_ReaderThread.start();
        }

        private void initMembers() {
            this.m_ByteArray = new byte[1024];
            this.m_BytesReaden = new byte[1024];
            this.m_SerialPortEventListener = new SerialPortDataListener(){

                @Override
                public int getListeningEvents() {
                    return 0x10000001;
                }

                @Override
                public void serialEvent(SerialPortEvent spe) {
                    SerialReader.this.parseSerialEvent(spe);
                }
            };
            this.m_Runnable_FireSerialPortReadData = new Runnable(){

                @Override
                public void run() {
                    CommSerialPortConnection.this.fireSerialPortReadData();
                }
            };
            this.m_ReaderJobs = new ArrayList();
            this.m_ReaderThread = new Thread((Runnable)this, "Thread_Comm_SerialReader");
            this.m_ReaderEndFlag = false;
            this.m_ReaderErrorFlag = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.m_ReaderEndFlag = true;
            Object object = this.m_SyncReaderThread;
            synchronized (object) {
                this.m_SyncReaderThread.notifyAll();
            }
            try {
                if (Thread.currentThread() != this.m_ReaderThread) {
                    this.m_ReaderThread.join(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public int getReaderBufferLength() {
            if (this.m_BytesReaden == null) {
                return 0;
            }
            return this.m_BytesReaden.length;
        }

        public SerialPortDataListener getSerialPortEventListener() {
            return this.m_SerialPortEventListener;
        }

        public int getBytesNewCount() {
            return this.m_BytesNewCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetBytesNewCount(int p_BytesCount) {
            Object object = this.m_SyncReaderThread;
            synchronized (object) {
                this.m_BytesNewCount -= p_BytesCount;
            }
        }

        public byte[] getBytesNew() {
            return this.m_BytesReaden;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parseSerialEvent(final SerialPortEvent p_SerialPortEvent) {
            if ((p_SerialPortEvent.getEventType() | 1) > 0) {
                // empty if block
            }
            switch (p_SerialPortEvent.getEventType()) {
                case 1: {
                    InputStream o_InputStream = this.m_InputStream;
                    if (o_InputStream == null) {
                        return;
                    }
                    if (CommSerialPortConnection.this.m_IOExceptionOccured) {
                        return;
                    }
                    if (this.m_ByteArray == null) {
                        return;
                    }
                    Object object = CommSerialPortConnection.this.m_SyncParseReadenBytes;
                    synchronized (object) {
                        byte[] o_ByteArray = this.m_ByteArray;
                        try {
                            int intDataLength = 0;
                            int intReadByte = 0;
                            int intDataAvailable = o_InputStream.available();
                            if (intDataAvailable == 0) {
                                return;
                            }
                            intReadByte = o_InputStream.read(o_ByteArray, intDataLength, o_ByteArray.length - intDataLength);
                            while (intReadByte > 0 && intDataLength < o_ByteArray.length && this.m_BytesNewCount <= this.m_BytesReaden.length - intReadByte) {
                                for (int intByte = 0; intByte < intReadByte; ++intByte) {
                                    this.m_BytesReaden[this.m_BytesNewCount] = o_ByteArray[intDataLength + intByte];
                                    ++this.m_BytesNewCount;
                                }
                                if ((intDataLength += intReadByte) == o_ByteArray.length || intDataLength >= intDataAvailable) {
                                    this.addReaderJob(this.m_Runnable_FireSerialPortReadData);
                                    try {
                                        CommSerialPortConnection.this.m_SyncParseReadenBytes.wait(1000L);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    intDataLength = 0;
                                    intReadByte = 0;
                                }
                                if ((intDataAvailable = o_InputStream.available()) <= 0) break;
                                intReadByte = o_InputStream.read(o_ByteArray, intDataLength, o_ByteArray.length - intDataLength);
                            }
                            if (intDataLength > 0) {
                                this.addReaderJob(this.m_Runnable_FireSerialPortReadData);
                                try {
                                    CommSerialPortConnection.this.m_SyncParseReadenBytes.wait(1000L);
                                }
                                catch (Exception exception) {}
                            }
                        }
                        catch (IOException e_IOException) {
                            this.m_ReaderErrorFlag = true;
                            Runnable o_Runnable = new Runnable(){

                                @Override
                                public void run() {
                                    CommSerialPortConnection.this.fireSerialPortException(new CommSerialPortException(32, e_IOException.getMessage(), e_IOException.getCause()));
                                }
                            };
                            this.addReaderJob(o_Runnable);
                        }
                        break;
                    }
                }
                case 0x10000000: {
                    if (this.m_CommSerialPortConnection == null) break;
                    this.m_CommSerialPortConnection.eventRXTXPortDisconnected(CommSerialPortConnection.this.m_RXTXPort);
                    break;
                }
                default: {
                    Runnable o_Runnable = new Runnable(){

                        @Override
                        public void run() {
                            SerialPort o_SerialPort = SerialReader.this.m_SerialPort;
                            if (o_SerialPort != null && p_SerialPortEvent != null) {
                                CommSerialPortConnection.this.fireSerialPortEvent(new CommSerialPortEvent(o_SerialPort, p_SerialPortEvent));
                            }
                        }
                    };
                    this.addReaderJob(o_Runnable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addReaderJob(Runnable p_Runnable) {
            if (p_Runnable == null) {
                return;
            }
            Object object = this.m_SyncReaderThread;
            synchronized (object) {
                if (this.m_ReaderJobs.contains(p_Runnable)) {
                    return;
                }
                this.m_ReaderJobs.add(p_Runnable);
                this.m_SyncReaderThread.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object o_CommException2;
            Object object;
            Runnable o_ReaderJob = null;
            while (!this.m_ReaderEndFlag && !this.m_ReaderErrorFlag || this.m_InputStream == null) {
                object = this.m_SyncReaderThread;
                synchronized (object) {
                    if (this.m_InputStream == null) {
                        o_CommException2 = new CommSerialPortException(32, "Error SerialReader: InputStream == null");
                        CommSerialPortConnection.this.fireSerialPortException((CommSerialPortException)o_CommException2);
                        this.m_ReaderErrorFlag = true;
                        break;
                    }
                    if (this.m_ReaderJobs.size() <= 0) {
                        try {
                            this.m_SyncReaderThread.wait();
                            continue;
                        }
                        catch (InterruptedException o_CommException2) {
                        }
                    } else {
                        o_ReaderJob = this.m_ReaderJobs.get(0);
                        this.m_ReaderJobs.remove(0);
                    }
                }
                if (o_ReaderJob == null) continue;
                try {
                    o_ReaderJob.run();
                }
                catch (Exception exception) {}
            }
            object = this.m_SyncReaderThread;
            synchronized (object) {
                if (this.m_InputStream != null) {
                    try {
                        this.m_InputStream.close();
                        this.m_InputStream = null;
                    }
                    catch (Exception o_CommException2) {
                        // empty catch block
                    }
                }
                while (this.m_ReaderJobs.size() > 0) {
                    o_CommException2 = this.m_SyncReaderThread;
                    synchronized (o_CommException2) {
                        o_ReaderJob = this.m_ReaderJobs.get(0);
                        this.m_ReaderJobs.remove(0);
                    }
                    if (o_ReaderJob == null) continue;
                    o_ReaderJob.run();
                }
                this.m_ReaderJobs.clear();
                for (int intByte = 0; intByte < this.m_BytesReaden.length; ++intByte) {
                    this.m_BytesReaden[intByte] = 0;
                }
                if (this.m_ReaderErrorFlag) {
                    this.m_CommSerialPortConnection.eventErrorOccured(null, this);
                }
            }
        }
    }
}

