/*
 * Decompiled with CFR 0.152.
 */
package Messages;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class Message_Status_Jingle
implements Externalizable {
    public static final int SOFTWAREVERSION = 1;
    private ArrayList<JingleDescription> m_JingleDescriptions;
    private ArrayList<PlayControlStatus> m_JinglePlayStatus;

    public Message_Status_Jingle() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_JingleDescriptions = new ArrayList();
        this.m_JinglePlayStatus = new ArrayList();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        int intJingleCount = this.m_JingleDescriptions.size();
        out.writeInt(intJingleCount);
        for (int intJingle = 0; intJingle < this.m_JingleDescriptions.size(); ++intJingle) {
            JingleDescription o_JingleDescription = this.m_JingleDescriptions.get(intJingle);
            o_JingleDescription.writeExternal(out);
            PlayControlStatus o_JinglePlayStatus = this.m_JinglePlayStatus.get(intJingle);
            o_JinglePlayStatus.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        int intJingleCount = in.readInt();
        for (int intJingle = 0; intJingle < intJingleCount; ++intJingle) {
            JingleDescription o_JingleDescription = new JingleDescription();
            o_JingleDescription.readExternal(in);
            PlayControlStatus o_JinglePlayStatus = new PlayControlStatus();
            o_JinglePlayStatus.readExternal(in);
            this.addJingleDescriptionStatus(o_JingleDescription, o_JinglePlayStatus);
        }
    }

    public void addJingleDescriptionStatus(JingleDescription p_JingleDescription, PlayControlStatus p_Status) {
        if (p_JingleDescription == null) {
            return;
        }
        JingleDescription o_JingleDescriptionNew = new JingleDescription(p_JingleDescription.getVIPType(), p_JingleDescription.getJingleID(), p_JingleDescription.getJingleName(), p_JingleDescription.getJingleSourceName());
        this.m_JingleDescriptions.add(o_JingleDescriptionNew);
        this.m_JinglePlayStatus.add(p_Status);
    }

    public int getJingleDescriptionCount() {
        return this.m_JingleDescriptions.size();
    }

    public JingleDescription getJingleDescription(int p_Index) {
        if (p_Index < 0 || p_Index >= this.m_JingleDescriptions.size()) {
            return null;
        }
        return this.m_JingleDescriptions.get(p_Index);
    }

    public PlayControlStatus getJinglePlayStatus(int p_Index) {
        if (p_Index < 0 || p_Index >= this.m_JinglePlayStatus.size()) {
            return null;
        }
        return this.m_JinglePlayStatus.get(p_Index);
    }

    public static class PlayControlStatus
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        private boolean m_Start;
        private boolean m_Pause;
        private boolean m_Stop;
        private boolean m_FadeIn;
        private boolean m_FadeOut;
        private boolean m_FastForward;
        private boolean m_Rewind;

        public PlayControlStatus() {
        }

        public PlayControlStatus(boolean p_Start, boolean p_Pause, boolean p_Stop, boolean p_FadeIn, boolean p_FadeOut, boolean p_FastForward, boolean p_Rewind) {
            this.m_Start = p_Start;
            this.m_Pause = p_Pause;
            this.m_Stop = p_Stop;
            this.m_FadeIn = p_FadeIn;
            this.m_FadeOut = p_FadeOut;
            this.m_FastForward = p_FastForward;
            this.m_Rewind = p_Rewind;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeBoolean(this.m_Start);
            out.writeBoolean(this.m_Pause);
            out.writeBoolean(this.m_Stop);
            out.writeBoolean(this.m_FadeIn);
            out.writeBoolean(this.m_FadeOut);
            out.writeBoolean(this.m_FastForward);
            out.writeBoolean(this.m_Rewind);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            this.m_Start = in.readBoolean();
            this.m_Pause = in.readBoolean();
            this.m_Stop = in.readBoolean();
            this.m_FadeIn = in.readBoolean();
            this.m_FadeOut = in.readBoolean();
            this.m_FastForward = in.readBoolean();
            this.m_Rewind = in.readBoolean();
        }

        public boolean getStartEnabled() {
            return this.m_Start;
        }

        public boolean getPauseEnabled() {
            return this.m_Pause;
        }

        public boolean getStopEnabled() {
            return this.m_Stop;
        }

        public boolean getFadeInEnabled() {
            return this.m_FadeIn;
        }

        public boolean getFadeOutEnabled() {
            return this.m_FadeOut;
        }

        public boolean getFastForwardEnabled() {
            return this.m_FastForward;
        }

        public boolean getRewindEnabled() {
            return this.m_Rewind;
        }
    }

    public static class JingleDescription
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        int m_ViPType;
        String m_JingleID;
        String m_JingleName;
        String m_JingleSourceName;

        public JingleDescription() {
        }

        public JingleDescription(int p_ViPType, String p_JingleID, String p_JingleName, String p_JingleSourceName) {
            this.m_ViPType = p_ViPType;
            this.m_JingleID = p_JingleID;
            if (this.m_JingleID == null) {
                this.m_JingleID = "null";
            }
            this.m_JingleName = p_JingleName;
            if (this.m_JingleName == null) {
                this.m_JingleName = "null";
            }
            this.m_JingleSourceName = p_JingleSourceName;
            if (this.m_JingleSourceName == null) {
                this.m_JingleSourceName = "null";
            }
        }

        public int getVIPType() {
            return this.m_ViPType;
        }

        public String getJingleID() {
            return this.m_JingleID;
        }

        public String getJingleName() {
            return this.m_JingleName;
        }

        public String getJingleSourceName() {
            return this.m_JingleSourceName;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeInt(this.m_ViPType);
            out.writeUTF(this.m_JingleID);
            out.writeUTF(this.m_JingleName);
            out.writeUTF(this.m_JingleSourceName);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            this.m_ViPType = in.readInt();
            this.m_JingleID = in.readUTF();
            if ("null".equals(this.m_JingleID)) {
                this.m_JingleID = null;
            }
            this.m_JingleName = in.readUTF();
            this.m_JingleSourceName = in.readUTF();
        }
    }
}

